#ifndef __LIBXML_WIN32_CONFIG__
#define __LIBXML_WIN32_CONFIG__

#define HAVE_CTYPE_H
#define HAVE_STDARG_H
#define HAVE_MALLOC_H
#define HAVE_ERRNO_H

#ifdef _WIN32_WCE
#undef HAVE_ERRNO_H
#include <windows.h>
#include "wincecompat.h"
#else
#define HAVE_SYS_STAT_H
#define HAVE__STAT
#define HAVE_STAT
#define HAVE_STDLIB_H
#define HAVE_TIME_H
#define HAVE_FCNTL_H
#include <io.h>
#include <direct.h>
#endif

#include <libxml/xmlwin32version.h>

#ifdef NEED_SOCKETS
#include <wsockcompat.h>
#endif

#define HAVE_ISINF
#define HAVE_ISNAN
#include <math.h>
#ifdef _MSC_VER
/* MS C-runtime has functions which can be used in order to determine if
   a given floating-point variable contains NaN, (+-)INF. These are 
   preferred, because floating-point technology is considered propriatary
   by MS and we can assume that their functions know more about their 
   oddities than we do. */
#include <float.h>
/* Bjorn Reese figured a quite nice construct for isinf() using the _fpclass
   function. */
#ifndef isinf
#define isinf(d) ((_fpclass(d) == _FPCLASS_PINF) ? 1 \
	: ((_fpclass(d) == _FPCLASS_NINF) ? -1 : 0))
#endif
/* _isnan(x) returns nonzero if (x == NaN) and zero otherwise. */
#ifndef isnan
#define isnan(d) (_isnan(d))
#endif
#else /* _MSC_VER */
static int isinf (double d) {
    int expon = 0;
    double val = frexp (d, &expon);
    if (expon == 1025) {
        if (val == 0.5) {
            return 1;
        } else if (val == -0.5) {
            return -1;
        } else {
            return 0;
        }
    } else {
        return 0;
    }
}
static int isnan (double d) {
    int expon = 0;
    double val = frexp (d, &expon);
    if (expon == 1025) {
        if (val == 0.5) {
            return 0;
        } else if (val == -0.5) {
            return 0;
        } else {
            return 1;
        }
    } else {
        return 0;
    }
}
#endif /* _MSC_VER */

#ifdef _MSC_VER
/* We don't use trio when compiling under MSVC. This is not because trio
   is bad, but because MSVC has no easy way to conditionally include a .c
   file in the project. In order to enable trio usage, we would have to compile
   all trio functionality into the executable, even if we don't use it.
   Since MS C-runtime has all required functions, trio is not necessary. */
#ifdef WITH_TRIO
#undef WITH_TRIO
#endif /* WITH_TRIO */
#ifndef WITHOUT_TRIO
#define WITHOUT_TRIO
#endif /* WITHOUT_TRIO */
/* Microsoft's C runtime names all non-ANSI functions with a leading
   underscore. Since functionality is still the same, they can be used. */
#define snprintf _snprintf
#define vsnprintf _vsnprintf
#endif /* _MSC_VER */

/* Define this if you want to use Windows native thread implementation.
   Undefine it if you wish to use another, pthreads for example. Note
   that this alone does not enable threads, just specifies the
   threading model. Threading support is activated in xmlversion.h by
   defining LIBXML_THREAD_ENABLE. */
#define HAVE_WIN32_THREADS

#endif /* __LIBXML_WIN32_CONFIG__ */

