#
# Note that this is NOT a relocatable package
#

%define ver      1.0.2
%define rel      1
%define prefix   /opt/gnome
%define name	 eog

Summary: Eye Of Gnome
Name: %name
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications/Multimedia
Source: ftp://ftp.gnome.org/pub/GNOME/unstable/sources/eog/eog-%{ver}.tar.gz
BuildRoot: /var/tmp/eog
Obsoletes: eog
Packager: Federico Mena-Quintero <federico@gnu.org>
URL: http://www.gnome.org
Prereq: /sbin/install-info
Prefix: %{prefix}
Docdir: %{prefix}/doc
Requires: ORBit >= 0.5.0
Requires: oaf >= 0.3.0
Requires: gnome-print >= 0.20
Requires: gdk-pixbuf >= 0.9.0
Requires: bonobo >= 0.15
Requires: gconf >= 0.8

%description
This is the Eye of Gnome, an image viewer program.  It is meant to be
a fast and functional image viewer as well as an image cataloging
program.

%changelog

* Mon Sep 04 2000  Federico Mena Quintero  <federico@helixcode.com>

- Updated the spec file; it is still not guaranteed to work out of the
  box.


* Sun Jun 11 2000  Eskil Heyn Olsen <deity@eazel.com>

- Created the .spec file

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="-pipe $RPM_OPT_FLAGS" ./autogen.sh       \
        --prefix=%{prefix} --sysconfdir=%{sysconfdir} \
        --localstatedir=%{localstatedir}
else
  CFLAGS="-pipe $RPM_OPT_FLAGS" ./configure       \
        --prefix=%{prefix} --sysconfdir=%{sysconfdir} \
        --localstatedir=%{localstatedir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=$RPM_BUILD_ROOT%{prefix} \
        sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} \
        localstatedir=$RPM_BUILD_ROOT%{localstatedir}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog HACKING NEWS README THANKS TODO
%{prefix}/bin/*
%{prefix}/share/gnome/apps/*
%{prefix}/share/pixmaps/*
%{prefix}/share/locale/*
%{prefix}/share/oaf/*
%{prefix}/share/gnome/help/*
%config /etc/CORBA/*
