#define __TESTPRINT_C__

/*
 * libgnomeprintui test program
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Unknown author
 *   Lauris Kaplinski <lauris@helixcode.com>
 *
 * Copyright 2000-2001 Ximian, Inc. and authors
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <popt.h>
#include <math.h>
#include <popt.h>
#include <gtk/gtk.h>
#include <libgnomeprint/gnome-print-meta.h>
#include <libgnomeprintui/gnome-print-i18n.h>
#include <libgnomeprintui/gnome-print-preview.h>
#include <libgnomeprintui/gnome-print-master-preview.h>
#include <libgnomeprintui/gnome-font-dialog.h>
#include <libgnomeprintui/gnome-printer-dialog.h>
#include <libgnomeprintui/gnome-print-dialog.h>
#include <libgnomeprintui/gnome-print-paper-selector.h>

#define dpi 72

#define CM(v) ((v) * 72.0 / 2.54)
#define A4_WIDTH (210.0 * 72 / 25.4)
#define A4_HEIGHT (297.0 * 72 / 25.4)
#define LINESPACING 6.0
#define INDENT 20.0
#define KERNING 0.0
#define LETTERSPACE 0.0

static gboolean font_dialog = FALSE;
static gboolean printer_dialog = FALSE;
static gboolean print_dialog = FALSE;
static gboolean master_preview = FALSE;
static gboolean paper_dialog = FALSE;
static gchar *textfile = NULL;
static gchar *metafile = NULL;

static struct poptOption options[] = {
	{ "metafile", 'm', POPT_ARG_STRING, &metafile, 0, N_("Render from metafile"), N_("PATH")},
	{ "font-dialog", 'f', POPT_ARG_NONE, &font_dialog, 0, N_("Bring up font dialog"), NULL},
	{ "printer-dialog", 'p', POPT_ARG_NONE, &printer_dialog, 0, N_("Bring up printer dialog"), NULL},
	{ "print-dialog", 'd', POPT_ARG_NONE, &print_dialog, 0, N_("Bring up print dialog"), NULL},
	{ "master-preview", 0, POPT_ARG_NONE, &master_preview, 0, N_("Use GnomePrintMasterPreview"), NULL},
	{ "paper-dialog", 0, POPT_ARG_NONE, &paper_dialog, 0, N_("Show paper dialog"), NULL},
	{ "text", 't', POPT_ARG_STRING, &textfile, 0, N_("Print text file"), N_("PATH")},
	POPT_AUTOHELP
	{ NULL, '\0', 0, NULL, 0 }
};

static void do_print_text (GnomePrintConfig *config, GnomePrintContext *ctx, GnomeFont *font, const guchar *buf, gint buflen);

static void
star (GnomePrintContext *pc, double x, double y)
{
	gnome_print_moveto (pc, x - 3, y - 5);
	gnome_print_lineto (pc, x + 3, y + 5);
	gnome_print_stroke (pc);

	gnome_print_moveto (pc, x + 3, y - 5);
	gnome_print_lineto (pc, x - 3, y + 5);
	gnome_print_stroke (pc);
}

static void
print_test_page (GnomePrintConfig *config, GnomePrintContext *pc, GnomeFont *font)
{
	GnomeFontFace *face;
	int i;

	face = gnome_font_get_face (font);

	if (textfile) {
		struct stat s;
		gint fh, len;
		guchar *b;
		if (!stat (textfile, &s) && S_ISREG (s.st_mode)) {
			len = s.st_size;
			fh = open (textfile, O_RDONLY);
			if (fh >= 0) {
				b = g_new (guchar, len + 1);
				*(b + len) = '\0';
				read (fh, b, len);
				close (fh);
				do_print_text (config, pc, font, b, len);
				g_free (b);
				return;
			}
		}
	}

	gnome_print_beginpage (pc, "testprint2 demo page");

	font = gnome_font_face_get_font_default (face, 14);

	gnome_print_setfont (pc, font);

	for (i = 0; i < 900; i += 20){
		char buf [40];
		
		gnome_print_setrgbcolor (pc, 0.4, 0.4, 0.4);
		gnome_print_moveto (pc, 0, i);
		gnome_print_lineto (pc, 600, i);
		gnome_print_stroke (pc);

		gnome_print_setrgbcolor (pc, 1.0, 0.0, 0.0);
		sprintf (buf, "%d", i);
		gnome_print_moveto (pc, 10, i + 3);
		gnome_print_show (pc, buf);
	}

	gnome_print_setrgbcolor (pc, 0.4, 0.4, 0.4);
	for (i = 0; i < 900; i += 20){
		gnome_print_moveto (pc, i, 0);
		gnome_print_lineto (pc, i, 900);
		gnome_print_stroke (pc);
	}

	if (1){

		double aff [6];

		gnome_print_gsave (pc);
		art_affine_rotate (aff, 20);
		gnome_print_concat (pc, aff);
		art_affine_translate (aff, 100, 100);
		gnome_print_concat (pc, aff);
		gnome_print_grestore (pc);
	}

#if 0
	gnome_print_moveto (pc, 120, 120);
	gnome_print_lineto (pc, 200, 210);
	gnome_print_stroke (pc);

	gnome_print_setrgbcolor (pc, 0.1, 0.1, 0.1);
	gnome_print_moveto (pc, 200, 200);
	gnome_print_lineto (pc, 300, 300);
	gnome_print_stroke (pc);
#endif
	
	gnome_print_setrgbcolor (pc, 0, 0, 0);

	font = gnome_font_face_get_font_default (face, 45);

	for (i = 0; i < 300; i += 50){
		char buf [90];

		sprintf (buf, "Hello-%d", i);
		gnome_print_setfont (pc, font);
		gnome_print_moveto (pc, i, i);
		gnome_print_show (pc, buf);
		star (pc, i, i); 
	}

	gnome_print_showpage (pc);
	gnome_print_context_close (pc);
	
}

#if 0
static void
show_pixbuf (GnomePrintPixbuf * gpb, GdkPixbuf * pb, gint pagenum, gpointer data)
{
	int fh;
	gint y, w, h, rs;
	guchar * px, * p;

	g_print ("Showpixbuf called :)\n");

	w = gdk_pixbuf_get_width (pb);
	h = gdk_pixbuf_get_height (pb);
	rs = gdk_pixbuf_get_rowstride (pb);
	px = gdk_pixbuf_get_pixels (pb);

	fh = creat ("output.dump", S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
	g_return_if_fail (fh >= 0);

	for (y = 0; y < h; y++) {
		p = px + y * rs;
		write (fh, p, w * 4);
	}

	close (fh);
}
#endif

static void
test_ps (GnomePrintConfig *config, GnomeFont *font, gboolean preview)
{
	GnomePrintContext *pc;

	gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
#if 0
	gtk_widget_set_default_visual (gdk_rgb_get_visual ());
#endif
		
	if (config && !preview) {
		GnomePrintMaster *gpm;
		gpm = gnome_print_master_new_from_config (config);
		pc = gnome_print_master_get_context (gpm);
		if (metafile) {
			gnome_print_meta_render_file (pc, metafile);
		} else {
			print_test_page (config, pc, font);
		}
		g_object_unref (G_OBJECT (pc));
		gnome_print_master_close (gpm);
		gnome_print_master_print (gpm);
		g_object_unref (G_OBJECT (gpm));
	} else {
		if (master_preview) {
			GnomePrintMaster *gpm;
			GnomePrintContext *ctx;
			GtkWidget *gpmp;
			if (config) {
				g_print ("We have config\n");
				gpm = gnome_print_master_new_from_config (config);
			} else {
				g_print ("Do not have config\n");
				gpm = gnome_print_master_new ();
			}
			ctx = gnome_print_master_get_context (gpm);
			if (metafile) {
				gnome_print_meta_render_file (ctx, metafile);
			} else {
				print_test_page (config, ctx, font);
			}
			gnome_print_context_close (ctx);
			g_object_unref (G_OBJECT (ctx));
			gnome_print_master_close (gpm);

			gpmp = gnome_print_master_preview_new (gpm, NULL);
			gtk_signal_connect (GTK_OBJECT (gpmp), "destroy", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
			gtk_widget_show (gpmp);
			gtk_main ();
		} else {
			GtkWidget *toplevel, *canvas, *sw;
			toplevel = gtk_window_new (GTK_WINDOW_TOPLEVEL);
			gtk_widget_set_usize (toplevel, 700, 700);
			sw = gtk_scrolled_window_new (NULL, NULL);
			canvas = gnome_canvas_new_aa ();
			gnome_canvas_set_pixels_per_unit (GNOME_CANVAS (canvas), dpi / 72.0);
			gtk_container_add (GTK_CONTAINER (toplevel), sw);
			gtk_container_add (GTK_CONTAINER (sw), canvas);
			
			if (!config) config = gnome_print_config_default ();
			pc = gnome_print_preview_new (config, GNOME_CANVAS (canvas));
			
			gtk_widget_show_all (toplevel);

			if (metafile) {
				gnome_print_meta_render_file (pc, metafile);
			} else {
				print_test_page (config, pc, font);
			}

			gtk_main ();
		}
	}
}

int
main (int argc, char **argv)
{
	poptContext *ctx;
	gint ret;
	GtkWidget *w;
	gint response;
	GnomeFont *font = NULL;
	GnomePrintConfig *config = NULL;

	/* Parse arguments */
	ctx = poptGetContext (NULL, argc, argv, options, 0);
	if (!ctx) {
		g_error ("Could not parse arguments");
	}

	ret = poptGetNextOpt (ctx);
	if (ret != -1) {
		fprintf (stderr, "%s: %s: %s\n",
			 "testprint",
			 poptBadOption (ctx, POPT_BADOPTION_NOALIAS),
			 poptStrerror (ret));
		exit (1);
	}

	gtk_init (&argc, &argv);

	if (paper_dialog) {
		GtkWidget *w, *p;
		w = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (w), "Paper Selector test");
		p = gnome_paper_selector_new (NULL);
		gtk_widget_show (p);
		gtk_container_add (GTK_CONTAINER (w), p);
		gtk_widget_show (w);
		gtk_main ();
		exit (0);
	}

	if (font_dialog) {
		w = gnome_font_dialog_new ("Please select font");
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response == GTK_RESPONSE_OK) {
			GtkWidget *fs;
			fs = gnome_font_dialog_get_fontsel (GNOME_FONT_DIALOG (w));
			g_return_val_if_fail (GNOME_IS_FONT_SELECTION (fs), 1);
			font = gnome_font_selection_get_font (GNOME_FONT_SELECTION (fs));
			g_return_val_if_fail (GNOME_IS_FONT (font), 1);
		} else {
			g_warning ("No font specified");
		}
#if 0
		gtk_widget_destroy (w);
#endif
	}

	if (printer_dialog) {
		w = gnome_printer_dialog_new_default ();
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response == GTK_RESPONSE_OK) {
			config = gnome_printer_dialog_get_config (GNOME_PRINTER_DIALOG (w));
		} else {
			g_warning ("No config specified");
		}
#if 0
		gtk_widget_destroy (w);
#endif
	} else if (print_dialog) {
		w = gnome_print_dialog_new ("Print test dialog", GNOME_PRINT_DIALOG_RANGE | GNOME_PRINT_DIALOG_COPIES);
		gnome_print_dialog_construct_range_page (GNOME_PRINT_DIALOG (w),
							 GNOME_PRINT_RANGE_CURRENT |
							 GNOME_PRINT_RANGE_ALL |
							 GNOME_PRINT_RANGE_SELECTION |
							 GNOME_PRINT_RANGE_RANGE,
							 1, 123,
							 "Current object", "Pages");
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response != GNOME_PRINT_DIALOG_RESPONSE_CANCEL) {
			config = gnome_print_dialog_get_config (GNOME_PRINT_DIALOG (w));
		} else {
			g_warning ("No config specified");
		}
#if 0
		gtk_widget_destroy (w);
#endif
	}

	if (!font) font = gnome_font_find ("Courier", 14.0);

	test_ps (config, font, response == GNOME_PRINT_DIALOG_RESPONSE_PREVIEW);

	return 0;
}

static gint
do_print_paragraph (GnomePrintContext *pc, GnomeFont *font, const guchar *b, const guchar *e, gdouble x0, gdouble *y0, gdouble x1, gdouble y1)
{
	GSList *words;
	const guchar *p;
	gchar *ub, *u;
	gdouble fontheight;
	gint space;
	gdouble x, y;

	if (!font) return TRUE;
	g_print ("Ascender %g\n", gnome_font_get_ascender (font));
	g_print ("Descender %g\n", gnome_font_get_descender (font));
	fontheight = gnome_font_get_ascender (font) + gnome_font_get_descender (font);
	space = gnome_font_face_lookup_default (gnome_font_get_face (font), ' ');

	/* Test for line space */
	if (*y0 - y1 < fontheight) return TRUE;

	/* Split text into words & convert to utf-8 */
	ub = g_new (guchar, (e - b) * 2 + 1);
	u = ub;
	words = NULL;
	p = b;
	while (p < e) {
		while ((p < e) && (*p <= ' ')) p++;
		if (p < e) {
			words = g_slist_prepend (words, u);
			while ((p < e) && (*p > ' ')) {
#if 0
				u += g_unichar_to_utf8 (*p++, u);
#else
				*u++ = *p++;
#endif
			}
			*u++ = '\0';
		}
	}
	words = g_slist_reverse (words);

	x = x0 + INDENT;
	while ((*y0 - y1 >= fontheight) && (words != NULL)) {
		ArtPoint spadv;
		gdouble accwidth, spcwidth;
		gboolean stop;
		GSList *lw;
		gint numwords;
		GnomeGlyphList * gl;
		/* Find actual Y */
		y = *y0 - gnome_font_get_ascender (font);
		/* Find space advance */
		gnome_font_get_glyph_stdadvance (font, space, &spadv);
		accwidth = 0.0;
		spcwidth = 0.0;
		stop = FALSE;
		lw = NULL;
		while ((accwidth <= (x1 - x)) && !stop) {
			gdouble width;
			width = gnome_font_get_width_utf8 (font, (gchar *) words->data);
			width += (g_utf8_strlen ((gchar *) words->data, strlen ((gchar *) words->data)) - 1) * LETTERSPACE;
			if (accwidth > 0.0) spcwidth += spadv.x;
			if ((accwidth == 0.0) || (accwidth + spcwidth + width < (x1 - x))) {
				/* We have room */
				accwidth += width;
				lw = g_slist_prepend (lw, words->data);
				words = g_slist_remove (words, words->data);
				if (!words) stop = TRUE;
			} else {
				stop = TRUE;
			}
		}
		lw = g_slist_reverse (lw);
		/* Typeset */
		numwords = g_slist_length (lw);
		if ((numwords > 1) && (words != NULL)) {
			spcwidth = ((x1 - x) - accwidth) / (numwords - 1);
		} else {
			spcwidth = spadv.x;
		}
		gl = gnome_glyphlist_from_text_dumb (font, 0x000000ff, KERNING, LETTERSPACE, "");
		gnome_glyphlist_advance (gl, TRUE);
		while (lw) {
			guchar *str;
			str = (guchar *) lw->data;
			gnome_glyphlist_moveto (gl, x, y);
			if (!strcmp (str, "GNU")) {
				gint glyph;
				gnome_glyphlist_color (gl, 0xff0000ff);
				gnome_glyphlist_rmoveto (gl, 0.0, -fontheight / 3.0);
				glyph = gnome_font_face_lookup_default (gnome_font_get_face (font), 'G');
				gnome_glyphlist_glyph (gl, glyph);
				gnome_glyphlist_color (gl, 0x00ff00ff);
				gnome_glyphlist_rmoveto (gl, 0.0, fontheight / 3.0);
				glyph = gnome_font_face_lookup_default (gnome_font_get_face (font), 'N');
				gnome_glyphlist_glyph (gl, glyph);
				gnome_glyphlist_color (gl, 0x0000ffff);
				gnome_glyphlist_rmoveto (gl, 0.0, fontheight / 3.0);
				glyph = gnome_font_face_lookup_default (gnome_font_get_face (font), 'U');
				gnome_glyphlist_glyph (gl, glyph);
				gnome_glyphlist_color (gl, 0x000000ff);
				gnome_glyphlist_rmoveto (gl, 0.0, -fontheight / 3.0);
			} else {
				gnome_glyphlist_text_dumb (gl, str);
			}
			x += gnome_font_get_width_utf8 (font, str);
			x += (g_utf8_strlen (str, strlen (str)) - 1) * LETTERSPACE;
			x += spcwidth;
			lw = g_slist_remove (lw, str);
		}
		gnome_print_moveto (pc, 0.0, 0.0);
		gnome_print_glyphlist (pc, gl);
		gnome_glyphlist_unref (gl);
		*y0 = *y0 - gnome_font_get_size (font) - LINESPACING;
		x = x0;
	}

	if (words) g_slist_free (words);

	g_free (ub);

	return FALSE;
}

static void
do_print_text (GnomePrintConfig *config, GnomePrintContext *ctx, GnomeFont *font, const guchar *buf, gint buflen)
{
	GnomePrintMaster *gpm;
	const GnomePrintUnit *unit;
	gdouble pw, ph;
	gdouble ml, mr, mt, mb;
	gdouble x0, y0, x1, y1;
	gint pagenum;
	const guchar *bend, *b;

	if (!font) font = gnome_font_find_closest_from_weight_slant ("Times", GNOME_FONT_BOOK, 1, 12);
	if (!font) g_error ("Cannot find suitable font, exiting...");

	pw = A4_WIDTH;
	ph = A4_HEIGHT;
	gnome_print_master_get_page_size_from_config (config, &pw, &ph);

	ml = CM(1);
	mr = CM(1);
	mt = CM(1);
	mb = CM(1);
	if (gnome_print_config_get_length (config, GNOME_PRINT_KEY_PAGE_MARGIN_LEFT, &ml, &unit)) {
		gnome_print_convert_distance (&ml, unit, GNOME_PRINT_PS_UNIT);
	}
	if (gnome_print_config_get_length (config, GNOME_PRINT_KEY_PAGE_MARGIN_RIGHT, &mr, &unit)) {
		gnome_print_convert_distance (&mr, unit, GNOME_PRINT_PS_UNIT);
	}
	if (gnome_print_config_get_length (config, GNOME_PRINT_KEY_PAGE_MARGIN_TOP, &mt, &unit)) {
		gnome_print_convert_distance (&mt, unit, GNOME_PRINT_PS_UNIT);
	}
	if (gnome_print_config_get_length (config, GNOME_PRINT_KEY_PAGE_MARGIN_BOTTOM, &mb, &unit)) {
		gnome_print_convert_distance (&mb, unit, GNOME_PRINT_PS_UNIT);
	}

	x0 = ml;
	y0 = mb;
	x1 = pw - mr;
	y1 = ph - mt;

	pagenum = 1;
	bend = buf + buflen;
	b = buf;
	while (b < bend) {
		gchar *str;
		gdouble y;
		gboolean stop;
		/* Start page */
		str = g_strdup_printf ("Test Page %d", pagenum++);
		gnome_print_beginpage (ctx, str);
		g_free (str);
		/* Draw margins */
		gnome_print_setrgbcolor (ctx, 0.0, 0.0, 1.0);
		gnome_print_setlinewidth (ctx, 1.0);
		gnome_print_moveto (ctx, x0, y0);
		gnome_print_lineto (ctx, x0, y1);
		gnome_print_lineto (ctx, x1, y1);
		gnome_print_lineto (ctx, x1, y0);
		gnome_print_closepath (ctx);
		gnome_print_stroke (ctx);
		/* Draw paragraphs */
		y = y1;
		stop = FALSE;
		while (!stop) {
			/* Find start of paragraph */
			while ((b < bend) && (isspace (*b) || iscntrl (*b))) b += 1;
			if (b < bend) {
				const guchar *e;
				/* Search paragraph end */
				for (e = b; e < (bend - 1); e++) {
					if ((*e == '\n') && (*(e + 1) == '\n')) break;
				}
				if (e == (bend - 1)) e += 1;
				stop = do_print_paragraph (ctx, font, b, e, x0, &y, x1, y0);
				b = e;
			} else {
				stop = TRUE;
			}
		}
		/* Finish page */
		gnome_print_showpage (ctx);
	}
}

