#include <gnome--.h> // don't do that : here it is just for simplicity's
                     // sake, but this drags more than a meg worth of headers



class RoseCanvas : public Gnome::Canvas
{
  Gnome::CanvasGroup m_canvasgroup;
  Gnome::CanvasLine *m_line;
  Gnome::CanvasEllipse *m_ellipse;
  Gnome::CanvasRect *m_rect;
  Gnome::CanvasImage *m_image;
  
public:
  RoseCanvas();
};

class MainWin : public Gnome::Main
{
public:
  MainWin(const gchar * appname, const gchar * title,
	  const char *app_id, const char *app_version,
	  int argc, char **argv);
	 
protected:

  //override:
  gint on_app_delete_event(GdkEventAny*);

  //Member widgets:
  RoseCanvas m_canvas;
  Gnome::App m_app;
};

RoseCanvas::RoseCanvas()
  : m_canvasgroup(*(root()), 0, 0)
{

  // create some elements there
  Gnome::CanvasPoints points;
  
  points.push_back(Gnome::gpoint(0, 0));
  points.push_back(Gnome::gpoint(100,0));
  points.push_back(Gnome::gpoint(0,100));
  points.push_back(Gnome::gpoint(100,100));

  m_line = new Gnome::CanvasLine(m_canvasgroup,
				"points", points.gtkobj(),
				"fill_color", "black",
				"width_units", 1.0,
				"cap_style", GDK_CAP_ROUND,
				NULL);

  (*m_line).set_fill_color("red").set_width_units(4.0);

  m_ellipse = new Gnome::CanvasEllipse(m_canvasgroup);

  (*m_ellipse).set_x1(0).set_y1(0).
    set_x2(100).set_y2(100).set_fill_color("blue");

  m_rect = new Gnome::CanvasRect(m_canvasgroup,
				"width_pixels", 2,
				"fill_color", "white",
				NULL);

  (*m_rect).set_x1(10).set_y1(10).
    set_x2(50).set_y2(100).set_fill_color("white");

  m_image = new Gnome::CanvasImage(m_canvasgroup);

  Gdk_Imlib::Image toroid("toroid.png");
  m_image->set_image(toroid);


}

MainWin::MainWin(const gchar * appname, const gchar * title,
		 const char *app_id, const char *app_version,
		 int argc, char **argv)
  : Gnome::Main(app_id, app_version, argc, argv),
    m_app(appname, title)
{
  m_app.set_contents(m_canvas);

  //Connect signals:
  m_app.delete_event.connect(slot(this, &MainWin::on_app_delete_event));
  
  m_app.show_all();
};

gint MainWin::on_app_delete_event(GdkEventAny*)
{ 
  Gtk::Main::quit();
  return FALSE; 
}

int main(int argc, char *argv[])
{
  MainWin mainwin("RoseExperiment", "Rosegarden Experiment", "Rose", "0.0",
		  argc, argv);
  
  mainwin.run();
  return 0;
}

