/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * gtkvt102c2f: VT102 charset conversion tables for GtkVt102Emu
 * Copyright (C) 1997 Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* --- charset/font conversion tables --- */

/* the characters output by the terminal application will be used
 * as index into these tables. the most appropriate mappings has
 * been tried to be achieved for the -misc-* fonts.
 */

/* charset to font character conversion table for
 * TERM=linux and font -misc-*
 */
static	gchar	c2f_linux_misc[256] = {
  '\000'	/*   0) 0x00  NUL  */,
  '\001'	/*   1) 0x01  SOH  */,
  '\002'	/*   2) 0x02  STX  */,
  '\003'	/*   3) 0x03  ETX  */,
  0x01		/*   4) 0x04  EOT  -> DIAMOND */,
  '\005'	/*   5) 0x05  ENQ  */,
  '\006'	/*   6) 0x06  ACK  */,
  '\007'	/*   7) 0x07  '\a' */,
  '\010'	/*   8) 0x08  '\b' */,
  0x03		/*   9) 0x09  '\t' -> Ht */,
  0x06		/*  10) 0x0a  '\n' -> Lf */,
  0x0a		/*  11) 0x0b  '\v' -> Vt */,
  0x04		/*  12) 0x0c  '\f' -> Ff */,
  0x05		/*  13) 0x0d  '\r' -> Cr */,
  '\016'	/*  14) 0x0e  SO   */,
  '\017'	/*  15) 0x0f  SI   */,
  '>'		/*  16) 0x10  DLE  -> ARROW POINTING RIGHT */,
  '<'		/*  17) 0x11  DC1  -> ARROW POINTING LEFT */,
  '\022'	/*  18) 0x12  DC2  */,
  '\023'	/*  19) 0x13  DC3  */,
  '\024'	/*  20) 0x14  DC4  */,
  '\025'	/*  21) 0x15  NAK  */,
  '\026'	/*  22) 0x16  SYN  */,
  '\027'	/*  23) 0x17  ETB  */,
  '^'		/*  24) 0x18  CAN  -> arrow pointing up */,
  'v'		/*  25) 0x19  EM   -> ARROW POINTING DOWN */,
  '\032'	/*  26) 0x1a  SUB  */,
  '\033'	/*  27) 0x1b  ESC  */,
  '\034'	/*  28) 0x1c  FS   */,
  '\035'	/*  29) 0x1d  GS   */,
  '\036'	/*  30) 0x1e  RS   */,
  '\037'	/*  31) 0x1f  US   */,
  '\040'	/*  32) 0x20  ' '  */,
  '\041'	/*  33) 0x21  '!'  */,
  '\042'	/*  34) 0x22  '"'  */,
  '\043'	/*  35) 0x23  '#'  */,
  '\044'	/*  36) 0x24  '$'  */,
  '\045'	/*  37) 0x25  '%'  */,
  '\046'	/*  38) 0x26  '&'  */,
  '\047'	/*  39) 0x27  '\'' */,
  '\050'	/*  40) 0x28  '('  */,
  '\051'	/*  41) 0x29  ')'  */,
  '\052'	/*  42) 0x2a  '*'  */,
  '\053'	/*  43) 0x2b  '+'  */,
  '\054'	/*  44) 0x2c  ','  */,
  '\055'	/*  45) 0x2d  '-'  */,
  '\056'	/*  46) 0x2e  '.'  */,
  '\057'	/*  47) 0x2f  '/'  */,
  0x02		/*  48) 0x30  '0'  -> SOLID SQUARE BLOCK / FULL SQUARE (#) */,
  '\061'	/*  49) 0x31  '1'  */,
  '\062'	/*  50) 0x32  '2'  */,
  '\063'	/*  51) 0x33  '3'  */,
  '\064'	/*  52) 0x34  '4'  */,
  '\065'	/*  53) 0x35  '5'  */,
  '\066'	/*  54) 0x36  '6'  */,
  '\067'	/*  55) 0x37  '7'  */,
  '\070'	/*  56) 0x38  '8'  */,
  '\071'	/*  57) 0x39  '9'  */,
  '\072'	/*  58) 0x3a  ':'  */,
  '\073'	/*  59) 0x3b  ';'  */,
  '\074'	/*  60) 0x3c  '<'  */,
  '\075'	/*  61) 0x3d  '='  */,
  '\076'	/*  62) 0x3e  '>'  */,
  '\077'	/*  63) 0x3f  '?'  */,
  '\100'	/*  64) 0x40  '@'  */,
  '\101'	/*  65) 0x41  'A'  */,
  '\102'	/*  66) 0x42  'B'  */,
  '\103'	/*  67) 0x43  'C'  */,
  '\104'	/*  68) 0x44  'D'  */,
  '\105'	/*  69) 0x45  'E'  */,
  '\106'	/*  70) 0x46  'F'  */,
  '\107'	/*  71) 0x47  'G'  */,
  '\110'	/*  72) 0x48  'H'  */,
  '\111'	/*  73) 0x49  'I'  */,
  '\112'	/*  74) 0x4a  'J'  */,
  '\113'	/*  75) 0x4b  'K'  */,
  '\114'	/*  76) 0x4c  'L'  */,
  '\115'	/*  77) 0x4d  'M'  */,
  '\116'	/*  78) 0x4e  'N'  */,
  '\117'	/*  79) 0x4f  'O'  */,
  '\120'	/*  80) 0x50  'P'  */,
  '\121'	/*  81) 0x51  'Q'  */,
  '\122'	/*  82) 0x52  'R'  */,
  '\123'	/*  83) 0x53  'S'  */,
  '\124'	/*  84) 0x54  'T'  */,
  '\125'	/*  85) 0x55  'U'  */,
  '\126'	/*  86) 0x56  'V'  */,
  '\127'	/*  87) 0x57  'W'  */,
  '\130'	/*  88) 0x58  'X'  */,
  '\131'	/*  89) 0x59  'Y'  */,
  '\132'	/*  90) 0x5a  'Z'  */,
  '\133'	/*  91) 0x5b  '['  */,
  '\134'	/*  92) 0x5c  '\'  */,
  '\135'	/*  93) 0x5d  ']'  */,
  '\136'	/*  94) 0x5e  '^'  */,
  0x14		/*  95) 0x5f  '_'  -> BOTTOM HORIZONTAL LINE */,
  '\140'	/*  96) 0x60  '`'  */,
  '\141'	/*  97) 0x61  'a'  */,
  '\142'	/*  98) 0x62  'b'  */,
  '\143'	/*  99) 0x63  'c'  */,
  '\144'	/* 100) 0x64  'd'  */,
  '\145'	/* 101) 0x65  'e'  */,
  '\146'	/* 102) 0x66  'f'  */,
  '\147'	/* 103) 0x67  'g'  */,
  '\150'	/* 104) 0x68  'h'  */,
  '\151'	/* 105) 0x69  'i'  */,
  '\152'	/* 106) 0x6a  'j'  */,
  '\153'	/* 107) 0x6b  'k'  */,
  '\154'	/* 108) 0x6c  'l'  */,
  '\155'	/* 109) 0x6d  'm'  */,
  '\156'	/* 110) 0x6e  'n'  */,
  '\157'	/* 111) 0x6f  'o'  */,
  '\160'	/* 112) 0x70  'p'  */,
  '\161'	/* 113) 0x71  'q'  */,
  '\162'	/* 114) 0x72  'r'  */,
  '\163'	/* 115) 0x73  's'  */,
  '\164'	/* 116) 0x74  't'  */,
  '\165'	/* 117) 0x75  'u'  */,
  '\166'	/* 118) 0x76  'v'  */,
  '\167'	/* 119) 0x77  'w'  */,
  '\170'	/* 120) 0x78  'x'  */,
  '\171'	/* 121) 0x79  'y'  */,
  '\172'	/* 122) 0x7a  'z'  */,
  '\173'	/* 123) 0x7b  '{'  */,
  '\174'	/* 124) 0x7c  '|'  */,
  '\175'	/* 125) 0x7d  '}'  */,
  0x10		/* 126) 0x7e  '~'  -> UPPER HORIZONTAL LINE */,
  '\177'	/* 127) 0x7f  DEL  */,
  '\200'	/* 128) 0x80	   */,
  '\201'	/* 129) 0x81	   */,
  '\202'	/* 130) 0x82	   */,
  '\203'	/* 131) 0x83	   */,
  '\204'	/* 132) 0x84	   */,
  '\205'	/* 133) 0x85	   */,
  '\206'	/* 134) 0x86	   */,
  '\207'	/* 135) 0x87	   */,
  '\210'	/* 136) 0x88	   */,
  '\211'	/* 137) 0x89	   */,
  '\212'	/* 138) 0x8a	   */,
  '\213'	/* 139) 0x8b	   */,
  '\214'	/* 140) 0x8c	   */,
  '\215'	/* 141) 0x8d	   */,
  '\216'	/* 142) 0x8e	   */,
  '\217'	/* 143) 0x8f	   */,
  '\220'	/* 144) 0x90	   */,
  '\221'	/* 145) 0x91	   */,
  '\222'	/* 146) 0x92	   */,
  '\223'	/* 147) 0x93	   */,
  '\224'	/* 148) 0x94	   */,
  '\225'	/* 149) 0x95	   */,
  '\226'	/* 150) 0x96	   */,
  '\227'	/* 151) 0x97	   */,
  '\230'	/* 152) 0x98	   */,
  '\231'	/* 153) 0x99	   */,
  '\232'	/* 154) 0x9a	   */,
  '\233'	/* 155) 0x9b	   */,
  0xa3		/* 156) 0x9c	   -> POUND ??? */,
  '\235'	/* 157) 0x9d	   */,
  '\236'	/* 158) 0x9e	   */,
  '\237'	/* 159) 0x9f	   */,
  '\240'	/* 160) 0xa0	   */,
  '\241'	/* 161) 0xa1	   */,
  '\242'	/* 162) 0xa2	   */,
  '\243'	/* 163) 0xa3	   */,
  '\244'	/* 164) 0xa4	   */,
  '\245'	/* 165) 0xa5	   */,
  '\246'	/* 166) 0xa6	   */,
  '\247'	/* 167) 0xa7	   */,
  '\250'	/* 168) 0xa8	   */,
  '\251'	/* 169) 0xa9	   */,
  '\252'	/* 170) 0xaa	   */,
  '\253'	/* 171) 0xab	   */,
  '\254'	/* 172) 0xac	   */,
  '\255'	/* 173) 0xad	   */,
  '\256'	/* 174) 0xae	   */,
  '\257'	/* 175) 0xaf	   */,
  '#'		/* 176) 0xb0	   -> LIGHT SQUARES / BOARD OF SQUARES / SQUARE (#) */,
  0x02		/* 177) 0xb1	   -> DENSE SQUARES / CHECKER BOARD (STIPPLE) / CHESS BOARD */,
  '\262'	/* 178) 0xb2	   */,
  0x19		/* 179) 0xb3	   -> VERTICAL LINE */,
  0x16		/* 180) 0xb4	   -> RIGHT TEE */,
  '\265'	/* 181) 0xb5	   */,
  '\266'	/* 182) 0xb6	   */,
  '\267'	/* 183) 0xb7	   */,
  '\270'	/* 184) 0xb8	   */,
  '\271'	/* 185) 0xb9	   */,
  '\272'	/* 186) 0xba	   */,
  '\273'	/* 187) 0xbb	   */,
  '\274'	/* 188) 0xbc	   */,
  '\275'	/* 189) 0xbd	   */,
  '\276'	/* 190) 0xbe	   */,
  0x0c		/* 191) 0xbf	   -> RIGHT UPPER CORNER */,
  0x0e		/* 192) 0xc0	   -> LEFT BOTTOM CORNER */,
  0x17		/* 193) 0xc1	   -> BOTTOM TEE */,
  0x18		/* 194) 0xc2	   -> NORMAL TEE */,
  0x15		/* 195) 0xc3	   -> LEFT TEE */,
  0x12		/* 196) 0xc4	   -> MIDDLE HORIZONTAL LINE */,
  0x0f		/* 197) 0xc5	   -> CROSS */,
  '\306'	/* 198) 0xc6	   */,
  '\307'	/* 199) 0xc7	   */,
  '\310'	/* 200) 0xc8	   */,
  '\311'	/* 201) 0xc9	   */,
  '\312'	/* 202) 0xca	   */,
  '\313'	/* 203) 0xcb	   */,
  '\314'	/* 204) 0xcc	   */,
  '\315'	/* 205) 0xcd	   */,
  '\316'	/* 206) 0xce	   */,
  '\317'	/* 207) 0xcf	   */,
  '\320'	/* 208) 0xd0	   */,
  '\321'	/* 209) 0xd1	   */,
  '\322'	/* 210) 0xd2	   */,
  '\323'	/* 211) 0xd3	   */,
  '\324'	/* 212) 0xd4	   */,
  '\325'	/* 213) 0xd5	   */,
  '\326'	/* 214) 0xd6	   */,
  '\327'	/* 215) 0xd7	   */,
  0x0f		/* 216) 0xd8	   -> CROSS ??? */,
  0x0b		/* 217) 0xd9	   -> RIGHT BOTTOM CORNER */,
  0x0d		/* 218) 0xda	   -> LEFT UPPER CORNER */,
  '\333'	/* 219) 0xdb	   */,
  '\334'	/* 220) 0xdc	   */,
  '\335'	/* 221) 0xdd	   */,
  '\336'	/* 222) 0xde	   */,
  '\337'	/* 223) 0xdf	   */,
  '\340'	/* 224) 0xe0	   */,
  '\341'	/* 225) 0xe1	   */,
  '\342'	/* 226) 0xe2	   */,
  0x1c		/* 227) 0xe3	   -> PI ??? */,
  '\344'	/* 228) 0xe4	   */,
  '\345'	/* 229) 0xe5	   */,
  '\346'	/* 230) 0xe6	   */,
  '\347'	/* 231) 0xe7	   */,
  '\350'	/* 232) 0xe8	   */,
  '\351'	/* 233) 0xe9	   */,
  '\352'	/* 234) 0xea	   */,
  '\353'	/* 235) 0xeb	   */,
  '\354'	/* 236) 0xec	   */,
  '\355'	/* 237) 0xed	   */,
  '\356'	/* 238) 0xee	   */,
  '\357'	/* 239) 0xef	   */,
  '\360'	/* 240) 0xf0	   */,
  0xb1		/* 241) 0xf1	   -> PLUS-MINUS */,
  0x1b		/* 242) 0xf2	   -> GREATER-OR-EQUAL ??? */,
  0x1a		/* 243) 0xf3	   -> LESS-OR-EQUAL ??? */,
  '\364'	/* 244) 0xf4	   */,
  '\365'	/* 245) 0xf5	   */,
  '\366'	/* 246) 0xf6	   */,
  '\367'	/* 247) 0xf7	   */,
  0xb0		/* 248) 0xf8	   -> DEGREE SYMBOL () */,
  0xb7		/* 249) 0xf9	   -> MIDDLE DOT ??? */,
  0xb8		/* 250) 0xfa	   -> LOWER MIDDLE DOT ??? */,
  '?'		/* 251) 0xfb	   -> SQUARE ROOT */,
  '?'		/* 252) 0xfc	   -> POWER OF N */,
  0xb2		/* 253) 0xfd	   -> POWER OF 2 */,
  0xb3		/* 254) 0xfe	   -> POWER OF 3 ??? */,
  '\377'	/* 255) 0xff	   */,
};

/* charset to font character conversion table for
 * TERM=linux and unspecified font
 */
static	gchar	c2f_linux_any[256] = {
  '\000'	/*   0) 0x00  NUL  */,
  '\001'	/*   1) 0x01  SOH  */,
  '\002'	/*   2) 0x02  STX  */,
  '\003'	/*   3) 0x03  ETX  */,
  '?'		/*   4) 0x04  EOT  -> DIAMOND */,
  '\005'	/*   5) 0x05  ENQ  */,
  '\006'	/*   6) 0x06  ACK  */,
  '\007'	/*   7) 0x07  '\a' */,
  '\010'	/*   8) 0x08  '\b' */,
  '\011'	/*   9) 0x09  '\t' */,
  '\012'	/*  10) 0x0a  '\n' */,
  '\013'	/*  11) 0x0b  '\v' */,
  '\014'	/*  12) 0x0c  '\f' */,
  '\015'	/*  13) 0x0d  '\r' */,
  '\016'	/*  14) 0x0e  SO   */,
  '\017'	/*  15) 0x0f  SI   */,
  '>'		/*  16) 0x10  DLE  -> ARROW POINTING RIGHT */,
  '<'		/*  17) 0x11  DC1  -> ARROW POINTING LEFT */,
  '\022'	/*  18) 0x12  DC2  */,
  '\023'	/*  19) 0x13  DC3  */,
  '\024'	/*  20) 0x14  DC4  */,
  '\025'	/*  21) 0x15  NAK  */,
  '\026'	/*  22) 0x16  SYN  */,
  '\027'	/*  23) 0x17  ETB  */,
  '^'		/*  24) 0x18  CAN  -> arrow pointing up */,
  'v'		/*  25) 0x19  EM   -> ARROW POINTING DOWN */,
  '\032'	/*  26) 0x1a  SUB  */,
  '\033'	/*  27) 0x1b  ESC  */,
  '\034'	/*  28) 0x1c  FS   */,
  '\035'	/*  29) 0x1d  GS   */,
  '\036'	/*  30) 0x1e  RS   */,
  '\037'	/*  31) 0x1f  US   */,
  '\040'	/*  32) 0x20  ' '  */,
  '\041'	/*  33) 0x21  '!'  */,
  '\042'	/*  34) 0x22  '"'  */,
  '\043'	/*  35) 0x23  '#'  */,
  '\044'	/*  36) 0x24  '$'  */,
  '\045'	/*  37) 0x25  '%'  */,
  '\046'	/*  38) 0x26  '&'  */,
  '\047'	/*  39) 0x27  '\'' */,
  '\050'	/*  40) 0x28  '('  */,
  '\051'	/*  41) 0x29  ')'  */,
  '\052'	/*  42) 0x2a  '*'  */,
  '\053'	/*  43) 0x2b  '+'  */,
  '\054'	/*  44) 0x2c  ','  */,
  '\055'	/*  45) 0x2d  '-'  */,
  '\056'	/*  46) 0x2e  '.'  */,
  '\057'	/*  47) 0x2f  '/'  */,
  '#'		/*  48) 0x30  '0'  -> SOLID SQUARE BLOCK / FULL SQUARE (#) */,
  '\061'	/*  49) 0x31  '1'  */,
  '\062'	/*  50) 0x32  '2'  */,
  '\063'	/*  51) 0x33  '3'  */,
  '\064'	/*  52) 0x34  '4'  */,
  '\065'	/*  53) 0x35  '5'  */,
  '\066'	/*  54) 0x36  '6'  */,
  '\067'	/*  55) 0x37  '7'  */,
  '\070'	/*  56) 0x38  '8'  */,
  '\071'	/*  57) 0x39  '9'  */,
  '\072'	/*  58) 0x3a  ':'  */,
  '\073'	/*  59) 0x3b  ';'  */,
  '\074'	/*  60) 0x3c  '<'  */,
  '\075'	/*  61) 0x3d  '='  */,
  '\076'	/*  62) 0x3e  '>'  */,
  '\077'	/*  63) 0x3f  '?'  */,
  '\100'	/*  64) 0x40  '@'  */,
  '\101'	/*  65) 0x41  'A'  */,
  '\102'	/*  66) 0x42  'B'  */,
  '\103'	/*  67) 0x43  'C'  */,
  '\104'	/*  68) 0x44  'D'  */,
  '\105'	/*  69) 0x45  'E'  */,
  '\106'	/*  70) 0x46  'F'  */,
  '\107'	/*  71) 0x47  'G'  */,
  '\110'	/*  72) 0x48  'H'  */,
  '\111'	/*  73) 0x49  'I'  */,
  '\112'	/*  74) 0x4a  'J'  */,
  '\113'	/*  75) 0x4b  'K'  */,
  '\114'	/*  76) 0x4c  'L'  */,
  '\115'	/*  77) 0x4d  'M'  */,
  '\116'	/*  78) 0x4e  'N'  */,
  '\117'	/*  79) 0x4f  'O'  */,
  '\120'	/*  80) 0x50  'P'  */,
  '\121'	/*  81) 0x51  'Q'  */,
  '\122'	/*  82) 0x52  'R'  */,
  '\123'	/*  83) 0x53  'S'  */,
  '\124'	/*  84) 0x54  'T'  */,
  '\125'	/*  85) 0x55  'U'  */,
  '\126'	/*  86) 0x56  'V'  */,
  '\127'	/*  87) 0x57  'W'  */,
  '\130'	/*  88) 0x58  'X'  */,
  '\131'	/*  89) 0x59  'Y'  */,
  '\132'	/*  90) 0x5a  'Z'  */,
  '\133'	/*  91) 0x5b  '['  */,
  '\134'	/*  92) 0x5c  '\'  */,
  '\135'	/*  93) 0x5d  ']'  */,
  '\136'	/*  94) 0x5e  '^'  */,
  '_'		/*  95) 0x5f  '_'  -> BOTTOM HORIZONTAL LINE */,
  '\140'	/*  96) 0x60  '`'  */,
  '\141'	/*  97) 0x61  'a'  */,
  '\142'	/*  98) 0x62  'b'  */,
  '\143'	/*  99) 0x63  'c'  */,
  '\144'	/* 100) 0x64  'd'  */,
  '\145'	/* 101) 0x65  'e'  */,
  '\146'	/* 102) 0x66  'f'  */,
  '\147'	/* 103) 0x67  'g'  */,
  '\150'	/* 104) 0x68  'h'  */,
  '\151'	/* 105) 0x69  'i'  */,
  '\152'	/* 106) 0x6a  'j'  */,
  '\153'	/* 107) 0x6b  'k'  */,
  '\154'	/* 108) 0x6c  'l'  */,
  '\155'	/* 109) 0x6d  'm'  */,
  '\156'	/* 110) 0x6e  'n'  */,
  '\157'	/* 111) 0x6f  'o'  */,
  '\160'	/* 112) 0x70  'p'  */,
  '\161'	/* 113) 0x71  'q'  */,
  '\162'	/* 114) 0x72  'r'  */,
  '\163'	/* 115) 0x73  's'  */,
  '\164'	/* 116) 0x74  't'  */,
  '\165'	/* 117) 0x75  'u'  */,
  '\166'	/* 118) 0x76  'v'  */,
  '\167'	/* 119) 0x77  'w'  */,
  '\170'	/* 120) 0x78  'x'  */,
  '\171'	/* 121) 0x79  'y'  */,
  '\172'	/* 122) 0x7a  'z'  */,
  '\173'	/* 123) 0x7b  '{'  */,
  '\174'	/* 124) 0x7c  '|'  */,
  '\175'	/* 125) 0x7d  '}'  */,
  '~'		/* 126) 0x7e  '~'  -> UPPER HORIZONTAL LINE */,
  '\177'	/* 127) 0x7f  DEL  */,
  '\200'	/* 128) 0x80	   */,
  '\201'	/* 129) 0x81	   */,
  '\202'	/* 130) 0x82	   */,
  '\203'	/* 131) 0x83	   */,
  '\204'	/* 132) 0x84	   */,
  '\205'	/* 133) 0x85	   */,
  '\206'	/* 134) 0x86	   */,
  '\207'	/* 135) 0x87	   */,
  '\210'	/* 136) 0x88	   */,
  '\211'	/* 137) 0x89	   */,
  '\212'	/* 138) 0x8a	   */,
  '\213'	/* 139) 0x8b	   */,
  '\214'	/* 140) 0x8c	   */,
  '\215'	/* 141) 0x8d	   */,
  '\216'	/* 142) 0x8e	   */,
  '\217'	/* 143) 0x8f	   */,
  '\220'	/* 144) 0x90	   */,
  '\221'	/* 145) 0x91	   */,
  '\222'	/* 146) 0x92	   */,
  '\223'	/* 147) 0x93	   */,
  '\224'	/* 148) 0x94	   */,
  '\225'	/* 149) 0x95	   */,
  '\226'	/* 150) 0x96	   */,
  '\227'	/* 151) 0x97	   */,
  '\230'	/* 152) 0x98	   */,
  '\231'	/* 153) 0x99	   */,
  '\232'	/* 154) 0x9a	   */,
  '\233'	/* 155) 0x9b	   */,
  0xa3		/* 156) 0x9c	   -> POUND ??? */,
  '\235'	/* 157) 0x9d	   */,
  '\236'	/* 158) 0x9e	   */,
  '\237'	/* 159) 0x9f	   */,
  '\240'	/* 160) 0xa0	   */,
  '\241'	/* 161) 0xa1	   */,
  '\242'	/* 162) 0xa2	   */,
  '\243'	/* 163) 0xa3	   */,
  '\244'	/* 164) 0xa4	   */,
  '\245'	/* 165) 0xa5	   */,
  '\246'	/* 166) 0xa6	   */,
  '\247'	/* 167) 0xa7	   */,
  '\250'	/* 168) 0xa8	   */,
  '\251'	/* 169) 0xa9	   */,
  '\252'	/* 170) 0xaa	   */,
  '\253'	/* 171) 0xab	   */,
  '\254'	/* 172) 0xac	   */,
  '\255'	/* 173) 0xad	   */,
  '\256'	/* 174) 0xae	   */,
  '\257'	/* 175) 0xaf	   */,
  '#'		/* 176) 0xb0	   -> LIGHT SQUARES / BOARD OF SQUARES / SQUARE (#) */,
  '*'		/* 177) 0xb1	   -> DENSE SQUARES / CHECKER BOARD (STIPPLE) / CHESS BOARD */,
  '\262'	/* 178) 0xb2	   */,
  '|'		/* 179) 0xb3	   -> VERTICAL LINE */,
  '+'		/* 180) 0xb4	   -> RIGHT TEE */,
  '\265'	/* 181) 0xb5	   */,
  '\266'	/* 182) 0xb6	   */,
  '\267'	/* 183) 0xb7	   */,
  '\270'	/* 184) 0xb8	   */,
  '\271'	/* 185) 0xb9	   */,
  '\272'	/* 186) 0xba	   */,
  '\273'	/* 187) 0xbb	   */,
  '\274'	/* 188) 0xbc	   */,
  '\275'	/* 189) 0xbd	   */,
  '\276'	/* 190) 0xbe	   */,
  '+'		/* 191) 0xbf	   -> RIGHT UPPER CORNER */,
  '+'		/* 192) 0xc0	   -> LEFT BOTTOM CORNER */,
  '+'		/* 193) 0xc1	   -> BOTTOM TEE */,
  '+'		/* 194) 0xc2	   -> NORMAL TEE */,
  '+'		/* 195) 0xc3	   -> LEFT TEE */,
  '-'		/* 196) 0xc4	   -> MIDDLE HORIZONTAL LINE */,
  '+'		/* 197) 0xc5	   -> CROSS */,
  '\306'	/* 198) 0xc6	   */,
  '\307'	/* 199) 0xc7	   */,
  '\310'	/* 200) 0xc8	   */,
  '\311'	/* 201) 0xc9	   */,
  '\312'	/* 202) 0xca	   */,
  '\313'	/* 203) 0xcb	   */,
  '\314'	/* 204) 0xcc	   */,
  '\315'	/* 205) 0xcd	   */,
  '\316'	/* 206) 0xce	   */,
  '\317'	/* 207) 0xcf	   */,
  '\320'	/* 208) 0xd0	   */,
  '\321'	/* 209) 0xd1	   */,
  '\322'	/* 210) 0xd2	   */,
  '\323'	/* 211) 0xd3	   */,
  '\324'	/* 212) 0xd4	   */,
  '\325'	/* 213) 0xd5	   */,
  '\326'	/* 214) 0xd6	   */,
  '\327'	/* 215) 0xd7	   */,
  '+'		/* 216) 0xd8	   -> CROSS ??? */,
  '+'		/* 217) 0xd9	   -> RIGHT BOTTOM CORNER */,
  '+'		/* 218) 0xda	   -> LEFT UPPER CORNER */,
  '\333'	/* 219) 0xdb	   */,
  '\334'	/* 220) 0xdc	   */,
  '\335'	/* 221) 0xdd	   */,
  '\336'	/* 222) 0xde	   */,
  '\337'	/* 223) 0xdf	   */,
  '\340'	/* 224) 0xe0	   */,
  '\341'	/* 225) 0xe1	   */,
  '\342'	/* 226) 0xe2	   */,
  '?'		/* 227) 0xe3	   -> PI ??? */,
  '\344'	/* 228) 0xe4	   */,
  '\345'	/* 229) 0xe5	   */,
  '\346'	/* 230) 0xe6	   */,
  '\347'	/* 231) 0xe7	   */,
  '\350'	/* 232) 0xe8	   */,
  '\351'	/* 233) 0xe9	   */,
  '\352'	/* 234) 0xea	   */,
  '\353'	/* 235) 0xeb	   */,
  '\354'	/* 236) 0xec	   */,
  '\355'	/* 237) 0xed	   */,
  '\356'	/* 238) 0xee	   */,
  '\357'	/* 239) 0xef	   */,
  '\360'	/* 240) 0xf0	   */,
  '?'		/* 241) 0xf1	   -> PLUS-MINUS */,
  '?'		/* 242) 0xf2	   -> GREATER-OR-EQUAL ??? */,
  '?'		/* 243) 0xf3	   -> LESS-OR-EQUAL ??? */,
  '\364'	/* 244) 0xf4	   */,
  '\365'	/* 245) 0xf5	   */,
  '\366'	/* 246) 0xf6	   */,
  '\367'	/* 247) 0xf7	   */,
  0xb0		/* 248) 0xf8	   -> DEGREE SYMBOL () */,
  0xb7		/* 249) 0xf9	   -> MIDDLE DOT ??? */,
  '?'		/* 250) 0xfa	   -> LOWER MIDDLE DOT ??? */,
  '?'		/* 251) 0xfb	   -> SQUARE ROOT */,
  '?'		/* 252) 0xfc	   -> POWER OF N */,
  0xb2		/* 253) 0xfd	   -> POWER OF 2 */,
  0xb3		/* 254) 0xfe	   -> POWER OF 3 ??? */,
  '\377'	/* 255) 0xff	   */,
};

/* charset to font character conversion table for
 * TERM=vt102 and font -misc-*
 */
static	gchar	c2f_vt102_misc[256] = {
  '\000'	/*   0) 0x00  NUL  */,
  '\001'	/*   1) 0x01  SOH  */,
  '\002'	/*   2) 0x02  STX  */,
  '\003'	/*   3) 0x03  ETX  */,
  '\004'	/*   4) 0x04  EOT  */,
  '\005'	/*   5) 0x05  ENQ  */,
  '\006'	/*   6) 0x06  ACK  */,
  '\007'	/*   7) 0x07  '\a' */,
  '\010'	/*   8) 0x08  '\b' */,
  0x03		/*   9) 0x09  '\t' -> Ht */,
  0x06		/*  10) 0x0a  '\n' -> Lf */,
  0x0a		/*  11) 0x0b  '\v' -> Vt */,
  0x04		/*  12) 0x0c  '\f' -> Ff */,
  0x05		/*  13) 0x0d  '\r' -> Cr */,
  '\016'	/*  14) 0x0e  SO   */,
  '\017'	/*  15) 0x0f  SI   */,
  '\020'	/*  16) 0x10  DLE  */,
  '\021'	/*  17) 0x11  DC1  */,
  '\022'	/*  18) 0x12  DC2  */,
  '\023'	/*  19) 0x13  DC3  */,
  '\024'	/*  20) 0x14  DC4  */,
  '\025'	/*  21) 0x15  NAK  */,
  '\026'	/*  22) 0x16  SYN  */,
  '\027'	/*  23) 0x17  ETB  */,
  '\030'	/*  24) 0x18  CAN  */,
  '\031'	/*  25) 0x19  EM   */,
  '\032'	/*  26) 0x1a  SUB  */,
  '\033'	/*  27) 0x1b  ESC  */,
  '\034'	/*  28) 0x1c  FS   */,
  '\035'	/*  29) 0x1d  GS   */,
  '\036'	/*  30) 0x1e  RS   */,
  '\037'	/*  31) 0x1f  US   */,
  '\040'	/*  32) 0x20  ' '  */,
  '\041'	/*  33) 0x21  '!'  */,
  '\042'	/*  34) 0x22  '"'  */,
  '\043'	/*  35) 0x23  '#'  */,
  '\044'	/*  36) 0x24  '$'  */,
  '\045'	/*  37) 0x25  '%'  */,
  '\046'	/*  38) 0x26  '&'  */,
  '\047'	/*  39) 0x27  '\'' */,
  '\050'	/*  40) 0x28  '('  */,
  '\051'	/*  41) 0x29  ')'  */,
  '\052'	/*  42) 0x2a  '*'  */,
  '>'		/*  43) 0x2b  '+'  -> ARROW POINTING RIGHT */,
  '<'		/*  44) 0x2c  ','  -> ARROW POINTING LEFT */,
  '^'		/*  45) 0x2d  '-'  -> ARROW POINTING UP */,
  'v'		/*  46) 0x2e  '.'  -> ARROW POINTING DOWN */,
  '\057'	/*  47) 0x2f  '/'  */,
  '\060'	/*  48) 0x30  '0'  */,
  '\061'	/*  49) 0x31  '1'  */,
  '\062'	/*  50) 0x32  '2'  */,
  '\063'	/*  51) 0x33  '3'  */,
  '\064'	/*  52) 0x34  '4'  */,
  '\065'	/*  53) 0x35  '5'  */,
  '\066'	/*  54) 0x36  '6'  */,
  '\067'	/*  55) 0x37  '7'  */,
  '\070'	/*  56) 0x38  '8'  */,
  '\071'	/*  57) 0x39  '9'  */,
  '\072'	/*  58) 0x3a  ':'  */,
  '\073'	/*  59) 0x3b  ';'  */,
  '\074'	/*  60) 0x3c  '<'  */,
  '\075'	/*  61) 0x3d  '='  */,
  '\076'	/*  62) 0x3e  '>'  */,
  '\077'	/*  63) 0x3f  '?'  */,
  '\100'	/*  64) 0x40  '@'  */,
  '\101'	/*  65) 0x41  'A'  */,
  '\102'	/*  66) 0x42  'B'  */,
  '\103'	/*  67) 0x43  'C'  */,
  '\104'	/*  68) 0x44  'D'  */,
  '\105'	/*  69) 0x45  'E'  */,
  '\106'	/*  70) 0x46  'F'  */,
  '\107'	/*  71) 0x47  'G'  */,
  '\110'	/*  72) 0x48  'H'  */,
  '\111'	/*  73) 0x49  'I'  */,
  '\112'	/*  74) 0x4a  'J'  */,
  '\113'	/*  75) 0x4b  'K'  */,
  '\114'	/*  76) 0x4c  'L'  */,
  '\115'	/*  77) 0x4d  'M'  */,
  '\116'	/*  78) 0x4e  'N'  */,
  '\117'	/*  79) 0x4f  'O'  */,
  '\120'	/*  80) 0x50  'P'  */,
  '\121'	/*  81) 0x51  'Q'  */,
  '\122'	/*  82) 0x52  'R'  */,
  '\123'	/*  83) 0x53  'S'  */,
  '\124'	/*  84) 0x54  'T'  */,
  '\125'	/*  85) 0x55  'U'  */,
  '\126'	/*  86) 0x56  'V'  */,
  '\127'	/*  87) 0x57  'W'  */,
  '\130'	/*  88) 0x58  'X'  */,
  '\131'	/*  89) 0x59  'Y'  */,
  '\132'	/*  90) 0x5a  'Z'  */,
  '\133'	/*  91) 0x5b  '['  */,
  '\134'	/*  92) 0x5c  '\'  */,
  '\135'	/*  93) 0x5d  ']'  */,
  '\136'	/*  94) 0x5e  '^'  */,
  0x7f		/*  95) 0x5f  '_'  -> SPACE ??? (xterm does this) */,
  0x01		/*  96) 0x60  '`'  -> DIAMOND */,
  0x02		/*  97) 0x61  'a'  -> SOLID SQUARE BLOCK / FULL SQUARE (#) */,
  0x03		/*  98) 0x62  'b'  -> Ht */,
  0x04		/*  99) 0x63  'c'  -> Ff */,
  0x05		/* 100) 0x64  'd'  -> Cr */,
  0x06		/* 101) 0x65  'e'  -> Lf */,
  0xb0		/* 102) 0x66  'f'  -> DEGREE SYMBOL () */,
  0xb1		/* 103) 0x67  'g'  -> PLUS-MINUS */,
  0x09		/* 104) 0x68  'h'  -> Nl */,
  0x0a		/* 105) 0x69  'i'  -> Vt */,
  0x0b		/* 106) 0x6a  'j'  -> RIGHT BOTTOM CORNER */,
  0x0c		/* 107) 0x6b  'k'  -> RIGHT UPPER CORNER */,
  0x0d		/* 108) 0x6c  'l'  -> LEFT UPPER CORNER */,
  0x0e		/* 109) 0x6d  'm'  -> LEFT BOTTOM CORNER */,
  0x0f		/* 110) 0x6e  'n'  -> CROSS */,
  0x10		/* 111) 0x6f  'o'  -> UPPER HORIZONTAL LINE */,
  0x11		/* 112) 0x70  'p'  -> UPPER HORIZONTAL LINE - 1 */,
  0x12		/* 113) 0x71  'q'  -> MIDDLE HORIZONTAL LINE */,
  0x13		/* 114) 0x72  'r'  -> BOTTOM HORIZONTAL LINE + 1 */,
  0x14		/* 115) 0x73  's'  -> BOTTOM HORIZONTAL LINE */,
  0x15		/* 116) 0x74  't'  -> LEFT TEE */,
  0x16		/* 117) 0x75  'u'  -> RIGHT TEE */,
  0x17		/* 118) 0x76  'v'  -> BOTTOM TEE */,
  0x18		/* 119) 0x77  'w'  -> NORMAL TEE */,
  0x19		/* 120) 0x78  'x'  -> VERTICAL LINE */,
  0x1a		/* 121) 0x79  'y'  -> LESS-OR-EQUAL ??? */,
  0x1b		/* 122) 0x7a  'z'  -> GREATER-OR-EQUAL ??? */,
  0x1c		/* 123) 0x7b  '{'  -> PI ??? */,
  0x1d		/* 124) 0x7c  '|'  -> UNEQUAL ??? */,
  0xa3		/* 125) 0x7d  '}'  -> POUND ??? */,
  0x1f		/* 126) 0x7e  '~'  -> MIDDLE DOT ??? (xterm does this) */,
  '\177'	/* 127) 0x7f  DEL  */,
  '\200'	/* 128) 0x80	   */,
  '\201'	/* 129) 0x81	   */,
  '\202'	/* 130) 0x82	   */,
  '\203'	/* 131) 0x83	   */,
  '\204'	/* 132) 0x84	   */,
  '\205'	/* 133) 0x85	   */,
  '\206'	/* 134) 0x86	   */,
  '\207'	/* 135) 0x87	   */,
  '\210'	/* 136) 0x88	   */,
  '\211'	/* 137) 0x89	   */,
  '\212'	/* 138) 0x8a	   */,
  '\213'	/* 139) 0x8b	   */,
  '\214'	/* 140) 0x8c	   */,
  '\215'	/* 141) 0x8d	   */,
  '\216'	/* 142) 0x8e	   */,
  '\217'	/* 143) 0x8f	   */,
  '\220'	/* 144) 0x90	   */,
  '\221'	/* 145) 0x91	   */,
  '\222'	/* 146) 0x92	   */,
  '\223'	/* 147) 0x93	   */,
  '\224'	/* 148) 0x94	   */,
  '\225'	/* 149) 0x95	   */,
  '\226'	/* 150) 0x96	   */,
  '\227'	/* 151) 0x97	   */,
  '\230'	/* 152) 0x98	   */,
  '\231'	/* 153) 0x99	   */,
  '\232'	/* 154) 0x9a	   */,
  '\233'	/* 155) 0x9b	   */,
  '\234'	/* 156) 0x9c	   */,
  '\235'	/* 157) 0x9d	   */,
  '\236'	/* 158) 0x9e	   */,
  '\237'	/* 159) 0x9f	   */,
  '\240'	/* 160) 0xa0	   */,
  '\241'	/* 161) 0xa1	   */,
  '\242'	/* 162) 0xa2	   */,
  '\243'	/* 163) 0xa3	   */,
  '\244'	/* 164) 0xa4	   */,
  '\245'	/* 165) 0xa5	   */,
  '\246'	/* 166) 0xa6	   */,
  '\247'	/* 167) 0xa7	   */,
  '\250'	/* 168) 0xa8	   */,
  '\251'	/* 169) 0xa9	   */,
  '\252'	/* 170) 0xaa	   */,
  '\253'	/* 171) 0xab	   */,
  '\254'	/* 172) 0xac	   */,
  '\255'	/* 173) 0xad	   */,
  '\256'	/* 174) 0xae	   */,
  '\257'	/* 175) 0xaf	   */,
  '\260'	/* 176) 0xb0	   */,
  '\261'	/* 177) 0xb1	   */,
  '\262'	/* 178) 0xb2	   */,
  '\263'	/* 179) 0xb3	   */,
  '\264'	/* 180) 0xb4	   */,
  '\265'	/* 181) 0xb5	   */,
  '\266'	/* 182) 0xb6	   */,
  '\267'	/* 183) 0xb7	   */,
  '\270'	/* 184) 0xb8	   */,
  '\271'	/* 185) 0xb9	   */,
  '\272'	/* 186) 0xba	   */,
  '\273'	/* 187) 0xbb	   */,
  '\274'	/* 188) 0xbc	   */,
  '\275'	/* 189) 0xbd	   */,
  '\276'	/* 190) 0xbe	   */,
  '\277'	/* 191) 0xbf	   */,
  '\300'	/* 192) 0xc0	   */,
  '\301'	/* 193) 0xc1	   */,
  '\302'	/* 194) 0xc2	   */,
  '\303'	/* 195) 0xc3	   */,
  '\304'	/* 196) 0xc4	   */,
  '\305'	/* 197) 0xc5	   */,
  '\306'	/* 198) 0xc6	   */,
  '\307'	/* 199) 0xc7	   */,
  '\310'	/* 200) 0xc8	   */,
  '\311'	/* 201) 0xc9	   */,
  '\312'	/* 202) 0xca	   */,
  '\313'	/* 203) 0xcb	   */,
  '\314'	/* 204) 0xcc	   */,
  '\315'	/* 205) 0xcd	   */,
  '\316'	/* 206) 0xce	   */,
  '\317'	/* 207) 0xcf	   */,
  '\320'	/* 208) 0xd0	   */,
  '\321'	/* 209) 0xd1	   */,
  '\322'	/* 210) 0xd2	   */,
  '\323'	/* 211) 0xd3	   */,
  '\324'	/* 212) 0xd4	   */,
  '\325'	/* 213) 0xd5	   */,
  '\326'	/* 214) 0xd6	   */,
  '\327'	/* 215) 0xd7	   */,
  '\330'	/* 216) 0xd8	   */,
  '\331'	/* 217) 0xd9	   */,
  '\332'	/* 218) 0xda	   */,
  '\333'	/* 219) 0xdb	   */,
  '\334'	/* 220) 0xdc	   */,
  '\335'	/* 221) 0xdd	   */,
  '\336'	/* 222) 0xde	   */,
  '\337'	/* 223) 0xdf	   */,
  '\340'	/* 224) 0xe0	   */,
  '\341'	/* 225) 0xe1	   */,
  '\342'	/* 226) 0xe2	   */,
  '\343'	/* 227) 0xe3	   */,
  '\344'	/* 228) 0xe4	   */,
  '\345'	/* 229) 0xe5	   */,
  '\346'	/* 230) 0xe6	   */,
  '\347'	/* 231) 0xe7	   */,
  '\350'	/* 232) 0xe8	   */,
  '\351'	/* 233) 0xe9	   */,
  '\352'	/* 234) 0xea	   */,
  '\353'	/* 235) 0xeb	   */,
  '\354'	/* 236) 0xec	   */,
  '\355'	/* 237) 0xed	   */,
  '\356'	/* 238) 0xee	   */,
  '\357'	/* 239) 0xef	   */,
  '\360'	/* 240) 0xf0	   */,
  '\361'	/* 241) 0xf1	   */,
  '\362'	/* 242) 0xf2	   */,
  '\363'	/* 243) 0xf3	   */,
  '\364'	/* 244) 0xf4	   */,
  '\365'	/* 245) 0xf5	   */,
  '\366'	/* 246) 0xf6	   */,
  '\367'	/* 247) 0xf7	   */,
  '\370'	/* 248) 0xf8	   */,
  '\371'	/* 249) 0xf9	   */,
  '\372'	/* 250) 0xfa	   */,
  '\373'	/* 251) 0xfb	   */,
  '\374'	/* 252) 0xfc	   */,
  '\375'	/* 253) 0xfd	   */,
  '\376'	/* 254) 0xfe	   */,
  '\377'	/* 255) 0xff	   */,
};

/* charset to font character conversion table for
 * TERM=vt102 and and unspecified font
 */
static	gchar	c2f_vt102_any[256] = {
  '\000'	/*   0) 0x00  NUL  */,
  '\001'	/*   1) 0x01  SOH  */,
  '\002'	/*   2) 0x02  STX  */,
  '\003'	/*   3) 0x03  ETX  */,
  '\004'	/*   4) 0x04  EOT  */,
  '\005'	/*   5) 0x05  ENQ  */,
  '\006'	/*   6) 0x06  ACK  */,
  '\007'	/*   7) 0x07  '\a' */,
  '\010'	/*   8) 0x08  '\b' */,
  '\011'	/*   9) 0x09  '\t' */,
  '\012'	/*  10) 0x0a  '\n' */,
  '\013'	/*  11) 0x0b  '\v' */,
  '\014'	/*  12) 0x0c  '\f' */,
  '\015'	/*  13) 0x0d  '\r' */,
  '\016'	/*  14) 0x0e  SO   */,
  '\017'	/*  15) 0x0f  SI   */,
  '\020'	/*  16) 0x10  DLE  */,
  '\021'	/*  17) 0x11  DC1  */,
  '\022'	/*  18) 0x12  DC2  */,
  '\023'	/*  19) 0x13  DC3  */,
  '\024'	/*  20) 0x14  DC4  */,
  '\025'	/*  21) 0x15  NAK  */,
  '\026'	/*  22) 0x16  SYN  */,
  '\027'	/*  23) 0x17  ETB  */,
  '\030'	/*  24) 0x18  CAN  */,
  '\031'	/*  25) 0x19  EM   */,
  '\032'	/*  26) 0x1a  SUB  */,
  '\033'	/*  27) 0x1b  ESC  */,
  '\034'	/*  28) 0x1c  FS   */,
  '\035'	/*  29) 0x1d  GS   */,
  '\036'	/*  30) 0x1e  RS   */,
  '\037'	/*  31) 0x1f  US   */,
  '\040'	/*  32) 0x20  ' '  */,
  '\041'	/*  33) 0x21  '!'  */,
  '\042'	/*  34) 0x22  '"'  */,
  '\043'	/*  35) 0x23  '#'  */,
  '\044'	/*  36) 0x24  '$'  */,
  '\045'	/*  37) 0x25  '%'  */,
  '\046'	/*  38) 0x26  '&'  */,
  '\047'	/*  39) 0x27  '\'' */,
  '\050'	/*  40) 0x28  '('  */,
  '\051'	/*  41) 0x29  ')'  */,
  '\052'	/*  42) 0x2a  '*'  */,
  '>'		/*  43) 0x2b  '+'  -> ARROW POINTING RIGHT */,
  '<'		/*  44) 0x2c  ','  -> ARROW POINTING LEFT */,
  '^'		/*  45) 0x2d  '-'  -> ARROW POINTING UP */,
  'v'		/*  46) 0x2e  '.'  -> ARROW POINTING DOWN */,
  '\057'	/*  47) 0x2f  '/'  */,
  '\060'	/*  48) 0x30  '0'  */,
  '\061'	/*  49) 0x31  '1'  */,
  '\062'	/*  50) 0x32  '2'  */,
  '\063'	/*  51) 0x33  '3'  */,
  '\064'	/*  52) 0x34  '4'  */,
  '\065'	/*  53) 0x35  '5'  */,
  '\066'	/*  54) 0x36  '6'  */,
  '\067'	/*  55) 0x37  '7'  */,
  '\070'	/*  56) 0x38  '8'  */,
  '\071'	/*  57) 0x39  '9'  */,
  '\072'	/*  58) 0x3a  ':'  */,
  '\073'	/*  59) 0x3b  ';'  */,
  '\074'	/*  60) 0x3c  '<'  */,
  '\075'	/*  61) 0x3d  '='  */,
  '\076'	/*  62) 0x3e  '>'  */,
  '\077'	/*  63) 0x3f  '?'  */,
  '\100'	/*  64) 0x40  '@'  */,
  '\101'	/*  65) 0x41  'A'  */,
  '\102'	/*  66) 0x42  'B'  */,
  '\103'	/*  67) 0x43  'C'  */,
  '\104'	/*  68) 0x44  'D'  */,
  '\105'	/*  69) 0x45  'E'  */,
  '\106'	/*  70) 0x46  'F'  */,
  '\107'	/*  71) 0x47  'G'  */,
  '\110'	/*  72) 0x48  'H'  */,
  '\111'	/*  73) 0x49  'I'  */,
  '\112'	/*  74) 0x4a  'J'  */,
  '\113'	/*  75) 0x4b  'K'  */,
  '\114'	/*  76) 0x4c  'L'  */,
  '\115'	/*  77) 0x4d  'M'  */,
  '\116'	/*  78) 0x4e  'N'  */,
  '\117'	/*  79) 0x4f  'O'  */,
  '\120'	/*  80) 0x50  'P'  */,
  '\121'	/*  81) 0x51  'Q'  */,
  '\122'	/*  82) 0x52  'R'  */,
  '\123'	/*  83) 0x53  'S'  */,
  '\124'	/*  84) 0x54  'T'  */,
  '\125'	/*  85) 0x55  'U'  */,
  '\126'	/*  86) 0x56  'V'  */,
  '\127'	/*  87) 0x57  'W'  */,
  '\130'	/*  88) 0x58  'X'  */,
  '\131'	/*  89) 0x59  'Y'  */,
  '\132'	/*  90) 0x5a  'Z'  */,
  '\133'	/*  91) 0x5b  '['  */,
  '\134'	/*  92) 0x5c  '\'  */,
  '\135'	/*  93) 0x5d  ']'  */,
  '\136'	/*  94) 0x5e  '^'  */,
  ' '		/*  95) 0x5f  '_'  -> SPACE ??? (xterm does this) */,
  '?'		/*  96) 0x60  '`'  -> DIAMOND */,
  '#'		/*  97) 0x61  'a'  -> SOLID SQUARE BLOCK / FULL SQUARE (#) */,
  '?'		/*  98) 0x62  'b'  -> Ht */,
  '?'		/*  99) 0x63  'c'  -> Ff */,
  '?'		/* 100) 0x64  'd'  -> Cr */,
  '?'		/* 101) 0x65  'e'  -> Lf */,
  0xb0		/* 102) 0x66  'f'  -> DEGREE SYMBOL () */,
  0xb1		/* 103) 0x67  'g'  -> PLUS-MINUS */,
  '?'		/* 104) 0x68  'h'  -> Nl */,
  '?'		/* 105) 0x69  'i'  -> Vt */,
  '+'		/* 106) 0x6a  'j'  -> RIGHT BOTTOM CORNER */,
  '+'		/* 107) 0x6b  'k'  -> RIGHT UPPER CORNER */,
  '+'		/* 108) 0x6c  'l'  -> LEFT UPPER CORNER */,
  '+'		/* 109) 0x6d  'm'  -> LEFT BOTTOM CORNER */,
  '+'		/* 110) 0x6e  'n'  -> CROSS */,
  '~'		/* 111) 0x6f  'o'  -> UPPER HORIZONTAL LINE */,
  '?'		/* 112) 0x70  'p'  -> UPPER HORIZONTAL LINE - 1 */,
  '-'		/* 113) 0x71  'q'  -> MIDDLE HORIZONTAL LINE */,
  '?'		/* 114) 0x72  'r'  -> BOTTOM HORIZONTAL LINE + 1 */,
  '_'		/* 115) 0x73  's'  -> BOTTOM HORIZONTAL LINE */,
  '+'		/* 116) 0x74  't'  -> LEFT TEE */,
  '+'		/* 117) 0x75  'u'  -> RIGHT TEE */,
  '+'		/* 118) 0x76  'v'  -> BOTTOM TEE */,
  '+'		/* 119) 0x77  'w'  -> NORMAL TEE */,
  '|'		/* 120) 0x78  'x'  -> VERTICAL LINE */,
  '?'		/* 121) 0x79  'y'  -> LESS-OR-EQUAL ??? */,
  '?'		/* 122) 0x7a  'z'  -> GREATER-OR-EQUAL ??? */,
  '?'		/* 123) 0x7b  '{'  -> PI ??? */,
  '?'		/* 124) 0x7c  '|'  -> UNEQUAL ??? */,
  0xa3		/* 125) 0x7d  '}'  -> POUND ??? */,
  '?'		/* 126) 0x7e  '~'  -> MIDDLE DOT ??? (xterm does this) */,
  '\177'	/* 127) 0x7f  DEL  */,
  '\200'	/* 128) 0x80	   */,
  '\201'	/* 129) 0x81	   */,
  '\202'	/* 130) 0x82	   */,
  '\203'	/* 131) 0x83	   */,
  '\204'	/* 132) 0x84	   */,
  '\205'	/* 133) 0x85	   */,
  '\206'	/* 134) 0x86	   */,
  '\207'	/* 135) 0x87	   */,
  '\210'	/* 136) 0x88	   */,
  '\211'	/* 137) 0x89	   */,
  '\212'	/* 138) 0x8a	   */,
  '\213'	/* 139) 0x8b	   */,
  '\214'	/* 140) 0x8c	   */,
  '\215'	/* 141) 0x8d	   */,
  '\216'	/* 142) 0x8e	   */,
  '\217'	/* 143) 0x8f	   */,
  '\220'	/* 144) 0x90	   */,
  '\221'	/* 145) 0x91	   */,
  '\222'	/* 146) 0x92	   */,
  '\223'	/* 147) 0x93	   */,
  '\224'	/* 148) 0x94	   */,
  '\225'	/* 149) 0x95	   */,
  '\226'	/* 150) 0x96	   */,
  '\227'	/* 151) 0x97	   */,
  '\230'	/* 152) 0x98	   */,
  '\231'	/* 153) 0x99	   */,
  '\232'	/* 154) 0x9a	   */,
  '\233'	/* 155) 0x9b	   */,
  '\234'	/* 156) 0x9c	   */,
  '\235'	/* 157) 0x9d	   */,
  '\236'	/* 158) 0x9e	   */,
  '\237'	/* 159) 0x9f	   */,
  '\240'	/* 160) 0xa0	   */,
  '\241'	/* 161) 0xa1	   */,
  '\242'	/* 162) 0xa2	   */,
  '\243'	/* 163) 0xa3	   */,
  '\244'	/* 164) 0xa4	   */,
  '\245'	/* 165) 0xa5	   */,
  '\246'	/* 166) 0xa6	   */,
  '\247'	/* 167) 0xa7	   */,
  '\250'	/* 168) 0xa8	   */,
  '\251'	/* 169) 0xa9	   */,
  '\252'	/* 170) 0xaa	   */,
  '\253'	/* 171) 0xab	   */,
  '\254'	/* 172) 0xac	   */,
  '\255'	/* 173) 0xad	   */,
  '\256'	/* 174) 0xae	   */,
  '\257'	/* 175) 0xaf	   */,
  '\260'	/* 176) 0xb0	   */,
  '\261'	/* 177) 0xb1	   */,
  '\262'	/* 178) 0xb2	   */,
  '\263'	/* 179) 0xb3	   */,
  '\264'	/* 180) 0xb4	   */,
  '\265'	/* 181) 0xb5	   */,
  '\266'	/* 182) 0xb6	   */,
  '\267'	/* 183) 0xb7	   */,
  '\270'	/* 184) 0xb8	   */,
  '\271'	/* 185) 0xb9	   */,
  '\272'	/* 186) 0xba	   */,
  '\273'	/* 187) 0xbb	   */,
  '\274'	/* 188) 0xbc	   */,
  '\275'	/* 189) 0xbd	   */,
  '\276'	/* 190) 0xbe	   */,
  '\277'	/* 191) 0xbf	   */,
  '\300'	/* 192) 0xc0	   */,
  '\301'	/* 193) 0xc1	   */,
  '\302'	/* 194) 0xc2	   */,
  '\303'	/* 195) 0xc3	   */,
  '\304'	/* 196) 0xc4	   */,
  '\305'	/* 197) 0xc5	   */,
  '\306'	/* 198) 0xc6	   */,
  '\307'	/* 199) 0xc7	   */,
  '\310'	/* 200) 0xc8	   */,
  '\311'	/* 201) 0xc9	   */,
  '\312'	/* 202) 0xca	   */,
  '\313'	/* 203) 0xcb	   */,
  '\314'	/* 204) 0xcc	   */,
  '\315'	/* 205) 0xcd	   */,
  '\316'	/* 206) 0xce	   */,
  '\317'	/* 207) 0xcf	   */,
  '\320'	/* 208) 0xd0	   */,
  '\321'	/* 209) 0xd1	   */,
  '\322'	/* 210) 0xd2	   */,
  '\323'	/* 211) 0xd3	   */,
  '\324'	/* 212) 0xd4	   */,
  '\325'	/* 213) 0xd5	   */,
  '\326'	/* 214) 0xd6	   */,
  '\327'	/* 215) 0xd7	   */,
  '\330'	/* 216) 0xd8	   */,
  '\331'	/* 217) 0xd9	   */,
  '\332'	/* 218) 0xda	   */,
  '\333'	/* 219) 0xdb	   */,
  '\334'	/* 220) 0xdc	   */,
  '\335'	/* 221) 0xdd	   */,
  '\336'	/* 222) 0xde	   */,
  '\337'	/* 223) 0xdf	   */,
  '\340'	/* 224) 0xe0	   */,
  '\341'	/* 225) 0xe1	   */,
  '\342'	/* 226) 0xe2	   */,
  '\343'	/* 227) 0xe3	   */,
  '\344'	/* 228) 0xe4	   */,
  '\345'	/* 229) 0xe5	   */,
  '\346'	/* 230) 0xe6	   */,
  '\347'	/* 231) 0xe7	   */,
  '\350'	/* 232) 0xe8	   */,
  '\351'	/* 233) 0xe9	   */,
  '\352'	/* 234) 0xea	   */,
  '\353'	/* 235) 0xeb	   */,
  '\354'	/* 236) 0xec	   */,
  '\355'	/* 237) 0xed	   */,
  '\356'	/* 238) 0xee	   */,
  '\357'	/* 239) 0xef	   */,
  '\360'	/* 240) 0xf0	   */,
  '\361'	/* 241) 0xf1	   */,
  '\362'	/* 242) 0xf2	   */,
  '\363'	/* 243) 0xf3	   */,
  '\364'	/* 244) 0xf4	   */,
  '\365'	/* 245) 0xf5	   */,
  '\366'	/* 246) 0xf6	   */,
  '\367'	/* 247) 0xf7	   */,
  '\370'	/* 248) 0xf8	   */,
  '\371'	/* 249) 0xf9	   */,
  '\372'	/* 250) 0xfa	   */,
  '\373'	/* 251) 0xfb	   */,
  '\374'	/* 252) 0xfc	   */,
  '\375'	/* 253) 0xfd	   */,
  '\376'	/* 254) 0xfe	   */,
  '\377'	/* 255) 0xff	   */,
};
