dnl
dnl GNOME_INIT_HOOK (script-if-gnome-enabled, failflag)
dnl
dnl if failflag is "fail" then GNOME_INIT_HOOK will abort if gnomeConf.sh
dnl is not found. 
dnl

AC_DEFUN([GNOME_INIT_HOOK],
[	
	AC_SUBST(GNOME_LIBS)
	AC_SUBST(GNOMEUI_LIBS)
	AC_SUBST(GTKXMHTML_LIBS)
	AC_SUBST(GNOME_LIBDIR)
	AC_SUBST(GNOME_INCLUDEDIR)

	if test x$exec_prefix = xNONE; then
	    if test x$prefix = xNONE; then
	        gnome_prefix=$ac_default_prefix/lib
	    else
		gnome_prefix=$prefix/lib
	    fi
	else
	    gnome_prefix=`eval echo \`echo $libdir\``
	fi

	AC_ARG_WITH(gnome-includes,
	[  --with-gnome-includes   Specify location of GNOME headers],[
	CFLAGS="$CFLAGS -I$withval"
	])

	AC_ARG_WITH(gnome-libs,
	[  --with-gnome-libs       Specify location of GNOME libs],[
	LDFLAGS="$LDFLAGS -L$withval"
	gnome_prefix=$withval
	])

	AC_ARG_WITH(gnome,
	[  --with-gnome            Specify prefix for GNOME files],[
	if test x$withval = xyes; then
	    dnl Note that an empty true branch is not valid sh syntax.
	    ifelse([$1], [], :, [$1])
        else
	    LDFLAGS="$LDFLAGS -L$withval/lib"
	    CFLAGS="$CFLAGS -I$withval/include"
	    gnome_prefix=$withval/lib
  	fi
	])

        AC_MSG_CHECKING(for gnomeConf.sh file in $gnome_prefix)
	if test -f $gnome_prefix/gnomeConf.sh; then
	    AC_MSG_RESULT(found)
	    echo "loading gnome configuration from $gnome_prefix/gnomeConf.sh"
	    . $gnome_prefix/gnomeConf.sh
	    $1
	else
	    AC_MSG_RESULT(not found)
 	    if test x$2 = xfail; then
	        AC_MSG_ERROR(Could not find the gnomeConf.sh file that is generated by gnome-libs install)
 	    fi
	fi
])

AC_DEFUN([GNOME_INIT],[
	GNOME_INIT_HOOK([],fail)
])
