/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);
static GType vala_local_variable_get_type_once (void);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaSemanticAnalyzer* _tmp60_;
	ValaSemanticAnalyzer* _tmp61_;
	ValaSymbol* _tmp62_;
	ValaSymbol* _tmp63_;
	ValaScope* _tmp64_;
	ValaScope* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	gboolean _tmp133_;
	gboolean _tmp134_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp148_;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean _tmp151_ = FALSE;
	ValaArrayType* _tmp152_;
	gboolean _tmp164_ = FALSE;
	gboolean _tmp165_ = FALSE;
	gboolean _tmp166_ = FALSE;
	ValaArrayType* _tmp167_;
	gboolean _tmp178_ = FALSE;
	ValaExpression* _tmp179_;
	ValaExpression* _tmp180_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp321_;
	ValaSemanticAnalyzer* _tmp322_;
	ValaSymbol* _tmp323_;
	ValaSymbol* _tmp324_;
	ValaBlock* _tmp325_;
	gboolean _tmp327_;
	gboolean _tmp328_;
	gboolean result;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaVarType* _tmp6_;
		ValaVarType* _tmp7_;
		_tmp6_ = vala_var_type_new (TRUE);
		_tmp7_ = _tmp6_;
		vala_variable_set_variable_type ((ValaVariable*) self, (ValaDataType*) _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	_tmp8_ = vala_code_context_get_experimental_non_null (context);
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_REFERENCE_TYPE (_tmp11_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaArrayType* _tmp15_;
			_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp13_ = _tmp12_;
			array_type = VALA_IS_ARRAY_TYPE (_tmp13_) ? ((ValaArrayType*) _tmp13_) : NULL;
			_tmp15_ = array_type;
			if (_tmp15_ != NULL) {
				ValaArrayType* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = array_type;
				_tmp17_ = vala_array_type_get_fixed_length (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
			} else {
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp20_ = _tmp19_;
				vala_data_type_set_nullable (_tmp20_, TRUE);
			}
		}
	}
	_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp22_ = _tmp21_;
	if (!VALA_IS_VAR_TYPE (_tmp22_)) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp24_ = _tmp23_;
		if (VALA_IS_VOID_TYPE (_tmp24_)) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "'void' not supported as variable type");
		} else {
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			_tmp27_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp28_ = _tmp27_;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp28_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		}
		_tmp29_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		if (!_tmp30_) {
			ValaSemanticAnalyzer* _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			_tmp31_ = vala_code_context_get_analyzer (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp34_ = _tmp33_;
			vala_semantic_analyzer_check_type (_tmp32_, _tmp34_);
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp36_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp38_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp39_ = _tmp38_;
		_tmp35_ = !_tmp39_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp50_;
		ValaExpression* _tmp51_;
		_tmp40_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp43_ = _tmp42_;
		vala_expression_set_target_type (_tmp41_, _tmp43_);
		_tmp44_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp45_ = _tmp44_;
		if (VALA_IS_INITIALIZER_LIST (_tmp45_)) {
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			_tmp46_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp49_ = _tmp48_;
			initializer_size = _tmp49_;
			is_initializer_list = TRUE;
		}
		_tmp50_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp51_ = _tmp50_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp51_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		} else {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			if (VALA_IS_VOID_TYPE (_tmp55_)) {
				ValaExpression* _tmp56_;
				ValaExpression* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				vala_report_error (_tmp59_, "'void' not supported as initializer type");
			}
		}
	}
	_tmp60_ = vala_code_context_get_analyzer (context);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_semantic_analyzer_get_current_symbol (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_symbol_get_scope (_tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp67_ = _tmp66_;
	vala_scope_add (_tmp65_, _tmp67_, (ValaSymbol*) self);
	_tmp68_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp69_ = _tmp68_;
	if (_tmp69_) {
		result = FALSE;
		return result;
	}
	_tmp70_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp71_ = _tmp70_;
	if (VALA_IS_VAR_TYPE (_tmp71_)) {
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp76_;
		ValaExpression* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		gboolean _tmp82_ = FALSE;
		ValaExpression* _tmp83_;
		ValaExpression* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		gboolean nullable = FALSE;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		gboolean _tmp103_;
		gboolean _tmp104_;
		gboolean value_owned = FALSE;
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		gboolean _tmp107_;
		gboolean _tmp108_;
		gboolean is_dynamic = FALSE;
		ValaDataType* _tmp109_;
		ValaDataType* _tmp110_;
		gboolean _tmp111_;
		gboolean _tmp112_;
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaDataType* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaDataType* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaDataType* _tmp129_;
		ValaDataType* _tmp130_;
		ValaDataType* _tmp131_;
		ValaDataType* _tmp132_;
		_tmp72_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp73_ = _tmp72_;
		if (_tmp73_ == NULL) {
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp75_ = _tmp74_;
			vala_report_error (_tmp75_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_expression_get_value_type (_tmp77_);
		_tmp79_ = _tmp78_;
		if (_tmp79_ == NULL) {
			ValaSourceReference* _tmp80_;
			ValaSourceReference* _tmp81_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp81_ = _tmp80_;
			vala_report_error (_tmp81_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp83_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_expression_get_value_type (_tmp84_);
		_tmp86_ = _tmp85_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp86_)) {
			_tmp82_ = TRUE;
		} else {
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			ValaDataType* _tmp89_;
			ValaDataType* _tmp90_;
			_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_expression_get_value_type (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp82_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp90_);
		}
		if (_tmp82_) {
			ValaExpression* _tmp91_;
			ValaExpression* _tmp92_;
			ValaSourceReference* _tmp93_;
			ValaSourceReference* _tmp94_;
			ValaExpression* _tmp95_;
			ValaExpression* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp91_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_expression_get_symbol_reference (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = vala_symbol_get_full_name (_tmp98_);
			_tmp100_ = _tmp99_;
			vala_report_error (_tmp94_, "Access to instance member `%s' denied", _tmp100_);
			_g_free0 (_tmp100_);
			result = FALSE;
			return result;
		}
		_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_data_type_get_nullable (_tmp102_);
		_tmp104_ = _tmp103_;
		nullable = _tmp104_;
		_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_data_type_get_value_owned (_tmp106_);
		_tmp108_ = _tmp107_;
		value_owned = _tmp108_;
		_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_data_type_get_is_dynamic (_tmp110_);
		_tmp112_ = _tmp111_;
		is_dynamic = _tmp112_;
		_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_expression_get_value_type (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_data_type_copy (_tmp116_);
		_tmp118_ = _tmp117_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp118_);
		_vala_code_node_unref0 (_tmp118_);
		_tmp119_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp120_ = _tmp119_;
		vala_data_type_set_value_owned (_tmp120_, value_owned);
		_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp122_ = _tmp121_;
		vala_data_type_set_floating_reference (_tmp122_, FALSE);
		if (nullable) {
			ValaDataType* _tmp123_;
			ValaDataType* _tmp124_;
			_tmp123_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp124_ = _tmp123_;
			vala_data_type_set_nullable (_tmp124_, TRUE);
		}
		if (is_dynamic) {
			ValaDataType* _tmp125_;
			ValaDataType* _tmp126_;
			_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp126_ = _tmp125_;
			vala_data_type_set_is_dynamic (_tmp126_, TRUE);
		}
		_tmp127_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		vala_expression_set_target_type (_tmp128_, _tmp130_);
		_tmp131_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp132_ = _tmp131_;
		vala_code_node_check ((ValaCodeNode*) _tmp132_, context);
	}
	_tmp133_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp134_ = _tmp133_;
	if (!_tmp134_) {
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		ValaTypeSymbol* _tmp137_;
		ValaTypeSymbol* _tmp138_;
		_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_data_type_get_type_symbol (_tmp136_);
		_tmp138_ = _tmp137_;
		if (_tmp138_ != NULL) {
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			ValaTypeSymbol* _tmp141_;
			ValaTypeSymbol* _tmp142_;
			ValaVersionAttribute* _tmp143_;
			ValaVersionAttribute* _tmp144_;
			ValaSourceReference* _tmp145_;
			ValaSourceReference* _tmp146_;
			_tmp139_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_data_type_get_type_symbol (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_symbol_get_version ((ValaSymbol*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp146_ = _tmp145_;
			vala_version_attribute_check (_tmp144_, context, _tmp146_);
		}
	}
	_tmp147_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp148_ = _tmp147_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp148_) ? ((ValaArrayType*) _tmp148_) : NULL;
	_tmp152_ = variable_array_type;
	if (_tmp152_ != NULL) {
		ValaArrayType* _tmp153_;
		gboolean _tmp154_;
		gboolean _tmp155_;
		_tmp153_ = variable_array_type;
		_tmp154_ = vala_array_type_get_inline_allocated (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp151_ = _tmp155_;
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		ValaExpression* _tmp156_;
		ValaExpression* _tmp157_;
		_tmp156_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp157_ = _tmp156_;
		_tmp150_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp157_);
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		ValaExpression* _tmp158_;
		ValaExpression* _tmp159_;
		ValaInitializerList* _tmp160_;
		ValaInitializerList* _tmp161_;
		_tmp158_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp161_ = _tmp160_;
		_tmp149_ = _tmp161_ == NULL;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValaSourceReference* _tmp162_;
		ValaSourceReference* _tmp163_;
		_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp163_ = _tmp162_;
		vala_report_warning (_tmp163_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp167_ = variable_array_type;
	if (_tmp167_ != NULL) {
		ValaArrayType* _tmp168_;
		gboolean _tmp169_;
		gboolean _tmp170_;
		_tmp168_ = variable_array_type;
		_tmp169_ = vala_array_type_get_inline_allocated (_tmp168_);
		_tmp170_ = _tmp169_;
		_tmp166_ = _tmp170_;
	} else {
		_tmp166_ = FALSE;
	}
	if (_tmp166_) {
		ValaArrayType* _tmp171_;
		ValaExpression* _tmp172_;
		ValaExpression* _tmp173_;
		_tmp171_ = variable_array_type;
		_tmp172_ = vala_array_type_get_length (_tmp171_);
		_tmp173_ = _tmp172_;
		_tmp165_ = _tmp173_ == NULL;
	} else {
		_tmp165_ = FALSE;
	}
	if (_tmp165_) {
		ValaExpression* _tmp174_;
		ValaExpression* _tmp175_;
		_tmp174_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp175_ = _tmp174_;
		_tmp164_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp175_);
	} else {
		_tmp164_ = FALSE;
	}
	if (_tmp164_) {
		ValaSourceReference* _tmp176_;
		ValaSourceReference* _tmp177_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp177_ = _tmp176_;
		vala_report_error (_tmp177_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp180_ = _tmp179_;
	if (_tmp180_ != NULL) {
		ValaExpression* _tmp181_;
		ValaExpression* _tmp182_;
		gboolean _tmp183_;
		gboolean _tmp184_;
		_tmp181_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp182_ = _tmp181_;
		_tmp183_ = vala_code_node_get_error ((ValaCodeNode*) _tmp182_);
		_tmp184_ = _tmp183_;
		_tmp178_ = !_tmp184_;
	} else {
		_tmp178_ = FALSE;
	}
	if (_tmp178_) {
		ValaExpression* _tmp185_;
		ValaExpression* _tmp186_;
		ValaDataType* _tmp187_;
		ValaDataType* _tmp188_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaDataType* _tmp236_;
		ValaDataType* _tmp237_;
		ValaDataType* _tmp238_;
		ValaDataType* _tmp239_;
		gboolean _tmp279_ = FALSE;
		gboolean _tmp280_ = FALSE;
		gboolean _tmp281_ = FALSE;
		ValaArrayType* _tmp282_;
		gboolean _tmp296_ = FALSE;
		gboolean _tmp297_ = FALSE;
		ValaArrayType* _tmp298_;
		ValaExpression* _tmp308_;
		ValaExpression* _tmp309_;
		ValaDataType* _tmp310_;
		ValaDataType* _tmp311_;
		_tmp185_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_expression_get_value_type (_tmp186_);
		_tmp188_ = _tmp187_;
		if (VALA_IS_METHOD_TYPE (_tmp188_)) {
			gboolean _tmp189_ = FALSE;
			ValaExpression* _tmp190_;
			ValaExpression* _tmp191_;
			ValaDataType* _tmp198_;
			ValaDataType* _tmp199_;
			_tmp190_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp191_ = _tmp190_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp191_)) {
				ValaExpression* _tmp192_;
				ValaExpression* _tmp193_;
				_tmp192_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp193_ = _tmp192_;
				_tmp189_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp193_);
			} else {
				_tmp189_ = FALSE;
			}
			if (_tmp189_) {
				ValaExpression* _tmp194_;
				ValaExpression* _tmp195_;
				ValaSourceReference* _tmp196_;
				ValaSourceReference* _tmp197_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp194_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp195_);
				_tmp197_ = _tmp196_;
				vala_report_error (_tmp197_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp198_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp199_ = _tmp198_;
			if (VALA_IS_DELEGATE_TYPE (_tmp199_)) {
				ValaExpression* _tmp200_;
				ValaExpression* _tmp201_;
				ValaDataType* _tmp202_;
				ValaDataType* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				_tmp200_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_expression_get_value_type (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp205_ = _tmp204_;
				if (!vala_data_type_compatible (_tmp203_, _tmp205_)) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaSymbol* _tmp208_;
					ValaSymbol* _tmp209_;
					ValaDelegate* cb = NULL;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					ValaDelegate* _tmp212_;
					ValaDelegate* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaMethod* _tmp216_;
					gchar* _tmp217_;
					gchar* _tmp218_;
					ValaDelegate* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					_tmp206_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_symbol_reference (_tmp207_);
					_tmp209_ = _tmp208_;
					m = G_TYPE_CHECK_INSTANCE_CAST (_tmp209_, VALA_TYPE_METHOD, ValaMethod);
					_tmp210_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp213_ = _tmp212_;
					cb = _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = m;
					_tmp217_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = cb;
					_tmp220_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp219_);
					_tmp221_ = _tmp220_;
					vala_report_error (_tmp215_, "Declaration of method `%s' is not compatible with delegate `%s'", _tmp218_, _tmp221_);
					_g_free0 (_tmp221_);
					_g_free0 (_tmp218_);
					result = FALSE;
					return result;
				}
			} else {
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaSourceReference* _tmp224_;
				ValaSourceReference* _tmp225_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp222_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp223_ = _tmp222_;
				_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp223_);
				_tmp225_ = _tmp224_;
				vala_report_error (_tmp225_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		} else {
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			ValaDataType* _tmp228_;
			ValaDataType* _tmp229_;
			_tmp226_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp227_ = _tmp226_;
			_tmp228_ = vala_expression_get_value_type (_tmp227_);
			_tmp229_ = _tmp228_;
			if (_tmp229_ == NULL) {
				ValaExpression* _tmp230_;
				ValaExpression* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp230_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp231_ = _tmp230_;
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp231_);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp234_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_expression_get_value_type (_tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp239_ = _tmp238_;
		if (!vala_data_type_compatible (_tmp237_, _tmp239_)) {
			ValaSourceReference* _tmp240_;
			ValaSourceReference* _tmp241_;
			ValaExpression* _tmp242_;
			ValaExpression* _tmp243_;
			ValaDataType* _tmp244_;
			ValaDataType* _tmp245_;
			gchar* _tmp246_;
			gchar* _tmp247_;
			ValaDataType* _tmp248_;
			ValaDataType* _tmp249_;
			gchar* _tmp250_;
			gchar* _tmp251_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp241_ = _tmp240_;
			_tmp242_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp243_ = _tmp242_;
			_tmp244_ = vala_expression_get_value_type (_tmp243_);
			_tmp245_ = _tmp244_;
			_tmp246_ = vala_code_node_to_string ((ValaCodeNode*) _tmp245_);
			_tmp247_ = _tmp246_;
			_tmp248_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_to_string ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			vala_report_error (_tmp241_, "Assignment: Cannot convert from `%s' to `%s'", _tmp247_, _tmp251_);
			_g_free0 (_tmp251_);
			_g_free0 (_tmp247_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp252_ = FALSE;
			gboolean _tmp253_ = FALSE;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			_tmp254_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp255_ = _tmp254_;
			if (VALA_IS_ENUM_VALUE_TYPE (_tmp255_)) {
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				_tmp256_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				_tmp253_ = VALA_IS_INTEGER_TYPE (_tmp259_);
			} else {
				_tmp253_ = FALSE;
			}
			if (_tmp253_) {
				gboolean _tmp260_ = FALSE;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				_tmp261_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp262_ = _tmp261_;
				if (!VALA_IS_INTEGER_LITERAL (_tmp262_)) {
					_tmp260_ = TRUE;
				} else {
					ValaExpression* _tmp263_;
					ValaExpression* _tmp264_;
					const gchar* _tmp265_;
					const gchar* _tmp266_;
					_tmp263_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
					_tmp266_ = _tmp265_;
					_tmp260_ = g_strcmp0 (_tmp266_, "0") != 0;
				}
				_tmp252_ = _tmp260_;
			} else {
				_tmp252_ = FALSE;
			}
			if (_tmp252_) {
				ValaSourceReference* _tmp267_;
				ValaSourceReference* _tmp268_;
				ValaExpression* _tmp269_;
				ValaExpression* _tmp270_;
				ValaDataType* _tmp271_;
				ValaDataType* _tmp272_;
				gchar* _tmp273_;
				gchar* _tmp274_;
				ValaDataType* _tmp275_;
				ValaDataType* _tmp276_;
				gchar* _tmp277_;
				gchar* _tmp278_;
				_tmp267_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_expression_get_value_type (_tmp270_);
				_tmp272_ = _tmp271_;
				_tmp273_ = vala_code_node_to_string ((ValaCodeNode*) _tmp272_);
				_tmp274_ = _tmp273_;
				_tmp275_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp276_ = _tmp275_;
				_tmp277_ = vala_code_node_to_string ((ValaCodeNode*) _tmp276_);
				_tmp278_ = _tmp277_;
				vala_report_notice (_tmp268_, "Assignment: Unsafe conversion from `%s' to `%s'", _tmp274_, _tmp278_);
				_g_free0 (_tmp278_);
				_g_free0 (_tmp274_);
			}
		}
		_tmp282_ = variable_array_type;
		if (_tmp282_ != NULL) {
			ValaArrayType* _tmp283_;
			gboolean _tmp284_;
			gboolean _tmp285_;
			_tmp283_ = variable_array_type;
			_tmp284_ = vala_array_type_get_inline_allocated (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp281_ = _tmp285_;
		} else {
			_tmp281_ = FALSE;
		}
		if (_tmp281_) {
			ValaArrayType* _tmp286_;
			gboolean _tmp287_;
			gboolean _tmp288_;
			_tmp286_ = variable_array_type;
			_tmp287_ = vala_array_type_get_fixed_length (_tmp286_);
			_tmp288_ = _tmp287_;
			_tmp280_ = !_tmp288_;
		} else {
			_tmp280_ = FALSE;
		}
		if (_tmp280_) {
			_tmp279_ = is_initializer_list;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			ValaArrayType* _tmp289_;
			gchar* _tmp290_;
			gchar* _tmp291_;
			ValaIntegerLiteral* _tmp292_;
			ValaIntegerLiteral* _tmp293_;
			ValaArrayType* _tmp294_;
			ValaArrayType* _tmp295_;
			_tmp289_ = variable_array_type;
			_tmp290_ = g_strdup_printf ("%i", initializer_size);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_integer_literal_new (_tmp291_, NULL);
			_tmp293_ = _tmp292_;
			vala_array_type_set_length (_tmp289_, (ValaExpression*) _tmp293_);
			_vala_code_node_unref0 (_tmp293_);
			_g_free0 (_tmp291_);
			_tmp294_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp294_, TRUE);
			_tmp295_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp295_, FALSE);
		}
		_tmp298_ = variable_array_type;
		if (_tmp298_ != NULL) {
			ValaArrayType* _tmp299_;
			gboolean _tmp300_;
			gboolean _tmp301_;
			_tmp299_ = variable_array_type;
			_tmp300_ = vala_array_type_get_inline_allocated (_tmp299_);
			_tmp301_ = _tmp300_;
			_tmp297_ = _tmp301_;
		} else {
			_tmp297_ = FALSE;
		}
		if (_tmp297_) {
			ValaExpression* _tmp302_;
			ValaExpression* _tmp303_;
			ValaDataType* _tmp304_;
			ValaDataType* _tmp305_;
			_tmp302_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp303_ = _tmp302_;
			_tmp304_ = vala_expression_get_value_type (_tmp303_);
			_tmp305_ = _tmp304_;
			_tmp296_ = VALA_IS_ARRAY_TYPE (_tmp305_) == FALSE;
		} else {
			_tmp296_ = FALSE;
		}
		if (_tmp296_) {
			ValaSourceReference* _tmp306_;
			ValaSourceReference* _tmp307_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp306_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp307_ = _tmp306_;
			vala_report_error (_tmp307_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp308_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = vala_expression_get_value_type (_tmp309_);
		_tmp311_ = _tmp310_;
		if (vala_data_type_is_disposable (_tmp311_)) {
			gboolean _tmp312_ = FALSE;
			ValaDataType* _tmp313_;
			ValaDataType* _tmp314_;
			_tmp313_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp314_ = _tmp313_;
			if (!VALA_IS_POINTER_TYPE (_tmp314_)) {
				ValaDataType* _tmp315_;
				ValaDataType* _tmp316_;
				gboolean _tmp317_;
				gboolean _tmp318_;
				_tmp315_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_data_type_get_value_owned (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp312_ = !_tmp318_;
			} else {
				_tmp312_ = FALSE;
			}
			if (_tmp312_) {
				ValaSourceReference* _tmp319_;
				ValaSourceReference* _tmp320_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp320_ = _tmp319_;
				vala_report_error (_tmp320_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp321_ = vala_code_context_get_analyzer (context);
	_tmp322_ = _tmp321_;
	_tmp323_ = vala_semantic_analyzer_get_current_symbol (_tmp322_);
	_tmp324_ = _tmp323_;
	block = VALA_IS_BLOCK (_tmp324_) ? ((ValaBlock*) _tmp324_) : NULL;
	_tmp325_ = block;
	if (_tmp325_ != NULL) {
		ValaBlock* _tmp326_;
		_tmp326_ = block;
		vala_block_add_local_variable (_tmp326_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp327_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp328_ = _tmp327_;
	result = !_tmp328_;
	return result;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
static GType
vala_local_variable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
	GType vala_local_variable_type_id;
	vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
	ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
	return vala_local_variable_type_id;
}

GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__once = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__once)) {
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = vala_local_variable_get_type_once ();
		g_once_init_leave (&vala_local_variable_type_id__once, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__once;
}

