/* ide-editor-utils.h
 *
 * Copyright 2020 Christian Hergert <chergert@redhat.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#if !defined (IDE_EDITOR_INSIDE) && !defined (IDE_EDITOR_COMPILATION)
# error "Only <libide-editor.h> can be included directly."
#endif

#include <gtksourceview/gtksource.h>

#include <libide-core.h>

G_BEGIN_DECLS

void                     ide_editor_file_chooser_add_encodings     (GtkFileChooser       *chooser);
void                     ide_editor_file_chooser_add_line_endings  (GtkFileChooser       *chooser,
                                                                    GtkSourceNewlineType  selected);
const GtkSourceEncoding *ide_editor_file_chooser_get_encoding      (GtkFileChooser       *chooser);
GtkSourceNewlineType     ide_editor_file_chooser_get_line_ending   (GtkFileChooser       *chooser);
GMenuModel              *ide_editor_encoding_menu_new              (const char           *action_name);
GMenuModel              *ide_editor_syntax_menu_new                (const char           *action_name);

G_END_DECLS
