// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "AdwClampLayout")]
    pub struct ClampLayout(Object<ffi::AdwClampLayout, ffi::AdwClampLayoutClass>) @extends gtk::LayoutManager, @implements gtk::Orientable;

    match fn {
        type_ => || ffi::adw_clamp_layout_get_type(),
    }
}

impl ClampLayout {
    #[doc(alias = "adw_clamp_layout_new")]
    pub fn new() -> ClampLayout {
        assert_initialized_main_thread!();
        unsafe { gtk::LayoutManager::from_glib_full(ffi::adw_clamp_layout_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ClampLayout`] objects.
    ///
    /// This method returns an instance of [`ClampLayoutBuilder`](crate::builders::ClampLayoutBuilder) which can be used to create [`ClampLayout`] objects.
    pub fn builder() -> ClampLayoutBuilder {
        ClampLayoutBuilder::default()
    }

    #[doc(alias = "adw_clamp_layout_get_maximum_size")]
    #[doc(alias = "get_maximum_size")]
    pub fn maximum_size(&self) -> i32 {
        unsafe { ffi::adw_clamp_layout_get_maximum_size(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_clamp_layout_get_tightening_threshold")]
    #[doc(alias = "get_tightening_threshold")]
    pub fn tightening_threshold(&self) -> i32 {
        unsafe { ffi::adw_clamp_layout_get_tightening_threshold(self.to_glib_none().0) }
    }

    #[doc(alias = "adw_clamp_layout_set_maximum_size")]
    pub fn set_maximum_size(&self, maximum_size: i32) {
        unsafe {
            ffi::adw_clamp_layout_set_maximum_size(self.to_glib_none().0, maximum_size);
        }
    }

    #[doc(alias = "adw_clamp_layout_set_tightening_threshold")]
    pub fn set_tightening_threshold(&self, tightening_threshold: i32) {
        unsafe {
            ffi::adw_clamp_layout_set_tightening_threshold(
                self.to_glib_none().0,
                tightening_threshold,
            );
        }
    }

    #[doc(alias = "maximum-size")]
    pub fn connect_maximum_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_maximum_size_trampoline<F: Fn(&ClampLayout) + 'static>(
            this: *mut ffi::AdwClampLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::maximum-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_maximum_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tightening-threshold")]
    pub fn connect_tightening_threshold_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_tightening_threshold_trampoline<
            F: Fn(&ClampLayout) + 'static,
        >(
            this: *mut ffi::AdwClampLayout,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tightening-threshold\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tightening_threshold_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for ClampLayout {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ClampLayout`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ClampLayoutBuilder {
    maximum_size: Option<i32>,
    tightening_threshold: Option<i32>,
    orientation: Option<gtk::Orientation>,
}

impl ClampLayoutBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`ClampLayoutBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ClampLayout`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ClampLayout {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref maximum_size) = self.maximum_size {
            properties.push(("maximum-size", maximum_size));
        }
        if let Some(ref tightening_threshold) = self.tightening_threshold {
            properties.push(("tightening-threshold", tightening_threshold));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<ClampLayout>(&properties)
            .expect("Failed to create an instance of ClampLayout")
    }

    pub fn maximum_size(mut self, maximum_size: i32) -> Self {
        self.maximum_size = Some(maximum_size);
        self
    }

    pub fn tightening_threshold(mut self, tightening_threshold: i32) -> Self {
        self.tightening_threshold = Some(tightening_threshold);
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

impl fmt::Display for ClampLayout {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ClampLayout")
    }
}
