/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	gboolean _null_safe_access;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

gboolean
vala_member_access_get_null_safe_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_null_safe_access;
	return result;
}

void
vala_member_access_set_null_safe_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_null_safe_access = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp708_ = FALSE;
	gboolean _tmp709_ = FALSE;
	gboolean _tmp710_ = FALSE;
	ValaExpression* _tmp711_;
	ValaExpression* _tmp712_;
	ValaSymbol* _tmp739_;
	ValaSymbol* _tmp740_;
	ValaSymbol* _tmp809_;
	ValaSymbol* _tmp810_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp846_;
	ValaSymbol* _tmp847_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp848_;
	ValaSymbol* _tmp849_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1297_;
	ValaSymbol* _tmp1298_;
	ValaSymbol* _tmp1300_;
	ValaVersionAttribute* _tmp1301_;
	ValaVersionAttribute* _tmp1302_;
	ValaSourceReference* _tmp1303_;
	ValaSourceReference* _tmp1304_;
	gboolean _tmp1305_ = FALSE;
	gboolean _tmp1356_ = FALSE;
	gboolean _tmp1383_ = FALSE;
	gboolean _tmp1384_ = FALSE;
	ValaDataType* _tmp1677_;
	ValaDataType* _tmp1678_;
	ValaSymbol* _tmp1681_;
	ValaSymbol* _tmp1682_;
	gboolean _tmp1723_;
	gboolean _tmp1724_;
	gboolean _tmp1725_;
	gboolean result;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_null_safe_access;
	if (_tmp4_) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp5_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		result = !_tmp6_;
		return result;
	}
	_tmp7_ = vala_member_access_get_inner (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp9_ = vala_member_access_get_inner (self);
		_tmp10_ = _tmp9_;
		vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp11_;
		gint _type_arg_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _type_arg_index = 0;
		_tmp11_ = self->priv->type_argument_list;
		_type_arg_list = _tmp11_;
		_tmp12_ = _type_arg_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_type_arg_size = _tmp14_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_type_arg_index = _type_arg_index + 1;
			_tmp15_ = _type_arg_index;
			_tmp16_ = _type_arg_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _type_arg_list;
			_tmp18_ = vala_list_get (_tmp17_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	visited_types = _tmp21_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp22_ = self->priv->_qualified;
	if (_tmp22_) {
		ValaNamespace* _tmp23_;
		ValaNamespace* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaScope* _tmp26_;
		ValaScope* _tmp27_;
		const gchar* _tmp28_;
		ValaSymbol* _tmp29_;
		ValaSymbol* _tmp30_;
		_tmp23_ = vala_code_context_get_root (context);
		_tmp24_ = _tmp23_;
		base_symbol = (ValaSymbol*) _tmp24_;
		_tmp25_ = base_symbol;
		_tmp26_ = vala_symbol_get_scope (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->_member_name;
		_tmp29_ = vala_scope_lookup (_tmp27_, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
	} else {
		ValaExpression* _tmp31_;
		ValaExpression* _tmp32_;
		_tmp31_ = vala_member_access_get_inner (self);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == NULL) {
			const gchar* _tmp33_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp182_ = FALSE;
			ValaSymbol* _tmp183_;
			ValaSymbol* _tmp184_;
			_tmp33_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp33_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp34_;
				ValaSemanticAnalyzer* _tmp35_;
				_tmp34_ = vala_code_context_get_analyzer (context);
				_tmp35_ = _tmp34_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp35_)) {
					ValaSourceReference* _tmp36_;
					ValaSourceReference* _tmp37_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp37_ = _tmp36_;
					vala_report_error (_tmp37_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp93_;
				const gchar* _tmp94_;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				gboolean _tmp97_ = FALSE;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp135_ = FALSE;
				gboolean _tmp136_ = FALSE;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp50_;
					_tmp50_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp50_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp51_;
						ValaCreationMethod* _tmp52_;
						ValaParameter* _tmp53_;
						ValaParameter* _tmp54_;
						_tmp51_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp52_ = cm;
						_tmp53_ = vala_method_get_this_parameter ((ValaMethod*) _tmp52_);
						_tmp54_ = _tmp53_;
						this_parameter = _tmp54_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp55_;
						_tmp55_ = sym;
						if (VALA_IS_PROPERTY (_tmp55_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaProperty* _tmp63_;
							ValaMemberBinding _tmp64_;
							ValaMemberBinding _tmp65_;
							_tmp56_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							this_parameter = _tmp59_;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_instance_members = _tmp62_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp63_ = prop;
							_tmp64_ = vala_property_get_binding (_tmp63_);
							_tmp65_ = _tmp64_;
							may_access_klass_members = _tmp65_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp66_;
							_tmp66_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp66_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaParameter* _tmp69_;
								ValaParameter* _tmp70_;
								ValaConstructor* _tmp71_;
								ValaMemberBinding _tmp72_;
								ValaMemberBinding _tmp73_;
								_tmp67_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_this_parameter (_tmp68_);
								_tmp70_ = _tmp69_;
								this_parameter = _tmp70_;
								_tmp71_ = c;
								_tmp72_ = vala_constructor_get_binding (_tmp71_);
								_tmp73_ = _tmp72_;
								may_access_instance_members = _tmp73_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp74_;
								_tmp74_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp74_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaParameter* _tmp77_;
									ValaParameter* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaMemberBinding _tmp80_;
									ValaMemberBinding _tmp81_;
									_tmp75_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_this_parameter (_tmp76_);
									_tmp78_ = _tmp77_;
									this_parameter = _tmp78_;
									_tmp79_ = d;
									_tmp80_ = vala_destructor_get_binding (_tmp79_);
									_tmp81_ = _tmp80_;
									may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp82_;
									_tmp82_ = sym;
									if (VALA_IS_METHOD (_tmp82_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp83_;
										ValaMethod* _tmp84_;
										ValaParameter* _tmp85_;
										ValaParameter* _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMethod* _tmp90_;
										ValaMemberBinding _tmp91_;
										ValaMemberBinding _tmp92_;
										_tmp83_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod);
										_tmp84_ = m;
										_tmp85_ = vala_method_get_this_parameter (_tmp84_);
										_tmp86_ = _tmp85_;
										this_parameter = _tmp86_;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_instance_members = _tmp89_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_binding (_tmp90_);
										_tmp92_ = _tmp91_;
										may_access_klass_members = _tmp92_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp93_ = sym;
				_tmp94_ = self->priv->_member_name;
				_tmp95_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp93_, _tmp94_);
				_tmp96_ = _tmp95_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp96_);
				_vala_code_node_unref0 (_tmp96_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp99_;
					ValaSymbol* _tmp100_;
					_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp100_ = _tmp99_;
					_tmp98_ = _tmp100_ == NULL;
				} else {
					_tmp98_ = FALSE;
				}
				if (_tmp98_) {
					ValaSymbol* _tmp101_;
					_tmp101_ = sym;
					_tmp97_ = VALA_IS_WITH_STATEMENT (_tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (_tmp97_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp102_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp103_;
					ValaLocalVariable* _tmp104_;
					ValaLocalVariable* _tmp105_;
					ValaDataType* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					ValaDataType* _tmp109_;
					ValaArrayList* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					ValaSymbol* _tmp121_;
					_tmp102_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp103_ = w;
					_tmp104_ = vala_with_statement_get_with_variable (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_variable_get_variable_type ((ValaVariable*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = _vala_code_node_ref0 (_tmp107_);
					variable_type = _tmp108_;
					_tmp109_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp109_)) {
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp110_ = variable_type;
						_tmp111_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp112_ = _tmp111_;
						_tmp113_ = _vala_code_node_ref0 (_tmp112_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp113_;
					}
					_tmp114_ = visited_types;
					_tmp115_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp114_, _tmp115_);
					_tmp116_ = variable_type;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp120_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp121_ = _tmp120_;
					if (_tmp121_ != NULL) {
						ValaWithStatement* _tmp122_;
						ValaLocalVariable* _tmp123_;
						ValaLocalVariable* _tmp124_;
						const gchar* _tmp125_;
						const gchar* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaSourceReference* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaMemberAccess* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaExpression* _tmp133_;
						ValaExpression* _tmp134_;
						_tmp122_ = w;
						_tmp123_ = vala_with_statement_get_with_variable (_tmp122_);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_member_access_new (NULL, _tmp126_, _tmp128_);
						_tmp130_ = _tmp129_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp133_ = vala_member_access_get_inner (self);
						_tmp134_ = _tmp133_;
						vala_code_node_check ((ValaCodeNode*) _tmp134_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp138_ = _tmp137_;
				if (_tmp138_ == NULL) {
					ValaSymbol* _tmp139_;
					_tmp139_ = sym;
					_tmp136_ = VALA_IS_TYPESYMBOL (_tmp139_);
				} else {
					_tmp136_ = FALSE;
				}
				if (_tmp136_) {
					_tmp135_ = may_access_instance_members;
				} else {
					_tmp135_ = FALSE;
				}
				if (_tmp135_) {
					ValaParameter* _tmp140_;
					ValaDataType* _tmp141_;
					ValaDataType* _tmp142_;
					const gchar* _tmp143_;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					gboolean _tmp146_ = FALSE;
					ValaSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					_tmp140_ = this_parameter;
					_tmp141_ = vala_variable_get_variable_type ((ValaVariable*) _tmp140_);
					_tmp142_ = _tmp141_;
					_tmp143_ = self->priv->_member_name;
					_tmp144_ = vala_data_type_get_member (_tmp142_, _tmp143_);
					_tmp145_ = _tmp144_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp145_);
					_vala_code_node_unref0 (_tmp145_);
					_tmp147_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp148_ = _tmp147_;
					if (_tmp148_ != NULL) {
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp150_ = _tmp149_;
						_tmp146_ = vala_member_access_is_instance_symbol (_tmp150_);
					} else {
						_tmp146_ = FALSE;
					}
					if (_tmp146_) {
						ValaSourceReference* _tmp151_;
						ValaSourceReference* _tmp152_;
						ValaMemberAccess* _tmp153_;
						ValaMemberAccess* _tmp154_;
						ValaExpression* _tmp155_;
						ValaExpression* _tmp156_;
						ValaParameter* _tmp157_;
						ValaDataType* _tmp158_;
						ValaDataType* _tmp159_;
						ValaDataType* _tmp160_;
						ValaDataType* _tmp161_;
						ValaExpression* _tmp162_;
						ValaExpression* _tmp163_;
						ValaDataType* _tmp164_;
						ValaDataType* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaParameter* _tmp168_;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaDataType* _tmp171_;
						ValaDataType* _tmp172_;
						const gchar* _tmp173_;
						ValaSymbol* _tmp174_;
						ValaSymbol* _tmp175_;
						_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp152_ = _tmp151_;
						_tmp153_ = vala_member_access_new (NULL, "this", _tmp152_);
						_tmp154_ = _tmp153_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp154_);
						_vala_code_node_unref0 (_tmp154_);
						_tmp155_ = vala_member_access_get_inner (self);
						_tmp156_ = _tmp155_;
						_tmp157_ = this_parameter;
						_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
						_tmp159_ = _tmp158_;
						_tmp160_ = vala_data_type_copy (_tmp159_);
						_tmp161_ = _tmp160_;
						vala_expression_set_value_type (_tmp156_, _tmp161_);
						_vala_code_node_unref0 (_tmp161_);
						_tmp162_ = vala_member_access_get_inner (self);
						_tmp163_ = _tmp162_;
						_tmp164_ = vala_expression_get_value_type (_tmp163_);
						_tmp165_ = _tmp164_;
						vala_data_type_set_value_owned (_tmp165_, FALSE);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp167_, (ValaSymbol*) _tmp168_);
						_tmp169_ = vala_member_access_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_expression_get_value_type (_tmp170_);
						_tmp172_ = _tmp171_;
						_tmp173_ = self->priv->_member_name;
						_tmp174_ = vala_data_type_get_member (_tmp172_, _tmp173_);
						_tmp175_ = _tmp174_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp175_);
						_vala_code_node_unref0 (_tmp175_);
					}
				}
				_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					ValaSymbol* _tmp178_;
					_tmp178_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp178_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp179_ = sym;
				_tmp180_ = vala_symbol_get_parent_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				sym = _tmp181_;
			}
			_tmp183_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp184_ = _tmp183_;
			if (_tmp184_ == NULL) {
				ValaSourceReference* _tmp185_;
				ValaSourceReference* _tmp186_;
				_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp186_ = _tmp185_;
				_tmp182_ = _tmp186_ != NULL;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaList* _tmp189_;
					ValaList* _tmp190_;
					gint _ns_size = 0;
					ValaList* _tmp191_;
					gint _tmp192_;
					gint _tmp193_;
					gint _ns_index = 0;
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_source_reference_get_using_directives (_tmp188_);
					_tmp190_ = _tmp189_;
					_ns_list = _tmp190_;
					_tmp191_ = _ns_list;
					_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
					_tmp193_ = _tmp192_;
					_ns_size = _tmp193_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp194_;
						gint _tmp195_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp196_;
						gpointer _tmp197_;
						ValaUsingDirective* _tmp198_;
						gboolean _tmp199_;
						gboolean _tmp200_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp201_;
						ValaSymbol* _tmp202_;
						ValaSymbol* _tmp203_;
						ValaScope* _tmp204_;
						ValaScope* _tmp205_;
						const gchar* _tmp206_;
						ValaSymbol* _tmp207_;
						ValaSymbol* _tmp208_;
						_ns_index = _ns_index + 1;
						_tmp194_ = _ns_index;
						_tmp195_ = _ns_size;
						if (!(_tmp194_ < _tmp195_)) {
							break;
						}
						_tmp196_ = _ns_list;
						_tmp197_ = vala_list_get (_tmp196_, _ns_index);
						ns = (ValaUsingDirective*) _tmp197_;
						_tmp198_ = ns;
						_tmp199_ = vala_code_node_get_error ((ValaCodeNode*) _tmp198_);
						_tmp200_ = _tmp199_;
						if (_tmp200_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp201_ = ns;
						_tmp202_ = vala_using_directive_get_namespace_symbol (_tmp201_);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_symbol_get_scope (_tmp203_);
						_tmp205_ = _tmp204_;
						_tmp206_ = self->priv->_member_name;
						_tmp207_ = vala_scope_lookup (_tmp205_, _tmp206_);
						local_sym = _tmp207_;
						_tmp208_ = local_sym;
						if (_tmp208_ != NULL) {
							gboolean _tmp209_ = FALSE;
							ValaSymbol* _tmp210_;
							ValaSymbol* _tmp211_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp225_;
							ValaSymbol* _tmp226_;
							ValaSymbol* _tmp227_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp247_;
							ValaExpression* _tmp248_;
							ValaExpression* _tmp249_;
							ValaSymbol* _tmp250_;
							_tmp210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp211_ = _tmp210_;
							if (_tmp211_ != NULL) {
								ValaSymbol* _tmp212_;
								ValaSymbol* _tmp213_;
								ValaSymbol* _tmp214_;
								_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = local_sym;
								_tmp209_ = _tmp213_ != _tmp214_;
							} else {
								_tmp209_ = FALSE;
							}
							if (_tmp209_) {
								ValaSourceReference* _tmp215_;
								ValaSourceReference* _tmp216_;
								const gchar* _tmp217_;
								ValaSymbol* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								ValaSymbol* _tmp222_;
								gchar* _tmp223_;
								gchar* _tmp224_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = self->priv->_member_name;
								_tmp218_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp219_ = _tmp218_;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								_tmp222_ = local_sym;
								_tmp223_ = vala_symbol_get_full_name (_tmp222_);
								_tmp224_ = _tmp223_;
								vala_report_error (_tmp216_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp217_, _tmp221_, _tmp224_);
								_g_free0 (_tmp224_);
								_g_free0 (_tmp221_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp225_ = local_sym;
							_tmp226_ = vala_symbol_get_parent_symbol (_tmp225_);
							_tmp227_ = _tmp226_;
							inner_sym = _tmp227_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp228_ = FALSE;
								ValaSymbol* _tmp229_;
								ValaMemberAccess* _tmp233_;
								ValaSymbol* _tmp234_;
								const gchar* _tmp235_;
								const gchar* _tmp236_;
								ValaSourceReference* _tmp237_;
								ValaSourceReference* _tmp238_;
								ValaMemberAccess* _tmp239_;
								ValaMemberAccess* _tmp240_;
								ValaMemberAccess* _tmp241_;
								ValaExpression* _tmp242_;
								ValaExpression* _tmp243_;
								ValaSymbol* _tmp244_;
								ValaSymbol* _tmp245_;
								ValaSymbol* _tmp246_;
								_tmp229_ = inner_sym;
								if (_tmp229_ != NULL) {
									ValaSymbol* _tmp230_;
									const gchar* _tmp231_;
									const gchar* _tmp232_;
									_tmp230_ = inner_sym;
									_tmp231_ = vala_symbol_get_name (_tmp230_);
									_tmp232_ = _tmp231_;
									_tmp228_ = _tmp232_ != NULL;
								} else {
									_tmp228_ = FALSE;
								}
								if (!_tmp228_) {
									break;
								}
								_tmp233_ = inner_ma;
								_tmp234_ = inner_sym;
								_tmp235_ = vala_symbol_get_name (_tmp234_);
								_tmp236_ = _tmp235_;
								_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_member_access_new (NULL, _tmp236_, _tmp238_);
								_tmp240_ = _tmp239_;
								vala_member_access_set_inner (_tmp233_, (ValaExpression*) _tmp240_);
								_vala_code_node_unref0 (_tmp240_);
								_tmp241_ = inner_ma;
								_tmp242_ = vala_member_access_get_inner (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp244_ = inner_sym;
								_tmp245_ = vala_symbol_get_parent_symbol (_tmp244_);
								_tmp246_ = _tmp245_;
								inner_sym = _tmp246_;
							}
							_tmp247_ = inner_ma;
							vala_member_access_set_qualified (_tmp247_, TRUE);
							_tmp248_ = vala_member_access_get_inner (self);
							_tmp249_ = _tmp248_;
							vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
							_tmp250_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp250_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp253_;
			gboolean _tmp254_;
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaDataType* _tmp257_;
			ValaDataType* _tmp258_;
			gboolean _tmp289_ = FALSE;
			ValaExpression* _tmp290_;
			ValaExpression* _tmp291_;
			ValaDataType* _tmp292_;
			ValaDataType* _tmp293_;
			ValaExpression* _tmp299_;
			ValaExpression* _tmp300_;
			gboolean _tmp313_ = FALSE;
			ValaExpression* _tmp314_;
			ValaExpression* _tmp315_;
			gboolean _tmp322_ = FALSE;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			gboolean _tmp345_ = FALSE;
			ValaExpression* _tmp346_;
			ValaExpression* _tmp347_;
			gboolean _tmp362_ = FALSE;
			ValaSymbol* _tmp363_;
			ValaSymbol* _tmp364_;
			gboolean _tmp398_ = FALSE;
			gboolean _tmp399_ = FALSE;
			ValaSymbol* _tmp400_;
			ValaSymbol* _tmp401_;
			ValaSymbol* _tmp674_;
			ValaSymbol* _tmp675_;
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_code_node_get_error ((ValaCodeNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			if (_tmp254_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp255_ = vala_member_access_get_inner (self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_value_type (_tmp256_);
			_tmp258_ = _tmp257_;
			if (VALA_IS_POINTER_TYPE (_tmp258_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp259_;
				ValaExpression* _tmp260_;
				ValaDataType* _tmp261_;
				ValaDataType* _tmp262_;
				gboolean _tmp263_ = FALSE;
				ValaPointerType* _tmp264_;
				_tmp259_ = vala_member_access_get_inner (self);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_expression_get_value_type (_tmp260_);
				_tmp262_ = _tmp261_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp262_) ? ((ValaPointerType*) _tmp262_) : NULL;
				_tmp264_ = pointer_type;
				if (_tmp264_ != NULL) {
					ValaPointerType* _tmp265_;
					ValaDataType* _tmp266_;
					ValaDataType* _tmp267_;
					_tmp265_ = pointer_type;
					_tmp266_ = vala_pointer_type_get_base_type (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp263_ = VALA_IS_VALUE_TYPE (_tmp267_);
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaExpression* _tmp268_;
					ValaExpression* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaExpression* _tmp281_;
					ValaExpression* _tmp282_;
					ValaSourceReference* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaPointerIndirection* _tmp285_;
					ValaPointerIndirection* _tmp286_;
					ValaExpression* _tmp287_;
					ValaExpression* _tmp288_;
					_tmp268_ = vala_member_access_get_inner (self);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_expression_get_formal_value_type (_tmp269_);
					_tmp271_ = _tmp270_;
					if (VALA_IS_GENERIC_TYPE (_tmp271_)) {
						ValaExpression* _tmp272_;
						ValaExpression* _tmp273_;
						ValaPointerType* _tmp274_;
						ValaDataType* _tmp275_;
						ValaDataType* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaSourceReference* _tmp278_;
						ValaCastExpression* _tmp279_;
						ValaCastExpression* _tmp280_;
						_tmp272_ = vala_member_access_get_inner (self);
						_tmp273_ = _tmp272_;
						_tmp274_ = pointer_type;
						_tmp275_ = vala_data_type_copy ((ValaDataType*) _tmp274_);
						_tmp276_ = _tmp275_;
						_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp278_ = _tmp277_;
						_tmp279_ = vala_cast_expression_new (_tmp273_, _tmp276_, _tmp278_);
						_tmp280_ = _tmp279_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp280_);
						_vala_code_node_unref0 (_tmp280_);
						_vala_code_node_unref0 (_tmp276_);
					}
					_tmp281_ = vala_member_access_get_inner (self);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp284_ = _tmp283_;
					_tmp285_ = vala_pointer_indirection_new (_tmp282_, _tmp284_);
					_tmp286_ = _tmp285_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp286_);
					_vala_code_node_unref0 (_tmp286_);
					_tmp287_ = vala_member_access_get_inner (self);
					_tmp288_ = _tmp287_;
					vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp290_ = vala_member_access_get_inner (self);
			_tmp291_ = _tmp290_;
			_tmp292_ = vala_expression_get_value_type (_tmp291_);
			_tmp293_ = _tmp292_;
			if (VALA_IS_SIGNAL_TYPE (_tmp293_)) {
				const gchar* _tmp294_;
				_tmp294_ = self->priv->_member_name;
				_tmp289_ = g_strcmp0 (_tmp294_, "emit") == 0;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				ValaCodeNode* _tmp295_;
				ValaCodeNode* _tmp296_;
				ValaExpression* _tmp297_;
				ValaExpression* _tmp298_;
				_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_member_access_get_inner (self);
				_tmp298_ = _tmp297_;
				vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, _tmp298_);
				result = TRUE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp299_ = vala_member_access_get_inner (self);
			_tmp300_ = _tmp299_;
			if (VALA_IS_MEMBER_ACCESS (_tmp300_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaMemberAccess* _tmp303_;
				gboolean _tmp304_;
				_tmp301_ = vala_member_access_get_inner (self);
				_tmp302_ = _tmp301_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp303_ = ma;
				_tmp304_ = _tmp303_->priv->_prototype_access;
				if (_tmp304_) {
					ValaSourceReference* _tmp305_;
					ValaSourceReference* _tmp306_;
					ValaExpression* _tmp307_;
					ValaExpression* _tmp308_;
					ValaSymbol* _tmp309_;
					ValaSymbol* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_member_access_get_inner (self);
					_tmp308_ = _tmp307_;
					_tmp309_ = vala_expression_get_symbol_reference (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_symbol_get_full_name (_tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp306_, "Access to instance member `%s' denied", _tmp312_);
					_g_free0 (_tmp312_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp314_ = vala_member_access_get_inner (self);
			_tmp315_ = _tmp314_;
			if (VALA_IS_CAST_EXPRESSION (_tmp315_)) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				gboolean _tmp318_;
				gboolean _tmp319_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp319_ = _tmp318_;
				_tmp313_ = _tmp319_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_warning (_tmp321_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp323_ = vala_member_access_get_inner (self);
			_tmp324_ = _tmp323_;
			if (VALA_IS_MEMBER_ACCESS (_tmp324_)) {
				_tmp322_ = TRUE;
			} else {
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp322_ = VALA_IS_BASE_ACCESS (_tmp326_);
			}
			if (_tmp322_) {
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaSymbol* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_symbol_reference (_tmp328_);
				_tmp330_ = _tmp329_;
				base_symbol = _tmp330_;
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ == NULL) {
					gboolean _tmp334_ = FALSE;
					ValaSymbol* _tmp335_;
					_tmp335_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp335_)) {
						_tmp334_ = TRUE;
					} else {
						ValaSymbol* _tmp336_;
						_tmp336_ = base_symbol;
						_tmp334_ = VALA_IS_TYPESYMBOL (_tmp336_);
					}
					_tmp331_ = _tmp334_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaSymbol* _tmp337_;
					ValaScope* _tmp338_;
					ValaScope* _tmp339_;
					const gchar* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaExpression* _tmp343_;
					ValaExpression* _tmp344_;
					_tmp337_ = base_symbol;
					_tmp338_ = vala_symbol_get_scope (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = self->priv->_member_name;
					_tmp341_ = vala_scope_lookup (_tmp339_, _tmp340_);
					_tmp342_ = _tmp341_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp342_);
					_vala_code_node_unref0 (_tmp342_);
					_tmp343_ = vala_member_access_get_inner (self);
					_tmp344_ = _tmp343_;
					if (VALA_IS_BASE_ACCESS (_tmp344_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp346_ = vala_member_access_get_inner (self);
			_tmp347_ = _tmp346_;
			if (VALA_IS_MEMBER_ACCESS (_tmp347_)) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaSymbol* _tmp351_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_symbol_reference (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp345_ = VALA_IS_TYPEPARAMETER (_tmp351_);
			} else {
				_tmp345_ = FALSE;
			}
			if (_tmp345_) {
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaExpression* _tmp355_;
				ValaSymbol* _tmp356_;
				ValaSymbol* _tmp357_;
				ValaSourceReference* _tmp358_;
				ValaSourceReference* _tmp359_;
				ValaGenericType* _tmp360_;
				ValaGenericType* _tmp361_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_member_access_get_inner (self);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter), _tmp359_);
				_tmp361_ = _tmp360_;
				vala_expression_set_value_type (_tmp353_, (ValaDataType*) _tmp361_);
				_vala_code_node_unref0 (_tmp361_);
			}
			_tmp363_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp364_ = _tmp363_;
			if (_tmp364_ == NULL) {
				ValaExpression* _tmp365_;
				ValaExpression* _tmp366_;
				ValaDataType* _tmp367_;
				ValaDataType* _tmp368_;
				_tmp365_ = vala_member_access_get_inner (self);
				_tmp366_ = _tmp365_;
				_tmp367_ = vala_expression_get_value_type (_tmp366_);
				_tmp368_ = _tmp367_;
				_tmp362_ = _tmp368_ != NULL;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				gboolean _tmp369_;
				ValaSymbol* _tmp396_;
				ValaSymbol* _tmp397_;
				_tmp369_ = self->priv->_pointer_member_access;
				if (_tmp369_) {
					ValaExpression* _tmp370_;
					ValaExpression* _tmp371_;
					ValaDataType* _tmp372_;
					ValaDataType* _tmp373_;
					const gchar* _tmp374_;
					ValaSymbol* _tmp375_;
					ValaSymbol* _tmp376_;
					_tmp370_ = vala_member_access_get_inner (self);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_expression_get_value_type (_tmp371_);
					_tmp373_ = _tmp372_;
					_tmp374_ = self->priv->_member_name;
					_tmp375_ = vala_data_type_get_pointer_member (_tmp373_, _tmp374_);
					_tmp376_ = _tmp375_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp376_);
					_vala_code_node_unref0 (_tmp376_);
				} else {
					ValaExpression* _tmp377_;
					ValaExpression* _tmp378_;
					ValaDataType* _tmp379_;
					ValaDataType* _tmp380_;
					ValaTypeSymbol* _tmp381_;
					ValaTypeSymbol* _tmp382_;
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					const gchar* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					_tmp377_ = vala_member_access_get_inner (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_expression_get_value_type (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = vala_data_type_get_type_symbol (_tmp380_);
					_tmp382_ = _tmp381_;
					if (_tmp382_ != NULL) {
						ValaExpression* _tmp383_;
						ValaExpression* _tmp384_;
						ValaDataType* _tmp385_;
						ValaDataType* _tmp386_;
						ValaTypeSymbol* _tmp387_;
						ValaTypeSymbol* _tmp388_;
						_tmp383_ = vala_member_access_get_inner (self);
						_tmp384_ = _tmp383_;
						_tmp385_ = vala_expression_get_value_type (_tmp384_);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_data_type_get_type_symbol (_tmp386_);
						_tmp388_ = _tmp387_;
						base_symbol = (ValaSymbol*) _tmp388_;
					}
					_tmp389_ = vala_member_access_get_inner (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp393_ = self->priv->_member_name;
					_tmp394_ = vala_data_type_get_member (_tmp392_, _tmp393_);
					_tmp395_ = _tmp394_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp395_);
					_vala_code_node_unref0 (_tmp395_);
				}
				_tmp396_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp397_ = _tmp396_;
				if (_tmp397_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp401_ = _tmp400_;
			if (_tmp401_ == NULL) {
				ValaExpression* _tmp402_;
				ValaExpression* _tmp403_;
				ValaDataType* _tmp404_;
				ValaDataType* _tmp405_;
				_tmp402_ = vala_member_access_get_inner (self);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_expression_get_value_type (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp399_ = _tmp405_ != NULL;
			} else {
				_tmp399_ = FALSE;
			}
			if (_tmp399_) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				gboolean _tmp410_;
				gboolean _tmp411_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp410_ = vala_data_type_get_is_dynamic (_tmp409_);
				_tmp411_ = _tmp410_;
				_tmp398_ = _tmp411_;
			} else {
				_tmp398_ = FALSE;
			}
			if (_tmp398_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp412_;
				ValaExpression* _tmp413_;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaObjectType* _tmp416_;
				ValaCodeNode* _tmp417_;
				ValaCodeNode* _tmp418_;
				ValaSymbol* _tmp622_;
				ValaSymbol* _tmp623_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				_tmp412_ = vala_member_access_get_inner (self);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_expression_get_value_type (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp416_;
				_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				if (VALA_IS_METHOD_CALL (_tmp418_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp419_;
					ValaCodeNode* _tmp420_;
					ValaMethodCall* _tmp421_;
					ValaExpression* _tmp422_;
					ValaExpression* _tmp423_;
					_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp420_ = _tmp419_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp421_ = invoc;
					_tmp422_ = vala_method_call_get_call (_tmp421_);
					_tmp423_ = _tmp422_;
					if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp424_;
						ValaDataType* _tmp425_;
						ValaDataType* _tmp426_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp441_;
						ValaExpression* _tmp442_;
						ValaDataType* _tmp443_;
						ValaDataType* _tmp444_;
						const gchar* _tmp445_;
						ValaDataType* _tmp446_;
						ValaSourceReference* _tmp447_;
						ValaSourceReference* _tmp448_;
						ValaDynamicMethod* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaMethodCall* _tmp451_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp452_;
						ValaSourceReference* _tmp453_;
						ValaSourceReference* _tmp454_;
						ValaErrorType* _tmp455_;
						ValaErrorType* _tmp456_;
						ValaDynamicMethod* _tmp457_;
						ValaErrorType* _tmp458_;
						ValaDynamicMethod* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaDynamicMethod* _tmp463_;
						ValaObjectType* _tmp464_;
						ValaDataType* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDynamicMethod* _tmp467_;
						ValaSourceReference* _tmp468_;
						ValaSourceReference* _tmp469_;
						ValaParameter* _tmp470_;
						ValaParameter* _tmp471_;
						ValaObjectType* _tmp472_;
						ValaTypeSymbol* _tmp473_;
						ValaTypeSymbol* _tmp474_;
						ValaScope* _tmp475_;
						ValaScope* _tmp476_;
						ValaDynamicMethod* _tmp477_;
						ValaDynamicMethod* _tmp478_;
						_tmp424_ = invoc;
						_tmp425_ = vala_expression_get_target_type ((ValaExpression*) _tmp424_);
						_tmp426_ = _tmp425_;
						if (_tmp426_ != NULL) {
							ValaMethodCall* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							ValaDataType* _tmp430_;
							ValaDataType* _tmp431_;
							_tmp427_ = invoc;
							_tmp428_ = vala_expression_get_target_type ((ValaExpression*) _tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = vala_data_type_copy (_tmp429_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp430_;
							_tmp431_ = ret_type;
							vala_data_type_set_value_owned (_tmp431_, TRUE);
						} else {
							ValaMethodCall* _tmp432_;
							ValaCodeNode* _tmp433_;
							ValaCodeNode* _tmp434_;
							_tmp432_ = invoc;
							_tmp433_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp432_);
							_tmp434_ = _tmp433_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp434_)) {
								ValaVoidType* _tmp435_;
								_tmp435_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp435_;
							} else {
								ValaExpression* _tmp436_;
								ValaExpression* _tmp437_;
								ValaDataType* _tmp438_;
								ValaDataType* _tmp439_;
								ValaDataType* _tmp440_;
								_tmp436_ = vala_member_access_get_inner (self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_expression_get_value_type (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_data_type_copy (_tmp439_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp440_;
							}
						}
						_tmp441_ = vala_member_access_get_inner (self);
						_tmp442_ = _tmp441_;
						_tmp443_ = vala_expression_get_value_type (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp445_ = self->priv->_member_name;
						_tmp446_ = ret_type;
						_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp448_ = _tmp447_;
						_tmp449_ = vala_dynamic_method_new (_tmp444_, _tmp445_, _tmp446_, _tmp448_, NULL);
						m = _tmp449_;
						_tmp450_ = m;
						_tmp451_ = invoc;
						vala_dynamic_method_set_invocation (_tmp450_, _tmp451_);
						_tmp452_ = m;
						_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp452_);
						_tmp454_ = _tmp453_;
						_tmp455_ = vala_error_type_new (NULL, NULL, _tmp454_);
						err = _tmp455_;
						_tmp456_ = err;
						vala_error_type_set_dynamic_error (_tmp456_, TRUE);
						_tmp457_ = m;
						_tmp458_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp457_, (ValaDataType*) _tmp458_);
						_tmp459_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp460_ = m;
						_tmp461_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp462_ = _tmp461_;
						vala_callable_add_parameter ((ValaCallable*) _tmp460_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_tmp463_ = m;
						_tmp464_ = dynamic_object_type;
						_tmp465_ = vala_data_type_copy ((ValaDataType*) _tmp464_);
						_tmp466_ = _tmp465_;
						_tmp467_ = m;
						_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp467_);
						_tmp469_ = _tmp468_;
						_tmp470_ = vala_parameter_new ("this", _tmp466_, _tmp469_);
						_tmp471_ = _tmp470_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp463_, _tmp471_);
						_vala_code_node_unref0 (_tmp471_);
						_vala_code_node_unref0 (_tmp466_);
						_tmp472_ = dynamic_object_type;
						_tmp473_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = vala_symbol_get_scope ((ValaSymbol*) _tmp474_);
						_tmp476_ = _tmp475_;
						_tmp477_ = m;
						vala_scope_add (_tmp476_, NULL, (ValaSymbol*) _tmp477_);
						_tmp478_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp478_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp479_;
					ValaCodeNode* _tmp480_;
					_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp480_ = _tmp479_;
					if (VALA_IS_ASSIGNMENT (_tmp480_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp481_;
						ValaCodeNode* _tmp482_;
						ValaAssignment* _tmp483_;
						ValaExpression* _tmp484_;
						ValaExpression* _tmp485_;
						_tmp481_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp482_ = _tmp481_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp483_ = a;
						_tmp484_ = vala_assignment_get_left (_tmp483_);
						_tmp485_ = _tmp484_;
						if (_tmp485_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp486_;
							ValaExpression* _tmp487_;
							ValaDataType* _tmp488_;
							ValaDataType* _tmp489_;
							const gchar* _tmp490_;
							ValaSourceReference* _tmp491_;
							ValaSourceReference* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							ValaDynamicProperty* _tmp495_;
							ValaDynamicProperty* _tmp496_;
							ValaSourceReference* _tmp497_;
							ValaSourceReference* _tmp498_;
							ValaPropertyAccessor* _tmp499_;
							ValaPropertyAccessor* _tmp500_;
							ValaDynamicProperty* _tmp501_;
							ValaExpression* _tmp502_;
							ValaExpression* _tmp503_;
							ValaDataType* _tmp504_;
							ValaDataType* _tmp505_;
							ValaTypeSymbol* _tmp506_;
							ValaTypeSymbol* _tmp507_;
							ValaScope* _tmp508_;
							ValaScope* _tmp509_;
							ValaObjectType* _tmp510_;
							ValaTypeSymbol* _tmp511_;
							ValaTypeSymbol* _tmp512_;
							ValaScope* _tmp513_;
							ValaScope* _tmp514_;
							ValaDynamicProperty* _tmp515_;
							ValaDynamicProperty* _tmp516_;
							_tmp486_ = vala_member_access_get_inner (self);
							_tmp487_ = _tmp486_;
							_tmp488_ = vala_expression_get_value_type (_tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = self->priv->_member_name;
							_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp492_ = _tmp491_;
							_tmp493_ = vala_dynamic_property_new (_tmp489_, _tmp490_, _tmp492_, NULL);
							prop = _tmp493_;
							_tmp494_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp494_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp495_ = prop;
							_tmp496_ = prop;
							_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp498_, NULL);
							_tmp500_ = _tmp499_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp495_, _tmp500_);
							_vala_code_node_unref0 (_tmp500_);
							_tmp501_ = prop;
							_tmp502_ = vala_member_access_get_inner (self);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_expression_get_value_type (_tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = vala_data_type_get_type_symbol (_tmp505_);
							_tmp507_ = _tmp506_;
							_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
							_tmp509_ = _tmp508_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
							_tmp510_ = dynamic_object_type;
							_tmp511_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
							_tmp514_ = _tmp513_;
							_tmp515_ = prop;
							vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
							_tmp516_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp517_ = FALSE;
						gboolean _tmp518_ = FALSE;
						ValaCodeNode* _tmp519_;
						ValaCodeNode* _tmp520_;
						_tmp519_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp520_ = _tmp519_;
						if (VALA_IS_MEMBER_ACCESS (_tmp520_)) {
							ValaExpression* _tmp521_;
							ValaExpression* _tmp522_;
							_tmp521_ = vala_member_access_get_inner (self);
							_tmp522_ = _tmp521_;
							_tmp518_ = VALA_IS_MEMBER_ACCESS (_tmp522_);
						} else {
							_tmp518_ = FALSE;
						}
						if (_tmp518_) {
							ValaCodeNode* _tmp523_;
							ValaCodeNode* _tmp524_;
							ValaCodeNode* _tmp525_;
							ValaCodeNode* _tmp526_;
							_tmp523_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp524_ = _tmp523_;
							_tmp525_ = vala_code_node_get_parent_node (_tmp524_);
							_tmp526_ = _tmp525_;
							_tmp517_ = VALA_IS_METHOD_CALL (_tmp526_);
						} else {
							_tmp517_ = FALSE;
						}
						if (_tmp517_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp527_;
							ValaCodeNode* _tmp528_;
							gboolean _tmp529_ = FALSE;
							ValaMemberAccess* _tmp530_;
							const gchar* _tmp531_;
							_tmp527_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp528_ = _tmp527_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp528_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp530_ = ma;
							_tmp531_ = _tmp530_->priv->_member_name;
							if (g_strcmp0 (_tmp531_, "connect") == 0) {
								_tmp529_ = TRUE;
							} else {
								ValaMemberAccess* _tmp532_;
								const gchar* _tmp533_;
								_tmp532_ = ma;
								_tmp533_ = _tmp532_->priv->_member_name;
								_tmp529_ = g_strcmp0 (_tmp533_, "connect_after") == 0;
							}
							if (_tmp529_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp534_;
								ValaExpression* _tmp535_;
								ValaDataType* _tmp536_;
								ValaDataType* _tmp537_;
								const gchar* _tmp538_;
								ValaVoidType* _tmp539_;
								ValaVoidType* _tmp540_;
								ValaSourceReference* _tmp541_;
								ValaSourceReference* _tmp542_;
								ValaDynamicSignal* _tmp543_;
								ValaDynamicSignal* _tmp544_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp545_;
								ValaCodeNode* _tmp546_;
								ValaCodeNode* _tmp547_;
								ValaCodeNode* _tmp548_;
								ValaMethodCall* _tmp549_;
								ValaMethodCall* _tmp550_;
								ValaList* _tmp551_;
								gint _tmp552_;
								gint _tmp553_;
								ValaDynamicSignal* _tmp585_;
								ValaObjectType* _tmp586_;
								ValaTypeSymbol* _tmp587_;
								ValaTypeSymbol* _tmp588_;
								ValaScope* _tmp589_;
								ValaScope* _tmp590_;
								ValaDynamicSignal* _tmp591_;
								ValaDynamicSignal* _tmp592_;
								_tmp534_ = vala_member_access_get_inner (self);
								_tmp535_ = _tmp534_;
								_tmp536_ = vala_expression_get_value_type (_tmp535_);
								_tmp537_ = _tmp536_;
								_tmp538_ = self->priv->_member_name;
								_tmp539_ = vala_void_type_new (NULL);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp542_ = _tmp541_;
								_tmp543_ = vala_dynamic_signal_new (_tmp537_, _tmp538_, (ValaDataType*) _tmp540_, _tmp542_, NULL);
								_tmp544_ = _tmp543_;
								_vala_code_node_unref0 (_tmp540_);
								s = _tmp544_;
								_tmp545_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp546_ = _tmp545_;
								_tmp547_ = vala_code_node_get_parent_node (_tmp546_);
								_tmp548_ = _tmp547_;
								_tmp549_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp548_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp549_;
								_tmp550_ = mcall;
								_tmp551_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp550_);
								_tmp552_ = vala_collection_get_size ((ValaCollection*) _tmp551_);
								_tmp553_ = _tmp552_;
								if (_tmp553_ > 0) {
									ValaDynamicSignal* _tmp554_;
									ValaMethodCall* _tmp555_;
									ValaList* _tmp556_;
									gpointer _tmp557_;
									ValaExpression* _tmp558_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp559_;
									ValaExpression* _tmp560_;
									ValaExpression* _tmp561_;
									gboolean _tmp562_ = FALSE;
									gboolean _tmp563_ = FALSE;
									ValaMemberAccess* _tmp564_;
									_tmp554_ = s;
									_tmp555_ = mcall;
									_tmp556_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp555_);
									_tmp557_ = vala_list_get (_tmp556_, 0);
									_tmp558_ = (ValaExpression*) _tmp557_;
									vala_dynamic_signal_set_handler (_tmp554_, _tmp558_);
									_vala_code_node_unref0 (_tmp558_);
									_tmp559_ = s;
									_tmp560_ = vala_dynamic_signal_get_handler (_tmp559_);
									_tmp561_ = _tmp560_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp561_) ? ((ValaMemberAccess*) _tmp561_) : NULL;
									_tmp564_ = arg;
									if (_tmp564_ == NULL) {
										_tmp563_ = TRUE;
									} else {
										ValaMemberAccess* _tmp565_;
										_tmp565_ = arg;
										_tmp563_ = !vala_code_node_check ((ValaCodeNode*) _tmp565_, context);
									}
									if (_tmp563_) {
										_tmp562_ = TRUE;
									} else {
										ValaMemberAccess* _tmp566_;
										ValaSymbol* _tmp567_;
										ValaSymbol* _tmp568_;
										_tmp566_ = arg;
										_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp566_);
										_tmp568_ = _tmp567_;
										_tmp562_ = !VALA_IS_METHOD (_tmp568_);
									}
									if (_tmp562_) {
										ValaDynamicSignal* _tmp569_;
										ValaExpression* _tmp570_;
										ValaExpression* _tmp571_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp569_ = s;
										_tmp570_ = vala_dynamic_signal_get_handler (_tmp569_);
										_tmp571_ = _tmp570_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp571_)) {
											ValaDynamicSignal* _tmp572_;
											ValaExpression* _tmp573_;
											ValaExpression* _tmp574_;
											ValaSourceReference* _tmp575_;
											ValaSourceReference* _tmp576_;
											_tmp572_ = s;
											_tmp573_ = vala_dynamic_signal_get_handler (_tmp572_);
											_tmp574_ = _tmp573_;
											_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp574_);
											_tmp576_ = _tmp575_;
											vala_report_error (_tmp576_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp577_;
											ValaExpression* _tmp578_;
											ValaExpression* _tmp579_;
											ValaSourceReference* _tmp580_;
											ValaSourceReference* _tmp581_;
											ValaDynamicSignal* _tmp582_;
											gchar* _tmp583_;
											gchar* _tmp584_;
											_tmp577_ = s;
											_tmp578_ = vala_dynamic_signal_get_handler (_tmp577_);
											_tmp579_ = _tmp578_;
											_tmp580_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp579_);
											_tmp581_ = _tmp580_;
											_tmp582_ = s;
											_tmp583_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp582_);
											_tmp584_ = _tmp583_;
											vala_report_error (_tmp581_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp584_);
											_g_free0 (_tmp584_);
										}
									}
								}
								_tmp585_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp585_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp586_ = dynamic_object_type;
								_tmp587_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp586_);
								_tmp588_ = _tmp587_;
								_tmp589_ = vala_symbol_get_scope ((ValaSymbol*) _tmp588_);
								_tmp590_ = _tmp589_;
								_tmp591_ = s;
								vala_scope_add (_tmp590_, NULL, (ValaSymbol*) _tmp591_);
								_tmp592_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp592_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp593_;
								const gchar* _tmp594_;
								_tmp593_ = ma;
								_tmp594_ = _tmp593_->priv->_member_name;
								if (g_strcmp0 (_tmp594_, "emit") == 0) {
									ValaDynamicSignal* s = NULL;
									ValaExpression* _tmp595_;
									ValaExpression* _tmp596_;
									ValaDataType* _tmp597_;
									ValaDataType* _tmp598_;
									const gchar* _tmp599_;
									ValaVoidType* _tmp600_;
									ValaVoidType* _tmp601_;
									ValaSourceReference* _tmp602_;
									ValaSourceReference* _tmp603_;
									ValaDynamicSignal* _tmp604_;
									ValaDynamicSignal* _tmp605_;
									ValaDynamicSignal* _tmp606_;
									ValaDynamicSignal* _tmp607_;
									ValaParameter* _tmp608_;
									ValaParameter* _tmp609_;
									ValaObjectType* _tmp610_;
									ValaTypeSymbol* _tmp611_;
									ValaTypeSymbol* _tmp612_;
									ValaScope* _tmp613_;
									ValaScope* _tmp614_;
									ValaDynamicSignal* _tmp615_;
									ValaDynamicSignal* _tmp616_;
									_tmp595_ = vala_member_access_get_inner (self);
									_tmp596_ = _tmp595_;
									_tmp597_ = vala_expression_get_value_type (_tmp596_);
									_tmp598_ = _tmp597_;
									_tmp599_ = self->priv->_member_name;
									_tmp600_ = vala_void_type_new (NULL);
									_tmp601_ = _tmp600_;
									_tmp602_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp603_ = _tmp602_;
									_tmp604_ = vala_dynamic_signal_new (_tmp598_, _tmp599_, (ValaDataType*) _tmp601_, _tmp603_, NULL);
									_tmp605_ = _tmp604_;
									_vala_code_node_unref0 (_tmp601_);
									s = _tmp605_;
									_tmp606_ = s;
									vala_symbol_set_access ((ValaSymbol*) _tmp606_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
									_tmp607_ = s;
									_tmp608_ = vala_parameter_new_with_ellipsis (NULL);
									_tmp609_ = _tmp608_;
									vala_callable_add_parameter ((ValaCallable*) _tmp607_, _tmp609_);
									_vala_code_node_unref0 (_tmp609_);
									_tmp610_ = dynamic_object_type;
									_tmp611_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp610_);
									_tmp612_ = _tmp611_;
									_tmp613_ = vala_symbol_get_scope ((ValaSymbol*) _tmp612_);
									_tmp614_ = _tmp613_;
									_tmp615_ = s;
									vala_scope_add (_tmp614_, NULL, (ValaSymbol*) _tmp615_);
									_tmp616_ = s;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp616_);
									_vala_code_node_unref0 (s);
								} else {
									ValaMemberAccess* _tmp617_;
									const gchar* _tmp618_;
									_tmp617_ = ma;
									_tmp618_ = _tmp617_->priv->_member_name;
									if (g_strcmp0 (_tmp618_, "disconnect") == 0) {
										ValaMemberAccess* _tmp619_;
										ValaSourceReference* _tmp620_;
										ValaSourceReference* _tmp621_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp619_ = ma;
										_tmp620_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp619_);
										_tmp621_ = _tmp620_;
										vala_report_error (_tmp621_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
									}
								}
							}
						}
					}
				}
				_tmp622_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp623_ = _tmp622_;
				if (_tmp623_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaDataType* _tmp626_;
					ValaDataType* _tmp627_;
					const gchar* _tmp628_;
					ValaSourceReference* _tmp629_;
					ValaSourceReference* _tmp630_;
					ValaDynamicProperty* _tmp631_;
					ValaDataType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDynamicProperty* _tmp644_;
					ValaDynamicProperty* _tmp645_;
					ValaDynamicProperty* _tmp646_;
					ValaDataType* _tmp647_;
					ValaDataType* _tmp648_;
					ValaDataType* _tmp649_;
					ValaDataType* _tmp650_;
					ValaDynamicProperty* _tmp651_;
					ValaSourceReference* _tmp652_;
					ValaSourceReference* _tmp653_;
					ValaPropertyAccessor* _tmp654_;
					ValaPropertyAccessor* _tmp655_;
					ValaDynamicProperty* _tmp656_;
					ValaExpression* _tmp657_;
					ValaExpression* _tmp658_;
					ValaDataType* _tmp659_;
					ValaDataType* _tmp660_;
					ValaTypeSymbol* _tmp661_;
					ValaTypeSymbol* _tmp662_;
					ValaScope* _tmp663_;
					ValaScope* _tmp664_;
					ValaObjectType* _tmp665_;
					ValaTypeSymbol* _tmp666_;
					ValaTypeSymbol* _tmp667_;
					ValaScope* _tmp668_;
					ValaScope* _tmp669_;
					ValaDynamicProperty* _tmp670_;
					ValaDynamicProperty* _tmp671_;
					_tmp624_ = vala_member_access_get_inner (self);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_expression_get_value_type (_tmp625_);
					_tmp627_ = _tmp626_;
					_tmp628_ = self->priv->_member_name;
					_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_dynamic_property_new (_tmp627_, _tmp628_, _tmp630_, NULL);
					prop = _tmp631_;
					_tmp632_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp633_ = _tmp632_;
					if (_tmp633_ != NULL) {
						ValaDynamicProperty* _tmp634_;
						ValaDataType* _tmp635_;
						ValaDataType* _tmp636_;
						_tmp634_ = prop;
						_tmp635_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp636_ = _tmp635_;
						vala_property_set_property_type ((ValaProperty*) _tmp634_, _tmp636_);
					} else {
						ValaDynamicProperty* _tmp637_;
						ValaExpression* _tmp638_;
						ValaExpression* _tmp639_;
						ValaDataType* _tmp640_;
						ValaDataType* _tmp641_;
						ValaDataType* _tmp642_;
						ValaDataType* _tmp643_;
						_tmp637_ = prop;
						_tmp638_ = vala_member_access_get_inner (self);
						_tmp639_ = _tmp638_;
						_tmp640_ = vala_expression_get_value_type (_tmp639_);
						_tmp641_ = _tmp640_;
						_tmp642_ = vala_data_type_copy (_tmp641_);
						_tmp643_ = _tmp642_;
						vala_property_set_property_type ((ValaProperty*) _tmp637_, _tmp643_);
						_vala_code_node_unref0 (_tmp643_);
					}
					_tmp644_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp644_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp645_ = prop;
					_tmp646_ = prop;
					_tmp647_ = vala_property_get_property_type ((ValaProperty*) _tmp646_);
					_tmp648_ = _tmp647_;
					_tmp649_ = vala_data_type_copy (_tmp648_);
					_tmp650_ = _tmp649_;
					_tmp651_ = prop;
					_tmp652_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp650_, NULL, _tmp653_, NULL);
					_tmp655_ = _tmp654_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp645_, _tmp655_);
					_vala_code_node_unref0 (_tmp655_);
					_vala_code_node_unref0 (_tmp650_);
					_tmp656_ = prop;
					_tmp657_ = vala_member_access_get_inner (self);
					_tmp658_ = _tmp657_;
					_tmp659_ = vala_expression_get_value_type (_tmp658_);
					_tmp660_ = _tmp659_;
					_tmp661_ = vala_data_type_get_type_symbol (_tmp660_);
					_tmp662_ = _tmp661_;
					_tmp663_ = vala_symbol_get_scope ((ValaSymbol*) _tmp662_);
					_tmp664_ = _tmp663_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp656_, _tmp664_);
					_tmp665_ = dynamic_object_type;
					_tmp666_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp665_);
					_tmp667_ = _tmp666_;
					_tmp668_ = vala_symbol_get_scope ((ValaSymbol*) _tmp667_);
					_tmp669_ = _tmp668_;
					_tmp670_ = prop;
					vala_scope_add (_tmp669_, NULL, (ValaSymbol*) _tmp670_);
					_tmp671_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp671_);
					_vala_code_node_unref0 (prop);
				}
				_tmp672_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp673_ = _tmp672_;
				if (_tmp673_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp674_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp675_ = _tmp674_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp675_)) {
				ValaExpression* _tmp676_;
				ValaExpression* _tmp677_;
				ValaSymbol* _tmp678_;
				ValaSymbol* _tmp679_;
				_tmp676_ = vala_member_access_get_inner (self);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_expression_get_symbol_reference (_tmp677_);
				_tmp679_ = _tmp678_;
				if (VALA_IS_VARIABLE (_tmp679_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp680_;
					ValaSemanticAnalyzer* _tmp681_;
					ValaExpression* _tmp682_;
					ValaExpression* _tmp683_;
					ValaSymbol* _tmp684_;
					ValaSymbol* _tmp685_;
					ValaDataType* _tmp686_;
					ValaArrayType* _tmp687_;
					gboolean _tmp688_ = FALSE;
					ValaArrayType* _tmp689_;
					_tmp680_ = vala_code_context_get_analyzer (context);
					_tmp681_ = _tmp680_;
					_tmp682_ = vala_member_access_get_inner (self);
					_tmp683_ = _tmp682_;
					_tmp684_ = vala_expression_get_symbol_reference (_tmp683_);
					_tmp685_ = _tmp684_;
					_tmp686_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp681_, _tmp685_, TRUE);
					_tmp687_ = VALA_IS_ARRAY_TYPE (_tmp686_) ? ((ValaArrayType*) _tmp686_) : NULL;
					if (_tmp687_ == NULL) {
						_vala_code_node_unref0 (_tmp686_);
					}
					inner_type = _tmp687_;
					_tmp689_ = inner_type;
					if (_tmp689_ != NULL) {
						ValaArrayType* _tmp690_;
						gboolean _tmp691_;
						gboolean _tmp692_;
						_tmp690_ = inner_type;
						_tmp691_ = vala_array_type_get_inline_allocated (_tmp690_);
						_tmp692_ = _tmp691_;
						_tmp688_ = _tmp692_;
					} else {
						_tmp688_ = FALSE;
					}
					if (_tmp688_) {
						ValaSourceReference* _tmp693_;
						ValaSourceReference* _tmp694_;
						_tmp693_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp694_ = _tmp693_;
						vala_report_error (_tmp694_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp695_ = FALSE;
						ValaArrayType* _tmp696_;
						_tmp696_ = inner_type;
						if (_tmp696_ != NULL) {
							ValaArrayType* _tmp697_;
							gboolean _tmp698_;
							gboolean _tmp699_;
							_tmp697_ = inner_type;
							_tmp698_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp697_);
							_tmp699_ = _tmp698_;
							_tmp695_ = !_tmp699_;
						} else {
							_tmp695_ = FALSE;
						}
						if (_tmp695_) {
							ValaSourceReference* _tmp700_;
							ValaSourceReference* _tmp701_;
							_tmp700_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp701_ = _tmp700_;
							vala_report_error (_tmp701_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp702_;
					ValaExpression* _tmp703_;
					ValaSymbol* _tmp704_;
					ValaSymbol* _tmp705_;
					_tmp702_ = vala_member_access_get_inner (self);
					_tmp703_ = _tmp702_;
					_tmp704_ = vala_expression_get_symbol_reference (_tmp703_);
					_tmp705_ = _tmp704_;
					if (VALA_IS_CONSTANT (_tmp705_)) {
						ValaSourceReference* _tmp706_;
						ValaSourceReference* _tmp707_;
						_tmp706_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp707_ = _tmp706_;
						vala_report_error (_tmp707_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp711_ = vala_member_access_get_inner (self);
	_tmp712_ = _tmp711_;
	if (_tmp712_ == NULL) {
		ValaSymbol* _tmp713_;
		ValaSymbol* _tmp714_;
		_tmp713_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp714_ = _tmp713_;
		_tmp710_ = _tmp714_ == NULL;
	} else {
		_tmp710_ = FALSE;
	}
	if (_tmp710_) {
		ValaDataType* _tmp715_;
		ValaDataType* _tmp716_;
		_tmp715_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp716_ = _tmp715_;
		_tmp709_ = _tmp716_ != NULL;
	} else {
		_tmp709_ = FALSE;
	}
	if (_tmp709_) {
		ValaDataType* _tmp717_;
		ValaDataType* _tmp718_;
		ValaTypeSymbol* _tmp719_;
		ValaTypeSymbol* _tmp720_;
		_tmp717_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp718_ = _tmp717_;
		_tmp719_ = vala_data_type_get_type_symbol (_tmp718_);
		_tmp720_ = _tmp719_;
		_tmp708_ = VALA_IS_ENUM (_tmp720_);
	} else {
		_tmp708_ = FALSE;
	}
	if (_tmp708_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp721_;
		ValaDataType* _tmp722_;
		ValaTypeSymbol* _tmp723_;
		ValaTypeSymbol* _tmp724_;
		_tmp721_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp722_ = _tmp721_;
		_tmp723_ = vala_data_type_get_type_symbol (_tmp722_);
		_tmp724_ = _tmp723_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp724_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp725_;
			ValaList* _tmp726_;
			gint _val_size = 0;
			ValaList* _tmp727_;
			gint _tmp728_;
			gint _tmp729_;
			gint _val_index = 0;
			_tmp725_ = enum_type;
			_tmp726_ = vala_enum_get_values (_tmp725_);
			_val_list = _tmp726_;
			_tmp727_ = _val_list;
			_tmp728_ = vala_collection_get_size ((ValaCollection*) _tmp727_);
			_tmp729_ = _tmp728_;
			_val_size = _tmp729_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp730_;
				gint _tmp731_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp732_;
				gpointer _tmp733_;
				const gchar* _tmp734_;
				ValaEnumValue* _tmp735_;
				const gchar* _tmp736_;
				const gchar* _tmp737_;
				_val_index = _val_index + 1;
				_tmp730_ = _val_index;
				_tmp731_ = _val_size;
				if (!(_tmp730_ < _tmp731_)) {
					break;
				}
				_tmp732_ = _val_list;
				_tmp733_ = vala_list_get (_tmp732_, _val_index);
				val = (ValaEnumValue*) _tmp733_;
				_tmp734_ = self->priv->_member_name;
				_tmp735_ = val;
				_tmp736_ = vala_symbol_get_name ((ValaSymbol*) _tmp735_);
				_tmp737_ = _tmp736_;
				if (g_strcmp0 (_tmp734_, _tmp737_) == 0) {
					ValaEnumValue* _tmp738_;
					_tmp738_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp738_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp739_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp740_ = _tmp739_;
	if (_tmp740_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp741_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp742_ = FALSE;
		ValaExpression* _tmp743_;
		ValaExpression* _tmp744_;
		gchar* base_type_package = NULL;
		gchar* _tmp764_;
		gboolean _tmp765_ = FALSE;
		ValaSymbol* _tmp766_;
		gchar* visited_types_string = NULL;
		gchar* _tmp781_;
		ValaSourceReference* _tmp797_;
		ValaSourceReference* _tmp798_;
		const gchar* _tmp799_;
		const gchar* _tmp800_;
		const gchar* _tmp801_;
		const gchar* _tmp802_;
		ValaInvalidType* _tmp803_;
		ValaInvalidType* _tmp804_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp741_ = g_strdup ("(null)");
		base_type_name = _tmp741_;
		base_type = NULL;
		_tmp743_ = vala_member_access_get_inner (self);
		_tmp744_ = _tmp743_;
		if (_tmp744_ != NULL) {
			ValaExpression* _tmp745_;
			ValaExpression* _tmp746_;
			ValaDataType* _tmp747_;
			ValaDataType* _tmp748_;
			_tmp745_ = vala_member_access_get_inner (self);
			_tmp746_ = _tmp745_;
			_tmp747_ = vala_expression_get_value_type (_tmp746_);
			_tmp748_ = _tmp747_;
			_tmp742_ = _tmp748_ != NULL;
		} else {
			_tmp742_ = FALSE;
		}
		if (_tmp742_) {
			ValaExpression* _tmp749_;
			ValaExpression* _tmp750_;
			ValaDataType* _tmp751_;
			ValaDataType* _tmp752_;
			gchar* _tmp753_;
			ValaExpression* _tmp754_;
			ValaExpression* _tmp755_;
			ValaDataType* _tmp756_;
			ValaDataType* _tmp757_;
			ValaTypeSymbol* _tmp758_;
			ValaTypeSymbol* _tmp759_;
			_tmp749_ = vala_member_access_get_inner (self);
			_tmp750_ = _tmp749_;
			_tmp751_ = vala_expression_get_value_type (_tmp750_);
			_tmp752_ = _tmp751_;
			_tmp753_ = vala_code_node_to_string ((ValaCodeNode*) _tmp752_);
			_g_free0 (base_type_name);
			base_type_name = _tmp753_;
			_tmp754_ = vala_member_access_get_inner (self);
			_tmp755_ = _tmp754_;
			_tmp756_ = vala_expression_get_value_type (_tmp755_);
			_tmp757_ = _tmp756_;
			_tmp758_ = vala_data_type_get_type_symbol (_tmp757_);
			_tmp759_ = _tmp758_;
			base_type = (ValaSymbol*) _tmp759_;
		} else {
			ValaSymbol* _tmp760_;
			_tmp760_ = base_symbol;
			if (_tmp760_ != NULL) {
				ValaSymbol* _tmp761_;
				gchar* _tmp762_;
				ValaSymbol* _tmp763_;
				_tmp761_ = base_symbol;
				_tmp762_ = vala_symbol_get_full_name (_tmp761_);
				_g_free0 (base_type_name);
				base_type_name = _tmp762_;
				_tmp763_ = base_symbol;
				base_type = _tmp763_;
			}
		}
		_tmp764_ = g_strdup ("");
		base_type_package = _tmp764_;
		_tmp766_ = base_type;
		if (_tmp766_ != NULL) {
			ValaSymbol* _tmp767_;
			gboolean _tmp768_;
			gboolean _tmp769_;
			_tmp767_ = base_type;
			_tmp768_ = vala_symbol_get_external_package (_tmp767_);
			_tmp769_ = _tmp768_;
			_tmp765_ = _tmp769_;
		} else {
			_tmp765_ = FALSE;
		}
		if (_tmp765_) {
			ValaSymbol* _tmp770_;
			ValaSourceReference* _tmp771_;
			ValaSourceReference* _tmp772_;
			ValaSourceFile* _tmp773_;
			ValaSourceFile* _tmp774_;
			const gchar* _tmp775_;
			const gchar* _tmp776_;
			gchar* _tmp777_;
			const gchar* _tmp778_;
			_tmp770_ = base_symbol;
			_tmp771_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp770_);
			_tmp772_ = _tmp771_;
			_tmp773_ = vala_source_reference_get_file (_tmp772_);
			_tmp774_ = _tmp773_;
			_tmp775_ = vala_source_file_get_package_name (_tmp774_);
			_tmp776_ = _tmp775_;
			_tmp777_ = g_strdup (_tmp776_);
			_g_free0 (base_type_package);
			base_type_package = _tmp777_;
			_tmp778_ = base_type_package;
			if (_tmp778_ != NULL) {
				const gchar* _tmp779_;
				gchar* _tmp780_;
				_tmp779_ = base_type_package;
				_tmp780_ = g_strdup_printf (" (%s)", _tmp779_);
				_g_free0 (base_type_package);
				base_type_package = _tmp780_;
			}
		}
		_tmp781_ = g_strdup ("");
		visited_types_string = _tmp781_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp782_;
			gint _type_size = 0;
			ValaArrayList* _tmp783_;
			gint _tmp784_;
			gint _tmp785_;
			gint _type_index = 0;
			_tmp782_ = visited_types;
			_type_list = _tmp782_;
			_tmp783_ = _type_list;
			_tmp784_ = vala_collection_get_size ((ValaCollection*) _tmp783_);
			_tmp785_ = _tmp784_;
			_type_size = _tmp785_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp786_;
				gint _tmp787_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp788_;
				gpointer _tmp789_;
				const gchar* _tmp790_;
				ValaDataType* _tmp791_;
				gchar* _tmp792_;
				gchar* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				_type_index = _type_index + 1;
				_tmp786_ = _type_index;
				_tmp787_ = _type_size;
				if (!(_tmp786_ < _tmp787_)) {
					break;
				}
				_tmp788_ = _type_list;
				_tmp789_ = vala_list_get ((ValaList*) _tmp788_, _type_index);
				type = (ValaDataType*) _tmp789_;
				_tmp790_ = visited_types_string;
				_tmp791_ = type;
				_tmp792_ = vala_code_node_to_string ((ValaCodeNode*) _tmp791_);
				_tmp793_ = _tmp792_;
				_tmp794_ = g_strdup_printf (" or `%s'", _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp790_, _tmp795_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp796_;
				_g_free0 (_tmp795_);
				_g_free0 (_tmp793_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp797_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp798_ = _tmp797_;
		_tmp799_ = self->priv->_member_name;
		_tmp800_ = base_type_name;
		_tmp801_ = base_type_package;
		_tmp802_ = visited_types_string;
		vala_report_error (_tmp798_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp799_, _tmp800_, _tmp801_, _tmp802_);
		_tmp803_ = vala_invalid_type_new ();
		_tmp804_ = _tmp803_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp804_);
		_vala_code_node_unref0 (_tmp804_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp805_;
		ValaSymbol* _tmp806_;
		gboolean _tmp807_;
		gboolean _tmp808_;
		_tmp805_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp806_ = _tmp805_;
		_tmp807_ = vala_code_node_get_error ((ValaCodeNode*) _tmp806_);
		_tmp808_ = _tmp807_;
		if (_tmp808_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp809_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp810_ = _tmp809_;
	if (VALA_IS_SIGNAL (_tmp810_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp811_;
		ValaSymbol* _tmp812_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp819_;
		ValaCodeNode* _tmp820_;
		ValaCodeNode* _tmp821_;
		gboolean _tmp822_ = FALSE;
		gboolean _tmp823_ = FALSE;
		gboolean _tmp824_ = FALSE;
		ValaCodeNode* _tmp825_;
		_tmp811_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp812_ = _tmp811_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp812_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp813_;
			ValaCodeNode* _tmp814_;
			ValaCodeNode* _tmp815_;
			ValaCodeNode* _tmp816_;
			ValaCodeNode* _tmp817_;
			ValaCodeNode* _tmp818_;
			_tmp813_ = ma;
			_tmp814_ = vala_code_node_get_parent_node (_tmp813_);
			_tmp815_ = _tmp814_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp815_)) {
				break;
			}
			_tmp816_ = ma;
			_tmp817_ = vala_code_node_get_parent_node (_tmp816_);
			_tmp818_ = _tmp817_;
			ma = _tmp818_;
		}
		_tmp819_ = ma;
		_tmp820_ = vala_code_node_get_parent_node (_tmp819_);
		_tmp821_ = _tmp820_;
		parent = _tmp821_;
		_tmp825_ = parent;
		if (_tmp825_ != NULL) {
			ValaCodeNode* _tmp826_;
			_tmp826_ = parent;
			_tmp824_ = !VALA_IS_ELEMENT_ACCESS (_tmp826_);
		} else {
			_tmp824_ = FALSE;
		}
		if (_tmp824_) {
			ValaCodeNode* _tmp827_;
			ValaExpression* _tmp828_;
			ValaExpression* _tmp829_;
			_tmp827_ = ma;
			_tmp828_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp827_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp829_ = _tmp828_;
			_tmp823_ = !VALA_IS_BASE_ACCESS (_tmp829_);
		} else {
			_tmp823_ = FALSE;
		}
		if (_tmp823_) {
			gboolean _tmp830_ = FALSE;
			ValaCodeNode* _tmp831_;
			_tmp831_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp831_)) {
				_tmp830_ = TRUE;
			} else {
				ValaCodeNode* _tmp832_;
				ValaList* _tmp833_;
				_tmp832_ = parent;
				_tmp833_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp832_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp830_ = vala_collection_contains ((ValaCollection*) _tmp833_, (ValaExpression*) self);
			}
			_tmp822_ = _tmp830_;
		} else {
			_tmp822_ = FALSE;
		}
		if (_tmp822_) {
			ValaSignal* _tmp834_;
			ValaAttribute* _tmp835_;
			_tmp834_ = sig;
			_tmp835_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp834_, "HasEmitter");
			if (_tmp835_ != NULL) {
				ValaSignal* _tmp836_;
				ValaSignal* _tmp837_;
				ValaMethod* _tmp838_;
				ValaMethod* _tmp839_;
				_tmp836_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp836_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp837_ = sig;
				_tmp838_ = vala_signal_get_emitter (_tmp837_);
				_tmp839_ = _tmp838_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp839_);
			} else {
				ValaSourceReference* _tmp840_;
				ValaSourceReference* _tmp841_;
				ValaSymbol* _tmp842_;
				ValaSymbol* _tmp843_;
				gchar* _tmp844_;
				gchar* _tmp845_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp840_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp841_ = _tmp840_;
				_tmp842_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp843_ = _tmp842_;
				_tmp844_ = vala_symbol_get_full_name (_tmp843_);
				_tmp845_ = _tmp844_;
				vala_report_error (_tmp841_, "Signal `%s' requires emitter in this context", _tmp845_);
				_g_free0 (_tmp845_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp846_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp847_ = _tmp846_;
	member = _tmp847_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp848_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp848_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp849_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp849_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp850_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp851_;
		ValaSymbol* _tmp852_;
		ValaSymbol* _tmp853_;
		gboolean _tmp854_ = FALSE;
		ValaBlock* _tmp855_;
		_tmp850_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp850_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp851_ = local;
		_tmp852_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp851_);
		_tmp853_ = _tmp852_;
		block = VALA_IS_BLOCK (_tmp853_) ? ((ValaBlock*) _tmp853_) : NULL;
		_tmp855_ = block;
		if (_tmp855_ != NULL) {
			ValaBlock* _tmp856_;
			ValaSymbol* _tmp857_;
			ValaSemanticAnalyzer* _tmp858_;
			ValaSemanticAnalyzer* _tmp859_;
			ValaSymbol* _tmp860_;
			ValaSymbol* _tmp861_;
			_tmp856_ = block;
			_tmp857_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp856_);
			_tmp858_ = vala_code_context_get_analyzer (context);
			_tmp859_ = _tmp858_;
			_tmp860_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp859_);
			_tmp861_ = _tmp860_;
			_tmp854_ = _tmp857_ != _tmp861_;
		} else {
			_tmp854_ = FALSE;
		}
		if (_tmp854_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp862_;
			ValaSemanticAnalyzer* _tmp863_;
			ValaSymbol* _tmp864_;
			ValaSymbol* _tmp865_;
			ValaLocalVariable* _tmp876_;
			ValaBlock* _tmp877_;
			ValaLocalVariable* _tmp878_;
			ValaDataType* _tmp879_;
			ValaDataType* _tmp880_;
			ValaTypeSymbol* _tmp881_;
			ValaTypeSymbol* _tmp882_;
			ValaSemanticAnalyzer* _tmp883_;
			ValaSemanticAnalyzer* _tmp884_;
			ValaDataType* _tmp885_;
			ValaTypeSymbol* _tmp886_;
			ValaTypeSymbol* _tmp887_;
			_tmp862_ = vala_code_context_get_analyzer (context);
			_tmp863_ = _tmp862_;
			_tmp864_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp863_);
			_tmp865_ = _tmp864_;
			sym = _tmp865_;
			while (TRUE) {
				ValaSymbol* _tmp866_;
				ValaBlock* _tmp867_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp868_;
				ValaMethod* _tmp869_;
				ValaSymbol* _tmp873_;
				ValaSymbol* _tmp874_;
				ValaSymbol* _tmp875_;
				_tmp866_ = sym;
				_tmp867_ = block;
				if (!(_tmp866_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp867_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp868_ = sym;
				method = VALA_IS_METHOD (_tmp868_) ? ((ValaMethod*) _tmp868_) : NULL;
				_tmp869_ = method;
				if (_tmp869_ != NULL) {
					ValaMethod* _tmp870_;
					ValaMethod* _tmp871_;
					ValaLocalVariable* _tmp872_;
					_tmp870_ = method;
					vala_method_set_closure (_tmp870_, TRUE);
					_tmp871_ = method;
					_tmp872_ = local;
					vala_method_add_captured_variable (_tmp871_, _tmp872_);
				}
				_tmp873_ = sym;
				_tmp874_ = vala_symbol_get_parent_symbol (_tmp873_);
				_tmp875_ = _tmp874_;
				sym = _tmp875_;
			}
			_tmp876_ = local;
			vala_local_variable_set_captured (_tmp876_, TRUE);
			_tmp877_ = block;
			vala_block_set_captured (_tmp877_, TRUE);
			_tmp878_ = local;
			_tmp879_ = vala_variable_get_variable_type ((ValaVariable*) _tmp878_);
			_tmp880_ = _tmp879_;
			_tmp881_ = vala_data_type_get_type_symbol (_tmp880_);
			_tmp882_ = _tmp881_;
			_tmp883_ = vala_code_context_get_analyzer (context);
			_tmp884_ = _tmp883_;
			_tmp885_ = _tmp884_->va_list_type;
			_tmp886_ = vala_data_type_get_type_symbol (_tmp885_);
			_tmp887_ = _tmp886_;
			if (_tmp882_ == _tmp887_) {
				ValaSourceReference* _tmp888_;
				ValaSourceReference* _tmp889_;
				ValaLocalVariable* _tmp890_;
				gchar* _tmp891_;
				gchar* _tmp892_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp888_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp889_ = _tmp888_;
				_tmp890_ = local;
				_tmp891_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp890_);
				_tmp892_ = _tmp891_;
				vala_report_error (_tmp889_, "Capturing `va_list' variable `%s' is not allowed", _tmp892_);
				_g_free0 (_tmp892_);
			}
		}
	} else {
		ValaSymbol* _tmp893_;
		_tmp893_ = member;
		if (VALA_IS_PARAMETER (_tmp893_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp894_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp895_;
			ValaSymbol* _tmp896_;
			ValaSymbol* _tmp897_;
			gboolean _tmp898_ = FALSE;
			gboolean _tmp899_ = FALSE;
			ValaMethod* _tmp900_;
			_tmp894_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp894_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp895_ = param;
			_tmp896_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp895_);
			_tmp897_ = _tmp896_;
			m = VALA_IS_METHOD (_tmp897_) ? ((ValaMethod*) _tmp897_) : NULL;
			_tmp900_ = m;
			if (_tmp900_ != NULL) {
				ValaMethod* _tmp901_;
				ValaSemanticAnalyzer* _tmp902_;
				ValaSemanticAnalyzer* _tmp903_;
				ValaSymbol* _tmp904_;
				ValaSymbol* _tmp905_;
				_tmp901_ = m;
				_tmp902_ = vala_code_context_get_analyzer (context);
				_tmp903_ = _tmp902_;
				_tmp904_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp903_);
				_tmp905_ = _tmp904_;
				_tmp899_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp901_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp905_;
			} else {
				_tmp899_ = FALSE;
			}
			if (_tmp899_) {
				ValaParameter* _tmp906_;
				ValaMethod* _tmp907_;
				ValaParameter* _tmp908_;
				ValaParameter* _tmp909_;
				_tmp906_ = param;
				_tmp907_ = m;
				_tmp908_ = vala_method_get_this_parameter (_tmp907_);
				_tmp909_ = _tmp908_;
				_tmp898_ = _tmp906_ != _tmp909_;
			} else {
				_tmp898_ = FALSE;
			}
			if (_tmp898_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp910_;
				ValaSemanticAnalyzer* _tmp911_;
				ValaSymbol* _tmp912_;
				ValaSymbol* _tmp913_;
				ValaParameter* _tmp922_;
				ValaMethod* _tmp923_;
				ValaBlock* _tmp924_;
				ValaBlock* _tmp925_;
				ValaParameter* _tmp926_;
				ValaParameterDirection _tmp927_;
				ValaParameterDirection _tmp928_;
				ValaParameter* _tmp934_;
				ValaDataType* _tmp935_;
				ValaDataType* _tmp936_;
				ValaTypeSymbol* _tmp937_;
				ValaTypeSymbol* _tmp938_;
				ValaSemanticAnalyzer* _tmp939_;
				ValaSemanticAnalyzer* _tmp940_;
				ValaDataType* _tmp941_;
				ValaTypeSymbol* _tmp942_;
				ValaTypeSymbol* _tmp943_;
				_tmp910_ = vala_code_context_get_analyzer (context);
				_tmp911_ = _tmp910_;
				_tmp912_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp911_);
				_tmp913_ = _tmp912_;
				sym = _tmp913_;
				while (TRUE) {
					ValaSymbol* _tmp914_;
					ValaMethod* _tmp915_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp916_;
					ValaMethod* _tmp917_;
					ValaSymbol* _tmp919_;
					ValaSymbol* _tmp920_;
					ValaSymbol* _tmp921_;
					_tmp914_ = sym;
					_tmp915_ = m;
					if (!(_tmp914_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp915_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp916_ = sym;
					method = VALA_IS_METHOD (_tmp916_) ? ((ValaMethod*) _tmp916_) : NULL;
					_tmp917_ = method;
					if (_tmp917_ != NULL) {
						ValaMethod* _tmp918_;
						_tmp918_ = method;
						vala_method_set_closure (_tmp918_, TRUE);
					}
					_tmp919_ = sym;
					_tmp920_ = vala_symbol_get_parent_symbol (_tmp919_);
					_tmp921_ = _tmp920_;
					sym = _tmp921_;
				}
				_tmp922_ = param;
				vala_parameter_set_captured (_tmp922_, TRUE);
				_tmp923_ = m;
				_tmp924_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp923_);
				_tmp925_ = _tmp924_;
				vala_block_set_captured (_tmp925_, TRUE);
				_tmp926_ = param;
				_tmp927_ = vala_parameter_get_direction (_tmp926_);
				_tmp928_ = _tmp927_;
				if (_tmp928_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp929_;
					ValaSourceReference* _tmp930_;
					ValaParameter* _tmp931_;
					gchar* _tmp932_;
					gchar* _tmp933_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp929_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp930_ = _tmp929_;
					_tmp931_ = param;
					_tmp932_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp931_);
					_tmp933_ = _tmp932_;
					vala_report_error (_tmp930_, "Cannot capture reference or output parameter `%s'", _tmp933_);
					_g_free0 (_tmp933_);
				}
				_tmp934_ = param;
				_tmp935_ = vala_variable_get_variable_type ((ValaVariable*) _tmp934_);
				_tmp936_ = _tmp935_;
				_tmp937_ = vala_data_type_get_type_symbol (_tmp936_);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_code_context_get_analyzer (context);
				_tmp940_ = _tmp939_;
				_tmp941_ = _tmp940_->va_list_type;
				_tmp942_ = vala_data_type_get_type_symbol (_tmp941_);
				_tmp943_ = _tmp942_;
				if (_tmp938_ == _tmp943_) {
					ValaSourceReference* _tmp944_;
					ValaSourceReference* _tmp945_;
					ValaParameter* _tmp946_;
					gchar* _tmp947_;
					gchar* _tmp948_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp944_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp945_ = _tmp944_;
					_tmp946_ = param;
					_tmp947_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp946_);
					_tmp948_ = _tmp947_;
					vala_report_error (_tmp945_, "Capturing `va_list' parameter `%s' is not allowed", _tmp948_);
					_g_free0 (_tmp948_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp949_;
				ValaSymbol* _tmp950_;
				ValaSymbol* _tmp951_;
				ValaSymbol* _tmp952_;
				ValaSymbol* _tmp953_;
				gboolean _tmp954_ = FALSE;
				gboolean _tmp955_ = FALSE;
				ValaPropertyAccessor* _tmp956_;
				_tmp949_ = param;
				_tmp950_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp949_);
				_tmp951_ = _tmp950_;
				_tmp952_ = vala_symbol_get_parent_symbol (_tmp951_);
				_tmp953_ = _tmp952_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp953_) ? ((ValaPropertyAccessor*) _tmp953_) : NULL;
				_tmp956_ = acc;
				if (_tmp956_ != NULL) {
					ValaPropertyAccessor* _tmp957_;
					ValaSemanticAnalyzer* _tmp958_;
					ValaSemanticAnalyzer* _tmp959_;
					ValaSymbol* _tmp960_;
					ValaSymbol* _tmp961_;
					_tmp957_ = acc;
					_tmp958_ = vala_code_context_get_analyzer (context);
					_tmp959_ = _tmp958_;
					_tmp960_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp959_);
					_tmp961_ = _tmp960_;
					_tmp955_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp957_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp961_;
				} else {
					_tmp955_ = FALSE;
				}
				if (_tmp955_) {
					ValaParameter* _tmp962_;
					ValaPropertyAccessor* _tmp963_;
					ValaProperty* _tmp964_;
					ValaProperty* _tmp965_;
					ValaParameter* _tmp966_;
					ValaParameter* _tmp967_;
					_tmp962_ = param;
					_tmp963_ = acc;
					_tmp964_ = vala_property_accessor_get_prop (_tmp963_);
					_tmp965_ = _tmp964_;
					_tmp966_ = vala_property_get_this_parameter (_tmp965_);
					_tmp967_ = _tmp966_;
					_tmp954_ = _tmp962_ != _tmp967_;
				} else {
					_tmp954_ = FALSE;
				}
				if (_tmp954_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp968_;
					ValaSemanticAnalyzer* _tmp969_;
					ValaSymbol* _tmp970_;
					ValaSymbol* _tmp971_;
					ValaParameter* _tmp980_;
					ValaPropertyAccessor* _tmp981_;
					ValaBlock* _tmp982_;
					ValaBlock* _tmp983_;
					_tmp968_ = vala_code_context_get_analyzer (context);
					_tmp969_ = _tmp968_;
					_tmp970_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp969_);
					_tmp971_ = _tmp970_;
					sym = _tmp971_;
					while (TRUE) {
						ValaSymbol* _tmp972_;
						ValaMethod* _tmp973_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp974_;
						ValaMethod* _tmp975_;
						ValaSymbol* _tmp977_;
						ValaSymbol* _tmp978_;
						ValaSymbol* _tmp979_;
						_tmp972_ = sym;
						_tmp973_ = m;
						if (!(_tmp972_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp973_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp974_ = sym;
						method = VALA_IS_METHOD (_tmp974_) ? ((ValaMethod*) _tmp974_) : NULL;
						_tmp975_ = method;
						if (_tmp975_ != NULL) {
							ValaMethod* _tmp976_;
							_tmp976_ = method;
							vala_method_set_closure (_tmp976_, TRUE);
						}
						_tmp977_ = sym;
						_tmp978_ = vala_symbol_get_parent_symbol (_tmp977_);
						_tmp979_ = _tmp978_;
						sym = _tmp979_;
					}
					_tmp980_ = param;
					vala_parameter_set_captured (_tmp980_, TRUE);
					_tmp981_ = acc;
					_tmp982_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp981_);
					_tmp983_ = _tmp982_;
					vala_block_set_captured (_tmp983_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp984_;
			_tmp984_ = member;
			if (VALA_IS_FIELD (_tmp984_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp985_;
				ValaField* _tmp986_;
				ValaSymbolAccessibility _tmp987_;
				ValaSymbolAccessibility _tmp988_;
				ValaField* _tmp989_;
				ValaMemberBinding _tmp990_;
				ValaMemberBinding _tmp991_;
				ValaField* _tmp992_;
				ValaMemberBinding _tmp993_;
				ValaMemberBinding _tmp994_;
				ValaField* _tmp995_;
				ValaDataType* _tmp996_;
				ValaDataType* _tmp997_;
				_tmp985_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp985_, VALA_TYPE_FIELD, ValaField);
				_tmp986_ = f;
				_tmp987_ = vala_symbol_get_access ((ValaSymbol*) _tmp986_);
				_tmp988_ = _tmp987_;
				access = _tmp988_;
				_tmp989_ = f;
				_tmp990_ = vala_field_get_binding (_tmp989_);
				_tmp991_ = _tmp990_;
				instance = _tmp991_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp992_ = f;
				_tmp993_ = vala_field_get_binding (_tmp992_);
				_tmp994_ = _tmp993_;
				klass = _tmp994_ == VALA_MEMBER_BINDING_CLASS;
				_tmp995_ = f;
				_tmp996_ = vala_variable_get_variable_type ((ValaVariable*) _tmp995_);
				_tmp997_ = _tmp996_;
				if (VALA_IS_GENERIC_TYPE (_tmp997_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp998_;
				_tmp998_ = member;
				if (VALA_IS_CONSTANT (_tmp998_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp999_;
					ValaConstant* _tmp1000_;
					ValaSymbolAccessibility _tmp1001_;
					ValaSymbolAccessibility _tmp1002_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp1003_;
					ValaSymbol* _tmp1004_;
					ValaSymbol* _tmp1005_;
					gboolean _tmp1006_ = FALSE;
					ValaBlock* _tmp1007_;
					_tmp999_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp999_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp1000_ = c;
					_tmp1001_ = vala_symbol_get_access ((ValaSymbol*) _tmp1000_);
					_tmp1002_ = _tmp1001_;
					access = _tmp1002_;
					_tmp1003_ = c;
					_tmp1004_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1003_);
					_tmp1005_ = _tmp1004_;
					block = VALA_IS_BLOCK (_tmp1005_) ? ((ValaBlock*) _tmp1005_) : NULL;
					_tmp1007_ = block;
					if (_tmp1007_ != NULL) {
						ValaBlock* _tmp1008_;
						ValaSymbol* _tmp1009_;
						ValaSemanticAnalyzer* _tmp1010_;
						ValaSemanticAnalyzer* _tmp1011_;
						ValaSymbol* _tmp1012_;
						ValaSymbol* _tmp1013_;
						_tmp1008_ = block;
						_tmp1009_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1008_);
						_tmp1010_ = vala_code_context_get_analyzer (context);
						_tmp1011_ = _tmp1010_;
						_tmp1012_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1011_);
						_tmp1013_ = _tmp1012_;
						_tmp1006_ = _tmp1009_ != _tmp1013_;
					} else {
						_tmp1006_ = FALSE;
					}
					if (_tmp1006_) {
						ValaSourceReference* _tmp1014_;
						ValaSourceReference* _tmp1015_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1014_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1015_ = _tmp1014_;
						vala_report_error (_tmp1015_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1016_;
					_tmp1016_ = member;
					if (VALA_IS_METHOD (_tmp1016_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1017_;
						ValaMethod* _tmp1018_;
						gboolean _tmp1019_;
						gboolean _tmp1020_;
						ValaMethod* _tmp1107_;
						ValaSymbolAccessibility _tmp1108_;
						ValaSymbolAccessibility _tmp1109_;
						ValaMethod* _tmp1110_;
						ValaMethod* _tmp1114_;
						ValaMemberBinding _tmp1115_;
						ValaMemberBinding _tmp1116_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1136_;
						ValaDataType* _tmp1137_;
						ValaDataType* _tmp1138_;
						gboolean _tmp1139_ = FALSE;
						ValaGenericType* _tmp1140_;
						_tmp1017_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1017_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1018_ = m;
						_tmp1019_ = vala_method_get_is_async_callback (_tmp1018_);
						_tmp1020_ = _tmp1019_;
						if (_tmp1020_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1021_;
							ValaSemanticAnalyzer* _tmp1022_;
							ValaMethod* _tmp1023_;
							ValaMethod* _tmp1024_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1025_;
							ValaMethod* _tmp1052_;
							ValaSemanticAnalyzer* _tmp1053_;
							ValaSemanticAnalyzer* _tmp1054_;
							ValaMethod* _tmp1055_;
							ValaMethod* _tmp1056_;
							ValaMethod* _tmp1072_;
							ValaMethod* _tmp1073_;
							ValaMethod* _tmp1074_;
							ValaSymbol* _tmp1075_;
							ValaSymbol* _tmp1076_;
							_tmp1021_ = vala_code_context_get_analyzer (context);
							_tmp1022_ = _tmp1021_;
							_tmp1023_ = vala_semantic_analyzer_get_current_async_method (_tmp1022_);
							_tmp1024_ = _tmp1023_;
							async_method = _tmp1024_;
							is_valid_access = FALSE;
							_tmp1025_ = async_method;
							if (_tmp1025_ != NULL) {
								ValaMethod* _tmp1026_;
								ValaMethod* _tmp1027_;
								ValaMethod* _tmp1028_;
								_tmp1026_ = m;
								_tmp1027_ = async_method;
								_tmp1028_ = vala_method_get_callback_method (_tmp1027_);
								if (_tmp1026_ == _tmp1028_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1029_ = FALSE;
									ValaMethod* _tmp1030_;
									ValaMethod* _tmp1031_;
									ValaMethod* _tmp1032_;
									_tmp1030_ = async_method;
									_tmp1031_ = vala_method_get_base_method (_tmp1030_);
									_tmp1032_ = _tmp1031_;
									if (_tmp1032_ != NULL) {
										ValaMethod* _tmp1033_;
										ValaMethod* _tmp1034_;
										ValaMethod* _tmp1035_;
										ValaMethod* _tmp1036_;
										ValaMethod* _tmp1037_;
										_tmp1033_ = m;
										_tmp1034_ = async_method;
										_tmp1035_ = vala_method_get_base_method (_tmp1034_);
										_tmp1036_ = _tmp1035_;
										_tmp1037_ = vala_method_get_callback_method (_tmp1036_);
										_tmp1029_ = _tmp1033_ == _tmp1037_;
									} else {
										_tmp1029_ = FALSE;
									}
									if (_tmp1029_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1038_ = FALSE;
										ValaMethod* _tmp1039_;
										ValaMethod* _tmp1040_;
										ValaMethod* _tmp1041_;
										_tmp1039_ = async_method;
										_tmp1040_ = vala_method_get_base_interface_method (_tmp1039_);
										_tmp1041_ = _tmp1040_;
										if (_tmp1041_ != NULL) {
											ValaMethod* _tmp1042_;
											ValaMethod* _tmp1043_;
											ValaMethod* _tmp1044_;
											ValaMethod* _tmp1045_;
											ValaMethod* _tmp1046_;
											_tmp1042_ = m;
											_tmp1043_ = async_method;
											_tmp1044_ = vala_method_get_base_interface_method (_tmp1043_);
											_tmp1045_ = _tmp1044_;
											_tmp1046_ = vala_method_get_callback_method (_tmp1045_);
											_tmp1038_ = _tmp1042_ == _tmp1046_;
										} else {
											_tmp1038_ = FALSE;
										}
										if (_tmp1038_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1047_;
								ValaSourceReference* _tmp1048_;
								ValaMethod* _tmp1049_;
								gchar* _tmp1050_;
								gchar* _tmp1051_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1047_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1048_ = _tmp1047_;
								_tmp1049_ = m;
								_tmp1050_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1049_);
								_tmp1051_ = _tmp1050_;
								vala_report_error (_tmp1048_, "Access to async callback `%s' not allowed in this context", _tmp1051_);
								_g_free0 (_tmp1051_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1052_ = async_method;
							_tmp1053_ = vala_code_context_get_analyzer (context);
							_tmp1054_ = _tmp1053_;
							_tmp1055_ = vala_semantic_analyzer_get_current_method (_tmp1054_);
							_tmp1056_ = _tmp1055_;
							if (_tmp1052_ != _tmp1056_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1057_;
								ValaSemanticAnalyzer* _tmp1058_;
								ValaMethod* _tmp1059_;
								ValaMethod* _tmp1060_;
								ValaMethod* _tmp1069_;
								ValaBlock* _tmp1070_;
								ValaBlock* _tmp1071_;
								_tmp1057_ = vala_code_context_get_analyzer (context);
								_tmp1058_ = _tmp1057_;
								_tmp1059_ = vala_semantic_analyzer_get_current_method (_tmp1058_);
								_tmp1060_ = _tmp1059_;
								sym = (ValaSymbol*) _tmp1060_;
								while (TRUE) {
									ValaSymbol* _tmp1061_;
									ValaMethod* _tmp1062_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1063_;
									ValaMethod* _tmp1064_;
									ValaSymbol* _tmp1066_;
									ValaSymbol* _tmp1067_;
									ValaSymbol* _tmp1068_;
									_tmp1061_ = sym;
									_tmp1062_ = async_method;
									if (!(_tmp1061_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1062_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1063_ = sym;
									method = VALA_IS_METHOD (_tmp1063_) ? ((ValaMethod*) _tmp1063_) : NULL;
									_tmp1064_ = method;
									if (_tmp1064_ != NULL) {
										ValaMethod* _tmp1065_;
										_tmp1065_ = method;
										vala_method_set_closure (_tmp1065_, TRUE);
									}
									_tmp1066_ = sym;
									_tmp1067_ = vala_symbol_get_parent_symbol (_tmp1066_);
									_tmp1068_ = _tmp1067_;
									sym = _tmp1068_;
								}
								_tmp1069_ = async_method;
								_tmp1070_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1069_);
								_tmp1071_ = _tmp1070_;
								vala_block_set_captured (_tmp1071_, TRUE);
							}
							_tmp1072_ = async_method;
							_tmp1073_ = vala_method_get_callback_method (_tmp1072_);
							m = _tmp1073_;
							_tmp1074_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1074_);
							_tmp1075_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1076_ = _tmp1075_;
							member = _tmp1076_;
						} else {
							ValaMethod* _tmp1077_;
							ValaMethod* _tmp1078_;
							ValaMethod* _tmp1079_;
							_tmp1077_ = m;
							_tmp1078_ = vala_method_get_base_method (_tmp1077_);
							_tmp1079_ = _tmp1078_;
							if (_tmp1079_ != NULL) {
								ValaMethod* _tmp1080_;
								ValaMethod* _tmp1081_;
								ValaMethod* _tmp1082_;
								ValaMethod* _tmp1083_;
								ValaSignal* _tmp1084_;
								ValaSignal* _tmp1085_;
								ValaSymbol* _tmp1090_;
								ValaSymbol* _tmp1091_;
								_tmp1080_ = m;
								_tmp1081_ = vala_method_get_base_method (_tmp1080_);
								_tmp1082_ = _tmp1081_;
								m = _tmp1082_;
								_tmp1083_ = m;
								_tmp1084_ = vala_method_get_signal_reference (_tmp1083_);
								_tmp1085_ = _tmp1084_;
								if (_tmp1085_ != NULL) {
									ValaMethod* _tmp1086_;
									ValaSignal* _tmp1087_;
									ValaSignal* _tmp1088_;
									_tmp1086_ = m;
									_tmp1087_ = vala_method_get_signal_reference (_tmp1086_);
									_tmp1088_ = _tmp1087_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1088_);
								} else {
									ValaMethod* _tmp1089_;
									_tmp1089_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1089_);
								}
								_tmp1090_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1091_ = _tmp1090_;
								member = _tmp1091_;
							} else {
								ValaMethod* _tmp1092_;
								ValaMethod* _tmp1093_;
								ValaMethod* _tmp1094_;
								_tmp1092_ = m;
								_tmp1093_ = vala_method_get_base_interface_method (_tmp1092_);
								_tmp1094_ = _tmp1093_;
								if (_tmp1094_ != NULL) {
									ValaMethod* _tmp1095_;
									ValaMethod* _tmp1096_;
									ValaMethod* _tmp1097_;
									ValaMethod* _tmp1098_;
									ValaSignal* _tmp1099_;
									ValaSignal* _tmp1100_;
									ValaSymbol* _tmp1105_;
									ValaSymbol* _tmp1106_;
									_tmp1095_ = m;
									_tmp1096_ = vala_method_get_base_interface_method (_tmp1095_);
									_tmp1097_ = _tmp1096_;
									m = _tmp1097_;
									_tmp1098_ = m;
									_tmp1099_ = vala_method_get_signal_reference (_tmp1098_);
									_tmp1100_ = _tmp1099_;
									if (_tmp1100_ != NULL) {
										ValaMethod* _tmp1101_;
										ValaSignal* _tmp1102_;
										ValaSignal* _tmp1103_;
										_tmp1101_ = m;
										_tmp1102_ = vala_method_get_signal_reference (_tmp1101_);
										_tmp1103_ = _tmp1102_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1103_);
									} else {
										ValaMethod* _tmp1104_;
										_tmp1104_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1104_);
									}
									_tmp1105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1106_ = _tmp1105_;
									member = _tmp1106_;
								}
							}
						}
						_tmp1107_ = m;
						_tmp1108_ = vala_symbol_get_access ((ValaSymbol*) _tmp1107_);
						_tmp1109_ = _tmp1108_;
						access = _tmp1109_;
						_tmp1110_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1110_)) {
							ValaMethod* _tmp1111_;
							ValaMemberBinding _tmp1112_;
							ValaMemberBinding _tmp1113_;
							_tmp1111_ = m;
							_tmp1112_ = vala_method_get_binding (_tmp1111_);
							_tmp1113_ = _tmp1112_;
							instance = _tmp1113_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1114_ = m;
						_tmp1115_ = vala_method_get_binding (_tmp1114_);
						_tmp1116_ = _tmp1115_;
						klass = _tmp1116_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1117_;
							ValaList* _tmp1118_;
							gint _param_size = 0;
							ValaList* _tmp1119_;
							gint _tmp1120_;
							gint _tmp1121_;
							gint _param_index = 0;
							_tmp1117_ = m;
							_tmp1118_ = vala_callable_get_parameters ((ValaCallable*) _tmp1117_);
							_param_list = _tmp1118_;
							_tmp1119_ = _param_list;
							_tmp1120_ = vala_collection_get_size ((ValaCollection*) _tmp1119_);
							_tmp1121_ = _tmp1120_;
							_param_size = _tmp1121_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1122_;
								gint _tmp1123_;
								ValaParameter* param = NULL;
								ValaList* _tmp1124_;
								gpointer _tmp1125_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1126_;
								ValaDataType* _tmp1127_;
								ValaDataType* _tmp1128_;
								gboolean _tmp1129_ = FALSE;
								ValaGenericType* _tmp1130_;
								_param_index = _param_index + 1;
								_tmp1122_ = _param_index;
								_tmp1123_ = _param_size;
								if (!(_tmp1122_ < _tmp1123_)) {
									break;
								}
								_tmp1124_ = _param_list;
								_tmp1125_ = vala_list_get (_tmp1124_, _param_index);
								param = (ValaParameter*) _tmp1125_;
								_tmp1126_ = param;
								_tmp1127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1126_);
								_tmp1128_ = _tmp1127_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1128_) ? ((ValaGenericType*) _tmp1128_) : NULL;
								_tmp1130_ = generic_type;
								if (_tmp1130_ != NULL) {
									ValaGenericType* _tmp1131_;
									ValaTypeParameter* _tmp1132_;
									ValaTypeParameter* _tmp1133_;
									ValaSymbol* _tmp1134_;
									ValaSymbol* _tmp1135_;
									_tmp1131_ = generic_type;
									_tmp1132_ = vala_generic_type_get_type_parameter (_tmp1131_);
									_tmp1133_ = _tmp1132_;
									_tmp1134_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1133_);
									_tmp1135_ = _tmp1134_;
									_tmp1129_ = VALA_IS_TYPESYMBOL (_tmp1135_);
								} else {
									_tmp1129_ = FALSE;
								}
								if (_tmp1129_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1136_ = m;
						_tmp1137_ = vala_callable_get_return_type ((ValaCallable*) _tmp1136_);
						_tmp1138_ = _tmp1137_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1138_) ? ((ValaGenericType*) _tmp1138_) : NULL;
						_tmp1140_ = generic_type;
						if (_tmp1140_ != NULL) {
							ValaGenericType* _tmp1141_;
							ValaTypeParameter* _tmp1142_;
							ValaTypeParameter* _tmp1143_;
							ValaSymbol* _tmp1144_;
							ValaSymbol* _tmp1145_;
							_tmp1141_ = generic_type;
							_tmp1142_ = vala_generic_type_get_type_parameter (_tmp1141_);
							_tmp1143_ = _tmp1142_;
							_tmp1144_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1143_);
							_tmp1145_ = _tmp1144_;
							_tmp1139_ = VALA_IS_TYPESYMBOL (_tmp1145_);
						} else {
							_tmp1139_ = FALSE;
						}
						if (_tmp1139_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1146_;
						_tmp1146_ = member;
						if (VALA_IS_PROPERTY (_tmp1146_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1147_;
							ValaProperty* _tmp1148_;
							ValaProperty* _tmp1149_;
							ValaProperty* _tmp1150_;
							ValaProperty* _tmp1151_;
							ValaProperty* _tmp1167_;
							ValaSymbolAccessibility _tmp1168_;
							ValaSymbolAccessibility _tmp1169_;
							gboolean _tmp1170_;
							gboolean _tmp1171_;
							ValaProperty* _tmp1270_;
							ValaMemberBinding _tmp1271_;
							ValaMemberBinding _tmp1272_;
							ValaProperty* _tmp1273_;
							ValaDataType* _tmp1274_;
							ValaDataType* _tmp1275_;
							_tmp1147_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1147_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1148_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1148_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1149_ = prop;
							_tmp1150_ = vala_property_get_base_property (_tmp1149_);
							_tmp1151_ = _tmp1150_;
							if (_tmp1151_ != NULL) {
								ValaProperty* _tmp1152_;
								ValaProperty* _tmp1153_;
								ValaProperty* _tmp1154_;
								ValaProperty* _tmp1155_;
								ValaSymbol* _tmp1156_;
								ValaSymbol* _tmp1157_;
								_tmp1152_ = prop;
								_tmp1153_ = vala_property_get_base_property (_tmp1152_);
								_tmp1154_ = _tmp1153_;
								prop = _tmp1154_;
								_tmp1155_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1155_);
								_tmp1156_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1157_ = _tmp1156_;
								member = _tmp1157_;
							} else {
								ValaProperty* _tmp1158_;
								ValaProperty* _tmp1159_;
								ValaProperty* _tmp1160_;
								_tmp1158_ = prop;
								_tmp1159_ = vala_property_get_base_interface_property (_tmp1158_);
								_tmp1160_ = _tmp1159_;
								if (_tmp1160_ != NULL) {
									ValaProperty* _tmp1161_;
									ValaProperty* _tmp1162_;
									ValaProperty* _tmp1163_;
									ValaProperty* _tmp1164_;
									ValaSymbol* _tmp1165_;
									ValaSymbol* _tmp1166_;
									_tmp1161_ = prop;
									_tmp1162_ = vala_property_get_base_interface_property (_tmp1161_);
									_tmp1163_ = _tmp1162_;
									prop = _tmp1163_;
									_tmp1164_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1164_);
									_tmp1165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1166_ = _tmp1165_;
									member = _tmp1166_;
								}
							}
							_tmp1167_ = prop;
							_tmp1168_ = vala_symbol_get_access ((ValaSymbol*) _tmp1167_);
							_tmp1169_ = _tmp1168_;
							access = _tmp1169_;
							_tmp1170_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1171_ = _tmp1170_;
							if (_tmp1171_) {
								ValaProperty* _tmp1172_;
								ValaPropertyAccessor* _tmp1173_;
								ValaPropertyAccessor* _tmp1174_;
								ValaProperty* _tmp1218_;
								ValaSymbolAccessibility _tmp1219_;
								ValaSymbolAccessibility _tmp1220_;
								_tmp1172_ = prop;
								_tmp1173_ = vala_property_get_set_accessor (_tmp1172_);
								_tmp1174_ = _tmp1173_;
								if (_tmp1174_ == NULL) {
									ValaSourceReference* _tmp1175_;
									ValaSourceReference* _tmp1176_;
									ValaProperty* _tmp1177_;
									gchar* _tmp1178_;
									gchar* _tmp1179_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1176_ = _tmp1175_;
									_tmp1177_ = prop;
									_tmp1178_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1177_);
									_tmp1179_ = _tmp1178_;
									vala_report_error (_tmp1176_, "Property `%s' is read-only", _tmp1179_);
									_g_free0 (_tmp1179_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1180_ = FALSE;
									ValaProperty* _tmp1181_;
									ValaPropertyAccessor* _tmp1182_;
									ValaPropertyAccessor* _tmp1183_;
									gboolean _tmp1184_;
									gboolean _tmp1185_;
									_tmp1181_ = prop;
									_tmp1182_ = vala_property_get_set_accessor (_tmp1181_);
									_tmp1183_ = _tmp1182_;
									_tmp1184_ = vala_property_accessor_get_writable (_tmp1183_);
									_tmp1185_ = _tmp1184_;
									if (!_tmp1185_) {
										ValaProperty* _tmp1186_;
										ValaPropertyAccessor* _tmp1187_;
										ValaPropertyAccessor* _tmp1188_;
										gboolean _tmp1189_;
										gboolean _tmp1190_;
										_tmp1186_ = prop;
										_tmp1187_ = vala_property_get_set_accessor (_tmp1186_);
										_tmp1188_ = _tmp1187_;
										_tmp1189_ = vala_property_accessor_get_construction (_tmp1188_);
										_tmp1190_ = _tmp1189_;
										_tmp1180_ = _tmp1190_;
									} else {
										_tmp1180_ = FALSE;
									}
									if (_tmp1180_) {
										ValaSemanticAnalyzer* _tmp1191_;
										ValaSemanticAnalyzer* _tmp1192_;
										ValaMethod* _tmp1193_;
										_tmp1191_ = vala_code_context_get_analyzer (context);
										_tmp1192_ = _tmp1191_;
										_tmp1193_ = vala_semantic_analyzer_find_current_method (_tmp1192_);
										if (VALA_IS_CREATION_METHOD (_tmp1193_)) {
											ValaSourceReference* _tmp1194_;
											ValaSourceReference* _tmp1195_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1195_ = _tmp1194_;
											vala_report_error (_tmp1195_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1196_;
											ValaSemanticAnalyzer* _tmp1197_;
											_tmp1196_ = vala_code_context_get_analyzer (context);
											_tmp1197_ = _tmp1196_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1197_)) {
												ValaSemanticAnalyzer* _tmp1198_;
												ValaSemanticAnalyzer* _tmp1199_;
												ValaTypeSymbol* _tmp1200_;
												ValaTypeSymbol* _tmp1201_;
												ValaProperty* _tmp1202_;
												ValaSymbol* _tmp1203_;
												ValaSymbol* _tmp1204_;
												_tmp1198_ = vala_code_context_get_analyzer (context);
												_tmp1199_ = _tmp1198_;
												_tmp1200_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1199_);
												_tmp1201_ = _tmp1200_;
												_tmp1202_ = prop;
												_tmp1203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1202_);
												_tmp1204_ = _tmp1203_;
												if (!vala_typesymbol_is_subtype_of (_tmp1201_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1204_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1205_;
													ValaSourceReference* _tmp1206_;
													ValaProperty* _tmp1207_;
													gchar* _tmp1208_;
													gchar* _tmp1209_;
													ValaSemanticAnalyzer* _tmp1210_;
													ValaSemanticAnalyzer* _tmp1211_;
													ValaTypeSymbol* _tmp1212_;
													ValaTypeSymbol* _tmp1213_;
													gchar* _tmp1214_;
													gchar* _tmp1215_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1206_ = _tmp1205_;
													_tmp1207_ = prop;
													_tmp1208_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1207_);
													_tmp1209_ = _tmp1208_;
													_tmp1210_ = vala_code_context_get_analyzer (context);
													_tmp1211_ = _tmp1210_;
													_tmp1212_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1211_);
													_tmp1213_ = _tmp1212_;
													_tmp1214_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1213_);
													_tmp1215_ = _tmp1214_;
													vala_report_error (_tmp1206_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1209_, _tmp1215_);
													_g_free0 (_tmp1215_);
													_g_free0 (_tmp1209_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1216_;
												ValaSourceReference* _tmp1217_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1216_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1217_ = _tmp1216_;
												vala_report_error (_tmp1217_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1218_ = prop;
								_tmp1219_ = vala_symbol_get_access ((ValaSymbol*) _tmp1218_);
								_tmp1220_ = _tmp1219_;
								if (_tmp1220_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1221_;
									ValaPropertyAccessor* _tmp1222_;
									ValaPropertyAccessor* _tmp1223_;
									ValaSymbolAccessibility _tmp1224_;
									ValaSymbolAccessibility _tmp1225_;
									_tmp1221_ = prop;
									_tmp1222_ = vala_property_get_set_accessor (_tmp1221_);
									_tmp1223_ = _tmp1222_;
									_tmp1224_ = vala_symbol_get_access ((ValaSymbol*) _tmp1223_);
									_tmp1225_ = _tmp1224_;
									access = _tmp1225_;
								} else {
									gboolean _tmp1226_ = FALSE;
									ValaProperty* _tmp1227_;
									ValaSymbolAccessibility _tmp1228_;
									ValaSymbolAccessibility _tmp1229_;
									_tmp1227_ = prop;
									_tmp1228_ = vala_symbol_get_access ((ValaSymbol*) _tmp1227_);
									_tmp1229_ = _tmp1228_;
									if (_tmp1229_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1230_;
										ValaPropertyAccessor* _tmp1231_;
										ValaPropertyAccessor* _tmp1232_;
										ValaSymbolAccessibility _tmp1233_;
										ValaSymbolAccessibility _tmp1234_;
										_tmp1230_ = prop;
										_tmp1231_ = vala_property_get_set_accessor (_tmp1230_);
										_tmp1232_ = _tmp1231_;
										_tmp1233_ = vala_symbol_get_access ((ValaSymbol*) _tmp1232_);
										_tmp1234_ = _tmp1233_;
										_tmp1226_ = _tmp1234_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1226_ = FALSE;
									}
									if (_tmp1226_) {
										ValaProperty* _tmp1235_;
										ValaPropertyAccessor* _tmp1236_;
										ValaPropertyAccessor* _tmp1237_;
										ValaSymbolAccessibility _tmp1238_;
										ValaSymbolAccessibility _tmp1239_;
										_tmp1235_ = prop;
										_tmp1236_ = vala_property_get_set_accessor (_tmp1235_);
										_tmp1237_ = _tmp1236_;
										_tmp1238_ = vala_symbol_get_access ((ValaSymbol*) _tmp1237_);
										_tmp1239_ = _tmp1238_;
										access = _tmp1239_;
									}
								}
							} else {
								ValaProperty* _tmp1240_;
								ValaPropertyAccessor* _tmp1241_;
								ValaPropertyAccessor* _tmp1242_;
								ValaProperty* _tmp1248_;
								ValaSymbolAccessibility _tmp1249_;
								ValaSymbolAccessibility _tmp1250_;
								_tmp1240_ = prop;
								_tmp1241_ = vala_property_get_get_accessor (_tmp1240_);
								_tmp1242_ = _tmp1241_;
								if (_tmp1242_ == NULL) {
									ValaSourceReference* _tmp1243_;
									ValaSourceReference* _tmp1244_;
									ValaProperty* _tmp1245_;
									gchar* _tmp1246_;
									gchar* _tmp1247_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1244_ = _tmp1243_;
									_tmp1245_ = prop;
									_tmp1246_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1245_);
									_tmp1247_ = _tmp1246_;
									vala_report_error (_tmp1244_, "Property `%s' is write-only", _tmp1247_);
									_g_free0 (_tmp1247_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1248_ = prop;
								_tmp1249_ = vala_symbol_get_access ((ValaSymbol*) _tmp1248_);
								_tmp1250_ = _tmp1249_;
								if (_tmp1250_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1251_;
									ValaPropertyAccessor* _tmp1252_;
									ValaPropertyAccessor* _tmp1253_;
									ValaSymbolAccessibility _tmp1254_;
									ValaSymbolAccessibility _tmp1255_;
									_tmp1251_ = prop;
									_tmp1252_ = vala_property_get_get_accessor (_tmp1251_);
									_tmp1253_ = _tmp1252_;
									_tmp1254_ = vala_symbol_get_access ((ValaSymbol*) _tmp1253_);
									_tmp1255_ = _tmp1254_;
									access = _tmp1255_;
								} else {
									gboolean _tmp1256_ = FALSE;
									ValaProperty* _tmp1257_;
									ValaSymbolAccessibility _tmp1258_;
									ValaSymbolAccessibility _tmp1259_;
									_tmp1257_ = prop;
									_tmp1258_ = vala_symbol_get_access ((ValaSymbol*) _tmp1257_);
									_tmp1259_ = _tmp1258_;
									if (_tmp1259_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1260_;
										ValaPropertyAccessor* _tmp1261_;
										ValaPropertyAccessor* _tmp1262_;
										ValaSymbolAccessibility _tmp1263_;
										ValaSymbolAccessibility _tmp1264_;
										_tmp1260_ = prop;
										_tmp1261_ = vala_property_get_get_accessor (_tmp1260_);
										_tmp1262_ = _tmp1261_;
										_tmp1263_ = vala_symbol_get_access ((ValaSymbol*) _tmp1262_);
										_tmp1264_ = _tmp1263_;
										_tmp1256_ = _tmp1264_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1256_ = FALSE;
									}
									if (_tmp1256_) {
										ValaProperty* _tmp1265_;
										ValaPropertyAccessor* _tmp1266_;
										ValaPropertyAccessor* _tmp1267_;
										ValaSymbolAccessibility _tmp1268_;
										ValaSymbolAccessibility _tmp1269_;
										_tmp1265_ = prop;
										_tmp1266_ = vala_property_get_get_accessor (_tmp1265_);
										_tmp1267_ = _tmp1266_;
										_tmp1268_ = vala_symbol_get_access ((ValaSymbol*) _tmp1267_);
										_tmp1269_ = _tmp1268_;
										access = _tmp1269_;
									}
								}
							}
							_tmp1270_ = prop;
							_tmp1271_ = vala_property_get_binding (_tmp1270_);
							_tmp1272_ = _tmp1271_;
							instance = _tmp1272_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1273_ = prop;
							_tmp1274_ = vala_property_get_property_type (_tmp1273_);
							_tmp1275_ = _tmp1274_;
							if (VALA_IS_GENERIC_TYPE (_tmp1275_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1276_;
							_tmp1276_ = member;
							if (VALA_IS_SIGNAL (_tmp1276_)) {
								ValaSymbol* _tmp1277_;
								ValaSymbolAccessibility _tmp1278_;
								ValaSymbolAccessibility _tmp1279_;
								instance = TRUE;
								_tmp1277_ = member;
								_tmp1278_ = vala_symbol_get_access (_tmp1277_);
								_tmp1279_ = _tmp1278_;
								access = _tmp1279_;
							} else {
								gboolean _tmp1280_ = FALSE;
								gboolean _tmp1281_;
								_tmp1281_ = self->priv->_creation_member;
								if (!_tmp1281_) {
									ValaSymbol* _tmp1282_;
									_tmp1282_ = member;
									_tmp1280_ = VALA_IS_ERROR_CODE (_tmp1282_);
								} else {
									_tmp1280_ = FALSE;
								}
								if (_tmp1280_) {
									ValaSymbol* _tmp1283_;
									ValaConstant* _tmp1284_;
									ValaConstant* _tmp1285_;
									ValaSymbol* _tmp1286_;
									ValaSymbol* _tmp1287_;
									_tmp1283_ = member;
									_tmp1284_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1283_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1285_ = _tmp1284_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1285_);
									_tmp1286_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1287_ = _tmp1286_;
									member = _tmp1287_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1288_;
		ValaSymbol* _tmp1289_;
		ValaCodeNode* _tmp1290_;
		ValaCodeNode* _tmp1291_;
		ValaCodeNode* _tmp1292_;
		gboolean _tmp1293_ = FALSE;
		ValaCodeNode* _tmp1294_;
		_tmp1288_ = parent;
		_tmp1289_ = member;
		if (!(_tmp1288_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1289_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1290_ = parent;
		_tmp1291_ = vala_code_node_get_parent_node (_tmp1290_);
		_tmp1292_ = _tmp1291_;
		parent = _tmp1292_;
		_tmp1294_ = parent;
		if (_tmp1294_ == NULL) {
			_tmp1293_ = TRUE;
		} else {
			ValaCodeNode* _tmp1295_;
			ValaSymbol* _tmp1296_;
			_tmp1295_ = parent;
			_tmp1296_ = member;
			_tmp1293_ = _tmp1295_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1296_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1293_) {
			break;
		}
	}
	_tmp1297_ = parent;
	_tmp1298_ = member;
	if (_tmp1297_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1298_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1299_;
		_tmp1299_ = member;
		vala_symbol_set_used (_tmp1299_, TRUE);
	}
	_tmp1300_ = member;
	_tmp1301_ = vala_symbol_get_version (_tmp1300_);
	_tmp1302_ = _tmp1301_;
	_tmp1303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1304_ = _tmp1303_;
	vala_version_attribute_check (_tmp1302_, context, _tmp1304_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1306_;
		ValaSymbol* _tmp1307_;
		ValaSymbol* _tmp1308_;
		_tmp1306_ = member;
		_tmp1307_ = vala_symbol_get_parent_symbol (_tmp1306_);
		_tmp1308_ = _tmp1307_;
		_tmp1305_ = VALA_IS_TYPESYMBOL (_tmp1308_);
	} else {
		_tmp1305_ = FALSE;
	}
	if (_tmp1305_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1309_;
		ValaSymbol* _tmp1310_;
		ValaSymbol* _tmp1311_;
		gboolean in_subtype = FALSE;
		_tmp1309_ = member;
		_tmp1310_ = vala_symbol_get_parent_symbol (_tmp1309_);
		_tmp1311_ = _tmp1310_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1311_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1312_;
			ValaSemanticAnalyzer* _tmp1313_;
			ValaSymbol* _tmp1314_;
			ValaSymbol* _tmp1315_;
			ValaSymbol* _tmp1316_;
			_tmp1312_ = vala_code_context_get_analyzer (context);
			_tmp1313_ = _tmp1312_;
			_tmp1314_ = vala_semantic_analyzer_get_current_symbol (_tmp1313_);
			_tmp1315_ = _tmp1314_;
			_tmp1316_ = _vala_code_node_ref0 (_tmp1315_);
			this_symbol = _tmp1316_;
			{
				gboolean _tmp1317_ = FALSE;
				_tmp1317_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1322_;
					ValaSymbol* _tmp1323_;
					ValaTypeSymbol* _tmp1324_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1325_;
					gboolean _tmp1326_ = FALSE;
					ValaClass* _tmp1327_;
					if (!_tmp1317_) {
						ValaSymbol* _tmp1318_;
						ValaSymbol* _tmp1319_;
						ValaSymbol* _tmp1320_;
						ValaSymbol* _tmp1321_;
						_tmp1318_ = this_symbol;
						_tmp1319_ = vala_symbol_get_parent_symbol (_tmp1318_);
						_tmp1320_ = _tmp1319_;
						_tmp1321_ = _vala_code_node_ref0 (_tmp1320_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1321_;
					}
					_tmp1317_ = FALSE;
					_tmp1322_ = this_symbol;
					if (!(_tmp1322_ != NULL)) {
						break;
					}
					_tmp1323_ = this_symbol;
					_tmp1324_ = target_type;
					if (_tmp1323_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1324_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1325_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1325_) ? ((ValaClass*) _tmp1325_) : NULL;
					_tmp1327_ = cl;
					if (_tmp1327_ != NULL) {
						ValaClass* _tmp1328_;
						ValaTypeSymbol* _tmp1329_;
						_tmp1328_ = cl;
						_tmp1329_ = target_type;
						_tmp1326_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1328_, _tmp1329_);
					} else {
						_tmp1326_ = FALSE;
					}
					if (_tmp1326_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1330_;
			ValaSourceReference* _tmp1331_;
			ValaSymbol* _tmp1332_;
			gchar* _tmp1333_;
			gchar* _tmp1334_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1330_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = member;
			_tmp1333_ = vala_symbol_get_full_name (_tmp1332_);
			_tmp1334_ = _tmp1333_;
			vala_report_error (_tmp1331_, "Access to protected member `%s' denied", _tmp1334_);
			_g_free0 (_tmp1334_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1335_;
			ValaSymbol* _tmp1336_;
			ValaSymbol* _tmp1337_;
			gboolean in_target_type = FALSE;
			_tmp1335_ = member;
			_tmp1336_ = vala_symbol_get_parent_symbol (_tmp1335_);
			_tmp1337_ = _tmp1336_;
			target_type = _tmp1337_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1338_;
				ValaSemanticAnalyzer* _tmp1339_;
				ValaSymbol* _tmp1340_;
				ValaSymbol* _tmp1341_;
				ValaSymbol* _tmp1342_;
				_tmp1338_ = vala_code_context_get_analyzer (context);
				_tmp1339_ = _tmp1338_;
				_tmp1340_ = vala_semantic_analyzer_get_current_symbol (_tmp1339_);
				_tmp1341_ = _tmp1340_;
				_tmp1342_ = _vala_code_node_ref0 (_tmp1341_);
				this_symbol = _tmp1342_;
				{
					gboolean _tmp1343_ = FALSE;
					_tmp1343_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1348_;
						ValaSymbol* _tmp1349_;
						ValaSymbol* _tmp1350_;
						if (!_tmp1343_) {
							ValaSymbol* _tmp1344_;
							ValaSymbol* _tmp1345_;
							ValaSymbol* _tmp1346_;
							ValaSymbol* _tmp1347_;
							_tmp1344_ = this_symbol;
							_tmp1345_ = vala_symbol_get_parent_symbol (_tmp1344_);
							_tmp1346_ = _tmp1345_;
							_tmp1347_ = _vala_code_node_ref0 (_tmp1346_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1347_;
						}
						_tmp1343_ = FALSE;
						_tmp1348_ = this_symbol;
						if (!(_tmp1348_ != NULL)) {
							break;
						}
						_tmp1349_ = target_type;
						_tmp1350_ = this_symbol;
						if (_tmp1349_ == _tmp1350_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1351_;
				ValaSourceReference* _tmp1352_;
				ValaSymbol* _tmp1353_;
				gchar* _tmp1354_;
				gchar* _tmp1355_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1352_ = _tmp1351_;
				_tmp1353_ = member;
				_tmp1354_ = vala_symbol_get_full_name (_tmp1353_);
				_tmp1355_ = _tmp1354_;
				vala_report_error (_tmp1352_, "Access to private member `%s' denied", _tmp1355_);
				_g_free0 (_tmp1355_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1357_;
		ValaExpression* _tmp1358_;
		_tmp1357_ = vala_member_access_get_inner (self);
		_tmp1358_ = _tmp1357_;
		_tmp1356_ = _tmp1358_ != NULL;
	} else {
		_tmp1356_ = FALSE;
	}
	if (_tmp1356_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1359_;
		ValaExpression* _tmp1360_;
		ValaDataType* _tmp1361_;
		ValaDataType* _tmp1362_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1363_;
		ValaExpression* _tmp1364_;
		ValaDataType* _tmp1365_;
		ValaDataType* _tmp1366_;
		ValaPointerType* _tmp1367_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1371_;
		gboolean _tmp1372_ = FALSE;
		gboolean _tmp1373_ = FALSE;
		ValaObjectType* _tmp1374_;
		_tmp1359_ = vala_member_access_get_inner (self);
		_tmp1360_ = _tmp1359_;
		_tmp1361_ = vala_expression_get_value_type (_tmp1360_);
		_tmp1362_ = _tmp1361_;
		instance_type = _tmp1362_;
		_tmp1363_ = vala_member_access_get_inner (self);
		_tmp1364_ = _tmp1363_;
		_tmp1365_ = vala_expression_get_value_type (_tmp1364_);
		_tmp1366_ = _tmp1365_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1366_) ? ((ValaPointerType*) _tmp1366_) : NULL;
		_tmp1367_ = pointer_type;
		if (_tmp1367_ != NULL) {
			ValaPointerType* _tmp1368_;
			ValaDataType* _tmp1369_;
			ValaDataType* _tmp1370_;
			_tmp1368_ = pointer_type;
			_tmp1369_ = vala_pointer_type_get_base_type (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			instance_type = _tmp1370_;
		}
		_tmp1371_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1371_) ? ((ValaObjectType*) _tmp1371_) : NULL;
		_tmp1374_ = object_type;
		if (_tmp1374_ != NULL) {
			ValaObjectType* _tmp1375_;
			ValaObjectTypeSymbol* _tmp1376_;
			ValaObjectTypeSymbol* _tmp1377_;
			_tmp1375_ = object_type;
			_tmp1376_ = vala_object_type_get_object_type_symbol (_tmp1375_);
			_tmp1377_ = _tmp1376_;
			_tmp1373_ = vala_object_type_symbol_has_type_parameters (_tmp1377_);
		} else {
			_tmp1373_ = FALSE;
		}
		if (_tmp1373_) {
			ValaDataType* _tmp1378_;
			_tmp1378_ = instance_type;
			_tmp1372_ = !vala_data_type_has_type_arguments (_tmp1378_);
		} else {
			_tmp1372_ = FALSE;
		}
		if (_tmp1372_) {
			ValaExpression* _tmp1379_;
			ValaExpression* _tmp1380_;
			ValaSourceReference* _tmp1381_;
			ValaSourceReference* _tmp1382_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1379_ = vala_member_access_get_inner (self);
			_tmp1380_ = _tmp1379_;
			_tmp1381_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1380_);
			_tmp1382_ = _tmp1381_;
			vala_report_error (_tmp1382_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1384_ = !may_access_instance_members;
	} else {
		_tmp1384_ = FALSE;
	}
	if (_tmp1384_) {
		_tmp1383_ = TRUE;
	} else {
		gboolean _tmp1385_ = FALSE;
		if (klass) {
			_tmp1385_ = !may_access_klass_members;
		} else {
			_tmp1385_ = FALSE;
		}
		_tmp1383_ = _tmp1385_;
	}
	if (_tmp1383_) {
		ValaSymbol* _tmp1386_;
		ValaSymbol* _tmp1387_;
		ValaDataType* _tmp1418_;
		ValaDataType* _tmp1419_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1386_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1387_ = _tmp1386_;
		if (VALA_IS_METHOD (_tmp1387_)) {
			ValaSemanticAnalyzer* _tmp1388_;
			ValaSemanticAnalyzer* _tmp1389_;
			ValaSymbol* _tmp1390_;
			ValaSymbol* _tmp1391_;
			gboolean _tmp1392_;
			gboolean _tmp1393_;
			ValaDataType* _tmp1394_;
			ValaDataType* _tmp1395_;
			ValaDataType* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaSourceReference* _tmp1398_;
			ValaSourceReference* _tmp1399_;
			_tmp1388_ = vala_code_context_get_analyzer (context);
			_tmp1389_ = _tmp1388_;
			_tmp1390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1391_ = _tmp1390_;
			_tmp1392_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1393_ = _tmp1392_;
			_tmp1394_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1389_, _tmp1391_, _tmp1393_);
			_tmp1395_ = _tmp1394_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1395_);
			_vala_code_node_unref0 (_tmp1395_);
			_tmp1396_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1397_ = _tmp1396_;
			_tmp1398_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1399_ = _tmp1398_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1397_, _tmp1399_);
		} else {
			ValaSymbol* _tmp1400_;
			ValaSymbol* _tmp1401_;
			_tmp1400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1401_ = _tmp1400_;
			if (VALA_IS_FIELD (_tmp1401_)) {
				ValaSymbol* _tmp1402_;
				ValaSymbol* _tmp1403_;
				ValaSourceReference* _tmp1404_;
				ValaSourceReference* _tmp1405_;
				ValaFieldPrototype* _tmp1406_;
				ValaFieldPrototype* _tmp1407_;
				_tmp1402_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1405_ = _tmp1404_;
				_tmp1406_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1403_, VALA_TYPE_FIELD, ValaField), _tmp1405_);
				_tmp1407_ = _tmp1406_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1407_);
				_vala_code_node_unref0 (_tmp1407_);
			} else {
				ValaSymbol* _tmp1408_;
				ValaSymbol* _tmp1409_;
				_tmp1408_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1409_ = _tmp1408_;
				if (VALA_IS_PROPERTY (_tmp1409_)) {
					ValaSymbol* _tmp1410_;
					ValaSymbol* _tmp1411_;
					ValaSourceReference* _tmp1412_;
					ValaSourceReference* _tmp1413_;
					ValaPropertyPrototype* _tmp1414_;
					ValaPropertyPrototype* _tmp1415_;
					_tmp1410_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1411_ = _tmp1410_;
					_tmp1412_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1413_ = _tmp1412_;
					_tmp1414_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1411_, VALA_TYPE_PROPERTY, ValaProperty), _tmp1413_);
					_tmp1415_ = _tmp1414_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1415_);
					_vala_code_node_unref0 (_tmp1415_);
				} else {
					ValaInvalidType* _tmp1416_;
					ValaInvalidType* _tmp1417_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1416_ = vala_invalid_type_new ();
					_tmp1417_ = _tmp1416_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1417_);
					_vala_code_node_unref0 (_tmp1417_);
				}
			}
		}
		_tmp1418_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1419_ = _tmp1418_;
		if (_tmp1419_ != NULL) {
			ValaDataType* _tmp1420_;
			ValaDataType* _tmp1421_;
			ValaDataType* _tmp1422_;
			ValaDataType* _tmp1423_;
			gboolean _tmp1424_;
			gboolean _tmp1425_;
			_tmp1420_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1423_ = _tmp1422_;
			_tmp1424_ = vala_data_type_get_value_owned (_tmp1423_);
			_tmp1425_ = _tmp1424_;
			vala_data_type_set_value_owned (_tmp1421_, _tmp1425_);
		}
	} else {
		gboolean _tmp1426_ = FALSE;
		gboolean _tmp1447_ = FALSE;
		gboolean _tmp1448_ = FALSE;
		gboolean _tmp1449_ = FALSE;
		gboolean _tmp1450_ = FALSE;
		gboolean _tmp1491_ = FALSE;
		gboolean _tmp1492_ = FALSE;
		gboolean _tmp1493_ = FALSE;
		gboolean _tmp1494_ = FALSE;
		gboolean _tmp1495_ = FALSE;
		gboolean _tmp1496_;
		gboolean _tmp1497_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1522_;
		ValaSymbol* _tmp1523_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1524_;
		ValaExpression* _tmp1525_;
		gboolean _tmp1526_ = FALSE;
		gboolean _tmp1527_ = FALSE;
		gboolean _tmp1528_ = FALSE;
		gboolean _tmp1529_ = FALSE;
		gboolean _tmp1530_ = FALSE;
		ValaMethod* _tmp1531_;
		ValaSemanticAnalyzer* _tmp1571_;
		ValaSemanticAnalyzer* _tmp1572_;
		ValaSymbol* _tmp1573_;
		ValaSymbol* _tmp1574_;
		gboolean _tmp1575_;
		gboolean _tmp1576_;
		ValaDataType* _tmp1577_;
		ValaDataType* _tmp1578_;
		gboolean _tmp1579_ = FALSE;
		ValaExpression* _tmp1580_;
		ValaExpression* _tmp1581_;
		ValaSymbol* _tmp1594_;
		ValaSymbol* _tmp1595_;
		gboolean _tmp1669_ = FALSE;
		gboolean _tmp1670_ = FALSE;
		ValaExpression* _tmp1671_;
		ValaExpression* _tmp1672_;
		if (instance) {
			ValaExpression* _tmp1427_;
			ValaExpression* _tmp1428_;
			_tmp1427_ = vala_member_access_get_inner (self);
			_tmp1428_ = _tmp1427_;
			_tmp1426_ = _tmp1428_ == NULL;
		} else {
			_tmp1426_ = FALSE;
		}
		if (_tmp1426_) {
			ValaSourceReference* _tmp1429_;
			ValaSourceReference* _tmp1430_;
			ValaMemberAccess* _tmp1431_;
			ValaMemberAccess* _tmp1432_;
			ValaExpression* _tmp1433_;
			ValaExpression* _tmp1434_;
			ValaParameter* _tmp1435_;
			ValaDataType* _tmp1436_;
			ValaDataType* _tmp1437_;
			ValaDataType* _tmp1438_;
			ValaDataType* _tmp1439_;
			ValaExpression* _tmp1440_;
			ValaExpression* _tmp1441_;
			ValaDataType* _tmp1442_;
			ValaDataType* _tmp1443_;
			ValaExpression* _tmp1444_;
			ValaExpression* _tmp1445_;
			ValaParameter* _tmp1446_;
			_tmp1429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1430_ = _tmp1429_;
			_tmp1431_ = vala_member_access_new (NULL, "this", _tmp1430_);
			_tmp1432_ = _tmp1431_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1432_);
			_vala_code_node_unref0 (_tmp1432_);
			_tmp1433_ = vala_member_access_get_inner (self);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = this_parameter;
			_tmp1436_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1435_);
			_tmp1437_ = _tmp1436_;
			_tmp1438_ = vala_data_type_copy (_tmp1437_);
			_tmp1439_ = _tmp1438_;
			vala_expression_set_value_type (_tmp1434_, _tmp1439_);
			_vala_code_node_unref0 (_tmp1439_);
			_tmp1440_ = vala_member_access_get_inner (self);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = vala_expression_get_value_type (_tmp1441_);
			_tmp1443_ = _tmp1442_;
			vala_data_type_set_value_owned (_tmp1443_, FALSE);
			_tmp1444_ = vala_member_access_get_inner (self);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1445_, (ValaSymbol*) _tmp1446_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1450_ = !klass;
		} else {
			_tmp1450_ = FALSE;
		}
		if (_tmp1450_) {
			ValaSymbol* _tmp1451_;
			ValaSymbol* _tmp1452_;
			_tmp1451_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1452_ = _tmp1451_;
			_tmp1449_ = !VALA_IS_CREATION_METHOD (_tmp1452_);
		} else {
			_tmp1449_ = FALSE;
		}
		if (_tmp1449_) {
			_tmp1448_ = may_access_instance_members;
		} else {
			_tmp1448_ = FALSE;
		}
		if (_tmp1448_) {
			ValaExpression* _tmp1453_;
			ValaExpression* _tmp1454_;
			_tmp1453_ = vala_member_access_get_inner (self);
			_tmp1454_ = _tmp1453_;
			_tmp1447_ = _tmp1454_ != NULL;
		} else {
			_tmp1447_ = FALSE;
		}
		if (_tmp1447_) {
			ValaExpression* _tmp1455_;
			ValaExpression* _tmp1456_;
			ValaSymbol* _tmp1457_;
			ValaSymbol* _tmp1458_;
			_tmp1455_ = vala_member_access_get_inner (self);
			_tmp1456_ = _tmp1455_;
			_tmp1457_ = vala_expression_get_symbol_reference (_tmp1456_);
			_tmp1458_ = _tmp1457_;
			if (VALA_IS_METHOD (_tmp1458_)) {
			} else {
				ValaSourceReference* _tmp1459_;
				ValaSourceReference* _tmp1460_;
				ValaSymbol* _tmp1461_;
				ValaSymbol* _tmp1462_;
				gchar* _tmp1463_;
				gchar* _tmp1464_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1465_;
				ValaSymbol* _tmp1466_;
				ValaSymbol* _tmp1467_;
				ValaSymbol* _tmp1468_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1488_;
				ValaExpression* _tmp1489_;
				ValaExpression* _tmp1490_;
				_tmp1459_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1460_ = _tmp1459_;
				_tmp1461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1462_ = _tmp1461_;
				_tmp1463_ = vala_symbol_get_full_name (_tmp1462_);
				_tmp1464_ = _tmp1463_;
				vala_report_warning (_tmp1460_, "Access to static member `%s' with an instance reference", _tmp1464_);
				_g_free0 (_tmp1464_);
				_tmp1465_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1466_ = _tmp1465_;
				_tmp1467_ = vala_symbol_get_parent_symbol (_tmp1466_);
				_tmp1468_ = _tmp1467_;
				inner_sym = _tmp1468_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1469_ = FALSE;
					ValaSymbol* _tmp1470_;
					ValaMemberAccess* _tmp1474_;
					ValaSymbol* _tmp1475_;
					const gchar* _tmp1476_;
					const gchar* _tmp1477_;
					ValaSourceReference* _tmp1478_;
					ValaSourceReference* _tmp1479_;
					ValaMemberAccess* _tmp1480_;
					ValaMemberAccess* _tmp1481_;
					ValaMemberAccess* _tmp1482_;
					ValaExpression* _tmp1483_;
					ValaExpression* _tmp1484_;
					ValaSymbol* _tmp1485_;
					ValaSymbol* _tmp1486_;
					ValaSymbol* _tmp1487_;
					_tmp1470_ = inner_sym;
					if (_tmp1470_ != NULL) {
						ValaSymbol* _tmp1471_;
						const gchar* _tmp1472_;
						const gchar* _tmp1473_;
						_tmp1471_ = inner_sym;
						_tmp1472_ = vala_symbol_get_name (_tmp1471_);
						_tmp1473_ = _tmp1472_;
						_tmp1469_ = _tmp1473_ != NULL;
					} else {
						_tmp1469_ = FALSE;
					}
					if (!_tmp1469_) {
						break;
					}
					_tmp1474_ = inner_ma;
					_tmp1475_ = inner_sym;
					_tmp1476_ = vala_symbol_get_name (_tmp1475_);
					_tmp1477_ = _tmp1476_;
					_tmp1478_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1479_ = _tmp1478_;
					_tmp1480_ = vala_member_access_new (NULL, _tmp1477_, _tmp1479_);
					_tmp1481_ = _tmp1480_;
					vala_member_access_set_inner (_tmp1474_, (ValaExpression*) _tmp1481_);
					_vala_code_node_unref0 (_tmp1481_);
					_tmp1482_ = inner_ma;
					_tmp1483_ = vala_member_access_get_inner (_tmp1482_);
					_tmp1484_ = _tmp1483_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1484_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1485_ = inner_sym;
					_tmp1486_ = vala_symbol_get_parent_symbol (_tmp1485_);
					_tmp1487_ = _tmp1486_;
					inner_sym = _tmp1487_;
				}
				_tmp1488_ = inner_ma;
				vala_member_access_set_qualified (_tmp1488_, TRUE);
				_tmp1489_ = vala_member_access_get_inner (self);
				_tmp1490_ = _tmp1489_;
				vala_code_node_check ((ValaCodeNode*) _tmp1490_, context);
			}
		}
		_tmp1496_ = vala_code_context_get_experimental_non_null (context);
		_tmp1497_ = _tmp1496_;
		if (_tmp1497_) {
			_tmp1495_ = instance;
		} else {
			_tmp1495_ = FALSE;
		}
		if (_tmp1495_) {
			ValaExpression* _tmp1498_;
			ValaExpression* _tmp1499_;
			ValaDataType* _tmp1500_;
			ValaDataType* _tmp1501_;
			gboolean _tmp1502_;
			gboolean _tmp1503_;
			_tmp1498_ = vala_member_access_get_inner (self);
			_tmp1499_ = _tmp1498_;
			_tmp1500_ = vala_expression_get_value_type (_tmp1499_);
			_tmp1501_ = _tmp1500_;
			_tmp1502_ = vala_data_type_get_nullable (_tmp1501_);
			_tmp1503_ = _tmp1502_;
			_tmp1494_ = _tmp1503_;
		} else {
			_tmp1494_ = FALSE;
		}
		if (_tmp1494_) {
			ValaExpression* _tmp1504_;
			ValaExpression* _tmp1505_;
			ValaDataType* _tmp1506_;
			ValaDataType* _tmp1507_;
			_tmp1504_ = vala_member_access_get_inner (self);
			_tmp1505_ = _tmp1504_;
			_tmp1506_ = vala_expression_get_value_type (_tmp1505_);
			_tmp1507_ = _tmp1506_;
			_tmp1493_ = !VALA_IS_POINTER_TYPE (_tmp1507_);
		} else {
			_tmp1493_ = FALSE;
		}
		if (_tmp1493_) {
			ValaExpression* _tmp1508_;
			ValaExpression* _tmp1509_;
			ValaDataType* _tmp1510_;
			ValaDataType* _tmp1511_;
			_tmp1508_ = vala_member_access_get_inner (self);
			_tmp1509_ = _tmp1508_;
			_tmp1510_ = vala_expression_get_value_type (_tmp1509_);
			_tmp1511_ = _tmp1510_;
			_tmp1492_ = !VALA_IS_GENERIC_TYPE (_tmp1511_);
		} else {
			_tmp1492_ = FALSE;
		}
		if (_tmp1492_) {
			ValaExpression* _tmp1512_;
			ValaExpression* _tmp1513_;
			ValaDataType* _tmp1514_;
			ValaDataType* _tmp1515_;
			_tmp1512_ = vala_member_access_get_inner (self);
			_tmp1513_ = _tmp1512_;
			_tmp1514_ = vala_expression_get_value_type (_tmp1513_);
			_tmp1515_ = _tmp1514_;
			_tmp1491_ = !VALA_IS_ARRAY_TYPE (_tmp1515_);
		} else {
			_tmp1491_ = FALSE;
		}
		if (_tmp1491_) {
			ValaSourceReference* _tmp1516_;
			ValaSourceReference* _tmp1517_;
			ValaSymbol* _tmp1518_;
			ValaSymbol* _tmp1519_;
			gchar* _tmp1520_;
			gchar* _tmp1521_;
			_tmp1516_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1517_ = _tmp1516_;
			_tmp1518_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1519_ = _tmp1518_;
			_tmp1520_ = vala_symbol_get_full_name (_tmp1519_);
			_tmp1521_ = _tmp1520_;
			vala_report_error (_tmp1517_, "Access to instance member `%s' from nullable reference denied", _tmp1521_);
			_g_free0 (_tmp1521_);
		}
		_tmp1522_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1523_ = _tmp1522_;
		m = VALA_IS_METHOD (_tmp1523_) ? ((ValaMethod*) _tmp1523_) : NULL;
		_tmp1524_ = vala_member_access_get_inner (self);
		_tmp1525_ = _tmp1524_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1525_) ? ((ValaMemberAccess*) _tmp1525_) : NULL;
		_tmp1531_ = m;
		if (_tmp1531_ != NULL) {
			ValaMethod* _tmp1532_;
			ValaMemberBinding _tmp1533_;
			ValaMemberBinding _tmp1534_;
			_tmp1532_ = m;
			_tmp1533_ = vala_method_get_binding (_tmp1532_);
			_tmp1534_ = _tmp1533_;
			_tmp1530_ = _tmp1534_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1530_ = FALSE;
		}
		if (_tmp1530_) {
			ValaMethod* _tmp1535_;
			ValaSymbol* _tmp1536_;
			ValaSymbol* _tmp1537_;
			_tmp1535_ = m;
			_tmp1536_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1535_);
			_tmp1537_ = _tmp1536_;
			_tmp1529_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1537_);
		} else {
			_tmp1529_ = FALSE;
		}
		if (_tmp1529_) {
			ValaExpression* _tmp1538_;
			ValaExpression* _tmp1539_;
			_tmp1538_ = vala_member_access_get_inner (self);
			_tmp1539_ = _tmp1538_;
			_tmp1528_ = _tmp1539_ != NULL;
		} else {
			_tmp1528_ = FALSE;
		}
		if (_tmp1528_) {
			ValaExpression* _tmp1540_;
			ValaExpression* _tmp1541_;
			ValaDataType* _tmp1542_;
			ValaDataType* _tmp1543_;
			_tmp1540_ = vala_member_access_get_inner (self);
			_tmp1541_ = _tmp1540_;
			_tmp1542_ = vala_expression_get_value_type (_tmp1541_);
			_tmp1543_ = _tmp1542_;
			_tmp1527_ = _tmp1543_ == NULL;
		} else {
			_tmp1527_ = FALSE;
		}
		if (_tmp1527_) {
			ValaMemberAccess* _tmp1544_;
			ValaList* _tmp1545_;
			gint _tmp1546_;
			gint _tmp1547_;
			_tmp1544_ = inner_ma;
			_tmp1545_ = _tmp1544_->priv->type_argument_list;
			_tmp1546_ = vala_collection_get_size ((ValaCollection*) _tmp1545_);
			_tmp1547_ = _tmp1546_;
			_tmp1526_ = _tmp1547_ > 0;
		} else {
			_tmp1526_ = FALSE;
		}
		if (_tmp1526_) {
			ValaExpression* _tmp1548_;
			ValaExpression* _tmp1549_;
			ValaMethod* _tmp1550_;
			ValaSymbol* _tmp1551_;
			ValaSymbol* _tmp1552_;
			ValaSourceReference* _tmp1553_;
			ValaSourceReference* _tmp1554_;
			ValaObjectType* _tmp1555_;
			ValaObjectType* _tmp1556_;
			_tmp1548_ = vala_member_access_get_inner (self);
			_tmp1549_ = _tmp1548_;
			_tmp1550_ = m;
			_tmp1551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1550_);
			_tmp1552_ = _tmp1551_;
			_tmp1553_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1554_ = _tmp1553_;
			_tmp1555_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1552_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), _tmp1554_);
			_tmp1556_ = _tmp1555_;
			vala_expression_set_value_type (_tmp1549_, (ValaDataType*) _tmp1556_);
			_vala_code_node_unref0 (_tmp1556_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1557_;
				ValaList* _tmp1558_;
				gint _type_argument_size = 0;
				ValaList* _tmp1559_;
				gint _tmp1560_;
				gint _tmp1561_;
				gint _type_argument_index = 0;
				_tmp1557_ = inner_ma;
				_tmp1558_ = _tmp1557_->priv->type_argument_list;
				_type_argument_list = _tmp1558_;
				_tmp1559_ = _type_argument_list;
				_tmp1560_ = vala_collection_get_size ((ValaCollection*) _tmp1559_);
				_tmp1561_ = _tmp1560_;
				_type_argument_size = _tmp1561_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1562_;
					gint _tmp1563_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1564_;
					gpointer _tmp1565_;
					ValaExpression* _tmp1566_;
					ValaExpression* _tmp1567_;
					ValaDataType* _tmp1568_;
					ValaDataType* _tmp1569_;
					ValaDataType* _tmp1570_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1562_ = _type_argument_index;
					_tmp1563_ = _type_argument_size;
					if (!(_tmp1562_ < _tmp1563_)) {
						break;
					}
					_tmp1564_ = _type_argument_list;
					_tmp1565_ = vala_list_get (_tmp1564_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1565_;
					_tmp1566_ = vala_member_access_get_inner (self);
					_tmp1567_ = _tmp1566_;
					_tmp1568_ = vala_expression_get_value_type (_tmp1567_);
					_tmp1569_ = _tmp1568_;
					_tmp1570_ = type_argument;
					vala_data_type_add_type_argument (_tmp1569_, _tmp1570_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1571_ = vala_code_context_get_analyzer (context);
		_tmp1572_ = _tmp1571_;
		_tmp1573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1574_ = _tmp1573_;
		_tmp1575_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1576_ = _tmp1575_;
		_tmp1577_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1572_, _tmp1574_, _tmp1576_);
		_tmp1578_ = _tmp1577_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1578_);
		_vala_code_node_unref0 (_tmp1578_);
		_tmp1580_ = vala_member_access_get_inner (self);
		_tmp1581_ = _tmp1580_;
		if (_tmp1581_ != NULL) {
			ValaDataType* _tmp1582_;
			ValaDataType* _tmp1583_;
			_tmp1582_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1583_ = _tmp1582_;
			_tmp1579_ = _tmp1583_ != NULL;
		} else {
			_tmp1579_ = FALSE;
		}
		if (_tmp1579_) {
			ValaDataType* _tmp1584_;
			ValaDataType* _tmp1585_;
			ValaExpression* _tmp1586_;
			ValaExpression* _tmp1587_;
			ValaDataType* _tmp1588_;
			ValaDataType* _tmp1589_;
			ValaDataType* _tmp1590_;
			ValaDataType* _tmp1591_;
			_tmp1584_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1585_ = _tmp1584_;
			_tmp1586_ = vala_member_access_get_inner (self);
			_tmp1587_ = _tmp1586_;
			_tmp1588_ = vala_expression_get_value_type (_tmp1587_);
			_tmp1589_ = _tmp1588_;
			_tmp1590_ = vala_data_type_get_actual_type (_tmp1585_, _tmp1589_, NULL, (ValaCodeNode*) self);
			_tmp1591_ = _tmp1590_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1591_);
			_vala_code_node_unref0 (_tmp1591_);
		} else {
			ValaDataType* _tmp1592_;
			ValaDataType* _tmp1593_;
			_tmp1592_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1593_ = _tmp1592_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1593_);
		}
		_tmp1594_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1595_ = _tmp1594_;
		if (VALA_IS_METHOD (_tmp1595_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1596_;
			ValaSymbol* _tmp1597_;
			ValaDataType* _tmp1598_;
			ValaDataType* _tmp1599_;
			gboolean _tmp1606_ = FALSE;
			_tmp1596_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1597_ = _tmp1596_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1597_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1598_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1599_ = _tmp1598_;
			if (_tmp1599_ != NULL) {
				ValaDataType* _tmp1600_;
				ValaDataType* _tmp1601_;
				ValaDataType* _tmp1602_;
				ValaDataType* _tmp1603_;
				gboolean _tmp1604_;
				gboolean _tmp1605_;
				_tmp1600_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1601_ = _tmp1600_;
				_tmp1602_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1603_ = _tmp1602_;
				_tmp1604_ = vala_data_type_get_value_owned (_tmp1603_);
				_tmp1605_ = _tmp1604_;
				vala_data_type_set_value_owned (_tmp1601_, _tmp1605_);
			}
			if (instance) {
				ValaMethod* _tmp1607_;
				ValaSymbol* _tmp1608_;
				ValaSymbol* _tmp1609_;
				_tmp1607_ = method;
				_tmp1608_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1607_);
				_tmp1609_ = _tmp1608_;
				_tmp1606_ = VALA_IS_TYPESYMBOL (_tmp1609_);
			} else {
				_tmp1606_ = FALSE;
			}
			if (_tmp1606_) {
				ValaExpression* _tmp1610_;
				ValaExpression* _tmp1611_;
				ValaMethod* _tmp1612_;
				ValaSymbol* _tmp1613_;
				ValaSymbol* _tmp1614_;
				ValaDataType* _tmp1615_;
				ValaDataType* _tmp1616_;
				ValaExpression* _tmp1617_;
				ValaExpression* _tmp1618_;
				ValaDataType* _tmp1619_;
				ValaDataType* _tmp1620_;
				ValaMethod* _tmp1621_;
				ValaParameter* _tmp1622_;
				ValaParameter* _tmp1623_;
				ValaDataType* _tmp1624_;
				ValaDataType* _tmp1625_;
				gboolean _tmp1626_;
				gboolean _tmp1627_;
				_tmp1610_ = vala_member_access_get_inner (self);
				_tmp1611_ = _tmp1610_;
				_tmp1612_ = method;
				_tmp1613_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1612_);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1614_);
				_tmp1616_ = _tmp1615_;
				vala_expression_set_target_type (_tmp1611_, _tmp1616_);
				_vala_code_node_unref0 (_tmp1616_);
				_tmp1617_ = vala_member_access_get_inner (self);
				_tmp1618_ = _tmp1617_;
				_tmp1619_ = vala_expression_get_target_type (_tmp1618_);
				_tmp1620_ = _tmp1619_;
				_tmp1621_ = method;
				_tmp1622_ = vala_method_get_this_parameter (_tmp1621_);
				_tmp1623_ = _tmp1622_;
				_tmp1624_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1623_);
				_tmp1625_ = _tmp1624_;
				_tmp1626_ = vala_data_type_get_value_owned (_tmp1625_);
				_tmp1627_ = _tmp1626_;
				vala_data_type_set_value_owned (_tmp1620_, _tmp1627_);
			}
		} else {
			gboolean _tmp1628_ = FALSE;
			gboolean _tmp1629_ = FALSE;
			ValaSymbol* _tmp1630_;
			ValaSymbol* _tmp1631_;
			_tmp1630_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1631_ = _tmp1630_;
			if (VALA_IS_PROPERTY (_tmp1631_)) {
				_tmp1629_ = instance;
			} else {
				_tmp1629_ = FALSE;
			}
			if (_tmp1629_) {
				ValaSymbol* _tmp1632_;
				ValaSymbol* _tmp1633_;
				ValaSymbol* _tmp1634_;
				ValaSymbol* _tmp1635_;
				_tmp1632_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = vala_symbol_get_parent_symbol (_tmp1633_);
				_tmp1635_ = _tmp1634_;
				_tmp1628_ = _tmp1635_ != NULL;
			} else {
				_tmp1628_ = FALSE;
			}
			if (_tmp1628_) {
				ValaExpression* _tmp1636_;
				ValaExpression* _tmp1637_;
				ValaSymbol* _tmp1638_;
				ValaSymbol* _tmp1639_;
				ValaSymbol* _tmp1640_;
				ValaSymbol* _tmp1641_;
				ValaDataType* _tmp1642_;
				ValaDataType* _tmp1643_;
				_tmp1636_ = vala_member_access_get_inner (self);
				_tmp1637_ = _tmp1636_;
				_tmp1638_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1639_ = _tmp1638_;
				_tmp1640_ = vala_symbol_get_parent_symbol (_tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1641_);
				_tmp1643_ = _tmp1642_;
				vala_expression_set_target_type (_tmp1637_, _tmp1643_);
				_vala_code_node_unref0 (_tmp1643_);
			} else {
				gboolean _tmp1644_ = FALSE;
				gboolean _tmp1645_ = FALSE;
				gboolean _tmp1646_ = FALSE;
				ValaSymbol* _tmp1647_;
				ValaSymbol* _tmp1648_;
				_tmp1647_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1648_ = _tmp1647_;
				if (VALA_IS_FIELD (_tmp1648_)) {
					_tmp1646_ = TRUE;
				} else {
					ValaSymbol* _tmp1649_;
					ValaSymbol* _tmp1650_;
					_tmp1649_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1650_ = _tmp1649_;
					_tmp1646_ = VALA_IS_SIGNAL (_tmp1650_);
				}
				if (_tmp1646_) {
					_tmp1645_ = instance;
				} else {
					_tmp1645_ = FALSE;
				}
				if (_tmp1645_) {
					ValaSymbol* _tmp1651_;
					ValaSymbol* _tmp1652_;
					ValaSymbol* _tmp1653_;
					ValaSymbol* _tmp1654_;
					_tmp1651_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1652_ = _tmp1651_;
					_tmp1653_ = vala_symbol_get_parent_symbol (_tmp1652_);
					_tmp1654_ = _tmp1653_;
					_tmp1644_ = _tmp1654_ != NULL;
				} else {
					_tmp1644_ = FALSE;
				}
				if (_tmp1644_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1655_;
					ValaSymbol* _tmp1656_;
					ValaSymbol* _tmp1657_;
					ValaSymbol* _tmp1658_;
					ValaDataType* _tmp1659_;
					ValaExpression* _tmp1660_;
					ValaExpression* _tmp1661_;
					ValaDataType* _tmp1662_;
					ValaExpression* _tmp1663_;
					ValaExpression* _tmp1664_;
					ValaDataType* _tmp1665_;
					ValaDataType* _tmp1666_;
					ValaDataType* _tmp1667_;
					ValaDataType* _tmp1668_;
					_tmp1655_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1656_ = _tmp1655_;
					_tmp1657_ = vala_symbol_get_parent_symbol (_tmp1656_);
					_tmp1658_ = _tmp1657_;
					_tmp1659_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1658_);
					parent_type = _tmp1659_;
					_tmp1660_ = vala_member_access_get_inner (self);
					_tmp1661_ = _tmp1660_;
					_tmp1662_ = parent_type;
					_tmp1663_ = vala_member_access_get_inner (self);
					_tmp1664_ = _tmp1663_;
					_tmp1665_ = vala_expression_get_value_type (_tmp1664_);
					_tmp1666_ = _tmp1665_;
					_tmp1667_ = vala_data_type_get_actual_type (_tmp1662_, _tmp1666_, NULL, (ValaCodeNode*) self);
					_tmp1668_ = _tmp1667_;
					vala_expression_set_target_type (_tmp1661_, _tmp1668_);
					_vala_code_node_unref0 (_tmp1668_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1671_ = vala_member_access_get_inner (self);
		_tmp1672_ = _tmp1671_;
		if (_tmp1672_ == NULL) {
			ValaDataType* _tmp1673_;
			ValaDataType* _tmp1674_;
			_tmp1673_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1674_ = _tmp1673_;
			_tmp1670_ = _tmp1674_ != NULL;
		} else {
			_tmp1670_ = FALSE;
		}
		if (_tmp1670_) {
			ValaProfile _tmp1675_;
			ValaProfile _tmp1676_;
			_tmp1675_ = vala_code_context_get_profile (context);
			_tmp1676_ = _tmp1675_;
			_tmp1669_ = _tmp1676_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1669_ = FALSE;
		}
		if (_tmp1669_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1677_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1678_ = _tmp1677_;
	if (_tmp1678_ != NULL) {
		ValaDataType* _tmp1679_;
		ValaDataType* _tmp1680_;
		_tmp1679_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1680_ = _tmp1679_;
		vala_code_node_check ((ValaCodeNode*) _tmp1680_, context);
	}
	_tmp1681_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1682_ = _tmp1681_;
	if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp1682_)) {
		gboolean _tmp1683_ = FALSE;
		gboolean _tmp1684_ = FALSE;
		ValaExpression* _tmp1685_;
		ValaExpression* _tmp1686_;
		ValaDataType* _tmp1687_;
		ValaDataType* _tmp1688_;
		_tmp1685_ = vala_member_access_get_inner (self);
		_tmp1686_ = _tmp1685_;
		_tmp1687_ = vala_expression_get_value_type (_tmp1686_);
		_tmp1688_ = _tmp1687_;
		if (VALA_IS_ARRAY_TYPE (_tmp1688_)) {
			ValaExpression* _tmp1689_;
			ValaExpression* _tmp1690_;
			ValaDataType* _tmp1691_;
			ValaDataType* _tmp1692_;
			gint _tmp1693_;
			gint _tmp1694_;
			_tmp1689_ = vala_member_access_get_inner (self);
			_tmp1690_ = _tmp1689_;
			_tmp1691_ = vala_expression_get_value_type (_tmp1690_);
			_tmp1692_ = _tmp1691_;
			_tmp1693_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp1692_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp1694_ = _tmp1693_;
			_tmp1684_ = _tmp1694_ > 1;
		} else {
			_tmp1684_ = FALSE;
		}
		if (_tmp1684_) {
			ValaCodeNode* _tmp1695_;
			ValaCodeNode* _tmp1696_;
			_tmp1695_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp1696_ = _tmp1695_;
			_tmp1683_ = !VALA_IS_ELEMENT_ACCESS (_tmp1696_);
		} else {
			_tmp1683_ = FALSE;
		}
		if (_tmp1683_) {
			ValaSourceReference* _tmp1697_;
			ValaSourceReference* _tmp1698_;
			_tmp1697_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1698_ = _tmp1697_;
			vala_report_error (_tmp1698_, "unsupported use of length field of multi-dimensional array");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		}
	} else {
		ValaSymbol* _tmp1699_;
		ValaSymbol* _tmp1700_;
		_tmp1699_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1700_ = _tmp1699_;
		if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp1700_)) {
			ValaExpression* _tmp1701_;
			ValaExpression* _tmp1702_;
			ValaDataType* _tmp1703_;
			ValaDataType* _tmp1704_;
			ValaDelegate* _tmp1705_;
			ValaDelegate* _tmp1706_;
			gboolean _tmp1707_;
			gboolean _tmp1708_;
			_tmp1701_ = vala_member_access_get_inner (self);
			_tmp1702_ = _tmp1701_;
			_tmp1703_ = vala_expression_get_value_type (_tmp1702_);
			_tmp1704_ = _tmp1703_;
			_tmp1705_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1704_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			_tmp1706_ = _tmp1705_;
			_tmp1707_ = vala_delegate_get_has_target (_tmp1706_);
			_tmp1708_ = _tmp1707_;
			if (!_tmp1708_) {
				ValaSourceReference* _tmp1709_;
				ValaSourceReference* _tmp1710_;
				_tmp1709_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1710_ = _tmp1709_;
				vala_report_error (_tmp1710_, "unsupported use of target field of delegate without target");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
		} else {
			ValaSymbol* _tmp1711_;
			ValaSymbol* _tmp1712_;
			_tmp1711_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1712_ = _tmp1711_;
			if (VALA_IS_DELEGATE_DESTROY_FIELD (_tmp1712_)) {
				ValaExpression* _tmp1713_;
				ValaExpression* _tmp1714_;
				ValaDataType* _tmp1715_;
				ValaDataType* _tmp1716_;
				ValaDelegate* _tmp1717_;
				ValaDelegate* _tmp1718_;
				gboolean _tmp1719_;
				gboolean _tmp1720_;
				_tmp1713_ = vala_member_access_get_inner (self);
				_tmp1714_ = _tmp1713_;
				_tmp1715_ = vala_expression_get_value_type (_tmp1714_);
				_tmp1716_ = _tmp1715_;
				_tmp1717_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1716_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp1718_ = _tmp1717_;
				_tmp1719_ = vala_delegate_get_has_target (_tmp1718_);
				_tmp1720_ = _tmp1719_;
				if (!_tmp1720_) {
					ValaSourceReference* _tmp1721_;
					ValaSourceReference* _tmp1722_;
					_tmp1721_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1722_ = _tmp1721_;
					vala_report_error (_tmp1722_, "unsupported use of destroy field of delegate without target");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp1723_ = self->priv->_tainted_access;
	if (!_tmp1723_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1724_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1725_ = _tmp1724_;
	result = !_tmp1725_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__once = 0;
	if (g_once_init_enter (&vala_member_access_type_id__once)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__once, vala_member_access_type_id);
	}
	return vala_member_access_type_id__once;
}

