// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::TabAlign;
use glib::translate::*;
use std::mem;

glib::wrapper! {
    #[derive(Debug, PartialEq, Eq, PartialOrd, Ord, Hash)]
    pub struct TabArray(Boxed<ffi::PangoTabArray>);

    match fn {
        copy => |ptr| ffi::pango_tab_array_copy(mut_override(ptr)),
        free => |ptr| ffi::pango_tab_array_free(ptr),
        type_ => || ffi::pango_tab_array_get_type(),
    }
}

impl TabArray {
    #[doc(alias = "pango_tab_array_new")]
    pub fn new(initial_size: i32, positions_in_pixels: bool) -> TabArray {
        unsafe {
            from_glib_full(ffi::pango_tab_array_new(
                initial_size,
                positions_in_pixels.into_glib(),
            ))
        }
    }

    //#[doc(alias = "pango_tab_array_new_with_positions")]
    //#[doc(alias = "new_with_positions")]
    //pub fn with_positions(size: i32, positions_in_pixels: bool, first_alignment: TabAlign, first_position: i32, : /*Unknown conversion*//*Unimplemented*/Fundamental: VarArgs) -> TabArray {
    //    unsafe { TODO: call ffi:pango_tab_array_new_with_positions() }
    //}

    #[doc(alias = "pango_tab_array_get_positions_in_pixels")]
    #[doc(alias = "get_positions_in_pixels")]
    pub fn is_positions_in_pixels(&mut self) -> bool {
        unsafe {
            from_glib(ffi::pango_tab_array_get_positions_in_pixels(
                self.to_glib_none_mut().0,
            ))
        }
    }

    #[doc(alias = "pango_tab_array_get_size")]
    #[doc(alias = "get_size")]
    pub fn size(&mut self) -> i32 {
        unsafe { ffi::pango_tab_array_get_size(self.to_glib_none_mut().0) }
    }

    #[doc(alias = "pango_tab_array_get_tab")]
    #[doc(alias = "get_tab")]
    pub fn tab(&mut self, tab_index: i32) -> (TabAlign, i32) {
        unsafe {
            let mut alignment = mem::MaybeUninit::uninit();
            let mut location = mem::MaybeUninit::uninit();
            ffi::pango_tab_array_get_tab(
                self.to_glib_none_mut().0,
                tab_index,
                alignment.as_mut_ptr(),
                location.as_mut_ptr(),
            );
            let alignment = alignment.assume_init();
            let location = location.assume_init();
            (from_glib(alignment), location)
        }
    }

    //#[doc(alias = "pango_tab_array_get_tabs")]
    //#[doc(alias = "get_tabs")]
    //pub fn tabs(&mut self, locations: Vec<i32>) -> TabAlign {
    //    unsafe { TODO: call ffi:pango_tab_array_get_tabs() }
    //}

    #[doc(alias = "pango_tab_array_resize")]
    pub fn resize(&mut self, new_size: i32) {
        unsafe {
            ffi::pango_tab_array_resize(self.to_glib_none_mut().0, new_size);
        }
    }

    #[doc(alias = "pango_tab_array_set_tab")]
    pub fn set_tab(&mut self, tab_index: i32, alignment: TabAlign, location: i32) {
        unsafe {
            ffi::pango_tab_array_set_tab(
                self.to_glib_none_mut().0,
                tab_index,
                alignment.into_glib(),
                location,
            );
        }
    }
}
