# NMake Makefile portion for enabling features for Windows builds

!include detectenv-msvc.mak

# Default prefix if not defined
!ifndef PREFIX
PREFIX=..\..\vs$(VSVER)\$(PLAT)
!endif

# Configurable paths to the various interpreters we need
!ifndef PERL
PERL = perl
!endif

!ifndef PYTHON
PYTHON=python
!endif

# Path to the pkg-config tool, if not already in the PATH
!if "$(PKG_CONFIG)" == ""
PKG_CONFIG=pkg-config
!endif

# Configurable paths to the various scripts and tools that we are using
!ifndef GLIB_MKENUMS
GLIB_MKENUMS = $(PREFIX)\bin\glib-mkenums
!endif

!ifndef GLIB_GENMARSHAL
GLIB_GENMARSHAL = $(PREFIX)\bin\glib-genmarshal
!endif

!ifndef GLIB_COMPILE_RESOURCES
GLIB_COMPILE_RESOURCES = $(PREFIX)\bin\glib-compile-resources.exe
!endif

!ifndef GDBUS_CODEGEN
GDBUS_CODEGEN = $(PREFIX)\bin\gdbus-codegen
!endif

!ifndef GLIB_COMPILE_SCHEMAS
GLIB_COMPILE_SCHEMAS = $(PREFIX)\bin\glib-compile-schemas.exe
!endif

!ifndef MSGFMT
MSGFMT = msgfmt
!endif

!ifndef INCLUDEDIR
INCLUDEDIR=$(PREFIX)\include
!endif

!ifndef LIBDIR
LIBDIR=$(PREFIX)\lib
!endif

!if "$(PLAT)" == "x64"
AT_PLAT=x86_64
!elseif "$(PLAT)" == "arm64"
AT_PLAT=aarch64
!elseif "$(PLAT)" == "Win32"
AT_PLAT=i686
!else
AT_PLAT=unknown
!endif

demo_sources = $(demos_base)
more_demo_sources =	\
	..\demos\gtk-demo\gtkfishbowl.c	\
	..\demos\gtk-demo\main.c

!ifdef FONT_FEATURES_DEMO
demo_sources = $(demo_sources) $(font_features_demo)
!endif

# Please do not change anything beneath this line unless maintaining the NMake Makefiles
GTK_INTERFACE_AGE = 31
GTK_VERSION = 3.24.35

GDK_PREPROCESSOR_FLAGS =	\
	/DG_LOG_USE_STRUCTURED=1	\
	/DGDK_COMPILATION	\
	/I..	\
	/I..\gdk	\
	/I..\gdk\win32

GTK_PREPROCESSOR_FLAGS =	\
	 /I.\vs$(VSVER)\$(CFG)\$(PLAT)\obj\gtk-3\gtk	\
	 /I..\gtk	\
	 /I.\vs$(VSVER)\$(CFG)\$(PLAT)\obj\gdk-3\gdk	\
	 /I..\gdk	\
	 /I..\gdk\win32	\
	 /I.\vs$(VSVER)\$(CFG)\$(PLAT)\obj\gtk-3	\
	 /I.\vs$(VSVER)\$(CFG)\$(PLAT)\obj\gdk-3	\
	 /I..	\
	 /I$(INCLUDEDIR)\gdk-pixbuf-2.0	\
	 /I$(INCLUDEDIR)\pango-1.0	\
	 /I$(INCLUDEDIR)\atk-1.0	\
	 /I$(INCLUDEDIR)\harfbuzz	\
	 /I$(INCLUDEDIR)\cairo	\
	 /I$(INCLUDEDIR)\gio-win32-2.0	\
	 /I$(INCLUDEDIR)\glib-2.0	\
	 /I$(LIBDIR)\glib-2.0\include	\
	 /I$(INCLUDEDIR)	\
	 /DHAVE_CONFIG_H	\
	 /DG_DISABLE_SINGLE_INCLUDES	\
	 /DATK_DISABLE_SINGLE_INCLUDES	\
	 /DGDK_PIXBUF_DISABLE_SINGLE_INCLUDES	\
	 /DGTK_DISABLE_SINGLE_INCLUDES	\
	 /D_USE_MATH_DEFINES	\
	 /DGTK_COMPILATION	\
	 /DG_LOG_DOMAIN=\"Gtk\"	\
	 /DGTK_HOST=\"$(AT_PLAT)-pc-vs$(VSVER)\"	\
	 /DGTK_PRINT_BACKENDS=\"file\"	\
	 /DGTK_PRINT_BACKEND_ENABLE_UNSUPPORTED	\
	 /DINCLUDE_IM_am_et	\
	 /DINCLUDE_IM_cedilla	\
	 /DINCLUDE_IM_cyrillic_translit	\
	 /DINCLUDE_IM_ime	\
	 /DINCLUDE_IM_inuktitut	\
	 /DINCLUDE_IM_ipa	\
	 /DINCLUDE_IM_multipress	\
	 /DINCLUDE_IM_thai	\
	 /DINCLUDE_IM_ti_er	\
	 /DINCLUDE_IM_ti_et	\
	 /DINCLUDE_IM_viqr	\
	 /DGTK_LIBDIR=\"$(PREFIX:\=/)/lib\"	\
	 /DGTK_DATADIR=\"$(PREFIX:\=/)/share\"	\
	 /DGTK_DATA_PREFIX=\"$(PREFIX:\=/)\"	\
	 /DGTK_SYSCONFDIR=\"$(PREFIX:\=/)/etc\"	\
	 /DMULTIPRESS_CONFDIR=\"$(PREFIX:\=/)/etc/gtk-3.0\"	\
	 /DMULTIPRESS_LOCALEDIR=\"$(PREFIX:\=/)/share/locale\"	\
	 /DGTK_VERSION=\"$(GTK_VERSION)\"	\
	 /DGTK_BINARY_VERSION=\"3.0.0\"	\
	 /DGDK_DISABLE_DEPRECATED	\
	 /DISOLATION_AWARE_ENABLED
