#define NLANGUAGES 1100
struct LanguageScripts
{
  const gchar *language;
  const gchar *scripts[6];
};
struct LanguageScripts language_scripts[NLANGUAGES] =
  {
    { "aa", { N_("Latin"), NULL } },
    { "ab", { N_("Cyrillic"), NULL } },
    { "abq", { N_("Cyrillic"), NULL } },
    { "abr", { N_("Latin"), NULL } },
    { "ace", { N_("Latin"), NULL } },
    { "ach", { N_("Latin"), NULL } },
    { "ada", { N_("Latin"), NULL } },
    { "ady", { N_("Cyrillic"), NULL } },
    { "ae", { N_("Avestan"), NULL } },
    { "aeb", { N_("Arabic"), NULL } },
    { "af", { N_("Latin"), NULL } },
    { "agq", { N_("Latin"), NULL } },
    { "aii", { N_("Syriac"), NULL } },
    { "ain", { N_("Katakana"), N_("Latin"), NULL } },
    { "ak", { N_("Latin"), NULL } },
    { "akk", { N_("Cuneiform"), NULL } },
    { "akz", { N_("Latin"), NULL } },
    { "ale", { N_("Latin"), NULL } },
    { "aln", { N_("Latin"), NULL } },
    { "alt", { N_("Cyrillic"), NULL } },
    { "am_ET", { N_("Ethiopic"), NULL } },
    { "amo", { N_("Latin"), NULL } },
    { "an", { N_("Latin"), NULL } },
    { "ang", { N_("Latin"), NULL } },
    { "anp", { N_("Devanagari"), NULL } },
    { "aoz", { N_("Latin"), NULL } },
    { "ar_AE", { N_("Arabic"), NULL } },
    { "ar_BH", { N_("Arabic"), NULL } },
    { "ar_DJ", { N_("Arabic"), NULL } },
    { "ar_DZ", { N_("Arabic"), NULL } },
    { "ar_EG", { N_("Arabic"), NULL } },
    { "ar_EH", { N_("Arabic"), NULL } },
    { "ar_ER", { N_("Arabic"), NULL } },
    { "ar_IL", { N_("Arabic"), NULL } },
    { "ar_IQ", { N_("Arabic"), NULL } },
    { "ar_IR", { N_("Syriac"), NULL } },
    { "ar_JO", { N_("Arabic"), NULL } },
    { "ar_KM", { N_("Arabic"), NULL } },
    { "ar_KW", { N_("Arabic"), NULL } },
    { "ar_LB", { N_("Arabic"), NULL } },
    { "ar_LY", { N_("Arabic"), NULL } },
    { "ar_MA", { N_("Arabic"), NULL } },
    { "ar_MR", { N_("Arabic"), NULL } },
    { "ar_OM", { N_("Arabic"), NULL } },
    { "ar_PS", { N_("Arabic"), NULL } },
    { "ar_QA", { N_("Arabic"), NULL } },
    { "ar_SA", { N_("Arabic"), NULL } },
    { "ar_SD", { N_("Arabic"), NULL } },
    { "ar_SO", { N_("Arabic"), NULL } },
    { "ar_SS", { N_("Syriac"), NULL } },
    { "ar_SY", { N_("Arabic"), NULL } },
    { "ar_TD", { N_("Arabic"), NULL } },
    { "ar_TN", { N_("Arabic"), NULL } },
    { "ar_YE", { N_("Arabic"), NULL } },
    { "arc", { N_("Nabataean"), N_("Palmyrene"), N_("Imperial_Aramaic"), NULL } },
    { "arn", { N_("Latin"), NULL } },
    { "aro", { N_("Latin"), NULL } },
    { "arp", { N_("Latin"), NULL } },
    { "arq", { N_("Arabic"), NULL } },
    { "arw", { N_("Latin"), NULL } },
    { "ary", { N_("Arabic"), NULL } },
    { "arz", { N_("Arabic"), NULL } },
    { "as", { N_("Bengali"), NULL } },
    { "asa", { N_("Latin"), NULL } },
    { "ast", { N_("Latin"), NULL } },
    { "atj", { N_("Latin"), NULL } },
    { "av", { N_("Cyrillic"), NULL } },
    { "avk", { N_("Latin"), NULL } },
    { "awa", { N_("Devanagari"), NULL } },
    { "ay_BO", { N_("Latin"), NULL } },
    { "az_AZ", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "azb", { N_("Arabic"), NULL } },
    { "ba", { N_("Cyrillic"), NULL } },
    { "bal", { N_("Arabic"), NULL } },
    { "bal_AF", { N_("Latin"), NULL } },
    { "bal_IR", { N_("Latin"), NULL } },
    { "bal_PK", { N_("Latin"), NULL } },
    { "ban", { N_("Latin"), NULL } },
    { "ban_ID", { N_("Balinese"), NULL } },
    { "bap", { N_("Devanagari"), NULL } },
    { "bar", { N_("Latin"), NULL } },
    { "bas", { N_("Latin"), NULL } },
    { "bax", { N_("Bamum"), NULL } },
    { "bbc", { N_("Latin"), NULL } },
    { "bbc_ID", { N_("Batak"), NULL } },
    { "bbj", { N_("Latin"), NULL } },
    { "bci", { N_("Latin"), NULL } },
    { "be_BY", { N_("Cyrillic"), NULL } },
    { "bej", { N_("Arabic"), NULL } },
    { "bem", { N_("Latin"), NULL } },
    { "bew", { N_("Latin"), NULL } },
    { "bez", { N_("Latin"), NULL } },
    { "bfd", { N_("Latin"), NULL } },
    { "bfq", { N_("Tamil"), NULL } },
    { "bft", { N_("Tibetan"), NULL } },
    { "bfy", { N_("Devanagari"), NULL } },
    { "bg_BG", { N_("Cyrillic"), NULL } },
    { "bgc", { N_("Devanagari"), NULL } },
    { "bgn", { N_("Arabic"), NULL } },
    { "bgx", { N_("Greek"), NULL } },
    { "bhb", { N_("Devanagari"), NULL } },
    { "bhi", { N_("Devanagari"), NULL } },
    { "bhk", { N_("Latin"), NULL } },
    { "bho", { N_("Devanagari"), NULL } },
    { "bi_VU", { N_("Latin"), NULL } },
    { "bik", { N_("Latin"), NULL } },
    { "bin", { N_("Latin"), NULL } },
    { "bjj", { N_("Devanagari"), NULL } },
    { "bjn", { N_("Latin"), NULL } },
    { "bkm", { N_("Latin"), NULL } },
    { "bku", { N_("Buhid"), NULL } },
    { "bla", { N_("Latin"), NULL } },
    { "blt", { N_("Tai_Viet"), NULL } },
    { "bm", { N_("Nko"), N_("Latin"), NULL } },
    { "bmq", { N_("Latin"), NULL } },
    { "bn_BD", { N_("Bengali"), NULL } },
    { "bo", { N_("Tibetan"), NULL } },
    { "bpy", { N_("Bengali"), NULL } },
    { "bqi", { N_("Arabic"), NULL } },
    { "bqv", { N_("Latin"), NULL } },
    { "br", { N_("Latin"), NULL } },
    { "bra", { N_("Devanagari"), NULL } },
    { "brh", { N_("Arabic"), NULL } },
    { "brh_PK", { N_("Latin"), NULL } },
    { "brx", { N_("Devanagari"), NULL } },
    { "bs_BA", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "bss", { N_("Latin"), NULL } },
    { "bto", { N_("Latin"), NULL } },
    { "btv", { N_("Devanagari"), NULL } },
    { "bua", { N_("Cyrillic"), NULL } },
    { "buc", { N_("Latin"), NULL } },
    { "bug", { N_("Latin"), NULL } },
    { "bug_ID", { N_("Buginese"), NULL } },
    { "bum", { N_("Latin"), NULL } },
    { "bvb", { N_("Latin"), NULL } },
    { "byn", { N_("Ethiopic"), NULL } },
    { "byv", { N_("Latin"), NULL } },
    { "bze", { N_("Latin"), NULL } },
    { "bzx", { N_("Latin"), NULL } },
    { "ca_AD", { N_("Latin"), NULL } },
    { "cad", { N_("Latin"), NULL } },
    { "car", { N_("Latin"), NULL } },
    { "cay", { N_("Latin"), NULL } },
    { "cch", { N_("Latin"), NULL } },
    { "ccp", { N_("Chakma"), NULL } },
    { "ce", { N_("Cyrillic"), NULL } },
    { "ceb", { N_("Latin"), NULL } },
    { "cgg", { N_("Latin"), NULL } },
    { "ch_GU", { N_("Latin"), NULL } },
    { "chk", { N_("Latin"), NULL } },
    { "chm", { N_("Cyrillic"), NULL } },
    { "chn", { N_("Latin"), NULL } },
    { "cho", { N_("Latin"), NULL } },
    { "chp", { N_("Canadian_Aboriginal"), NULL } },
    { "chr", { N_("Cherokee"), NULL } },
    { "chy", { N_("Latin"), NULL } },
    { "cja", { N_("Cham"), NULL } },
    { "cjm", { N_("Arabic"), NULL } },
    { "cjs", { N_("Cyrillic"), NULL } },
    { "ckb", { N_("Arabic"), NULL } },
    { "ckt", { N_("Cyrillic"), NULL } },
    { "co", { N_("Latin"), NULL } },
    { "cop", { N_("Greek"), N_("Arabic"), N_("Coptic"), NULL } },
    { "cps", { N_("Latin"), NULL } },
    { "cr", { N_("Canadian_Aboriginal"), N_("Latin"), NULL } },
    { "crh", { N_("Cyrillic"), NULL } },
    { "crj", { N_("Latin"), NULL } },
    { "crk", { N_("Canadian_Aboriginal"), NULL } },
    { "crl", { N_("Latin"), NULL } },
    { "crm", { N_("Canadian_Aboriginal"), NULL } },
    { "crs", { N_("Latin"), NULL } },
    { "cs_CZ", { N_("Latin"), NULL } },
    { "csb_PL", { N_("Latin"), NULL } },
    { "csw", { N_("Canadian_Aboriginal"), NULL } },
    { "ctd", { N_("Latin"), NULL } },
    { "cu", { N_("Cyrillic"), NULL } },
    { "cv", { N_("Cyrillic"), NULL } },
    { "cy", { N_("Latin"), NULL } },
    { "da_DK", { N_("Latin"), NULL } },
    { "dak", { N_("Latin"), NULL } },
    { "dar", { N_("Cyrillic"), NULL } },
    { "dav", { N_("Latin"), NULL } },
    { "dcc", { N_("Arabic"), NULL } },
    { "de_AT", { N_("Latin"), NULL } },
    { "de_BE", { N_("Latin"), NULL } },
    { "de_BR", { N_("Runic"), NULL } },
    { "de_CH", { N_("Latin"), NULL } },
    { "de_DE", { N_("Latin"), NULL } },
    { "de_DK", { N_("Runic"), NULL } },
    { "de_KZ", { N_("Runic"), NULL } },
    { "de_LI", { N_("Latin"), NULL } },
    { "de_LU", { N_("Latin"), NULL } },
    { "de_PL", { N_("Runic"), NULL } },
    { "de_US", { N_("Runic"), NULL } },
    { "del", { N_("Latin"), NULL } },
    { "den", { N_("Canadian_Aboriginal"), NULL } },
    { "dgr", { N_("Latin"), NULL } },
    { "din", { N_("Latin"), NULL } },
    { "dje", { N_("Latin"), NULL } },
    { "dng", { N_("Cyrillic"), NULL } },
    { "dnj", { N_("Latin"), NULL } },
    { "doi", { N_("Arabic"), NULL } },
    { "doi_IN", { N_("Takri"), NULL } },
    { "dsb", { N_("Latin"), NULL } },
    { "dtm", { N_("Latin"), NULL } },
    { "dtp", { N_("Latin"), NULL } },
    { "dua", { N_("Latin"), NULL } },
    { "dum", { N_("Latin"), NULL } },
    { "dv_MV", { N_("Thaana"), NULL } },
    { "dyo", { N_("Arabic"), NULL } },
    { "dyu", { N_("Latin"), NULL } },
    { "dz_BT", { N_("Tibetan"), NULL } },
    { "ebu", { N_("Latin"), NULL } },
    { "ee", { N_("Latin"), NULL } },
    { "efi", { N_("Latin"), NULL } },
    { "egl", { N_("Latin"), NULL } },
    { "egy", { N_("Egyptian_Hieroglyphs"), NULL } },
    { "eka", { N_("Latin"), NULL } },
    { "eky", { N_("Kayah_Li"), NULL } },
    { "el_CY", { N_("Greek"), NULL } },
    { "el_GR", { N_("Greek"), NULL } },
    { "en", { N_("Latin"), NULL } },
    { "en_AC", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_AG", { N_("Latin"), NULL } },
    { "en_AI", { N_("Latin"), NULL } },
    { "en_AR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_AS", { N_("Latin"), NULL } },
    { "en_AT", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_AU", { N_("Latin"), NULL } },
    { "en_BA", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_BB", { N_("Latin"), NULL } },
    { "en_BD", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_BE", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_BG", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_BM", { N_("Latin"), NULL } },
    { "en_BR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_BS", { N_("Latin"), NULL } },
    { "en_BW", { N_("Latin"), NULL } },
    { "en_BZ", { N_("Latin"), NULL } },
    { "en_CA", { N_("Latin"), NULL } },
    { "en_CC", { N_("Latin"), NULL } },
    { "en_CH", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_CK", { N_("Latin"), NULL } },
    { "en_CL", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_CM", { N_("Latin"), NULL } },
    { "en_CX", { N_("Latin"), NULL } },
    { "en_CY", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_CZ", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_DE", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_DG", { N_("Latin"), NULL } },
    { "en_DK", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_DM", { N_("Latin"), NULL } },
    { "en_DZ", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_EG", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_ER", { N_("Latin"), NULL } },
    { "en_ES", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_ET", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_FI", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_FJ", { N_("Latin"), NULL } },
    { "en_FK", { N_("Latin"), NULL } },
    { "en_FM", { N_("Latin"), NULL } },
    { "en_FR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_GB", { N_("Latin"), NULL } },
    { "en_GD", { N_("Latin"), NULL } },
    { "en_GG", { N_("Latin"), NULL } },
    { "en_GH", { N_("Latin"), NULL } },
    { "en_GI", { N_("Latin"), NULL } },
    { "en_GM", { N_("Latin"), NULL } },
    { "en_GR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_GU", { N_("Latin"), NULL } },
    { "en_GY", { N_("Latin"), NULL } },
    { "en_HK", { N_("Latin"), NULL } },
    { "en_HR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_HU", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_IE", { N_("Latin"), NULL } },
    { "en_IL", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_IM", { N_("Latin"), NULL } },
    { "en_IN", { N_("Latin"), NULL } },
    { "en_IO", { N_("Latin"), NULL } },
    { "en_IQ", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_IT", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_JE", { N_("Latin"), NULL } },
    { "en_JM", { N_("Latin"), NULL } },
    { "en_JO", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_KE", { N_("Latin"), NULL } },
    { "en_KI", { N_("Latin"), NULL } },
    { "en_KN", { N_("Latin"), NULL } },
    { "en_KY", { N_("Latin"), NULL } },
    { "en_KZ", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_LB", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_LC", { N_("Latin"), NULL } },
    { "en_LK", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_LR", { N_("Latin"), NULL } },
    { "en_LS", { N_("Latin"), NULL } },
    { "en_LT", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_MA", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_MG", { N_("Latin"), NULL } },
    { "en_MH", { N_("Latin"), NULL } },
    { "en_MP", { N_("Latin"), NULL } },
    { "en_MS", { N_("Latin"), NULL } },
    { "en_MT", { N_("Latin"), NULL } },
    { "en_MU", { N_("Latin"), NULL } },
    { "en_MW", { N_("Latin"), NULL } },
    { "en_MX", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_MY", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_NA", { N_("Latin"), NULL } },
    { "en_NF", { N_("Latin"), NULL } },
    { "en_NG", { N_("Latin"), NULL } },
    { "en_NL", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_NR", { N_("Latin"), NULL } },
    { "en_NU", { N_("Latin"), NULL } },
    { "en_NZ", { N_("Latin"), NULL } },
    { "en_PG", { N_("Latin"), NULL } },
    { "en_PH", { N_("Latin"), NULL } },
    { "en_PK", { N_("Latin"), NULL } },
    { "en_PL", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_PN", { N_("Latin"), NULL } },
    { "en_PR", { N_("Latin"), NULL } },
    { "en_PT", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_PW", { N_("Latin"), NULL } },
    { "en_RO", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_RW", { N_("Latin"), NULL } },
    { "en_SB", { N_("Latin"), NULL } },
    { "en_SC", { N_("Latin"), NULL } },
    { "en_SD", { N_("Latin"), NULL } },
    { "en_SE", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_SG", { N_("Latin"), NULL } },
    { "en_SH", { N_("Latin"), NULL } },
    { "en_SI", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_SK", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_SL", { N_("Latin"), NULL } },
    { "en_SS", { N_("Latin"), NULL } },
    { "en_SX", { N_("Latin"), NULL } },
    { "en_SZ", { N_("Latin"), NULL } },
    { "en_TA", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_TC", { N_("Latin"), NULL } },
    { "en_TH", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_TK", { N_("Latin"), NULL } },
    { "en_TO", { N_("Latin"), NULL } },
    { "en_TR", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_TT", { N_("Latin"), NULL } },
    { "en_TV", { N_("Latin"), NULL } },
    { "en_TZ", { N_("Latin"), NULL } },
    { "en_UG", { N_("Latin"), NULL } },
    { "en_UM", { N_("Latin"), NULL } },
    { "en_US", { N_("Latin"), NULL } },
    { "en_VC", { N_("Latin"), NULL } },
    { "en_VG", { N_("Latin"), NULL } },
    { "en_VI", { N_("Latin"), NULL } },
    { "en_VU", { N_("Latin"), NULL } },
    { "en_WS", { N_("Latin"), NULL } },
    { "en_YE", { N_("Shavian"), N_("Deseret"), NULL } },
    { "en_ZA", { N_("Latin"), NULL } },
    { "en_ZM", { N_("Latin"), NULL } },
    { "en_ZW", { N_("Latin"), NULL } },
    { "enm", { N_("Latin"), NULL } },
    { "eo", { N_("Latin"), NULL } },
    { "es_AR", { N_("Latin"), NULL } },
    { "es_BO", { N_("Latin"), NULL } },
    { "es_CL", { N_("Latin"), NULL } },
    { "es_CO", { N_("Latin"), NULL } },
    { "es_CR", { N_("Latin"), NULL } },
    { "es_CU", { N_("Latin"), NULL } },
    { "es_DO", { N_("Latin"), NULL } },
    { "es_EA", { N_("Latin"), NULL } },
    { "es_EC", { N_("Latin"), NULL } },
    { "es_ES", { N_("Latin"), NULL } },
    { "es_GQ", { N_("Latin"), NULL } },
    { "es_GT", { N_("Latin"), NULL } },
    { "es_HN", { N_("Latin"), NULL } },
    { "es_IC", { N_("Latin"), NULL } },
    { "es_MX", { N_("Latin"), NULL } },
    { "es_NI", { N_("Latin"), NULL } },
    { "es_PA", { N_("Latin"), NULL } },
    { "es_PE", { N_("Latin"), NULL } },
    { "es_PR", { N_("Latin"), NULL } },
    { "es_PY", { N_("Latin"), NULL } },
    { "es_SV", { N_("Latin"), NULL } },
    { "es_UY", { N_("Latin"), NULL } },
    { "es_VE", { N_("Latin"), NULL } },
    { "esu", { N_("Latin"), NULL } },
    { "et_EE", { N_("Latin"), NULL } },
    { "ett", { N_("Old_Italic"), N_("Latin"), NULL } },
    { "eu", { N_("Latin"), NULL } },
    { "evn", { N_("Cyrillic"), NULL } },
    { "ewo", { N_("Latin"), NULL } },
    { "ext", { N_("Latin"), NULL } },
    { "fa_AF", { N_("Arabic"), NULL } },
    { "fa_IR", { N_("Arabic"), NULL } },
    { "fan", { N_("Latin"), NULL } },
    { "ff", { N_("Latin"), NULL } },
    { "ffm", { N_("Latin"), NULL } },
    { "fi_FI", { N_("Latin"), NULL } },
    { "fil_PH", { N_("Latin"), NULL } },
    { "fil_US", { N_("Tagalog"), NULL } },
    { "fit", { N_("Latin"), NULL } },
    { "fj_FJ", { N_("Latin"), NULL } },
    { "fo_FO", { N_("Latin"), NULL } },
    { "fon", { N_("Latin"), NULL } },
    { "fr_BE", { N_("Latin"), NULL } },
    { "fr_BF", { N_("Latin"), NULL } },
    { "fr_BI", { N_("Latin"), NULL } },
    { "fr_BJ", { N_("Latin"), NULL } },
    { "fr_BL", { N_("Latin"), NULL } },
    { "fr_CA", { N_("Latin"), NULL } },
    { "fr_CD", { N_("Latin"), NULL } },
    { "fr_CF", { N_("Latin"), NULL } },
    { "fr_CG", { N_("Latin"), NULL } },
    { "fr_CH", { N_("Latin"), NULL } },
    { "fr_CI", { N_("Latin"), NULL } },
    { "fr_CM", { N_("Latin"), NULL } },
    { "fr_DE", { N_("Duployan"), NULL } },
    { "fr_DJ", { N_("Latin"), NULL } },
    { "fr_DZ", { N_("Latin"), NULL } },
    { "fr_FR", { N_("Latin"), NULL } },
    { "fr_GA", { N_("Latin"), NULL } },
    { "fr_GF", { N_("Latin"), NULL } },
    { "fr_GN", { N_("Latin"), NULL } },
    { "fr_GP", { N_("Latin"), NULL } },
    { "fr_GQ", { N_("Latin"), NULL } },
    { "fr_HT", { N_("Latin"), NULL } },
    { "fr_IT", { N_("Duployan"), NULL } },
    { "fr_KM", { N_("Latin"), NULL } },
    { "fr_LU", { N_("Latin"), NULL } },
    { "fr_MA", { N_("Latin"), NULL } },
    { "fr_MC", { N_("Latin"), NULL } },
    { "fr_MF", { N_("Latin"), NULL } },
    { "fr_MG", { N_("Latin"), NULL } },
    { "fr_ML", { N_("Latin"), NULL } },
    { "fr_MQ", { N_("Latin"), NULL } },
    { "fr_MU", { N_("Latin"), NULL } },
    { "fr_NC", { N_("Latin"), NULL } },
    { "fr_NE", { N_("Latin"), NULL } },
    { "fr_PF", { N_("Latin"), NULL } },
    { "fr_PM", { N_("Latin"), NULL } },
    { "fr_RE", { N_("Latin"), NULL } },
    { "fr_RW", { N_("Latin"), NULL } },
    { "fr_SC", { N_("Latin"), NULL } },
    { "fr_SN", { N_("Latin"), NULL } },
    { "fr_SY", { N_("Latin"), NULL } },
    { "fr_TD", { N_("Latin"), NULL } },
    { "fr_TF", { N_("Duployan"), NULL } },
    { "fr_TG", { N_("Latin"), NULL } },
    { "fr_TN", { N_("Latin"), NULL } },
    { "fr_US", { N_("Duployan"), NULL } },
    { "fr_VU", { N_("Latin"), NULL } },
    { "fr_WF", { N_("Latin"), NULL } },
    { "fr_YT", { N_("Latin"), NULL } },
    { "frc", { N_("Latin"), NULL } },
    { "frm", { N_("Latin"), NULL } },
    { "fro", { N_("Latin"), NULL } },
    { "frp", { N_("Latin"), NULL } },
    { "frr", { N_("Latin"), NULL } },
    { "frs", { N_("Latin"), NULL } },
    { "fud", { N_("Latin"), NULL } },
    { "fuq", { N_("Latin"), NULL } },
    { "fur", { N_("Latin"), NULL } },
    { "fuv", { N_("Latin"), NULL } },
    { "fy", { N_("Latin"), NULL } },
    { "ga_IE", { N_("Latin"), NULL } },
    { "gaa", { N_("Latin"), NULL } },
    { "gag", { N_("Cyrillic"), NULL } },
    { "gan", { N_("Han"), NULL } },
    { "gay", { N_("Latin"), NULL } },
    { "gba", { N_("Arabic"), NULL } },
    { "gbm", { N_("Devanagari"), NULL } },
    { "gbz", { N_("Arabic"), NULL } },
    { "gcr", { N_("Latin"), NULL } },
    { "gd", { N_("Latin"), NULL } },
    { "gez", { N_("Ethiopic"), NULL } },
    { "ggn", { N_("Latin"), NULL } },
    { "gil_KI", { N_("Latin"), NULL } },
    { "gjk", { N_("Arabic"), NULL } },
    { "gju", { N_("Arabic"), NULL } },
    { "gl", { N_("Latin"), NULL } },
    { "gld", { N_("Cyrillic"), NULL } },
    { "glk", { N_("Arabic"), NULL } },
    { "gmh", { N_("Latin"), NULL } },
    { "gn_PY", { N_("Latin"), NULL } },
    { "goh", { N_("Latin"), NULL } },
    { "gom", { N_("Devanagari"), NULL } },
    { "gon", { N_("Devanagari"), N_("Telugu"), NULL } },
    { "gor", { N_("Latin"), NULL } },
    { "gos", { N_("Latin"), NULL } },
    { "got", { N_("Gothic"), NULL } },
    { "grb", { N_("Latin"), NULL } },
    { "grc", { N_("Linear_B"), N_("Greek"), N_("Cypriot"), NULL } },
    { "grt", { N_("Bengali"), NULL } },
    { "gsw_CH", { N_("Latin"), NULL } },
    { "gsw_LI", { N_("Latin"), NULL } },
    { "gu", { N_("Gujarati"), NULL } },
    { "gub", { N_("Latin"), NULL } },
    { "guc", { N_("Latin"), NULL } },
    { "gur", { N_("Latin"), NULL } },
    { "guz", { N_("Latin"), NULL } },
    { "gv_IM", { N_("Latin"), NULL } },
    { "gvr", { N_("Devanagari"), NULL } },
    { "gwi", { N_("Latin"), NULL } },
    { "ha", { N_("Arabic"), N_("Latin"), NULL } },
    { "hai", { N_("Latin"), NULL } },
    { "hak", { N_("Han"), NULL } },
    { "haw", { N_("Latin"), NULL } },
    { "haz", { N_("Arabic"), NULL } },
    { "he_IL", { N_("Hebrew"), NULL } },
    { "hi_FJ", { N_("Mahajani"), NULL } },
    { "hi_IN", { N_("Devanagari"), NULL } },
    { "hif_FJ", { N_("Devanagari"), N_("Latin"), NULL } },
    { "hil", { N_("Latin"), NULL } },
    { "hit", { N_("Cuneiform"), NULL } },
    { "hmd", { N_("Miao"), NULL } },
    { "hmn", { N_("Pahawh_Hmong"), NULL } },
    { "hnd", { N_("Arabic"), NULL } },
    { "hne", { N_("Devanagari"), NULL } },
    { "hnj", { N_("Lao"), NULL } },
    { "hnn", { N_("Hanunoo"), NULL } },
    { "hno", { N_("Arabic"), NULL } },
    { "ho_PG", { N_("Latin"), NULL } },
    { "hoc", { N_("Devanagari"), NULL } },
    { "hoc_IN", { N_("Warang_Citi"), NULL } },
    { "hoj", { N_("Devanagari"), NULL } },
    { "hop", { N_("Latin"), NULL } },
    { "hr_BA", { N_("Latin"), NULL } },
    { "hr_HR", { N_("Latin"), NULL } },
    { "hsb", { N_("Latin"), NULL } },
    { "hsn", { N_("Han"), NULL } },
    { "ht_HT", { N_("Latin"), NULL } },
    { "hu_HU", { N_("Latin"), NULL } },
    { "hup", { N_("Latin"), NULL } },
    { "hy_AM", { N_("Armenian"), NULL } },
    { "hz", { N_("Latin"), NULL } },
    { "ia", { N_("Latin"), NULL } },
    { "iba", { N_("Latin"), NULL } },
    { "ibb", { N_("Latin"), NULL } },
    { "id", { N_("Arabic"), NULL } },
    { "id_ID", { N_("Latin"), NULL } },
    { "ig", { N_("Latin"), NULL } },
    { "ii", { N_("Yi"), NULL } },
    { "ii_CN", { N_("Latin"), NULL } },
    { "ik", { N_("Latin"), NULL } },
    { "ikt", { N_("Latin"), NULL } },
    { "ilo", { N_("Latin"), NULL } },
    { "inh", { N_("Cyrillic"), NULL } },
    { "inh_RU", { N_("Arabic"), N_("Latin"), NULL } },
    { "is_IS", { N_("Latin"), NULL } },
    { "it_CH", { N_("Latin"), NULL } },
    { "it_IT", { N_("Latin"), NULL } },
    { "it_SM", { N_("Latin"), NULL } },
    { "iu", { N_("Canadian_Aboriginal"), N_("Latin"), NULL } },
    { "izh", { N_("Latin"), NULL } },
    { "ja_JP", { N_("Katakana"), N_("Hiragana"), NULL } },
    { "jam", { N_("Latin"), NULL } },
    { "jgo", { N_("Latin"), NULL } },
    { "jmc", { N_("Latin"), NULL } },
    { "jml", { N_("Devanagari"), NULL } },
    { "jpr", { N_("Hebrew"), NULL } },
    { "jrb", { N_("Hebrew"), NULL } },
    { "jut", { N_("Latin"), NULL } },
    { "jv", { N_("Latin"), NULL } },
    { "jv_ID", { N_("Javanese"), NULL } },
    { "ka_GE", { N_("Georgian"), NULL } },
    { "kaa", { N_("Cyrillic"), NULL } },
    { "kab", { N_("Latin"), NULL } },
    { "kac", { N_("Latin"), NULL } },
    { "kaj", { N_("Latin"), NULL } },
    { "kam", { N_("Latin"), NULL } },
    { "kao", { N_("Latin"), NULL } },
    { "kbd", { N_("Cyrillic"), NULL } },
    { "kca", { N_("Cyrillic"), NULL } },
    { "kcg", { N_("Latin"), NULL } },
    { "kck", { N_("Latin"), NULL } },
    { "kde", { N_("Latin"), NULL } },
    { "kdt", { N_("Thai"), NULL } },
    { "kea", { N_("Latin"), NULL } },
    { "kfo", { N_("Latin"), NULL } },
    { "kfr", { N_("Devanagari"), NULL } },
    { "kfy", { N_("Devanagari"), NULL } },
    { "kg", { N_("Latin"), NULL } },
    { "kge", { N_("Latin"), NULL } },
    { "kgp", { N_("Latin"), NULL } },
    { "kha", { N_("Latin"), NULL } },
    { "kha_IN", { N_("Bengali"), NULL } },
    { "khb", { N_("New_Tai_Lue"), NULL } },
    { "khn", { N_("Devanagari"), NULL } },
    { "khq", { N_("Latin"), NULL } },
    { "kht", { N_("Myanmar"), NULL } },
    { "khw", { N_("Arabic"), NULL } },
    { "ki", { N_("Latin"), NULL } },
    { "kiu", { N_("Latin"), NULL } },
    { "kj", { N_("Latin"), NULL } },
    { "kjg", { N_("Latin"), NULL } },
    { "kjh", { N_("Cyrillic"), NULL } },
    { "kk_KZ", { N_("Arabic"), N_("Cyrillic"), NULL } },
    { "kkj", { N_("Latin"), NULL } },
    { "kl_GL", { N_("Latin"), NULL } },
    { "kln", { N_("Latin"), NULL } },
    { "km_KH", { N_("Khmer"), NULL } },
    { "kmb", { N_("Latin"), NULL } },
    { "kn", { N_("Kannada"), NULL } },
    { "ko_KP", { N_("Hangul"), NULL } },
    { "ko_KR", { N_("Hangul"), NULL } },
    { "koi", { N_("Cyrillic"), NULL } },
    { "kok", { N_("Devanagari"), NULL } },
    { "kos", { N_("Latin"), NULL } },
    { "kpe", { N_("Latin"), NULL } },
    { "kpy", { N_("Cyrillic"), NULL } },
    { "kr", { N_("Latin"), NULL } },
    { "krc", { N_("Cyrillic"), NULL } },
    { "kri", { N_("Latin"), NULL } },
    { "krj", { N_("Latin"), NULL } },
    { "krl", { N_("Latin"), NULL } },
    { "kru", { N_("Devanagari"), NULL } },
    { "ks", { N_("Devanagari"), N_("Arabic"), NULL } },
    { "ksb", { N_("Latin"), NULL } },
    { "ksf", { N_("Latin"), NULL } },
    { "ksh", { N_("Latin"), NULL } },
    { "ku", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "kum", { N_("Cyrillic"), NULL } },
    { "kut", { N_("Latin"), NULL } },
    { "kv", { N_("Cyrillic"), NULL } },
    { "kv_RU", { N_("Old_Permic"), NULL } },
    { "kvr", { N_("Latin"), NULL } },
    { "kvx", { N_("Arabic"), NULL } },
    { "kw", { N_("Latin"), NULL } },
    { "kxm", { N_("Thai"), NULL } },
    { "kxp", { N_("Arabic"), NULL } },
    { "ky_KG", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "kyu", { N_("Kayah_Li"), NULL } },
    { "la_VA", { N_("Latin"), NULL } },
    { "lab", { N_("Linear_A"), NULL } },
    { "lad", { N_("Hebrew"), NULL } },
    { "lag", { N_("Latin"), NULL } },
    { "lah", { N_("Arabic"), NULL } },
    { "laj", { N_("Latin"), NULL } },
    { "lam", { N_("Latin"), NULL } },
    { "lb_LU", { N_("Latin"), NULL } },
    { "lbe", { N_("Cyrillic"), NULL } },
    { "lbw", { N_("Latin"), NULL } },
    { "lcp", { N_("Thai"), NULL } },
    { "lep", { N_("Lepcha"), NULL } },
    { "lez", { N_("Cyrillic"), NULL } },
    { "lez_RU", { N_("Caucasian_Albanian"), NULL } },
    { "lfn", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "lg", { N_("Latin"), NULL } },
    { "li", { N_("Latin"), NULL } },
    { "lif", { N_("Devanagari"), N_("Limbu"), NULL } },
    { "lij", { N_("Latin"), NULL } },
    { "lis", { N_("Lisu"), NULL } },
    { "liv", { N_("Latin"), NULL } },
    { "ljp", { N_("Latin"), NULL } },
    { "lki", { N_("Arabic"), NULL } },
    { "lkt", { N_("Latin"), NULL } },
    { "lmn", { N_("Telugu"), NULL } },
    { "lmo", { N_("Latin"), NULL } },
    { "ln", { N_("Latin"), NULL } },
    { "lo_LA", { N_("Lao"), NULL } },
    { "lol", { N_("Latin"), NULL } },
    { "loz", { N_("Latin"), NULL } },
    { "lrc", { N_("Arabic"), NULL } },
    { "lt_LT", { N_("Latin"), NULL } },
    { "ltg", { N_("Latin"), NULL } },
    { "lu", { N_("Latin"), NULL } },
    { "lua", { N_("Latin"), NULL } },
    { "lui", { N_("Latin"), NULL } },
    { "lun", { N_("Latin"), NULL } },
    { "luo", { N_("Latin"), NULL } },
    { "lus", { N_("Bengali"), NULL } },
    { "lut", { N_("Latin"), NULL } },
    { "luy", { N_("Latin"), NULL } },
    { "luz", { N_("Arabic"), NULL } },
    { "lv_LV", { N_("Latin"), NULL } },
    { "lwl", { N_("Thai"), NULL } },
    { "lzh", { N_("Han"), NULL } },
    { "lzz", { N_("Georgian"), N_("Latin"), NULL } },
    { "mad", { N_("Latin"), NULL } },
    { "maf", { N_("Latin"), NULL } },
    { "mag", { N_("Devanagari"), NULL } },
    { "mai", { N_("Devanagari"), NULL } },
    { "mai_IN", { N_("Tirhuta"), NULL } },
    { "mai_NP", { N_("Tirhuta"), NULL } },
    { "mak", { N_("Latin"), NULL } },
    { "mak_ID", { N_("Buginese"), NULL } },
    { "man", { N_("Nko"), N_("Latin"), NULL } },
    { "mas", { N_("Latin"), NULL } },
    { "maz", { N_("Latin"), NULL } },
    { "mdf", { N_("Cyrillic"), NULL } },
    { "mdh", { N_("Latin"), NULL } },
    { "mdr", { N_("Buginese"), NULL } },
    { "mdt", { N_("Latin"), NULL } },
    { "men", { N_("Latin"), NULL } },
    { "men_SL", { N_("Mende_Kikakui"), NULL } },
    { "mer", { N_("Latin"), NULL } },
    { "mfa", { N_("Arabic"), NULL } },
    { "mfe", { N_("Latin"), NULL } },
    { "mg_MG", { N_("Latin"), NULL } },
    { "mgh", { N_("Latin"), NULL } },
    { "mgo", { N_("Latin"), NULL } },
    { "mgp", { N_("Devanagari"), NULL } },
    { "mgy", { N_("Latin"), NULL } },
    { "mh_MH", { N_("Latin"), NULL } },
    { "mi_NZ", { N_("Latin"), NULL } },
    { "mic", { N_("Latin"), NULL } },
    { "min", { N_("Latin"), NULL } },
    { "mk_MK", { N_("Cyrillic"), NULL } },
    { "ml", { N_("Malayalam"), NULL } },
    { "mn_CN", { N_("Phags_Pa"), NULL } },
    { "mn_MN", { N_("Cyrillic"), N_("Mongolian"), NULL } },
    { "mnc", { N_("Mongolian"), NULL } },
    { "mni", { N_("Bengali"), NULL } },
    { "mni_IN", { N_("Meetei_Mayek"), NULL } },
    { "mns", { N_("Cyrillic"), NULL } },
    { "mnw", { N_("Myanmar"), NULL } },
    { "moe", { N_("Latin"), NULL } },
    { "moh", { N_("Latin"), NULL } },
    { "mos", { N_("Latin"), NULL } },
    { "mr", { N_("Devanagari"), NULL } },
    { "mr_IN", { N_("Modi"), NULL } },
    { "mrd", { N_("Devanagari"), NULL } },
    { "mrj", { N_("Cyrillic"), NULL } },
    { "mro", { N_("Mro"), NULL } },
    { "ms_BN", { N_("Arabic"), N_("Latin"), NULL } },
    { "ms_MY", { N_("Arabic"), N_("Latin"), NULL } },
    { "ms_SG", { N_("Arabic"), N_("Latin"), NULL } },
    { "mt_MT", { N_("Latin"), NULL } },
    { "mtr", { N_("Devanagari"), NULL } },
    { "mua", { N_("Latin"), NULL } },
    { "mus", { N_("Latin"), NULL } },
    { "mvy", { N_("Arabic"), NULL } },
    { "mwk", { N_("Latin"), NULL } },
    { "mwl", { N_("Latin"), NULL } },
    { "mwr", { N_("Devanagari"), NULL } },
    { "mwv", { N_("Latin"), NULL } },
    { "mxc", { N_("Latin"), NULL } },
    { "my_MM", { N_("Myanmar"), NULL } },
    { "myv", { N_("Cyrillic"), NULL } },
    { "myx", { N_("Latin"), NULL } },
    { "myz", { N_("Mandaic"), NULL } },
    { "mzn", { N_("Arabic"), NULL } },
    { "na_NR", { N_("Latin"), NULL } },
    { "nan", { N_("Han"), NULL } },
    { "nap", { N_("Latin"), NULL } },
    { "naq", { N_("Latin"), NULL } },
    { "nb_NO", { N_("Latin"), NULL } },
    { "nb_SJ", { N_("Latin"), NULL } },
    { "nch", { N_("Latin"), NULL } },
    { "nd_ZW", { N_("Latin"), NULL } },
    { "ndc", { N_("Latin"), NULL } },
    { "nds", { N_("Latin"), NULL } },
    { "ne_NP", { N_("Devanagari"), NULL } },
    { "new", { N_("Devanagari"), NULL } },
    { "ng", { N_("Latin"), NULL } },
    { "ngl", { N_("Latin"), NULL } },
    { "nhe", { N_("Latin"), NULL } },
    { "nhw", { N_("Latin"), NULL } },
    { "nia", { N_("Latin"), NULL } },
    { "nij", { N_("Latin"), NULL } },
    { "niu_NU", { N_("Latin"), NULL } },
    { "njo", { N_("Latin"), NULL } },
    { "nl_AW", { N_("Latin"), NULL } },
    { "nl_BE", { N_("Latin"), NULL } },
    { "nl_BQ", { N_("Latin"), NULL } },
    { "nl_CW", { N_("Latin"), NULL } },
    { "nl_NL", { N_("Latin"), NULL } },
    { "nl_SR", { N_("Latin"), NULL } },
    { "nl_SX", { N_("Latin"), NULL } },
    { "nmg", { N_("Latin"), NULL } },
    { "nn_NO", { N_("Latin"), NULL } },
    { "nnh", { N_("Latin"), NULL } },
    { "nod", { N_("Tai_Tham"), NULL } },
    { "noe", { N_("Devanagari"), NULL } },
    { "nog", { N_("Cyrillic"), NULL } },
    { "non", { N_("Runic"), NULL } },
    { "nov", { N_("Latin"), NULL } },
    { "nqo", { N_("Nko"), NULL } },
    { "nr", { N_("Latin"), NULL } },
    { "nsk", { N_("Latin"), NULL } },
    { "nso", { N_("Latin"), NULL } },
    { "nus", { N_("Latin"), NULL } },
    { "nv", { N_("Latin"), NULL } },
    { "nxq", { N_("Latin"), NULL } },
    { "ny_MW", { N_("Latin"), NULL } },
    { "nym", { N_("Latin"), NULL } },
    { "nyn", { N_("Latin"), NULL } },
    { "nyo", { N_("Latin"), NULL } },
    { "nzi", { N_("Latin"), NULL } },
    { "oc", { N_("Latin"), NULL } },
    { "oj", { N_("Latin"), NULL } },
    { "om", { N_("Latin"), NULL } },
    { "om_ET", { N_("Ethiopic"), NULL } },
    { "or", { N_("Oriya"), NULL } },
    { "os", { N_("Cyrillic"), NULL } },
    { "osa", { N_("Latin"), NULL } },
    { "osc", { N_("Old_Italic"), N_("Latin"), NULL } },
    { "otk", { N_("Old_Turkic"), NULL } },
    { "pa", { N_("Gurmukhi"), N_("Arabic"), NULL } },
    { "pag", { N_("Latin"), NULL } },
    { "pal", { N_("Inscriptional_Pahlavi"), N_("Psalter_Pahlavi"), NULL } },
    { "pam", { N_("Latin"), NULL } },
    { "pap_AW", { N_("Latin"), NULL } },
    { "pap_CW", { N_("Latin"), NULL } },
    { "pau_PW", { N_("Latin"), NULL } },
    { "pcd", { N_("Latin"), NULL } },
    { "pcm", { N_("Latin"), NULL } },
    { "pdc", { N_("Latin"), NULL } },
    { "pdt", { N_("Latin"), NULL } },
    { "peo", { N_("Old_Persian"), NULL } },
    { "pfl", { N_("Latin"), NULL } },
    { "phn", { N_("Phoenician"), NULL } },
    { "pi", { N_("Devanagari"), N_("Sinhala"), N_("Thai"), NULL } },
    { "pko", { N_("Latin"), NULL } },
    { "pl_PL", { N_("Latin"), NULL } },
    { "pms", { N_("Latin"), NULL } },
    { "pnt", { N_("Greek"), N_("Cyrillic"), N_("Latin"), NULL } },
    { "pon", { N_("Latin"), NULL } },
    { "prd", { N_("Arabic"), NULL } },
    { "prg", { N_("Latin"), NULL } },
    { "pro", { N_("Latin"), NULL } },
    { "prs", { N_("Arabic"), NULL } },
    { "ps_AF", { N_("Arabic"), NULL } },
    { "pt_AO", { N_("Latin"), NULL } },
    { "pt_BR", { N_("Latin"), NULL } },
    { "pt_CV", { N_("Latin"), NULL } },
    { "pt_GW", { N_("Latin"), NULL } },
    { "pt_MO", { N_("Latin"), NULL } },
    { "pt_MZ", { N_("Latin"), NULL } },
    { "pt_PT", { N_("Latin"), NULL } },
    { "pt_ST", { N_("Latin"), NULL } },
    { "pt_TL", { N_("Latin"), NULL } },
    { "puu", { N_("Latin"), NULL } },
    { "qu_BO", { N_("Latin"), NULL } },
    { "qu_EC", { N_("Latin"), NULL } },
    { "qu_PE", { N_("Latin"), NULL } },
    { "quc", { N_("Latin"), NULL } },
    { "qug", { N_("Latin"), NULL } },
    { "raj", { N_("Latin"), NULL } },
    { "rap", { N_("Latin"), NULL } },
    { "rar", { N_("Latin"), NULL } },
    { "rcf", { N_("Latin"), NULL } },
    { "rej", { N_("Latin"), NULL } },
    { "rej_ID", { N_("Rejang"), NULL } },
    { "rgn", { N_("Latin"), NULL } },
    { "ria", { N_("Latin"), NULL } },
    { "rif", { N_("Tifinagh"), N_("Latin"), NULL } },
    { "rjs", { N_("Devanagari"), NULL } },
    { "rkt", { N_("Bengali"), NULL } },
    { "rm", { N_("Latin"), NULL } },
    { "rmf", { N_("Latin"), NULL } },
    { "rmo", { N_("Latin"), NULL } },
    { "rmt", { N_("Arabic"), NULL } },
    { "rmu", { N_("Latin"), NULL } },
    { "rn_BI", { N_("Latin"), NULL } },
    { "rng", { N_("Latin"), NULL } },
    { "ro_MD", { N_("Latin"), NULL } },
    { "ro_RO", { N_("Latin"), NULL } },
    { "ro_RS", { N_("Cyrillic"), NULL } },
    { "rob", { N_("Latin"), NULL } },
    { "rof", { N_("Latin"), NULL } },
    { "rom", { N_("Cyrillic"), NULL } },
    { "rtm", { N_("Latin"), NULL } },
    { "ru_BY", { N_("Cyrillic"), NULL } },
    { "ru_KG", { N_("Cyrillic"), NULL } },
    { "ru_KZ", { N_("Cyrillic"), NULL } },
    { "ru_RU", { N_("Cyrillic"), NULL } },
    { "ru_UA", { N_("Cyrillic"), NULL } },
    { "rue", { N_("Cyrillic"), NULL } },
    { "rug", { N_("Latin"), NULL } },
    { "rup", { N_("Latin"), NULL } },
    { "rw_RW", { N_("Latin"), NULL } },
    { "rwk", { N_("Latin"), NULL } },
    { "ryu", { N_("Katakana"), NULL } },
    { "sa_IN", { N_("Devanagari"), N_("Sharada"), N_("Grantha"), N_("Siddham"), N_("Sinhala"), NULL } },
    { "sad", { N_("Latin"), NULL } },
    { "saf", { N_("Latin"), NULL } },
    { "sah", { N_("Cyrillic"), NULL } },
    { "sam", { N_("Samaritan"), N_("Hebrew"), NULL } },
    { "saq", { N_("Latin"), NULL } },
    { "sas", { N_("Latin"), NULL } },
    { "sat", { N_("Latin"), NULL } },
    { "sat_IN", { N_("Oriya"), N_("Devanagari"), N_("Bengali"), N_("Ol_Chiki"), NULL } },
    { "saz", { N_("Saurashtra"), NULL } },
    { "sbp", { N_("Latin"), NULL } },
    { "sc", { N_("Latin"), NULL } },
    { "sck", { N_("Devanagari"), NULL } },
    { "scn", { N_("Latin"), NULL } },
    { "sco", { N_("Latin"), NULL } },
    { "scs", { N_("Latin"), NULL } },
    { "sd", { N_("Devanagari"), N_("Arabic"), NULL } },
    { "sd_IN", { N_("Khudawadi"), N_("Khojki"), NULL } },
    { "sd_PK", { N_("Khudawadi"), N_("Khojki"), NULL } },
    { "sdc", { N_("Latin"), NULL } },
    { "sdh", { N_("Arabic"), NULL } },
    { "se", { N_("Latin"), NULL } },
    { "se_NO", { N_("Cyrillic"), NULL } },
    { "see", { N_("Latin"), NULL } },
    { "sef", { N_("Latin"), NULL } },
    { "seh", { N_("Latin"), NULL } },
    { "sei", { N_("Latin"), NULL } },
    { "sel", { N_("Cyrillic"), NULL } },
    { "ses", { N_("Latin"), NULL } },
    { "sg_CF", { N_("Latin"), NULL } },
    { "sga", { N_("Ogham"), N_("Latin"), NULL } },
    { "sgs", { N_("Latin"), NULL } },
    { "shi", { N_("Tifinagh"), N_("Arabic"), N_("Latin"), NULL } },
    { "shn", { N_("Myanmar"), NULL } },
    { "si_LK", { N_("Sinhala"), NULL } },
    { "sid", { N_("Latin"), NULL } },
    { "sk_SK", { N_("Latin"), NULL } },
    { "skr", { N_("Arabic"), NULL } },
    { "sl_SI", { N_("Latin"), NULL } },
    { "sli", { N_("Latin"), NULL } },
    { "sly", { N_("Latin"), NULL } },
    { "sm_AS", { N_("Latin"), NULL } },
    { "sm_WS", { N_("Latin"), NULL } },
    { "sma", { N_("Latin"), NULL } },
    { "smj", { N_("Latin"), NULL } },
    { "smn", { N_("Latin"), NULL } },
    { "smp", { N_("Samaritan"), NULL } },
    { "sms", { N_("Latin"), NULL } },
    { "sn_ZW", { N_("Latin"), NULL } },
    { "snk", { N_("Latin"), NULL } },
    { "so_DJ", { N_("Arabic"), N_("Osmanya"), NULL } },
    { "so_ET", { N_("Arabic"), N_("Osmanya"), NULL } },
    { "so_SO", { N_("Latin"), NULL } },
    { "sou", { N_("Thai"), NULL } },
    { "sq_AL", { N_("Latin"), NULL } },
    { "sq_MK", { N_("Elbasan"), NULL } },
    { "sq_RS", { N_("Elbasan"), NULL } },
    { "sq_XK", { N_("Latin"), NULL } },
    { "sr_BA", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "sr_ME", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "sr_RS", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "sr_XK", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "srb", { N_("Sora_Sompeng"), NULL } },
    { "srn", { N_("Latin"), NULL } },
    { "srr", { N_("Latin"), NULL } },
    { "srx", { N_("Devanagari"), NULL } },
    { "ss_SZ", { N_("Latin"), NULL } },
    { "ssy", { N_("Latin"), NULL } },
    { "st_LS", { N_("Latin"), NULL } },
    { "stq", { N_("Latin"), NULL } },
    { "su", { N_("Latin"), NULL } },
    { "su_ID", { N_("Sundanese"), NULL } },
    { "suk", { N_("Latin"), NULL } },
    { "sus", { N_("Latin"), NULL } },
    { "sus_GN", { N_("Arabic"), NULL } },
    { "sv_AX", { N_("Latin"), NULL } },
    { "sv_FI", { N_("Latin"), NULL } },
    { "sv_SE", { N_("Latin"), NULL } },
    { "sw_KE", { N_("Latin"), NULL } },
    { "sw_TZ", { N_("Latin"), NULL } },
    { "sw_UG", { N_("Latin"), NULL } },
    { "swb", { N_("Arabic"), NULL } },
    { "swb_YT", { N_("Latin"), NULL } },
    { "swc", { N_("Latin"), NULL } },
    { "swv", { N_("Devanagari"), NULL } },
    { "sxn", { N_("Latin"), NULL } },
    { "syi", { N_("Latin"), NULL } },
    { "syl", { N_("Bengali"), NULL } },
    { "syl_BD", { N_("Syloti_Nagri"), NULL } },
    { "syr", { N_("Syriac"), NULL } },
    { "szl", { N_("Latin"), NULL } },
    { "ta_LK", { N_("Tamil"), NULL } },
    { "ta_SG", { N_("Tamil"), NULL } },
    { "tab", { N_("Cyrillic"), NULL } },
    { "taj", { N_("Tibetan"), NULL } },
    { "tbw", { N_("Tagbanwa"), NULL } },
    { "tcy", { N_("Kannada"), NULL } },
    { "tdd", { N_("Tai_Le"), NULL } },
    { "tdg", { N_("Tibetan"), NULL } },
    { "tdh", { N_("Devanagari"), NULL } },
    { "te", { N_("Telugu"), NULL } },
    { "tem", { N_("Latin"), NULL } },
    { "teo", { N_("Latin"), NULL } },
    { "ter", { N_("Latin"), NULL } },
    { "tet_TL", { N_("Latin"), NULL } },
    { "tg_TJ", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "th_TH", { N_("Thai"), NULL } },
    { "thl", { N_("Devanagari"), NULL } },
    { "thq", { N_("Devanagari"), NULL } },
    { "thr", { N_("Devanagari"), NULL } },
    { "ti_ER", { N_("Ethiopic"), NULL } },
    { "tig", { N_("Ethiopic"), NULL } },
    { "tiv", { N_("Latin"), NULL } },
    { "tk_TM", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "tkl_TK", { N_("Latin"), NULL } },
    { "tkr", { N_("Cyrillic"), N_("Latin"), NULL } },
    { "tkt", { N_("Devanagari"), NULL } },
    { "tli", { N_("Latin"), NULL } },
    { "tly", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "tmh", { N_("Latin"), NULL } },
    { "tn_BW", { N_("Latin"), NULL } },
    { "to_TO", { N_("Latin"), NULL } },
    { "tog", { N_("Latin"), NULL } },
    { "tpi_PG", { N_("Latin"), NULL } },
    { "tr_CY", { N_("Latin"), NULL } },
    { "tr_DE", { N_("Arabic"), NULL } },
    { "tr_TR", { N_("Latin"), NULL } },
    { "tru", { N_("Syriac"), NULL } },
    { "trv", { N_("Latin"), NULL } },
    { "ts", { N_("Latin"), NULL } },
    { "tsd", { N_("Greek"), NULL } },
    { "tsf", { N_("Devanagari"), NULL } },
    { "tsg", { N_("Latin"), NULL } },
    { "tsi", { N_("Latin"), NULL } },
    { "tsj", { N_("Tibetan"), NULL } },
    { "tt", { N_("Cyrillic"), NULL } },
    { "ttj", { N_("Latin"), NULL } },
    { "tts", { N_("Thai"), NULL } },
    { "ttt", { N_("Arabic"), NULL } },
    { "tum", { N_("Latin"), NULL } },
    { "tvl_TV", { N_("Latin"), NULL } },
    { "twq", { N_("Latin"), NULL } },
    { "ty_PF", { N_("Latin"), NULL } },
    { "tyv", { N_("Cyrillic"), NULL } },
    { "tzm_MA", { N_("Tifinagh"), N_("Latin"), NULL } },
    { "ude", { N_("Cyrillic"), NULL } },
    { "udm", { N_("Cyrillic"), NULL } },
    { "udm_RU", { N_("Latin"), NULL } },
    { "ug", { N_("Arabic"), N_("Cyrillic"), NULL } },
    { "ug_CN", { N_("Latin"), NULL } },
    { "uga", { N_("Ugaritic"), NULL } },
    { "uk_UA", { N_("Cyrillic"), NULL } },
    { "uli", { N_("Latin"), NULL } },
    { "umb", { N_("Latin"), NULL } },
    { "unr", { N_("Devanagari"), N_("Bengali"), NULL } },
    { "unx", { N_("Devanagari"), N_("Bengali"), NULL } },
    { "ur_PK", { N_("Arabic"), NULL } },
    { "uz_UZ", { N_("Latin"), N_("Arabic"), N_("Cyrillic"), NULL } },
    { "vai", { N_("Vai"), N_("Latin"), NULL } },
    { "ve", { N_("Latin"), NULL } },
    { "vec", { N_("Latin"), NULL } },
    { "vep", { N_("Latin"), NULL } },
    { "vi_US", { N_("Han"), NULL } },
    { "vi_VN", { N_("Latin"), NULL } },
    { "vic", { N_("Latin"), NULL } },
    { "vls", { N_("Latin"), NULL } },
    { "vmf", { N_("Latin"), NULL } },
    { "vmw", { N_("Latin"), NULL } },
    { "vo", { N_("Latin"), NULL } },
    { "vot", { N_("Latin"), NULL } },
    { "vro", { N_("Latin"), NULL } },
    { "vun", { N_("Latin"), NULL } },
    { "wa", { N_("Latin"), NULL } },
    { "wae", { N_("Latin"), NULL } },
    { "wal", { N_("Ethiopic"), NULL } },
    { "war", { N_("Latin"), NULL } },
    { "was", { N_("Latin"), NULL } },
    { "wbp", { N_("Latin"), NULL } },
    { "wbq", { N_("Telugu"), NULL } },
    { "wbr", { N_("Devanagari"), NULL } },
    { "wls", { N_("Latin"), NULL } },
    { "wo", { N_("Arabic"), NULL } },
    { "wo_SN", { N_("Latin"), NULL } },
    { "wtm", { N_("Devanagari"), NULL } },
    { "wuu", { N_("Han"), NULL } },
    { "xal", { N_("Cyrillic"), NULL } },
    { "xav", { N_("Latin"), NULL } },
    { "xcr", { N_("Carian"), NULL } },
    { "xh", { N_("Latin"), NULL } },
    { "xlc", { N_("Lycian"), NULL } },
    { "xld", { N_("Lydian"), NULL } },
    { "xmf", { N_("Georgian"), NULL } },
    { "xmn", { N_("Manichaean"), NULL } },
    { "xmr", { N_("Meroitic_Cursive"), NULL } },
    { "xna", { N_("Old_North_Arabian"), NULL } },
    { "xnr", { N_("Devanagari"), NULL } },
    { "xog", { N_("Latin"), NULL } },
    { "xpr", { N_("Inscriptional_Parthian"), NULL } },
    { "xsa", { N_("Old_South_Arabian"), NULL } },
    { "xsr", { N_("Devanagari"), NULL } },
    { "xum", { N_("Old_Italic"), N_("Latin"), NULL } },
    { "yao", { N_("Latin"), NULL } },
    { "yap", { N_("Latin"), NULL } },
    { "yav", { N_("Latin"), NULL } },
    { "ybb", { N_("Latin"), NULL } },
    { "yi", { N_("Hebrew"), NULL } },
    { "yo_NG", { N_("Latin"), NULL } },
    { "yrk", { N_("Cyrillic"), NULL } },
    { "yrl", { N_("Latin"), NULL } },
    { "yua", { N_("Latin"), NULL } },
    { "yue", { N_("Han"), NULL } },
    { "za", { N_("Latin"), NULL } },
    { "za_CN", { N_("Han"), NULL } },
    { "zap", { N_("Latin"), NULL } },
    { "zdj_KM", { N_("Arabic"), NULL } },
    { "zea", { N_("Latin"), NULL } },
    { "zen", { N_("Tifinagh"), NULL } },
    { "zgh", { N_("Tifinagh"), NULL } },
    { "zh_CN", { N_("Han"), NULL } },
    { "zh_HK", { N_("Han"), NULL } },
    { "zh_ID", { N_("Phags_Pa"), N_("Bopomofo"), NULL } },
    { "zh_MO", { N_("Han"), NULL } },
    { "zh_MY", { N_("Phags_Pa"), N_("Bopomofo"), NULL } },
    { "zh_SG", { N_("Han"), NULL } },
    { "zh_TH", { N_("Phags_Pa"), N_("Bopomofo"), NULL } },
    { "zh_TW", { N_("Han"), NULL } },
    { "zh_US", { N_("Phags_Pa"), N_("Bopomofo"), NULL } },
    { "zmi", { N_("Latin"), NULL } },
    { "zu", { N_("Latin"), NULL } },
    { "zun", { N_("Latin"), NULL } },
    { "zza", { N_("Latin"), NULL } }
};
