/* gnome-bg.h -

   Copyright 2007, Red Hat, Inc.

   This file is part of the Gnome Library.

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

   Author: Soren Sandmann <sandmann@redhat.com>
*/

#ifndef __GNOME_BG_H__
#define __GNOME_BG_H__

#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gdesktop-enums.h>
#include <gdesktop-enums.h>

G_BEGIN_DECLS

#define GNOME_TYPE_BG            (gnome_bg_get_type ())
#define GNOME_BG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_BG, GnomeBG))
#define GNOME_BG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  GNOME_TYPE_BG, GnomeBGClass))
#define GNOME_IS_BG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_BG))
#define GNOME_IS_BG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GNOME_TYPE_BG))
#define GNOME_BG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  GNOME_TYPE_BG, GnomeBGClass))

typedef struct _GnomeBG GnomeBG;
typedef struct _GnomeBGClass GnomeBGClass;

G_DEFINE_AUTOPTR_CLEANUP_FUNC(GnomeBG, g_object_unref)

GType            gnome_bg_get_type              (void);
GnomeBG *        gnome_bg_new                   (void);
void             gnome_bg_load_from_preferences (GnomeBG               *bg,
						 GSettings             *settings);
void             gnome_bg_save_to_preferences   (GnomeBG               *bg,
						 GSettings             *settings);
/* Setters */
void             gnome_bg_set_filename          (GnomeBG               *bg,
						 const char            *filename);
void             gnome_bg_set_placement         (GnomeBG               *bg,
						 GDesktopBackgroundStyle placement);
void             gnome_bg_set_rgba              (GnomeBG               *bg,
						 GDesktopBackgroundShading type,
						 GdkRGBA               *primary,
						 GdkRGBA               *secondary);

/* Getters */
GDesktopBackgroundStyle gnome_bg_get_placement  (GnomeBG               *bg);
void		 gnome_bg_get_rgba              (GnomeBG               *bg,
						 GDesktopBackgroundShading *type,
						 GdkRGBA               *primary,
						 GdkRGBA               *secondary);
const gchar *    gnome_bg_get_filename          (GnomeBG               *bg);

/* Drawing and thumbnailing */
void             gnome_bg_draw                  (GnomeBG               *bg,
						 GdkPixbuf             *dest);
cairo_surface_t *gnome_bg_create_surface        (GnomeBG               *bg,
						 GdkSurface            *surface,
						 int                    width,
						 int                    height);
gboolean         gnome_bg_get_image_size        (GnomeBG               *bg,
                                                 int                    best_width,
                                                 int                    best_height,
						 int                   *width,
						 int                   *height);
GdkPixbuf *      gnome_bg_create_thumbnail      (GnomeBG               *bg,
						 GdkSurface            *surface,
						 int                    dest_width,
						 int                    dest_height);
gboolean         gnome_bg_is_dark               (GnomeBG               *bg,
                                                 int                    dest_width,
						 int                    dest_height);
gboolean         gnome_bg_has_multiple_sizes    (GnomeBG               *bg);
gboolean         gnome_bg_changes_with_time     (GnomeBG               *bg);
GdkPixbuf *      gnome_bg_create_frame_thumbnail (GnomeBG              *bg,
						 GdkSurface            *surface,
						 int                    dest_width,
						 int                    dest_height,
						 int                    frame_num);

G_END_DECLS

#endif
