/* valacastexpression.c generated by valac, the Vala compiler
 * generated from valacastexpression.vala, do not modify */

/* valacastexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaCastExpressionPrivate {
	gboolean _is_silent_cast;
	gboolean _is_non_null_cast;
	ValaExpression* _inner;
	ValaDataType* _data_type;
};

static gint ValaCastExpression_private_offset;
static gpointer vala_cast_expression_parent_class = NULL;

static void vala_cast_expression_set_inner (ValaCastExpression* self,
                                     ValaExpression* value);
static void vala_cast_expression_set_type_reference (ValaCastExpression* self,
                                              ValaDataType* value);
static void vala_cast_expression_set_is_silent_cast (ValaCastExpression* self,
                                              gboolean value);
static void vala_cast_expression_set_is_non_null_cast (ValaCastExpression* self,
                                                gboolean value);
static void vala_cast_expression_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_cast_expression_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gchar* vala_cast_expression_real_to_string (ValaCodeNode* base);
static void vala_cast_expression_real_replace_expression (ValaCodeNode* base,
                                                   ValaExpression* old_node,
                                                   ValaExpression* new_node);
static gboolean vala_cast_expression_real_is_pure (ValaExpression* base);
static gboolean vala_cast_expression_real_is_accessible (ValaExpression* base,
                                                  ValaSymbol* sym);
static void vala_cast_expression_real_replace_type (ValaCodeNode* base,
                                             ValaDataType* old_type,
                                             ValaDataType* new_type);
static gboolean vala_cast_expression_real_is_non_null (ValaExpression* base);
static void vala_cast_expression_real_get_error_types (ValaCodeNode* base,
                                                ValaCollection* collection,
                                                ValaSourceReference* source_reference);
static gboolean vala_cast_expression_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static gboolean vala_cast_expression_is_gvariant (ValaCastExpression* self,
                                           ValaCodeContext* context,
                                           ValaDataType* type);
static gboolean vala_cast_expression_is_gvalue (ValaCastExpression* self,
                                         ValaCodeContext* context,
                                         ValaDataType* type);
static void vala_cast_expression_real_emit (ValaCodeNode* base,
                                     ValaCodeGenerator* codegen);
static void vala_cast_expression_real_get_defined_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_cast_expression_real_get_used_variables (ValaCodeNode* base,
                                                   ValaCollection* collection);
static gboolean vala_cast_expression_real_is_constant (ValaExpression* base);
static void vala_cast_expression_finalize (ValaCodeNode * obj);
static GType vala_cast_expression_get_type_once (void);

static inline gpointer
vala_cast_expression_get_instance_private (ValaCastExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCastExpression_private_offset);
}

ValaExpression*
vala_cast_expression_get_inner (ValaCastExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_cast_expression_set_inner (ValaCastExpression* self,
                                ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_cast_expression_get_type_reference (ValaCastExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_set_type_reference (ValaCastExpression* self,
                                         ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_cast_expression_get_is_silent_cast (ValaCastExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_silent_cast;
	return result;
}

static void
vala_cast_expression_set_is_silent_cast (ValaCastExpression* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_silent_cast = value;
}

gboolean
vala_cast_expression_get_is_non_null_cast (ValaCastExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_non_null_cast;
	return result;
}

static void
vala_cast_expression_set_is_non_null_cast (ValaCastExpression* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_non_null_cast = value;
}

/**
 * Creates a new cast expression.
 *
 * @param inner           expression to be cast
 * @param type_reference  target type
 * @return                newly created cast expression
 */
ValaCastExpression*
vala_cast_expression_construct (GType object_type,
                                ValaExpression* inner,
                                ValaDataType* type_reference,
                                ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (type_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_type_reference (self, type_reference);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_cast_expression_set_is_silent_cast (self, FALSE);
	vala_cast_expression_set_is_non_null_cast (self, FALSE);
	vala_cast_expression_set_inner (self, inner);
	return self;
}

ValaCastExpression*
vala_cast_expression_new (ValaExpression* inner,
                          ValaDataType* type_reference,
                          ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct (VALA_TYPE_CAST_EXPRESSION, inner, type_reference, source_reference);
}

ValaCastExpression*
vala_cast_expression_construct_silent (GType object_type,
                                       ValaExpression* inner,
                                       ValaDataType* type_reference,
                                       ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (type_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_type_reference (self, type_reference);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_cast_expression_set_is_silent_cast (self, TRUE);
	vala_cast_expression_set_is_non_null_cast (self, FALSE);
	vala_cast_expression_set_inner (self, inner);
	return self;
}

ValaCastExpression*
vala_cast_expression_new_silent (ValaExpression* inner,
                                 ValaDataType* type_reference,
                                 ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct_silent (VALA_TYPE_CAST_EXPRESSION, inner, type_reference, source_reference);
}

ValaCastExpression*
vala_cast_expression_construct_non_null (GType object_type,
                                         ValaExpression* inner,
                                         ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_inner (self, inner);
	vala_cast_expression_set_is_non_null_cast (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaCastExpression*
vala_cast_expression_new_non_null (ValaExpression* inner,
                                   ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct_non_null (VALA_TYPE_CAST_EXPRESSION, inner, source_reference);
}

static void
vala_cast_expression_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCastExpression * self;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_cast_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_cast_expression_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = self->priv->_is_non_null_cast;
	if (!_tmp2_) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_cast_expression_get_type_reference (self);
		_tmp4_ = _tmp3_;
		vala_code_node_accept ((ValaCodeNode*) _tmp4_, visitor);
	}
}

static gchar*
vala_cast_expression_real_to_string (ValaCodeNode* base)
{
	ValaCastExpression * self;
	gboolean _tmp0_;
	gchar* result = NULL;
	self = (ValaCastExpression*) base;
	_tmp0_ = self->priv->_is_non_null_cast;
	if (_tmp0_) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = vala_cast_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("(!) %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		return result;
	} else {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_is_silent_cast;
		if (_tmp7_) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = vala_cast_expression_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_cast_expression_get_type_reference (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s as %s", _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp11_);
			result = _tmp17_;
			return result;
		} else {
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			ValaExpression* _tmp22_;
			ValaExpression* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp18_ = vala_cast_expression_get_type_reference (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_cast_expression_get_inner (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_node_to_string ((ValaCodeNode*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("(%s) %s", _tmp21_, _tmp25_);
			_tmp27_ = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			result = _tmp27_;
			return result;
		}
	}
}

static void
vala_cast_expression_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_cast_expression_set_inner (self, new_node);
	}
}

static gboolean
vala_cast_expression_real_is_pure (ValaExpression* base)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_pure (_tmp1_);
	return result;
}

static gboolean
vala_cast_expression_real_is_accessible (ValaExpression* base,
                                         ValaSymbol* sym)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static void
vala_cast_expression_real_replace_type (ValaCodeNode* base,
                                        ValaDataType* old_type,
                                        ValaDataType* new_type)
{
	ValaCastExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_cast_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_cast_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_cast_expression_real_is_non_null (ValaExpression* base)
{
	ValaCastExpression * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result = FALSE;
	self = (ValaCastExpression*) base;
	_tmp1_ = self->priv->_is_non_null_cast;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = self->priv->_is_silent_cast;
		if (!_tmp3_) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			_tmp4_ = vala_cast_expression_get_inner (self);
			_tmp5_ = _tmp4_;
			_tmp2_ = vala_expression_is_non_null (_tmp5_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
}

static gboolean
vala_cast_expression_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCastExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp12_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	ValaDataType* _tmp38_;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaExpression* _tmp113_;
	ValaExpression* _tmp114_;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	gboolean _tmp117_;
	gboolean _tmp118_;
	ValaDataType* _tmp119_;
	ValaDataType* _tmp120_;
	ValaExpression* _tmp121_;
	ValaExpression* _tmp122_;
	ValaDataType* _tmp123_;
	ValaDataType* _tmp124_;
	gboolean _tmp125_;
	gboolean _tmp126_;
	gboolean _tmp127_;
	gboolean _tmp130_ = FALSE;
	gboolean _tmp131_ = FALSE;
	ValaProfile _tmp132_;
	ValaProfile _tmp133_;
	gboolean _tmp153_ = FALSE;
	gboolean _tmp154_ = FALSE;
	ValaProfile _tmp155_;
	ValaProfile _tmp156_;
	ValaExpression* _tmp185_;
	ValaExpression* _tmp186_;
	ValaExpression* _tmp187_;
	ValaExpression* _tmp188_;
	ValaDataType* _tmp189_;
	ValaDataType* _tmp190_;
	ValaDataType* _tmp191_;
	ValaDataType* _tmp192_;
	gboolean _tmp193_;
	gboolean _tmp194_;
	gboolean result = FALSE;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_cast_expression_get_inner (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_cast_expression_get_inner (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "Invalid cast expression");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_is_non_null_cast;
	if (_tmp12_) {
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = vala_cast_expression_get_inner (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_expression_get_value_type (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_data_type_copy (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_cast_expression_set_type_reference (self, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp19_ = vala_cast_expression_get_type_reference (self);
		_tmp20_ = _tmp19_;
		vala_data_type_set_nullable (_tmp20_, FALSE);
	}
	_tmp21_ = vala_cast_expression_get_type_reference (self);
	_tmp22_ = _tmp21_;
	vala_code_node_check ((ValaCodeNode*) _tmp22_, context);
	_tmp23_ = vala_cast_expression_get_type_reference (self);
	_tmp24_ = _tmp23_;
	if (VALA_IS_VOID_TYPE (_tmp24_)) {
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaList* _tmp29_;
		ValaCodeNode* _tmp30_;
		ValaCodeNode* _tmp31_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		ValaExpression* _tmp35_;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		vala_report_warning (_tmp26_, "Casting to `void' is not supported");
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp29_, (ValaCodeNode*) self);
		_tmp30_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_cast_expression_get_inner (self);
		_tmp33_ = _tmp32_;
		vala_code_node_replace_expression (_tmp31_, (ValaExpression*) self, _tmp33_);
		_tmp34_ = vala_cast_expression_get_inner (self);
		_tmp35_ = _tmp34_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp35_, context);
		return result;
	}
	_tmp37_ = vala_cast_expression_get_type_reference (self);
	_tmp38_ = _tmp37_;
	if (VALA_IS_DELEGATE_TYPE (_tmp38_)) {
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		_tmp39_ = vala_cast_expression_get_inner (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp36_ = VALA_IS_METHOD_TYPE (_tmp42_);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		_tmp43_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp44_ = _tmp43_;
		if (_tmp44_ != NULL) {
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			gboolean _tmp51_;
			gboolean _tmp52_;
			_tmp45_ = vala_cast_expression_get_inner (self);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_data_type_get_value_owned (_tmp50_);
			_tmp52_ = _tmp51_;
			vala_data_type_set_value_owned (_tmp48_, _tmp52_);
		} else {
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			ValaDataType* _tmp55_;
			ValaDataType* _tmp56_;
			_tmp53_ = vala_cast_expression_get_inner (self);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_expression_get_value_type (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_data_type_set_value_owned (_tmp56_, TRUE);
		}
	}
	_tmp60_ = self->priv->_is_silent_cast;
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp61_;
		_tmp61_ = self->priv->_is_non_null_cast;
		_tmp59_ = _tmp61_;
	}
	if (!_tmp59_) {
		gboolean _tmp62_ = FALSE;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		_tmp63_ = vala_cast_expression_get_type_reference (self);
		_tmp64_ = _tmp63_;
		if (VALA_IS_VALUE_TYPE (_tmp64_)) {
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			gboolean _tmp67_;
			gboolean _tmp68_;
			_tmp65_ = vala_cast_expression_get_type_reference (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_data_type_get_nullable (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp62_ = _tmp68_;
		} else {
			_tmp62_ = FALSE;
		}
		_tmp58_ = _tmp62_;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp69_ = vala_cast_expression_get_inner (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_expression_get_value_type (_tmp70_);
		_tmp72_ = _tmp71_;
		_tmp57_ = vala_data_type_is_non_null_simple_type (_tmp72_);
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp73_;
		ValaDataType* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		ValaExpression* _tmp77_;
		ValaExpression* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaSourceReference* _tmp80_;
		ValaLocalVariable* _tmp81_;
		ValaLocalVariable* _tmp82_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp83_;
		ValaSourceReference* _tmp84_;
		ValaSourceReference* _tmp85_;
		ValaDeclarationStatement* _tmp86_;
		ValaSemanticAnalyzer* _tmp87_;
		ValaSemanticAnalyzer* _tmp88_;
		ValaBlock* _tmp89_;
		ValaDeclarationStatement* _tmp90_;
		ValaExpression* temp_access = NULL;
		ValaLocalVariable* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaExpression* _tmp94_;
		ValaExpression* _tmp95_;
		ValaDataType* _tmp96_;
		ValaDataType* _tmp97_;
		ValaLocalVariable* _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaDeclarationStatement* _tmp101_;
		ValaSemanticAnalyzer* _tmp102_;
		ValaSemanticAnalyzer* _tmp103_;
		ValaList* _tmp104_;
		ValaCodeNode* _tmp105_;
		ValaCodeNode* _tmp106_;
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		_tmp73_ = vala_cast_expression_get_type_reference (self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_code_node_get_temp_name ();
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_cast_expression_get_inner (self);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_local_variable_new (_tmp74_, _tmp76_, NULL, _tmp80_);
		_tmp82_ = _tmp81_;
		_g_free0 (_tmp76_);
		local = _tmp82_;
		_tmp83_ = local;
		_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_declaration_statement_new ((ValaSymbol*) _tmp83_, _tmp85_);
		decl = _tmp86_;
		_tmp87_ = vala_code_context_get_analyzer (context);
		_tmp88_ = _tmp87_;
		_tmp89_ = _tmp88_->insert_block;
		_tmp90_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp89_, (ValaStatement*) _tmp90_);
		_tmp91_ = local;
		_tmp92_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_semantic_analyzer_create_temp_access (_tmp91_, _tmp93_);
		temp_access = _tmp94_;
		_tmp95_ = temp_access;
		_tmp96_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		vala_expression_set_formal_target_type (_tmp95_, _tmp97_);
		_tmp98_ = local;
		_tmp99_ = vala_cast_expression_get_inner (self);
		_tmp100_ = _tmp99_;
		vala_variable_set_initializer ((ValaVariable*) _tmp98_, _tmp100_);
		_tmp101_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
		_tmp102_ = vala_code_context_get_analyzer (context);
		_tmp103_ = _tmp102_;
		_tmp104_ = _tmp103_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp104_, (ValaCodeNode*) self);
		_tmp105_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = temp_access;
		vala_code_node_replace_expression (_tmp106_, (ValaExpression*) self, _tmp107_);
		_tmp108_ = temp_access;
		result = vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_vala_code_node_unref0 (temp_access);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp109_ = vala_cast_expression_get_type_reference (self);
	_tmp110_ = _tmp109_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp110_);
	_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_cast_expression_get_inner (self);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_expression_get_value_type (_tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_data_type_get_value_owned (_tmp116_);
	_tmp118_ = _tmp117_;
	vala_data_type_set_value_owned (_tmp112_, _tmp118_);
	_tmp119_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_cast_expression_get_inner (self);
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_expression_get_value_type (_tmp122_);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_data_type_get_floating_reference (_tmp124_);
	_tmp126_ = _tmp125_;
	vala_data_type_set_floating_reference (_tmp120_, _tmp126_);
	_tmp127_ = self->priv->_is_silent_cast;
	if (_tmp127_) {
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		_tmp128_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp129_ = _tmp128_;
		vala_data_type_set_nullable (_tmp129_, TRUE);
	}
	_tmp132_ = vala_code_context_get_profile (context);
	_tmp133_ = _tmp132_;
	if (_tmp133_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp134_;
		ValaExpression* _tmp135_;
		ValaDataType* _tmp136_;
		ValaDataType* _tmp137_;
		_tmp134_ = vala_cast_expression_get_inner (self);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_expression_get_value_type (_tmp135_);
		_tmp137_ = _tmp136_;
		_tmp131_ = vala_cast_expression_is_gvariant (self, context, _tmp137_);
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		ValaDataType* _tmp138_;
		ValaDataType* _tmp139_;
		_tmp138_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp139_ = _tmp138_;
		_tmp130_ = !vala_cast_expression_is_gvariant (self, context, _tmp139_);
	} else {
		_tmp130_ = FALSE;
	}
	if (_tmp130_) {
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		gboolean _tmp146_;
		_tmp140_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp141_ = _tmp140_;
		vala_data_type_set_value_owned (_tmp141_, TRUE);
		_tmp142_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_data_type_get_type_signature (_tmp143_, NULL);
		_tmp145_ = _tmp144_;
		_tmp146_ = _tmp145_ == NULL;
		_g_free0 (_tmp145_);
		if (_tmp146_) {
			ValaSourceReference* _tmp147_;
			ValaSourceReference* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_data_type_to_qualified_string (_tmp150_, NULL);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp148_, "Casting of `GLib.Variant' to `%s' is not supported", _tmp152_);
			_g_free0 (_tmp152_);
		}
	}
	_tmp155_ = vala_code_context_get_profile (context);
	_tmp156_ = _tmp155_;
	if (_tmp156_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp157_;
		ValaExpression* _tmp158_;
		ValaDataType* _tmp159_;
		ValaDataType* _tmp160_;
		_tmp157_ = vala_cast_expression_get_inner (self);
		_tmp158_ = _tmp157_;
		_tmp159_ = vala_expression_get_value_type (_tmp158_);
		_tmp160_ = _tmp159_;
		_tmp154_ = vala_cast_expression_is_gvalue (self, context, _tmp160_);
	} else {
		_tmp154_ = FALSE;
	}
	if (_tmp154_) {
		ValaDataType* _tmp161_;
		ValaDataType* _tmp162_;
		_tmp161_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp162_ = _tmp161_;
		_tmp153_ = !vala_cast_expression_is_gvalue (self, context, _tmp162_);
	} else {
		_tmp153_ = FALSE;
	}
	if (_tmp153_) {
		ValaDataType* _tmp163_;
		ValaDataType* _tmp164_;
		gboolean _tmp165_ = FALSE;
		gboolean _tmp166_ = FALSE;
		ValaDataType* _tmp167_;
		ValaDataType* _tmp168_;
		gboolean _tmp169_;
		gboolean _tmp170_;
		_tmp163_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp164_ = _tmp163_;
		vala_data_type_set_value_owned (_tmp164_, FALSE);
		_tmp167_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp168_ = _tmp167_;
		_tmp169_ = vala_data_type_get_nullable (_tmp168_);
		_tmp170_ = _tmp169_;
		if (_tmp170_) {
			ValaDataType* _tmp171_;
			ValaDataType* _tmp172_;
			ValaTypeSymbol* _tmp173_;
			ValaTypeSymbol* _tmp174_;
			_tmp171_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_data_type_get_type_symbol (_tmp172_);
			_tmp174_ = _tmp173_;
			_tmp166_ = _tmp174_ != NULL;
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			ValaDataType* _tmp175_;
			ValaDataType* _tmp176_;
			ValaTypeSymbol* _tmp177_;
			ValaTypeSymbol* _tmp178_;
			_tmp175_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_data_type_get_type_symbol (_tmp176_);
			_tmp178_ = _tmp177_;
			_tmp165_ = !vala_typesymbol_is_reference_type (_tmp178_);
		} else {
			_tmp165_ = FALSE;
		}
		if (_tmp165_) {
			ValaSourceReference* _tmp179_;
			ValaSourceReference* _tmp180_;
			ValaDataType* _tmp181_;
			ValaDataType* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp182_ = _tmp181_;
			_tmp183_ = vala_data_type_to_qualified_string (_tmp182_, NULL);
			_tmp184_ = _tmp183_;
			vala_report_error (_tmp180_, "Casting of `GLib.Value' to `%s' is not supported", _tmp184_);
			_g_free0 (_tmp184_);
		}
	}
	_tmp185_ = vala_cast_expression_get_inner (self);
	_tmp186_ = _tmp185_;
	_tmp187_ = vala_cast_expression_get_inner (self);
	_tmp188_ = _tmp187_;
	_tmp189_ = vala_expression_get_value_type (_tmp188_);
	_tmp190_ = _tmp189_;
	_tmp191_ = vala_data_type_copy (_tmp190_);
	_tmp192_ = _tmp191_;
	vala_expression_set_target_type (_tmp186_, _tmp192_);
	_vala_code_node_unref0 (_tmp192_);
	_tmp193_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp194_ = _tmp193_;
	result = !_tmp194_;
	return result;
}

static gboolean
vala_cast_expression_is_gvariant (ValaCastExpression* self,
                                  ValaCodeContext* context,
                                  ValaDataType* type)
{
	gboolean _tmp0_ = FALSE;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_type_symbol (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaSemanticAnalyzer* _tmp6_;
		ValaObjectType* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp3_ = vala_data_type_get_type_symbol (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_analyzer (context);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->gvariant_type;
		_tmp8_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = vala_typesymbol_is_subtype_of (_tmp4_, _tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_cast_expression_is_gvalue (ValaCastExpression* self,
                                ValaCodeContext* context,
                                ValaDataType* type)
{
	gboolean _tmp0_ = FALSE;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_type_symbol (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaSemanticAnalyzer* _tmp6_;
		ValaStructValueType* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp3_ = vala_data_type_get_type_symbol (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_analyzer (context);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->gvalue_type;
		_tmp8_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = vala_typesymbol_is_subtype_of (_tmp4_, _tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_cast_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_cast_expression_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_cast_expression_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static gboolean
vala_cast_expression_real_is_constant (ValaExpression* base)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result = FALSE;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_constant (_tmp1_);
	return result;
}

static void
vala_cast_expression_class_init (ValaCastExpressionClass * klass,
                                 gpointer klass_data)
{
	vala_cast_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_cast_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCastExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_cast_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_cast_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_cast_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_cast_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_cast_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_cast_expression_real_replace_type;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_cast_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_cast_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_cast_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_cast_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_cast_expression_real_get_used_variables;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_constant;
}

static void
vala_cast_expression_instance_init (ValaCastExpression * self,
                                    gpointer klass)
{
	self->priv = vala_cast_expression_get_instance_private (self);
}

static void
vala_cast_expression_finalize (ValaCodeNode * obj)
{
	ValaCastExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_cast_expression_parent_class)->finalize (obj);
}

/**
 * Represents a type cast in the source code.
 */
static GType
vala_cast_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCastExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_cast_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCastExpression), 0, (GInstanceInitFunc) vala_cast_expression_instance_init, NULL };
	GType vala_cast_expression_type_id;
	vala_cast_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaCastExpression", &g_define_type_info, 0);
	ValaCastExpression_private_offset = g_type_add_instance_private (vala_cast_expression_type_id, sizeof (ValaCastExpressionPrivate));
	return vala_cast_expression_type_id;
}

GType
vala_cast_expression_get_type (void)
{
	static volatile gsize vala_cast_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_cast_expression_type_id__volatile)) {
		GType vala_cast_expression_type_id;
		vala_cast_expression_type_id = vala_cast_expression_get_type_once ();
		g_once_init_leave (&vala_cast_expression_type_id__volatile, vala_cast_expression_type_id);
	}
	return vala_cast_expression_type_id__volatile;
}

