/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_compact;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp11_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			gboolean _tmp9_;
			gboolean* _tmp10_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_ != NULL;
			_tmp10_ = __bool_dup0 (&_tmp9_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp10_;
		}
	}
	_tmp11_ = self->priv->_is_immutable;
	result = *_tmp11_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		gboolean _tmp2_;
		gboolean* _tmp3_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = _tmp1_ != NULL;
		_tmp3_ = __bool_dup0 (&_tmp2_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp3_;
	}
	_tmp4_ = self->priv->_is_singleton;
	result = *_tmp4_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	result = _tmp0_ != NULL;
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp23_ = _tmp28_ > 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaDataType* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		_tmp29_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp30_ = _tmp29_;
		if (_tmp30_ != NULL) {
			ValaScope* _tmp31_;
			ValaScope* _tmp32_;
			ValaLocalVariable* _tmp33_;
			ValaLocalVariable* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_scope_remove (_tmp32_, _tmp36_);
		}
		_tmp37_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_data_type_copy (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_local_variable_new (_tmp40_, "result", NULL, _tmp42_);
		_tmp44_ = _tmp43_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp44_);
		_vala_code_node_unref0 (_tmp44_);
		_vala_code_node_unref0 (_tmp40_);
		_tmp45_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp46_ = _tmp45_;
		vala_local_variable_set_is_result (_tmp46_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp49_ = FALSE;
		ValaCreationMethod* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_;
		_tmp47_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp48_ = _tmp47_;
		if (_tmp48_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp50_ = cm;
		_tmp51_ = vala_creation_method_get_class_name (_tmp50_);
		_tmp52_ = _tmp51_;
		if (_tmp52_ != NULL) {
			ValaCreationMethod* _tmp53_;
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			_tmp53_ = cm;
			_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp57_ = _tmp56_;
			_tmp49_ = g_strcmp0 (_tmp55_, _tmp57_) != 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaSourceReference* _tmp58_;
			ValaSourceReference* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			ValaCreationMethod* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = cm;
			_tmp63_ = vala_creation_method_get_class_name (_tmp62_);
			_tmp64_ = _tmp63_;
			vala_report_error (_tmp59_, "missing return type in method `%s.%s´", _tmp61_, _tmp64_);
			_g_free0 (_tmp61_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp66_ = self->priv->_is_abstract;
		if (_tmp66_) {
			ValaCreationMethod* _tmp67_;
			ValaSymbolAccessibility _tmp68_;
			ValaSymbolAccessibility _tmp69_;
			_tmp67_ = cm;
			_tmp68_ = vala_symbol_get_access ((ValaSymbol*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp65_ = FALSE;
		}
		if (_tmp65_) {
			gboolean _tmp70_;
			gboolean _tmp71_;
			_tmp70_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp71_ = _tmp70_;
			if (_tmp71_) {
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp73_ = _tmp72_;
				vala_report_warning (_tmp73_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp14_;
	ValaField* _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaParameter* _tmp8_;
		ValaParameter* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaParameter* _tmp12_;
		ValaParameter* _tmp13_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_parameter_new ("this", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		vala_property_set_this_parameter (prop, _tmp5_);
		_vala_code_node_unref0 (_tmp5_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_property_get_this_parameter (prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_name ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_property_get_this_parameter (prop);
		_tmp13_ = _tmp12_;
		vala_scope_add (_tmp7_, _tmp11_, (ValaSymbol*) _tmp13_);
	}
	_tmp14_ = vala_property_get_field (prop);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaField* _tmp16_;
		ValaField* _tmp17_;
		_tmp16_ = vala_property_get_field (prop);
		_tmp17_ = _tmp16_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp17_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_constructor_set_this_parameter (c, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_constructor_get_this_parameter (c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_constructor_get_this_parameter (c);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaParameter* _tmp26_;
		ValaParameter* _tmp27_;
		ValaScope* _tmp28_;
		ValaScope* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		ValaParameter* _tmp34_;
		ValaParameter* _tmp35_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_parameter_new ("this", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_destructor_set_this_parameter (d, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_destructor_get_this_parameter (d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_destructor_get_this_parameter (d);
		_tmp35_ = _tmp34_;
		vala_scope_add (_tmp29_, _tmp33_, (ValaSymbol*) _tmp35_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp88_ = FALSE;
	ValaClass* _tmp89_;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp110_ = FALSE;
	gboolean _tmp111_;
	gboolean _tmp112_;
	gboolean _tmp124_ = FALSE;
	ValaClass* _tmp125_;
	gboolean _tmp135_;
	ValaConstructor* _tmp254_;
	ValaConstructor* _tmp255_;
	ValaConstructor* _tmp258_;
	ValaConstructor* _tmp259_;
	ValaConstructor* _tmp262_;
	ValaConstructor* _tmp263_;
	ValaDestructor* _tmp266_;
	ValaDestructor* _tmp267_;
	ValaDestructor* _tmp270_;
	ValaDestructor* _tmp271_;
	ValaDestructor* _tmp274_;
	ValaDestructor* _tmp275_;
	gboolean _tmp314_;
	gboolean _tmp315_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp356_;
	ValaArrayList* _tmp357_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp373_;
	ValaArrayList* _tmp374_;
	ValaList* _tmp388_;
	gint _tmp389_;
	gint _tmp390_;
	ValaSourceFileType _tmp414_;
	ValaSourceFileType _tmp415_;
	ValaSemanticAnalyzer* _tmp632_;
	ValaSemanticAnalyzer* _tmp633_;
	ValaSourceFile* _tmp634_;
	ValaSemanticAnalyzer* _tmp635_;
	ValaSemanticAnalyzer* _tmp636_;
	ValaSymbol* _tmp637_;
	gboolean _tmp638_;
	gboolean _tmp639_;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaDataType* _tmp43_;
			gint n_type_args = 0;
			ValaDataType* _tmp51_;
			ValaList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint n_type_params = 0;
			ValaDataType* _tmp55_;
			ValaTypeSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaList* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = vala_code_context_get_analyzer (context);
			_tmp42_ = _tmp41_;
			_tmp43_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp42_, (ValaSymbol*) self, _tmp43_)) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				ValaDataType* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				_tmp46_ = base_type_reference;
				_tmp47_ = vala_code_node_to_string ((ValaCodeNode*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp50_ = _tmp49_;
				vala_report_error (_tmp45_, "base type `%s' is less accessible than class `%s'", _tmp48_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp51_ = base_type_reference;
			_tmp52_ = vala_data_type_get_type_arguments (_tmp51_);
			_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			n_type_args = _tmp54_;
			_tmp55_ = base_type_reference;
			_tmp56_ = vala_data_type_get_type_symbol (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
			_tmp60_ = _tmp59_;
			n_type_params = _tmp60_;
			if (n_type_args < n_type_params) {
				ValaDataType* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaSourceReference* _tmp63_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp61_ = base_type_reference;
				_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
				_tmp63_ = _tmp62_;
				vala_report_error (_tmp63_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				if (n_type_args > n_type_params) {
					ValaDataType* _tmp64_;
					ValaSourceReference* _tmp65_;
					ValaSourceReference* _tmp66_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp64_ = base_type_reference;
					_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp64_);
					_tmp66_ = _tmp65_;
					vala_report_error (_tmp66_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp67_;
		gint _type_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _type_index = 0;
		_tmp67_ = self->priv->base_types;
		_type_list = _tmp67_;
		_tmp68_ = _type_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_type_size = _tmp70_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			ValaDataType* type = NULL;
			ValaList* _tmp73_;
			gpointer _tmp74_;
			ValaDataType* _tmp75_;
			ValaSemanticAnalyzer* _tmp76_;
			ValaSemanticAnalyzer* _tmp77_;
			ValaDataType* _tmp78_;
			_type_index = _type_index + 1;
			_tmp71_ = _type_index;
			_tmp72_ = _type_size;
			if (!(_tmp71_ < _tmp72_)) {
				break;
			}
			_tmp73_ = _type_list;
			_tmp74_ = vala_list_get (_tmp73_, _type_index);
			type = (ValaDataType*) _tmp74_;
			_tmp75_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp75_, context);
			_tmp76_ = vala_code_context_get_analyzer (context);
			_tmp77_ = _tmp76_;
			_tmp78_ = type;
			vala_semantic_analyzer_check_type (_tmp77_, _tmp78_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp79_;
		gint _p_size = 0;
		ValaList* _tmp80_;
		gint _tmp81_;
		gint _tmp82_;
		gint _p_index = 0;
		_tmp79_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp79_;
		_tmp80_ = _p_list;
		_tmp81_ = vala_collection_get_size ((ValaCollection*) _tmp80_);
		_tmp82_ = _tmp81_;
		_p_size = _tmp82_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp83_;
			gint _tmp84_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaTypeParameter* _tmp87_;
			_p_index = _p_index + 1;
			_tmp83_ = _p_index;
			_tmp84_ = _p_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _p_list;
			_tmp86_ = vala_list_get (_tmp85_, _p_index);
			p = (ValaTypeParameter*) _tmp86_;
			_tmp87_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp87_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp89_ = self->priv->_base_class;
	if (_tmp89_ != NULL) {
		ValaClass* _tmp90_;
		gboolean _tmp91_;
		gboolean _tmp92_;
		_tmp90_ = self->priv->_base_class;
		_tmp91_ = vala_class_get_is_singleton (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp88_ = _tmp92_;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		ValaSourceReference* _tmp93_;
		ValaSourceReference* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		ValaClass* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = self->priv->_base_class;
		_tmp98_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp97_);
		_tmp99_ = _tmp98_;
		vala_report_error (_tmp94_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp96_, _tmp99_);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp96_);
	}
	_tmp101_ = vala_class_get_is_singleton (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_) {
		ValaSemanticAnalyzer* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaClass* _tmp105_;
		_tmp103_ = vala_code_context_get_analyzer (context);
		_tmp104_ = _tmp103_;
		_tmp105_ = _tmp104_->object_type;
		_tmp100_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp105_);
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp107_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp109_);
		_g_free0 (_tmp109_);
	}
	_tmp111_ = vala_class_get_is_singleton (self);
	_tmp112_ = _tmp111_;
	if (_tmp112_) {
		ValaConstructor* _tmp113_;
		ValaConstructor* _tmp114_;
		_tmp113_ = vala_class_get_constructor (self);
		_tmp114_ = _tmp113_;
		_tmp110_ = _tmp114_ == NULL;
	} else {
		_tmp110_ = FALSE;
	}
	if (_tmp110_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp115_;
		ValaSourceReference* _tmp116_;
		ValaConstructor* _tmp117_;
		ValaConstructor* _tmp118_;
		ValaSourceReference* _tmp119_;
		ValaSourceReference* _tmp120_;
		ValaBlock* _tmp121_;
		ValaBlock* _tmp122_;
		ValaConstructor* _tmp123_;
		_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_constructor_new (_tmp116_);
		c = _tmp117_;
		_tmp118_ = c;
		_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_block_new (_tmp120_);
		_tmp122_ = _tmp121_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp118_, _tmp122_);
		_vala_code_node_unref0 (_tmp122_);
		_tmp123_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp123_);
		_vala_code_node_unref0 (c);
	}
	_tmp125_ = self->priv->_base_class;
	if (_tmp125_ != NULL) {
		ValaClass* _tmp126_;
		gboolean _tmp127_;
		_tmp126_ = self->priv->_base_class;
		_tmp127_ = _tmp126_->priv->_is_sealed;
		_tmp124_ = _tmp127_;
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		ValaSourceReference* _tmp128_;
		ValaSourceReference* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		ValaClass* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = self->priv->_base_class;
		_tmp133_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp132_);
		_tmp134_ = _tmp133_;
		vala_report_error (_tmp129_, "`%s' cannot inherit from sealed class `%s'", _tmp131_, _tmp134_);
		_g_free0 (_tmp134_);
		_g_free0 (_tmp131_);
	}
	_tmp135_ = self->priv->_is_sealed;
	if (_tmp135_) {
		gboolean _tmp136_;
		gboolean _tmp137_;
		gboolean _tmp142_;
		gboolean _tmp147_;
		gboolean _tmp148_;
		_tmp136_ = vala_class_get_is_compact (self);
		_tmp137_ = _tmp136_;
		if (_tmp137_) {
			ValaSourceReference* _tmp138_;
			ValaSourceReference* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp139_, "Sealed class `%s' cannot be compact", _tmp141_);
			_g_free0 (_tmp141_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp142_ = self->priv->_is_abstract;
		if (_tmp142_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp146_ = _tmp145_;
			vala_report_error (_tmp144_, "Sealed class `%s' cannot be abstract", _tmp146_);
			_g_free0 (_tmp146_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp147_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp148_ = _tmp147_;
		if (!_tmp148_) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp150_, "Sealed classes are not fully supported yet");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp151_;
		gint _en_size = 0;
		ValaList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		gint _en_index = 0;
		_tmp151_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp151_;
		_tmp152_ = _en_list;
		_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		_en_size = _tmp154_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp155_;
			gint _tmp156_;
			ValaEnum* en = NULL;
			ValaList* _tmp157_;
			gpointer _tmp158_;
			ValaEnum* _tmp159_;
			_en_index = _en_index + 1;
			_tmp155_ = _en_index;
			_tmp156_ = _en_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _en_list;
			_tmp158_ = vala_list_get (_tmp157_, _en_index);
			en = (ValaEnum*) _tmp158_;
			_tmp159_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp159_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp160_;
		gint _f_size = 0;
		ValaList* _tmp161_;
		gint _tmp162_;
		gint _tmp163_;
		gint _f_index = 0;
		_tmp160_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp160_;
		_tmp161_ = _f_list;
		_tmp162_ = vala_collection_get_size ((ValaCollection*) _tmp161_);
		_tmp163_ = _tmp162_;
		_f_size = _tmp163_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp164_;
			gint _tmp165_;
			ValaField* f = NULL;
			ValaList* _tmp166_;
			gpointer _tmp167_;
			gboolean _tmp168_ = FALSE;
			gboolean _tmp169_;
			gboolean _tmp170_;
			ValaField* _tmp208_;
			_f_index = _f_index + 1;
			_tmp164_ = _f_index;
			_tmp165_ = _f_size;
			if (!(_tmp164_ < _tmp165_)) {
				break;
			}
			_tmp166_ = _f_list;
			_tmp167_ = vala_list_get (_tmp166_, _f_index);
			f = (ValaField*) _tmp167_;
			_tmp169_ = vala_class_get_is_compact (self);
			_tmp170_ = _tmp169_;
			if (_tmp170_) {
				ValaField* _tmp171_;
				ValaMemberBinding _tmp172_;
				ValaMemberBinding _tmp173_;
				_tmp171_ = f;
				_tmp172_ = vala_field_get_binding (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp168_ = _tmp173_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp168_ = FALSE;
			}
			if (_tmp168_) {
				gboolean _tmp174_ = FALSE;
				gboolean _tmp175_ = FALSE;
				gboolean _tmp176_;
				gboolean _tmp177_;
				gboolean _tmp186_ = FALSE;
				gboolean _tmp187_ = FALSE;
				gboolean _tmp188_;
				gboolean _tmp189_;
				ValaField* _tmp202_;
				ValaMemberBinding _tmp203_;
				ValaMemberBinding _tmp204_;
				_tmp176_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp177_ = _tmp176_;
				if (!_tmp177_) {
					gboolean _tmp178_;
					gboolean _tmp179_;
					_tmp178_ = vala_class_get_is_opaque (self);
					_tmp179_ = _tmp178_;
					_tmp175_ = !_tmp179_;
				} else {
					_tmp175_ = FALSE;
				}
				if (_tmp175_) {
					ValaField* _tmp180_;
					ValaSymbolAccessibility _tmp181_;
					ValaSymbolAccessibility _tmp182_;
					_tmp180_ = f;
					_tmp181_ = vala_symbol_get_access ((ValaSymbol*) _tmp180_);
					_tmp182_ = _tmp181_;
					_tmp174_ = _tmp182_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp174_ = FALSE;
				}
				if (_tmp174_) {
					ValaField* _tmp183_;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					_tmp183_ = f;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
					_tmp185_ = _tmp184_;
					vala_report_error (_tmp185_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp188_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp189_ = _tmp188_;
				if (!_tmp189_) {
					gboolean _tmp190_;
					gboolean _tmp191_;
					_tmp190_ = vala_class_get_is_opaque (self);
					_tmp191_ = _tmp190_;
					_tmp187_ = _tmp191_;
				} else {
					_tmp187_ = FALSE;
				}
				if (_tmp187_) {
					gboolean _tmp192_ = FALSE;
					ValaField* _tmp193_;
					ValaSymbolAccessibility _tmp194_;
					ValaSymbolAccessibility _tmp195_;
					_tmp193_ = f;
					_tmp194_ = vala_symbol_get_access ((ValaSymbol*) _tmp193_);
					_tmp195_ = _tmp194_;
					if (_tmp195_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp192_ = TRUE;
					} else {
						ValaField* _tmp196_;
						ValaSymbolAccessibility _tmp197_;
						ValaSymbolAccessibility _tmp198_;
						_tmp196_ = f;
						_tmp197_ = vala_symbol_get_access ((ValaSymbol*) _tmp196_);
						_tmp198_ = _tmp197_;
						_tmp192_ = _tmp198_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp186_ = _tmp192_;
				} else {
					_tmp186_ = FALSE;
				}
				if (_tmp186_) {
					ValaField* _tmp199_;
					ValaSourceReference* _tmp200_;
					ValaSourceReference* _tmp201_;
					_tmp199_ = f;
					_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp199_);
					_tmp201_ = _tmp200_;
					vala_report_error (_tmp201_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp202_ = f;
				_tmp203_ = vala_field_get_binding (_tmp202_);
				_tmp204_ = _tmp203_;
				if (_tmp204_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp205_;
					ValaSourceReference* _tmp206_;
					ValaSourceReference* _tmp207_;
					_tmp205_ = f;
					_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp205_);
					_tmp207_ = _tmp206_;
					vala_report_error (_tmp207_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp208_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp209_;
		gint _c_size = 0;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		gint _c_index = 0;
		_tmp209_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp209_;
		_tmp210_ = _c_list;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		_c_size = _tmp212_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp213_;
			gint _tmp214_;
			ValaConstant* c = NULL;
			ValaList* _tmp215_;
			gpointer _tmp216_;
			ValaConstant* _tmp217_;
			_c_index = _c_index + 1;
			_tmp213_ = _c_index;
			_tmp214_ = _c_size;
			if (!(_tmp213_ < _tmp214_)) {
				break;
			}
			_tmp215_ = _c_list;
			_tmp216_ = vala_list_get (_tmp215_, _c_index);
			c = (ValaConstant*) _tmp216_;
			_tmp217_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp218_;
		gint _m_size = 0;
		ValaList* _tmp219_;
		gint _tmp220_;
		gint _tmp221_;
		gint _m_index = 0;
		_tmp218_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp218_;
		_tmp219_ = _m_list;
		_tmp220_ = vala_collection_get_size ((ValaCollection*) _tmp219_);
		_tmp221_ = _tmp220_;
		_m_size = _tmp221_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp222_;
			gint _tmp223_;
			ValaMethod* m = NULL;
			ValaList* _tmp224_;
			gpointer _tmp225_;
			ValaMethod* _tmp226_;
			_m_index = _m_index + 1;
			_tmp222_ = _m_index;
			_tmp223_ = _m_size;
			if (!(_tmp222_ < _tmp223_)) {
				break;
			}
			_tmp224_ = _m_list;
			_tmp225_ = vala_list_get (_tmp224_, _m_index);
			m = (ValaMethod*) _tmp225_;
			_tmp226_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp226_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp227_;
		gint _prop_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _prop_index = 0;
		_tmp227_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp227_;
		_tmp228_ = _prop_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_prop_size = _tmp230_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp231_;
			gint _tmp232_;
			ValaProperty* prop = NULL;
			ValaList* _tmp233_;
			gpointer _tmp234_;
			gboolean _tmp235_ = FALSE;
			ValaProperty* _tmp236_;
			ValaAttribute* _tmp237_;
			ValaProperty* _tmp244_;
			_prop_index = _prop_index + 1;
			_tmp231_ = _prop_index;
			_tmp232_ = _prop_size;
			if (!(_tmp231_ < _tmp232_)) {
				break;
			}
			_tmp233_ = _prop_list;
			_tmp234_ = vala_list_get (_tmp233_, _prop_index);
			prop = (ValaProperty*) _tmp234_;
			_tmp236_ = prop;
			_tmp237_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp236_, "NoAccessorMethod");
			if (_tmp237_ != NULL) {
				ValaSemanticAnalyzer* _tmp238_;
				ValaSemanticAnalyzer* _tmp239_;
				ValaClass* _tmp240_;
				_tmp238_ = vala_code_context_get_analyzer (context);
				_tmp239_ = _tmp238_;
				_tmp240_ = _tmp239_->object_type;
				_tmp235_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp240_);
			} else {
				_tmp235_ = FALSE;
			}
			if (_tmp235_) {
				ValaProperty* _tmp241_;
				ValaSourceReference* _tmp242_;
				ValaSourceReference* _tmp243_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp241_ = prop;
				_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp241_);
				_tmp243_ = _tmp242_;
				vala_report_error (_tmp243_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp244_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp244_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp245_;
		gint _sig_size = 0;
		ValaList* _tmp246_;
		gint _tmp247_;
		gint _tmp248_;
		gint _sig_index = 0;
		_tmp245_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp245_;
		_tmp246_ = _sig_list;
		_tmp247_ = vala_collection_get_size ((ValaCollection*) _tmp246_);
		_tmp248_ = _tmp247_;
		_sig_size = _tmp248_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp249_;
			gint _tmp250_;
			ValaSignal* sig = NULL;
			ValaList* _tmp251_;
			gpointer _tmp252_;
			ValaSignal* _tmp253_;
			_sig_index = _sig_index + 1;
			_tmp249_ = _sig_index;
			_tmp250_ = _sig_size;
			if (!(_tmp249_ < _tmp250_)) {
				break;
			}
			_tmp251_ = _sig_list;
			_tmp252_ = vala_list_get (_tmp251_, _sig_index);
			sig = (ValaSignal*) _tmp252_;
			_tmp253_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp253_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp254_ = vala_class_get_constructor (self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ != NULL) {
		ValaConstructor* _tmp256_;
		ValaConstructor* _tmp257_;
		_tmp256_ = vala_class_get_constructor (self);
		_tmp257_ = _tmp256_;
		vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
	}
	_tmp258_ = vala_class_get_class_constructor (self);
	_tmp259_ = _tmp258_;
	if (_tmp259_ != NULL) {
		ValaConstructor* _tmp260_;
		ValaConstructor* _tmp261_;
		_tmp260_ = vala_class_get_class_constructor (self);
		_tmp261_ = _tmp260_;
		vala_code_node_check ((ValaCodeNode*) _tmp261_, context);
	}
	_tmp262_ = vala_class_get_static_constructor (self);
	_tmp263_ = _tmp262_;
	if (_tmp263_ != NULL) {
		ValaConstructor* _tmp264_;
		ValaConstructor* _tmp265_;
		_tmp264_ = vala_class_get_static_constructor (self);
		_tmp265_ = _tmp264_;
		vala_code_node_check ((ValaCodeNode*) _tmp265_, context);
	}
	_tmp266_ = vala_class_get_destructor (self);
	_tmp267_ = _tmp266_;
	if (_tmp267_ != NULL) {
		ValaDestructor* _tmp268_;
		ValaDestructor* _tmp269_;
		_tmp268_ = vala_class_get_destructor (self);
		_tmp269_ = _tmp268_;
		vala_code_node_check ((ValaCodeNode*) _tmp269_, context);
	}
	_tmp270_ = vala_class_get_static_destructor (self);
	_tmp271_ = _tmp270_;
	if (_tmp271_ != NULL) {
		ValaDestructor* _tmp272_;
		ValaDestructor* _tmp273_;
		_tmp272_ = vala_class_get_static_destructor (self);
		_tmp273_ = _tmp272_;
		vala_code_node_check ((ValaCodeNode*) _tmp273_, context);
	}
	_tmp274_ = vala_class_get_class_destructor (self);
	_tmp275_ = _tmp274_;
	if (_tmp275_ != NULL) {
		ValaDestructor* _tmp276_;
		ValaDestructor* _tmp277_;
		_tmp276_ = vala_class_get_class_destructor (self);
		_tmp277_ = _tmp276_;
		vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp278_;
		gint _cl_size = 0;
		ValaList* _tmp279_;
		gint _tmp280_;
		gint _tmp281_;
		gint _cl_index = 0;
		_tmp278_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp278_;
		_tmp279_ = _cl_list;
		_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
		_tmp281_ = _tmp280_;
		_cl_size = _tmp281_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp282_;
			gint _tmp283_;
			ValaClass* cl = NULL;
			ValaList* _tmp284_;
			gpointer _tmp285_;
			ValaClass* _tmp286_;
			_cl_index = _cl_index + 1;
			_tmp282_ = _cl_index;
			_tmp283_ = _cl_size;
			if (!(_tmp282_ < _tmp283_)) {
				break;
			}
			_tmp284_ = _cl_list;
			_tmp285_ = vala_list_get (_tmp284_, _cl_index);
			cl = (ValaClass*) _tmp285_;
			_tmp286_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp286_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp287_;
		gint _iface_size = 0;
		ValaList* _tmp288_;
		gint _tmp289_;
		gint _tmp290_;
		gint _iface_index = 0;
		_tmp287_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp287_;
		_tmp288_ = _iface_list;
		_tmp289_ = vala_collection_get_size ((ValaCollection*) _tmp288_);
		_tmp290_ = _tmp289_;
		_iface_size = _tmp290_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp291_;
			gint _tmp292_;
			ValaInterface* iface = NULL;
			ValaList* _tmp293_;
			gpointer _tmp294_;
			ValaInterface* _tmp295_;
			_iface_index = _iface_index + 1;
			_tmp291_ = _iface_index;
			_tmp292_ = _iface_size;
			if (!(_tmp291_ < _tmp292_)) {
				break;
			}
			_tmp293_ = _iface_list;
			_tmp294_ = vala_list_get (_tmp293_, _iface_index);
			iface = (ValaInterface*) _tmp294_;
			_tmp295_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp295_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp296_;
		gint _st_size = 0;
		ValaList* _tmp297_;
		gint _tmp298_;
		gint _tmp299_;
		gint _st_index = 0;
		_tmp296_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp296_;
		_tmp297_ = _st_list;
		_tmp298_ = vala_collection_get_size ((ValaCollection*) _tmp297_);
		_tmp299_ = _tmp298_;
		_st_size = _tmp299_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp300_;
			gint _tmp301_;
			ValaStruct* st = NULL;
			ValaList* _tmp302_;
			gpointer _tmp303_;
			ValaStruct* _tmp304_;
			_st_index = _st_index + 1;
			_tmp300_ = _st_index;
			_tmp301_ = _st_size;
			if (!(_tmp300_ < _tmp301_)) {
				break;
			}
			_tmp302_ = _st_list;
			_tmp303_ = vala_list_get (_tmp302_, _st_index);
			st = (ValaStruct*) _tmp303_;
			_tmp304_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp304_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp305_;
		gint _d_size = 0;
		ValaList* _tmp306_;
		gint _tmp307_;
		gint _tmp308_;
		gint _d_index = 0;
		_tmp305_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp305_;
		_tmp306_ = _d_list;
		_tmp307_ = vala_collection_get_size ((ValaCollection*) _tmp306_);
		_tmp308_ = _tmp307_;
		_d_size = _tmp308_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp309_;
			gint _tmp310_;
			ValaDelegate* d = NULL;
			ValaList* _tmp311_;
			gpointer _tmp312_;
			ValaDelegate* _tmp313_;
			_d_index = _d_index + 1;
			_tmp309_ = _d_index;
			_tmp310_ = _d_size;
			if (!(_tmp309_ < _tmp310_)) {
				break;
			}
			_tmp311_ = _d_list;
			_tmp312_ = vala_list_get (_tmp311_, _d_index);
			d = (ValaDelegate*) _tmp312_;
			_tmp313_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp313_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp314_ = vala_class_get_is_compact (self);
	_tmp315_ = _tmp314_;
	if (_tmp315_) {
		gboolean _tmp331_ = FALSE;
		gboolean _tmp332_ = FALSE;
		gboolean _tmp333_ = FALSE;
		gboolean _tmp334_;
		gboolean _tmp335_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp316_;
			gint _base_type_size = 0;
			ValaList* _tmp317_;
			gint _tmp318_;
			gint _tmp319_;
			gint _base_type_index = 0;
			_tmp316_ = vala_class_get_base_types (self);
			_base_type_list = _tmp316_;
			_tmp317_ = _base_type_list;
			_tmp318_ = vala_collection_get_size ((ValaCollection*) _tmp317_);
			_tmp319_ = _tmp318_;
			_base_type_size = _tmp319_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp320_;
				gint _tmp321_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp322_;
				gpointer _tmp323_;
				ValaDataType* _tmp324_;
				ValaTypeSymbol* _tmp325_;
				ValaTypeSymbol* _tmp326_;
				_base_type_index = _base_type_index + 1;
				_tmp320_ = _base_type_index;
				_tmp321_ = _base_type_size;
				if (!(_tmp320_ < _tmp321_)) {
					break;
				}
				_tmp322_ = _base_type_list;
				_tmp323_ = vala_list_get (_tmp322_, _base_type_index);
				base_type = (ValaDataType*) _tmp323_;
				_tmp324_ = base_type;
				_tmp325_ = vala_data_type_get_type_symbol (_tmp324_);
				_tmp326_ = _tmp325_;
				if (VALA_IS_INTERFACE (_tmp326_)) {
					ValaSourceReference* _tmp327_;
					ValaSourceReference* _tmp328_;
					gchar* _tmp329_;
					gchar* _tmp330_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp328_ = _tmp327_;
					_tmp329_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp330_ = _tmp329_;
					vala_report_error (_tmp328_, "compact classes `%s' may not implement interfaces", _tmp330_);
					_g_free0 (_tmp330_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp334_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp335_ = _tmp334_;
		if (!_tmp335_) {
			gboolean _tmp336_;
			gboolean _tmp337_;
			_tmp336_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp337_ = _tmp336_;
			_tmp333_ = !_tmp337_;
		} else {
			_tmp333_ = FALSE;
		}
		if (_tmp333_) {
			ValaClass* _tmp338_;
			_tmp338_ = self->priv->_base_class;
			_tmp332_ = _tmp338_ != NULL;
		} else {
			_tmp332_ = FALSE;
		}
		if (_tmp332_) {
			ValaClass* _tmp339_;
			ValaSemanticAnalyzer* _tmp340_;
			ValaSemanticAnalyzer* _tmp341_;
			ValaClass* _tmp342_;
			_tmp339_ = self->priv->_base_class;
			_tmp340_ = vala_code_context_get_analyzer (context);
			_tmp341_ = _tmp340_;
			_tmp342_ = _tmp341_->gsource_type;
			_tmp331_ = _tmp339_ != _tmp342_;
		} else {
			_tmp331_ = FALSE;
		}
		if (_tmp331_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp343_;
				gint _f_size = 0;
				ValaList* _tmp344_;
				gint _tmp345_;
				gint _tmp346_;
				gint _f_index = 0;
				_tmp343_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp343_;
				_tmp344_ = _f_list;
				_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
				_tmp346_ = _tmp345_;
				_f_size = _tmp346_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp347_;
					gint _tmp348_;
					ValaField* f = NULL;
					ValaList* _tmp349_;
					gpointer _tmp350_;
					ValaField* _tmp351_;
					ValaMemberBinding _tmp352_;
					ValaMemberBinding _tmp353_;
					_f_index = _f_index + 1;
					_tmp347_ = _f_index;
					_tmp348_ = _f_size;
					if (!(_tmp347_ < _tmp348_)) {
						break;
					}
					_tmp349_ = _f_list;
					_tmp350_ = vala_list_get (_tmp349_, _f_index);
					f = (ValaField*) _tmp350_;
					_tmp351_ = f;
					_tmp352_ = vala_field_get_binding (_tmp351_);
					_tmp353_ = _tmp352_;
					if (_tmp353_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp354_;
						ValaSourceReference* _tmp355_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp355_ = _tmp354_;
						vala_report_error (_tmp355_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp356_ = g_direct_equal;
	_tmp357_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp356_);
	prerequisites = (ValaList*) _tmp357_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp358_;
		gint _base_type_size = 0;
		ValaList* _tmp359_;
		gint _tmp360_;
		gint _tmp361_;
		gint _base_type_index = 0;
		_tmp358_ = vala_class_get_base_types (self);
		_base_type_list = _tmp358_;
		_tmp359_ = _base_type_list;
		_tmp360_ = vala_collection_get_size ((ValaCollection*) _tmp359_);
		_tmp361_ = _tmp360_;
		_base_type_size = _tmp361_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp362_;
			gint _tmp363_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp364_;
			gpointer _tmp365_;
			ValaDataType* _tmp366_;
			ValaTypeSymbol* _tmp367_;
			ValaTypeSymbol* _tmp368_;
			_base_type_index = _base_type_index + 1;
			_tmp362_ = _base_type_index;
			_tmp363_ = _base_type_size;
			if (!(_tmp362_ < _tmp363_)) {
				break;
			}
			_tmp364_ = _base_type_list;
			_tmp365_ = vala_list_get (_tmp364_, _base_type_index);
			base_type = (ValaDataType*) _tmp365_;
			_tmp366_ = base_type;
			_tmp367_ = vala_data_type_get_type_symbol (_tmp366_);
			_tmp368_ = _tmp367_;
			if (VALA_IS_INTERFACE (_tmp368_)) {
				ValaDataType* _tmp369_;
				ValaTypeSymbol* _tmp370_;
				ValaTypeSymbol* _tmp371_;
				ValaList* _tmp372_;
				_tmp369_ = base_type;
				_tmp370_ = vala_data_type_get_type_symbol (_tmp369_);
				_tmp371_ = _tmp370_;
				_tmp372_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_INTERFACE, ValaInterface), _tmp372_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp373_ = g_str_equal;
	_tmp374_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp373_);
	missing_prereqs = (ValaList*) _tmp374_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp375_;
		gint _prereq_size = 0;
		ValaList* _tmp376_;
		gint _tmp377_;
		gint _tmp378_;
		gint _prereq_index = 0;
		_tmp375_ = prerequisites;
		_prereq_list = _tmp375_;
		_tmp376_ = _prereq_list;
		_tmp377_ = vala_collection_get_size ((ValaCollection*) _tmp376_);
		_tmp378_ = _tmp377_;
		_prereq_size = _tmp378_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp379_;
			gint _tmp380_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp381_;
			gpointer _tmp382_;
			ValaTypeSymbol* _tmp383_;
			_prereq_index = _prereq_index + 1;
			_tmp379_ = _prereq_index;
			_tmp380_ = _prereq_size;
			if (!(_tmp379_ < _tmp380_)) {
				break;
			}
			_tmp381_ = _prereq_list;
			_tmp382_ = vala_list_get (_tmp381_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp382_;
			_tmp383_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp383_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp384_;
				ValaTypeSymbol* _tmp385_;
				gchar* _tmp386_;
				gchar* _tmp387_;
				_tmp384_ = missing_prereqs;
				_tmp385_ = prereq;
				_tmp386_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp385_);
				_tmp387_ = _tmp386_;
				vala_list_insert (_tmp384_, 0, _tmp387_);
				_g_free0 (_tmp387_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp388_ = missing_prereqs;
	_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
	_tmp390_ = _tmp389_;
	if (_tmp390_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp391_;
		gchar* _tmp392_;
		gchar* _tmp393_;
		gchar* _tmp394_;
		gboolean first = FALSE;
		const gchar* _tmp409_;
		gchar* _tmp410_;
		ValaSourceReference* _tmp411_;
		ValaSourceReference* _tmp412_;
		const gchar* _tmp413_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp391_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp392_ = _tmp391_;
		_tmp393_ = g_strdup_printf ("%s: some prerequisites (", _tmp392_);
		_tmp394_ = _tmp393_;
		_g_free0 (_tmp392_);
		error_string = _tmp394_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp395_;
			gint _s_size = 0;
			ValaList* _tmp396_;
			gint _tmp397_;
			gint _tmp398_;
			gint _s_index = 0;
			_tmp395_ = missing_prereqs;
			_s_list = _tmp395_;
			_tmp396_ = _s_list;
			_tmp397_ = vala_collection_get_size ((ValaCollection*) _tmp396_);
			_tmp398_ = _tmp397_;
			_s_size = _tmp398_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp399_;
				gint _tmp400_;
				gchar* s = NULL;
				ValaList* _tmp401_;
				gpointer _tmp402_;
				_s_index = _s_index + 1;
				_tmp399_ = _s_index;
				_tmp400_ = _s_size;
				if (!(_tmp399_ < _tmp400_)) {
					break;
				}
				_tmp401_ = _s_list;
				_tmp402_ = vala_list_get (_tmp401_, _s_index);
				s = (gchar*) _tmp402_;
				if (first) {
					const gchar* _tmp403_;
					const gchar* _tmp404_;
					gchar* _tmp405_;
					_tmp403_ = error_string;
					_tmp404_ = s;
					_tmp405_ = g_strdup_printf ("%s`%s'", _tmp403_, _tmp404_);
					_g_free0 (error_string);
					error_string = _tmp405_;
					first = FALSE;
				} else {
					const gchar* _tmp406_;
					const gchar* _tmp407_;
					gchar* _tmp408_;
					_tmp406_ = error_string;
					_tmp407_ = s;
					_tmp408_ = g_strdup_printf ("%s, `%s'", _tmp406_, _tmp407_);
					_g_free0 (error_string);
					error_string = _tmp408_;
				}
				_g_free0 (s);
			}
		}
		_tmp409_ = error_string;
		_tmp410_ = g_strconcat (_tmp409_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp410_;
		_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp412_ = _tmp411_;
		_tmp413_ = error_string;
		vala_report_error (_tmp412_, "%s", _tmp413_);
		_g_free0 (error_string);
	}
	_tmp414_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp415_ = _tmp414_;
	if (_tmp415_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp566_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp416_;
			gint _base_type_size = 0;
			ValaList* _tmp417_;
			gint _tmp418_;
			gint _tmp419_;
			gint _base_type_index = 0;
			_tmp416_ = vala_class_get_base_types (self);
			_base_type_list = _tmp416_;
			_tmp417_ = _base_type_list;
			_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
			_tmp419_ = _tmp418_;
			_base_type_size = _tmp419_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp420_;
				gint _tmp421_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp422_;
				gpointer _tmp423_;
				ValaDataType* _tmp424_;
				ValaTypeSymbol* _tmp425_;
				ValaTypeSymbol* _tmp426_;
				_base_type_index = _base_type_index + 1;
				_tmp420_ = _base_type_index;
				_tmp421_ = _base_type_size;
				if (!(_tmp420_ < _tmp421_)) {
					break;
				}
				_tmp422_ = _base_type_list;
				_tmp423_ = vala_list_get (_tmp422_, _base_type_index);
				base_type = (ValaDataType*) _tmp423_;
				_tmp424_ = base_type;
				_tmp425_ = vala_data_type_get_type_symbol (_tmp424_);
				_tmp426_ = _tmp425_;
				if (VALA_IS_INTERFACE (_tmp426_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp427_;
					ValaTypeSymbol* _tmp428_;
					ValaTypeSymbol* _tmp429_;
					gboolean _tmp430_ = FALSE;
					ValaClass* _tmp431_;
					_tmp427_ = base_type;
					_tmp428_ = vala_data_type_get_type_symbol (_tmp427_);
					_tmp429_ = _tmp428_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp429_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp431_ = self->priv->_base_class;
					if (_tmp431_ != NULL) {
						ValaClass* _tmp432_;
						ValaInterface* _tmp433_;
						_tmp432_ = self->priv->_base_class;
						_tmp433_ = iface;
						_tmp430_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp432_, (ValaTypeSymbol*) _tmp433_);
					} else {
						_tmp430_ = FALSE;
					}
					if (_tmp430_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp434_;
						ValaList* _tmp435_;
						gint _m_size = 0;
						ValaList* _tmp436_;
						gint _tmp437_;
						gint _tmp438_;
						gint _m_index = 0;
						_tmp434_ = iface;
						_tmp435_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp434_);
						_m_list = _tmp435_;
						_tmp436_ = _m_list;
						_tmp437_ = vala_collection_get_size ((ValaCollection*) _tmp436_);
						_tmp438_ = _tmp437_;
						_m_size = _tmp438_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp439_;
							gint _tmp440_;
							ValaMethod* m = NULL;
							ValaList* _tmp441_;
							gpointer _tmp442_;
							ValaMethod* _tmp443_;
							gboolean _tmp444_;
							gboolean _tmp445_;
							_m_index = _m_index + 1;
							_tmp439_ = _m_index;
							_tmp440_ = _m_size;
							if (!(_tmp439_ < _tmp440_)) {
								break;
							}
							_tmp441_ = _m_list;
							_tmp442_ = vala_list_get (_tmp441_, _m_index);
							m = (ValaMethod*) _tmp442_;
							_tmp443_ = m;
							_tmp444_ = vala_method_get_is_abstract (_tmp443_);
							_tmp445_ = _tmp444_;
							if (_tmp445_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp446_ = FALSE;
									ValaClass* _tmp447_;
									ValaClass* _tmp500_;
									ValaClass* _tmp501_;
									_tmp447_ = base_class;
									if (_tmp447_ != NULL) {
										_tmp446_ = !implemented;
									} else {
										_tmp446_ = FALSE;
									}
									if (!_tmp446_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp448_;
										ValaList* _tmp449_;
										gint _impl_size = 0;
										ValaList* _tmp450_;
										gint _tmp451_;
										gint _tmp452_;
										gint _impl_index = 0;
										_tmp448_ = base_class;
										_tmp449_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp448_);
										_impl_list = _tmp449_;
										_tmp450_ = _impl_list;
										_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
										_tmp452_ = _tmp451_;
										_impl_size = _tmp452_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp453_;
											gint _tmp454_;
											ValaMethod* impl = NULL;
											ValaList* _tmp455_;
											gpointer _tmp456_;
											gboolean _tmp457_ = FALSE;
											ValaMethod* _tmp458_;
											ValaMethod* _tmp459_;
											ValaMethod* _tmp460_;
											ValaMethod* _tmp461_;
											_impl_index = _impl_index + 1;
											_tmp453_ = _impl_index;
											_tmp454_ = _impl_size;
											if (!(_tmp453_ < _tmp454_)) {
												break;
											}
											_tmp455_ = _impl_list;
											_tmp456_ = vala_list_get (_tmp455_, _impl_index);
											impl = (ValaMethod*) _tmp456_;
											_tmp458_ = impl;
											_tmp459_ = vala_method_get_base_interface_method (_tmp458_);
											_tmp460_ = _tmp459_;
											_tmp461_ = m;
											if (_tmp460_ == _tmp461_) {
												_tmp457_ = TRUE;
											} else {
												gboolean _tmp462_ = FALSE;
												gboolean _tmp463_ = FALSE;
												gboolean _tmp464_ = FALSE;
												gboolean _tmp465_ = FALSE;
												ValaClass* _tmp466_;
												_tmp466_ = base_class;
												if (_tmp466_ != self) {
													ValaMethod* _tmp467_;
													ValaMethod* _tmp468_;
													ValaMethod* _tmp469_;
													_tmp467_ = impl;
													_tmp468_ = vala_method_get_base_interface_method (_tmp467_);
													_tmp469_ = _tmp468_;
													_tmp465_ = _tmp469_ == NULL;
												} else {
													_tmp465_ = FALSE;
												}
												if (_tmp465_) {
													ValaMethod* _tmp470_;
													const gchar* _tmp471_;
													const gchar* _tmp472_;
													ValaMethod* _tmp473_;
													const gchar* _tmp474_;
													const gchar* _tmp475_;
													_tmp470_ = impl;
													_tmp471_ = vala_symbol_get_name ((ValaSymbol*) _tmp470_);
													_tmp472_ = _tmp471_;
													_tmp473_ = m;
													_tmp474_ = vala_symbol_get_name ((ValaSymbol*) _tmp473_);
													_tmp475_ = _tmp474_;
													_tmp464_ = g_strcmp0 (_tmp472_, _tmp475_) == 0;
												} else {
													_tmp464_ = FALSE;
												}
												if (_tmp464_) {
													gboolean _tmp476_ = FALSE;
													ValaMethod* _tmp477_;
													ValaDataType* _tmp478_;
													ValaDataType* _tmp479_;
													_tmp477_ = impl;
													_tmp478_ = vala_method_get_base_interface_type (_tmp477_);
													_tmp479_ = _tmp478_;
													if (_tmp479_ == NULL) {
														_tmp476_ = TRUE;
													} else {
														ValaMethod* _tmp480_;
														ValaDataType* _tmp481_;
														ValaDataType* _tmp482_;
														ValaTypeSymbol* _tmp483_;
														ValaTypeSymbol* _tmp484_;
														ValaInterface* _tmp485_;
														_tmp480_ = impl;
														_tmp481_ = vala_method_get_base_interface_type (_tmp480_);
														_tmp482_ = _tmp481_;
														_tmp483_ = vala_data_type_get_type_symbol (_tmp482_);
														_tmp484_ = _tmp483_;
														_tmp485_ = iface;
														_tmp476_ = _tmp484_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp485_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp463_ = _tmp476_;
												} else {
													_tmp463_ = FALSE;
												}
												if (_tmp463_) {
													ValaMethod* _tmp486_;
													ValaMethod* _tmp487_;
													_tmp486_ = impl;
													_tmp487_ = m;
													_tmp462_ = vala_method_compatible_no_error (_tmp486_, _tmp487_);
												} else {
													_tmp462_ = FALSE;
												}
												_tmp457_ = _tmp462_;
											}
											if (_tmp457_) {
												ValaMethod* _tmp488_;
												ValaVersionAttribute* _tmp489_;
												ValaVersionAttribute* _tmp490_;
												ValaSourceReference* _tmp491_;
												ValaSourceReference* _tmp492_;
												ValaMethod* _tmp493_;
												ValaMethod* _tmp494_;
												ValaMethod* _tmp495_;
												ValaMethod* _tmp496_;
												_tmp488_ = impl;
												_tmp489_ = vala_symbol_get_version ((ValaSymbol*) _tmp488_);
												_tmp490_ = _tmp489_;
												_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp492_ = _tmp491_;
												vala_version_attribute_check (_tmp490_, context, _tmp492_);
												_tmp493_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp493_, TRUE);
												implemented = TRUE;
												_tmp494_ = impl;
												_tmp495_ = vala_method_get_base_interface_method (_tmp494_);
												_tmp496_ = _tmp495_;
												if (_tmp496_ == NULL) {
													ValaHashMap* _tmp497_;
													ValaMethod* _tmp498_;
													ValaMethod* _tmp499_;
													_tmp497_ = self->priv->implicit_implementations;
													_tmp498_ = m;
													_tmp499_ = impl;
													vala_map_set ((ValaMap*) _tmp497_, _tmp498_, _tmp499_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp500_ = base_class;
									_tmp501_ = _tmp500_->priv->_base_class;
									base_class = _tmp501_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp502_;
									ValaSourceReference* _tmp503_;
									gchar* _tmp504_;
									gchar* _tmp505_;
									ValaMethod* _tmp506_;
									gchar* _tmp507_;
									gchar* _tmp508_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp502_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp503_ = _tmp502_;
									_tmp504_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp505_ = _tmp504_;
									_tmp506_ = m;
									_tmp507_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp506_);
									_tmp508_ = _tmp507_;
									vala_report_error (_tmp503_, "`%s' does not implement interface method `%s'", _tmp505_, _tmp508_);
									_g_free0 (_tmp508_);
									_g_free0 (_tmp505_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp509_;
						ValaList* _tmp510_;
						gint _prop_size = 0;
						ValaList* _tmp511_;
						gint _tmp512_;
						gint _tmp513_;
						gint _prop_index = 0;
						_tmp509_ = iface;
						_tmp510_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp509_);
						_prop_list = _tmp510_;
						_tmp511_ = _prop_list;
						_tmp512_ = vala_collection_get_size ((ValaCollection*) _tmp511_);
						_tmp513_ = _tmp512_;
						_prop_size = _tmp513_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp514_;
							gint _tmp515_;
							ValaProperty* prop = NULL;
							ValaList* _tmp516_;
							gpointer _tmp517_;
							ValaProperty* _tmp518_;
							gboolean _tmp519_;
							gboolean _tmp520_;
							_prop_index = _prop_index + 1;
							_tmp514_ = _prop_index;
							_tmp515_ = _prop_size;
							if (!(_tmp514_ < _tmp515_)) {
								break;
							}
							_tmp516_ = _prop_list;
							_tmp517_ = vala_list_get (_tmp516_, _prop_index);
							prop = (ValaProperty*) _tmp517_;
							_tmp518_ = prop;
							_tmp519_ = vala_property_get_is_abstract (_tmp518_);
							_tmp520_ = _tmp519_;
							if (_tmp520_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp533_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp521_ = FALSE;
									ValaClass* _tmp522_;
									ValaClass* _tmp524_;
									ValaScope* _tmp525_;
									ValaScope* _tmp526_;
									ValaProperty* _tmp527_;
									const gchar* _tmp528_;
									const gchar* _tmp529_;
									ValaSymbol* _tmp530_;
									ValaClass* _tmp531_;
									ValaClass* _tmp532_;
									_tmp522_ = base_class;
									if (_tmp522_ != NULL) {
										ValaSymbol* _tmp523_;
										_tmp523_ = sym;
										_tmp521_ = !VALA_IS_PROPERTY (_tmp523_);
									} else {
										_tmp521_ = FALSE;
									}
									if (!_tmp521_) {
										break;
									}
									_tmp524_ = base_class;
									_tmp525_ = vala_symbol_get_scope ((ValaSymbol*) _tmp524_);
									_tmp526_ = _tmp525_;
									_tmp527_ = prop;
									_tmp528_ = vala_symbol_get_name ((ValaSymbol*) _tmp527_);
									_tmp529_ = _tmp528_;
									_tmp530_ = vala_scope_lookup (_tmp526_, _tmp529_);
									_vala_code_node_unref0 (sym);
									sym = _tmp530_;
									_tmp531_ = base_class;
									_tmp532_ = _tmp531_->priv->_base_class;
									base_class = _tmp532_;
								}
								_tmp533_ = sym;
								if (VALA_IS_PROPERTY (_tmp533_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp534_;
									ValaProperty* _tmp535_;
									gchar* invalid_match = NULL;
									gboolean _tmp536_ = FALSE;
									ValaProperty* _tmp537_;
									gboolean _tmp538_;
									gboolean _tmp539_;
									ValaSymbol* _tmp553_;
									ValaVersionAttribute* _tmp554_;
									ValaVersionAttribute* _tmp555_;
									ValaSourceReference* _tmp556_;
									ValaSourceReference* _tmp557_;
									ValaSymbol* _tmp558_;
									_tmp534_ = sym;
									_tmp535_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp534_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp535_;
									invalid_match = NULL;
									_tmp537_ = base_prop;
									_tmp538_ = vala_symbol_get_hides ((ValaSymbol*) _tmp537_);
									_tmp539_ = _tmp538_;
									if (!_tmp539_) {
										ValaProperty* _tmp540_;
										ValaProperty* _tmp541_;
										gchar* _tmp542_ = NULL;
										gboolean _tmp543_;
										_tmp540_ = base_prop;
										_tmp541_ = prop;
										_tmp543_ = vala_property_compatible (_tmp540_, _tmp541_, &_tmp542_);
										_g_free0 (invalid_match);
										invalid_match = _tmp542_;
										_tmp536_ = !_tmp543_;
									} else {
										_tmp536_ = FALSE;
									}
									if (_tmp536_) {
										ValaSourceReference* _tmp544_;
										ValaSourceReference* _tmp545_;
										ValaProperty* _tmp546_;
										gchar* _tmp547_;
										gchar* _tmp548_;
										ValaProperty* _tmp549_;
										gchar* _tmp550_;
										gchar* _tmp551_;
										const gchar* _tmp552_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp545_ = _tmp544_;
										_tmp546_ = prop;
										_tmp547_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp546_);
										_tmp548_ = _tmp547_;
										_tmp549_ = base_prop;
										_tmp550_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp549_);
										_tmp551_ = _tmp550_;
										_tmp552_ = invalid_match;
										vala_report_error (_tmp545_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp548_, _tmp551_, _tmp552_);
										_g_free0 (_tmp551_);
										_g_free0 (_tmp548_);
									}
									_tmp553_ = sym;
									_tmp554_ = vala_symbol_get_version (_tmp553_);
									_tmp555_ = _tmp554_;
									_tmp556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp557_ = _tmp556_;
									vala_version_attribute_check (_tmp555_, context, _tmp557_);
									_tmp558_ = sym;
									vala_symbol_set_used (_tmp558_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp559_;
									ValaSourceReference* _tmp560_;
									gchar* _tmp561_;
									gchar* _tmp562_;
									ValaProperty* _tmp563_;
									gchar* _tmp564_;
									gchar* _tmp565_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp559_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp560_ = _tmp559_;
									_tmp561_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp562_ = _tmp561_;
									_tmp563_ = prop;
									_tmp564_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp563_);
									_tmp565_ = _tmp564_;
									vala_report_error (_tmp560_, "`%s' does not implement interface property `%s'", _tmp562_, _tmp565_);
									_g_free0 (_tmp565_);
									_g_free0 (_tmp562_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp566_ = self->priv->_is_abstract;
		if (!_tmp566_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp567_;
			_tmp567_ = self->priv->_base_class;
			base_class = _tmp567_;
			while (TRUE) {
				gboolean _tmp568_ = FALSE;
				ValaClass* _tmp569_;
				ValaClass* _tmp630_;
				ValaClass* _tmp631_;
				_tmp569_ = base_class;
				if (_tmp569_ != NULL) {
					ValaClass* _tmp570_;
					gboolean _tmp571_;
					_tmp570_ = base_class;
					_tmp571_ = _tmp570_->priv->_is_abstract;
					_tmp568_ = _tmp571_;
				} else {
					_tmp568_ = FALSE;
				}
				if (!_tmp568_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp572_;
					ValaList* _tmp573_;
					gint _base_method_size = 0;
					ValaList* _tmp574_;
					gint _tmp575_;
					gint _tmp576_;
					gint _base_method_index = 0;
					_tmp572_ = base_class;
					_tmp573_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp572_);
					_base_method_list = _tmp573_;
					_tmp574_ = _base_method_list;
					_tmp575_ = vala_collection_get_size ((ValaCollection*) _tmp574_);
					_tmp576_ = _tmp575_;
					_base_method_size = _tmp576_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp577_;
						gint _tmp578_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp579_;
						gpointer _tmp580_;
						ValaMethod* _tmp581_;
						gboolean _tmp582_;
						gboolean _tmp583_;
						_base_method_index = _base_method_index + 1;
						_tmp577_ = _base_method_index;
						_tmp578_ = _base_method_size;
						if (!(_tmp577_ < _tmp578_)) {
							break;
						}
						_tmp579_ = _base_method_list;
						_tmp580_ = vala_list_get (_tmp579_, _base_method_index);
						base_method = (ValaMethod*) _tmp580_;
						_tmp581_ = base_method;
						_tmp582_ = vala_method_get_is_abstract (_tmp581_);
						_tmp583_ = _tmp582_;
						if (_tmp583_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp584_;
							const gchar* _tmp585_;
							const gchar* _tmp586_;
							ValaSymbol* _tmp587_;
							ValaMethod* _tmp588_;
							gboolean _tmp589_ = FALSE;
							ValaMethod* _tmp590_;
							_tmp584_ = base_method;
							_tmp585_ = vala_symbol_get_name ((ValaSymbol*) _tmp584_);
							_tmp586_ = _tmp585_;
							_tmp587_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp586_);
							_tmp588_ = VALA_IS_METHOD (_tmp587_) ? ((ValaMethod*) _tmp587_) : NULL;
							if (_tmp588_ == NULL) {
								_vala_code_node_unref0 (_tmp587_);
							}
							override_method = _tmp588_;
							_tmp590_ = override_method;
							if (_tmp590_ == NULL) {
								_tmp589_ = TRUE;
							} else {
								ValaMethod* _tmp591_;
								gboolean _tmp592_;
								gboolean _tmp593_;
								_tmp591_ = override_method;
								_tmp592_ = vala_method_get_overrides (_tmp591_);
								_tmp593_ = _tmp592_;
								_tmp589_ = !_tmp593_;
							}
							if (_tmp589_) {
								ValaSourceReference* _tmp594_;
								ValaSourceReference* _tmp595_;
								gchar* _tmp596_;
								gchar* _tmp597_;
								ValaMethod* _tmp598_;
								gchar* _tmp599_;
								gchar* _tmp600_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp595_ = _tmp594_;
								_tmp596_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp597_ = _tmp596_;
								_tmp598_ = base_method;
								_tmp599_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp598_);
								_tmp600_ = _tmp599_;
								vala_report_error (_tmp595_, "`%s' does not implement abstract method `%s'", _tmp597_, _tmp600_);
								_g_free0 (_tmp600_);
								_g_free0 (_tmp597_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp601_;
					ValaList* _tmp602_;
					gint _base_property_size = 0;
					ValaList* _tmp603_;
					gint _tmp604_;
					gint _tmp605_;
					gint _base_property_index = 0;
					_tmp601_ = base_class;
					_tmp602_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp601_);
					_base_property_list = _tmp602_;
					_tmp603_ = _base_property_list;
					_tmp604_ = vala_collection_get_size ((ValaCollection*) _tmp603_);
					_tmp605_ = _tmp604_;
					_base_property_size = _tmp605_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp606_;
						gint _tmp607_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp608_;
						gpointer _tmp609_;
						ValaProperty* _tmp610_;
						gboolean _tmp611_;
						gboolean _tmp612_;
						_base_property_index = _base_property_index + 1;
						_tmp606_ = _base_property_index;
						_tmp607_ = _base_property_size;
						if (!(_tmp606_ < _tmp607_)) {
							break;
						}
						_tmp608_ = _base_property_list;
						_tmp609_ = vala_list_get (_tmp608_, _base_property_index);
						base_property = (ValaProperty*) _tmp609_;
						_tmp610_ = base_property;
						_tmp611_ = vala_property_get_is_abstract (_tmp610_);
						_tmp612_ = _tmp611_;
						if (_tmp612_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp613_;
							const gchar* _tmp614_;
							const gchar* _tmp615_;
							ValaSymbol* _tmp616_;
							ValaProperty* _tmp617_;
							gboolean _tmp618_ = FALSE;
							ValaProperty* _tmp619_;
							_tmp613_ = base_property;
							_tmp614_ = vala_symbol_get_name ((ValaSymbol*) _tmp613_);
							_tmp615_ = _tmp614_;
							_tmp616_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp615_);
							_tmp617_ = VALA_IS_PROPERTY (_tmp616_) ? ((ValaProperty*) _tmp616_) : NULL;
							if (_tmp617_ == NULL) {
								_vala_code_node_unref0 (_tmp616_);
							}
							override_property = _tmp617_;
							_tmp619_ = override_property;
							if (_tmp619_ == NULL) {
								_tmp618_ = TRUE;
							} else {
								ValaProperty* _tmp620_;
								gboolean _tmp621_;
								gboolean _tmp622_;
								_tmp620_ = override_property;
								_tmp621_ = vala_property_get_overrides (_tmp620_);
								_tmp622_ = _tmp621_;
								_tmp618_ = !_tmp622_;
							}
							if (_tmp618_) {
								ValaSourceReference* _tmp623_;
								ValaSourceReference* _tmp624_;
								gchar* _tmp625_;
								gchar* _tmp626_;
								ValaProperty* _tmp627_;
								gchar* _tmp628_;
								gchar* _tmp629_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp623_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp624_ = _tmp623_;
								_tmp625_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp626_ = _tmp625_;
								_tmp627_ = base_property;
								_tmp628_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp627_);
								_tmp629_ = _tmp628_;
								vala_report_error (_tmp624_, "`%s' does not implement abstract property `%s'", _tmp626_, _tmp629_);
								_g_free0 (_tmp629_);
								_g_free0 (_tmp626_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp630_ = base_class;
				_tmp631_ = _tmp630_->priv->_base_class;
				base_class = _tmp631_;
			}
		}
	}
	_tmp632_ = vala_code_context_get_analyzer (context);
	_tmp633_ = _tmp632_;
	_tmp634_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp633_, _tmp634_);
	_tmp635_ = vala_code_context_get_analyzer (context);
	_tmp636_ = _tmp635_;
	_tmp637_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp636_, _tmp637_);
	_tmp638_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp639_ = _tmp638_;
	result = !_tmp639_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}

