/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                          ValaBinaryOperator value);
static void vala_binary_expression_set_left (ValaBinaryExpression* self,
                                      ValaExpression* value);
static void vala_binary_expression_set_right (ValaBinaryExpression* self,
                                       ValaExpression* value);
static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);
static GType vala_binary_expression_get_type_once (void);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp367_ = FALSE;
	gboolean _tmp368_ = FALSE;
	ValaDataType* _tmp369_;
	ValaDataType* _tmp370_;
	ValaExpression* _tmp390_;
	ValaExpression* _tmp391_;
	gboolean _tmp392_ = FALSE;
	gboolean _tmp393_ = FALSE;
	ValaExpression* _tmp394_;
	ValaExpression* _tmp395_;
	ValaDataType* _tmp396_;
	ValaDataType* _tmp397_;
	ValaExpression* _tmp415_;
	ValaExpression* _tmp416_;
	gboolean _tmp417_ = FALSE;
	gboolean _tmp418_ = FALSE;
	ValaExpression* _tmp419_;
	ValaExpression* _tmp420_;
	ValaDataType* _tmp421_;
	ValaDataType* _tmp422_;
	gboolean _tmp440_ = FALSE;
	ValaExpression* _tmp441_;
	ValaExpression* _tmp442_;
	ValaExpression* _tmp445_;
	ValaExpression* _tmp446_;
	ValaDataType* _tmp447_;
	ValaDataType* _tmp448_;
	gboolean _tmp453_ = FALSE;
	ValaBinaryOperator _tmp454_;
	gboolean _tmp463_ = FALSE;
	ValaExpression* _tmp464_;
	ValaExpression* _tmp465_;
	ValaDataType* _tmp466_;
	ValaDataType* _tmp467_;
	gboolean _tmp482_ = FALSE;
	ValaExpression* _tmp483_;
	ValaExpression* _tmp484_;
	ValaDataType* _tmp485_;
	ValaDataType* _tmp486_;
	ValaExpression* _tmp501_;
	ValaExpression* _tmp502_;
	ValaExpression* _tmp503_;
	ValaExpression* _tmp504_;
	ValaDataType* _tmp505_;
	ValaDataType* _tmp506_;
	ValaDataType* _tmp507_;
	ValaDataType* _tmp508_;
	ValaExpression* _tmp509_;
	ValaExpression* _tmp510_;
	ValaDataType* _tmp511_;
	ValaDataType* _tmp512_;
	ValaExpression* _tmp513_;
	ValaExpression* _tmp514_;
	ValaExpression* _tmp515_;
	ValaExpression* _tmp516_;
	ValaDataType* _tmp517_;
	ValaDataType* _tmp518_;
	ValaDataType* _tmp519_;
	ValaDataType* _tmp520_;
	ValaExpression* _tmp521_;
	ValaExpression* _tmp522_;
	ValaDataType* _tmp523_;
	ValaDataType* _tmp524_;
	gboolean _tmp525_ = FALSE;
	gboolean _tmp526_ = FALSE;
	ValaBinaryOperator _tmp527_;
	ValaBinaryOperator _tmp616_;
	ValaDataType* _tmp1143_;
	ValaDataType* _tmp1144_;
	gboolean _tmp1145_;
	gboolean _tmp1146_;
	gboolean result = FALSE;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (VALA_IS_BLOCK (_tmp8_)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaExpression* _tmp141_;
		ValaExpression* _tmp142_;
		gchar* temp_name = NULL;
		gchar* _tmp143_;
		ValaLocalVariable* right_local = NULL;
		const gchar* _tmp144_;
		ValaExpression* _tmp145_;
		ValaExpression* _tmp146_;
		ValaExpression* _tmp147_;
		ValaExpression* _tmp148_;
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaLocalVariable* _tmp151_;
		ValaDeclarationStatement* right_decl = NULL;
		ValaLocalVariable* _tmp152_;
		ValaExpression* _tmp153_;
		ValaExpression* _tmp154_;
		ValaSourceReference* _tmp155_;
		ValaSourceReference* _tmp156_;
		ValaDeclarationStatement* _tmp157_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp158_;
		ValaSourceReference* _tmp159_;
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		ValaDeclarationStatement* _tmp162_;
		ValaBlock* _tmp163_;
		ValaLocalVariable* _tmp164_;
		ValaExpression* _tmp165_;
		ValaExpression* _tmp166_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp167_ = FALSE;
		ValaExpression* _tmp168_;
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		gboolean _tmp254_ = FALSE;
		gboolean _tmp255_ = FALSE;
		ValaDataType* _tmp256_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp268_;
		const gchar* _tmp269_;
		ValaExpression* _tmp270_;
		ValaExpression* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaLocalVariable* _tmp274_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp275_;
		ValaSourceReference* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaDeclarationStatement* _tmp278_;
		ValaSemanticAnalyzer* _tmp279_;
		ValaSemanticAnalyzer* _tmp280_;
		ValaBlock* _tmp281_;
		ValaDeclarationStatement* _tmp282_;
		ValaDeclarationStatement* _tmp283_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp284_;
		const gchar* _tmp285_;
		const gchar* _tmp286_;
		ValaExpression* _tmp287_;
		ValaExpression* _tmp288_;
		ValaSourceReference* _tmp289_;
		ValaSourceReference* _tmp290_;
		ValaMemberAccess* _tmp291_;
		ValaMemberAccess* _tmp292_;
		ValaExpression* _tmp293_;
		ValaExpression* _tmp294_;
		ValaExpression* _tmp295_;
		ValaExpression* _tmp296_;
		ValaSourceReference* _tmp297_;
		ValaSourceReference* _tmp298_;
		ValaAssignment* _tmp299_;
		ValaAssignment* _tmp300_;
		ValaExpression* _tmp301_;
		ValaExpression* _tmp302_;
		ValaSourceReference* _tmp303_;
		ValaSourceReference* _tmp304_;
		ValaExpressionStatement* _tmp305_;
		ValaExpressionStatement* _tmp306_;
		ValaBlock* _tmp307_;
		ValaLocalVariable* _tmp308_;
		ValaBlock* _tmp309_;
		ValaDeclarationStatement* _tmp310_;
		ValaExpressionStatement* _tmp311_;
		ValaExpressionStatement* _tmp312_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp313_;
		const gchar* _tmp314_;
		const gchar* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		ValaMemberAccess* _tmp320_;
		ValaMemberAccess* _tmp321_;
		ValaSourceReference* _tmp322_;
		ValaSourceReference* _tmp323_;
		ValaNullLiteral* _tmp324_;
		ValaNullLiteral* _tmp325_;
		ValaSourceReference* _tmp326_;
		ValaSourceReference* _tmp327_;
		ValaBinaryExpression* _tmp328_;
		ValaBinaryExpression* _tmp329_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp330_;
		ValaBlock* _tmp331_;
		ValaSourceReference* _tmp332_;
		ValaSourceReference* _tmp333_;
		ValaIfStatement* _tmp334_;
		ValaSemanticAnalyzer* _tmp335_;
		ValaSemanticAnalyzer* _tmp336_;
		ValaBlock* _tmp337_;
		ValaIfStatement* _tmp338_;
		ValaIfStatement* _tmp339_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp340_;
		ValaDataType* _tmp341_;
		ValaDataType* _tmp342_;
		ValaExpression* _tmp343_;
		gboolean _tmp344_ = FALSE;
		ValaCodeNode* _tmp363_;
		ValaCodeNode* _tmp364_;
		ValaExpression* _tmp365_;
		ValaExpression* _tmp366_;
		_tmp127_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp128_ = _tmp127_;
		if (_tmp128_ != NULL) {
			ValaExpression* _tmp129_;
			ValaExpression* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			ValaDataType* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			ValaDataType* _tmp140_;
			_tmp129_ = vala_binary_expression_get_left (self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_data_type_copy (_tmp132_);
			_tmp134_ = _tmp133_;
			vala_expression_set_target_type (_tmp130_, _tmp134_);
			_vala_code_node_unref0 (_tmp134_);
			_tmp135_ = vala_binary_expression_get_right (self);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_data_type_copy (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_target_type (_tmp136_, _tmp140_);
			_vala_code_node_unref0 (_tmp140_);
		}
		_tmp141_ = vala_binary_expression_get_left (self);
		_tmp142_ = _tmp141_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp142_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp143_ = vala_code_node_get_temp_name ();
		temp_name = _tmp143_;
		_tmp144_ = temp_name;
		_tmp145_ = vala_binary_expression_get_right (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_binary_expression_get_right (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_local_variable_new (NULL, _tmp144_, _tmp146_, _tmp150_);
		right_local = _tmp151_;
		_tmp152_ = right_local;
		_tmp153_ = vala_binary_expression_get_right (self);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = vala_declaration_statement_new ((ValaSymbol*) _tmp152_, _tmp156_);
		right_decl = _tmp157_;
		_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = vala_block_new (_tmp159_);
		true_block = _tmp160_;
		_tmp161_ = true_block;
		_tmp162_ = right_decl;
		vala_block_add_statement (_tmp161_, (ValaStatement*) _tmp162_);
		_tmp163_ = true_block;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp163_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp164_ = right_local;
		_tmp165_ = vala_variable_get_initializer ((ValaVariable*) _tmp164_);
		_tmp166_ = _tmp165_;
		vala_binary_expression_set_right (self, _tmp166_);
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp168_ = vala_binary_expression_get_left (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_expression_get_value_type (_tmp169_);
		_tmp171_ = _tmp170_;
		if (VALA_IS_NULL_TYPE (_tmp171_)) {
			ValaExpression* _tmp172_;
			ValaExpression* _tmp173_;
			ValaDataType* _tmp174_;
			ValaDataType* _tmp175_;
			_tmp172_ = vala_binary_expression_get_right (self);
			_tmp173_ = _tmp172_;
			_tmp174_ = vala_expression_get_value_type (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp167_ = _tmp175_ != NULL;
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaDataType* _tmp182_;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			ValaExpression* _tmp186_;
			ValaExpression* _tmp187_;
			ValaDataType* _tmp188_;
			ValaDataType* _tmp189_;
			gboolean _tmp190_;
			gboolean _tmp191_;
			_tmp176_ = vala_binary_expression_get_left (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp177_);
			_tmp179_ = _tmp178_;
			vala_report_warning (_tmp179_, "left operand is always null");
			_tmp180_ = vala_binary_expression_get_right (self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_value_type (_tmp181_);
			_tmp183_ = _tmp182_;
			_tmp184_ = vala_data_type_copy (_tmp183_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp184_;
			_tmp185_ = local_type;
			vala_data_type_set_nullable (_tmp185_, TRUE);
			_tmp186_ = vala_binary_expression_get_right (self);
			_tmp187_ = _tmp186_;
			_tmp188_ = vala_expression_get_value_type (_tmp187_);
			_tmp189_ = _tmp188_;
			_tmp190_ = vala_data_type_get_nullable (_tmp189_);
			_tmp191_ = _tmp190_;
			if (!_tmp191_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp192_;
			ValaExpression* _tmp193_;
			ValaDataType* _tmp194_;
			ValaDataType* _tmp195_;
			_tmp192_ = vala_binary_expression_get_left (self);
			_tmp193_ = _tmp192_;
			_tmp194_ = vala_expression_get_value_type (_tmp193_);
			_tmp195_ = _tmp194_;
			if (_tmp195_ != NULL) {
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				gboolean _tmp201_ = FALSE;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp196_ = vala_binary_expression_get_left (self);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_expression_get_value_type (_tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_data_type_copy (_tmp199_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp200_;
				_tmp202_ = vala_binary_expression_get_right (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp205_ != NULL) {
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					gboolean _tmp210_;
					gboolean _tmp211_;
					_tmp206_ = vala_binary_expression_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_expression_get_value_type (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_value_owned (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp201_ = _tmp211_;
				} else {
					_tmp201_ = FALSE;
				}
				if (_tmp201_) {
					ValaDataType* _tmp212_;
					_tmp212_ = local_type;
					vala_data_type_set_value_owned (_tmp212_, TRUE);
				}
				_tmp213_ = vala_code_context_get_experimental_non_null (context);
				_tmp214_ = _tmp213_;
				if (_tmp214_) {
					ValaDataType* _tmp215_;
					gboolean _tmp216_;
					gboolean _tmp217_;
					_tmp215_ = local_type;
					_tmp216_ = vala_data_type_get_nullable (_tmp215_);
					_tmp217_ = _tmp216_;
					if (!_tmp217_) {
						ValaExpression* _tmp218_;
						ValaExpression* _tmp219_;
						ValaSourceReference* _tmp220_;
						ValaSourceReference* _tmp221_;
						gboolean _tmp222_ = FALSE;
						ValaExpression* _tmp223_;
						ValaExpression* _tmp224_;
						ValaDataType* _tmp225_;
						ValaDataType* _tmp226_;
						_tmp218_ = vala_binary_expression_get_left (self);
						_tmp219_ = _tmp218_;
						_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp219_);
						_tmp221_ = _tmp220_;
						vala_report_warning (_tmp221_, "left operand is never null");
						_tmp223_ = vala_binary_expression_get_right (self);
						_tmp224_ = _tmp223_;
						_tmp225_ = vala_expression_get_value_type (_tmp224_);
						_tmp226_ = _tmp225_;
						if (_tmp226_ != NULL) {
							ValaExpression* _tmp227_;
							ValaExpression* _tmp228_;
							ValaDataType* _tmp229_;
							ValaDataType* _tmp230_;
							gboolean _tmp231_;
							gboolean _tmp232_;
							_tmp227_ = vala_binary_expression_get_right (self);
							_tmp228_ = _tmp227_;
							_tmp229_ = vala_expression_get_value_type (_tmp228_);
							_tmp230_ = _tmp229_;
							_tmp231_ = vala_data_type_get_nullable (_tmp230_);
							_tmp232_ = _tmp231_;
							_tmp222_ = _tmp232_;
						} else {
							_tmp222_ = FALSE;
						}
						if (_tmp222_) {
							ValaDataType* _tmp233_;
							_tmp233_ = local_type;
							vala_data_type_set_nullable (_tmp233_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp234_ = FALSE;
						ValaExpression* _tmp235_;
						ValaExpression* _tmp236_;
						ValaDataType* _tmp237_;
						ValaDataType* _tmp238_;
						_tmp235_ = vala_binary_expression_get_right (self);
						_tmp236_ = _tmp235_;
						_tmp237_ = vala_expression_get_value_type (_tmp236_);
						_tmp238_ = _tmp237_;
						if (_tmp238_ != NULL) {
							ValaExpression* _tmp239_;
							ValaExpression* _tmp240_;
							ValaDataType* _tmp241_;
							ValaDataType* _tmp242_;
							gboolean _tmp243_;
							gboolean _tmp244_;
							_tmp239_ = vala_binary_expression_get_right (self);
							_tmp240_ = _tmp239_;
							_tmp241_ = vala_expression_get_value_type (_tmp240_);
							_tmp242_ = _tmp241_;
							_tmp243_ = vala_data_type_get_nullable (_tmp242_);
							_tmp244_ = _tmp243_;
							_tmp234_ = !_tmp244_;
						} else {
							_tmp234_ = FALSE;
						}
						if (_tmp234_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp245_;
				ValaExpression* _tmp246_;
				ValaDataType* _tmp247_;
				ValaDataType* _tmp248_;
				_tmp245_ = vala_binary_expression_get_right (self);
				_tmp246_ = _tmp245_;
				_tmp247_ = vala_expression_get_value_type (_tmp246_);
				_tmp248_ = _tmp247_;
				if (_tmp248_ != NULL) {
					ValaExpression* _tmp249_;
					ValaExpression* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					ValaDataType* _tmp253_;
					_tmp249_ = vala_binary_expression_get_right (self);
					_tmp250_ = _tmp249_;
					_tmp251_ = vala_expression_get_value_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_data_type_copy (_tmp252_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp253_;
				}
			}
		}
		_tmp256_ = local_type;
		if (_tmp256_ != NULL) {
			ValaExpression* _tmp257_;
			ValaExpression* _tmp258_;
			ValaDataType* _tmp259_;
			ValaDataType* _tmp260_;
			_tmp257_ = vala_binary_expression_get_right (self);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_expression_get_value_type (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp255_ = VALA_IS_VALUE_TYPE (_tmp260_);
		} else {
			_tmp255_ = FALSE;
		}
		if (_tmp255_) {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaDataType* _tmp263_;
			ValaDataType* _tmp264_;
			gboolean _tmp265_;
			gboolean _tmp266_;
			_tmp261_ = vala_binary_expression_get_right (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_value_type (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_data_type_get_nullable (_tmp264_);
			_tmp266_ = _tmp265_;
			_tmp254_ = !_tmp266_;
		} else {
			_tmp254_ = FALSE;
		}
		if (_tmp254_) {
			ValaDataType* _tmp267_;
			_tmp267_ = local_type;
			vala_data_type_set_value_owned (_tmp267_, TRUE);
		}
		_tmp268_ = local_type;
		_tmp269_ = temp_name;
		_tmp270_ = vala_binary_expression_get_left (self);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_local_variable_new (_tmp268_, _tmp269_, _tmp271_, _tmp273_);
		local = _tmp274_;
		_tmp275_ = local;
		_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_declaration_statement_new ((ValaSymbol*) _tmp275_, _tmp277_);
		decl = _tmp278_;
		_tmp279_ = vala_code_context_get_analyzer (context);
		_tmp280_ = _tmp279_;
		_tmp281_ = _tmp280_->insert_block;
		_tmp282_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp281_, (ValaStatement*) _tmp282_);
		_tmp283_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp283_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp284_ = local;
		_tmp285_ = vala_symbol_get_name ((ValaSymbol*) _tmp284_);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_binary_expression_get_right (self);
		_tmp288_ = _tmp287_;
		_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_member_access_new_simple (_tmp286_, _tmp290_);
		_tmp292_ = _tmp291_;
		_tmp293_ = vala_binary_expression_get_right (self);
		_tmp294_ = _tmp293_;
		_tmp295_ = vala_binary_expression_get_right (self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp296_);
		_tmp298_ = _tmp297_;
		_tmp299_ = vala_assignment_new ((ValaExpression*) _tmp292_, _tmp294_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp298_);
		_tmp300_ = _tmp299_;
		_tmp301_ = vala_binary_expression_get_right (self);
		_tmp302_ = _tmp301_;
		_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp302_);
		_tmp304_ = _tmp303_;
		_tmp305_ = vala_expression_statement_new ((ValaExpression*) _tmp300_, _tmp304_);
		_tmp306_ = _tmp305_;
		_vala_code_node_unref0 (_tmp300_);
		_vala_code_node_unref0 (_tmp292_);
		right_stmt = _tmp306_;
		_tmp307_ = true_block;
		_tmp308_ = right_local;
		vala_block_remove_local_variable (_tmp307_, _tmp308_);
		_tmp309_ = true_block;
		_tmp310_ = right_decl;
		_tmp311_ = right_stmt;
		vala_block_replace_statement (_tmp309_, (ValaStatement*) _tmp310_, (ValaStatement*) _tmp311_);
		_tmp312_ = right_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp312_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp313_ = local;
		_tmp314_ = vala_symbol_get_name ((ValaSymbol*) _tmp313_);
		_tmp315_ = _tmp314_;
		_tmp316_ = vala_binary_expression_get_left (self);
		_tmp317_ = _tmp316_;
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp317_);
		_tmp319_ = _tmp318_;
		_tmp320_ = vala_member_access_new_simple (_tmp315_, _tmp319_);
		_tmp321_ = _tmp320_;
		_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_null_literal_new (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp327_ = _tmp326_;
		_tmp328_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp321_, (ValaExpression*) _tmp325_, _tmp327_);
		_tmp329_ = _tmp328_;
		_vala_code_node_unref0 (_tmp325_);
		_vala_code_node_unref0 (_tmp321_);
		cond = _tmp329_;
		_tmp330_ = cond;
		_tmp331_ = true_block;
		_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = vala_if_statement_new ((ValaExpression*) _tmp330_, _tmp331_, NULL, _tmp333_);
		if_stmt = _tmp334_;
		_tmp335_ = vala_code_context_get_analyzer (context);
		_tmp336_ = _tmp335_;
		_tmp337_ = _tmp336_->insert_block;
		_tmp338_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp337_, (ValaStatement*) _tmp338_);
		_tmp339_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp339_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_decl);
			_vala_code_node_unref0 (right_local);
			_g_free0 (temp_name);
			return result;
		}
		_tmp340_ = local;
		_tmp341_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp342_ = _tmp341_;
		_tmp343_ = vala_semantic_analyzer_create_temp_access (_tmp340_, _tmp342_);
		replace_expr = _tmp343_;
		if (cast_non_null) {
			ValaExpression* _tmp345_;
			ValaDataType* _tmp346_;
			ValaDataType* _tmp347_;
			_tmp345_ = replace_expr;
			_tmp346_ = vala_expression_get_target_type (_tmp345_);
			_tmp347_ = _tmp346_;
			_tmp344_ = _tmp347_ != NULL;
		} else {
			_tmp344_ = FALSE;
		}
		if (_tmp344_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp348_;
			ValaSourceReference* _tmp349_;
			ValaSourceReference* _tmp350_;
			ValaCastExpression* _tmp351_;
			ValaCastExpression* _tmp352_;
			ValaExpression* _tmp353_;
			ValaDataType* _tmp354_;
			ValaDataType* _tmp355_;
			ValaDataType* _tmp356_;
			ValaDataType* _tmp357_;
			ValaCastExpression* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaCastExpression* _tmp361_;
			ValaExpression* _tmp362_;
			_tmp348_ = replace_expr;
			_tmp349_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp350_ = _tmp349_;
			_tmp351_ = vala_cast_expression_new_non_null (_tmp348_, _tmp350_);
			cast = _tmp351_;
			_tmp352_ = cast;
			_tmp353_ = replace_expr;
			_tmp354_ = vala_expression_get_target_type (_tmp353_);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_data_type_copy (_tmp355_);
			_tmp357_ = _tmp356_;
			vala_expression_set_target_type ((ValaExpression*) _tmp352_, _tmp357_);
			_vala_code_node_unref0 (_tmp357_);
			_tmp358_ = cast;
			_tmp359_ = vala_expression_get_target_type ((ValaExpression*) _tmp358_);
			_tmp360_ = _tmp359_;
			vala_data_type_set_nullable (_tmp360_, FALSE);
			_tmp361_ = cast;
			_tmp362_ = _vala_code_node_ref0 ((ValaExpression*) _tmp361_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp362_;
			_vala_code_node_unref0 (cast);
		}
		_tmp363_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp364_ = _tmp363_;
		_tmp365_ = replace_expr;
		vala_code_node_replace_expression (_tmp364_, (ValaExpression*) self, _tmp365_);
		_tmp366_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp366_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_decl);
		_vala_code_node_unref0 (right_local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp369_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp370_ = _tmp369_;
	if (_tmp370_ != NULL) {
		ValaDataType* _tmp371_;
		ValaDataType* _tmp372_;
		ValaTypeSymbol* _tmp373_;
		ValaTypeSymbol* _tmp374_;
		_tmp371_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp372_ = _tmp371_;
		_tmp373_ = vala_data_type_get_type_symbol (_tmp372_);
		_tmp374_ = _tmp373_;
		_tmp368_ = VALA_IS_ENUM (_tmp374_);
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		gboolean _tmp375_ = FALSE;
		ValaBinaryOperator _tmp376_;
		_tmp376_ = self->priv->_operator;
		if (_tmp376_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp375_ = TRUE;
		} else {
			ValaBinaryOperator _tmp377_;
			_tmp377_ = self->priv->_operator;
			_tmp375_ = _tmp377_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp367_ = _tmp375_;
	} else {
		_tmp367_ = FALSE;
	}
	if (_tmp367_) {
		ValaExpression* _tmp378_;
		ValaExpression* _tmp379_;
		ValaDataType* _tmp380_;
		ValaDataType* _tmp381_;
		ValaDataType* _tmp382_;
		ValaDataType* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaDataType* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		_tmp378_ = vala_binary_expression_get_left (self);
		_tmp379_ = _tmp378_;
		_tmp380_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp381_ = _tmp380_;
		_tmp382_ = vala_data_type_copy (_tmp381_);
		_tmp383_ = _tmp382_;
		vala_expression_set_target_type (_tmp379_, _tmp383_);
		_vala_code_node_unref0 (_tmp383_);
		_tmp384_ = vala_binary_expression_get_right (self);
		_tmp385_ = _tmp384_;
		_tmp386_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp387_ = _tmp386_;
		_tmp388_ = vala_data_type_copy (_tmp387_);
		_tmp389_ = _tmp388_;
		vala_expression_set_target_type (_tmp385_, _tmp389_);
		_vala_code_node_unref0 (_tmp389_);
	}
	_tmp390_ = vala_binary_expression_get_left (self);
	_tmp391_ = _tmp390_;
	vala_code_node_check ((ValaCodeNode*) _tmp391_, context);
	_tmp394_ = vala_binary_expression_get_left (self);
	_tmp395_ = _tmp394_;
	_tmp396_ = vala_expression_get_value_type (_tmp395_);
	_tmp397_ = _tmp396_;
	if (_tmp397_ != NULL) {
		ValaExpression* _tmp398_;
		ValaExpression* _tmp399_;
		ValaDataType* _tmp400_;
		ValaDataType* _tmp401_;
		ValaTypeSymbol* _tmp402_;
		ValaTypeSymbol* _tmp403_;
		_tmp398_ = vala_binary_expression_get_left (self);
		_tmp399_ = _tmp398_;
		_tmp400_ = vala_expression_get_value_type (_tmp399_);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_data_type_get_type_symbol (_tmp401_);
		_tmp403_ = _tmp402_;
		_tmp393_ = VALA_IS_ENUM (_tmp403_);
	} else {
		_tmp393_ = FALSE;
	}
	if (_tmp393_) {
		gboolean _tmp404_ = FALSE;
		ValaBinaryOperator _tmp405_;
		_tmp405_ = self->priv->_operator;
		if (_tmp405_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp404_ = TRUE;
		} else {
			ValaBinaryOperator _tmp406_;
			_tmp406_ = self->priv->_operator;
			_tmp404_ = _tmp406_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp392_ = _tmp404_;
	} else {
		_tmp392_ = FALSE;
	}
	if (_tmp392_) {
		ValaExpression* _tmp407_;
		ValaExpression* _tmp408_;
		ValaExpression* _tmp409_;
		ValaExpression* _tmp410_;
		ValaDataType* _tmp411_;
		ValaDataType* _tmp412_;
		ValaDataType* _tmp413_;
		ValaDataType* _tmp414_;
		_tmp407_ = vala_binary_expression_get_right (self);
		_tmp408_ = _tmp407_;
		_tmp409_ = vala_binary_expression_get_left (self);
		_tmp410_ = _tmp409_;
		_tmp411_ = vala_expression_get_value_type (_tmp410_);
		_tmp412_ = _tmp411_;
		_tmp413_ = vala_data_type_copy (_tmp412_);
		_tmp414_ = _tmp413_;
		vala_expression_set_target_type (_tmp408_, _tmp414_);
		_vala_code_node_unref0 (_tmp414_);
	}
	_tmp415_ = vala_binary_expression_get_right (self);
	_tmp416_ = _tmp415_;
	vala_code_node_check ((ValaCodeNode*) _tmp416_, context);
	_tmp419_ = vala_binary_expression_get_right (self);
	_tmp420_ = _tmp419_;
	_tmp421_ = vala_expression_get_value_type (_tmp420_);
	_tmp422_ = _tmp421_;
	if (_tmp422_ != NULL) {
		ValaExpression* _tmp423_;
		ValaExpression* _tmp424_;
		ValaDataType* _tmp425_;
		ValaDataType* _tmp426_;
		ValaTypeSymbol* _tmp427_;
		ValaTypeSymbol* _tmp428_;
		_tmp423_ = vala_binary_expression_get_right (self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_expression_get_value_type (_tmp424_);
		_tmp426_ = _tmp425_;
		_tmp427_ = vala_data_type_get_type_symbol (_tmp426_);
		_tmp428_ = _tmp427_;
		_tmp418_ = VALA_IS_ENUM (_tmp428_);
	} else {
		_tmp418_ = FALSE;
	}
	if (_tmp418_) {
		gboolean _tmp429_ = FALSE;
		ValaBinaryOperator _tmp430_;
		_tmp430_ = self->priv->_operator;
		if (_tmp430_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp429_ = TRUE;
		} else {
			ValaBinaryOperator _tmp431_;
			_tmp431_ = self->priv->_operator;
			_tmp429_ = _tmp431_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp417_ = _tmp429_;
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaExpression* _tmp432_;
		ValaExpression* _tmp433_;
		ValaExpression* _tmp434_;
		ValaExpression* _tmp435_;
		ValaDataType* _tmp436_;
		ValaDataType* _tmp437_;
		ValaDataType* _tmp438_;
		ValaDataType* _tmp439_;
		_tmp432_ = vala_binary_expression_get_left (self);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_binary_expression_get_right (self);
		_tmp435_ = _tmp434_;
		_tmp436_ = vala_expression_get_value_type (_tmp435_);
		_tmp437_ = _tmp436_;
		_tmp438_ = vala_data_type_copy (_tmp437_);
		_tmp439_ = _tmp438_;
		vala_expression_set_target_type (_tmp433_, _tmp439_);
		_vala_code_node_unref0 (_tmp439_);
	}
	_tmp441_ = vala_binary_expression_get_left (self);
	_tmp442_ = _tmp441_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp442_, context)) {
		_tmp440_ = TRUE;
	} else {
		ValaExpression* _tmp443_;
		ValaExpression* _tmp444_;
		_tmp443_ = vala_binary_expression_get_right (self);
		_tmp444_ = _tmp443_;
		_tmp440_ = !vala_code_node_check ((ValaCodeNode*) _tmp444_, context);
	}
	if (_tmp440_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp445_ = vala_binary_expression_get_left (self);
	_tmp446_ = _tmp445_;
	_tmp447_ = vala_expression_get_value_type (_tmp446_);
	_tmp448_ = _tmp447_;
	if (_tmp448_ == NULL) {
		ValaExpression* _tmp449_;
		ValaExpression* _tmp450_;
		ValaSourceReference* _tmp451_;
		ValaSourceReference* _tmp452_;
		_tmp449_ = vala_binary_expression_get_left (self);
		_tmp450_ = _tmp449_;
		_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp450_);
		_tmp452_ = _tmp451_;
		vala_report_error (_tmp452_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp454_ = self->priv->_operator;
	if (_tmp454_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp455_;
		ValaExpression* _tmp456_;
		ValaDataType* _tmp457_;
		ValaDataType* _tmp458_;
		_tmp455_ = vala_binary_expression_get_right (self);
		_tmp456_ = _tmp455_;
		_tmp457_ = vala_expression_get_value_type (_tmp456_);
		_tmp458_ = _tmp457_;
		_tmp453_ = _tmp458_ == NULL;
	} else {
		_tmp453_ = FALSE;
	}
	if (_tmp453_) {
		ValaExpression* _tmp459_;
		ValaExpression* _tmp460_;
		ValaSourceReference* _tmp461_;
		ValaSourceReference* _tmp462_;
		_tmp459_ = vala_binary_expression_get_right (self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp460_);
		_tmp462_ = _tmp461_;
		vala_report_error (_tmp462_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp464_ = vala_binary_expression_get_left (self);
	_tmp465_ = _tmp464_;
	_tmp466_ = vala_expression_get_value_type (_tmp465_);
	_tmp467_ = _tmp466_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp467_)) {
		_tmp463_ = TRUE;
	} else {
		ValaExpression* _tmp468_;
		ValaExpression* _tmp469_;
		ValaDataType* _tmp470_;
		ValaDataType* _tmp471_;
		_tmp468_ = vala_binary_expression_get_left (self);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_expression_get_value_type (_tmp469_);
		_tmp471_ = _tmp470_;
		_tmp463_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp471_);
	}
	if (_tmp463_) {
		ValaExpression* _tmp472_;
		ValaExpression* _tmp473_;
		ValaSourceReference* _tmp474_;
		ValaSourceReference* _tmp475_;
		ValaExpression* _tmp476_;
		ValaExpression* _tmp477_;
		ValaSymbol* _tmp478_;
		ValaSymbol* _tmp479_;
		gchar* _tmp480_;
		gchar* _tmp481_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp472_ = vala_binary_expression_get_left (self);
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp473_);
		_tmp475_ = _tmp474_;
		_tmp476_ = vala_binary_expression_get_left (self);
		_tmp477_ = _tmp476_;
		_tmp478_ = vala_expression_get_symbol_reference (_tmp477_);
		_tmp479_ = _tmp478_;
		_tmp480_ = vala_symbol_get_full_name (_tmp479_);
		_tmp481_ = _tmp480_;
		vala_report_error (_tmp475_, "Access to instance member `%s' denied", _tmp481_);
		_g_free0 (_tmp481_);
		result = FALSE;
		return result;
	}
	_tmp483_ = vala_binary_expression_get_right (self);
	_tmp484_ = _tmp483_;
	_tmp485_ = vala_expression_get_value_type (_tmp484_);
	_tmp486_ = _tmp485_;
	if (VALA_IS_FIELD_PROTOTYPE (_tmp486_)) {
		_tmp482_ = TRUE;
	} else {
		ValaExpression* _tmp487_;
		ValaExpression* _tmp488_;
		ValaDataType* _tmp489_;
		ValaDataType* _tmp490_;
		_tmp487_ = vala_binary_expression_get_right (self);
		_tmp488_ = _tmp487_;
		_tmp489_ = vala_expression_get_value_type (_tmp488_);
		_tmp490_ = _tmp489_;
		_tmp482_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp490_);
	}
	if (_tmp482_) {
		ValaExpression* _tmp491_;
		ValaExpression* _tmp492_;
		ValaSourceReference* _tmp493_;
		ValaSourceReference* _tmp494_;
		ValaExpression* _tmp495_;
		ValaExpression* _tmp496_;
		ValaSymbol* _tmp497_;
		ValaSymbol* _tmp498_;
		gchar* _tmp499_;
		gchar* _tmp500_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp491_ = vala_binary_expression_get_right (self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp492_);
		_tmp494_ = _tmp493_;
		_tmp495_ = vala_binary_expression_get_right (self);
		_tmp496_ = _tmp495_;
		_tmp497_ = vala_expression_get_symbol_reference (_tmp496_);
		_tmp498_ = _tmp497_;
		_tmp499_ = vala_symbol_get_full_name (_tmp498_);
		_tmp500_ = _tmp499_;
		vala_report_error (_tmp494_, "Access to instance member `%s' denied", _tmp500_);
		_g_free0 (_tmp500_);
		result = FALSE;
		return result;
	}
	_tmp501_ = vala_binary_expression_get_left (self);
	_tmp502_ = _tmp501_;
	_tmp503_ = vala_binary_expression_get_left (self);
	_tmp504_ = _tmp503_;
	_tmp505_ = vala_expression_get_value_type (_tmp504_);
	_tmp506_ = _tmp505_;
	_tmp507_ = vala_data_type_copy (_tmp506_);
	_tmp508_ = _tmp507_;
	vala_expression_set_target_type (_tmp502_, _tmp508_);
	_vala_code_node_unref0 (_tmp508_);
	_tmp509_ = vala_binary_expression_get_left (self);
	_tmp510_ = _tmp509_;
	_tmp511_ = vala_expression_get_target_type (_tmp510_);
	_tmp512_ = _tmp511_;
	vala_data_type_set_value_owned (_tmp512_, FALSE);
	_tmp513_ = vala_binary_expression_get_right (self);
	_tmp514_ = _tmp513_;
	_tmp515_ = vala_binary_expression_get_right (self);
	_tmp516_ = _tmp515_;
	_tmp517_ = vala_expression_get_value_type (_tmp516_);
	_tmp518_ = _tmp517_;
	_tmp519_ = vala_data_type_copy (_tmp518_);
	_tmp520_ = _tmp519_;
	vala_expression_set_target_type (_tmp514_, _tmp520_);
	_vala_code_node_unref0 (_tmp520_);
	_tmp521_ = vala_binary_expression_get_right (self);
	_tmp522_ = _tmp521_;
	_tmp523_ = vala_expression_get_target_type (_tmp522_);
	_tmp524_ = _tmp523_;
	vala_data_type_set_value_owned (_tmp524_, FALSE);
	_tmp527_ = self->priv->_operator;
	if (_tmp527_ == VALA_BINARY_OPERATOR_PLUS) {
		ValaExpression* _tmp528_;
		ValaExpression* _tmp529_;
		ValaDataType* _tmp530_;
		ValaDataType* _tmp531_;
		_tmp528_ = vala_binary_expression_get_left (self);
		_tmp529_ = _tmp528_;
		_tmp530_ = vala_expression_get_value_type (_tmp529_);
		_tmp531_ = _tmp530_;
		_tmp526_ = !VALA_IS_POINTER_TYPE (_tmp531_);
	} else {
		_tmp526_ = FALSE;
	}
	if (_tmp526_) {
		ValaExpression* _tmp532_;
		ValaExpression* _tmp533_;
		ValaDataType* _tmp534_;
		ValaDataType* _tmp535_;
		ValaSemanticAnalyzer* _tmp536_;
		ValaSemanticAnalyzer* _tmp537_;
		ValaDataType* _tmp538_;
		_tmp532_ = vala_binary_expression_get_left (self);
		_tmp533_ = _tmp532_;
		_tmp534_ = vala_expression_get_value_type (_tmp533_);
		_tmp535_ = _tmp534_;
		_tmp536_ = vala_code_context_get_analyzer (context);
		_tmp537_ = _tmp536_;
		_tmp538_ = _tmp537_->string_type;
		_tmp525_ = vala_data_type_compatible (_tmp535_, _tmp538_);
	} else {
		_tmp525_ = FALSE;
	}
	if (_tmp525_) {
		gboolean _tmp539_ = FALSE;
		ValaExpression* _tmp540_;
		ValaExpression* _tmp541_;
		ValaDataType* _tmp542_;
		ValaDataType* _tmp543_;
		ValaSemanticAnalyzer* _tmp553_;
		ValaSemanticAnalyzer* _tmp554_;
		ValaDataType* _tmp555_;
		ValaDataType* _tmp556_;
		ValaDataType* _tmp557_;
		gboolean _tmp558_ = FALSE;
		ValaExpression* _tmp559_;
		ValaExpression* _tmp560_;
		ValaDataType* _tmp567_;
		ValaDataType* _tmp568_;
		gboolean _tmp569_;
		gboolean _tmp570_;
		_tmp540_ = vala_binary_expression_get_right (self);
		_tmp541_ = _tmp540_;
		_tmp542_ = vala_expression_get_value_type (_tmp541_);
		_tmp543_ = _tmp542_;
		if (_tmp543_ == NULL) {
			_tmp539_ = TRUE;
		} else {
			ValaExpression* _tmp544_;
			ValaExpression* _tmp545_;
			ValaDataType* _tmp546_;
			ValaDataType* _tmp547_;
			ValaSemanticAnalyzer* _tmp548_;
			ValaSemanticAnalyzer* _tmp549_;
			ValaDataType* _tmp550_;
			_tmp544_ = vala_binary_expression_get_right (self);
			_tmp545_ = _tmp544_;
			_tmp546_ = vala_expression_get_value_type (_tmp545_);
			_tmp547_ = _tmp546_;
			_tmp548_ = vala_code_context_get_analyzer (context);
			_tmp549_ = _tmp548_;
			_tmp550_ = _tmp549_->string_type;
			_tmp539_ = !vala_data_type_compatible (_tmp547_, _tmp550_);
		}
		if (_tmp539_) {
			ValaSourceReference* _tmp551_;
			ValaSourceReference* _tmp552_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp552_ = _tmp551_;
			vala_report_error (_tmp552_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp553_ = vala_code_context_get_analyzer (context);
		_tmp554_ = _tmp553_;
		_tmp555_ = _tmp554_->string_type;
		_tmp556_ = vala_data_type_copy (_tmp555_);
		_tmp557_ = _tmp556_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp557_);
		_vala_code_node_unref0 (_tmp557_);
		_tmp559_ = vala_binary_expression_get_left (self);
		_tmp560_ = _tmp559_;
		if (vala_expression_is_constant (_tmp560_)) {
			ValaExpression* _tmp561_;
			ValaExpression* _tmp562_;
			_tmp561_ = vala_binary_expression_get_right (self);
			_tmp562_ = _tmp561_;
			_tmp558_ = vala_expression_is_constant (_tmp562_);
		} else {
			_tmp558_ = FALSE;
		}
		if (_tmp558_) {
			ValaDataType* _tmp563_;
			ValaDataType* _tmp564_;
			_tmp563_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp564_ = _tmp563_;
			vala_data_type_set_value_owned (_tmp564_, FALSE);
		} else {
			ValaDataType* _tmp565_;
			ValaDataType* _tmp566_;
			_tmp565_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp566_ = _tmp565_;
			vala_data_type_set_value_owned (_tmp566_, TRUE);
		}
		_tmp567_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp568_ = _tmp567_;
		vala_code_node_check ((ValaCodeNode*) _tmp568_, context);
		_tmp569_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp570_ = _tmp569_;
		result = !_tmp570_;
		return result;
	} else {
		gboolean _tmp571_ = FALSE;
		ValaBinaryOperator _tmp572_;
		_tmp572_ = self->priv->_operator;
		if (_tmp572_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp573_;
			ValaExpression* _tmp574_;
			ValaDataType* _tmp575_;
			ValaDataType* _tmp576_;
			_tmp573_ = vala_binary_expression_get_left (self);
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_expression_get_value_type (_tmp574_);
			_tmp576_ = _tmp575_;
			_tmp571_ = VALA_IS_ARRAY_TYPE (_tmp576_);
		} else {
			_tmp571_ = FALSE;
		}
		if (_tmp571_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp577_;
			ValaExpression* _tmp578_;
			ValaDataType* _tmp579_;
			ValaDataType* _tmp580_;
			ValaArrayType* _tmp581_;
			gboolean _tmp582_;
			gboolean _tmp583_;
			gboolean _tmp586_ = FALSE;
			ValaExpression* _tmp587_;
			ValaExpression* _tmp588_;
			ValaDataType* _tmp589_;
			ValaDataType* _tmp590_;
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaArrayType* _tmp602_;
			ValaDataType* _tmp603_;
			ValaDataType* _tmp604_;
			ValaDataType* _tmp605_;
			ValaDataType* _tmp606_;
			ValaArrayType* _tmp607_;
			ValaDataType* _tmp608_;
			ValaDataType* _tmp609_;
			ValaDataType* _tmp610_;
			ValaDataType* _tmp611_;
			ValaDataType* _tmp612_;
			ValaDataType* _tmp613_;
			gboolean _tmp614_;
			gboolean _tmp615_;
			_tmp577_ = vala_binary_expression_get_left (self);
			_tmp578_ = _tmp577_;
			_tmp579_ = vala_expression_get_value_type (_tmp578_);
			_tmp580_ = _tmp579_;
			array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
			_tmp581_ = array_type;
			_tmp582_ = vala_array_type_get_inline_allocated (_tmp581_);
			_tmp583_ = _tmp582_;
			if (_tmp583_) {
				ValaSourceReference* _tmp584_;
				ValaSourceReference* _tmp585_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp584_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp585_ = _tmp584_;
				vala_report_error (_tmp585_, "Array concatenation not supported for fixed length arrays");
			}
			_tmp587_ = vala_binary_expression_get_right (self);
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_expression_get_value_type (_tmp588_);
			_tmp590_ = _tmp589_;
			if (_tmp590_ == NULL) {
				_tmp586_ = TRUE;
			} else {
				ValaExpression* _tmp591_;
				ValaExpression* _tmp592_;
				ValaDataType* _tmp593_;
				ValaDataType* _tmp594_;
				ValaArrayType* _tmp595_;
				ValaDataType* _tmp596_;
				ValaDataType* _tmp597_;
				_tmp591_ = vala_binary_expression_get_right (self);
				_tmp592_ = _tmp591_;
				_tmp593_ = vala_expression_get_value_type (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = array_type;
				_tmp596_ = vala_array_type_get_element_type (_tmp595_);
				_tmp597_ = _tmp596_;
				_tmp586_ = !vala_data_type_compatible (_tmp594_, _tmp597_);
			}
			if (_tmp586_) {
				ValaSourceReference* _tmp598_;
				ValaSourceReference* _tmp599_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp598_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp599_ = _tmp598_;
				vala_report_error (_tmp599_, "Incompatible operand");
				result = FALSE;
				return result;
			}
			_tmp600_ = vala_binary_expression_get_right (self);
			_tmp601_ = _tmp600_;
			_tmp602_ = array_type;
			_tmp603_ = vala_array_type_get_element_type (_tmp602_);
			_tmp604_ = _tmp603_;
			_tmp605_ = vala_data_type_copy (_tmp604_);
			_tmp606_ = _tmp605_;
			vala_expression_set_target_type (_tmp601_, _tmp606_);
			_vala_code_node_unref0 (_tmp606_);
			_tmp607_ = array_type;
			_tmp608_ = vala_data_type_copy ((ValaDataType*) _tmp607_);
			_tmp609_ = _tmp608_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp609_);
			_vala_code_node_unref0 (_tmp609_);
			_tmp610_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			vala_data_type_set_value_owned (_tmp611_, TRUE);
			_tmp612_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp613_ = _tmp612_;
			vala_code_node_check ((ValaCodeNode*) _tmp613_, context);
			_tmp614_ = vala_code_node_get_error ((ValaCodeNode*) self);
			_tmp615_ = _tmp614_;
			result = !_tmp615_;
			return result;
		}
	}
	_tmp616_ = self->priv->_operator;
	switch (_tmp616_) {
		case VALA_BINARY_OPERATOR_PLUS:
		case VALA_BINARY_OPERATOR_MINUS:
		case VALA_BINARY_OPERATOR_MUL:
		case VALA_BINARY_OPERATOR_DIV:
		{
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			ValaDataType* _tmp619_;
			ValaDataType* _tmp620_;
			ValaDataType* _tmp663_;
			ValaDataType* _tmp664_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			_tmp617_ = vala_binary_expression_get_left (self);
			_tmp618_ = _tmp617_;
			_tmp619_ = vala_expression_get_value_type (_tmp618_);
			_tmp620_ = _tmp619_;
			if (VALA_IS_POINTER_TYPE (_tmp620_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp621_;
				ValaExpression* _tmp622_;
				ValaDataType* _tmp623_;
				ValaDataType* _tmp624_;
				ValaPointerType* _tmp625_;
				ValaDataType* _tmp626_;
				ValaDataType* _tmp627_;
				ValaStruct* offset_type = NULL;
				ValaExpression* _tmp630_;
				ValaExpression* _tmp631_;
				ValaDataType* _tmp632_;
				ValaDataType* _tmp633_;
				ValaTypeSymbol* _tmp634_;
				ValaTypeSymbol* _tmp635_;
				gboolean _tmp636_ = FALSE;
				ValaStruct* _tmp637_;
				_tmp621_ = vala_binary_expression_get_left (self);
				_tmp622_ = _tmp621_;
				_tmp623_ = vala_expression_get_value_type (_tmp622_);
				_tmp624_ = _tmp623_;
				pointer_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp624_, VALA_TYPE_POINTER_TYPE, ValaPointerType);
				_tmp625_ = pointer_type;
				_tmp626_ = vala_pointer_type_get_base_type (_tmp625_);
				_tmp627_ = _tmp626_;
				if (VALA_IS_VOID_TYPE (_tmp627_)) {
					ValaSourceReference* _tmp628_;
					ValaSourceReference* _tmp629_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp628_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp629_ = _tmp628_;
					vala_report_error (_tmp629_, "Pointer arithmetic not supported for `void*'");
					result = FALSE;
					return result;
				}
				_tmp630_ = vala_binary_expression_get_right (self);
				_tmp631_ = _tmp630_;
				_tmp632_ = vala_expression_get_value_type (_tmp631_);
				_tmp633_ = _tmp632_;
				_tmp634_ = vala_data_type_get_type_symbol (_tmp633_);
				_tmp635_ = _tmp634_;
				offset_type = VALA_IS_STRUCT (_tmp635_) ? ((ValaStruct*) _tmp635_) : NULL;
				_tmp637_ = offset_type;
				if (_tmp637_ != NULL) {
					ValaStruct* _tmp638_;
					_tmp638_ = offset_type;
					_tmp636_ = vala_struct_is_integer_type (_tmp638_);
				} else {
					_tmp636_ = FALSE;
				}
				if (_tmp636_) {
					gboolean _tmp639_ = FALSE;
					ValaBinaryOperator _tmp640_;
					_tmp640_ = self->priv->_operator;
					if (_tmp640_ == VALA_BINARY_OPERATOR_PLUS) {
						_tmp639_ = TRUE;
					} else {
						ValaBinaryOperator _tmp641_;
						_tmp641_ = self->priv->_operator;
						_tmp639_ = _tmp641_ == VALA_BINARY_OPERATOR_MINUS;
					}
					if (_tmp639_) {
						ValaExpression* _tmp642_;
						ValaExpression* _tmp643_;
						ValaDataType* _tmp644_;
						ValaDataType* _tmp645_;
						ValaDataType* _tmp646_;
						ValaDataType* _tmp647_;
						_tmp642_ = vala_binary_expression_get_left (self);
						_tmp643_ = _tmp642_;
						_tmp644_ = vala_expression_get_value_type (_tmp643_);
						_tmp645_ = _tmp644_;
						_tmp646_ = vala_data_type_copy (_tmp645_);
						_tmp647_ = _tmp646_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp647_);
						_vala_code_node_unref0 (_tmp647_);
					}
				} else {
					ValaExpression* _tmp648_;
					ValaExpression* _tmp649_;
					ValaDataType* _tmp650_;
					ValaDataType* _tmp651_;
					_tmp648_ = vala_binary_expression_get_right (self);
					_tmp649_ = _tmp648_;
					_tmp650_ = vala_expression_get_value_type (_tmp649_);
					_tmp651_ = _tmp650_;
					if (VALA_IS_POINTER_TYPE (_tmp651_)) {
						ValaSemanticAnalyzer* _tmp652_;
						ValaSemanticAnalyzer* _tmp653_;
						ValaDataType* _tmp654_;
						_tmp652_ = vala_code_context_get_analyzer (context);
						_tmp653_ = _tmp652_;
						_tmp654_ = _tmp653_->size_t_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp654_);
					}
				}
			} else {
				ValaExpression* _tmp655_;
				ValaExpression* _tmp656_;
				ValaDataType* _tmp657_;
				ValaDataType* _tmp658_;
				ValaExpression* _tmp659_;
				ValaExpression* _tmp660_;
				ValaDataType* _tmp661_;
				ValaDataType* _tmp662_;
				_tmp655_ = vala_binary_expression_get_left (self);
				_tmp656_ = _tmp655_;
				_tmp657_ = vala_expression_get_target_type (_tmp656_);
				_tmp658_ = _tmp657_;
				vala_data_type_set_nullable (_tmp658_, FALSE);
				_tmp659_ = vala_binary_expression_get_right (self);
				_tmp660_ = _tmp659_;
				_tmp661_ = vala_expression_get_target_type (_tmp660_);
				_tmp662_ = _tmp661_;
				vala_data_type_set_nullable (_tmp662_, FALSE);
			}
			_tmp663_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp664_ = _tmp663_;
			if (_tmp664_ == NULL) {
				ValaSemanticAnalyzer* _tmp665_;
				ValaSemanticAnalyzer* _tmp666_;
				ValaExpression* _tmp667_;
				ValaExpression* _tmp668_;
				ValaDataType* _tmp669_;
				ValaDataType* _tmp670_;
				ValaExpression* _tmp671_;
				ValaExpression* _tmp672_;
				ValaDataType* _tmp673_;
				ValaDataType* _tmp674_;
				ValaDataType* _tmp675_;
				_tmp665_ = vala_code_context_get_analyzer (context);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_binary_expression_get_left (self);
				_tmp668_ = _tmp667_;
				_tmp669_ = vala_expression_get_target_type (_tmp668_);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_binary_expression_get_right (self);
				_tmp672_ = _tmp671_;
				_tmp673_ = vala_expression_get_target_type (_tmp672_);
				_tmp674_ = _tmp673_;
				_tmp675_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp666_, _tmp670_, _tmp674_);
				vala_expression_set_value_type ((ValaExpression*) self, _tmp675_);
			}
			_tmp676_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp677_ = _tmp676_;
			if (_tmp677_ == NULL) {
				ValaSourceReference* _tmp678_;
				ValaSourceReference* _tmp679_;
				ValaExpression* _tmp680_;
				ValaExpression* _tmp681_;
				ValaDataType* _tmp682_;
				ValaDataType* _tmp683_;
				gchar* _tmp684_;
				gchar* _tmp685_;
				ValaExpression* _tmp686_;
				ValaExpression* _tmp687_;
				ValaDataType* _tmp688_;
				ValaDataType* _tmp689_;
				gchar* _tmp690_;
				gchar* _tmp691_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp678_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_binary_expression_get_left (self);
				_tmp681_ = _tmp680_;
				_tmp682_ = vala_expression_get_value_type (_tmp681_);
				_tmp683_ = _tmp682_;
				_tmp684_ = vala_code_node_to_string ((ValaCodeNode*) _tmp683_);
				_tmp685_ = _tmp684_;
				_tmp686_ = vala_binary_expression_get_right (self);
				_tmp687_ = _tmp686_;
				_tmp688_ = vala_expression_get_value_type (_tmp687_);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_code_node_to_string ((ValaCodeNode*) _tmp689_);
				_tmp691_ = _tmp690_;
				vala_report_error (_tmp679_, "Arithmetic operation not supported for types `%s' and `%s'", _tmp685_, _tmp691_);
				_g_free0 (_tmp691_);
				_g_free0 (_tmp685_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_MOD:
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			ValaExpression* _tmp692_;
			ValaExpression* _tmp693_;
			ValaDataType* _tmp694_;
			ValaDataType* _tmp695_;
			ValaExpression* _tmp696_;
			ValaExpression* _tmp697_;
			ValaDataType* _tmp698_;
			ValaDataType* _tmp699_;
			ValaSemanticAnalyzer* _tmp700_;
			ValaSemanticAnalyzer* _tmp701_;
			ValaExpression* _tmp702_;
			ValaExpression* _tmp703_;
			ValaDataType* _tmp704_;
			ValaDataType* _tmp705_;
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			ValaDataType* _tmp708_;
			ValaDataType* _tmp709_;
			ValaDataType* _tmp710_;
			ValaDataType* _tmp711_;
			ValaDataType* _tmp712_;
			_tmp692_ = vala_binary_expression_get_left (self);
			_tmp693_ = _tmp692_;
			_tmp694_ = vala_expression_get_target_type (_tmp693_);
			_tmp695_ = _tmp694_;
			vala_data_type_set_nullable (_tmp695_, FALSE);
			_tmp696_ = vala_binary_expression_get_right (self);
			_tmp697_ = _tmp696_;
			_tmp698_ = vala_expression_get_target_type (_tmp697_);
			_tmp699_ = _tmp698_;
			vala_data_type_set_nullable (_tmp699_, FALSE);
			_tmp700_ = vala_code_context_get_analyzer (context);
			_tmp701_ = _tmp700_;
			_tmp702_ = vala_binary_expression_get_left (self);
			_tmp703_ = _tmp702_;
			_tmp704_ = vala_expression_get_target_type (_tmp703_);
			_tmp705_ = _tmp704_;
			_tmp706_ = vala_binary_expression_get_right (self);
			_tmp707_ = _tmp706_;
			_tmp708_ = vala_expression_get_target_type (_tmp707_);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp701_, _tmp705_, _tmp709_);
			vala_expression_set_value_type ((ValaExpression*) self, _tmp710_);
			_tmp711_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp712_ = _tmp711_;
			if (_tmp712_ == NULL) {
				ValaSourceReference* _tmp713_;
				ValaSourceReference* _tmp714_;
				ValaExpression* _tmp715_;
				ValaExpression* _tmp716_;
				ValaDataType* _tmp717_;
				ValaDataType* _tmp718_;
				gchar* _tmp719_;
				gchar* _tmp720_;
				ValaExpression* _tmp721_;
				ValaExpression* _tmp722_;
				ValaDataType* _tmp723_;
				ValaDataType* _tmp724_;
				gchar* _tmp725_;
				gchar* _tmp726_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp713_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp714_ = _tmp713_;
				_tmp715_ = vala_binary_expression_get_left (self);
				_tmp716_ = _tmp715_;
				_tmp717_ = vala_expression_get_value_type (_tmp716_);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_code_node_to_string ((ValaCodeNode*) _tmp718_);
				_tmp720_ = _tmp719_;
				_tmp721_ = vala_binary_expression_get_right (self);
				_tmp722_ = _tmp721_;
				_tmp723_ = vala_expression_get_value_type (_tmp722_);
				_tmp724_ = _tmp723_;
				_tmp725_ = vala_code_node_to_string ((ValaCodeNode*) _tmp724_);
				_tmp726_ = _tmp725_;
				vala_report_error (_tmp714_, "Arithmetic operation not supported for types `%s' and `%s'", _tmp720_, _tmp726_);
				_g_free0 (_tmp726_);
				_g_free0 (_tmp720_);
				result = FALSE;
				return result;
			}
			break;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			gboolean _tmp727_ = FALSE;
			ValaExpression* _tmp728_;
			ValaExpression* _tmp729_;
			ValaDataType* _tmp730_;
			ValaDataType* _tmp731_;
			ValaSemanticAnalyzer* _tmp732_;
			ValaSemanticAnalyzer* _tmp733_;
			ValaDataType* _tmp734_;
			ValaSemanticAnalyzer* _tmp814_;
			ValaSemanticAnalyzer* _tmp815_;
			ValaDataType* _tmp816_;
			_tmp728_ = vala_binary_expression_get_left (self);
			_tmp729_ = _tmp728_;
			_tmp730_ = vala_expression_get_value_type (_tmp729_);
			_tmp731_ = _tmp730_;
			_tmp732_ = vala_code_context_get_analyzer (context);
			_tmp733_ = _tmp732_;
			_tmp734_ = _tmp733_->string_type;
			if (vala_data_type_compatible (_tmp731_, _tmp734_)) {
				ValaExpression* _tmp735_;
				ValaExpression* _tmp736_;
				ValaDataType* _tmp737_;
				ValaDataType* _tmp738_;
				ValaSemanticAnalyzer* _tmp739_;
				ValaSemanticAnalyzer* _tmp740_;
				ValaDataType* _tmp741_;
				_tmp735_ = vala_binary_expression_get_right (self);
				_tmp736_ = _tmp735_;
				_tmp737_ = vala_expression_get_value_type (_tmp736_);
				_tmp738_ = _tmp737_;
				_tmp739_ = vala_code_context_get_analyzer (context);
				_tmp740_ = _tmp739_;
				_tmp741_ = _tmp740_->string_type;
				_tmp727_ = vala_data_type_compatible (_tmp738_, _tmp741_);
			} else {
				_tmp727_ = FALSE;
			}
			if (_tmp727_) {
			} else {
				gboolean _tmp742_ = FALSE;
				ValaExpression* _tmp743_;
				ValaExpression* _tmp744_;
				ValaDataType* _tmp745_;
				ValaDataType* _tmp746_;
				_tmp743_ = vala_binary_expression_get_left (self);
				_tmp744_ = _tmp743_;
				_tmp745_ = vala_expression_get_value_type (_tmp744_);
				_tmp746_ = _tmp745_;
				if (VALA_IS_POINTER_TYPE (_tmp746_)) {
					ValaExpression* _tmp747_;
					ValaExpression* _tmp748_;
					ValaDataType* _tmp749_;
					ValaDataType* _tmp750_;
					_tmp747_ = vala_binary_expression_get_right (self);
					_tmp748_ = _tmp747_;
					_tmp749_ = vala_expression_get_value_type (_tmp748_);
					_tmp750_ = _tmp749_;
					_tmp742_ = VALA_IS_POINTER_TYPE (_tmp750_);
				} else {
					_tmp742_ = FALSE;
				}
				if (_tmp742_) {
				} else {
					ValaDataType* resulting_type = NULL;
					gboolean _tmp751_;
					ValaDataType* _tmp780_;
					gboolean _tmp795_;
					ValaExpression* _tmp801_;
					ValaExpression* _tmp802_;
					ValaDataType* _tmp803_;
					ValaDataType* _tmp804_;
					ValaDataType* _tmp805_;
					ValaExpression* _tmp806_;
					ValaExpression* _tmp807_;
					ValaDataType* _tmp808_;
					ValaDataType* _tmp809_;
					ValaExpression* _tmp810_;
					ValaExpression* _tmp811_;
					ValaDataType* _tmp812_;
					ValaDataType* _tmp813_;
					_tmp751_ = self->priv->_is_chained;
					if (_tmp751_) {
						ValaBinaryExpression* lbe = NULL;
						ValaExpression* _tmp752_;
						ValaExpression* _tmp753_;
						ValaBinaryExpression* _tmp754_;
						ValaSemanticAnalyzer* _tmp755_;
						ValaSemanticAnalyzer* _tmp756_;
						ValaBinaryExpression* _tmp757_;
						ValaExpression* _tmp758_;
						ValaExpression* _tmp759_;
						ValaDataType* _tmp760_;
						ValaDataType* _tmp761_;
						ValaExpression* _tmp762_;
						ValaExpression* _tmp763_;
						ValaDataType* _tmp764_;
						ValaDataType* _tmp765_;
						ValaDataType* _tmp766_;
						ValaDataType* _tmp767_;
						_tmp752_ = vala_binary_expression_get_left (self);
						_tmp753_ = _tmp752_;
						_tmp754_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp753_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
						lbe = _tmp754_;
						_tmp755_ = vala_code_context_get_analyzer (context);
						_tmp756_ = _tmp755_;
						_tmp757_ = lbe;
						_tmp758_ = vala_binary_expression_get_right (_tmp757_);
						_tmp759_ = _tmp758_;
						_tmp760_ = vala_expression_get_target_type (_tmp759_);
						_tmp761_ = _tmp760_;
						_tmp762_ = vala_binary_expression_get_right (self);
						_tmp763_ = _tmp762_;
						_tmp764_ = vala_expression_get_target_type (_tmp763_);
						_tmp765_ = _tmp764_;
						_tmp766_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp756_, _tmp761_, _tmp765_);
						_tmp767_ = _vala_code_node_ref0 (_tmp766_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp767_;
						_vala_code_node_unref0 (lbe);
					} else {
						ValaSemanticAnalyzer* _tmp768_;
						ValaSemanticAnalyzer* _tmp769_;
						ValaExpression* _tmp770_;
						ValaExpression* _tmp771_;
						ValaDataType* _tmp772_;
						ValaDataType* _tmp773_;
						ValaExpression* _tmp774_;
						ValaExpression* _tmp775_;
						ValaDataType* _tmp776_;
						ValaDataType* _tmp777_;
						ValaDataType* _tmp778_;
						ValaDataType* _tmp779_;
						_tmp768_ = vala_code_context_get_analyzer (context);
						_tmp769_ = _tmp768_;
						_tmp770_ = vala_binary_expression_get_left (self);
						_tmp771_ = _tmp770_;
						_tmp772_ = vala_expression_get_target_type (_tmp771_);
						_tmp773_ = _tmp772_;
						_tmp774_ = vala_binary_expression_get_right (self);
						_tmp775_ = _tmp774_;
						_tmp776_ = vala_expression_get_target_type (_tmp775_);
						_tmp777_ = _tmp776_;
						_tmp778_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp769_, _tmp773_, _tmp777_);
						_tmp779_ = _vala_code_node_ref0 (_tmp778_);
						_vala_code_node_unref0 (resulting_type);
						resulting_type = _tmp779_;
					}
					_tmp780_ = resulting_type;
					if (_tmp780_ == NULL) {
						ValaSourceReference* _tmp781_;
						ValaSourceReference* _tmp782_;
						ValaExpression* _tmp783_;
						ValaExpression* _tmp784_;
						ValaDataType* _tmp785_;
						ValaDataType* _tmp786_;
						gchar* _tmp787_;
						gchar* _tmp788_;
						ValaExpression* _tmp789_;
						ValaExpression* _tmp790_;
						ValaDataType* _tmp791_;
						ValaDataType* _tmp792_;
						gchar* _tmp793_;
						gchar* _tmp794_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp781_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp782_ = _tmp781_;
						_tmp783_ = vala_binary_expression_get_left (self);
						_tmp784_ = _tmp783_;
						_tmp785_ = vala_expression_get_value_type (_tmp784_);
						_tmp786_ = _tmp785_;
						_tmp787_ = vala_code_node_to_string ((ValaCodeNode*) _tmp786_);
						_tmp788_ = _tmp787_;
						_tmp789_ = vala_binary_expression_get_right (self);
						_tmp790_ = _tmp789_;
						_tmp791_ = vala_expression_get_value_type (_tmp790_);
						_tmp792_ = _tmp791_;
						_tmp793_ = vala_code_node_to_string ((ValaCodeNode*) _tmp792_);
						_tmp794_ = _tmp793_;
						vala_report_error (_tmp782_, "Relational operation not supported for types `%s' and `%s'", _tmp788_, _tmp794_);
						_g_free0 (_tmp794_);
						_g_free0 (_tmp788_);
						result = FALSE;
						_vala_code_node_unref0 (resulting_type);
						return result;
					}
					_tmp795_ = self->priv->_is_chained;
					if (!_tmp795_) {
						ValaExpression* _tmp796_;
						ValaExpression* _tmp797_;
						ValaDataType* _tmp798_;
						ValaDataType* _tmp799_;
						ValaDataType* _tmp800_;
						_tmp796_ = vala_binary_expression_get_left (self);
						_tmp797_ = _tmp796_;
						_tmp798_ = resulting_type;
						_tmp799_ = vala_data_type_copy (_tmp798_);
						_tmp800_ = _tmp799_;
						vala_expression_set_target_type (_tmp797_, _tmp800_);
						_vala_code_node_unref0 (_tmp800_);
					}
					_tmp801_ = vala_binary_expression_get_right (self);
					_tmp802_ = _tmp801_;
					_tmp803_ = resulting_type;
					_tmp804_ = vala_data_type_copy (_tmp803_);
					_tmp805_ = _tmp804_;
					vala_expression_set_target_type (_tmp802_, _tmp805_);
					_vala_code_node_unref0 (_tmp805_);
					_tmp806_ = vala_binary_expression_get_left (self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_expression_get_target_type (_tmp807_);
					_tmp809_ = _tmp808_;
					vala_data_type_set_nullable (_tmp809_, FALSE);
					_tmp810_ = vala_binary_expression_get_right (self);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_expression_get_target_type (_tmp811_);
					_tmp813_ = _tmp812_;
					vala_data_type_set_nullable (_tmp813_, FALSE);
					_vala_code_node_unref0 (resulting_type);
				}
			}
			_tmp814_ = vala_code_context_get_analyzer (context);
			_tmp815_ = _tmp814_;
			_tmp816_ = _tmp815_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp816_);
			break;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			ValaProfile _tmp817_;
			ValaProfile _tmp818_;
			gboolean _tmp887_ = FALSE;
			ValaExpression* _tmp888_;
			ValaExpression* _tmp889_;
			ValaDataType* _tmp890_;
			ValaDataType* _tmp891_;
			ValaExpression* _tmp892_;
			ValaExpression* _tmp893_;
			ValaDataType* _tmp894_;
			ValaDataType* _tmp895_;
			ValaDataType* resulting_type = NULL;
			ValaSemanticAnalyzer* _tmp918_;
			ValaSemanticAnalyzer* _tmp919_;
			ValaExpression* _tmp920_;
			ValaExpression* _tmp921_;
			ValaDataType* _tmp922_;
			ValaDataType* _tmp923_;
			ValaExpression* _tmp924_;
			ValaExpression* _tmp925_;
			ValaDataType* _tmp926_;
			ValaDataType* _tmp927_;
			ValaDataType* _tmp928_;
			ValaDataType* _tmp929_;
			ValaDataType* _tmp930_;
			ValaExpression* _tmp941_;
			ValaExpression* _tmp942_;
			ValaDataType* _tmp943_;
			ValaDataType* _tmp944_;
			ValaExpression* _tmp945_;
			ValaExpression* _tmp946_;
			ValaDataType* _tmp947_;
			ValaDataType* _tmp948_;
			ValaExpression* _tmp949_;
			ValaExpression* _tmp950_;
			ValaDataType* _tmp951_;
			ValaDataType* _tmp952_;
			gboolean _tmp953_;
			gboolean _tmp954_;
			ValaExpression* _tmp955_;
			ValaExpression* _tmp956_;
			ValaDataType* _tmp957_;
			ValaDataType* _tmp958_;
			gboolean _tmp959_;
			gboolean _tmp960_;
			ValaSemanticAnalyzer* _tmp969_;
			ValaSemanticAnalyzer* _tmp970_;
			ValaDataType* _tmp971_;
			_tmp817_ = vala_code_context_get_profile (context);
			_tmp818_ = _tmp817_;
			if (_tmp818_ == VALA_PROFILE_GOBJECT) {
				ValaTypeSymbol* gvalue_type = NULL;
				ValaSemanticAnalyzer* _tmp819_;
				ValaSemanticAnalyzer* _tmp820_;
				ValaStructValueType* _tmp821_;
				ValaTypeSymbol* _tmp822_;
				ValaTypeSymbol* _tmp823_;
				ValaTypeSymbol* _tmp824_;
				gboolean _tmp825_ = FALSE;
				gboolean _tmp826_ = FALSE;
				ValaExpression* _tmp827_;
				ValaExpression* _tmp828_;
				ValaDataType* _tmp829_;
				ValaDataType* _tmp830_;
				ValaTypeSymbol* _tmp831_;
				ValaTypeSymbol* _tmp832_;
				ValaTypeSymbol* _tmp833_;
				_tmp819_ = vala_code_context_get_analyzer (context);
				_tmp820_ = _tmp819_;
				_tmp821_ = _tmp820_->gvalue_type;
				_tmp822_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp821_);
				_tmp823_ = _tmp822_;
				_tmp824_ = _vala_code_node_ref0 (_tmp823_);
				gvalue_type = _tmp824_;
				_tmp827_ = vala_binary_expression_get_left (self);
				_tmp828_ = _tmp827_;
				_tmp829_ = vala_expression_get_target_type (_tmp828_);
				_tmp830_ = _tmp829_;
				_tmp831_ = vala_data_type_get_type_symbol (_tmp830_);
				_tmp832_ = _tmp831_;
				_tmp833_ = gvalue_type;
				if (_tmp832_ == _tmp833_) {
					ValaExpression* _tmp834_;
					ValaExpression* _tmp835_;
					ValaDataType* _tmp836_;
					ValaDataType* _tmp837_;
					ValaTypeSymbol* _tmp838_;
					ValaTypeSymbol* _tmp839_;
					ValaTypeSymbol* _tmp840_;
					_tmp834_ = vala_binary_expression_get_right (self);
					_tmp835_ = _tmp834_;
					_tmp836_ = vala_expression_get_target_type (_tmp835_);
					_tmp837_ = _tmp836_;
					_tmp838_ = vala_data_type_get_type_symbol (_tmp837_);
					_tmp839_ = _tmp838_;
					_tmp840_ = gvalue_type;
					_tmp826_ = _tmp839_ != _tmp840_;
				} else {
					_tmp826_ = FALSE;
				}
				if (_tmp826_) {
					_tmp825_ = TRUE;
				} else {
					gboolean _tmp841_ = FALSE;
					ValaExpression* _tmp842_;
					ValaExpression* _tmp843_;
					ValaDataType* _tmp844_;
					ValaDataType* _tmp845_;
					ValaTypeSymbol* _tmp846_;
					ValaTypeSymbol* _tmp847_;
					ValaTypeSymbol* _tmp848_;
					_tmp842_ = vala_binary_expression_get_left (self);
					_tmp843_ = _tmp842_;
					_tmp844_ = vala_expression_get_target_type (_tmp843_);
					_tmp845_ = _tmp844_;
					_tmp846_ = vala_data_type_get_type_symbol (_tmp845_);
					_tmp847_ = _tmp846_;
					_tmp848_ = gvalue_type;
					if (_tmp847_ != _tmp848_) {
						ValaExpression* _tmp849_;
						ValaExpression* _tmp850_;
						ValaDataType* _tmp851_;
						ValaDataType* _tmp852_;
						ValaTypeSymbol* _tmp853_;
						ValaTypeSymbol* _tmp854_;
						ValaTypeSymbol* _tmp855_;
						_tmp849_ = vala_binary_expression_get_right (self);
						_tmp850_ = _tmp849_;
						_tmp851_ = vala_expression_get_target_type (_tmp850_);
						_tmp852_ = _tmp851_;
						_tmp853_ = vala_data_type_get_type_symbol (_tmp852_);
						_tmp854_ = _tmp853_;
						_tmp855_ = gvalue_type;
						_tmp841_ = _tmp854_ == _tmp855_;
					} else {
						_tmp841_ = FALSE;
					}
					_tmp825_ = _tmp841_;
				}
				if (_tmp825_) {
					ValaExpression* gvalue_expr = NULL;
					ValaDataType* target_type = NULL;
					ValaExpression* _tmp856_;
					ValaExpression* _tmp857_;
					ValaDataType* _tmp858_;
					ValaDataType* _tmp859_;
					ValaTypeSymbol* _tmp860_;
					ValaTypeSymbol* _tmp861_;
					ValaTypeSymbol* _tmp862_;
					ValaCastExpression* cast_expr = NULL;
					ValaExpression* _tmp879_;
					ValaDataType* _tmp880_;
					ValaExpression* _tmp881_;
					ValaSourceReference* _tmp882_;
					ValaSourceReference* _tmp883_;
					ValaCastExpression* _tmp884_;
					ValaExpression* _tmp885_;
					ValaCastExpression* _tmp886_;
					_tmp856_ = vala_binary_expression_get_left (self);
					_tmp857_ = _tmp856_;
					_tmp858_ = vala_expression_get_target_type (_tmp857_);
					_tmp859_ = _tmp858_;
					_tmp860_ = vala_data_type_get_type_symbol (_tmp859_);
					_tmp861_ = _tmp860_;
					_tmp862_ = gvalue_type;
					if (_tmp861_ == _tmp862_) {
						ValaExpression* _tmp863_;
						ValaExpression* _tmp864_;
						ValaExpression* _tmp865_;
						ValaExpression* _tmp866_;
						ValaExpression* _tmp867_;
						ValaDataType* _tmp868_;
						ValaDataType* _tmp869_;
						ValaDataType* _tmp870_;
						_tmp863_ = vala_binary_expression_get_left (self);
						_tmp864_ = _tmp863_;
						_tmp865_ = _vala_code_node_ref0 (_tmp864_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp865_;
						_tmp866_ = vala_binary_expression_get_right (self);
						_tmp867_ = _tmp866_;
						_tmp868_ = vala_expression_get_target_type (_tmp867_);
						_tmp869_ = _tmp868_;
						_tmp870_ = _vala_code_node_ref0 (_tmp869_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp870_;
					} else {
						ValaExpression* _tmp871_;
						ValaExpression* _tmp872_;
						ValaExpression* _tmp873_;
						ValaExpression* _tmp874_;
						ValaExpression* _tmp875_;
						ValaDataType* _tmp876_;
						ValaDataType* _tmp877_;
						ValaDataType* _tmp878_;
						_tmp871_ = vala_binary_expression_get_right (self);
						_tmp872_ = _tmp871_;
						_tmp873_ = _vala_code_node_ref0 (_tmp872_);
						_vala_code_node_unref0 (gvalue_expr);
						gvalue_expr = _tmp873_;
						_tmp874_ = vala_binary_expression_get_left (self);
						_tmp875_ = _tmp874_;
						_tmp876_ = vala_expression_get_target_type (_tmp875_);
						_tmp877_ = _tmp876_;
						_tmp878_ = _vala_code_node_ref0 (_tmp877_);
						_vala_code_node_unref0 (target_type);
						target_type = _tmp878_;
					}
					_tmp879_ = gvalue_expr;
					_tmp880_ = target_type;
					_tmp881_ = gvalue_expr;
					_tmp882_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp881_);
					_tmp883_ = _tmp882_;
					_tmp884_ = vala_cast_expression_new (_tmp879_, _tmp880_, _tmp883_);
					cast_expr = _tmp884_;
					_tmp885_ = gvalue_expr;
					_tmp886_ = cast_expr;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp885_, (ValaExpression*) _tmp886_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					result = vala_code_node_check ((ValaCodeNode*) self, context);
					_vala_code_node_unref0 (cast_expr);
					_vala_code_node_unref0 (target_type);
					_vala_code_node_unref0 (gvalue_expr);
					_vala_code_node_unref0 (gvalue_type);
					return result;
				}
				_vala_code_node_unref0 (gvalue_type);
			}
			_tmp888_ = vala_binary_expression_get_right (self);
			_tmp889_ = _tmp888_;
			_tmp890_ = vala_expression_get_value_type (_tmp889_);
			_tmp891_ = _tmp890_;
			_tmp892_ = vala_binary_expression_get_left (self);
			_tmp893_ = _tmp892_;
			_tmp894_ = vala_expression_get_value_type (_tmp893_);
			_tmp895_ = _tmp894_;
			if (!vala_data_type_compatible (_tmp891_, _tmp895_)) {
				ValaExpression* _tmp896_;
				ValaExpression* _tmp897_;
				ValaDataType* _tmp898_;
				ValaDataType* _tmp899_;
				ValaExpression* _tmp900_;
				ValaExpression* _tmp901_;
				ValaDataType* _tmp902_;
				ValaDataType* _tmp903_;
				_tmp896_ = vala_binary_expression_get_left (self);
				_tmp897_ = _tmp896_;
				_tmp898_ = vala_expression_get_value_type (_tmp897_);
				_tmp899_ = _tmp898_;
				_tmp900_ = vala_binary_expression_get_right (self);
				_tmp901_ = _tmp900_;
				_tmp902_ = vala_expression_get_value_type (_tmp901_);
				_tmp903_ = _tmp902_;
				_tmp887_ = !vala_data_type_compatible (_tmp899_, _tmp903_);
			} else {
				_tmp887_ = FALSE;
			}
			if (_tmp887_) {
				ValaSourceReference* _tmp904_;
				ValaSourceReference* _tmp905_;
				ValaExpression* _tmp906_;
				ValaExpression* _tmp907_;
				ValaDataType* _tmp908_;
				ValaDataType* _tmp909_;
				gchar* _tmp910_;
				gchar* _tmp911_;
				ValaExpression* _tmp912_;
				ValaExpression* _tmp913_;
				ValaDataType* _tmp914_;
				ValaDataType* _tmp915_;
				gchar* _tmp916_;
				gchar* _tmp917_;
				_tmp904_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_binary_expression_get_right (self);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_expression_get_value_type (_tmp907_);
				_tmp909_ = _tmp908_;
				_tmp910_ = vala_code_node_to_string ((ValaCodeNode*) _tmp909_);
				_tmp911_ = _tmp910_;
				_tmp912_ = vala_binary_expression_get_left (self);
				_tmp913_ = _tmp912_;
				_tmp914_ = vala_expression_get_value_type (_tmp913_);
				_tmp915_ = _tmp914_;
				_tmp916_ = vala_code_node_to_string ((ValaCodeNode*) _tmp915_);
				_tmp917_ = _tmp916_;
				vala_report_error (_tmp905_, "Equality operation: `%s' and `%s' are incompatible", _tmp911_, _tmp917_);
				_g_free0 (_tmp917_);
				_g_free0 (_tmp911_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp918_ = vala_code_context_get_analyzer (context);
			_tmp919_ = _tmp918_;
			_tmp920_ = vala_binary_expression_get_left (self);
			_tmp921_ = _tmp920_;
			_tmp922_ = vala_expression_get_target_type (_tmp921_);
			_tmp923_ = _tmp922_;
			_tmp924_ = vala_binary_expression_get_right (self);
			_tmp925_ = _tmp924_;
			_tmp926_ = vala_expression_get_target_type (_tmp925_);
			_tmp927_ = _tmp926_;
			_tmp928_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp919_, _tmp923_, _tmp927_);
			_tmp929_ = _vala_code_node_ref0 (_tmp928_);
			resulting_type = _tmp929_;
			_tmp930_ = resulting_type;
			if (_tmp930_ != NULL) {
				ValaExpression* _tmp931_;
				ValaExpression* _tmp932_;
				ValaDataType* _tmp933_;
				ValaDataType* _tmp934_;
				ValaDataType* _tmp935_;
				ValaExpression* _tmp936_;
				ValaExpression* _tmp937_;
				ValaDataType* _tmp938_;
				ValaDataType* _tmp939_;
				ValaDataType* _tmp940_;
				_tmp931_ = vala_binary_expression_get_left (self);
				_tmp932_ = _tmp931_;
				_tmp933_ = resulting_type;
				_tmp934_ = vala_data_type_copy (_tmp933_);
				_tmp935_ = _tmp934_;
				vala_expression_set_target_type (_tmp932_, _tmp935_);
				_vala_code_node_unref0 (_tmp935_);
				_tmp936_ = vala_binary_expression_get_right (self);
				_tmp937_ = _tmp936_;
				_tmp938_ = resulting_type;
				_tmp939_ = vala_data_type_copy (_tmp938_);
				_tmp940_ = _tmp939_;
				vala_expression_set_target_type (_tmp937_, _tmp940_);
				_vala_code_node_unref0 (_tmp940_);
			}
			_tmp941_ = vala_binary_expression_get_left (self);
			_tmp942_ = _tmp941_;
			_tmp943_ = vala_expression_get_target_type (_tmp942_);
			_tmp944_ = _tmp943_;
			vala_data_type_set_value_owned (_tmp944_, FALSE);
			_tmp945_ = vala_binary_expression_get_right (self);
			_tmp946_ = _tmp945_;
			_tmp947_ = vala_expression_get_target_type (_tmp946_);
			_tmp948_ = _tmp947_;
			vala_data_type_set_value_owned (_tmp948_, FALSE);
			_tmp949_ = vala_binary_expression_get_left (self);
			_tmp950_ = _tmp949_;
			_tmp951_ = vala_expression_get_value_type (_tmp950_);
			_tmp952_ = _tmp951_;
			_tmp953_ = vala_data_type_get_nullable (_tmp952_);
			_tmp954_ = _tmp953_;
			_tmp955_ = vala_binary_expression_get_right (self);
			_tmp956_ = _tmp955_;
			_tmp957_ = vala_expression_get_value_type (_tmp956_);
			_tmp958_ = _tmp957_;
			_tmp959_ = vala_data_type_get_nullable (_tmp958_);
			_tmp960_ = _tmp959_;
			if (_tmp954_ != _tmp960_) {
				ValaExpression* _tmp961_;
				ValaExpression* _tmp962_;
				ValaDataType* _tmp963_;
				ValaDataType* _tmp964_;
				ValaExpression* _tmp965_;
				ValaExpression* _tmp966_;
				ValaDataType* _tmp967_;
				ValaDataType* _tmp968_;
				_tmp961_ = vala_binary_expression_get_left (self);
				_tmp962_ = _tmp961_;
				_tmp963_ = vala_expression_get_target_type (_tmp962_);
				_tmp964_ = _tmp963_;
				vala_data_type_set_nullable (_tmp964_, TRUE);
				_tmp965_ = vala_binary_expression_get_right (self);
				_tmp966_ = _tmp965_;
				_tmp967_ = vala_expression_get_target_type (_tmp966_);
				_tmp968_ = _tmp967_;
				vala_data_type_set_nullable (_tmp968_, TRUE);
			}
			_tmp969_ = vala_code_context_get_analyzer (context);
			_tmp970_ = _tmp969_;
			_tmp971_ = _tmp970_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp971_);
			_vala_code_node_unref0 (resulting_type);
			break;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			ValaExpression* _tmp972_;
			ValaExpression* _tmp973_;
			ValaDataType* _tmp974_;
			ValaDataType* _tmp975_;
			ValaExpression* _tmp976_;
			ValaExpression* _tmp977_;
			ValaDataType* _tmp978_;
			ValaDataType* _tmp979_;
			gboolean _tmp980_ = FALSE;
			ValaExpression* _tmp981_;
			ValaExpression* _tmp982_;
			ValaDataType* _tmp983_;
			ValaDataType* _tmp984_;
			ValaSemanticAnalyzer* _tmp985_;
			ValaSemanticAnalyzer* _tmp986_;
			ValaDataType* _tmp987_;
			_tmp972_ = vala_binary_expression_get_left (self);
			_tmp973_ = _tmp972_;
			_tmp974_ = vala_expression_get_target_type (_tmp973_);
			_tmp975_ = _tmp974_;
			vala_data_type_set_nullable (_tmp975_, FALSE);
			_tmp976_ = vala_binary_expression_get_right (self);
			_tmp977_ = _tmp976_;
			_tmp978_ = vala_expression_get_target_type (_tmp977_);
			_tmp979_ = _tmp978_;
			vala_data_type_set_nullable (_tmp979_, FALSE);
			_tmp981_ = vala_binary_expression_get_left (self);
			_tmp982_ = _tmp981_;
			_tmp983_ = vala_expression_get_value_type (_tmp982_);
			_tmp984_ = _tmp983_;
			_tmp985_ = vala_code_context_get_analyzer (context);
			_tmp986_ = _tmp985_;
			_tmp987_ = _tmp986_->bool_type;
			if (vala_data_type_compatible (_tmp984_, _tmp987_)) {
				ValaExpression* _tmp988_;
				ValaExpression* _tmp989_;
				ValaDataType* _tmp990_;
				ValaDataType* _tmp991_;
				ValaSemanticAnalyzer* _tmp992_;
				ValaSemanticAnalyzer* _tmp993_;
				ValaDataType* _tmp994_;
				_tmp988_ = vala_binary_expression_get_right (self);
				_tmp989_ = _tmp988_;
				_tmp990_ = vala_expression_get_value_type (_tmp989_);
				_tmp991_ = _tmp990_;
				_tmp992_ = vala_code_context_get_analyzer (context);
				_tmp993_ = _tmp992_;
				_tmp994_ = _tmp993_->bool_type;
				_tmp980_ = !vala_data_type_compatible (_tmp991_, _tmp994_);
			} else {
				_tmp980_ = FALSE;
			}
			if (_tmp980_) {
				ValaExpression* _tmp995_;
				ValaExpression* _tmp996_;
				ValaDataType* _tmp997_;
				ValaDataType* _tmp998_;
				ValaDataType* _tmp999_;
				ValaDataType* _tmp1000_;
				_tmp995_ = vala_binary_expression_get_right (self);
				_tmp996_ = _tmp995_;
				_tmp997_ = vala_expression_get_target_type (_tmp996_);
				_tmp998_ = _tmp997_;
				_tmp999_ = vala_data_type_copy (_tmp998_);
				_tmp1000_ = _tmp999_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1000_);
				_vala_code_node_unref0 (_tmp1000_);
			} else {
				ValaExpression* _tmp1001_;
				ValaExpression* _tmp1002_;
				ValaDataType* _tmp1003_;
				ValaDataType* _tmp1004_;
				ValaDataType* _tmp1005_;
				ValaDataType* _tmp1006_;
				_tmp1001_ = vala_binary_expression_get_left (self);
				_tmp1002_ = _tmp1001_;
				_tmp1003_ = vala_expression_get_target_type (_tmp1002_);
				_tmp1004_ = _tmp1003_;
				_tmp1005_ = vala_data_type_copy (_tmp1004_);
				_tmp1006_ = _tmp1005_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp1006_);
				_vala_code_node_unref0 (_tmp1006_);
			}
			break;
		}
		case VALA_BINARY_OPERATOR_AND:
		case VALA_BINARY_OPERATOR_OR:
		{
			gboolean _tmp1007_ = FALSE;
			ValaExpression* _tmp1008_;
			ValaExpression* _tmp1009_;
			ValaDataType* _tmp1010_;
			ValaDataType* _tmp1011_;
			ValaSemanticAnalyzer* _tmp1012_;
			ValaSemanticAnalyzer* _tmp1013_;
			ValaDataType* _tmp1014_;
			ValaExpression* _tmp1024_;
			ValaExpression* _tmp1025_;
			ValaDataType* _tmp1026_;
			ValaDataType* _tmp1027_;
			ValaExpression* _tmp1028_;
			ValaExpression* _tmp1029_;
			ValaDataType* _tmp1030_;
			ValaDataType* _tmp1031_;
			ValaSemanticAnalyzer* _tmp1032_;
			ValaSemanticAnalyzer* _tmp1033_;
			ValaDataType* _tmp1034_;
			_tmp1008_ = vala_binary_expression_get_left (self);
			_tmp1009_ = _tmp1008_;
			_tmp1010_ = vala_expression_get_value_type (_tmp1009_);
			_tmp1011_ = _tmp1010_;
			_tmp1012_ = vala_code_context_get_analyzer (context);
			_tmp1013_ = _tmp1012_;
			_tmp1014_ = _tmp1013_->bool_type;
			if (!vala_data_type_compatible (_tmp1011_, _tmp1014_)) {
				_tmp1007_ = TRUE;
			} else {
				ValaExpression* _tmp1015_;
				ValaExpression* _tmp1016_;
				ValaDataType* _tmp1017_;
				ValaDataType* _tmp1018_;
				ValaSemanticAnalyzer* _tmp1019_;
				ValaSemanticAnalyzer* _tmp1020_;
				ValaDataType* _tmp1021_;
				_tmp1015_ = vala_binary_expression_get_right (self);
				_tmp1016_ = _tmp1015_;
				_tmp1017_ = vala_expression_get_value_type (_tmp1016_);
				_tmp1018_ = _tmp1017_;
				_tmp1019_ = vala_code_context_get_analyzer (context);
				_tmp1020_ = _tmp1019_;
				_tmp1021_ = _tmp1020_->bool_type;
				_tmp1007_ = !vala_data_type_compatible (_tmp1018_, _tmp1021_);
			}
			if (_tmp1007_) {
				ValaSourceReference* _tmp1022_;
				ValaSourceReference* _tmp1023_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1022_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1023_ = _tmp1022_;
				vala_report_error (_tmp1023_, "Operands must be boolean");
			}
			_tmp1024_ = vala_binary_expression_get_left (self);
			_tmp1025_ = _tmp1024_;
			_tmp1026_ = vala_expression_get_target_type (_tmp1025_);
			_tmp1027_ = _tmp1026_;
			vala_data_type_set_nullable (_tmp1027_, FALSE);
			_tmp1028_ = vala_binary_expression_get_right (self);
			_tmp1029_ = _tmp1028_;
			_tmp1030_ = vala_expression_get_target_type (_tmp1029_);
			_tmp1031_ = _tmp1030_;
			vala_data_type_set_nullable (_tmp1031_, FALSE);
			_tmp1032_ = vala_code_context_get_analyzer (context);
			_tmp1033_ = _tmp1032_;
			_tmp1034_ = _tmp1033_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1034_);
			break;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			gboolean _tmp1035_ = FALSE;
			ValaExpression* _tmp1036_;
			ValaExpression* _tmp1037_;
			ValaDataType* _tmp1038_;
			ValaDataType* _tmp1039_;
			ValaSemanticAnalyzer* _tmp1040_;
			ValaSemanticAnalyzer* _tmp1041_;
			ValaDataType* _tmp1042_;
			ValaSemanticAnalyzer* _tmp1138_;
			ValaSemanticAnalyzer* _tmp1139_;
			ValaDataType* _tmp1140_;
			_tmp1036_ = vala_binary_expression_get_left (self);
			_tmp1037_ = _tmp1036_;
			_tmp1038_ = vala_expression_get_value_type (_tmp1037_);
			_tmp1039_ = _tmp1038_;
			_tmp1040_ = vala_code_context_get_analyzer (context);
			_tmp1041_ = _tmp1040_;
			_tmp1042_ = _tmp1041_->int_type;
			if (vala_data_type_compatible (_tmp1039_, _tmp1042_)) {
				ValaExpression* _tmp1043_;
				ValaExpression* _tmp1044_;
				ValaDataType* _tmp1045_;
				ValaDataType* _tmp1046_;
				ValaSemanticAnalyzer* _tmp1047_;
				ValaSemanticAnalyzer* _tmp1048_;
				ValaDataType* _tmp1049_;
				_tmp1043_ = vala_binary_expression_get_right (self);
				_tmp1044_ = _tmp1043_;
				_tmp1045_ = vala_expression_get_value_type (_tmp1044_);
				_tmp1046_ = _tmp1045_;
				_tmp1047_ = vala_code_context_get_analyzer (context);
				_tmp1048_ = _tmp1047_;
				_tmp1049_ = _tmp1048_->int_type;
				_tmp1035_ = vala_data_type_compatible (_tmp1046_, _tmp1049_);
			} else {
				_tmp1035_ = FALSE;
			}
			if (_tmp1035_) {
				ValaExpression* _tmp1050_;
				ValaExpression* _tmp1051_;
				ValaDataType* _tmp1052_;
				ValaDataType* _tmp1053_;
				ValaExpression* _tmp1054_;
				ValaExpression* _tmp1055_;
				ValaDataType* _tmp1056_;
				ValaDataType* _tmp1057_;
				_tmp1050_ = vala_binary_expression_get_left (self);
				_tmp1051_ = _tmp1050_;
				_tmp1052_ = vala_expression_get_target_type (_tmp1051_);
				_tmp1053_ = _tmp1052_;
				vala_data_type_set_nullable (_tmp1053_, FALSE);
				_tmp1054_ = vala_binary_expression_get_right (self);
				_tmp1055_ = _tmp1054_;
				_tmp1056_ = vala_expression_get_target_type (_tmp1055_);
				_tmp1057_ = _tmp1056_;
				vala_data_type_set_nullable (_tmp1057_, FALSE);
			} else {
				ValaExpression* _tmp1058_;
				ValaExpression* _tmp1059_;
				ValaDataType* _tmp1060_;
				ValaDataType* _tmp1061_;
				_tmp1058_ = vala_binary_expression_get_right (self);
				_tmp1059_ = _tmp1058_;
				_tmp1060_ = vala_expression_get_value_type (_tmp1059_);
				_tmp1061_ = _tmp1060_;
				if (VALA_IS_ARRAY_TYPE (_tmp1061_)) {
					ValaExpression* _tmp1062_;
					ValaExpression* _tmp1063_;
					ValaDataType* _tmp1064_;
					ValaDataType* _tmp1065_;
					ValaExpression* _tmp1066_;
					ValaExpression* _tmp1067_;
					ValaDataType* _tmp1068_;
					ValaDataType* _tmp1069_;
					ValaDataType* _tmp1070_;
					ValaDataType* _tmp1071_;
					_tmp1062_ = vala_binary_expression_get_left (self);
					_tmp1063_ = _tmp1062_;
					_tmp1064_ = vala_expression_get_value_type (_tmp1063_);
					_tmp1065_ = _tmp1064_;
					_tmp1066_ = vala_binary_expression_get_right (self);
					_tmp1067_ = _tmp1066_;
					_tmp1068_ = vala_expression_get_value_type (_tmp1067_);
					_tmp1069_ = _tmp1068_;
					_tmp1070_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1069_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp1071_ = _tmp1070_;
					if (!vala_data_type_compatible (_tmp1065_, _tmp1071_)) {
						ValaSourceReference* _tmp1072_;
						ValaSourceReference* _tmp1073_;
						ValaExpression* _tmp1074_;
						ValaExpression* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						gchar* _tmp1078_;
						gchar* _tmp1079_;
						ValaExpression* _tmp1080_;
						ValaExpression* _tmp1081_;
						ValaDataType* _tmp1082_;
						ValaDataType* _tmp1083_;
						gchar* _tmp1084_;
						gchar* _tmp1085_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1072_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1073_ = _tmp1072_;
						_tmp1074_ = vala_binary_expression_get_left (self);
						_tmp1075_ = _tmp1074_;
						_tmp1076_ = vala_expression_get_value_type (_tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1078_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1077_);
						_tmp1079_ = _tmp1078_;
						_tmp1080_ = vala_binary_expression_get_right (self);
						_tmp1081_ = _tmp1080_;
						_tmp1082_ = vala_expression_get_value_type (_tmp1081_);
						_tmp1083_ = _tmp1082_;
						_tmp1084_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1083_);
						_tmp1085_ = _tmp1084_;
						vala_report_error (_tmp1073_, "Cannot look for `%s' in `%s'", _tmp1079_, _tmp1085_);
						_g_free0 (_tmp1085_);
						_g_free0 (_tmp1079_);
					}
				} else {
					ValaMethod* contains_method = NULL;
					ValaExpression* _tmp1086_;
					ValaExpression* _tmp1087_;
					ValaDataType* _tmp1088_;
					ValaDataType* _tmp1089_;
					ValaSymbol* _tmp1090_;
					ValaMethod* _tmp1091_;
					ValaMethod* _tmp1092_;
					ValaMethod* _tmp1101_;
					ValaList* _tmp1102_;
					gint _tmp1103_;
					gint _tmp1104_;
					ValaMethod* _tmp1110_;
					ValaDataType* _tmp1111_;
					ValaDataType* _tmp1112_;
					ValaSemanticAnalyzer* _tmp1113_;
					ValaSemanticAnalyzer* _tmp1114_;
					ValaDataType* _tmp1115_;
					ValaMethodCall* contains_call = NULL;
					ValaExpression* _tmp1121_;
					ValaExpression* _tmp1122_;
					ValaSourceReference* _tmp1123_;
					ValaSourceReference* _tmp1124_;
					ValaMemberAccess* _tmp1125_;
					ValaMemberAccess* _tmp1126_;
					ValaSourceReference* _tmp1127_;
					ValaSourceReference* _tmp1128_;
					ValaMethodCall* _tmp1129_;
					ValaMethodCall* _tmp1130_;
					ValaMethodCall* _tmp1131_;
					ValaExpression* _tmp1132_;
					ValaExpression* _tmp1133_;
					ValaCodeNode* _tmp1134_;
					ValaCodeNode* _tmp1135_;
					ValaMethodCall* _tmp1136_;
					ValaMethodCall* _tmp1137_;
					_tmp1086_ = vala_binary_expression_get_right (self);
					_tmp1087_ = _tmp1086_;
					_tmp1088_ = vala_expression_get_value_type (_tmp1087_);
					_tmp1089_ = _tmp1088_;
					_tmp1090_ = vala_data_type_get_member (_tmp1089_, "contains");
					_tmp1091_ = VALA_IS_METHOD (_tmp1090_) ? ((ValaMethod*) _tmp1090_) : NULL;
					if (_tmp1091_ == NULL) {
						_vala_code_node_unref0 (_tmp1090_);
					}
					contains_method = _tmp1091_;
					_tmp1092_ = contains_method;
					if (_tmp1092_ == NULL) {
						ValaSourceReference* _tmp1093_;
						ValaSourceReference* _tmp1094_;
						ValaExpression* _tmp1095_;
						ValaExpression* _tmp1096_;
						ValaDataType* _tmp1097_;
						ValaDataType* _tmp1098_;
						gchar* _tmp1099_;
						gchar* _tmp1100_;
						_tmp1093_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1094_ = _tmp1093_;
						_tmp1095_ = vala_binary_expression_get_right (self);
						_tmp1096_ = _tmp1095_;
						_tmp1097_ = vala_expression_get_value_type (_tmp1096_);
						_tmp1098_ = _tmp1097_;
						_tmp1099_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1098_);
						_tmp1100_ = _tmp1099_;
						vala_report_error (_tmp1094_, "`%s' does not have a `contains' method", _tmp1100_);
						_g_free0 (_tmp1100_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1101_ = contains_method;
					_tmp1102_ = vala_callable_get_parameters ((ValaCallable*) _tmp1101_);
					_tmp1103_ = vala_collection_get_size ((ValaCollection*) _tmp1102_);
					_tmp1104_ = _tmp1103_;
					if (_tmp1104_ != 1) {
						ValaSourceReference* _tmp1105_;
						ValaSourceReference* _tmp1106_;
						ValaMethod* _tmp1107_;
						gchar* _tmp1108_;
						gchar* _tmp1109_;
						_tmp1105_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1106_ = _tmp1105_;
						_tmp1107_ = contains_method;
						_tmp1108_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1107_);
						_tmp1109_ = _tmp1108_;
						vala_report_error (_tmp1106_, "`%s' must have one parameter", _tmp1109_);
						_g_free0 (_tmp1109_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1110_ = contains_method;
					_tmp1111_ = vala_callable_get_return_type ((ValaCallable*) _tmp1110_);
					_tmp1112_ = _tmp1111_;
					_tmp1113_ = vala_code_context_get_analyzer (context);
					_tmp1114_ = _tmp1113_;
					_tmp1115_ = _tmp1114_->bool_type;
					if (!vala_data_type_compatible (_tmp1112_, _tmp1115_)) {
						ValaSourceReference* _tmp1116_;
						ValaSourceReference* _tmp1117_;
						ValaMethod* _tmp1118_;
						gchar* _tmp1119_;
						gchar* _tmp1120_;
						_tmp1116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1117_ = _tmp1116_;
						_tmp1118_ = contains_method;
						_tmp1119_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1118_);
						_tmp1120_ = _tmp1119_;
						vala_report_error (_tmp1117_, "`%s' must return a boolean value", _tmp1120_);
						_g_free0 (_tmp1120_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_vala_code_node_unref0 (contains_method);
						return result;
					}
					_tmp1121_ = vala_binary_expression_get_right (self);
					_tmp1122_ = _tmp1121_;
					_tmp1123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1124_ = _tmp1123_;
					_tmp1125_ = vala_member_access_new (_tmp1122_, "contains", _tmp1124_);
					_tmp1126_ = _tmp1125_;
					_tmp1127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1128_ = _tmp1127_;
					_tmp1129_ = vala_method_call_new ((ValaExpression*) _tmp1126_, _tmp1128_);
					_tmp1130_ = _tmp1129_;
					_vala_code_node_unref0 (_tmp1126_);
					contains_call = _tmp1130_;
					_tmp1131_ = contains_call;
					_tmp1132_ = vala_binary_expression_get_left (self);
					_tmp1133_ = _tmp1132_;
					vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp1131_, _tmp1133_);
					_tmp1134_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp1135_ = _tmp1134_;
					_tmp1136_ = contains_call;
					vala_code_node_replace_expression (_tmp1135_, (ValaExpression*) self, (ValaExpression*) _tmp1136_);
					_tmp1137_ = contains_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp1137_, context);
					_vala_code_node_unref0 (contains_call);
					_vala_code_node_unref0 (contains_method);
					return result;
				}
			}
			_tmp1138_ = vala_code_context_get_analyzer (context);
			_tmp1139_ = _tmp1138_;
			_tmp1140_ = _tmp1139_->bool_type;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1140_);
			break;
		}
		default:
		{
			ValaSourceReference* _tmp1141_;
			ValaSourceReference* _tmp1142_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1142_ = _tmp1141_;
			vala_report_error (_tmp1142_, "internal error: unsupported binary operator");
			result = FALSE;
			return result;
		}
	}
	_tmp1143_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1144_ = _tmp1143_;
	vala_code_node_check ((ValaCodeNode*) _tmp1144_, context);
	_tmp1145_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1146_ = _tmp1145_;
	result = !_tmp1146_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self,
                                      gpointer klass)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
static GType
vala_binary_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
	GType vala_binary_expression_type_id;
	vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
	ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
	return vala_binary_expression_type_id;
}

GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = vala_binary_expression_get_type_once ();
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_binary_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
	GType vala_binary_operator_type_id;
	vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
	return vala_binary_operator_type_id;
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = vala_binary_operator_get_type_once ();
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

