/* valagobjectmodule.c generated by valac, the Vala compiler
 * generated from valagobjectmodule.vala, do not modify */

/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <glib.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};

static gint ValaGObjectModule_private_offset;
static gpointer vala_gobject_module_parent_class = NULL;

static void vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                           ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                                   ValaClass* cl);
static void vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                                 ValaSymbol* sym,
                                                 ValaCCodeExpression* expression);
static void vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                                 ValaConstructor* c);
static gchar* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                          ValaDynamicSignal* node);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                         ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                           ValaDynamicSignal* sig,
                                                           gboolean after);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                               ValaDynamicSignal* sig);
static void vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                              ValaProperty* prop);
static void vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void vala_gobject_module_finalize (ValaCodeVisitor * obj);
static GType vala_gobject_module_get_type_once (void);

static inline gpointer
vala_gobject_module_get_instance_private (ValaGObjectModule* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGObjectModule_private_offset);
}

static void
vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                      ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), cl);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp2_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp3_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp4_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                              ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp20_ = FALSE;
	ValaConstructor* _tmp32_;
	ValaConstructor* _tmp33_;
	gboolean _tmp52_ = FALSE;
	ValaList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	ValaList* props = NULL;
	ValaList* _tmp225_;
	ValaList* _tmp226_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_ccode_node_unref0 (_tmp2_);
	ccall = _tmp4_;
	_tmp5_ = ccall;
	_tmp6_ = vala_ccode_identifier_new ("klass");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (_tmp5_, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp9_;
		ValaCCodeFunction* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_;
		ValaCCodeMemberAccess* _tmp12_;
		ValaCCodeMemberAccess* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeIdentifier* _tmp18_;
		ValaCCodeIdentifier* _tmp19_;
		_tmp9_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ccall;
		_tmp12_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp11_, "get_property");
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("_vala_%s_get_property", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_identifier_new (_tmp17_);
		_tmp19_ = _tmp18_;
		vala_ccode_function_add_assignment (_tmp10_, (ValaCCodeExpression*) _tmp13_, (ValaCCodeExpression*) _tmp19_);
		_vala_ccode_node_unref0 (_tmp19_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		_vala_ccode_node_unref0 (_tmp13_);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) cl);
	}
	if (_tmp20_) {
		ValaCCodeFunction* _tmp21_;
		ValaCCodeFunction* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeMemberAccess* _tmp24_;
		ValaCCodeMemberAccess* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		_tmp21_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = ccall;
		_tmp24_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp23_, "set_property");
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("_vala_%s_set_property", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_ccode_function_add_assignment (_tmp22_, (ValaCCodeExpression*) _tmp25_, (ValaCCodeExpression*) _tmp31_);
		_vala_ccode_node_unref0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_vala_ccode_node_unref0 (_tmp25_);
	}
	_tmp32_ = vala_class_get_constructor (cl);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp34_;
		ValaCCodeIdentifier* _tmp35_;
		ValaCCodeFunctionCall* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeIdentifier* _tmp40_;
		ValaCCodeFunction* _tmp41_;
		ValaCCodeFunction* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaCCodeMemberAccess* _tmp44_;
		ValaCCodeMemberAccess* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		ValaCCodeIdentifier* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		_tmp34_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
		_tmp37_ = _tmp36_;
		_vala_ccode_node_unref0 (_tmp35_);
		ccast = _tmp37_;
		_tmp38_ = ccast;
		_tmp39_ = vala_ccode_identifier_new ("klass");
		_tmp40_ = _tmp39_;
		vala_ccode_function_call_add_argument (_tmp38_, (ValaCCodeExpression*) _tmp40_);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = ccast;
		_tmp44_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp43_, "constructor");
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) cl);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf ("%sconstructor", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_ccode_identifier_new (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_ccode_function_add_assignment (_tmp42_, (ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp51_);
		_vala_ccode_node_unref0 (_tmp51_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_vala_ccode_node_unref0 (_tmp45_);
		_vala_ccode_node_unref0 (ccast);
	}
	_tmp53_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_ > 0) {
		_tmp52_ = TRUE;
	} else {
		ValaDestructor* _tmp56_;
		ValaDestructor* _tmp57_;
		_tmp56_ = vala_class_get_destructor (cl);
		_tmp57_ = _tmp56_;
		_tmp52_ = _tmp57_ != NULL;
	}
	if (_tmp52_) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeFunctionCall* _tmp60_;
		ValaCCodeFunctionCall* _tmp61_;
		ValaCCodeFunctionCall* _tmp62_;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunction* _tmp65_;
		ValaCCodeFunction* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeMemberAccess* _tmp68_;
		ValaCCodeMemberAccess* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeIdentifier* _tmp75_;
		_tmp58_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp59_);
		_tmp61_ = _tmp60_;
		_vala_ccode_node_unref0 (_tmp59_);
		ccast = _tmp61_;
		_tmp62_ = ccast;
		_tmp63_ = vala_ccode_identifier_new ("klass");
		_tmp64_ = _tmp63_;
		vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp64_);
		_vala_ccode_node_unref0 (_tmp64_);
		_tmp65_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = ccast;
		_tmp68_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp67_, "finalize");
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) cl);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup_printf ("%sfinalize", _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_ccode_identifier_new (_tmp73_);
		_tmp75_ = _tmp74_;
		vala_ccode_function_add_assignment (_tmp66_, (ValaCCodeExpression*) _tmp69_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (_tmp75_);
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_vala_ccode_node_unref0 (_tmp69_);
		_vala_ccode_node_unref0 (ccast);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp76_;
		gint _type_param_size = 0;
		ValaList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _type_param_index = 0;
		_tmp76_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp76_;
		_tmp77_ = _type_param_list;
		_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		_type_param_size = _tmp79_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp80_;
			gint _tmp81_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp82_;
			gpointer _tmp83_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeConstant* func_name_constant = NULL;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeFunctionCall* cspec = NULL;
			gchar* name_prefix = NULL;
			ValaTypeParameter* _tmp84_;
			const gchar* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* canonical_prefix = NULL;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			const gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaCCodeConstant* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeIdentifier* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			ValaCCodeFunctionCall* _tmp106_;
			ValaCCodeFunctionCall* _tmp107_;
			const gchar* _tmp108_;
			ValaCCodeConstant* _tmp109_;
			ValaCCodeConstant* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaCCodeFunctionCall* _tmp114_;
			ValaCCodeConstant* _tmp115_;
			ValaCCodeFunctionCall* _tmp116_;
			ValaCCodeConstant* _tmp117_;
			ValaCCodeConstant* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			ValaCCodeConstant* _tmp120_;
			ValaCCodeConstant* _tmp121_;
			ValaCCodeFunctionCall* _tmp122_;
			ValaCCodeIdentifier* _tmp123_;
			ValaCCodeIdentifier* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeFunctionCall* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeFunction* _tmp130_;
			ValaCCodeFunction* _tmp131_;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeEnum* _tmp133_;
			const gchar* _tmp134_;
			ValaCCodeEnumValue* _tmp135_;
			ValaCCodeEnumValue* _tmp136_;
			const gchar* _tmp137_;
			gchar* _tmp138_;
			const gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			ValaCCodeConstant* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			const gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeIdentifier* _tmp150_;
			ValaCCodeFunctionCall* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeFunctionCall* _tmp153_;
			ValaCCodeFunctionCall* _tmp154_;
			const gchar* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeIdentifier* _tmp158_;
			ValaCCodeIdentifier* _tmp159_;
			ValaCCodeFunctionCall* _tmp160_;
			ValaCCodeFunctionCall* _tmp161_;
			ValaCCodeConstant* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeConstant* _tmp164_;
			ValaCCodeConstant* _tmp165_;
			ValaCCodeFunctionCall* _tmp166_;
			ValaCCodeConstant* _tmp167_;
			ValaCCodeConstant* _tmp168_;
			ValaCCodeFunctionCall* _tmp169_;
			ValaCCodeConstant* _tmp170_;
			ValaCCodeConstant* _tmp171_;
			ValaCCodeFunctionCall* _tmp172_;
			ValaCCodeFunctionCall* _tmp173_;
			ValaCCodeFunction* _tmp174_;
			ValaCCodeFunction* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeEnum* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeEnumValue* _tmp179_;
			ValaCCodeEnumValue* _tmp180_;
			const gchar* _tmp181_;
			gchar* _tmp182_;
			const gchar* _tmp183_;
			gchar* _tmp184_;
			gchar* _tmp185_;
			ValaCCodeConstant* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			const gchar* _tmp189_;
			gchar* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			ValaCCodeIdentifier* _tmp193_;
			ValaCCodeIdentifier* _tmp194_;
			ValaCCodeFunctionCall* _tmp195_;
			ValaCCodeFunctionCall* _tmp196_;
			ValaCCodeFunctionCall* _tmp197_;
			ValaCCodeFunctionCall* _tmp198_;
			const gchar* _tmp199_;
			ValaCCodeConstant* _tmp200_;
			ValaCCodeConstant* _tmp201_;
			ValaCCodeIdentifier* _tmp202_;
			ValaCCodeIdentifier* _tmp203_;
			ValaCCodeFunctionCall* _tmp204_;
			ValaCCodeFunctionCall* _tmp205_;
			ValaCCodeConstant* _tmp206_;
			ValaCCodeFunctionCall* _tmp207_;
			ValaCCodeConstant* _tmp208_;
			ValaCCodeConstant* _tmp209_;
			ValaCCodeFunctionCall* _tmp210_;
			ValaCCodeConstant* _tmp211_;
			ValaCCodeConstant* _tmp212_;
			ValaCCodeFunctionCall* _tmp213_;
			ValaCCodeConstant* _tmp214_;
			ValaCCodeConstant* _tmp215_;
			ValaCCodeFunctionCall* _tmp216_;
			ValaCCodeFunctionCall* _tmp217_;
			ValaCCodeFunction* _tmp218_;
			ValaCCodeFunction* _tmp219_;
			ValaCCodeFunctionCall* _tmp220_;
			ValaCCodeEnum* _tmp221_;
			const gchar* _tmp222_;
			ValaCCodeEnumValue* _tmp223_;
			ValaCCodeEnumValue* _tmp224_;
			_type_param_index = _type_param_index + 1;
			_tmp80_ = _type_param_index;
			_tmp81_ = _type_param_size;
			if (!(_tmp80_ < _tmp81_)) {
				break;
			}
			_tmp82_ = _type_param_list;
			_tmp83_ = vala_list_get (_tmp82_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp83_;
			_tmp84_ = type_param;
			_tmp85_ = vala_symbol_get_name ((ValaSymbol*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_ascii_strdown (_tmp86_, (gssize) -1);
			name_prefix = _tmp87_;
			_tmp88_ = name_prefix;
			_tmp89_ = string_replace (_tmp88_, "_", "-");
			canonical_prefix = _tmp89_;
			_tmp90_ = name_prefix;
			_tmp91_ = g_strdup_printf ("%s_type", _tmp90_);
			_g_free0 (func_name);
			func_name = _tmp91_;
			_tmp92_ = canonical_prefix;
			_tmp93_ = g_strdup_printf ("\"%s-type\"", _tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_ccode_constant_new (_tmp94_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp95_;
			_g_free0 (_tmp94_);
			_tmp96_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp97_ = _tmp96_;
			_tmp98_ = func_name;
			_tmp99_ = g_strdup_printf ("%s_%s", _tmp97_, _tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = g_ascii_strup (_tmp100_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp101_;
			_g_free0 (_tmp100_);
			_g_free0 (_tmp97_);
			_tmp102_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp103_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp104_;
			_vala_ccode_node_unref0 (_tmp103_);
			_tmp105_ = cinst;
			_tmp106_ = ccall;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp106_);
			_tmp107_ = cinst;
			_tmp108_ = enum_value;
			_tmp109_ = vala_ccode_constant_new (_tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_tmp111_ = vala_ccode_identifier_new ("g_param_spec_gtype");
			_tmp112_ = _tmp111_;
			_tmp113_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp112_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp113_;
			_vala_ccode_node_unref0 (_tmp112_);
			_tmp114_ = cspec;
			_tmp115_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp114_, (ValaCCodeExpression*) _tmp115_);
			_tmp116_ = cspec;
			_tmp117_ = vala_ccode_constant_new ("\"type\"");
			_tmp118_ = _tmp117_;
			vala_ccode_function_call_add_argument (_tmp116_, (ValaCCodeExpression*) _tmp118_);
			_vala_ccode_node_unref0 (_tmp118_);
			_tmp119_ = cspec;
			_tmp120_ = vala_ccode_constant_new ("\"type\"");
			_tmp121_ = _tmp120_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp121_);
			_vala_ccode_node_unref0 (_tmp121_);
			_tmp122_ = cspec;
			_tmp123_ = vala_ccode_identifier_new ("G_TYPE_NONE");
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_tmp125_ = cspec;
			_tmp126_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = cinst;
			_tmp129_ = cspec;
			vala_ccode_function_call_add_argument (_tmp128_, (ValaCCodeExpression*) _tmp129_);
			_tmp130_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp131_ = _tmp130_;
			_tmp132_ = cinst;
			vala_ccode_function_add_expression (_tmp131_, (ValaCCodeExpression*) _tmp132_);
			_tmp133_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp134_ = enum_value;
			_tmp135_ = vala_ccode_enum_value_new (_tmp134_, NULL);
			_tmp136_ = _tmp135_;
			vala_ccode_enum_add_value (_tmp133_, _tmp136_);
			_vala_ccode_node_unref0 (_tmp136_);
			_tmp137_ = name_prefix;
			_tmp138_ = g_strdup_printf ("%s_dup_func", _tmp137_);
			_g_free0 (func_name);
			func_name = _tmp138_;
			_tmp139_ = canonical_prefix;
			_tmp140_ = g_strdup_printf ("\"%s-dup-func\"", _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_ccode_constant_new (_tmp141_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp142_;
			_g_free0 (_tmp141_);
			_tmp143_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp144_ = _tmp143_;
			_tmp145_ = func_name;
			_tmp146_ = g_strdup_printf ("%s_%s", _tmp144_, _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = g_ascii_strup (_tmp147_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp148_;
			_g_free0 (_tmp147_);
			_g_free0 (_tmp144_);
			_tmp149_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp150_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp151_;
			_vala_ccode_node_unref0 (_tmp150_);
			_tmp152_ = cinst;
			_tmp153_ = ccall;
			vala_ccode_function_call_add_argument (_tmp152_, (ValaCCodeExpression*) _tmp153_);
			_tmp154_ = cinst;
			_tmp155_ = enum_value;
			_tmp156_ = vala_ccode_constant_new (_tmp155_);
			_tmp157_ = _tmp156_;
			vala_ccode_function_call_add_argument (_tmp154_, (ValaCCodeExpression*) _tmp157_);
			_vala_ccode_node_unref0 (_tmp157_);
			_tmp158_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp160_;
			_vala_ccode_node_unref0 (_tmp159_);
			_tmp161_ = cspec;
			_tmp162_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp161_, (ValaCCodeExpression*) _tmp162_);
			_tmp163_ = cspec;
			_tmp164_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp165_ = _tmp164_;
			vala_ccode_function_call_add_argument (_tmp163_, (ValaCCodeExpression*) _tmp165_);
			_vala_ccode_node_unref0 (_tmp165_);
			_tmp166_ = cspec;
			_tmp167_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp166_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = cspec;
			_tmp170_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp171_ = _tmp170_;
			vala_ccode_function_call_add_argument (_tmp169_, (ValaCCodeExpression*) _tmp171_);
			_vala_ccode_node_unref0 (_tmp171_);
			_tmp172_ = cinst;
			_tmp173_ = cspec;
			vala_ccode_function_call_add_argument (_tmp172_, (ValaCCodeExpression*) _tmp173_);
			_tmp174_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp175_ = _tmp174_;
			_tmp176_ = cinst;
			vala_ccode_function_add_expression (_tmp175_, (ValaCCodeExpression*) _tmp176_);
			_tmp177_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp178_ = enum_value;
			_tmp179_ = vala_ccode_enum_value_new (_tmp178_, NULL);
			_tmp180_ = _tmp179_;
			vala_ccode_enum_add_value (_tmp177_, _tmp180_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp181_ = name_prefix;
			_tmp182_ = g_strdup_printf ("%s_destroy_func", _tmp181_);
			_g_free0 (func_name);
			func_name = _tmp182_;
			_tmp183_ = canonical_prefix;
			_tmp184_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = vala_ccode_constant_new (_tmp185_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp186_;
			_g_free0 (_tmp185_);
			_tmp187_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp188_ = _tmp187_;
			_tmp189_ = func_name;
			_tmp190_ = g_strdup_printf ("%s_%s", _tmp188_, _tmp189_);
			_tmp191_ = _tmp190_;
			_tmp192_ = g_ascii_strup (_tmp191_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp192_;
			_g_free0 (_tmp191_);
			_g_free0 (_tmp188_);
			_tmp193_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp194_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp195_;
			_vala_ccode_node_unref0 (_tmp194_);
			_tmp196_ = cinst;
			_tmp197_ = ccall;
			vala_ccode_function_call_add_argument (_tmp196_, (ValaCCodeExpression*) _tmp197_);
			_tmp198_ = cinst;
			_tmp199_ = enum_value;
			_tmp200_ = vala_ccode_constant_new (_tmp199_);
			_tmp201_ = _tmp200_;
			vala_ccode_function_call_add_argument (_tmp198_, (ValaCCodeExpression*) _tmp201_);
			_vala_ccode_node_unref0 (_tmp201_);
			_tmp202_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp203_ = _tmp202_;
			_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp204_;
			_vala_ccode_node_unref0 (_tmp203_);
			_tmp205_ = cspec;
			_tmp206_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp205_, (ValaCCodeExpression*) _tmp206_);
			_tmp207_ = cspec;
			_tmp208_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp209_ = _tmp208_;
			vala_ccode_function_call_add_argument (_tmp207_, (ValaCCodeExpression*) _tmp209_);
			_vala_ccode_node_unref0 (_tmp209_);
			_tmp210_ = cspec;
			_tmp211_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp212_ = _tmp211_;
			vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
			_vala_ccode_node_unref0 (_tmp212_);
			_tmp213_ = cspec;
			_tmp214_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY");
			_tmp215_ = _tmp214_;
			vala_ccode_function_call_add_argument (_tmp213_, (ValaCCodeExpression*) _tmp215_);
			_vala_ccode_node_unref0 (_tmp215_);
			_tmp216_ = cinst;
			_tmp217_ = cspec;
			vala_ccode_function_call_add_argument (_tmp216_, (ValaCCodeExpression*) _tmp217_);
			_tmp218_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp219_ = _tmp218_;
			_tmp220_ = cinst;
			vala_ccode_function_add_expression (_tmp219_, (ValaCCodeExpression*) _tmp220_);
			_tmp221_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp222_ = enum_value;
			_tmp223_ = vala_ccode_enum_value_new (_tmp222_, NULL);
			_tmp224_ = _tmp223_;
			vala_ccode_enum_add_value (_tmp221_, _tmp224_);
			_vala_ccode_node_unref0 (_tmp224_);
			_g_free0 (canonical_prefix);
			_g_free0 (name_prefix);
			_vala_ccode_node_unref0 (cspec);
			_vala_ccode_node_unref0 (cinst);
			_vala_ccode_node_unref0 (func_name_constant);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
	}
	_tmp225_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp226_ = _vala_iterable_ref0 (_tmp225_);
	props = _tmp226_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp227_;
		gint _prop_size = 0;
		ValaList* _tmp228_;
		gint _tmp229_;
		gint _tmp230_;
		gint _prop_index = 0;
		_tmp227_ = props;
		_prop_list = _tmp227_;
		_tmp228_ = _prop_list;
		_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
		_tmp230_ = _tmp229_;
		_prop_size = _tmp230_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp231_;
			gint _tmp232_;
			ValaProperty* prop = NULL;
			ValaList* _tmp233_;
			gpointer _tmp234_;
			ValaCodeContext* _tmp235_;
			ValaCodeContext* _tmp236_;
			ValaSemanticAnalyzer* _tmp237_;
			ValaSemanticAnalyzer* _tmp238_;
			ValaProperty* _tmp239_;
			ValaProperty* _tmp255_;
			ValaComment* _tmp256_;
			ValaComment* _tmp257_;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeIdentifier* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeFunctionCall* _tmp269_;
			ValaCCodeFunctionCall* _tmp270_;
			ValaCCodeFunctionCall* _tmp271_;
			ValaCCodeFunctionCall* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaProperty* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			ValaCCodeConstant* _tmp279_;
			ValaCCodeConstant* _tmp280_;
			ValaCCodeFunctionCall* _tmp281_;
			ValaProperty* _tmp282_;
			ValaCCodeExpression* _tmp283_;
			ValaCCodeExpression* _tmp284_;
			ValaCCodeFunction* _tmp285_;
			ValaCCodeFunction* _tmp286_;
			ValaCCodeFunctionCall* _tmp287_;
			_prop_index = _prop_index + 1;
			_tmp231_ = _prop_index;
			_tmp232_ = _prop_size;
			if (!(_tmp231_ < _tmp232_)) {
				break;
			}
			_tmp233_ = _prop_list;
			_tmp234_ = vala_list_get (_tmp233_, _prop_index);
			prop = (ValaProperty*) _tmp234_;
			_tmp235_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_code_context_get_analyzer (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp239_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp238_, _tmp239_)) {
				ValaCodeContext* _tmp240_;
				ValaCodeContext* _tmp241_;
				ValaSemanticAnalyzer* _tmp242_;
				ValaSemanticAnalyzer* _tmp243_;
				ValaProperty* _tmp244_;
				ValaDataType* _tmp245_;
				ValaDataType* _tmp246_;
				_tmp240_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp241_ = _tmp240_;
				_tmp242_ = vala_code_context_get_analyzer (_tmp241_);
				_tmp243_ = _tmp242_;
				_tmp244_ = prop;
				_tmp245_ = vala_property_get_property_type (_tmp244_);
				_tmp246_ = _tmp245_;
				if (!vala_semantic_analyzer_is_gobject_property_type (_tmp243_, _tmp246_)) {
					ValaProperty* _tmp247_;
					ValaSourceReference* _tmp248_;
					ValaSourceReference* _tmp249_;
					ValaProperty* _tmp250_;
					ValaDataType* _tmp251_;
					ValaDataType* _tmp252_;
					gchar* _tmp253_;
					gchar* _tmp254_;
					_tmp247_ = prop;
					_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = prop;
					_tmp251_ = vala_property_get_property_type (_tmp250_);
					_tmp252_ = _tmp251_;
					_tmp253_ = vala_data_type_to_qualified_string (_tmp252_, NULL);
					_tmp254_ = _tmp253_;
					vala_report_warning (_tmp249_, "Type `%s' can not be used for a GLib.Object property", _tmp254_);
					_g_free0 (_tmp254_);
				}
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp255_ = prop;
			_tmp256_ = vala_symbol_get_comment ((ValaSymbol*) _tmp255_);
			_tmp257_ = _tmp256_;
			if (_tmp257_ != NULL) {
				ValaCCodeFunction* _tmp258_;
				ValaCCodeFunction* _tmp259_;
				ValaProperty* _tmp260_;
				ValaComment* _tmp261_;
				ValaComment* _tmp262_;
				const gchar* _tmp263_;
				const gchar* _tmp264_;
				ValaCCodeComment* _tmp265_;
				ValaCCodeComment* _tmp266_;
				_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp259_ = _tmp258_;
				_tmp260_ = prop;
				_tmp261_ = vala_symbol_get_comment ((ValaSymbol*) _tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_comment_get_content (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_ccode_comment_new (_tmp264_);
				_tmp266_ = _tmp265_;
				vala_ccode_function_add_statement (_tmp259_, (ValaCCodeNode*) _tmp266_);
				_vala_ccode_node_unref0 (_tmp266_);
			}
			_tmp267_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp268_);
			_tmp270_ = _tmp269_;
			_vala_ccode_node_unref0 (_tmp268_);
			cinst = _tmp270_;
			_tmp271_ = cinst;
			_tmp272_ = ccall;
			vala_ccode_function_call_add_argument (_tmp271_, (ValaCCodeExpression*) _tmp272_);
			_tmp273_ = cinst;
			_tmp274_ = prop;
			_tmp275_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp274_, NULL);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("%s_PROPERTY", _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_ccode_constant_new (_tmp278_);
			_tmp280_ = _tmp279_;
			vala_ccode_function_call_add_argument (_tmp273_, (ValaCCodeExpression*) _tmp280_);
			_vala_ccode_node_unref0 (_tmp280_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
			_tmp281_ = cinst;
			_tmp282_ = prop;
			_tmp283_ = vala_ccode_base_module_get_param_spec ((ValaCCodeBaseModule*) self, _tmp282_);
			_tmp284_ = _tmp283_;
			vala_ccode_function_call_add_argument (_tmp281_, _tmp284_);
			_vala_ccode_node_unref0 (_tmp284_);
			_tmp285_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp286_ = _tmp285_;
			_tmp287_ = cinst;
			vala_ccode_function_add_expression (_tmp286_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (cinst);
			_vala_code_node_unref0 (prop);
		}
	}
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
}

static gboolean
vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaProperty* prop = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaProperty* _tmp8_;
			ValaPropertyAccessor* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			_prop_index = _prop_index + 1;
			_tmp4_ = _prop_index;
			_tmp5_ = _prop_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prop_list;
			_tmp7_ = vala_list_get (_tmp6_, _prop_index);
			prop = (ValaProperty*) _tmp7_;
			_tmp8_ = prop;
			_tmp9_ = vala_property_get_get_accessor (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaProperty* prop = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaProperty* _tmp8_;
			ValaPropertyAccessor* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			_prop_index = _prop_index + 1;
			_tmp4_ = _prop_index;
			_tmp5_ = _prop_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prop_list;
			_tmp7_ = vala_list_get (_tmp6_, _prop_index);
			prop = (ValaProperty*) _tmp7_;
			_tmp8_ = prop;
			_tmp9_ = vala_property_get_set_accessor (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                            ValaSymbol* sym,
                                            ValaCCodeExpression* expression)
{
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (expression != NULL);
	_tmp0_ = vala_symbol_get_version (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_version_attribute_get_deprecated (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaCCodeGGnucSection* guard = NULL;
		ValaCCodeGGnucSection* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeGGnucSection* _tmp7_;
		ValaCCodeGGnucSection* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp10_;
		_tmp4_ = vala_ccode_ggnuc_section_new (VALA_GGNUC_SECTION_TYPE_IGNORE_DEPRECATIONS);
		guard = _tmp4_;
		_tmp5_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = guard;
		vala_ccode_function_add_statement (_tmp6_, (ValaCCodeNode*) _tmp7_);
		_tmp8_ = guard;
		_tmp9_ = vala_ccode_expression_statement_new (expression);
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp8_, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (guard);
	} else {
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp12_ = _tmp11_;
		vala_ccode_function_add_expression (_tmp12_, expression);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static void
vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* get_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp421_;
	ValaCCodeFunction* _tmp422_;
	ValaCCodeFunction* _tmp423_;
	ValaCCodeFunction* _tmp424_;
	ValaCCodeFunction* _tmp425_;
	ValaCCodeFunction* _tmp426_;
	ValaCCodeFile* _tmp427_;
	ValaCCodeFunction* _tmp428_;
	ValaCCodeFile* _tmp429_;
	ValaCCodeFunction* _tmp430_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_get_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	get_prop = _tmp5_;
	_tmp6_ = get_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = get_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = get_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = get_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = get_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = get_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaProperty* prop = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			gboolean _tmp47_ = FALSE;
			ValaProperty* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaPropertyAccessor* _tmp50_;
			ValaCodeContext* _tmp54_;
			ValaCodeContext* _tmp55_;
			ValaSemanticAnalyzer* _tmp56_;
			ValaSemanticAnalyzer* _tmp57_;
			ValaProperty* _tmp58_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp59_;
			ValaProperty* _tmp60_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp61_;
			ValaProperty* _tmp62_;
			ValaProperty* _tmp63_;
			ValaProperty* _tmp64_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp126_ = FALSE;
			ValaProperty* _tmp127_;
			ValaCCodeFunction* _tmp141_;
			ValaCCodeFunction* _tmp142_;
			ValaProperty* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			ValaCCodeIdentifier* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaProperty* _tmp150_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			ValaCCodeFunction* _tmp303_;
			ValaCCodeFunction* _tmp304_;
			_prop_index = _prop_index + 1;
			_tmp43_ = _prop_index;
			_tmp44_ = _prop_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _prop_list;
			_tmp46_ = vala_list_get (_tmp45_, _prop_index);
			prop = (ValaProperty*) _tmp46_;
			_tmp48_ = prop;
			_tmp49_ = vala_property_get_get_accessor (_tmp48_);
			_tmp50_ = _tmp49_;
			if (_tmp50_ == NULL) {
				_tmp47_ = TRUE;
			} else {
				ValaProperty* _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp53_;
				_tmp51_ = prop;
				_tmp52_ = vala_property_get_is_abstract (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp47_ = _tmp53_;
			}
			if (_tmp47_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp54_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_code_context_get_analyzer (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp57_, _tmp58_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp59_ = prop;
			_tmp60_ = _vala_code_node_ref0 (_tmp59_);
			base_prop = _tmp60_;
			_tmp61_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp61_;
			_tmp62_ = prop;
			_tmp63_ = vala_property_get_base_property (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp65_;
				ValaProperty* _tmp66_;
				ValaProperty* _tmp67_;
				ValaSymbol* _tmp68_;
				ValaSymbol* _tmp69_;
				ValaClass* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaProperty* _tmp74_;
				ValaObjectType* _tmp75_;
				ValaObjectType* _tmp76_;
				ValaCCodeExpression* _tmp77_;
				ValaGLibValue* _tmp78_;
				ValaGLibValue* _tmp79_;
				ValaClass* _tmp80_;
				ValaObjectType* _tmp81_;
				ValaObjectType* _tmp82_;
				ValaProperty* _tmp83_;
				ValaTargetValue* _tmp84_;
				ValaTargetValue* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				ValaCCodeExpression* _tmp87_;
				ValaProperty* _tmp88_;
				ValaProperty* _tmp89_;
				ValaProperty* _tmp90_;
				ValaPropertyAccessor* _tmp91_;
				ValaPropertyAccessor* _tmp92_;
				ValaCCodeFile* _tmp93_;
				_tmp65_ = prop;
				_tmp66_ = vala_property_get_base_property (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp70_;
				_tmp71_ = prop;
				_tmp72_ = vala_property_get_base_property (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = _vala_code_node_ref0 (_tmp73_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp74_;
				_tmp75_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp76_ = _tmp75_;
				_tmp77_ = cself;
				_tmp78_ = vala_glib_value_new ((ValaDataType*) _tmp76_, _tmp77_, TRUE);
				_tmp79_ = _tmp78_;
				_tmp80_ = base_type;
				_tmp81_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = prop;
				_tmp84_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp79_, (ValaDataType*) _tmp82_, (ValaCodeNode*) _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_get_cvalue_ (_tmp85_);
				_tmp87_ = _vala_ccode_node_ref0 (_tmp86_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp87_;
				_vala_target_value_unref0 (_tmp85_);
				_vala_code_node_unref0 (_tmp82_);
				_vala_target_value_unref0 (_tmp79_);
				_vala_code_node_unref0 (_tmp76_);
				_tmp88_ = prop;
				_tmp89_ = vala_property_get_base_property (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_property_get_get_accessor (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp92_, _tmp93_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp94_;
				ValaProperty* _tmp95_;
				ValaProperty* _tmp96_;
				_tmp94_ = prop;
				_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp97_;
					ValaProperty* _tmp98_;
					ValaProperty* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					ValaInterface* _tmp102_;
					ValaProperty* _tmp103_;
					ValaProperty* _tmp104_;
					ValaProperty* _tmp105_;
					ValaProperty* _tmp106_;
					ValaObjectType* _tmp107_;
					ValaObjectType* _tmp108_;
					ValaCCodeExpression* _tmp109_;
					ValaGLibValue* _tmp110_;
					ValaGLibValue* _tmp111_;
					ValaInterface* _tmp112_;
					ValaObjectType* _tmp113_;
					ValaObjectType* _tmp114_;
					ValaProperty* _tmp115_;
					ValaTargetValue* _tmp116_;
					ValaTargetValue* _tmp117_;
					ValaCCodeExpression* _tmp118_;
					ValaCCodeExpression* _tmp119_;
					ValaProperty* _tmp120_;
					ValaProperty* _tmp121_;
					ValaProperty* _tmp122_;
					ValaPropertyAccessor* _tmp123_;
					ValaPropertyAccessor* _tmp124_;
					ValaCCodeFile* _tmp125_;
					_tmp97_ = prop;
					_tmp98_ = vala_property_get_base_interface_property (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp102_;
					_tmp103_ = prop;
					_tmp104_ = vala_property_get_base_interface_property (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = _vala_code_node_ref0 (_tmp105_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp106_;
					_tmp107_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp108_ = _tmp107_;
					_tmp109_ = cself;
					_tmp110_ = vala_glib_value_new ((ValaDataType*) _tmp108_, _tmp109_, TRUE);
					_tmp111_ = _tmp110_;
					_tmp112_ = base_type;
					_tmp113_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = prop;
					_tmp116_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp111_, (ValaDataType*) _tmp114_, (ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = vala_get_cvalue_ (_tmp117_);
					_tmp119_ = _vala_ccode_node_ref0 (_tmp118_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp119_;
					_vala_target_value_unref0 (_tmp117_);
					_vala_code_node_unref0 (_tmp114_);
					_vala_target_value_unref0 (_tmp111_);
					_vala_code_node_unref0 (_tmp108_);
					_tmp120_ = prop;
					_tmp121_ = vala_property_get_base_interface_property (_tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = vala_property_get_get_accessor (_tmp122_);
					_tmp124_ = _tmp123_;
					_tmp125_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp124_, _tmp125_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp127_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp127_)) {
				ValaProperty* _tmp128_;
				_tmp128_ = base_prop;
				_tmp126_ = !vala_get_ccode_concrete_accessor (_tmp128_);
			} else {
				_tmp126_ = FALSE;
			}
			if (_tmp126_) {
				ValaProperty* _tmp129_;
				ValaPropertyAccessor* _tmp130_;
				ValaPropertyAccessor* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				ValaCCodeIdentifier* _tmp134_;
				_tmp129_ = base_prop;
				_tmp130_ = vala_property_get_get_accessor (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_get_ccode_name ((ValaCodeNode*) _tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_ccode_identifier_new (_tmp133_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp134_;
				_g_free0 (_tmp133_);
			} else {
				ValaProperty* _tmp135_;
				ValaPropertyAccessor* _tmp136_;
				ValaPropertyAccessor* _tmp137_;
				gchar* _tmp138_;
				gchar* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				_tmp135_ = prop;
				_tmp136_ = vala_property_get_get_accessor (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp137_);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_ccode_identifier_new (_tmp139_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp140_;
				_g_free0 (_tmp139_);
			}
			_tmp141_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = prop;
			_tmp144_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp143_, NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = g_strdup_printf ("%s_PROPERTY", _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_ccode_identifier_new (_tmp147_);
			_tmp149_ = _tmp148_;
			vala_ccode_function_add_case (_tmp142_, (ValaCCodeExpression*) _tmp149_);
			_vala_ccode_node_unref0 (_tmp149_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp145_);
			_tmp150_ = prop;
			_tmp151_ = vala_property_get_property_type (_tmp150_);
			_tmp152_ = _tmp151_;
			if (vala_data_type_is_real_struct_type (_tmp152_)) {
				ValaCCodeFunction* _tmp153_;
				ValaCCodeFunction* _tmp154_;
				ValaCCodeFunction* _tmp155_;
				ValaCCodeFunction* _tmp156_;
				ValaProperty* _tmp157_;
				ValaDataType* _tmp158_;
				ValaDataType* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				ValaCCodeVariableDeclarator* _tmp162_;
				ValaCCodeVariableDeclarator* _tmp163_;
				ValaCCodeExpression* _tmp164_;
				ValaCCodeFunctionCall* _tmp165_;
				ValaCCodeFunctionCall* _tmp166_;
				ValaCCodeExpression* _tmp167_;
				ValaProperty* _tmp168_;
				ValaDataType* _tmp169_;
				ValaDataType* _tmp170_;
				gboolean _tmp171_;
				gboolean _tmp172_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp186_;
				ValaCCodeFunctionCall* _tmp187_;
				ValaProperty* _tmp188_;
				ValaDataType* _tmp189_;
				ValaDataType* _tmp190_;
				ValaCCodeExpression* _tmp191_;
				ValaCCodeExpression* _tmp192_;
				ValaCCodeFunctionCall* _tmp193_;
				ValaCCodeIdentifier* _tmp194_;
				ValaCCodeIdentifier* _tmp195_;
				ValaProperty* _tmp196_;
				ValaDataType* _tmp197_;
				ValaDataType* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				ValaProperty* _tmp209_;
				ValaCCodeFunctionCall* _tmp210_;
				ValaProperty* _tmp211_;
				ValaPropertyAccessor* _tmp212_;
				ValaPropertyAccessor* _tmp213_;
				ValaDataType* _tmp214_;
				ValaDataType* _tmp215_;
				ValaCCodeFunction* _tmp229_;
				ValaCCodeFunction* _tmp230_;
				_tmp153_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp154_ = _tmp153_;
				vala_ccode_function_open_block (_tmp154_);
				_tmp155_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp156_ = _tmp155_;
				_tmp157_ = prop;
				_tmp158_ = vala_property_get_property_type (_tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_get_ccode_name ((ValaCodeNode*) _tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp163_ = _tmp162_;
				vala_ccode_function_add_declaration (_tmp156_, _tmp161_, (ValaCCodeDeclarator*) _tmp163_, 0);
				_vala_ccode_node_unref0 (_tmp163_);
				_g_free0 (_tmp161_);
				_tmp164_ = cfunc;
				_tmp165_ = vala_ccode_function_call_new (_tmp164_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp165_;
				_tmp166_ = ccall;
				_tmp167_ = cself;
				vala_ccode_function_call_add_argument (_tmp166_, _tmp167_);
				_tmp168_ = prop;
				_tmp169_ = vala_property_get_property_type (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = vala_data_type_get_nullable (_tmp170_);
				_tmp172_ = _tmp171_;
				if (_tmp172_) {
					ValaCCodeFunction* _tmp173_;
					ValaCCodeFunction* _tmp174_;
					ValaCCodeIdentifier* _tmp175_;
					ValaCCodeIdentifier* _tmp176_;
					ValaCCodeFunctionCall* _tmp177_;
					_tmp173_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = vala_ccode_identifier_new ("boxed");
					_tmp176_ = _tmp175_;
					_tmp177_ = ccall;
					vala_ccode_function_add_assignment (_tmp174_, (ValaCCodeExpression*) _tmp176_, (ValaCCodeExpression*) _tmp177_);
					_vala_ccode_node_unref0 (_tmp176_);
				} else {
					ValaCCodeFunctionCall* _tmp178_;
					ValaCCodeIdentifier* _tmp179_;
					ValaCCodeIdentifier* _tmp180_;
					ValaCCodeUnaryExpression* _tmp181_;
					ValaCCodeUnaryExpression* _tmp182_;
					ValaCCodeFunction* _tmp183_;
					ValaCCodeFunction* _tmp184_;
					ValaCCodeFunctionCall* _tmp185_;
					_tmp178_ = ccall;
					_tmp179_ = vala_ccode_identifier_new ("boxed");
					_tmp180_ = _tmp179_;
					_tmp181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp180_);
					_tmp182_ = _tmp181_;
					vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp182_);
					_vala_ccode_node_unref0 (_tmp182_);
					_vala_ccode_node_unref0 (_tmp180_);
					_tmp183_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp184_ = _tmp183_;
					_tmp185_ = ccall;
					vala_ccode_function_add_expression (_tmp184_, (ValaCCodeExpression*) _tmp185_);
				}
				_tmp186_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp186_;
				_tmp187_ = csetcall;
				_tmp188_ = prop;
				_tmp189_ = vala_property_get_property_type (_tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp190_);
				_tmp192_ = _tmp191_;
				vala_ccode_function_call_set_call (_tmp187_, _tmp192_);
				_vala_ccode_node_unref0 (_tmp192_);
				_tmp193_ = csetcall;
				_tmp194_ = vala_ccode_identifier_new ("value");
				_tmp195_ = _tmp194_;
				vala_ccode_function_call_add_argument (_tmp193_, (ValaCCodeExpression*) _tmp195_);
				_vala_ccode_node_unref0 (_tmp195_);
				_tmp196_ = prop;
				_tmp197_ = vala_property_get_property_type (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_data_type_get_nullable (_tmp198_);
				_tmp200_ = _tmp199_;
				if (_tmp200_) {
					ValaCCodeFunctionCall* _tmp201_;
					ValaCCodeIdentifier* _tmp202_;
					ValaCCodeIdentifier* _tmp203_;
					_tmp201_ = csetcall;
					_tmp202_ = vala_ccode_identifier_new ("boxed");
					_tmp203_ = _tmp202_;
					vala_ccode_function_call_add_argument (_tmp201_, (ValaCCodeExpression*) _tmp203_);
					_vala_ccode_node_unref0 (_tmp203_);
				} else {
					ValaCCodeFunctionCall* _tmp204_;
					ValaCCodeIdentifier* _tmp205_;
					ValaCCodeIdentifier* _tmp206_;
					ValaCCodeUnaryExpression* _tmp207_;
					ValaCCodeUnaryExpression* _tmp208_;
					_tmp204_ = csetcall;
					_tmp205_ = vala_ccode_identifier_new ("boxed");
					_tmp206_ = _tmp205_;
					_tmp207_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp206_);
					_tmp208_ = _tmp207_;
					vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp208_);
					_vala_ccode_node_unref0 (_tmp208_);
					_vala_ccode_node_unref0 (_tmp206_);
				}
				_tmp209_ = prop;
				_tmp210_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp209_, (ValaCCodeExpression*) _tmp210_);
				_tmp211_ = prop;
				_tmp212_ = vala_property_get_get_accessor (_tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_property_accessor_get_value_type (_tmp213_);
				_tmp215_ = _tmp214_;
				if (vala_ccode_base_module_requires_destroy (_tmp215_)) {
					ValaCCodeFunction* _tmp216_;
					ValaCCodeFunction* _tmp217_;
					ValaProperty* _tmp218_;
					ValaPropertyAccessor* _tmp219_;
					ValaPropertyAccessor* _tmp220_;
					ValaDataType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaCCodeIdentifier* _tmp223_;
					ValaCCodeIdentifier* _tmp224_;
					ValaGLibValue* _tmp225_;
					ValaGLibValue* _tmp226_;
					ValaCCodeExpression* _tmp227_;
					ValaCCodeExpression* _tmp228_;
					_tmp216_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp217_ = _tmp216_;
					_tmp218_ = prop;
					_tmp219_ = vala_property_get_get_accessor (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_property_accessor_get_value_type (_tmp220_);
					_tmp222_ = _tmp221_;
					_tmp223_ = vala_ccode_identifier_new ("boxed");
					_tmp224_ = _tmp223_;
					_tmp225_ = vala_glib_value_new (_tmp222_, (ValaCCodeExpression*) _tmp224_, TRUE);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp226_, FALSE);
					_tmp228_ = _tmp227_;
					vala_ccode_function_add_expression (_tmp217_, _tmp228_);
					_vala_ccode_node_unref0 (_tmp228_);
					_vala_target_value_unref0 (_tmp226_);
					_vala_ccode_node_unref0 (_tmp224_);
				}
				_tmp229_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp230_ = _tmp229_;
				vala_ccode_function_close (_tmp230_);
				_vala_ccode_node_unref0 (csetcall);
			} else {
				ValaCCodeExpression* _tmp231_;
				ValaCCodeFunctionCall* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaArrayType* array_type = NULL;
				ValaProperty* _tmp235_;
				ValaDataType* _tmp236_;
				ValaDataType* _tmp237_;
				ValaArrayType* _tmp238_;
				gboolean _tmp239_ = FALSE;
				gboolean _tmp240_ = FALSE;
				ValaArrayType* _tmp241_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp262_;
				ValaProperty* _tmp263_;
				ValaPropertyAccessor* _tmp264_;
				ValaPropertyAccessor* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				gboolean _tmp268_;
				gboolean _tmp269_;
				ValaCCodeFunctionCall* _tmp282_;
				ValaCCodeIdentifier* _tmp283_;
				ValaCCodeIdentifier* _tmp284_;
				ValaCCodeFunctionCall* _tmp285_;
				ValaCCodeFunctionCall* _tmp286_;
				ValaProperty* _tmp287_;
				ValaCCodeFunctionCall* _tmp288_;
				gboolean _tmp289_ = FALSE;
				gboolean _tmp290_ = FALSE;
				ValaArrayType* _tmp291_;
				_tmp231_ = cfunc;
				_tmp232_ = vala_ccode_function_call_new (_tmp231_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp232_;
				_tmp233_ = ccall;
				_tmp234_ = cself;
				vala_ccode_function_call_add_argument (_tmp233_, _tmp234_);
				_tmp235_ = prop;
				_tmp236_ = vala_property_get_property_type (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp237_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp237_) : NULL);
				array_type = _tmp238_;
				_tmp241_ = array_type;
				if (_tmp241_ != NULL) {
					ValaProperty* _tmp242_;
					_tmp242_ = prop;
					_tmp240_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp242_);
				} else {
					_tmp240_ = FALSE;
				}
				if (_tmp240_) {
					ValaArrayType* _tmp243_;
					ValaDataType* _tmp244_;
					ValaDataType* _tmp245_;
					ValaTypeSymbol* _tmp246_;
					ValaTypeSymbol* _tmp247_;
					ValaDataType* _tmp248_;
					ValaTypeSymbol* _tmp249_;
					ValaTypeSymbol* _tmp250_;
					_tmp243_ = array_type;
					_tmp244_ = vala_array_type_get_element_type (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_data_type_get_type_symbol (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp249_ = vala_data_type_get_type_symbol (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp239_ = _tmp247_ == _tmp250_;
				} else {
					_tmp239_ = FALSE;
				}
				if (_tmp239_) {
					ValaCCodeFunction* _tmp251_;
					ValaCCodeFunction* _tmp252_;
					ValaCCodeFunction* _tmp253_;
					ValaCCodeFunction* _tmp254_;
					ValaCCodeVariableDeclarator* _tmp255_;
					ValaCCodeVariableDeclarator* _tmp256_;
					ValaCCodeFunctionCall* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaCCodeUnaryExpression* _tmp260_;
					ValaCCodeUnaryExpression* _tmp261_;
					_tmp251_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp252_ = _tmp251_;
					vala_ccode_function_open_block (_tmp252_);
					_tmp253_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp254_ = _tmp253_;
					_tmp255_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
					_tmp256_ = _tmp255_;
					vala_ccode_function_add_declaration (_tmp254_, "int", (ValaCCodeDeclarator*) _tmp256_, 0);
					_vala_ccode_node_unref0 (_tmp256_);
					_tmp257_ = ccall;
					_tmp258_ = vala_ccode_identifier_new ("length");
					_tmp259_ = _tmp258_;
					_tmp260_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp259_);
					_tmp261_ = _tmp260_;
					vala_ccode_function_call_add_argument (_tmp257_, (ValaCCodeExpression*) _tmp261_);
					_vala_ccode_node_unref0 (_tmp261_);
					_vala_ccode_node_unref0 (_tmp259_);
				}
				_tmp262_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp262_;
				_tmp263_ = prop;
				_tmp264_ = vala_property_get_get_accessor (_tmp263_);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_property_accessor_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp268_ = vala_data_type_get_value_owned (_tmp267_);
				_tmp269_ = _tmp268_;
				if (_tmp269_) {
					ValaCCodeFunctionCall* _tmp270_;
					ValaProperty* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					ValaCCodeExpression* _tmp274_;
					ValaCCodeExpression* _tmp275_;
					_tmp270_ = csetcall;
					_tmp271_ = prop;
					_tmp272_ = vala_property_get_property_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_ccode_function_call_set_call (_tmp270_, _tmp275_);
					_vala_ccode_node_unref0 (_tmp275_);
				} else {
					ValaCCodeFunctionCall* _tmp276_;
					ValaProperty* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaCCodeExpression* _tmp280_;
					ValaCCodeExpression* _tmp281_;
					_tmp276_ = csetcall;
					_tmp277_ = prop;
					_tmp278_ = vala_property_get_property_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp279_);
					_tmp281_ = _tmp280_;
					vala_ccode_function_call_set_call (_tmp276_, _tmp281_);
					_vala_ccode_node_unref0 (_tmp281_);
				}
				_tmp282_ = csetcall;
				_tmp283_ = vala_ccode_identifier_new ("value");
				_tmp284_ = _tmp283_;
				vala_ccode_function_call_add_argument (_tmp282_, (ValaCCodeExpression*) _tmp284_);
				_vala_ccode_node_unref0 (_tmp284_);
				_tmp285_ = csetcall;
				_tmp286_ = ccall;
				vala_ccode_function_call_add_argument (_tmp285_, (ValaCCodeExpression*) _tmp286_);
				_tmp287_ = prop;
				_tmp288_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp287_, (ValaCCodeExpression*) _tmp288_);
				_tmp291_ = array_type;
				if (_tmp291_ != NULL) {
					ValaProperty* _tmp292_;
					_tmp292_ = prop;
					_tmp290_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp292_);
				} else {
					_tmp290_ = FALSE;
				}
				if (_tmp290_) {
					ValaArrayType* _tmp293_;
					ValaDataType* _tmp294_;
					ValaDataType* _tmp295_;
					ValaTypeSymbol* _tmp296_;
					ValaTypeSymbol* _tmp297_;
					ValaDataType* _tmp298_;
					ValaTypeSymbol* _tmp299_;
					ValaTypeSymbol* _tmp300_;
					_tmp293_ = array_type;
					_tmp294_ = vala_array_type_get_element_type (_tmp293_);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_data_type_get_type_symbol (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp299_ = vala_data_type_get_type_symbol (_tmp298_);
					_tmp300_ = _tmp299_;
					_tmp289_ = _tmp297_ == _tmp300_;
				} else {
					_tmp289_ = FALSE;
				}
				if (_tmp289_) {
					ValaCCodeFunction* _tmp301_;
					ValaCCodeFunction* _tmp302_;
					_tmp301_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp302_ = _tmp301_;
					vala_ccode_function_close (_tmp302_);
				}
				_vala_ccode_node_unref0 (csetcall);
				_vala_code_node_unref0 (array_type);
			}
			_tmp303_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp304_ = _tmp303_;
			vala_ccode_function_add_break (_tmp304_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp305_;
		gint _type_param_size = 0;
		ValaList* _tmp306_;
		gint _tmp307_;
		gint _tmp308_;
		gint _type_param_index = 0;
		_tmp305_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp305_;
		_tmp306_ = _type_param_list;
		_tmp307_ = vala_collection_get_size ((ValaCollection*) _tmp306_);
		_tmp308_ = _tmp307_;
		_type_param_size = _tmp308_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp309_;
			gint _tmp310_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp311_;
			gpointer _tmp312_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* csetcall = NULL;
			ValaTypeParameter* _tmp313_;
			const gchar* _tmp314_;
			const gchar* _tmp315_;
			gchar* _tmp316_;
			gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* _tmp319_;
			gchar* _tmp320_;
			const gchar* _tmp321_;
			gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			ValaCCodeFunction* _tmp325_;
			ValaCCodeFunction* _tmp326_;
			const gchar* _tmp327_;
			ValaCCodeIdentifier* _tmp328_;
			ValaCCodeIdentifier* _tmp329_;
			ValaCCodeIdentifier* _tmp330_;
			ValaCCodeIdentifier* _tmp331_;
			ValaCCodeMemberAccess* _tmp332_;
			ValaCCodeMemberAccess* _tmp333_;
			const gchar* _tmp334_;
			ValaCCodeMemberAccess* _tmp335_;
			ValaCCodeIdentifier* _tmp336_;
			ValaCCodeIdentifier* _tmp337_;
			ValaCCodeFunctionCall* _tmp338_;
			ValaCCodeFunctionCall* _tmp339_;
			ValaCCodeIdentifier* _tmp340_;
			ValaCCodeIdentifier* _tmp341_;
			ValaCCodeFunctionCall* _tmp342_;
			ValaCCodeMemberAccess* _tmp343_;
			ValaCCodeFunction* _tmp344_;
			ValaCCodeFunction* _tmp345_;
			ValaCCodeFunctionCall* _tmp346_;
			ValaCCodeFunction* _tmp347_;
			ValaCCodeFunction* _tmp348_;
			ValaTypeParameter* _tmp349_;
			const gchar* _tmp350_;
			const gchar* _tmp351_;
			gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			gchar* _tmp356_;
			const gchar* _tmp357_;
			gchar* _tmp358_;
			gchar* _tmp359_;
			gchar* _tmp360_;
			ValaCCodeFunction* _tmp361_;
			ValaCCodeFunction* _tmp362_;
			const gchar* _tmp363_;
			ValaCCodeIdentifier* _tmp364_;
			ValaCCodeIdentifier* _tmp365_;
			ValaCCodeIdentifier* _tmp366_;
			ValaCCodeIdentifier* _tmp367_;
			ValaCCodeMemberAccess* _tmp368_;
			ValaCCodeMemberAccess* _tmp369_;
			const gchar* _tmp370_;
			ValaCCodeMemberAccess* _tmp371_;
			ValaCCodeIdentifier* _tmp372_;
			ValaCCodeIdentifier* _tmp373_;
			ValaCCodeFunctionCall* _tmp374_;
			ValaCCodeFunctionCall* _tmp375_;
			ValaCCodeIdentifier* _tmp376_;
			ValaCCodeIdentifier* _tmp377_;
			ValaCCodeFunctionCall* _tmp378_;
			ValaCCodeMemberAccess* _tmp379_;
			ValaCCodeFunction* _tmp380_;
			ValaCCodeFunction* _tmp381_;
			ValaCCodeFunctionCall* _tmp382_;
			ValaCCodeFunction* _tmp383_;
			ValaCCodeFunction* _tmp384_;
			ValaTypeParameter* _tmp385_;
			const gchar* _tmp386_;
			const gchar* _tmp387_;
			gchar* _tmp388_;
			gchar* _tmp389_;
			gchar* _tmp390_;
			gchar* _tmp391_;
			gchar* _tmp392_;
			const gchar* _tmp393_;
			gchar* _tmp394_;
			gchar* _tmp395_;
			gchar* _tmp396_;
			ValaCCodeFunction* _tmp397_;
			ValaCCodeFunction* _tmp398_;
			const gchar* _tmp399_;
			ValaCCodeIdentifier* _tmp400_;
			ValaCCodeIdentifier* _tmp401_;
			ValaCCodeIdentifier* _tmp402_;
			ValaCCodeIdentifier* _tmp403_;
			ValaCCodeMemberAccess* _tmp404_;
			ValaCCodeMemberAccess* _tmp405_;
			const gchar* _tmp406_;
			ValaCCodeMemberAccess* _tmp407_;
			ValaCCodeIdentifier* _tmp408_;
			ValaCCodeIdentifier* _tmp409_;
			ValaCCodeFunctionCall* _tmp410_;
			ValaCCodeFunctionCall* _tmp411_;
			ValaCCodeIdentifier* _tmp412_;
			ValaCCodeIdentifier* _tmp413_;
			ValaCCodeFunctionCall* _tmp414_;
			ValaCCodeMemberAccess* _tmp415_;
			ValaCCodeFunction* _tmp416_;
			ValaCCodeFunction* _tmp417_;
			ValaCCodeFunctionCall* _tmp418_;
			ValaCCodeFunction* _tmp419_;
			ValaCCodeFunction* _tmp420_;
			_type_param_index = _type_param_index + 1;
			_tmp309_ = _type_param_index;
			_tmp310_ = _type_param_size;
			if (!(_tmp309_ < _tmp310_)) {
				break;
			}
			_tmp311_ = _type_param_list;
			_tmp312_ = vala_list_get (_tmp311_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp312_;
			_tmp313_ = type_param;
			_tmp314_ = vala_symbol_get_name ((ValaSymbol*) _tmp313_);
			_tmp315_ = _tmp314_;
			_tmp316_ = g_ascii_strdown (_tmp315_, (gssize) -1);
			_tmp317_ = _tmp316_;
			_tmp318_ = g_strdup_printf ("%s_type", _tmp317_);
			_g_free0 (func_name);
			func_name = _tmp318_;
			_g_free0 (_tmp317_);
			_tmp319_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp320_ = _tmp319_;
			_tmp321_ = func_name;
			_tmp322_ = g_strdup_printf ("%s_%s", _tmp320_, _tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = g_ascii_strup (_tmp323_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp324_;
			_g_free0 (_tmp323_);
			_g_free0 (_tmp320_);
			_tmp325_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp326_ = _tmp325_;
			_tmp327_ = enum_value;
			_tmp328_ = vala_ccode_identifier_new (_tmp327_);
			_tmp329_ = _tmp328_;
			vala_ccode_function_add_case (_tmp326_, (ValaCCodeExpression*) _tmp329_);
			_vala_ccode_node_unref0 (_tmp329_);
			_tmp330_ = vala_ccode_identifier_new ("self");
			_tmp331_ = _tmp330_;
			_tmp332_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp331_, "priv");
			_tmp333_ = _tmp332_;
			_tmp334_ = func_name;
			_tmp335_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp333_, _tmp334_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp335_;
			_vala_ccode_node_unref0 (_tmp333_);
			_vala_ccode_node_unref0 (_tmp331_);
			_tmp336_ = vala_ccode_identifier_new ("g_value_set_gtype");
			_tmp337_ = _tmp336_;
			_tmp338_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp337_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp338_;
			_vala_ccode_node_unref0 (_tmp337_);
			_tmp339_ = csetcall;
			_tmp340_ = vala_ccode_identifier_new ("value");
			_tmp341_ = _tmp340_;
			vala_ccode_function_call_add_argument (_tmp339_, (ValaCCodeExpression*) _tmp341_);
			_vala_ccode_node_unref0 (_tmp341_);
			_tmp342_ = csetcall;
			_tmp343_ = cfield;
			vala_ccode_function_call_add_argument (_tmp342_, (ValaCCodeExpression*) _tmp343_);
			_tmp344_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp345_ = _tmp344_;
			_tmp346_ = csetcall;
			vala_ccode_function_add_expression (_tmp345_, (ValaCCodeExpression*) _tmp346_);
			_tmp347_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp348_ = _tmp347_;
			vala_ccode_function_add_break (_tmp348_);
			_tmp349_ = type_param;
			_tmp350_ = vala_symbol_get_name ((ValaSymbol*) _tmp349_);
			_tmp351_ = _tmp350_;
			_tmp352_ = g_ascii_strdown (_tmp351_, (gssize) -1);
			_tmp353_ = _tmp352_;
			_tmp354_ = g_strdup_printf ("%s_dup_func", _tmp353_);
			_g_free0 (func_name);
			func_name = _tmp354_;
			_g_free0 (_tmp353_);
			_tmp355_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp356_ = _tmp355_;
			_tmp357_ = func_name;
			_tmp358_ = g_strdup_printf ("%s_%s", _tmp356_, _tmp357_);
			_tmp359_ = _tmp358_;
			_tmp360_ = g_ascii_strup (_tmp359_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp360_;
			_g_free0 (_tmp359_);
			_g_free0 (_tmp356_);
			_tmp361_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp362_ = _tmp361_;
			_tmp363_ = enum_value;
			_tmp364_ = vala_ccode_identifier_new (_tmp363_);
			_tmp365_ = _tmp364_;
			vala_ccode_function_add_case (_tmp362_, (ValaCCodeExpression*) _tmp365_);
			_vala_ccode_node_unref0 (_tmp365_);
			_tmp366_ = vala_ccode_identifier_new ("self");
			_tmp367_ = _tmp366_;
			_tmp368_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp367_, "priv");
			_tmp369_ = _tmp368_;
			_tmp370_ = func_name;
			_tmp371_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp369_, _tmp370_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp371_;
			_vala_ccode_node_unref0 (_tmp369_);
			_vala_ccode_node_unref0 (_tmp367_);
			_tmp372_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp373_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp374_;
			_vala_ccode_node_unref0 (_tmp373_);
			_tmp375_ = csetcall;
			_tmp376_ = vala_ccode_identifier_new ("value");
			_tmp377_ = _tmp376_;
			vala_ccode_function_call_add_argument (_tmp375_, (ValaCCodeExpression*) _tmp377_);
			_vala_ccode_node_unref0 (_tmp377_);
			_tmp378_ = csetcall;
			_tmp379_ = cfield;
			vala_ccode_function_call_add_argument (_tmp378_, (ValaCCodeExpression*) _tmp379_);
			_tmp380_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp381_ = _tmp380_;
			_tmp382_ = csetcall;
			vala_ccode_function_add_expression (_tmp381_, (ValaCCodeExpression*) _tmp382_);
			_tmp383_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp384_ = _tmp383_;
			vala_ccode_function_add_break (_tmp384_);
			_tmp385_ = type_param;
			_tmp386_ = vala_symbol_get_name ((ValaSymbol*) _tmp385_);
			_tmp387_ = _tmp386_;
			_tmp388_ = g_ascii_strdown (_tmp387_, (gssize) -1);
			_tmp389_ = _tmp388_;
			_tmp390_ = g_strdup_printf ("%s_destroy_func", _tmp389_);
			_g_free0 (func_name);
			func_name = _tmp390_;
			_g_free0 (_tmp389_);
			_tmp391_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp392_ = _tmp391_;
			_tmp393_ = func_name;
			_tmp394_ = g_strdup_printf ("%s_%s", _tmp392_, _tmp393_);
			_tmp395_ = _tmp394_;
			_tmp396_ = g_ascii_strup (_tmp395_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp396_;
			_g_free0 (_tmp395_);
			_g_free0 (_tmp392_);
			_tmp397_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp398_ = _tmp397_;
			_tmp399_ = enum_value;
			_tmp400_ = vala_ccode_identifier_new (_tmp399_);
			_tmp401_ = _tmp400_;
			vala_ccode_function_add_case (_tmp398_, (ValaCCodeExpression*) _tmp401_);
			_vala_ccode_node_unref0 (_tmp401_);
			_tmp402_ = vala_ccode_identifier_new ("self");
			_tmp403_ = _tmp402_;
			_tmp404_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp403_, "priv");
			_tmp405_ = _tmp404_;
			_tmp406_ = func_name;
			_tmp407_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp405_, _tmp406_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp407_;
			_vala_ccode_node_unref0 (_tmp405_);
			_vala_ccode_node_unref0 (_tmp403_);
			_tmp408_ = vala_ccode_identifier_new ("g_value_set_pointer");
			_tmp409_ = _tmp408_;
			_tmp410_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp409_);
			_vala_ccode_node_unref0 (csetcall);
			csetcall = _tmp410_;
			_vala_ccode_node_unref0 (_tmp409_);
			_tmp411_ = csetcall;
			_tmp412_ = vala_ccode_identifier_new ("value");
			_tmp413_ = _tmp412_;
			vala_ccode_function_call_add_argument (_tmp411_, (ValaCCodeExpression*) _tmp413_);
			_vala_ccode_node_unref0 (_tmp413_);
			_tmp414_ = csetcall;
			_tmp415_ = cfield;
			vala_ccode_function_call_add_argument (_tmp414_, (ValaCCodeExpression*) _tmp415_);
			_tmp416_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp417_ = _tmp416_;
			_tmp418_ = csetcall;
			vala_ccode_function_add_expression (_tmp417_, (ValaCCodeExpression*) _tmp418_);
			_tmp419_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp420_ = _tmp419_;
			vala_ccode_function_add_break (_tmp420_);
			_vala_ccode_node_unref0 (csetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
	}
	_tmp421_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp422_ = _tmp421_;
	vala_ccode_function_add_default (_tmp422_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp423_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp424_ = _tmp423_;
	vala_ccode_function_add_break (_tmp424_);
	_tmp425_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp426_ = _tmp425_;
	vala_ccode_function_close (_tmp426_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp427_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp428_ = get_prop;
	vala_ccode_file_add_function_declaration (_tmp427_, _tmp428_);
	_tmp429_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp430_ = get_prop;
	vala_ccode_file_add_function (_tmp429_, _tmp430_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (get_prop);
}

static void
vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* set_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaCCodeFunction* _tmp356_;
	ValaCCodeFunction* _tmp357_;
	ValaCCodeFunction* _tmp358_;
	ValaCCodeFunction* _tmp359_;
	ValaCCodeFunction* _tmp360_;
	ValaCCodeFunction* _tmp361_;
	ValaCCodeFile* _tmp362_;
	ValaCCodeFunction* _tmp363_;
	ValaCCodeFile* _tmp364_;
	ValaCCodeFunction* _tmp365_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_set_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	set_prop = _tmp5_;
	_tmp6_ = set_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = set_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = set_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = set_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = set_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = set_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _vala_iterable_ref0 (_tmp37_);
	props = _tmp38_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp39_ = props;
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaProperty* prop = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			gboolean _tmp47_ = FALSE;
			ValaProperty* _tmp48_;
			ValaPropertyAccessor* _tmp49_;
			ValaPropertyAccessor* _tmp50_;
			ValaCodeContext* _tmp54_;
			ValaCodeContext* _tmp55_;
			ValaSemanticAnalyzer* _tmp56_;
			ValaSemanticAnalyzer* _tmp57_;
			ValaProperty* _tmp58_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp59_;
			ValaProperty* _tmp60_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp61_;
			ValaProperty* _tmp62_;
			ValaProperty* _tmp63_;
			ValaProperty* _tmp64_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp126_ = FALSE;
			ValaProperty* _tmp127_;
			ValaCCodeFunction* _tmp141_;
			ValaCCodeFunction* _tmp142_;
			ValaProperty* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			ValaCCodeIdentifier* _tmp148_;
			ValaCCodeIdentifier* _tmp149_;
			ValaCCodeExpression* _tmp150_;
			ValaCCodeFunctionCall* _tmp151_;
			ValaCCodeFunctionCall* _tmp152_;
			ValaCCodeExpression* _tmp153_;
			gboolean _tmp154_ = FALSE;
			ValaProperty* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaCCodeFunction* _tmp241_;
			ValaCCodeFunction* _tmp242_;
			_prop_index = _prop_index + 1;
			_tmp43_ = _prop_index;
			_tmp44_ = _prop_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _prop_list;
			_tmp46_ = vala_list_get (_tmp45_, _prop_index);
			prop = (ValaProperty*) _tmp46_;
			_tmp48_ = prop;
			_tmp49_ = vala_property_get_set_accessor (_tmp48_);
			_tmp50_ = _tmp49_;
			if (_tmp50_ == NULL) {
				_tmp47_ = TRUE;
			} else {
				ValaProperty* _tmp51_;
				gboolean _tmp52_;
				gboolean _tmp53_;
				_tmp51_ = prop;
				_tmp52_ = vala_property_get_is_abstract (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp47_ = _tmp53_;
			}
			if (_tmp47_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp54_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_code_context_get_analyzer (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = prop;
			if (!vala_semantic_analyzer_is_gobject_property (_tmp57_, _tmp58_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp59_ = prop;
			_tmp60_ = _vala_code_node_ref0 (_tmp59_);
			base_prop = _tmp60_;
			_tmp61_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp61_;
			_tmp62_ = prop;
			_tmp63_ = vala_property_get_base_property (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp65_;
				ValaProperty* _tmp66_;
				ValaProperty* _tmp67_;
				ValaSymbol* _tmp68_;
				ValaSymbol* _tmp69_;
				ValaClass* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaProperty* _tmp73_;
				ValaProperty* _tmp74_;
				ValaObjectType* _tmp75_;
				ValaObjectType* _tmp76_;
				ValaCCodeExpression* _tmp77_;
				ValaGLibValue* _tmp78_;
				ValaGLibValue* _tmp79_;
				ValaClass* _tmp80_;
				ValaObjectType* _tmp81_;
				ValaObjectType* _tmp82_;
				ValaProperty* _tmp83_;
				ValaTargetValue* _tmp84_;
				ValaTargetValue* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				ValaCCodeExpression* _tmp87_;
				ValaProperty* _tmp88_;
				ValaProperty* _tmp89_;
				ValaProperty* _tmp90_;
				ValaPropertyAccessor* _tmp91_;
				ValaPropertyAccessor* _tmp92_;
				ValaCCodeFile* _tmp93_;
				_tmp65_ = prop;
				_tmp66_ = vala_property_get_base_property (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp70_;
				_tmp71_ = prop;
				_tmp72_ = vala_property_get_base_property (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = _vala_code_node_ref0 (_tmp73_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp74_;
				_tmp75_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp76_ = _tmp75_;
				_tmp77_ = cself;
				_tmp78_ = vala_glib_value_new ((ValaDataType*) _tmp76_, _tmp77_, TRUE);
				_tmp79_ = _tmp78_;
				_tmp80_ = base_type;
				_tmp81_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = prop;
				_tmp84_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp79_, (ValaDataType*) _tmp82_, (ValaCodeNode*) _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_get_cvalue_ (_tmp85_);
				_tmp87_ = _vala_ccode_node_ref0 (_tmp86_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp87_;
				_vala_target_value_unref0 (_tmp85_);
				_vala_code_node_unref0 (_tmp82_);
				_vala_target_value_unref0 (_tmp79_);
				_vala_code_node_unref0 (_tmp76_);
				_tmp88_ = prop;
				_tmp89_ = vala_property_get_base_property (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = vala_property_get_set_accessor (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp92_, _tmp93_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp94_;
				ValaProperty* _tmp95_;
				ValaProperty* _tmp96_;
				_tmp94_ = prop;
				_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp97_;
					ValaProperty* _tmp98_;
					ValaProperty* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					ValaInterface* _tmp102_;
					ValaProperty* _tmp103_;
					ValaProperty* _tmp104_;
					ValaProperty* _tmp105_;
					ValaProperty* _tmp106_;
					ValaObjectType* _tmp107_;
					ValaObjectType* _tmp108_;
					ValaCCodeExpression* _tmp109_;
					ValaGLibValue* _tmp110_;
					ValaGLibValue* _tmp111_;
					ValaInterface* _tmp112_;
					ValaObjectType* _tmp113_;
					ValaObjectType* _tmp114_;
					ValaProperty* _tmp115_;
					ValaTargetValue* _tmp116_;
					ValaTargetValue* _tmp117_;
					ValaCCodeExpression* _tmp118_;
					ValaCCodeExpression* _tmp119_;
					ValaProperty* _tmp120_;
					ValaProperty* _tmp121_;
					ValaProperty* _tmp122_;
					ValaPropertyAccessor* _tmp123_;
					ValaPropertyAccessor* _tmp124_;
					ValaCCodeFile* _tmp125_;
					_tmp97_ = prop;
					_tmp98_ = vala_property_get_base_interface_property (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp102_;
					_tmp103_ = prop;
					_tmp104_ = vala_property_get_base_interface_property (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = _vala_code_node_ref0 (_tmp105_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp106_;
					_tmp107_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp108_ = _tmp107_;
					_tmp109_ = cself;
					_tmp110_ = vala_glib_value_new ((ValaDataType*) _tmp108_, _tmp109_, TRUE);
					_tmp111_ = _tmp110_;
					_tmp112_ = base_type;
					_tmp113_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = prop;
					_tmp116_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp111_, (ValaDataType*) _tmp114_, (ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = vala_get_cvalue_ (_tmp117_);
					_tmp119_ = _vala_ccode_node_ref0 (_tmp118_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp119_;
					_vala_target_value_unref0 (_tmp117_);
					_vala_code_node_unref0 (_tmp114_);
					_vala_target_value_unref0 (_tmp111_);
					_vala_code_node_unref0 (_tmp108_);
					_tmp120_ = prop;
					_tmp121_ = vala_property_get_base_interface_property (_tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = vala_property_get_set_accessor (_tmp122_);
					_tmp124_ = _tmp123_;
					_tmp125_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp124_, _tmp125_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp127_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp127_)) {
				ValaProperty* _tmp128_;
				_tmp128_ = base_prop;
				_tmp126_ = !vala_get_ccode_concrete_accessor (_tmp128_);
			} else {
				_tmp126_ = FALSE;
			}
			if (_tmp126_) {
				ValaProperty* _tmp129_;
				ValaPropertyAccessor* _tmp130_;
				ValaPropertyAccessor* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				ValaCCodeIdentifier* _tmp134_;
				_tmp129_ = base_prop;
				_tmp130_ = vala_property_get_set_accessor (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = vala_get_ccode_name ((ValaCodeNode*) _tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_ccode_identifier_new (_tmp133_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp134_;
				_g_free0 (_tmp133_);
			} else {
				ValaProperty* _tmp135_;
				ValaPropertyAccessor* _tmp136_;
				ValaPropertyAccessor* _tmp137_;
				gchar* _tmp138_;
				gchar* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				_tmp135_ = prop;
				_tmp136_ = vala_property_get_set_accessor (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp137_);
				_tmp139_ = _tmp138_;
				_tmp140_ = vala_ccode_identifier_new (_tmp139_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp140_;
				_g_free0 (_tmp139_);
			}
			_tmp141_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = prop;
			_tmp144_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp143_, NULL);
			_tmp145_ = _tmp144_;
			_tmp146_ = g_strdup_printf ("%s_PROPERTY", _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_ccode_identifier_new (_tmp147_);
			_tmp149_ = _tmp148_;
			vala_ccode_function_add_case (_tmp142_, (ValaCCodeExpression*) _tmp149_);
			_vala_ccode_node_unref0 (_tmp149_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp145_);
			_tmp150_ = cfunc;
			_tmp151_ = vala_ccode_function_call_new (_tmp150_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp151_;
			_tmp152_ = ccall;
			_tmp153_ = cself;
			vala_ccode_function_call_add_argument (_tmp152_, _tmp153_);
			_tmp155_ = prop;
			_tmp156_ = vala_property_get_property_type (_tmp155_);
			_tmp157_ = _tmp156_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, VALA_TYPE_ARRAY_TYPE)) {
				ValaProperty* _tmp158_;
				ValaDataType* _tmp159_;
				ValaDataType* _tmp160_;
				ValaDataType* _tmp161_;
				ValaDataType* _tmp162_;
				ValaTypeSymbol* _tmp163_;
				ValaTypeSymbol* _tmp164_;
				ValaDataType* _tmp165_;
				ValaTypeSymbol* _tmp166_;
				ValaTypeSymbol* _tmp167_;
				_tmp158_ = prop;
				_tmp159_ = vala_property_get_property_type (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_data_type_get_type_symbol (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp166_ = vala_data_type_get_type_symbol (_tmp165_);
				_tmp167_ = _tmp166_;
				_tmp154_ = _tmp164_ == _tmp167_;
			} else {
				_tmp154_ = FALSE;
			}
			if (_tmp154_) {
				ValaCCodeFunction* _tmp168_;
				ValaCCodeFunction* _tmp169_;
				ValaCCodeFunction* _tmp170_;
				ValaCCodeFunction* _tmp171_;
				ValaCCodeVariableDeclarator* _tmp172_;
				ValaCCodeVariableDeclarator* _tmp173_;
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeIdentifier* _tmp174_;
				ValaCCodeIdentifier* _tmp175_;
				ValaCCodeFunctionCall* _tmp176_;
				ValaCCodeFunctionCall* _tmp177_;
				ValaCCodeFunctionCall* _tmp178_;
				ValaCCodeIdentifier* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				ValaCCodeFunction* _tmp181_;
				ValaCCodeFunction* _tmp182_;
				ValaCCodeIdentifier* _tmp183_;
				ValaCCodeIdentifier* _tmp184_;
				ValaCCodeFunctionCall* _tmp185_;
				ValaCCodeFunctionCall* _tmp186_;
				ValaCCodeIdentifier* _tmp187_;
				ValaCCodeIdentifier* _tmp188_;
				ValaProperty* _tmp189_;
				ValaProperty* _tmp211_;
				ValaCCodeFunctionCall* _tmp212_;
				ValaCCodeFunction* _tmp213_;
				ValaCCodeFunction* _tmp214_;
				_tmp168_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp169_ = _tmp168_;
				vala_ccode_function_open_block (_tmp169_);
				_tmp170_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp173_ = _tmp172_;
				vala_ccode_function_add_declaration (_tmp171_, "gpointer", (ValaCCodeDeclarator*) _tmp173_, 0);
				_vala_ccode_node_unref0 (_tmp173_);
				_tmp174_ = vala_ccode_identifier_new ("g_value_get_boxed");
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp175_);
				_tmp177_ = _tmp176_;
				_vala_ccode_node_unref0 (_tmp175_);
				cgetcall = _tmp177_;
				_tmp178_ = cgetcall;
				_tmp179_ = vala_ccode_identifier_new ("value");
				_tmp180_ = _tmp179_;
				vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp180_);
				_vala_ccode_node_unref0 (_tmp180_);
				_tmp181_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_ccode_identifier_new ("boxed");
				_tmp184_ = _tmp183_;
				_tmp185_ = cgetcall;
				vala_ccode_function_add_assignment (_tmp182_, (ValaCCodeExpression*) _tmp184_, (ValaCCodeExpression*) _tmp185_);
				_vala_ccode_node_unref0 (_tmp184_);
				_tmp186_ = ccall;
				_tmp187_ = vala_ccode_identifier_new ("boxed");
				_tmp188_ = _tmp187_;
				vala_ccode_function_call_add_argument (_tmp186_, (ValaCCodeExpression*) _tmp188_);
				_vala_ccode_node_unref0 (_tmp188_);
				_tmp189_ = prop;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp189_)) {
					ValaCCodeBinaryExpression* cisnull = NULL;
					ValaCCodeIdentifier* _tmp190_;
					ValaCCodeIdentifier* _tmp191_;
					ValaCCodeConstant* _tmp192_;
					ValaCCodeConstant* _tmp193_;
					ValaCCodeBinaryExpression* _tmp194_;
					ValaCCodeBinaryExpression* _tmp195_;
					ValaCCodeFunctionCall* cstrvlen = NULL;
					ValaCCodeIdentifier* _tmp196_;
					ValaCCodeIdentifier* _tmp197_;
					ValaCCodeFunctionCall* _tmp198_;
					ValaCCodeFunctionCall* _tmp199_;
					ValaCCodeFunctionCall* _tmp200_;
					ValaCCodeIdentifier* _tmp201_;
					ValaCCodeIdentifier* _tmp202_;
					ValaCCodeConditionalExpression* ccond = NULL;
					ValaCCodeBinaryExpression* _tmp203_;
					ValaCCodeConstant* _tmp204_;
					ValaCCodeConstant* _tmp205_;
					ValaCCodeFunctionCall* _tmp206_;
					ValaCCodeConditionalExpression* _tmp207_;
					ValaCCodeConditionalExpression* _tmp208_;
					ValaCCodeFunctionCall* _tmp209_;
					ValaCCodeConditionalExpression* _tmp210_;
					_tmp190_ = vala_ccode_identifier_new ("boxed");
					_tmp191_ = _tmp190_;
					_tmp192_ = vala_ccode_constant_new ("NULL");
					_tmp193_ = _tmp192_;
					_tmp194_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp191_, (ValaCCodeExpression*) _tmp193_);
					_tmp195_ = _tmp194_;
					_vala_ccode_node_unref0 (_tmp193_);
					_vala_ccode_node_unref0 (_tmp191_);
					cisnull = _tmp195_;
					_tmp196_ = vala_ccode_identifier_new ("g_strv_length");
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp197_);
					_tmp199_ = _tmp198_;
					_vala_ccode_node_unref0 (_tmp197_);
					cstrvlen = _tmp199_;
					_tmp200_ = cstrvlen;
					_tmp201_ = vala_ccode_identifier_new ("boxed");
					_tmp202_ = _tmp201_;
					vala_ccode_function_call_add_argument (_tmp200_, (ValaCCodeExpression*) _tmp202_);
					_vala_ccode_node_unref0 (_tmp202_);
					_tmp203_ = cisnull;
					_tmp204_ = vala_ccode_constant_new ("0");
					_tmp205_ = _tmp204_;
					_tmp206_ = cstrvlen;
					_tmp207_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp203_, (ValaCCodeExpression*) _tmp205_, (ValaCCodeExpression*) _tmp206_);
					_tmp208_ = _tmp207_;
					_vala_ccode_node_unref0 (_tmp205_);
					ccond = _tmp208_;
					_tmp209_ = ccall;
					_tmp210_ = ccond;
					vala_ccode_function_call_add_argument (_tmp209_, (ValaCCodeExpression*) _tmp210_);
					_vala_ccode_node_unref0 (ccond);
					_vala_ccode_node_unref0 (cstrvlen);
					_vala_ccode_node_unref0 (cisnull);
				}
				_tmp211_ = prop;
				_tmp212_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp211_, (ValaCCodeExpression*) _tmp212_);
				_tmp213_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp214_ = _tmp213_;
				vala_ccode_function_close (_tmp214_);
				_vala_ccode_node_unref0 (cgetcall);
			} else {
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeFunctionCall* _tmp215_;
				ValaProperty* _tmp216_;
				ValaDataType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaTypeSymbol* _tmp219_;
				ValaTypeSymbol* _tmp220_;
				ValaCCodeFunctionCall* _tmp234_;
				ValaCCodeIdentifier* _tmp235_;
				ValaCCodeIdentifier* _tmp236_;
				ValaCCodeFunctionCall* _tmp237_;
				ValaCCodeFunctionCall* _tmp238_;
				ValaProperty* _tmp239_;
				ValaCCodeFunctionCall* _tmp240_;
				_tmp215_ = vala_ccode_function_call_new (NULL);
				cgetcall = _tmp215_;
				_tmp216_ = prop;
				_tmp217_ = vala_property_get_property_type (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_data_type_get_type_symbol (_tmp218_);
				_tmp220_ = _tmp219_;
				if (_tmp220_ != NULL) {
					ValaCCodeFunctionCall* _tmp221_;
					ValaProperty* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaTypeSymbol* _tmp225_;
					ValaTypeSymbol* _tmp226_;
					gchar* _tmp227_;
					gchar* _tmp228_;
					ValaCCodeIdentifier* _tmp229_;
					ValaCCodeIdentifier* _tmp230_;
					_tmp221_ = cgetcall;
					_tmp222_ = prop;
					_tmp223_ = vala_property_get_property_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp225_ = vala_data_type_get_type_symbol (_tmp224_);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp226_);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_ccode_identifier_new (_tmp228_);
					_tmp230_ = _tmp229_;
					vala_ccode_function_call_set_call (_tmp221_, (ValaCCodeExpression*) _tmp230_);
					_vala_ccode_node_unref0 (_tmp230_);
					_g_free0 (_tmp228_);
				} else {
					ValaCCodeFunctionCall* _tmp231_;
					ValaCCodeIdentifier* _tmp232_;
					ValaCCodeIdentifier* _tmp233_;
					_tmp231_ = cgetcall;
					_tmp232_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp233_ = _tmp232_;
					vala_ccode_function_call_set_call (_tmp231_, (ValaCCodeExpression*) _tmp233_);
					_vala_ccode_node_unref0 (_tmp233_);
				}
				_tmp234_ = cgetcall;
				_tmp235_ = vala_ccode_identifier_new ("value");
				_tmp236_ = _tmp235_;
				vala_ccode_function_call_add_argument (_tmp234_, (ValaCCodeExpression*) _tmp236_);
				_vala_ccode_node_unref0 (_tmp236_);
				_tmp237_ = ccall;
				_tmp238_ = cgetcall;
				vala_ccode_function_call_add_argument (_tmp237_, (ValaCCodeExpression*) _tmp238_);
				_tmp239_ = prop;
				_tmp240_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp239_, (ValaCCodeExpression*) _tmp240_);
				_vala_ccode_node_unref0 (cgetcall);
			}
			_tmp241_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp242_ = _tmp241_;
			vala_ccode_function_add_break (_tmp242_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp243_;
		gint _type_param_size = 0;
		ValaList* _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
		gint _type_param_index = 0;
		_tmp243_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp243_;
		_tmp244_ = _type_param_list;
		_tmp245_ = vala_collection_get_size ((ValaCollection*) _tmp244_);
		_tmp246_ = _tmp245_;
		_type_param_size = _tmp246_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp247_;
			gint _tmp248_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp249_;
			gpointer _tmp250_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* cgetcall = NULL;
			ValaTypeParameter* _tmp251_;
			const gchar* _tmp252_;
			const gchar* _tmp253_;
			gchar* _tmp254_;
			gchar* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			gchar* _tmp258_;
			const gchar* _tmp259_;
			gchar* _tmp260_;
			gchar* _tmp261_;
			gchar* _tmp262_;
			ValaCCodeFunction* _tmp263_;
			ValaCCodeFunction* _tmp264_;
			const gchar* _tmp265_;
			ValaCCodeIdentifier* _tmp266_;
			ValaCCodeIdentifier* _tmp267_;
			ValaCCodeIdentifier* _tmp268_;
			ValaCCodeIdentifier* _tmp269_;
			ValaCCodeMemberAccess* _tmp270_;
			ValaCCodeMemberAccess* _tmp271_;
			const gchar* _tmp272_;
			ValaCCodeMemberAccess* _tmp273_;
			ValaCCodeIdentifier* _tmp274_;
			ValaCCodeIdentifier* _tmp275_;
			ValaCCodeFunctionCall* _tmp276_;
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeIdentifier* _tmp278_;
			ValaCCodeIdentifier* _tmp279_;
			ValaCCodeFunction* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeMemberAccess* _tmp282_;
			ValaCCodeFunctionCall* _tmp283_;
			ValaCCodeFunction* _tmp284_;
			ValaCCodeFunction* _tmp285_;
			ValaTypeParameter* _tmp286_;
			const gchar* _tmp287_;
			const gchar* _tmp288_;
			gchar* _tmp289_;
			gchar* _tmp290_;
			gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			const gchar* _tmp294_;
			gchar* _tmp295_;
			gchar* _tmp296_;
			gchar* _tmp297_;
			ValaCCodeFunction* _tmp298_;
			ValaCCodeFunction* _tmp299_;
			const gchar* _tmp300_;
			ValaCCodeIdentifier* _tmp301_;
			ValaCCodeIdentifier* _tmp302_;
			ValaCCodeIdentifier* _tmp303_;
			ValaCCodeIdentifier* _tmp304_;
			ValaCCodeMemberAccess* _tmp305_;
			ValaCCodeMemberAccess* _tmp306_;
			const gchar* _tmp307_;
			ValaCCodeMemberAccess* _tmp308_;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeIdentifier* _tmp313_;
			ValaCCodeIdentifier* _tmp314_;
			ValaCCodeFunction* _tmp315_;
			ValaCCodeFunction* _tmp316_;
			ValaCCodeMemberAccess* _tmp317_;
			ValaCCodeFunctionCall* _tmp318_;
			ValaCCodeFunction* _tmp319_;
			ValaCCodeFunction* _tmp320_;
			ValaTypeParameter* _tmp321_;
			const gchar* _tmp322_;
			const gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			const gchar* _tmp329_;
			gchar* _tmp330_;
			gchar* _tmp331_;
			gchar* _tmp332_;
			ValaCCodeFunction* _tmp333_;
			ValaCCodeFunction* _tmp334_;
			const gchar* _tmp335_;
			ValaCCodeIdentifier* _tmp336_;
			ValaCCodeIdentifier* _tmp337_;
			ValaCCodeIdentifier* _tmp338_;
			ValaCCodeIdentifier* _tmp339_;
			ValaCCodeMemberAccess* _tmp340_;
			ValaCCodeMemberAccess* _tmp341_;
			const gchar* _tmp342_;
			ValaCCodeMemberAccess* _tmp343_;
			ValaCCodeIdentifier* _tmp344_;
			ValaCCodeIdentifier* _tmp345_;
			ValaCCodeFunctionCall* _tmp346_;
			ValaCCodeFunctionCall* _tmp347_;
			ValaCCodeIdentifier* _tmp348_;
			ValaCCodeIdentifier* _tmp349_;
			ValaCCodeFunction* _tmp350_;
			ValaCCodeFunction* _tmp351_;
			ValaCCodeMemberAccess* _tmp352_;
			ValaCCodeFunctionCall* _tmp353_;
			ValaCCodeFunction* _tmp354_;
			ValaCCodeFunction* _tmp355_;
			_type_param_index = _type_param_index + 1;
			_tmp247_ = _type_param_index;
			_tmp248_ = _type_param_size;
			if (!(_tmp247_ < _tmp248_)) {
				break;
			}
			_tmp249_ = _type_param_list;
			_tmp250_ = vala_list_get (_tmp249_, _type_param_index);
			type_param = (ValaTypeParameter*) _tmp250_;
			_tmp251_ = type_param;
			_tmp252_ = vala_symbol_get_name ((ValaSymbol*) _tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = g_ascii_strdown (_tmp253_, (gssize) -1);
			_tmp255_ = _tmp254_;
			_tmp256_ = g_strdup_printf ("%s_type", _tmp255_);
			_g_free0 (func_name);
			func_name = _tmp256_;
			_g_free0 (_tmp255_);
			_tmp257_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp258_ = _tmp257_;
			_tmp259_ = func_name;
			_tmp260_ = g_strdup_printf ("%s_%s", _tmp258_, _tmp259_);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_ascii_strup (_tmp261_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp262_;
			_g_free0 (_tmp261_);
			_g_free0 (_tmp258_);
			_tmp263_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp264_ = _tmp263_;
			_tmp265_ = enum_value;
			_tmp266_ = vala_ccode_identifier_new (_tmp265_);
			_tmp267_ = _tmp266_;
			vala_ccode_function_add_case (_tmp264_, (ValaCCodeExpression*) _tmp267_);
			_vala_ccode_node_unref0 (_tmp267_);
			_tmp268_ = vala_ccode_identifier_new ("self");
			_tmp269_ = _tmp268_;
			_tmp270_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp269_, "priv");
			_tmp271_ = _tmp270_;
			_tmp272_ = func_name;
			_tmp273_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp271_, _tmp272_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp273_;
			_vala_ccode_node_unref0 (_tmp271_);
			_vala_ccode_node_unref0 (_tmp269_);
			_tmp274_ = vala_ccode_identifier_new ("g_value_get_gtype");
			_tmp275_ = _tmp274_;
			_tmp276_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp275_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp276_;
			_vala_ccode_node_unref0 (_tmp275_);
			_tmp277_ = cgetcall;
			_tmp278_ = vala_ccode_identifier_new ("value");
			_tmp279_ = _tmp278_;
			vala_ccode_function_call_add_argument (_tmp277_, (ValaCCodeExpression*) _tmp279_);
			_vala_ccode_node_unref0 (_tmp279_);
			_tmp280_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp281_ = _tmp280_;
			_tmp282_ = cfield;
			_tmp283_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp281_, (ValaCCodeExpression*) _tmp282_, (ValaCCodeExpression*) _tmp283_);
			_tmp284_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp285_ = _tmp284_;
			vala_ccode_function_add_break (_tmp285_);
			_tmp286_ = type_param;
			_tmp287_ = vala_symbol_get_name ((ValaSymbol*) _tmp286_);
			_tmp288_ = _tmp287_;
			_tmp289_ = g_ascii_strdown (_tmp288_, (gssize) -1);
			_tmp290_ = _tmp289_;
			_tmp291_ = g_strdup_printf ("%s_dup_func", _tmp290_);
			_g_free0 (func_name);
			func_name = _tmp291_;
			_g_free0 (_tmp290_);
			_tmp292_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp293_ = _tmp292_;
			_tmp294_ = func_name;
			_tmp295_ = g_strdup_printf ("%s_%s", _tmp293_, _tmp294_);
			_tmp296_ = _tmp295_;
			_tmp297_ = g_ascii_strup (_tmp296_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp297_;
			_g_free0 (_tmp296_);
			_g_free0 (_tmp293_);
			_tmp298_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp299_ = _tmp298_;
			_tmp300_ = enum_value;
			_tmp301_ = vala_ccode_identifier_new (_tmp300_);
			_tmp302_ = _tmp301_;
			vala_ccode_function_add_case (_tmp299_, (ValaCCodeExpression*) _tmp302_);
			_vala_ccode_node_unref0 (_tmp302_);
			_tmp303_ = vala_ccode_identifier_new ("self");
			_tmp304_ = _tmp303_;
			_tmp305_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp304_, "priv");
			_tmp306_ = _tmp305_;
			_tmp307_ = func_name;
			_tmp308_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp306_, _tmp307_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp308_;
			_vala_ccode_node_unref0 (_tmp306_);
			_vala_ccode_node_unref0 (_tmp304_);
			_tmp309_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp310_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp311_;
			_vala_ccode_node_unref0 (_tmp310_);
			_tmp312_ = cgetcall;
			_tmp313_ = vala_ccode_identifier_new ("value");
			_tmp314_ = _tmp313_;
			vala_ccode_function_call_add_argument (_tmp312_, (ValaCCodeExpression*) _tmp314_);
			_vala_ccode_node_unref0 (_tmp314_);
			_tmp315_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp316_ = _tmp315_;
			_tmp317_ = cfield;
			_tmp318_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp316_, (ValaCCodeExpression*) _tmp317_, (ValaCCodeExpression*) _tmp318_);
			_tmp319_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp320_ = _tmp319_;
			vala_ccode_function_add_break (_tmp320_);
			_tmp321_ = type_param;
			_tmp322_ = vala_symbol_get_name ((ValaSymbol*) _tmp321_);
			_tmp323_ = _tmp322_;
			_tmp324_ = g_ascii_strdown (_tmp323_, (gssize) -1);
			_tmp325_ = _tmp324_;
			_tmp326_ = g_strdup_printf ("%s_destroy_func", _tmp325_);
			_g_free0 (func_name);
			func_name = _tmp326_;
			_g_free0 (_tmp325_);
			_tmp327_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp328_ = _tmp327_;
			_tmp329_ = func_name;
			_tmp330_ = g_strdup_printf ("%s_%s", _tmp328_, _tmp329_);
			_tmp331_ = _tmp330_;
			_tmp332_ = g_ascii_strup (_tmp331_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp332_;
			_g_free0 (_tmp331_);
			_g_free0 (_tmp328_);
			_tmp333_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp334_ = _tmp333_;
			_tmp335_ = enum_value;
			_tmp336_ = vala_ccode_identifier_new (_tmp335_);
			_tmp337_ = _tmp336_;
			vala_ccode_function_add_case (_tmp334_, (ValaCCodeExpression*) _tmp337_);
			_vala_ccode_node_unref0 (_tmp337_);
			_tmp338_ = vala_ccode_identifier_new ("self");
			_tmp339_ = _tmp338_;
			_tmp340_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp339_, "priv");
			_tmp341_ = _tmp340_;
			_tmp342_ = func_name;
			_tmp343_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp341_, _tmp342_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp343_;
			_vala_ccode_node_unref0 (_tmp341_);
			_vala_ccode_node_unref0 (_tmp339_);
			_tmp344_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp345_ = _tmp344_;
			_tmp346_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp345_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp346_;
			_vala_ccode_node_unref0 (_tmp345_);
			_tmp347_ = cgetcall;
			_tmp348_ = vala_ccode_identifier_new ("value");
			_tmp349_ = _tmp348_;
			vala_ccode_function_call_add_argument (_tmp347_, (ValaCCodeExpression*) _tmp349_);
			_vala_ccode_node_unref0 (_tmp349_);
			_tmp350_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp351_ = _tmp350_;
			_tmp352_ = cfield;
			_tmp353_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp351_, (ValaCCodeExpression*) _tmp352_, (ValaCCodeExpression*) _tmp353_);
			_tmp354_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp355_ = _tmp354_;
			vala_ccode_function_add_break (_tmp355_);
			_vala_ccode_node_unref0 (cgetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
	}
	_tmp356_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp357_ = _tmp356_;
	vala_ccode_function_add_default (_tmp357_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp358_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp359_ = _tmp358_;
	vala_ccode_function_add_break (_tmp359_);
	_tmp360_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp361_ = _tmp360_;
	vala_ccode_function_close (_tmp361_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp362_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp363_ = set_prop;
	vala_ccode_file_add_function_declaration (_tmp362_, _tmp363_);
	_tmp364_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp365_ = set_prop;
	vala_ccode_file_add_function (_tmp364_, _tmp365_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (set_prop);
}

static void
vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self)
{
	ValaCCodeFunctionCall* cwarn = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cwarn = _tmp3_;
	_tmp4_ = vala_ccode_identifier_new ("object");
	_tmp5_ = _tmp4_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_identifier_new ("property_id");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("pspec");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_expression (_tmp11_, (ValaCCodeExpression*) cwarn);
	_vala_ccode_node_unref0 (cwarn);
}

static void
vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                            ValaConstructor* c)
{
	ValaGObjectModule * self;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaClass* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
	cl = _tmp4_;
	_tmp5_ = vala_constructor_get_binding (c);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaClass* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaCCodeBaseModuleEmitContext* _tmp11_;
		ValaCCodeBaseModuleEmitContext* _tmp12_;
		ValaCCodeFunction* function = NULL;
		ValaClass* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeFunction* _tmp18_;
		ValaCCodeFunction* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeParameter* _tmp22_;
		ValaCCodeParameter* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeParameter* _tmp25_;
		ValaCCodeParameter* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeParameter* _tmp28_;
		ValaCCodeParameter* _tmp29_;
		ValaCCodeFile* _tmp30_;
		ValaCCodeFunction* _tmp31_;
		ValaCCodeFunction* _tmp32_;
		ValaCCodeFunction* _tmp33_;
		ValaCCodeFunction* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp35_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeVariableDeclarator* _tmp39_;
		ValaCCodeVariableDeclarator* _tmp40_;
		ValaClass* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp199_;
		ValaCCodeIdentifier* _tmp200_;
		ValaCCodeFunctionCall* _tmp201_;
		ValaCCodeFunctionCall* _tmp202_;
		ValaCCodeFunctionCall* _tmp203_;
		ValaClass* _tmp204_;
		gchar* _tmp205_;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		ValaCCodeIdentifier* _tmp209_;
		ValaCCodeIdentifier* _tmp210_;
		ValaCCodeFunction* _tmp211_;
		ValaCCodeFunction* _tmp212_;
		ValaCCodeIdentifier* _tmp213_;
		ValaCCodeIdentifier* _tmp214_;
		ValaCCodeFunctionCall* _tmp215_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp216_;
		ValaCCodeIdentifier* _tmp217_;
		ValaCCodeMemberAccess* _tmp218_;
		ValaCCodeMemberAccess* _tmp219_;
		ValaCCodeFunctionCall* _tmp220_;
		ValaCCodeFunctionCall* _tmp221_;
		ValaCCodeFunctionCall* _tmp222_;
		ValaCCodeIdentifier* _tmp223_;
		ValaCCodeIdentifier* _tmp224_;
		ValaCCodeFunctionCall* _tmp225_;
		ValaCCodeIdentifier* _tmp226_;
		ValaCCodeIdentifier* _tmp227_;
		ValaCCodeFunctionCall* _tmp228_;
		ValaCCodeIdentifier* _tmp229_;
		ValaCCodeIdentifier* _tmp230_;
		ValaCCodeFunction* _tmp231_;
		ValaCCodeFunction* _tmp232_;
		ValaCCodeIdentifier* _tmp233_;
		ValaCCodeIdentifier* _tmp234_;
		ValaCCodeFunctionCall* _tmp235_;
		ValaCCodeIdentifier* _tmp236_;
		ValaCCodeIdentifier* _tmp237_;
		ValaClass* _tmp238_;
		ValaCCodeFunctionCall* _tmp239_;
		ValaCCodeFunction* _tmp240_;
		ValaCCodeFunction* _tmp241_;
		ValaClass* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		ValaCCodeVariableDeclarator* _tmp247_;
		ValaCCodeVariableDeclarator* _tmp248_;
		ValaCCodeFunction* _tmp249_;
		ValaCCodeFunction* _tmp250_;
		ValaCCodeIdentifier* _tmp251_;
		ValaCCodeIdentifier* _tmp252_;
		ValaCCodeFunctionCall* _tmp253_;
		ValaBlock* _tmp254_;
		ValaBlock* _tmp255_;
		gboolean _tmp256_;
		gboolean _tmp257_;
		ValaClass* _tmp268_;
		gboolean _tmp269_;
		gboolean _tmp270_;
		ValaCCodeFunction* _tmp324_;
		ValaCCodeFunction* _tmp325_;
		ValaCCodeIdentifier* _tmp326_;
		ValaCCodeIdentifier* _tmp327_;
		ValaCCodeFile* _tmp328_;
		ValaCCodeFunction* _tmp329_;
		_tmp7_ = cl;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp7_, _tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			_vala_code_node_unref0 (cl);
			return;
		}
		_tmp11_ = vala_ccode_base_module_emit_context_new ((ValaSymbol*) c);
		_tmp12_ = _tmp11_;
		vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp12_);
		_vala_ccode_base_module_emit_context_unref0 (_tmp12_);
		_tmp13_ = cl;
		_tmp14_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%sconstructor", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_new (_tmp17_, "GObject *");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		function = _tmp19_;
		_tmp20_ = function;
		vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp20_, VALA_CCODE_MODIFIERS_STATIC);
		_tmp21_ = function;
		_tmp22_ = vala_ccode_parameter_new ("type", "GType");
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_parameter (_tmp21_, _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = function;
		_tmp25_ = vala_ccode_parameter_new ("n_construct_properties", "guint");
		_tmp26_ = _tmp25_;
		vala_ccode_function_add_parameter (_tmp24_, _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = function;
		_tmp28_ = vala_ccode_parameter_new ("construct_properties", "GObjectConstructParam *");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_parameter (_tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp31_ = function;
		vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
		_tmp32_ = function;
		vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp32_);
		_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL);
		_tmp36_ = _tmp35_;
		vala_ccode_function_add_declaration (_tmp34_, "GObject *", (ValaCCodeDeclarator*) _tmp36_, 0);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL);
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_declaration (_tmp38_, "GObjectClass *", (ValaCCodeDeclarator*) _tmp40_, 0);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = cl;
		_tmp42_ = vala_class_get_is_singleton (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* singleton_once_name = NULL;
			ValaClass* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValaCCodeDeclaration* singleton_ref = NULL;
			ValaCCodeDeclaration* _tmp59_;
			ValaCCodeDeclaration* _tmp60_;
			const gchar* _tmp61_;
			ValaCCodeConstant* _tmp62_;
			ValaCCodeConstant* _tmp63_;
			ValaCCodeVariableDeclarator* _tmp64_;
			ValaCCodeVariableDeclarator* _tmp65_;
			ValaCCodeDeclaration* _tmp66_;
			ValaCCodeFunction* _tmp67_;
			ValaCCodeFunction* _tmp68_;
			ValaCCodeDeclaration* _tmp69_;
			ValaCCodeDeclaration* mutex_lock = NULL;
			ValaCCodeDeclaration* _tmp70_;
			ValaCCodeDeclaration* _tmp71_;
			const gchar* _tmp72_;
			ValaCCodeVariableDeclarator* _tmp73_;
			ValaCCodeVariableDeclarator* _tmp74_;
			ValaCCodeDeclaration* _tmp75_;
			ValaCCodeFunction* _tmp76_;
			ValaCCodeFunction* _tmp77_;
			ValaCCodeDeclaration* _tmp78_;
			ValaCCodeDeclaration* once_lock = NULL;
			ValaCCodeDeclaration* _tmp79_;
			ValaCCodeDeclaration* _tmp80_;
			const gchar* _tmp81_;
			ValaCCodeConstant* _tmp82_;
			ValaCCodeConstant* _tmp83_;
			ValaCCodeVariableDeclarator* _tmp84_;
			ValaCCodeVariableDeclarator* _tmp85_;
			ValaCCodeDeclaration* _tmp86_;
			ValaCCodeFunction* _tmp87_;
			ValaCCodeFunction* _tmp88_;
			ValaCCodeDeclaration* _tmp89_;
			ValaCCodeFunctionCall* once_init = NULL;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeIdentifier* _tmp91_;
			ValaCCodeFunctionCall* _tmp92_;
			ValaCCodeFunctionCall* _tmp93_;
			ValaCCodeFunctionCall* _tmp94_;
			const gchar* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeIdentifier* _tmp97_;
			ValaCCodeUnaryExpression* _tmp98_;
			ValaCCodeUnaryExpression* _tmp99_;
			ValaCCodeBlock* once_block = NULL;
			ValaCCodeBlock* _tmp100_;
			ValaCCodeFunctionCall* singleton_mutex_init = NULL;
			ValaCCodeIdentifier* _tmp101_;
			ValaCCodeIdentifier* _tmp102_;
			ValaCCodeFunctionCall* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaCCodeFunctionCall* _tmp105_;
			const gchar* _tmp106_;
			ValaCCodeIdentifier* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeUnaryExpression* _tmp109_;
			ValaCCodeUnaryExpression* _tmp110_;
			ValaCCodeBlock* _tmp111_;
			ValaCCodeFunctionCall* _tmp112_;
			ValaCCodeExpressionStatement* _tmp113_;
			ValaCCodeExpressionStatement* _tmp114_;
			ValaCCodeFunctionCall* once_leave = NULL;
			ValaCCodeIdentifier* _tmp115_;
			ValaCCodeIdentifier* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			const gchar* _tmp120_;
			ValaCCodeIdentifier* _tmp121_;
			ValaCCodeIdentifier* _tmp122_;
			ValaCCodeUnaryExpression* _tmp123_;
			ValaCCodeUnaryExpression* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeConstant* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeBlock* _tmp128_;
			ValaCCodeFunctionCall* _tmp129_;
			ValaCCodeExpressionStatement* _tmp130_;
			ValaCCodeExpressionStatement* _tmp131_;
			ValaCCodeIfStatement* if_once = NULL;
			ValaCCodeFunctionCall* _tmp132_;
			ValaCCodeBlock* _tmp133_;
			ValaCCodeIfStatement* _tmp134_;
			ValaCCodeFunction* _tmp135_;
			ValaCCodeFunction* _tmp136_;
			ValaCCodeIfStatement* _tmp137_;
			ValaCCodeFunctionCall* singleton_mutex_lock = NULL;
			ValaCCodeIdentifier* _tmp138_;
			ValaCCodeIdentifier* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaCCodeFunctionCall* _tmp142_;
			const gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeUnaryExpression* _tmp146_;
			ValaCCodeUnaryExpression* _tmp147_;
			ValaCCodeFunction* _tmp148_;
			ValaCCodeFunction* _tmp149_;
			ValaCCodeFunctionCall* _tmp150_;
			ValaCCodeExpressionStatement* _tmp151_;
			ValaCCodeExpressionStatement* _tmp152_;
			ValaCCodeBinaryExpression* check_existance = NULL;
			const gchar* _tmp153_;
			ValaCCodeIdentifier* _tmp154_;
			ValaCCodeIdentifier* _tmp155_;
			ValaCCodeConstant* _tmp156_;
			ValaCCodeConstant* _tmp157_;
			ValaCCodeBinaryExpression* _tmp158_;
			ValaCCodeBinaryExpression* _tmp159_;
			ValaCCodeBlock* return_singleton = NULL;
			ValaCCodeBlock* _tmp160_;
			ValaCCodeFunctionCall* ref_object = NULL;
			ValaCCodeIdentifier* _tmp161_;
			ValaCCodeIdentifier* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			const gchar* _tmp166_;
			ValaCCodeIdentifier* _tmp167_;
			ValaCCodeIdentifier* _tmp168_;
			ValaCCodeBlock* _tmp169_;
			ValaCCodeFunctionCall* _tmp170_;
			ValaCCodeExpressionStatement* _tmp171_;
			ValaCCodeExpressionStatement* _tmp172_;
			ValaCCodeFunctionCall* singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp173_;
			ValaCCodeIdentifier* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeFunctionCall* _tmp176_;
			ValaCCodeFunctionCall* _tmp177_;
			const gchar* _tmp178_;
			ValaCCodeIdentifier* _tmp179_;
			ValaCCodeIdentifier* _tmp180_;
			ValaCCodeUnaryExpression* _tmp181_;
			ValaCCodeUnaryExpression* _tmp182_;
			ValaCCodeBlock* _tmp183_;
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeExpressionStatement* _tmp185_;
			ValaCCodeExpressionStatement* _tmp186_;
			ValaCCodeBlock* _tmp187_;
			const gchar* _tmp188_;
			ValaCCodeIdentifier* _tmp189_;
			ValaCCodeIdentifier* _tmp190_;
			ValaCCodeReturnStatement* _tmp191_;
			ValaCCodeReturnStatement* _tmp192_;
			ValaCCodeIfStatement* if_singleton_alive = NULL;
			ValaCCodeBinaryExpression* _tmp193_;
			ValaCCodeBlock* _tmp194_;
			ValaCCodeIfStatement* _tmp195_;
			ValaCCodeFunction* _tmp196_;
			ValaCCodeFunction* _tmp197_;
			ValaCCodeIfStatement* _tmp198_;
			_tmp44_ = cl;
			_tmp45_ = vala_get_ccode_name ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("%s_singleton__ref", _tmp46_);
			_tmp48_ = _tmp47_;
			_g_free0 (_tmp46_);
			singleton_ref_name = _tmp48_;
			_tmp49_ = cl;
			_tmp50_ = vala_get_ccode_name ((ValaCodeNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_strdup_printf ("%s_singleton__lock", _tmp51_);
			_tmp53_ = _tmp52_;
			_g_free0 (_tmp51_);
			singleton_lock_name = _tmp53_;
			_tmp54_ = cl;
			_tmp55_ = vala_get_ccode_name ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("%s_singleton__volatile", _tmp56_);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			singleton_once_name = _tmp58_;
			_tmp59_ = vala_ccode_declaration_new ("GObject *");
			singleton_ref = _tmp59_;
			_tmp60_ = singleton_ref;
			_tmp61_ = singleton_ref_name;
			_tmp62_ = vala_ccode_constant_new ("NULL");
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_ccode_variable_declarator_new (_tmp61_, (ValaCCodeExpression*) _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			vala_ccode_declaration_add_declarator (_tmp60_, (ValaCCodeDeclarator*) _tmp65_);
			_vala_ccode_node_unref0 (_tmp65_);
			_vala_ccode_node_unref0 (_tmp63_);
			_tmp66_ = singleton_ref;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp66_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = singleton_ref;
			vala_ccode_function_add_statement (_tmp68_, (ValaCCodeNode*) _tmp69_);
			_tmp70_ = vala_ccode_declaration_new ("GMutex");
			mutex_lock = _tmp70_;
			_tmp71_ = mutex_lock;
			_tmp72_ = singleton_lock_name;
			_tmp73_ = vala_ccode_variable_declarator_new (_tmp72_, NULL, NULL);
			_tmp74_ = _tmp73_;
			vala_ccode_declaration_add_declarator (_tmp71_, (ValaCCodeDeclarator*) _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = mutex_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp75_, VALA_CCODE_MODIFIERS_STATIC);
			_tmp76_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = mutex_lock;
			vala_ccode_function_add_statement (_tmp77_, (ValaCCodeNode*) _tmp78_);
			_tmp79_ = vala_ccode_declaration_new ("gsize");
			once_lock = _tmp79_;
			_tmp80_ = once_lock;
			_tmp81_ = singleton_once_name;
			_tmp82_ = vala_ccode_constant_new ("0");
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_ccode_variable_declarator_new (_tmp81_, (ValaCCodeExpression*) _tmp83_, NULL);
			_tmp85_ = _tmp84_;
			vala_ccode_declaration_add_declarator (_tmp80_, (ValaCCodeDeclarator*) _tmp85_);
			_vala_ccode_node_unref0 (_tmp85_);
			_vala_ccode_node_unref0 (_tmp83_);
			_tmp86_ = once_lock;
			vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp86_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
			_tmp87_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp88_ = _tmp87_;
			_tmp89_ = once_lock;
			vala_ccode_function_add_statement (_tmp88_, (ValaCCodeNode*) _tmp89_);
			_tmp90_ = vala_ccode_identifier_new ("g_once_init_enter");
			_tmp91_ = _tmp90_;
			_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
			_tmp93_ = _tmp92_;
			_vala_ccode_node_unref0 (_tmp91_);
			once_init = _tmp93_;
			_tmp94_ = once_init;
			_tmp95_ = singleton_once_name;
			_tmp96_ = vala_ccode_identifier_new (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp97_);
			_tmp99_ = _tmp98_;
			vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp99_);
			_vala_ccode_node_unref0 (_tmp99_);
			_vala_ccode_node_unref0 (_tmp97_);
			_tmp100_ = vala_ccode_block_new ();
			once_block = _tmp100_;
			_tmp101_ = vala_ccode_identifier_new ("g_mutex_init");
			_tmp102_ = _tmp101_;
			_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
			_tmp104_ = _tmp103_;
			_vala_ccode_node_unref0 (_tmp102_);
			singleton_mutex_init = _tmp104_;
			_tmp105_ = singleton_mutex_init;
			_tmp106_ = singleton_lock_name;
			_tmp107_ = vala_ccode_identifier_new (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp108_);
			_tmp110_ = _tmp109_;
			vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp110_);
			_vala_ccode_node_unref0 (_tmp110_);
			_vala_ccode_node_unref0 (_tmp108_);
			_tmp111_ = once_block;
			_tmp112_ = singleton_mutex_init;
			_tmp113_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp112_);
			_tmp114_ = _tmp113_;
			vala_ccode_block_add_statement (_tmp111_, (ValaCCodeNode*) _tmp114_);
			_vala_ccode_node_unref0 (_tmp114_);
			_tmp115_ = vala_ccode_identifier_new ("g_once_init_leave");
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp116_);
			_tmp118_ = _tmp117_;
			_vala_ccode_node_unref0 (_tmp116_);
			once_leave = _tmp118_;
			_tmp119_ = once_leave;
			_tmp120_ = singleton_once_name;
			_tmp121_ = vala_ccode_identifier_new (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (_tmp124_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp125_ = once_leave;
			_tmp126_ = vala_ccode_constant_new ("42");
			_tmp127_ = _tmp126_;
			vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp127_);
			_vala_ccode_node_unref0 (_tmp127_);
			_tmp128_ = once_block;
			_tmp129_ = once_leave;
			_tmp130_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp129_);
			_tmp131_ = _tmp130_;
			vala_ccode_block_add_statement (_tmp128_, (ValaCCodeNode*) _tmp131_);
			_vala_ccode_node_unref0 (_tmp131_);
			_tmp132_ = once_init;
			_tmp133_ = once_block;
			_tmp134_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp132_, (ValaCCodeStatement*) _tmp133_, NULL);
			if_once = _tmp134_;
			_tmp135_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp136_ = _tmp135_;
			_tmp137_ = if_once;
			vala_ccode_function_add_statement (_tmp136_, (ValaCCodeNode*) _tmp137_);
			_tmp138_ = vala_ccode_identifier_new ("g_mutex_lock");
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp139_);
			_tmp141_ = _tmp140_;
			_vala_ccode_node_unref0 (_tmp139_);
			singleton_mutex_lock = _tmp141_;
			_tmp142_ = singleton_mutex_lock;
			_tmp143_ = singleton_lock_name;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp145_);
			_tmp147_ = _tmp146_;
			vala_ccode_function_call_add_argument (_tmp142_, (ValaCCodeExpression*) _tmp147_);
			_vala_ccode_node_unref0 (_tmp147_);
			_vala_ccode_node_unref0 (_tmp145_);
			_tmp148_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = singleton_mutex_lock;
			_tmp151_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_ccode_function_add_statement (_tmp149_, (ValaCCodeNode*) _tmp152_);
			_vala_ccode_node_unref0 (_tmp152_);
			_tmp153_ = singleton_ref_name;
			_tmp154_ = vala_ccode_identifier_new (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_ccode_constant_new ("NULL");
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp155_, (ValaCCodeExpression*) _tmp157_);
			_tmp159_ = _tmp158_;
			_vala_ccode_node_unref0 (_tmp157_);
			_vala_ccode_node_unref0 (_tmp155_);
			check_existance = _tmp159_;
			_tmp160_ = vala_ccode_block_new ();
			return_singleton = _tmp160_;
			_tmp161_ = vala_ccode_identifier_new ("g_object_ref");
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp162_);
			_tmp164_ = _tmp163_;
			_vala_ccode_node_unref0 (_tmp162_);
			ref_object = _tmp164_;
			_tmp165_ = ref_object;
			_tmp166_ = singleton_ref_name;
			_tmp167_ = vala_ccode_identifier_new (_tmp166_);
			_tmp168_ = _tmp167_;
			vala_ccode_function_call_add_argument (_tmp165_, (ValaCCodeExpression*) _tmp168_);
			_vala_ccode_node_unref0 (_tmp168_);
			_tmp169_ = return_singleton;
			_tmp170_ = ref_object;
			_tmp171_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp170_);
			_tmp172_ = _tmp171_;
			vala_ccode_block_add_statement (_tmp169_, (ValaCCodeNode*) _tmp172_);
			_vala_ccode_node_unref0 (_tmp172_);
			_tmp173_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp174_);
			_tmp176_ = _tmp175_;
			_vala_ccode_node_unref0 (_tmp174_);
			singleton_mutex_unlock = _tmp176_;
			_tmp177_ = singleton_mutex_unlock;
			_tmp178_ = singleton_lock_name;
			_tmp179_ = vala_ccode_identifier_new (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp180_);
			_tmp182_ = _tmp181_;
			vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp182_);
			_vala_ccode_node_unref0 (_tmp182_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp183_ = return_singleton;
			_tmp184_ = singleton_mutex_unlock;
			_tmp185_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp184_);
			_tmp186_ = _tmp185_;
			vala_ccode_block_add_statement (_tmp183_, (ValaCCodeNode*) _tmp186_);
			_vala_ccode_node_unref0 (_tmp186_);
			_tmp187_ = return_singleton;
			_tmp188_ = singleton_ref_name;
			_tmp189_ = vala_ccode_identifier_new (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) _tmp190_);
			_tmp192_ = _tmp191_;
			vala_ccode_block_add_statement (_tmp187_, (ValaCCodeNode*) _tmp192_);
			_vala_ccode_node_unref0 (_tmp192_);
			_vala_ccode_node_unref0 (_tmp190_);
			_tmp193_ = check_existance;
			_tmp194_ = return_singleton;
			_tmp195_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) _tmp193_, (ValaCCodeStatement*) _tmp194_, NULL);
			if_singleton_alive = _tmp195_;
			_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp197_ = _tmp196_;
			_tmp198_ = if_singleton_alive;
			vala_ccode_function_add_statement (_tmp197_, (ValaCCodeNode*) _tmp198_);
			_vala_ccode_node_unref0 (if_singleton_alive);
			_vala_ccode_node_unref0 (singleton_mutex_unlock);
			_vala_ccode_node_unref0 (ref_object);
			_vala_ccode_node_unref0 (return_singleton);
			_vala_ccode_node_unref0 (check_existance);
			_vala_ccode_node_unref0 (singleton_mutex_lock);
			_vala_ccode_node_unref0 (if_once);
			_vala_ccode_node_unref0 (once_leave);
			_vala_ccode_node_unref0 (singleton_mutex_init);
			_vala_ccode_node_unref0 (once_block);
			_vala_ccode_node_unref0 (once_init);
			_vala_ccode_node_unref0 (once_lock);
			_vala_ccode_node_unref0 (mutex_lock);
			_vala_ccode_node_unref0 (singleton_ref);
			_g_free0 (singleton_once_name);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp199_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp200_ = _tmp199_;
		_tmp201_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp200_);
		_tmp202_ = _tmp201_;
		_vala_ccode_node_unref0 (_tmp200_);
		ccast = _tmp202_;
		_tmp203_ = ccast;
		_tmp204_ = cl;
		_tmp205_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp204_, NULL);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strdup_printf ("%s_parent_class", _tmp206_);
		_tmp208_ = _tmp207_;
		_tmp209_ = vala_ccode_identifier_new (_tmp208_);
		_tmp210_ = _tmp209_;
		vala_ccode_function_call_add_argument (_tmp203_, (ValaCCodeExpression*) _tmp210_);
		_vala_ccode_node_unref0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
		_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp212_ = _tmp211_;
		_tmp213_ = vala_ccode_identifier_new ("parent_class");
		_tmp214_ = _tmp213_;
		_tmp215_ = ccast;
		vala_ccode_function_add_assignment (_tmp212_, (ValaCCodeExpression*) _tmp214_, (ValaCCodeExpression*) _tmp215_);
		_vala_ccode_node_unref0 (_tmp214_);
		_tmp216_ = vala_ccode_identifier_new ("parent_class");
		_tmp217_ = _tmp216_;
		_tmp218_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp217_, "constructor");
		_tmp219_ = _tmp218_;
		_tmp220_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp219_);
		_tmp221_ = _tmp220_;
		_vala_ccode_node_unref0 (_tmp219_);
		_vala_ccode_node_unref0 (_tmp217_);
		ccall = _tmp221_;
		_tmp222_ = ccall;
		_tmp223_ = vala_ccode_identifier_new ("type");
		_tmp224_ = _tmp223_;
		vala_ccode_function_call_add_argument (_tmp222_, (ValaCCodeExpression*) _tmp224_);
		_vala_ccode_node_unref0 (_tmp224_);
		_tmp225_ = ccall;
		_tmp226_ = vala_ccode_identifier_new ("n_construct_properties");
		_tmp227_ = _tmp226_;
		vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
		_vala_ccode_node_unref0 (_tmp227_);
		_tmp228_ = ccall;
		_tmp229_ = vala_ccode_identifier_new ("construct_properties");
		_tmp230_ = _tmp229_;
		vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp230_);
		_vala_ccode_node_unref0 (_tmp230_);
		_tmp231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp232_ = _tmp231_;
		_tmp233_ = vala_ccode_identifier_new ("obj");
		_tmp234_ = _tmp233_;
		_tmp235_ = ccall;
		vala_ccode_function_add_assignment (_tmp232_, (ValaCCodeExpression*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
		_vala_ccode_node_unref0 (_tmp234_);
		_tmp236_ = vala_ccode_identifier_new ("obj");
		_tmp237_ = _tmp236_;
		_tmp238_ = cl;
		_tmp239_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp237_, (ValaTypeSymbol*) _tmp238_);
		_vala_ccode_node_unref0 (ccall);
		ccall = _tmp239_;
		_vala_ccode_node_unref0 (_tmp237_);
		_tmp240_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp241_ = _tmp240_;
		_tmp242_ = cl;
		_tmp243_ = vala_get_ccode_name ((ValaCodeNode*) _tmp242_);
		_tmp244_ = _tmp243_;
		_tmp245_ = g_strdup_printf ("%s *", _tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
		_tmp248_ = _tmp247_;
		vala_ccode_function_add_declaration (_tmp241_, _tmp246_, (ValaCCodeDeclarator*) _tmp248_, 0);
		_vala_ccode_node_unref0 (_tmp248_);
		_g_free0 (_tmp246_);
		_g_free0 (_tmp244_);
		_tmp249_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_ccode_identifier_new ("self");
		_tmp252_ = _tmp251_;
		_tmp253_ = ccall;
		vala_ccode_function_add_assignment (_tmp250_, (ValaCCodeExpression*) _tmp252_, (ValaCCodeExpression*) _tmp253_);
		_vala_ccode_node_unref0 (_tmp252_);
		_tmp254_ = vala_subroutine_get_body ((ValaSubroutine*) c);
		_tmp255_ = _tmp254_;
		vala_code_node_emit ((ValaCodeNode*) _tmp255_, (ValaCodeGenerator*) self);
		_tmp256_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
		_tmp257_ = _tmp256_;
		if (_tmp257_) {
			ValaCCodeFunction* _tmp258_;
			ValaCCodeFunction* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gchar* _tmp262_;
			gchar* _tmp263_;
			ValaCCodeConstant* _tmp264_;
			ValaCCodeConstant* _tmp265_;
			ValaCCodeVariableDeclarator* _tmp266_;
			ValaCCodeVariableDeclarator* _tmp267_;
			_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
			_tmp261_ = _tmp260_;
			_tmp262_ = g_strdup_printf ("_inner_error%d_", _tmp261_);
			_tmp263_ = _tmp262_;
			_tmp264_ = vala_ccode_constant_new ("NULL");
			_tmp265_ = _tmp264_;
			_tmp266_ = vala_ccode_variable_declarator_new_zero (_tmp263_, (ValaCCodeExpression*) _tmp265_, NULL);
			_tmp267_ = _tmp266_;
			vala_ccode_function_add_declaration (_tmp259_, "GError*", (ValaCCodeDeclarator*) _tmp267_, 0);
			_vala_ccode_node_unref0 (_tmp267_);
			_vala_ccode_node_unref0 (_tmp265_);
			_g_free0 (_tmp263_);
		}
		_tmp268_ = cl;
		_tmp269_ = vala_class_get_is_singleton (_tmp268_);
		_tmp270_ = _tmp269_;
		if (_tmp270_) {
			gchar* singleton_ref_name = NULL;
			ValaClass* _tmp271_;
			gchar* _tmp272_;
			gchar* _tmp273_;
			gchar* _tmp274_;
			gchar* _tmp275_;
			gchar* singleton_lock_name = NULL;
			ValaClass* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			const gchar* _tmp283_;
			ValaCCodeIdentifier* _tmp284_;
			ValaCCodeIdentifier* _tmp285_;
			ValaCCodeIdentifier* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeFunctionCall* set_weak_ref_to_volatile = NULL;
			ValaCCodeIdentifier* _tmp288_;
			ValaCCodeIdentifier* _tmp289_;
			ValaCCodeFunctionCall* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			ValaCCodeFunctionCall* _tmp292_;
			const gchar* _tmp293_;
			ValaCCodeIdentifier* _tmp294_;
			ValaCCodeIdentifier* _tmp295_;
			ValaCCodeFunctionCall* _tmp296_;
			const gchar* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeUnaryExpression* _tmp300_;
			ValaCCodeUnaryExpression* _tmp301_;
			ValaCCodeCastExpression* _tmp302_;
			ValaCCodeCastExpression* _tmp303_;
			ValaCCodeFunction* _tmp304_;
			ValaCCodeFunction* _tmp305_;
			ValaCCodeFunctionCall* _tmp306_;
			ValaCCodeExpressionStatement* _tmp307_;
			ValaCCodeExpressionStatement* _tmp308_;
			ValaCCodeFunctionCall* final_singleton_mutex_unlock = NULL;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeFunctionCall* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			const gchar* _tmp314_;
			ValaCCodeIdentifier* _tmp315_;
			ValaCCodeIdentifier* _tmp316_;
			ValaCCodeUnaryExpression* _tmp317_;
			ValaCCodeUnaryExpression* _tmp318_;
			ValaCCodeFunction* _tmp319_;
			ValaCCodeFunction* _tmp320_;
			ValaCCodeFunctionCall* _tmp321_;
			ValaCCodeExpressionStatement* _tmp322_;
			ValaCCodeExpressionStatement* _tmp323_;
			_tmp271_ = cl;
			_tmp272_ = vala_get_ccode_name ((ValaCodeNode*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("%s_singleton__ref", _tmp273_);
			_tmp275_ = _tmp274_;
			_g_free0 (_tmp273_);
			singleton_ref_name = _tmp275_;
			_tmp276_ = cl;
			_tmp277_ = vala_get_ccode_name ((ValaCodeNode*) _tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = g_strdup_printf ("%s_singleton__lock", _tmp278_);
			_tmp280_ = _tmp279_;
			_g_free0 (_tmp278_);
			singleton_lock_name = _tmp280_;
			_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp282_ = _tmp281_;
			_tmp283_ = singleton_ref_name;
			_tmp284_ = vala_ccode_identifier_new (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = vala_ccode_identifier_new ("obj");
			_tmp287_ = _tmp286_;
			vala_ccode_function_add_assignment (_tmp282_, (ValaCCodeExpression*) _tmp285_, (ValaCCodeExpression*) _tmp287_);
			_vala_ccode_node_unref0 (_tmp287_);
			_vala_ccode_node_unref0 (_tmp285_);
			_tmp288_ = vala_ccode_identifier_new ("g_object_add_weak_pointer");
			_tmp289_ = _tmp288_;
			_tmp290_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp289_);
			_tmp291_ = _tmp290_;
			_vala_ccode_node_unref0 (_tmp289_);
			set_weak_ref_to_volatile = _tmp291_;
			_tmp292_ = set_weak_ref_to_volatile;
			_tmp293_ = singleton_ref_name;
			_tmp294_ = vala_ccode_identifier_new (_tmp293_);
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp292_, (ValaCCodeExpression*) _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
			_tmp296_ = set_weak_ref_to_volatile;
			_tmp297_ = singleton_ref_name;
			_tmp298_ = vala_ccode_identifier_new (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp301_, "gpointer");
			_tmp303_ = _tmp302_;
			vala_ccode_function_call_add_argument (_tmp296_, (ValaCCodeExpression*) _tmp303_);
			_vala_ccode_node_unref0 (_tmp303_);
			_vala_ccode_node_unref0 (_tmp301_);
			_vala_ccode_node_unref0 (_tmp299_);
			_tmp304_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = set_weak_ref_to_volatile;
			_tmp307_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp306_);
			_tmp308_ = _tmp307_;
			vala_ccode_function_add_statement (_tmp305_, (ValaCCodeNode*) _tmp308_);
			_vala_ccode_node_unref0 (_tmp308_);
			_tmp309_ = vala_ccode_identifier_new ("g_mutex_unlock");
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp310_);
			_tmp312_ = _tmp311_;
			_vala_ccode_node_unref0 (_tmp310_);
			final_singleton_mutex_unlock = _tmp312_;
			_tmp313_ = final_singleton_mutex_unlock;
			_tmp314_ = singleton_lock_name;
			_tmp315_ = vala_ccode_identifier_new (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp316_);
			_tmp318_ = _tmp317_;
			vala_ccode_function_call_add_argument (_tmp313_, (ValaCCodeExpression*) _tmp318_);
			_vala_ccode_node_unref0 (_tmp318_);
			_vala_ccode_node_unref0 (_tmp316_);
			_tmp319_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp320_ = _tmp319_;
			_tmp321_ = final_singleton_mutex_unlock;
			_tmp322_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) _tmp321_);
			_tmp323_ = _tmp322_;
			vala_ccode_function_add_statement (_tmp320_, (ValaCCodeNode*) _tmp323_);
			_vala_ccode_node_unref0 (_tmp323_);
			_vala_ccode_node_unref0 (final_singleton_mutex_unlock);
			_vala_ccode_node_unref0 (set_weak_ref_to_volatile);
			_g_free0 (singleton_lock_name);
			_g_free0 (singleton_ref_name);
		}
		_tmp324_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp325_ = _tmp324_;
		_tmp326_ = vala_ccode_identifier_new ("obj");
		_tmp327_ = _tmp326_;
		vala_ccode_function_add_return (_tmp325_, (ValaCCodeExpression*) _tmp327_);
		_vala_ccode_node_unref0 (_tmp327_);
		vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
		_tmp328_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp329_ = function;
		vala_ccode_file_add_function (_tmp328_, _tmp329_);
		vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (ccast);
		_vala_ccode_node_unref0 (function);
	} else {
		ValaMemberBinding _tmp330_;
		ValaMemberBinding _tmp331_;
		_tmp330_ = vala_constructor_get_binding (c);
		_tmp331_ = _tmp330_;
		if (_tmp331_ == VALA_MEMBER_BINDING_CLASS) {
			ValaClass* _tmp332_;
			gboolean _tmp333_;
			gboolean _tmp334_;
			ValaCCodeBaseModuleEmitContext* _tmp337_;
			ValaBlock* _tmp338_;
			ValaBlock* _tmp339_;
			gboolean _tmp340_;
			gboolean _tmp341_;
			_tmp332_ = cl;
			_tmp333_ = vala_class_get_is_compact (_tmp332_);
			_tmp334_ = _tmp333_;
			if (_tmp334_) {
				ValaSourceReference* _tmp335_;
				ValaSourceReference* _tmp336_;
				_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp336_ = _tmp335_;
				vala_report_error (_tmp336_, "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				_vala_code_node_unref0 (cl);
				return;
			}
			_tmp337_ = ((ValaCCodeBaseModule*) self)->base_init_context;
			vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp337_);
			_tmp338_ = vala_subroutine_get_body ((ValaSubroutine*) c);
			_tmp339_ = _tmp338_;
			vala_code_node_emit ((ValaCodeNode*) _tmp339_, (ValaCodeGenerator*) self);
			_tmp340_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
			_tmp341_ = _tmp340_;
			if (_tmp341_) {
				ValaCCodeFunction* _tmp342_;
				ValaCCodeFunction* _tmp343_;
				gint _tmp344_;
				gint _tmp345_;
				gchar* _tmp346_;
				gchar* _tmp347_;
				ValaCCodeConstant* _tmp348_;
				ValaCCodeConstant* _tmp349_;
				ValaCCodeVariableDeclarator* _tmp350_;
				ValaCCodeVariableDeclarator* _tmp351_;
				_tmp342_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
				_tmp345_ = _tmp344_;
				_tmp346_ = g_strdup_printf ("_inner_error%d_", _tmp345_);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_ccode_constant_new ("NULL");
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_ccode_variable_declarator_new_zero (_tmp347_, (ValaCCodeExpression*) _tmp349_, NULL);
				_tmp351_ = _tmp350_;
				vala_ccode_function_add_declaration (_tmp343_, "GError*", (ValaCCodeDeclarator*) _tmp351_, 0);
				_vala_ccode_node_unref0 (_tmp351_);
				_vala_ccode_node_unref0 (_tmp349_);
				_g_free0 (_tmp347_);
			}
			vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		} else {
			ValaMemberBinding _tmp352_;
			ValaMemberBinding _tmp353_;
			_tmp352_ = vala_constructor_get_binding (c);
			_tmp353_ = _tmp352_;
			if (_tmp353_ == VALA_MEMBER_BINDING_STATIC) {
				ValaClass* _tmp354_;
				gboolean _tmp355_;
				gboolean _tmp356_;
				ValaCCodeBaseModuleEmitContext* _tmp359_;
				ValaBlock* _tmp360_;
				ValaBlock* _tmp361_;
				gboolean _tmp362_;
				gboolean _tmp363_;
				_tmp354_ = cl;
				_tmp355_ = vala_class_get_is_compact (_tmp354_);
				_tmp356_ = _tmp355_;
				if (_tmp356_) {
					ValaSourceReference* _tmp357_;
					ValaSourceReference* _tmp358_;
					_tmp357_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
					_tmp358_ = _tmp357_;
					vala_report_error (_tmp358_, "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					_vala_code_node_unref0 (cl);
					return;
				}
				_tmp359_ = ((ValaCCodeBaseModule*) self)->class_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp359_);
				_tmp360_ = vala_subroutine_get_body ((ValaSubroutine*) c);
				_tmp361_ = _tmp360_;
				vala_code_node_emit ((ValaCodeNode*) _tmp361_, (ValaCodeGenerator*) self);
				_tmp362_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
				_tmp363_ = _tmp362_;
				if (_tmp363_) {
					ValaCCodeFunction* _tmp364_;
					ValaCCodeFunction* _tmp365_;
					gint _tmp366_;
					gint _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					ValaCCodeConstant* _tmp370_;
					ValaCCodeConstant* _tmp371_;
					ValaCCodeVariableDeclarator* _tmp372_;
					ValaCCodeVariableDeclarator* _tmp373_;
					_tmp364_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp365_ = _tmp364_;
					_tmp366_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
					_tmp367_ = _tmp366_;
					_tmp368_ = g_strdup_printf ("_inner_error%d_", _tmp367_);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_ccode_constant_new ("NULL");
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_ccode_variable_declarator_new_zero (_tmp369_, (ValaCCodeExpression*) _tmp371_, NULL);
					_tmp373_ = _tmp372_;
					vala_ccode_function_add_declaration (_tmp365_, "GError*", (ValaCCodeDeclarator*) _tmp373_, 0);
					_vala_ccode_node_unref0 (_tmp373_);
					_vala_ccode_node_unref0 (_tmp371_);
					_g_free0 (_tmp369_);
				}
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
			} else {
				ValaSourceReference* _tmp374_;
				ValaSourceReference* _tmp375_;
				_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp375_ = _tmp374_;
				vala_report_error (_tmp375_, "internal error: constructors must have instance, class, or static bind" \
"ing");
			}
		}
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (cl);
}

static gchar*
vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* getter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeModifiers _tmp24_;
	ValaCCodeModifiers _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeParameter* _tmp31_;
	ValaCCodeParameter* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFile* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFile* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_get_%s%d", _tmp12_, _tmp13_);
	getter_cname = _tmp14_;
	_tmp15_ = getter_cname;
	_tmp16_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_new (_tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	func = _tmp21_;
	_tmp22_ = func;
	_tmp23_ = func;
	_tmp24_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp23_, _tmp25_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp26_ = func;
	_tmp27_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_parameter_new ("obj", _tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp33_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp39_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = vala_ccode_identifier_new ("g_object_get");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("obj");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = call;
	_tmp53_ = vala_ccode_identifier_new ("result");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp57_ = call;
	_tmp58_ = vala_ccode_constant_new ("NULL");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp57_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = call;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) _tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_identifier_new ("result");
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_return (_tmp64_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp67_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp68_ = func;
	vala_ccode_file_add_function_declaration (_tmp67_, _tmp68_);
	_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp70_ = func;
	vala_ccode_file_add_function (_tmp69_, _tmp70_);
	result = getter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* setter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* _tmp18_;
	ValaCCodeModifiers _tmp19_;
	ValaCCodeModifiers _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeParameter* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeParameter* _tmp33_;
	ValaCCodeParameter* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFile* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_set_%s%d", _tmp12_, _tmp13_);
	setter_cname = _tmp14_;
	_tmp15_ = setter_cname;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "void");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = func;
	_tmp19_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp18_, _tmp20_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp21_ = func;
	_tmp22_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_get_ccode_name ((ValaCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_parameter_new ("obj", _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_parameter (_tmp21_, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = func;
	_tmp29_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_parameter_new ("value", _tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_parameter (_tmp28_, _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_object_set");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	call = _tmp39_;
	_tmp40_ = call;
	_tmp41_ = vala_ccode_identifier_new ("obj");
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = call;
	_tmp44_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("value");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = call;
	vala_ccode_function_add_expression (_tmp53_, (ValaCCodeExpression*) _tmp54_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = func;
	vala_ccode_file_add_function_declaration (_tmp55_, _tmp56_);
	_tmp57_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp58_ = func;
	vala_ccode_file_add_function (_tmp57_, _tmp58_);
	result = setter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                   ValaDynamicSignal* node)
{
	ValaGObjectModule * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) node);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->signal_wrapper_id;
	self->priv->signal_wrapper_id = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("dynamic_%s%d_", _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                  ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, FALSE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                        ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	gchar* result = NULL;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_type_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_type_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect_after", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, TRUE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}

static void
vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                      ValaDynamicSignal* sig,
                                                      gboolean after)
{
	ValaMethod* m = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* _tmp4_;
	gchar* connect_func = NULL;
	gchar* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaCCodeFunctionCall* call = NULL;
	const gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMemberBinding _tmp29_;
	ValaMemberBinding _tmp30_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_dynamic_signal_get_handler (sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp5_ = g_strdup ("g_signal_connect_object");
	connect_func = _tmp5_;
	_tmp6_ = m;
	_tmp7_ = vala_method_get_binding (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("g_signal_connect");
			_g_free0 (connect_func);
			connect_func = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("g_signal_connect_after");
			_g_free0 (connect_func);
			connect_func = _tmp10_;
		}
	}
	_tmp11_ = connect_func;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	call = _tmp15_;
	_tmp16_ = call;
	_tmp17_ = vala_ccode_identifier_new ("obj");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = call;
	_tmp20_ = vala_ccode_identifier_new ("signal_name");
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, (ValaCCodeExpression*) _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = call;
	_tmp23_ = vala_ccode_identifier_new ("handler");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = call;
	_tmp26_ = vala_ccode_identifier_new ("data");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = m;
	_tmp29_ = vala_method_get_binding (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			_tmp31_ = call;
			_tmp32_ = vala_ccode_constant_new ("0");
			_tmp33_ = _tmp32_;
			vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeConstant* _tmp36_;
			_tmp34_ = call;
			_tmp35_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp36_ = _tmp35_;
			vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
		}
	}
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = call;
	vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (connect_func);
	_vala_code_node_unref0 (m);
}

static void
vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                         ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaSemanticAnalyzer* _tmp3_;
	ValaSemanticAnalyzer* _tmp4_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
	_tmp1_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_analyzer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (vala_semantic_analyzer_is_gobject_property (_tmp4_, prop)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValaCCodeEnumValue* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		_tmp7_ = ((ValaCCodeBaseModule*) self)->prop_enum;
		_tmp8_ = vala_get_ccode_upper_case_name ((ValaSymbol*) prop, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s_PROPERTY", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_enum_value_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		vala_ccode_enum_add_value (_tmp7_, _tmp13_);
		_vala_ccode_node_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
}

static void
vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGObjectModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaMemberAccess* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp3_);
		_tmp4_ = vala_method_call_get_call (expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
		ma = _tmp6_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaMemberAccess* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp12_ = ma;
			_tmp13_ = vala_member_access_get_inner (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			ValaMemberAccess* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = ma;
			_tmp22_ = vala_member_access_get_member_name (_tmp21_);
			_tmp23_ = _tmp22_;
			if (g_strcmp0 (_tmp23_, "new") == 0) {
				_tmp20_ = TRUE;
			} else {
				ValaMemberAccess* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = ma;
				_tmp25_ = vala_member_access_get_member_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = g_strcmp0 (_tmp26_, "newv") == 0;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp19_ = g_strcmp0 (_tmp29_, "new_valist") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				ValaMemberAccess* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = ma;
				_tmp31_ = vala_member_access_get_member_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp18_ = g_strcmp0 (_tmp32_, "new_with_properties") == 0;
			}
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaCCodeFunctionCall* initiallyunowned_ccall = NULL;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeExpression* _tmp38_;
			ValaCCodeFunctionCall* sink_ref_ccall = NULL;
			ValaCCodeIdentifier* _tmp39_;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeFunctionCall* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeExpression* _tmp44_;
			ValaCCodeConditionalExpression* cexpr = NULL;
			ValaCCodeFunctionCall* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_;
			ValaCCodeExpression* _tmp47_;
			ValaCCodeConditionalExpression* _tmp48_;
			ValaDataType* _tmp49_;
			ValaDataType* _tmp50_;
			ValaCCodeConditionalExpression* _tmp51_;
			ValaGLibValue* _tmp52_;
			ValaGLibValue* _tmp53_;
			ValaTargetValue* _tmp54_;
			ValaTargetValue* _tmp55_;
			VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
			_tmp33_ = vala_ccode_identifier_new ("G_IS_INITIALLY_UNOWNED");
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			initiallyunowned_ccall = _tmp36_;
			_tmp37_ = initiallyunowned_ccall;
			_tmp38_ = vala_get_cvalue ((ValaExpression*) expr);
			vala_ccode_function_call_add_argument (_tmp37_, _tmp38_);
			_tmp39_ = vala_ccode_identifier_new ("g_object_ref_sink");
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp40_);
			_tmp42_ = _tmp41_;
			_vala_ccode_node_unref0 (_tmp40_);
			sink_ref_ccall = _tmp42_;
			_tmp43_ = sink_ref_ccall;
			_tmp44_ = vala_get_cvalue ((ValaExpression*) expr);
			vala_ccode_function_call_add_argument (_tmp43_, _tmp44_);
			_tmp45_ = initiallyunowned_ccall;
			_tmp46_ = sink_ref_ccall;
			_tmp47_ = vala_get_cvalue ((ValaExpression*) expr);
			_tmp48_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp45_, (ValaCCodeExpression*) _tmp46_, _tmp47_);
			cexpr = _tmp48_;
			_tmp49_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp50_ = _tmp49_;
			_tmp51_ = cexpr;
			_tmp52_ = vala_glib_value_new (_tmp50_, (ValaCCodeExpression*) _tmp51_, FALSE);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp53_, (ValaCodeNode*) expr, NULL);
			_tmp55_ = _tmp54_;
			vala_expression_set_target_value ((ValaExpression*) expr, _tmp55_);
			_vala_target_value_unref0 (_tmp55_);
			_vala_target_value_unref0 (_tmp53_);
			_vala_ccode_node_unref0 (cexpr);
			_vala_ccode_node_unref0 (sink_ref_ccall);
			_vala_ccode_node_unref0 (initiallyunowned_ccall);
			_vala_code_node_unref0 (ma);
			return;
		} else {
			ValaMemberAccess* _tmp56_;
			ValaSymbol* _tmp57_;
			ValaSymbol* _tmp58_;
			ValaTypeSymbol* _tmp59_;
			_tmp56_ = ma;
			_tmp57_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			if (_tmp58_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				{
					ValaList* _arg_list = NULL;
					ValaList* _tmp60_;
					gint _arg_size = 0;
					ValaList* _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					gint _arg_index = 0;
					_tmp60_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) expr);
					_arg_list = _tmp60_;
					_tmp61_ = _arg_list;
					_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
					_tmp63_ = _tmp62_;
					_arg_size = _tmp63_;
					_arg_index = -1;
					while (TRUE) {
						gint _tmp64_;
						gint _tmp65_;
						ValaExpression* arg = NULL;
						ValaList* _tmp66_;
						gpointer _tmp67_;
						ValaNamedArgument* named_argument = NULL;
						ValaExpression* _tmp68_;
						ValaNamedArgument* _tmp69_;
						ValaNamedArgument* _tmp70_;
						ValaProperty* prop = NULL;
						ValaClass* _tmp74_;
						ValaClass* _tmp75_;
						ValaNamedArgument* _tmp76_;
						const gchar* _tmp77_;
						const gchar* _tmp78_;
						ValaSymbol* _tmp79_;
						ValaProperty* _tmp80_;
						ValaProperty* _tmp81_;
						ValaCodeContext* _tmp92_;
						ValaCodeContext* _tmp93_;
						ValaSemanticAnalyzer* _tmp94_;
						ValaSemanticAnalyzer* _tmp95_;
						ValaProperty* _tmp96_;
						ValaExpression* _tmp103_;
						ValaDataType* _tmp104_;
						ValaDataType* _tmp105_;
						ValaProperty* _tmp106_;
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						_arg_index = _arg_index + 1;
						_tmp64_ = _arg_index;
						_tmp65_ = _arg_size;
						if (!(_tmp64_ < _tmp65_)) {
							break;
						}
						_tmp66_ = _arg_list;
						_tmp67_ = vala_list_get (_tmp66_, _arg_index);
						arg = (ValaExpression*) _tmp67_;
						_tmp68_ = arg;
						_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_NAMED_ARGUMENT) ? ((ValaNamedArgument*) _tmp68_) : NULL);
						named_argument = _tmp69_;
						_tmp70_ = named_argument;
						if (_tmp70_ == NULL) {
							ValaExpression* _tmp71_;
							ValaSourceReference* _tmp72_;
							ValaSourceReference* _tmp73_;
							_tmp71_ = arg;
							_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
							_tmp73_ = _tmp72_;
							vala_report_error (_tmp73_, "Named argument expected");
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp74_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp75_ = _tmp74_;
						_tmp76_ = named_argument;
						_tmp77_ = vala_named_argument_get_name (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp75_, _tmp78_);
						_tmp80_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp79_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp79_) : NULL;
						if (_tmp80_ == NULL) {
							_vala_code_node_unref0 (_tmp79_);
						}
						prop = _tmp80_;
						_tmp81_ = prop;
						if (_tmp81_ == NULL) {
							ValaExpression* _tmp82_;
							ValaSourceReference* _tmp83_;
							ValaSourceReference* _tmp84_;
							ValaNamedArgument* _tmp85_;
							const gchar* _tmp86_;
							const gchar* _tmp87_;
							ValaClass* _tmp88_;
							ValaClass* _tmp89_;
							gchar* _tmp90_;
							gchar* _tmp91_;
							_tmp82_ = arg;
							_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = named_argument;
							_tmp86_ = vala_named_argument_get_name (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp89_ = _tmp88_;
							_tmp90_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp89_);
							_tmp91_ = _tmp90_;
							vala_report_error (_tmp84_, "Property `%s' not found in `%s'", _tmp87_, _tmp91_);
							_g_free0 (_tmp91_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp92_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
						_tmp93_ = _tmp92_;
						_tmp94_ = vala_code_context_get_analyzer (_tmp93_);
						_tmp95_ = _tmp94_;
						_tmp96_ = prop;
						if (!vala_semantic_analyzer_is_gobject_property (_tmp95_, _tmp96_)) {
							ValaExpression* _tmp97_;
							ValaSourceReference* _tmp98_;
							ValaSourceReference* _tmp99_;
							ValaNamedArgument* _tmp100_;
							const gchar* _tmp101_;
							const gchar* _tmp102_;
							_tmp97_ = arg;
							_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = named_argument;
							_tmp101_ = vala_named_argument_get_name (_tmp100_);
							_tmp102_ = _tmp101_;
							vala_report_error (_tmp99_, "Property `%s' not supported in Object (property: value) constructor ch" \
"ain up", _tmp102_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp103_ = arg;
						_tmp104_ = vala_expression_get_value_type (_tmp103_);
						_tmp105_ = _tmp104_;
						_tmp106_ = prop;
						_tmp107_ = vala_property_get_property_type (_tmp106_);
						_tmp108_ = _tmp107_;
						if (!vala_data_type_compatible (_tmp105_, _tmp108_)) {
							ValaExpression* _tmp109_;
							ValaSourceReference* _tmp110_;
							ValaSourceReference* _tmp111_;
							ValaExpression* _tmp112_;
							ValaDataType* _tmp113_;
							ValaDataType* _tmp114_;
							gchar* _tmp115_;
							gchar* _tmp116_;
							ValaProperty* _tmp117_;
							ValaDataType* _tmp118_;
							ValaDataType* _tmp119_;
							gchar* _tmp120_;
							gchar* _tmp121_;
							_tmp109_ = arg;
							_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp109_);
							_tmp111_ = _tmp110_;
							_tmp112_ = arg;
							_tmp113_ = vala_expression_get_value_type (_tmp112_);
							_tmp114_ = _tmp113_;
							_tmp115_ = vala_code_node_to_string ((ValaCodeNode*) _tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = prop;
							_tmp118_ = vala_property_get_property_type (_tmp117_);
							_tmp119_ = _tmp118_;
							_tmp120_ = vala_code_node_to_string ((ValaCodeNode*) _tmp119_);
							_tmp121_ = _tmp120_;
							vala_report_error (_tmp111_, "Cannot convert from `%s' to `%s'", _tmp116_, _tmp121_);
							_g_free0 (_tmp121_);
							_g_free0 (_tmp116_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (named_argument);
						_vala_code_node_unref0 (arg);
					}
				}
			}
		}
		vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
		_vala_code_node_unref0 (ma);
	}
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
}

ValaGObjectModule*
vala_gobject_module_construct (GType object_type)
{
	ValaGObjectModule* self = NULL;
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type);
	return self;
}

ValaGObjectModule*
vala_gobject_module_new (void)
{
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE);
}

static void
vala_gobject_module_class_init (ValaGObjectModuleClass * klass,
                                gpointer klass_data)
{
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gobject_module_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGObjectModule_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_gobject_module_real_visit_class;
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule*, ValaClass*)) vala_gobject_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_gobject_module_real_visit_constructor;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_getter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_getter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_setter_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_setter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_cname = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_after_wrapper_name = (gchar* (*) (ValaCCodeBaseModule*, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_gobject_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gobject_module_real_visit_method_call;
}

static void
vala_gobject_module_instance_init (ValaGObjectModule * self,
                                   gpointer klass)
{
	self->priv = vala_gobject_module_get_instance_private (self);
}

static void
vala_gobject_module_finalize (ValaCodeVisitor * obj)
{
	ValaGObjectModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}

static GType
vala_gobject_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
	GType vala_gobject_module_type_id;
	vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
	ValaGObjectModule_private_offset = g_type_add_instance_private (vala_gobject_module_type_id, sizeof (ValaGObjectModulePrivate));
	return vala_gobject_module_type_id;
}

GType
vala_gobject_module_get_type (void)
{
	static volatile gsize vala_gobject_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gobject_module_type_id__volatile)) {
		GType vala_gobject_module_type_id;
		vala_gobject_module_type_id = vala_gobject_module_get_type_once ();
		g_once_init_leave (&vala_gobject_module_type_id__volatile, vala_gobject_module_type_id);
	}
	return vala_gobject_module_type_id__volatile;
}

