/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaLocalVariable* l = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaConstant* _tmp6_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	l = VALA_IS_LOCAL_VARIABLE (_tmp3_) ? ((ValaLocalVariable*) _tmp3_) : NULL;
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	m = VALA_IS_METHOD (_tmp5_) ? ((ValaMethod*) _tmp5_) : NULL;
	_tmp6_ = c;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaConstant* _tmp8_;
		_tmp8_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaConstant* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp9_ = c;
			_tmp10_ = vala_constant_get_type_reference (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_data_type_get_nullable (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp7_ = !_tmp13_;
		}
		result = _tmp7_;
		return result;
	} else {
		ValaLocalVariable* _tmp14_;
		_tmp14_ = l;
		if (_tmp14_ != NULL) {
			ValaDataType* type = NULL;
			ValaLocalVariable* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			_tmp15_ = l;
			_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) _tmp15_);
			_tmp17_ = _tmp16_;
			type = _tmp17_;
			_tmp18_ = type;
			if (VALA_IS_ARRAY_TYPE (_tmp18_)) {
				ValaDataType* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = type;
				_tmp20_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp21_ = _tmp20_;
				result = _tmp21_;
				return result;
			} else {
				gboolean _tmp22_ = FALSE;
				ValaDataType* _tmp23_;
				_tmp23_ = type;
				if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
					_tmp22_ = TRUE;
				} else {
					ValaDataType* _tmp24_;
					_tmp24_ = type;
					_tmp22_ = vala_data_type_is_non_null_simple_type (_tmp24_);
				}
				result = _tmp22_;
				return result;
			}
		} else {
			ValaMethod* _tmp25_;
			_tmp25_ = m;
			if (_tmp25_ != NULL) {
				gboolean _tmp26_ = FALSE;
				ValaMethod* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = m;
				_tmp28_ = vala_method_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_;
					_tmp30_ = self->priv->_prototype_access;
					_tmp26_ = _tmp30_;
				}
				result = _tmp26_;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp701_ = FALSE;
	gboolean _tmp702_ = FALSE;
	gboolean _tmp703_ = FALSE;
	ValaExpression* _tmp704_;
	ValaExpression* _tmp705_;
	ValaSymbol* _tmp732_;
	ValaSymbol* _tmp733_;
	ValaSymbol* _tmp802_;
	ValaSymbol* _tmp803_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp839_;
	ValaSymbol* _tmp840_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp841_;
	ValaSymbol* _tmp842_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1290_;
	ValaSymbol* _tmp1291_;
	ValaSymbol* _tmp1293_;
	ValaVersionAttribute* _tmp1294_;
	ValaVersionAttribute* _tmp1295_;
	ValaSourceReference* _tmp1296_;
	ValaSourceReference* _tmp1297_;
	gboolean _tmp1298_ = FALSE;
	gboolean _tmp1349_ = FALSE;
	gboolean _tmp1376_ = FALSE;
	gboolean _tmp1377_ = FALSE;
	ValaDataType* _tmp1678_;
	ValaDataType* _tmp1679_;
	gboolean _tmp1682_;
	gboolean _tmp1683_;
	gboolean _tmp1684_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp300_ = FALSE;
			ValaExpression* _tmp301_;
			ValaExpression* _tmp302_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp332_ = FALSE;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			gboolean _tmp353_ = FALSE;
			ValaSymbol* _tmp354_;
			ValaSymbol* _tmp355_;
			gboolean _tmp389_ = FALSE;
			gboolean _tmp390_ = FALSE;
			ValaSymbol* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp667_;
			ValaSymbol* _tmp668_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaPointerIndirection* _tmp282_;
					ValaPointerIndirection* _tmp283_;
					ValaExpression* _tmp284_;
					ValaExpression* _tmp285_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_formal_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					if (VALA_IS_GENERIC_TYPE (_tmp268_)) {
						ValaExpression* _tmp269_;
						ValaExpression* _tmp270_;
						ValaPointerType* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaCastExpression* _tmp276_;
						ValaCastExpression* _tmp277_;
						_tmp269_ = vala_member_access_get_inner (self);
						_tmp270_ = _tmp269_;
						_tmp271_ = pointer_type;
						_tmp272_ = vala_data_type_copy ((ValaDataType*) _tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_cast_expression_new (_tmp270_, _tmp273_, _tmp275_);
						_tmp277_ = _tmp276_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp281_ = _tmp280_;
					_tmp282_ = vala_pointer_indirection_new (_tmp279_, _tmp281_);
					_tmp283_ = _tmp282_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp283_);
					_vala_code_node_unref0 (_tmp283_);
					_tmp284_ = vala_member_access_get_inner (self);
					_tmp285_ = _tmp284_;
					vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaMemberAccess* _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp290_ = ma;
				_tmp291_ = _tmp290_->priv->_prototype_access;
				if (_tmp291_) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaExpression* _tmp294_;
					ValaExpression* _tmp295_;
					ValaSymbol* _tmp296_;
					ValaSymbol* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_member_access_get_inner (self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_symbol_get_full_name (_tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_error (_tmp293_, "Access to instance member `%s' denied", _tmp299_);
					_g_free0 (_tmp299_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp301_ = vala_member_access_get_inner (self);
			_tmp302_ = _tmp301_;
			if (VALA_IS_CAST_EXPRESSION (_tmp302_)) {
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				_tmp303_ = vala_member_access_get_inner (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp304_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp306_ = _tmp305_;
				_tmp300_ = _tmp306_;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_warning (_tmp308_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_MEMBER_ACCESS (_tmp311_)) {
				_tmp309_ = TRUE;
			} else {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp309_ = VALA_IS_BASE_ACCESS (_tmp313_);
			}
			if (_tmp309_) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaSymbol* _tmp316_;
				ValaSymbol* _tmp317_;
				gboolean _tmp318_ = FALSE;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_symbol_reference (_tmp315_);
				_tmp317_ = _tmp316_;
				base_symbol = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp320_ = _tmp319_;
				if (_tmp320_ == NULL) {
					gboolean _tmp321_ = FALSE;
					ValaSymbol* _tmp322_;
					_tmp322_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp322_)) {
						_tmp321_ = TRUE;
					} else {
						ValaSymbol* _tmp323_;
						_tmp323_ = base_symbol;
						_tmp321_ = VALA_IS_TYPESYMBOL (_tmp323_);
					}
					_tmp318_ = _tmp321_;
				} else {
					_tmp318_ = FALSE;
				}
				if (_tmp318_) {
					ValaSymbol* _tmp324_;
					ValaScope* _tmp325_;
					ValaScope* _tmp326_;
					const gchar* _tmp327_;
					ValaSymbol* _tmp328_;
					ValaSymbol* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp324_ = base_symbol;
					_tmp325_ = vala_symbol_get_scope (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = self->priv->_member_name;
					_tmp328_ = vala_scope_lookup (_tmp326_, _tmp327_);
					_tmp329_ = _tmp328_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = vala_member_access_get_inner (self);
					_tmp331_ = _tmp330_;
					if (VALA_IS_BASE_ACCESS (_tmp331_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp333_ = vala_member_access_get_inner (self);
			_tmp334_ = _tmp333_;
			if (VALA_IS_MEMBER_ACCESS (_tmp334_)) {
				ValaExpression* _tmp335_;
				ValaExpression* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaSymbol* _tmp338_;
				_tmp335_ = vala_member_access_get_inner (self);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_expression_get_symbol_reference (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp332_ = VALA_IS_TYPEPARAMETER (_tmp338_);
			} else {
				_tmp332_ = FALSE;
			}
			if (_tmp332_) {
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				ValaGenericType* _tmp345_;
				ValaGenericType* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaDataType* _tmp349_;
				ValaDataType* _tmp350_;
				ValaSourceReference* _tmp351_;
				ValaSourceReference* _tmp352_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp344_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp346_ = _tmp345_;
				vala_expression_set_value_type (_tmp340_, (ValaDataType*) _tmp346_);
				_vala_code_node_unref0 (_tmp346_);
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_value_type (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp352_ = _tmp351_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp350_, _tmp352_);
			}
			_tmp354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp355_ = _tmp354_;
			if (_tmp355_ == NULL) {
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp353_ = _tmp359_ != NULL;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				gboolean _tmp360_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp360_ = self->priv->_pointer_member_access;
				if (_tmp360_) {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					const gchar* _tmp365_;
					ValaSymbol* _tmp366_;
					ValaSymbol* _tmp367_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = self->priv->_member_name;
					_tmp366_ = vala_data_type_get_pointer_member (_tmp364_, _tmp365_);
					_tmp367_ = _tmp366_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
				} else {
					ValaExpression* _tmp368_;
					ValaExpression* _tmp369_;
					ValaDataType* _tmp370_;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaExpression* _tmp380_;
					ValaExpression* _tmp381_;
					ValaDataType* _tmp382_;
					ValaDataType* _tmp383_;
					const gchar* _tmp384_;
					ValaSymbol* _tmp385_;
					ValaSymbol* _tmp386_;
					_tmp368_ = vala_member_access_get_inner (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_expression_get_value_type (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_data_type_get_type_symbol (_tmp371_);
					_tmp373_ = _tmp372_;
					if (_tmp373_ != NULL) {
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaTypeSymbol* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						_tmp374_ = vala_member_access_get_inner (self);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_expression_get_value_type (_tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						base_symbol = (ValaSymbol*) _tmp379_;
					}
					_tmp380_ = vala_member_access_get_inner (self);
					_tmp381_ = _tmp380_;
					_tmp382_ = vala_expression_get_value_type (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = self->priv->_member_name;
					_tmp385_ = vala_data_type_get_member (_tmp383_, _tmp384_);
					_tmp386_ = _tmp385_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp386_);
					_vala_code_node_unref0 (_tmp386_);
				}
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp388_ = _tmp387_;
				if (_tmp388_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp392_ = _tmp391_;
			if (_tmp392_ == NULL) {
				ValaExpression* _tmp393_;
				ValaExpression* _tmp394_;
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp393_ = vala_member_access_get_inner (self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_expression_get_value_type (_tmp394_);
				_tmp396_ = _tmp395_;
				_tmp390_ = _tmp396_ != NULL;
			} else {
				_tmp390_ = FALSE;
			}
			if (_tmp390_) {
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp397_ = vala_member_access_get_inner (self);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_is_dynamic (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp389_ = _tmp402_;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaObjectType* _tmp407_;
				ValaCodeNode* _tmp408_;
				ValaCodeNode* _tmp409_;
				ValaSymbol* _tmp602_;
				ValaSymbol* _tmp603_;
				ValaSymbol* _tmp665_;
				ValaSymbol* _tmp666_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp407_;
				_tmp408_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				if (VALA_IS_METHOD_CALL (_tmp409_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					ValaMethodCall* _tmp412_;
					ValaExpression* _tmp413_;
					ValaExpression* _tmp414_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp412_ = invoc;
					_tmp413_ = vala_method_call_get_call (_tmp412_);
					_tmp414_ = _tmp413_;
					if (_tmp414_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp415_;
						ValaDataType* _tmp416_;
						ValaDataType* _tmp417_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp432_;
						ValaExpression* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						const gchar* _tmp436_;
						ValaDataType* _tmp437_;
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaMethodCall* _tmp442_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp443_;
						ValaSourceReference* _tmp444_;
						ValaSourceReference* _tmp445_;
						ValaErrorType* _tmp446_;
						ValaErrorType* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaParameter* _tmp452_;
						ValaParameter* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaObjectType* _tmp455_;
						ValaDataType* _tmp456_;
						ValaDataType* _tmp457_;
						ValaDynamicMethod* _tmp458_;
						ValaSourceReference* _tmp459_;
						ValaSourceReference* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaObjectType* _tmp463_;
						ValaTypeSymbol* _tmp464_;
						ValaTypeSymbol* _tmp465_;
						ValaScope* _tmp466_;
						ValaScope* _tmp467_;
						ValaDynamicMethod* _tmp468_;
						ValaDynamicMethod* _tmp469_;
						_tmp415_ = invoc;
						_tmp416_ = vala_expression_get_target_type ((ValaExpression*) _tmp415_);
						_tmp417_ = _tmp416_;
						if (_tmp417_ != NULL) {
							ValaMethodCall* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							_tmp418_ = invoc;
							_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_copy (_tmp420_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp421_;
							_tmp422_ = ret_type;
							vala_data_type_set_value_owned (_tmp422_, TRUE);
						} else {
							ValaMethodCall* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp423_ = invoc;
							_tmp424_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp423_);
							_tmp425_ = _tmp424_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp425_)) {
								ValaVoidType* _tmp426_;
								_tmp426_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp426_;
							} else {
								ValaExpression* _tmp427_;
								ValaExpression* _tmp428_;
								ValaDataType* _tmp429_;
								ValaDataType* _tmp430_;
								ValaDataType* _tmp431_;
								_tmp427_ = vala_member_access_get_inner (self);
								_tmp428_ = _tmp427_;
								_tmp429_ = vala_expression_get_value_type (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_data_type_copy (_tmp430_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp431_;
							}
						}
						_tmp432_ = vala_member_access_get_inner (self);
						_tmp433_ = _tmp432_;
						_tmp434_ = vala_expression_get_value_type (_tmp433_);
						_tmp435_ = _tmp434_;
						_tmp436_ = self->priv->_member_name;
						_tmp437_ = ret_type;
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_dynamic_method_new (_tmp435_, _tmp436_, _tmp437_, _tmp439_, NULL);
						m = _tmp440_;
						_tmp441_ = m;
						_tmp442_ = invoc;
						vala_dynamic_method_set_invocation (_tmp441_, _tmp442_);
						_tmp443_ = m;
						_tmp444_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp443_);
						_tmp445_ = _tmp444_;
						_tmp446_ = vala_error_type_new (NULL, NULL, _tmp445_);
						err = _tmp446_;
						_tmp447_ = err;
						vala_error_type_set_dynamic_error (_tmp447_, TRUE);
						_tmp448_ = m;
						_tmp449_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp448_, (ValaDataType*) _tmp449_);
						_tmp450_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp450_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp451_ = m;
						_tmp452_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp453_ = _tmp452_;
						vala_callable_add_parameter ((ValaCallable*) _tmp451_, _tmp453_);
						_vala_code_node_unref0 (_tmp453_);
						_tmp454_ = m;
						_tmp455_ = dynamic_object_type;
						_tmp456_ = vala_data_type_copy ((ValaDataType*) _tmp455_);
						_tmp457_ = _tmp456_;
						_tmp458_ = m;
						_tmp459_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = vala_parameter_new ("this", _tmp457_, _tmp460_);
						_tmp462_ = _tmp461_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp454_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_vala_code_node_unref0 (_tmp457_);
						_tmp463_ = dynamic_object_type;
						_tmp464_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp463_);
						_tmp465_ = _tmp464_;
						_tmp466_ = vala_symbol_get_scope ((ValaSymbol*) _tmp465_);
						_tmp467_ = _tmp466_;
						_tmp468_ = m;
						vala_scope_add (_tmp467_, NULL, (ValaSymbol*) _tmp468_);
						_tmp469_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp469_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp470_;
					ValaCodeNode* _tmp471_;
					_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp471_ = _tmp470_;
					if (VALA_IS_ASSIGNMENT (_tmp471_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp472_;
						ValaCodeNode* _tmp473_;
						ValaAssignment* _tmp474_;
						ValaExpression* _tmp475_;
						ValaExpression* _tmp476_;
						_tmp472_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp473_ = _tmp472_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp474_ = a;
						_tmp475_ = vala_assignment_get_left (_tmp474_);
						_tmp476_ = _tmp475_;
						if (_tmp476_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp477_;
							ValaExpression* _tmp478_;
							ValaDataType* _tmp479_;
							ValaDataType* _tmp480_;
							const gchar* _tmp481_;
							ValaSourceReference* _tmp482_;
							ValaSourceReference* _tmp483_;
							ValaDynamicProperty* _tmp484_;
							ValaDynamicProperty* _tmp485_;
							ValaDynamicProperty* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaSourceReference* _tmp488_;
							ValaSourceReference* _tmp489_;
							ValaPropertyAccessor* _tmp490_;
							ValaPropertyAccessor* _tmp491_;
							ValaDynamicProperty* _tmp492_;
							ValaExpression* _tmp493_;
							ValaExpression* _tmp494_;
							ValaDataType* _tmp495_;
							ValaDataType* _tmp496_;
							ValaTypeSymbol* _tmp497_;
							ValaTypeSymbol* _tmp498_;
							ValaScope* _tmp499_;
							ValaScope* _tmp500_;
							ValaObjectType* _tmp501_;
							ValaTypeSymbol* _tmp502_;
							ValaTypeSymbol* _tmp503_;
							ValaScope* _tmp504_;
							ValaScope* _tmp505_;
							ValaDynamicProperty* _tmp506_;
							ValaDynamicProperty* _tmp507_;
							ValaObjectType* _tmp508_;
							ValaTypeSymbol* _tmp509_;
							ValaTypeSymbol* _tmp510_;
							ValaSemanticAnalyzer* _tmp511_;
							ValaSemanticAnalyzer* _tmp512_;
							ValaClass* _tmp513_;
							_tmp477_ = vala_member_access_get_inner (self);
							_tmp478_ = _tmp477_;
							_tmp479_ = vala_expression_get_value_type (_tmp478_);
							_tmp480_ = _tmp479_;
							_tmp481_ = self->priv->_member_name;
							_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp483_ = _tmp482_;
							_tmp484_ = vala_dynamic_property_new (_tmp480_, _tmp481_, _tmp483_, NULL);
							prop = _tmp484_;
							_tmp485_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp485_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp486_ = prop;
							_tmp487_ = prop;
							_tmp488_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp489_, NULL);
							_tmp491_ = _tmp490_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp486_, _tmp491_);
							_vala_code_node_unref0 (_tmp491_);
							_tmp492_ = prop;
							_tmp493_ = vala_member_access_get_inner (self);
							_tmp494_ = _tmp493_;
							_tmp495_ = vala_expression_get_value_type (_tmp494_);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_data_type_get_type_symbol (_tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_symbol_get_scope ((ValaSymbol*) _tmp498_);
							_tmp500_ = _tmp499_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp492_, _tmp500_);
							_tmp501_ = dynamic_object_type;
							_tmp502_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp501_);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_symbol_get_scope ((ValaSymbol*) _tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = prop;
							vala_scope_add (_tmp505_, NULL, (ValaSymbol*) _tmp506_);
							_tmp507_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp507_);
							_tmp508_ = dynamic_object_type;
							_tmp509_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp508_);
							_tmp510_ = _tmp509_;
							_tmp511_ = vala_code_context_get_analyzer (context);
							_tmp512_ = _tmp511_;
							_tmp513_ = _tmp512_->object_type;
							if (!vala_typesymbol_is_subtype_of (_tmp510_, (ValaTypeSymbol*) _tmp513_)) {
								ValaSourceReference* _tmp514_;
								ValaSourceReference* _tmp515_;
								ValaObjectType* _tmp516_;
								ValaTypeSymbol* _tmp517_;
								ValaTypeSymbol* _tmp518_;
								gchar* _tmp519_;
								gchar* _tmp520_;
								_tmp514_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp515_ = _tmp514_;
								_tmp516_ = dynamic_object_type;
								_tmp517_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp516_);
								_tmp518_ = _tmp517_;
								_tmp519_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp518_);
								_tmp520_ = _tmp519_;
								vala_report_error (_tmp515_, "dynamic properties are not supported for `%s'", _tmp520_);
								_g_free0 (_tmp520_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							}
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp521_ = FALSE;
						gboolean _tmp522_ = FALSE;
						ValaCodeNode* _tmp523_;
						ValaCodeNode* _tmp524_;
						_tmp523_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp524_ = _tmp523_;
						if (VALA_IS_MEMBER_ACCESS (_tmp524_)) {
							ValaExpression* _tmp525_;
							ValaExpression* _tmp526_;
							_tmp525_ = vala_member_access_get_inner (self);
							_tmp526_ = _tmp525_;
							_tmp522_ = VALA_IS_MEMBER_ACCESS (_tmp526_);
						} else {
							_tmp522_ = FALSE;
						}
						if (_tmp522_) {
							ValaCodeNode* _tmp527_;
							ValaCodeNode* _tmp528_;
							ValaCodeNode* _tmp529_;
							ValaCodeNode* _tmp530_;
							_tmp527_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp528_ = _tmp527_;
							_tmp529_ = vala_code_node_get_parent_node (_tmp528_);
							_tmp530_ = _tmp529_;
							_tmp521_ = VALA_IS_METHOD_CALL (_tmp530_);
						} else {
							_tmp521_ = FALSE;
						}
						if (_tmp521_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp531_;
							ValaCodeNode* _tmp532_;
							gboolean _tmp533_ = FALSE;
							ValaMemberAccess* _tmp534_;
							const gchar* _tmp535_;
							_tmp531_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp532_ = _tmp531_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp532_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp534_ = ma;
							_tmp535_ = _tmp534_->priv->_member_name;
							if (g_strcmp0 (_tmp535_, "connect") == 0) {
								_tmp533_ = TRUE;
							} else {
								ValaMemberAccess* _tmp536_;
								const gchar* _tmp537_;
								_tmp536_ = ma;
								_tmp537_ = _tmp536_->priv->_member_name;
								_tmp533_ = g_strcmp0 (_tmp537_, "connect_after") == 0;
							}
							if (_tmp533_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp538_;
								ValaExpression* _tmp539_;
								ValaDataType* _tmp540_;
								ValaDataType* _tmp541_;
								const gchar* _tmp542_;
								ValaVoidType* _tmp543_;
								ValaVoidType* _tmp544_;
								ValaSourceReference* _tmp545_;
								ValaSourceReference* _tmp546_;
								ValaDynamicSignal* _tmp547_;
								ValaDynamicSignal* _tmp548_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp549_;
								ValaCodeNode* _tmp550_;
								ValaCodeNode* _tmp551_;
								ValaCodeNode* _tmp552_;
								ValaMethodCall* _tmp553_;
								ValaMethodCall* _tmp554_;
								ValaList* _tmp555_;
								gint _tmp556_;
								gint _tmp557_;
								ValaDynamicSignal* _tmp589_;
								ValaObjectType* _tmp590_;
								ValaTypeSymbol* _tmp591_;
								ValaTypeSymbol* _tmp592_;
								ValaScope* _tmp593_;
								ValaScope* _tmp594_;
								ValaDynamicSignal* _tmp595_;
								ValaDynamicSignal* _tmp596_;
								_tmp538_ = vala_member_access_get_inner (self);
								_tmp539_ = _tmp538_;
								_tmp540_ = vala_expression_get_value_type (_tmp539_);
								_tmp541_ = _tmp540_;
								_tmp542_ = self->priv->_member_name;
								_tmp543_ = vala_void_type_new (NULL);
								_tmp544_ = _tmp543_;
								_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp546_ = _tmp545_;
								_tmp547_ = vala_dynamic_signal_new (_tmp541_, _tmp542_, (ValaDataType*) _tmp544_, _tmp546_, NULL);
								_tmp548_ = _tmp547_;
								_vala_code_node_unref0 (_tmp544_);
								s = _tmp548_;
								_tmp549_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp550_ = _tmp549_;
								_tmp551_ = vala_code_node_get_parent_node (_tmp550_);
								_tmp552_ = _tmp551_;
								_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp552_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp553_;
								_tmp554_ = mcall;
								_tmp555_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp554_);
								_tmp556_ = vala_collection_get_size ((ValaCollection*) _tmp555_);
								_tmp557_ = _tmp556_;
								if (_tmp557_ > 0) {
									ValaDynamicSignal* _tmp558_;
									ValaMethodCall* _tmp559_;
									ValaList* _tmp560_;
									gpointer _tmp561_;
									ValaExpression* _tmp562_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp563_;
									ValaExpression* _tmp564_;
									ValaExpression* _tmp565_;
									gboolean _tmp566_ = FALSE;
									gboolean _tmp567_ = FALSE;
									ValaMemberAccess* _tmp568_;
									_tmp558_ = s;
									_tmp559_ = mcall;
									_tmp560_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp559_);
									_tmp561_ = vala_list_get (_tmp560_, 0);
									_tmp562_ = (ValaExpression*) _tmp561_;
									vala_dynamic_signal_set_handler (_tmp558_, _tmp562_);
									_vala_code_node_unref0 (_tmp562_);
									_tmp563_ = s;
									_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
									_tmp565_ = _tmp564_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp565_) ? ((ValaMemberAccess*) _tmp565_) : NULL;
									_tmp568_ = arg;
									if (_tmp568_ == NULL) {
										_tmp567_ = TRUE;
									} else {
										ValaMemberAccess* _tmp569_;
										_tmp569_ = arg;
										_tmp567_ = !vala_code_node_check ((ValaCodeNode*) _tmp569_, context);
									}
									if (_tmp567_) {
										_tmp566_ = TRUE;
									} else {
										ValaMemberAccess* _tmp570_;
										ValaSymbol* _tmp571_;
										ValaSymbol* _tmp572_;
										_tmp570_ = arg;
										_tmp571_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp570_);
										_tmp572_ = _tmp571_;
										_tmp566_ = !VALA_IS_METHOD (_tmp572_);
									}
									if (_tmp566_) {
										ValaDynamicSignal* _tmp573_;
										ValaExpression* _tmp574_;
										ValaExpression* _tmp575_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp573_ = s;
										_tmp574_ = vala_dynamic_signal_get_handler (_tmp573_);
										_tmp575_ = _tmp574_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp575_)) {
											ValaDynamicSignal* _tmp576_;
											ValaExpression* _tmp577_;
											ValaExpression* _tmp578_;
											ValaSourceReference* _tmp579_;
											ValaSourceReference* _tmp580_;
											_tmp576_ = s;
											_tmp577_ = vala_dynamic_signal_get_handler (_tmp576_);
											_tmp578_ = _tmp577_;
											_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp578_);
											_tmp580_ = _tmp579_;
											vala_report_error (_tmp580_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp581_;
											ValaExpression* _tmp582_;
											ValaExpression* _tmp583_;
											ValaSourceReference* _tmp584_;
											ValaSourceReference* _tmp585_;
											ValaDynamicSignal* _tmp586_;
											gchar* _tmp587_;
											gchar* _tmp588_;
											_tmp581_ = s;
											_tmp582_ = vala_dynamic_signal_get_handler (_tmp581_);
											_tmp583_ = _tmp582_;
											_tmp584_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp583_);
											_tmp585_ = _tmp584_;
											_tmp586_ = s;
											_tmp587_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp586_);
											_tmp588_ = _tmp587_;
											vala_report_error (_tmp585_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp588_);
											_g_free0 (_tmp588_);
										}
									}
								}
								_tmp589_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp589_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp590_ = dynamic_object_type;
								_tmp591_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp590_);
								_tmp592_ = _tmp591_;
								_tmp593_ = vala_symbol_get_scope ((ValaSymbol*) _tmp592_);
								_tmp594_ = _tmp593_;
								_tmp595_ = s;
								vala_scope_add (_tmp594_, NULL, (ValaSymbol*) _tmp595_);
								_tmp596_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp596_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp597_;
								const gchar* _tmp598_;
								_tmp597_ = ma;
								_tmp598_ = _tmp597_->priv->_member_name;
								if (g_strcmp0 (_tmp598_, "disconnect") == 0) {
									ValaMemberAccess* _tmp599_;
									ValaSourceReference* _tmp600_;
									ValaSourceReference* _tmp601_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp599_ = ma;
									_tmp600_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp599_);
									_tmp601_ = _tmp600_;
									vala_report_error (_tmp601_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp602_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp603_ = _tmp602_;
				if (_tmp603_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp604_;
					ValaExpression* _tmp605_;
					ValaDataType* _tmp606_;
					ValaDataType* _tmp607_;
					const gchar* _tmp608_;
					ValaSourceReference* _tmp609_;
					ValaSourceReference* _tmp610_;
					ValaDynamicProperty* _tmp611_;
					ValaDataType* _tmp612_;
					ValaDataType* _tmp613_;
					ValaDynamicProperty* _tmp624_;
					ValaDynamicProperty* _tmp625_;
					ValaDynamicProperty* _tmp626_;
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					ValaDataType* _tmp629_;
					ValaDataType* _tmp630_;
					ValaDynamicProperty* _tmp631_;
					ValaSourceReference* _tmp632_;
					ValaSourceReference* _tmp633_;
					ValaPropertyAccessor* _tmp634_;
					ValaPropertyAccessor* _tmp635_;
					ValaDynamicProperty* _tmp636_;
					ValaExpression* _tmp637_;
					ValaExpression* _tmp638_;
					ValaDataType* _tmp639_;
					ValaDataType* _tmp640_;
					ValaTypeSymbol* _tmp641_;
					ValaTypeSymbol* _tmp642_;
					ValaScope* _tmp643_;
					ValaScope* _tmp644_;
					ValaObjectType* _tmp645_;
					ValaTypeSymbol* _tmp646_;
					ValaTypeSymbol* _tmp647_;
					ValaScope* _tmp648_;
					ValaScope* _tmp649_;
					ValaDynamicProperty* _tmp650_;
					ValaDynamicProperty* _tmp651_;
					ValaObjectType* _tmp652_;
					ValaTypeSymbol* _tmp653_;
					ValaTypeSymbol* _tmp654_;
					ValaSemanticAnalyzer* _tmp655_;
					ValaSemanticAnalyzer* _tmp656_;
					ValaClass* _tmp657_;
					_tmp604_ = vala_member_access_get_inner (self);
					_tmp605_ = _tmp604_;
					_tmp606_ = vala_expression_get_value_type (_tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = self->priv->_member_name;
					_tmp609_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_dynamic_property_new (_tmp607_, _tmp608_, _tmp610_, NULL);
					prop = _tmp611_;
					_tmp612_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp613_ = _tmp612_;
					if (_tmp613_ != NULL) {
						ValaDynamicProperty* _tmp614_;
						ValaDataType* _tmp615_;
						ValaDataType* _tmp616_;
						_tmp614_ = prop;
						_tmp615_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp616_ = _tmp615_;
						vala_property_set_property_type ((ValaProperty*) _tmp614_, _tmp616_);
					} else {
						ValaDynamicProperty* _tmp617_;
						ValaExpression* _tmp618_;
						ValaExpression* _tmp619_;
						ValaDataType* _tmp620_;
						ValaDataType* _tmp621_;
						ValaDataType* _tmp622_;
						ValaDataType* _tmp623_;
						_tmp617_ = prop;
						_tmp618_ = vala_member_access_get_inner (self);
						_tmp619_ = _tmp618_;
						_tmp620_ = vala_expression_get_value_type (_tmp619_);
						_tmp621_ = _tmp620_;
						_tmp622_ = vala_data_type_copy (_tmp621_);
						_tmp623_ = _tmp622_;
						vala_property_set_property_type ((ValaProperty*) _tmp617_, _tmp623_);
						_vala_code_node_unref0 (_tmp623_);
					}
					_tmp624_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp624_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp625_ = prop;
					_tmp626_ = prop;
					_tmp627_ = vala_property_get_property_type ((ValaProperty*) _tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_data_type_copy (_tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = prop;
					_tmp632_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp631_);
					_tmp633_ = _tmp632_;
					_tmp634_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp630_, NULL, _tmp633_, NULL);
					_tmp635_ = _tmp634_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp625_, _tmp635_);
					_vala_code_node_unref0 (_tmp635_);
					_vala_code_node_unref0 (_tmp630_);
					_tmp636_ = prop;
					_tmp637_ = vala_member_access_get_inner (self);
					_tmp638_ = _tmp637_;
					_tmp639_ = vala_expression_get_value_type (_tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_data_type_get_type_symbol (_tmp640_);
					_tmp642_ = _tmp641_;
					_tmp643_ = vala_symbol_get_scope ((ValaSymbol*) _tmp642_);
					_tmp644_ = _tmp643_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp636_, _tmp644_);
					_tmp645_ = dynamic_object_type;
					_tmp646_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp645_);
					_tmp647_ = _tmp646_;
					_tmp648_ = vala_symbol_get_scope ((ValaSymbol*) _tmp647_);
					_tmp649_ = _tmp648_;
					_tmp650_ = prop;
					vala_scope_add (_tmp649_, NULL, (ValaSymbol*) _tmp650_);
					_tmp651_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp651_);
					_tmp652_ = dynamic_object_type;
					_tmp653_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp652_);
					_tmp654_ = _tmp653_;
					_tmp655_ = vala_code_context_get_analyzer (context);
					_tmp656_ = _tmp655_;
					_tmp657_ = _tmp656_->object_type;
					if (!vala_typesymbol_is_subtype_of (_tmp654_, (ValaTypeSymbol*) _tmp657_)) {
						ValaSourceReference* _tmp658_;
						ValaSourceReference* _tmp659_;
						ValaObjectType* _tmp660_;
						ValaTypeSymbol* _tmp661_;
						ValaTypeSymbol* _tmp662_;
						gchar* _tmp663_;
						gchar* _tmp664_;
						_tmp658_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp659_ = _tmp658_;
						_tmp660_ = dynamic_object_type;
						_tmp661_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp660_);
						_tmp662_ = _tmp661_;
						_tmp663_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp662_);
						_tmp664_ = _tmp663_;
						vala_report_error (_tmp659_, "dynamic properties are not supported for %s", _tmp664_);
						_g_free0 (_tmp664_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_vala_code_node_unref0 (prop);
				}
				_tmp665_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp666_ = _tmp665_;
				if (_tmp666_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp667_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp668_ = _tmp667_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp668_)) {
				ValaExpression* _tmp669_;
				ValaExpression* _tmp670_;
				ValaSymbol* _tmp671_;
				ValaSymbol* _tmp672_;
				_tmp669_ = vala_member_access_get_inner (self);
				_tmp670_ = _tmp669_;
				_tmp671_ = vala_expression_get_symbol_reference (_tmp670_);
				_tmp672_ = _tmp671_;
				if (VALA_IS_VARIABLE (_tmp672_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp673_;
					ValaSemanticAnalyzer* _tmp674_;
					ValaExpression* _tmp675_;
					ValaExpression* _tmp676_;
					ValaSymbol* _tmp677_;
					ValaSymbol* _tmp678_;
					ValaDataType* _tmp679_;
					ValaArrayType* _tmp680_;
					gboolean _tmp681_ = FALSE;
					ValaArrayType* _tmp682_;
					_tmp673_ = vala_code_context_get_analyzer (context);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_member_access_get_inner (self);
					_tmp676_ = _tmp675_;
					_tmp677_ = vala_expression_get_symbol_reference (_tmp676_);
					_tmp678_ = _tmp677_;
					_tmp679_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp674_, _tmp678_, TRUE);
					_tmp680_ = VALA_IS_ARRAY_TYPE (_tmp679_) ? ((ValaArrayType*) _tmp679_) : NULL;
					if (_tmp680_ == NULL) {
						_vala_code_node_unref0 (_tmp679_);
					}
					inner_type = _tmp680_;
					_tmp682_ = inner_type;
					if (_tmp682_ != NULL) {
						ValaArrayType* _tmp683_;
						gboolean _tmp684_;
						gboolean _tmp685_;
						_tmp683_ = inner_type;
						_tmp684_ = vala_array_type_get_inline_allocated (_tmp683_);
						_tmp685_ = _tmp684_;
						_tmp681_ = _tmp685_;
					} else {
						_tmp681_ = FALSE;
					}
					if (_tmp681_) {
						ValaSourceReference* _tmp686_;
						ValaSourceReference* _tmp687_;
						_tmp686_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp687_ = _tmp686_;
						vala_report_error (_tmp687_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp688_ = FALSE;
						ValaArrayType* _tmp689_;
						_tmp689_ = inner_type;
						if (_tmp689_ != NULL) {
							ValaArrayType* _tmp690_;
							gboolean _tmp691_;
							gboolean _tmp692_;
							_tmp690_ = inner_type;
							_tmp691_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp690_);
							_tmp692_ = _tmp691_;
							_tmp688_ = !_tmp692_;
						} else {
							_tmp688_ = FALSE;
						}
						if (_tmp688_) {
							ValaSourceReference* _tmp693_;
							ValaSourceReference* _tmp694_;
							_tmp693_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp694_ = _tmp693_;
							vala_report_error (_tmp694_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp695_;
					ValaExpression* _tmp696_;
					ValaSymbol* _tmp697_;
					ValaSymbol* _tmp698_;
					_tmp695_ = vala_member_access_get_inner (self);
					_tmp696_ = _tmp695_;
					_tmp697_ = vala_expression_get_symbol_reference (_tmp696_);
					_tmp698_ = _tmp697_;
					if (VALA_IS_CONSTANT (_tmp698_)) {
						ValaSourceReference* _tmp699_;
						ValaSourceReference* _tmp700_;
						_tmp699_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp700_ = _tmp699_;
						vala_report_error (_tmp700_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp704_ = vala_member_access_get_inner (self);
	_tmp705_ = _tmp704_;
	if (_tmp705_ == NULL) {
		ValaSymbol* _tmp706_;
		ValaSymbol* _tmp707_;
		_tmp706_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp707_ = _tmp706_;
		_tmp703_ = _tmp707_ == NULL;
	} else {
		_tmp703_ = FALSE;
	}
	if (_tmp703_) {
		ValaDataType* _tmp708_;
		ValaDataType* _tmp709_;
		_tmp708_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp709_ = _tmp708_;
		_tmp702_ = _tmp709_ != NULL;
	} else {
		_tmp702_ = FALSE;
	}
	if (_tmp702_) {
		ValaDataType* _tmp710_;
		ValaDataType* _tmp711_;
		ValaTypeSymbol* _tmp712_;
		ValaTypeSymbol* _tmp713_;
		_tmp710_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp711_ = _tmp710_;
		_tmp712_ = vala_data_type_get_type_symbol (_tmp711_);
		_tmp713_ = _tmp712_;
		_tmp701_ = VALA_IS_ENUM (_tmp713_);
	} else {
		_tmp701_ = FALSE;
	}
	if (_tmp701_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp714_;
		ValaDataType* _tmp715_;
		ValaTypeSymbol* _tmp716_;
		ValaTypeSymbol* _tmp717_;
		_tmp714_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp715_ = _tmp714_;
		_tmp716_ = vala_data_type_get_type_symbol (_tmp715_);
		_tmp717_ = _tmp716_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp717_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp718_;
			ValaList* _tmp719_;
			gint _val_size = 0;
			ValaList* _tmp720_;
			gint _tmp721_;
			gint _tmp722_;
			gint _val_index = 0;
			_tmp718_ = enum_type;
			_tmp719_ = vala_enum_get_values (_tmp718_);
			_val_list = _tmp719_;
			_tmp720_ = _val_list;
			_tmp721_ = vala_collection_get_size ((ValaCollection*) _tmp720_);
			_tmp722_ = _tmp721_;
			_val_size = _tmp722_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp723_;
				gint _tmp724_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp725_;
				gpointer _tmp726_;
				const gchar* _tmp727_;
				ValaEnumValue* _tmp728_;
				const gchar* _tmp729_;
				const gchar* _tmp730_;
				_val_index = _val_index + 1;
				_tmp723_ = _val_index;
				_tmp724_ = _val_size;
				if (!(_tmp723_ < _tmp724_)) {
					break;
				}
				_tmp725_ = _val_list;
				_tmp726_ = vala_list_get (_tmp725_, _val_index);
				val = (ValaEnumValue*) _tmp726_;
				_tmp727_ = self->priv->_member_name;
				_tmp728_ = val;
				_tmp729_ = vala_symbol_get_name ((ValaSymbol*) _tmp728_);
				_tmp730_ = _tmp729_;
				if (g_strcmp0 (_tmp727_, _tmp730_) == 0) {
					ValaEnumValue* _tmp731_;
					_tmp731_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp731_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp732_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp733_ = _tmp732_;
	if (_tmp733_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp734_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp735_ = FALSE;
		ValaExpression* _tmp736_;
		ValaExpression* _tmp737_;
		gchar* base_type_package = NULL;
		gchar* _tmp757_;
		gboolean _tmp758_ = FALSE;
		ValaSymbol* _tmp759_;
		gchar* visited_types_string = NULL;
		gchar* _tmp774_;
		ValaSourceReference* _tmp790_;
		ValaSourceReference* _tmp791_;
		const gchar* _tmp792_;
		const gchar* _tmp793_;
		const gchar* _tmp794_;
		const gchar* _tmp795_;
		ValaInvalidType* _tmp796_;
		ValaInvalidType* _tmp797_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp734_ = g_strdup ("(null)");
		base_type_name = _tmp734_;
		base_type = NULL;
		_tmp736_ = vala_member_access_get_inner (self);
		_tmp737_ = _tmp736_;
		if (_tmp737_ != NULL) {
			ValaExpression* _tmp738_;
			ValaExpression* _tmp739_;
			ValaDataType* _tmp740_;
			ValaDataType* _tmp741_;
			_tmp738_ = vala_member_access_get_inner (self);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_expression_get_value_type (_tmp739_);
			_tmp741_ = _tmp740_;
			_tmp735_ = _tmp741_ != NULL;
		} else {
			_tmp735_ = FALSE;
		}
		if (_tmp735_) {
			ValaExpression* _tmp742_;
			ValaExpression* _tmp743_;
			ValaDataType* _tmp744_;
			ValaDataType* _tmp745_;
			gchar* _tmp746_;
			ValaExpression* _tmp747_;
			ValaExpression* _tmp748_;
			ValaDataType* _tmp749_;
			ValaDataType* _tmp750_;
			ValaTypeSymbol* _tmp751_;
			ValaTypeSymbol* _tmp752_;
			_tmp742_ = vala_member_access_get_inner (self);
			_tmp743_ = _tmp742_;
			_tmp744_ = vala_expression_get_value_type (_tmp743_);
			_tmp745_ = _tmp744_;
			_tmp746_ = vala_code_node_to_string ((ValaCodeNode*) _tmp745_);
			_g_free0 (base_type_name);
			base_type_name = _tmp746_;
			_tmp747_ = vala_member_access_get_inner (self);
			_tmp748_ = _tmp747_;
			_tmp749_ = vala_expression_get_value_type (_tmp748_);
			_tmp750_ = _tmp749_;
			_tmp751_ = vala_data_type_get_type_symbol (_tmp750_);
			_tmp752_ = _tmp751_;
			base_type = (ValaSymbol*) _tmp752_;
		} else {
			ValaSymbol* _tmp753_;
			_tmp753_ = base_symbol;
			if (_tmp753_ != NULL) {
				ValaSymbol* _tmp754_;
				gchar* _tmp755_;
				ValaSymbol* _tmp756_;
				_tmp754_ = base_symbol;
				_tmp755_ = vala_symbol_get_full_name (_tmp754_);
				_g_free0 (base_type_name);
				base_type_name = _tmp755_;
				_tmp756_ = base_symbol;
				base_type = _tmp756_;
			}
		}
		_tmp757_ = g_strdup ("");
		base_type_package = _tmp757_;
		_tmp759_ = base_type;
		if (_tmp759_ != NULL) {
			ValaSymbol* _tmp760_;
			gboolean _tmp761_;
			gboolean _tmp762_;
			_tmp760_ = base_type;
			_tmp761_ = vala_symbol_get_external_package (_tmp760_);
			_tmp762_ = _tmp761_;
			_tmp758_ = _tmp762_;
		} else {
			_tmp758_ = FALSE;
		}
		if (_tmp758_) {
			ValaSymbol* _tmp763_;
			ValaSourceReference* _tmp764_;
			ValaSourceReference* _tmp765_;
			ValaSourceFile* _tmp766_;
			ValaSourceFile* _tmp767_;
			const gchar* _tmp768_;
			const gchar* _tmp769_;
			gchar* _tmp770_;
			const gchar* _tmp771_;
			_tmp763_ = base_symbol;
			_tmp764_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp763_);
			_tmp765_ = _tmp764_;
			_tmp766_ = vala_source_reference_get_file (_tmp765_);
			_tmp767_ = _tmp766_;
			_tmp768_ = vala_source_file_get_package_name (_tmp767_);
			_tmp769_ = _tmp768_;
			_tmp770_ = g_strdup (_tmp769_);
			_g_free0 (base_type_package);
			base_type_package = _tmp770_;
			_tmp771_ = base_type_package;
			if (_tmp771_ != NULL) {
				const gchar* _tmp772_;
				gchar* _tmp773_;
				_tmp772_ = base_type_package;
				_tmp773_ = g_strdup_printf (" (%s)", _tmp772_);
				_g_free0 (base_type_package);
				base_type_package = _tmp773_;
			}
		}
		_tmp774_ = g_strdup ("");
		visited_types_string = _tmp774_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp775_;
			gint _type_size = 0;
			ValaArrayList* _tmp776_;
			gint _tmp777_;
			gint _tmp778_;
			gint _type_index = 0;
			_tmp775_ = visited_types;
			_type_list = _tmp775_;
			_tmp776_ = _type_list;
			_tmp777_ = vala_collection_get_size ((ValaCollection*) _tmp776_);
			_tmp778_ = _tmp777_;
			_type_size = _tmp778_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp779_;
				gint _tmp780_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp781_;
				gpointer _tmp782_;
				const gchar* _tmp783_;
				ValaDataType* _tmp784_;
				gchar* _tmp785_;
				gchar* _tmp786_;
				gchar* _tmp787_;
				gchar* _tmp788_;
				gchar* _tmp789_;
				_type_index = _type_index + 1;
				_tmp779_ = _type_index;
				_tmp780_ = _type_size;
				if (!(_tmp779_ < _tmp780_)) {
					break;
				}
				_tmp781_ = _type_list;
				_tmp782_ = vala_list_get ((ValaList*) _tmp781_, _type_index);
				type = (ValaDataType*) _tmp782_;
				_tmp783_ = visited_types_string;
				_tmp784_ = type;
				_tmp785_ = vala_code_node_to_string ((ValaCodeNode*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp787_ = g_strdup_printf (" or `%s'", _tmp786_);
				_tmp788_ = _tmp787_;
				_tmp789_ = g_strconcat (_tmp783_, _tmp788_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp789_;
				_g_free0 (_tmp788_);
				_g_free0 (_tmp786_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp790_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp791_ = _tmp790_;
		_tmp792_ = self->priv->_member_name;
		_tmp793_ = base_type_name;
		_tmp794_ = base_type_package;
		_tmp795_ = visited_types_string;
		vala_report_error (_tmp791_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp792_, _tmp793_, _tmp794_, _tmp795_);
		_tmp796_ = vala_invalid_type_new ();
		_tmp797_ = _tmp796_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp797_);
		_vala_code_node_unref0 (_tmp797_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp798_;
		ValaSymbol* _tmp799_;
		gboolean _tmp800_;
		gboolean _tmp801_;
		_tmp798_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp799_ = _tmp798_;
		_tmp800_ = vala_code_node_get_error ((ValaCodeNode*) _tmp799_);
		_tmp801_ = _tmp800_;
		if (_tmp801_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp802_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp803_ = _tmp802_;
	if (VALA_IS_SIGNAL (_tmp803_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp804_;
		ValaSymbol* _tmp805_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp812_;
		ValaCodeNode* _tmp813_;
		ValaCodeNode* _tmp814_;
		gboolean _tmp815_ = FALSE;
		gboolean _tmp816_ = FALSE;
		gboolean _tmp817_ = FALSE;
		ValaCodeNode* _tmp818_;
		_tmp804_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp805_ = _tmp804_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp805_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp806_;
			ValaCodeNode* _tmp807_;
			ValaCodeNode* _tmp808_;
			ValaCodeNode* _tmp809_;
			ValaCodeNode* _tmp810_;
			ValaCodeNode* _tmp811_;
			_tmp806_ = ma;
			_tmp807_ = vala_code_node_get_parent_node (_tmp806_);
			_tmp808_ = _tmp807_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp808_)) {
				break;
			}
			_tmp809_ = ma;
			_tmp810_ = vala_code_node_get_parent_node (_tmp809_);
			_tmp811_ = _tmp810_;
			ma = _tmp811_;
		}
		_tmp812_ = ma;
		_tmp813_ = vala_code_node_get_parent_node (_tmp812_);
		_tmp814_ = _tmp813_;
		parent = _tmp814_;
		_tmp818_ = parent;
		if (_tmp818_ != NULL) {
			ValaCodeNode* _tmp819_;
			_tmp819_ = parent;
			_tmp817_ = !VALA_IS_ELEMENT_ACCESS (_tmp819_);
		} else {
			_tmp817_ = FALSE;
		}
		if (_tmp817_) {
			ValaCodeNode* _tmp820_;
			ValaExpression* _tmp821_;
			ValaExpression* _tmp822_;
			_tmp820_ = ma;
			_tmp821_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp820_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp822_ = _tmp821_;
			_tmp816_ = !VALA_IS_BASE_ACCESS (_tmp822_);
		} else {
			_tmp816_ = FALSE;
		}
		if (_tmp816_) {
			gboolean _tmp823_ = FALSE;
			ValaCodeNode* _tmp824_;
			_tmp824_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp824_)) {
				_tmp823_ = TRUE;
			} else {
				ValaCodeNode* _tmp825_;
				ValaList* _tmp826_;
				_tmp825_ = parent;
				_tmp826_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp825_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp823_ = vala_collection_contains ((ValaCollection*) _tmp826_, (ValaExpression*) self);
			}
			_tmp815_ = _tmp823_;
		} else {
			_tmp815_ = FALSE;
		}
		if (_tmp815_) {
			ValaSignal* _tmp827_;
			ValaAttribute* _tmp828_;
			_tmp827_ = sig;
			_tmp828_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp827_, "HasEmitter");
			if (_tmp828_ != NULL) {
				ValaSignal* _tmp829_;
				ValaSignal* _tmp830_;
				ValaMethod* _tmp831_;
				ValaMethod* _tmp832_;
				_tmp829_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp829_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp830_ = sig;
				_tmp831_ = vala_signal_get_emitter (_tmp830_);
				_tmp832_ = _tmp831_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp832_);
			} else {
				ValaSourceReference* _tmp833_;
				ValaSourceReference* _tmp834_;
				ValaSymbol* _tmp835_;
				ValaSymbol* _tmp836_;
				gchar* _tmp837_;
				gchar* _tmp838_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp833_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_symbol_get_full_name (_tmp836_);
				_tmp838_ = _tmp837_;
				vala_report_error (_tmp834_, "Signal `%s' requires emitter in this context", _tmp838_);
				_g_free0 (_tmp838_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp839_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp840_ = _tmp839_;
	member = _tmp840_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp841_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp841_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp842_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp842_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp843_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp844_;
		ValaSymbol* _tmp845_;
		ValaSymbol* _tmp846_;
		gboolean _tmp847_ = FALSE;
		ValaBlock* _tmp848_;
		_tmp843_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp843_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp844_ = local;
		_tmp845_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp844_);
		_tmp846_ = _tmp845_;
		block = VALA_IS_BLOCK (_tmp846_) ? ((ValaBlock*) _tmp846_) : NULL;
		_tmp848_ = block;
		if (_tmp848_ != NULL) {
			ValaBlock* _tmp849_;
			ValaSymbol* _tmp850_;
			ValaSemanticAnalyzer* _tmp851_;
			ValaSemanticAnalyzer* _tmp852_;
			ValaSymbol* _tmp853_;
			ValaSymbol* _tmp854_;
			_tmp849_ = block;
			_tmp850_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp849_);
			_tmp851_ = vala_code_context_get_analyzer (context);
			_tmp852_ = _tmp851_;
			_tmp853_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp852_);
			_tmp854_ = _tmp853_;
			_tmp847_ = _tmp850_ != _tmp854_;
		} else {
			_tmp847_ = FALSE;
		}
		if (_tmp847_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp855_;
			ValaSemanticAnalyzer* _tmp856_;
			ValaSymbol* _tmp857_;
			ValaSymbol* _tmp858_;
			ValaLocalVariable* _tmp869_;
			ValaBlock* _tmp870_;
			ValaLocalVariable* _tmp871_;
			ValaDataType* _tmp872_;
			ValaDataType* _tmp873_;
			ValaTypeSymbol* _tmp874_;
			ValaTypeSymbol* _tmp875_;
			ValaSemanticAnalyzer* _tmp876_;
			ValaSemanticAnalyzer* _tmp877_;
			ValaDataType* _tmp878_;
			ValaTypeSymbol* _tmp879_;
			ValaTypeSymbol* _tmp880_;
			_tmp855_ = vala_code_context_get_analyzer (context);
			_tmp856_ = _tmp855_;
			_tmp857_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp856_);
			_tmp858_ = _tmp857_;
			sym = _tmp858_;
			while (TRUE) {
				ValaSymbol* _tmp859_;
				ValaBlock* _tmp860_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp861_;
				ValaMethod* _tmp862_;
				ValaSymbol* _tmp866_;
				ValaSymbol* _tmp867_;
				ValaSymbol* _tmp868_;
				_tmp859_ = sym;
				_tmp860_ = block;
				if (!(_tmp859_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp860_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp861_ = sym;
				method = VALA_IS_METHOD (_tmp861_) ? ((ValaMethod*) _tmp861_) : NULL;
				_tmp862_ = method;
				if (_tmp862_ != NULL) {
					ValaMethod* _tmp863_;
					ValaMethod* _tmp864_;
					ValaLocalVariable* _tmp865_;
					_tmp863_ = method;
					vala_method_set_closure (_tmp863_, TRUE);
					_tmp864_ = method;
					_tmp865_ = local;
					vala_method_add_captured_variable (_tmp864_, _tmp865_);
				}
				_tmp866_ = sym;
				_tmp867_ = vala_symbol_get_parent_symbol (_tmp866_);
				_tmp868_ = _tmp867_;
				sym = _tmp868_;
			}
			_tmp869_ = local;
			vala_local_variable_set_captured (_tmp869_, TRUE);
			_tmp870_ = block;
			vala_block_set_captured (_tmp870_, TRUE);
			_tmp871_ = local;
			_tmp872_ = vala_variable_get_variable_type ((ValaVariable*) _tmp871_);
			_tmp873_ = _tmp872_;
			_tmp874_ = vala_data_type_get_type_symbol (_tmp873_);
			_tmp875_ = _tmp874_;
			_tmp876_ = vala_code_context_get_analyzer (context);
			_tmp877_ = _tmp876_;
			_tmp878_ = _tmp877_->va_list_type;
			_tmp879_ = vala_data_type_get_type_symbol (_tmp878_);
			_tmp880_ = _tmp879_;
			if (_tmp875_ == _tmp880_) {
				ValaSourceReference* _tmp881_;
				ValaSourceReference* _tmp882_;
				ValaLocalVariable* _tmp883_;
				gchar* _tmp884_;
				gchar* _tmp885_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp881_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp882_ = _tmp881_;
				_tmp883_ = local;
				_tmp884_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp883_);
				_tmp885_ = _tmp884_;
				vala_report_error (_tmp882_, "Capturing `va_list' variable `%s' is not allowed", _tmp885_);
				_g_free0 (_tmp885_);
			}
		}
	} else {
		ValaSymbol* _tmp886_;
		_tmp886_ = member;
		if (VALA_IS_PARAMETER (_tmp886_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp887_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp888_;
			ValaSymbol* _tmp889_;
			ValaSymbol* _tmp890_;
			gboolean _tmp891_ = FALSE;
			gboolean _tmp892_ = FALSE;
			ValaMethod* _tmp893_;
			_tmp887_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp887_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp888_ = param;
			_tmp889_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp888_);
			_tmp890_ = _tmp889_;
			m = VALA_IS_METHOD (_tmp890_) ? ((ValaMethod*) _tmp890_) : NULL;
			_tmp893_ = m;
			if (_tmp893_ != NULL) {
				ValaMethod* _tmp894_;
				ValaSemanticAnalyzer* _tmp895_;
				ValaSemanticAnalyzer* _tmp896_;
				ValaSymbol* _tmp897_;
				ValaSymbol* _tmp898_;
				_tmp894_ = m;
				_tmp895_ = vala_code_context_get_analyzer (context);
				_tmp896_ = _tmp895_;
				_tmp897_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp896_);
				_tmp898_ = _tmp897_;
				_tmp892_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp894_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp898_;
			} else {
				_tmp892_ = FALSE;
			}
			if (_tmp892_) {
				ValaParameter* _tmp899_;
				ValaMethod* _tmp900_;
				ValaParameter* _tmp901_;
				ValaParameter* _tmp902_;
				_tmp899_ = param;
				_tmp900_ = m;
				_tmp901_ = vala_method_get_this_parameter (_tmp900_);
				_tmp902_ = _tmp901_;
				_tmp891_ = _tmp899_ != _tmp902_;
			} else {
				_tmp891_ = FALSE;
			}
			if (_tmp891_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp903_;
				ValaSemanticAnalyzer* _tmp904_;
				ValaSymbol* _tmp905_;
				ValaSymbol* _tmp906_;
				ValaParameter* _tmp915_;
				ValaMethod* _tmp916_;
				ValaBlock* _tmp917_;
				ValaBlock* _tmp918_;
				ValaParameter* _tmp919_;
				ValaParameterDirection _tmp920_;
				ValaParameterDirection _tmp921_;
				ValaParameter* _tmp927_;
				ValaDataType* _tmp928_;
				ValaDataType* _tmp929_;
				ValaTypeSymbol* _tmp930_;
				ValaTypeSymbol* _tmp931_;
				ValaSemanticAnalyzer* _tmp932_;
				ValaSemanticAnalyzer* _tmp933_;
				ValaDataType* _tmp934_;
				ValaTypeSymbol* _tmp935_;
				ValaTypeSymbol* _tmp936_;
				_tmp903_ = vala_code_context_get_analyzer (context);
				_tmp904_ = _tmp903_;
				_tmp905_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp904_);
				_tmp906_ = _tmp905_;
				sym = _tmp906_;
				while (TRUE) {
					ValaSymbol* _tmp907_;
					ValaMethod* _tmp908_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp909_;
					ValaMethod* _tmp910_;
					ValaSymbol* _tmp912_;
					ValaSymbol* _tmp913_;
					ValaSymbol* _tmp914_;
					_tmp907_ = sym;
					_tmp908_ = m;
					if (!(_tmp907_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp908_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp909_ = sym;
					method = VALA_IS_METHOD (_tmp909_) ? ((ValaMethod*) _tmp909_) : NULL;
					_tmp910_ = method;
					if (_tmp910_ != NULL) {
						ValaMethod* _tmp911_;
						_tmp911_ = method;
						vala_method_set_closure (_tmp911_, TRUE);
					}
					_tmp912_ = sym;
					_tmp913_ = vala_symbol_get_parent_symbol (_tmp912_);
					_tmp914_ = _tmp913_;
					sym = _tmp914_;
				}
				_tmp915_ = param;
				vala_parameter_set_captured (_tmp915_, TRUE);
				_tmp916_ = m;
				_tmp917_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp916_);
				_tmp918_ = _tmp917_;
				vala_block_set_captured (_tmp918_, TRUE);
				_tmp919_ = param;
				_tmp920_ = vala_parameter_get_direction (_tmp919_);
				_tmp921_ = _tmp920_;
				if (_tmp921_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp922_;
					ValaSourceReference* _tmp923_;
					ValaParameter* _tmp924_;
					gchar* _tmp925_;
					gchar* _tmp926_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp922_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp923_ = _tmp922_;
					_tmp924_ = param;
					_tmp925_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp924_);
					_tmp926_ = _tmp925_;
					vala_report_error (_tmp923_, "Cannot capture reference or output parameter `%s'", _tmp926_);
					_g_free0 (_tmp926_);
				}
				_tmp927_ = param;
				_tmp928_ = vala_variable_get_variable_type ((ValaVariable*) _tmp927_);
				_tmp929_ = _tmp928_;
				_tmp930_ = vala_data_type_get_type_symbol (_tmp929_);
				_tmp931_ = _tmp930_;
				_tmp932_ = vala_code_context_get_analyzer (context);
				_tmp933_ = _tmp932_;
				_tmp934_ = _tmp933_->va_list_type;
				_tmp935_ = vala_data_type_get_type_symbol (_tmp934_);
				_tmp936_ = _tmp935_;
				if (_tmp931_ == _tmp936_) {
					ValaSourceReference* _tmp937_;
					ValaSourceReference* _tmp938_;
					ValaParameter* _tmp939_;
					gchar* _tmp940_;
					gchar* _tmp941_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp938_ = _tmp937_;
					_tmp939_ = param;
					_tmp940_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp939_);
					_tmp941_ = _tmp940_;
					vala_report_error (_tmp938_, "Capturing `va_list' parameter `%s' is not allowed", _tmp941_);
					_g_free0 (_tmp941_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp942_;
				ValaSymbol* _tmp943_;
				ValaSymbol* _tmp944_;
				ValaSymbol* _tmp945_;
				ValaSymbol* _tmp946_;
				gboolean _tmp947_ = FALSE;
				gboolean _tmp948_ = FALSE;
				ValaPropertyAccessor* _tmp949_;
				_tmp942_ = param;
				_tmp943_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp942_);
				_tmp944_ = _tmp943_;
				_tmp945_ = vala_symbol_get_parent_symbol (_tmp944_);
				_tmp946_ = _tmp945_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp946_) ? ((ValaPropertyAccessor*) _tmp946_) : NULL;
				_tmp949_ = acc;
				if (_tmp949_ != NULL) {
					ValaPropertyAccessor* _tmp950_;
					ValaSemanticAnalyzer* _tmp951_;
					ValaSemanticAnalyzer* _tmp952_;
					ValaSymbol* _tmp953_;
					ValaSymbol* _tmp954_;
					_tmp950_ = acc;
					_tmp951_ = vala_code_context_get_analyzer (context);
					_tmp952_ = _tmp951_;
					_tmp953_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp952_);
					_tmp954_ = _tmp953_;
					_tmp948_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp950_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp954_;
				} else {
					_tmp948_ = FALSE;
				}
				if (_tmp948_) {
					ValaParameter* _tmp955_;
					ValaPropertyAccessor* _tmp956_;
					ValaProperty* _tmp957_;
					ValaProperty* _tmp958_;
					ValaParameter* _tmp959_;
					ValaParameter* _tmp960_;
					_tmp955_ = param;
					_tmp956_ = acc;
					_tmp957_ = vala_property_accessor_get_prop (_tmp956_);
					_tmp958_ = _tmp957_;
					_tmp959_ = vala_property_get_this_parameter (_tmp958_);
					_tmp960_ = _tmp959_;
					_tmp947_ = _tmp955_ != _tmp960_;
				} else {
					_tmp947_ = FALSE;
				}
				if (_tmp947_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp961_;
					ValaSemanticAnalyzer* _tmp962_;
					ValaSymbol* _tmp963_;
					ValaSymbol* _tmp964_;
					ValaParameter* _tmp973_;
					ValaPropertyAccessor* _tmp974_;
					ValaBlock* _tmp975_;
					ValaBlock* _tmp976_;
					_tmp961_ = vala_code_context_get_analyzer (context);
					_tmp962_ = _tmp961_;
					_tmp963_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp962_);
					_tmp964_ = _tmp963_;
					sym = _tmp964_;
					while (TRUE) {
						ValaSymbol* _tmp965_;
						ValaMethod* _tmp966_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp967_;
						ValaMethod* _tmp968_;
						ValaSymbol* _tmp970_;
						ValaSymbol* _tmp971_;
						ValaSymbol* _tmp972_;
						_tmp965_ = sym;
						_tmp966_ = m;
						if (!(_tmp965_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp966_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp967_ = sym;
						method = VALA_IS_METHOD (_tmp967_) ? ((ValaMethod*) _tmp967_) : NULL;
						_tmp968_ = method;
						if (_tmp968_ != NULL) {
							ValaMethod* _tmp969_;
							_tmp969_ = method;
							vala_method_set_closure (_tmp969_, TRUE);
						}
						_tmp970_ = sym;
						_tmp971_ = vala_symbol_get_parent_symbol (_tmp970_);
						_tmp972_ = _tmp971_;
						sym = _tmp972_;
					}
					_tmp973_ = param;
					vala_parameter_set_captured (_tmp973_, TRUE);
					_tmp974_ = acc;
					_tmp975_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp974_);
					_tmp976_ = _tmp975_;
					vala_block_set_captured (_tmp976_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp977_;
			_tmp977_ = member;
			if (VALA_IS_FIELD (_tmp977_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp978_;
				ValaField* _tmp979_;
				ValaSymbolAccessibility _tmp980_;
				ValaSymbolAccessibility _tmp981_;
				ValaField* _tmp982_;
				ValaMemberBinding _tmp983_;
				ValaMemberBinding _tmp984_;
				ValaField* _tmp985_;
				ValaMemberBinding _tmp986_;
				ValaMemberBinding _tmp987_;
				ValaField* _tmp988_;
				ValaDataType* _tmp989_;
				ValaDataType* _tmp990_;
				_tmp978_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp978_, VALA_TYPE_FIELD, ValaField);
				_tmp979_ = f;
				_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
				_tmp981_ = _tmp980_;
				access = _tmp981_;
				_tmp982_ = f;
				_tmp983_ = vala_field_get_binding (_tmp982_);
				_tmp984_ = _tmp983_;
				instance = _tmp984_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp985_ = f;
				_tmp986_ = vala_field_get_binding (_tmp985_);
				_tmp987_ = _tmp986_;
				klass = _tmp987_ == VALA_MEMBER_BINDING_CLASS;
				_tmp988_ = f;
				_tmp989_ = vala_variable_get_variable_type ((ValaVariable*) _tmp988_);
				_tmp990_ = _tmp989_;
				if (VALA_IS_GENERIC_TYPE (_tmp990_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp991_;
				_tmp991_ = member;
				if (VALA_IS_CONSTANT (_tmp991_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp992_;
					ValaConstant* _tmp993_;
					ValaSymbolAccessibility _tmp994_;
					ValaSymbolAccessibility _tmp995_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp996_;
					ValaSymbol* _tmp997_;
					ValaSymbol* _tmp998_;
					gboolean _tmp999_ = FALSE;
					ValaBlock* _tmp1000_;
					_tmp992_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp992_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp993_ = c;
					_tmp994_ = vala_symbol_get_access ((ValaSymbol*) _tmp993_);
					_tmp995_ = _tmp994_;
					access = _tmp995_;
					_tmp996_ = c;
					_tmp997_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp996_);
					_tmp998_ = _tmp997_;
					block = VALA_IS_BLOCK (_tmp998_) ? ((ValaBlock*) _tmp998_) : NULL;
					_tmp1000_ = block;
					if (_tmp1000_ != NULL) {
						ValaBlock* _tmp1001_;
						ValaSymbol* _tmp1002_;
						ValaSemanticAnalyzer* _tmp1003_;
						ValaSemanticAnalyzer* _tmp1004_;
						ValaSymbol* _tmp1005_;
						ValaSymbol* _tmp1006_;
						_tmp1001_ = block;
						_tmp1002_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp1001_);
						_tmp1003_ = vala_code_context_get_analyzer (context);
						_tmp1004_ = _tmp1003_;
						_tmp1005_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp1004_);
						_tmp1006_ = _tmp1005_;
						_tmp999_ = _tmp1002_ != _tmp1006_;
					} else {
						_tmp999_ = FALSE;
					}
					if (_tmp999_) {
						ValaSourceReference* _tmp1007_;
						ValaSourceReference* _tmp1008_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp1007_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp1008_ = _tmp1007_;
						vala_report_error (_tmp1008_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp1009_;
					_tmp1009_ = member;
					if (VALA_IS_METHOD (_tmp1009_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp1010_;
						ValaMethod* _tmp1011_;
						gboolean _tmp1012_;
						gboolean _tmp1013_;
						ValaMethod* _tmp1100_;
						ValaSymbolAccessibility _tmp1101_;
						ValaSymbolAccessibility _tmp1102_;
						ValaMethod* _tmp1103_;
						ValaMethod* _tmp1107_;
						ValaMemberBinding _tmp1108_;
						ValaMemberBinding _tmp1109_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1129_;
						ValaDataType* _tmp1130_;
						ValaDataType* _tmp1131_;
						gboolean _tmp1132_ = FALSE;
						ValaGenericType* _tmp1133_;
						_tmp1010_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp1010_, VALA_TYPE_METHOD, ValaMethod);
						_tmp1011_ = m;
						_tmp1012_ = vala_method_get_is_async_callback (_tmp1011_);
						_tmp1013_ = _tmp1012_;
						if (_tmp1013_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp1014_;
							ValaSemanticAnalyzer* _tmp1015_;
							ValaMethod* _tmp1016_;
							ValaMethod* _tmp1017_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp1018_;
							ValaMethod* _tmp1045_;
							ValaSemanticAnalyzer* _tmp1046_;
							ValaSemanticAnalyzer* _tmp1047_;
							ValaMethod* _tmp1048_;
							ValaMethod* _tmp1049_;
							ValaMethod* _tmp1065_;
							ValaMethod* _tmp1066_;
							ValaMethod* _tmp1067_;
							ValaSymbol* _tmp1068_;
							ValaSymbol* _tmp1069_;
							_tmp1014_ = vala_code_context_get_analyzer (context);
							_tmp1015_ = _tmp1014_;
							_tmp1016_ = vala_semantic_analyzer_get_current_async_method (_tmp1015_);
							_tmp1017_ = _tmp1016_;
							async_method = _tmp1017_;
							is_valid_access = FALSE;
							_tmp1018_ = async_method;
							if (_tmp1018_ != NULL) {
								ValaMethod* _tmp1019_;
								ValaMethod* _tmp1020_;
								ValaMethod* _tmp1021_;
								_tmp1019_ = m;
								_tmp1020_ = async_method;
								_tmp1021_ = vala_method_get_callback_method (_tmp1020_);
								if (_tmp1019_ == _tmp1021_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp1022_ = FALSE;
									ValaMethod* _tmp1023_;
									ValaMethod* _tmp1024_;
									ValaMethod* _tmp1025_;
									_tmp1023_ = async_method;
									_tmp1024_ = vala_method_get_base_method (_tmp1023_);
									_tmp1025_ = _tmp1024_;
									if (_tmp1025_ != NULL) {
										ValaMethod* _tmp1026_;
										ValaMethod* _tmp1027_;
										ValaMethod* _tmp1028_;
										ValaMethod* _tmp1029_;
										ValaMethod* _tmp1030_;
										_tmp1026_ = m;
										_tmp1027_ = async_method;
										_tmp1028_ = vala_method_get_base_method (_tmp1027_);
										_tmp1029_ = _tmp1028_;
										_tmp1030_ = vala_method_get_callback_method (_tmp1029_);
										_tmp1022_ = _tmp1026_ == _tmp1030_;
									} else {
										_tmp1022_ = FALSE;
									}
									if (_tmp1022_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1031_ = FALSE;
										ValaMethod* _tmp1032_;
										ValaMethod* _tmp1033_;
										ValaMethod* _tmp1034_;
										_tmp1032_ = async_method;
										_tmp1033_ = vala_method_get_base_interface_method (_tmp1032_);
										_tmp1034_ = _tmp1033_;
										if (_tmp1034_ != NULL) {
											ValaMethod* _tmp1035_;
											ValaMethod* _tmp1036_;
											ValaMethod* _tmp1037_;
											ValaMethod* _tmp1038_;
											ValaMethod* _tmp1039_;
											_tmp1035_ = m;
											_tmp1036_ = async_method;
											_tmp1037_ = vala_method_get_base_interface_method (_tmp1036_);
											_tmp1038_ = _tmp1037_;
											_tmp1039_ = vala_method_get_callback_method (_tmp1038_);
											_tmp1031_ = _tmp1035_ == _tmp1039_;
										} else {
											_tmp1031_ = FALSE;
										}
										if (_tmp1031_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1040_;
								ValaSourceReference* _tmp1041_;
								ValaMethod* _tmp1042_;
								gchar* _tmp1043_;
								gchar* _tmp1044_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1040_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1041_ = _tmp1040_;
								_tmp1042_ = m;
								_tmp1043_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1042_);
								_tmp1044_ = _tmp1043_;
								vala_report_error (_tmp1041_, "Access to async callback `%s' not allowed in this context", _tmp1044_);
								_g_free0 (_tmp1044_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1045_ = async_method;
							_tmp1046_ = vala_code_context_get_analyzer (context);
							_tmp1047_ = _tmp1046_;
							_tmp1048_ = vala_semantic_analyzer_get_current_method (_tmp1047_);
							_tmp1049_ = _tmp1048_;
							if (_tmp1045_ != _tmp1049_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1050_;
								ValaSemanticAnalyzer* _tmp1051_;
								ValaMethod* _tmp1052_;
								ValaMethod* _tmp1053_;
								ValaMethod* _tmp1062_;
								ValaBlock* _tmp1063_;
								ValaBlock* _tmp1064_;
								_tmp1050_ = vala_code_context_get_analyzer (context);
								_tmp1051_ = _tmp1050_;
								_tmp1052_ = vala_semantic_analyzer_get_current_method (_tmp1051_);
								_tmp1053_ = _tmp1052_;
								sym = (ValaSymbol*) _tmp1053_;
								while (TRUE) {
									ValaSymbol* _tmp1054_;
									ValaMethod* _tmp1055_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1056_;
									ValaMethod* _tmp1057_;
									ValaSymbol* _tmp1059_;
									ValaSymbol* _tmp1060_;
									ValaSymbol* _tmp1061_;
									_tmp1054_ = sym;
									_tmp1055_ = async_method;
									if (!(_tmp1054_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1055_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1056_ = sym;
									method = VALA_IS_METHOD (_tmp1056_) ? ((ValaMethod*) _tmp1056_) : NULL;
									_tmp1057_ = method;
									if (_tmp1057_ != NULL) {
										ValaMethod* _tmp1058_;
										_tmp1058_ = method;
										vala_method_set_closure (_tmp1058_, TRUE);
									}
									_tmp1059_ = sym;
									_tmp1060_ = vala_symbol_get_parent_symbol (_tmp1059_);
									_tmp1061_ = _tmp1060_;
									sym = _tmp1061_;
								}
								_tmp1062_ = async_method;
								_tmp1063_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1062_);
								_tmp1064_ = _tmp1063_;
								vala_block_set_captured (_tmp1064_, TRUE);
							}
							_tmp1065_ = async_method;
							_tmp1066_ = vala_method_get_callback_method (_tmp1065_);
							m = _tmp1066_;
							_tmp1067_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1067_);
							_tmp1068_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1069_ = _tmp1068_;
							member = _tmp1069_;
						} else {
							ValaMethod* _tmp1070_;
							ValaMethod* _tmp1071_;
							ValaMethod* _tmp1072_;
							_tmp1070_ = m;
							_tmp1071_ = vala_method_get_base_method (_tmp1070_);
							_tmp1072_ = _tmp1071_;
							if (_tmp1072_ != NULL) {
								ValaMethod* _tmp1073_;
								ValaMethod* _tmp1074_;
								ValaMethod* _tmp1075_;
								ValaMethod* _tmp1076_;
								ValaSignal* _tmp1077_;
								ValaSignal* _tmp1078_;
								ValaSymbol* _tmp1083_;
								ValaSymbol* _tmp1084_;
								_tmp1073_ = m;
								_tmp1074_ = vala_method_get_base_method (_tmp1073_);
								_tmp1075_ = _tmp1074_;
								m = _tmp1075_;
								_tmp1076_ = m;
								_tmp1077_ = vala_method_get_signal_reference (_tmp1076_);
								_tmp1078_ = _tmp1077_;
								if (_tmp1078_ != NULL) {
									ValaMethod* _tmp1079_;
									ValaSignal* _tmp1080_;
									ValaSignal* _tmp1081_;
									_tmp1079_ = m;
									_tmp1080_ = vala_method_get_signal_reference (_tmp1079_);
									_tmp1081_ = _tmp1080_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1081_);
								} else {
									ValaMethod* _tmp1082_;
									_tmp1082_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1082_);
								}
								_tmp1083_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1084_ = _tmp1083_;
								member = _tmp1084_;
							} else {
								ValaMethod* _tmp1085_;
								ValaMethod* _tmp1086_;
								ValaMethod* _tmp1087_;
								_tmp1085_ = m;
								_tmp1086_ = vala_method_get_base_interface_method (_tmp1085_);
								_tmp1087_ = _tmp1086_;
								if (_tmp1087_ != NULL) {
									ValaMethod* _tmp1088_;
									ValaMethod* _tmp1089_;
									ValaMethod* _tmp1090_;
									ValaMethod* _tmp1091_;
									ValaSignal* _tmp1092_;
									ValaSignal* _tmp1093_;
									ValaSymbol* _tmp1098_;
									ValaSymbol* _tmp1099_;
									_tmp1088_ = m;
									_tmp1089_ = vala_method_get_base_interface_method (_tmp1088_);
									_tmp1090_ = _tmp1089_;
									m = _tmp1090_;
									_tmp1091_ = m;
									_tmp1092_ = vala_method_get_signal_reference (_tmp1091_);
									_tmp1093_ = _tmp1092_;
									if (_tmp1093_ != NULL) {
										ValaMethod* _tmp1094_;
										ValaSignal* _tmp1095_;
										ValaSignal* _tmp1096_;
										_tmp1094_ = m;
										_tmp1095_ = vala_method_get_signal_reference (_tmp1094_);
										_tmp1096_ = _tmp1095_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1096_);
									} else {
										ValaMethod* _tmp1097_;
										_tmp1097_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1097_);
									}
									_tmp1098_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1099_ = _tmp1098_;
									member = _tmp1099_;
								}
							}
						}
						_tmp1100_ = m;
						_tmp1101_ = vala_symbol_get_access ((ValaSymbol*) _tmp1100_);
						_tmp1102_ = _tmp1101_;
						access = _tmp1102_;
						_tmp1103_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1103_)) {
							ValaMethod* _tmp1104_;
							ValaMemberBinding _tmp1105_;
							ValaMemberBinding _tmp1106_;
							_tmp1104_ = m;
							_tmp1105_ = vala_method_get_binding (_tmp1104_);
							_tmp1106_ = _tmp1105_;
							instance = _tmp1106_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1107_ = m;
						_tmp1108_ = vala_method_get_binding (_tmp1107_);
						_tmp1109_ = _tmp1108_;
						klass = _tmp1109_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1110_;
							ValaList* _tmp1111_;
							gint _param_size = 0;
							ValaList* _tmp1112_;
							gint _tmp1113_;
							gint _tmp1114_;
							gint _param_index = 0;
							_tmp1110_ = m;
							_tmp1111_ = vala_callable_get_parameters ((ValaCallable*) _tmp1110_);
							_param_list = _tmp1111_;
							_tmp1112_ = _param_list;
							_tmp1113_ = vala_collection_get_size ((ValaCollection*) _tmp1112_);
							_tmp1114_ = _tmp1113_;
							_param_size = _tmp1114_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1115_;
								gint _tmp1116_;
								ValaParameter* param = NULL;
								ValaList* _tmp1117_;
								gpointer _tmp1118_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1119_;
								ValaDataType* _tmp1120_;
								ValaDataType* _tmp1121_;
								gboolean _tmp1122_ = FALSE;
								ValaGenericType* _tmp1123_;
								_param_index = _param_index + 1;
								_tmp1115_ = _param_index;
								_tmp1116_ = _param_size;
								if (!(_tmp1115_ < _tmp1116_)) {
									break;
								}
								_tmp1117_ = _param_list;
								_tmp1118_ = vala_list_get (_tmp1117_, _param_index);
								param = (ValaParameter*) _tmp1118_;
								_tmp1119_ = param;
								_tmp1120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1119_);
								_tmp1121_ = _tmp1120_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1121_) ? ((ValaGenericType*) _tmp1121_) : NULL;
								_tmp1123_ = generic_type;
								if (_tmp1123_ != NULL) {
									ValaGenericType* _tmp1124_;
									ValaTypeParameter* _tmp1125_;
									ValaTypeParameter* _tmp1126_;
									ValaSymbol* _tmp1127_;
									ValaSymbol* _tmp1128_;
									_tmp1124_ = generic_type;
									_tmp1125_ = vala_generic_type_get_type_parameter (_tmp1124_);
									_tmp1126_ = _tmp1125_;
									_tmp1127_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1126_);
									_tmp1128_ = _tmp1127_;
									_tmp1122_ = VALA_IS_TYPESYMBOL (_tmp1128_);
								} else {
									_tmp1122_ = FALSE;
								}
								if (_tmp1122_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1129_ = m;
						_tmp1130_ = vala_callable_get_return_type ((ValaCallable*) _tmp1129_);
						_tmp1131_ = _tmp1130_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1131_) ? ((ValaGenericType*) _tmp1131_) : NULL;
						_tmp1133_ = generic_type;
						if (_tmp1133_ != NULL) {
							ValaGenericType* _tmp1134_;
							ValaTypeParameter* _tmp1135_;
							ValaTypeParameter* _tmp1136_;
							ValaSymbol* _tmp1137_;
							ValaSymbol* _tmp1138_;
							_tmp1134_ = generic_type;
							_tmp1135_ = vala_generic_type_get_type_parameter (_tmp1134_);
							_tmp1136_ = _tmp1135_;
							_tmp1137_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1136_);
							_tmp1138_ = _tmp1137_;
							_tmp1132_ = VALA_IS_TYPESYMBOL (_tmp1138_);
						} else {
							_tmp1132_ = FALSE;
						}
						if (_tmp1132_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1139_;
						_tmp1139_ = member;
						if (VALA_IS_PROPERTY (_tmp1139_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1140_;
							ValaProperty* _tmp1141_;
							ValaProperty* _tmp1142_;
							ValaProperty* _tmp1143_;
							ValaProperty* _tmp1144_;
							ValaProperty* _tmp1160_;
							ValaSymbolAccessibility _tmp1161_;
							ValaSymbolAccessibility _tmp1162_;
							gboolean _tmp1163_;
							gboolean _tmp1164_;
							ValaProperty* _tmp1263_;
							ValaMemberBinding _tmp1264_;
							ValaMemberBinding _tmp1265_;
							ValaProperty* _tmp1266_;
							ValaDataType* _tmp1267_;
							ValaDataType* _tmp1268_;
							_tmp1140_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1140_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1141_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1141_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1142_ = prop;
							_tmp1143_ = vala_property_get_base_property (_tmp1142_);
							_tmp1144_ = _tmp1143_;
							if (_tmp1144_ != NULL) {
								ValaProperty* _tmp1145_;
								ValaProperty* _tmp1146_;
								ValaProperty* _tmp1147_;
								ValaProperty* _tmp1148_;
								ValaSymbol* _tmp1149_;
								ValaSymbol* _tmp1150_;
								_tmp1145_ = prop;
								_tmp1146_ = vala_property_get_base_property (_tmp1145_);
								_tmp1147_ = _tmp1146_;
								prop = _tmp1147_;
								_tmp1148_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1148_);
								_tmp1149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1150_ = _tmp1149_;
								member = _tmp1150_;
							} else {
								ValaProperty* _tmp1151_;
								ValaProperty* _tmp1152_;
								ValaProperty* _tmp1153_;
								_tmp1151_ = prop;
								_tmp1152_ = vala_property_get_base_interface_property (_tmp1151_);
								_tmp1153_ = _tmp1152_;
								if (_tmp1153_ != NULL) {
									ValaProperty* _tmp1154_;
									ValaProperty* _tmp1155_;
									ValaProperty* _tmp1156_;
									ValaProperty* _tmp1157_;
									ValaSymbol* _tmp1158_;
									ValaSymbol* _tmp1159_;
									_tmp1154_ = prop;
									_tmp1155_ = vala_property_get_base_interface_property (_tmp1154_);
									_tmp1156_ = _tmp1155_;
									prop = _tmp1156_;
									_tmp1157_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1157_);
									_tmp1158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1159_ = _tmp1158_;
									member = _tmp1159_;
								}
							}
							_tmp1160_ = prop;
							_tmp1161_ = vala_symbol_get_access ((ValaSymbol*) _tmp1160_);
							_tmp1162_ = _tmp1161_;
							access = _tmp1162_;
							_tmp1163_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1164_ = _tmp1163_;
							if (_tmp1164_) {
								ValaProperty* _tmp1165_;
								ValaPropertyAccessor* _tmp1166_;
								ValaPropertyAccessor* _tmp1167_;
								ValaProperty* _tmp1211_;
								ValaSymbolAccessibility _tmp1212_;
								ValaSymbolAccessibility _tmp1213_;
								_tmp1165_ = prop;
								_tmp1166_ = vala_property_get_set_accessor (_tmp1165_);
								_tmp1167_ = _tmp1166_;
								if (_tmp1167_ == NULL) {
									ValaSourceReference* _tmp1168_;
									ValaSourceReference* _tmp1169_;
									ValaProperty* _tmp1170_;
									gchar* _tmp1171_;
									gchar* _tmp1172_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1168_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1169_ = _tmp1168_;
									_tmp1170_ = prop;
									_tmp1171_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1170_);
									_tmp1172_ = _tmp1171_;
									vala_report_error (_tmp1169_, "Property `%s' is read-only", _tmp1172_);
									_g_free0 (_tmp1172_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1173_ = FALSE;
									ValaProperty* _tmp1174_;
									ValaPropertyAccessor* _tmp1175_;
									ValaPropertyAccessor* _tmp1176_;
									gboolean _tmp1177_;
									gboolean _tmp1178_;
									_tmp1174_ = prop;
									_tmp1175_ = vala_property_get_set_accessor (_tmp1174_);
									_tmp1176_ = _tmp1175_;
									_tmp1177_ = vala_property_accessor_get_writable (_tmp1176_);
									_tmp1178_ = _tmp1177_;
									if (!_tmp1178_) {
										ValaProperty* _tmp1179_;
										ValaPropertyAccessor* _tmp1180_;
										ValaPropertyAccessor* _tmp1181_;
										gboolean _tmp1182_;
										gboolean _tmp1183_;
										_tmp1179_ = prop;
										_tmp1180_ = vala_property_get_set_accessor (_tmp1179_);
										_tmp1181_ = _tmp1180_;
										_tmp1182_ = vala_property_accessor_get_construction (_tmp1181_);
										_tmp1183_ = _tmp1182_;
										_tmp1173_ = _tmp1183_;
									} else {
										_tmp1173_ = FALSE;
									}
									if (_tmp1173_) {
										ValaSemanticAnalyzer* _tmp1184_;
										ValaSemanticAnalyzer* _tmp1185_;
										ValaMethod* _tmp1186_;
										_tmp1184_ = vala_code_context_get_analyzer (context);
										_tmp1185_ = _tmp1184_;
										_tmp1186_ = vala_semantic_analyzer_find_current_method (_tmp1185_);
										if (VALA_IS_CREATION_METHOD (_tmp1186_)) {
											ValaSourceReference* _tmp1187_;
											ValaSourceReference* _tmp1188_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1188_ = _tmp1187_;
											vala_report_error (_tmp1188_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1189_;
											ValaSemanticAnalyzer* _tmp1190_;
											_tmp1189_ = vala_code_context_get_analyzer (context);
											_tmp1190_ = _tmp1189_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1190_)) {
												ValaSemanticAnalyzer* _tmp1191_;
												ValaSemanticAnalyzer* _tmp1192_;
												ValaTypeSymbol* _tmp1193_;
												ValaTypeSymbol* _tmp1194_;
												ValaProperty* _tmp1195_;
												ValaSymbol* _tmp1196_;
												ValaSymbol* _tmp1197_;
												_tmp1191_ = vala_code_context_get_analyzer (context);
												_tmp1192_ = _tmp1191_;
												_tmp1193_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1192_);
												_tmp1194_ = _tmp1193_;
												_tmp1195_ = prop;
												_tmp1196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1195_);
												_tmp1197_ = _tmp1196_;
												if (!vala_typesymbol_is_subtype_of (_tmp1194_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1197_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1198_;
													ValaSourceReference* _tmp1199_;
													ValaProperty* _tmp1200_;
													gchar* _tmp1201_;
													gchar* _tmp1202_;
													ValaSemanticAnalyzer* _tmp1203_;
													ValaSemanticAnalyzer* _tmp1204_;
													ValaTypeSymbol* _tmp1205_;
													ValaTypeSymbol* _tmp1206_;
													gchar* _tmp1207_;
													gchar* _tmp1208_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1199_ = _tmp1198_;
													_tmp1200_ = prop;
													_tmp1201_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1200_);
													_tmp1202_ = _tmp1201_;
													_tmp1203_ = vala_code_context_get_analyzer (context);
													_tmp1204_ = _tmp1203_;
													_tmp1205_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1204_);
													_tmp1206_ = _tmp1205_;
													_tmp1207_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1206_);
													_tmp1208_ = _tmp1207_;
													vala_report_error (_tmp1199_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1202_, _tmp1208_);
													_g_free0 (_tmp1208_);
													_g_free0 (_tmp1202_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1209_;
												ValaSourceReference* _tmp1210_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1210_ = _tmp1209_;
												vala_report_error (_tmp1210_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1211_ = prop;
								_tmp1212_ = vala_symbol_get_access ((ValaSymbol*) _tmp1211_);
								_tmp1213_ = _tmp1212_;
								if (_tmp1213_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1214_;
									ValaPropertyAccessor* _tmp1215_;
									ValaPropertyAccessor* _tmp1216_;
									ValaSymbolAccessibility _tmp1217_;
									ValaSymbolAccessibility _tmp1218_;
									_tmp1214_ = prop;
									_tmp1215_ = vala_property_get_set_accessor (_tmp1214_);
									_tmp1216_ = _tmp1215_;
									_tmp1217_ = vala_symbol_get_access ((ValaSymbol*) _tmp1216_);
									_tmp1218_ = _tmp1217_;
									access = _tmp1218_;
								} else {
									gboolean _tmp1219_ = FALSE;
									ValaProperty* _tmp1220_;
									ValaSymbolAccessibility _tmp1221_;
									ValaSymbolAccessibility _tmp1222_;
									_tmp1220_ = prop;
									_tmp1221_ = vala_symbol_get_access ((ValaSymbol*) _tmp1220_);
									_tmp1222_ = _tmp1221_;
									if (_tmp1222_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1223_;
										ValaPropertyAccessor* _tmp1224_;
										ValaPropertyAccessor* _tmp1225_;
										ValaSymbolAccessibility _tmp1226_;
										ValaSymbolAccessibility _tmp1227_;
										_tmp1223_ = prop;
										_tmp1224_ = vala_property_get_set_accessor (_tmp1223_);
										_tmp1225_ = _tmp1224_;
										_tmp1226_ = vala_symbol_get_access ((ValaSymbol*) _tmp1225_);
										_tmp1227_ = _tmp1226_;
										_tmp1219_ = _tmp1227_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1219_ = FALSE;
									}
									if (_tmp1219_) {
										ValaProperty* _tmp1228_;
										ValaPropertyAccessor* _tmp1229_;
										ValaPropertyAccessor* _tmp1230_;
										ValaSymbolAccessibility _tmp1231_;
										ValaSymbolAccessibility _tmp1232_;
										_tmp1228_ = prop;
										_tmp1229_ = vala_property_get_set_accessor (_tmp1228_);
										_tmp1230_ = _tmp1229_;
										_tmp1231_ = vala_symbol_get_access ((ValaSymbol*) _tmp1230_);
										_tmp1232_ = _tmp1231_;
										access = _tmp1232_;
									}
								}
							} else {
								ValaProperty* _tmp1233_;
								ValaPropertyAccessor* _tmp1234_;
								ValaPropertyAccessor* _tmp1235_;
								ValaProperty* _tmp1241_;
								ValaSymbolAccessibility _tmp1242_;
								ValaSymbolAccessibility _tmp1243_;
								_tmp1233_ = prop;
								_tmp1234_ = vala_property_get_get_accessor (_tmp1233_);
								_tmp1235_ = _tmp1234_;
								if (_tmp1235_ == NULL) {
									ValaSourceReference* _tmp1236_;
									ValaSourceReference* _tmp1237_;
									ValaProperty* _tmp1238_;
									gchar* _tmp1239_;
									gchar* _tmp1240_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1237_ = _tmp1236_;
									_tmp1238_ = prop;
									_tmp1239_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1238_);
									_tmp1240_ = _tmp1239_;
									vala_report_error (_tmp1237_, "Property `%s' is write-only", _tmp1240_);
									_g_free0 (_tmp1240_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1241_ = prop;
								_tmp1242_ = vala_symbol_get_access ((ValaSymbol*) _tmp1241_);
								_tmp1243_ = _tmp1242_;
								if (_tmp1243_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1244_;
									ValaPropertyAccessor* _tmp1245_;
									ValaPropertyAccessor* _tmp1246_;
									ValaSymbolAccessibility _tmp1247_;
									ValaSymbolAccessibility _tmp1248_;
									_tmp1244_ = prop;
									_tmp1245_ = vala_property_get_get_accessor (_tmp1244_);
									_tmp1246_ = _tmp1245_;
									_tmp1247_ = vala_symbol_get_access ((ValaSymbol*) _tmp1246_);
									_tmp1248_ = _tmp1247_;
									access = _tmp1248_;
								} else {
									gboolean _tmp1249_ = FALSE;
									ValaProperty* _tmp1250_;
									ValaSymbolAccessibility _tmp1251_;
									ValaSymbolAccessibility _tmp1252_;
									_tmp1250_ = prop;
									_tmp1251_ = vala_symbol_get_access ((ValaSymbol*) _tmp1250_);
									_tmp1252_ = _tmp1251_;
									if (_tmp1252_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1253_;
										ValaPropertyAccessor* _tmp1254_;
										ValaPropertyAccessor* _tmp1255_;
										ValaSymbolAccessibility _tmp1256_;
										ValaSymbolAccessibility _tmp1257_;
										_tmp1253_ = prop;
										_tmp1254_ = vala_property_get_get_accessor (_tmp1253_);
										_tmp1255_ = _tmp1254_;
										_tmp1256_ = vala_symbol_get_access ((ValaSymbol*) _tmp1255_);
										_tmp1257_ = _tmp1256_;
										_tmp1249_ = _tmp1257_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1249_ = FALSE;
									}
									if (_tmp1249_) {
										ValaProperty* _tmp1258_;
										ValaPropertyAccessor* _tmp1259_;
										ValaPropertyAccessor* _tmp1260_;
										ValaSymbolAccessibility _tmp1261_;
										ValaSymbolAccessibility _tmp1262_;
										_tmp1258_ = prop;
										_tmp1259_ = vala_property_get_get_accessor (_tmp1258_);
										_tmp1260_ = _tmp1259_;
										_tmp1261_ = vala_symbol_get_access ((ValaSymbol*) _tmp1260_);
										_tmp1262_ = _tmp1261_;
										access = _tmp1262_;
									}
								}
							}
							_tmp1263_ = prop;
							_tmp1264_ = vala_property_get_binding (_tmp1263_);
							_tmp1265_ = _tmp1264_;
							instance = _tmp1265_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1266_ = prop;
							_tmp1267_ = vala_property_get_property_type (_tmp1266_);
							_tmp1268_ = _tmp1267_;
							if (VALA_IS_GENERIC_TYPE (_tmp1268_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1269_;
							_tmp1269_ = member;
							if (VALA_IS_SIGNAL (_tmp1269_)) {
								ValaSymbol* _tmp1270_;
								ValaSymbolAccessibility _tmp1271_;
								ValaSymbolAccessibility _tmp1272_;
								instance = TRUE;
								_tmp1270_ = member;
								_tmp1271_ = vala_symbol_get_access (_tmp1270_);
								_tmp1272_ = _tmp1271_;
								access = _tmp1272_;
							} else {
								gboolean _tmp1273_ = FALSE;
								gboolean _tmp1274_;
								_tmp1274_ = self->priv->_creation_member;
								if (!_tmp1274_) {
									ValaSymbol* _tmp1275_;
									_tmp1275_ = member;
									_tmp1273_ = VALA_IS_ERROR_CODE (_tmp1275_);
								} else {
									_tmp1273_ = FALSE;
								}
								if (_tmp1273_) {
									ValaSymbol* _tmp1276_;
									ValaConstant* _tmp1277_;
									ValaConstant* _tmp1278_;
									ValaSymbol* _tmp1279_;
									ValaSymbol* _tmp1280_;
									_tmp1276_ = member;
									_tmp1277_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1276_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1278_ = _tmp1277_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1278_);
									_tmp1279_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1280_ = _tmp1279_;
									member = _tmp1280_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1281_;
		ValaSymbol* _tmp1282_;
		ValaCodeNode* _tmp1283_;
		ValaCodeNode* _tmp1284_;
		ValaCodeNode* _tmp1285_;
		gboolean _tmp1286_ = FALSE;
		ValaCodeNode* _tmp1287_;
		_tmp1281_ = parent;
		_tmp1282_ = member;
		if (!(_tmp1281_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1282_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1283_ = parent;
		_tmp1284_ = vala_code_node_get_parent_node (_tmp1283_);
		_tmp1285_ = _tmp1284_;
		parent = _tmp1285_;
		_tmp1287_ = parent;
		if (_tmp1287_ == NULL) {
			_tmp1286_ = TRUE;
		} else {
			ValaCodeNode* _tmp1288_;
			ValaSymbol* _tmp1289_;
			_tmp1288_ = parent;
			_tmp1289_ = member;
			_tmp1286_ = _tmp1288_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1289_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1286_) {
			break;
		}
	}
	_tmp1290_ = parent;
	_tmp1291_ = member;
	if (_tmp1290_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1291_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1292_;
		_tmp1292_ = member;
		vala_symbol_set_used (_tmp1292_, TRUE);
	}
	_tmp1293_ = member;
	_tmp1294_ = vala_symbol_get_version (_tmp1293_);
	_tmp1295_ = _tmp1294_;
	_tmp1296_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1297_ = _tmp1296_;
	vala_version_attribute_check (_tmp1295_, context, _tmp1297_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1299_;
		ValaSymbol* _tmp1300_;
		ValaSymbol* _tmp1301_;
		_tmp1299_ = member;
		_tmp1300_ = vala_symbol_get_parent_symbol (_tmp1299_);
		_tmp1301_ = _tmp1300_;
		_tmp1298_ = VALA_IS_TYPESYMBOL (_tmp1301_);
	} else {
		_tmp1298_ = FALSE;
	}
	if (_tmp1298_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1302_;
		ValaSymbol* _tmp1303_;
		ValaSymbol* _tmp1304_;
		gboolean in_subtype = FALSE;
		_tmp1302_ = member;
		_tmp1303_ = vala_symbol_get_parent_symbol (_tmp1302_);
		_tmp1304_ = _tmp1303_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1304_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1305_;
			ValaSemanticAnalyzer* _tmp1306_;
			ValaSymbol* _tmp1307_;
			ValaSymbol* _tmp1308_;
			ValaSymbol* _tmp1309_;
			_tmp1305_ = vala_code_context_get_analyzer (context);
			_tmp1306_ = _tmp1305_;
			_tmp1307_ = vala_semantic_analyzer_get_current_symbol (_tmp1306_);
			_tmp1308_ = _tmp1307_;
			_tmp1309_ = _vala_code_node_ref0 (_tmp1308_);
			this_symbol = _tmp1309_;
			{
				gboolean _tmp1310_ = FALSE;
				_tmp1310_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1315_;
					ValaSymbol* _tmp1316_;
					ValaTypeSymbol* _tmp1317_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1318_;
					gboolean _tmp1319_ = FALSE;
					ValaClass* _tmp1320_;
					if (!_tmp1310_) {
						ValaSymbol* _tmp1311_;
						ValaSymbol* _tmp1312_;
						ValaSymbol* _tmp1313_;
						ValaSymbol* _tmp1314_;
						_tmp1311_ = this_symbol;
						_tmp1312_ = vala_symbol_get_parent_symbol (_tmp1311_);
						_tmp1313_ = _tmp1312_;
						_tmp1314_ = _vala_code_node_ref0 (_tmp1313_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1314_;
					}
					_tmp1310_ = FALSE;
					_tmp1315_ = this_symbol;
					if (!(_tmp1315_ != NULL)) {
						break;
					}
					_tmp1316_ = this_symbol;
					_tmp1317_ = target_type;
					if (_tmp1316_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1317_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1318_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1318_) ? ((ValaClass*) _tmp1318_) : NULL;
					_tmp1320_ = cl;
					if (_tmp1320_ != NULL) {
						ValaClass* _tmp1321_;
						ValaTypeSymbol* _tmp1322_;
						_tmp1321_ = cl;
						_tmp1322_ = target_type;
						_tmp1319_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1321_, _tmp1322_);
					} else {
						_tmp1319_ = FALSE;
					}
					if (_tmp1319_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1323_;
			ValaSourceReference* _tmp1324_;
			ValaSymbol* _tmp1325_;
			gchar* _tmp1326_;
			gchar* _tmp1327_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1323_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1324_ = _tmp1323_;
			_tmp1325_ = member;
			_tmp1326_ = vala_symbol_get_full_name (_tmp1325_);
			_tmp1327_ = _tmp1326_;
			vala_report_error (_tmp1324_, "Access to protected member `%s' denied", _tmp1327_);
			_g_free0 (_tmp1327_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1328_;
			ValaSymbol* _tmp1329_;
			ValaSymbol* _tmp1330_;
			gboolean in_target_type = FALSE;
			_tmp1328_ = member;
			_tmp1329_ = vala_symbol_get_parent_symbol (_tmp1328_);
			_tmp1330_ = _tmp1329_;
			target_type = _tmp1330_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1331_;
				ValaSemanticAnalyzer* _tmp1332_;
				ValaSymbol* _tmp1333_;
				ValaSymbol* _tmp1334_;
				ValaSymbol* _tmp1335_;
				_tmp1331_ = vala_code_context_get_analyzer (context);
				_tmp1332_ = _tmp1331_;
				_tmp1333_ = vala_semantic_analyzer_get_current_symbol (_tmp1332_);
				_tmp1334_ = _tmp1333_;
				_tmp1335_ = _vala_code_node_ref0 (_tmp1334_);
				this_symbol = _tmp1335_;
				{
					gboolean _tmp1336_ = FALSE;
					_tmp1336_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1341_;
						ValaSymbol* _tmp1342_;
						ValaSymbol* _tmp1343_;
						if (!_tmp1336_) {
							ValaSymbol* _tmp1337_;
							ValaSymbol* _tmp1338_;
							ValaSymbol* _tmp1339_;
							ValaSymbol* _tmp1340_;
							_tmp1337_ = this_symbol;
							_tmp1338_ = vala_symbol_get_parent_symbol (_tmp1337_);
							_tmp1339_ = _tmp1338_;
							_tmp1340_ = _vala_code_node_ref0 (_tmp1339_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1340_;
						}
						_tmp1336_ = FALSE;
						_tmp1341_ = this_symbol;
						if (!(_tmp1341_ != NULL)) {
							break;
						}
						_tmp1342_ = target_type;
						_tmp1343_ = this_symbol;
						if (_tmp1342_ == _tmp1343_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1344_;
				ValaSourceReference* _tmp1345_;
				ValaSymbol* _tmp1346_;
				gchar* _tmp1347_;
				gchar* _tmp1348_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1344_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1345_ = _tmp1344_;
				_tmp1346_ = member;
				_tmp1347_ = vala_symbol_get_full_name (_tmp1346_);
				_tmp1348_ = _tmp1347_;
				vala_report_error (_tmp1345_, "Access to private member `%s' denied", _tmp1348_);
				_g_free0 (_tmp1348_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1350_;
		ValaExpression* _tmp1351_;
		_tmp1350_ = vala_member_access_get_inner (self);
		_tmp1351_ = _tmp1350_;
		_tmp1349_ = _tmp1351_ != NULL;
	} else {
		_tmp1349_ = FALSE;
	}
	if (_tmp1349_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1352_;
		ValaExpression* _tmp1353_;
		ValaDataType* _tmp1354_;
		ValaDataType* _tmp1355_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1356_;
		ValaExpression* _tmp1357_;
		ValaDataType* _tmp1358_;
		ValaDataType* _tmp1359_;
		ValaPointerType* _tmp1360_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1364_;
		gboolean _tmp1365_ = FALSE;
		gboolean _tmp1366_ = FALSE;
		ValaObjectType* _tmp1367_;
		_tmp1352_ = vala_member_access_get_inner (self);
		_tmp1353_ = _tmp1352_;
		_tmp1354_ = vala_expression_get_value_type (_tmp1353_);
		_tmp1355_ = _tmp1354_;
		instance_type = _tmp1355_;
		_tmp1356_ = vala_member_access_get_inner (self);
		_tmp1357_ = _tmp1356_;
		_tmp1358_ = vala_expression_get_value_type (_tmp1357_);
		_tmp1359_ = _tmp1358_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1359_) ? ((ValaPointerType*) _tmp1359_) : NULL;
		_tmp1360_ = pointer_type;
		if (_tmp1360_ != NULL) {
			ValaPointerType* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			_tmp1361_ = pointer_type;
			_tmp1362_ = vala_pointer_type_get_base_type (_tmp1361_);
			_tmp1363_ = _tmp1362_;
			instance_type = _tmp1363_;
		}
		_tmp1364_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1364_) ? ((ValaObjectType*) _tmp1364_) : NULL;
		_tmp1367_ = object_type;
		if (_tmp1367_ != NULL) {
			ValaObjectType* _tmp1368_;
			ValaObjectTypeSymbol* _tmp1369_;
			ValaObjectTypeSymbol* _tmp1370_;
			_tmp1368_ = object_type;
			_tmp1369_ = vala_object_type_get_object_type_symbol (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			_tmp1366_ = vala_object_type_symbol_has_type_parameters (_tmp1370_);
		} else {
			_tmp1366_ = FALSE;
		}
		if (_tmp1366_) {
			ValaDataType* _tmp1371_;
			_tmp1371_ = instance_type;
			_tmp1365_ = !vala_data_type_has_type_arguments (_tmp1371_);
		} else {
			_tmp1365_ = FALSE;
		}
		if (_tmp1365_) {
			ValaExpression* _tmp1372_;
			ValaExpression* _tmp1373_;
			ValaSourceReference* _tmp1374_;
			ValaSourceReference* _tmp1375_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1372_ = vala_member_access_get_inner (self);
			_tmp1373_ = _tmp1372_;
			_tmp1374_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1373_);
			_tmp1375_ = _tmp1374_;
			vala_report_error (_tmp1375_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1377_ = !may_access_instance_members;
	} else {
		_tmp1377_ = FALSE;
	}
	if (_tmp1377_) {
		_tmp1376_ = TRUE;
	} else {
		gboolean _tmp1378_ = FALSE;
		if (klass) {
			_tmp1378_ = !may_access_klass_members;
		} else {
			_tmp1378_ = FALSE;
		}
		_tmp1376_ = _tmp1378_;
	}
	if (_tmp1376_) {
		ValaSymbol* _tmp1379_;
		ValaSymbol* _tmp1380_;
		ValaDataType* _tmp1415_;
		ValaDataType* _tmp1416_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1379_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1380_ = _tmp1379_;
		if (VALA_IS_METHOD (_tmp1380_)) {
			ValaSemanticAnalyzer* _tmp1381_;
			ValaSemanticAnalyzer* _tmp1382_;
			ValaSymbol* _tmp1383_;
			ValaSymbol* _tmp1384_;
			gboolean _tmp1385_;
			gboolean _tmp1386_;
			ValaDataType* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaDataType* _tmp1389_;
			ValaDataType* _tmp1390_;
			ValaSourceReference* _tmp1391_;
			ValaSourceReference* _tmp1392_;
			_tmp1381_ = vala_code_context_get_analyzer (context);
			_tmp1382_ = _tmp1381_;
			_tmp1383_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1384_ = _tmp1383_;
			_tmp1385_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1386_ = _tmp1385_;
			_tmp1387_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1382_, _tmp1384_, _tmp1386_);
			_tmp1388_ = _tmp1387_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1388_);
			_vala_code_node_unref0 (_tmp1388_);
			_tmp1389_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1390_ = _tmp1389_;
			_tmp1391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1392_ = _tmp1391_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1390_, _tmp1392_);
		} else {
			ValaSymbol* _tmp1393_;
			ValaSymbol* _tmp1394_;
			_tmp1393_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1394_ = _tmp1393_;
			if (VALA_IS_FIELD (_tmp1394_)) {
				ValaSymbol* _tmp1395_;
				ValaSymbol* _tmp1396_;
				ValaFieldPrototype* _tmp1397_;
				ValaFieldPrototype* _tmp1398_;
				ValaDataType* _tmp1399_;
				ValaDataType* _tmp1400_;
				ValaSourceReference* _tmp1401_;
				ValaSourceReference* _tmp1402_;
				_tmp1395_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1396_ = _tmp1395_;
				_tmp1397_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1396_, VALA_TYPE_FIELD, ValaField));
				_tmp1398_ = _tmp1397_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1398_);
				_vala_code_node_unref0 (_tmp1398_);
				_tmp1399_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1400_ = _tmp1399_;
				_tmp1401_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1402_ = _tmp1401_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1400_, _tmp1402_);
			} else {
				ValaSymbol* _tmp1403_;
				ValaSymbol* _tmp1404_;
				_tmp1403_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1404_ = _tmp1403_;
				if (VALA_IS_PROPERTY (_tmp1404_)) {
					ValaSymbol* _tmp1405_;
					ValaSymbol* _tmp1406_;
					ValaPropertyPrototype* _tmp1407_;
					ValaPropertyPrototype* _tmp1408_;
					ValaDataType* _tmp1409_;
					ValaDataType* _tmp1410_;
					ValaSourceReference* _tmp1411_;
					ValaSourceReference* _tmp1412_;
					_tmp1405_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1406_ = _tmp1405_;
					_tmp1407_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1406_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1408_ = _tmp1407_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1408_);
					_vala_code_node_unref0 (_tmp1408_);
					_tmp1409_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1410_ = _tmp1409_;
					_tmp1411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1412_ = _tmp1411_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1410_, _tmp1412_);
				} else {
					ValaInvalidType* _tmp1413_;
					ValaInvalidType* _tmp1414_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1413_ = vala_invalid_type_new ();
					_tmp1414_ = _tmp1413_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1414_);
					_vala_code_node_unref0 (_tmp1414_);
				}
			}
		}
		_tmp1415_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1416_ = _tmp1415_;
		if (_tmp1416_ != NULL) {
			ValaDataType* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			ValaDataType* _tmp1420_;
			gboolean _tmp1421_;
			gboolean _tmp1422_;
			_tmp1417_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1418_ = _tmp1417_;
			_tmp1419_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1420_ = _tmp1419_;
			_tmp1421_ = vala_data_type_get_value_owned (_tmp1420_);
			_tmp1422_ = _tmp1421_;
			vala_data_type_set_value_owned (_tmp1418_, _tmp1422_);
		}
	} else {
		gboolean _tmp1423_ = FALSE;
		gboolean _tmp1444_ = FALSE;
		gboolean _tmp1445_ = FALSE;
		gboolean _tmp1446_ = FALSE;
		gboolean _tmp1447_ = FALSE;
		gboolean _tmp1488_ = FALSE;
		gboolean _tmp1489_ = FALSE;
		gboolean _tmp1490_ = FALSE;
		gboolean _tmp1491_ = FALSE;
		gboolean _tmp1492_ = FALSE;
		gboolean _tmp1493_;
		gboolean _tmp1494_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1519_;
		ValaSymbol* _tmp1520_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1521_;
		ValaExpression* _tmp1522_;
		gboolean _tmp1523_ = FALSE;
		gboolean _tmp1524_ = FALSE;
		gboolean _tmp1525_ = FALSE;
		gboolean _tmp1526_ = FALSE;
		gboolean _tmp1527_ = FALSE;
		ValaMethod* _tmp1528_;
		ValaSemanticAnalyzer* _tmp1572_;
		ValaSemanticAnalyzer* _tmp1573_;
		ValaSymbol* _tmp1574_;
		ValaSymbol* _tmp1575_;
		gboolean _tmp1576_;
		gboolean _tmp1577_;
		ValaDataType* _tmp1578_;
		ValaDataType* _tmp1579_;
		gboolean _tmp1580_ = FALSE;
		ValaExpression* _tmp1581_;
		ValaExpression* _tmp1582_;
		ValaSymbol* _tmp1595_;
		ValaSymbol* _tmp1596_;
		gboolean _tmp1670_ = FALSE;
		gboolean _tmp1671_ = FALSE;
		ValaExpression* _tmp1672_;
		ValaExpression* _tmp1673_;
		if (instance) {
			ValaExpression* _tmp1424_;
			ValaExpression* _tmp1425_;
			_tmp1424_ = vala_member_access_get_inner (self);
			_tmp1425_ = _tmp1424_;
			_tmp1423_ = _tmp1425_ == NULL;
		} else {
			_tmp1423_ = FALSE;
		}
		if (_tmp1423_) {
			ValaSourceReference* _tmp1426_;
			ValaSourceReference* _tmp1427_;
			ValaMemberAccess* _tmp1428_;
			ValaMemberAccess* _tmp1429_;
			ValaExpression* _tmp1430_;
			ValaExpression* _tmp1431_;
			ValaParameter* _tmp1432_;
			ValaDataType* _tmp1433_;
			ValaDataType* _tmp1434_;
			ValaDataType* _tmp1435_;
			ValaDataType* _tmp1436_;
			ValaExpression* _tmp1437_;
			ValaExpression* _tmp1438_;
			ValaDataType* _tmp1439_;
			ValaDataType* _tmp1440_;
			ValaExpression* _tmp1441_;
			ValaExpression* _tmp1442_;
			ValaParameter* _tmp1443_;
			_tmp1426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1427_ = _tmp1426_;
			_tmp1428_ = vala_member_access_new (NULL, "this", _tmp1427_);
			_tmp1429_ = _tmp1428_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1429_);
			_vala_code_node_unref0 (_tmp1429_);
			_tmp1430_ = vala_member_access_get_inner (self);
			_tmp1431_ = _tmp1430_;
			_tmp1432_ = this_parameter;
			_tmp1433_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1432_);
			_tmp1434_ = _tmp1433_;
			_tmp1435_ = vala_data_type_copy (_tmp1434_);
			_tmp1436_ = _tmp1435_;
			vala_expression_set_value_type (_tmp1431_, _tmp1436_);
			_vala_code_node_unref0 (_tmp1436_);
			_tmp1437_ = vala_member_access_get_inner (self);
			_tmp1438_ = _tmp1437_;
			_tmp1439_ = vala_expression_get_value_type (_tmp1438_);
			_tmp1440_ = _tmp1439_;
			vala_data_type_set_value_owned (_tmp1440_, FALSE);
			_tmp1441_ = vala_member_access_get_inner (self);
			_tmp1442_ = _tmp1441_;
			_tmp1443_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1442_, (ValaSymbol*) _tmp1443_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1447_ = !klass;
		} else {
			_tmp1447_ = FALSE;
		}
		if (_tmp1447_) {
			ValaSymbol* _tmp1448_;
			ValaSymbol* _tmp1449_;
			_tmp1448_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1449_ = _tmp1448_;
			_tmp1446_ = !VALA_IS_CREATION_METHOD (_tmp1449_);
		} else {
			_tmp1446_ = FALSE;
		}
		if (_tmp1446_) {
			_tmp1445_ = may_access_instance_members;
		} else {
			_tmp1445_ = FALSE;
		}
		if (_tmp1445_) {
			ValaExpression* _tmp1450_;
			ValaExpression* _tmp1451_;
			_tmp1450_ = vala_member_access_get_inner (self);
			_tmp1451_ = _tmp1450_;
			_tmp1444_ = _tmp1451_ != NULL;
		} else {
			_tmp1444_ = FALSE;
		}
		if (_tmp1444_) {
			ValaExpression* _tmp1452_;
			ValaExpression* _tmp1453_;
			ValaSymbol* _tmp1454_;
			ValaSymbol* _tmp1455_;
			_tmp1452_ = vala_member_access_get_inner (self);
			_tmp1453_ = _tmp1452_;
			_tmp1454_ = vala_expression_get_symbol_reference (_tmp1453_);
			_tmp1455_ = _tmp1454_;
			if (VALA_IS_METHOD (_tmp1455_)) {
			} else {
				ValaSourceReference* _tmp1456_;
				ValaSourceReference* _tmp1457_;
				ValaSymbol* _tmp1458_;
				ValaSymbol* _tmp1459_;
				gchar* _tmp1460_;
				gchar* _tmp1461_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1462_;
				ValaSymbol* _tmp1463_;
				ValaSymbol* _tmp1464_;
				ValaSymbol* _tmp1465_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1485_;
				ValaExpression* _tmp1486_;
				ValaExpression* _tmp1487_;
				_tmp1456_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1457_ = _tmp1456_;
				_tmp1458_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1459_ = _tmp1458_;
				_tmp1460_ = vala_symbol_get_full_name (_tmp1459_);
				_tmp1461_ = _tmp1460_;
				vala_report_warning (_tmp1457_, "Access to static member `%s' with an instance reference", _tmp1461_);
				_g_free0 (_tmp1461_);
				_tmp1462_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1463_ = _tmp1462_;
				_tmp1464_ = vala_symbol_get_parent_symbol (_tmp1463_);
				_tmp1465_ = _tmp1464_;
				inner_sym = _tmp1465_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1466_ = FALSE;
					ValaSymbol* _tmp1467_;
					ValaMemberAccess* _tmp1471_;
					ValaSymbol* _tmp1472_;
					const gchar* _tmp1473_;
					const gchar* _tmp1474_;
					ValaSourceReference* _tmp1475_;
					ValaSourceReference* _tmp1476_;
					ValaMemberAccess* _tmp1477_;
					ValaMemberAccess* _tmp1478_;
					ValaMemberAccess* _tmp1479_;
					ValaExpression* _tmp1480_;
					ValaExpression* _tmp1481_;
					ValaSymbol* _tmp1482_;
					ValaSymbol* _tmp1483_;
					ValaSymbol* _tmp1484_;
					_tmp1467_ = inner_sym;
					if (_tmp1467_ != NULL) {
						ValaSymbol* _tmp1468_;
						const gchar* _tmp1469_;
						const gchar* _tmp1470_;
						_tmp1468_ = inner_sym;
						_tmp1469_ = vala_symbol_get_name (_tmp1468_);
						_tmp1470_ = _tmp1469_;
						_tmp1466_ = _tmp1470_ != NULL;
					} else {
						_tmp1466_ = FALSE;
					}
					if (!_tmp1466_) {
						break;
					}
					_tmp1471_ = inner_ma;
					_tmp1472_ = inner_sym;
					_tmp1473_ = vala_symbol_get_name (_tmp1472_);
					_tmp1474_ = _tmp1473_;
					_tmp1475_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1476_ = _tmp1475_;
					_tmp1477_ = vala_member_access_new (NULL, _tmp1474_, _tmp1476_);
					_tmp1478_ = _tmp1477_;
					vala_member_access_set_inner (_tmp1471_, (ValaExpression*) _tmp1478_);
					_vala_code_node_unref0 (_tmp1478_);
					_tmp1479_ = inner_ma;
					_tmp1480_ = vala_member_access_get_inner (_tmp1479_);
					_tmp1481_ = _tmp1480_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1481_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1482_ = inner_sym;
					_tmp1483_ = vala_symbol_get_parent_symbol (_tmp1482_);
					_tmp1484_ = _tmp1483_;
					inner_sym = _tmp1484_;
				}
				_tmp1485_ = inner_ma;
				vala_member_access_set_qualified (_tmp1485_, TRUE);
				_tmp1486_ = vala_member_access_get_inner (self);
				_tmp1487_ = _tmp1486_;
				vala_code_node_check ((ValaCodeNode*) _tmp1487_, context);
			}
		}
		_tmp1493_ = vala_code_context_get_experimental_non_null (context);
		_tmp1494_ = _tmp1493_;
		if (_tmp1494_) {
			_tmp1492_ = instance;
		} else {
			_tmp1492_ = FALSE;
		}
		if (_tmp1492_) {
			ValaExpression* _tmp1495_;
			ValaExpression* _tmp1496_;
			ValaDataType* _tmp1497_;
			ValaDataType* _tmp1498_;
			gboolean _tmp1499_;
			gboolean _tmp1500_;
			_tmp1495_ = vala_member_access_get_inner (self);
			_tmp1496_ = _tmp1495_;
			_tmp1497_ = vala_expression_get_value_type (_tmp1496_);
			_tmp1498_ = _tmp1497_;
			_tmp1499_ = vala_data_type_get_nullable (_tmp1498_);
			_tmp1500_ = _tmp1499_;
			_tmp1491_ = _tmp1500_;
		} else {
			_tmp1491_ = FALSE;
		}
		if (_tmp1491_) {
			ValaExpression* _tmp1501_;
			ValaExpression* _tmp1502_;
			ValaDataType* _tmp1503_;
			ValaDataType* _tmp1504_;
			_tmp1501_ = vala_member_access_get_inner (self);
			_tmp1502_ = _tmp1501_;
			_tmp1503_ = vala_expression_get_value_type (_tmp1502_);
			_tmp1504_ = _tmp1503_;
			_tmp1490_ = !VALA_IS_POINTER_TYPE (_tmp1504_);
		} else {
			_tmp1490_ = FALSE;
		}
		if (_tmp1490_) {
			ValaExpression* _tmp1505_;
			ValaExpression* _tmp1506_;
			ValaDataType* _tmp1507_;
			ValaDataType* _tmp1508_;
			_tmp1505_ = vala_member_access_get_inner (self);
			_tmp1506_ = _tmp1505_;
			_tmp1507_ = vala_expression_get_value_type (_tmp1506_);
			_tmp1508_ = _tmp1507_;
			_tmp1489_ = !VALA_IS_GENERIC_TYPE (_tmp1508_);
		} else {
			_tmp1489_ = FALSE;
		}
		if (_tmp1489_) {
			ValaExpression* _tmp1509_;
			ValaExpression* _tmp1510_;
			ValaDataType* _tmp1511_;
			ValaDataType* _tmp1512_;
			_tmp1509_ = vala_member_access_get_inner (self);
			_tmp1510_ = _tmp1509_;
			_tmp1511_ = vala_expression_get_value_type (_tmp1510_);
			_tmp1512_ = _tmp1511_;
			_tmp1488_ = !VALA_IS_ARRAY_TYPE (_tmp1512_);
		} else {
			_tmp1488_ = FALSE;
		}
		if (_tmp1488_) {
			ValaSourceReference* _tmp1513_;
			ValaSourceReference* _tmp1514_;
			ValaSymbol* _tmp1515_;
			ValaSymbol* _tmp1516_;
			gchar* _tmp1517_;
			gchar* _tmp1518_;
			_tmp1513_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1514_ = _tmp1513_;
			_tmp1515_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1516_ = _tmp1515_;
			_tmp1517_ = vala_symbol_get_full_name (_tmp1516_);
			_tmp1518_ = _tmp1517_;
			vala_report_error (_tmp1514_, "Access to instance member `%s' from nullable reference denied", _tmp1518_);
			_g_free0 (_tmp1518_);
		}
		_tmp1519_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1520_ = _tmp1519_;
		m = VALA_IS_METHOD (_tmp1520_) ? ((ValaMethod*) _tmp1520_) : NULL;
		_tmp1521_ = vala_member_access_get_inner (self);
		_tmp1522_ = _tmp1521_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1522_) ? ((ValaMemberAccess*) _tmp1522_) : NULL;
		_tmp1528_ = m;
		if (_tmp1528_ != NULL) {
			ValaMethod* _tmp1529_;
			ValaMemberBinding _tmp1530_;
			ValaMemberBinding _tmp1531_;
			_tmp1529_ = m;
			_tmp1530_ = vala_method_get_binding (_tmp1529_);
			_tmp1531_ = _tmp1530_;
			_tmp1527_ = _tmp1531_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1527_ = FALSE;
		}
		if (_tmp1527_) {
			ValaMethod* _tmp1532_;
			ValaSymbol* _tmp1533_;
			ValaSymbol* _tmp1534_;
			_tmp1532_ = m;
			_tmp1533_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1532_);
			_tmp1534_ = _tmp1533_;
			_tmp1526_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1534_);
		} else {
			_tmp1526_ = FALSE;
		}
		if (_tmp1526_) {
			ValaExpression* _tmp1535_;
			ValaExpression* _tmp1536_;
			_tmp1535_ = vala_member_access_get_inner (self);
			_tmp1536_ = _tmp1535_;
			_tmp1525_ = _tmp1536_ != NULL;
		} else {
			_tmp1525_ = FALSE;
		}
		if (_tmp1525_) {
			ValaExpression* _tmp1537_;
			ValaExpression* _tmp1538_;
			ValaDataType* _tmp1539_;
			ValaDataType* _tmp1540_;
			_tmp1537_ = vala_member_access_get_inner (self);
			_tmp1538_ = _tmp1537_;
			_tmp1539_ = vala_expression_get_value_type (_tmp1538_);
			_tmp1540_ = _tmp1539_;
			_tmp1524_ = _tmp1540_ == NULL;
		} else {
			_tmp1524_ = FALSE;
		}
		if (_tmp1524_) {
			ValaMemberAccess* _tmp1541_;
			ValaList* _tmp1542_;
			gint _tmp1543_;
			gint _tmp1544_;
			_tmp1541_ = inner_ma;
			_tmp1542_ = _tmp1541_->priv->type_argument_list;
			_tmp1543_ = vala_collection_get_size ((ValaCollection*) _tmp1542_);
			_tmp1544_ = _tmp1543_;
			_tmp1523_ = _tmp1544_ > 0;
		} else {
			_tmp1523_ = FALSE;
		}
		if (_tmp1523_) {
			ValaExpression* _tmp1545_;
			ValaExpression* _tmp1546_;
			ValaMethod* _tmp1547_;
			ValaSymbol* _tmp1548_;
			ValaSymbol* _tmp1549_;
			ValaObjectType* _tmp1550_;
			ValaObjectType* _tmp1551_;
			ValaExpression* _tmp1552_;
			ValaExpression* _tmp1553_;
			ValaDataType* _tmp1554_;
			ValaDataType* _tmp1555_;
			ValaSourceReference* _tmp1556_;
			ValaSourceReference* _tmp1557_;
			_tmp1545_ = vala_member_access_get_inner (self);
			_tmp1546_ = _tmp1545_;
			_tmp1547_ = m;
			_tmp1548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1547_);
			_tmp1549_ = _tmp1548_;
			_tmp1550_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1549_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1551_ = _tmp1550_;
			vala_expression_set_value_type (_tmp1546_, (ValaDataType*) _tmp1551_);
			_vala_code_node_unref0 (_tmp1551_);
			_tmp1552_ = vala_member_access_get_inner (self);
			_tmp1553_ = _tmp1552_;
			_tmp1554_ = vala_expression_get_value_type (_tmp1553_);
			_tmp1555_ = _tmp1554_;
			_tmp1556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1557_ = _tmp1556_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1555_, _tmp1557_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1558_;
				ValaList* _tmp1559_;
				gint _type_argument_size = 0;
				ValaList* _tmp1560_;
				gint _tmp1561_;
				gint _tmp1562_;
				gint _type_argument_index = 0;
				_tmp1558_ = inner_ma;
				_tmp1559_ = _tmp1558_->priv->type_argument_list;
				_type_argument_list = _tmp1559_;
				_tmp1560_ = _type_argument_list;
				_tmp1561_ = vala_collection_get_size ((ValaCollection*) _tmp1560_);
				_tmp1562_ = _tmp1561_;
				_type_argument_size = _tmp1562_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1563_;
					gint _tmp1564_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1565_;
					gpointer _tmp1566_;
					ValaExpression* _tmp1567_;
					ValaExpression* _tmp1568_;
					ValaDataType* _tmp1569_;
					ValaDataType* _tmp1570_;
					ValaDataType* _tmp1571_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1563_ = _type_argument_index;
					_tmp1564_ = _type_argument_size;
					if (!(_tmp1563_ < _tmp1564_)) {
						break;
					}
					_tmp1565_ = _type_argument_list;
					_tmp1566_ = vala_list_get (_tmp1565_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1566_;
					_tmp1567_ = vala_member_access_get_inner (self);
					_tmp1568_ = _tmp1567_;
					_tmp1569_ = vala_expression_get_value_type (_tmp1568_);
					_tmp1570_ = _tmp1569_;
					_tmp1571_ = type_argument;
					vala_data_type_add_type_argument (_tmp1570_, _tmp1571_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1572_ = vala_code_context_get_analyzer (context);
		_tmp1573_ = _tmp1572_;
		_tmp1574_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1575_ = _tmp1574_;
		_tmp1576_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1577_ = _tmp1576_;
		_tmp1578_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1573_, _tmp1575_, _tmp1577_);
		_tmp1579_ = _tmp1578_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1579_);
		_vala_code_node_unref0 (_tmp1579_);
		_tmp1581_ = vala_member_access_get_inner (self);
		_tmp1582_ = _tmp1581_;
		if (_tmp1582_ != NULL) {
			ValaDataType* _tmp1583_;
			ValaDataType* _tmp1584_;
			_tmp1583_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1584_ = _tmp1583_;
			_tmp1580_ = _tmp1584_ != NULL;
		} else {
			_tmp1580_ = FALSE;
		}
		if (_tmp1580_) {
			ValaDataType* _tmp1585_;
			ValaDataType* _tmp1586_;
			ValaExpression* _tmp1587_;
			ValaExpression* _tmp1588_;
			ValaDataType* _tmp1589_;
			ValaDataType* _tmp1590_;
			ValaDataType* _tmp1591_;
			ValaDataType* _tmp1592_;
			_tmp1585_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1586_ = _tmp1585_;
			_tmp1587_ = vala_member_access_get_inner (self);
			_tmp1588_ = _tmp1587_;
			_tmp1589_ = vala_expression_get_value_type (_tmp1588_);
			_tmp1590_ = _tmp1589_;
			_tmp1591_ = vala_data_type_get_actual_type (_tmp1586_, _tmp1590_, NULL, (ValaCodeNode*) self);
			_tmp1592_ = _tmp1591_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1592_);
			_vala_code_node_unref0 (_tmp1592_);
		} else {
			ValaDataType* _tmp1593_;
			ValaDataType* _tmp1594_;
			_tmp1593_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1594_ = _tmp1593_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1594_);
		}
		_tmp1595_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1596_ = _tmp1595_;
		if (VALA_IS_METHOD (_tmp1596_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1597_;
			ValaSymbol* _tmp1598_;
			ValaDataType* _tmp1599_;
			ValaDataType* _tmp1600_;
			gboolean _tmp1607_ = FALSE;
			_tmp1597_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1598_ = _tmp1597_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1598_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1599_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1600_ = _tmp1599_;
			if (_tmp1600_ != NULL) {
				ValaDataType* _tmp1601_;
				ValaDataType* _tmp1602_;
				ValaDataType* _tmp1603_;
				ValaDataType* _tmp1604_;
				gboolean _tmp1605_;
				gboolean _tmp1606_;
				_tmp1601_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1602_ = _tmp1601_;
				_tmp1603_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1604_ = _tmp1603_;
				_tmp1605_ = vala_data_type_get_value_owned (_tmp1604_);
				_tmp1606_ = _tmp1605_;
				vala_data_type_set_value_owned (_tmp1602_, _tmp1606_);
			}
			if (instance) {
				ValaMethod* _tmp1608_;
				ValaSymbol* _tmp1609_;
				ValaSymbol* _tmp1610_;
				_tmp1608_ = method;
				_tmp1609_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1608_);
				_tmp1610_ = _tmp1609_;
				_tmp1607_ = VALA_IS_TYPESYMBOL (_tmp1610_);
			} else {
				_tmp1607_ = FALSE;
			}
			if (_tmp1607_) {
				ValaExpression* _tmp1611_;
				ValaExpression* _tmp1612_;
				ValaMethod* _tmp1613_;
				ValaSymbol* _tmp1614_;
				ValaSymbol* _tmp1615_;
				ValaDataType* _tmp1616_;
				ValaDataType* _tmp1617_;
				ValaExpression* _tmp1618_;
				ValaExpression* _tmp1619_;
				ValaDataType* _tmp1620_;
				ValaDataType* _tmp1621_;
				ValaMethod* _tmp1622_;
				ValaParameter* _tmp1623_;
				ValaParameter* _tmp1624_;
				ValaDataType* _tmp1625_;
				ValaDataType* _tmp1626_;
				gboolean _tmp1627_;
				gboolean _tmp1628_;
				_tmp1611_ = vala_member_access_get_inner (self);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = method;
				_tmp1614_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1613_);
				_tmp1615_ = _tmp1614_;
				_tmp1616_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1615_);
				_tmp1617_ = _tmp1616_;
				vala_expression_set_target_type (_tmp1612_, _tmp1617_);
				_vala_code_node_unref0 (_tmp1617_);
				_tmp1618_ = vala_member_access_get_inner (self);
				_tmp1619_ = _tmp1618_;
				_tmp1620_ = vala_expression_get_target_type (_tmp1619_);
				_tmp1621_ = _tmp1620_;
				_tmp1622_ = method;
				_tmp1623_ = vala_method_get_this_parameter (_tmp1622_);
				_tmp1624_ = _tmp1623_;
				_tmp1625_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1624_);
				_tmp1626_ = _tmp1625_;
				_tmp1627_ = vala_data_type_get_value_owned (_tmp1626_);
				_tmp1628_ = _tmp1627_;
				vala_data_type_set_value_owned (_tmp1621_, _tmp1628_);
			}
		} else {
			gboolean _tmp1629_ = FALSE;
			gboolean _tmp1630_ = FALSE;
			ValaSymbol* _tmp1631_;
			ValaSymbol* _tmp1632_;
			_tmp1631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1632_ = _tmp1631_;
			if (VALA_IS_PROPERTY (_tmp1632_)) {
				_tmp1630_ = instance;
			} else {
				_tmp1630_ = FALSE;
			}
			if (_tmp1630_) {
				ValaSymbol* _tmp1633_;
				ValaSymbol* _tmp1634_;
				ValaSymbol* _tmp1635_;
				ValaSymbol* _tmp1636_;
				_tmp1633_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1634_ = _tmp1633_;
				_tmp1635_ = vala_symbol_get_parent_symbol (_tmp1634_);
				_tmp1636_ = _tmp1635_;
				_tmp1629_ = _tmp1636_ != NULL;
			} else {
				_tmp1629_ = FALSE;
			}
			if (_tmp1629_) {
				ValaExpression* _tmp1637_;
				ValaExpression* _tmp1638_;
				ValaSymbol* _tmp1639_;
				ValaSymbol* _tmp1640_;
				ValaSymbol* _tmp1641_;
				ValaSymbol* _tmp1642_;
				ValaDataType* _tmp1643_;
				ValaDataType* _tmp1644_;
				_tmp1637_ = vala_member_access_get_inner (self);
				_tmp1638_ = _tmp1637_;
				_tmp1639_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1640_ = _tmp1639_;
				_tmp1641_ = vala_symbol_get_parent_symbol (_tmp1640_);
				_tmp1642_ = _tmp1641_;
				_tmp1643_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1642_);
				_tmp1644_ = _tmp1643_;
				vala_expression_set_target_type (_tmp1638_, _tmp1644_);
				_vala_code_node_unref0 (_tmp1644_);
			} else {
				gboolean _tmp1645_ = FALSE;
				gboolean _tmp1646_ = FALSE;
				gboolean _tmp1647_ = FALSE;
				ValaSymbol* _tmp1648_;
				ValaSymbol* _tmp1649_;
				_tmp1648_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1649_ = _tmp1648_;
				if (VALA_IS_FIELD (_tmp1649_)) {
					_tmp1647_ = TRUE;
				} else {
					ValaSymbol* _tmp1650_;
					ValaSymbol* _tmp1651_;
					_tmp1650_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1651_ = _tmp1650_;
					_tmp1647_ = VALA_IS_SIGNAL (_tmp1651_);
				}
				if (_tmp1647_) {
					_tmp1646_ = instance;
				} else {
					_tmp1646_ = FALSE;
				}
				if (_tmp1646_) {
					ValaSymbol* _tmp1652_;
					ValaSymbol* _tmp1653_;
					ValaSymbol* _tmp1654_;
					ValaSymbol* _tmp1655_;
					_tmp1652_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1653_ = _tmp1652_;
					_tmp1654_ = vala_symbol_get_parent_symbol (_tmp1653_);
					_tmp1655_ = _tmp1654_;
					_tmp1645_ = _tmp1655_ != NULL;
				} else {
					_tmp1645_ = FALSE;
				}
				if (_tmp1645_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1656_;
					ValaSymbol* _tmp1657_;
					ValaSymbol* _tmp1658_;
					ValaSymbol* _tmp1659_;
					ValaDataType* _tmp1660_;
					ValaExpression* _tmp1661_;
					ValaExpression* _tmp1662_;
					ValaDataType* _tmp1663_;
					ValaExpression* _tmp1664_;
					ValaExpression* _tmp1665_;
					ValaDataType* _tmp1666_;
					ValaDataType* _tmp1667_;
					ValaDataType* _tmp1668_;
					ValaDataType* _tmp1669_;
					_tmp1656_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1657_ = _tmp1656_;
					_tmp1658_ = vala_symbol_get_parent_symbol (_tmp1657_);
					_tmp1659_ = _tmp1658_;
					_tmp1660_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1659_);
					parent_type = _tmp1660_;
					_tmp1661_ = vala_member_access_get_inner (self);
					_tmp1662_ = _tmp1661_;
					_tmp1663_ = parent_type;
					_tmp1664_ = vala_member_access_get_inner (self);
					_tmp1665_ = _tmp1664_;
					_tmp1666_ = vala_expression_get_value_type (_tmp1665_);
					_tmp1667_ = _tmp1666_;
					_tmp1668_ = vala_data_type_get_actual_type (_tmp1663_, _tmp1667_, NULL, (ValaCodeNode*) self);
					_tmp1669_ = _tmp1668_;
					vala_expression_set_target_type (_tmp1662_, _tmp1669_);
					_vala_code_node_unref0 (_tmp1669_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1672_ = vala_member_access_get_inner (self);
		_tmp1673_ = _tmp1672_;
		if (_tmp1673_ == NULL) {
			ValaDataType* _tmp1674_;
			ValaDataType* _tmp1675_;
			_tmp1674_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1675_ = _tmp1674_;
			_tmp1671_ = _tmp1675_ != NULL;
		} else {
			_tmp1671_ = FALSE;
		}
		if (_tmp1671_) {
			ValaProfile _tmp1676_;
			ValaProfile _tmp1677_;
			_tmp1676_ = vala_code_context_get_profile (context);
			_tmp1677_ = _tmp1676_;
			_tmp1670_ = _tmp1677_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1670_ = FALSE;
		}
		if (_tmp1670_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1678_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1679_ = _tmp1678_;
	if (_tmp1679_ != NULL) {
		ValaDataType* _tmp1680_;
		ValaDataType* _tmp1681_;
		_tmp1680_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1681_ = _tmp1680_;
		vala_code_node_check ((ValaCodeNode*) _tmp1681_, context);
	}
	_tmp1682_ = self->priv->_tainted_access;
	if (!_tmp1682_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1683_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1684_ = _tmp1683_;
	result = !_tmp1684_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	gboolean _tmp93_ = FALSE;
	ValaSymbol* _tmp94_;
	ValaSymbol* _tmp95_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_DELEGATE_TARGET_FIELD (_tmp85_)) {
		_tmp83_ = TRUE;
	} else {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp83_ = VALA_IS_DELEGATE_DESTROY_FIELD (_tmp87_);
	}
	if (_tmp83_) {
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaMemberAccess* _tmp90_;
		_tmp88_ = vala_member_access_get_inner (self);
		_tmp89_ = _tmp88_;
		vala_expression_set_lvalue (_tmp89_, TRUE);
		_tmp90_ = ma;
		if (_tmp90_ != NULL) {
			ValaMemberAccess* _tmp91_;
			ValaMemberAccess* _tmp92_;
			_tmp91_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp91_, TRUE);
			_tmp92_ = ma;
			vala_member_access_check_lvalue_access (_tmp92_);
		}
	}
	_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp95_ = _tmp94_;
	if (VALA_IS_METHOD (_tmp95_)) {
		ValaSymbol* _tmp96_;
		ValaSymbol* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp93_ = _tmp98_ != NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		ValaSymbol* _tmp102_;
		gboolean _tmp103_ = FALSE;
		gboolean _tmp104_ = FALSE;
		ValaClass* _tmp105_;
		_tmp99_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_METHOD, ValaMethod));
		_tmp102_ = _tmp101_;
		cl = VALA_IS_CLASS (_tmp102_) ? ((ValaClass*) _tmp102_) : NULL;
		_tmp105_ = cl;
		if (_tmp105_ != NULL) {
			ValaClass* _tmp106_;
			gboolean _tmp107_;
			gboolean _tmp108_;
			_tmp106_ = cl;
			_tmp107_ = vala_class_get_is_compact (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp104_ = _tmp108_;
		} else {
			_tmp104_ = FALSE;
		}
		if (_tmp104_) {
			ValaMemberAccess* _tmp109_;
			_tmp109_ = ma;
			_tmp103_ = _tmp109_ != NULL;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp110_;
			ValaMemberAccess* _tmp111_;
			_tmp110_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp110_, TRUE);
			_tmp111_ = ma;
			vala_member_access_check_lvalue_access (_tmp111_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

