/* valaforeachstatement.c generated by valac, the Vala compiler
 * generated from valaforeachstatement.vala, do not modify */

/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForeachStatementPrivate {
	gchar* _variable_name;
	gboolean _use_iterator;
	ValaLocalVariable* _element_variable;
	ValaLocalVariable* _collection_variable;
	ValaLocalVariable* _iterator_variable;
	ValaExpression* _collection;
	ValaBlock* _body;
	ValaDataType* _data_type;
};

static gint ValaForeachStatement_private_offset;
static gpointer vala_foreach_statement_parent_class = NULL;

static void vala_foreach_statement_set_type_reference (ValaForeachStatement* self,
                                                ValaDataType* value);
static void vala_foreach_statement_set_variable_name (ValaForeachStatement* self,
                                               const gchar* value);
static void vala_foreach_statement_set_collection (ValaForeachStatement* self,
                                            ValaExpression* value);
static void vala_foreach_statement_set_body (ValaForeachStatement* self,
                                      ValaBlock* value);
static void vala_foreach_statement_set_use_iterator (ValaForeachStatement* self,
                                              gboolean value);
static void vala_foreach_statement_set_element_variable (ValaForeachStatement* self,
                                                  ValaLocalVariable* value);
static void vala_foreach_statement_set_collection_variable (ValaForeachStatement* self,
                                                     ValaLocalVariable* value);
static void vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self,
                                                   ValaLocalVariable* value);
static void vala_foreach_statement_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static void vala_foreach_statement_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static gboolean vala_foreach_statement_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static gboolean vala_foreach_statement_check_without_iterator (ValaForeachStatement* self,
                                                        ValaCodeContext* context,
                                                        ValaDataType* collection_type,
                                                        ValaDataType* element_type);
static gboolean vala_foreach_statement_check_with_iterator (ValaForeachStatement* self,
                                                     ValaCodeContext* context,
                                                     ValaDataType* collection_type);
static gboolean vala_foreach_statement_check_with_index (ValaForeachStatement* self,
                                                  ValaCodeContext* context,
                                                  ValaDataType* collection_type);
static gboolean vala_foreach_statement_analyze_element_type (ValaForeachStatement* self,
                                                      ValaDataType* element_type);
static void vala_foreach_statement_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static void vala_foreach_statement_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_foreach_statement_finalize (ValaCodeNode * obj);
static GType vala_foreach_statement_get_type_once (void);

static inline gpointer
vala_foreach_statement_get_instance_private (ValaForeachStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForeachStatement_private_offset);
}

ValaDataType*
vala_foreach_statement_get_type_reference (ValaForeachStatement* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_foreach_statement_set_type_reference (ValaForeachStatement* self,
                                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_foreach_statement_get_variable_name (ValaForeachStatement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variable_name;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_variable_name (ValaForeachStatement* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_variable_name);
	self->priv->_variable_name = _tmp0_;
}

ValaExpression*
vala_foreach_statement_get_collection (ValaForeachStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_collection (ValaForeachStatement* self,
                                       ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_collection);
	self->priv->_collection = _tmp0_;
	_tmp1_ = self->priv->_collection;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_foreach_statement_get_body (ValaForeachStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_body (ValaForeachStatement* self,
                                 ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_foreach_statement_get_use_iterator (ValaForeachStatement* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_iterator;
	return result;
}

static void
vala_foreach_statement_set_use_iterator (ValaForeachStatement* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_use_iterator = value;
}

ValaLocalVariable*
vala_foreach_statement_get_element_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_element_variable (ValaForeachStatement* self,
                                             ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_variable);
	self->priv->_element_variable = _tmp0_;
}

ValaLocalVariable*
vala_foreach_statement_get_collection_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_collection_variable (ValaForeachStatement* self,
                                                ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	self->priv->_collection_variable = _tmp0_;
}

ValaLocalVariable*
vala_foreach_statement_get_iterator_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iterator_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self,
                                              ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	self->priv->_iterator_variable = _tmp0_;
}

/**
 * Creates a new foreach statement.
 *
 * @param type_reference    element type
 * @param variable_name     element variable name
 * @param collection        container
 * @param body              loop body
 * @param source_reference  reference to source code
 * @return                  newly created foreach statement
 */
ValaForeachStatement*
vala_foreach_statement_construct (GType object_type,
                                  ValaDataType* type_reference,
                                  const gchar* variable_name,
                                  ValaExpression* collection,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference)
{
	ValaForeachStatement* self = NULL;
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForeachStatement*) vala_block_construct (object_type, source_reference);
	vala_foreach_statement_set_variable_name (self, variable_name);
	vala_foreach_statement_set_collection (self, collection);
	vala_foreach_statement_set_body (self, body);
	vala_foreach_statement_set_type_reference (self, type_reference);
	return self;
}

ValaForeachStatement*
vala_foreach_statement_new (ValaDataType* type_reference,
                            const gchar* variable_name,
                            ValaExpression* collection,
                            ValaBlock* body,
                            ValaSourceReference* source_reference)
{
	return vala_foreach_statement_construct (VALA_TYPE_FOREACH_STATEMENT, type_reference, variable_name, collection, body, source_reference);
}

static void
vala_foreach_statement_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
		return;
	}
	vala_code_visitor_visit_foreach_statement (visitor, self);
}

static void
vala_foreach_statement_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
		return;
	}
	_tmp1_ = vala_foreach_statement_get_collection (self);
	_tmp2_ = _tmp1_;
	vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
	_tmp3_ = vala_foreach_statement_get_collection (self);
	_tmp4_ = _tmp3_;
	vala_code_visitor_visit_end_full_expression (visitor, _tmp4_);
	_tmp5_ = vala_foreach_statement_get_type_reference (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp7_ = vala_foreach_statement_get_type_reference (self);
		_tmp8_ = _tmp7_;
		vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
	}
	_tmp9_ = vala_foreach_statement_get_body (self);
	_tmp10_ = _tmp9_;
	vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
}

static void
vala_foreach_statement_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaForeachStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_foreach_statement_get_collection (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_foreach_statement_set_collection (self, new_node);
	}
}

static void
vala_foreach_statement_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaForeachStatement * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_foreach_statement_set_type_reference (self, new_type);
	}
}

static gboolean
vala_foreach_statement_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaDataType* collection_type = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaExpression* _tmp23_;
	ValaExpression* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gboolean result = FALSE;
	self = (ValaForeachStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_foreach_statement_get_type_reference (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaVarType* _tmp6_;
		ValaVarType* _tmp7_;
		_tmp6_ = vala_var_type_new (TRUE);
		_tmp7_ = _tmp6_;
		vala_foreach_statement_set_type_reference (self, (ValaDataType*) _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	_tmp8_ = vala_foreach_statement_get_collection (self);
	_tmp9_ = _tmp8_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp9_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	} else {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp10_ = vala_foreach_statement_get_collection (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			ValaExpression* _tmp14_;
			ValaExpression* _tmp15_;
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp14_ = vala_foreach_statement_get_collection (self);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp15_);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "invalid collection expression");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp18_ = vala_foreach_statement_get_collection (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_expression_get_value_type (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_data_type_copy (_tmp21_);
	collection_type = _tmp22_;
	_tmp23_ = vala_foreach_statement_get_collection (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = collection_type;
	_tmp26_ = vala_data_type_copy (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_expression_set_target_type (_tmp24_, _tmp27_);
	_vala_code_node_unref0 (_tmp27_);
	_tmp28_ = collection_type;
	if (VALA_IS_ARRAY_TYPE (_tmp28_)) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp29_;
		ValaArrayType* _tmp30_;
		ValaArrayType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaArrayType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp29_ = collection_type;
		_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp30_;
		_tmp31_ = array_type;
		vala_array_type_set_inline_allocated (_tmp31_, FALSE);
		_tmp32_ = collection_type;
		_tmp33_ = array_type;
		_tmp34_ = vala_array_type_get_element_type (_tmp33_);
		_tmp35_ = _tmp34_;
		result = vala_foreach_statement_check_without_iterator (self, context, _tmp32_, _tmp35_);
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (collection_type);
		return result;
	} else {
		gboolean _tmp36_ = FALSE;
		ValaProfile _tmp37_;
		ValaProfile _tmp38_;
		_tmp37_ = vala_code_context_get_profile (context);
		_tmp38_ = _tmp37_;
		if (_tmp38_ == VALA_PROFILE_GOBJECT) {
			gboolean _tmp39_ = FALSE;
			ValaDataType* _tmp40_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaDataType* _tmp43_;
			_tmp40_ = collection_type;
			_tmp41_ = vala_code_context_get_analyzer (context);
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_->glist_type;
			if (vala_data_type_compatible (_tmp40_, _tmp43_)) {
				_tmp39_ = TRUE;
			} else {
				ValaDataType* _tmp44_;
				ValaSemanticAnalyzer* _tmp45_;
				ValaSemanticAnalyzer* _tmp46_;
				ValaDataType* _tmp47_;
				_tmp44_ = collection_type;
				_tmp45_ = vala_code_context_get_analyzer (context);
				_tmp46_ = _tmp45_;
				_tmp47_ = _tmp46_->gslist_type;
				_tmp39_ = vala_data_type_compatible (_tmp44_, _tmp47_);
			}
			_tmp36_ = _tmp39_;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			ValaDataType* _tmp48_;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			ValaList* _tmp58_;
			gpointer _tmp59_;
			ValaDataType* _tmp60_;
			gboolean _tmp61_;
			_tmp48_ = collection_type;
			_tmp49_ = vala_data_type_get_type_arguments (_tmp48_);
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_ != 1) {
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp52_ = vala_foreach_statement_get_collection (self);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "missing type argument for collection");
				result = FALSE;
				_vala_code_node_unref0 (collection_type);
				return result;
			}
			_tmp56_ = collection_type;
			_tmp57_ = collection_type;
			_tmp58_ = vala_data_type_get_type_arguments (_tmp57_);
			_tmp59_ = vala_list_get (_tmp58_, 0);
			_tmp60_ = (ValaDataType*) _tmp59_;
			_tmp61_ = vala_foreach_statement_check_without_iterator (self, context, _tmp56_, _tmp60_);
			_vala_code_node_unref0 (_tmp60_);
			result = _tmp61_;
			_vala_code_node_unref0 (collection_type);
			return result;
		} else {
			gboolean _tmp62_ = FALSE;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp63_ = vala_code_context_get_profile (context);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_GOBJECT) {
				ValaDataType* _tmp65_;
				ValaSemanticAnalyzer* _tmp66_;
				ValaSemanticAnalyzer* _tmp67_;
				ValaDataType* _tmp68_;
				_tmp65_ = collection_type;
				_tmp66_ = vala_code_context_get_analyzer (context);
				_tmp67_ = _tmp66_;
				_tmp68_ = _tmp67_->gvaluearray_type;
				_tmp62_ = vala_data_type_compatible (_tmp65_, _tmp68_);
			} else {
				_tmp62_ = FALSE;
			}
			if (_tmp62_) {
				ValaDataType* _tmp69_;
				ValaSemanticAnalyzer* _tmp70_;
				ValaSemanticAnalyzer* _tmp71_;
				ValaStructValueType* _tmp72_;
				_tmp69_ = collection_type;
				_tmp70_ = vala_code_context_get_analyzer (context);
				_tmp71_ = _tmp70_;
				_tmp72_ = _tmp71_->gvalue_type;
				result = vala_foreach_statement_check_without_iterator (self, context, _tmp69_, (ValaDataType*) _tmp72_);
				_vala_code_node_unref0 (collection_type);
				return result;
			} else {
				ValaDataType* _tmp73_;
				_tmp73_ = collection_type;
				result = vala_foreach_statement_check_with_iterator (self, context, _tmp73_);
				_vala_code_node_unref0 (collection_type);
				return result;
			}
		}
	}
}

static gboolean
vala_foreach_statement_check_with_index (ValaForeachStatement* self,
                                         ValaCodeContext* context,
                                         ValaDataType* collection_type)
{
	ValaMethod* get_method = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaList* parameters = NULL;
	ValaMethod* _tmp3_;
	ValaList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValaProperty* size_property = NULL;
	ValaSymbol* _tmp14_;
	ValaProperty* _tmp15_;
	ValaProperty* _tmp16_;
	ValaDataType* list_type = NULL;
	ValaDataType* _tmp17_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaSymbol* _tmp21_;
	ValaDataType* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	ValaExpression* _tmp27_;
	ValaExpression* _tmp28_;
	ValaSourceReference* _tmp29_;
	ValaSourceReference* _tmp30_;
	ValaLocalVariable* _tmp31_;
	ValaLocalVariable* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaDeclarationStatement* _tmp35_;
	ValaDeclarationStatement* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaMemberAccess* _tmp45_;
	ValaMemberAccess* _tmp46_;
	ValaSourceReference* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaMemberAccess* _tmp49_;
	ValaMemberAccess* _tmp50_;
	ValaSourceReference* _tmp51_;
	ValaSourceReference* _tmp52_;
	ValaLocalVariable* _tmp53_;
	ValaLocalVariable* _tmp54_;
	ValaSourceReference* _tmp55_;
	ValaSourceReference* _tmp56_;
	ValaDeclarationStatement* _tmp57_;
	ValaDeclarationStatement* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	ValaSourceReference* _tmp62_;
	ValaSourceReference* _tmp63_;
	ValaIntegerLiteral* _tmp64_;
	ValaIntegerLiteral* _tmp65_;
	ValaSourceReference* _tmp66_;
	ValaSourceReference* _tmp67_;
	ValaUnaryExpression* _tmp68_;
	ValaUnaryExpression* _tmp69_;
	ValaSourceReference* _tmp70_;
	ValaSourceReference* _tmp71_;
	ValaLocalVariable* _tmp72_;
	ValaLocalVariable* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaDeclarationStatement* _tmp76_;
	ValaDeclarationStatement* _tmp77_;
	ValaUnaryExpression* next = NULL;
	const gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	ValaSourceReference* _tmp81_;
	ValaSourceReference* _tmp82_;
	ValaMemberAccess* _tmp83_;
	ValaMemberAccess* _tmp84_;
	ValaSourceReference* _tmp85_;
	ValaSourceReference* _tmp86_;
	ValaUnaryExpression* _tmp87_;
	ValaUnaryExpression* _tmp88_;
	ValaBinaryExpression* conditional = NULL;
	ValaUnaryExpression* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	ValaSourceReference* _tmp93_;
	ValaSourceReference* _tmp94_;
	ValaMemberAccess* _tmp95_;
	ValaMemberAccess* _tmp96_;
	ValaSourceReference* _tmp97_;
	ValaSourceReference* _tmp98_;
	ValaBinaryExpression* _tmp99_;
	ValaBinaryExpression* _tmp100_;
	ValaWhileStatement* loop = NULL;
	ValaBinaryExpression* _tmp101_;
	ValaBlock* _tmp102_;
	ValaBlock* _tmp103_;
	ValaSourceReference* _tmp104_;
	ValaSourceReference* _tmp105_;
	ValaWhileStatement* _tmp106_;
	ValaWhileStatement* _tmp107_;
	ValaMethodCall* get_call = NULL;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	ValaSourceReference* _tmp111_;
	ValaSourceReference* _tmp112_;
	ValaMemberAccess* _tmp113_;
	ValaMemberAccess* _tmp114_;
	ValaSourceReference* _tmp115_;
	ValaSourceReference* _tmp116_;
	ValaMemberAccess* _tmp117_;
	ValaMemberAccess* _tmp118_;
	ValaSourceReference* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaMethodCall* _tmp121_;
	ValaMethodCall* _tmp122_;
	ValaMethodCall* _tmp123_;
	const gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	ValaSourceReference* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaMemberAccess* _tmp129_;
	ValaMemberAccess* _tmp130_;
	ValaBlock* _tmp131_;
	ValaBlock* _tmp132_;
	ValaDataType* _tmp133_;
	ValaDataType* _tmp134_;
	const gchar* _tmp135_;
	ValaMethodCall* _tmp136_;
	ValaSourceReference* _tmp137_;
	ValaSourceReference* _tmp138_;
	ValaLocalVariable* _tmp139_;
	ValaLocalVariable* _tmp140_;
	ValaSourceReference* _tmp141_;
	ValaSourceReference* _tmp142_;
	ValaDeclarationStatement* _tmp143_;
	ValaDeclarationStatement* _tmp144_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_member (collection_type, "get");
	_tmp1_ = VALA_IS_METHOD (_tmp0_) ? ((ValaMethod*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	get_method = _tmp1_;
	_tmp2_ = get_method;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp3_ = get_method;
	_tmp4_ = vala_callable_get_parameters ((ValaCallable*) _tmp3_);
	parameters = _tmp4_;
	_tmp6_ = parameters;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != 1) {
		_tmp5_ = TRUE;
	} else {
		ValaList* _tmp9_;
		gpointer _tmp10_;
		ValaParameter* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp9_ = parameters;
		_tmp10_ = vala_list_get (_tmp9_, 0);
		_tmp11_ = (ValaParameter*) _tmp10_;
		_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp5_ = !VALA_IS_INTEGER_TYPE (_tmp13_);
		_vala_code_node_unref0 (_tmp11_);
	}
	if (_tmp5_) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp14_ = vala_data_type_get_member (collection_type, "size");
	_tmp15_ = VALA_IS_PROPERTY (_tmp14_) ? ((ValaProperty*) _tmp14_) : NULL;
	if (_tmp15_ == NULL) {
		_vala_code_node_unref0 (_tmp14_);
	}
	size_property = _tmp15_;
	_tmp16_ = size_property;
	if (_tmp16_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (size_property);
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp17_ = vala_data_type_copy (collection_type);
	list_type = _tmp17_;
	_tmp18_ = vala_foreach_statement_get_collection (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
	_tmp21_ = _tmp20_;
	if (VALA_IS_VARIABLE (_tmp21_)) {
		ValaDataType* _tmp22_;
		_tmp22_ = list_type;
		vala_data_type_set_value_owned (_tmp22_, FALSE);
	}
	_tmp23_ = list_type;
	_tmp24_ = self->priv->_variable_name;
	_tmp25_ = g_strdup_printf ("_%s_list", _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_foreach_statement_get_collection (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_local_variable_new (_tmp23_, _tmp26_, _tmp28_, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_declaration_statement_new ((ValaSymbol*) _tmp32_, _tmp34_);
	_tmp36_ = _tmp35_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_vala_code_node_unref0 (_tmp32_);
	_g_free0 (_tmp26_);
	_tmp37_ = self->priv->_variable_name;
	_tmp38_ = g_strdup_printf ("_%s_size", _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->_variable_name;
	_tmp41_ = g_strdup_printf ("_%s_list", _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_member_access_new_simple (_tmp42_, _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_member_access_new ((ValaExpression*) _tmp46_, "size", _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_local_variable_new (NULL, _tmp39_, (ValaExpression*) _tmp50_, _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_declaration_statement_new ((ValaSymbol*) _tmp54_, _tmp56_);
	_tmp58_ = _tmp57_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp58_);
	_vala_code_node_unref0 (_tmp58_);
	_vala_code_node_unref0 (_tmp54_);
	_vala_code_node_unref0 (_tmp50_);
	_vala_code_node_unref0 (_tmp46_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp39_);
	_tmp59_ = self->priv->_variable_name;
	_tmp60_ = g_strdup_printf ("_%s_index", _tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_integer_literal_new ("1", _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, (ValaExpression*) _tmp65_, _tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_local_variable_new (NULL, _tmp61_, (ValaExpression*) _tmp69_, _tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_declaration_statement_new ((ValaSymbol*) _tmp73_, _tmp75_);
	_tmp77_ = _tmp76_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp77_);
	_vala_code_node_unref0 (_tmp77_);
	_vala_code_node_unref0 (_tmp73_);
	_vala_code_node_unref0 (_tmp69_);
	_vala_code_node_unref0 (_tmp65_);
	_g_free0 (_tmp61_);
	_tmp78_ = self->priv->_variable_name;
	_tmp79_ = g_strdup_printf ("_%s_index", _tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp82_ = _tmp81_;
	_tmp83_ = vala_member_access_new_simple (_tmp80_, _tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp86_ = _tmp85_;
	_tmp87_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_INCREMENT, (ValaExpression*) _tmp84_, _tmp86_);
	_tmp88_ = _tmp87_;
	_vala_code_node_unref0 (_tmp84_);
	_g_free0 (_tmp80_);
	next = _tmp88_;
	_tmp89_ = next;
	_tmp90_ = self->priv->_variable_name;
	_tmp91_ = g_strdup_printf ("_%s_size", _tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = vala_member_access_new_simple (_tmp92_, _tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN, (ValaExpression*) _tmp89_, (ValaExpression*) _tmp96_, _tmp98_);
	_tmp100_ = _tmp99_;
	_vala_code_node_unref0 (_tmp96_);
	_g_free0 (_tmp92_);
	conditional = _tmp100_;
	_tmp101_ = conditional;
	_tmp102_ = vala_foreach_statement_get_body (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_while_statement_new ((ValaExpression*) _tmp101_, _tmp103_, _tmp105_);
	loop = _tmp106_;
	_tmp107_ = loop;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp107_);
	_tmp108_ = self->priv->_variable_name;
	_tmp109_ = g_strdup_printf ("_%s_list", _tmp108_);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_member_access_new_simple (_tmp110_, _tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_member_access_new ((ValaExpression*) _tmp114_, "get", _tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_method_call_new ((ValaExpression*) _tmp118_, _tmp120_);
	_tmp122_ = _tmp121_;
	_vala_code_node_unref0 (_tmp118_);
	_vala_code_node_unref0 (_tmp114_);
	_g_free0 (_tmp110_);
	get_call = _tmp122_;
	_tmp123_ = get_call;
	_tmp124_ = self->priv->_variable_name;
	_tmp125_ = g_strdup_printf ("_%s_index", _tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_member_access_new_simple (_tmp126_, _tmp128_);
	_tmp130_ = _tmp129_;
	vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp123_, (ValaExpression*) _tmp130_);
	_vala_code_node_unref0 (_tmp130_);
	_g_free0 (_tmp126_);
	_tmp131_ = vala_foreach_statement_get_body (self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_foreach_statement_get_type_reference (self);
	_tmp134_ = _tmp133_;
	_tmp135_ = self->priv->_variable_name;
	_tmp136_ = get_call;
	_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_local_variable_new (_tmp134_, _tmp135_, (ValaExpression*) _tmp136_, _tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_declaration_statement_new ((ValaSymbol*) _tmp140_, _tmp142_);
	_tmp144_ = _tmp143_;
	vala_block_insert_statement (_tmp132_, 0, (ValaStatement*) _tmp144_);
	_vala_code_node_unref0 (_tmp144_);
	_vala_code_node_unref0 (_tmp140_);
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	result = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context);
	_vala_code_node_unref0 (get_call);
	_vala_code_node_unref0 (loop);
	_vala_code_node_unref0 (conditional);
	_vala_code_node_unref0 (next);
	_vala_code_node_unref0 (list_type);
	_vala_code_node_unref0 (size_property);
	_vala_code_node_unref0 (get_method);
	return result;
}

static gboolean
vala_foreach_statement_check_with_iterator (ValaForeachStatement* self,
                                            ValaCodeContext* context,
                                            ValaDataType* collection_type)
{
	ValaMethod* iterator_method = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaMethod* _tmp9_;
	ValaList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	ValaDataType* iterator_type = NULL;
	ValaMethod* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	ValaMethodCall* iterator_call = NULL;
	ValaExpression* _tmp32_;
	ValaExpression* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaSourceReference* _tmp35_;
	ValaMemberAccess* _tmp36_;
	ValaMemberAccess* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaSourceReference* _tmp39_;
	ValaMethodCall* _tmp40_;
	ValaMethodCall* _tmp41_;
	ValaDataType* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	ValaMethodCall* _tmp46_;
	ValaSourceReference* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaLocalVariable* _tmp49_;
	ValaLocalVariable* _tmp50_;
	ValaSourceReference* _tmp51_;
	ValaSourceReference* _tmp52_;
	ValaDeclarationStatement* _tmp53_;
	ValaDeclarationStatement* _tmp54_;
	ValaMethod* next_value_method = NULL;
	ValaDataType* _tmp55_;
	ValaSymbol* _tmp56_;
	ValaMethod* _tmp57_;
	ValaMethod* next_method = NULL;
	ValaDataType* _tmp58_;
	ValaSymbol* _tmp59_;
	ValaMethod* _tmp60_;
	ValaMethod* _tmp61_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	vala_foreach_statement_set_use_iterator (self, TRUE);
	if (vala_foreach_statement_check_with_index (self, context, collection_type)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_data_type_get_member (collection_type, "iterator");
	_tmp1_ = VALA_IS_METHOD (_tmp0_) ? ((ValaMethod*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	iterator_method = _tmp1_;
	_tmp2_ = iterator_method;
	if (_tmp2_ == NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = vala_foreach_statement_get_collection (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) collection_type);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, "`%s' does not have an `iterator' method", _tmp8_);
		_g_free0 (_tmp8_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp9_ = iterator_method;
	_tmp10_ = vala_callable_get_parameters ((ValaCallable*) _tmp9_);
	_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != 0) {
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaMethod* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = vala_foreach_statement_get_collection (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = iterator_method;
		_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		vala_report_error (_tmp16_, "`%s' must not have any parameters", _tmp19_);
		_g_free0 (_tmp19_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp20_ = iterator_method;
	_tmp21_ = vala_callable_get_return_type ((ValaCallable*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_data_type_get_actual_type (_tmp22_, collection_type, NULL, (ValaCodeNode*) self);
	iterator_type = _tmp23_;
	_tmp24_ = iterator_type;
	if (VALA_IS_VOID_TYPE (_tmp24_)) {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaMethod* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp25_ = vala_foreach_statement_get_collection (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = iterator_method;
		_tmp30_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp29_);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp28_, "`%s' must return an iterator", _tmp31_);
		_g_free0 (_tmp31_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_type);
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp32_ = vala_foreach_statement_get_collection (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_member_access_new (_tmp33_, "iterator", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_method_call_new ((ValaExpression*) _tmp37_, _tmp39_);
	_tmp41_ = _tmp40_;
	_vala_code_node_unref0 (_tmp37_);
	iterator_call = _tmp41_;
	_tmp42_ = iterator_type;
	_tmp43_ = self->priv->_variable_name;
	_tmp44_ = g_strdup_printf ("_%s_it", _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = iterator_call;
	_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_local_variable_new (_tmp42_, _tmp45_, (ValaExpression*) _tmp46_, _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_declaration_statement_new ((ValaSymbol*) _tmp50_, _tmp52_);
	_tmp54_ = _tmp53_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp54_);
	_vala_code_node_unref0 (_tmp54_);
	_vala_code_node_unref0 (_tmp50_);
	_g_free0 (_tmp45_);
	_tmp55_ = iterator_type;
	_tmp56_ = vala_data_type_get_member (_tmp55_, "next_value");
	_tmp57_ = VALA_IS_METHOD (_tmp56_) ? ((ValaMethod*) _tmp56_) : NULL;
	if (_tmp57_ == NULL) {
		_vala_code_node_unref0 (_tmp56_);
	}
	next_value_method = _tmp57_;
	_tmp58_ = iterator_type;
	_tmp59_ = vala_data_type_get_member (_tmp58_, "next");
	_tmp60_ = VALA_IS_METHOD (_tmp59_) ? ((ValaMethod*) _tmp59_) : NULL;
	if (_tmp60_ == NULL) {
		_vala_code_node_unref0 (_tmp59_);
	}
	next_method = _tmp60_;
	_tmp61_ = next_value_method;
	if (_tmp61_ != NULL) {
		ValaMethod* _tmp62_;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		ValaDataType* element_type = NULL;
		ValaMethod* _tmp73_;
		ValaDataType* _tmp74_;
		ValaDataType* _tmp75_;
		ValaDataType* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		gboolean _tmp79_;
		gboolean _tmp80_;
		ValaDataType* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		const gchar* _tmp91_;
		ValaSourceReference* _tmp92_;
		ValaSourceReference* _tmp93_;
		ValaLocalVariable* _tmp94_;
		ValaLocalVariable* _tmp95_;
		ValaSourceReference* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaDeclarationStatement* _tmp98_;
		ValaDeclarationStatement* _tmp99_;
		ValaMethodCall* next_value_call = NULL;
		const gchar* _tmp100_;
		gchar* _tmp101_;
		gchar* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaSourceReference* _tmp104_;
		ValaMemberAccess* _tmp105_;
		ValaMemberAccess* _tmp106_;
		ValaSourceReference* _tmp107_;
		ValaSourceReference* _tmp108_;
		ValaMemberAccess* _tmp109_;
		ValaMemberAccess* _tmp110_;
		ValaSourceReference* _tmp111_;
		ValaSourceReference* _tmp112_;
		ValaMethodCall* _tmp113_;
		ValaMethodCall* _tmp114_;
		ValaAssignment* assignment = NULL;
		const gchar* _tmp115_;
		ValaSourceReference* _tmp116_;
		ValaSourceReference* _tmp117_;
		ValaMemberAccess* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaMethodCall* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaAssignment* _tmp123_;
		ValaAssignment* _tmp124_;
		ValaBinaryExpression* conditional = NULL;
		ValaAssignment* _tmp125_;
		ValaSourceReference* _tmp126_;
		ValaSourceReference* _tmp127_;
		ValaNullLiteral* _tmp128_;
		ValaNullLiteral* _tmp129_;
		ValaSourceReference* _tmp130_;
		ValaSourceReference* _tmp131_;
		ValaBinaryExpression* _tmp132_;
		ValaBinaryExpression* _tmp133_;
		ValaWhileStatement* loop = NULL;
		ValaBinaryExpression* _tmp134_;
		ValaBlock* _tmp135_;
		ValaBlock* _tmp136_;
		ValaSourceReference* _tmp137_;
		ValaSourceReference* _tmp138_;
		ValaWhileStatement* _tmp139_;
		ValaWhileStatement* _tmp140_;
		_tmp62_ = next_value_method;
		_tmp63_ = vala_callable_get_parameters ((ValaCallable*) _tmp62_);
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_ != 0) {
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaSourceReference* _tmp68_;
			ValaSourceReference* _tmp69_;
			ValaMethod* _tmp70_;
			gchar* _tmp71_;
			gchar* _tmp72_;
			_tmp66_ = vala_foreach_statement_get_collection (self);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = next_value_method;
			_tmp71_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp70_);
			_tmp72_ = _tmp71_;
			vala_report_error (_tmp69_, "`%s' must not have any parameters", _tmp72_);
			_g_free0 (_tmp72_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp73_ = next_value_method;
		_tmp74_ = vala_callable_get_return_type ((ValaCallable*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = iterator_type;
		_tmp77_ = vala_data_type_get_actual_type (_tmp75_, _tmp76_, NULL, (ValaCodeNode*) self);
		element_type = _tmp77_;
		_tmp78_ = element_type;
		_tmp79_ = vala_data_type_get_nullable (_tmp78_);
		_tmp80_ = _tmp79_;
		if (!_tmp80_) {
			ValaExpression* _tmp81_;
			ValaExpression* _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			ValaMethod* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			_tmp81_ = vala_foreach_statement_get_collection (self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = next_value_method;
			_tmp86_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp85_);
			_tmp87_ = _tmp86_;
			vala_report_error (_tmp84_, "return type of `%s' must be nullable", _tmp87_);
			_g_free0 (_tmp87_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp88_ = element_type;
		if (!vala_foreach_statement_analyze_element_type (self, _tmp88_)) {
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp89_ = vala_foreach_statement_get_type_reference (self);
		_tmp90_ = _tmp89_;
		_tmp91_ = self->priv->_variable_name;
		_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp93_ = _tmp92_;
		_tmp94_ = vala_local_variable_new (_tmp90_, _tmp91_, NULL, _tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_declaration_statement_new ((ValaSymbol*) _tmp95_, _tmp97_);
		_tmp99_ = _tmp98_;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp99_);
		_vala_code_node_unref0 (_tmp99_);
		_vala_code_node_unref0 (_tmp95_);
		_tmp100_ = self->priv->_variable_name;
		_tmp101_ = g_strdup_printf ("_%s_it", _tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_member_access_new_simple (_tmp102_, _tmp104_);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_member_access_new ((ValaExpression*) _tmp106_, "next_value", _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_method_call_new ((ValaExpression*) _tmp110_, _tmp112_);
		_tmp114_ = _tmp113_;
		_vala_code_node_unref0 (_tmp110_);
		_vala_code_node_unref0 (_tmp106_);
		_g_free0 (_tmp102_);
		next_value_call = _tmp114_;
		_tmp115_ = self->priv->_variable_name;
		_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_member_access_new (NULL, _tmp115_, _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = next_value_call;
		_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_assignment_new ((ValaExpression*) _tmp119_, (ValaExpression*) _tmp120_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp122_);
		_tmp124_ = _tmp123_;
		_vala_code_node_unref0 (_tmp119_);
		assignment = _tmp124_;
		_tmp125_ = assignment;
		_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_null_literal_new (_tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_INEQUALITY, (ValaExpression*) _tmp125_, (ValaExpression*) _tmp129_, _tmp131_);
		_tmp133_ = _tmp132_;
		_vala_code_node_unref0 (_tmp129_);
		conditional = _tmp133_;
		_tmp134_ = conditional;
		_tmp135_ = vala_foreach_statement_get_body (self);
		_tmp136_ = _tmp135_;
		_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp138_ = _tmp137_;
		_tmp139_ = vala_while_statement_new ((ValaExpression*) _tmp134_, _tmp136_, _tmp138_);
		loop = _tmp139_;
		_tmp140_ = loop;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp140_);
		_vala_code_node_unref0 (loop);
		_vala_code_node_unref0 (conditional);
		_vala_code_node_unref0 (assignment);
		_vala_code_node_unref0 (next_value_call);
		_vala_code_node_unref0 (element_type);
	} else {
		ValaMethod* _tmp141_;
		_tmp141_ = next_method;
		if (_tmp141_ != NULL) {
			ValaMethod* _tmp142_;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			ValaMethod* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			ValaSemanticAnalyzer* _tmp156_;
			ValaSemanticAnalyzer* _tmp157_;
			ValaDataType* _tmp158_;
			ValaMethod* get_method = NULL;
			ValaDataType* _tmp166_;
			ValaSymbol* _tmp167_;
			ValaMethod* _tmp168_;
			ValaMethod* _tmp169_;
			ValaMethod* _tmp177_;
			ValaList* _tmp178_;
			gint _tmp179_;
			gint _tmp180_;
			ValaDataType* element_type = NULL;
			ValaMethod* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			ValaDataType* _tmp191_;
			ValaDataType* _tmp192_;
			ValaDataType* _tmp193_;
			ValaDataType* _tmp201_;
			ValaMethodCall* next_call = NULL;
			const gchar* _tmp202_;
			gchar* _tmp203_;
			gchar* _tmp204_;
			ValaSourceReference* _tmp205_;
			ValaSourceReference* _tmp206_;
			ValaMemberAccess* _tmp207_;
			ValaMemberAccess* _tmp208_;
			ValaSourceReference* _tmp209_;
			ValaSourceReference* _tmp210_;
			ValaMemberAccess* _tmp211_;
			ValaMemberAccess* _tmp212_;
			ValaSourceReference* _tmp213_;
			ValaSourceReference* _tmp214_;
			ValaMethodCall* _tmp215_;
			ValaMethodCall* _tmp216_;
			ValaWhileStatement* loop = NULL;
			ValaMethodCall* _tmp217_;
			ValaBlock* _tmp218_;
			ValaBlock* _tmp219_;
			ValaSourceReference* _tmp220_;
			ValaSourceReference* _tmp221_;
			ValaWhileStatement* _tmp222_;
			ValaWhileStatement* _tmp223_;
			ValaMethodCall* get_call = NULL;
			const gchar* _tmp224_;
			gchar* _tmp225_;
			gchar* _tmp226_;
			ValaSourceReference* _tmp227_;
			ValaSourceReference* _tmp228_;
			ValaMemberAccess* _tmp229_;
			ValaMemberAccess* _tmp230_;
			ValaSourceReference* _tmp231_;
			ValaSourceReference* _tmp232_;
			ValaMemberAccess* _tmp233_;
			ValaMemberAccess* _tmp234_;
			ValaSourceReference* _tmp235_;
			ValaSourceReference* _tmp236_;
			ValaMethodCall* _tmp237_;
			ValaMethodCall* _tmp238_;
			ValaBlock* _tmp239_;
			ValaBlock* _tmp240_;
			ValaDataType* _tmp241_;
			ValaDataType* _tmp242_;
			const gchar* _tmp243_;
			ValaMethodCall* _tmp244_;
			ValaSourceReference* _tmp245_;
			ValaSourceReference* _tmp246_;
			ValaLocalVariable* _tmp247_;
			ValaLocalVariable* _tmp248_;
			ValaSourceReference* _tmp249_;
			ValaSourceReference* _tmp250_;
			ValaDeclarationStatement* _tmp251_;
			ValaDeclarationStatement* _tmp252_;
			_tmp142_ = next_method;
			_tmp143_ = vala_callable_get_parameters ((ValaCallable*) _tmp142_);
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			if (_tmp145_ != 0) {
				ValaExpression* _tmp146_;
				ValaExpression* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaMethod* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				_tmp146_ = vala_foreach_statement_get_collection (self);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = next_method;
				_tmp151_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp150_);
				_tmp152_ = _tmp151_;
				vala_report_error (_tmp149_, "`%s' must not have any parameters", _tmp152_);
				_g_free0 (_tmp152_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp153_ = next_method;
			_tmp154_ = vala_callable_get_return_type ((ValaCallable*) _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_code_context_get_analyzer (context);
			_tmp157_ = _tmp156_;
			_tmp158_ = _tmp157_->bool_type;
			if (!vala_data_type_compatible (_tmp155_, _tmp158_)) {
				ValaExpression* _tmp159_;
				ValaExpression* _tmp160_;
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				ValaMethod* _tmp163_;
				gchar* _tmp164_;
				gchar* _tmp165_;
				_tmp159_ = vala_foreach_statement_get_collection (self);
				_tmp160_ = _tmp159_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = next_method;
				_tmp164_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp163_);
				_tmp165_ = _tmp164_;
				vala_report_error (_tmp162_, "`%s' must return a boolean value", _tmp165_);
				_g_free0 (_tmp165_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp166_ = iterator_type;
			_tmp167_ = vala_data_type_get_member (_tmp166_, "get");
			_tmp168_ = VALA_IS_METHOD (_tmp167_) ? ((ValaMethod*) _tmp167_) : NULL;
			if (_tmp168_ == NULL) {
				_vala_code_node_unref0 (_tmp167_);
			}
			get_method = _tmp168_;
			_tmp169_ = get_method;
			if (_tmp169_ == NULL) {
				ValaExpression* _tmp170_;
				ValaExpression* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaSourceReference* _tmp173_;
				ValaDataType* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				_tmp170_ = vala_foreach_statement_get_collection (self);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = iterator_type;
				_tmp175_ = vala_code_node_to_string ((ValaCodeNode*) _tmp174_);
				_tmp176_ = _tmp175_;
				vala_report_error (_tmp173_, "`%s' does not have a `get' method", _tmp176_);
				_g_free0 (_tmp176_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp177_ = get_method;
			_tmp178_ = vala_callable_get_parameters ((ValaCallable*) _tmp177_);
			_tmp179_ = vala_collection_get_size ((ValaCollection*) _tmp178_);
			_tmp180_ = _tmp179_;
			if (_tmp180_ != 0) {
				ValaExpression* _tmp181_;
				ValaExpression* _tmp182_;
				ValaSourceReference* _tmp183_;
				ValaSourceReference* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				_tmp181_ = vala_foreach_statement_get_collection (self);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = get_method;
				_tmp186_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp185_);
				_tmp187_ = _tmp186_;
				vala_report_error (_tmp184_, "`%s' must not have any parameters", _tmp187_);
				_g_free0 (_tmp187_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp188_ = get_method;
			_tmp189_ = vala_callable_get_return_type ((ValaCallable*) _tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = iterator_type;
			_tmp192_ = vala_data_type_get_actual_type (_tmp190_, _tmp191_, NULL, (ValaCodeNode*) self);
			element_type = _tmp192_;
			_tmp193_ = element_type;
			if (VALA_IS_VOID_TYPE (_tmp193_)) {
				ValaExpression* _tmp194_;
				ValaExpression* _tmp195_;
				ValaSourceReference* _tmp196_;
				ValaSourceReference* _tmp197_;
				ValaMethod* _tmp198_;
				gchar* _tmp199_;
				gchar* _tmp200_;
				_tmp194_ = vala_foreach_statement_get_collection (self);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = get_method;
				_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp198_);
				_tmp200_ = _tmp199_;
				vala_report_error (_tmp197_, "`%s' must return an element", _tmp200_);
				_g_free0 (_tmp200_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp201_ = element_type;
			if (!vala_foreach_statement_analyze_element_type (self, _tmp201_)) {
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp202_ = self->priv->_variable_name;
			_tmp203_ = g_strdup_printf ("_%s_it", _tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_member_access_new_simple (_tmp204_, _tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_member_access_new ((ValaExpression*) _tmp208_, "next", _tmp210_);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp214_ = _tmp213_;
			_tmp215_ = vala_method_call_new ((ValaExpression*) _tmp212_, _tmp214_);
			_tmp216_ = _tmp215_;
			_vala_code_node_unref0 (_tmp212_);
			_vala_code_node_unref0 (_tmp208_);
			_g_free0 (_tmp204_);
			next_call = _tmp216_;
			_tmp217_ = next_call;
			_tmp218_ = vala_foreach_statement_get_body (self);
			_tmp219_ = _tmp218_;
			_tmp220_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp221_ = _tmp220_;
			_tmp222_ = vala_while_statement_new ((ValaExpression*) _tmp217_, _tmp219_, _tmp221_);
			loop = _tmp222_;
			_tmp223_ = loop;
			vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp223_);
			_tmp224_ = self->priv->_variable_name;
			_tmp225_ = g_strdup_printf ("_%s_it", _tmp224_);
			_tmp226_ = _tmp225_;
			_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp228_ = _tmp227_;
			_tmp229_ = vala_member_access_new_simple (_tmp226_, _tmp228_);
			_tmp230_ = _tmp229_;
			_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_member_access_new ((ValaExpression*) _tmp230_, "get", _tmp232_);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_method_call_new ((ValaExpression*) _tmp234_, _tmp236_);
			_tmp238_ = _tmp237_;
			_vala_code_node_unref0 (_tmp234_);
			_vala_code_node_unref0 (_tmp230_);
			_g_free0 (_tmp226_);
			get_call = _tmp238_;
			_tmp239_ = vala_foreach_statement_get_body (self);
			_tmp240_ = _tmp239_;
			_tmp241_ = vala_foreach_statement_get_type_reference (self);
			_tmp242_ = _tmp241_;
			_tmp243_ = self->priv->_variable_name;
			_tmp244_ = get_call;
			_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_local_variable_new (_tmp242_, _tmp243_, (ValaExpression*) _tmp244_, _tmp246_);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_declaration_statement_new ((ValaSymbol*) _tmp248_, _tmp250_);
			_tmp252_ = _tmp251_;
			vala_block_insert_statement (_tmp240_, 0, (ValaStatement*) _tmp252_);
			_vala_code_node_unref0 (_tmp252_);
			_vala_code_node_unref0 (_tmp248_);
			_vala_code_node_unref0 (get_call);
			_vala_code_node_unref0 (loop);
			_vala_code_node_unref0 (next_call);
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (get_method);
		} else {
			ValaExpression* _tmp253_;
			ValaExpression* _tmp254_;
			ValaSourceReference* _tmp255_;
			ValaSourceReference* _tmp256_;
			ValaDataType* _tmp257_;
			gchar* _tmp258_;
			gchar* _tmp259_;
			_tmp253_ = vala_foreach_statement_get_collection (self);
			_tmp254_ = _tmp253_;
			_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp254_);
			_tmp256_ = _tmp255_;
			_tmp257_ = iterator_type;
			_tmp258_ = vala_code_node_to_string ((ValaCodeNode*) _tmp257_);
			_tmp259_ = _tmp258_;
			vala_report_error (_tmp256_, "`%s' does not have a `next_value' or `next' method", _tmp259_);
			_g_free0 (_tmp259_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	result = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context);
	_vala_code_node_unref0 (next_method);
	_vala_code_node_unref0 (next_value_method);
	_vala_code_node_unref0 (iterator_call);
	_vala_code_node_unref0 (iterator_type);
	_vala_code_node_unref0 (iterator_method);
	return result;
}

static gboolean
vala_foreach_statement_analyze_element_type (ValaForeachStatement* self,
                                             ValaDataType* element_type)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_VAR_TYPE (_tmp1_)) {
		gboolean value_owned = FALSE;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp2_ = vala_foreach_statement_get_type_reference (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_data_type_get_value_owned (_tmp3_);
		_tmp5_ = _tmp4_;
		value_owned = _tmp5_;
		_tmp6_ = vala_data_type_copy (element_type);
		_tmp7_ = _tmp6_;
		vala_foreach_statement_set_type_reference (self, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		if (!value_owned) {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_tmp8_ = vala_foreach_statement_get_type_reference (self);
			_tmp9_ = _tmp8_;
			vala_data_type_set_value_owned (_tmp9_, FALSE);
		}
	} else {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_foreach_statement_get_type_reference (self);
		_tmp11_ = _tmp10_;
		if (!vala_data_type_compatible (element_type, _tmp11_)) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) element_type);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_foreach_statement_get_type_reference (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_code_node_to_string ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp13_, "Foreach: Cannot convert from `%s' to `%s'", _tmp15_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp15_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			if (vala_data_type_is_disposable (element_type)) {
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp22_ = vala_data_type_get_value_owned (element_type);
				_tmp23_ = _tmp22_;
				_tmp21_ = _tmp23_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				ValaDataType* _tmp24_;
				ValaDataType* _tmp25_;
				gboolean _tmp26_;
				gboolean _tmp27_;
				_tmp24_ = vala_foreach_statement_get_type_reference (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_data_type_get_value_owned (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp20_ = !_tmp27_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp29_, "Foreach: Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_foreach_statement_check_without_iterator (ValaForeachStatement* self,
                                               ValaCodeContext* context,
                                               ValaDataType* collection_type,
                                               ValaDataType* element_type)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp20_;
	ValaDataType* _tmp21_;
	const gchar* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaLocalVariable* _tmp25_;
	ValaLocalVariable* _tmp26_;
	ValaBlock* _tmp27_;
	ValaBlock* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	const gchar* _tmp31_;
	ValaLocalVariable* _tmp32_;
	ValaBlock* _tmp33_;
	ValaBlock* _tmp34_;
	ValaLocalVariable* _tmp35_;
	ValaLocalVariable* _tmp36_;
	ValaLocalVariable* _tmp37_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp38_;
	ValaSemanticAnalyzer* _tmp39_;
	ValaSymbol* _tmp40_;
	ValaSymbol* _tmp41_;
	ValaSymbol* _tmp42_;
	ValaSemanticAnalyzer* _tmp43_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSymbol* _tmp45_;
	ValaSymbol* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaSemanticAnalyzer* _tmp49_;
	ValaSemanticAnalyzer* _tmp50_;
	ValaLocalVariable* _tmp51_;
	ValaLocalVariable* _tmp52_;
	ValaBlock* _tmp53_;
	ValaBlock* _tmp54_;
	ValaSemanticAnalyzer* _tmp64_;
	ValaSemanticAnalyzer* _tmp65_;
	ValaSymbol* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaLocalVariable* _tmp74_;
	ValaLocalVariable* _tmp75_;
	ValaLocalVariable* _tmp76_;
	ValaLocalVariable* _tmp77_;
	gboolean _tmp78_;
	gboolean _tmp79_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_VAR_TYPE (_tmp1_)) {
		gboolean value_owned = FALSE;
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp2_ = vala_foreach_statement_get_type_reference (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_data_type_get_value_owned (_tmp3_);
		_tmp5_ = _tmp4_;
		value_owned = _tmp5_;
		_tmp6_ = vala_data_type_copy (element_type);
		_tmp7_ = _tmp6_;
		vala_foreach_statement_set_type_reference (self, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		if (!value_owned) {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			_tmp8_ = vala_foreach_statement_get_type_reference (self);
			_tmp9_ = _tmp8_;
			vala_data_type_set_value_owned (_tmp9_, FALSE);
		}
	} else {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_foreach_statement_get_type_reference (self);
		_tmp11_ = _tmp10_;
		if (!vala_data_type_compatible (element_type, _tmp11_)) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) element_type);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_foreach_statement_get_type_reference (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_code_node_to_string ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp13_, "Foreach: Cannot convert from `%s' to `%s'", _tmp15_, _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp15_);
			result = FALSE;
			return result;
		}
	}
	_tmp20_ = vala_foreach_statement_get_type_reference (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_variable_name;
	_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_local_variable_new (_tmp21_, _tmp22_, NULL, _tmp24_);
	_tmp26_ = _tmp25_;
	vala_foreach_statement_set_element_variable (self, _tmp26_);
	_vala_code_node_unref0 (_tmp26_);
	_tmp27_ = vala_foreach_statement_get_body (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_symbol_get_scope ((ValaSymbol*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_variable_name;
	_tmp32_ = self->priv->_element_variable;
	vala_scope_add (_tmp30_, _tmp31_, (ValaSymbol*) _tmp32_);
	_tmp33_ = vala_foreach_statement_get_body (self);
	_tmp34_ = _tmp33_;
	_tmp35_ = self->priv->_element_variable;
	vala_block_add_local_variable (_tmp34_, _tmp35_);
	_tmp36_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp36_, TRUE);
	_tmp37_ = self->priv->_element_variable;
	vala_code_node_set_checked ((ValaCodeNode*) _tmp37_, TRUE);
	_tmp38_ = vala_code_context_get_analyzer (context);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _vala_code_node_ref0 (_tmp41_);
	old_symbol = _tmp42_;
	_tmp43_ = vala_code_context_get_analyzer (context);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_semantic_analyzer_get_current_symbol (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_symbol_get_scope (_tmp46_);
	_tmp48_ = _tmp47_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp48_);
	_tmp49_ = vala_code_context_get_analyzer (context);
	_tmp50_ = _tmp49_;
	vala_semantic_analyzer_set_current_symbol (_tmp50_, (ValaSymbol*) self);
	_tmp51_ = self->priv->_element_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp51_);
	_tmp52_ = self->priv->_element_variable;
	vala_block_remove_local_variable ((ValaBlock*) self, _tmp52_);
	_tmp53_ = vala_foreach_statement_get_body (self);
	_tmp54_ = _tmp53_;
	vala_code_node_check ((ValaCodeNode*) _tmp54_, context);
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp55_;
		gint _local_size = 0;
		ValaList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		gint _local_index = 0;
		_tmp55_ = vala_block_get_local_variables ((ValaBlock*) self);
		_local_list = _tmp55_;
		_tmp56_ = _local_list;
		_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		_local_size = _tmp58_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp59_;
			gint _tmp60_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaLocalVariable* _tmp63_;
			_local_index = _local_index + 1;
			_tmp59_ = _local_index;
			_tmp60_ = _local_size;
			if (!(_tmp59_ < _tmp60_)) {
				break;
			}
			_tmp61_ = _local_list;
			_tmp62_ = vala_list_get (_tmp61_, _local_index);
			local = (ValaLocalVariable*) _tmp62_;
			_tmp63_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp63_, FALSE);
			_vala_code_node_unref0 (local);
		}
	}
	_tmp64_ = vala_code_context_get_analyzer (context);
	_tmp65_ = _tmp64_;
	_tmp66_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp65_, _tmp66_);
	_tmp67_ = vala_data_type_copy (collection_type);
	_tmp68_ = _tmp67_;
	_tmp69_ = self->priv->_variable_name;
	_tmp70_ = g_strdup_printf ("%s_collection", _tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_local_variable_new (_tmp68_, _tmp71_, NULL, _tmp73_);
	_tmp75_ = _tmp74_;
	vala_foreach_statement_set_collection_variable (self, _tmp75_);
	_vala_code_node_unref0 (_tmp75_);
	_g_free0 (_tmp71_);
	_vala_code_node_unref0 (_tmp68_);
	_tmp76_ = self->priv->_collection_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp76_);
	_tmp77_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp77_, TRUE);
	_tmp78_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp79_ = _tmp78_;
	result = !_tmp79_;
	_vala_code_node_unref0 (old_symbol);
	return result;
}

static void
vala_foreach_statement_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaForeachStatement * self;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_foreach_statement_get_collection (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	_tmp4_ = vala_foreach_statement_get_body (self);
	_tmp5_ = _tmp4_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp5_, collection, source_reference);
}

static void
vala_foreach_statement_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaLocalVariable* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaLocalVariable* _tmp7_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), codegen);
		return;
	}
	_tmp1_ = vala_foreach_statement_get_collection (self);
	_tmp2_ = _tmp1_;
	vala_code_node_emit ((ValaCodeNode*) _tmp2_, codegen);
	_tmp3_ = vala_foreach_statement_get_collection (self);
	_tmp4_ = _tmp3_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) codegen, _tmp4_);
	_tmp5_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp5_, TRUE);
	_tmp6_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp6_, TRUE);
	_tmp7_ = self->priv->_iterator_variable;
	if (_tmp7_ != NULL) {
		ValaLocalVariable* _tmp8_;
		_tmp8_ = self->priv->_iterator_variable;
		vala_symbol_set_active ((ValaSymbol*) _tmp8_, TRUE);
	}
	vala_code_visitor_visit_foreach_statement ((ValaCodeVisitor*) codegen, self);
}

static void
vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaForeachStatement * self;
	ValaLocalVariable* _tmp0_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_element_variable;
	if (_tmp0_ != NULL) {
		ValaLocalVariable* _tmp1_;
		_tmp1_ = self->priv->_element_variable;
		vala_collection_add (collection, (ValaVariable*) _tmp1_);
	}
}

static void
vala_foreach_statement_class_init (ValaForeachStatementClass * klass,
                                   gpointer klass_data)
{
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_foreach_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForeachStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_foreach_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_foreach_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_foreach_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_foreach_statement_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_foreach_statement_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_foreach_statement_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_foreach_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_foreach_statement_real_get_defined_variables;
}

static void
vala_foreach_statement_instance_init (ValaForeachStatement * self,
                                      gpointer klass)
{
	self->priv = vala_foreach_statement_get_instance_private (self);
}

static void
vala_foreach_statement_finalize (ValaCodeNode * obj)
{
	ValaForeachStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement);
	_g_free0 (self->priv->_variable_name);
	_vala_code_node_unref0 (self->priv->_element_variable);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	_vala_code_node_unref0 (self->priv->_collection);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->finalize (obj);
}

/**
 * Represents a foreach statement in the source code.
 *
 * Foreach statements iterate over the elements of a collection.
 */
static GType
vala_foreach_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_instance_init, NULL };
	GType vala_foreach_statement_type_id;
	vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaForeachStatement", &g_define_type_info, 0);
	ValaForeachStatement_private_offset = g_type_add_instance_private (vala_foreach_statement_type_id, sizeof (ValaForeachStatementPrivate));
	return vala_foreach_statement_type_id;
}

GType
vala_foreach_statement_get_type (void)
{
	static volatile gsize vala_foreach_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_foreach_statement_type_id__volatile)) {
		GType vala_foreach_statement_type_id;
		vala_foreach_statement_type_id = vala_foreach_statement_get_type_once ();
		g_once_init_leave (&vala_foreach_statement_type_id__volatile, vala_foreach_statement_type_id);
	}
	return vala_foreach_statement_type_id__volatile;
}

