// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use gst_sys;
use std::boxed::Box as Box_;
use std::mem::transmute;
use Bin;
use ChildProxy;
use Clock;
use ClockTime;
use Element;
use Object;

glib_wrapper! {
    pub struct Pipeline(Object<gst_sys::GstPipeline, gst_sys::GstPipelineClass, PipelineClass>) @extends Bin, Element, Object, @implements ChildProxy;

    match fn {
        get_type => || gst_sys::gst_pipeline_get_type(),
    }
}

impl Pipeline {
    pub fn new(name: Option<&str>) -> Pipeline {
        assert_initialized_main_thread!();
        unsafe {
            Element::from_glib_none(gst_sys::gst_pipeline_new(name.to_glib_none().0)).unsafe_cast()
        }
    }
}

unsafe impl Send for Pipeline {}
unsafe impl Sync for Pipeline {}

pub const NONE_PIPELINE: Option<&Pipeline> = None;

pub trait PipelineExt: 'static {
    fn auto_clock(&self);

    fn get_auto_flush_bus(&self) -> bool;

    fn get_delay(&self) -> ClockTime;

    fn get_latency(&self) -> ClockTime;

    fn get_pipeline_clock(&self) -> Option<Clock>;

    fn set_auto_flush_bus(&self, auto_flush: bool);

    fn set_delay(&self, delay: ClockTime);

    fn set_latency(&self, latency: ClockTime);

    fn use_clock<P: IsA<Clock>>(&self, clock: Option<&P>);

    fn connect_property_auto_flush_bus_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_delay_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_latency_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<Pipeline>> PipelineExt for O {
    fn auto_clock(&self) {
        unsafe {
            gst_sys::gst_pipeline_auto_clock(self.as_ref().to_glib_none().0);
        }
    }

    fn get_auto_flush_bus(&self) -> bool {
        unsafe {
            from_glib(gst_sys::gst_pipeline_get_auto_flush_bus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_delay(&self) -> ClockTime {
        unsafe {
            from_glib(gst_sys::gst_pipeline_get_delay(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_latency(&self) -> ClockTime {
        unsafe {
            from_glib(gst_sys::gst_pipeline_get_latency(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_pipeline_clock(&self) -> Option<Clock> {
        unsafe {
            from_glib_full(gst_sys::gst_pipeline_get_pipeline_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_auto_flush_bus(&self, auto_flush: bool) {
        unsafe {
            gst_sys::gst_pipeline_set_auto_flush_bus(
                self.as_ref().to_glib_none().0,
                auto_flush.to_glib(),
            );
        }
    }

    fn set_delay(&self, delay: ClockTime) {
        unsafe {
            gst_sys::gst_pipeline_set_delay(self.as_ref().to_glib_none().0, delay.to_glib());
        }
    }

    fn set_latency(&self, latency: ClockTime) {
        unsafe {
            gst_sys::gst_pipeline_set_latency(self.as_ref().to_glib_none().0, latency.to_glib());
        }
    }

    fn use_clock<P: IsA<Clock>>(&self, clock: Option<&P>) {
        unsafe {
            gst_sys::gst_pipeline_use_clock(
                self.as_ref().to_glib_none().0,
                clock.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn connect_property_auto_flush_bus_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_auto_flush_bus_trampoline<
            P,
            F: Fn(&P) + Send + Sync + 'static,
        >(
            this: *mut gst_sys::GstPipeline,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Pipeline>,
        {
            let f: &F = &*(f as *const F);
            f(&Pipeline::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::auto-flush-bus\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_auto_flush_bus_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_delay_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_delay_trampoline<P, F: Fn(&P) + Send + Sync + 'static>(
            this: *mut gst_sys::GstPipeline,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Pipeline>,
        {
            let f: &F = &*(f as *const F);
            f(&Pipeline::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::delay\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_delay_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_latency_notify<F: Fn(&Self) + Send + Sync + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_latency_trampoline<P, F: Fn(&P) + Send + Sync + 'static>(
            this: *mut gst_sys::GstPipeline,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Pipeline>,
        {
            let f: &F = &*(f as *const F);
            f(&Pipeline::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::latency\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_latency_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}
