/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
	gboolean is_with_variable_access;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_check_narrowed_value_type (ValaMemberAccess* self);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		gint _type_arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_type_arg_list = _tmp4_;
		_tmp5_ = _type_arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_type_arg_size = _tmp7_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			_type_arg_index = _type_arg_index + 1;
			_tmp8_ = _type_arg_index;
			_tmp9_ = _type_arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _type_arg_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp11_;
			_tmp12_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp17_;
	ValaArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp675_ = FALSE;
	gboolean _tmp676_ = FALSE;
	gboolean _tmp677_ = FALSE;
	ValaExpression* _tmp678_;
	ValaExpression* _tmp679_;
	ValaSymbol* _tmp706_;
	ValaSymbol* _tmp707_;
	ValaSymbol* _tmp776_;
	ValaSymbol* _tmp777_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp813_;
	ValaSymbol* _tmp814_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp815_;
	ValaSymbol* _tmp816_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1264_;
	ValaSymbol* _tmp1265_;
	ValaSymbol* _tmp1267_;
	ValaVersionAttribute* _tmp1268_;
	ValaVersionAttribute* _tmp1269_;
	ValaSourceReference* _tmp1270_;
	ValaSourceReference* _tmp1271_;
	gboolean _tmp1272_ = FALSE;
	gboolean _tmp1323_ = FALSE;
	gboolean _tmp1350_ = FALSE;
	gboolean _tmp1351_ = FALSE;
	ValaDataType* _tmp1652_;
	ValaDataType* _tmp1653_;
	gboolean _tmp1656_;
	gboolean _tmp1657_;
	gboolean _tmp1658_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		gint _type_arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_type_arg_list = _tmp8_;
		_tmp9_ = _type_arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_type_arg_size = _tmp11_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaDataType* _tmp16_;
			_type_arg_index = _type_arg_index + 1;
			_tmp12_ = _type_arg_index;
			_tmp13_ = _type_arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _type_arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp15_;
			_tmp16_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp16_, context);
			_vala_code_node_unref0 (type_arg);
		}
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp17_ = g_direct_equal;
	_tmp18_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp17_);
	visited_types = _tmp18_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaScope* _tmp23_;
		ValaScope* _tmp24_;
		const gchar* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		base_symbol = (ValaSymbol*) _tmp21_;
		_tmp22_ = base_symbol;
		_tmp23_ = vala_symbol_get_scope (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_member_name;
		_tmp26_ = vala_scope_lookup (_tmp24_, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
	} else {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			const gchar* _tmp30_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp179_ = FALSE;
			ValaSymbol* _tmp180_;
			ValaSymbol* _tmp181_;
			_tmp30_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp30_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp31_;
				ValaSemanticAnalyzer* _tmp32_;
				_tmp31_ = vala_code_context_get_analyzer (context);
				_tmp32_ = _tmp31_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp32_)) {
					ValaSourceReference* _tmp33_;
					ValaSourceReference* _tmp34_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp34_ = _tmp33_;
					vala_report_error (_tmp34_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp35_ = vala_code_context_get_analyzer (context);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_semantic_analyzer_get_current_symbol (_tmp36_);
			_tmp38_ = _tmp37_;
			base_symbol = _tmp38_;
			method_found = FALSE;
			_tmp39_ = vala_code_context_get_analyzer (context);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_semantic_analyzer_get_current_symbol (_tmp40_);
			_tmp42_ = _tmp41_;
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp90_;
				const gchar* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaSymbol* _tmp93_;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				gboolean _tmp132_ = FALSE;
				gboolean _tmp133_ = FALSE;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaParameter* _tmp50_;
						ValaParameter* _tmp51_;
						_tmp48_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp49_ = cm;
						_tmp50_ = vala_method_get_this_parameter ((ValaMethod*) _tmp49_);
						_tmp51_ = _tmp50_;
						this_parameter = _tmp51_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp52_;
						_tmp52_ = sym;
						if (VALA_IS_PROPERTY (_tmp52_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp53_;
							ValaProperty* _tmp54_;
							ValaParameter* _tmp55_;
							ValaParameter* _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaProperty* _tmp60_;
							ValaMemberBinding _tmp61_;
							ValaMemberBinding _tmp62_;
							_tmp53_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_this_parameter (_tmp54_);
							_tmp56_ = _tmp55_;
							this_parameter = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_instance_members = _tmp59_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp60_ = prop;
							_tmp61_ = vala_property_get_binding (_tmp60_);
							_tmp62_ = _tmp61_;
							may_access_klass_members = _tmp62_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp63_;
							_tmp63_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp63_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaParameter* _tmp66_;
								ValaParameter* _tmp67_;
								ValaConstructor* _tmp68_;
								ValaMemberBinding _tmp69_;
								ValaMemberBinding _tmp70_;
								_tmp64_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_this_parameter (_tmp65_);
								_tmp67_ = _tmp66_;
								this_parameter = _tmp67_;
								_tmp68_ = c;
								_tmp69_ = vala_constructor_get_binding (_tmp68_);
								_tmp70_ = _tmp69_;
								may_access_instance_members = _tmp70_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp71_;
								_tmp71_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp71_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaParameter* _tmp74_;
									ValaParameter* _tmp75_;
									ValaDestructor* _tmp76_;
									ValaMemberBinding _tmp77_;
									ValaMemberBinding _tmp78_;
									_tmp72_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_this_parameter (_tmp73_);
									_tmp75_ = _tmp74_;
									this_parameter = _tmp75_;
									_tmp76_ = d;
									_tmp77_ = vala_destructor_get_binding (_tmp76_);
									_tmp78_ = _tmp77_;
									may_access_instance_members = _tmp78_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp79_;
									_tmp79_ = sym;
									if (VALA_IS_METHOD (_tmp79_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp80_;
										ValaMethod* _tmp81_;
										ValaParameter* _tmp82_;
										ValaParameter* _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMethod* _tmp87_;
										ValaMemberBinding _tmp88_;
										ValaMemberBinding _tmp89_;
										_tmp80_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, VALA_TYPE_METHOD, ValaMethod);
										_tmp81_ = m;
										_tmp82_ = vala_method_get_this_parameter (_tmp81_);
										_tmp83_ = _tmp82_;
										this_parameter = _tmp83_;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp87_ = m;
										_tmp88_ = vala_method_get_binding (_tmp87_);
										_tmp89_ = _tmp88_;
										may_access_klass_members = _tmp89_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp90_ = sym;
				_tmp91_ = self->priv->_member_name;
				_tmp92_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp90_, _tmp91_);
				_tmp93_ = _tmp92_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp93_);
				_vala_code_node_unref0 (_tmp93_);
				if (!self->priv->is_with_variable_access) {
					ValaSymbol* _tmp96_;
					ValaSymbol* _tmp97_;
					_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp97_ = _tmp96_;
					_tmp95_ = _tmp97_ == NULL;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp94_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaExpression* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = vala_member_access_get_inner (self);
						_tmp129_ = _tmp128_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess)->priv->is_with_variable_access = TRUE;
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						vala_code_node_check ((ValaCodeNode*) _tmp131_, context);
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					_tmp133_ = VALA_IS_TYPESYMBOL (_tmp136_);
				} else {
					_tmp133_ = FALSE;
				}
				if (_tmp133_) {
					_tmp132_ = may_access_instance_members;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					ValaParameter* _tmp137_;
					ValaDataType* _tmp138_;
					ValaDataType* _tmp139_;
					const gchar* _tmp140_;
					ValaSymbol* _tmp141_;
					ValaSymbol* _tmp142_;
					gboolean _tmp143_ = FALSE;
					ValaSymbol* _tmp144_;
					ValaSymbol* _tmp145_;
					_tmp137_ = this_parameter;
					_tmp138_ = vala_variable_get_variable_type ((ValaVariable*) _tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = self->priv->_member_name;
					_tmp141_ = vala_data_type_get_member (_tmp139_, _tmp140_);
					_tmp142_ = _tmp141_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp142_);
					_vala_code_node_unref0 (_tmp142_);
					_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp145_ = _tmp144_;
					if (_tmp145_ != NULL) {
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp146_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp147_ = _tmp146_;
						_tmp143_ = vala_member_access_is_instance_symbol (_tmp147_);
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						ValaSourceReference* _tmp148_;
						ValaSourceReference* _tmp149_;
						ValaMemberAccess* _tmp150_;
						ValaMemberAccess* _tmp151_;
						ValaExpression* _tmp152_;
						ValaExpression* _tmp153_;
						ValaParameter* _tmp154_;
						ValaDataType* _tmp155_;
						ValaDataType* _tmp156_;
						ValaDataType* _tmp157_;
						ValaDataType* _tmp158_;
						ValaExpression* _tmp159_;
						ValaExpression* _tmp160_;
						ValaDataType* _tmp161_;
						ValaDataType* _tmp162_;
						ValaExpression* _tmp163_;
						ValaExpression* _tmp164_;
						ValaParameter* _tmp165_;
						ValaExpression* _tmp166_;
						ValaExpression* _tmp167_;
						ValaDataType* _tmp168_;
						ValaDataType* _tmp169_;
						const gchar* _tmp170_;
						ValaSymbol* _tmp171_;
						ValaSymbol* _tmp172_;
						_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp149_ = _tmp148_;
						_tmp150_ = vala_member_access_new (NULL, "this", _tmp149_);
						_tmp151_ = _tmp150_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp151_);
						_vala_code_node_unref0 (_tmp151_);
						_tmp152_ = vala_member_access_get_inner (self);
						_tmp153_ = _tmp152_;
						_tmp154_ = this_parameter;
						_tmp155_ = vala_variable_get_variable_type ((ValaVariable*) _tmp154_);
						_tmp156_ = _tmp155_;
						_tmp157_ = vala_data_type_copy (_tmp156_);
						_tmp158_ = _tmp157_;
						vala_expression_set_value_type (_tmp153_, _tmp158_);
						_vala_code_node_unref0 (_tmp158_);
						_tmp159_ = vala_member_access_get_inner (self);
						_tmp160_ = _tmp159_;
						_tmp161_ = vala_expression_get_value_type (_tmp160_);
						_tmp162_ = _tmp161_;
						vala_data_type_set_value_owned (_tmp162_, FALSE);
						_tmp163_ = vala_member_access_get_inner (self);
						_tmp164_ = _tmp163_;
						_tmp165_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp164_, (ValaSymbol*) _tmp165_);
						_tmp166_ = vala_member_access_get_inner (self);
						_tmp167_ = _tmp166_;
						_tmp168_ = vala_expression_get_value_type (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = self->priv->_member_name;
						_tmp171_ = vala_data_type_get_member (_tmp169_, _tmp170_);
						_tmp172_ = _tmp171_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
					}
				}
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				if (_tmp174_ == NULL) {
					ValaSymbol* _tmp175_;
					_tmp175_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp175_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp176_ = sym;
				_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
				_tmp178_ = _tmp177_;
				sym = _tmp178_;
			}
			_tmp180_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp181_ = _tmp180_;
			if (_tmp181_ == NULL) {
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp183_ = _tmp182_;
				_tmp179_ = _tmp183_ != NULL;
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp184_;
					ValaSourceReference* _tmp185_;
					ValaList* _tmp186_;
					ValaList* _tmp187_;
					gint _ns_size = 0;
					ValaList* _tmp188_;
					gint _tmp189_;
					gint _tmp190_;
					gint _ns_index = 0;
					_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp185_ = _tmp184_;
					_tmp186_ = vala_source_reference_get_using_directives (_tmp185_);
					_tmp187_ = _tmp186_;
					_ns_list = _tmp187_;
					_tmp188_ = _ns_list;
					_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
					_tmp190_ = _tmp189_;
					_ns_size = _tmp190_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp191_;
						gint _tmp192_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp193_;
						gpointer _tmp194_;
						ValaUsingDirective* _tmp195_;
						gboolean _tmp196_;
						gboolean _tmp197_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp198_;
						ValaSymbol* _tmp199_;
						ValaSymbol* _tmp200_;
						ValaScope* _tmp201_;
						ValaScope* _tmp202_;
						const gchar* _tmp203_;
						ValaSymbol* _tmp204_;
						ValaSymbol* _tmp205_;
						_ns_index = _ns_index + 1;
						_tmp191_ = _ns_index;
						_tmp192_ = _ns_size;
						if (!(_tmp191_ < _tmp192_)) {
							break;
						}
						_tmp193_ = _ns_list;
						_tmp194_ = vala_list_get (_tmp193_, _ns_index);
						ns = (ValaUsingDirective*) _tmp194_;
						_tmp195_ = ns;
						_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
						_tmp197_ = _tmp196_;
						if (_tmp197_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp198_ = ns;
						_tmp199_ = vala_using_directive_get_namespace_symbol (_tmp198_);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_symbol_get_scope (_tmp200_);
						_tmp202_ = _tmp201_;
						_tmp203_ = self->priv->_member_name;
						_tmp204_ = vala_scope_lookup (_tmp202_, _tmp203_);
						local_sym = _tmp204_;
						_tmp205_ = local_sym;
						if (_tmp205_ != NULL) {
							gboolean _tmp206_ = FALSE;
							ValaSymbol* _tmp207_;
							ValaSymbol* _tmp208_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp222_;
							ValaSymbol* _tmp223_;
							ValaSymbol* _tmp224_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp244_;
							ValaExpression* _tmp245_;
							ValaExpression* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp208_ = _tmp207_;
							if (_tmp208_ != NULL) {
								ValaSymbol* _tmp209_;
								ValaSymbol* _tmp210_;
								ValaSymbol* _tmp211_;
								_tmp209_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp210_ = _tmp209_;
								_tmp211_ = local_sym;
								_tmp206_ = _tmp210_ != _tmp211_;
							} else {
								_tmp206_ = FALSE;
							}
							if (_tmp206_) {
								ValaSourceReference* _tmp212_;
								ValaSourceReference* _tmp213_;
								const gchar* _tmp214_;
								ValaSymbol* _tmp215_;
								ValaSymbol* _tmp216_;
								gchar* _tmp217_;
								gchar* _tmp218_;
								ValaSymbol* _tmp219_;
								gchar* _tmp220_;
								gchar* _tmp221_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp213_ = _tmp212_;
								_tmp214_ = self->priv->_member_name;
								_tmp215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp216_ = _tmp215_;
								_tmp217_ = vala_symbol_get_full_name (_tmp216_);
								_tmp218_ = _tmp217_;
								_tmp219_ = local_sym;
								_tmp220_ = vala_symbol_get_full_name (_tmp219_);
								_tmp221_ = _tmp220_;
								vala_report_error (_tmp213_, "`%s' is an ambiguous reference between `%s' and `%s'", _tmp214_, _tmp218_, _tmp221_);
								_g_free0 (_tmp221_);
								_g_free0 (_tmp218_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp222_ = local_sym;
							_tmp223_ = vala_symbol_get_parent_symbol (_tmp222_);
							_tmp224_ = _tmp223_;
							inner_sym = _tmp224_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp225_ = FALSE;
								ValaSymbol* _tmp226_;
								ValaMemberAccess* _tmp230_;
								ValaSymbol* _tmp231_;
								const gchar* _tmp232_;
								const gchar* _tmp233_;
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								ValaMemberAccess* _tmp236_;
								ValaMemberAccess* _tmp237_;
								ValaMemberAccess* _tmp238_;
								ValaExpression* _tmp239_;
								ValaExpression* _tmp240_;
								ValaSymbol* _tmp241_;
								ValaSymbol* _tmp242_;
								ValaSymbol* _tmp243_;
								_tmp226_ = inner_sym;
								if (_tmp226_ != NULL) {
									ValaSymbol* _tmp227_;
									const gchar* _tmp228_;
									const gchar* _tmp229_;
									_tmp227_ = inner_sym;
									_tmp228_ = vala_symbol_get_name (_tmp227_);
									_tmp229_ = _tmp228_;
									_tmp225_ = _tmp229_ != NULL;
								} else {
									_tmp225_ = FALSE;
								}
								if (!_tmp225_) {
									break;
								}
								_tmp230_ = inner_ma;
								_tmp231_ = inner_sym;
								_tmp232_ = vala_symbol_get_name (_tmp231_);
								_tmp233_ = _tmp232_;
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = vala_member_access_new (NULL, _tmp233_, _tmp235_);
								_tmp237_ = _tmp236_;
								vala_member_access_set_inner (_tmp230_, (ValaExpression*) _tmp237_);
								_vala_code_node_unref0 (_tmp237_);
								_tmp238_ = inner_ma;
								_tmp239_ = vala_member_access_get_inner (_tmp238_);
								_tmp240_ = _tmp239_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp241_ = inner_sym;
								_tmp242_ = vala_symbol_get_parent_symbol (_tmp241_);
								_tmp243_ = _tmp242_;
								inner_sym = _tmp243_;
							}
							_tmp244_ = inner_ma;
							vala_member_access_set_qualified (_tmp244_, TRUE);
							_tmp245_ = vala_member_access_get_inner (self);
							_tmp246_ = _tmp245_;
							vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
							_tmp247_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp247_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
				}
			}
		} else {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp250_;
			gboolean _tmp251_;
			ValaExpression* _tmp252_;
			ValaExpression* _tmp253_;
			ValaDataType* _tmp254_;
			ValaDataType* _tmp255_;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp300_ = FALSE;
			ValaExpression* _tmp301_;
			ValaExpression* _tmp302_;
			gboolean _tmp309_ = FALSE;
			ValaExpression* _tmp310_;
			ValaExpression* _tmp311_;
			gboolean _tmp332_ = FALSE;
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			gboolean _tmp353_ = FALSE;
			ValaSymbol* _tmp354_;
			ValaSymbol* _tmp355_;
			gboolean _tmp389_ = FALSE;
			gboolean _tmp390_ = FALSE;
			ValaSymbol* _tmp391_;
			ValaSymbol* _tmp392_;
			ValaSymbol* _tmp641_;
			ValaSymbol* _tmp642_;
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_code_node_get_error ((ValaCodeNode*) _tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp252_ = vala_member_access_get_inner (self);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_expression_get_value_type (_tmp253_);
			_tmp255_ = _tmp254_;
			if (VALA_IS_POINTER_TYPE (_tmp255_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				ValaDataType* _tmp258_;
				ValaDataType* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaPointerType* _tmp261_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_expression_get_value_type (_tmp257_);
				_tmp259_ = _tmp258_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp259_) ? ((ValaPointerType*) _tmp259_) : NULL;
				_tmp261_ = pointer_type;
				if (_tmp261_ != NULL) {
					ValaPointerType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					_tmp262_ = pointer_type;
					_tmp263_ = vala_pointer_type_get_base_type (_tmp262_);
					_tmp264_ = _tmp263_;
					_tmp260_ = VALA_IS_VALUE_TYPE (_tmp264_);
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					ValaSourceReference* _tmp280_;
					ValaSourceReference* _tmp281_;
					ValaPointerIndirection* _tmp282_;
					ValaPointerIndirection* _tmp283_;
					ValaExpression* _tmp284_;
					ValaExpression* _tmp285_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_formal_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					if (VALA_IS_GENERIC_TYPE (_tmp268_)) {
						ValaExpression* _tmp269_;
						ValaExpression* _tmp270_;
						ValaPointerType* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						ValaCastExpression* _tmp276_;
						ValaCastExpression* _tmp277_;
						_tmp269_ = vala_member_access_get_inner (self);
						_tmp270_ = _tmp269_;
						_tmp271_ = pointer_type;
						_tmp272_ = vala_data_type_copy ((ValaDataType*) _tmp271_);
						_tmp273_ = _tmp272_;
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_cast_expression_new (_tmp270_, _tmp273_, _tmp275_);
						_tmp277_ = _tmp276_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp277_);
						_vala_code_node_unref0 (_tmp277_);
						_vala_code_node_unref0 (_tmp273_);
					}
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp281_ = _tmp280_;
					_tmp282_ = vala_pointer_indirection_new (_tmp279_, _tmp281_);
					_tmp283_ = _tmp282_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp283_);
					_vala_code_node_unref0 (_tmp283_);
					_tmp284_ = vala_member_access_get_inner (self);
					_tmp285_ = _tmp284_;
					vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaMemberAccess* _tmp290_;
				gboolean _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp290_ = ma;
				_tmp291_ = _tmp290_->priv->_prototype_access;
				if (_tmp291_) {
					ValaSourceReference* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaExpression* _tmp294_;
					ValaExpression* _tmp295_;
					ValaSymbol* _tmp296_;
					ValaSymbol* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp293_ = _tmp292_;
					_tmp294_ = vala_member_access_get_inner (self);
					_tmp295_ = _tmp294_;
					_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = vala_symbol_get_full_name (_tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_error (_tmp293_, "Access to instance member `%s' denied", _tmp299_);
					_g_free0 (_tmp299_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp301_ = vala_member_access_get_inner (self);
			_tmp302_ = _tmp301_;
			if (VALA_IS_CAST_EXPRESSION (_tmp302_)) {
				ValaExpression* _tmp303_;
				ValaExpression* _tmp304_;
				gboolean _tmp305_;
				gboolean _tmp306_;
				_tmp303_ = vala_member_access_get_inner (self);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp304_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp306_ = _tmp305_;
				_tmp300_ = _tmp306_;
			} else {
				_tmp300_ = FALSE;
			}
			if (_tmp300_) {
				ValaSourceReference* _tmp307_;
				ValaSourceReference* _tmp308_;
				_tmp307_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp308_ = _tmp307_;
				vala_report_warning (_tmp308_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp310_ = vala_member_access_get_inner (self);
			_tmp311_ = _tmp310_;
			if (VALA_IS_MEMBER_ACCESS (_tmp311_)) {
				_tmp309_ = TRUE;
			} else {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp309_ = VALA_IS_BASE_ACCESS (_tmp313_);
			}
			if (_tmp309_) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaSymbol* _tmp316_;
				ValaSymbol* _tmp317_;
				gboolean _tmp318_ = FALSE;
				ValaSymbol* _tmp319_;
				ValaSymbol* _tmp320_;
				_tmp314_ = vala_member_access_get_inner (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_expression_get_symbol_reference (_tmp315_);
				_tmp317_ = _tmp316_;
				base_symbol = _tmp317_;
				_tmp319_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp320_ = _tmp319_;
				if (_tmp320_ == NULL) {
					gboolean _tmp321_ = FALSE;
					ValaSymbol* _tmp322_;
					_tmp322_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp322_)) {
						_tmp321_ = TRUE;
					} else {
						ValaSymbol* _tmp323_;
						_tmp323_ = base_symbol;
						_tmp321_ = VALA_IS_TYPESYMBOL (_tmp323_);
					}
					_tmp318_ = _tmp321_;
				} else {
					_tmp318_ = FALSE;
				}
				if (_tmp318_) {
					ValaSymbol* _tmp324_;
					ValaScope* _tmp325_;
					ValaScope* _tmp326_;
					const gchar* _tmp327_;
					ValaSymbol* _tmp328_;
					ValaSymbol* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp324_ = base_symbol;
					_tmp325_ = vala_symbol_get_scope (_tmp324_);
					_tmp326_ = _tmp325_;
					_tmp327_ = self->priv->_member_name;
					_tmp328_ = vala_scope_lookup (_tmp326_, _tmp327_);
					_tmp329_ = _tmp328_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = vala_member_access_get_inner (self);
					_tmp331_ = _tmp330_;
					if (VALA_IS_BASE_ACCESS (_tmp331_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp333_ = vala_member_access_get_inner (self);
			_tmp334_ = _tmp333_;
			if (VALA_IS_MEMBER_ACCESS (_tmp334_)) {
				ValaExpression* _tmp335_;
				ValaExpression* _tmp336_;
				ValaSymbol* _tmp337_;
				ValaSymbol* _tmp338_;
				_tmp335_ = vala_member_access_get_inner (self);
				_tmp336_ = _tmp335_;
				_tmp337_ = vala_expression_get_symbol_reference (_tmp336_);
				_tmp338_ = _tmp337_;
				_tmp332_ = VALA_IS_TYPEPARAMETER (_tmp338_);
			} else {
				_tmp332_ = FALSE;
			}
			if (_tmp332_) {
				ValaExpression* _tmp339_;
				ValaExpression* _tmp340_;
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaSymbol* _tmp343_;
				ValaSymbol* _tmp344_;
				ValaGenericType* _tmp345_;
				ValaGenericType* _tmp346_;
				ValaExpression* _tmp347_;
				ValaExpression* _tmp348_;
				ValaDataType* _tmp349_;
				ValaDataType* _tmp350_;
				ValaSourceReference* _tmp351_;
				ValaSourceReference* _tmp352_;
				_tmp339_ = vala_member_access_get_inner (self);
				_tmp340_ = _tmp339_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_symbol_reference (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp345_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp344_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp346_ = _tmp345_;
				vala_expression_set_value_type (_tmp340_, (ValaDataType*) _tmp346_);
				_vala_code_node_unref0 (_tmp346_);
				_tmp347_ = vala_member_access_get_inner (self);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_expression_get_value_type (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp352_ = _tmp351_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp350_, _tmp352_);
			}
			_tmp354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp355_ = _tmp354_;
			if (_tmp355_ == NULL) {
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp353_ = _tmp359_ != NULL;
			} else {
				_tmp353_ = FALSE;
			}
			if (_tmp353_) {
				gboolean _tmp360_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp360_ = self->priv->_pointer_member_access;
				if (_tmp360_) {
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					ValaDataType* _tmp363_;
					ValaDataType* _tmp364_;
					const gchar* _tmp365_;
					ValaSymbol* _tmp366_;
					ValaSymbol* _tmp367_;
					_tmp361_ = vala_member_access_get_inner (self);
					_tmp362_ = _tmp361_;
					_tmp363_ = vala_expression_get_value_type (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = self->priv->_member_name;
					_tmp366_ = vala_data_type_get_pointer_member (_tmp364_, _tmp365_);
					_tmp367_ = _tmp366_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp367_);
					_vala_code_node_unref0 (_tmp367_);
				} else {
					ValaExpression* _tmp368_;
					ValaExpression* _tmp369_;
					ValaDataType* _tmp370_;
					ValaDataType* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaTypeSymbol* _tmp373_;
					ValaExpression* _tmp380_;
					ValaExpression* _tmp381_;
					ValaDataType* _tmp382_;
					ValaDataType* _tmp383_;
					const gchar* _tmp384_;
					ValaSymbol* _tmp385_;
					ValaSymbol* _tmp386_;
					_tmp368_ = vala_member_access_get_inner (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_expression_get_value_type (_tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = vala_data_type_get_type_symbol (_tmp371_);
					_tmp373_ = _tmp372_;
					if (_tmp373_ != NULL) {
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaTypeSymbol* _tmp378_;
						ValaTypeSymbol* _tmp379_;
						_tmp374_ = vala_member_access_get_inner (self);
						_tmp375_ = _tmp374_;
						_tmp376_ = vala_expression_get_value_type (_tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_data_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						base_symbol = (ValaSymbol*) _tmp379_;
					}
					_tmp380_ = vala_member_access_get_inner (self);
					_tmp381_ = _tmp380_;
					_tmp382_ = vala_expression_get_value_type (_tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = self->priv->_member_name;
					_tmp385_ = vala_data_type_get_member (_tmp383_, _tmp384_);
					_tmp386_ = _tmp385_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp386_);
					_vala_code_node_unref0 (_tmp386_);
				}
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp388_ = _tmp387_;
				if (_tmp388_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp391_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp392_ = _tmp391_;
			if (_tmp392_ == NULL) {
				ValaExpression* _tmp393_;
				ValaExpression* _tmp394_;
				ValaDataType* _tmp395_;
				ValaDataType* _tmp396_;
				_tmp393_ = vala_member_access_get_inner (self);
				_tmp394_ = _tmp393_;
				_tmp395_ = vala_expression_get_value_type (_tmp394_);
				_tmp396_ = _tmp395_;
				_tmp390_ = _tmp396_ != NULL;
			} else {
				_tmp390_ = FALSE;
			}
			if (_tmp390_) {
				ValaExpression* _tmp397_;
				ValaExpression* _tmp398_;
				ValaDataType* _tmp399_;
				ValaDataType* _tmp400_;
				gboolean _tmp401_;
				gboolean _tmp402_;
				_tmp397_ = vala_member_access_get_inner (self);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_expression_get_value_type (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_data_type_get_is_dynamic (_tmp400_);
				_tmp402_ = _tmp401_;
				_tmp389_ = _tmp402_;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp403_;
				ValaExpression* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaObjectType* _tmp407_;
				ValaCodeNode* _tmp408_;
				ValaCodeNode* _tmp409_;
				ValaSymbol* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaSymbol* _tmp639_;
				ValaSymbol* _tmp640_;
				_tmp403_ = vala_member_access_get_inner (self);
				_tmp404_ = _tmp403_;
				_tmp405_ = vala_expression_get_value_type (_tmp404_);
				_tmp406_ = _tmp405_;
				_tmp407_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp406_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp407_;
				_tmp408_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp409_ = _tmp408_;
				if (VALA_IS_METHOD_CALL (_tmp409_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					ValaMethodCall* _tmp412_;
					ValaExpression* _tmp413_;
					ValaExpression* _tmp414_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp411_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp412_ = invoc;
					_tmp413_ = vala_method_call_get_call (_tmp412_);
					_tmp414_ = _tmp413_;
					if (_tmp414_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp415_;
						ValaDataType* _tmp416_;
						ValaDataType* _tmp417_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp432_;
						ValaExpression* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						const gchar* _tmp436_;
						ValaDataType* _tmp437_;
						ValaSourceReference* _tmp438_;
						ValaSourceReference* _tmp439_;
						ValaDynamicMethod* _tmp440_;
						ValaDynamicMethod* _tmp441_;
						ValaMethodCall* _tmp442_;
						ValaErrorType* err = NULL;
						ValaDynamicMethod* _tmp443_;
						ValaSourceReference* _tmp444_;
						ValaSourceReference* _tmp445_;
						ValaErrorType* _tmp446_;
						ValaErrorType* _tmp447_;
						ValaDynamicMethod* _tmp448_;
						ValaErrorType* _tmp449_;
						ValaDynamicMethod* _tmp450_;
						ValaDynamicMethod* _tmp451_;
						ValaParameter* _tmp452_;
						ValaParameter* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaObjectType* _tmp455_;
						ValaDataType* _tmp456_;
						ValaDataType* _tmp457_;
						ValaDynamicMethod* _tmp458_;
						ValaSourceReference* _tmp459_;
						ValaSourceReference* _tmp460_;
						ValaParameter* _tmp461_;
						ValaParameter* _tmp462_;
						ValaObjectType* _tmp463_;
						ValaTypeSymbol* _tmp464_;
						ValaTypeSymbol* _tmp465_;
						ValaScope* _tmp466_;
						ValaScope* _tmp467_;
						ValaDynamicMethod* _tmp468_;
						ValaDynamicMethod* _tmp469_;
						_tmp415_ = invoc;
						_tmp416_ = vala_expression_get_target_type ((ValaExpression*) _tmp415_);
						_tmp417_ = _tmp416_;
						if (_tmp417_ != NULL) {
							ValaMethodCall* _tmp418_;
							ValaDataType* _tmp419_;
							ValaDataType* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							_tmp418_ = invoc;
							_tmp419_ = vala_expression_get_target_type ((ValaExpression*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_data_type_copy (_tmp420_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp421_;
							_tmp422_ = ret_type;
							vala_data_type_set_value_owned (_tmp422_, TRUE);
						} else {
							ValaMethodCall* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaCodeNode* _tmp425_;
							_tmp423_ = invoc;
							_tmp424_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp423_);
							_tmp425_ = _tmp424_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp425_)) {
								ValaVoidType* _tmp426_;
								_tmp426_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp426_;
							} else {
								ValaExpression* _tmp427_;
								ValaExpression* _tmp428_;
								ValaDataType* _tmp429_;
								ValaDataType* _tmp430_;
								ValaDataType* _tmp431_;
								_tmp427_ = vala_member_access_get_inner (self);
								_tmp428_ = _tmp427_;
								_tmp429_ = vala_expression_get_value_type (_tmp428_);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_data_type_copy (_tmp430_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp431_;
							}
						}
						_tmp432_ = vala_member_access_get_inner (self);
						_tmp433_ = _tmp432_;
						_tmp434_ = vala_expression_get_value_type (_tmp433_);
						_tmp435_ = _tmp434_;
						_tmp436_ = self->priv->_member_name;
						_tmp437_ = ret_type;
						_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp439_ = _tmp438_;
						_tmp440_ = vala_dynamic_method_new (_tmp435_, _tmp436_, _tmp437_, _tmp439_, NULL);
						m = _tmp440_;
						_tmp441_ = m;
						_tmp442_ = invoc;
						vala_dynamic_method_set_invocation (_tmp441_, _tmp442_);
						_tmp443_ = m;
						_tmp444_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp443_);
						_tmp445_ = _tmp444_;
						_tmp446_ = vala_error_type_new (NULL, NULL, _tmp445_);
						err = _tmp446_;
						_tmp447_ = err;
						vala_error_type_set_dynamic_error (_tmp447_, TRUE);
						_tmp448_ = m;
						_tmp449_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp448_, (ValaDataType*) _tmp449_);
						_tmp450_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp450_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp451_ = m;
						_tmp452_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp453_ = _tmp452_;
						vala_callable_add_parameter ((ValaCallable*) _tmp451_, _tmp453_);
						_vala_code_node_unref0 (_tmp453_);
						_tmp454_ = m;
						_tmp455_ = dynamic_object_type;
						_tmp456_ = vala_data_type_copy ((ValaDataType*) _tmp455_);
						_tmp457_ = _tmp456_;
						_tmp458_ = m;
						_tmp459_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = vala_parameter_new ("this", _tmp457_, _tmp460_);
						_tmp462_ = _tmp461_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp454_, _tmp462_);
						_vala_code_node_unref0 (_tmp462_);
						_vala_code_node_unref0 (_tmp457_);
						_tmp463_ = dynamic_object_type;
						_tmp464_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp463_);
						_tmp465_ = _tmp464_;
						_tmp466_ = vala_symbol_get_scope ((ValaSymbol*) _tmp465_);
						_tmp467_ = _tmp466_;
						_tmp468_ = m;
						vala_scope_add (_tmp467_, NULL, (ValaSymbol*) _tmp468_);
						_tmp469_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp469_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp470_;
					ValaCodeNode* _tmp471_;
					_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp471_ = _tmp470_;
					if (VALA_IS_ASSIGNMENT (_tmp471_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp472_;
						ValaCodeNode* _tmp473_;
						ValaAssignment* _tmp474_;
						ValaExpression* _tmp475_;
						ValaExpression* _tmp476_;
						_tmp472_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp473_ = _tmp472_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp474_ = a;
						_tmp475_ = vala_assignment_get_left (_tmp474_);
						_tmp476_ = _tmp475_;
						if (_tmp476_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp477_;
							ValaExpression* _tmp478_;
							ValaDataType* _tmp479_;
							ValaDataType* _tmp480_;
							const gchar* _tmp481_;
							ValaSourceReference* _tmp482_;
							ValaSourceReference* _tmp483_;
							ValaDynamicProperty* _tmp484_;
							ValaDynamicProperty* _tmp485_;
							ValaDynamicProperty* _tmp486_;
							ValaDynamicProperty* _tmp487_;
							ValaSourceReference* _tmp488_;
							ValaSourceReference* _tmp489_;
							ValaPropertyAccessor* _tmp490_;
							ValaPropertyAccessor* _tmp491_;
							ValaDynamicProperty* _tmp492_;
							ValaExpression* _tmp493_;
							ValaExpression* _tmp494_;
							ValaDataType* _tmp495_;
							ValaDataType* _tmp496_;
							ValaTypeSymbol* _tmp497_;
							ValaTypeSymbol* _tmp498_;
							ValaScope* _tmp499_;
							ValaScope* _tmp500_;
							ValaObjectType* _tmp501_;
							ValaTypeSymbol* _tmp502_;
							ValaTypeSymbol* _tmp503_;
							ValaScope* _tmp504_;
							ValaScope* _tmp505_;
							ValaDynamicProperty* _tmp506_;
							ValaDynamicProperty* _tmp507_;
							_tmp477_ = vala_member_access_get_inner (self);
							_tmp478_ = _tmp477_;
							_tmp479_ = vala_expression_get_value_type (_tmp478_);
							_tmp480_ = _tmp479_;
							_tmp481_ = self->priv->_member_name;
							_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp483_ = _tmp482_;
							_tmp484_ = vala_dynamic_property_new (_tmp480_, _tmp481_, _tmp483_, NULL);
							prop = _tmp484_;
							_tmp485_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp485_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp486_ = prop;
							_tmp487_ = prop;
							_tmp488_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp487_);
							_tmp489_ = _tmp488_;
							_tmp490_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp489_, NULL);
							_tmp491_ = _tmp490_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp486_, _tmp491_);
							_vala_code_node_unref0 (_tmp491_);
							_tmp492_ = prop;
							_tmp493_ = vala_member_access_get_inner (self);
							_tmp494_ = _tmp493_;
							_tmp495_ = vala_expression_get_value_type (_tmp494_);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_data_type_get_type_symbol (_tmp496_);
							_tmp498_ = _tmp497_;
							_tmp499_ = vala_symbol_get_scope ((ValaSymbol*) _tmp498_);
							_tmp500_ = _tmp499_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp492_, _tmp500_);
							_tmp501_ = dynamic_object_type;
							_tmp502_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp501_);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_symbol_get_scope ((ValaSymbol*) _tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = prop;
							vala_scope_add (_tmp505_, NULL, (ValaSymbol*) _tmp506_);
							_tmp507_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp507_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp508_ = FALSE;
						gboolean _tmp509_ = FALSE;
						ValaCodeNode* _tmp510_;
						ValaCodeNode* _tmp511_;
						_tmp510_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp511_ = _tmp510_;
						if (VALA_IS_MEMBER_ACCESS (_tmp511_)) {
							ValaExpression* _tmp512_;
							ValaExpression* _tmp513_;
							_tmp512_ = vala_member_access_get_inner (self);
							_tmp513_ = _tmp512_;
							_tmp509_ = VALA_IS_MEMBER_ACCESS (_tmp513_);
						} else {
							_tmp509_ = FALSE;
						}
						if (_tmp509_) {
							ValaCodeNode* _tmp514_;
							ValaCodeNode* _tmp515_;
							ValaCodeNode* _tmp516_;
							ValaCodeNode* _tmp517_;
							_tmp514_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp515_ = _tmp514_;
							_tmp516_ = vala_code_node_get_parent_node (_tmp515_);
							_tmp517_ = _tmp516_;
							_tmp508_ = VALA_IS_METHOD_CALL (_tmp517_);
						} else {
							_tmp508_ = FALSE;
						}
						if (_tmp508_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp518_;
							ValaCodeNode* _tmp519_;
							gboolean _tmp520_ = FALSE;
							ValaMemberAccess* _tmp521_;
							const gchar* _tmp522_;
							_tmp518_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp519_ = _tmp518_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp519_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp521_ = ma;
							_tmp522_ = _tmp521_->priv->_member_name;
							if (g_strcmp0 (_tmp522_, "connect") == 0) {
								_tmp520_ = TRUE;
							} else {
								ValaMemberAccess* _tmp523_;
								const gchar* _tmp524_;
								_tmp523_ = ma;
								_tmp524_ = _tmp523_->priv->_member_name;
								_tmp520_ = g_strcmp0 (_tmp524_, "connect_after") == 0;
							}
							if (_tmp520_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp525_;
								ValaExpression* _tmp526_;
								ValaDataType* _tmp527_;
								ValaDataType* _tmp528_;
								const gchar* _tmp529_;
								ValaVoidType* _tmp530_;
								ValaVoidType* _tmp531_;
								ValaSourceReference* _tmp532_;
								ValaSourceReference* _tmp533_;
								ValaDynamicSignal* _tmp534_;
								ValaDynamicSignal* _tmp535_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp536_;
								ValaCodeNode* _tmp537_;
								ValaCodeNode* _tmp538_;
								ValaCodeNode* _tmp539_;
								ValaMethodCall* _tmp540_;
								ValaMethodCall* _tmp541_;
								ValaList* _tmp542_;
								gint _tmp543_;
								gint _tmp544_;
								ValaDynamicSignal* _tmp576_;
								ValaObjectType* _tmp577_;
								ValaTypeSymbol* _tmp578_;
								ValaTypeSymbol* _tmp579_;
								ValaScope* _tmp580_;
								ValaScope* _tmp581_;
								ValaDynamicSignal* _tmp582_;
								ValaDynamicSignal* _tmp583_;
								_tmp525_ = vala_member_access_get_inner (self);
								_tmp526_ = _tmp525_;
								_tmp527_ = vala_expression_get_value_type (_tmp526_);
								_tmp528_ = _tmp527_;
								_tmp529_ = self->priv->_member_name;
								_tmp530_ = vala_void_type_new (NULL);
								_tmp531_ = _tmp530_;
								_tmp532_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp533_ = _tmp532_;
								_tmp534_ = vala_dynamic_signal_new (_tmp528_, _tmp529_, (ValaDataType*) _tmp531_, _tmp533_, NULL);
								_tmp535_ = _tmp534_;
								_vala_code_node_unref0 (_tmp531_);
								s = _tmp535_;
								_tmp536_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp537_ = _tmp536_;
								_tmp538_ = vala_code_node_get_parent_node (_tmp537_);
								_tmp539_ = _tmp538_;
								_tmp540_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp540_;
								_tmp541_ = mcall;
								_tmp542_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp541_);
								_tmp543_ = vala_collection_get_size ((ValaCollection*) _tmp542_);
								_tmp544_ = _tmp543_;
								if (_tmp544_ > 0) {
									ValaDynamicSignal* _tmp545_;
									ValaMethodCall* _tmp546_;
									ValaList* _tmp547_;
									gpointer _tmp548_;
									ValaExpression* _tmp549_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp550_;
									ValaExpression* _tmp551_;
									ValaExpression* _tmp552_;
									gboolean _tmp553_ = FALSE;
									gboolean _tmp554_ = FALSE;
									ValaMemberAccess* _tmp555_;
									_tmp545_ = s;
									_tmp546_ = mcall;
									_tmp547_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) _tmp546_);
									_tmp548_ = vala_list_get (_tmp547_, 0);
									_tmp549_ = (ValaExpression*) _tmp548_;
									vala_dynamic_signal_set_handler (_tmp545_, _tmp549_);
									_vala_code_node_unref0 (_tmp549_);
									_tmp550_ = s;
									_tmp551_ = vala_dynamic_signal_get_handler (_tmp550_);
									_tmp552_ = _tmp551_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp552_) ? ((ValaMemberAccess*) _tmp552_) : NULL;
									_tmp555_ = arg;
									if (_tmp555_ == NULL) {
										_tmp554_ = TRUE;
									} else {
										ValaMemberAccess* _tmp556_;
										_tmp556_ = arg;
										_tmp554_ = !vala_code_node_check ((ValaCodeNode*) _tmp556_, context);
									}
									if (_tmp554_) {
										_tmp553_ = TRUE;
									} else {
										ValaMemberAccess* _tmp557_;
										ValaSymbol* _tmp558_;
										ValaSymbol* _tmp559_;
										_tmp557_ = arg;
										_tmp558_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp557_);
										_tmp559_ = _tmp558_;
										_tmp553_ = !VALA_IS_METHOD (_tmp559_);
									}
									if (_tmp553_) {
										ValaDynamicSignal* _tmp560_;
										ValaExpression* _tmp561_;
										ValaExpression* _tmp562_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp560_ = s;
										_tmp561_ = vala_dynamic_signal_get_handler (_tmp560_);
										_tmp562_ = _tmp561_;
										if (VALA_IS_LAMBDA_EXPRESSION (_tmp562_)) {
											ValaDynamicSignal* _tmp563_;
											ValaExpression* _tmp564_;
											ValaExpression* _tmp565_;
											ValaSourceReference* _tmp566_;
											ValaSourceReference* _tmp567_;
											_tmp563_ = s;
											_tmp564_ = vala_dynamic_signal_get_handler (_tmp563_);
											_tmp565_ = _tmp564_;
											_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp565_);
											_tmp567_ = _tmp566_;
											vala_report_error (_tmp567_, "Lambdas are not allowed for dynamic signals");
										} else {
											ValaDynamicSignal* _tmp568_;
											ValaExpression* _tmp569_;
											ValaExpression* _tmp570_;
											ValaSourceReference* _tmp571_;
											ValaSourceReference* _tmp572_;
											ValaDynamicSignal* _tmp573_;
											gchar* _tmp574_;
											gchar* _tmp575_;
											_tmp568_ = s;
											_tmp569_ = vala_dynamic_signal_get_handler (_tmp568_);
											_tmp570_ = _tmp569_;
											_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp570_);
											_tmp572_ = _tmp571_;
											_tmp573_ = s;
											_tmp574_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp573_);
											_tmp575_ = _tmp574_;
											vala_report_error (_tmp572_, "Cannot infer call signature for dynamic signal `%s' from given express" \
"ion", _tmp575_);
											_g_free0 (_tmp575_);
										}
									}
								}
								_tmp576_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp576_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp577_ = dynamic_object_type;
								_tmp578_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp577_);
								_tmp579_ = _tmp578_;
								_tmp580_ = vala_symbol_get_scope ((ValaSymbol*) _tmp579_);
								_tmp581_ = _tmp580_;
								_tmp582_ = s;
								vala_scope_add (_tmp581_, NULL, (ValaSymbol*) _tmp582_);
								_tmp583_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp583_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							} else {
								ValaMemberAccess* _tmp584_;
								const gchar* _tmp585_;
								_tmp584_ = ma;
								_tmp585_ = _tmp584_->priv->_member_name;
								if (g_strcmp0 (_tmp585_, "disconnect") == 0) {
									ValaMemberAccess* _tmp586_;
									ValaSourceReference* _tmp587_;
									ValaSourceReference* _tmp588_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp586_ = ma;
									_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
									_tmp588_ = _tmp587_;
									vala_report_error (_tmp588_, "Use SignalHandler.disconnect() to disconnect from dynamic signal");
								}
							}
						}
					}
				}
				_tmp589_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp590_ = _tmp589_;
				if (_tmp590_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp591_;
					ValaExpression* _tmp592_;
					ValaDataType* _tmp593_;
					ValaDataType* _tmp594_;
					const gchar* _tmp595_;
					ValaSourceReference* _tmp596_;
					ValaSourceReference* _tmp597_;
					ValaDynamicProperty* _tmp598_;
					ValaDataType* _tmp599_;
					ValaDataType* _tmp600_;
					ValaDynamicProperty* _tmp611_;
					ValaDynamicProperty* _tmp612_;
					ValaDynamicProperty* _tmp613_;
					ValaDataType* _tmp614_;
					ValaDataType* _tmp615_;
					ValaDataType* _tmp616_;
					ValaDataType* _tmp617_;
					ValaDynamicProperty* _tmp618_;
					ValaSourceReference* _tmp619_;
					ValaSourceReference* _tmp620_;
					ValaPropertyAccessor* _tmp621_;
					ValaPropertyAccessor* _tmp622_;
					ValaDynamicProperty* _tmp623_;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaDataType* _tmp626_;
					ValaDataType* _tmp627_;
					ValaTypeSymbol* _tmp628_;
					ValaTypeSymbol* _tmp629_;
					ValaScope* _tmp630_;
					ValaScope* _tmp631_;
					ValaObjectType* _tmp632_;
					ValaTypeSymbol* _tmp633_;
					ValaTypeSymbol* _tmp634_;
					ValaScope* _tmp635_;
					ValaScope* _tmp636_;
					ValaDynamicProperty* _tmp637_;
					ValaDynamicProperty* _tmp638_;
					_tmp591_ = vala_member_access_get_inner (self);
					_tmp592_ = _tmp591_;
					_tmp593_ = vala_expression_get_value_type (_tmp592_);
					_tmp594_ = _tmp593_;
					_tmp595_ = self->priv->_member_name;
					_tmp596_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp597_ = _tmp596_;
					_tmp598_ = vala_dynamic_property_new (_tmp594_, _tmp595_, _tmp597_, NULL);
					prop = _tmp598_;
					_tmp599_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp600_ = _tmp599_;
					if (_tmp600_ != NULL) {
						ValaDynamicProperty* _tmp601_;
						ValaDataType* _tmp602_;
						ValaDataType* _tmp603_;
						_tmp601_ = prop;
						_tmp602_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp603_ = _tmp602_;
						vala_property_set_property_type ((ValaProperty*) _tmp601_, _tmp603_);
					} else {
						ValaDynamicProperty* _tmp604_;
						ValaExpression* _tmp605_;
						ValaExpression* _tmp606_;
						ValaDataType* _tmp607_;
						ValaDataType* _tmp608_;
						ValaDataType* _tmp609_;
						ValaDataType* _tmp610_;
						_tmp604_ = prop;
						_tmp605_ = vala_member_access_get_inner (self);
						_tmp606_ = _tmp605_;
						_tmp607_ = vala_expression_get_value_type (_tmp606_);
						_tmp608_ = _tmp607_;
						_tmp609_ = vala_data_type_copy (_tmp608_);
						_tmp610_ = _tmp609_;
						vala_property_set_property_type ((ValaProperty*) _tmp604_, _tmp610_);
						_vala_code_node_unref0 (_tmp610_);
					}
					_tmp611_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp611_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp612_ = prop;
					_tmp613_ = prop;
					_tmp614_ = vala_property_get_property_type ((ValaProperty*) _tmp613_);
					_tmp615_ = _tmp614_;
					_tmp616_ = vala_data_type_copy (_tmp615_);
					_tmp617_ = _tmp616_;
					_tmp618_ = prop;
					_tmp619_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp618_);
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp617_, NULL, _tmp620_, NULL);
					_tmp622_ = _tmp621_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp612_, _tmp622_);
					_vala_code_node_unref0 (_tmp622_);
					_vala_code_node_unref0 (_tmp617_);
					_tmp623_ = prop;
					_tmp624_ = vala_member_access_get_inner (self);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_expression_get_value_type (_tmp625_);
					_tmp627_ = _tmp626_;
					_tmp628_ = vala_data_type_get_type_symbol (_tmp627_);
					_tmp629_ = _tmp628_;
					_tmp630_ = vala_symbol_get_scope ((ValaSymbol*) _tmp629_);
					_tmp631_ = _tmp630_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp623_, _tmp631_);
					_tmp632_ = dynamic_object_type;
					_tmp633_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp632_);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_symbol_get_scope ((ValaSymbol*) _tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = prop;
					vala_scope_add (_tmp636_, NULL, (ValaSymbol*) _tmp637_);
					_tmp638_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp638_);
					_vala_code_node_unref0 (prop);
				}
				_tmp639_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp640_ = _tmp639_;
				if (_tmp640_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp641_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp642_ = _tmp641_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp642_)) {
				ValaExpression* _tmp643_;
				ValaExpression* _tmp644_;
				ValaSymbol* _tmp645_;
				ValaSymbol* _tmp646_;
				_tmp643_ = vala_member_access_get_inner (self);
				_tmp644_ = _tmp643_;
				_tmp645_ = vala_expression_get_symbol_reference (_tmp644_);
				_tmp646_ = _tmp645_;
				if (VALA_IS_VARIABLE (_tmp646_)) {
					ValaArrayType* inner_type = NULL;
					ValaSemanticAnalyzer* _tmp647_;
					ValaSemanticAnalyzer* _tmp648_;
					ValaExpression* _tmp649_;
					ValaExpression* _tmp650_;
					ValaSymbol* _tmp651_;
					ValaSymbol* _tmp652_;
					ValaDataType* _tmp653_;
					ValaArrayType* _tmp654_;
					gboolean _tmp655_ = FALSE;
					ValaArrayType* _tmp656_;
					_tmp647_ = vala_code_context_get_analyzer (context);
					_tmp648_ = _tmp647_;
					_tmp649_ = vala_member_access_get_inner (self);
					_tmp650_ = _tmp649_;
					_tmp651_ = vala_expression_get_symbol_reference (_tmp650_);
					_tmp652_ = _tmp651_;
					_tmp653_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp648_, _tmp652_, TRUE);
					_tmp654_ = VALA_IS_ARRAY_TYPE (_tmp653_) ? ((ValaArrayType*) _tmp653_) : NULL;
					if (_tmp654_ == NULL) {
						_vala_code_node_unref0 (_tmp653_);
					}
					inner_type = _tmp654_;
					_tmp656_ = inner_type;
					if (_tmp656_ != NULL) {
						ValaArrayType* _tmp657_;
						gboolean _tmp658_;
						gboolean _tmp659_;
						_tmp657_ = inner_type;
						_tmp658_ = vala_array_type_get_inline_allocated (_tmp657_);
						_tmp659_ = _tmp658_;
						_tmp655_ = _tmp659_;
					} else {
						_tmp655_ = FALSE;
					}
					if (_tmp655_) {
						ValaSourceReference* _tmp660_;
						ValaSourceReference* _tmp661_;
						_tmp660_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp661_ = _tmp660_;
						vala_report_error (_tmp661_, "`resize' is not supported for arrays with fixed length");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					} else {
						gboolean _tmp662_ = FALSE;
						ValaArrayType* _tmp663_;
						_tmp663_ = inner_type;
						if (_tmp663_ != NULL) {
							ValaArrayType* _tmp664_;
							gboolean _tmp665_;
							gboolean _tmp666_;
							_tmp664_ = inner_type;
							_tmp665_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp664_);
							_tmp666_ = _tmp665_;
							_tmp662_ = !_tmp666_;
						} else {
							_tmp662_ = FALSE;
						}
						if (_tmp662_) {
							ValaSourceReference* _tmp667_;
							ValaSourceReference* _tmp668_;
							_tmp667_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp668_ = _tmp667_;
							vala_report_error (_tmp668_, "`resize' is not allowed for unowned array references");
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						}
					}
					_vala_code_node_unref0 (inner_type);
				} else {
					ValaExpression* _tmp669_;
					ValaExpression* _tmp670_;
					ValaSymbol* _tmp671_;
					ValaSymbol* _tmp672_;
					_tmp669_ = vala_member_access_get_inner (self);
					_tmp670_ = _tmp669_;
					_tmp671_ = vala_expression_get_symbol_reference (_tmp670_);
					_tmp672_ = _tmp671_;
					if (VALA_IS_CONSTANT (_tmp672_)) {
						ValaSourceReference* _tmp673_;
						ValaSourceReference* _tmp674_;
						_tmp673_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp674_ = _tmp673_;
						vala_report_error (_tmp674_, "`resize' is not allowed for constant arrays");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
			}
		}
	}
	_tmp678_ = vala_member_access_get_inner (self);
	_tmp679_ = _tmp678_;
	if (_tmp679_ == NULL) {
		ValaSymbol* _tmp680_;
		ValaSymbol* _tmp681_;
		_tmp680_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp681_ = _tmp680_;
		_tmp677_ = _tmp681_ == NULL;
	} else {
		_tmp677_ = FALSE;
	}
	if (_tmp677_) {
		ValaDataType* _tmp682_;
		ValaDataType* _tmp683_;
		_tmp682_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp683_ = _tmp682_;
		_tmp676_ = _tmp683_ != NULL;
	} else {
		_tmp676_ = FALSE;
	}
	if (_tmp676_) {
		ValaDataType* _tmp684_;
		ValaDataType* _tmp685_;
		ValaTypeSymbol* _tmp686_;
		ValaTypeSymbol* _tmp687_;
		_tmp684_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp685_ = _tmp684_;
		_tmp686_ = vala_data_type_get_type_symbol (_tmp685_);
		_tmp687_ = _tmp686_;
		_tmp675_ = VALA_IS_ENUM (_tmp687_);
	} else {
		_tmp675_ = FALSE;
	}
	if (_tmp675_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp688_;
		ValaDataType* _tmp689_;
		ValaTypeSymbol* _tmp690_;
		ValaTypeSymbol* _tmp691_;
		_tmp688_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp689_ = _tmp688_;
		_tmp690_ = vala_data_type_get_type_symbol (_tmp689_);
		_tmp691_ = _tmp690_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp691_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp692_;
			ValaList* _tmp693_;
			gint _val_size = 0;
			ValaList* _tmp694_;
			gint _tmp695_;
			gint _tmp696_;
			gint _val_index = 0;
			_tmp692_ = enum_type;
			_tmp693_ = vala_enum_get_values (_tmp692_);
			_val_list = _tmp693_;
			_tmp694_ = _val_list;
			_tmp695_ = vala_collection_get_size ((ValaCollection*) _tmp694_);
			_tmp696_ = _tmp695_;
			_val_size = _tmp696_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp697_;
				gint _tmp698_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp699_;
				gpointer _tmp700_;
				const gchar* _tmp701_;
				ValaEnumValue* _tmp702_;
				const gchar* _tmp703_;
				const gchar* _tmp704_;
				_val_index = _val_index + 1;
				_tmp697_ = _val_index;
				_tmp698_ = _val_size;
				if (!(_tmp697_ < _tmp698_)) {
					break;
				}
				_tmp699_ = _val_list;
				_tmp700_ = vala_list_get (_tmp699_, _val_index);
				val = (ValaEnumValue*) _tmp700_;
				_tmp701_ = self->priv->_member_name;
				_tmp702_ = val;
				_tmp703_ = vala_symbol_get_name ((ValaSymbol*) _tmp702_);
				_tmp704_ = _tmp703_;
				if (g_strcmp0 (_tmp701_, _tmp704_) == 0) {
					ValaEnumValue* _tmp705_;
					_tmp705_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp705_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
		}
	}
	_tmp706_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp707_ = _tmp706_;
	if (_tmp707_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp708_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp709_ = FALSE;
		ValaExpression* _tmp710_;
		ValaExpression* _tmp711_;
		gchar* base_type_package = NULL;
		gchar* _tmp731_;
		gboolean _tmp732_ = FALSE;
		ValaSymbol* _tmp733_;
		gchar* visited_types_string = NULL;
		gchar* _tmp748_;
		ValaSourceReference* _tmp764_;
		ValaSourceReference* _tmp765_;
		const gchar* _tmp766_;
		const gchar* _tmp767_;
		const gchar* _tmp768_;
		const gchar* _tmp769_;
		ValaInvalidType* _tmp770_;
		ValaInvalidType* _tmp771_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp708_ = g_strdup ("(null)");
		base_type_name = _tmp708_;
		base_type = NULL;
		_tmp710_ = vala_member_access_get_inner (self);
		_tmp711_ = _tmp710_;
		if (_tmp711_ != NULL) {
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			ValaDataType* _tmp714_;
			ValaDataType* _tmp715_;
			_tmp712_ = vala_member_access_get_inner (self);
			_tmp713_ = _tmp712_;
			_tmp714_ = vala_expression_get_value_type (_tmp713_);
			_tmp715_ = _tmp714_;
			_tmp709_ = _tmp715_ != NULL;
		} else {
			_tmp709_ = FALSE;
		}
		if (_tmp709_) {
			ValaExpression* _tmp716_;
			ValaExpression* _tmp717_;
			ValaDataType* _tmp718_;
			ValaDataType* _tmp719_;
			gchar* _tmp720_;
			ValaExpression* _tmp721_;
			ValaExpression* _tmp722_;
			ValaDataType* _tmp723_;
			ValaDataType* _tmp724_;
			ValaTypeSymbol* _tmp725_;
			ValaTypeSymbol* _tmp726_;
			_tmp716_ = vala_member_access_get_inner (self);
			_tmp717_ = _tmp716_;
			_tmp718_ = vala_expression_get_value_type (_tmp717_);
			_tmp719_ = _tmp718_;
			_tmp720_ = vala_code_node_to_string ((ValaCodeNode*) _tmp719_);
			_g_free0 (base_type_name);
			base_type_name = _tmp720_;
			_tmp721_ = vala_member_access_get_inner (self);
			_tmp722_ = _tmp721_;
			_tmp723_ = vala_expression_get_value_type (_tmp722_);
			_tmp724_ = _tmp723_;
			_tmp725_ = vala_data_type_get_type_symbol (_tmp724_);
			_tmp726_ = _tmp725_;
			base_type = (ValaSymbol*) _tmp726_;
		} else {
			ValaSymbol* _tmp727_;
			_tmp727_ = base_symbol;
			if (_tmp727_ != NULL) {
				ValaSymbol* _tmp728_;
				gchar* _tmp729_;
				ValaSymbol* _tmp730_;
				_tmp728_ = base_symbol;
				_tmp729_ = vala_symbol_get_full_name (_tmp728_);
				_g_free0 (base_type_name);
				base_type_name = _tmp729_;
				_tmp730_ = base_symbol;
				base_type = _tmp730_;
			}
		}
		_tmp731_ = g_strdup ("");
		base_type_package = _tmp731_;
		_tmp733_ = base_type;
		if (_tmp733_ != NULL) {
			ValaSymbol* _tmp734_;
			gboolean _tmp735_;
			gboolean _tmp736_;
			_tmp734_ = base_type;
			_tmp735_ = vala_symbol_get_external_package (_tmp734_);
			_tmp736_ = _tmp735_;
			_tmp732_ = _tmp736_;
		} else {
			_tmp732_ = FALSE;
		}
		if (_tmp732_) {
			ValaSymbol* _tmp737_;
			ValaSourceReference* _tmp738_;
			ValaSourceReference* _tmp739_;
			ValaSourceFile* _tmp740_;
			ValaSourceFile* _tmp741_;
			const gchar* _tmp742_;
			const gchar* _tmp743_;
			gchar* _tmp744_;
			const gchar* _tmp745_;
			_tmp737_ = base_symbol;
			_tmp738_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp737_);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_source_reference_get_file (_tmp739_);
			_tmp741_ = _tmp740_;
			_tmp742_ = vala_source_file_get_package_name (_tmp741_);
			_tmp743_ = _tmp742_;
			_tmp744_ = g_strdup (_tmp743_);
			_g_free0 (base_type_package);
			base_type_package = _tmp744_;
			_tmp745_ = base_type_package;
			if (_tmp745_ != NULL) {
				const gchar* _tmp746_;
				gchar* _tmp747_;
				_tmp746_ = base_type_package;
				_tmp747_ = g_strdup_printf (" (%s)", _tmp746_);
				_g_free0 (base_type_package);
				base_type_package = _tmp747_;
			}
		}
		_tmp748_ = g_strdup ("");
		visited_types_string = _tmp748_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp749_;
			gint _type_size = 0;
			ValaArrayList* _tmp750_;
			gint _tmp751_;
			gint _tmp752_;
			gint _type_index = 0;
			_tmp749_ = visited_types;
			_type_list = _tmp749_;
			_tmp750_ = _type_list;
			_tmp751_ = vala_collection_get_size ((ValaCollection*) _tmp750_);
			_tmp752_ = _tmp751_;
			_type_size = _tmp752_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp753_;
				gint _tmp754_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp755_;
				gpointer _tmp756_;
				const gchar* _tmp757_;
				ValaDataType* _tmp758_;
				gchar* _tmp759_;
				gchar* _tmp760_;
				gchar* _tmp761_;
				gchar* _tmp762_;
				gchar* _tmp763_;
				_type_index = _type_index + 1;
				_tmp753_ = _type_index;
				_tmp754_ = _type_size;
				if (!(_tmp753_ < _tmp754_)) {
					break;
				}
				_tmp755_ = _type_list;
				_tmp756_ = vala_list_get ((ValaList*) _tmp755_, _type_index);
				type = (ValaDataType*) _tmp756_;
				_tmp757_ = visited_types_string;
				_tmp758_ = type;
				_tmp759_ = vala_code_node_to_string ((ValaCodeNode*) _tmp758_);
				_tmp760_ = _tmp759_;
				_tmp761_ = g_strdup_printf (" or `%s'", _tmp760_);
				_tmp762_ = _tmp761_;
				_tmp763_ = g_strconcat (_tmp757_, _tmp762_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp763_;
				_g_free0 (_tmp762_);
				_g_free0 (_tmp760_);
				_vala_code_node_unref0 (type);
			}
		}
		_tmp764_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp765_ = _tmp764_;
		_tmp766_ = self->priv->_member_name;
		_tmp767_ = base_type_name;
		_tmp768_ = base_type_package;
		_tmp769_ = visited_types_string;
		vala_report_error (_tmp765_, "The name `%s' does not exist in the context of `%s'%s%s", _tmp766_, _tmp767_, _tmp768_, _tmp769_);
		_tmp770_ = vala_invalid_type_new ();
		_tmp771_ = _tmp770_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp771_);
		_vala_code_node_unref0 (_tmp771_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp772_;
		ValaSymbol* _tmp773_;
		gboolean _tmp774_;
		gboolean _tmp775_;
		_tmp772_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp773_ = _tmp772_;
		_tmp774_ = vala_code_node_get_error ((ValaCodeNode*) _tmp773_);
		_tmp775_ = _tmp774_;
		if (_tmp775_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp776_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp777_ = _tmp776_;
	if (VALA_IS_SIGNAL (_tmp777_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp778_;
		ValaSymbol* _tmp779_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp786_;
		ValaCodeNode* _tmp787_;
		ValaCodeNode* _tmp788_;
		gboolean _tmp789_ = FALSE;
		gboolean _tmp790_ = FALSE;
		gboolean _tmp791_ = FALSE;
		ValaCodeNode* _tmp792_;
		_tmp778_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp779_ = _tmp778_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp779_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp780_;
			ValaCodeNode* _tmp781_;
			ValaCodeNode* _tmp782_;
			ValaCodeNode* _tmp783_;
			ValaCodeNode* _tmp784_;
			ValaCodeNode* _tmp785_;
			_tmp780_ = ma;
			_tmp781_ = vala_code_node_get_parent_node (_tmp780_);
			_tmp782_ = _tmp781_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp782_)) {
				break;
			}
			_tmp783_ = ma;
			_tmp784_ = vala_code_node_get_parent_node (_tmp783_);
			_tmp785_ = _tmp784_;
			ma = _tmp785_;
		}
		_tmp786_ = ma;
		_tmp787_ = vala_code_node_get_parent_node (_tmp786_);
		_tmp788_ = _tmp787_;
		parent = _tmp788_;
		_tmp792_ = parent;
		if (_tmp792_ != NULL) {
			ValaCodeNode* _tmp793_;
			_tmp793_ = parent;
			_tmp791_ = !VALA_IS_ELEMENT_ACCESS (_tmp793_);
		} else {
			_tmp791_ = FALSE;
		}
		if (_tmp791_) {
			ValaCodeNode* _tmp794_;
			ValaExpression* _tmp795_;
			ValaExpression* _tmp796_;
			_tmp794_ = ma;
			_tmp795_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp796_ = _tmp795_;
			_tmp790_ = !VALA_IS_BASE_ACCESS (_tmp796_);
		} else {
			_tmp790_ = FALSE;
		}
		if (_tmp790_) {
			gboolean _tmp797_ = FALSE;
			ValaCodeNode* _tmp798_;
			_tmp798_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp798_)) {
				_tmp797_ = TRUE;
			} else {
				ValaCodeNode* _tmp799_;
				ValaList* _tmp800_;
				_tmp799_ = parent;
				_tmp800_ = vala_callable_expression_get_argument_list ((ValaCallableExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp799_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp797_ = vala_collection_contains ((ValaCollection*) _tmp800_, (ValaExpression*) self);
			}
			_tmp789_ = _tmp797_;
		} else {
			_tmp789_ = FALSE;
		}
		if (_tmp789_) {
			ValaSignal* _tmp801_;
			ValaAttribute* _tmp802_;
			_tmp801_ = sig;
			_tmp802_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp801_, "HasEmitter");
			if (_tmp802_ != NULL) {
				ValaSignal* _tmp803_;
				ValaSignal* _tmp804_;
				ValaMethod* _tmp805_;
				ValaMethod* _tmp806_;
				_tmp803_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp803_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp804_ = sig;
				_tmp805_ = vala_signal_get_emitter (_tmp804_);
				_tmp806_ = _tmp805_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp806_);
			} else {
				ValaSourceReference* _tmp807_;
				ValaSourceReference* _tmp808_;
				ValaSymbol* _tmp809_;
				ValaSymbol* _tmp810_;
				gchar* _tmp811_;
				gchar* _tmp812_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp807_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp808_ = _tmp807_;
				_tmp809_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp810_ = _tmp809_;
				_tmp811_ = vala_symbol_get_full_name (_tmp810_);
				_tmp812_ = _tmp811_;
				vala_report_error (_tmp808_, "Signal `%s' requires emitter in this context", _tmp812_);
				_g_free0 (_tmp812_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp813_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp814_ = _tmp813_;
	member = _tmp814_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp815_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp815_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp816_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp816_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp817_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp818_;
		ValaSymbol* _tmp819_;
		ValaSymbol* _tmp820_;
		gboolean _tmp821_ = FALSE;
		ValaBlock* _tmp822_;
		_tmp817_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp817_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp818_ = local;
		_tmp819_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp818_);
		_tmp820_ = _tmp819_;
		block = VALA_IS_BLOCK (_tmp820_) ? ((ValaBlock*) _tmp820_) : NULL;
		_tmp822_ = block;
		if (_tmp822_ != NULL) {
			ValaBlock* _tmp823_;
			ValaSymbol* _tmp824_;
			ValaSemanticAnalyzer* _tmp825_;
			ValaSemanticAnalyzer* _tmp826_;
			ValaSymbol* _tmp827_;
			ValaSymbol* _tmp828_;
			_tmp823_ = block;
			_tmp824_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp823_);
			_tmp825_ = vala_code_context_get_analyzer (context);
			_tmp826_ = _tmp825_;
			_tmp827_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp826_);
			_tmp828_ = _tmp827_;
			_tmp821_ = _tmp824_ != _tmp828_;
		} else {
			_tmp821_ = FALSE;
		}
		if (_tmp821_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp829_;
			ValaSemanticAnalyzer* _tmp830_;
			ValaSymbol* _tmp831_;
			ValaSymbol* _tmp832_;
			ValaLocalVariable* _tmp843_;
			ValaBlock* _tmp844_;
			ValaLocalVariable* _tmp845_;
			ValaDataType* _tmp846_;
			ValaDataType* _tmp847_;
			ValaTypeSymbol* _tmp848_;
			ValaTypeSymbol* _tmp849_;
			ValaSemanticAnalyzer* _tmp850_;
			ValaSemanticAnalyzer* _tmp851_;
			ValaDataType* _tmp852_;
			ValaTypeSymbol* _tmp853_;
			ValaTypeSymbol* _tmp854_;
			_tmp829_ = vala_code_context_get_analyzer (context);
			_tmp830_ = _tmp829_;
			_tmp831_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp830_);
			_tmp832_ = _tmp831_;
			sym = _tmp832_;
			while (TRUE) {
				ValaSymbol* _tmp833_;
				ValaBlock* _tmp834_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp835_;
				ValaMethod* _tmp836_;
				ValaSymbol* _tmp840_;
				ValaSymbol* _tmp841_;
				ValaSymbol* _tmp842_;
				_tmp833_ = sym;
				_tmp834_ = block;
				if (!(_tmp833_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp834_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp835_ = sym;
				method = VALA_IS_METHOD (_tmp835_) ? ((ValaMethod*) _tmp835_) : NULL;
				_tmp836_ = method;
				if (_tmp836_ != NULL) {
					ValaMethod* _tmp837_;
					ValaMethod* _tmp838_;
					ValaLocalVariable* _tmp839_;
					_tmp837_ = method;
					vala_method_set_closure (_tmp837_, TRUE);
					_tmp838_ = method;
					_tmp839_ = local;
					vala_method_add_captured_variable (_tmp838_, _tmp839_);
				}
				_tmp840_ = sym;
				_tmp841_ = vala_symbol_get_parent_symbol (_tmp840_);
				_tmp842_ = _tmp841_;
				sym = _tmp842_;
			}
			_tmp843_ = local;
			vala_local_variable_set_captured (_tmp843_, TRUE);
			_tmp844_ = block;
			vala_block_set_captured (_tmp844_, TRUE);
			_tmp845_ = local;
			_tmp846_ = vala_variable_get_variable_type ((ValaVariable*) _tmp845_);
			_tmp847_ = _tmp846_;
			_tmp848_ = vala_data_type_get_type_symbol (_tmp847_);
			_tmp849_ = _tmp848_;
			_tmp850_ = vala_code_context_get_analyzer (context);
			_tmp851_ = _tmp850_;
			_tmp852_ = _tmp851_->va_list_type;
			_tmp853_ = vala_data_type_get_type_symbol (_tmp852_);
			_tmp854_ = _tmp853_;
			if (_tmp849_ == _tmp854_) {
				ValaSourceReference* _tmp855_;
				ValaSourceReference* _tmp856_;
				ValaLocalVariable* _tmp857_;
				gchar* _tmp858_;
				gchar* _tmp859_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp855_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp856_ = _tmp855_;
				_tmp857_ = local;
				_tmp858_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp857_);
				_tmp859_ = _tmp858_;
				vala_report_error (_tmp856_, "Capturing `va_list' variable `%s' is not allowed", _tmp859_);
				_g_free0 (_tmp859_);
			}
		}
	} else {
		ValaSymbol* _tmp860_;
		_tmp860_ = member;
		if (VALA_IS_PARAMETER (_tmp860_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp861_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp862_;
			ValaSymbol* _tmp863_;
			ValaSymbol* _tmp864_;
			gboolean _tmp865_ = FALSE;
			gboolean _tmp866_ = FALSE;
			ValaMethod* _tmp867_;
			_tmp861_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp861_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp862_ = param;
			_tmp863_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp862_);
			_tmp864_ = _tmp863_;
			m = VALA_IS_METHOD (_tmp864_) ? ((ValaMethod*) _tmp864_) : NULL;
			_tmp867_ = m;
			if (_tmp867_ != NULL) {
				ValaMethod* _tmp868_;
				ValaSemanticAnalyzer* _tmp869_;
				ValaSemanticAnalyzer* _tmp870_;
				ValaSymbol* _tmp871_;
				ValaSymbol* _tmp872_;
				_tmp868_ = m;
				_tmp869_ = vala_code_context_get_analyzer (context);
				_tmp870_ = _tmp869_;
				_tmp871_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp870_);
				_tmp872_ = _tmp871_;
				_tmp866_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp872_;
			} else {
				_tmp866_ = FALSE;
			}
			if (_tmp866_) {
				ValaParameter* _tmp873_;
				ValaMethod* _tmp874_;
				ValaParameter* _tmp875_;
				ValaParameter* _tmp876_;
				_tmp873_ = param;
				_tmp874_ = m;
				_tmp875_ = vala_method_get_this_parameter (_tmp874_);
				_tmp876_ = _tmp875_;
				_tmp865_ = _tmp873_ != _tmp876_;
			} else {
				_tmp865_ = FALSE;
			}
			if (_tmp865_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp877_;
				ValaSemanticAnalyzer* _tmp878_;
				ValaSymbol* _tmp879_;
				ValaSymbol* _tmp880_;
				ValaParameter* _tmp889_;
				ValaMethod* _tmp890_;
				ValaBlock* _tmp891_;
				ValaBlock* _tmp892_;
				ValaParameter* _tmp893_;
				ValaParameterDirection _tmp894_;
				ValaParameterDirection _tmp895_;
				ValaParameter* _tmp901_;
				ValaDataType* _tmp902_;
				ValaDataType* _tmp903_;
				ValaTypeSymbol* _tmp904_;
				ValaTypeSymbol* _tmp905_;
				ValaSemanticAnalyzer* _tmp906_;
				ValaSemanticAnalyzer* _tmp907_;
				ValaDataType* _tmp908_;
				ValaTypeSymbol* _tmp909_;
				ValaTypeSymbol* _tmp910_;
				_tmp877_ = vala_code_context_get_analyzer (context);
				_tmp878_ = _tmp877_;
				_tmp879_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp878_);
				_tmp880_ = _tmp879_;
				sym = _tmp880_;
				while (TRUE) {
					ValaSymbol* _tmp881_;
					ValaMethod* _tmp882_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp883_;
					ValaMethod* _tmp884_;
					ValaSymbol* _tmp886_;
					ValaSymbol* _tmp887_;
					ValaSymbol* _tmp888_;
					_tmp881_ = sym;
					_tmp882_ = m;
					if (!(_tmp881_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp882_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp883_ = sym;
					method = VALA_IS_METHOD (_tmp883_) ? ((ValaMethod*) _tmp883_) : NULL;
					_tmp884_ = method;
					if (_tmp884_ != NULL) {
						ValaMethod* _tmp885_;
						_tmp885_ = method;
						vala_method_set_closure (_tmp885_, TRUE);
					}
					_tmp886_ = sym;
					_tmp887_ = vala_symbol_get_parent_symbol (_tmp886_);
					_tmp888_ = _tmp887_;
					sym = _tmp888_;
				}
				_tmp889_ = param;
				vala_parameter_set_captured (_tmp889_, TRUE);
				_tmp890_ = m;
				_tmp891_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp890_);
				_tmp892_ = _tmp891_;
				vala_block_set_captured (_tmp892_, TRUE);
				_tmp893_ = param;
				_tmp894_ = vala_parameter_get_direction (_tmp893_);
				_tmp895_ = _tmp894_;
				if (_tmp895_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp896_;
					ValaSourceReference* _tmp897_;
					ValaParameter* _tmp898_;
					gchar* _tmp899_;
					gchar* _tmp900_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp896_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp897_ = _tmp896_;
					_tmp898_ = param;
					_tmp899_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp898_);
					_tmp900_ = _tmp899_;
					vala_report_error (_tmp897_, "Cannot capture reference or output parameter `%s'", _tmp900_);
					_g_free0 (_tmp900_);
				}
				_tmp901_ = param;
				_tmp902_ = vala_variable_get_variable_type ((ValaVariable*) _tmp901_);
				_tmp903_ = _tmp902_;
				_tmp904_ = vala_data_type_get_type_symbol (_tmp903_);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_code_context_get_analyzer (context);
				_tmp907_ = _tmp906_;
				_tmp908_ = _tmp907_->va_list_type;
				_tmp909_ = vala_data_type_get_type_symbol (_tmp908_);
				_tmp910_ = _tmp909_;
				if (_tmp905_ == _tmp910_) {
					ValaSourceReference* _tmp911_;
					ValaSourceReference* _tmp912_;
					ValaParameter* _tmp913_;
					gchar* _tmp914_;
					gchar* _tmp915_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp911_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp912_ = _tmp911_;
					_tmp913_ = param;
					_tmp914_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp913_);
					_tmp915_ = _tmp914_;
					vala_report_error (_tmp912_, "Capturing `va_list' parameter `%s' is not allowed", _tmp915_);
					_g_free0 (_tmp915_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp916_;
				ValaSymbol* _tmp917_;
				ValaSymbol* _tmp918_;
				ValaSymbol* _tmp919_;
				ValaSymbol* _tmp920_;
				gboolean _tmp921_ = FALSE;
				gboolean _tmp922_ = FALSE;
				ValaPropertyAccessor* _tmp923_;
				_tmp916_ = param;
				_tmp917_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp916_);
				_tmp918_ = _tmp917_;
				_tmp919_ = vala_symbol_get_parent_symbol (_tmp918_);
				_tmp920_ = _tmp919_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp920_) ? ((ValaPropertyAccessor*) _tmp920_) : NULL;
				_tmp923_ = acc;
				if (_tmp923_ != NULL) {
					ValaPropertyAccessor* _tmp924_;
					ValaSemanticAnalyzer* _tmp925_;
					ValaSemanticAnalyzer* _tmp926_;
					ValaSymbol* _tmp927_;
					ValaSymbol* _tmp928_;
					_tmp924_ = acc;
					_tmp925_ = vala_code_context_get_analyzer (context);
					_tmp926_ = _tmp925_;
					_tmp927_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp926_);
					_tmp928_ = _tmp927_;
					_tmp922_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp924_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp928_;
				} else {
					_tmp922_ = FALSE;
				}
				if (_tmp922_) {
					ValaParameter* _tmp929_;
					ValaPropertyAccessor* _tmp930_;
					ValaProperty* _tmp931_;
					ValaProperty* _tmp932_;
					ValaParameter* _tmp933_;
					ValaParameter* _tmp934_;
					_tmp929_ = param;
					_tmp930_ = acc;
					_tmp931_ = vala_property_accessor_get_prop (_tmp930_);
					_tmp932_ = _tmp931_;
					_tmp933_ = vala_property_get_this_parameter (_tmp932_);
					_tmp934_ = _tmp933_;
					_tmp921_ = _tmp929_ != _tmp934_;
				} else {
					_tmp921_ = FALSE;
				}
				if (_tmp921_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp935_;
					ValaSemanticAnalyzer* _tmp936_;
					ValaSymbol* _tmp937_;
					ValaSymbol* _tmp938_;
					ValaParameter* _tmp947_;
					ValaPropertyAccessor* _tmp948_;
					ValaBlock* _tmp949_;
					ValaBlock* _tmp950_;
					_tmp935_ = vala_code_context_get_analyzer (context);
					_tmp936_ = _tmp935_;
					_tmp937_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp936_);
					_tmp938_ = _tmp937_;
					sym = _tmp938_;
					while (TRUE) {
						ValaSymbol* _tmp939_;
						ValaMethod* _tmp940_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp941_;
						ValaMethod* _tmp942_;
						ValaSymbol* _tmp944_;
						ValaSymbol* _tmp945_;
						ValaSymbol* _tmp946_;
						_tmp939_ = sym;
						_tmp940_ = m;
						if (!(_tmp939_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp940_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp941_ = sym;
						method = VALA_IS_METHOD (_tmp941_) ? ((ValaMethod*) _tmp941_) : NULL;
						_tmp942_ = method;
						if (_tmp942_ != NULL) {
							ValaMethod* _tmp943_;
							_tmp943_ = method;
							vala_method_set_closure (_tmp943_, TRUE);
						}
						_tmp944_ = sym;
						_tmp945_ = vala_symbol_get_parent_symbol (_tmp944_);
						_tmp946_ = _tmp945_;
						sym = _tmp946_;
					}
					_tmp947_ = param;
					vala_parameter_set_captured (_tmp947_, TRUE);
					_tmp948_ = acc;
					_tmp949_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp948_);
					_tmp950_ = _tmp949_;
					vala_block_set_captured (_tmp950_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp951_;
			_tmp951_ = member;
			if (VALA_IS_FIELD (_tmp951_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp952_;
				ValaField* _tmp953_;
				ValaSymbolAccessibility _tmp954_;
				ValaSymbolAccessibility _tmp955_;
				ValaField* _tmp956_;
				ValaMemberBinding _tmp957_;
				ValaMemberBinding _tmp958_;
				ValaField* _tmp959_;
				ValaMemberBinding _tmp960_;
				ValaMemberBinding _tmp961_;
				ValaField* _tmp962_;
				ValaDataType* _tmp963_;
				ValaDataType* _tmp964_;
				_tmp952_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp952_, VALA_TYPE_FIELD, ValaField);
				_tmp953_ = f;
				_tmp954_ = vala_symbol_get_access ((ValaSymbol*) _tmp953_);
				_tmp955_ = _tmp954_;
				access = _tmp955_;
				_tmp956_ = f;
				_tmp957_ = vala_field_get_binding (_tmp956_);
				_tmp958_ = _tmp957_;
				instance = _tmp958_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp959_ = f;
				_tmp960_ = vala_field_get_binding (_tmp959_);
				_tmp961_ = _tmp960_;
				klass = _tmp961_ == VALA_MEMBER_BINDING_CLASS;
				_tmp962_ = f;
				_tmp963_ = vala_variable_get_variable_type ((ValaVariable*) _tmp962_);
				_tmp964_ = _tmp963_;
				if (VALA_IS_GENERIC_TYPE (_tmp964_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp965_;
				_tmp965_ = member;
				if (VALA_IS_CONSTANT (_tmp965_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp966_;
					ValaConstant* _tmp967_;
					ValaSymbolAccessibility _tmp968_;
					ValaSymbolAccessibility _tmp969_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp970_;
					ValaSymbol* _tmp971_;
					ValaSymbol* _tmp972_;
					gboolean _tmp973_ = FALSE;
					ValaBlock* _tmp974_;
					_tmp966_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp966_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp967_ = c;
					_tmp968_ = vala_symbol_get_access ((ValaSymbol*) _tmp967_);
					_tmp969_ = _tmp968_;
					access = _tmp969_;
					_tmp970_ = c;
					_tmp971_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp970_);
					_tmp972_ = _tmp971_;
					block = VALA_IS_BLOCK (_tmp972_) ? ((ValaBlock*) _tmp972_) : NULL;
					_tmp974_ = block;
					if (_tmp974_ != NULL) {
						ValaBlock* _tmp975_;
						ValaSymbol* _tmp976_;
						ValaSemanticAnalyzer* _tmp977_;
						ValaSemanticAnalyzer* _tmp978_;
						ValaSymbol* _tmp979_;
						ValaSymbol* _tmp980_;
						_tmp975_ = block;
						_tmp976_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp975_);
						_tmp977_ = vala_code_context_get_analyzer (context);
						_tmp978_ = _tmp977_;
						_tmp979_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp978_);
						_tmp980_ = _tmp979_;
						_tmp973_ = _tmp976_ != _tmp980_;
					} else {
						_tmp973_ = FALSE;
					}
					if (_tmp973_) {
						ValaSourceReference* _tmp981_;
						ValaSourceReference* _tmp982_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp981_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp982_ = _tmp981_;
						vala_report_error (_tmp982_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp983_;
					_tmp983_ = member;
					if (VALA_IS_METHOD (_tmp983_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp984_;
						ValaMethod* _tmp985_;
						gboolean _tmp986_;
						gboolean _tmp987_;
						ValaMethod* _tmp1074_;
						ValaSymbolAccessibility _tmp1075_;
						ValaSymbolAccessibility _tmp1076_;
						ValaMethod* _tmp1077_;
						ValaMethod* _tmp1081_;
						ValaMemberBinding _tmp1082_;
						ValaMemberBinding _tmp1083_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1103_;
						ValaDataType* _tmp1104_;
						ValaDataType* _tmp1105_;
						gboolean _tmp1106_ = FALSE;
						ValaGenericType* _tmp1107_;
						_tmp984_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp984_, VALA_TYPE_METHOD, ValaMethod);
						_tmp985_ = m;
						_tmp986_ = vala_method_get_is_async_callback (_tmp985_);
						_tmp987_ = _tmp986_;
						if (_tmp987_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp988_;
							ValaSemanticAnalyzer* _tmp989_;
							ValaMethod* _tmp990_;
							ValaMethod* _tmp991_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp992_;
							ValaMethod* _tmp1019_;
							ValaSemanticAnalyzer* _tmp1020_;
							ValaSemanticAnalyzer* _tmp1021_;
							ValaMethod* _tmp1022_;
							ValaMethod* _tmp1023_;
							ValaMethod* _tmp1039_;
							ValaMethod* _tmp1040_;
							ValaMethod* _tmp1041_;
							ValaSymbol* _tmp1042_;
							ValaSymbol* _tmp1043_;
							_tmp988_ = vala_code_context_get_analyzer (context);
							_tmp989_ = _tmp988_;
							_tmp990_ = vala_semantic_analyzer_get_current_async_method (_tmp989_);
							_tmp991_ = _tmp990_;
							async_method = _tmp991_;
							is_valid_access = FALSE;
							_tmp992_ = async_method;
							if (_tmp992_ != NULL) {
								ValaMethod* _tmp993_;
								ValaMethod* _tmp994_;
								ValaMethod* _tmp995_;
								_tmp993_ = m;
								_tmp994_ = async_method;
								_tmp995_ = vala_method_get_callback_method (_tmp994_);
								if (_tmp993_ == _tmp995_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp996_ = FALSE;
									ValaMethod* _tmp997_;
									ValaMethod* _tmp998_;
									ValaMethod* _tmp999_;
									_tmp997_ = async_method;
									_tmp998_ = vala_method_get_base_method (_tmp997_);
									_tmp999_ = _tmp998_;
									if (_tmp999_ != NULL) {
										ValaMethod* _tmp1000_;
										ValaMethod* _tmp1001_;
										ValaMethod* _tmp1002_;
										ValaMethod* _tmp1003_;
										ValaMethod* _tmp1004_;
										_tmp1000_ = m;
										_tmp1001_ = async_method;
										_tmp1002_ = vala_method_get_base_method (_tmp1001_);
										_tmp1003_ = _tmp1002_;
										_tmp1004_ = vala_method_get_callback_method (_tmp1003_);
										_tmp996_ = _tmp1000_ == _tmp1004_;
									} else {
										_tmp996_ = FALSE;
									}
									if (_tmp996_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp1005_ = FALSE;
										ValaMethod* _tmp1006_;
										ValaMethod* _tmp1007_;
										ValaMethod* _tmp1008_;
										_tmp1006_ = async_method;
										_tmp1007_ = vala_method_get_base_interface_method (_tmp1006_);
										_tmp1008_ = _tmp1007_;
										if (_tmp1008_ != NULL) {
											ValaMethod* _tmp1009_;
											ValaMethod* _tmp1010_;
											ValaMethod* _tmp1011_;
											ValaMethod* _tmp1012_;
											ValaMethod* _tmp1013_;
											_tmp1009_ = m;
											_tmp1010_ = async_method;
											_tmp1011_ = vala_method_get_base_interface_method (_tmp1010_);
											_tmp1012_ = _tmp1011_;
											_tmp1013_ = vala_method_get_callback_method (_tmp1012_);
											_tmp1005_ = _tmp1009_ == _tmp1013_;
										} else {
											_tmp1005_ = FALSE;
										}
										if (_tmp1005_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp1014_;
								ValaSourceReference* _tmp1015_;
								ValaMethod* _tmp1016_;
								gchar* _tmp1017_;
								gchar* _tmp1018_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp1014_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp1015_ = _tmp1014_;
								_tmp1016_ = m;
								_tmp1017_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1016_);
								_tmp1018_ = _tmp1017_;
								vala_report_error (_tmp1015_, "Access to async callback `%s' not allowed in this context", _tmp1018_);
								_g_free0 (_tmp1018_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1019_ = async_method;
							_tmp1020_ = vala_code_context_get_analyzer (context);
							_tmp1021_ = _tmp1020_;
							_tmp1022_ = vala_semantic_analyzer_get_current_method (_tmp1021_);
							_tmp1023_ = _tmp1022_;
							if (_tmp1019_ != _tmp1023_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp1024_;
								ValaSemanticAnalyzer* _tmp1025_;
								ValaMethod* _tmp1026_;
								ValaMethod* _tmp1027_;
								ValaMethod* _tmp1036_;
								ValaBlock* _tmp1037_;
								ValaBlock* _tmp1038_;
								_tmp1024_ = vala_code_context_get_analyzer (context);
								_tmp1025_ = _tmp1024_;
								_tmp1026_ = vala_semantic_analyzer_get_current_method (_tmp1025_);
								_tmp1027_ = _tmp1026_;
								sym = (ValaSymbol*) _tmp1027_;
								while (TRUE) {
									ValaSymbol* _tmp1028_;
									ValaMethod* _tmp1029_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1030_;
									ValaMethod* _tmp1031_;
									ValaSymbol* _tmp1033_;
									ValaSymbol* _tmp1034_;
									ValaSymbol* _tmp1035_;
									_tmp1028_ = sym;
									_tmp1029_ = async_method;
									if (!(_tmp1028_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1029_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1030_ = sym;
									method = VALA_IS_METHOD (_tmp1030_) ? ((ValaMethod*) _tmp1030_) : NULL;
									_tmp1031_ = method;
									if (_tmp1031_ != NULL) {
										ValaMethod* _tmp1032_;
										_tmp1032_ = method;
										vala_method_set_closure (_tmp1032_, TRUE);
									}
									_tmp1033_ = sym;
									_tmp1034_ = vala_symbol_get_parent_symbol (_tmp1033_);
									_tmp1035_ = _tmp1034_;
									sym = _tmp1035_;
								}
								_tmp1036_ = async_method;
								_tmp1037_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1036_);
								_tmp1038_ = _tmp1037_;
								vala_block_set_captured (_tmp1038_, TRUE);
							}
							_tmp1039_ = async_method;
							_tmp1040_ = vala_method_get_callback_method (_tmp1039_);
							m = _tmp1040_;
							_tmp1041_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1041_);
							_tmp1042_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1043_ = _tmp1042_;
							member = _tmp1043_;
						} else {
							ValaMethod* _tmp1044_;
							ValaMethod* _tmp1045_;
							ValaMethod* _tmp1046_;
							_tmp1044_ = m;
							_tmp1045_ = vala_method_get_base_method (_tmp1044_);
							_tmp1046_ = _tmp1045_;
							if (_tmp1046_ != NULL) {
								ValaMethod* _tmp1047_;
								ValaMethod* _tmp1048_;
								ValaMethod* _tmp1049_;
								ValaMethod* _tmp1050_;
								ValaSignal* _tmp1051_;
								ValaSignal* _tmp1052_;
								ValaSymbol* _tmp1057_;
								ValaSymbol* _tmp1058_;
								_tmp1047_ = m;
								_tmp1048_ = vala_method_get_base_method (_tmp1047_);
								_tmp1049_ = _tmp1048_;
								m = _tmp1049_;
								_tmp1050_ = m;
								_tmp1051_ = vala_method_get_signal_reference (_tmp1050_);
								_tmp1052_ = _tmp1051_;
								if (_tmp1052_ != NULL) {
									ValaMethod* _tmp1053_;
									ValaSignal* _tmp1054_;
									ValaSignal* _tmp1055_;
									_tmp1053_ = m;
									_tmp1054_ = vala_method_get_signal_reference (_tmp1053_);
									_tmp1055_ = _tmp1054_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1055_);
								} else {
									ValaMethod* _tmp1056_;
									_tmp1056_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1056_);
								}
								_tmp1057_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1058_ = _tmp1057_;
								member = _tmp1058_;
							} else {
								ValaMethod* _tmp1059_;
								ValaMethod* _tmp1060_;
								ValaMethod* _tmp1061_;
								_tmp1059_ = m;
								_tmp1060_ = vala_method_get_base_interface_method (_tmp1059_);
								_tmp1061_ = _tmp1060_;
								if (_tmp1061_ != NULL) {
									ValaMethod* _tmp1062_;
									ValaMethod* _tmp1063_;
									ValaMethod* _tmp1064_;
									ValaMethod* _tmp1065_;
									ValaSignal* _tmp1066_;
									ValaSignal* _tmp1067_;
									ValaSymbol* _tmp1072_;
									ValaSymbol* _tmp1073_;
									_tmp1062_ = m;
									_tmp1063_ = vala_method_get_base_interface_method (_tmp1062_);
									_tmp1064_ = _tmp1063_;
									m = _tmp1064_;
									_tmp1065_ = m;
									_tmp1066_ = vala_method_get_signal_reference (_tmp1065_);
									_tmp1067_ = _tmp1066_;
									if (_tmp1067_ != NULL) {
										ValaMethod* _tmp1068_;
										ValaSignal* _tmp1069_;
										ValaSignal* _tmp1070_;
										_tmp1068_ = m;
										_tmp1069_ = vala_method_get_signal_reference (_tmp1068_);
										_tmp1070_ = _tmp1069_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1070_);
									} else {
										ValaMethod* _tmp1071_;
										_tmp1071_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1071_);
									}
									_tmp1072_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1073_ = _tmp1072_;
									member = _tmp1073_;
								}
							}
						}
						_tmp1074_ = m;
						_tmp1075_ = vala_symbol_get_access ((ValaSymbol*) _tmp1074_);
						_tmp1076_ = _tmp1075_;
						access = _tmp1076_;
						_tmp1077_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1077_)) {
							ValaMethod* _tmp1078_;
							ValaMemberBinding _tmp1079_;
							ValaMemberBinding _tmp1080_;
							_tmp1078_ = m;
							_tmp1079_ = vala_method_get_binding (_tmp1078_);
							_tmp1080_ = _tmp1079_;
							instance = _tmp1080_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1081_ = m;
						_tmp1082_ = vala_method_get_binding (_tmp1081_);
						_tmp1083_ = _tmp1082_;
						klass = _tmp1083_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1084_;
							ValaList* _tmp1085_;
							gint _param_size = 0;
							ValaList* _tmp1086_;
							gint _tmp1087_;
							gint _tmp1088_;
							gint _param_index = 0;
							_tmp1084_ = m;
							_tmp1085_ = vala_callable_get_parameters ((ValaCallable*) _tmp1084_);
							_param_list = _tmp1085_;
							_tmp1086_ = _param_list;
							_tmp1087_ = vala_collection_get_size ((ValaCollection*) _tmp1086_);
							_tmp1088_ = _tmp1087_;
							_param_size = _tmp1088_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1089_;
								gint _tmp1090_;
								ValaParameter* param = NULL;
								ValaList* _tmp1091_;
								gpointer _tmp1092_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1093_;
								ValaDataType* _tmp1094_;
								ValaDataType* _tmp1095_;
								gboolean _tmp1096_ = FALSE;
								ValaGenericType* _tmp1097_;
								_param_index = _param_index + 1;
								_tmp1089_ = _param_index;
								_tmp1090_ = _param_size;
								if (!(_tmp1089_ < _tmp1090_)) {
									break;
								}
								_tmp1091_ = _param_list;
								_tmp1092_ = vala_list_get (_tmp1091_, _param_index);
								param = (ValaParameter*) _tmp1092_;
								_tmp1093_ = param;
								_tmp1094_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1093_);
								_tmp1095_ = _tmp1094_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1095_) ? ((ValaGenericType*) _tmp1095_) : NULL;
								_tmp1097_ = generic_type;
								if (_tmp1097_ != NULL) {
									ValaGenericType* _tmp1098_;
									ValaTypeParameter* _tmp1099_;
									ValaTypeParameter* _tmp1100_;
									ValaSymbol* _tmp1101_;
									ValaSymbol* _tmp1102_;
									_tmp1098_ = generic_type;
									_tmp1099_ = vala_generic_type_get_type_parameter (_tmp1098_);
									_tmp1100_ = _tmp1099_;
									_tmp1101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1100_);
									_tmp1102_ = _tmp1101_;
									_tmp1096_ = VALA_IS_TYPESYMBOL (_tmp1102_);
								} else {
									_tmp1096_ = FALSE;
								}
								if (_tmp1096_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp1103_ = m;
						_tmp1104_ = vala_callable_get_return_type ((ValaCallable*) _tmp1103_);
						_tmp1105_ = _tmp1104_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1105_) ? ((ValaGenericType*) _tmp1105_) : NULL;
						_tmp1107_ = generic_type;
						if (_tmp1107_ != NULL) {
							ValaGenericType* _tmp1108_;
							ValaTypeParameter* _tmp1109_;
							ValaTypeParameter* _tmp1110_;
							ValaSymbol* _tmp1111_;
							ValaSymbol* _tmp1112_;
							_tmp1108_ = generic_type;
							_tmp1109_ = vala_generic_type_get_type_parameter (_tmp1108_);
							_tmp1110_ = _tmp1109_;
							_tmp1111_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1110_);
							_tmp1112_ = _tmp1111_;
							_tmp1106_ = VALA_IS_TYPESYMBOL (_tmp1112_);
						} else {
							_tmp1106_ = FALSE;
						}
						if (_tmp1106_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1113_;
						_tmp1113_ = member;
						if (VALA_IS_PROPERTY (_tmp1113_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1114_;
							ValaProperty* _tmp1115_;
							ValaProperty* _tmp1116_;
							ValaProperty* _tmp1117_;
							ValaProperty* _tmp1118_;
							ValaProperty* _tmp1134_;
							ValaSymbolAccessibility _tmp1135_;
							ValaSymbolAccessibility _tmp1136_;
							gboolean _tmp1137_;
							gboolean _tmp1138_;
							ValaProperty* _tmp1237_;
							ValaMemberBinding _tmp1238_;
							ValaMemberBinding _tmp1239_;
							ValaProperty* _tmp1240_;
							ValaDataType* _tmp1241_;
							ValaDataType* _tmp1242_;
							_tmp1114_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1115_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1115_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1116_ = prop;
							_tmp1117_ = vala_property_get_base_property (_tmp1116_);
							_tmp1118_ = _tmp1117_;
							if (_tmp1118_ != NULL) {
								ValaProperty* _tmp1119_;
								ValaProperty* _tmp1120_;
								ValaProperty* _tmp1121_;
								ValaProperty* _tmp1122_;
								ValaSymbol* _tmp1123_;
								ValaSymbol* _tmp1124_;
								_tmp1119_ = prop;
								_tmp1120_ = vala_property_get_base_property (_tmp1119_);
								_tmp1121_ = _tmp1120_;
								prop = _tmp1121_;
								_tmp1122_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1122_);
								_tmp1123_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1124_ = _tmp1123_;
								member = _tmp1124_;
							} else {
								ValaProperty* _tmp1125_;
								ValaProperty* _tmp1126_;
								ValaProperty* _tmp1127_;
								_tmp1125_ = prop;
								_tmp1126_ = vala_property_get_base_interface_property (_tmp1125_);
								_tmp1127_ = _tmp1126_;
								if (_tmp1127_ != NULL) {
									ValaProperty* _tmp1128_;
									ValaProperty* _tmp1129_;
									ValaProperty* _tmp1130_;
									ValaProperty* _tmp1131_;
									ValaSymbol* _tmp1132_;
									ValaSymbol* _tmp1133_;
									_tmp1128_ = prop;
									_tmp1129_ = vala_property_get_base_interface_property (_tmp1128_);
									_tmp1130_ = _tmp1129_;
									prop = _tmp1130_;
									_tmp1131_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1131_);
									_tmp1132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1133_ = _tmp1132_;
									member = _tmp1133_;
								}
							}
							_tmp1134_ = prop;
							_tmp1135_ = vala_symbol_get_access ((ValaSymbol*) _tmp1134_);
							_tmp1136_ = _tmp1135_;
							access = _tmp1136_;
							_tmp1137_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1138_ = _tmp1137_;
							if (_tmp1138_) {
								ValaProperty* _tmp1139_;
								ValaPropertyAccessor* _tmp1140_;
								ValaPropertyAccessor* _tmp1141_;
								ValaProperty* _tmp1185_;
								ValaSymbolAccessibility _tmp1186_;
								ValaSymbolAccessibility _tmp1187_;
								_tmp1139_ = prop;
								_tmp1140_ = vala_property_get_set_accessor (_tmp1139_);
								_tmp1141_ = _tmp1140_;
								if (_tmp1141_ == NULL) {
									ValaSourceReference* _tmp1142_;
									ValaSourceReference* _tmp1143_;
									ValaProperty* _tmp1144_;
									gchar* _tmp1145_;
									gchar* _tmp1146_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1142_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1143_ = _tmp1142_;
									_tmp1144_ = prop;
									_tmp1145_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1144_);
									_tmp1146_ = _tmp1145_;
									vala_report_error (_tmp1143_, "Property `%s' is read-only", _tmp1146_);
									_g_free0 (_tmp1146_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								} else {
									gboolean _tmp1147_ = FALSE;
									ValaProperty* _tmp1148_;
									ValaPropertyAccessor* _tmp1149_;
									ValaPropertyAccessor* _tmp1150_;
									gboolean _tmp1151_;
									gboolean _tmp1152_;
									_tmp1148_ = prop;
									_tmp1149_ = vala_property_get_set_accessor (_tmp1148_);
									_tmp1150_ = _tmp1149_;
									_tmp1151_ = vala_property_accessor_get_writable (_tmp1150_);
									_tmp1152_ = _tmp1151_;
									if (!_tmp1152_) {
										ValaProperty* _tmp1153_;
										ValaPropertyAccessor* _tmp1154_;
										ValaPropertyAccessor* _tmp1155_;
										gboolean _tmp1156_;
										gboolean _tmp1157_;
										_tmp1153_ = prop;
										_tmp1154_ = vala_property_get_set_accessor (_tmp1153_);
										_tmp1155_ = _tmp1154_;
										_tmp1156_ = vala_property_accessor_get_construction (_tmp1155_);
										_tmp1157_ = _tmp1156_;
										_tmp1147_ = _tmp1157_;
									} else {
										_tmp1147_ = FALSE;
									}
									if (_tmp1147_) {
										ValaSemanticAnalyzer* _tmp1158_;
										ValaSemanticAnalyzer* _tmp1159_;
										ValaMethod* _tmp1160_;
										_tmp1158_ = vala_code_context_get_analyzer (context);
										_tmp1159_ = _tmp1158_;
										_tmp1160_ = vala_semantic_analyzer_find_current_method (_tmp1159_);
										if (VALA_IS_CREATION_METHOD (_tmp1160_)) {
											ValaSourceReference* _tmp1161_;
											ValaSourceReference* _tmp1162_;
											vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
											_tmp1161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
											_tmp1162_ = _tmp1161_;
											vala_report_error (_tmp1162_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
											result = FALSE;
											_vala_iterable_unref0 (visited_types);
											return result;
										} else {
											ValaSemanticAnalyzer* _tmp1163_;
											ValaSemanticAnalyzer* _tmp1164_;
											_tmp1163_ = vala_code_context_get_analyzer (context);
											_tmp1164_ = _tmp1163_;
											if (vala_semantic_analyzer_is_in_constructor (_tmp1164_)) {
												ValaSemanticAnalyzer* _tmp1165_;
												ValaSemanticAnalyzer* _tmp1166_;
												ValaTypeSymbol* _tmp1167_;
												ValaTypeSymbol* _tmp1168_;
												ValaProperty* _tmp1169_;
												ValaSymbol* _tmp1170_;
												ValaSymbol* _tmp1171_;
												_tmp1165_ = vala_code_context_get_analyzer (context);
												_tmp1166_ = _tmp1165_;
												_tmp1167_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1166_);
												_tmp1168_ = _tmp1167_;
												_tmp1169_ = prop;
												_tmp1170_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1169_);
												_tmp1171_ = _tmp1170_;
												if (!vala_typesymbol_is_subtype_of (_tmp1168_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1171_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))) {
													ValaSourceReference* _tmp1172_;
													ValaSourceReference* _tmp1173_;
													ValaProperty* _tmp1174_;
													gchar* _tmp1175_;
													gchar* _tmp1176_;
													ValaSemanticAnalyzer* _tmp1177_;
													ValaSemanticAnalyzer* _tmp1178_;
													ValaTypeSymbol* _tmp1179_;
													ValaTypeSymbol* _tmp1180_;
													gchar* _tmp1181_;
													gchar* _tmp1182_;
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													_tmp1172_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1173_ = _tmp1172_;
													_tmp1174_ = prop;
													_tmp1175_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1174_);
													_tmp1176_ = _tmp1175_;
													_tmp1177_ = vala_code_context_get_analyzer (context);
													_tmp1178_ = _tmp1177_;
													_tmp1179_ = vala_semantic_analyzer_get_current_type_symbol (_tmp1178_);
													_tmp1180_ = _tmp1179_;
													_tmp1181_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1180_);
													_tmp1182_ = _tmp1181_;
													vala_report_error (_tmp1173_, "Cannot assign to construct-only property `%s' in `construct' of `%s'", _tmp1176_, _tmp1182_);
													_g_free0 (_tmp1182_);
													_g_free0 (_tmp1176_);
													result = FALSE;
													_vala_iterable_unref0 (visited_types);
													return result;
												}
											} else {
												ValaSourceReference* _tmp1183_;
												ValaSourceReference* _tmp1184_;
												vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
												_tmp1183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1184_ = _tmp1183_;
												vala_report_error (_tmp1184_, "Cannot assign to construct-only property in this context");
												result = FALSE;
												_vala_iterable_unref0 (visited_types);
												return result;
											}
										}
									}
								}
								_tmp1185_ = prop;
								_tmp1186_ = vala_symbol_get_access ((ValaSymbol*) _tmp1185_);
								_tmp1187_ = _tmp1186_;
								if (_tmp1187_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1188_;
									ValaPropertyAccessor* _tmp1189_;
									ValaPropertyAccessor* _tmp1190_;
									ValaSymbolAccessibility _tmp1191_;
									ValaSymbolAccessibility _tmp1192_;
									_tmp1188_ = prop;
									_tmp1189_ = vala_property_get_set_accessor (_tmp1188_);
									_tmp1190_ = _tmp1189_;
									_tmp1191_ = vala_symbol_get_access ((ValaSymbol*) _tmp1190_);
									_tmp1192_ = _tmp1191_;
									access = _tmp1192_;
								} else {
									gboolean _tmp1193_ = FALSE;
									ValaProperty* _tmp1194_;
									ValaSymbolAccessibility _tmp1195_;
									ValaSymbolAccessibility _tmp1196_;
									_tmp1194_ = prop;
									_tmp1195_ = vala_symbol_get_access ((ValaSymbol*) _tmp1194_);
									_tmp1196_ = _tmp1195_;
									if (_tmp1196_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1197_;
										ValaPropertyAccessor* _tmp1198_;
										ValaPropertyAccessor* _tmp1199_;
										ValaSymbolAccessibility _tmp1200_;
										ValaSymbolAccessibility _tmp1201_;
										_tmp1197_ = prop;
										_tmp1198_ = vala_property_get_set_accessor (_tmp1197_);
										_tmp1199_ = _tmp1198_;
										_tmp1200_ = vala_symbol_get_access ((ValaSymbol*) _tmp1199_);
										_tmp1201_ = _tmp1200_;
										_tmp1193_ = _tmp1201_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1193_ = FALSE;
									}
									if (_tmp1193_) {
										ValaProperty* _tmp1202_;
										ValaPropertyAccessor* _tmp1203_;
										ValaPropertyAccessor* _tmp1204_;
										ValaSymbolAccessibility _tmp1205_;
										ValaSymbolAccessibility _tmp1206_;
										_tmp1202_ = prop;
										_tmp1203_ = vala_property_get_set_accessor (_tmp1202_);
										_tmp1204_ = _tmp1203_;
										_tmp1205_ = vala_symbol_get_access ((ValaSymbol*) _tmp1204_);
										_tmp1206_ = _tmp1205_;
										access = _tmp1206_;
									}
								}
							} else {
								ValaProperty* _tmp1207_;
								ValaPropertyAccessor* _tmp1208_;
								ValaPropertyAccessor* _tmp1209_;
								ValaProperty* _tmp1215_;
								ValaSymbolAccessibility _tmp1216_;
								ValaSymbolAccessibility _tmp1217_;
								_tmp1207_ = prop;
								_tmp1208_ = vala_property_get_get_accessor (_tmp1207_);
								_tmp1209_ = _tmp1208_;
								if (_tmp1209_ == NULL) {
									ValaSourceReference* _tmp1210_;
									ValaSourceReference* _tmp1211_;
									ValaProperty* _tmp1212_;
									gchar* _tmp1213_;
									gchar* _tmp1214_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1211_ = _tmp1210_;
									_tmp1212_ = prop;
									_tmp1213_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1212_);
									_tmp1214_ = _tmp1213_;
									vala_report_error (_tmp1211_, "Property `%s' is write-only", _tmp1214_);
									_g_free0 (_tmp1214_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1215_ = prop;
								_tmp1216_ = vala_symbol_get_access ((ValaSymbol*) _tmp1215_);
								_tmp1217_ = _tmp1216_;
								if (_tmp1217_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1218_;
									ValaPropertyAccessor* _tmp1219_;
									ValaPropertyAccessor* _tmp1220_;
									ValaSymbolAccessibility _tmp1221_;
									ValaSymbolAccessibility _tmp1222_;
									_tmp1218_ = prop;
									_tmp1219_ = vala_property_get_get_accessor (_tmp1218_);
									_tmp1220_ = _tmp1219_;
									_tmp1221_ = vala_symbol_get_access ((ValaSymbol*) _tmp1220_);
									_tmp1222_ = _tmp1221_;
									access = _tmp1222_;
								} else {
									gboolean _tmp1223_ = FALSE;
									ValaProperty* _tmp1224_;
									ValaSymbolAccessibility _tmp1225_;
									ValaSymbolAccessibility _tmp1226_;
									_tmp1224_ = prop;
									_tmp1225_ = vala_symbol_get_access ((ValaSymbol*) _tmp1224_);
									_tmp1226_ = _tmp1225_;
									if (_tmp1226_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1227_;
										ValaPropertyAccessor* _tmp1228_;
										ValaPropertyAccessor* _tmp1229_;
										ValaSymbolAccessibility _tmp1230_;
										ValaSymbolAccessibility _tmp1231_;
										_tmp1227_ = prop;
										_tmp1228_ = vala_property_get_get_accessor (_tmp1227_);
										_tmp1229_ = _tmp1228_;
										_tmp1230_ = vala_symbol_get_access ((ValaSymbol*) _tmp1229_);
										_tmp1231_ = _tmp1230_;
										_tmp1223_ = _tmp1231_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1223_ = FALSE;
									}
									if (_tmp1223_) {
										ValaProperty* _tmp1232_;
										ValaPropertyAccessor* _tmp1233_;
										ValaPropertyAccessor* _tmp1234_;
										ValaSymbolAccessibility _tmp1235_;
										ValaSymbolAccessibility _tmp1236_;
										_tmp1232_ = prop;
										_tmp1233_ = vala_property_get_get_accessor (_tmp1232_);
										_tmp1234_ = _tmp1233_;
										_tmp1235_ = vala_symbol_get_access ((ValaSymbol*) _tmp1234_);
										_tmp1236_ = _tmp1235_;
										access = _tmp1236_;
									}
								}
							}
							_tmp1237_ = prop;
							_tmp1238_ = vala_property_get_binding (_tmp1237_);
							_tmp1239_ = _tmp1238_;
							instance = _tmp1239_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1240_ = prop;
							_tmp1241_ = vala_property_get_property_type (_tmp1240_);
							_tmp1242_ = _tmp1241_;
							if (VALA_IS_GENERIC_TYPE (_tmp1242_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1243_;
							_tmp1243_ = member;
							if (VALA_IS_SIGNAL (_tmp1243_)) {
								ValaSymbol* _tmp1244_;
								ValaSymbolAccessibility _tmp1245_;
								ValaSymbolAccessibility _tmp1246_;
								instance = TRUE;
								_tmp1244_ = member;
								_tmp1245_ = vala_symbol_get_access (_tmp1244_);
								_tmp1246_ = _tmp1245_;
								access = _tmp1246_;
							} else {
								gboolean _tmp1247_ = FALSE;
								gboolean _tmp1248_;
								_tmp1248_ = self->priv->_creation_member;
								if (!_tmp1248_) {
									ValaSymbol* _tmp1249_;
									_tmp1249_ = member;
									_tmp1247_ = VALA_IS_ERROR_CODE (_tmp1249_);
								} else {
									_tmp1247_ = FALSE;
								}
								if (_tmp1247_) {
									ValaSymbol* _tmp1250_;
									ValaConstant* _tmp1251_;
									ValaConstant* _tmp1252_;
									ValaSymbol* _tmp1253_;
									ValaSymbol* _tmp1254_;
									_tmp1250_ = member;
									_tmp1251_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1252_ = _tmp1251_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1252_);
									_tmp1253_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1254_ = _tmp1253_;
									member = _tmp1254_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1255_;
		ValaSymbol* _tmp1256_;
		ValaCodeNode* _tmp1257_;
		ValaCodeNode* _tmp1258_;
		ValaCodeNode* _tmp1259_;
		gboolean _tmp1260_ = FALSE;
		ValaCodeNode* _tmp1261_;
		_tmp1255_ = parent;
		_tmp1256_ = member;
		if (!(_tmp1255_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1256_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1257_ = parent;
		_tmp1258_ = vala_code_node_get_parent_node (_tmp1257_);
		_tmp1259_ = _tmp1258_;
		parent = _tmp1259_;
		_tmp1261_ = parent;
		if (_tmp1261_ == NULL) {
			_tmp1260_ = TRUE;
		} else {
			ValaCodeNode* _tmp1262_;
			ValaSymbol* _tmp1263_;
			_tmp1262_ = parent;
			_tmp1263_ = member;
			_tmp1260_ = _tmp1262_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1263_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1260_) {
			break;
		}
	}
	_tmp1264_ = parent;
	_tmp1265_ = member;
	if (_tmp1264_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1265_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1266_;
		_tmp1266_ = member;
		vala_symbol_set_used (_tmp1266_, TRUE);
	}
	_tmp1267_ = member;
	_tmp1268_ = vala_symbol_get_version (_tmp1267_);
	_tmp1269_ = _tmp1268_;
	_tmp1270_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1271_ = _tmp1270_;
	vala_version_attribute_check (_tmp1269_, context, _tmp1271_);
	if (access == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1273_;
		ValaSymbol* _tmp1274_;
		ValaSymbol* _tmp1275_;
		_tmp1273_ = member;
		_tmp1274_ = vala_symbol_get_parent_symbol (_tmp1273_);
		_tmp1275_ = _tmp1274_;
		_tmp1272_ = VALA_IS_TYPESYMBOL (_tmp1275_);
	} else {
		_tmp1272_ = FALSE;
	}
	if (_tmp1272_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1276_;
		ValaSymbol* _tmp1277_;
		ValaSymbol* _tmp1278_;
		gboolean in_subtype = FALSE;
		_tmp1276_ = member;
		_tmp1277_ = vala_symbol_get_parent_symbol (_tmp1276_);
		_tmp1278_ = _tmp1277_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1278_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1279_;
			ValaSemanticAnalyzer* _tmp1280_;
			ValaSymbol* _tmp1281_;
			ValaSymbol* _tmp1282_;
			ValaSymbol* _tmp1283_;
			_tmp1279_ = vala_code_context_get_analyzer (context);
			_tmp1280_ = _tmp1279_;
			_tmp1281_ = vala_semantic_analyzer_get_current_symbol (_tmp1280_);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = _vala_code_node_ref0 (_tmp1282_);
			this_symbol = _tmp1283_;
			{
				gboolean _tmp1284_ = FALSE;
				_tmp1284_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1289_;
					ValaSymbol* _tmp1290_;
					ValaTypeSymbol* _tmp1291_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1292_;
					gboolean _tmp1293_ = FALSE;
					ValaClass* _tmp1294_;
					if (!_tmp1284_) {
						ValaSymbol* _tmp1285_;
						ValaSymbol* _tmp1286_;
						ValaSymbol* _tmp1287_;
						ValaSymbol* _tmp1288_;
						_tmp1285_ = this_symbol;
						_tmp1286_ = vala_symbol_get_parent_symbol (_tmp1285_);
						_tmp1287_ = _tmp1286_;
						_tmp1288_ = _vala_code_node_ref0 (_tmp1287_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1288_;
					}
					_tmp1284_ = FALSE;
					_tmp1289_ = this_symbol;
					if (!(_tmp1289_ != NULL)) {
						break;
					}
					_tmp1290_ = this_symbol;
					_tmp1291_ = target_type;
					if (_tmp1290_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1291_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1292_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1292_) ? ((ValaClass*) _tmp1292_) : NULL;
					_tmp1294_ = cl;
					if (_tmp1294_ != NULL) {
						ValaClass* _tmp1295_;
						ValaTypeSymbol* _tmp1296_;
						_tmp1295_ = cl;
						_tmp1296_ = target_type;
						_tmp1293_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1295_, _tmp1296_);
					} else {
						_tmp1293_ = FALSE;
					}
					if (_tmp1293_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1297_;
			ValaSourceReference* _tmp1298_;
			ValaSymbol* _tmp1299_;
			gchar* _tmp1300_;
			gchar* _tmp1301_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1297_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1298_ = _tmp1297_;
			_tmp1299_ = member;
			_tmp1300_ = vala_symbol_get_full_name (_tmp1299_);
			_tmp1301_ = _tmp1300_;
			vala_report_error (_tmp1298_, "Access to protected member `%s' denied", _tmp1301_);
			_g_free0 (_tmp1301_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1302_;
			ValaSymbol* _tmp1303_;
			ValaSymbol* _tmp1304_;
			gboolean in_target_type = FALSE;
			_tmp1302_ = member;
			_tmp1303_ = vala_symbol_get_parent_symbol (_tmp1302_);
			_tmp1304_ = _tmp1303_;
			target_type = _tmp1304_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1305_;
				ValaSemanticAnalyzer* _tmp1306_;
				ValaSymbol* _tmp1307_;
				ValaSymbol* _tmp1308_;
				ValaSymbol* _tmp1309_;
				_tmp1305_ = vala_code_context_get_analyzer (context);
				_tmp1306_ = _tmp1305_;
				_tmp1307_ = vala_semantic_analyzer_get_current_symbol (_tmp1306_);
				_tmp1308_ = _tmp1307_;
				_tmp1309_ = _vala_code_node_ref0 (_tmp1308_);
				this_symbol = _tmp1309_;
				{
					gboolean _tmp1310_ = FALSE;
					_tmp1310_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1315_;
						ValaSymbol* _tmp1316_;
						ValaSymbol* _tmp1317_;
						if (!_tmp1310_) {
							ValaSymbol* _tmp1311_;
							ValaSymbol* _tmp1312_;
							ValaSymbol* _tmp1313_;
							ValaSymbol* _tmp1314_;
							_tmp1311_ = this_symbol;
							_tmp1312_ = vala_symbol_get_parent_symbol (_tmp1311_);
							_tmp1313_ = _tmp1312_;
							_tmp1314_ = _vala_code_node_ref0 (_tmp1313_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1314_;
						}
						_tmp1310_ = FALSE;
						_tmp1315_ = this_symbol;
						if (!(_tmp1315_ != NULL)) {
							break;
						}
						_tmp1316_ = target_type;
						_tmp1317_ = this_symbol;
						if (_tmp1316_ == _tmp1317_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1318_;
				ValaSourceReference* _tmp1319_;
				ValaSymbol* _tmp1320_;
				gchar* _tmp1321_;
				gchar* _tmp1322_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1318_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1319_ = _tmp1318_;
				_tmp1320_ = member;
				_tmp1321_ = vala_symbol_get_full_name (_tmp1320_);
				_tmp1322_ = _tmp1321_;
				vala_report_error (_tmp1319_, "Access to private member `%s' denied", _tmp1322_);
				_g_free0 (_tmp1322_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1324_;
		ValaExpression* _tmp1325_;
		_tmp1324_ = vala_member_access_get_inner (self);
		_tmp1325_ = _tmp1324_;
		_tmp1323_ = _tmp1325_ != NULL;
	} else {
		_tmp1323_ = FALSE;
	}
	if (_tmp1323_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1326_;
		ValaExpression* _tmp1327_;
		ValaDataType* _tmp1328_;
		ValaDataType* _tmp1329_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1330_;
		ValaExpression* _tmp1331_;
		ValaDataType* _tmp1332_;
		ValaDataType* _tmp1333_;
		ValaPointerType* _tmp1334_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1338_;
		gboolean _tmp1339_ = FALSE;
		gboolean _tmp1340_ = FALSE;
		ValaObjectType* _tmp1341_;
		_tmp1326_ = vala_member_access_get_inner (self);
		_tmp1327_ = _tmp1326_;
		_tmp1328_ = vala_expression_get_value_type (_tmp1327_);
		_tmp1329_ = _tmp1328_;
		instance_type = _tmp1329_;
		_tmp1330_ = vala_member_access_get_inner (self);
		_tmp1331_ = _tmp1330_;
		_tmp1332_ = vala_expression_get_value_type (_tmp1331_);
		_tmp1333_ = _tmp1332_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1333_) ? ((ValaPointerType*) _tmp1333_) : NULL;
		_tmp1334_ = pointer_type;
		if (_tmp1334_ != NULL) {
			ValaPointerType* _tmp1335_;
			ValaDataType* _tmp1336_;
			ValaDataType* _tmp1337_;
			_tmp1335_ = pointer_type;
			_tmp1336_ = vala_pointer_type_get_base_type (_tmp1335_);
			_tmp1337_ = _tmp1336_;
			instance_type = _tmp1337_;
		}
		_tmp1338_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1338_) ? ((ValaObjectType*) _tmp1338_) : NULL;
		_tmp1341_ = object_type;
		if (_tmp1341_ != NULL) {
			ValaObjectType* _tmp1342_;
			ValaObjectTypeSymbol* _tmp1343_;
			ValaObjectTypeSymbol* _tmp1344_;
			_tmp1342_ = object_type;
			_tmp1343_ = vala_object_type_get_object_type_symbol (_tmp1342_);
			_tmp1344_ = _tmp1343_;
			_tmp1340_ = vala_object_type_symbol_has_type_parameters (_tmp1344_);
		} else {
			_tmp1340_ = FALSE;
		}
		if (_tmp1340_) {
			ValaDataType* _tmp1345_;
			_tmp1345_ = instance_type;
			_tmp1339_ = !vala_data_type_has_type_arguments (_tmp1345_);
		} else {
			_tmp1339_ = FALSE;
		}
		if (_tmp1339_) {
			ValaExpression* _tmp1346_;
			ValaExpression* _tmp1347_;
			ValaSourceReference* _tmp1348_;
			ValaSourceReference* _tmp1349_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1346_ = vala_member_access_get_inner (self);
			_tmp1347_ = _tmp1346_;
			_tmp1348_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1347_);
			_tmp1349_ = _tmp1348_;
			vala_report_error (_tmp1349_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1351_ = !may_access_instance_members;
	} else {
		_tmp1351_ = FALSE;
	}
	if (_tmp1351_) {
		_tmp1350_ = TRUE;
	} else {
		gboolean _tmp1352_ = FALSE;
		if (klass) {
			_tmp1352_ = !may_access_klass_members;
		} else {
			_tmp1352_ = FALSE;
		}
		_tmp1350_ = _tmp1352_;
	}
	if (_tmp1350_) {
		ValaSymbol* _tmp1353_;
		ValaSymbol* _tmp1354_;
		ValaDataType* _tmp1389_;
		ValaDataType* _tmp1390_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1353_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1354_ = _tmp1353_;
		if (VALA_IS_METHOD (_tmp1354_)) {
			ValaSemanticAnalyzer* _tmp1355_;
			ValaSemanticAnalyzer* _tmp1356_;
			ValaSymbol* _tmp1357_;
			ValaSymbol* _tmp1358_;
			gboolean _tmp1359_;
			gboolean _tmp1360_;
			ValaDataType* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			ValaDataType* _tmp1364_;
			ValaSourceReference* _tmp1365_;
			ValaSourceReference* _tmp1366_;
			_tmp1355_ = vala_code_context_get_analyzer (context);
			_tmp1356_ = _tmp1355_;
			_tmp1357_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1358_ = _tmp1357_;
			_tmp1359_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1360_ = _tmp1359_;
			_tmp1361_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1356_, _tmp1358_, _tmp1360_);
			_tmp1362_ = _tmp1361_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1362_);
			_vala_code_node_unref0 (_tmp1362_);
			_tmp1363_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1364_ = _tmp1363_;
			_tmp1365_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1366_ = _tmp1365_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1364_, _tmp1366_);
		} else {
			ValaSymbol* _tmp1367_;
			ValaSymbol* _tmp1368_;
			_tmp1367_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1368_ = _tmp1367_;
			if (VALA_IS_FIELD (_tmp1368_)) {
				ValaSymbol* _tmp1369_;
				ValaSymbol* _tmp1370_;
				ValaFieldPrototype* _tmp1371_;
				ValaFieldPrototype* _tmp1372_;
				ValaDataType* _tmp1373_;
				ValaDataType* _tmp1374_;
				ValaSourceReference* _tmp1375_;
				ValaSourceReference* _tmp1376_;
				_tmp1369_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1370_ = _tmp1369_;
				_tmp1371_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1370_, VALA_TYPE_FIELD, ValaField));
				_tmp1372_ = _tmp1371_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1372_);
				_vala_code_node_unref0 (_tmp1372_);
				_tmp1373_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1374_ = _tmp1373_;
				_tmp1375_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1376_ = _tmp1375_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1374_, _tmp1376_);
			} else {
				ValaSymbol* _tmp1377_;
				ValaSymbol* _tmp1378_;
				_tmp1377_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1378_ = _tmp1377_;
				if (VALA_IS_PROPERTY (_tmp1378_)) {
					ValaSymbol* _tmp1379_;
					ValaSymbol* _tmp1380_;
					ValaPropertyPrototype* _tmp1381_;
					ValaPropertyPrototype* _tmp1382_;
					ValaDataType* _tmp1383_;
					ValaDataType* _tmp1384_;
					ValaSourceReference* _tmp1385_;
					ValaSourceReference* _tmp1386_;
					_tmp1379_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1380_ = _tmp1379_;
					_tmp1381_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1380_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1382_ = _tmp1381_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1382_);
					_vala_code_node_unref0 (_tmp1382_);
					_tmp1383_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp1384_ = _tmp1383_;
					_tmp1385_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1386_ = _tmp1385_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1384_, _tmp1386_);
				} else {
					ValaInvalidType* _tmp1387_;
					ValaInvalidType* _tmp1388_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1387_ = vala_invalid_type_new ();
					_tmp1388_ = _tmp1387_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1388_);
					_vala_code_node_unref0 (_tmp1388_);
				}
			}
		}
		_tmp1389_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1390_ = _tmp1389_;
		if (_tmp1390_ != NULL) {
			ValaDataType* _tmp1391_;
			ValaDataType* _tmp1392_;
			ValaDataType* _tmp1393_;
			ValaDataType* _tmp1394_;
			gboolean _tmp1395_;
			gboolean _tmp1396_;
			_tmp1391_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1392_ = _tmp1391_;
			_tmp1393_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1394_ = _tmp1393_;
			_tmp1395_ = vala_data_type_get_value_owned (_tmp1394_);
			_tmp1396_ = _tmp1395_;
			vala_data_type_set_value_owned (_tmp1392_, _tmp1396_);
		}
	} else {
		gboolean _tmp1397_ = FALSE;
		gboolean _tmp1418_ = FALSE;
		gboolean _tmp1419_ = FALSE;
		gboolean _tmp1420_ = FALSE;
		gboolean _tmp1421_ = FALSE;
		gboolean _tmp1462_ = FALSE;
		gboolean _tmp1463_ = FALSE;
		gboolean _tmp1464_ = FALSE;
		gboolean _tmp1465_ = FALSE;
		gboolean _tmp1466_ = FALSE;
		gboolean _tmp1467_;
		gboolean _tmp1468_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1493_;
		ValaSymbol* _tmp1494_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1495_;
		ValaExpression* _tmp1496_;
		gboolean _tmp1497_ = FALSE;
		gboolean _tmp1498_ = FALSE;
		gboolean _tmp1499_ = FALSE;
		gboolean _tmp1500_ = FALSE;
		gboolean _tmp1501_ = FALSE;
		ValaMethod* _tmp1502_;
		ValaSemanticAnalyzer* _tmp1546_;
		ValaSemanticAnalyzer* _tmp1547_;
		ValaSymbol* _tmp1548_;
		ValaSymbol* _tmp1549_;
		gboolean _tmp1550_;
		gboolean _tmp1551_;
		ValaDataType* _tmp1552_;
		ValaDataType* _tmp1553_;
		gboolean _tmp1554_ = FALSE;
		ValaExpression* _tmp1555_;
		ValaExpression* _tmp1556_;
		ValaSymbol* _tmp1569_;
		ValaSymbol* _tmp1570_;
		gboolean _tmp1644_ = FALSE;
		gboolean _tmp1645_ = FALSE;
		ValaExpression* _tmp1646_;
		ValaExpression* _tmp1647_;
		if (instance) {
			ValaExpression* _tmp1398_;
			ValaExpression* _tmp1399_;
			_tmp1398_ = vala_member_access_get_inner (self);
			_tmp1399_ = _tmp1398_;
			_tmp1397_ = _tmp1399_ == NULL;
		} else {
			_tmp1397_ = FALSE;
		}
		if (_tmp1397_) {
			ValaSourceReference* _tmp1400_;
			ValaSourceReference* _tmp1401_;
			ValaMemberAccess* _tmp1402_;
			ValaMemberAccess* _tmp1403_;
			ValaExpression* _tmp1404_;
			ValaExpression* _tmp1405_;
			ValaParameter* _tmp1406_;
			ValaDataType* _tmp1407_;
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			ValaDataType* _tmp1410_;
			ValaExpression* _tmp1411_;
			ValaExpression* _tmp1412_;
			ValaDataType* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaExpression* _tmp1415_;
			ValaExpression* _tmp1416_;
			ValaParameter* _tmp1417_;
			_tmp1400_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_member_access_new (NULL, "this", _tmp1401_);
			_tmp1403_ = _tmp1402_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1403_);
			_vala_code_node_unref0 (_tmp1403_);
			_tmp1404_ = vala_member_access_get_inner (self);
			_tmp1405_ = _tmp1404_;
			_tmp1406_ = this_parameter;
			_tmp1407_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1406_);
			_tmp1408_ = _tmp1407_;
			_tmp1409_ = vala_data_type_copy (_tmp1408_);
			_tmp1410_ = _tmp1409_;
			vala_expression_set_value_type (_tmp1405_, _tmp1410_);
			_vala_code_node_unref0 (_tmp1410_);
			_tmp1411_ = vala_member_access_get_inner (self);
			_tmp1412_ = _tmp1411_;
			_tmp1413_ = vala_expression_get_value_type (_tmp1412_);
			_tmp1414_ = _tmp1413_;
			vala_data_type_set_value_owned (_tmp1414_, FALSE);
			_tmp1415_ = vala_member_access_get_inner (self);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1416_, (ValaSymbol*) _tmp1417_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1421_ = !klass;
		} else {
			_tmp1421_ = FALSE;
		}
		if (_tmp1421_) {
			ValaSymbol* _tmp1422_;
			ValaSymbol* _tmp1423_;
			_tmp1422_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1423_ = _tmp1422_;
			_tmp1420_ = !VALA_IS_CREATION_METHOD (_tmp1423_);
		} else {
			_tmp1420_ = FALSE;
		}
		if (_tmp1420_) {
			_tmp1419_ = may_access_instance_members;
		} else {
			_tmp1419_ = FALSE;
		}
		if (_tmp1419_) {
			ValaExpression* _tmp1424_;
			ValaExpression* _tmp1425_;
			_tmp1424_ = vala_member_access_get_inner (self);
			_tmp1425_ = _tmp1424_;
			_tmp1418_ = _tmp1425_ != NULL;
		} else {
			_tmp1418_ = FALSE;
		}
		if (_tmp1418_) {
			ValaExpression* _tmp1426_;
			ValaExpression* _tmp1427_;
			ValaSymbol* _tmp1428_;
			ValaSymbol* _tmp1429_;
			_tmp1426_ = vala_member_access_get_inner (self);
			_tmp1427_ = _tmp1426_;
			_tmp1428_ = vala_expression_get_symbol_reference (_tmp1427_);
			_tmp1429_ = _tmp1428_;
			if (VALA_IS_METHOD (_tmp1429_)) {
			} else {
				ValaSourceReference* _tmp1430_;
				ValaSourceReference* _tmp1431_;
				ValaSymbol* _tmp1432_;
				ValaSymbol* _tmp1433_;
				gchar* _tmp1434_;
				gchar* _tmp1435_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1436_;
				ValaSymbol* _tmp1437_;
				ValaSymbol* _tmp1438_;
				ValaSymbol* _tmp1439_;
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp1459_;
				ValaExpression* _tmp1460_;
				ValaExpression* _tmp1461_;
				_tmp1430_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1431_ = _tmp1430_;
				_tmp1432_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1433_ = _tmp1432_;
				_tmp1434_ = vala_symbol_get_full_name (_tmp1433_);
				_tmp1435_ = _tmp1434_;
				vala_report_warning (_tmp1431_, "Access to static member `%s' with an instance reference", _tmp1435_);
				_g_free0 (_tmp1435_);
				_tmp1436_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1437_ = _tmp1436_;
				_tmp1438_ = vala_symbol_get_parent_symbol (_tmp1437_);
				_tmp1439_ = _tmp1438_;
				inner_sym = _tmp1439_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1440_ = FALSE;
					ValaSymbol* _tmp1441_;
					ValaMemberAccess* _tmp1445_;
					ValaSymbol* _tmp1446_;
					const gchar* _tmp1447_;
					const gchar* _tmp1448_;
					ValaSourceReference* _tmp1449_;
					ValaSourceReference* _tmp1450_;
					ValaMemberAccess* _tmp1451_;
					ValaMemberAccess* _tmp1452_;
					ValaMemberAccess* _tmp1453_;
					ValaExpression* _tmp1454_;
					ValaExpression* _tmp1455_;
					ValaSymbol* _tmp1456_;
					ValaSymbol* _tmp1457_;
					ValaSymbol* _tmp1458_;
					_tmp1441_ = inner_sym;
					if (_tmp1441_ != NULL) {
						ValaSymbol* _tmp1442_;
						const gchar* _tmp1443_;
						const gchar* _tmp1444_;
						_tmp1442_ = inner_sym;
						_tmp1443_ = vala_symbol_get_name (_tmp1442_);
						_tmp1444_ = _tmp1443_;
						_tmp1440_ = _tmp1444_ != NULL;
					} else {
						_tmp1440_ = FALSE;
					}
					if (!_tmp1440_) {
						break;
					}
					_tmp1445_ = inner_ma;
					_tmp1446_ = inner_sym;
					_tmp1447_ = vala_symbol_get_name (_tmp1446_);
					_tmp1448_ = _tmp1447_;
					_tmp1449_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1450_ = _tmp1449_;
					_tmp1451_ = vala_member_access_new (NULL, _tmp1448_, _tmp1450_);
					_tmp1452_ = _tmp1451_;
					vala_member_access_set_inner (_tmp1445_, (ValaExpression*) _tmp1452_);
					_vala_code_node_unref0 (_tmp1452_);
					_tmp1453_ = inner_ma;
					_tmp1454_ = vala_member_access_get_inner (_tmp1453_);
					_tmp1455_ = _tmp1454_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1455_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1456_ = inner_sym;
					_tmp1457_ = vala_symbol_get_parent_symbol (_tmp1456_);
					_tmp1458_ = _tmp1457_;
					inner_sym = _tmp1458_;
				}
				_tmp1459_ = inner_ma;
				vala_member_access_set_qualified (_tmp1459_, TRUE);
				_tmp1460_ = vala_member_access_get_inner (self);
				_tmp1461_ = _tmp1460_;
				vala_code_node_check ((ValaCodeNode*) _tmp1461_, context);
			}
		}
		_tmp1467_ = vala_code_context_get_experimental_non_null (context);
		_tmp1468_ = _tmp1467_;
		if (_tmp1468_) {
			_tmp1466_ = instance;
		} else {
			_tmp1466_ = FALSE;
		}
		if (_tmp1466_) {
			ValaExpression* _tmp1469_;
			ValaExpression* _tmp1470_;
			ValaDataType* _tmp1471_;
			ValaDataType* _tmp1472_;
			gboolean _tmp1473_;
			gboolean _tmp1474_;
			_tmp1469_ = vala_member_access_get_inner (self);
			_tmp1470_ = _tmp1469_;
			_tmp1471_ = vala_expression_get_value_type (_tmp1470_);
			_tmp1472_ = _tmp1471_;
			_tmp1473_ = vala_data_type_get_nullable (_tmp1472_);
			_tmp1474_ = _tmp1473_;
			_tmp1465_ = _tmp1474_;
		} else {
			_tmp1465_ = FALSE;
		}
		if (_tmp1465_) {
			ValaExpression* _tmp1475_;
			ValaExpression* _tmp1476_;
			ValaDataType* _tmp1477_;
			ValaDataType* _tmp1478_;
			_tmp1475_ = vala_member_access_get_inner (self);
			_tmp1476_ = _tmp1475_;
			_tmp1477_ = vala_expression_get_value_type (_tmp1476_);
			_tmp1478_ = _tmp1477_;
			_tmp1464_ = !VALA_IS_POINTER_TYPE (_tmp1478_);
		} else {
			_tmp1464_ = FALSE;
		}
		if (_tmp1464_) {
			ValaExpression* _tmp1479_;
			ValaExpression* _tmp1480_;
			ValaDataType* _tmp1481_;
			ValaDataType* _tmp1482_;
			_tmp1479_ = vala_member_access_get_inner (self);
			_tmp1480_ = _tmp1479_;
			_tmp1481_ = vala_expression_get_value_type (_tmp1480_);
			_tmp1482_ = _tmp1481_;
			_tmp1463_ = !VALA_IS_GENERIC_TYPE (_tmp1482_);
		} else {
			_tmp1463_ = FALSE;
		}
		if (_tmp1463_) {
			ValaExpression* _tmp1483_;
			ValaExpression* _tmp1484_;
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			_tmp1483_ = vala_member_access_get_inner (self);
			_tmp1484_ = _tmp1483_;
			_tmp1485_ = vala_expression_get_value_type (_tmp1484_);
			_tmp1486_ = _tmp1485_;
			_tmp1462_ = !VALA_IS_ARRAY_TYPE (_tmp1486_);
		} else {
			_tmp1462_ = FALSE;
		}
		if (_tmp1462_) {
			ValaSourceReference* _tmp1487_;
			ValaSourceReference* _tmp1488_;
			ValaSymbol* _tmp1489_;
			ValaSymbol* _tmp1490_;
			gchar* _tmp1491_;
			gchar* _tmp1492_;
			_tmp1487_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1488_ = _tmp1487_;
			_tmp1489_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_symbol_get_full_name (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			vala_report_error (_tmp1488_, "Access to instance member `%s' from nullable reference denied", _tmp1492_);
			_g_free0 (_tmp1492_);
		}
		_tmp1493_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1494_ = _tmp1493_;
		m = VALA_IS_METHOD (_tmp1494_) ? ((ValaMethod*) _tmp1494_) : NULL;
		_tmp1495_ = vala_member_access_get_inner (self);
		_tmp1496_ = _tmp1495_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1496_) ? ((ValaMemberAccess*) _tmp1496_) : NULL;
		_tmp1502_ = m;
		if (_tmp1502_ != NULL) {
			ValaMethod* _tmp1503_;
			ValaMemberBinding _tmp1504_;
			ValaMemberBinding _tmp1505_;
			_tmp1503_ = m;
			_tmp1504_ = vala_method_get_binding (_tmp1503_);
			_tmp1505_ = _tmp1504_;
			_tmp1501_ = _tmp1505_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1501_ = FALSE;
		}
		if (_tmp1501_) {
			ValaMethod* _tmp1506_;
			ValaSymbol* _tmp1507_;
			ValaSymbol* _tmp1508_;
			_tmp1506_ = m;
			_tmp1507_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1506_);
			_tmp1508_ = _tmp1507_;
			_tmp1500_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1508_);
		} else {
			_tmp1500_ = FALSE;
		}
		if (_tmp1500_) {
			ValaExpression* _tmp1509_;
			ValaExpression* _tmp1510_;
			_tmp1509_ = vala_member_access_get_inner (self);
			_tmp1510_ = _tmp1509_;
			_tmp1499_ = _tmp1510_ != NULL;
		} else {
			_tmp1499_ = FALSE;
		}
		if (_tmp1499_) {
			ValaExpression* _tmp1511_;
			ValaExpression* _tmp1512_;
			ValaDataType* _tmp1513_;
			ValaDataType* _tmp1514_;
			_tmp1511_ = vala_member_access_get_inner (self);
			_tmp1512_ = _tmp1511_;
			_tmp1513_ = vala_expression_get_value_type (_tmp1512_);
			_tmp1514_ = _tmp1513_;
			_tmp1498_ = _tmp1514_ == NULL;
		} else {
			_tmp1498_ = FALSE;
		}
		if (_tmp1498_) {
			ValaMemberAccess* _tmp1515_;
			ValaList* _tmp1516_;
			gint _tmp1517_;
			gint _tmp1518_;
			_tmp1515_ = inner_ma;
			_tmp1516_ = _tmp1515_->priv->type_argument_list;
			_tmp1517_ = vala_collection_get_size ((ValaCollection*) _tmp1516_);
			_tmp1518_ = _tmp1517_;
			_tmp1497_ = _tmp1518_ > 0;
		} else {
			_tmp1497_ = FALSE;
		}
		if (_tmp1497_) {
			ValaExpression* _tmp1519_;
			ValaExpression* _tmp1520_;
			ValaMethod* _tmp1521_;
			ValaSymbol* _tmp1522_;
			ValaSymbol* _tmp1523_;
			ValaObjectType* _tmp1524_;
			ValaObjectType* _tmp1525_;
			ValaExpression* _tmp1526_;
			ValaExpression* _tmp1527_;
			ValaDataType* _tmp1528_;
			ValaDataType* _tmp1529_;
			ValaSourceReference* _tmp1530_;
			ValaSourceReference* _tmp1531_;
			_tmp1519_ = vala_member_access_get_inner (self);
			_tmp1520_ = _tmp1519_;
			_tmp1521_ = m;
			_tmp1522_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1521_);
			_tmp1523_ = _tmp1522_;
			_tmp1524_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1523_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1525_ = _tmp1524_;
			vala_expression_set_value_type (_tmp1520_, (ValaDataType*) _tmp1525_);
			_vala_code_node_unref0 (_tmp1525_);
			_tmp1526_ = vala_member_access_get_inner (self);
			_tmp1527_ = _tmp1526_;
			_tmp1528_ = vala_expression_get_value_type (_tmp1527_);
			_tmp1529_ = _tmp1528_;
			_tmp1530_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1531_ = _tmp1530_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp1529_, _tmp1531_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1532_;
				ValaList* _tmp1533_;
				gint _type_argument_size = 0;
				ValaList* _tmp1534_;
				gint _tmp1535_;
				gint _tmp1536_;
				gint _type_argument_index = 0;
				_tmp1532_ = inner_ma;
				_tmp1533_ = _tmp1532_->priv->type_argument_list;
				_type_argument_list = _tmp1533_;
				_tmp1534_ = _type_argument_list;
				_tmp1535_ = vala_collection_get_size ((ValaCollection*) _tmp1534_);
				_tmp1536_ = _tmp1535_;
				_type_argument_size = _tmp1536_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1537_;
					gint _tmp1538_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1539_;
					gpointer _tmp1540_;
					ValaExpression* _tmp1541_;
					ValaExpression* _tmp1542_;
					ValaDataType* _tmp1543_;
					ValaDataType* _tmp1544_;
					ValaDataType* _tmp1545_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1537_ = _type_argument_index;
					_tmp1538_ = _type_argument_size;
					if (!(_tmp1537_ < _tmp1538_)) {
						break;
					}
					_tmp1539_ = _type_argument_list;
					_tmp1540_ = vala_list_get (_tmp1539_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1540_;
					_tmp1541_ = vala_member_access_get_inner (self);
					_tmp1542_ = _tmp1541_;
					_tmp1543_ = vala_expression_get_value_type (_tmp1542_);
					_tmp1544_ = _tmp1543_;
					_tmp1545_ = type_argument;
					vala_data_type_add_type_argument (_tmp1544_, _tmp1545_);
					_vala_code_node_unref0 (type_argument);
				}
			}
		}
		_tmp1546_ = vala_code_context_get_analyzer (context);
		_tmp1547_ = _tmp1546_;
		_tmp1548_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1549_ = _tmp1548_;
		_tmp1550_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1551_ = _tmp1550_;
		_tmp1552_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1547_, _tmp1549_, _tmp1551_);
		_tmp1553_ = _tmp1552_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1553_);
		_vala_code_node_unref0 (_tmp1553_);
		_tmp1555_ = vala_member_access_get_inner (self);
		_tmp1556_ = _tmp1555_;
		if (_tmp1556_ != NULL) {
			ValaDataType* _tmp1557_;
			ValaDataType* _tmp1558_;
			_tmp1557_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1558_ = _tmp1557_;
			_tmp1554_ = _tmp1558_ != NULL;
		} else {
			_tmp1554_ = FALSE;
		}
		if (_tmp1554_) {
			ValaDataType* _tmp1559_;
			ValaDataType* _tmp1560_;
			ValaExpression* _tmp1561_;
			ValaExpression* _tmp1562_;
			ValaDataType* _tmp1563_;
			ValaDataType* _tmp1564_;
			ValaDataType* _tmp1565_;
			ValaDataType* _tmp1566_;
			_tmp1559_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1560_ = _tmp1559_;
			_tmp1561_ = vala_member_access_get_inner (self);
			_tmp1562_ = _tmp1561_;
			_tmp1563_ = vala_expression_get_value_type (_tmp1562_);
			_tmp1564_ = _tmp1563_;
			_tmp1565_ = vala_data_type_get_actual_type (_tmp1560_, _tmp1564_, NULL, (ValaCodeNode*) self);
			_tmp1566_ = _tmp1565_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1566_);
			_vala_code_node_unref0 (_tmp1566_);
		} else {
			ValaDataType* _tmp1567_;
			ValaDataType* _tmp1568_;
			_tmp1567_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1568_ = _tmp1567_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1568_);
		}
		_tmp1569_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1570_ = _tmp1569_;
		if (VALA_IS_METHOD (_tmp1570_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1571_;
			ValaSymbol* _tmp1572_;
			ValaDataType* _tmp1573_;
			ValaDataType* _tmp1574_;
			gboolean _tmp1581_ = FALSE;
			_tmp1571_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1572_ = _tmp1571_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1572_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1573_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1574_ = _tmp1573_;
			if (_tmp1574_ != NULL) {
				ValaDataType* _tmp1575_;
				ValaDataType* _tmp1576_;
				ValaDataType* _tmp1577_;
				ValaDataType* _tmp1578_;
				gboolean _tmp1579_;
				gboolean _tmp1580_;
				_tmp1575_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1576_ = _tmp1575_;
				_tmp1577_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = vala_data_type_get_value_owned (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				vala_data_type_set_value_owned (_tmp1576_, _tmp1580_);
			}
			if (instance) {
				ValaMethod* _tmp1582_;
				ValaSymbol* _tmp1583_;
				ValaSymbol* _tmp1584_;
				_tmp1582_ = method;
				_tmp1583_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1581_ = VALA_IS_TYPESYMBOL (_tmp1584_);
			} else {
				_tmp1581_ = FALSE;
			}
			if (_tmp1581_) {
				ValaExpression* _tmp1585_;
				ValaExpression* _tmp1586_;
				ValaMethod* _tmp1587_;
				ValaSymbol* _tmp1588_;
				ValaSymbol* _tmp1589_;
				ValaDataType* _tmp1590_;
				ValaDataType* _tmp1591_;
				ValaExpression* _tmp1592_;
				ValaExpression* _tmp1593_;
				ValaDataType* _tmp1594_;
				ValaDataType* _tmp1595_;
				ValaMethod* _tmp1596_;
				ValaParameter* _tmp1597_;
				ValaParameter* _tmp1598_;
				ValaDataType* _tmp1599_;
				ValaDataType* _tmp1600_;
				gboolean _tmp1601_;
				gboolean _tmp1602_;
				_tmp1585_ = vala_member_access_get_inner (self);
				_tmp1586_ = _tmp1585_;
				_tmp1587_ = method;
				_tmp1588_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1590_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1589_);
				_tmp1591_ = _tmp1590_;
				vala_expression_set_target_type (_tmp1586_, _tmp1591_);
				_vala_code_node_unref0 (_tmp1591_);
				_tmp1592_ = vala_member_access_get_inner (self);
				_tmp1593_ = _tmp1592_;
				_tmp1594_ = vala_expression_get_target_type (_tmp1593_);
				_tmp1595_ = _tmp1594_;
				_tmp1596_ = method;
				_tmp1597_ = vala_method_get_this_parameter (_tmp1596_);
				_tmp1598_ = _tmp1597_;
				_tmp1599_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1598_);
				_tmp1600_ = _tmp1599_;
				_tmp1601_ = vala_data_type_get_value_owned (_tmp1600_);
				_tmp1602_ = _tmp1601_;
				vala_data_type_set_value_owned (_tmp1595_, _tmp1602_);
			}
		} else {
			gboolean _tmp1603_ = FALSE;
			gboolean _tmp1604_ = FALSE;
			ValaSymbol* _tmp1605_;
			ValaSymbol* _tmp1606_;
			_tmp1605_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1606_ = _tmp1605_;
			if (VALA_IS_PROPERTY (_tmp1606_)) {
				_tmp1604_ = instance;
			} else {
				_tmp1604_ = FALSE;
			}
			if (_tmp1604_) {
				ValaSymbol* _tmp1607_;
				ValaSymbol* _tmp1608_;
				ValaSymbol* _tmp1609_;
				ValaSymbol* _tmp1610_;
				_tmp1607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1608_ = _tmp1607_;
				_tmp1609_ = vala_symbol_get_parent_symbol (_tmp1608_);
				_tmp1610_ = _tmp1609_;
				_tmp1603_ = _tmp1610_ != NULL;
			} else {
				_tmp1603_ = FALSE;
			}
			if (_tmp1603_) {
				ValaExpression* _tmp1611_;
				ValaExpression* _tmp1612_;
				ValaSymbol* _tmp1613_;
				ValaSymbol* _tmp1614_;
				ValaSymbol* _tmp1615_;
				ValaSymbol* _tmp1616_;
				ValaDataType* _tmp1617_;
				ValaDataType* _tmp1618_;
				_tmp1611_ = vala_member_access_get_inner (self);
				_tmp1612_ = _tmp1611_;
				_tmp1613_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1614_ = _tmp1613_;
				_tmp1615_ = vala_symbol_get_parent_symbol (_tmp1614_);
				_tmp1616_ = _tmp1615_;
				_tmp1617_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1616_);
				_tmp1618_ = _tmp1617_;
				vala_expression_set_target_type (_tmp1612_, _tmp1618_);
				_vala_code_node_unref0 (_tmp1618_);
			} else {
				gboolean _tmp1619_ = FALSE;
				gboolean _tmp1620_ = FALSE;
				gboolean _tmp1621_ = FALSE;
				ValaSymbol* _tmp1622_;
				ValaSymbol* _tmp1623_;
				_tmp1622_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1623_ = _tmp1622_;
				if (VALA_IS_FIELD (_tmp1623_)) {
					_tmp1621_ = TRUE;
				} else {
					ValaSymbol* _tmp1624_;
					ValaSymbol* _tmp1625_;
					_tmp1624_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1625_ = _tmp1624_;
					_tmp1621_ = VALA_IS_SIGNAL (_tmp1625_);
				}
				if (_tmp1621_) {
					_tmp1620_ = instance;
				} else {
					_tmp1620_ = FALSE;
				}
				if (_tmp1620_) {
					ValaSymbol* _tmp1626_;
					ValaSymbol* _tmp1627_;
					ValaSymbol* _tmp1628_;
					ValaSymbol* _tmp1629_;
					_tmp1626_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1627_ = _tmp1626_;
					_tmp1628_ = vala_symbol_get_parent_symbol (_tmp1627_);
					_tmp1629_ = _tmp1628_;
					_tmp1619_ = _tmp1629_ != NULL;
				} else {
					_tmp1619_ = FALSE;
				}
				if (_tmp1619_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1630_;
					ValaSymbol* _tmp1631_;
					ValaSymbol* _tmp1632_;
					ValaSymbol* _tmp1633_;
					ValaDataType* _tmp1634_;
					ValaExpression* _tmp1635_;
					ValaExpression* _tmp1636_;
					ValaDataType* _tmp1637_;
					ValaExpression* _tmp1638_;
					ValaExpression* _tmp1639_;
					ValaDataType* _tmp1640_;
					ValaDataType* _tmp1641_;
					ValaDataType* _tmp1642_;
					ValaDataType* _tmp1643_;
					_tmp1630_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1631_ = _tmp1630_;
					_tmp1632_ = vala_symbol_get_parent_symbol (_tmp1631_);
					_tmp1633_ = _tmp1632_;
					_tmp1634_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1633_);
					parent_type = _tmp1634_;
					_tmp1635_ = vala_member_access_get_inner (self);
					_tmp1636_ = _tmp1635_;
					_tmp1637_ = parent_type;
					_tmp1638_ = vala_member_access_get_inner (self);
					_tmp1639_ = _tmp1638_;
					_tmp1640_ = vala_expression_get_value_type (_tmp1639_);
					_tmp1641_ = _tmp1640_;
					_tmp1642_ = vala_data_type_get_actual_type (_tmp1637_, _tmp1641_, NULL, (ValaCodeNode*) self);
					_tmp1643_ = _tmp1642_;
					vala_expression_set_target_type (_tmp1636_, _tmp1643_);
					_vala_code_node_unref0 (_tmp1643_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_tmp1646_ = vala_member_access_get_inner (self);
		_tmp1647_ = _tmp1646_;
		if (_tmp1647_ == NULL) {
			ValaDataType* _tmp1648_;
			ValaDataType* _tmp1649_;
			_tmp1648_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1649_ = _tmp1648_;
			_tmp1645_ = _tmp1649_ != NULL;
		} else {
			_tmp1645_ = FALSE;
		}
		if (_tmp1645_) {
			ValaProfile _tmp1650_;
			ValaProfile _tmp1651_;
			_tmp1650_ = vala_code_context_get_profile (context);
			_tmp1651_ = _tmp1650_;
			_tmp1644_ = _tmp1651_ == VALA_PROFILE_GOBJECT;
		} else {
			_tmp1644_ = FALSE;
		}
		if (_tmp1644_) {
			vala_member_access_check_narrowed_value_type (self);
		}
	}
	_tmp1652_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1653_ = _tmp1652_;
	if (_tmp1653_ != NULL) {
		ValaDataType* _tmp1654_;
		ValaDataType* _tmp1655_;
		_tmp1654_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1655_ = _tmp1654_;
		vala_code_node_check ((ValaCodeNode*) _tmp1655_, context);
	}
	_tmp1656_ = self->priv->_tainted_access;
	if (!_tmp1656_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1657_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1658_ = _tmp1657_;
	result = !_tmp1658_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_check_narrowed_value_type (ValaMemberAccess* self)
{
	ValaVariable* variable = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaVariable* _tmp2_;
	ValaCodeNode* _tmp3_;
	ValaCodeNode* _tmp4_;
	gboolean is_negation = FALSE;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp5_;
	ValaCodeNode* _tmp6_;
	ValaIfStatement* if_statement = NULL;
	ValaArrayList* scope_type_checks = NULL;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaIfStatement* _tmp43_;
	ValaDataType* _tmp79_;
	ValaDataType* _tmp80_;
	ValaSymbol* _tmp81_;
	ValaSymbol* _tmp82_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	variable = VALA_IS_VARIABLE (_tmp1_) ? ((ValaVariable*) _tmp1_) : NULL;
	_tmp2_ = variable;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp4_ = _tmp3_;
	if (!VALA_IS_MEMBER_ACCESS (_tmp4_)) {
		return;
	}
	is_negation = FALSE;
	_tmp5_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	parent = _tmp6_;
	if_statement = NULL;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_TYPECHECK, NULL, NULL, _tmp7_);
	scope_type_checks = _tmp8_;
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		ValaCodeNode* _tmp10_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		ValaCodeNode* _tmp23_;
		ValaCodeNode* _tmp24_;
		ValaCodeNode* _tmp25_;
		ValaCodeNode* _tmp40_;
		ValaCodeNode* _tmp41_;
		ValaCodeNode* _tmp42_;
		_tmp10_ = parent;
		if (_tmp10_ != NULL) {
			ValaCodeNode* _tmp11_;
			_tmp11_ = parent;
			_tmp9_ = !VALA_IS_METHOD (_tmp11_);
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		_tmp12_ = parent;
		if (VALA_IS_TYPECHECK (_tmp12_)) {
			parent = NULL;
			break;
		}
		_tmp13_ = parent;
		_tmp14_ = vala_code_node_get_parent_node (_tmp13_);
		_tmp15_ = _tmp14_;
		if (VALA_IS_IF_STATEMENT (_tmp15_)) {
			ValaCodeNode* _tmp16_;
			ValaCodeNode* _tmp17_;
			ValaCodeNode* _tmp18_;
			ValaIfStatement* _tmp19_;
			ValaBlock* _tmp20_;
			ValaBlock* _tmp21_;
			ValaCodeNode* _tmp22_;
			_tmp16_ = parent;
			_tmp17_ = vala_code_node_get_parent_node (_tmp16_);
			_tmp18_ = _tmp17_;
			if_statement = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
			_tmp19_ = if_statement;
			_tmp20_ = vala_if_statement_get_false_statement (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = parent;
			is_negation = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp22_;
			break;
		}
		_tmp23_ = parent;
		_tmp24_ = vala_code_node_get_parent_node (_tmp23_);
		_tmp25_ = _tmp24_;
		if (VALA_IS_METHOD (_tmp25_)) {
			{
				ValaList* _expr_list = NULL;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaCodeNode* _tmp28_;
				ValaList* _tmp29_;
				gint _expr_size = 0;
				ValaList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _expr_index = 0;
				_tmp26_ = parent;
				_tmp27_ = vala_code_node_get_parent_node (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_method_get_preconditions (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_METHOD, ValaMethod));
				_expr_list = _tmp29_;
				_tmp30_ = _expr_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_expr_size = _tmp32_;
				_expr_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaExpression* expr = NULL;
					ValaList* _tmp35_;
					gpointer _tmp36_;
					ValaExpression* _tmp37_;
					_expr_index = _expr_index + 1;
					_tmp33_ = _expr_index;
					_tmp34_ = _expr_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _expr_list;
					_tmp36_ = vala_list_get (_tmp35_, _expr_index);
					expr = (ValaExpression*) _tmp36_;
					_tmp37_ = expr;
					if (VALA_IS_TYPECHECK (_tmp37_)) {
						ValaArrayList* _tmp38_;
						ValaExpression* _tmp39_;
						_tmp38_ = scope_type_checks;
						_tmp39_ = expr;
						vala_collection_add ((ValaCollection*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_TYPECHECK, ValaTypeCheck));
					}
					_vala_code_node_unref0 (expr);
				}
			}
			break;
		}
		_tmp40_ = parent;
		_tmp41_ = vala_code_node_get_parent_node (_tmp40_);
		_tmp42_ = _tmp41_;
		parent = _tmp42_;
	}
	_tmp43_ = if_statement;
	if (_tmp43_ != NULL) {
		ValaExpression* expr = NULL;
		ValaIfStatement* _tmp44_;
		ValaExpression* _tmp45_;
		ValaExpression* _tmp46_;
		gboolean _tmp47_ = FALSE;
		ValaExpression* _tmp48_;
		ValaTypeCheck* type_check = NULL;
		ValaExpression* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp44_ = if_statement;
		_tmp45_ = vala_if_statement_get_condition (_tmp44_);
		_tmp46_ = _tmp45_;
		expr = _tmp46_;
		_tmp48_ = expr;
		if (VALA_IS_UNARY_EXPRESSION (_tmp48_)) {
			ValaExpression* _tmp49_;
			ValaUnaryOperator _tmp50_;
			ValaUnaryOperator _tmp51_;
			_tmp49_ = expr;
			_tmp50_ = vala_unary_expression_get_operator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp51_ = _tmp50_;
			_tmp47_ = _tmp51_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION;
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaExpression* _tmp54_;
			_tmp52_ = expr;
			_tmp53_ = vala_unary_expression_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression));
			_tmp54_ = _tmp53_;
			expr = _tmp54_;
			is_negation = !is_negation;
		}
		_tmp55_ = expr;
		type_check = VALA_IS_TYPECHECK (_tmp55_) ? ((ValaTypeCheck*) _tmp55_) : NULL;
		if (!is_negation) {
			ValaTypeCheck* _tmp57_;
			_tmp57_ = type_check;
			_tmp56_ = _tmp57_ != NULL;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			ValaTypeSymbol* narrowed_symnol = NULL;
			ValaTypeCheck* _tmp58_;
			ValaDataType* _tmp59_;
			ValaDataType* _tmp60_;
			ValaTypeSymbol* _tmp61_;
			ValaTypeSymbol* _tmp62_;
			ValaVariable* _tmp63_;
			ValaTypeCheck* _tmp64_;
			ValaExpression* _tmp65_;
			ValaExpression* _tmp66_;
			ValaSymbol* _tmp67_;
			ValaSymbol* _tmp68_;
			_tmp58_ = type_check;
			_tmp59_ = vala_typecheck_get_type_reference (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_get_type_symbol (_tmp60_);
			_tmp62_ = _tmp61_;
			narrowed_symnol = _tmp62_;
			_tmp63_ = variable;
			_tmp64_ = type_check;
			_tmp65_ = vala_typecheck_get_expression (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_expression_get_symbol_reference (_tmp66_);
			_tmp68_ = _tmp67_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp68_) {
				ValaTypeSymbol* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				ValaTypeSymbol* _tmp72_;
				ValaTypeSymbol* _tmp73_;
				ValaDataType* _tmp77_;
				ValaDataType* _tmp78_;
				_tmp69_ = narrowed_symnol;
				_tmp70_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_data_type_get_type_symbol (_tmp71_);
				_tmp73_ = _tmp72_;
				if (_tmp69_ != _tmp73_) {
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					_tmp74_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp75_ = _tmp74_;
					_tmp76_ = narrowed_symnol;
					vala_data_type_set_context_symbol (_tmp75_, (ValaSymbol*) _tmp76_);
				}
				_tmp77_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp78_ = _tmp77_;
				vala_data_type_set_nullable (_tmp78_, FALSE);
			}
		}
	}
	_tmp79_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_data_type_get_context_symbol (_tmp80_);
	_tmp82_ = _tmp81_;
	if (_tmp82_ == NULL) {
		{
			ValaArrayList* _type_check_list = NULL;
			ValaArrayList* _tmp83_;
			gint _type_check_size = 0;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _type_check_index = 0;
			_tmp83_ = scope_type_checks;
			_type_check_list = _tmp83_;
			_tmp84_ = _type_check_list;
			_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_type_check_size = _tmp86_;
			_type_check_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				ValaTypeCheck* type_check = NULL;
				ValaArrayList* _tmp89_;
				gpointer _tmp90_;
				ValaTypeCheck* _tmp91_;
				ValaTypeSymbol* narrowed_symnol = NULL;
				ValaTypeCheck* _tmp92_;
				ValaDataType* _tmp93_;
				ValaDataType* _tmp94_;
				ValaTypeSymbol* _tmp95_;
				ValaTypeSymbol* _tmp96_;
				ValaVariable* _tmp97_;
				ValaTypeCheck* _tmp98_;
				ValaExpression* _tmp99_;
				ValaExpression* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaSymbol* _tmp102_;
				_type_check_index = _type_check_index + 1;
				_tmp87_ = _type_check_index;
				_tmp88_ = _type_check_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _type_check_list;
				_tmp90_ = vala_list_get ((ValaList*) _tmp89_, _type_check_index);
				_tmp91_ = _vala_code_node_ref0 ((ValaTypeCheck*) _tmp90_);
				type_check = _tmp91_;
				_tmp92_ = type_check;
				_tmp93_ = vala_typecheck_get_type_reference (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = vala_data_type_get_type_symbol (_tmp94_);
				_tmp96_ = _tmp95_;
				narrowed_symnol = _tmp96_;
				_tmp97_ = variable;
				_tmp98_ = type_check;
				_tmp99_ = vala_typecheck_get_expression (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = vala_expression_get_symbol_reference (_tmp100_);
				_tmp102_ = _tmp101_;
				if (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp102_) {
					ValaTypeSymbol* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaTypeSymbol* _tmp106_;
					ValaTypeSymbol* _tmp107_;
					ValaDataType* _tmp111_;
					ValaDataType* _tmp112_;
					_tmp103_ = narrowed_symnol;
					_tmp104_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_data_type_get_type_symbol (_tmp105_);
					_tmp107_ = _tmp106_;
					if (_tmp103_ != _tmp107_) {
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaTypeSymbol* _tmp110_;
						_tmp108_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp109_ = _tmp108_;
						_tmp110_ = narrowed_symnol;
						vala_data_type_set_context_symbol (_tmp109_, (ValaSymbol*) _tmp110_);
					}
					_tmp111_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp112_ = _tmp111_;
					vala_data_type_set_nullable (_tmp112_, FALSE);
				}
				_vala_code_node_unref0 (type_check);
			}
		}
	}
	_vala_iterable_unref0 (scope_type_checks);
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

