// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use atk_sys;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::FromValueOptional;
use glib::value::SetValue;
use glib::value::Value;
use glib::StaticType;
use glib::Type;
use gobject_sys;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum CoordType {
    Screen,
    Window,
    Parent,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CoordType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CoordType::{}",
            match *self {
                CoordType::Screen => "Screen",
                CoordType::Window => "Window",
                CoordType::Parent => "Parent",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for CoordType {
    type GlibType = atk_sys::AtkCoordType;

    fn to_glib(&self) -> atk_sys::AtkCoordType {
        match *self {
            CoordType::Screen => atk_sys::ATK_XY_SCREEN,
            CoordType::Window => atk_sys::ATK_XY_WINDOW,
            CoordType::Parent => atk_sys::ATK_XY_PARENT,
            CoordType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkCoordType> for CoordType {
    fn from_glib(value: atk_sys::AtkCoordType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => CoordType::Screen,
            1 => CoordType::Window,
            2 => CoordType::Parent,
            value => CoordType::__Unknown(value),
        }
    }
}

impl StaticType for CoordType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_coord_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CoordType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CoordType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CoordType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Layer {
    Invalid,
    Background,
    Canvas,
    Widget,
    Mdi,
    Popup,
    Overlay,
    Window,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Layer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Layer::{}",
            match *self {
                Layer::Invalid => "Invalid",
                Layer::Background => "Background",
                Layer::Canvas => "Canvas",
                Layer::Widget => "Widget",
                Layer::Mdi => "Mdi",
                Layer::Popup => "Popup",
                Layer::Overlay => "Overlay",
                Layer::Window => "Window",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Layer {
    type GlibType = atk_sys::AtkLayer;

    fn to_glib(&self) -> atk_sys::AtkLayer {
        match *self {
            Layer::Invalid => atk_sys::ATK_LAYER_INVALID,
            Layer::Background => atk_sys::ATK_LAYER_BACKGROUND,
            Layer::Canvas => atk_sys::ATK_LAYER_CANVAS,
            Layer::Widget => atk_sys::ATK_LAYER_WIDGET,
            Layer::Mdi => atk_sys::ATK_LAYER_MDI,
            Layer::Popup => atk_sys::ATK_LAYER_POPUP,
            Layer::Overlay => atk_sys::ATK_LAYER_OVERLAY,
            Layer::Window => atk_sys::ATK_LAYER_WINDOW,
            Layer::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkLayer> for Layer {
    fn from_glib(value: atk_sys::AtkLayer) -> Self {
        skip_assert_initialized!();
        match value {
            0 => Layer::Invalid,
            1 => Layer::Background,
            2 => Layer::Canvas,
            3 => Layer::Widget,
            4 => Layer::Mdi,
            5 => Layer::Popup,
            6 => Layer::Overlay,
            7 => Layer::Window,
            value => Layer::__Unknown(value),
        }
    }
}

impl StaticType for Layer {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_layer_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Layer {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Layer {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Layer {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum RelationType {
    Null,
    ControlledBy,
    ControllerFor,
    LabelFor,
    LabelledBy,
    MemberOf,
    NodeChildOf,
    FlowsTo,
    FlowsFrom,
    SubwindowOf,
    Embeds,
    EmbeddedBy,
    PopupFor,
    ParentWindowOf,
    DescribedBy,
    DescriptionFor,
    NodeParentOf,
    Details,
    DetailsFor,
    ErrorMessage,
    ErrorFor,
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RelationType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RelationType::{}",
            match *self {
                RelationType::Null => "Null",
                RelationType::ControlledBy => "ControlledBy",
                RelationType::ControllerFor => "ControllerFor",
                RelationType::LabelFor => "LabelFor",
                RelationType::LabelledBy => "LabelledBy",
                RelationType::MemberOf => "MemberOf",
                RelationType::NodeChildOf => "NodeChildOf",
                RelationType::FlowsTo => "FlowsTo",
                RelationType::FlowsFrom => "FlowsFrom",
                RelationType::SubwindowOf => "SubwindowOf",
                RelationType::Embeds => "Embeds",
                RelationType::EmbeddedBy => "EmbeddedBy",
                RelationType::PopupFor => "PopupFor",
                RelationType::ParentWindowOf => "ParentWindowOf",
                RelationType::DescribedBy => "DescribedBy",
                RelationType::DescriptionFor => "DescriptionFor",
                RelationType::NodeParentOf => "NodeParentOf",
                RelationType::Details => "Details",
                RelationType::DetailsFor => "DetailsFor",
                RelationType::ErrorMessage => "ErrorMessage",
                RelationType::ErrorFor => "ErrorFor",
                RelationType::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for RelationType {
    type GlibType = atk_sys::AtkRelationType;

    fn to_glib(&self) -> atk_sys::AtkRelationType {
        match *self {
            RelationType::Null => atk_sys::ATK_RELATION_NULL,
            RelationType::ControlledBy => atk_sys::ATK_RELATION_CONTROLLED_BY,
            RelationType::ControllerFor => atk_sys::ATK_RELATION_CONTROLLER_FOR,
            RelationType::LabelFor => atk_sys::ATK_RELATION_LABEL_FOR,
            RelationType::LabelledBy => atk_sys::ATK_RELATION_LABELLED_BY,
            RelationType::MemberOf => atk_sys::ATK_RELATION_MEMBER_OF,
            RelationType::NodeChildOf => atk_sys::ATK_RELATION_NODE_CHILD_OF,
            RelationType::FlowsTo => atk_sys::ATK_RELATION_FLOWS_TO,
            RelationType::FlowsFrom => atk_sys::ATK_RELATION_FLOWS_FROM,
            RelationType::SubwindowOf => atk_sys::ATK_RELATION_SUBWINDOW_OF,
            RelationType::Embeds => atk_sys::ATK_RELATION_EMBEDS,
            RelationType::EmbeddedBy => atk_sys::ATK_RELATION_EMBEDDED_BY,
            RelationType::PopupFor => atk_sys::ATK_RELATION_POPUP_FOR,
            RelationType::ParentWindowOf => atk_sys::ATK_RELATION_PARENT_WINDOW_OF,
            RelationType::DescribedBy => atk_sys::ATK_RELATION_DESCRIBED_BY,
            RelationType::DescriptionFor => atk_sys::ATK_RELATION_DESCRIPTION_FOR,
            RelationType::NodeParentOf => atk_sys::ATK_RELATION_NODE_PARENT_OF,
            RelationType::Details => atk_sys::ATK_RELATION_DETAILS,
            RelationType::DetailsFor => atk_sys::ATK_RELATION_DETAILS_FOR,
            RelationType::ErrorMessage => atk_sys::ATK_RELATION_ERROR_MESSAGE,
            RelationType::ErrorFor => atk_sys::ATK_RELATION_ERROR_FOR,
            RelationType::LastDefined => atk_sys::ATK_RELATION_LAST_DEFINED,
            RelationType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkRelationType> for RelationType {
    fn from_glib(value: atk_sys::AtkRelationType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => RelationType::Null,
            1 => RelationType::ControlledBy,
            2 => RelationType::ControllerFor,
            3 => RelationType::LabelFor,
            4 => RelationType::LabelledBy,
            5 => RelationType::MemberOf,
            6 => RelationType::NodeChildOf,
            7 => RelationType::FlowsTo,
            8 => RelationType::FlowsFrom,
            9 => RelationType::SubwindowOf,
            10 => RelationType::Embeds,
            11 => RelationType::EmbeddedBy,
            12 => RelationType::PopupFor,
            13 => RelationType::ParentWindowOf,
            14 => RelationType::DescribedBy,
            15 => RelationType::DescriptionFor,
            16 => RelationType::NodeParentOf,
            17 => RelationType::Details,
            18 => RelationType::DetailsFor,
            19 => RelationType::ErrorMessage,
            20 => RelationType::ErrorFor,
            21 => RelationType::LastDefined,
            value => RelationType::__Unknown(value),
        }
    }
}

impl StaticType for RelationType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_relation_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for RelationType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for RelationType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for RelationType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Role {
    Invalid,
    AcceleratorLabel,
    Alert,
    Animation,
    Arrow,
    Calendar,
    Canvas,
    CheckBox,
    CheckMenuItem,
    ColorChooser,
    ColumnHeader,
    ComboBox,
    DateEditor,
    DesktopIcon,
    DesktopFrame,
    Dial,
    Dialog,
    DirectoryPane,
    DrawingArea,
    FileChooser,
    Filler,
    FontChooser,
    Frame,
    GlassPane,
    HtmlContainer,
    Icon,
    Image,
    InternalFrame,
    Label,
    LayeredPane,
    List,
    ListItem,
    Menu,
    MenuBar,
    MenuItem,
    OptionPane,
    PageTab,
    PageTabList,
    Panel,
    PasswordText,
    PopupMenu,
    ProgressBar,
    PushButton,
    RadioButton,
    RadioMenuItem,
    RootPane,
    RowHeader,
    ScrollBar,
    ScrollPane,
    Separator,
    Slider,
    SplitPane,
    SpinButton,
    Statusbar,
    Table,
    TableCell,
    TableColumnHeader,
    TableRowHeader,
    TearOffMenuItem,
    Terminal,
    Text,
    ToggleButton,
    ToolBar,
    ToolTip,
    Tree,
    TreeTable,
    Unknown,
    Viewport,
    Window,
    Header,
    Footer,
    Paragraph,
    Ruler,
    Application,
    Autocomplete,
    EditBar,
    Embedded,
    Entry,
    Chart,
    Caption,
    DocumentFrame,
    Heading,
    Page,
    Section,
    RedundantObject,
    Form,
    Link,
    InputMethodWindow,
    TableRow,
    TreeItem,
    DocumentSpreadsheet,
    DocumentPresentation,
    DocumentText,
    DocumentWeb,
    DocumentEmail,
    Comment,
    ListBox,
    Grouping,
    ImageMap,
    Notification,
    InfoBar,
    LevelBar,
    TitleBar,
    BlockQuote,
    Audio,
    Video,
    Definition,
    Article,
    Landmark,
    Log,
    Marquee,
    Math,
    Rating,
    Timer,
    DescriptionList,
    DescriptionTerm,
    DescriptionValue,
    Static,
    MathFraction,
    MathRoot,
    Subscript,
    Superscript,
    Footnote,
    ContentDeletion,
    ContentInsertion,
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Role {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Role::{}",
            match *self {
                Role::Invalid => "Invalid",
                Role::AcceleratorLabel => "AcceleratorLabel",
                Role::Alert => "Alert",
                Role::Animation => "Animation",
                Role::Arrow => "Arrow",
                Role::Calendar => "Calendar",
                Role::Canvas => "Canvas",
                Role::CheckBox => "CheckBox",
                Role::CheckMenuItem => "CheckMenuItem",
                Role::ColorChooser => "ColorChooser",
                Role::ColumnHeader => "ColumnHeader",
                Role::ComboBox => "ComboBox",
                Role::DateEditor => "DateEditor",
                Role::DesktopIcon => "DesktopIcon",
                Role::DesktopFrame => "DesktopFrame",
                Role::Dial => "Dial",
                Role::Dialog => "Dialog",
                Role::DirectoryPane => "DirectoryPane",
                Role::DrawingArea => "DrawingArea",
                Role::FileChooser => "FileChooser",
                Role::Filler => "Filler",
                Role::FontChooser => "FontChooser",
                Role::Frame => "Frame",
                Role::GlassPane => "GlassPane",
                Role::HtmlContainer => "HtmlContainer",
                Role::Icon => "Icon",
                Role::Image => "Image",
                Role::InternalFrame => "InternalFrame",
                Role::Label => "Label",
                Role::LayeredPane => "LayeredPane",
                Role::List => "List",
                Role::ListItem => "ListItem",
                Role::Menu => "Menu",
                Role::MenuBar => "MenuBar",
                Role::MenuItem => "MenuItem",
                Role::OptionPane => "OptionPane",
                Role::PageTab => "PageTab",
                Role::PageTabList => "PageTabList",
                Role::Panel => "Panel",
                Role::PasswordText => "PasswordText",
                Role::PopupMenu => "PopupMenu",
                Role::ProgressBar => "ProgressBar",
                Role::PushButton => "PushButton",
                Role::RadioButton => "RadioButton",
                Role::RadioMenuItem => "RadioMenuItem",
                Role::RootPane => "RootPane",
                Role::RowHeader => "RowHeader",
                Role::ScrollBar => "ScrollBar",
                Role::ScrollPane => "ScrollPane",
                Role::Separator => "Separator",
                Role::Slider => "Slider",
                Role::SplitPane => "SplitPane",
                Role::SpinButton => "SpinButton",
                Role::Statusbar => "Statusbar",
                Role::Table => "Table",
                Role::TableCell => "TableCell",
                Role::TableColumnHeader => "TableColumnHeader",
                Role::TableRowHeader => "TableRowHeader",
                Role::TearOffMenuItem => "TearOffMenuItem",
                Role::Terminal => "Terminal",
                Role::Text => "Text",
                Role::ToggleButton => "ToggleButton",
                Role::ToolBar => "ToolBar",
                Role::ToolTip => "ToolTip",
                Role::Tree => "Tree",
                Role::TreeTable => "TreeTable",
                Role::Unknown => "Unknown",
                Role::Viewport => "Viewport",
                Role::Window => "Window",
                Role::Header => "Header",
                Role::Footer => "Footer",
                Role::Paragraph => "Paragraph",
                Role::Ruler => "Ruler",
                Role::Application => "Application",
                Role::Autocomplete => "Autocomplete",
                Role::EditBar => "EditBar",
                Role::Embedded => "Embedded",
                Role::Entry => "Entry",
                Role::Chart => "Chart",
                Role::Caption => "Caption",
                Role::DocumentFrame => "DocumentFrame",
                Role::Heading => "Heading",
                Role::Page => "Page",
                Role::Section => "Section",
                Role::RedundantObject => "RedundantObject",
                Role::Form => "Form",
                Role::Link => "Link",
                Role::InputMethodWindow => "InputMethodWindow",
                Role::TableRow => "TableRow",
                Role::TreeItem => "TreeItem",
                Role::DocumentSpreadsheet => "DocumentSpreadsheet",
                Role::DocumentPresentation => "DocumentPresentation",
                Role::DocumentText => "DocumentText",
                Role::DocumentWeb => "DocumentWeb",
                Role::DocumentEmail => "DocumentEmail",
                Role::Comment => "Comment",
                Role::ListBox => "ListBox",
                Role::Grouping => "Grouping",
                Role::ImageMap => "ImageMap",
                Role::Notification => "Notification",
                Role::InfoBar => "InfoBar",
                Role::LevelBar => "LevelBar",
                Role::TitleBar => "TitleBar",
                Role::BlockQuote => "BlockQuote",
                Role::Audio => "Audio",
                Role::Video => "Video",
                Role::Definition => "Definition",
                Role::Article => "Article",
                Role::Landmark => "Landmark",
                Role::Log => "Log",
                Role::Marquee => "Marquee",
                Role::Math => "Math",
                Role::Rating => "Rating",
                Role::Timer => "Timer",
                Role::DescriptionList => "DescriptionList",
                Role::DescriptionTerm => "DescriptionTerm",
                Role::DescriptionValue => "DescriptionValue",
                Role::Static => "Static",
                Role::MathFraction => "MathFraction",
                Role::MathRoot => "MathRoot",
                Role::Subscript => "Subscript",
                Role::Superscript => "Superscript",
                Role::Footnote => "Footnote",
                Role::ContentDeletion => "ContentDeletion",
                Role::ContentInsertion => "ContentInsertion",
                Role::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Role {
    type GlibType = atk_sys::AtkRole;

    fn to_glib(&self) -> atk_sys::AtkRole {
        match *self {
            Role::Invalid => atk_sys::ATK_ROLE_INVALID,
            Role::AcceleratorLabel => atk_sys::ATK_ROLE_ACCEL_LABEL,
            Role::Alert => atk_sys::ATK_ROLE_ALERT,
            Role::Animation => atk_sys::ATK_ROLE_ANIMATION,
            Role::Arrow => atk_sys::ATK_ROLE_ARROW,
            Role::Calendar => atk_sys::ATK_ROLE_CALENDAR,
            Role::Canvas => atk_sys::ATK_ROLE_CANVAS,
            Role::CheckBox => atk_sys::ATK_ROLE_CHECK_BOX,
            Role::CheckMenuItem => atk_sys::ATK_ROLE_CHECK_MENU_ITEM,
            Role::ColorChooser => atk_sys::ATK_ROLE_COLOR_CHOOSER,
            Role::ColumnHeader => atk_sys::ATK_ROLE_COLUMN_HEADER,
            Role::ComboBox => atk_sys::ATK_ROLE_COMBO_BOX,
            Role::DateEditor => atk_sys::ATK_ROLE_DATE_EDITOR,
            Role::DesktopIcon => atk_sys::ATK_ROLE_DESKTOP_ICON,
            Role::DesktopFrame => atk_sys::ATK_ROLE_DESKTOP_FRAME,
            Role::Dial => atk_sys::ATK_ROLE_DIAL,
            Role::Dialog => atk_sys::ATK_ROLE_DIALOG,
            Role::DirectoryPane => atk_sys::ATK_ROLE_DIRECTORY_PANE,
            Role::DrawingArea => atk_sys::ATK_ROLE_DRAWING_AREA,
            Role::FileChooser => atk_sys::ATK_ROLE_FILE_CHOOSER,
            Role::Filler => atk_sys::ATK_ROLE_FILLER,
            Role::FontChooser => atk_sys::ATK_ROLE_FONT_CHOOSER,
            Role::Frame => atk_sys::ATK_ROLE_FRAME,
            Role::GlassPane => atk_sys::ATK_ROLE_GLASS_PANE,
            Role::HtmlContainer => atk_sys::ATK_ROLE_HTML_CONTAINER,
            Role::Icon => atk_sys::ATK_ROLE_ICON,
            Role::Image => atk_sys::ATK_ROLE_IMAGE,
            Role::InternalFrame => atk_sys::ATK_ROLE_INTERNAL_FRAME,
            Role::Label => atk_sys::ATK_ROLE_LABEL,
            Role::LayeredPane => atk_sys::ATK_ROLE_LAYERED_PANE,
            Role::List => atk_sys::ATK_ROLE_LIST,
            Role::ListItem => atk_sys::ATK_ROLE_LIST_ITEM,
            Role::Menu => atk_sys::ATK_ROLE_MENU,
            Role::MenuBar => atk_sys::ATK_ROLE_MENU_BAR,
            Role::MenuItem => atk_sys::ATK_ROLE_MENU_ITEM,
            Role::OptionPane => atk_sys::ATK_ROLE_OPTION_PANE,
            Role::PageTab => atk_sys::ATK_ROLE_PAGE_TAB,
            Role::PageTabList => atk_sys::ATK_ROLE_PAGE_TAB_LIST,
            Role::Panel => atk_sys::ATK_ROLE_PANEL,
            Role::PasswordText => atk_sys::ATK_ROLE_PASSWORD_TEXT,
            Role::PopupMenu => atk_sys::ATK_ROLE_POPUP_MENU,
            Role::ProgressBar => atk_sys::ATK_ROLE_PROGRESS_BAR,
            Role::PushButton => atk_sys::ATK_ROLE_PUSH_BUTTON,
            Role::RadioButton => atk_sys::ATK_ROLE_RADIO_BUTTON,
            Role::RadioMenuItem => atk_sys::ATK_ROLE_RADIO_MENU_ITEM,
            Role::RootPane => atk_sys::ATK_ROLE_ROOT_PANE,
            Role::RowHeader => atk_sys::ATK_ROLE_ROW_HEADER,
            Role::ScrollBar => atk_sys::ATK_ROLE_SCROLL_BAR,
            Role::ScrollPane => atk_sys::ATK_ROLE_SCROLL_PANE,
            Role::Separator => atk_sys::ATK_ROLE_SEPARATOR,
            Role::Slider => atk_sys::ATK_ROLE_SLIDER,
            Role::SplitPane => atk_sys::ATK_ROLE_SPLIT_PANE,
            Role::SpinButton => atk_sys::ATK_ROLE_SPIN_BUTTON,
            Role::Statusbar => atk_sys::ATK_ROLE_STATUSBAR,
            Role::Table => atk_sys::ATK_ROLE_TABLE,
            Role::TableCell => atk_sys::ATK_ROLE_TABLE_CELL,
            Role::TableColumnHeader => atk_sys::ATK_ROLE_TABLE_COLUMN_HEADER,
            Role::TableRowHeader => atk_sys::ATK_ROLE_TABLE_ROW_HEADER,
            Role::TearOffMenuItem => atk_sys::ATK_ROLE_TEAR_OFF_MENU_ITEM,
            Role::Terminal => atk_sys::ATK_ROLE_TERMINAL,
            Role::Text => atk_sys::ATK_ROLE_TEXT,
            Role::ToggleButton => atk_sys::ATK_ROLE_TOGGLE_BUTTON,
            Role::ToolBar => atk_sys::ATK_ROLE_TOOL_BAR,
            Role::ToolTip => atk_sys::ATK_ROLE_TOOL_TIP,
            Role::Tree => atk_sys::ATK_ROLE_TREE,
            Role::TreeTable => atk_sys::ATK_ROLE_TREE_TABLE,
            Role::Unknown => atk_sys::ATK_ROLE_UNKNOWN,
            Role::Viewport => atk_sys::ATK_ROLE_VIEWPORT,
            Role::Window => atk_sys::ATK_ROLE_WINDOW,
            Role::Header => atk_sys::ATK_ROLE_HEADER,
            Role::Footer => atk_sys::ATK_ROLE_FOOTER,
            Role::Paragraph => atk_sys::ATK_ROLE_PARAGRAPH,
            Role::Ruler => atk_sys::ATK_ROLE_RULER,
            Role::Application => atk_sys::ATK_ROLE_APPLICATION,
            Role::Autocomplete => atk_sys::ATK_ROLE_AUTOCOMPLETE,
            Role::EditBar => atk_sys::ATK_ROLE_EDITBAR,
            Role::Embedded => atk_sys::ATK_ROLE_EMBEDDED,
            Role::Entry => atk_sys::ATK_ROLE_ENTRY,
            Role::Chart => atk_sys::ATK_ROLE_CHART,
            Role::Caption => atk_sys::ATK_ROLE_CAPTION,
            Role::DocumentFrame => atk_sys::ATK_ROLE_DOCUMENT_FRAME,
            Role::Heading => atk_sys::ATK_ROLE_HEADING,
            Role::Page => atk_sys::ATK_ROLE_PAGE,
            Role::Section => atk_sys::ATK_ROLE_SECTION,
            Role::RedundantObject => atk_sys::ATK_ROLE_REDUNDANT_OBJECT,
            Role::Form => atk_sys::ATK_ROLE_FORM,
            Role::Link => atk_sys::ATK_ROLE_LINK,
            Role::InputMethodWindow => atk_sys::ATK_ROLE_INPUT_METHOD_WINDOW,
            Role::TableRow => atk_sys::ATK_ROLE_TABLE_ROW,
            Role::TreeItem => atk_sys::ATK_ROLE_TREE_ITEM,
            Role::DocumentSpreadsheet => atk_sys::ATK_ROLE_DOCUMENT_SPREADSHEET,
            Role::DocumentPresentation => atk_sys::ATK_ROLE_DOCUMENT_PRESENTATION,
            Role::DocumentText => atk_sys::ATK_ROLE_DOCUMENT_TEXT,
            Role::DocumentWeb => atk_sys::ATK_ROLE_DOCUMENT_WEB,
            Role::DocumentEmail => atk_sys::ATK_ROLE_DOCUMENT_EMAIL,
            Role::Comment => atk_sys::ATK_ROLE_COMMENT,
            Role::ListBox => atk_sys::ATK_ROLE_LIST_BOX,
            Role::Grouping => atk_sys::ATK_ROLE_GROUPING,
            Role::ImageMap => atk_sys::ATK_ROLE_IMAGE_MAP,
            Role::Notification => atk_sys::ATK_ROLE_NOTIFICATION,
            Role::InfoBar => atk_sys::ATK_ROLE_INFO_BAR,
            Role::LevelBar => atk_sys::ATK_ROLE_LEVEL_BAR,
            Role::TitleBar => atk_sys::ATK_ROLE_TITLE_BAR,
            Role::BlockQuote => atk_sys::ATK_ROLE_BLOCK_QUOTE,
            Role::Audio => atk_sys::ATK_ROLE_AUDIO,
            Role::Video => atk_sys::ATK_ROLE_VIDEO,
            Role::Definition => atk_sys::ATK_ROLE_DEFINITION,
            Role::Article => atk_sys::ATK_ROLE_ARTICLE,
            Role::Landmark => atk_sys::ATK_ROLE_LANDMARK,
            Role::Log => atk_sys::ATK_ROLE_LOG,
            Role::Marquee => atk_sys::ATK_ROLE_MARQUEE,
            Role::Math => atk_sys::ATK_ROLE_MATH,
            Role::Rating => atk_sys::ATK_ROLE_RATING,
            Role::Timer => atk_sys::ATK_ROLE_TIMER,
            Role::DescriptionList => atk_sys::ATK_ROLE_DESCRIPTION_LIST,
            Role::DescriptionTerm => atk_sys::ATK_ROLE_DESCRIPTION_TERM,
            Role::DescriptionValue => atk_sys::ATK_ROLE_DESCRIPTION_VALUE,
            Role::Static => atk_sys::ATK_ROLE_STATIC,
            Role::MathFraction => atk_sys::ATK_ROLE_MATH_FRACTION,
            Role::MathRoot => atk_sys::ATK_ROLE_MATH_ROOT,
            Role::Subscript => atk_sys::ATK_ROLE_SUBSCRIPT,
            Role::Superscript => atk_sys::ATK_ROLE_SUPERSCRIPT,
            Role::Footnote => atk_sys::ATK_ROLE_FOOTNOTE,
            Role::ContentDeletion => atk_sys::ATK_ROLE_CONTENT_DELETION,
            Role::ContentInsertion => atk_sys::ATK_ROLE_CONTENT_INSERTION,
            Role::LastDefined => atk_sys::ATK_ROLE_LAST_DEFINED,
            Role::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkRole> for Role {
    fn from_glib(value: atk_sys::AtkRole) -> Self {
        skip_assert_initialized!();
        match value {
            0 => Role::Invalid,
            1 => Role::AcceleratorLabel,
            2 => Role::Alert,
            3 => Role::Animation,
            4 => Role::Arrow,
            5 => Role::Calendar,
            6 => Role::Canvas,
            7 => Role::CheckBox,
            8 => Role::CheckMenuItem,
            9 => Role::ColorChooser,
            10 => Role::ColumnHeader,
            11 => Role::ComboBox,
            12 => Role::DateEditor,
            13 => Role::DesktopIcon,
            14 => Role::DesktopFrame,
            15 => Role::Dial,
            16 => Role::Dialog,
            17 => Role::DirectoryPane,
            18 => Role::DrawingArea,
            19 => Role::FileChooser,
            20 => Role::Filler,
            21 => Role::FontChooser,
            22 => Role::Frame,
            23 => Role::GlassPane,
            24 => Role::HtmlContainer,
            25 => Role::Icon,
            26 => Role::Image,
            27 => Role::InternalFrame,
            28 => Role::Label,
            29 => Role::LayeredPane,
            30 => Role::List,
            31 => Role::ListItem,
            32 => Role::Menu,
            33 => Role::MenuBar,
            34 => Role::MenuItem,
            35 => Role::OptionPane,
            36 => Role::PageTab,
            37 => Role::PageTabList,
            38 => Role::Panel,
            39 => Role::PasswordText,
            40 => Role::PopupMenu,
            41 => Role::ProgressBar,
            42 => Role::PushButton,
            43 => Role::RadioButton,
            44 => Role::RadioMenuItem,
            45 => Role::RootPane,
            46 => Role::RowHeader,
            47 => Role::ScrollBar,
            48 => Role::ScrollPane,
            49 => Role::Separator,
            50 => Role::Slider,
            51 => Role::SplitPane,
            52 => Role::SpinButton,
            53 => Role::Statusbar,
            54 => Role::Table,
            55 => Role::TableCell,
            56 => Role::TableColumnHeader,
            57 => Role::TableRowHeader,
            58 => Role::TearOffMenuItem,
            59 => Role::Terminal,
            60 => Role::Text,
            61 => Role::ToggleButton,
            62 => Role::ToolBar,
            63 => Role::ToolTip,
            64 => Role::Tree,
            65 => Role::TreeTable,
            66 => Role::Unknown,
            67 => Role::Viewport,
            68 => Role::Window,
            69 => Role::Header,
            70 => Role::Footer,
            71 => Role::Paragraph,
            72 => Role::Ruler,
            73 => Role::Application,
            74 => Role::Autocomplete,
            75 => Role::EditBar,
            76 => Role::Embedded,
            77 => Role::Entry,
            78 => Role::Chart,
            79 => Role::Caption,
            80 => Role::DocumentFrame,
            81 => Role::Heading,
            82 => Role::Page,
            83 => Role::Section,
            84 => Role::RedundantObject,
            85 => Role::Form,
            86 => Role::Link,
            87 => Role::InputMethodWindow,
            88 => Role::TableRow,
            89 => Role::TreeItem,
            90 => Role::DocumentSpreadsheet,
            91 => Role::DocumentPresentation,
            92 => Role::DocumentText,
            93 => Role::DocumentWeb,
            94 => Role::DocumentEmail,
            95 => Role::Comment,
            96 => Role::ListBox,
            97 => Role::Grouping,
            98 => Role::ImageMap,
            99 => Role::Notification,
            100 => Role::InfoBar,
            101 => Role::LevelBar,
            102 => Role::TitleBar,
            103 => Role::BlockQuote,
            104 => Role::Audio,
            105 => Role::Video,
            106 => Role::Definition,
            107 => Role::Article,
            108 => Role::Landmark,
            109 => Role::Log,
            110 => Role::Marquee,
            111 => Role::Math,
            112 => Role::Rating,
            113 => Role::Timer,
            114 => Role::DescriptionList,
            115 => Role::DescriptionTerm,
            116 => Role::DescriptionValue,
            117 => Role::Static,
            118 => Role::MathFraction,
            119 => Role::MathRoot,
            120 => Role::Subscript,
            121 => Role::Superscript,
            122 => Role::Footnote,
            123 => Role::ContentDeletion,
            124 => Role::ContentInsertion,
            125 => Role::LastDefined,
            value => Role::__Unknown(value),
        }
    }
}

impl StaticType for Role {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_role_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Role {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Role {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Role {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ScrollType {
    TopLeft,
    BottomRight,
    TopEdge,
    BottomEdge,
    LeftEdge,
    RightEdge,
    Anywhere,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
impl fmt::Display for ScrollType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ScrollType::{}",
            match *self {
                ScrollType::TopLeft => "TopLeft",
                ScrollType::BottomRight => "BottomRight",
                ScrollType::TopEdge => "TopEdge",
                ScrollType::BottomEdge => "BottomEdge",
                ScrollType::LeftEdge => "LeftEdge",
                ScrollType::RightEdge => "RightEdge",
                ScrollType::Anywhere => "Anywhere",
                _ => "Unknown",
            }
        )
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[doc(hidden)]
impl ToGlib for ScrollType {
    type GlibType = atk_sys::AtkScrollType;

    fn to_glib(&self) -> atk_sys::AtkScrollType {
        match *self {
            ScrollType::TopLeft => atk_sys::ATK_SCROLL_TOP_LEFT,
            ScrollType::BottomRight => atk_sys::ATK_SCROLL_BOTTOM_RIGHT,
            ScrollType::TopEdge => atk_sys::ATK_SCROLL_TOP_EDGE,
            ScrollType::BottomEdge => atk_sys::ATK_SCROLL_BOTTOM_EDGE,
            ScrollType::LeftEdge => atk_sys::ATK_SCROLL_LEFT_EDGE,
            ScrollType::RightEdge => atk_sys::ATK_SCROLL_RIGHT_EDGE,
            ScrollType::Anywhere => atk_sys::ATK_SCROLL_ANYWHERE,
            ScrollType::__Unknown(value) => value,
        }
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[doc(hidden)]
impl FromGlib<atk_sys::AtkScrollType> for ScrollType {
    fn from_glib(value: atk_sys::AtkScrollType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ScrollType::TopLeft,
            1 => ScrollType::BottomRight,
            2 => ScrollType::TopEdge,
            3 => ScrollType::BottomEdge,
            4 => ScrollType::LeftEdge,
            5 => ScrollType::RightEdge,
            6 => ScrollType::Anywhere,
            value => ScrollType::__Unknown(value),
        }
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
impl StaticType for ScrollType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_scroll_type_get_type()) }
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
impl<'a> FromValueOptional<'a> for ScrollType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
impl<'a> FromValue<'a> for ScrollType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
impl SetValue for ScrollType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum StateType {
    Invalid,
    Active,
    Armed,
    Busy,
    Checked,
    Defunct,
    Editable,
    Enabled,
    Expandable,
    Expanded,
    Focusable,
    Focused,
    Horizontal,
    Iconified,
    Modal,
    MultiLine,
    Multiselectable,
    Opaque,
    Pressed,
    Resizable,
    Selectable,
    Selected,
    Sensitive,
    Showing,
    SingleLine,
    Stale,
    Transient,
    Vertical,
    Visible,
    ManagesDescendants,
    Indeterminate,
    Truncated,
    Required,
    InvalidEntry,
    SupportsAutocompletion,
    SelectableText,
    Default,
    Animated,
    Visited,
    Checkable,
    HasPopup,
    HasTooltip,
    ReadOnly,
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for StateType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "StateType::{}",
            match *self {
                StateType::Invalid => "Invalid",
                StateType::Active => "Active",
                StateType::Armed => "Armed",
                StateType::Busy => "Busy",
                StateType::Checked => "Checked",
                StateType::Defunct => "Defunct",
                StateType::Editable => "Editable",
                StateType::Enabled => "Enabled",
                StateType::Expandable => "Expandable",
                StateType::Expanded => "Expanded",
                StateType::Focusable => "Focusable",
                StateType::Focused => "Focused",
                StateType::Horizontal => "Horizontal",
                StateType::Iconified => "Iconified",
                StateType::Modal => "Modal",
                StateType::MultiLine => "MultiLine",
                StateType::Multiselectable => "Multiselectable",
                StateType::Opaque => "Opaque",
                StateType::Pressed => "Pressed",
                StateType::Resizable => "Resizable",
                StateType::Selectable => "Selectable",
                StateType::Selected => "Selected",
                StateType::Sensitive => "Sensitive",
                StateType::Showing => "Showing",
                StateType::SingleLine => "SingleLine",
                StateType::Stale => "Stale",
                StateType::Transient => "Transient",
                StateType::Vertical => "Vertical",
                StateType::Visible => "Visible",
                StateType::ManagesDescendants => "ManagesDescendants",
                StateType::Indeterminate => "Indeterminate",
                StateType::Truncated => "Truncated",
                StateType::Required => "Required",
                StateType::InvalidEntry => "InvalidEntry",
                StateType::SupportsAutocompletion => "SupportsAutocompletion",
                StateType::SelectableText => "SelectableText",
                StateType::Default => "Default",
                StateType::Animated => "Animated",
                StateType::Visited => "Visited",
                StateType::Checkable => "Checkable",
                StateType::HasPopup => "HasPopup",
                StateType::HasTooltip => "HasTooltip",
                StateType::ReadOnly => "ReadOnly",
                StateType::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for StateType {
    type GlibType = atk_sys::AtkStateType;

    fn to_glib(&self) -> atk_sys::AtkStateType {
        match *self {
            StateType::Invalid => atk_sys::ATK_STATE_INVALID,
            StateType::Active => atk_sys::ATK_STATE_ACTIVE,
            StateType::Armed => atk_sys::ATK_STATE_ARMED,
            StateType::Busy => atk_sys::ATK_STATE_BUSY,
            StateType::Checked => atk_sys::ATK_STATE_CHECKED,
            StateType::Defunct => atk_sys::ATK_STATE_DEFUNCT,
            StateType::Editable => atk_sys::ATK_STATE_EDITABLE,
            StateType::Enabled => atk_sys::ATK_STATE_ENABLED,
            StateType::Expandable => atk_sys::ATK_STATE_EXPANDABLE,
            StateType::Expanded => atk_sys::ATK_STATE_EXPANDED,
            StateType::Focusable => atk_sys::ATK_STATE_FOCUSABLE,
            StateType::Focused => atk_sys::ATK_STATE_FOCUSED,
            StateType::Horizontal => atk_sys::ATK_STATE_HORIZONTAL,
            StateType::Iconified => atk_sys::ATK_STATE_ICONIFIED,
            StateType::Modal => atk_sys::ATK_STATE_MODAL,
            StateType::MultiLine => atk_sys::ATK_STATE_MULTI_LINE,
            StateType::Multiselectable => atk_sys::ATK_STATE_MULTISELECTABLE,
            StateType::Opaque => atk_sys::ATK_STATE_OPAQUE,
            StateType::Pressed => atk_sys::ATK_STATE_PRESSED,
            StateType::Resizable => atk_sys::ATK_STATE_RESIZABLE,
            StateType::Selectable => atk_sys::ATK_STATE_SELECTABLE,
            StateType::Selected => atk_sys::ATK_STATE_SELECTED,
            StateType::Sensitive => atk_sys::ATK_STATE_SENSITIVE,
            StateType::Showing => atk_sys::ATK_STATE_SHOWING,
            StateType::SingleLine => atk_sys::ATK_STATE_SINGLE_LINE,
            StateType::Stale => atk_sys::ATK_STATE_STALE,
            StateType::Transient => atk_sys::ATK_STATE_TRANSIENT,
            StateType::Vertical => atk_sys::ATK_STATE_VERTICAL,
            StateType::Visible => atk_sys::ATK_STATE_VISIBLE,
            StateType::ManagesDescendants => atk_sys::ATK_STATE_MANAGES_DESCENDANTS,
            StateType::Indeterminate => atk_sys::ATK_STATE_INDETERMINATE,
            StateType::Truncated => atk_sys::ATK_STATE_TRUNCATED,
            StateType::Required => atk_sys::ATK_STATE_REQUIRED,
            StateType::InvalidEntry => atk_sys::ATK_STATE_INVALID_ENTRY,
            StateType::SupportsAutocompletion => atk_sys::ATK_STATE_SUPPORTS_AUTOCOMPLETION,
            StateType::SelectableText => atk_sys::ATK_STATE_SELECTABLE_TEXT,
            StateType::Default => atk_sys::ATK_STATE_DEFAULT,
            StateType::Animated => atk_sys::ATK_STATE_ANIMATED,
            StateType::Visited => atk_sys::ATK_STATE_VISITED,
            StateType::Checkable => atk_sys::ATK_STATE_CHECKABLE,
            StateType::HasPopup => atk_sys::ATK_STATE_HAS_POPUP,
            StateType::HasTooltip => atk_sys::ATK_STATE_HAS_TOOLTIP,
            StateType::ReadOnly => atk_sys::ATK_STATE_READ_ONLY,
            StateType::LastDefined => atk_sys::ATK_STATE_LAST_DEFINED,
            StateType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkStateType> for StateType {
    fn from_glib(value: atk_sys::AtkStateType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => StateType::Invalid,
            1 => StateType::Active,
            2 => StateType::Armed,
            3 => StateType::Busy,
            4 => StateType::Checked,
            5 => StateType::Defunct,
            6 => StateType::Editable,
            7 => StateType::Enabled,
            8 => StateType::Expandable,
            9 => StateType::Expanded,
            10 => StateType::Focusable,
            11 => StateType::Focused,
            12 => StateType::Horizontal,
            13 => StateType::Iconified,
            14 => StateType::Modal,
            15 => StateType::MultiLine,
            16 => StateType::Multiselectable,
            17 => StateType::Opaque,
            18 => StateType::Pressed,
            19 => StateType::Resizable,
            20 => StateType::Selectable,
            21 => StateType::Selected,
            22 => StateType::Sensitive,
            23 => StateType::Showing,
            24 => StateType::SingleLine,
            25 => StateType::Stale,
            26 => StateType::Transient,
            27 => StateType::Vertical,
            28 => StateType::Visible,
            29 => StateType::ManagesDescendants,
            30 => StateType::Indeterminate,
            31 => StateType::Truncated,
            32 => StateType::Required,
            33 => StateType::InvalidEntry,
            34 => StateType::SupportsAutocompletion,
            35 => StateType::SelectableText,
            36 => StateType::Default,
            37 => StateType::Animated,
            38 => StateType::Visited,
            39 => StateType::Checkable,
            40 => StateType::HasPopup,
            41 => StateType::HasTooltip,
            42 => StateType::ReadOnly,
            43 => StateType::LastDefined,
            value => StateType::__Unknown(value),
        }
    }
}

impl StaticType for StateType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_state_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for StateType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for StateType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for StateType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TextAttribute {
    Invalid,
    LeftMargin,
    RightMargin,
    Indent,
    Invisible,
    Editable,
    PixelsAboveLines,
    PixelsBelowLines,
    PixelsInsideWrap,
    BgFullHeight,
    Rise,
    Underline,
    Strikethrough,
    Size,
    Scale,
    Weight,
    Language,
    FamilyName,
    BgColor,
    FgColor,
    BgStipple,
    FgStipple,
    WrapMode,
    Direction,
    Justification,
    Stretch,
    Variant,
    Style,
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextAttribute {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextAttribute::{}",
            match *self {
                TextAttribute::Invalid => "Invalid",
                TextAttribute::LeftMargin => "LeftMargin",
                TextAttribute::RightMargin => "RightMargin",
                TextAttribute::Indent => "Indent",
                TextAttribute::Invisible => "Invisible",
                TextAttribute::Editable => "Editable",
                TextAttribute::PixelsAboveLines => "PixelsAboveLines",
                TextAttribute::PixelsBelowLines => "PixelsBelowLines",
                TextAttribute::PixelsInsideWrap => "PixelsInsideWrap",
                TextAttribute::BgFullHeight => "BgFullHeight",
                TextAttribute::Rise => "Rise",
                TextAttribute::Underline => "Underline",
                TextAttribute::Strikethrough => "Strikethrough",
                TextAttribute::Size => "Size",
                TextAttribute::Scale => "Scale",
                TextAttribute::Weight => "Weight",
                TextAttribute::Language => "Language",
                TextAttribute::FamilyName => "FamilyName",
                TextAttribute::BgColor => "BgColor",
                TextAttribute::FgColor => "FgColor",
                TextAttribute::BgStipple => "BgStipple",
                TextAttribute::FgStipple => "FgStipple",
                TextAttribute::WrapMode => "WrapMode",
                TextAttribute::Direction => "Direction",
                TextAttribute::Justification => "Justification",
                TextAttribute::Stretch => "Stretch",
                TextAttribute::Variant => "Variant",
                TextAttribute::Style => "Style",
                TextAttribute::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for TextAttribute {
    type GlibType = atk_sys::AtkTextAttribute;

    fn to_glib(&self) -> atk_sys::AtkTextAttribute {
        match *self {
            TextAttribute::Invalid => atk_sys::ATK_TEXT_ATTR_INVALID,
            TextAttribute::LeftMargin => atk_sys::ATK_TEXT_ATTR_LEFT_MARGIN,
            TextAttribute::RightMargin => atk_sys::ATK_TEXT_ATTR_RIGHT_MARGIN,
            TextAttribute::Indent => atk_sys::ATK_TEXT_ATTR_INDENT,
            TextAttribute::Invisible => atk_sys::ATK_TEXT_ATTR_INVISIBLE,
            TextAttribute::Editable => atk_sys::ATK_TEXT_ATTR_EDITABLE,
            TextAttribute::PixelsAboveLines => atk_sys::ATK_TEXT_ATTR_PIXELS_ABOVE_LINES,
            TextAttribute::PixelsBelowLines => atk_sys::ATK_TEXT_ATTR_PIXELS_BELOW_LINES,
            TextAttribute::PixelsInsideWrap => atk_sys::ATK_TEXT_ATTR_PIXELS_INSIDE_WRAP,
            TextAttribute::BgFullHeight => atk_sys::ATK_TEXT_ATTR_BG_FULL_HEIGHT,
            TextAttribute::Rise => atk_sys::ATK_TEXT_ATTR_RISE,
            TextAttribute::Underline => atk_sys::ATK_TEXT_ATTR_UNDERLINE,
            TextAttribute::Strikethrough => atk_sys::ATK_TEXT_ATTR_STRIKETHROUGH,
            TextAttribute::Size => atk_sys::ATK_TEXT_ATTR_SIZE,
            TextAttribute::Scale => atk_sys::ATK_TEXT_ATTR_SCALE,
            TextAttribute::Weight => atk_sys::ATK_TEXT_ATTR_WEIGHT,
            TextAttribute::Language => atk_sys::ATK_TEXT_ATTR_LANGUAGE,
            TextAttribute::FamilyName => atk_sys::ATK_TEXT_ATTR_FAMILY_NAME,
            TextAttribute::BgColor => atk_sys::ATK_TEXT_ATTR_BG_COLOR,
            TextAttribute::FgColor => atk_sys::ATK_TEXT_ATTR_FG_COLOR,
            TextAttribute::BgStipple => atk_sys::ATK_TEXT_ATTR_BG_STIPPLE,
            TextAttribute::FgStipple => atk_sys::ATK_TEXT_ATTR_FG_STIPPLE,
            TextAttribute::WrapMode => atk_sys::ATK_TEXT_ATTR_WRAP_MODE,
            TextAttribute::Direction => atk_sys::ATK_TEXT_ATTR_DIRECTION,
            TextAttribute::Justification => atk_sys::ATK_TEXT_ATTR_JUSTIFICATION,
            TextAttribute::Stretch => atk_sys::ATK_TEXT_ATTR_STRETCH,
            TextAttribute::Variant => atk_sys::ATK_TEXT_ATTR_VARIANT,
            TextAttribute::Style => atk_sys::ATK_TEXT_ATTR_STYLE,
            TextAttribute::LastDefined => atk_sys::ATK_TEXT_ATTR_LAST_DEFINED,
            TextAttribute::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkTextAttribute> for TextAttribute {
    fn from_glib(value: atk_sys::AtkTextAttribute) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TextAttribute::Invalid,
            1 => TextAttribute::LeftMargin,
            2 => TextAttribute::RightMargin,
            3 => TextAttribute::Indent,
            4 => TextAttribute::Invisible,
            5 => TextAttribute::Editable,
            6 => TextAttribute::PixelsAboveLines,
            7 => TextAttribute::PixelsBelowLines,
            8 => TextAttribute::PixelsInsideWrap,
            9 => TextAttribute::BgFullHeight,
            10 => TextAttribute::Rise,
            11 => TextAttribute::Underline,
            12 => TextAttribute::Strikethrough,
            13 => TextAttribute::Size,
            14 => TextAttribute::Scale,
            15 => TextAttribute::Weight,
            16 => TextAttribute::Language,
            17 => TextAttribute::FamilyName,
            18 => TextAttribute::BgColor,
            19 => TextAttribute::FgColor,
            20 => TextAttribute::BgStipple,
            21 => TextAttribute::FgStipple,
            22 => TextAttribute::WrapMode,
            23 => TextAttribute::Direction,
            24 => TextAttribute::Justification,
            25 => TextAttribute::Stretch,
            26 => TextAttribute::Variant,
            27 => TextAttribute::Style,
            28 => TextAttribute::LastDefined,
            value => TextAttribute::__Unknown(value),
        }
    }
}

impl StaticType for TextAttribute {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_text_attribute_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TextAttribute {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TextAttribute {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TextAttribute {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TextBoundary {
    Char,
    WordStart,
    WordEnd,
    SentenceStart,
    SentenceEnd,
    LineStart,
    LineEnd,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextBoundary {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextBoundary::{}",
            match *self {
                TextBoundary::Char => "Char",
                TextBoundary::WordStart => "WordStart",
                TextBoundary::WordEnd => "WordEnd",
                TextBoundary::SentenceStart => "SentenceStart",
                TextBoundary::SentenceEnd => "SentenceEnd",
                TextBoundary::LineStart => "LineStart",
                TextBoundary::LineEnd => "LineEnd",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for TextBoundary {
    type GlibType = atk_sys::AtkTextBoundary;

    fn to_glib(&self) -> atk_sys::AtkTextBoundary {
        match *self {
            TextBoundary::Char => atk_sys::ATK_TEXT_BOUNDARY_CHAR,
            TextBoundary::WordStart => atk_sys::ATK_TEXT_BOUNDARY_WORD_START,
            TextBoundary::WordEnd => atk_sys::ATK_TEXT_BOUNDARY_WORD_END,
            TextBoundary::SentenceStart => atk_sys::ATK_TEXT_BOUNDARY_SENTENCE_START,
            TextBoundary::SentenceEnd => atk_sys::ATK_TEXT_BOUNDARY_SENTENCE_END,
            TextBoundary::LineStart => atk_sys::ATK_TEXT_BOUNDARY_LINE_START,
            TextBoundary::LineEnd => atk_sys::ATK_TEXT_BOUNDARY_LINE_END,
            TextBoundary::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkTextBoundary> for TextBoundary {
    fn from_glib(value: atk_sys::AtkTextBoundary) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TextBoundary::Char,
            1 => TextBoundary::WordStart,
            2 => TextBoundary::WordEnd,
            3 => TextBoundary::SentenceStart,
            4 => TextBoundary::SentenceEnd,
            5 => TextBoundary::LineStart,
            6 => TextBoundary::LineEnd,
            value => TextBoundary::__Unknown(value),
        }
    }
}

impl StaticType for TextBoundary {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_text_boundary_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TextBoundary {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TextBoundary {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TextBoundary {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TextClipType {
    None,
    Min,
    Max,
    Both,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextClipType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextClipType::{}",
            match *self {
                TextClipType::None => "None",
                TextClipType::Min => "Min",
                TextClipType::Max => "Max",
                TextClipType::Both => "Both",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for TextClipType {
    type GlibType = atk_sys::AtkTextClipType;

    fn to_glib(&self) -> atk_sys::AtkTextClipType {
        match *self {
            TextClipType::None => atk_sys::ATK_TEXT_CLIP_NONE,
            TextClipType::Min => atk_sys::ATK_TEXT_CLIP_MIN,
            TextClipType::Max => atk_sys::ATK_TEXT_CLIP_MAX,
            TextClipType::Both => atk_sys::ATK_TEXT_CLIP_BOTH,
            TextClipType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkTextClipType> for TextClipType {
    fn from_glib(value: atk_sys::AtkTextClipType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TextClipType::None,
            1 => TextClipType::Min,
            2 => TextClipType::Max,
            3 => TextClipType::Both,
            value => TextClipType::__Unknown(value),
        }
    }
}

impl StaticType for TextClipType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_text_clip_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TextClipType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TextClipType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TextClipType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TextGranularity {
    Char,
    Word,
    Sentence,
    Line,
    Paragraph,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TextGranularity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TextGranularity::{}",
            match *self {
                TextGranularity::Char => "Char",
                TextGranularity::Word => "Word",
                TextGranularity::Sentence => "Sentence",
                TextGranularity::Line => "Line",
                TextGranularity::Paragraph => "Paragraph",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for TextGranularity {
    type GlibType = atk_sys::AtkTextGranularity;

    fn to_glib(&self) -> atk_sys::AtkTextGranularity {
        match *self {
            TextGranularity::Char => atk_sys::ATK_TEXT_GRANULARITY_CHAR,
            TextGranularity::Word => atk_sys::ATK_TEXT_GRANULARITY_WORD,
            TextGranularity::Sentence => atk_sys::ATK_TEXT_GRANULARITY_SENTENCE,
            TextGranularity::Line => atk_sys::ATK_TEXT_GRANULARITY_LINE,
            TextGranularity::Paragraph => atk_sys::ATK_TEXT_GRANULARITY_PARAGRAPH,
            TextGranularity::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkTextGranularity> for TextGranularity {
    fn from_glib(value: atk_sys::AtkTextGranularity) -> Self {
        skip_assert_initialized!();
        match value {
            0 => TextGranularity::Char,
            1 => TextGranularity::Word,
            2 => TextGranularity::Sentence,
            3 => TextGranularity::Line,
            4 => TextGranularity::Paragraph,
            value => TextGranularity::__Unknown(value),
        }
    }
}

impl StaticType for TextGranularity {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_text_granularity_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TextGranularity {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TextGranularity {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TextGranularity {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum ValueType {
    VeryWeak,
    Weak,
    Acceptable,
    Strong,
    VeryStrong,
    VeryLow,
    Low,
    Medium,
    High,
    VeryHigh,
    VeryBad,
    Bad,
    Good,
    VeryGood,
    Best,
    LastDefined,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for ValueType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "ValueType::{}",
            match *self {
                ValueType::VeryWeak => "VeryWeak",
                ValueType::Weak => "Weak",
                ValueType::Acceptable => "Acceptable",
                ValueType::Strong => "Strong",
                ValueType::VeryStrong => "VeryStrong",
                ValueType::VeryLow => "VeryLow",
                ValueType::Low => "Low",
                ValueType::Medium => "Medium",
                ValueType::High => "High",
                ValueType::VeryHigh => "VeryHigh",
                ValueType::VeryBad => "VeryBad",
                ValueType::Bad => "Bad",
                ValueType::Good => "Good",
                ValueType::VeryGood => "VeryGood",
                ValueType::Best => "Best",
                ValueType::LastDefined => "LastDefined",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for ValueType {
    type GlibType = atk_sys::AtkValueType;

    fn to_glib(&self) -> atk_sys::AtkValueType {
        match *self {
            ValueType::VeryWeak => atk_sys::ATK_VALUE_VERY_WEAK,
            ValueType::Weak => atk_sys::ATK_VALUE_WEAK,
            ValueType::Acceptable => atk_sys::ATK_VALUE_ACCEPTABLE,
            ValueType::Strong => atk_sys::ATK_VALUE_STRONG,
            ValueType::VeryStrong => atk_sys::ATK_VALUE_VERY_STRONG,
            ValueType::VeryLow => atk_sys::ATK_VALUE_VERY_LOW,
            ValueType::Low => atk_sys::ATK_VALUE_LOW,
            ValueType::Medium => atk_sys::ATK_VALUE_MEDIUM,
            ValueType::High => atk_sys::ATK_VALUE_HIGH,
            ValueType::VeryHigh => atk_sys::ATK_VALUE_VERY_HIGH,
            ValueType::VeryBad => atk_sys::ATK_VALUE_VERY_BAD,
            ValueType::Bad => atk_sys::ATK_VALUE_BAD,
            ValueType::Good => atk_sys::ATK_VALUE_GOOD,
            ValueType::VeryGood => atk_sys::ATK_VALUE_VERY_GOOD,
            ValueType::Best => atk_sys::ATK_VALUE_BEST,
            ValueType::LastDefined => atk_sys::ATK_VALUE_LAST_DEFINED,
            ValueType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<atk_sys::AtkValueType> for ValueType {
    fn from_glib(value: atk_sys::AtkValueType) -> Self {
        skip_assert_initialized!();
        match value {
            0 => ValueType::VeryWeak,
            1 => ValueType::Weak,
            2 => ValueType::Acceptable,
            3 => ValueType::Strong,
            4 => ValueType::VeryStrong,
            5 => ValueType::VeryLow,
            6 => ValueType::Low,
            7 => ValueType::Medium,
            8 => ValueType::High,
            9 => ValueType::VeryHigh,
            10 => ValueType::VeryBad,
            11 => ValueType::Bad,
            12 => ValueType::Good,
            13 => ValueType::VeryGood,
            14 => ValueType::Best,
            15 => ValueType::LastDefined,
            value => ValueType::__Unknown(value),
        }
    }
}

impl StaticType for ValueType {
    fn static_type() -> Type {
        unsafe { from_glib(atk_sys::atk_value_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for ValueType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for ValueType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for ValueType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}
