// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk;
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectExt;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use glib::Value;
use glib_sys;
use gobject_sys;
use gtk_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use Adjustment;
use Align;
use Bin;
use Buildable;
use Container;
use CornerType;
use DirectionType;
use PolicyType;
#[cfg(any(feature = "v3_16", feature = "dox"))]
use PositionType;
use ResizeMode;
use ScrollType;
use ShadowType;
use Widget;

glib_wrapper! {
    pub struct ScrolledWindow(Object<gtk_sys::GtkScrolledWindow, gtk_sys::GtkScrolledWindowClass, ScrolledWindowClass>) @extends Bin, Container, Widget, @implements Buildable;

    match fn {
        get_type => || gtk_sys::gtk_scrolled_window_get_type(),
    }
}

impl ScrolledWindow {
    pub fn new<P: IsA<Adjustment>, Q: IsA<Adjustment>>(
        hadjustment: Option<&P>,
        vadjustment: Option<&Q>,
    ) -> ScrolledWindow {
        assert_initialized_main_thread!();
        unsafe {
            Widget::from_glib_none(gtk_sys::gtk_scrolled_window_new(
                hadjustment.map(|p| p.as_ref()).to_glib_none().0,
                vadjustment.map(|p| p.as_ref()).to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }
}

#[derive(Clone, Default)]
pub struct ScrolledWindowBuilder {
    hadjustment: Option<Adjustment>,
    hscrollbar_policy: Option<PolicyType>,
    kinetic_scrolling: Option<bool>,
    #[cfg(any(feature = "v3_22", feature = "dox"))]
    max_content_height: Option<i32>,
    #[cfg(any(feature = "v3_22", feature = "dox"))]
    max_content_width: Option<i32>,
    min_content_height: Option<i32>,
    min_content_width: Option<i32>,
    #[cfg(any(feature = "v3_16", feature = "dox"))]
    overlay_scrolling: Option<bool>,
    #[cfg(any(feature = "v3_22", feature = "dox"))]
    propagate_natural_height: Option<bool>,
    #[cfg(any(feature = "v3_22", feature = "dox"))]
    propagate_natural_width: Option<bool>,
    shadow_type: Option<ShadowType>,
    vadjustment: Option<Adjustment>,
    vscrollbar_policy: Option<PolicyType>,
    window_placement: Option<CornerType>,
    border_width: Option<u32>,
    child: Option<Widget>,
    resize_mode: Option<ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    #[cfg(any(feature = "v3_20", feature = "dox"))]
    focus_on_click: Option<bool>,
    halign: Option<Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
}

impl ScrolledWindowBuilder {
    pub fn new() -> Self {
        Self::default()
    }

    pub fn build(self) -> ScrolledWindow {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref hadjustment) = self.hadjustment {
            properties.push(("hadjustment", hadjustment));
        }
        if let Some(ref hscrollbar_policy) = self.hscrollbar_policy {
            properties.push(("hscrollbar-policy", hscrollbar_policy));
        }
        if let Some(ref kinetic_scrolling) = self.kinetic_scrolling {
            properties.push(("kinetic-scrolling", kinetic_scrolling));
        }
        #[cfg(any(feature = "v3_22", feature = "dox"))]
        {
            if let Some(ref max_content_height) = self.max_content_height {
                properties.push(("max-content-height", max_content_height));
            }
        }
        #[cfg(any(feature = "v3_22", feature = "dox"))]
        {
            if let Some(ref max_content_width) = self.max_content_width {
                properties.push(("max-content-width", max_content_width));
            }
        }
        if let Some(ref min_content_height) = self.min_content_height {
            properties.push(("min-content-height", min_content_height));
        }
        if let Some(ref min_content_width) = self.min_content_width {
            properties.push(("min-content-width", min_content_width));
        }
        #[cfg(any(feature = "v3_16", feature = "dox"))]
        {
            if let Some(ref overlay_scrolling) = self.overlay_scrolling {
                properties.push(("overlay-scrolling", overlay_scrolling));
            }
        }
        #[cfg(any(feature = "v3_22", feature = "dox"))]
        {
            if let Some(ref propagate_natural_height) = self.propagate_natural_height {
                properties.push(("propagate-natural-height", propagate_natural_height));
            }
        }
        #[cfg(any(feature = "v3_22", feature = "dox"))]
        {
            if let Some(ref propagate_natural_width) = self.propagate_natural_width {
                properties.push(("propagate-natural-width", propagate_natural_width));
            }
        }
        if let Some(ref shadow_type) = self.shadow_type {
            properties.push(("shadow-type", shadow_type));
        }
        if let Some(ref vadjustment) = self.vadjustment {
            properties.push(("vadjustment", vadjustment));
        }
        if let Some(ref vscrollbar_policy) = self.vscrollbar_policy {
            properties.push(("vscrollbar-policy", vscrollbar_policy));
        }
        if let Some(ref window_placement) = self.window_placement {
            properties.push(("window-placement", window_placement));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        #[cfg(any(feature = "v3_20", feature = "dox"))]
        {
            if let Some(ref focus_on_click) = self.focus_on_click {
                properties.push(("focus-on-click", focus_on_click));
            }
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        let ret = glib::Object::new(ScrolledWindow::static_type(), &properties)
            .expect("object new")
            .downcast::<ScrolledWindow>()
            .expect("downcast");
        ret
    }

    pub fn hadjustment<P: IsA<Adjustment>>(mut self, hadjustment: &P) -> Self {
        self.hadjustment = Some(hadjustment.clone().upcast());
        self
    }

    pub fn hscrollbar_policy(mut self, hscrollbar_policy: PolicyType) -> Self {
        self.hscrollbar_policy = Some(hscrollbar_policy);
        self
    }

    pub fn kinetic_scrolling(mut self, kinetic_scrolling: bool) -> Self {
        self.kinetic_scrolling = Some(kinetic_scrolling);
        self
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    pub fn max_content_height(mut self, max_content_height: i32) -> Self {
        self.max_content_height = Some(max_content_height);
        self
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    pub fn max_content_width(mut self, max_content_width: i32) -> Self {
        self.max_content_width = Some(max_content_width);
        self
    }

    pub fn min_content_height(mut self, min_content_height: i32) -> Self {
        self.min_content_height = Some(min_content_height);
        self
    }

    pub fn min_content_width(mut self, min_content_width: i32) -> Self {
        self.min_content_width = Some(min_content_width);
        self
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    pub fn overlay_scrolling(mut self, overlay_scrolling: bool) -> Self {
        self.overlay_scrolling = Some(overlay_scrolling);
        self
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    pub fn propagate_natural_height(mut self, propagate_natural_height: bool) -> Self {
        self.propagate_natural_height = Some(propagate_natural_height);
        self
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    pub fn propagate_natural_width(mut self, propagate_natural_width: bool) -> Self {
        self.propagate_natural_width = Some(propagate_natural_width);
        self
    }

    pub fn shadow_type(mut self, shadow_type: ShadowType) -> Self {
        self.shadow_type = Some(shadow_type);
        self
    }

    pub fn vadjustment<P: IsA<Adjustment>>(mut self, vadjustment: &P) -> Self {
        self.vadjustment = Some(vadjustment.clone().upcast());
        self
    }

    pub fn vscrollbar_policy(mut self, vscrollbar_policy: PolicyType) -> Self {
        self.vscrollbar_policy = Some(vscrollbar_policy);
        self
    }

    pub fn window_placement(mut self, window_placement: CornerType) -> Self {
        self.window_placement = Some(window_placement);
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    #[cfg(any(feature = "v3_20", feature = "dox"))]
    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }
}

pub const NONE_SCROLLED_WINDOW: Option<&ScrolledWindow> = None;

pub trait ScrolledWindowExt: 'static {
    fn get_capture_button_press(&self) -> bool;

    fn get_hadjustment(&self) -> Option<Adjustment>;

    fn get_hscrollbar(&self) -> Option<Widget>;

    fn get_kinetic_scrolling(&self) -> bool;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_max_content_height(&self) -> i32;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_max_content_width(&self) -> i32;

    fn get_min_content_height(&self) -> i32;

    fn get_min_content_width(&self) -> i32;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_overlay_scrolling(&self) -> bool;

    fn get_placement(&self) -> CornerType;

    fn get_policy(&self) -> (PolicyType, PolicyType);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_propagate_natural_height(&self) -> bool;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_propagate_natural_width(&self) -> bool;

    fn get_shadow_type(&self) -> ShadowType;

    fn get_vadjustment(&self) -> Option<Adjustment>;

    fn get_vscrollbar(&self) -> Option<Widget>;

    fn set_capture_button_press(&self, capture_button_press: bool);

    fn set_hadjustment<P: IsA<Adjustment>>(&self, hadjustment: Option<&P>);

    fn set_kinetic_scrolling(&self, kinetic_scrolling: bool);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_max_content_height(&self, height: i32);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_max_content_width(&self, width: i32);

    fn set_min_content_height(&self, height: i32);

    fn set_min_content_width(&self, width: i32);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_overlay_scrolling(&self, overlay_scrolling: bool);

    fn set_placement(&self, window_placement: CornerType);

    fn set_policy(&self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_propagate_natural_height(&self, propagate: bool);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_propagate_natural_width(&self, propagate: bool);

    fn set_shadow_type(&self, type_: ShadowType);

    fn set_vadjustment<P: IsA<Adjustment>>(&self, vadjustment: Option<&P>);

    fn unset_placement(&self);

    fn get_property_hscrollbar_policy(&self) -> PolicyType;

    fn set_property_hscrollbar_policy(&self, hscrollbar_policy: PolicyType);

    fn get_property_vscrollbar_policy(&self) -> PolicyType;

    fn set_property_vscrollbar_policy(&self, vscrollbar_policy: PolicyType);

    fn get_property_window_placement(&self) -> CornerType;

    fn set_property_window_placement(&self, window_placement: CornerType);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_edge_overshot<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_edge_reached<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_move_focus_out(&self, direction_type: DirectionType);

    fn connect_scroll_child<F: Fn(&Self, ScrollType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn emit_scroll_child(&self, scroll: ScrollType, horizontal: bool) -> bool;

    fn connect_property_hadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_hscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_kinetic_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_max_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_max_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_min_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_min_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_propagate_natural_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_propagate_natural_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_vadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_vscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    fn connect_property_window_placement_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;
}

impl<O: IsA<ScrolledWindow>> ScrolledWindowExt for O {
    fn get_capture_button_press(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_capture_button_press(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_hadjustment(&self) -> Option<Adjustment> {
        unsafe {
            from_glib_none(gtk_sys::gtk_scrolled_window_get_hadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_hscrollbar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_scrolled_window_get_hscrollbar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_kinetic_scrolling(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_kinetic_scrolling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_max_content_height(&self) -> i32 {
        unsafe {
            gtk_sys::gtk_scrolled_window_get_max_content_height(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_max_content_width(&self) -> i32 {
        unsafe {
            gtk_sys::gtk_scrolled_window_get_max_content_width(self.as_ref().to_glib_none().0)
        }
    }

    fn get_min_content_height(&self) -> i32 {
        unsafe {
            gtk_sys::gtk_scrolled_window_get_min_content_height(self.as_ref().to_glib_none().0)
        }
    }

    fn get_min_content_width(&self) -> i32 {
        unsafe {
            gtk_sys::gtk_scrolled_window_get_min_content_width(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn get_overlay_scrolling(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_overlay_scrolling(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_placement(&self) -> CornerType {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_placement(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_policy(&self) -> (PolicyType, PolicyType) {
        unsafe {
            let mut hscrollbar_policy = mem::MaybeUninit::uninit();
            let mut vscrollbar_policy = mem::MaybeUninit::uninit();
            gtk_sys::gtk_scrolled_window_get_policy(
                self.as_ref().to_glib_none().0,
                hscrollbar_policy.as_mut_ptr(),
                vscrollbar_policy.as_mut_ptr(),
            );
            let hscrollbar_policy = hscrollbar_policy.assume_init();
            let vscrollbar_policy = vscrollbar_policy.assume_init();
            (from_glib(hscrollbar_policy), from_glib(vscrollbar_policy))
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_propagate_natural_height(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_propagate_natural_height(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn get_propagate_natural_width(&self) -> bool {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_propagate_natural_width(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_shadow_type(&self) -> ShadowType {
        unsafe {
            from_glib(gtk_sys::gtk_scrolled_window_get_shadow_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_vadjustment(&self) -> Option<Adjustment> {
        unsafe {
            from_glib_none(gtk_sys::gtk_scrolled_window_get_vadjustment(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_vscrollbar(&self) -> Option<Widget> {
        unsafe {
            from_glib_none(gtk_sys::gtk_scrolled_window_get_vscrollbar(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_capture_button_press(&self, capture_button_press: bool) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_capture_button_press(
                self.as_ref().to_glib_none().0,
                capture_button_press.to_glib(),
            );
        }
    }

    fn set_hadjustment<P: IsA<Adjustment>>(&self, hadjustment: Option<&P>) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_hadjustment(
                self.as_ref().to_glib_none().0,
                hadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_kinetic_scrolling(&self, kinetic_scrolling: bool) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_kinetic_scrolling(
                self.as_ref().to_glib_none().0,
                kinetic_scrolling.to_glib(),
            );
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_max_content_height(&self, height: i32) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_max_content_height(
                self.as_ref().to_glib_none().0,
                height,
            );
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_max_content_width(&self, width: i32) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_max_content_width(
                self.as_ref().to_glib_none().0,
                width,
            );
        }
    }

    fn set_min_content_height(&self, height: i32) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_min_content_height(
                self.as_ref().to_glib_none().0,
                height,
            );
        }
    }

    fn set_min_content_width(&self, width: i32) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_min_content_width(
                self.as_ref().to_glib_none().0,
                width,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn set_overlay_scrolling(&self, overlay_scrolling: bool) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_overlay_scrolling(
                self.as_ref().to_glib_none().0,
                overlay_scrolling.to_glib(),
            );
        }
    }

    fn set_placement(&self, window_placement: CornerType) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_placement(
                self.as_ref().to_glib_none().0,
                window_placement.to_glib(),
            );
        }
    }

    fn set_policy(&self, hscrollbar_policy: PolicyType, vscrollbar_policy: PolicyType) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_policy(
                self.as_ref().to_glib_none().0,
                hscrollbar_policy.to_glib(),
                vscrollbar_policy.to_glib(),
            );
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_propagate_natural_height(&self, propagate: bool) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_propagate_natural_height(
                self.as_ref().to_glib_none().0,
                propagate.to_glib(),
            );
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn set_propagate_natural_width(&self, propagate: bool) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_propagate_natural_width(
                self.as_ref().to_glib_none().0,
                propagate.to_glib(),
            );
        }
    }

    fn set_shadow_type(&self, type_: ShadowType) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_shadow_type(
                self.as_ref().to_glib_none().0,
                type_.to_glib(),
            );
        }
    }

    fn set_vadjustment<P: IsA<Adjustment>>(&self, vadjustment: Option<&P>) {
        unsafe {
            gtk_sys::gtk_scrolled_window_set_vadjustment(
                self.as_ref().to_glib_none().0,
                vadjustment.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn unset_placement(&self) {
        unsafe {
            gtk_sys::gtk_scrolled_window_unset_placement(self.as_ref().to_glib_none().0);
        }
    }

    fn get_property_hscrollbar_policy(&self) -> PolicyType {
        unsafe {
            let mut value = Value::from_type(<PolicyType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"hscrollbar-policy\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `hscrollbar-policy` getter")
                .unwrap()
        }
    }

    fn set_property_hscrollbar_policy(&self, hscrollbar_policy: PolicyType) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"hscrollbar-policy\0".as_ptr() as *const _,
                Value::from(&hscrollbar_policy).to_glib_none().0,
            );
        }
    }

    fn get_property_vscrollbar_policy(&self) -> PolicyType {
        unsafe {
            let mut value = Value::from_type(<PolicyType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"vscrollbar-policy\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `vscrollbar-policy` getter")
                .unwrap()
        }
    }

    fn set_property_vscrollbar_policy(&self, vscrollbar_policy: PolicyType) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"vscrollbar-policy\0".as_ptr() as *const _,
                Value::from(&vscrollbar_policy).to_glib_none().0,
            );
        }
    }

    fn get_property_window_placement(&self) -> CornerType {
        unsafe {
            let mut value = Value::from_type(<CornerType as StaticType>::static_type());
            gobject_sys::g_object_get_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"window-placement\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `window-placement` getter")
                .unwrap()
        }
    }

    fn set_property_window_placement(&self, window_placement: CornerType) {
        unsafe {
            gobject_sys::g_object_set_property(
                self.to_glib_none().0 as *mut gobject_sys::GObject,
                b"window-placement\0".as_ptr() as *const _,
                Value::from(&window_placement).to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_edge_overshot<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edge_overshot_trampoline<P, F: Fn(&P, PositionType) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            pos: gtk_sys::GtkPositionType,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(
                &ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-overshot\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_overshot_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_edge_reached<F: Fn(&Self, PositionType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn edge_reached_trampoline<P, F: Fn(&P, PositionType) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            pos: gtk_sys::GtkPositionType,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(
                &ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(pos),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"edge-reached\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    edge_reached_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_focus_out<F: Fn(&Self, DirectionType) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_focus_out_trampoline<P, F: Fn(&P, DirectionType) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            direction_type: gtk_sys::GtkDirectionType,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(
                &ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(direction_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-focus-out\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_focus_out_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_focus_out(&self, direction_type: DirectionType) {
        let _ = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut gobject_sys::GObject)
                .emit("move-focus-out", &[&direction_type])
                .unwrap()
        };
    }

    fn connect_scroll_child<F: Fn(&Self, ScrollType, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn scroll_child_trampoline<
            P,
            F: Fn(&P, ScrollType, bool) -> bool + 'static,
        >(
            this: *mut gtk_sys::GtkScrolledWindow,
            scroll: gtk_sys::GtkScrollType,
            horizontal: glib_sys::gboolean,
            f: glib_sys::gpointer,
        ) -> glib_sys::gboolean
        where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(
                &ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(scroll),
                from_glib(horizontal),
            )
            .to_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"scroll-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    scroll_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_scroll_child(&self, scroll: ScrollType, horizontal: bool) -> bool {
        let res = unsafe {
            glib::Object::from_glib_borrow(self.as_ptr() as *mut gobject_sys::GObject)
                .emit("scroll-child", &[&scroll, &horizontal])
                .unwrap()
        };
        res.unwrap()
            .get()
            .expect("Return Value for `emit_scroll_child`")
            .unwrap()
    }

    fn connect_property_hadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hadjustment_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hadjustment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_hscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hscrollbar_policy_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hscrollbar_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_kinetic_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_kinetic_scrolling_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::kinetic-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_kinetic_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_max_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_height_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_max_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_content_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::max-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_max_content_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_min_content_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_height_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_min_content_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_min_content_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::min-content-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_min_content_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn connect_property_overlay_scrolling_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_overlay_scrolling_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::overlay-scrolling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_overlay_scrolling_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_propagate_natural_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_height_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn connect_property_propagate_natural_width_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_propagate_natural_width_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::propagate-natural-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_propagate_natural_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_shadow_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_shadow_type_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::shadow-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_shadow_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_vadjustment_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vadjustment_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vadjustment\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vadjustment_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_vscrollbar_policy_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vscrollbar_policy_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vscrollbar-policy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vscrollbar_policy_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_property_window_placement_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_window_placement_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gtk_sys::GtkScrolledWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<ScrolledWindow>,
        {
            let f: &F = &*(f as *const F);
            f(&ScrolledWindow::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::window-placement\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_window_placement_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for ScrolledWindow {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ScrolledWindow")
    }
}
