// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::translate::*;
use glib::value::FromValue;
use glib::value::FromValueOptional;
use glib::value::SetValue;
use glib::value::Value;
use glib::StaticType;
use glib::Type;
use gobject_sys;
use pango_sys;
use std::fmt;

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Alignment {
    Left,
    Center,
    Right,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Alignment {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Alignment::{}",
            match *self {
                Alignment::Left => "Left",
                Alignment::Center => "Center",
                Alignment::Right => "Right",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Alignment {
    type GlibType = pango_sys::PangoAlignment;

    fn to_glib(&self) -> pango_sys::PangoAlignment {
        match *self {
            Alignment::Left => pango_sys::PANGO_ALIGN_LEFT,
            Alignment::Center => pango_sys::PANGO_ALIGN_CENTER,
            Alignment::Right => pango_sys::PANGO_ALIGN_RIGHT,
            Alignment::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoAlignment> for Alignment {
    fn from_glib(value: pango_sys::PangoAlignment) -> Self {
        match value {
            0 => Alignment::Left,
            1 => Alignment::Center,
            2 => Alignment::Right,
            value => Alignment::__Unknown(value),
        }
    }
}

impl StaticType for Alignment {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_alignment_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Alignment {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Alignment {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Alignment {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum AttrType {
    Invalid,
    Language,
    Family,
    Style,
    Weight,
    Variant,
    Stretch,
    Size,
    FontDesc,
    Foreground,
    Background,
    Underline,
    Strikethrough,
    Rise,
    Shape,
    Scale,
    Fallback,
    LetterSpacing,
    UnderlineColor,
    StrikethroughColor,
    AbsoluteSize,
    Gravity,
    GravityHint,
    FontFeatures,
    ForegroundAlpha,
    BackgroundAlpha,
    AllowBreaks,
    Show,
    InsertHyphens,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for AttrType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "AttrType::{}",
            match *self {
                AttrType::Invalid => "Invalid",
                AttrType::Language => "Language",
                AttrType::Family => "Family",
                AttrType::Style => "Style",
                AttrType::Weight => "Weight",
                AttrType::Variant => "Variant",
                AttrType::Stretch => "Stretch",
                AttrType::Size => "Size",
                AttrType::FontDesc => "FontDesc",
                AttrType::Foreground => "Foreground",
                AttrType::Background => "Background",
                AttrType::Underline => "Underline",
                AttrType::Strikethrough => "Strikethrough",
                AttrType::Rise => "Rise",
                AttrType::Shape => "Shape",
                AttrType::Scale => "Scale",
                AttrType::Fallback => "Fallback",
                AttrType::LetterSpacing => "LetterSpacing",
                AttrType::UnderlineColor => "UnderlineColor",
                AttrType::StrikethroughColor => "StrikethroughColor",
                AttrType::AbsoluteSize => "AbsoluteSize",
                AttrType::Gravity => "Gravity",
                AttrType::GravityHint => "GravityHint",
                AttrType::FontFeatures => "FontFeatures",
                AttrType::ForegroundAlpha => "ForegroundAlpha",
                AttrType::BackgroundAlpha => "BackgroundAlpha",
                AttrType::AllowBreaks => "AllowBreaks",
                AttrType::Show => "Show",
                AttrType::InsertHyphens => "InsertHyphens",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for AttrType {
    type GlibType = pango_sys::PangoAttrType;

    fn to_glib(&self) -> pango_sys::PangoAttrType {
        match *self {
            AttrType::Invalid => pango_sys::PANGO_ATTR_INVALID,
            AttrType::Language => pango_sys::PANGO_ATTR_LANGUAGE,
            AttrType::Family => pango_sys::PANGO_ATTR_FAMILY,
            AttrType::Style => pango_sys::PANGO_ATTR_STYLE,
            AttrType::Weight => pango_sys::PANGO_ATTR_WEIGHT,
            AttrType::Variant => pango_sys::PANGO_ATTR_VARIANT,
            AttrType::Stretch => pango_sys::PANGO_ATTR_STRETCH,
            AttrType::Size => pango_sys::PANGO_ATTR_SIZE,
            AttrType::FontDesc => pango_sys::PANGO_ATTR_FONT_DESC,
            AttrType::Foreground => pango_sys::PANGO_ATTR_FOREGROUND,
            AttrType::Background => pango_sys::PANGO_ATTR_BACKGROUND,
            AttrType::Underline => pango_sys::PANGO_ATTR_UNDERLINE,
            AttrType::Strikethrough => pango_sys::PANGO_ATTR_STRIKETHROUGH,
            AttrType::Rise => pango_sys::PANGO_ATTR_RISE,
            AttrType::Shape => pango_sys::PANGO_ATTR_SHAPE,
            AttrType::Scale => pango_sys::PANGO_ATTR_SCALE,
            AttrType::Fallback => pango_sys::PANGO_ATTR_FALLBACK,
            AttrType::LetterSpacing => pango_sys::PANGO_ATTR_LETTER_SPACING,
            AttrType::UnderlineColor => pango_sys::PANGO_ATTR_UNDERLINE_COLOR,
            AttrType::StrikethroughColor => pango_sys::PANGO_ATTR_STRIKETHROUGH_COLOR,
            AttrType::AbsoluteSize => pango_sys::PANGO_ATTR_ABSOLUTE_SIZE,
            AttrType::Gravity => pango_sys::PANGO_ATTR_GRAVITY,
            AttrType::GravityHint => pango_sys::PANGO_ATTR_GRAVITY_HINT,
            AttrType::FontFeatures => pango_sys::PANGO_ATTR_FONT_FEATURES,
            AttrType::ForegroundAlpha => pango_sys::PANGO_ATTR_FOREGROUND_ALPHA,
            AttrType::BackgroundAlpha => pango_sys::PANGO_ATTR_BACKGROUND_ALPHA,
            AttrType::AllowBreaks => pango_sys::PANGO_ATTR_ALLOW_BREAKS,
            AttrType::Show => pango_sys::PANGO_ATTR_SHOW,
            AttrType::InsertHyphens => pango_sys::PANGO_ATTR_INSERT_HYPHENS,
            AttrType::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoAttrType> for AttrType {
    fn from_glib(value: pango_sys::PangoAttrType) -> Self {
        match value {
            0 => AttrType::Invalid,
            1 => AttrType::Language,
            2 => AttrType::Family,
            3 => AttrType::Style,
            4 => AttrType::Weight,
            5 => AttrType::Variant,
            6 => AttrType::Stretch,
            7 => AttrType::Size,
            8 => AttrType::FontDesc,
            9 => AttrType::Foreground,
            10 => AttrType::Background,
            11 => AttrType::Underline,
            12 => AttrType::Strikethrough,
            13 => AttrType::Rise,
            14 => AttrType::Shape,
            15 => AttrType::Scale,
            16 => AttrType::Fallback,
            17 => AttrType::LetterSpacing,
            18 => AttrType::UnderlineColor,
            19 => AttrType::StrikethroughColor,
            20 => AttrType::AbsoluteSize,
            21 => AttrType::Gravity,
            22 => AttrType::GravityHint,
            23 => AttrType::FontFeatures,
            24 => AttrType::ForegroundAlpha,
            25 => AttrType::BackgroundAlpha,
            26 => AttrType::AllowBreaks,
            27 => AttrType::Show,
            28 => AttrType::InsertHyphens,
            value => AttrType::__Unknown(value),
        }
    }
}

impl StaticType for AttrType {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_attr_type_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for AttrType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for AttrType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for AttrType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum BidiType {
    L,
    Lre,
    Lro,
    R,
    Al,
    Rle,
    Rlo,
    Pdf,
    En,
    Es,
    Et,
    An,
    Cs,
    Nsm,
    Bn,
    B,
    S,
    Ws,
    On,
    #[doc(hidden)]
    __Unknown(i32),
}

#[cfg_attr(feature = "v1_44", deprecated)]
impl fmt::Display for BidiType {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "BidiType::{}",
            match *self {
                BidiType::L => "L",
                BidiType::Lre => "Lre",
                BidiType::Lro => "Lro",
                BidiType::R => "R",
                BidiType::Al => "Al",
                BidiType::Rle => "Rle",
                BidiType::Rlo => "Rlo",
                BidiType::Pdf => "Pdf",
                BidiType::En => "En",
                BidiType::Es => "Es",
                BidiType::Et => "Et",
                BidiType::An => "An",
                BidiType::Cs => "Cs",
                BidiType::Nsm => "Nsm",
                BidiType::Bn => "Bn",
                BidiType::B => "B",
                BidiType::S => "S",
                BidiType::Ws => "Ws",
                BidiType::On => "On",
                _ => "Unknown",
            }
        )
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
#[doc(hidden)]
impl ToGlib for BidiType {
    type GlibType = pango_sys::PangoBidiType;

    fn to_glib(&self) -> pango_sys::PangoBidiType {
        match *self {
            BidiType::L => pango_sys::PANGO_BIDI_TYPE_L,
            BidiType::Lre => pango_sys::PANGO_BIDI_TYPE_LRE,
            BidiType::Lro => pango_sys::PANGO_BIDI_TYPE_LRO,
            BidiType::R => pango_sys::PANGO_BIDI_TYPE_R,
            BidiType::Al => pango_sys::PANGO_BIDI_TYPE_AL,
            BidiType::Rle => pango_sys::PANGO_BIDI_TYPE_RLE,
            BidiType::Rlo => pango_sys::PANGO_BIDI_TYPE_RLO,
            BidiType::Pdf => pango_sys::PANGO_BIDI_TYPE_PDF,
            BidiType::En => pango_sys::PANGO_BIDI_TYPE_EN,
            BidiType::Es => pango_sys::PANGO_BIDI_TYPE_ES,
            BidiType::Et => pango_sys::PANGO_BIDI_TYPE_ET,
            BidiType::An => pango_sys::PANGO_BIDI_TYPE_AN,
            BidiType::Cs => pango_sys::PANGO_BIDI_TYPE_CS,
            BidiType::Nsm => pango_sys::PANGO_BIDI_TYPE_NSM,
            BidiType::Bn => pango_sys::PANGO_BIDI_TYPE_BN,
            BidiType::B => pango_sys::PANGO_BIDI_TYPE_B,
            BidiType::S => pango_sys::PANGO_BIDI_TYPE_S,
            BidiType::Ws => pango_sys::PANGO_BIDI_TYPE_WS,
            BidiType::On => pango_sys::PANGO_BIDI_TYPE_ON,
            BidiType::__Unknown(value) => value,
        }
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
#[doc(hidden)]
impl FromGlib<pango_sys::PangoBidiType> for BidiType {
    fn from_glib(value: pango_sys::PangoBidiType) -> Self {
        match value {
            0 => BidiType::L,
            1 => BidiType::Lre,
            2 => BidiType::Lro,
            3 => BidiType::R,
            4 => BidiType::Al,
            5 => BidiType::Rle,
            6 => BidiType::Rlo,
            7 => BidiType::Pdf,
            8 => BidiType::En,
            9 => BidiType::Es,
            10 => BidiType::Et,
            11 => BidiType::An,
            12 => BidiType::Cs,
            13 => BidiType::Nsm,
            14 => BidiType::Bn,
            15 => BidiType::B,
            16 => BidiType::S,
            17 => BidiType::Ws,
            18 => BidiType::On,
            value => BidiType::__Unknown(value),
        }
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
impl StaticType for BidiType {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_bidi_type_get_type()) }
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
impl<'a> FromValueOptional<'a> for BidiType {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
impl<'a> FromValue<'a> for BidiType {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

#[cfg_attr(feature = "v1_44", deprecated)]
impl SetValue for BidiType {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum CoverageLevel {
    None,
    Fallback,
    Approximate,
    Exact,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for CoverageLevel {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "CoverageLevel::{}",
            match *self {
                CoverageLevel::None => "None",
                CoverageLevel::Fallback => "Fallback",
                CoverageLevel::Approximate => "Approximate",
                CoverageLevel::Exact => "Exact",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for CoverageLevel {
    type GlibType = pango_sys::PangoCoverageLevel;

    fn to_glib(&self) -> pango_sys::PangoCoverageLevel {
        match *self {
            CoverageLevel::None => pango_sys::PANGO_COVERAGE_NONE,
            CoverageLevel::Fallback => pango_sys::PANGO_COVERAGE_FALLBACK,
            CoverageLevel::Approximate => pango_sys::PANGO_COVERAGE_APPROXIMATE,
            CoverageLevel::Exact => pango_sys::PANGO_COVERAGE_EXACT,
            CoverageLevel::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoCoverageLevel> for CoverageLevel {
    fn from_glib(value: pango_sys::PangoCoverageLevel) -> Self {
        match value {
            0 => CoverageLevel::None,
            1 => CoverageLevel::Fallback,
            2 => CoverageLevel::Approximate,
            3 => CoverageLevel::Exact,
            value => CoverageLevel::__Unknown(value),
        }
    }
}

impl StaticType for CoverageLevel {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_coverage_level_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for CoverageLevel {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for CoverageLevel {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for CoverageLevel {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Direction {
    Ltr,
    Rtl,
    TtbLtr,
    TtbRtl,
    WeakLtr,
    WeakRtl,
    Neutral,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Direction {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Direction::{}",
            match *self {
                Direction::Ltr => "Ltr",
                Direction::Rtl => "Rtl",
                Direction::TtbLtr => "TtbLtr",
                Direction::TtbRtl => "TtbRtl",
                Direction::WeakLtr => "WeakLtr",
                Direction::WeakRtl => "WeakRtl",
                Direction::Neutral => "Neutral",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Direction {
    type GlibType = pango_sys::PangoDirection;

    fn to_glib(&self) -> pango_sys::PangoDirection {
        match *self {
            Direction::Ltr => pango_sys::PANGO_DIRECTION_LTR,
            Direction::Rtl => pango_sys::PANGO_DIRECTION_RTL,
            Direction::TtbLtr => pango_sys::PANGO_DIRECTION_TTB_LTR,
            Direction::TtbRtl => pango_sys::PANGO_DIRECTION_TTB_RTL,
            Direction::WeakLtr => pango_sys::PANGO_DIRECTION_WEAK_LTR,
            Direction::WeakRtl => pango_sys::PANGO_DIRECTION_WEAK_RTL,
            Direction::Neutral => pango_sys::PANGO_DIRECTION_NEUTRAL,
            Direction::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoDirection> for Direction {
    fn from_glib(value: pango_sys::PangoDirection) -> Self {
        match value {
            0 => Direction::Ltr,
            1 => Direction::Rtl,
            2 => Direction::TtbLtr,
            3 => Direction::TtbRtl,
            4 => Direction::WeakLtr,
            5 => Direction::WeakRtl,
            6 => Direction::Neutral,
            value => Direction::__Unknown(value),
        }
    }
}

impl StaticType for Direction {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_direction_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Direction {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Direction {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Direction {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum EllipsizeMode {
    None,
    Start,
    Middle,
    End,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for EllipsizeMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "EllipsizeMode::{}",
            match *self {
                EllipsizeMode::None => "None",
                EllipsizeMode::Start => "Start",
                EllipsizeMode::Middle => "Middle",
                EllipsizeMode::End => "End",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for EllipsizeMode {
    type GlibType = pango_sys::PangoEllipsizeMode;

    fn to_glib(&self) -> pango_sys::PangoEllipsizeMode {
        match *self {
            EllipsizeMode::None => pango_sys::PANGO_ELLIPSIZE_NONE,
            EllipsizeMode::Start => pango_sys::PANGO_ELLIPSIZE_START,
            EllipsizeMode::Middle => pango_sys::PANGO_ELLIPSIZE_MIDDLE,
            EllipsizeMode::End => pango_sys::PANGO_ELLIPSIZE_END,
            EllipsizeMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoEllipsizeMode> for EllipsizeMode {
    fn from_glib(value: pango_sys::PangoEllipsizeMode) -> Self {
        match value {
            0 => EllipsizeMode::None,
            1 => EllipsizeMode::Start,
            2 => EllipsizeMode::Middle,
            3 => EllipsizeMode::End,
            value => EllipsizeMode::__Unknown(value),
        }
    }
}

impl StaticType for EllipsizeMode {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_ellipsize_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for EllipsizeMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for EllipsizeMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for EllipsizeMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Gravity {
    South,
    East,
    North,
    West,
    Auto,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Gravity {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Gravity::{}",
            match *self {
                Gravity::South => "South",
                Gravity::East => "East",
                Gravity::North => "North",
                Gravity::West => "West",
                Gravity::Auto => "Auto",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Gravity {
    type GlibType = pango_sys::PangoGravity;

    fn to_glib(&self) -> pango_sys::PangoGravity {
        match *self {
            Gravity::South => pango_sys::PANGO_GRAVITY_SOUTH,
            Gravity::East => pango_sys::PANGO_GRAVITY_EAST,
            Gravity::North => pango_sys::PANGO_GRAVITY_NORTH,
            Gravity::West => pango_sys::PANGO_GRAVITY_WEST,
            Gravity::Auto => pango_sys::PANGO_GRAVITY_AUTO,
            Gravity::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoGravity> for Gravity {
    fn from_glib(value: pango_sys::PangoGravity) -> Self {
        match value {
            0 => Gravity::South,
            1 => Gravity::East,
            2 => Gravity::North,
            3 => Gravity::West,
            4 => Gravity::Auto,
            value => Gravity::__Unknown(value),
        }
    }
}

impl StaticType for Gravity {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_gravity_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Gravity {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Gravity {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Gravity {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum GravityHint {
    Natural,
    Strong,
    Line,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for GravityHint {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "GravityHint::{}",
            match *self {
                GravityHint::Natural => "Natural",
                GravityHint::Strong => "Strong",
                GravityHint::Line => "Line",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for GravityHint {
    type GlibType = pango_sys::PangoGravityHint;

    fn to_glib(&self) -> pango_sys::PangoGravityHint {
        match *self {
            GravityHint::Natural => pango_sys::PANGO_GRAVITY_HINT_NATURAL,
            GravityHint::Strong => pango_sys::PANGO_GRAVITY_HINT_STRONG,
            GravityHint::Line => pango_sys::PANGO_GRAVITY_HINT_LINE,
            GravityHint::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoGravityHint> for GravityHint {
    fn from_glib(value: pango_sys::PangoGravityHint) -> Self {
        match value {
            0 => GravityHint::Natural,
            1 => GravityHint::Strong,
            2 => GravityHint::Line,
            value => GravityHint::__Unknown(value),
        }
    }
}

impl StaticType for GravityHint {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_gravity_hint_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for GravityHint {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for GravityHint {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for GravityHint {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum RenderPart {
    Foreground,
    Background,
    Underline,
    Strikethrough,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for RenderPart {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "RenderPart::{}",
            match *self {
                RenderPart::Foreground => "Foreground",
                RenderPart::Background => "Background",
                RenderPart::Underline => "Underline",
                RenderPart::Strikethrough => "Strikethrough",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for RenderPart {
    type GlibType = pango_sys::PangoRenderPart;

    fn to_glib(&self) -> pango_sys::PangoRenderPart {
        match *self {
            RenderPart::Foreground => pango_sys::PANGO_RENDER_PART_FOREGROUND,
            RenderPart::Background => pango_sys::PANGO_RENDER_PART_BACKGROUND,
            RenderPart::Underline => pango_sys::PANGO_RENDER_PART_UNDERLINE,
            RenderPart::Strikethrough => pango_sys::PANGO_RENDER_PART_STRIKETHROUGH,
            RenderPart::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoRenderPart> for RenderPart {
    fn from_glib(value: pango_sys::PangoRenderPart) -> Self {
        match value {
            0 => RenderPart::Foreground,
            1 => RenderPart::Background,
            2 => RenderPart::Underline,
            3 => RenderPart::Strikethrough,
            value => RenderPart::__Unknown(value),
        }
    }
}

impl StaticType for RenderPart {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_render_part_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for RenderPart {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for RenderPart {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for RenderPart {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Script {
    InvalidCode,
    Common,
    Inherited,
    Arabic,
    Armenian,
    Bengali,
    Bopomofo,
    Cherokee,
    Coptic,
    Cyrillic,
    Deseret,
    Devanagari,
    Ethiopic,
    Georgian,
    Gothic,
    Greek,
    Gujarati,
    Gurmukhi,
    Han,
    Hangul,
    Hebrew,
    Hiragana,
    Kannada,
    Katakana,
    Khmer,
    Lao,
    Latin,
    Malayalam,
    Mongolian,
    Myanmar,
    Ogham,
    OldItalic,
    Oriya,
    Runic,
    Sinhala,
    Syriac,
    Tamil,
    Telugu,
    Thaana,
    Thai,
    Tibetan,
    CanadianAboriginal,
    Yi,
    Tagalog,
    Hanunoo,
    Buhid,
    Tagbanwa,
    Braille,
    Cypriot,
    Limbu,
    Osmanya,
    Shavian,
    LinearB,
    TaiLe,
    Ugaritic,
    NewTaiLue,
    Buginese,
    Glagolitic,
    Tifinagh,
    SylotiNagri,
    OldPersian,
    Kharoshthi,
    Unknown,
    Balinese,
    Cuneiform,
    Phoenician,
    PhagsPa,
    Nko,
    KayahLi,
    Lepcha,
    Rejang,
    Sundanese,
    Saurashtra,
    Cham,
    OlChiki,
    Vai,
    Carian,
    Lycian,
    Lydian,
    Batak,
    Brahmi,
    Mandaic,
    Chakma,
    MeroiticCursive,
    MeroiticHieroglyphs,
    Miao,
    Sharada,
    SoraSompeng,
    Takri,
    BassaVah,
    CaucasianAlbanian,
    Duployan,
    Elbasan,
    Grantha,
    Khojki,
    Khudawadi,
    LinearA,
    Mahajani,
    Manichaean,
    MendeKikakui,
    Modi,
    Mro,
    Nabataean,
    OldNorthArabian,
    OldPermic,
    PahawhHmong,
    Palmyrene,
    PauCinHau,
    PsalterPahlavi,
    Siddham,
    Tirhuta,
    WarangCiti,
    Ahom,
    AnatolianHieroglyphs,
    Hatran,
    Multani,
    OldHungarian,
    Signwriting,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Script {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Script::{}",
            match *self {
                Script::InvalidCode => "InvalidCode",
                Script::Common => "Common",
                Script::Inherited => "Inherited",
                Script::Arabic => "Arabic",
                Script::Armenian => "Armenian",
                Script::Bengali => "Bengali",
                Script::Bopomofo => "Bopomofo",
                Script::Cherokee => "Cherokee",
                Script::Coptic => "Coptic",
                Script::Cyrillic => "Cyrillic",
                Script::Deseret => "Deseret",
                Script::Devanagari => "Devanagari",
                Script::Ethiopic => "Ethiopic",
                Script::Georgian => "Georgian",
                Script::Gothic => "Gothic",
                Script::Greek => "Greek",
                Script::Gujarati => "Gujarati",
                Script::Gurmukhi => "Gurmukhi",
                Script::Han => "Han",
                Script::Hangul => "Hangul",
                Script::Hebrew => "Hebrew",
                Script::Hiragana => "Hiragana",
                Script::Kannada => "Kannada",
                Script::Katakana => "Katakana",
                Script::Khmer => "Khmer",
                Script::Lao => "Lao",
                Script::Latin => "Latin",
                Script::Malayalam => "Malayalam",
                Script::Mongolian => "Mongolian",
                Script::Myanmar => "Myanmar",
                Script::Ogham => "Ogham",
                Script::OldItalic => "OldItalic",
                Script::Oriya => "Oriya",
                Script::Runic => "Runic",
                Script::Sinhala => "Sinhala",
                Script::Syriac => "Syriac",
                Script::Tamil => "Tamil",
                Script::Telugu => "Telugu",
                Script::Thaana => "Thaana",
                Script::Thai => "Thai",
                Script::Tibetan => "Tibetan",
                Script::CanadianAboriginal => "CanadianAboriginal",
                Script::Yi => "Yi",
                Script::Tagalog => "Tagalog",
                Script::Hanunoo => "Hanunoo",
                Script::Buhid => "Buhid",
                Script::Tagbanwa => "Tagbanwa",
                Script::Braille => "Braille",
                Script::Cypriot => "Cypriot",
                Script::Limbu => "Limbu",
                Script::Osmanya => "Osmanya",
                Script::Shavian => "Shavian",
                Script::LinearB => "LinearB",
                Script::TaiLe => "TaiLe",
                Script::Ugaritic => "Ugaritic",
                Script::NewTaiLue => "NewTaiLue",
                Script::Buginese => "Buginese",
                Script::Glagolitic => "Glagolitic",
                Script::Tifinagh => "Tifinagh",
                Script::SylotiNagri => "SylotiNagri",
                Script::OldPersian => "OldPersian",
                Script::Kharoshthi => "Kharoshthi",
                Script::Unknown => "Unknown",
                Script::Balinese => "Balinese",
                Script::Cuneiform => "Cuneiform",
                Script::Phoenician => "Phoenician",
                Script::PhagsPa => "PhagsPa",
                Script::Nko => "Nko",
                Script::KayahLi => "KayahLi",
                Script::Lepcha => "Lepcha",
                Script::Rejang => "Rejang",
                Script::Sundanese => "Sundanese",
                Script::Saurashtra => "Saurashtra",
                Script::Cham => "Cham",
                Script::OlChiki => "OlChiki",
                Script::Vai => "Vai",
                Script::Carian => "Carian",
                Script::Lycian => "Lycian",
                Script::Lydian => "Lydian",
                Script::Batak => "Batak",
                Script::Brahmi => "Brahmi",
                Script::Mandaic => "Mandaic",
                Script::Chakma => "Chakma",
                Script::MeroiticCursive => "MeroiticCursive",
                Script::MeroiticHieroglyphs => "MeroiticHieroglyphs",
                Script::Miao => "Miao",
                Script::Sharada => "Sharada",
                Script::SoraSompeng => "SoraSompeng",
                Script::Takri => "Takri",
                Script::BassaVah => "BassaVah",
                Script::CaucasianAlbanian => "CaucasianAlbanian",
                Script::Duployan => "Duployan",
                Script::Elbasan => "Elbasan",
                Script::Grantha => "Grantha",
                Script::Khojki => "Khojki",
                Script::Khudawadi => "Khudawadi",
                Script::LinearA => "LinearA",
                Script::Mahajani => "Mahajani",
                Script::Manichaean => "Manichaean",
                Script::MendeKikakui => "MendeKikakui",
                Script::Modi => "Modi",
                Script::Mro => "Mro",
                Script::Nabataean => "Nabataean",
                Script::OldNorthArabian => "OldNorthArabian",
                Script::OldPermic => "OldPermic",
                Script::PahawhHmong => "PahawhHmong",
                Script::Palmyrene => "Palmyrene",
                Script::PauCinHau => "PauCinHau",
                Script::PsalterPahlavi => "PsalterPahlavi",
                Script::Siddham => "Siddham",
                Script::Tirhuta => "Tirhuta",
                Script::WarangCiti => "WarangCiti",
                Script::Ahom => "Ahom",
                Script::AnatolianHieroglyphs => "AnatolianHieroglyphs",
                Script::Hatran => "Hatran",
                Script::Multani => "Multani",
                Script::OldHungarian => "OldHungarian",
                Script::Signwriting => "Signwriting",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Script {
    type GlibType = pango_sys::PangoScript;

    fn to_glib(&self) -> pango_sys::PangoScript {
        match *self {
            Script::InvalidCode => pango_sys::PANGO_SCRIPT_INVALID_CODE,
            Script::Common => pango_sys::PANGO_SCRIPT_COMMON,
            Script::Inherited => pango_sys::PANGO_SCRIPT_INHERITED,
            Script::Arabic => pango_sys::PANGO_SCRIPT_ARABIC,
            Script::Armenian => pango_sys::PANGO_SCRIPT_ARMENIAN,
            Script::Bengali => pango_sys::PANGO_SCRIPT_BENGALI,
            Script::Bopomofo => pango_sys::PANGO_SCRIPT_BOPOMOFO,
            Script::Cherokee => pango_sys::PANGO_SCRIPT_CHEROKEE,
            Script::Coptic => pango_sys::PANGO_SCRIPT_COPTIC,
            Script::Cyrillic => pango_sys::PANGO_SCRIPT_CYRILLIC,
            Script::Deseret => pango_sys::PANGO_SCRIPT_DESERET,
            Script::Devanagari => pango_sys::PANGO_SCRIPT_DEVANAGARI,
            Script::Ethiopic => pango_sys::PANGO_SCRIPT_ETHIOPIC,
            Script::Georgian => pango_sys::PANGO_SCRIPT_GEORGIAN,
            Script::Gothic => pango_sys::PANGO_SCRIPT_GOTHIC,
            Script::Greek => pango_sys::PANGO_SCRIPT_GREEK,
            Script::Gujarati => pango_sys::PANGO_SCRIPT_GUJARATI,
            Script::Gurmukhi => pango_sys::PANGO_SCRIPT_GURMUKHI,
            Script::Han => pango_sys::PANGO_SCRIPT_HAN,
            Script::Hangul => pango_sys::PANGO_SCRIPT_HANGUL,
            Script::Hebrew => pango_sys::PANGO_SCRIPT_HEBREW,
            Script::Hiragana => pango_sys::PANGO_SCRIPT_HIRAGANA,
            Script::Kannada => pango_sys::PANGO_SCRIPT_KANNADA,
            Script::Katakana => pango_sys::PANGO_SCRIPT_KATAKANA,
            Script::Khmer => pango_sys::PANGO_SCRIPT_KHMER,
            Script::Lao => pango_sys::PANGO_SCRIPT_LAO,
            Script::Latin => pango_sys::PANGO_SCRIPT_LATIN,
            Script::Malayalam => pango_sys::PANGO_SCRIPT_MALAYALAM,
            Script::Mongolian => pango_sys::PANGO_SCRIPT_MONGOLIAN,
            Script::Myanmar => pango_sys::PANGO_SCRIPT_MYANMAR,
            Script::Ogham => pango_sys::PANGO_SCRIPT_OGHAM,
            Script::OldItalic => pango_sys::PANGO_SCRIPT_OLD_ITALIC,
            Script::Oriya => pango_sys::PANGO_SCRIPT_ORIYA,
            Script::Runic => pango_sys::PANGO_SCRIPT_RUNIC,
            Script::Sinhala => pango_sys::PANGO_SCRIPT_SINHALA,
            Script::Syriac => pango_sys::PANGO_SCRIPT_SYRIAC,
            Script::Tamil => pango_sys::PANGO_SCRIPT_TAMIL,
            Script::Telugu => pango_sys::PANGO_SCRIPT_TELUGU,
            Script::Thaana => pango_sys::PANGO_SCRIPT_THAANA,
            Script::Thai => pango_sys::PANGO_SCRIPT_THAI,
            Script::Tibetan => pango_sys::PANGO_SCRIPT_TIBETAN,
            Script::CanadianAboriginal => pango_sys::PANGO_SCRIPT_CANADIAN_ABORIGINAL,
            Script::Yi => pango_sys::PANGO_SCRIPT_YI,
            Script::Tagalog => pango_sys::PANGO_SCRIPT_TAGALOG,
            Script::Hanunoo => pango_sys::PANGO_SCRIPT_HANUNOO,
            Script::Buhid => pango_sys::PANGO_SCRIPT_BUHID,
            Script::Tagbanwa => pango_sys::PANGO_SCRIPT_TAGBANWA,
            Script::Braille => pango_sys::PANGO_SCRIPT_BRAILLE,
            Script::Cypriot => pango_sys::PANGO_SCRIPT_CYPRIOT,
            Script::Limbu => pango_sys::PANGO_SCRIPT_LIMBU,
            Script::Osmanya => pango_sys::PANGO_SCRIPT_OSMANYA,
            Script::Shavian => pango_sys::PANGO_SCRIPT_SHAVIAN,
            Script::LinearB => pango_sys::PANGO_SCRIPT_LINEAR_B,
            Script::TaiLe => pango_sys::PANGO_SCRIPT_TAI_LE,
            Script::Ugaritic => pango_sys::PANGO_SCRIPT_UGARITIC,
            Script::NewTaiLue => pango_sys::PANGO_SCRIPT_NEW_TAI_LUE,
            Script::Buginese => pango_sys::PANGO_SCRIPT_BUGINESE,
            Script::Glagolitic => pango_sys::PANGO_SCRIPT_GLAGOLITIC,
            Script::Tifinagh => pango_sys::PANGO_SCRIPT_TIFINAGH,
            Script::SylotiNagri => pango_sys::PANGO_SCRIPT_SYLOTI_NAGRI,
            Script::OldPersian => pango_sys::PANGO_SCRIPT_OLD_PERSIAN,
            Script::Kharoshthi => pango_sys::PANGO_SCRIPT_KHAROSHTHI,
            Script::Unknown => pango_sys::PANGO_SCRIPT_UNKNOWN,
            Script::Balinese => pango_sys::PANGO_SCRIPT_BALINESE,
            Script::Cuneiform => pango_sys::PANGO_SCRIPT_CUNEIFORM,
            Script::Phoenician => pango_sys::PANGO_SCRIPT_PHOENICIAN,
            Script::PhagsPa => pango_sys::PANGO_SCRIPT_PHAGS_PA,
            Script::Nko => pango_sys::PANGO_SCRIPT_NKO,
            Script::KayahLi => pango_sys::PANGO_SCRIPT_KAYAH_LI,
            Script::Lepcha => pango_sys::PANGO_SCRIPT_LEPCHA,
            Script::Rejang => pango_sys::PANGO_SCRIPT_REJANG,
            Script::Sundanese => pango_sys::PANGO_SCRIPT_SUNDANESE,
            Script::Saurashtra => pango_sys::PANGO_SCRIPT_SAURASHTRA,
            Script::Cham => pango_sys::PANGO_SCRIPT_CHAM,
            Script::OlChiki => pango_sys::PANGO_SCRIPT_OL_CHIKI,
            Script::Vai => pango_sys::PANGO_SCRIPT_VAI,
            Script::Carian => pango_sys::PANGO_SCRIPT_CARIAN,
            Script::Lycian => pango_sys::PANGO_SCRIPT_LYCIAN,
            Script::Lydian => pango_sys::PANGO_SCRIPT_LYDIAN,
            Script::Batak => pango_sys::PANGO_SCRIPT_BATAK,
            Script::Brahmi => pango_sys::PANGO_SCRIPT_BRAHMI,
            Script::Mandaic => pango_sys::PANGO_SCRIPT_MANDAIC,
            Script::Chakma => pango_sys::PANGO_SCRIPT_CHAKMA,
            Script::MeroiticCursive => pango_sys::PANGO_SCRIPT_MEROITIC_CURSIVE,
            Script::MeroiticHieroglyphs => pango_sys::PANGO_SCRIPT_MEROITIC_HIEROGLYPHS,
            Script::Miao => pango_sys::PANGO_SCRIPT_MIAO,
            Script::Sharada => pango_sys::PANGO_SCRIPT_SHARADA,
            Script::SoraSompeng => pango_sys::PANGO_SCRIPT_SORA_SOMPENG,
            Script::Takri => pango_sys::PANGO_SCRIPT_TAKRI,
            Script::BassaVah => pango_sys::PANGO_SCRIPT_BASSA_VAH,
            Script::CaucasianAlbanian => pango_sys::PANGO_SCRIPT_CAUCASIAN_ALBANIAN,
            Script::Duployan => pango_sys::PANGO_SCRIPT_DUPLOYAN,
            Script::Elbasan => pango_sys::PANGO_SCRIPT_ELBASAN,
            Script::Grantha => pango_sys::PANGO_SCRIPT_GRANTHA,
            Script::Khojki => pango_sys::PANGO_SCRIPT_KHOJKI,
            Script::Khudawadi => pango_sys::PANGO_SCRIPT_KHUDAWADI,
            Script::LinearA => pango_sys::PANGO_SCRIPT_LINEAR_A,
            Script::Mahajani => pango_sys::PANGO_SCRIPT_MAHAJANI,
            Script::Manichaean => pango_sys::PANGO_SCRIPT_MANICHAEAN,
            Script::MendeKikakui => pango_sys::PANGO_SCRIPT_MENDE_KIKAKUI,
            Script::Modi => pango_sys::PANGO_SCRIPT_MODI,
            Script::Mro => pango_sys::PANGO_SCRIPT_MRO,
            Script::Nabataean => pango_sys::PANGO_SCRIPT_NABATAEAN,
            Script::OldNorthArabian => pango_sys::PANGO_SCRIPT_OLD_NORTH_ARABIAN,
            Script::OldPermic => pango_sys::PANGO_SCRIPT_OLD_PERMIC,
            Script::PahawhHmong => pango_sys::PANGO_SCRIPT_PAHAWH_HMONG,
            Script::Palmyrene => pango_sys::PANGO_SCRIPT_PALMYRENE,
            Script::PauCinHau => pango_sys::PANGO_SCRIPT_PAU_CIN_HAU,
            Script::PsalterPahlavi => pango_sys::PANGO_SCRIPT_PSALTER_PAHLAVI,
            Script::Siddham => pango_sys::PANGO_SCRIPT_SIDDHAM,
            Script::Tirhuta => pango_sys::PANGO_SCRIPT_TIRHUTA,
            Script::WarangCiti => pango_sys::PANGO_SCRIPT_WARANG_CITI,
            Script::Ahom => pango_sys::PANGO_SCRIPT_AHOM,
            Script::AnatolianHieroglyphs => pango_sys::PANGO_SCRIPT_ANATOLIAN_HIEROGLYPHS,
            Script::Hatran => pango_sys::PANGO_SCRIPT_HATRAN,
            Script::Multani => pango_sys::PANGO_SCRIPT_MULTANI,
            Script::OldHungarian => pango_sys::PANGO_SCRIPT_OLD_HUNGARIAN,
            Script::Signwriting => pango_sys::PANGO_SCRIPT_SIGNWRITING,
            Script::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoScript> for Script {
    fn from_glib(value: pango_sys::PangoScript) -> Self {
        match value {
            -1 => Script::InvalidCode,
            0 => Script::Common,
            1 => Script::Inherited,
            2 => Script::Arabic,
            3 => Script::Armenian,
            4 => Script::Bengali,
            5 => Script::Bopomofo,
            6 => Script::Cherokee,
            7 => Script::Coptic,
            8 => Script::Cyrillic,
            9 => Script::Deseret,
            10 => Script::Devanagari,
            11 => Script::Ethiopic,
            12 => Script::Georgian,
            13 => Script::Gothic,
            14 => Script::Greek,
            15 => Script::Gujarati,
            16 => Script::Gurmukhi,
            17 => Script::Han,
            18 => Script::Hangul,
            19 => Script::Hebrew,
            20 => Script::Hiragana,
            21 => Script::Kannada,
            22 => Script::Katakana,
            23 => Script::Khmer,
            24 => Script::Lao,
            25 => Script::Latin,
            26 => Script::Malayalam,
            27 => Script::Mongolian,
            28 => Script::Myanmar,
            29 => Script::Ogham,
            30 => Script::OldItalic,
            31 => Script::Oriya,
            32 => Script::Runic,
            33 => Script::Sinhala,
            34 => Script::Syriac,
            35 => Script::Tamil,
            36 => Script::Telugu,
            37 => Script::Thaana,
            38 => Script::Thai,
            39 => Script::Tibetan,
            40 => Script::CanadianAboriginal,
            41 => Script::Yi,
            42 => Script::Tagalog,
            43 => Script::Hanunoo,
            44 => Script::Buhid,
            45 => Script::Tagbanwa,
            46 => Script::Braille,
            47 => Script::Cypriot,
            48 => Script::Limbu,
            49 => Script::Osmanya,
            50 => Script::Shavian,
            51 => Script::LinearB,
            52 => Script::TaiLe,
            53 => Script::Ugaritic,
            54 => Script::NewTaiLue,
            55 => Script::Buginese,
            56 => Script::Glagolitic,
            57 => Script::Tifinagh,
            58 => Script::SylotiNagri,
            59 => Script::OldPersian,
            60 => Script::Kharoshthi,
            61 => Script::Unknown,
            62 => Script::Balinese,
            63 => Script::Cuneiform,
            64 => Script::Phoenician,
            65 => Script::PhagsPa,
            66 => Script::Nko,
            67 => Script::KayahLi,
            68 => Script::Lepcha,
            69 => Script::Rejang,
            70 => Script::Sundanese,
            71 => Script::Saurashtra,
            72 => Script::Cham,
            73 => Script::OlChiki,
            74 => Script::Vai,
            75 => Script::Carian,
            76 => Script::Lycian,
            77 => Script::Lydian,
            78 => Script::Batak,
            79 => Script::Brahmi,
            80 => Script::Mandaic,
            81 => Script::Chakma,
            82 => Script::MeroiticCursive,
            83 => Script::MeroiticHieroglyphs,
            84 => Script::Miao,
            85 => Script::Sharada,
            86 => Script::SoraSompeng,
            87 => Script::Takri,
            88 => Script::BassaVah,
            89 => Script::CaucasianAlbanian,
            90 => Script::Duployan,
            91 => Script::Elbasan,
            92 => Script::Grantha,
            93 => Script::Khojki,
            94 => Script::Khudawadi,
            95 => Script::LinearA,
            96 => Script::Mahajani,
            97 => Script::Manichaean,
            98 => Script::MendeKikakui,
            99 => Script::Modi,
            100 => Script::Mro,
            101 => Script::Nabataean,
            102 => Script::OldNorthArabian,
            103 => Script::OldPermic,
            104 => Script::PahawhHmong,
            105 => Script::Palmyrene,
            106 => Script::PauCinHau,
            107 => Script::PsalterPahlavi,
            108 => Script::Siddham,
            109 => Script::Tirhuta,
            110 => Script::WarangCiti,
            111 => Script::Ahom,
            112 => Script::AnatolianHieroglyphs,
            113 => Script::Hatran,
            114 => Script::Multani,
            115 => Script::OldHungarian,
            116 => Script::Signwriting,
            value => Script::__Unknown(value),
        }
    }
}

impl StaticType for Script {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_script_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Script {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Script {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Script {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Stretch {
    UltraCondensed,
    ExtraCondensed,
    Condensed,
    SemiCondensed,
    Normal,
    SemiExpanded,
    Expanded,
    ExtraExpanded,
    UltraExpanded,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Stretch {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Stretch::{}",
            match *self {
                Stretch::UltraCondensed => "UltraCondensed",
                Stretch::ExtraCondensed => "ExtraCondensed",
                Stretch::Condensed => "Condensed",
                Stretch::SemiCondensed => "SemiCondensed",
                Stretch::Normal => "Normal",
                Stretch::SemiExpanded => "SemiExpanded",
                Stretch::Expanded => "Expanded",
                Stretch::ExtraExpanded => "ExtraExpanded",
                Stretch::UltraExpanded => "UltraExpanded",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Stretch {
    type GlibType = pango_sys::PangoStretch;

    fn to_glib(&self) -> pango_sys::PangoStretch {
        match *self {
            Stretch::UltraCondensed => pango_sys::PANGO_STRETCH_ULTRA_CONDENSED,
            Stretch::ExtraCondensed => pango_sys::PANGO_STRETCH_EXTRA_CONDENSED,
            Stretch::Condensed => pango_sys::PANGO_STRETCH_CONDENSED,
            Stretch::SemiCondensed => pango_sys::PANGO_STRETCH_SEMI_CONDENSED,
            Stretch::Normal => pango_sys::PANGO_STRETCH_NORMAL,
            Stretch::SemiExpanded => pango_sys::PANGO_STRETCH_SEMI_EXPANDED,
            Stretch::Expanded => pango_sys::PANGO_STRETCH_EXPANDED,
            Stretch::ExtraExpanded => pango_sys::PANGO_STRETCH_EXTRA_EXPANDED,
            Stretch::UltraExpanded => pango_sys::PANGO_STRETCH_ULTRA_EXPANDED,
            Stretch::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoStretch> for Stretch {
    fn from_glib(value: pango_sys::PangoStretch) -> Self {
        match value {
            0 => Stretch::UltraCondensed,
            1 => Stretch::ExtraCondensed,
            2 => Stretch::Condensed,
            3 => Stretch::SemiCondensed,
            4 => Stretch::Normal,
            5 => Stretch::SemiExpanded,
            6 => Stretch::Expanded,
            7 => Stretch::ExtraExpanded,
            8 => Stretch::UltraExpanded,
            value => Stretch::__Unknown(value),
        }
    }
}

impl StaticType for Stretch {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_stretch_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Stretch {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Stretch {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Stretch {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Style {
    Normal,
    Oblique,
    Italic,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Style {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Style::{}",
            match *self {
                Style::Normal => "Normal",
                Style::Oblique => "Oblique",
                Style::Italic => "Italic",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Style {
    type GlibType = pango_sys::PangoStyle;

    fn to_glib(&self) -> pango_sys::PangoStyle {
        match *self {
            Style::Normal => pango_sys::PANGO_STYLE_NORMAL,
            Style::Oblique => pango_sys::PANGO_STYLE_OBLIQUE,
            Style::Italic => pango_sys::PANGO_STYLE_ITALIC,
            Style::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoStyle> for Style {
    fn from_glib(value: pango_sys::PangoStyle) -> Self {
        match value {
            0 => Style::Normal,
            1 => Style::Oblique,
            2 => Style::Italic,
            value => Style::__Unknown(value),
        }
    }
}

impl StaticType for Style {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_style_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Style {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Style {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Style {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum TabAlign {
    Left,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for TabAlign {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "TabAlign::{}",
            match *self {
                TabAlign::Left => "Left",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for TabAlign {
    type GlibType = pango_sys::PangoTabAlign;

    fn to_glib(&self) -> pango_sys::PangoTabAlign {
        match *self {
            TabAlign::Left => pango_sys::PANGO_TAB_LEFT,
            TabAlign::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoTabAlign> for TabAlign {
    fn from_glib(value: pango_sys::PangoTabAlign) -> Self {
        match value {
            0 => TabAlign::Left,
            value => TabAlign::__Unknown(value),
        }
    }
}

impl StaticType for TabAlign {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_tab_align_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for TabAlign {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for TabAlign {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for TabAlign {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Underline {
    None,
    Single,
    Double,
    Low,
    Error,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Underline {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Underline::{}",
            match *self {
                Underline::None => "None",
                Underline::Single => "Single",
                Underline::Double => "Double",
                Underline::Low => "Low",
                Underline::Error => "Error",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Underline {
    type GlibType = pango_sys::PangoUnderline;

    fn to_glib(&self) -> pango_sys::PangoUnderline {
        match *self {
            Underline::None => pango_sys::PANGO_UNDERLINE_NONE,
            Underline::Single => pango_sys::PANGO_UNDERLINE_SINGLE,
            Underline::Double => pango_sys::PANGO_UNDERLINE_DOUBLE,
            Underline::Low => pango_sys::PANGO_UNDERLINE_LOW,
            Underline::Error => pango_sys::PANGO_UNDERLINE_ERROR,
            Underline::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoUnderline> for Underline {
    fn from_glib(value: pango_sys::PangoUnderline) -> Self {
        match value {
            0 => Underline::None,
            1 => Underline::Single,
            2 => Underline::Double,
            3 => Underline::Low,
            4 => Underline::Error,
            value => Underline::__Unknown(value),
        }
    }
}

impl StaticType for Underline {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_underline_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Underline {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Underline {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Underline {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Variant {
    Normal,
    SmallCaps,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Variant {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Variant::{}",
            match *self {
                Variant::Normal => "Normal",
                Variant::SmallCaps => "SmallCaps",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Variant {
    type GlibType = pango_sys::PangoVariant;

    fn to_glib(&self) -> pango_sys::PangoVariant {
        match *self {
            Variant::Normal => pango_sys::PANGO_VARIANT_NORMAL,
            Variant::SmallCaps => pango_sys::PANGO_VARIANT_SMALL_CAPS,
            Variant::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoVariant> for Variant {
    fn from_glib(value: pango_sys::PangoVariant) -> Self {
        match value {
            0 => Variant::Normal,
            1 => Variant::SmallCaps,
            value => Variant::__Unknown(value),
        }
    }
}

impl StaticType for Variant {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_variant_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Variant {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Variant {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Variant {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum Weight {
    Thin,
    Ultralight,
    Light,
    Semilight,
    Book,
    Normal,
    Medium,
    Semibold,
    Bold,
    Ultrabold,
    Heavy,
    Ultraheavy,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for Weight {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "Weight::{}",
            match *self {
                Weight::Thin => "Thin",
                Weight::Ultralight => "Ultralight",
                Weight::Light => "Light",
                Weight::Semilight => "Semilight",
                Weight::Book => "Book",
                Weight::Normal => "Normal",
                Weight::Medium => "Medium",
                Weight::Semibold => "Semibold",
                Weight::Bold => "Bold",
                Weight::Ultrabold => "Ultrabold",
                Weight::Heavy => "Heavy",
                Weight::Ultraheavy => "Ultraheavy",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for Weight {
    type GlibType = pango_sys::PangoWeight;

    fn to_glib(&self) -> pango_sys::PangoWeight {
        match *self {
            Weight::Thin => pango_sys::PANGO_WEIGHT_THIN,
            Weight::Ultralight => pango_sys::PANGO_WEIGHT_ULTRALIGHT,
            Weight::Light => pango_sys::PANGO_WEIGHT_LIGHT,
            Weight::Semilight => pango_sys::PANGO_WEIGHT_SEMILIGHT,
            Weight::Book => pango_sys::PANGO_WEIGHT_BOOK,
            Weight::Normal => pango_sys::PANGO_WEIGHT_NORMAL,
            Weight::Medium => pango_sys::PANGO_WEIGHT_MEDIUM,
            Weight::Semibold => pango_sys::PANGO_WEIGHT_SEMIBOLD,
            Weight::Bold => pango_sys::PANGO_WEIGHT_BOLD,
            Weight::Ultrabold => pango_sys::PANGO_WEIGHT_ULTRABOLD,
            Weight::Heavy => pango_sys::PANGO_WEIGHT_HEAVY,
            Weight::Ultraheavy => pango_sys::PANGO_WEIGHT_ULTRAHEAVY,
            Weight::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoWeight> for Weight {
    fn from_glib(value: pango_sys::PangoWeight) -> Self {
        match value {
            100 => Weight::Thin,
            200 => Weight::Ultralight,
            300 => Weight::Light,
            350 => Weight::Semilight,
            380 => Weight::Book,
            400 => Weight::Normal,
            500 => Weight::Medium,
            600 => Weight::Semibold,
            700 => Weight::Bold,
            800 => Weight::Ultrabold,
            900 => Weight::Heavy,
            1000 => Weight::Ultraheavy,
            value => Weight::__Unknown(value),
        }
    }
}

impl StaticType for Weight {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_weight_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for Weight {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for Weight {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for Weight {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
pub enum WrapMode {
    Word,
    Char,
    WordChar,
    #[doc(hidden)]
    __Unknown(i32),
}

impl fmt::Display for WrapMode {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(
            f,
            "WrapMode::{}",
            match *self {
                WrapMode::Word => "Word",
                WrapMode::Char => "Char",
                WrapMode::WordChar => "WordChar",
                _ => "Unknown",
            }
        )
    }
}

#[doc(hidden)]
impl ToGlib for WrapMode {
    type GlibType = pango_sys::PangoWrapMode;

    fn to_glib(&self) -> pango_sys::PangoWrapMode {
        match *self {
            WrapMode::Word => pango_sys::PANGO_WRAP_WORD,
            WrapMode::Char => pango_sys::PANGO_WRAP_CHAR,
            WrapMode::WordChar => pango_sys::PANGO_WRAP_WORD_CHAR,
            WrapMode::__Unknown(value) => value,
        }
    }
}

#[doc(hidden)]
impl FromGlib<pango_sys::PangoWrapMode> for WrapMode {
    fn from_glib(value: pango_sys::PangoWrapMode) -> Self {
        match value {
            0 => WrapMode::Word,
            1 => WrapMode::Char,
            2 => WrapMode::WordChar,
            value => WrapMode::__Unknown(value),
        }
    }
}

impl StaticType for WrapMode {
    fn static_type() -> Type {
        unsafe { from_glib(pango_sys::pango_wrap_mode_get_type()) }
    }
}

impl<'a> FromValueOptional<'a> for WrapMode {
    unsafe fn from_value_optional(value: &Value) -> Option<Self> {
        Some(FromValue::from_value(value))
    }
}

impl<'a> FromValue<'a> for WrapMode {
    unsafe fn from_value(value: &Value) -> Self {
        from_glib(gobject_sys::g_value_get_enum(value.to_glib_none().0))
    }
}

impl SetValue for WrapMode {
    unsafe fn set_value(value: &mut Value, this: &Self) {
        gobject_sys::g_value_set_enum(value.to_glib_none_mut().0, this.to_glib())
    }
}
