/* baobab-ringschart.c generated by valac 0.21.1.26-279b7, the Vala compiler
 * generated from baobab-ringschart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <pango/pango.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;

#define BAOBAB_TYPE_RINGSCHART_ITEM (baobab_ringschart_item_get_type ())
#define BAOBAB_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem))
#define BAOBAB_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))
#define BAOBAB_IS_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_IS_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_RINGSCHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))

typedef struct _BaobabRingschartItem BaobabRingschartItem;
typedef struct _BaobabRingschartItemClass BaobabRingschartItemClass;
typedef struct _BaobabRingschartItemPrivate BaobabRingschartItemPrivate;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;

#define BAOBAB_TYPE_RINGSCHART (baobab_ringschart_get_type ())
#define BAOBAB_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschart))
#define BAOBAB_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))
#define BAOBAB_IS_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_IS_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_RINGSCHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))

typedef struct _BaobabRingschart BaobabRingschart;
typedef struct _BaobabRingschartClass BaobabRingschartClass;
typedef struct _BaobabRingschartPrivate BaobabRingschartPrivate;
#define __g_list_free__baobab_chart_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_chart_item_unref0_ (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabRingschartItem {
	BaobabChartItem parent_instance;
	BaobabRingschartItemPrivate * priv;
	gdouble min_radius;
	gdouble max_radius;
	gdouble start_angle;
	gdouble angle;
	gboolean continued;
};

struct _BaobabRingschartItemClass {
	BaobabChartItemClass parent_class;
};

struct _BaobabChart {
	GtkWidget parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkWidgetClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabRingschart {
	BaobabChart parent_instance;
	BaobabRingschartPrivate * priv;
};

struct _BaobabRingschartClass {
	BaobabChartClass parent_class;
};

struct _BaobabRingschartPrivate {
	guint tips_timeout_id;
	gboolean drawing_subtips;
	GList* subtip_items;
};


static gpointer baobab_ringschart_item_parent_class = NULL;
static gpointer baobab_ringschart_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_item_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_RINGSCHART_ITEM_DUMMY_PROPERTY
};
BaobabRingschartItem* baobab_ringschart_item_new (void);
BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type);
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_ringschart_item_finalize (BaobabChartItem* obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_get_type (void) G_GNUC_CONST;
#define BAOBAB_RINGSCHART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_RINGSCHART, BaobabRingschartPrivate))
enum  {
	BAOBAB_RINGSCHART_DUMMY_PROPERTY
};
static void _baobab_chart_item_unref0_ (gpointer var);
static void _g_list_free__baobab_chart_item_unref0_ (GList* self);
#define BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH 1
#define BAOBAB_RINGSCHART_ITEM_MIN_ANGLE 0.03
#define BAOBAB_RINGSCHART_EDGE_ANGLE 0.004
#define BAOBAB_RINGSCHART_SUBTIP_TIMEOUT 1000
static void baobab_ringschart_subtips_update (BaobabRingschart* self);
BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self);
static gboolean ___lambda18_ (BaobabRingschart* self);
static gboolean ____lambda18__gsource_func (gpointer self);
static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base);
static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr);
static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item);
guint baobab_chart_get_max_depth (BaobabChart* self);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r);
static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item);
static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base);
#define BAOBAB_CHART_MAX_DEPTH ((guint) 5)
static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base);
#define BAOBAB_CHART_MIN_DEPTH ((guint) 1)
BaobabRingschart* baobab_ringschart_new (void);
BaobabRingschart* baobab_ringschart_construct (GType object_type);
BaobabChart* baobab_chart_construct (GType object_type);
static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void baobab_ringschart_finalize (GObject* obj);


BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type) {
	BaobabRingschartItem* self = NULL;
	self = (BaobabRingschartItem*) baobab_chart_item_construct (object_type);
	return self;
}


BaobabRingschartItem* baobab_ringschart_item_new (void) {
	return baobab_ringschart_item_construct (BAOBAB_TYPE_RINGSCHART_ITEM);
}


static void baobab_ringschart_item_class_init (BaobabRingschartItemClass * klass) {
	baobab_ringschart_item_parent_class = g_type_class_peek_parent (klass);
	BAOBAB_CHART_ITEM_CLASS (klass)->finalize = baobab_ringschart_item_finalize;
}


static void baobab_ringschart_item_instance_init (BaobabRingschartItem * self) {
}


static void baobab_ringschart_item_finalize (BaobabChartItem* obj) {
	BaobabRingschartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem);
	BAOBAB_CHART_ITEM_CLASS (baobab_ringschart_item_parent_class)->finalize (obj);
}


GType baobab_ringschart_item_get_type (void) {
	static volatile gsize baobab_ringschart_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschartItem), 0, (GInstanceInitFunc) baobab_ringschart_item_instance_init, NULL };
		GType baobab_ringschart_item_type_id;
		baobab_ringschart_item_type_id = g_type_register_static (BAOBAB_TYPE_CHART_ITEM, "BaobabRingschartItem", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_item_type_id__volatile, baobab_ringschart_item_type_id);
	}
	return baobab_ringschart_item_type_id__volatile;
}


static void _baobab_chart_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}


static void _g_list_free__baobab_chart_item_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_chart_item_unref0_, NULL);
	g_list_free (self);
}


static gboolean ___lambda18_ (BaobabRingschart* self) {
	gboolean result = FALSE;
	self->priv->drawing_subtips = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean ____lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda18_ (self);
	return result;
}


static void baobab_ringschart_subtips_update (BaobabRingschart* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	BaobabChartItem* _tmp3_ = NULL;
	BaobabChartItem* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	self->priv->drawing_subtips = FALSE;
	_tmp1_ = self->priv->tips_timeout_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->tips_timeout_id;
		g_source_remove (_tmp2_);
		self->priv->tips_timeout_id = (guint) 0;
	}
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	self->priv->subtip_items = NULL;
	_tmp3_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		guint _tmp5_ = 0U;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BAOBAB_RINGSCHART_SUBTIP_TIMEOUT, ____lambda18__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->tips_timeout_id = _tmp5_;
	}
}


static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base) {
	BaobabRingschart * self;
	BaobabChartItem* result = NULL;
	BaobabRingschartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_ringschart_item_new ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_CHART_ITEM) ? ((BaobabChartItem*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_baobab_chart_item_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr) {
	BaobabRingschart * self;
	gboolean _tmp0_ = FALSE;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp5_ = {0};
	gint q_width = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint q_height = 0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	gdouble q_angle = 0.0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp12_ = 0.0;
	GdkRectangle last_rect = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp13_ = NULL;
	GtkBorder _tmp14_ = {0};
	gint16 vpadding = 0;
	GtkBorder _tmp15_ = {0};
	gint16 _tmp16_ = 0;
	GtkBorder _tmp17_ = {0};
	gint16 _tmp18_ = 0;
	gint16 hpadding = 0;
	GtkBorder _tmp19_ = {0};
	gint16 _tmp20_ = 0;
	GtkBorder _tmp21_ = {0};
	gint16 _tmp22_ = 0;
	GList* _tmp23_ = NULL;
	GtkStyleContext* _tmp208_ = NULL;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	gtk_style_context_save (_tmp3_);
	_tmp4_ = context;
	gtk_style_context_add_class (_tmp4_, "subfolder-tip");
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = allocation;
	_tmp7_ = _tmp6_.width;
	q_width = _tmp7_ / 2;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.height;
	q_height = _tmp9_ / 2;
	_tmp10_ = q_height;
	_tmp11_ = q_width;
	_tmp12_ = atan2 ((gdouble) _tmp10_, (gdouble) _tmp11_);
	q_angle = _tmp12_;
	memset (&last_rect, 0, sizeof (GdkRectangle));
	_tmp13_ = context;
	gtk_style_context_get_padding (_tmp13_, GTK_STATE_FLAG_NORMAL, &_tmp14_);
	padding = _tmp14_;
	_tmp15_ = padding;
	_tmp16_ = _tmp15_.top;
	_tmp17_ = padding;
	_tmp18_ = _tmp17_.bottom;
	vpadding = _tmp16_ + _tmp18_;
	_tmp19_ = padding;
	_tmp20_ = _tmp19_.left;
	_tmp21_ = padding;
	_tmp22_ = _tmp21_.right;
	hpadding = _tmp20_ + _tmp22_;
	_tmp23_ = self->priv->subtip_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp23_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp24_ = NULL;
			BaobabChartItem* item = NULL;
			_tmp24_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp24_;
			{
				BaobabRingschartItem* ringsitem = NULL;
				BaobabChartItem* _tmp25_ = NULL;
				BaobabRingschartItem* _tmp26_ = NULL;
				gdouble middle_angle = 0.0;
				BaobabRingschartItem* _tmp27_ = NULL;
				gdouble _tmp28_ = 0.0;
				BaobabRingschartItem* _tmp29_ = NULL;
				gdouble _tmp30_ = 0.0;
				gdouble middle_angle_n = 0.0;
				gdouble _tmp31_ = 0.0;
				gdouble _tmp34_ = 0.0;
				gdouble _tmp35_ = 0.0;
				PangoLayout* layout = NULL;
				PangoLayout* _tmp36_ = NULL;
				gchar* markup = NULL;
				BaobabChartItem* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				PangoLayout* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				PangoLayout* _tmp47_ = NULL;
				PangoLayout* _tmp48_ = NULL;
				PangoRectangle layout_rect = {0};
				PangoLayout* _tmp49_ = NULL;
				PangoRectangle _tmp50_ = {0};
				gdouble tip_x = 0.0;
				gdouble tip_y = 0.0;
				gdouble _tmp51_ = 0.0;
				gdouble _tmp52_ = 0.0;
				cairo_rectangle_t tooltip_rect = {0};
				gint _tmp67_ = 0;
				gdouble _tmp68_ = 0.0;
				PangoRectangle _tmp69_ = {0};
				gint _tmp70_ = 0;
				GtkBorder _tmp71_ = {0};
				gint16 _tmp72_ = 0;
				gint _tmp73_ = 0;
				gdouble _tmp74_ = 0.0;
				PangoRectangle _tmp75_ = {0};
				gint _tmp76_ = 0;
				GtkBorder _tmp77_ = {0};
				gint16 _tmp78_ = 0;
				PangoRectangle _tmp79_ = {0};
				gint _tmp80_ = 0;
				gint16 _tmp81_ = 0;
				PangoRectangle _tmp82_ = {0};
				gint _tmp83_ = 0;
				gint16 _tmp84_ = 0;
				cairo_rectangle_t _tmp85_ = {0};
				gdouble _tmp86_ = 0.0;
				gint _tmp87_ = 0;
				gdouble a = 0.0;
				gdouble _tmp88_ = 0.0;
				gint i = 0;
				GdkRectangle _rect = {0};
				cairo_rectangle_t _tmp105_ = {0};
				gdouble _tmp106_ = 0.0;
				cairo_rectangle_t _tmp107_ = {0};
				gdouble _tmp108_ = 0.0;
				cairo_rectangle_t _tmp109_ = {0};
				gdouble _tmp110_ = 0.0;
				cairo_rectangle_t _tmp111_ = {0};
				gdouble _tmp112_ = 0.0;
				GdkRectangle _tmp113_ = {0};
				gboolean _tmp114_ = FALSE;
				_tmp25_ = item;
				_tmp26_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp25_) : NULL);
				ringsitem = _tmp26_;
				_tmp27_ = ringsitem;
				_tmp28_ = _tmp27_->start_angle;
				_tmp29_ = ringsitem;
				_tmp30_ = _tmp29_->angle;
				middle_angle = _tmp28_ + (_tmp30_ / 2);
				_tmp31_ = middle_angle;
				middle_angle_n = _tmp31_;
				while (TRUE) {
					gdouble _tmp32_ = 0.0;
					gdouble _tmp33_ = 0.0;
					_tmp32_ = middle_angle_n;
					if (!(_tmp32_ > (G_PI / 2))) {
						break;
					}
					_tmp33_ = middle_angle_n;
					middle_angle_n = _tmp33_ - G_PI;
				}
				_tmp34_ = middle_angle_n;
				_tmp35_ = fabs (_tmp34_);
				middle_angle_n = _tmp35_;
				_tmp36_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
				layout = _tmp36_;
				_tmp37_ = item;
				_tmp38_ = _tmp37_->name;
				_tmp39_ = g_markup_escape_text (_tmp38_, (gssize) (-1));
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat ("<span size=\"small\">", _tmp40_, NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat (_tmp42_, "</span>", NULL);
				_tmp44_ = _tmp43_;
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				markup = _tmp44_;
				_tmp45_ = layout;
				_tmp46_ = markup;
				pango_layout_set_markup (_tmp45_, _tmp46_, -1);
				_tmp47_ = layout;
				pango_layout_set_indent (_tmp47_, 0);
				_tmp48_ = layout;
				pango_layout_set_spacing (_tmp48_, 0);
				_tmp49_ = layout;
				pango_layout_get_pixel_extents (_tmp49_, NULL, &_tmp50_);
				layout_rect = _tmp50_;
				_tmp51_ = middle_angle_n;
				_tmp52_ = q_angle;
				if (_tmp51_ < _tmp52_) {
					gint _tmp53_ = 0;
					PangoRectangle _tmp54_ = {0};
					gint _tmp55_ = 0;
					gint16 _tmp56_ = 0;
					gdouble _tmp57_ = 0.0;
					gdouble _tmp58_ = 0.0;
					gdouble _tmp59_ = 0.0;
					_tmp53_ = q_width;
					_tmp54_ = layout_rect;
					_tmp55_ = _tmp54_.width;
					_tmp56_ = hpadding;
					tip_x = (gdouble) ((_tmp53_ - (_tmp55_ / 2)) - _tmp56_);
					_tmp57_ = middle_angle_n;
					_tmp58_ = tan (_tmp57_);
					_tmp59_ = tip_x;
					tip_y = _tmp58_ * _tmp59_;
				} else {
					gint _tmp60_ = 0;
					PangoRectangle _tmp61_ = {0};
					gint _tmp62_ = 0;
					gint16 _tmp63_ = 0;
					gdouble _tmp64_ = 0.0;
					gdouble _tmp65_ = 0.0;
					gdouble _tmp66_ = 0.0;
					_tmp60_ = q_height;
					_tmp61_ = layout_rect;
					_tmp62_ = _tmp61_.height;
					_tmp63_ = vpadding;
					tip_y = (gdouble) ((_tmp60_ - (_tmp62_ / 2)) - _tmp63_);
					_tmp64_ = tip_y;
					_tmp65_ = middle_angle_n;
					_tmp66_ = tan (_tmp65_);
					tip_x = _tmp64_ / _tmp66_;
				}
				memset (&tooltip_rect, 0, sizeof (cairo_rectangle_t));
				_tmp67_ = q_width;
				_tmp68_ = tip_x;
				_tmp69_ = layout_rect;
				_tmp70_ = _tmp69_.width;
				_tmp71_ = padding;
				_tmp72_ = _tmp71_.left;
				tooltip_rect.x = ((_tmp67_ + _tmp68_) - (_tmp70_ / 2)) - _tmp72_;
				_tmp73_ = q_height;
				_tmp74_ = tip_y;
				_tmp75_ = layout_rect;
				_tmp76_ = _tmp75_.height;
				_tmp77_ = padding;
				_tmp78_ = _tmp77_.top;
				tooltip_rect.y = ((_tmp73_ + _tmp74_) - (_tmp76_ / 2)) - _tmp78_;
				_tmp79_ = layout_rect;
				_tmp80_ = _tmp79_.width;
				_tmp81_ = hpadding;
				tooltip_rect.width = (gdouble) (_tmp80_ + _tmp81_);
				_tmp82_ = layout_rect;
				_tmp83_ = _tmp82_.height;
				_tmp84_ = vpadding;
				tooltip_rect.height = (gdouble) (_tmp83_ + _tmp84_);
				_tmp85_ = tooltip_rect;
				_tmp86_ = _tmp85_.width;
				_tmp87_ = q_width;
				if (_tmp86_ > ((gdouble) _tmp87_)) {
					_g_free0 (markup);
					_g_object_unref0 (layout);
					_baobab_chart_item_unref0 (ringsitem);
					_baobab_chart_item_unref0 (item);
					continue;
				}
				_tmp88_ = middle_angle;
				a = _tmp88_;
				i = 0;
				while (TRUE) {
					gdouble _tmp89_ = 0.0;
					gint _tmp90_ = 0;
					gint _tmp103_ = 0;
					gdouble _tmp104_ = 0.0;
					_tmp89_ = a;
					if (!(_tmp89_ > (G_PI / 2))) {
						break;
					}
					_tmp90_ = i;
					if ((_tmp90_ % 2) == 0) {
						GtkAllocation _tmp91_ = {0};
						gint _tmp92_ = 0;
						cairo_rectangle_t _tmp93_ = {0};
						gdouble _tmp94_ = 0.0;
						cairo_rectangle_t _tmp95_ = {0};
						gdouble _tmp96_ = 0.0;
						_tmp91_ = allocation;
						_tmp92_ = _tmp91_.width;
						_tmp93_ = tooltip_rect;
						_tmp94_ = _tmp93_.x;
						_tmp95_ = tooltip_rect;
						_tmp96_ = _tmp95_.width;
						tooltip_rect.x = (_tmp92_ - _tmp94_) - _tmp96_;
					} else {
						GtkAllocation _tmp97_ = {0};
						gint _tmp98_ = 0;
						cairo_rectangle_t _tmp99_ = {0};
						gdouble _tmp100_ = 0.0;
						cairo_rectangle_t _tmp101_ = {0};
						gdouble _tmp102_ = 0.0;
						_tmp97_ = allocation;
						_tmp98_ = _tmp97_.height;
						_tmp99_ = tooltip_rect;
						_tmp100_ = _tmp99_.y;
						_tmp101_ = tooltip_rect;
						_tmp102_ = _tmp101_.height;
						tooltip_rect.y = (_tmp98_ - _tmp100_) - _tmp102_;
					}
					_tmp103_ = i;
					i = _tmp103_ + 1;
					_tmp104_ = a;
					a = _tmp104_ - (G_PI / 2);
				}
				memset (&_rect, 0, sizeof (GdkRectangle));
				_tmp105_ = tooltip_rect;
				_tmp106_ = _tmp105_.x;
				_rect.x = (gint) (_tmp106_ - 1);
				_tmp107_ = tooltip_rect;
				_tmp108_ = _tmp107_.y;
				_rect.y = (gint) (_tmp108_ - 1);
				_tmp109_ = tooltip_rect;
				_tmp110_ = _tmp109_.width;
				_rect.width = (gint) (_tmp110_ + 2);
				_tmp111_ = tooltip_rect;
				_tmp112_ = _tmp111_.height;
				_rect.height = (gint) (_tmp112_ + 2);
				_tmp113_ = last_rect;
				_tmp114_ = gdk_rectangle_intersect (&_rect, &_tmp113_, NULL);
				if (!_tmp114_) {
					GdkRectangle _tmp115_ = {0};
					cairo_rectangle_t _tmp116_ = {0};
					gdouble _tmp117_ = 0.0;
					gdouble _tmp118_ = 0.0;
					cairo_rectangle_t _tmp119_ = {0};
					gdouble _tmp120_ = 0.0;
					gdouble _tmp121_ = 0.0;
					gdouble middle_radius = 0.0;
					BaobabRingschartItem* _tmp122_ = NULL;
					gdouble _tmp123_ = 0.0;
					BaobabRingschartItem* _tmp124_ = NULL;
					gdouble _tmp125_ = 0.0;
					BaobabRingschartItem* _tmp126_ = NULL;
					gdouble _tmp127_ = 0.0;
					gdouble sector_center_x = 0.0;
					gint _tmp128_ = 0;
					gdouble _tmp129_ = 0.0;
					gdouble _tmp130_ = 0.0;
					gdouble _tmp131_ = 0.0;
					gdouble sector_center_y = 0.0;
					gint _tmp132_ = 0;
					gdouble _tmp133_ = 0.0;
					gdouble _tmp134_ = 0.0;
					gdouble _tmp135_ = 0.0;
					cairo_t* _tmp136_ = NULL;
					cairo_t* _tmp137_ = NULL;
					GtkAllocation _tmp138_ = {0};
					gint _tmp139_ = 0;
					GtkAllocation _tmp140_ = {0};
					gint _tmp141_ = 0;
					cairo_t* _tmp142_ = NULL;
					cairo_rectangle_t _tmp143_ = {0};
					gdouble _tmp144_ = 0.0;
					cairo_rectangle_t _tmp145_ = {0};
					gdouble _tmp146_ = 0.0;
					cairo_rectangle_t _tmp147_ = {0};
					gdouble _tmp148_ = 0.0;
					cairo_rectangle_t _tmp149_ = {0};
					gdouble _tmp150_ = 0.0;
					cairo_rectangle_t _tmp151_ = {0};
					gdouble _tmp152_ = 0.0;
					cairo_t* _tmp153_ = NULL;
					GdkRGBA bg_color = {0};
					GtkStyleContext* _tmp154_ = NULL;
					GdkRGBA _tmp155_ = {0};
					cairo_t* _tmp156_ = NULL;
					cairo_t* _tmp157_ = NULL;
					gdouble _tmp158_ = 0.0;
					gdouble _tmp159_ = 0.0;
					cairo_t* _tmp160_ = NULL;
					GdkRGBA _tmp161_ = {0};
					cairo_t* _tmp162_ = NULL;
					cairo_rectangle_t _tmp163_ = {0};
					gdouble _tmp164_ = 0.0;
					cairo_rectangle_t _tmp165_ = {0};
					gdouble _tmp166_ = 0.0;
					cairo_rectangle_t _tmp167_ = {0};
					gdouble _tmp168_ = 0.0;
					cairo_rectangle_t _tmp169_ = {0};
					gdouble _tmp170_ = 0.0;
					cairo_t* _tmp171_ = NULL;
					cairo_t* _tmp172_ = NULL;
					cairo_t* _tmp173_ = NULL;
					gdouble _tmp174_ = 0.0;
					gdouble _tmp175_ = 0.0;
					cairo_t* _tmp176_ = NULL;
					GtkStyleContext* _tmp177_ = NULL;
					cairo_t* _tmp178_ = NULL;
					cairo_rectangle_t _tmp179_ = {0};
					gdouble _tmp180_ = 0.0;
					cairo_rectangle_t _tmp181_ = {0};
					gdouble _tmp182_ = 0.0;
					cairo_rectangle_t _tmp183_ = {0};
					gdouble _tmp184_ = 0.0;
					cairo_rectangle_t _tmp185_ = {0};
					gdouble _tmp186_ = 0.0;
					GtkStyleContext* _tmp187_ = NULL;
					cairo_t* _tmp188_ = NULL;
					cairo_rectangle_t _tmp189_ = {0};
					gdouble _tmp190_ = 0.0;
					cairo_rectangle_t _tmp191_ = {0};
					gdouble _tmp192_ = 0.0;
					cairo_rectangle_t _tmp193_ = {0};
					gdouble _tmp194_ = 0.0;
					cairo_rectangle_t _tmp195_ = {0};
					gdouble _tmp196_ = 0.0;
					GtkStyleContext* _tmp197_ = NULL;
					cairo_t* _tmp198_ = NULL;
					cairo_rectangle_t _tmp199_ = {0};
					gdouble _tmp200_ = 0.0;
					GtkBorder _tmp201_ = {0};
					gint16 _tmp202_ = 0;
					cairo_rectangle_t _tmp203_ = {0};
					gdouble _tmp204_ = 0.0;
					GtkBorder _tmp205_ = {0};
					gint16 _tmp206_ = 0;
					PangoLayout* _tmp207_ = NULL;
					_tmp115_ = _rect;
					last_rect = _tmp115_;
					_tmp116_ = tooltip_rect;
					_tmp117_ = _tmp116_.x;
					_tmp118_ = floor (_tmp117_);
					tooltip_rect.x = _tmp118_;
					_tmp119_ = tooltip_rect;
					_tmp120_ = _tmp119_.y;
					_tmp121_ = floor (_tmp120_);
					tooltip_rect.y = _tmp121_;
					_tmp122_ = ringsitem;
					_tmp123_ = _tmp122_->min_radius;
					_tmp124_ = ringsitem;
					_tmp125_ = _tmp124_->max_radius;
					_tmp126_ = ringsitem;
					_tmp127_ = _tmp126_->min_radius;
					middle_radius = _tmp123_ + ((_tmp125_ - _tmp127_) / 2);
					_tmp128_ = q_width;
					_tmp129_ = middle_radius;
					_tmp130_ = middle_angle;
					_tmp131_ = cos (_tmp130_);
					sector_center_x = _tmp128_ + (_tmp129_ * _tmp131_);
					_tmp132_ = q_height;
					_tmp133_ = middle_radius;
					_tmp134_ = middle_angle;
					_tmp135_ = sin (_tmp134_);
					sector_center_y = _tmp132_ + (_tmp133_ * _tmp135_);
					_tmp136_ = cr;
					cairo_save (_tmp136_);
					_tmp137_ = cr;
					_tmp138_ = allocation;
					_tmp139_ = _tmp138_.width;
					_tmp140_ = allocation;
					_tmp141_ = _tmp140_.height;
					cairo_rectangle (_tmp137_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp139_, (gdouble) _tmp141_);
					_tmp142_ = cr;
					_tmp143_ = tooltip_rect;
					_tmp144_ = _tmp143_.x;
					_tmp145_ = tooltip_rect;
					_tmp146_ = _tmp145_.width;
					_tmp147_ = tooltip_rect;
					_tmp148_ = _tmp147_.y;
					_tmp149_ = tooltip_rect;
					_tmp150_ = _tmp149_.width;
					_tmp151_ = tooltip_rect;
					_tmp152_ = _tmp151_.height;
					cairo_rectangle (_tmp142_, _tmp144_ + _tmp146_, _tmp148_, -_tmp150_, _tmp152_);
					_tmp153_ = cr;
					cairo_clip (_tmp153_);
					_tmp154_ = context;
					gtk_style_context_get_background_color (_tmp154_, GTK_STATE_FLAG_NORMAL, &_tmp155_);
					bg_color = _tmp155_;
					_tmp156_ = cr;
					cairo_set_line_width (_tmp156_, (gdouble) 1);
					_tmp157_ = cr;
					_tmp158_ = sector_center_x;
					_tmp159_ = sector_center_y;
					cairo_move_to (_tmp157_, _tmp158_, _tmp159_);
					_tmp160_ = cr;
					_tmp161_ = bg_color;
					gdk_cairo_set_source_rgba (_tmp160_, &_tmp161_);
					_tmp162_ = cr;
					_tmp163_ = tooltip_rect;
					_tmp164_ = _tmp163_.x;
					_tmp165_ = tooltip_rect;
					_tmp166_ = _tmp165_.width;
					_tmp167_ = tooltip_rect;
					_tmp168_ = _tmp167_.y;
					_tmp169_ = tooltip_rect;
					_tmp170_ = _tmp169_.height;
					cairo_line_to (_tmp162_, _tmp164_ + (_tmp166_ / 2), _tmp168_ + (_tmp170_ / 2));
					_tmp171_ = cr;
					cairo_stroke (_tmp171_);
					_tmp172_ = cr;
					cairo_restore (_tmp172_);
					_tmp173_ = cr;
					_tmp174_ = sector_center_x;
					_tmp175_ = sector_center_y;
					cairo_arc (_tmp173_, _tmp174_, _tmp175_, 1.0, (gdouble) 0, 2 * G_PI);
					_tmp176_ = cr;
					cairo_stroke (_tmp176_);
					_tmp177_ = context;
					_tmp178_ = cr;
					_tmp179_ = tooltip_rect;
					_tmp180_ = _tmp179_.x;
					_tmp181_ = tooltip_rect;
					_tmp182_ = _tmp181_.y;
					_tmp183_ = tooltip_rect;
					_tmp184_ = _tmp183_.width;
					_tmp185_ = tooltip_rect;
					_tmp186_ = _tmp185_.height;
					gtk_render_background (_tmp177_, _tmp178_, _tmp180_, _tmp182_, _tmp184_, _tmp186_);
					_tmp187_ = context;
					_tmp188_ = cr;
					_tmp189_ = tooltip_rect;
					_tmp190_ = _tmp189_.x;
					_tmp191_ = tooltip_rect;
					_tmp192_ = _tmp191_.y;
					_tmp193_ = tooltip_rect;
					_tmp194_ = _tmp193_.width;
					_tmp195_ = tooltip_rect;
					_tmp196_ = _tmp195_.height;
					gtk_render_frame (_tmp187_, _tmp188_, _tmp190_, _tmp192_, _tmp194_, _tmp196_);
					_tmp197_ = context;
					_tmp198_ = cr;
					_tmp199_ = tooltip_rect;
					_tmp200_ = _tmp199_.x;
					_tmp201_ = padding;
					_tmp202_ = _tmp201_.left;
					_tmp203_ = tooltip_rect;
					_tmp204_ = _tmp203_.y;
					_tmp205_ = padding;
					_tmp206_ = _tmp205_.top;
					_tmp207_ = layout;
					gtk_render_layout (_tmp197_, _tmp198_, _tmp200_ + _tmp202_, _tmp204_ + _tmp206_, _tmp207_);
				}
				_g_free0 (markup);
				_g_object_unref0 (layout);
				_baobab_chart_item_unref0 (ringsitem);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp208_ = context;
	gtk_style_context_restore (_tmp208_);
	_g_object_unref0 (context);
}


static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_t* _tmp18_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp19_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GdkRGBA border_color = {0};
	GtkStyleContext* _tmp22_ = NULL;
	GdkRGBA _tmp23_ = {0};
	GdkRGBA bg_color = {0};
	GtkStyleContext* _tmp24_ = NULL;
	GdkRGBA _tmp25_ = {0};
	gint center_x = 0;
	GtkAllocation _tmp26_ = {0};
	gint _tmp27_ = 0;
	gint center_y = 0;
	GtkAllocation _tmp28_ = {0};
	gint _tmp29_ = 0;
	gdouble final_angle = 0.0;
	BaobabRingschartItem* _tmp30_ = NULL;
	gdouble _tmp31_ = 0.0;
	BaobabRingschartItem* _tmp32_ = NULL;
	gdouble _tmp33_ = 0.0;
	BaobabChartItem* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = self->priv->drawing_subtips;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		BaobabChartItem* _tmp5_ = NULL;
		BaobabChartItem* _tmp6_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp15_ = FALSE;
		_tmp5_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			BaobabChartItem* _tmp7_ = NULL;
			GList* _tmp8_ = NULL;
			_tmp7_ = item;
			_tmp8_ = _tmp7_->parent;
			_tmp4_ = _tmp8_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp9_ = _tmp4_;
		if (_tmp9_) {
			BaobabChartItem* _tmp10_ = NULL;
			GList* _tmp11_ = NULL;
			gconstpointer _tmp12_ = NULL;
			BaobabChartItem* _tmp13_ = NULL;
			BaobabChartItem* _tmp14_ = NULL;
			_tmp10_ = item;
			_tmp11_ = _tmp10_->parent;
			_tmp12_ = _tmp11_->data;
			_tmp13_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
			_tmp14_ = _tmp13_;
			_tmp3_ = ((BaobabChartItem*) _tmp12_) == _tmp14_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp15_ = _tmp3_;
		if (_tmp15_) {
			BaobabChartItem* _tmp16_ = NULL;
			BaobabChartItem* _tmp17_ = NULL;
			_tmp16_ = item;
			_tmp17_ = _baobab_chart_item_ref0 (_tmp16_);
			self->priv->subtip_items = g_list_prepend (self->priv->subtip_items, _tmp17_);
		}
	}
	_tmp18_ = cr;
	cairo_set_line_width (_tmp18_, (gdouble) BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp19_);
	allocation = _tmp19_;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	context = _tmp21_;
	_tmp22_ = context;
	gtk_style_context_get_border_color (_tmp22_, GTK_STATE_FLAG_NORMAL, &_tmp23_);
	border_color = _tmp23_;
	_tmp24_ = context;
	gtk_style_context_get_background_color (_tmp24_, GTK_STATE_FLAG_NORMAL, &_tmp25_);
	bg_color = _tmp25_;
	_tmp26_ = allocation;
	_tmp27_ = _tmp26_.width;
	center_x = _tmp27_ / 2;
	_tmp28_ = allocation;
	_tmp29_ = _tmp28_.height;
	center_y = _tmp29_ / 2;
	_tmp30_ = ringsitem;
	_tmp31_ = _tmp30_->start_angle;
	_tmp32_ = ringsitem;
	_tmp33_ = _tmp32_->angle;
	final_angle = _tmp31_ + _tmp33_;
	_tmp34_ = item;
	_tmp35_ = _tmp34_->depth;
	if (_tmp35_ == ((guint) 0)) {
		PangoLayout* layout = NULL;
		PangoLayout* _tmp36_ = NULL;
		gchar* markup = NULL;
		BaobabChartItem* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		PangoLayout* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		PangoLayout* _tmp47_ = NULL;
		PangoLayout* _tmp48_ = NULL;
		PangoRectangle layout_rect = {0};
		PangoLayout* _tmp49_ = NULL;
		PangoRectangle _tmp50_ = {0};
		PangoRectangle _tmp51_ = {0};
		gint _tmp52_ = 0;
		BaobabRingschartItem* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		cairo_t* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		BaobabRingschartItem* _tmp72_ = NULL;
		gdouble _tmp73_ = 0.0;
		cairo_t* _tmp74_ = NULL;
		GdkRGBA _tmp75_ = {0};
		cairo_t* _tmp76_ = NULL;
		_tmp36_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		layout = _tmp36_;
		_tmp37_ = item;
		_tmp38_ = _tmp37_->size;
		_tmp39_ = g_markup_escape_text (_tmp38_, (gssize) (-1));
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat ("<span size=\"small\">", _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strconcat (_tmp42_, "</span>", NULL);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		markup = _tmp44_;
		_tmp45_ = layout;
		_tmp46_ = markup;
		pango_layout_set_markup (_tmp45_, _tmp46_, -1);
		_tmp47_ = layout;
		pango_layout_set_indent (_tmp47_, 0);
		_tmp48_ = layout;
		pango_layout_set_spacing (_tmp48_, 0);
		_tmp49_ = layout;
		pango_layout_get_pixel_extents (_tmp49_, NULL, &_tmp50_);
		layout_rect = _tmp50_;
		_tmp51_ = layout_rect;
		_tmp52_ = _tmp51_.width;
		_tmp53_ = ringsitem;
		_tmp54_ = _tmp53_->max_radius;
		if (((gdouble) _tmp52_) < (2 * _tmp54_)) {
			GtkStyleContext* _tmp55_ = NULL;
			cairo_t* _tmp56_ = NULL;
			gint _tmp57_ = 0;
			PangoRectangle _tmp58_ = {0};
			gint _tmp59_ = 0;
			gint _tmp60_ = 0;
			PangoRectangle _tmp61_ = {0};
			gint _tmp62_ = 0;
			PangoLayout* _tmp63_ = NULL;
			cairo_t* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			BaobabRingschartItem* _tmp66_ = NULL;
			gdouble _tmp67_ = 0.0;
			gint _tmp68_ = 0;
			_tmp55_ = context;
			_tmp56_ = cr;
			_tmp57_ = center_x;
			_tmp58_ = layout_rect;
			_tmp59_ = _tmp58_.width;
			_tmp60_ = center_y;
			_tmp61_ = layout_rect;
			_tmp62_ = _tmp61_.height;
			_tmp63_ = layout;
			gtk_render_layout (_tmp55_, _tmp56_, (gdouble) (_tmp57_ - (_tmp59_ / 2)), (gdouble) (_tmp60_ - (_tmp62_ / 2)), _tmp63_);
			_tmp64_ = cr;
			_tmp65_ = center_x;
			_tmp66_ = ringsitem;
			_tmp67_ = _tmp66_->max_radius;
			_tmp68_ = center_y;
			cairo_move_to (_tmp64_, (_tmp65_ + _tmp67_) + 1, (gdouble) _tmp68_);
		}
		_tmp69_ = cr;
		_tmp70_ = center_x;
		_tmp71_ = center_y;
		_tmp72_ = ringsitem;
		_tmp73_ = _tmp72_->max_radius;
		cairo_arc (_tmp69_, (gdouble) _tmp70_, (gdouble) _tmp71_, _tmp73_ + 1, (gdouble) 0, 2 * G_PI);
		_tmp74_ = cr;
		_tmp75_ = border_color;
		gdk_cairo_set_source_rgba (_tmp74_, &_tmp75_);
		_tmp76_ = cr;
		cairo_stroke (_tmp76_);
		_g_free0 (markup);
		_g_object_unref0 (layout);
	} else {
		GdkRGBA fill_color = {0};
		BaobabRingschartItem* _tmp77_ = NULL;
		gdouble _tmp78_ = 0.0;
		BaobabChartItem* _tmp79_ = NULL;
		guint _tmp80_ = 0U;
		gboolean _tmp81_ = FALSE;
		GdkRGBA _tmp82_ = {0};
		cairo_t* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		gint _tmp85_ = 0;
		BaobabRingschartItem* _tmp86_ = NULL;
		gdouble _tmp87_ = 0.0;
		BaobabRingschartItem* _tmp88_ = NULL;
		gdouble _tmp89_ = 0.0;
		gdouble _tmp90_ = 0.0;
		cairo_t* _tmp91_ = NULL;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		BaobabRingschartItem* _tmp94_ = NULL;
		gdouble _tmp95_ = 0.0;
		gdouble _tmp96_ = 0.0;
		BaobabRingschartItem* _tmp97_ = NULL;
		gdouble _tmp98_ = 0.0;
		cairo_t* _tmp99_ = NULL;
		cairo_t* _tmp100_ = NULL;
		GdkRGBA _tmp101_ = {0};
		cairo_t* _tmp102_ = NULL;
		cairo_t* _tmp103_ = NULL;
		GdkRGBA _tmp104_ = {0};
		cairo_t* _tmp105_ = NULL;
		BaobabRingschartItem* _tmp106_ = NULL;
		gboolean _tmp107_ = FALSE;
		_tmp77_ = ringsitem;
		_tmp78_ = _tmp77_->start_angle;
		_tmp79_ = item;
		_tmp80_ = _tmp79_->depth;
		_tmp81_ = highlighted;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp78_ / G_PI) * 99, _tmp80_, _tmp81_, &_tmp82_);
		fill_color = _tmp82_;
		_tmp83_ = cr;
		_tmp84_ = center_x;
		_tmp85_ = center_y;
		_tmp86_ = ringsitem;
		_tmp87_ = _tmp86_->min_radius;
		_tmp88_ = ringsitem;
		_tmp89_ = _tmp88_->start_angle;
		_tmp90_ = final_angle;
		cairo_arc (_tmp83_, (gdouble) _tmp84_, (gdouble) _tmp85_, _tmp87_, _tmp89_, _tmp90_);
		_tmp91_ = cr;
		_tmp92_ = center_x;
		_tmp93_ = center_y;
		_tmp94_ = ringsitem;
		_tmp95_ = _tmp94_->max_radius;
		_tmp96_ = final_angle;
		_tmp97_ = ringsitem;
		_tmp98_ = _tmp97_->start_angle;
		cairo_arc_negative (_tmp91_, (gdouble) _tmp92_, (gdouble) _tmp93_, _tmp95_, _tmp96_, _tmp98_);
		_tmp99_ = cr;
		cairo_close_path (_tmp99_);
		_tmp100_ = cr;
		_tmp101_ = fill_color;
		gdk_cairo_set_source_rgba (_tmp100_, &_tmp101_);
		_tmp102_ = cr;
		cairo_fill_preserve (_tmp102_);
		_tmp103_ = cr;
		_tmp104_ = bg_color;
		gdk_cairo_set_source_rgba (_tmp103_, &_tmp104_);
		_tmp105_ = cr;
		cairo_stroke (_tmp105_);
		_tmp106_ = ringsitem;
		_tmp107_ = _tmp106_->continued;
		if (_tmp107_) {
			cairo_t* _tmp108_ = NULL;
			GdkRGBA _tmp109_ = {0};
			cairo_t* _tmp110_ = NULL;
			cairo_t* _tmp111_ = NULL;
			gint _tmp112_ = 0;
			gint _tmp113_ = 0;
			BaobabRingschartItem* _tmp114_ = NULL;
			gdouble _tmp115_ = 0.0;
			BaobabRingschartItem* _tmp116_ = NULL;
			gdouble _tmp117_ = 0.0;
			gdouble _tmp118_ = 0.0;
			cairo_t* _tmp119_ = NULL;
			_tmp108_ = cr;
			_tmp109_ = border_color;
			gdk_cairo_set_source_rgba (_tmp108_, &_tmp109_);
			_tmp110_ = cr;
			cairo_set_line_width (_tmp110_, (gdouble) 3);
			_tmp111_ = cr;
			_tmp112_ = center_x;
			_tmp113_ = center_y;
			_tmp114_ = ringsitem;
			_tmp115_ = _tmp114_->max_radius;
			_tmp116_ = ringsitem;
			_tmp117_ = _tmp116_->start_angle;
			_tmp118_ = final_angle;
			cairo_arc (_tmp111_, (gdouble) _tmp112_, (gdouble) _tmp113_, _tmp115_ + 4, _tmp117_ + BAOBAB_RINGSCHART_EDGE_ANGLE, _tmp118_ - BAOBAB_RINGSCHART_EDGE_ANGLE);
			_tmp119_ = cr;
			cairo_stroke (_tmp119_);
		}
	}
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	BaobabRingschartItem* _tmp2_ = NULL;
	BaobabRingschartItem* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp4_ = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp5_ = NULL;
	GtkBorder _tmp6_ = {0};
	gint max_radius = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkBorder _tmp12_ = {0};
	gint16 _tmp13_ = 0;
	guint thickness = 0U;
	gint _tmp14_ = 0;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	BaobabRingschartItem* _tmp17_ = NULL;
	GList* _tmp18_ = NULL;
	BaobabRingschartItem* _tmp65_ = NULL;
	BaobabChartItem* _tmp66_ = NULL;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = ringsitem;
	_tmp2_->continued = FALSE;
	_tmp3_ = ringsitem;
	((BaobabChartItem*) _tmp3_)->visible = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	allocation = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_get_padding (_tmp5_, GTK_STATE_FLAG_NORMAL, &_tmp6_);
	padding = _tmp6_;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = allocation;
	_tmp10_ = _tmp9_.height;
	_tmp11_ = MIN (_tmp8_ / 2, _tmp10_ / 2);
	_tmp12_ = padding;
	_tmp13_ = _tmp12_.left;
	max_radius = _tmp11_ - _tmp13_;
	_tmp14_ = max_radius;
	_tmp15_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp16_ = _tmp15_;
	thickness = _tmp14_ / (_tmp16_ + 1);
	_tmp17_ = ringsitem;
	_tmp18_ = ((BaobabChartItem*) _tmp17_)->parent;
	if (_tmp18_ == NULL) {
		BaobabRingschartItem* _tmp19_ = NULL;
		BaobabRingschartItem* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		BaobabRingschartItem* _tmp22_ = NULL;
		BaobabRingschartItem* _tmp23_ = NULL;
		_tmp19_ = ringsitem;
		_tmp19_->min_radius = (gdouble) 0;
		_tmp20_ = ringsitem;
		_tmp21_ = thickness;
		_tmp20_->max_radius = (gdouble) _tmp21_;
		_tmp22_ = ringsitem;
		_tmp22_->start_angle = (gdouble) 0;
		_tmp23_ = ringsitem;
		_tmp23_->angle = 2 * G_PI;
	} else {
		BaobabRingschartItem* parent = NULL;
		BaobabChartItem* _tmp24_ = NULL;
		GList* _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		BaobabChartItem* _tmp27_ = NULL;
		BaobabRingschartItem* _tmp28_ = NULL;
		BaobabRingschartItem* _tmp29_ = NULL;
		BaobabRingschartItem* _tmp30_ = NULL;
		guint _tmp31_ = 0U;
		guint _tmp32_ = 0U;
		BaobabRingschartItem* _tmp33_ = NULL;
		guint _tmp34_ = 0U;
		guint _tmp35_ = 0U;
		guint _tmp36_ = 0U;
		BaobabRingschartItem* _tmp41_ = NULL;
		BaobabRingschartItem* _tmp42_ = NULL;
		gdouble _tmp43_ = 0.0;
		BaobabRingschartItem* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		BaobabRingschartItem* _tmp46_ = NULL;
		gdouble _tmp47_ = 0.0;
		BaobabRingschartItem* _tmp48_ = NULL;
		BaobabRingschartItem* _tmp49_ = NULL;
		gdouble _tmp50_ = 0.0;
		BaobabRingschartItem* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		BaobabRingschartItem* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		gboolean _tmp55_ = FALSE;
		BaobabRingschartItem* _tmp56_ = NULL;
		gboolean _tmp57_ = FALSE;
		BaobabRingschartItem* _tmp62_ = NULL;
		gboolean _tmp63_ = FALSE;
		BaobabRingschartItem* _tmp64_ = NULL;
		_tmp24_ = item;
		_tmp25_ = _tmp24_->parent;
		_tmp26_ = _tmp25_->data;
		_tmp27_ = (BaobabChartItem*) _tmp26_;
		_tmp28_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp27_) : NULL);
		parent = _tmp28_;
		_tmp29_ = ringsitem;
		_tmp30_ = ringsitem;
		_tmp31_ = ((BaobabChartItem*) _tmp30_)->depth;
		_tmp32_ = thickness;
		_tmp29_->min_radius = (gdouble) (_tmp31_ * _tmp32_);
		_tmp33_ = ringsitem;
		_tmp34_ = ((BaobabChartItem*) _tmp33_)->depth;
		_tmp35_ = baobab_chart_get_max_depth ((BaobabChart*) self);
		_tmp36_ = _tmp35_;
		if (_tmp34_ > _tmp36_) {
			_baobab_chart_item_unref0 (parent);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		} else {
			BaobabRingschartItem* _tmp37_ = NULL;
			BaobabRingschartItem* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			guint _tmp40_ = 0U;
			_tmp37_ = ringsitem;
			_tmp38_ = ringsitem;
			_tmp39_ = _tmp38_->min_radius;
			_tmp40_ = thickness;
			_tmp37_->max_radius = _tmp39_ + _tmp40_;
		}
		_tmp41_ = ringsitem;
		_tmp42_ = parent;
		_tmp43_ = _tmp42_->angle;
		_tmp44_ = ringsitem;
		_tmp45_ = ((BaobabChartItem*) _tmp44_)->rel_size;
		_tmp41_->angle = (_tmp43_ * _tmp45_) / 100;
		_tmp46_ = ringsitem;
		_tmp47_ = _tmp46_->angle;
		if (_tmp47_ < BAOBAB_RINGSCHART_ITEM_MIN_ANGLE) {
			_baobab_chart_item_unref0 (parent);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		}
		_tmp48_ = ringsitem;
		_tmp49_ = parent;
		_tmp50_ = _tmp49_->start_angle;
		_tmp51_ = parent;
		_tmp52_ = _tmp51_->angle;
		_tmp53_ = ringsitem;
		_tmp54_ = ((BaobabChartItem*) _tmp53_)->rel_start;
		_tmp48_->start_angle = _tmp50_ + ((_tmp52_ * _tmp54_) / 100);
		_tmp56_ = ringsitem;
		_tmp57_ = ((BaobabChartItem*) _tmp56_)->has_any_child;
		if (_tmp57_) {
			BaobabRingschartItem* _tmp58_ = NULL;
			guint _tmp59_ = 0U;
			guint _tmp60_ = 0U;
			guint _tmp61_ = 0U;
			_tmp58_ = ringsitem;
			_tmp59_ = ((BaobabChartItem*) _tmp58_)->depth;
			_tmp60_ = baobab_chart_get_max_depth ((BaobabChart*) self);
			_tmp61_ = _tmp60_;
			_tmp55_ = _tmp59_ == _tmp61_;
		} else {
			_tmp55_ = FALSE;
		}
		_tmp62_ = ringsitem;
		_tmp63_ = _tmp55_;
		_tmp62_->continued = _tmp63_;
		_tmp64_ = parent;
		((BaobabChartItem*) _tmp64_)->has_visible_children = TRUE;
		_baobab_chart_item_unref0 (parent);
	}
	_tmp65_ = ringsitem;
	((BaobabChartItem*) _tmp65_)->visible = TRUE;
	_tmp66_ = item;
	baobab_chart_get_item_rectangle ((BaobabChart*) self, _tmp66_);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r) {
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = cx;
	_tmp1_ = angle;
	_tmp2_ = cos (_tmp1_);
	_tmp3_ = radius;
	x = _tmp0_ + (_tmp2_ * _tmp3_);
	_tmp4_ = cy;
	_tmp5_ = angle;
	_tmp6_ = sin (_tmp5_);
	_tmp7_ = radius;
	y = _tmp4_ + (_tmp6_ * _tmp7_);
	_tmp8_ = *r;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = MIN (_tmp9_, (gint) x);
	(*r).x = _tmp10_;
	_tmp11_ = *r;
	_tmp12_ = _tmp11_.y;
	_tmp13_ = MIN (_tmp12_, (gint) y);
	(*r).y = _tmp13_;
	_tmp14_ = *r;
	_tmp15_ = _tmp14_.width;
	_tmp16_ = MAX (_tmp15_, (gint) x);
	(*r).width = _tmp16_;
	_tmp17_ = *r;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp18_, (gint) y);
	(*r).height = _tmp19_;
}


static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	GdkRectangle rect = {0};
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble r1 = 0.0;
	gdouble r2 = 0.0;
	gdouble a1 = 0.0;
	gdouble a2 = 0.0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	BaobabRingschartItem* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	BaobabRingschartItem* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	BaobabRingschartItem* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	BaobabRingschartItem* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	BaobabRingschartItem* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GtkAllocation _tmp19_ = {0};
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gboolean _tmp37_ = FALSE;
	gdouble _tmp38_ = 0.0;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gdouble _tmp48_ = 0.0;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gdouble _tmp58_ = 0.0;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gdouble _tmp68_ = 0.0;
	gboolean _tmp70_ = FALSE;
	gint _tmp77_ = 0;
	GdkRectangle _tmp78_ = {0};
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	GdkRectangle _tmp81_ = {0};
	gint _tmp82_ = 0;
	BaobabRingschartItem* _tmp83_ = NULL;
	GdkRectangle _tmp84_ = {0};
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	memset (&rect, 0, sizeof (GdkRectangle));
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.width;
	cx = (gdouble) (_tmp4_ / 2);
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	cy = (gdouble) (_tmp6_ / 2);
	_tmp7_ = ringsitem;
	_tmp8_ = _tmp7_->min_radius;
	r1 = _tmp8_;
	_tmp9_ = ringsitem;
	_tmp10_ = _tmp9_->max_radius;
	r2 = _tmp10_;
	_tmp11_ = ringsitem;
	_tmp12_ = _tmp11_->start_angle;
	a1 = _tmp12_;
	_tmp13_ = ringsitem;
	_tmp14_ = _tmp13_->start_angle;
	_tmp15_ = ringsitem;
	_tmp16_ = _tmp15_->angle;
	a2 = _tmp14_ + _tmp16_;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.width;
	rect.x = _tmp18_;
	_tmp19_ = allocation;
	_tmp20_ = _tmp19_.height;
	rect.y = _tmp20_;
	rect.width = 0;
	rect.height = 0;
	_tmp21_ = cx;
	_tmp22_ = cy;
	_tmp23_ = r1;
	_tmp24_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp21_, _tmp22_, _tmp23_, _tmp24_, &rect);
	_tmp25_ = cx;
	_tmp26_ = cy;
	_tmp27_ = r2;
	_tmp28_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, &rect);
	_tmp29_ = cx;
	_tmp30_ = cy;
	_tmp31_ = r1;
	_tmp32_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp29_, _tmp30_, _tmp31_, _tmp32_, &rect);
	_tmp33_ = cx;
	_tmp34_ = cy;
	_tmp35_ = r2;
	_tmp36_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, &rect);
	_tmp38_ = a1;
	if (_tmp38_ <= (G_PI / 2)) {
		gdouble _tmp39_ = 0.0;
		_tmp39_ = a2;
		_tmp37_ = _tmp39_ >= (G_PI / 2);
	} else {
		_tmp37_ = FALSE;
	}
	_tmp40_ = _tmp37_;
	if (_tmp40_) {
		GdkRectangle _tmp41_ = {0};
		gint _tmp42_ = 0;
		gdouble _tmp43_ = 0.0;
		gdouble _tmp44_ = 0.0;
		gdouble _tmp45_ = 0.0;
		gdouble _tmp46_ = 0.0;
		_tmp41_ = rect;
		_tmp42_ = _tmp41_.height;
		_tmp43_ = cy;
		_tmp44_ = sin (G_PI / 2);
		_tmp45_ = r2;
		_tmp46_ = MAX ((gdouble) _tmp42_, _tmp43_ + (_tmp44_ * _tmp45_));
		rect.height = (gint) _tmp46_;
	}
	_tmp48_ = a1;
	if (_tmp48_ <= G_PI) {
		gdouble _tmp49_ = 0.0;
		_tmp49_ = a2;
		_tmp47_ = _tmp49_ >= G_PI;
	} else {
		_tmp47_ = FALSE;
	}
	_tmp50_ = _tmp47_;
	if (_tmp50_) {
		GdkRectangle _tmp51_ = {0};
		gint _tmp52_ = 0;
		gdouble _tmp53_ = 0.0;
		gdouble _tmp54_ = 0.0;
		gdouble _tmp55_ = 0.0;
		gdouble _tmp56_ = 0.0;
		_tmp51_ = rect;
		_tmp52_ = _tmp51_.x;
		_tmp53_ = cx;
		_tmp54_ = cos (G_PI);
		_tmp55_ = r2;
		_tmp56_ = MIN ((gdouble) _tmp52_, _tmp53_ + (_tmp54_ * _tmp55_));
		rect.x = (gint) _tmp56_;
	}
	_tmp58_ = a1;
	if (_tmp58_ <= (G_PI * 1.5)) {
		gdouble _tmp59_ = 0.0;
		_tmp59_ = a2;
		_tmp57_ = _tmp59_ >= (G_PI * 1.5);
	} else {
		_tmp57_ = FALSE;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		GdkRectangle _tmp61_ = {0};
		gint _tmp62_ = 0;
		gdouble _tmp63_ = 0.0;
		gdouble _tmp64_ = 0.0;
		gdouble _tmp65_ = 0.0;
		gdouble _tmp66_ = 0.0;
		_tmp61_ = rect;
		_tmp62_ = _tmp61_.y;
		_tmp63_ = cy;
		_tmp64_ = sin (G_PI * 1.5);
		_tmp65_ = r2;
		_tmp66_ = MIN ((gdouble) _tmp62_, _tmp63_ + (_tmp64_ * _tmp65_));
		rect.y = (gint) _tmp66_;
	}
	_tmp68_ = a1;
	if (_tmp68_ <= (G_PI * 2)) {
		gdouble _tmp69_ = 0.0;
		_tmp69_ = a2;
		_tmp67_ = _tmp69_ >= (G_PI * 2);
	} else {
		_tmp67_ = FALSE;
	}
	_tmp70_ = _tmp67_;
	if (_tmp70_) {
		GdkRectangle _tmp71_ = {0};
		gint _tmp72_ = 0;
		gdouble _tmp73_ = 0.0;
		gdouble _tmp74_ = 0.0;
		gdouble _tmp75_ = 0.0;
		gdouble _tmp76_ = 0.0;
		_tmp71_ = rect;
		_tmp72_ = _tmp71_.width;
		_tmp73_ = cx;
		_tmp74_ = cos (G_PI * 2);
		_tmp75_ = r2;
		_tmp76_ = MAX ((gdouble) _tmp72_, _tmp73_ + (_tmp74_ * _tmp75_));
		rect.width = (gint) _tmp76_;
	}
	_tmp77_ = rect.width;
	_tmp78_ = rect;
	_tmp79_ = _tmp78_.x;
	rect.width = _tmp77_ - _tmp79_;
	_tmp80_ = rect.height;
	_tmp81_ = rect;
	_tmp82_ = _tmp81_.y;
	rect.height = _tmp80_ - _tmp82_;
	_tmp83_ = ringsitem;
	_tmp84_ = rect;
	((BaobabChartItem*) _tmp83_)->rect = _tmp84_;
	_baobab_chart_item_unref0 (ringsitem);
}


static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabRingschartItem* _tmp1_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble _tmp6_ = 0.0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble radius = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble angle = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp21_ = 0.0;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gdouble _tmp25_ = 0.0;
	BaobabRingschartItem* _tmp26_ = NULL;
	gdouble _tmp27_ = 0.0;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp41_ = FALSE;
	self = (BaobabRingschart*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = x;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.width;
	x = _tmp3_ - (_tmp5_ / 2);
	_tmp6_ = y;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.height;
	y = _tmp6_ - (_tmp8_ / 2);
	_tmp9_ = x;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = y;
	_tmp13_ = sqrt ((_tmp9_ * _tmp10_) + (_tmp11_ * _tmp12_));
	radius = _tmp13_;
	_tmp14_ = y;
	_tmp15_ = x;
	_tmp16_ = atan2 (_tmp14_, _tmp15_);
	angle = _tmp16_;
	_tmp18_ = angle;
	if (_tmp18_ > ((gdouble) 0)) {
		gdouble _tmp19_ = 0.0;
		_tmp19_ = angle;
		_tmp17_ = _tmp19_;
	} else {
		gdouble _tmp20_ = 0.0;
		_tmp20_ = angle;
		_tmp17_ = _tmp20_ + (2 * G_PI);
	}
	_tmp21_ = _tmp17_;
	angle = _tmp21_;
	_tmp25_ = radius;
	_tmp26_ = ringsitem;
	_tmp27_ = _tmp26_->min_radius;
	if (_tmp25_ >= _tmp27_) {
		gdouble _tmp28_ = 0.0;
		BaobabRingschartItem* _tmp29_ = NULL;
		gdouble _tmp30_ = 0.0;
		_tmp28_ = radius;
		_tmp29_ = ringsitem;
		_tmp30_ = _tmp29_->max_radius;
		_tmp24_ = _tmp28_ <= _tmp30_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp31_ = _tmp24_;
	if (_tmp31_) {
		gdouble _tmp32_ = 0.0;
		BaobabRingschartItem* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		_tmp32_ = angle;
		_tmp33_ = ringsitem;
		_tmp34_ = _tmp33_->start_angle;
		_tmp23_ = _tmp32_ >= _tmp34_;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp35_ = _tmp23_;
	if (_tmp35_) {
		gdouble _tmp36_ = 0.0;
		BaobabRingschartItem* _tmp37_ = NULL;
		gdouble _tmp38_ = 0.0;
		BaobabRingschartItem* _tmp39_ = NULL;
		gdouble _tmp40_ = 0.0;
		_tmp36_ = angle;
		_tmp37_ = ringsitem;
		_tmp38_ = _tmp37_->start_angle;
		_tmp39_ = ringsitem;
		_tmp40_ = _tmp39_->angle;
		_tmp22_ = _tmp36_ <= (_tmp38_ + _tmp40_);
	} else {
		_tmp22_ = FALSE;
	}
	_tmp41_ = _tmp22_;
	result = _tmp41_;
	_baobab_chart_item_unref0 (ringsitem);
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ < BAOBAB_CHART_MAX_DEPTH;
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > BAOBAB_CHART_MIN_DEPTH;
	return result;
}


BaobabRingschart* baobab_ringschart_construct (GType object_type) {
	BaobabRingschart * self = NULL;
	self = (BaobabRingschart*) baobab_chart_construct (object_type);
	return self;
}


BaobabRingschart* baobab_ringschart_new (void) {
	return baobab_ringschart_construct (BAOBAB_TYPE_RINGSCHART);
}


static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	baobab_ringschart_subtips_update (self);
}


static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabRingschart * self;
	parent_class = G_OBJECT_CLASS (baobab_ringschart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	g_signal_connect_object ((GObject*) self, "notify::max-depth", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::highlighted-item", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::root", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	return obj;
}


static void baobab_ringschart_class_init (BaobabRingschartClass * klass) {
	baobab_ringschart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabRingschartPrivate));
	BAOBAB_CHART_CLASS (klass)->create_new_chartitem = baobab_ringschart_real_create_new_chartitem;
	BAOBAB_CHART_CLASS (klass)->post_draw = baobab_ringschart_real_post_draw;
	BAOBAB_CHART_CLASS (klass)->draw_item = baobab_ringschart_real_draw_item;
	BAOBAB_CHART_CLASS (klass)->calculate_item_geometry = baobab_ringschart_real_calculate_item_geometry;
	BAOBAB_CHART_CLASS (klass)->get_item_rectangle = baobab_ringschart_real_get_item_rectangle;
	BAOBAB_CHART_CLASS (klass)->is_point_over_item = baobab_ringschart_real_is_point_over_item;
	BAOBAB_CHART_CLASS (klass)->can_zoom_out = baobab_ringschart_real_can_zoom_out;
	BAOBAB_CHART_CLASS (klass)->can_zoom_in = baobab_ringschart_real_can_zoom_in;
	G_OBJECT_CLASS (klass)->constructor = baobab_ringschart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_ringschart_finalize;
}


static void baobab_ringschart_instance_init (BaobabRingschart * self) {
	self->priv = BAOBAB_RINGSCHART_GET_PRIVATE (self);
	self->priv->tips_timeout_id = (guint) 0;
	self->priv->drawing_subtips = FALSE;
}


static void baobab_ringschart_finalize (GObject* obj) {
	BaobabRingschart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	G_OBJECT_CLASS (baobab_ringschart_parent_class)->finalize (obj);
}


GType baobab_ringschart_get_type (void) {
	static volatile gsize baobab_ringschart_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschart), 0, (GInstanceInitFunc) baobab_ringschart_instance_init, NULL };
		GType baobab_ringschart_type_id;
		baobab_ringschart_type_id = g_type_register_static (BAOBAB_TYPE_CHART, "BaobabRingschart", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_type_id__volatile, baobab_ringschart_type_id);
	}
	return baobab_ringschart_type_id__volatile;
}



