/* future.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from future.vala, do not modify */

/* future.vala
 *
 * Copyright (C) 2013  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>


#define GEE_TYPE_FUTURE (gee_future_get_type ())
#define GEE_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_FUTURE, GeeFuture))
#define GEE_IS_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_FUTURE))
#define GEE_FUTURE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_FUTURE, GeeFutureIface))

typedef struct _GeeFuture GeeFuture;
typedef struct _GeeFutureIface GeeFutureIface;

#define GEE_TYPE_PROMISE (gee_promise_get_type ())
#define GEE_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_PROMISE, GeePromise))
#define GEE_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_PROMISE, GeePromiseClass))
#define GEE_IS_PROMISE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_PROMISE))
#define GEE_IS_PROMISE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_PROMISE))
#define GEE_PROMISE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_PROMISE, GeePromiseClass))

typedef struct _GeePromise GeePromise;
typedef struct _GeePromiseClass GeePromiseClass;
typedef struct _Block5Data Block5Data;
#define _gee_promise_unref0(var) ((var == NULL) ? NULL : (var = (gee_promise_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEE_TYPE_LIGHT_MAP_FUTURE (gee_light_map_future_get_type ())
#define GEE_LIGHT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFuture))
#define GEE_LIGHT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFutureClass))
#define GEE_IS_LIGHT_MAP_FUTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIGHT_MAP_FUTURE))
#define GEE_IS_LIGHT_MAP_FUTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LIGHT_MAP_FUTURE))
#define GEE_LIGHT_MAP_FUTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LIGHT_MAP_FUTURE, GeeLightMapFutureClass))

typedef struct _GeeLightMapFuture GeeLightMapFuture;
typedef struct _GeeLightMapFutureClass GeeLightMapFutureClass;
typedef struct _Block6Data Block6Data;
typedef struct _GeeFutureDoZipData GeeFutureDoZipData;
typedef struct _Block7Data Block7Data;
typedef struct _GeeFutureDoFlatMapData GeeFutureDoFlatMapData;

#define GEE_FUTURE_TYPE_SOURCE_FUNC_ARRAY_ELEMENT (gee_future_source_func_array_element_get_type ())
typedef struct _GeeFutureSourceFuncArrayElement GeeFutureSourceFuncArrayElement;

typedef enum  {
	GEE_FUTURE_ERROR_ABANDON_PROMISE,
	GEE_FUTURE_ERROR_EXCEPTION
} GeeFutureError;
#define GEE_FUTURE_ERROR gee_future_error_quark ()
typedef gpointer (*GeeFutureMapFunc) (gconstpointer value, void* user_data);
typedef gconstpointer (*GeeFutureLightMapFunc) (gconstpointer value, void* user_data);
typedef gpointer (*GeeFutureZipFunc) (gconstpointer a, gconstpointer b, void* user_data);
typedef GeeFuture* (*GeeFutureFlatMapFunc) (gconstpointer value, void* user_data);
struct _GeeFutureIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeFuture* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeFuture* self);
	GDestroyNotify (*get_g_destroy_func) (GeeFuture* self);
	gconstpointer (*wait) (GeeFuture* self, GError** error);
	gboolean (*wait_until) (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error);
	void (*wait_async) (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gconstpointer (*wait_finish) (GeeFuture* self, GAsyncResult* _res_, GError** error);
	GeeFuture* (*map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
	GeeFuture* (*light_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
	GeeFuture* (*zip) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
	GeeFuture* (*flat_map) (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
	gconstpointer (*get_value) (GeeFuture* self);
	gboolean (*get_ready) (GeeFuture* self);
	GError* (*get_exception) (GeeFuture* self);
};

struct _Block5Data {
	int _ref_count_;
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeePromise* promise;
	GeeFutureMapFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _Block6Data {
	int _ref_count_;
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
};

struct _GeeFutureDoZipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GeeFutureZipFunc zip_func;
	gpointer zip_func_target;
	GDestroyNotify zip_func_target_destroy_notify;
	GeeFuture* first;
	GeeFuture* second;
	GeePromise* _result_;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	GType c_type;
	GBoxedCopyFunc c_dup_func;
	GDestroyNotify c_destroy_func;
	gpointer left;
	GeeFuture* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer right;
	GeeFuture* _tmp3_;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	GeePromise* _tmp6_;
	GeeFutureZipFunc _tmp7_;
	void* _tmp7__target;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	gpointer _tmp10_;
	GError* ex;
	GeePromise* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _Block7Data {
	int _ref_count_;
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
};

struct _GeeFutureDoFlatMapData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GeeFutureFlatMapFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	GeeFuture* future;
	GeePromise* promise;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	gpointer input;
	GeeFuture* _tmp0_;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	gpointer output;
	GeeFutureFlatMapFunc _tmp3_;
	void* _tmp3__target;
	gconstpointer _tmp4_;
	GeeFuture* _tmp5_;
	GeeFuture* _tmp6_;
	gconstpointer _tmp7_;
	gpointer _tmp8_;
	gpointer _tmp9_;
	GeePromise* _tmp10_;
	gpointer _tmp11_;
	GError* ex;
	GeePromise* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_;
};

struct _GeeFutureSourceFuncArrayElement {
	GSourceFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};



GQuark gee_future_error_quark (void);
GType gee_future_get_type (void) G_GNUC_CONST;
gconstpointer gee_future_wait (GeeFuture* self, GError** error);
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error);
void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_, GError** error);
GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
gpointer gee_promise_ref (gpointer instance);
void gee_promise_unref (gpointer instance);
GParamSpec* gee_param_spec_promise (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_promise (GValue* value, gpointer v_object);
void gee_value_take_promise (GValue* value, gpointer v_object);
gpointer gee_value_get_promise (const GValue* value);
GType gee_promise_get_type (void) G_GNUC_CONST;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GeePromise* gee_promise_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeePromise* gee_promise_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void __lambda2_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
void gee_promise_set_value (GeePromise* self, gpointer value);
void gee_promise_set_exception (GeePromise* self, GError* exception);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GeeFuture* gee_promise_get_future (GeePromise* self);
GeeFuture* gee_future_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
static GeeFuture* gee_future_real_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target);
GeeLightMapFuture* gee_light_map_future_new (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureLightMapFunc func, void* func_target);
GeeLightMapFuture* gee_light_map_future_construct (GType object_type, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeFuture* base_future, GeeFutureLightMapFunc func, void* func_target);
GType gee_light_map_future_get_type (void) G_GNUC_CONST;
GeeFuture* gee_future_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
static GeeFuture* gee_future_real_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void gee_future_do_zip (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GType c_type, GBoxedCopyFunc c_dup_func, GDestroyNotify c_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* first, GeeFuture* second, GeePromise* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gee_future_do_zip_finish (GAsyncResult* _res_);
static void __lambda3_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gee_future_do_zip_data_free (gpointer _data);
static gboolean gee_future_do_zip_co (GeeFutureDoZipData* _data_);
static void gee_future_do_zip_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeFuture* gee_future_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeFuture* gee_future_real_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void gee_future_do_flat_map (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeFuture* future, GeePromise* promise, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void gee_future_do_flat_map_finish (GAsyncResult* _res_);
static void __lambda4_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void gee_future_do_flat_map_data_free (gpointer _data);
static gboolean gee_future_do_flat_map_co (GeeFutureDoFlatMapData* _data_);
static void gee_future_do_flat_map_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gconstpointer gee_future_get_value (GeeFuture* self);
gboolean gee_future_get_ready (GeeFuture* self);
GError* gee_future_get_exception (GeeFuture* self);
GType gee_future_source_func_array_element_get_type (void) G_GNUC_CONST;
GeeFutureSourceFuncArrayElement* gee_future_source_func_array_element_dup (const GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_free (GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_copy (const GeeFutureSourceFuncArrayElement* self, GeeFutureSourceFuncArrayElement* dest);
void gee_future_source_func_array_element_destroy (GeeFutureSourceFuncArrayElement* self);
void gee_future_source_func_array_element_init (GeeFutureSourceFuncArrayElement *self, GSourceFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);


/**
 * Waits until the value is ready.
 *
 * @returns The {@link value} associated with future
 * @see ready
 * @see wait_until
 * @see wait_async
 */
gconstpointer gee_future_wait (GeeFuture* self, GError** error) {
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->wait (self, error);
#line 290 "future.c"
}


/**
 * Waits until the value is ready or deadline have passed.
 *
 * @param end_time The time when the wait should finish
 * @param value The {@link value} associated with future if the wait was successful
 * @returns ``true`` if the value was ready within deadline or ``false`` otherwise
 * @see ready
 * @see wait
 * @see wait_async
 */
gboolean gee_future_wait_until (GeeFuture* self, gint64 end_time, gconstpointer* value, GError** error) {
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 97 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->wait_until (self, end_time, value, error);
#line 309 "future.c"
}


void gee_future_wait_async (GeeFuture* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	GEE_FUTURE_GET_INTERFACE (self)->wait_async (self, _callback_, _user_data_);
#line 316 "future.c"
}


gconstpointer gee_future_wait_finish (GeeFuture* self, GAsyncResult* _res_, GError** error) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->wait_finish (self, _res_, error);
#line 323 "future.c"
}


/**
 * Maps a future value to another value by a function and returns the
 * another value in future.
 *
 * @param func Function applied to {@link value}
 * @returns Value returned by function
 *
 * @see flat_map
 * @see light_map
 *
 * Note: As time taken by function might not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to use
 *   {@link task} and {@link flat_map} for longer computation.
 */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return _data5_;
#line 347 "future.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 356 "future.c"
		GeeFuture * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		self = _data5_->self;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_type = _data5_->a_type;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_dup_func = _data5_->a_dup_func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_destroy_func = _data5_->a_destroy_func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_gee_promise_unref0 (_data5_->promise);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		(_data5_->func_target_destroy_notify == NULL) ? NULL : (_data5_->func_target_destroy_notify (_data5_->func_target), NULL);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data5_->func = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data5_->func_target = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data5_->func_target_destroy_notify = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_object_unref0 (self);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_slice_free (Block5Data, _data5_);
#line 383 "future.c"
	}
}


static void __lambda2_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GError * _inner_error_ = NULL;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	self = _data5_->self;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_type = _data5_->a_type;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_dup_func = _data5_->a_dup_func;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_destroy_func = _data5_->a_destroy_func;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_if_fail (res != NULL);
#line 404 "future.c"
	{
		gconstpointer _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gconstpointer _tmp2_ = NULL;
		GeeFutureMapFunc _tmp3_ = NULL;
		void* _tmp3__target = NULL;
		gpointer _tmp4_ = NULL;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp1_ = res;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp2_ = gee_future_wait_finish (self, _tmp1_, &_inner_error_);
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp0_ = _tmp2_;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_inner_error_ != NULL) {
#line 420 "future.c"
			goto __catch0_g_error;
		}
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp3_ = _data5_->func;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp3__target = _data5_->func_target;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp4_ = _tmp3_ (_tmp0_, _tmp3__target);
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_value (_data5_->promise, _tmp4_);
#line 431 "future.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* ex = NULL;
		GError* _tmp5_ = NULL;
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		ex = _inner_error_;
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_inner_error_ = NULL;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp5_ = ex;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		ex = NULL;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_exception (_data5_->promise, _tmp5_);
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_error_free0 (ex);
#line 450 "future.c"
	}
	__finally0:
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (_inner_error_ != NULL) {
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_clear_error (&_inner_error_);
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return;
#line 461 "future.c"
	}
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	__lambda2_ (self, source_object, res);
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block5_data_unref (self);
#line 471 "future.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return self ? g_object_ref (self) : NULL;
#line 478 "future.c"
}


static GeeFuture* gee_future_real_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GeeFuture* result = NULL;
	Block5Data* _data5_;
	GeeFutureMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeePromise* _tmp1_ = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->_ref_count_ = 1;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->self = g_object_ref (self);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->a_type = a_type;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->a_dup_func = a_dup_func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->a_destroy_func = a_destroy_func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = func;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0__target = func_target;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(_data5_->func_target_destroy_notify == NULL) ? NULL : (_data5_->func_target_destroy_notify (_data5_->func_target), NULL);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func_target = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func_target_destroy_notify = NULL;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func = _tmp0_;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func_target = _tmp0__target;
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->func_target_destroy_notify = func_target_destroy_notify;
#line 126 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = gee_promise_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func);
#line 126 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_->promise = _tmp1_;
#line 127 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_wait_async (self, ___lambda2__gasync_ready_callback, block5_data_ref (_data5_));
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp2_ = gee_promise_get_future (_data5_->promise);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp3_ = _tmp2_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	result = _tmp4_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block5_data_unref (_data5_);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data5_ = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return result;
#line 541 "future.c"
}


GeeFuture* gee_future_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, func, func_target, func_target_destroy_notify);
#line 550 "future.c"
}


/**
 * Maps a future value to another value by a function and returns the
 * another value in future.
 *
 * @param func Function applied to {@link value}
 * @returns Value returned by function
 *
 * @see flat_map
 * @see map
 * @since 0.11.4
 *
 * Note: The function may be reevaluated at any time and it might
 *   be called lazily. Therefore it is recommended for it to be
 *   idempotent. If the function needs to be called eagerly or have
 *   side-effects it is recommended to use {@link map}.
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to use
 *   {@link task} and {@link flat_map} for longer computation.
 */
static GeeFuture* gee_future_real_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target) {
	GeeFuture* result = NULL;
	GeeFutureLightMapFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeLightMapFuture* _tmp1_ = NULL;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = func;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0__target = func_target;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = gee_light_map_future_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), self, _tmp0_, _tmp0__target);
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	result = (GeeFuture*) _tmp1_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return result;
#line 590 "future.c"
}


GeeFuture* gee_future_light_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureLightMapFunc func, void* func_target) {
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->light_map (self, a_type, a_dup_func, a_destroy_func, func, func_target);
#line 599 "future.c"
}


/**
 * Combines values of two futures using a function returning the combined
 * value in future (call does not block).
 *
 * @param join_func Function applied to values
 * @param second Second parameter
 * @returns A combine value
 * @since 0.11.4
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to return a
 *   future from {@link task} and use {@link flat_map} for longer computation.
 */
static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return _data6_;
#line 622 "future.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 631 "future.c"
		GeeFuture * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		GType b_type;
		GBoxedCopyFunc b_dup_func;
		GDestroyNotify b_destroy_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		self = _data6_->self;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_type = _data6_->a_type;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_dup_func = _data6_->a_dup_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_destroy_func = _data6_->a_destroy_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		b_type = _data6_->b_type;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		b_dup_func = _data6_->b_dup_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		b_destroy_func = _data6_->b_destroy_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_object_unref0 (self);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_slice_free (Block6Data, _data6_);
#line 657 "future.c"
	}
}


static void __lambda3_ (Block6Data* _data6_, GObject* obj, GAsyncResult* res) {
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GType b_type;
	GBoxedCopyFunc b_dup_func;
	GDestroyNotify b_destroy_func;
	GAsyncResult* _tmp0_ = NULL;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	self = _data6_->self;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_type = _data6_->a_type;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_dup_func = _data6_->a_dup_func;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_destroy_func = _data6_->a_destroy_func;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	b_type = _data6_->b_type;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	b_dup_func = _data6_->b_dup_func;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	b_destroy_func = _data6_->b_destroy_func;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_if_fail (res != NULL);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = res;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_zip_finish (_tmp0_);
#line 691 "future.c"
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	__lambda3_ (self, source_object, res);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block6_data_unref (self);
#line 700 "future.c"
}


static GeeFuture* gee_future_real_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second) {
	GeeFuture* result = NULL;
	Block6Data* _data6_;
	GeePromise* promise = NULL;
	GeePromise* _tmp0_ = NULL;
	GeeFutureZipFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
	GeeFuture* _tmp5_ = NULL;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (second != NULL, NULL);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->_ref_count_ = 1;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->self = g_object_ref (self);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->a_type = a_type;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->a_dup_func = a_dup_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->a_destroy_func = a_destroy_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->b_type = b_type;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->b_dup_func = b_dup_func;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_->b_destroy_func = b_destroy_func;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = gee_promise_new (b_type, (GBoxedCopyFunc) b_dup_func, b_destroy_func);
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	promise = _tmp0_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = zip_func;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1__target = zip_func_target;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1__target_destroy_notify = NULL;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp2_ = second;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_zip (GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, b_type, (GBoxedCopyFunc) b_dup_func, b_destroy_func, _tmp1_, _tmp1__target, self, _tmp2_, promise, ___lambda3__gasync_ready_callback, block6_data_ref (_data6_));
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp3_ = gee_promise_get_future (promise);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp4_ = _tmp3_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	result = _tmp5_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (promise);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block6_data_unref (_data6_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data6_ = NULL;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return result;
#line 766 "future.c"
}


GeeFuture* gee_future_zip (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* second) {
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->zip (self, a_type, a_dup_func, a_destroy_func, b_type, b_dup_func, b_destroy_func, zip_func, zip_func_target, second);
#line 775 "future.c"
}


static void gee_future_do_zip_data_free (gpointer _data) {
	GeeFutureDoZipData* _data_;
	_data_ = _data;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->first);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->second);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (_data_->_result_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_slice_free (GeeFutureDoZipData, _data_);
#line 790 "future.c"
}


static gpointer _gee_promise_ref0 (gpointer self) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return self ? gee_promise_ref (self) : NULL;
#line 797 "future.c"
}


static void gee_future_do_zip (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GType c_type, GBoxedCopyFunc c_dup_func, GDestroyNotify c_destroy_func, GeeFutureZipFunc zip_func, void* zip_func_target, GeeFuture* first, GeeFuture* second, GeePromise* _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GeeFutureDoZipData* _data_;
	GeeFuture* _tmp0_ = NULL;
	GeeFuture* _tmp1_ = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeePromise* _tmp4_ = NULL;
	GeePromise* _tmp5_ = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = g_slice_new0 (GeeFutureDoZipData);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gee_future_do_zip);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gee_future_do_zip_data_free);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->zip_func = zip_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->zip_func_target = zip_func_target;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = first;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->first);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->first = _tmp1_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp2_ = second;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->second);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->second = _tmp3_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp4_ = _result_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp5_ = _gee_promise_ref0 (_tmp4_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (_data_->_result_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_result_ = _tmp5_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_type = a_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_dup_func = a_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_destroy_func = a_destroy_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_type = b_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_dup_func = b_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_destroy_func = b_destroy_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->c_type = c_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->c_dup_func = c_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->c_destroy_func = c_destroy_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_zip_co (_data_);
#line 863 "future.c"
}


static void gee_future_do_zip_finish (GAsyncResult* _res_) {
	GeeFutureDoZipData* _data_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 871 "future.c"
}


static void gee_future_do_zip_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GeeFutureDoZipData* _data_;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = _user_data_;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_source_object_ = source_object;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_res_ = _res_;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_zip_co (_data_);
#line 885 "future.c"
}


static gboolean gee_future_do_zip_co (GeeFutureDoZipData* _data_) {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	switch (_data_->_state_) {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 0:
#line 894 "future.c"
		goto _state_0;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 1:
#line 898 "future.c"
		goto _state_1;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 2:
#line 902 "future.c"
		goto _state_2;
		default:
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_assert_not_reached ();
#line 907 "future.c"
	}
	_state_0:
	{
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp0_ = NULL;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp0_ = _data_->first;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_state_ = 1;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_future_wait_async (_data_->_tmp0_, gee_future_do_zip_ready, _data_);
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 921 "future.c"
		_state_1:
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp1_ = NULL;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp1_ = gee_future_wait_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp2_ = NULL;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp2_ = ((_data_->_tmp1_ != NULL) && (_data_->a_dup_func != NULL)) ? _data_->a_dup_func ((gpointer) _data_->_tmp1_) : ((gpointer) _data_->_tmp1_);
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->left = _data_->_tmp2_;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_data_->_inner_error_ != NULL) {
#line 935 "future.c"
			goto __catch1_g_error;
		}
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3_ = NULL;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3_ = _data_->second;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_state_ = 2;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_future_wait_async (_data_->_tmp3_, gee_future_do_zip_ready, _data_);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 948 "future.c"
		_state_2:
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp4_ = NULL;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp4_ = gee_future_wait_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp5_ = NULL;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp5_ = ((_data_->_tmp4_ != NULL) && (_data_->b_dup_func != NULL)) ? _data_->b_dup_func ((gpointer) _data_->_tmp4_) : ((gpointer) _data_->_tmp4_);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->right = _data_->_tmp5_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_data_->_inner_error_ != NULL) {
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			((_data_->left == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->left = (_data_->a_destroy_func (_data_->left), NULL));
#line 964 "future.c"
			goto __catch1_g_error;
		}
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp6_ = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp6_ = _data_->_result_;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7_ = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7__target = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7_ = _data_->zip_func;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7__target = _data_->zip_func_target;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp8_ = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp8_ = _data_->left;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp9_ = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp9_ = _data_->right;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp10_ = NULL;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp10_ = _data_->_tmp7_ (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp7__target);
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_value (_data_->_tmp6_, _data_->_tmp10_);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		((_data_->right == NULL) || (_data_->b_destroy_func == NULL)) ? NULL : (_data_->right = (_data_->b_destroy_func (_data_->right), NULL));
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		((_data_->left == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->left = (_data_->a_destroy_func (_data_->left), NULL));
#line 997 "future.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->ex = _data_->_inner_error_;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_inner_error_ = NULL;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp11_ = NULL;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp11_ = _data_->_result_;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp12_ = NULL;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp12_ = _data_->ex;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->ex = NULL;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_exception (_data_->_tmp11_, _data_->_tmp12_);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_error_free0 (_data_->ex);
#line 1020 "future.c"
	}
	__finally1:
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (_data_->_inner_error_ != NULL) {
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_clear_error (&_data_->_inner_error_);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 1031 "future.c"
	}
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (_data_->_state_ == 0) {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1037 "future.c"
	} else {
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1041 "future.c"
	}
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_object_unref (_data_->_async_result);
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return FALSE;
#line 1047 "future.c"
}


/**
 * Maps a future value to another future value which is returned (call does not block).
 *
 * @param func Function applied to {@link value}
 * @returns Value of a future returned by function
 *
 * @see map
 *
 * Note: As time taken by function does not contribute to
 *   {@link wait_until} and the implementation is allowed to compute
 *   value eagerly by {@link when_done} it is recommended to put the
 *   larger computation inside the returned future for example by
 *   {@link task}
 */
static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return _data7_;
#line 1070 "future.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1079 "future.c"
		GeeFuture * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		self = _data7_->self;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_type = _data7_->a_type;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_dup_func = _data7_->a_dup_func;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		a_destroy_func = _data7_->a_destroy_func;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_object_unref0 (self);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_slice_free (Block7Data, _data7_);
#line 1096 "future.c"
	}
}


static void __lambda4_ (Block7Data* _data7_, GObject* obj, GAsyncResult* res) {
	GeeFuture * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GAsyncResult* _tmp0_ = NULL;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	self = _data7_->self;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_type = _data7_->a_type;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_dup_func = _data7_->a_dup_func;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_if_fail (res != NULL);
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = res;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_flat_map_finish (_tmp0_);
#line 1121 "future.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	__lambda4_ (self, source_object, res);
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block7_data_unref (self);
#line 1130 "future.c"
}


static GeeFuture* gee_future_real_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GeeFuture* result = NULL;
	Block7Data* _data7_;
	GeePromise* promise = NULL;
	GeePromise* _tmp0_ = NULL;
	GeeFutureFlatMapFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	GDestroyNotify _tmp1__target_destroy_notify = NULL;
	GeeFuture* _tmp2_ = NULL;
	GeeFuture* _tmp3_ = NULL;
	GeeFuture* _tmp4_ = NULL;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_->_ref_count_ = 1;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_->self = g_object_ref (self);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_->a_type = a_type;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_->a_dup_func = a_dup_func;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_->a_destroy_func = a_destroy_func;
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = gee_promise_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func);
#line 214 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	promise = _tmp0_;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = func;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1__target = func_target;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1__target_destroy_notify = func_target_destroy_notify;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target_destroy_notify = NULL;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_flat_map (GEE_FUTURE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_FUTURE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_FUTURE_GET_INTERFACE (self)->get_g_destroy_func (self), a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify, self, promise, ___lambda4__gasync_ready_callback, block7_data_ref (_data7_));
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp2_ = gee_promise_get_future (promise);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp3_ = _tmp2_;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	result = _tmp4_;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (promise);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	block7_data_unref (_data7_);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data7_ = NULL;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func = NULL;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target = NULL;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target_destroy_notify = NULL;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return result;
#line 1195 "future.c"
}


GeeFuture* gee_future_flat_map (GeeFuture* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->flat_map (self, a_type, a_dup_func, a_destroy_func, func, func_target, func_target_destroy_notify);
#line 1204 "future.c"
}


static void gee_future_do_flat_map_data_free (gpointer _data) {
	GeeFutureDoFlatMapData* _data_;
	_data_ = _data;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target_destroy_notify = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->future);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (_data_->promise);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_slice_free (GeeFutureDoFlatMapData, _data_);
#line 1225 "future.c"
}


static void gee_future_do_flat_map (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GType b_type, GBoxedCopyFunc b_dup_func, GDestroyNotify b_destroy_func, GeeFutureFlatMapFunc func, void* func_target, GDestroyNotify func_target_destroy_notify, GeeFuture* future, GeePromise* promise, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GeeFutureDoFlatMapData* _data_;
	GeeFuture* _tmp0_ = NULL;
	GeeFuture* _tmp1_ = NULL;
	GeePromise* _tmp2_ = NULL;
	GeePromise* _tmp3_ = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = g_slice_new0 (GeeFutureDoFlatMapData);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, gee_future_do_flat_map);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gee_future_do_flat_map_data_free);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target_destroy_notify = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func = func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target = func_target;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target_destroy_notify = func_target_destroy_notify;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = future;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_g_object_unref0 (_data_->future);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->future = _tmp1_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp2_ = promise;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp3_ = _gee_promise_ref0 (_tmp2_);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_gee_promise_unref0 (_data_->promise);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->promise = _tmp3_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_type = a_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_dup_func = a_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->a_destroy_func = a_destroy_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_type = b_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_dup_func = b_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->b_destroy_func = b_destroy_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_flat_map_co (_data_);
#line 1285 "future.c"
}


static void gee_future_do_flat_map_finish (GAsyncResult* _res_) {
	GeeFutureDoFlatMapData* _data_;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1293 "future.c"
}


static void gee_future_do_flat_map_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GeeFutureDoFlatMapData* _data_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_ = _user_data_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_source_object_ = source_object;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->_res_ = _res_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_do_flat_map_co (_data_);
#line 1307 "future.c"
}


static gboolean gee_future_do_flat_map_co (GeeFutureDoFlatMapData* _data_) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	switch (_data_->_state_) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 0:
#line 1316 "future.c"
		goto _state_0;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 1:
#line 1320 "future.c"
		goto _state_1;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		case 2:
#line 1324 "future.c"
		goto _state_2;
		default:
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_assert_not_reached ();
#line 1329 "future.c"
	}
	_state_0:
	{
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp0_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp0_ = _data_->future;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_state_ = 1;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_future_wait_async (_data_->_tmp0_, gee_future_do_flat_map_ready, _data_);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 1343 "future.c"
		_state_1:
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp1_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp1_ = gee_future_wait_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp2_ = NULL;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp2_ = ((_data_->_tmp1_ != NULL) && (_data_->a_dup_func != NULL)) ? _data_->a_dup_func ((gpointer) _data_->_tmp1_) : ((gpointer) _data_->_tmp1_);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->input = _data_->_tmp2_;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1357 "future.c"
			goto __catch2_g_error;
		}
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3__target = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3_ = _data_->func;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp3__target = _data_->func_target;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp4_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp4_ = _data_->input;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp5_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp5_ = _data_->_tmp3_ (_data_->_tmp4_, _data_->_tmp3__target);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp6_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_state_ = 2;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_future_wait_async (_data_->_tmp6_, gee_future_do_flat_map_ready, _data_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 1386 "future.c"
		_state_2:
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp7_ = gee_future_wait_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp8_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp8_ = ((_data_->_tmp7_ != NULL) && (_data_->b_dup_func != NULL)) ? _data_->b_dup_func ((gpointer) _data_->_tmp7_) : ((gpointer) _data_->_tmp7_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp9_ = NULL;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_object_unref0 (_data_->_tmp6_);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->output = _data_->_tmp9_;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_data_->_inner_error_ != NULL) {
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			((_data_->input == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->input = (_data_->a_destroy_func (_data_->input), NULL));
#line 1408 "future.c"
			goto __catch2_g_error;
		}
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp10_ = NULL;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp10_ = _data_->promise;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp11_ = NULL;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp11_ = _data_->output;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->output = NULL;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_value (_data_->_tmp10_, _data_->_tmp11_);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		((_data_->output == NULL) || (_data_->b_destroy_func == NULL)) ? NULL : (_data_->output = (_data_->b_destroy_func (_data_->output), NULL));
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		((_data_->input == NULL) || (_data_->a_destroy_func == NULL)) ? NULL : (_data_->input = (_data_->a_destroy_func (_data_->input), NULL));
#line 1427 "future.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->ex = _data_->_inner_error_;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_inner_error_ = NULL;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp12_ = NULL;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp12_ = _data_->promise;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp13_ = NULL;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->_tmp13_ = _data_->ex;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->ex = NULL;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		gee_promise_set_exception (_data_->_tmp12_, _data_->_tmp13_);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_error_free0 (_data_->ex);
#line 1450 "future.c"
	}
	__finally2:
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (_data_->_inner_error_ != NULL) {
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->func = NULL;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->func_target = NULL;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_data_->func_target_destroy_notify = NULL;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_clear_error (&_data_->_inner_error_);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return FALSE;
#line 1469 "future.c"
	}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(_data_->func_target_destroy_notify == NULL) ? NULL : (_data_->func_target_destroy_notify (_data_->func_target), NULL);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func = NULL;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target = NULL;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_data_->func_target_destroy_notify = NULL;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (_data_->_state_ == 0) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1483 "future.c"
	} else {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1487 "future.c"
	}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_object_unref (_data_->_async_result);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return FALSE;
#line 1493 "future.c"
}


gconstpointer gee_future_get_value (GeeFuture* self) {
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->get_value (self);
#line 1502 "future.c"
}


static gconstpointer gee_future_real_get_value (GeeFuture* base) {
	gconstpointer result;
	GeeFuture* self;
	GError * _inner_error_ = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	self = base;
#line 1512 "future.c"
	{
		gconstpointer _tmp0_ = NULL;
		gconstpointer _tmp1_ = NULL;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp1_ = gee_future_wait (self, &_inner_error_);
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_tmp0_ = _tmp1_;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		if (_inner_error_ != NULL) {
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			if (_inner_error_->domain == GEE_FUTURE_ERROR) {
#line 1524 "future.c"
				goto __catch3_gee_future_error;
			}
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
			return NULL;
#line 1533 "future.c"
		}
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		result = _tmp0_;
#line 54 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return result;
#line 1539 "future.c"
	}
	goto __finally3;
	__catch3_gee_future_error:
	{
		GError* ex = NULL;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		ex = _inner_error_;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_inner_error_ = NULL;
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		result = NULL;
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		_g_error_free0 (ex);
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		return result;
#line 1555 "future.c"
	}
	__finally3:
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_clear_error (&_inner_error_);
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return NULL;
#line 1564 "future.c"
}


gboolean gee_future_get_ready (GeeFuture* self) {
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->get_ready (self);
#line 1573 "future.c"
}


GError* gee_future_get_exception (GeeFuture* self) {
#line 75 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return GEE_FUTURE_GET_INTERFACE (self)->get_exception (self);
#line 1582 "future.c"
}


void gee_future_source_func_array_element_init (GeeFutureSourceFuncArrayElement *self, GSourceFunc func, void* func_target, GDestroyNotify func_target_destroy_notify) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GDestroyNotify _tmp0__target_destroy_notify = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	memset (self, 0, sizeof (GeeFutureSourceFuncArrayElement));
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = func;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0__target = func_target;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0__target_destroy_notify = func_target_destroy_notify;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target_destroy_notify = NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func = NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target = NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target_destroy_notify = NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func = _tmp0_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target = _tmp0__target;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target_destroy_notify = _tmp0__target_destroy_notify;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target = NULL;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	func_target_destroy_notify = NULL;
#line 1622 "future.c"
}


void gee_future_source_func_array_element_copy (const GeeFutureSourceFuncArrayElement* self, GeeFutureSourceFuncArrayElement* dest) {
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0_ = (*self).func;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	_tmp0__target = (*self).func_target;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func = NULL;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func_target = NULL;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func_target_destroy_notify = NULL;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func = _tmp0_;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func_target = _tmp0__target;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*dest).func_target_destroy_notify = NULL;
#line 1647 "future.c"
}


void gee_future_source_func_array_element_destroy (GeeFutureSourceFuncArrayElement* self) {
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func = NULL;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target = NULL;
#line 233 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	(*self).func_target_destroy_notify = NULL;
#line 1660 "future.c"
}


GeeFutureSourceFuncArrayElement* gee_future_source_func_array_element_dup (const GeeFutureSourceFuncArrayElement* self) {
	GeeFutureSourceFuncArrayElement* dup;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	dup = g_new0 (GeeFutureSourceFuncArrayElement, 1);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_source_func_array_element_copy (self, dup);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	return dup;
#line 1672 "future.c"
}


void gee_future_source_func_array_element_free (GeeFutureSourceFuncArrayElement* self) {
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	gee_future_source_func_array_element_destroy (self);
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	g_free (self);
#line 1681 "future.c"
}


GType gee_future_source_func_array_element_get_type (void) {
	static volatile gsize gee_future_source_func_array_element_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_source_func_array_element_type_id__volatile)) {
		GType gee_future_source_func_array_element_type_id;
		gee_future_source_func_array_element_type_id = g_boxed_type_register_static ("GeeFutureSourceFuncArrayElement", (GBoxedCopyFunc) gee_future_source_func_array_element_dup, (GBoxedFreeFunc) gee_future_source_func_array_element_free);
		g_once_init_leave (&gee_future_source_func_array_element_type_id__volatile, gee_future_source_func_array_element_type_id);
	}
	return gee_future_source_func_array_element_type_id__volatile;
}


static void gee_future_base_init (GeeFutureIface * iface) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	static gboolean initialized = FALSE;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
	if (!initialized) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		initialized = TRUE;
#line 1703 "future.c"
		/**
		 * Checks if value is ready. If it is calls to {@link wait} and
		 * {@link wait_until} will not block and value is returned immidiatly.
		 */
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1710 "future.c"
		/**
		 * Checks the exception that have been set. I.e. if the computation
		 * has thrown the exception it should be set here and the {@link wait},
		 * {@link wait_until} and {@link wait_async} should throw
		 * {@link FutureError.EXCEPTION}.
		 *
		 * @since 0.11.5
		 */
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		g_object_interface_install_property (iface, g_param_spec_pointer ("exception", "exception", "exception", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		iface->map = gee_future_real_map;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		iface->light_map = gee_future_real_light_map;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		iface->zip = gee_future_real_zip;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		iface->flat_map = gee_future_real_flat_map;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/future.vala"
		iface->get_value = gee_future_real_get_value;
#line 1731 "future.c"
	}
}


/**
 * Future is a value which might not yet be computed - for example it is calculated
 * in different thread or depends on I/O value.
 *
 * All methods can be called from many threads as part of interface.
 *
 * @see Promise
 * @see Lazy
 * @see task
 * @see async_task
 * @since 0.11.0
 *
 * Note: Statement that call does not block does not mean that it is lock-free.
 *   Internally the implementation is allowed to take mutex but it should guarantee
 *   that it is not for a long time (including blocking on anything else, I/O calls
 *   or callbacks).
 */
GType gee_future_get_type (void) {
	static volatile gsize gee_future_type_id__volatile = 0;
	if (g_once_init_enter (&gee_future_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeFutureIface), (GBaseInitFunc) gee_future_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_future_type_id;
		gee_future_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeFuture", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_future_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_future_type_id__volatile, gee_future_type_id);
	}
	return gee_future_type_id__volatile;
}


GQuark gee_future_error_quark (void) {
	return g_quark_from_static_string ("gee_future_error-quark");
}



