// -*- c++ -*-
// Generated by gmmproc 2.37.4 -- DO NOT MODIFY!
#ifndef _GIOMM_DRIVE_H
#define _GIOMM_DRIVE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <giomm/mount.h>
#include <giomm/icon.h>
//#include <giomm/volume.h>
//#include <giomm/mountoperation.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDriveIface GDriveIface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDrive GDrive;
typedef struct _GDriveClass GDriveClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Drive_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/** 
 *  @var DriveStartFlags DRIVE_START_NONE
 *  No flags set.
 * 
 *  @enum DriveStartFlags
 * 
 * Flags used when starting a drive.
 * 
 * @newin{2,22}
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DriveStartFlags operator|(DriveStartFlags, DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags operator&(DriveStartFlags, DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags operator^(DriveStartFlags, DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags operator~(DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags& operator|=(DriveStartFlags&, DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags& operator&=(DriveStartFlags&, DriveStartFlags)</tt><br>
 * <tt>%DriveStartFlags& operator^=(DriveStartFlags&, DriveStartFlags)</tt><br>
 */
enum DriveStartFlags
{
  DRIVE_START_NONE = 0x0
};

/** @ingroup giommEnums */
inline DriveStartFlags operator|(DriveStartFlags lhs, DriveStartFlags rhs)
  { return static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DriveStartFlags operator&(DriveStartFlags lhs, DriveStartFlags rhs)
  { return static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DriveStartFlags operator^(DriveStartFlags lhs, DriveStartFlags rhs)
  { return static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DriveStartFlags operator~(DriveStartFlags flags)
  { return static_cast<DriveStartFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DriveStartFlags& operator|=(DriveStartFlags& lhs, DriveStartFlags rhs)
  { return (lhs = static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DriveStartFlags& operator&=(DriveStartFlags& lhs, DriveStartFlags rhs)
  { return (lhs = static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DriveStartFlags& operator^=(DriveStartFlags& lhs, DriveStartFlags rhs)
  { return (lhs = static_cast<DriveStartFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::DriveStartFlags> : public Glib::Value_Flags<Gio::DriveStartFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{

/** 
 *  @var DriveStartStopType DRIVE_START_STOP_TYPE_UNKNOWN
 *  Unknown or drive doesn't supportstart/stop.
 * 
 *  @var DriveStartStopType DRIVE_START_STOP_TYPE_SHUTDOWN
 *  The stop method will physicallyshut down the drive and e.g. power down the port the drive isattached to.
 * 
 *  @var DriveStartStopType DRIVE_START_STOP_TYPE_NETWORK
 *  The start/stop methods are usedfor connecting/disconnect to the drive over the network.
 * 
 *  @var DriveStartStopType DRIVE_START_STOP_TYPE_MULTIDISK
 *  The start/stop methods willassemble/disassemble a virtual drive from several physicaldrives.
 * 
 *  @var DriveStartStopType DRIVE_START_STOP_TYPE_PASSWORD
 *  The start/stop methods willunlock/lock the disk (for example using the ATA <quote>SECURITYUNLOCK DEVICE</quote> command).
 * 
 *  @enum DriveStartStopType
 * 
 * Enumeration describing how a drive can be started/stopped.
 * 
 * @newin{2,22}
 * @ingroup giommEnums
 */
enum DriveStartStopType
{
  DRIVE_START_STOP_TYPE_UNKNOWN,
  DRIVE_START_STOP_TYPE_SHUTDOWN,
  DRIVE_START_STOP_TYPE_NETWORK,
  DRIVE_START_STOP_TYPE_MULTIDISK,
  DRIVE_START_STOP_TYPE_PASSWORD
};

} // namespace Gio


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gio::DriveStartStopType> : public Glib::Value_Enum<Gio::DriveStartStopType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{


/** Virtual File System drive management.
 *
 * This represent a piece of hardware connected to the machine. It's generally only created for removable hardware or hardware with removable media.
 * Gio::Drive is a container class for Gio::Volume objects that stem from the same piece of media. As such, Gio::Drive abstracts a drive with
 * (or without) removable media and provides operations for querying whether media is available, determing whether media change is automatically
 * detected and ejecting the media.
 *
 * If the Gio::Drive reports that media isn't automatically detected, one can poll for media; typically one should not do this periodically as a
 * poll for media operation is potententially expensive and may spin up the drive, creating noise.
 *
 * @newin{2,16}
 */

class Drive : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Drive CppObjectType;
  typedef Drive_Class CppClassType;
  typedef GDrive BaseObjectType;
  typedef GDriveIface BaseClassType;

private:
  friend class Drive_Class;
  static CppClassType drive_class_;

  // noncopyable
  Drive(const Drive&);
  Drive& operator=(const Drive&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Drive();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Drive(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Drive(GDrive* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Drive();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDrive*       gobj()       { return reinterpret_cast<GDrive*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDrive* gobj() const { return reinterpret_cast<GDrive*>(gobject_); }

private:

public:

  
  /** Gets the name of @a drive.
   * @return A string containing @a drive's name. The returned 
   * string should be freed when no longer needed.
   */
  Glib::ustring get_name() const;

  
  /** Gets the icon for @a drive.
   * @return Icon for the @a drive.
   * Free the returned object with Glib::object_unref().
   */
  Glib::RefPtr<Icon> get_icon();
  
  /** Gets the icon for @a drive.
   * @return Icon for the @a drive.
   * Free the returned object with Glib::object_unref().
   */
  Glib::RefPtr<const Icon> get_icon() const;

  
  /** Gets the icon for @a drive.
   * 
   * @newin{2,34}
   * @return Symbolic Icon for the @a drive.
   * Free the returned object with Glib::object_unref().
   */
  Glib::RefPtr<Icon> get_symbolic_icon();
  
  /** Gets the icon for @a drive.
   * 
   * @newin{2,34}
   * @return Symbolic Icon for the @a drive.
   * Free the returned object with Glib::object_unref().
   */
  Glib::RefPtr<const Icon> get_symbolic_icon() const;

  
  /** Check if @a drive has any mountable volumes.
   * @return <tt>true</tt> if the @a drive contains volumes, <tt>false</tt> otherwise.
   */
  bool has_volumes() const;

 
  /** Get a list of mountable volumes for @a drive.
   * 
   * The returned list should be freed with Glib::list_free(), after
   * its elements have been unreffed with Glib::object_unref().
   * @return List containing any Volume objects on the given @a drive.
   */
  Glib::ListHandle< Glib::RefPtr<Volume> > get_volumes();

  
  /** Checks if the @a drive supports removable media.
   * @return <tt>true</tt> if @a drive supports removable media, <tt>false</tt> otherwise.
   */
  bool is_media_removable() const;
  
  /** Checks if the @a drive has media. Note that the OS may not be polling
   * the drive for media changes; see g_drive_is_media_check_automatic()
   * for more details.
   * @return <tt>true</tt> if @a drive has media, <tt>false</tt> otherwise.
   */
  bool has_media() const;
  
  /** Checks if @a drive is capabable of automatically detecting media changes.
   * @return <tt>true</tt> if the @a drive is capabable of automatically detecting 
   * media changes, <tt>false</tt> otherwise.
   */
  bool is_media_check_automatic() const;
  
  /** Checks if a drive can be polled for media changes.
   * @return <tt>true</tt> if the @a drive can be polled for media changes,
   * <tt>false</tt> otherwise.
   */
  bool can_poll_for_media() const;
  
  /** Checks if a drive can be ejected.
   * @return <tt>true</tt> if the @a drive can be ejected, <tt>false</tt> otherwise.
   */
  bool can_eject() const;

  /** Ejects the drive.
   * @param slot A callback which will be called when the eject is completed or canceled.
   * @param flags Flags affecting the unmount if required for eject.
   * @param cancellable A cancellable object which can be used to cancel the eject.
   */
  void eject(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Ejects the drive.
   * @param slot A callback which will be called when the eject is completed.
   * @param flags Flags affecting the unmount if required for eject.
   */
  void eject(const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  void eject(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  void eject(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);

  /** Ejects the drive.
   * @param flags Flags affecting the unmount if required for eject.
   */
  void eject(MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  void eject(const Glib::RefPtr<MountOperation>& mount_operation, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  
  
  // eject_finish() is deprecated in favor of eject_with_operation_finish(), and
  // since all of our eject() overloads are implemented by
  // eject_with_operation(), we implement the _finish() with
  // eject_with_operation_finish and ignore the deprecated one
  
  /** Finishes ejecting a drive. If any errors occurred during the operation,
   *  @a error will be set to contain the errors and <tt>false</tt> will be returned.
   * 
   * @newin{2,22}
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the drive was successfully ejected. <tt>false</tt> otherwise.
   */
  bool eject_finish(const Glib::RefPtr<AsyncResult>& result);
  

  /** Polls drive to see if media has been inserted or removed.
   * @param slot A callback which will be called when the poll is completed.
   * @param cancellable A cancellable object which can be used to cancel the operation.
   */
  void poll_for_media(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable);

  /** Polls drive to see if media has been inserted or removed.
   * @param slot A callback which will be called when the poll is completed.
   */
  void poll_for_media(const SlotAsyncReady& slot);

  /** Polls drive to see if media has been inserted or removed.
   */
  void poll_for_media();
  

  /** Finishes an operation started with g_drive_poll_for_media() on a drive.
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the drive has been poll_for_mediaed successfully,
   * <tt>false</tt> otherwise.
   */
  bool poll_for_media_finish(const Glib::RefPtr<AsyncResult>& result);

  
  /** Gets the identifier of the given kind for @a drive.
   * @param kind The kind of identifier to return.
   * @return A newly allocated string containing the
   * requested identfier, or <tt>0</tt> if the Drive
   * doesn't have this kind of identifier.
   */
  std::string get_identifier(const std::string& kind) const;

   
  /** Gets the kinds of identifiers that @a drive has. 
   * Use g_drive_get_identifier() to obtain the identifiers
   * themselves.
   * @return A <tt>0</tt>-terminated
   * array of strings containing kinds of identifiers. Use Glib::strfreev()
   * to free.
   */
  Glib::StringArrayHandle enumerate_identifiers() const;

  /** @newin{2,22} */
  void start(const Glib::RefPtr<MountOperation>& mount_operation, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot, DriveStartFlags flags = DRIVE_START_NONE);
  /** @newin{2,22} */
  void start(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot, DriveStartFlags flags = DRIVE_START_NONE);
  
  
  /** Finishes starting a drive.
   * 
   * @newin{2,22}
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the drive has been started successfully,
   * <tt>false</tt> otherwise.
   */
  bool start_finish(const Glib::RefPtr<AsyncResult>& result);
  
  /** @newin{2,22}
   */
  bool can_start() const;
  
  /** @newin{2,22}
   */
  bool can_start_degraded() const;

  /** @newin{2,22} */
  void stop(const Glib::RefPtr<MountOperation>& mount_operation, const Glib::RefPtr<Cancellable>& cancellable, const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  /** @newin{2,22} */
  void stop(const Glib::RefPtr<MountOperation>& mount_operation, const SlotAsyncReady& slot, MountUnmountFlags flags = MOUNT_UNMOUNT_NONE);
  
  
  /** Finishes stopping a drive.
   * 
   * @newin{2,22}
   * @param result A AsyncResult.
   * @return <tt>true</tt> if the drive has been stopped successfully,
   * <tt>false</tt> otherwise.
   */
  bool stop_finish(const Glib::RefPtr<AsyncResult>& result);
  
  /** @newin{2,22}
   */
  bool can_stop() const;

  
  /** Gets a hint about how a drive can be started/stopped.
   * 
   * @newin{2,22}
   * @return A value from the DriveStartStopType enumeration.
   */
  DriveStartStopType get_start_stop_type() const;

  
  /** Gets the sort key for @a drive, if any.
   * 
   * @newin{2,32}
   * @return Sorting key for @a drive or <tt>0</tt> if no such key is available.
   */
  Glib::ustring get_sort_key() const;

  /** @newin{2,20}
   *
* @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   * Emitted when the drive's state has changed.
   */

  Glib::SignalProxy0< void > signal_changed();


  /** @newin{2,20}
   *
* @par Slot Prototype:
   * <tt>void on_my_%disconnected()</tt>
   *
   * This signal is emitted when the Drive have been
   * disconnected. If the recipient is holding references to the
   * object they should release them so the object can be
   * finalized.
   */

  Glib::SignalProxy0< void > signal_disconnected();


  /** @newin{2,20}
   *
* @par Slot Prototype:
   * <tt>void on_my_%eject_button()</tt>
   *
   * Emitted when the physical eject button (if any) of a drive has
   * been pressed.
   */

  Glib::SignalProxy0< void > signal_eject_button();

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%stop_button()</tt>
   *
   * Emitted when the physical stop button (if any) of a drive has
   * been pressed.
   * 
   * @newin{2,22}
   */

  Glib::SignalProxy0< void > signal_stop_button();


  //_WRAP_VFUNC(Glib::ustring get_name() const, get_name)
  //Careful of ref-counting: //_WRAP_VFUNC(Glib::RefPtr<Icon> get_icon() const, get_icon)
  //_WRAP_VFUNC(bool has_volumes() const, has_volumes)


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio

namespace Glib
{

//Pre-declare this so we can use it in TypeTrait:
Glib::RefPtr<Gio::Drive> wrap(GDrive* object, bool take_copy);

namespace Container_Helpers
{

/** This specialization of TypeTraits exists
 * because the default use of Glib::wrap(GObject*),
 * instead of a specific Glib::wrap(GSomeInterface*),
 * would not return a wrapper for an interface.
 */
template <>
struct TypeTraits< Glib::RefPtr<Gio::Drive> >
{
  typedef Glib::RefPtr<Gio::Drive> CppType;
  typedef GDrive* CType;
  typedef GDrive* CTypeNonConst;

  static CType   to_c_type      (const CppType& item)
  { return Glib::unwrap (item); }

  static CppType to_cpp_type    (const CType& item)
  {
    //Use a specific Glib::wrap() function,
    //because CType has the specific type (not just GObject):
    return Glib::wrap(item, true /* take_copy */);
  }

  static void    release_c_type (CType item)
  {
    GLIBMM_DEBUG_UNREFERENCE(0, item);
    g_object_unref(item);
  }
};

} // Container_Helpers
} // Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Drive
   */
  Glib::RefPtr<Gio::Drive> wrap(GDrive* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_DRIVE_H */

