/* persona-store-tests.c generated by valac 0.18.0.110-5650, the Vala compiler
 * generated from persona-store-tests.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <eds-test.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <folks/folks-eds.h>
#include <gio/gio.h>


#define TYPE_PERSONA_STORE_TESTS (persona_store_tests_get_type ())
#define PERSONA_STORE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONA_STORE_TESTS, PersonaStoreTests))
#define PERSONA_STORE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsClass))
#define IS_PERSONA_STORE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONA_STORE_TESTS))
#define IS_PERSONA_STORE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONA_STORE_TESTS))
#define PERSONA_STORE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsClass))

typedef struct _PersonaStoreTests PersonaStoreTests;
typedef struct _PersonaStoreTestsClass PersonaStoreTestsClass;
typedef struct _PersonaStoreTestsPrivate PersonaStoreTestsPrivate;
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PersonaStoreTests {
	FolksTestCase parent_instance;
	PersonaStoreTestsPrivate * priv;
};

struct _PersonaStoreTestsClass {
	FolksTestCaseClass parent_class;
};

struct _PersonaStoreTestsPrivate {
	EdsTestBackend* _eds_backend;
	GeeHashSet* _capabilities_received;
};

struct _Block1Data {
	int _ref_count_;
	PersonaStoreTests * self;
	GMainLoop* main_loop;
	FolksBackendStore* backend_store;
};

struct _Block2Data {
	int _ref_count_;
	PersonaStoreTests * self;
	FolksPersonaStore* store;
};


static gpointer persona_store_tests_parent_class = NULL;

GType persona_store_tests_get_type (void) G_GNUC_CONST;
#define PERSONA_STORE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PERSONA_STORE_TESTS, PersonaStoreTestsPrivate))
enum  {
	PERSONA_STORE_TESTS_DUMMY_PROPERTY
};
PersonaStoreTests* persona_store_tests_new (void);
PersonaStoreTests* persona_store_tests_construct (GType object_type);
void persona_store_tests_test_persona_store (PersonaStoreTests* self);
static void _persona_store_tests_test_persona_store_folks_test_case_test_method (gpointer self);
static void persona_store_tests_real_set_up (FolksTestCase* base);
static void persona_store_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void __lambda2_ (Block1Data* _data1_, GObject* o, GAsyncResult* r);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda3_ (PersonaStoreTests* self, FolksBackend* b);
static void ___lambda4_ (PersonaStoreTests* self, FolksPersonaStore* ps);
static void _persona_store_tests_set_up_persona_store (PersonaStoreTests* self, FolksPersonaStore* store);
static void ____lambda4__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self);
static void ___lambda3__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
static gboolean __lambda6_ (Block1Data* _data1_);
static gboolean ___lambda6__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_);
static void _persona_store_tests_can_add_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void __persona_store_tests_can_add_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _persona_store_tests_can_remove_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void __persona_store_tests_can_remove_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _persona_store_tests_check_can_alias_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void _persona_store_tests_check_can_group_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void persona_store_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _persona_store_tests_test_persona_store_folks_test_case_test_method (gpointer self) {
#line 34 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	persona_store_tests_test_persona_store (self);
#line 128 "persona-store-tests.c"
}


PersonaStoreTests* persona_store_tests_construct (GType object_type) {
	PersonaStoreTests * self = NULL;
	EdsTestBackend* _tmp0_;
#line 32 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) folks_test_case_construct (object_type, "PersonaStoreTests");
#line 33 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = eds_test_backend_new ();
#line 33 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_eds_test_backend_unref0 (self->priv->_eds_backend);
#line 33 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self->priv->_eds_backend = _tmp0_;
#line 34 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "persona store tests", _persona_store_tests_test_persona_store_folks_test_case_test_method, self);
#line 30 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return self;
#line 147 "persona-store-tests.c"
}


PersonaStoreTests* persona_store_tests_new (void) {
#line 30 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return persona_store_tests_construct (TYPE_PERSONA_STORE_TESTS);
#line 154 "persona-store-tests.c"
}


static void persona_store_tests_real_set_up (FolksTestCase* base) {
	PersonaStoreTests * self;
	GeeHashSet* _tmp0_;
	EdsTestBackend* _tmp1_;
#line 37 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) base;
#line 39 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 39 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (self->priv->_capabilities_received);
#line 39 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self->priv->_capabilities_received = _tmp0_;
#line 41 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = self->priv->_eds_backend;
#line 41 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_set_up (_tmp1_, FALSE, "test");
#line 174 "persona-store-tests.c"
}


static void persona_store_tests_real_tear_down (FolksTestCase* base) {
	PersonaStoreTests * self;
#line 44 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = (PersonaStoreTests*) base;
#line 182 "persona-store-tests.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return _data1_;
#line 191 "persona-store-tests.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 200 "persona-store-tests.c"
		PersonaStoreTests * self;
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		self = _data1_->self;
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (_data1_->backend_store);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_main_loop_unref0 (_data1_->main_loop);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (self);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_slice_free (Block1Data, _data1_);
#line 212 "persona-store-tests.c"
	}
}


static GValue* _g_value_dup (GValue* self) {
#line 50 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return g_boxed_copy (G_TYPE_VALUE, self);
#line 220 "persona-store-tests.c"
}


static void _vala_GValue_free (GValue* self) {
#line 50 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_unset (self);
#line 50 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_free (self);
#line 229 "persona-store-tests.c"
}


static gpointer __g_value_dup0 (gpointer self) {
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return self ? _g_value_dup (self) : NULL;
#line 236 "persona-store-tests.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 63 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return self ? g_object_ref (self) : NULL;
#line 243 "persona-store-tests.c"
}


static void __lambda2_ (Block1Data* _data1_, GObject* o, GAsyncResult* r) {
	PersonaStoreTests * self;
	GAsyncResult* _tmp0_;
#line 74 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = _data1_->self;
#line 74 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (r != NULL);
#line 76 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = r;
#line 76 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_prepare_finish (_data1_->backend_store, _tmp0_);
#line 258 "persona-store-tests.c"
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 74 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__lambda2_ (self, source_object, res);
#line 74 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	block1_data_unref (self);
#line 267 "persona-store-tests.c"
}


static void ___lambda4_ (PersonaStoreTests* self, FolksPersonaStore* ps) {
	FolksPersonaStore* _tmp0_;
#line 82 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (ps != NULL);
#line 84 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = ps;
#line 84 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_set_up_persona_store (self, _tmp0_);
#line 279 "persona-store-tests.c"
}


static void ____lambda4__folks_backend_persona_store_added (FolksBackend* _sender, FolksPersonaStore* store, gpointer self) {
#line 82 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	___lambda4_ (self, store);
#line 286 "persona-store-tests.c"
}


static void __lambda3_ (PersonaStoreTests* self, FolksBackend* b) {
	FolksBackend* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 78 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (b != NULL);
#line 80 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = b;
#line 80 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = folks_backend_get_name (_tmp0_);
#line 80 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _tmp1_;
#line 80 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (g_strcmp0 (_tmp2_, "eds") == 0) {
#line 304 "persona-store-tests.c"
		FolksBackend* _tmp3_;
#line 82 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp3_ = b;
#line 82 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_signal_connect_object (_tmp3_, "persona-store-added", (GCallback) ____lambda4__folks_backend_persona_store_added, self, 0);
#line 310 "persona-store-tests.c"
		{
			FolksBackend* _tmp4_;
			GeeMap* _tmp5_;
			GeeMap* _tmp6_;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			GeeCollection* _tmp9_;
			GeeIterator* _tmp10_ = NULL;
			GeeIterator* _tmp11_;
			GeeIterator* _store_it;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp4_ = b;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp5_ = folks_backend_get_persona_stores (_tmp4_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp6_ = _tmp5_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp7_ = gee_map_get_values (_tmp6_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp8_ = _tmp7_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp9_ = _tmp8_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp11_ = _tmp10_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_g_object_unref0 (_tmp9_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_store_it = _tmp11_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			while (TRUE) {
#line 343 "persona-store-tests.c"
				GeeIterator* _tmp12_;
				gboolean _tmp13_ = FALSE;
				GeeIterator* _tmp14_;
				gpointer _tmp15_ = NULL;
				FolksPersonaStore* store;
				FolksPersonaStore* _tmp16_;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_tmp12_ = _store_it;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_tmp13_ = gee_iterator_next (_tmp12_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				if (!_tmp13_) {
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
					break;
#line 358 "persona-store-tests.c"
				}
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_tmp14_ = _store_it;
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_tmp15_ = gee_iterator_get (_tmp14_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				store = (FolksPersonaStore*) _tmp15_;
#line 89 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_tmp16_ = store;
#line 89 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_persona_store_tests_set_up_persona_store (self, _tmp16_);
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
				_g_object_unref0 (store);
#line 372 "persona-store-tests.c"
			}
#line 87 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_g_object_unref0 (_store_it);
#line 376 "persona-store-tests.c"
		}
	}
}


static void ___lambda3__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
#line 78 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__lambda3_ (self, backend);
#line 385 "persona-store-tests.c"
}


static gboolean __lambda6_ (Block1Data* _data1_) {
	PersonaStoreTests * self;
	gboolean result = FALSE;
#line 97 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = _data1_->self;
#line 99 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_main_loop_quit (_data1_->main_loop);
#line 100 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	result = FALSE;
#line 100 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return result;
#line 400 "persona-store-tests.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
#line 97 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return result;
#line 409 "persona-store-tests.c"
}


void persona_store_tests_test_persona_store (PersonaStoreTests* self) {
	Block1Data* _data1_;
	GeeHashMap* _tmp0_;
	GeeHashMap* c1;
	GeeHashMap* _tmp1_;
	GeeHashMap* c2;
	GMainLoop* _tmp2_;
	GValue* v = NULL;
	EdsTestBackend* _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	GValue* _tmp6_;
	GValue* _tmp7_;
	GValue* _tmp8_;
	GValue* _tmp9_;
	GValue _tmp10_ = {0};
	GValue _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	const gchar* _tmp14_;
	GValue* _tmp15_;
	GValue* _tmp16_;
	EdsTestBackend* _tmp17_;
	GeeHashMap* _tmp18_;
	GValue _tmp19_ = {0};
	GValue _tmp20_;
	GValue* _tmp21_;
	GValue* _tmp22_;
	GValue* _tmp23_;
	GValue* _tmp24_;
	GValue _tmp25_ = {0};
	GValue _tmp26_;
	GValue* _tmp27_;
	GValue* _tmp28_;
	const gchar* _tmp29_;
	GValue* _tmp30_;
	GValue* _tmp31_;
	EdsTestBackend* _tmp32_;
	GeeHashMap* _tmp33_;
	FolksBackendStore* _tmp34_ = NULL;
	GeeHashSet* _tmp35_;
	gboolean _tmp36_ = FALSE;
	GeeHashSet* _tmp37_;
	gboolean _tmp38_ = FALSE;
	GeeHashSet* _tmp39_;
	gboolean _tmp40_ = FALSE;
	GeeHashSet* _tmp41_;
	gboolean _tmp42_ = FALSE;
	EdsTestBackend* _tmp43_;
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_->_ref_count_ = 1;
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_->self = g_object_ref (self);
#line 50 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 50 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	c1 = _tmp0_;
#line 51 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 51 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	c2 = _tmp1_;
#line 52 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = g_main_loop_new (NULL, FALSE);
#line 52 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_->main_loop = _tmp2_;
#line 55 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = self->priv->_eds_backend;
#line 55 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_reset (_tmp3_);
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp4_, G_TYPE_STRING);
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp6_ = __g_value_dup0 (&_tmp5_);
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = _tmp6_;
#line 57 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
#line 58 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp7_ = v;
#line 58 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp7_, "bernie h. innocenti");
#line 59 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp8_ = v;
#line 59 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 59 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp9_ = _tmp8_;
#line 59 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c1, "full_name", _tmp9_);
#line 59 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp9_);
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp10_, G_TYPE_STRING);
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp11_ = _tmp10_;
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp12_ = __g_value_dup0 (&_tmp11_);
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = _tmp12_;
#line 60 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
#line 61 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp13_ = v;
#line 61 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp13_, "bernie@example.org");
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp14_ = EDSF_PERSONA_email_fields[0];
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp15_ = v;
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp16_ = _tmp15_;
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c1, _tmp14_, _tmp16_);
#line 62 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp16_);
#line 63 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp17_ = self->priv->_eds_backend;
#line 63 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp18_ = _g_object_ref0 (c1);
#line 63 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_add_contact (_tmp17_, _tmp18_);
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp19_, G_TYPE_STRING);
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp20_ = _tmp19_;
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp21_ = __g_value_dup0 (&_tmp20_);
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = _tmp21_;
#line 65 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp20_) ? (g_value_unset (&_tmp20_), NULL) : NULL;
#line 66 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp22_ = v;
#line 66 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp22_, "richard m. stallman");
#line 67 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp23_ = v;
#line 67 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 67 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp24_ = _tmp23_;
#line 67 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c2, "full_name", _tmp24_);
#line 67 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp24_);
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_init (&_tmp25_, G_TYPE_STRING);
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp26_ = _tmp25_;
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp27_ = __g_value_dup0 (&_tmp26_);
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = _tmp27_;
#line 68 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_IS_VALUE (&_tmp26_) ? (g_value_unset (&_tmp26_), NULL) : NULL;
#line 69 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp28_ = v;
#line 69 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_value_set_string (_tmp28_, "rms@example.org");
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp29_ = EDSF_PERSONA_email_fields[0];
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp30_ = v;
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	v = NULL;
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp31_ = _tmp30_;
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	gee_abstract_map_set ((GeeAbstractMap*) c2, _tmp29_, _tmp31_);
#line 70 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (_tmp31_);
#line 71 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp32_ = self->priv->_eds_backend;
#line 71 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp33_ = _g_object_ref0 (c2);
#line 71 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_add_contact (_tmp32_, _tmp33_);
#line 73 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp34_ = folks_backend_store_dup ();
#line 73 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_->backend_store = _tmp34_;
#line 74 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_prepare (_data1_->backend_store, ___lambda2__gasync_ready_callback, block1_data_ref (_data1_));
#line 78 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_signal_connect_object (_data1_->backend_store, "backend-available", (GCallback) ___lambda3__folks_backend_store_backend_available, self, 0);
#line 95 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	folks_backend_store_load_backends (_data1_->backend_store, NULL, NULL);
#line 97 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, ___lambda6__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 103 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_main_loop_run (_data1_->main_loop);
#line 105 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp35_ = self->priv->_capabilities_received;
#line 105 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp35_, "can-add-personas");
#line 105 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp36_, "this._capabilities_received.contains (\"can-add-personas\")");
#line 106 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp37_ = self->priv->_capabilities_received;
#line 106 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp38_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp37_, "can-remove-personas");
#line 106 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp38_, "this._capabilities_received.contains (\"can-remove-personas\")");
#line 107 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp39_ = self->priv->_capabilities_received;
#line 107 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp40_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp39_, "can-alias-personas");
#line 107 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (!_tmp40_, "!this._capabilities_received.contains (\"can-alias-personas\")");
#line 108 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp41_ = self->priv->_capabilities_received;
#line 108 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp42_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp41_, "can-group-personas");
#line 108 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (_tmp42_, "this._capabilities_received.contains (\"can-group-personas\")");
#line 110 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp43_ = self->priv->_eds_backend;
#line 110 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	eds_test_backend_tear_down (_tmp43_);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__vala_GValue_free0 (v);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (c2);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (c1);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	block1_data_unref (_data1_);
#line 48 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data1_ = NULL;
#line 658 "persona-store-tests.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return _data2_;
#line 667 "persona-store-tests.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 676 "persona-store-tests.c"
		PersonaStoreTests * self;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		self = _data2_->self;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (_data2_->store);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_object_unref0 (self);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_slice_free (Block2Data, _data2_);
#line 686 "persona-store-tests.c"
	}
}


static void __persona_store_tests_can_add_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 124 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_can_add_personas_cb (self, _sender, pspec);
#line 694 "persona-store-tests.c"
}


static void __persona_store_tests_can_remove_personas_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 130 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_persona_store_tests_can_remove_personas_cb (self, _sender, pspec);
#line 701 "persona-store-tests.c"
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	for (i = 0; i < stack_length; i++) {
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			return TRUE;
#line 713 "persona-store-tests.c"
		}
	}
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return FALSE;
#line 718 "persona-store-tests.c"
}


static void __lambda5_ (Block2Data* _data2_, GObject* obj, GAsyncResult* _result_) {
	PersonaStoreTests * self;
	GError * _inner_error_ = NULL;
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = _data2_->self;
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (_result_ != NULL);
#line 729 "persona-store-tests.c"
	{
		FolksPersonaStore* _tmp0_;
		GAsyncResult* _tmp1_;
		FolksPersonaStore* _tmp2_;
		FolksMaybeBool _tmp3_;
		FolksMaybeBool _tmp4_;
		FolksPersonaStore* _tmp7_;
		FolksMaybeBool _tmp8_;
		FolksMaybeBool _tmp9_;
		FolksPersonaStore* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar** _tmp14_;
		gint _tmp14__length1;
		FolksPersonaStore* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar** _tmp18_;
		gint _tmp18__length1;
#line 119 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp0_ = _data2_->store;
#line 119 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp1_ = _result_;
#line 119 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		folks_persona_store_prepare_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 119 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (_inner_error_ != NULL) {
#line 757 "persona-store-tests.c"
			goto __catch0_g_error;
		}
#line 121 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp2_ = _data2_->store;
#line 121 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp3_ = folks_persona_store_get_can_add_personas (_tmp2_);
#line 121 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp4_ = _tmp3_;
#line 121 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (_tmp4_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 768 "persona-store-tests.c"
			FolksPersonaStore* _tmp5_;
#line 122 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp5_ = _data2_->store;
#line 122 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_can_add_personas_cb (self, (GObject*) _tmp5_, NULL);
#line 774 "persona-store-tests.c"
		} else {
			FolksPersonaStore* _tmp6_;
#line 124 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp6_ = _data2_->store;
#line 124 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			g_signal_connect_object ((GObject*) _tmp6_, "notify::can-add-personas", (GCallback) __persona_store_tests_can_add_personas_cb_g_object_notify, self, 0);
#line 781 "persona-store-tests.c"
		}
#line 127 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = _data2_->store;
#line 127 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = folks_persona_store_get_can_remove_personas (_tmp7_);
#line 127 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = _tmp8_;
#line 127 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (_tmp9_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 791 "persona-store-tests.c"
			FolksPersonaStore* _tmp10_;
#line 128 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp10_ = _data2_->store;
#line 128 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_can_remove_personas_cb (self, (GObject*) _tmp10_, NULL);
#line 797 "persona-store-tests.c"
		} else {
			FolksPersonaStore* _tmp11_;
#line 130 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp11_ = _data2_->store;
#line 130 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			g_signal_connect_object ((GObject*) _tmp11_, "notify::can-remove-personas", (GCallback) __persona_store_tests_can_remove_personas_cb_g_object_notify, self, 0);
#line 804 "persona-store-tests.c"
		}
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp12_ = _data2_->store;
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp13_ = folks_persona_store_get_always_writeable_properties (_tmp12_, &_tmp13__length1);
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp14_ = _tmp13_;
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp14__length1 = _tmp13__length1;
#line 133 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (_vala_string_array_contains (_tmp14_, _tmp14__length1, "alias")) {
#line 816 "persona-store-tests.c"
			FolksPersonaStore* _tmp15_;
#line 134 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp15_ = _data2_->store;
#line 134 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_check_can_alias_personas (self, (GObject*) _tmp15_, NULL);
#line 822 "persona-store-tests.c"
		}
#line 136 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp16_ = _data2_->store;
#line 136 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp17_ = folks_persona_store_get_always_writeable_properties (_tmp16_, &_tmp17__length1);
#line 136 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp18_ = _tmp17_;
#line 136 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp18__length1 = _tmp17__length1;
#line 136 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		if (_vala_string_array_contains (_tmp18_, _tmp18__length1, "groups")) {
#line 834 "persona-store-tests.c"
			FolksPersonaStore* _tmp19_;
#line 137 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_tmp19_ = _data2_->store;
#line 137 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
			_persona_store_tests_check_can_group_personas (self, (GObject*) _tmp19_, NULL);
#line 840 "persona-store-tests.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FolksPersonaStore* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		FolksPersonaStore* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GError* _tmp26_;
		const gchar* _tmp27_;
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		e = _inner_error_;
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_inner_error_ = NULL;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp20_ = _data2_->store;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp21_ = folks_persona_store_get_type_id (_tmp20_);
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp22_ = _tmp21_;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp23_ = _data2_->store;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp24_ = folks_persona_store_get_id (_tmp23_);
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp25_ = _tmp24_;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp26_ = e;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp27_ = _tmp26_->message;
#line 141 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_warning ("Error preparing PersonaStore type: %s, id: %s: " "'%s'", _tmp22_, _tmp25_, _tmp27_);
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_g_error_free0 (e);
#line 879 "persona-store-tests.c"
	}
	__finally0:
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (_inner_error_ != NULL) {
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_clear_error (&_inner_error_);
#line 117 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		return;
#line 890 "persona-store-tests.c"
	}
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	__lambda5_ (self, source_object, res);
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	block2_data_unref (self);
#line 900 "persona-store-tests.c"
}


static void _persona_store_tests_set_up_persona_store (PersonaStoreTests* self, FolksPersonaStore* store) {
	Block2Data* _data2_;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (store != NULL);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data2_->_ref_count_ = 1;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data2_->self = g_object_ref (self);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = store;
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (_data2_->store);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data2_->store = _tmp1_;
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _data2_->store;
#line 115 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	folks_persona_store_prepare (_tmp2_, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	block2_data_unref (_data2_);
#line 113 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_data2_ = NULL;
#line 935 "persona-store-tests.c"
}


static void _persona_store_tests_can_add_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	EdsfPersonaStore* _tmp2_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp3_;
	FolksMaybeBool _tmp4_;
	FolksMaybeBool _tmp5_;
#line 147 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 149 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 149 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 150 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 150 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 150 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 152 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = store;
#line 152 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = folks_persona_store_get_can_add_personas ((FolksPersonaStore*) _tmp3_);
#line 152 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 152 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (_tmp5_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 969 "persona-store-tests.c"
		EdsfPersonaStore* _tmp6_;
		FolksMaybeBool _tmp7_;
		FolksMaybeBool _tmp8_;
		GeeHashSet* _tmp9_;
		EdsfPersonaStore* _tmp10_;
		guint _tmp11_ = 0U;
		GQuark _tmp12_ = 0U;
#line 154 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp6_ = store;
#line 154 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = folks_persona_store_get_can_add_personas ((FolksPersonaStore*) _tmp6_);
#line 154 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = _tmp7_;
#line 154 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_vala_assert (_tmp8_ == FOLKS_MAYBE_BOOL_TRUE, "store.can_add_personas == MaybeBool.TRUE");
#line 156 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = self->priv->_capabilities_received;
#line 156 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "can-add-personas");
#line 158 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp10_ = store;
#line 158 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_signal_parse_name ("notify::can-add-personas", G_TYPE_OBJECT, &_tmp11_, &_tmp12_, TRUE);
#line 158 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, _tmp12_, NULL, (GCallback) __persona_store_tests_can_add_personas_cb_g_object_notify, self);
#line 995 "persona-store-tests.c"
	}
#line 147 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 999 "persona-store-tests.c"
}


static void _persona_store_tests_can_remove_personas_cb (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	EdsfPersonaStore* _tmp2_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp3_;
	FolksMaybeBool _tmp4_;
	FolksMaybeBool _tmp5_;
#line 163 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 165 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 165 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 166 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 166 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 166 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 168 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = store;
#line 168 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) _tmp3_);
#line 168 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 168 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (_tmp5_ != FOLKS_MAYBE_BOOL_UNSET) {
#line 1033 "persona-store-tests.c"
		EdsfPersonaStore* _tmp6_;
		FolksMaybeBool _tmp7_;
		FolksMaybeBool _tmp8_;
		GeeHashSet* _tmp9_;
		EdsfPersonaStore* _tmp10_;
		guint _tmp11_ = 0U;
		GQuark _tmp12_ = 0U;
#line 170 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp6_ = store;
#line 170 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp7_ = folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) _tmp6_);
#line 170 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp8_ = _tmp7_;
#line 170 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_vala_assert (_tmp8_ == FOLKS_MAYBE_BOOL_TRUE, "store.can_remove_personas == MaybeBool.TRUE");
#line 172 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp9_ = self->priv->_capabilities_received;
#line 172 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "can-remove-personas");
#line 174 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp10_ = store;
#line 174 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_signal_parse_name ("notify::can-remove-personas", G_TYPE_OBJECT, &_tmp11_, &_tmp12_, TRUE);
#line 174 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, _tmp12_, NULL, (GCallback) __persona_store_tests_can_remove_personas_cb_g_object_notify, self);
#line 1059 "persona-store-tests.c"
	}
#line 163 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1063 "persona-store-tests.c"
}


static void _persona_store_tests_check_can_alias_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	EdsfPersonaStore* _tmp2_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
#line 179 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 181 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 181 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 182 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 182 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 182 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 184 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = store;
#line 184 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _tmp3_, &_tmp4__length1);
#line 184 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 184 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5__length1 = _tmp4__length1;
#line 184 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (_vala_string_array_contains (_tmp5_, _tmp5__length1, "alias")) {
#line 1101 "persona-store-tests.c"
		GeeHashSet* _tmp6_;
#line 186 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp6_ = self->priv->_capabilities_received;
#line 186 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, "can-alias-personas");
#line 1107 "persona-store-tests.c"
	}
#line 179 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1111 "persona-store-tests.c"
}


static void _persona_store_tests_check_can_group_personas (PersonaStoreTests* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	EdsfPersonaStore* _tmp2_;
	EdsfPersonaStore* store;
	EdsfPersonaStore* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
#line 190 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_return_if_fail (s != NULL);
#line 192 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = s;
#line 192 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, EDSF_TYPE_PERSONA_STORE), "s is Edsf.PersonaStore");
#line 193 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = s;
#line 193 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, EDSF_TYPE_PERSONA_STORE, EdsfPersonaStore));
#line 193 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	store = _tmp2_;
#line 195 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = store;
#line 195 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp4_ = folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) _tmp3_, &_tmp4__length1);
#line 195 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5_ = _tmp4_;
#line 195 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp5__length1 = _tmp4__length1;
#line 195 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	if (_vala_string_array_contains (_tmp5_, _tmp5__length1, "groups")) {
#line 1149 "persona-store-tests.c"
		GeeHashSet* _tmp6_;
#line 197 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		_tmp6_ = self->priv->_capabilities_received;
#line 197 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, "can-group-personas");
#line 1155 "persona-store-tests.c"
	}
#line 190 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (store);
#line 1159 "persona-store-tests.c"
}


static void persona_store_tests_class_init (PersonaStoreTestsClass * klass) {
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	persona_store_tests_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_type_class_add_private (klass, sizeof (PersonaStoreTestsPrivate));
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	FOLKS_TEST_CASE_CLASS (klass)->set_up = persona_store_tests_real_set_up;
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = persona_store_tests_real_tear_down;
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_OBJECT_CLASS (klass)->finalize = persona_store_tests_finalize;
#line 1174 "persona-store-tests.c"
}


static void persona_store_tests_instance_init (PersonaStoreTests * self) {
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self->priv = PERSONA_STORE_TESTS_GET_PRIVATE (self);
#line 1181 "persona-store-tests.c"
}


static void persona_store_tests_finalize (GObject* obj) {
	PersonaStoreTests * self;
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PERSONA_STORE_TESTS, PersonaStoreTests);
#line 27 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_eds_test_backend_unref0 (self->priv->_eds_backend);
#line 28 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (self->priv->_capabilities_received);
#line 25 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	G_OBJECT_CLASS (persona_store_tests_parent_class)->finalize (obj);
#line 1195 "persona-store-tests.c"
}


GType persona_store_tests_get_type (void) {
	static volatile gsize persona_store_tests_type_id__volatile = 0;
	if (g_once_init_enter (&persona_store_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PersonaStoreTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) persona_store_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PersonaStoreTests), 0, (GInstanceInitFunc) persona_store_tests_instance_init, NULL };
		GType persona_store_tests_type_id;
		persona_store_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "PersonaStoreTests", &g_define_type_info, 0);
		g_once_init_leave (&persona_store_tests_type_id__volatile, persona_store_tests_type_id);
	}
	return persona_store_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	PersonaStoreTests* _tmp1_;
	PersonaStoreTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
#line 204 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_test_init (&args_length1, &args, NULL);
#line 206 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp0_ = g_test_get_root ();
#line 206 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	root = _tmp0_;
#line 207 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp1_ = persona_store_tests_new ();
#line 207 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp2_ = _tmp1_;
#line 207 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
#line 207 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_test_suite_add_suite (root, _tmp3_);
#line 207 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	_g_object_unref0 (_tmp2_);
#line 209 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_test_run ();
#line 211 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	result = 0;
#line 211 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return result;
#line 1240 "persona-store-tests.c"
}


int main (int argc, char ** argv) {
#line 202 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	g_type_init ();
#line 202 "/home/treitter/collabora/folks/tests/eds/persona-store-tests.vala"
	return _vala_main (argv, argc);
#line 1249 "persona-store-tests.c"
}



