// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_TLSCLIENTCONNECTION_H
#define _GIOMM_TLSCLIENTCONNECTION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2013 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GTlsClientConnectionInterface GTlsClientConnectionInterface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GTlsClientConnection GTlsClientConnection;
typedef struct _GTlsClientConnectionClass GTlsClientConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class TlsClientConnection_Class; } // namespace Gio
namespace Gio
{

class SocketConnectable;

/** TlsClientConnection - TLS client-side connection.
 * TlsClientConnection is the client-side subclass of TlsConnection,
 * representing a client-side TLS connection.
 * @newin{2,36}
 */

class TlsClientConnection : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TlsClientConnection CppObjectType;
  typedef TlsClientConnection_Class CppClassType;
  typedef GTlsClientConnection BaseObjectType;
  typedef GTlsClientConnectionInterface BaseClassType;

private:
  friend class TlsClientConnection_Class;
  static CppClassType tlsclientconnection_class_;

  // noncopyable
  TlsClientConnection(const TlsClientConnection&);
  TlsClientConnection& operator=(const TlsClientConnection&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  TlsClientConnection();
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit TlsClientConnection(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit TlsClientConnection(GTlsClientConnection* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TlsClientConnection();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GTlsClientConnection*       gobj()       { return reinterpret_cast<GTlsClientConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GTlsClientConnection* gobj() const { return reinterpret_cast<GTlsClientConnection*>(gobject_); }

private:


public:
  //TODO: This new function creates an IOStream, not a TlsClientConnection:
  // GIOStream* g_tls_client_connection_new(GIOStream *base_io_stream, GSocketConnectable *server_identity, GError **error);

  
  /** Sets @a conn's expected server identity, which is used both to tell
   * servers on virtual hosts which certificate to present, and also
   * to let @a conn know what name to look for in the certificate when
   * performing TLS_CERTIFICATE_BAD_IDENTITY validation, if enabled.
   * 
   * @newin{2,28}
   * @param identity A SocketConnectable describing the expected server identity.
   */
  void set_server_identity(const Glib::RefPtr<SocketConnectable>& identity);

  
  /** Gets @a conn's expected server identity
   * 
   * @newin{2,28}
   * @return A SocketConnectable describing the
   * expected server identity, or <tt>0</tt> if the expected identity is not
   * known.
   */
  Glib::RefPtr<SocketConnectable> get_server_identity();
  
  /** Gets @a conn's expected server identity
   * 
   * @newin{2,28}
   * @return A SocketConnectable describing the
   * expected server identity, or <tt>0</tt> if the expected identity is not
   * known.
   */
  Glib::RefPtr<const SocketConnectable> get_server_identity() const;

  
  /** Sets @a conn's validation flags, to override the default set of
   * checks performed when validating a server certificate. By default,
   * TLS_CERTIFICATE_VALIDATE_ALL is used.
   * 
   * @newin{2,28}
   * @param flags The TlsCertificateFlags to use.
   */
  void set_validation_flags(TlsCertificateFlags flags);
  
  /** Gets @a conn's validation flags
   * 
   * @newin{2,28}
   * @return The validation flags.
   */
  TlsCertificateFlags get_validation_flags() const;

  
  /** If @a use_ssl3 is <tt>true</tt>, this forces @a conn to use SSL 3.0 rather than
   * trying to properly negotiate the right version of TLS or SSL to use.
   * This can be used when talking to servers that do not implement the
   * fallbacks correctly and which will therefore fail to handshake with
   * a "modern" TLS handshake attempt.
   * 
   * @newin{2,28}
   * @param use_ssl3 Whether to use SSL 3.0.
   */
  void set_use_ssl3(bool use_ssl3);
  
  /** Gets whether @a conn will use SSL 3.0 rather than the
   * highest-supported version of TLS; see
   * g_tls_client_connection_set_use_ssl3().
   * 
   * @newin{2,28}
   * @return Whether @a conn will use SSL 3.0.
   */
  bool get_use_ssl3() const;

  //TODO: _WRAP_METHOD(GList* get_accepted_cas(), g_tls_client_connection_get_accepted_cas)

  //TODO: _WRAP_PROPERTY("accepted-cas", gpointer)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GSocketConnectable identifying the server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<SocketConnectable> > property_server_identity() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GSocketConnectable identifying the server.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SocketConnectable> > property_server_identity() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Use SSL 3.0 rather than trying to use TLS 1.x.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_use_ssl3() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Use SSL 3.0 rather than trying to use TLS 1.x.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_use_ssl3() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** What certificate validation to perform.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< TlsCertificateFlags > property_validation_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** What certificate validation to perform.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< TlsCertificateFlags > property_validation_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::TlsClientConnection
   */
  Glib::RefPtr<Gio::TlsClientConnection> wrap(GTlsClientConnection* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_TLSCLIENTCONNECTION_H */

