/* arrayqueue.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from arrayqueue.vala, do not modify */

/* arrayqueue.vala
 *
 * Copyright (C) 2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

#define GEE_TYPE_ABSTRACT_QUEUE (gee_abstract_queue_get_type ())
#define GEE_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueue))
#define GEE_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))
#define GEE_IS_ABSTRACT_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_IS_ABSTRACT_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_QUEUE))
#define GEE_ABSTRACT_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_QUEUE, GeeAbstractQueueClass))

typedef struct _GeeAbstractQueue GeeAbstractQueue;
typedef struct _GeeAbstractQueueClass GeeAbstractQueueClass;
typedef struct _GeeAbstractQueuePrivate GeeAbstractQueuePrivate;

#define GEE_TYPE_DEQUE (gee_deque_get_type ())
#define GEE_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_DEQUE, GeeDeque))
#define GEE_IS_DEQUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_DEQUE))
#define GEE_DEQUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_DEQUE, GeeDequeIface))

typedef struct _GeeDeque GeeDeque;
typedef struct _GeeDequeIface GeeDequeIface;

#define GEE_TYPE_ARRAY_QUEUE (gee_array_queue_get_type ())
#define GEE_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue))
#define GEE_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))
#define GEE_IS_ARRAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_QUEUE))
#define GEE_IS_ARRAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_QUEUE))
#define GEE_ARRAY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueueClass))

typedef struct _GeeArrayQueue GeeArrayQueue;
typedef struct _GeeArrayQueueClass GeeArrayQueueClass;
typedef struct _GeeArrayQueuePrivate GeeArrayQueuePrivate;

#define GEE_ARRAY_QUEUE_TYPE_ITERATOR (gee_array_queue_iterator_get_type ())
#define GEE_ARRAY_QUEUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator))
#define GEE_ARRAY_QUEUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))
#define GEE_ARRAY_QUEUE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_QUEUE_TYPE_ITERATOR))
#define GEE_ARRAY_QUEUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorClass))

typedef struct _GeeArrayQueueIterator GeeArrayQueueIterator;
typedef struct _GeeArrayQueueIteratorClass GeeArrayQueueIteratorClass;
typedef struct _GeeArrayQueueIteratorPrivate GeeArrayQueueIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};

struct _GeeAbstractQueue {
	GeeAbstractCollection parent_instance;
	GeeAbstractQueuePrivate * priv;
};

struct _GeeAbstractQueueClass {
	GeeAbstractCollectionClass parent_class;
	gpointer (*peek) (GeeAbstractQueue* self);
	gpointer (*poll) (GeeAbstractQueue* self);
	void (*reserved0) (GeeAbstractQueue* self);
	void (*reserved1) (GeeAbstractQueue* self);
	void (*reserved2) (GeeAbstractQueue* self);
	void (*reserved3) (GeeAbstractQueue* self);
	void (*reserved4) (GeeAbstractQueue* self);
	void (*reserved5) (GeeAbstractQueue* self);
	void (*reserved6) (GeeAbstractQueue* self);
	void (*reserved7) (GeeAbstractQueue* self);
	void (*reserved8) (GeeAbstractQueue* self);
	void (*reserved9) (GeeAbstractQueue* self);
	gint (*get_capacity) (GeeAbstractQueue* self);
	gint (*get_remaining_capacity) (GeeAbstractQueue* self);
	gboolean (*get_is_full) (GeeAbstractQueue* self);
};

struct _GeeDequeIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeDeque* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeDeque* self);
	GDestroyNotify (*get_g_destroy_func) (GeeDeque* self);
	gboolean (*offer_head) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_head) (GeeDeque* self);
	gpointer (*poll_head) (GeeDeque* self);
	gint (*drain_head) (GeeDeque* self, GeeCollection* recipient, gint amount);
	gboolean (*offer_tail) (GeeDeque* self, gconstpointer element);
	gpointer (*peek_tail) (GeeDeque* self);
	gpointer (*poll_tail) (GeeDeque* self);
	gint (*drain_tail) (GeeDeque* self, GeeCollection* recipient, gint amount);
};

struct _GeeArrayQueue {
	GeeAbstractQueue parent_instance;
	GeeArrayQueuePrivate * priv;
};

struct _GeeArrayQueueClass {
	GeeAbstractQueueClass parent_class;
};

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeArrayQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _start;
	gint _length;
	gint _stamp;
};

struct _GeeArrayQueueIterator {
	GObject parent_instance;
	GeeArrayQueueIteratorPrivate * priv;
};

struct _GeeArrayQueueIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayQueueIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayQueue* _queue;
	gint _stamp;
	gint _offset;
	gboolean _removed;
};


static gpointer gee_array_queue_parent_class = NULL;
static gpointer gee_array_queue_iterator_parent_class = NULL;
static GeeTraversableIface* gee_array_queue_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_array_queue_iterator_gee_iterator_parent_iface = NULL;
static GeeDequeIface* gee_array_queue_gee_deque_parent_iface = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
GType gee_abstract_queue_get_type (void) G_GNUC_CONST;
GType gee_deque_get_type (void) G_GNUC_CONST;
GType gee_array_queue_get_type (void) G_GNUC_CONST;
#define GEE_ARRAY_QUEUE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_QUEUE, GeeArrayQueuePrivate))
enum  {
	GEE_ARRAY_QUEUE_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_G_TYPE,
	GEE_ARRAY_QUEUE_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_SIZE,
	GEE_ARRAY_QUEUE_IS_EMPTY,
	GEE_ARRAY_QUEUE_READ_ONLY,
	GEE_ARRAY_QUEUE_CAPACITY,
	GEE_ARRAY_QUEUE_REMAINING_CAPACITY,
	GEE_ARRAY_QUEUE_IS_FULL
};
GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractQueue* gee_abstract_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target);
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base);
static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue);
static GType gee_array_queue_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_array_queue_real_add (GeeAbstractCollection* base, gconstpointer element);
gboolean gee_deque_offer_tail (GeeDeque* self, gconstpointer element);
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item);
static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item);
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index);
static void gee_array_queue_real_clear (GeeAbstractCollection* base);
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base);
gpointer gee_deque_peek_head (GeeDeque* self);
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base);
gpointer gee_deque_poll_head (GeeDeque* self);
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element);
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self);
static gpointer gee_array_queue_real_peek_head (GeeDeque* base);
static gpointer gee_array_queue_real_poll_head (GeeDeque* base);
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount);
gint gee_queue_drain (GeeQueue* self, GeeCollection* recipient, gint amount);
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element);
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base);
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base);
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount);
gpointer gee_deque_poll_tail (GeeDeque* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target);
gboolean gee_array_queue_get_is_empty (GeeArrayQueue* self);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
#define GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIteratorPrivate))
enum  {
	GEE_ARRAY_QUEUE_ITERATOR_DUMMY_PROPERTY,
	GEE_ARRAY_QUEUE_ITERATOR_G_TYPE,
	GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC,
	GEE_ARRAY_QUEUE_ITERATOR_VALID,
	GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY
};
static gboolean gee_array_queue_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base);
static gpointer gee_array_queue_iterator_real_get (GeeIterator* base);
static void gee_array_queue_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void gee_array_queue_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_array_queue_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_queue_get_capacity (GeeAbstractQueue* self);
gint gee_abstract_queue_get_remaining_capacity (GeeAbstractQueue* self);
gboolean gee_abstract_queue_get_is_full (GeeAbstractQueue* self);
static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


/**
 * Constructs a new, empty array queue.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
GeeArrayQueue* gee_array_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeArrayQueue * self = NULL;
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
	GeeEqualDataFunc _tmp4_;
	void* _tmp4__target;
	gpointer* _tmp5_ = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) gee_abstract_queue_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_type = g_type;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = equal_func;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = equal_func_target;
#line 44 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp0_ == NULL) {
#line 461 "arrayqueue.c"
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_ = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target_destroy_notify = NULL;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func = _tmp3_;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target = _tmp1_;
#line 45 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		equal_func_target_destroy_notify = _tmp2_;
#line 481 "arrayqueue.c"
	}
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = equal_func;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__target = equal_func_target;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_set_equal_func (self, _tmp4_, _tmp4__target);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = g_new0 (gpointer, 10);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) g_destroy_func), NULL);
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = _tmp5_;
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items_length1 = 10;
#line 48 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->__items_size_ = self->priv->_items_length1;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func_target = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	equal_func_target_destroy_notify = NULL;
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self;
#line 509 "arrayqueue.c"
}


GeeArrayQueue* gee_array_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
#line 43 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return gee_array_queue_construct (GEE_TYPE_ARRAY_QUEUE, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
#line 516 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_array_queue_real_iterator (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	GeeIterator* result = NULL;
	GeeArrayQueueIterator* _tmp0_;
#line 84 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_array_queue_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = (GeeIterator*) _tmp0_;
#line 85 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 535 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_add (GeeAbstractCollection* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 91 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = element;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = gee_deque_offer_tail ((GeeDeque*) self, _tmp0_);
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 557 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gint _tmp1_ = 0;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = item;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = gee_array_queue_find_index (self, _tmp0_);
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_ != (-1);
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 579 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gconstpointer _tmp1_;
	gint _tmp2_ = 0;
	gint index;
	gint _tmp3_;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = item;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = gee_array_queue_find_index (self, _tmp1_);
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	index = _tmp2_;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = index;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp3_ == (-1)) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = FALSE;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 614 "arrayqueue.c"
	} else {
		gint _tmp4_;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = index;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		gee_array_queue_remove_at (self, _tmp4_);
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = TRUE;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 625 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_real_clear (GeeAbstractCollection* base) {
	GeeArrayQueue * self;
	gint _tmp0_;
	gint _tmp11_;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 643 "arrayqueue.c"
	{
		gint i;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = 0;
#line 648 "arrayqueue.c"
		{
			gboolean _tmp1_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 655 "arrayqueue.c"
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				gpointer* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				gint _tmp8_;
				gpointer* _tmp9_;
				gint _tmp9__length1;
				gpointer _tmp10_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp2_ = _tmp1_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp2_) {
#line 670 "arrayqueue.c"
					gint _tmp3_;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp3_ = i;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp3_ + 1;
#line 676 "arrayqueue.c"
				}
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp1_ = FALSE;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = i;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5_ = self->priv->_length;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp4_ < _tmp5_)) {
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 688 "arrayqueue.c"
				}
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_ = self->priv->_items;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6__length1 = self->priv->_items_length1;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = self->priv->_start;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = i;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9_ = self->priv->_items;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9__length1 = self->priv->_items_length1;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				((_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = (self->priv->g_destroy_func (_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1]), NULL));
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1] = NULL;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = _tmp6_[(_tmp7_ + _tmp8_) % _tmp9__length1];
#line 708 "arrayqueue.c"
			}
		}
	}
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = 0;
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11_ = self->priv->_length;
#line 124 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = _tmp11_;
#line 718 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_deque_peek_head ((GeeDeque*) self);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 737 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll (GeeAbstractQueue* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer _tmp0_ = NULL;
#line 137 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = gee_deque_poll_head ((GeeDeque*) self);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 756 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_head (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gpointer* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
	gpointer _tmp8_;
	gint _tmp9_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_grow_if_needed (self);
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_items;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2__length1 = self->priv->_items_length1;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = ((_tmp0__length1 + _tmp1_) - 1) % _tmp2__length1;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_length;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = _tmp3_ + 1;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_items;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__length1 = self->priv->_items_length1;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_start;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = element;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = ((_tmp6_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((_tmp4_[_tmp5_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp4_[_tmp5_] = (self->priv->g_destroy_func (_tmp4_[_tmp5_]), NULL));
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_[_tmp5_] = _tmp7_;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp4_[_tmp5_];
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_stamp;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp9_ + 1;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 823 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gconstpointer _tmp2_;
	gpointer _tmp3_;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = _tmp0_[_tmp1_];
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = ((_tmp2_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp2_) : ((gpointer) _tmp2_);
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp3_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 854 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_head (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ == 0) {
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = 0;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = NULL;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 882 "arrayqueue.c"
	} else {
		gint _tmp2_;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gpointer _tmp5_;
		gpointer _result_;
		gint _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		gpointer _tmp8_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_length;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp2_ - 1;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = self->priv->_items;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3__length1 = self->priv->_items_length1;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_start;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = _tmp3_[_tmp4_];
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_[_tmp4_] = NULL;
#line 170 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_result_ = _tmp5_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_start;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_items;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7__length1 = self->priv->_items_length1;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = (_tmp6_ + 1) % _tmp7__length1;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _result_;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_result_ = NULL;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = _tmp8_;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		((_result_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_result_ = (self->priv->g_destroy_func (_result_), NULL));
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 928 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_head (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_ = 0;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 179 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = recipient;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = amount;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = gee_queue_drain ((GeeQueue*) self, _tmp0_, _tmp1_);
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp2_;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 956 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_array_queue_real_offer_tail (GeeDeque* base, gconstpointer element) {
	GeeArrayQueue * self;
	gboolean result = FALSE;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gconstpointer _tmp4_;
	gpointer _tmp5_;
	gpointer _tmp6_;
	gint _tmp7_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_grow_if_needed (self);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_length;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = _tmp2_ + 1;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_items;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3__length1 = self->priv->_items_length1;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = element;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = (self->priv->g_destroy_func (_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1]), NULL));
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1] = _tmp5_;
#line 188 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = _tmp0_[(_tmp1_ + _tmp2_) % _tmp3__length1];
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_stamp;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp7_ + 1;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1012 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_peek_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	gint _tmp3_;
	gpointer* _tmp4_;
	gint _tmp4__length1;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_items;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1__length1 = self->priv->_items_length1;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_start;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_length;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_items;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4__length1 = self->priv->_items_length1;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp0_[(((_tmp1__length1 + _tmp2_) + _tmp3_) - 1) % _tmp4__length1];
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp6_;
#line 197 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1058 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static gpointer gee_array_queue_real_poll_tail (GeeDeque* base) {
	GeeArrayQueue * self;
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
#line 203 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_stamp;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp0_ + 1;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ == 0) {
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = 0;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = NULL;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1086 "arrayqueue.c"
	} else {
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gpointer* _tmp7_;
		gint _tmp7__length1;
		gpointer _tmp8_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_start;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = self->priv->_length;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp5_ - 1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_length;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_items;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7__length1 = self->priv->_items_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1];
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_[((_tmp3__length1 + _tmp4_) + _tmp6_) % _tmp7__length1] = NULL;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = _tmp8_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1126 "arrayqueue.c"
	}
}


/**
 * {@inheritDoc}
 */
static gint gee_array_queue_real_drain_tail (GeeDeque* base, GeeCollection* recipient, gint amount) {
	GeeArrayQueue * self;
	gint result = 0;
	gpointer item;
	gint drained;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	item = NULL;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	drained = 0;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	while (TRUE) {
#line 1149 "arrayqueue.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		gboolean _tmp5_;
		gboolean _tmp8_;
		GeeCollection* _tmp9_;
		gconstpointer _tmp10_;
		gint _tmp11_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = amount;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp2_ == (-1)) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 1164 "arrayqueue.c"
		} else {
			gint _tmp3_;
			gint _tmp4_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp3_ = amount;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			amount = _tmp3_ - 1;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp4_ = amount;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = _tmp4_ >= 0;
#line 1176 "arrayqueue.c"
		}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = _tmp1_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp5_) {
#line 1182 "arrayqueue.c"
			gpointer _tmp6_ = NULL;
			gconstpointer _tmp7_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp6_ = gee_deque_poll_tail ((GeeDeque*) self);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			item = _tmp6_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp7_ = item;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp0_ = _tmp7_ != NULL;
#line 1195 "arrayqueue.c"
		} else {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp0_ = FALSE;
#line 1199 "arrayqueue.c"
		}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp0_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (!_tmp8_) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			break;
#line 1207 "arrayqueue.c"
		}
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp9_ = recipient;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp10_ = item;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		gee_collection_add (_tmp9_, _tmp10_);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp11_ = drained;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		drained = _tmp11_ + 1;
#line 1219 "arrayqueue.c"
	}
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = drained;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1227 "arrayqueue.c"
}


/**
 * {@inheritDoc}
 */
static void gee_array_queue_grow_if_needed (GeeArrayQueue* self) {
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_length;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp0__length1 < (_tmp1_ + 1)) {
#line 1248 "arrayqueue.c"
		gpointer* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_items;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2__length1 = self->priv->_items_length1;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp3_ = 2 * _tmp2__length1;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_items = g_renew (gpointer, self->priv->_items, 2 * _tmp2__length1);
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		(_tmp3_ > self->priv->_items_length1) ? memset (self->priv->_items + self->priv->_items_length1, 0, sizeof (gpointer) * (_tmp3_ - self->priv->_items_length1)) : NULL;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_items_length1 = _tmp3_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->__items_size_ = _tmp3_;
#line 1266 "arrayqueue.c"
		{
			gint i;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			i = 0;
#line 1271 "arrayqueue.c"
			{
				gboolean _tmp4_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = TRUE;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				while (TRUE) {
#line 1278 "arrayqueue.c"
					gboolean _tmp5_;
					gint _tmp7_;
					gint _tmp8_;
					gpointer* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					gint _tmp11_;
					gpointer* _tmp12_;
					gint _tmp12__length1;
					gint _tmp13_;
					gpointer _tmp14_;
					gpointer _tmp15_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp5_ = _tmp4_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					if (!_tmp5_) {
#line 1295 "arrayqueue.c"
						gint _tmp6_;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						_tmp6_ = i;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						i = _tmp6_ + 1;
#line 1301 "arrayqueue.c"
					}
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp4_ = FALSE;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp7_ = i;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp8_ = self->priv->_start;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					if (!(_tmp7_ < _tmp8_)) {
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
						break;
#line 1313 "arrayqueue.c"
					}
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_ = self->priv->_items;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9__length1 = self->priv->_items_length1;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp10_ = self->priv->_length;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp11_ = i;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12_ = self->priv->_items;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12__length1 = self->priv->_items_length1;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp13_ = i;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp12_[_tmp13_] = NULL;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					((_tmp9_[_tmp10_ + _tmp11_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_[_tmp10_ + _tmp11_] = (self->priv->g_destroy_func (_tmp9_[_tmp10_ + _tmp11_]), NULL));
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_[_tmp10_ + _tmp11_] = _tmp14_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp15_ = _tmp9_[_tmp10_ + _tmp11_];
#line 1339 "arrayqueue.c"
				}
			}
		}
	}
}


static gint gee_array_queue_find_index (GeeArrayQueue* self, gconstpointer item) {
	gint result = 0;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1351 "arrayqueue.c"
	{
		gint _tmp0_;
		gint i;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = self->priv->_start;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = _tmp0_;
#line 1359 "arrayqueue.c"
		{
			gboolean _tmp1_;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp1_ = TRUE;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 1366 "arrayqueue.c"
				gboolean _tmp2_;
				gint _tmp4_;
				gpointer* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_ = 0;
				GeeEqualDataFunc _tmp9_;
				void* _tmp9__target;
				GeeEqualDataFunc _tmp10_;
				void* _tmp10__target;
				gconstpointer _tmp11_;
				gpointer* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gconstpointer _tmp14_;
				gboolean _tmp15_ = FALSE;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp2_ = _tmp1_;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp2_) {
#line 1388 "arrayqueue.c"
					gint _tmp3_;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp3_ = i;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp3_ + 1;
#line 1394 "arrayqueue.c"
				}
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp1_ = FALSE;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp4_ = i;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5_ = self->priv->_items;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp5__length1 = self->priv->_items_length1;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp6_ = self->priv->_start;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = self->priv->_length;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = MIN (_tmp5__length1, _tmp6_ + _tmp7_);
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 1414 "arrayqueue.c"
				}
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp9_ = gee_array_queue_get_equal_func (self, &_tmp9__target);
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = _tmp9_;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10__target = _tmp9__target;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp11_ = item;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12_ = self->priv->_items;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12__length1 = self->priv->_items_length1;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13_ = i;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp14_ = _tmp12_[_tmp13_];
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15_ = _tmp10_ (_tmp11_, _tmp14_, _tmp10__target);
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (_tmp15_) {
#line 245 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = i;
#line 245 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 1440 "arrayqueue.c"
				}
			}
		}
	}
	{
		gint i;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = 0;
#line 1449 "arrayqueue.c"
		{
			gboolean _tmp16_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_ = TRUE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 1456 "arrayqueue.c"
				gboolean _tmp17_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gpointer* _tmp22_;
				gint _tmp22__length1;
				GeeEqualDataFunc _tmp23_;
				void* _tmp23__target;
				GeeEqualDataFunc _tmp24_;
				void* _tmp24__target;
				gconstpointer _tmp25_;
				gpointer* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gconstpointer _tmp28_;
				gboolean _tmp29_ = FALSE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp17_ = _tmp16_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp17_) {
#line 1477 "arrayqueue.c"
					gint _tmp18_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp18_ = i;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp18_ + 1;
#line 1483 "arrayqueue.c"
				}
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp16_ = FALSE;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp19_ = i;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20_ = self->priv->_start;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp21_ = self->priv->_length;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22_ = self->priv->_items;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22__length1 = self->priv->_items_length1;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp19_ < ((_tmp20_ + _tmp21_) - _tmp22__length1))) {
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 1501 "arrayqueue.c"
				}
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp23_ = gee_array_queue_get_equal_func (self, &_tmp23__target);
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp24_ = _tmp23_;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp24__target = _tmp23__target;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp25_ = item;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp26_ = self->priv->_items;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp26__length1 = self->priv->_items_length1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp27_ = i;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp28_ = _tmp26_[_tmp27_];
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp29_ = _tmp24_ (_tmp25_, _tmp28_, _tmp24__target);
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (_tmp29_) {
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = i;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 1527 "arrayqueue.c"
				}
			}
		}
	}
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = -1;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1536 "arrayqueue.c"
}


static void gee_array_queue_remove_at (GeeArrayQueue* self, gint index) {
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint end;
	gint _tmp4_;
	gint _tmp5_;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_items;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__length1 = self->priv->_items_length1;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_start;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_length;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_items;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3__length1 = self->priv->_items_length1;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	end = ((((_tmp0__length1 + _tmp1_) + _tmp2_) - 1) % _tmp3__length1) + 1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = index;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_start;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp4_ == _tmp5_) {
#line 1572 "arrayqueue.c"
		gpointer* _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_;
		gpointer _tmp8_;
		gint _tmp9_;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_items;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6__length1 = self->priv->_items_length1;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp7_ = self->priv->_start;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_start = _tmp7_ + 1;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		((_tmp6_[_tmp7_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp6_[_tmp7_] = (self->priv->g_destroy_func (_tmp6_[_tmp7_]), NULL));
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_[_tmp7_] = NULL;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp8_ = _tmp6_[_tmp7_];
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp9_ = self->priv->_length;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_length = _tmp9_ - 1;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return;
#line 1598 "arrayqueue.c"
	} else {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gboolean _tmp15_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp11_ = index;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp12_ = self->priv->_start;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp11_ > _tmp12_) {
#line 1610 "arrayqueue.c"
			gint _tmp13_;
			gint _tmp14_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp13_ = end;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp14_ = self->priv->_start;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp10_ = _tmp13_ <= _tmp14_;
#line 1619 "arrayqueue.c"
		} else {
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp10_ = FALSE;
#line 1623 "arrayqueue.c"
		}
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp15_ = _tmp10_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		if (_tmp15_) {
#line 1629 "arrayqueue.c"
			gpointer* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			gpointer _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gpointer* _tmp21_;
			gint _tmp21__length1;
			gpointer* _tmp22_;
			gint _tmp22__length1;
			gpointer* _tmp23_;
			gint _tmp23__length1;
			gpointer* _tmp24_;
			gint _tmp24__length1;
			gpointer _tmp25_;
			gpointer _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_ = self->priv->_items;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16__length1 = self->priv->_items_length1;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp17_ = index;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp16_[_tmp17_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp16_[_tmp17_] = (self->priv->g_destroy_func (_tmp16_[_tmp17_]), NULL));
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp16_[_tmp17_] = NULL;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp18_ = _tmp16_[_tmp17_];
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp19_ = index;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp20_ = index;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp21_ = self->priv->_items;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp21__length1 = self->priv->_items_length1;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp19_ + 1, _tmp20_, _tmp21__length1 - 1);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22_ = self->priv->_items;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22__length1 = self->priv->_items_length1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp23_ = self->priv->_items;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp23__length1 = self->priv->_items_length1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24_ = self->priv->_items;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24__length1 = self->priv->_items_length1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp25_ = _tmp24_[0];
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp24_[0] = NULL;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp22_[_tmp23__length1 - 1] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp22_[_tmp23__length1 - 1] = (self->priv->g_destroy_func (_tmp22_[_tmp23__length1 - 1]), NULL));
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp22_[_tmp23__length1 - 1] = _tmp25_;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp26_ = _tmp22_[_tmp23__length1 - 1];
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp27_ = end;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), 1, 0, _tmp27_ - 1);
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp28_ = self->priv->_length;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			self->priv->_length = _tmp28_ - 1;
#line 1700 "arrayqueue.c"
		} else {
			gpointer* _tmp29_;
			gint _tmp29__length1;
			gint _tmp30_;
			gpointer _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29_ = self->priv->_items;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29__length1 = self->priv->_items_length1;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp30_ = index;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			((_tmp29_[_tmp30_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp29_[_tmp30_] = (self->priv->g_destroy_func (_tmp29_[_tmp30_]), NULL));
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp29_[_tmp30_] = NULL;
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp31_ = _tmp29_[_tmp30_];
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp32_ = index;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp33_ = index;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp34_ = end;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp35_ = index;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_vala_array_move (self->priv->_items, sizeof (gpointer), _tmp32_ + 1, _tmp33_, _tmp34_ - (_tmp35_ + 1));
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp36_ = self->priv->_length;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			self->priv->_length = _tmp36_ - 1;
#line 1737 "arrayqueue.c"
		}
	}
}


GeeEqualDataFunc gee_array_queue_get_equal_func (GeeArrayQueue* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
	GeeEqualDataFunc _tmp1_;
	void* _tmp1__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_equal_func;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = self->priv->_equal_func_target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1__target = _tmp0__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	*result_target = _tmp1__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp1_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1765 "arrayqueue.c"
}


static void gee_array_queue_set_equal_func (GeeArrayQueue* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_;
	void* _tmp0__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = value;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0__target = value_target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = _tmp0__target;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 1792 "arrayqueue.c"
}


static gint gee_array_queue_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeArrayQueue* self;
	gint _tmp0_;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_length;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_;
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1808 "arrayqueue.c"
}


gboolean gee_array_queue_get_is_empty (GeeArrayQueue* self) {
	gboolean result;
	gint _tmp0_;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_length;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp0_ == 0;
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1823 "arrayqueue.c"
}


static gboolean gee_array_queue_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeArrayQueue* self;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 64 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1836 "arrayqueue.c"
}


static gint gee_array_queue_real_get_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 69 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1849 "arrayqueue.c"
}


static gint gee_array_queue_real_get_remaining_capacity (GeeAbstractQueue* base) {
	gint result;
	GeeArrayQueue* self;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = GEE_QUEUE_UNBOUNDED_CAPACITY;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1862 "arrayqueue.c"
}


static gboolean gee_array_queue_real_get_is_full (GeeAbstractQueue* base) {
	gboolean result;
	GeeArrayQueue* self;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueue*) base;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 79 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 1875 "arrayqueue.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self ? g_object_ref (self) : NULL;
#line 1882 "arrayqueue.c"
}


static GeeArrayQueueIterator* gee_array_queue_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
	GeeArrayQueueIterator * self = NULL;
	GeeArrayQueue* _tmp0_;
	GeeArrayQueue* _tmp1_;
	GeeArrayQueue* _tmp2_;
	gint _tmp3_;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_return_val_if_fail (queue != NULL, NULL);
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) g_object_new (object_type, NULL);
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_type = g_type;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_dup_func = g_dup_func;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = queue;
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_g_object_unref0 (self->priv->_queue);
#line 277 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_queue = _tmp1_;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_queue;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = _tmp2_->priv->_stamp;
#line 278 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp3_;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self;
#line 1918 "arrayqueue.c"
}


static GeeArrayQueueIterator* gee_array_queue_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayQueue* queue) {
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return gee_array_queue_iterator_construct (GEE_ARRAY_QUEUE_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, queue);
#line 1925 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
#line 281 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
#line 283 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp3_) {
#line 1950 "arrayqueue.c"
		gint _tmp4_;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp4_ = self->priv->_offset;
#line 284 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_offset = _tmp4_ + 1;
#line 285 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_removed = FALSE;
#line 286 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = TRUE;
#line 286 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1962 "arrayqueue.c"
	} else {
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		result = FALSE;
#line 288 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		return result;
#line 1968 "arrayqueue.c"
	}
}


static gboolean gee_array_queue_iterator_real_has_next (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayQueue* _tmp4_;
	gint _tmp5_;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_offset;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_queue;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp4_->priv->_length;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = (_tmp3_ + 1) < _tmp5_;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2002 "arrayqueue.c"
}


static gpointer gee_array_queue_iterator_real_get (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	gpointer result = NULL;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	GeeArrayQueue* _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	GeeArrayQueue* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayQueue* _tmp10_;
	gpointer* _tmp11_;
	gint _tmp11__length1;
	gconstpointer _tmp12_;
	gpointer _tmp13_;
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 298 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_offset;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp3_ != (-1), "_offset != -1");
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_removed;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (!_tmp4_, "!_removed");
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = self->priv->_queue;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = _tmp5_->priv->_items;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6__length1 = _tmp5_->priv->_items_length1;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_queue;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp7_->priv->_start;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_offset;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp10_ = self->priv->_queue;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11_ = _tmp10_->priv->_items;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp11__length1 = _tmp10_->priv->_items_length1;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp12_ = _tmp6_[(_tmp8_ + _tmp9_) % _tmp11__length1];
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp13_ = ((_tmp12_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp12_) : ((gpointer) _tmp12_);
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp13_;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2069 "arrayqueue.c"
}


static void gee_array_queue_iterator_real_remove (GeeIterator* base) {
	GeeArrayQueueIterator * self;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayQueue* _tmp3_;
	GeeArrayQueue* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeArrayQueue* _tmp7_;
	gpointer* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_->priv->_stamp = _tmp1_ + 1;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = _tmp2_ + 1;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp++ == _stamp++");
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = self->priv->_queue;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = self->priv->_queue;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp5_ = _tmp4_->priv->_start;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp6_ = self->priv->_offset;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp7_ = self->priv->_queue;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8_ = _tmp7_->priv->_items;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp8__length1 = _tmp7_->priv->_items_length1;
#line 306 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_remove_at (_tmp3_, (_tmp5_ + _tmp6_) % _tmp8__length1);
#line 307 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp9_ = self->priv->_offset;
#line 307 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_offset = _tmp9_ - 1;
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_removed = TRUE;
#line 2122 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeArrayQueueIterator * self;
	gboolean result = FALSE;
	GeeArrayQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 315 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp0_ = self->priv->_queue;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = _tmp0_->priv->_stamp;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp2_ = self->priv->_stamp;
#line 316 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_vala_assert (_tmp1_ == _tmp2_, "_queue._stamp == _stamp");
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = gee_iterator_get_valid ((GeeIterator*) self);
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp4_ = _tmp3_;
#line 317 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (!_tmp4_) {
#line 2150 "arrayqueue.c"
		gint _tmp5_;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp5_ = self->priv->_offset;
#line 318 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_offset = _tmp5_ + 1;
#line 319 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->_removed = FALSE;
#line 2158 "arrayqueue.c"
	}
	{
		gint _tmp6_;
		gint i;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp6_ = self->priv->_offset;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		i = _tmp6_;
#line 2167 "arrayqueue.c"
		{
			gboolean _tmp7_;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			_tmp7_ = TRUE;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
			while (TRUE) {
#line 2174 "arrayqueue.c"
				gboolean _tmp8_;
				gint _tmp10_;
				GeeArrayQueue* _tmp11_;
				gint _tmp12_;
				GeeForallFunc _tmp13_;
				void* _tmp13__target;
				GeeArrayQueue* _tmp14_;
				gpointer* _tmp15_;
				gint _tmp15__length1;
				GeeArrayQueue* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				GeeArrayQueue* _tmp19_;
				gpointer* _tmp20_;
				gint _tmp20__length1;
				gconstpointer _tmp21_;
				gpointer _tmp22_;
				gboolean _tmp23_ = FALSE;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp8_ = _tmp7_;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp8_) {
#line 2197 "arrayqueue.c"
					gint _tmp9_;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp9_ = i;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					i = _tmp9_ + 1;
#line 2203 "arrayqueue.c"
				}
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp7_ = FALSE;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp10_ = i;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp11_ = self->priv->_queue;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp12_ = _tmp11_->priv->_length;
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!(_tmp10_ < _tmp12_)) {
#line 321 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					break;
#line 2217 "arrayqueue.c"
				}
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13_ = f;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp13__target = f_target;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp14_ = self->priv->_queue;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15_ = _tmp14_->priv->_items;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp15__length1 = _tmp14_->priv->_items_length1;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp16_ = self->priv->_queue;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp17_ = _tmp16_->priv->_start;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp18_ = i;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp19_ = self->priv->_queue;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20_ = _tmp19_->priv->_items;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp20__length1 = _tmp19_->priv->_items_length1;
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp21_ = _tmp15_[(_tmp17_ + _tmp18_) % _tmp20__length1];
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp22_ = ((_tmp21_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp21_) : ((gpointer) _tmp21_);
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				_tmp23_ = _tmp13_ (_tmp22_, _tmp13__target);
#line 322 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
				if (!_tmp23_) {
#line 2249 "arrayqueue.c"
					gint _tmp24_;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					_tmp24_ = i;
#line 323 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					self->priv->_offset = _tmp24_;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					result = FALSE;
#line 324 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
					return result;
#line 2259 "arrayqueue.c"
				}
			}
		}
	}
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = TRUE;
#line 327 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2268 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp1_ = self->priv->_offset;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	if (_tmp1_ != (-1)) {
#line 2284 "arrayqueue.c"
		gboolean _tmp2_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp2_ = self->priv->_removed;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = !_tmp2_;
#line 2290 "arrayqueue.c"
	} else {
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		_tmp0_ = FALSE;
#line 2294 "arrayqueue.c"
	}
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_tmp3_ = _tmp0_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = _tmp3_;
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2302 "arrayqueue.c"
}


static gboolean gee_array_queue_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeArrayQueueIterator* self;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = (GeeArrayQueueIterator*) base;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	result = FALSE;
#line 313 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return result;
#line 2315 "arrayqueue.c"
}


static void gee_array_queue_iterator_class_init (GeeArrayQueueIteratorClass * klass) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_parent_class = g_type_class_peek_parent (klass);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_type_class_add_private (klass, sizeof (GeeArrayQueueIteratorPrivate));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_iterator_get_property;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_iterator_set_property;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_iterator_finalize;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2340 "arrayqueue.c"
}


static GType gee_array_queue_iterator_gee_traversable_get_g_type (GeeArrayQueueIterator* self) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_type;
#line 2347 "arrayqueue.c"
}


static GBoxedCopyFunc gee_array_queue_iterator_gee_traversable_get_g_dup_func (GeeArrayQueueIterator* self) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_dup_func;
#line 2354 "arrayqueue.c"
}


static GDestroyNotify gee_array_queue_iterator_gee_traversable_get_g_destroy_func (GeeArrayQueueIterator* self) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_destroy_func;
#line 2361 "arrayqueue.c"
}


static void gee_array_queue_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_array_queue_iterator_real_foreach;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_type;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_dup_func;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_array_queue_iterator_gee_traversable_get_g_destroy_func;
#line 2376 "arrayqueue.c"
}


static void gee_array_queue_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_next;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_array_queue_iterator_real_has_next;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get = (gpointer (*)(GeeIterator*)) gee_array_queue_iterator_real_get;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->remove = (void (*)(GeeIterator*)) gee_array_queue_iterator_real_remove;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_valid = gee_array_queue_iterator_real_get_valid;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_read_only = gee_array_queue_iterator_real_get_read_only;
#line 2395 "arrayqueue.c"
}


static void gee_array_queue_iterator_instance_init (GeeArrayQueueIterator * self) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv = GEE_ARRAY_QUEUE_ITERATOR_GET_PRIVATE (self);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_offset = -1;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_removed = FALSE;
#line 2406 "arrayqueue.c"
}


static void gee_array_queue_iterator_finalize (GObject* obj) {
	GeeArrayQueueIterator * self;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 330 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	_g_object_unref0 (self->priv->_queue);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (gee_array_queue_iterator_parent_class)->finalize (obj);
#line 2418 "arrayqueue.c"
}


static GType gee_array_queue_iterator_get_type (void) {
	static volatile gsize gee_array_queue_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueueIterator), 0, (GInstanceInitFunc) gee_array_queue_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_queue_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_iterator_type_id;
		gee_array_queue_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayQueueIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_array_queue_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_array_queue_iterator_type_id__volatile, gee_array_queue_iterator_type_id);
	}
	return gee_array_queue_iterator_type_id__volatile;
}


static void _vala_gee_array_queue_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_VALID:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_READ_ONLY:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2455 "arrayqueue.c"
		default:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2461 "arrayqueue.c"
	}
}


static void _vala_gee_array_queue_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueueIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_ARRAY_QUEUE_TYPE_ITERATOR, GeeArrayQueueIterator);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_TYPE:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_DUP_FUNC:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_ITERATOR_G_DESTROY_FUNC:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2489 "arrayqueue.c"
		default:
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 275 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2495 "arrayqueue.c"
	}
}


static void gee_array_queue_class_init (GeeArrayQueueClass * klass) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_parent_class = g_type_class_peek_parent (klass);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_type_class_add_private (klass, sizeof (GeeArrayQueuePrivate));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_array_queue_real_iterator;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_array_queue_real_add;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_array_queue_real_contains;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_array_queue_real_remove;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_array_queue_real_clear;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->peek = gee_array_queue_real_peek;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->poll = gee_array_queue_real_poll;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_queue_real_get_size;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_array_queue_real_get_read_only;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_capacity = gee_array_queue_real_get_capacity;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_remaining_capacity = gee_array_queue_real_get_remaining_capacity;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	GEE_ABSTRACT_QUEUE_CLASS (klass)->get_is_full = gee_array_queue_real_get_is_full;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_array_queue_get_property;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_array_queue_set_property;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_array_queue_finalize;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 2541 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2549 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2555 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_CAPACITY, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2561 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_REMAINING_CAPACITY, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2567 "arrayqueue.c"
	/**
	 * {@inheritDoc}
	 */
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_QUEUE_IS_FULL, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2573 "arrayqueue.c"
}


static GType gee_array_queue_gee_deque_get_g_type (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_type;
#line 2580 "arrayqueue.c"
}


static GBoxedCopyFunc gee_array_queue_gee_deque_get_g_dup_func (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_dup_func;
#line 2587 "arrayqueue.c"
}


static GDestroyNotify gee_array_queue_gee_deque_get_g_destroy_func (GeeArrayQueue* self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	return self->priv->g_destroy_func;
#line 2594 "arrayqueue.c"
}


static void gee_array_queue_gee_deque_interface_init (GeeDequeIface * iface) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	gee_array_queue_gee_deque_parent_iface = g_type_interface_peek_parent (iface);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->offer_head = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->peek_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->poll_head = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->drain_head = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_head;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->offer_tail = (gboolean (*)(GeeDeque*, gconstpointer)) gee_array_queue_real_offer_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->peek_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_peek_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->poll_tail = (gpointer (*)(GeeDeque*)) gee_array_queue_real_poll_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->drain_tail = (gint (*)(GeeDeque*, GeeCollection*, gint)) gee_array_queue_real_drain_tail;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_type = (GType(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_type;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_dup_func;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeDeque*)) gee_array_queue_gee_deque_get_g_destroy_func;
#line 2623 "arrayqueue.c"
}


static void gee_array_queue_instance_init (GeeArrayQueue * self) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv = GEE_ARRAY_QUEUE_GET_PRIVATE (self);
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_start = 0;
#line 338 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_length = 0;
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_stamp = 0;
#line 2636 "arrayqueue.c"
}


static void gee_array_queue_finalize (GObject* obj) {
	GeeArrayQueue * self;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target = NULL;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_equal_func_target_destroy_notify = NULL;
#line 336 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	self->priv->_items = (_vala_array_free (self->priv->_items, self->priv->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	G_OBJECT_CLASS (gee_array_queue_parent_class)->finalize (obj);
#line 2656 "arrayqueue.c"
}


/**
 * Resizable array implementation of the {@link Deque} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for lookups at the end or random.
 * Because they are stored in an array this structure does not fit for deleting
 * arbitrary elements. For an alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType gee_array_queue_get_type (void) {
	static volatile gsize gee_array_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayQueue), 0, (GInstanceInitFunc) gee_array_queue_instance_init, NULL };
		static const GInterfaceInfo gee_deque_info = { (GInterfaceInitFunc) gee_array_queue_gee_deque_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_queue_type_id;
		gee_array_queue_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_QUEUE, "GeeArrayQueue", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_queue_type_id, GEE_TYPE_DEQUE, &gee_deque_info);
		g_once_init_leave (&gee_array_queue_type_id__volatile, gee_array_queue_type_id);
	}
	return gee_array_queue_type_id__volatile;
}


static void _vala_gee_array_queue_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_SIZE:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_IS_EMPTY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_array_queue_get_is_empty (self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_READ_ONLY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_CAPACITY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_queue_get_capacity ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_REMAINING_CAPACITY:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_int (value, gee_abstract_queue_get_remaining_capacity ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_IS_FULL:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		g_value_set_boolean (value, gee_abstract_queue_get_is_full ((GeeAbstractQueue*) self));
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2726 "arrayqueue.c"
		default:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2732 "arrayqueue.c"
	}
}


static void _vala_gee_array_queue_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_ARRAY_QUEUE, GeeArrayQueue);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
	switch (property_id) {
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_TYPE:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_DUP_FUNC:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		case GEE_ARRAY_QUEUE_G_DESTROY_FUNC:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2760 "arrayqueue.c"
		default:
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 34 "/home/mpiechotka/Projects/contributions/libgee/gee/arrayqueue.vala"
		break;
#line 2766 "arrayqueue.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



