/* currency.c generated by valac 0.18.1, the Vala compiler
 * generated from currency.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <sys/stat.h>
#include <time.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <gio/gio.h>


#define TYPE_CURRENCY_MANAGER (currency_manager_get_type ())
#define CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY_MANAGER, CurrencyManager))
#define CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))
#define IS_CURRENCY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY_MANAGER))
#define IS_CURRENCY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY_MANAGER))
#define CURRENCY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY_MANAGER, CurrencyManagerClass))

typedef struct _CurrencyManager CurrencyManager;
typedef struct _CurrencyManagerClass CurrencyManagerClass;
typedef struct _CurrencyManagerPrivate CurrencyManagerPrivate;

#define TYPE_CURRENCY (currency_get_type ())
#define CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURRENCY, Currency))
#define CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURRENCY, CurrencyClass))
#define IS_CURRENCY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURRENCY))
#define IS_CURRENCY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURRENCY))
#define CURRENCY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURRENCY, CurrencyClass))

typedef struct _Currency Currency;
typedef struct _CurrencyClass CurrencyClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _xmlXPathFreeContext0(var) ((var == NULL) ? NULL : (var = (xmlXPathFreeContext (var), NULL)))
typedef struct _CurrencyPrivate CurrencyPrivate;

struct _CurrencyManager {
	GObject parent_instance;
	CurrencyManagerPrivate * priv;
};

struct _CurrencyManagerClass {
	GObjectClass parent_class;
};

struct _CurrencyManagerPrivate {
	GList* currencies;
};

struct _Currency {
	GObject parent_instance;
	CurrencyPrivate * priv;
};

struct _CurrencyClass {
	GObjectClass parent_class;
};

struct _CurrencyPrivate {
	Number* value;
	gchar* _name;
	gchar* _display_name;
	gchar* _symbol;
};


extern gboolean downloading_imf_rates;
gboolean downloading_imf_rates = FALSE;
extern gboolean downloading_ecb_rates;
gboolean downloading_ecb_rates = FALSE;
extern gboolean loaded_rates;
gboolean loaded_rates = FALSE;
extern CurrencyManager* default_currency_manager;
CurrencyManager* default_currency_manager = NULL;
static gpointer currency_manager_parent_class = NULL;
static gpointer currency_parent_class = NULL;

GType currency_manager_get_type (void) G_GNUC_CONST;
GType currency_get_type (void) G_GNUC_CONST;
#define CURRENCY_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY_MANAGER, CurrencyManagerPrivate))
enum  {
	CURRENCY_MANAGER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
CurrencyManager* currency_manager_get_default (void);
CurrencyManager* currency_manager_new (void);
CurrencyManager* currency_manager_construct (GType object_type);
Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol);
Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol);
GList* currency_manager_get_currencies (CurrencyManager* self);
Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name);
gchar* currency_get_name (Currency* self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* currency_get_value (Currency* self);
gboolean number_is_negative (Number* self);
gboolean number_is_zero (Number* self);
static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self);
static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self);
static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name);
static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age);
static void currency_manager_load_imf_rates (CurrencyManager* self);
static void _g_free0_ (gpointer var);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_reciprocal (Number* self);
void currency_set_value (Currency* self, Number* value);
static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate);
Number* number_multiply (Number* self, Number* y);
static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate);
Number* number_divide (Number* self, Number* y);
static void currency_manager_load_ecb_rates (CurrencyManager* self);
static gboolean currency_manager_load_rates (CurrencyManager* self);
Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency);
static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, GAsyncReadyCallback callback, void* callback_target);
static void currency_manager_download_imf_cb (CurrencyManager* self, GObject* object, GAsyncResult* _result_);
static void _currency_manager_download_imf_cb_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void currency_manager_download_ecb_cb (CurrencyManager* self, GObject* object, GAsyncResult* _result_);
static void _currency_manager_download_ecb_cb_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void currency_manager_finalize (GObject* obj);
#define CURRENCY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CURRENCY, CurrencyPrivate))
enum  {
	CURRENCY_DUMMY_PROPERTY,
	CURRENCY_NAME,
	CURRENCY_DISPLAY_NAME,
	CURRENCY_SYMBOL
};
gchar* currency_get_display_name (Currency* self);
gchar* currency_get_symbol (Currency* self);
static void currency_finalize (GObject* obj);
static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CurrencyManager* currency_manager_get_default (void) {
	CurrencyManager* result = NULL;
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	const gchar* _tmp5_ = NULL;
	Currency* _tmp6_;
	CurrencyManager* _tmp7_;
	const gchar* _tmp8_ = NULL;
	Currency* _tmp9_;
	CurrencyManager* _tmp10_;
	const gchar* _tmp11_ = NULL;
	Currency* _tmp12_;
	CurrencyManager* _tmp13_;
	const gchar* _tmp14_ = NULL;
	Currency* _tmp15_;
	CurrencyManager* _tmp16_;
	const gchar* _tmp17_ = NULL;
	Currency* _tmp18_;
	CurrencyManager* _tmp19_;
	const gchar* _tmp20_ = NULL;
	Currency* _tmp21_;
	CurrencyManager* _tmp22_;
	const gchar* _tmp23_ = NULL;
	Currency* _tmp24_;
	CurrencyManager* _tmp25_;
	const gchar* _tmp26_ = NULL;
	Currency* _tmp27_;
	CurrencyManager* _tmp28_;
	const gchar* _tmp29_ = NULL;
	Currency* _tmp30_;
	CurrencyManager* _tmp31_;
	const gchar* _tmp32_ = NULL;
	Currency* _tmp33_;
	CurrencyManager* _tmp34_;
	const gchar* _tmp35_ = NULL;
	Currency* _tmp36_;
	CurrencyManager* _tmp37_;
	const gchar* _tmp38_ = NULL;
	Currency* _tmp39_;
	CurrencyManager* _tmp40_;
	const gchar* _tmp41_ = NULL;
	Currency* _tmp42_;
	CurrencyManager* _tmp43_;
	const gchar* _tmp44_ = NULL;
	Currency* _tmp45_;
	CurrencyManager* _tmp46_;
	const gchar* _tmp47_ = NULL;
	Currency* _tmp48_;
	CurrencyManager* _tmp49_;
	const gchar* _tmp50_ = NULL;
	Currency* _tmp51_;
	CurrencyManager* _tmp52_;
	const gchar* _tmp53_ = NULL;
	Currency* _tmp54_;
	CurrencyManager* _tmp55_;
	const gchar* _tmp56_ = NULL;
	Currency* _tmp57_;
	CurrencyManager* _tmp58_;
	const gchar* _tmp59_ = NULL;
	Currency* _tmp60_;
	CurrencyManager* _tmp61_;
	const gchar* _tmp62_ = NULL;
	Currency* _tmp63_;
	CurrencyManager* _tmp64_;
	const gchar* _tmp65_ = NULL;
	Currency* _tmp66_;
	CurrencyManager* _tmp67_;
	const gchar* _tmp68_ = NULL;
	Currency* _tmp69_;
	CurrencyManager* _tmp70_;
	const gchar* _tmp71_ = NULL;
	Currency* _tmp72_;
	CurrencyManager* _tmp73_;
	const gchar* _tmp74_ = NULL;
	Currency* _tmp75_;
	CurrencyManager* _tmp76_;
	const gchar* _tmp77_ = NULL;
	Currency* _tmp78_;
	CurrencyManager* _tmp79_;
	const gchar* _tmp80_ = NULL;
	Currency* _tmp81_;
	CurrencyManager* _tmp82_;
	const gchar* _tmp83_ = NULL;
	Currency* _tmp84_;
	CurrencyManager* _tmp85_;
	const gchar* _tmp86_ = NULL;
	Currency* _tmp87_;
	CurrencyManager* _tmp88_;
	const gchar* _tmp89_ = NULL;
	Currency* _tmp90_;
	CurrencyManager* _tmp91_;
	const gchar* _tmp92_ = NULL;
	Currency* _tmp93_;
	CurrencyManager* _tmp94_;
	const gchar* _tmp95_ = NULL;
	Currency* _tmp96_;
	CurrencyManager* _tmp97_;
	const gchar* _tmp98_ = NULL;
	Currency* _tmp99_;
	CurrencyManager* _tmp100_;
	const gchar* _tmp101_ = NULL;
	Currency* _tmp102_;
	CurrencyManager* _tmp103_;
	const gchar* _tmp104_ = NULL;
	Currency* _tmp105_;
	CurrencyManager* _tmp106_;
	const gchar* _tmp107_ = NULL;
	Currency* _tmp108_;
	CurrencyManager* _tmp109_;
	const gchar* _tmp110_ = NULL;
	Currency* _tmp111_;
	CurrencyManager* _tmp112_;
	const gchar* _tmp113_ = NULL;
	Currency* _tmp114_;
	CurrencyManager* _tmp115_;
	const gchar* _tmp116_ = NULL;
	Currency* _tmp117_;
	CurrencyManager* _tmp118_;
	const gchar* _tmp119_ = NULL;
	Currency* _tmp120_;
	CurrencyManager* _tmp121_;
	const gchar* _tmp122_ = NULL;
	Currency* _tmp123_;
	CurrencyManager* _tmp124_;
	const gchar* _tmp125_ = NULL;
	Currency* _tmp126_;
	CurrencyManager* _tmp127_;
	const gchar* _tmp128_ = NULL;
	Currency* _tmp129_;
	CurrencyManager* _tmp130_;
	const gchar* _tmp131_ = NULL;
	Currency* _tmp132_;
	CurrencyManager* _tmp133_;
	const gchar* _tmp134_ = NULL;
	Currency* _tmp135_;
	CurrencyManager* _tmp136_;
	const gchar* _tmp137_ = NULL;
	Currency* _tmp138_;
	CurrencyManager* _tmp139_;
	const gchar* _tmp140_ = NULL;
	Currency* _tmp141_;
	CurrencyManager* _tmp142_;
	const gchar* _tmp143_ = NULL;
	Currency* _tmp144_;
	CurrencyManager* _tmp145_;
	const gchar* _tmp146_ = NULL;
	Currency* _tmp147_;
	CurrencyManager* _tmp148_;
	const gchar* _tmp149_ = NULL;
	Currency* _tmp150_;
	CurrencyManager* _tmp151_;
	const gchar* _tmp152_ = NULL;
	Currency* _tmp153_;
	CurrencyManager* _tmp154_;
	const gchar* _tmp155_ = NULL;
	Currency* _tmp156_;
	CurrencyManager* _tmp157_;
	const gchar* _tmp158_ = NULL;
	Currency* _tmp159_;
	CurrencyManager* _tmp160_;
	const gchar* _tmp161_ = NULL;
	Currency* _tmp162_;
	CurrencyManager* _tmp163_;
	const gchar* _tmp164_ = NULL;
	Currency* _tmp165_;
	CurrencyManager* _tmp166_;
	const gchar* _tmp167_ = NULL;
	Currency* _tmp168_;
	CurrencyManager* _tmp169_;
	const gchar* _tmp170_ = NULL;
	Currency* _tmp171_;
	CurrencyManager* _tmp172_;
	const gchar* _tmp173_ = NULL;
	Currency* _tmp174_;
	CurrencyManager* _tmp175_;
	const gchar* _tmp176_ = NULL;
	Currency* _tmp177_;
	CurrencyManager* _tmp178_;
	const gchar* _tmp179_ = NULL;
	Currency* _tmp180_;
	CurrencyManager* _tmp181_;
	const gchar* _tmp182_ = NULL;
	Currency* _tmp183_;
	CurrencyManager* _tmp184_;
	CurrencyManager* _tmp185_;
	_tmp0_ = default_currency_manager;
	if (_tmp0_ != NULL) {
		CurrencyManager* _tmp1_;
		CurrencyManager* _tmp2_;
		_tmp1_ = default_currency_manager;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = currency_manager_new ();
	_g_object_unref0 (default_currency_manager);
	default_currency_manager = _tmp3_;
	_tmp4_ = default_currency_manager;
	_tmp5_ = _ ("UAE Dirham");
	_tmp6_ = currency_new ("AED", _tmp5_, "إ.د");
	_tmp4_->priv->currencies = g_list_append (_tmp4_->priv->currencies, _tmp6_);
	_tmp7_ = default_currency_manager;
	_tmp8_ = _ ("Australian Dollar");
	_tmp9_ = currency_new ("AUD", _tmp8_, "$");
	_tmp7_->priv->currencies = g_list_append (_tmp7_->priv->currencies, _tmp9_);
	_tmp10_ = default_currency_manager;
	_tmp11_ = _ ("Bulgarian Lev");
	_tmp12_ = currency_new ("BGN", _tmp11_, "лв");
	_tmp10_->priv->currencies = g_list_append (_tmp10_->priv->currencies, _tmp12_);
	_tmp13_ = default_currency_manager;
	_tmp14_ = _ ("Bahraini Dinar");
	_tmp15_ = currency_new ("BHD", _tmp14_, ".ب.د");
	_tmp13_->priv->currencies = g_list_append (_tmp13_->priv->currencies, _tmp15_);
	_tmp16_ = default_currency_manager;
	_tmp17_ = _ ("Brunei Dollar");
	_tmp18_ = currency_new ("BND", _tmp17_, "$");
	_tmp16_->priv->currencies = g_list_append (_tmp16_->priv->currencies, _tmp18_);
	_tmp19_ = default_currency_manager;
	_tmp20_ = _ ("Brazilian Real");
	_tmp21_ = currency_new ("BRL", _tmp20_, "R$");
	_tmp19_->priv->currencies = g_list_append (_tmp19_->priv->currencies, _tmp21_);
	_tmp22_ = default_currency_manager;
	_tmp23_ = _ ("Botswana Pula");
	_tmp24_ = currency_new ("BWP", _tmp23_, "P");
	_tmp22_->priv->currencies = g_list_append (_tmp22_->priv->currencies, _tmp24_);
	_tmp25_ = default_currency_manager;
	_tmp26_ = _ ("Canadian Dollar");
	_tmp27_ = currency_new ("CAD", _tmp26_, "$");
	_tmp25_->priv->currencies = g_list_append (_tmp25_->priv->currencies, _tmp27_);
	_tmp28_ = default_currency_manager;
	_tmp29_ = _ ("CFA Franc");
	_tmp30_ = currency_new ("CFA", _tmp29_, "Fr");
	_tmp28_->priv->currencies = g_list_append (_tmp28_->priv->currencies, _tmp30_);
	_tmp31_ = default_currency_manager;
	_tmp32_ = _ ("Swiss Franc");
	_tmp33_ = currency_new ("CHF", _tmp32_, "Fr");
	_tmp31_->priv->currencies = g_list_append (_tmp31_->priv->currencies, _tmp33_);
	_tmp34_ = default_currency_manager;
	_tmp35_ = _ ("Chilean Peso");
	_tmp36_ = currency_new ("CLP", _tmp35_, "$");
	_tmp34_->priv->currencies = g_list_append (_tmp34_->priv->currencies, _tmp36_);
	_tmp37_ = default_currency_manager;
	_tmp38_ = _ ("Chinese Yuan");
	_tmp39_ = currency_new ("CNY", _tmp38_, "元");
	_tmp37_->priv->currencies = g_list_append (_tmp37_->priv->currencies, _tmp39_);
	_tmp40_ = default_currency_manager;
	_tmp41_ = _ ("Colombian Peso");
	_tmp42_ = currency_new ("COP", _tmp41_, "$");
	_tmp40_->priv->currencies = g_list_append (_tmp40_->priv->currencies, _tmp42_);
	_tmp43_ = default_currency_manager;
	_tmp44_ = _ ("Czech Koruna");
	_tmp45_ = currency_new ("CZK", _tmp44_, "Kč");
	_tmp43_->priv->currencies = g_list_append (_tmp43_->priv->currencies, _tmp45_);
	_tmp46_ = default_currency_manager;
	_tmp47_ = _ ("Danish Krone");
	_tmp48_ = currency_new ("DKK", _tmp47_, "kr");
	_tmp46_->priv->currencies = g_list_append (_tmp46_->priv->currencies, _tmp48_);
	_tmp49_ = default_currency_manager;
	_tmp50_ = _ ("Algerian Dinar");
	_tmp51_ = currency_new ("DZD", _tmp50_, "ج.د");
	_tmp49_->priv->currencies = g_list_append (_tmp49_->priv->currencies, _tmp51_);
	_tmp52_ = default_currency_manager;
	_tmp53_ = _ ("Estonian Kroon");
	_tmp54_ = currency_new ("EEK", _tmp53_, "KR");
	_tmp52_->priv->currencies = g_list_append (_tmp52_->priv->currencies, _tmp54_);
	_tmp55_ = default_currency_manager;
	_tmp56_ = _ ("Euro");
	_tmp57_ = currency_new ("EUR", _tmp56_, "€");
	_tmp55_->priv->currencies = g_list_append (_tmp55_->priv->currencies, _tmp57_);
	_tmp58_ = default_currency_manager;
	_tmp59_ = _ ("Pound Sterling");
	_tmp60_ = currency_new ("GBP", _tmp59_, "£");
	_tmp58_->priv->currencies = g_list_append (_tmp58_->priv->currencies, _tmp60_);
	_tmp61_ = default_currency_manager;
	_tmp62_ = _ ("Hong Kong Dollar");
	_tmp63_ = currency_new ("HKD", _tmp62_, "$");
	_tmp61_->priv->currencies = g_list_append (_tmp61_->priv->currencies, _tmp63_);
	_tmp64_ = default_currency_manager;
	_tmp65_ = _ ("Croatian Kuna");
	_tmp66_ = currency_new ("HRK", _tmp65_, "kn");
	_tmp64_->priv->currencies = g_list_append (_tmp64_->priv->currencies, _tmp66_);
	_tmp67_ = default_currency_manager;
	_tmp68_ = _ ("Hungarian Forint");
	_tmp69_ = currency_new ("HUF", _tmp68_, "Ft");
	_tmp67_->priv->currencies = g_list_append (_tmp67_->priv->currencies, _tmp69_);
	_tmp70_ = default_currency_manager;
	_tmp71_ = _ ("Indonesian Rupiah");
	_tmp72_ = currency_new ("IDR", _tmp71_, "Rp");
	_tmp70_->priv->currencies = g_list_append (_tmp70_->priv->currencies, _tmp72_);
	_tmp73_ = default_currency_manager;
	_tmp74_ = _ ("Israeli New Shekel");
	_tmp75_ = currency_new ("ILS", _tmp74_, "₪");
	_tmp73_->priv->currencies = g_list_append (_tmp73_->priv->currencies, _tmp75_);
	_tmp76_ = default_currency_manager;
	_tmp77_ = _ ("Indian Rupee");
	_tmp78_ = currency_new ("INR", _tmp77_, "₹");
	_tmp76_->priv->currencies = g_list_append (_tmp76_->priv->currencies, _tmp78_);
	_tmp79_ = default_currency_manager;
	_tmp80_ = _ ("Iranian Rial");
	_tmp81_ = currency_new ("IRR", _tmp80_, "﷼");
	_tmp79_->priv->currencies = g_list_append (_tmp79_->priv->currencies, _tmp81_);
	_tmp82_ = default_currency_manager;
	_tmp83_ = _ ("Icelandic Krona");
	_tmp84_ = currency_new ("ISK", _tmp83_, "kr");
	_tmp82_->priv->currencies = g_list_append (_tmp82_->priv->currencies, _tmp84_);
	_tmp85_ = default_currency_manager;
	_tmp86_ = _ ("Japanese Yen");
	_tmp87_ = currency_new ("JPY", _tmp86_, "¥");
	_tmp85_->priv->currencies = g_list_append (_tmp85_->priv->currencies, _tmp87_);
	_tmp88_ = default_currency_manager;
	_tmp89_ = _ ("South Korean Won");
	_tmp90_ = currency_new ("KRW", _tmp89_, "₩");
	_tmp88_->priv->currencies = g_list_append (_tmp88_->priv->currencies, _tmp90_);
	_tmp91_ = default_currency_manager;
	_tmp92_ = _ ("Kuwaiti Dinar");
	_tmp93_ = currency_new ("KWD", _tmp92_, "ك.د");
	_tmp91_->priv->currencies = g_list_append (_tmp91_->priv->currencies, _tmp93_);
	_tmp94_ = default_currency_manager;
	_tmp95_ = _ ("Kazakhstani Tenge");
	_tmp96_ = currency_new ("KZT", _tmp95_, "₸");
	_tmp94_->priv->currencies = g_list_append (_tmp94_->priv->currencies, _tmp96_);
	_tmp97_ = default_currency_manager;
	_tmp98_ = _ ("Sri Lankan Rupee");
	_tmp99_ = currency_new ("LKR", _tmp98_, "Rs");
	_tmp97_->priv->currencies = g_list_append (_tmp97_->priv->currencies, _tmp99_);
	_tmp100_ = default_currency_manager;
	_tmp101_ = _ ("Lithuanian Litas");
	_tmp102_ = currency_new ("LTL", _tmp101_, "Lt");
	_tmp100_->priv->currencies = g_list_append (_tmp100_->priv->currencies, _tmp102_);
	_tmp103_ = default_currency_manager;
	_tmp104_ = _ ("Latvian Lats");
	_tmp105_ = currency_new ("LVL", _tmp104_, "Ls");
	_tmp103_->priv->currencies = g_list_append (_tmp103_->priv->currencies, _tmp105_);
	_tmp106_ = default_currency_manager;
	_tmp107_ = _ ("Libyan Dinar");
	_tmp108_ = currency_new ("LYD", _tmp107_, "د.ل");
	_tmp106_->priv->currencies = g_list_append (_tmp106_->priv->currencies, _tmp108_);
	_tmp109_ = default_currency_manager;
	_tmp110_ = _ ("Mauritian Rupee");
	_tmp111_ = currency_new ("MUR", _tmp110_, "Rs");
	_tmp109_->priv->currencies = g_list_append (_tmp109_->priv->currencies, _tmp111_);
	_tmp112_ = default_currency_manager;
	_tmp113_ = _ ("Mexican Peso");
	_tmp114_ = currency_new ("MXN", _tmp113_, "$");
	_tmp112_->priv->currencies = g_list_append (_tmp112_->priv->currencies, _tmp114_);
	_tmp115_ = default_currency_manager;
	_tmp116_ = _ ("Malaysian Ringgit");
	_tmp117_ = currency_new ("MYR", _tmp116_, "RM");
	_tmp115_->priv->currencies = g_list_append (_tmp115_->priv->currencies, _tmp117_);
	_tmp118_ = default_currency_manager;
	_tmp119_ = _ ("Norwegian Krone");
	_tmp120_ = currency_new ("NOK", _tmp119_, "kr");
	_tmp118_->priv->currencies = g_list_append (_tmp118_->priv->currencies, _tmp120_);
	_tmp121_ = default_currency_manager;
	_tmp122_ = _ ("Nepalese Rupee");
	_tmp123_ = currency_new ("NPR", _tmp122_, "Rs");
	_tmp121_->priv->currencies = g_list_append (_tmp121_->priv->currencies, _tmp123_);
	_tmp124_ = default_currency_manager;
	_tmp125_ = _ ("New Zealand Dollar");
	_tmp126_ = currency_new ("NZD", _tmp125_, "$");
	_tmp124_->priv->currencies = g_list_append (_tmp124_->priv->currencies, _tmp126_);
	_tmp127_ = default_currency_manager;
	_tmp128_ = _ ("Omani Rial");
	_tmp129_ = currency_new ("OMR", _tmp128_, "ع.ر.");
	_tmp127_->priv->currencies = g_list_append (_tmp127_->priv->currencies, _tmp129_);
	_tmp130_ = default_currency_manager;
	_tmp131_ = _ ("Peruvian Nuevo Sol");
	_tmp132_ = currency_new ("PEN", _tmp131_, "S/.");
	_tmp130_->priv->currencies = g_list_append (_tmp130_->priv->currencies, _tmp132_);
	_tmp133_ = default_currency_manager;
	_tmp134_ = _ ("Philippine Peso");
	_tmp135_ = currency_new ("PHP", _tmp134_, "₱");
	_tmp133_->priv->currencies = g_list_append (_tmp133_->priv->currencies, _tmp135_);
	_tmp136_ = default_currency_manager;
	_tmp137_ = _ ("Pakistani Rupee");
	_tmp138_ = currency_new ("PKR", _tmp137_, "Rs");
	_tmp136_->priv->currencies = g_list_append (_tmp136_->priv->currencies, _tmp138_);
	_tmp139_ = default_currency_manager;
	_tmp140_ = _ ("Polish Zloty");
	_tmp141_ = currency_new ("PLN", _tmp140_, "zł");
	_tmp139_->priv->currencies = g_list_append (_tmp139_->priv->currencies, _tmp141_);
	_tmp142_ = default_currency_manager;
	_tmp143_ = _ ("Qatari Riyal");
	_tmp144_ = currency_new ("QAR", _tmp143_, "ق.ر");
	_tmp142_->priv->currencies = g_list_append (_tmp142_->priv->currencies, _tmp144_);
	_tmp145_ = default_currency_manager;
	_tmp146_ = _ ("New Romanian Leu");
	_tmp147_ = currency_new ("RON", _tmp146_, "L");
	_tmp145_->priv->currencies = g_list_append (_tmp145_->priv->currencies, _tmp147_);
	_tmp148_ = default_currency_manager;
	_tmp149_ = _ ("Russian Rouble");
	_tmp150_ = currency_new ("RUB", _tmp149_, "руб.");
	_tmp148_->priv->currencies = g_list_append (_tmp148_->priv->currencies, _tmp150_);
	_tmp151_ = default_currency_manager;
	_tmp152_ = _ ("Saudi Riyal");
	_tmp153_ = currency_new ("SAR", _tmp152_, "س.ر");
	_tmp151_->priv->currencies = g_list_append (_tmp151_->priv->currencies, _tmp153_);
	_tmp154_ = default_currency_manager;
	_tmp155_ = _ ("Swedish Krona");
	_tmp156_ = currency_new ("SEK", _tmp155_, "kr");
	_tmp154_->priv->currencies = g_list_append (_tmp154_->priv->currencies, _tmp156_);
	_tmp157_ = default_currency_manager;
	_tmp158_ = _ ("Singapore Dollar");
	_tmp159_ = currency_new ("SGD", _tmp158_, "$");
	_tmp157_->priv->currencies = g_list_append (_tmp157_->priv->currencies, _tmp159_);
	_tmp160_ = default_currency_manager;
	_tmp161_ = _ ("Thai Baht");
	_tmp162_ = currency_new ("THB", _tmp161_, "฿");
	_tmp160_->priv->currencies = g_list_append (_tmp160_->priv->currencies, _tmp162_);
	_tmp163_ = default_currency_manager;
	_tmp164_ = _ ("Tunisian Dinar");
	_tmp165_ = currency_new ("TND", _tmp164_, "ت.د");
	_tmp163_->priv->currencies = g_list_append (_tmp163_->priv->currencies, _tmp165_);
	_tmp166_ = default_currency_manager;
	_tmp167_ = _ ("New Turkish Lira");
	_tmp168_ = currency_new ("TRY", _tmp167_, "TL");
	_tmp166_->priv->currencies = g_list_append (_tmp166_->priv->currencies, _tmp168_);
	_tmp169_ = default_currency_manager;
	_tmp170_ = _ ("T&T Dollar (TTD)");
	_tmp171_ = currency_new ("TTD", _tmp170_, "$");
	_tmp169_->priv->currencies = g_list_append (_tmp169_->priv->currencies, _tmp171_);
	_tmp172_ = default_currency_manager;
	_tmp173_ = _ ("US Dollar");
	_tmp174_ = currency_new ("USD", _tmp173_, "$");
	_tmp172_->priv->currencies = g_list_append (_tmp172_->priv->currencies, _tmp174_);
	_tmp175_ = default_currency_manager;
	_tmp176_ = _ ("Uruguayan Peso");
	_tmp177_ = currency_new ("UYU", _tmp176_, "$");
	_tmp175_->priv->currencies = g_list_append (_tmp175_->priv->currencies, _tmp177_);
	_tmp178_ = default_currency_manager;
	_tmp179_ = _ ("Venezuelan Bolívar");
	_tmp180_ = currency_new ("VEF", _tmp179_, "Bs F");
	_tmp178_->priv->currencies = g_list_append (_tmp178_->priv->currencies, _tmp180_);
	_tmp181_ = default_currency_manager;
	_tmp182_ = _ ("South African Rand");
	_tmp183_ = currency_new ("ZAR", _tmp182_, "R");
	_tmp181_->priv->currencies = g_list_append (_tmp181_->priv->currencies, _tmp183_);
	_tmp184_ = default_currency_manager;
	_tmp185_ = _g_object_ref0 (_tmp184_);
	result = _tmp185_;
	return result;
}


GList* currency_manager_get_currencies (CurrencyManager* self) {
	GList* result = NULL;
	GList* r;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	r = NULL;
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				Currency* _tmp3_;
				_tmp2_ = c;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				r = g_list_append (r, _tmp3_);
				_g_object_unref0 (c);
			}
		}
	}
	result = r;
	return result;
}


Currency* currency_manager_get_currency (CurrencyManager* self, const gchar* name) {
	Currency* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				const gchar* _tmp2_;
				Currency* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = name;
				_tmp3_ = c;
				_tmp4_ = currency_get_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp2_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Currency* _tmp8_;
					Number* _tmp9_ = NULL;
					Number* value;
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					Number* _tmp12_;
					gboolean _tmp15_;
					gboolean _tmp18_;
					_tmp8_ = c;
					_tmp9_ = currency_get_value (_tmp8_);
					value = _tmp9_;
					_tmp12_ = value;
					if (_tmp12_ == NULL) {
						_tmp11_ = TRUE;
					} else {
						Number* _tmp13_;
						gboolean _tmp14_ = FALSE;
						_tmp13_ = value;
						_tmp14_ = number_is_negative (_tmp13_);
						_tmp11_ = _tmp14_;
					}
					_tmp15_ = _tmp11_;
					if (_tmp15_) {
						_tmp10_ = TRUE;
					} else {
						Number* _tmp16_;
						gboolean _tmp17_ = FALSE;
						_tmp16_ = value;
						_tmp17_ = number_is_zero (_tmp16_);
						_tmp10_ = _tmp17_;
					}
					_tmp18_ = _tmp10_;
					if (_tmp18_) {
						result = NULL;
						_number_unref0 (value);
						_g_object_unref0 (c);
						return result;
					} else {
						result = c;
						_number_unref0 (value);
						return result;
					}
					_number_unref0 (value);
				}
				_g_object_unref0 (c);
			}
		}
	}
	result = NULL;
	return result;
}


static gchar* currency_manager_get_imf_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "rms_five.xls", NULL);
	result = _tmp1_;
	return result;
}


static gchar* currency_manager_get_ecb_rate_filepath (CurrencyManager* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "eurofxref-daily.xml", NULL);
	result = _tmp1_;
	return result;
}


static Currency* currency_manager_add_currency (CurrencyManager* self, const gchar* short_name) {
	Currency* result = NULL;
	GList* _tmp0_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	Currency* _tmp12_;
	Currency* c;
	Currency* _tmp13_;
	Currency* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (short_name != NULL, NULL);
	_tmp0_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp0_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp1_;
			Currency* c = NULL;
			_tmp1_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp1_;
			{
				Currency* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = c;
				_tmp3_ = currency_get_name (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = short_name;
				_tmp7_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp7_) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	_tmp8_ = short_name;
	g_warning ("currency.vala:133: Currency %s is not in the currency table", _tmp8_);
	_tmp9_ = short_name;
	_tmp10_ = short_name;
	_tmp11_ = short_name;
	_tmp12_ = currency_new (_tmp9_, _tmp10_, _tmp11_);
	c = _tmp12_;
	_tmp13_ = c;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	self->priv->currencies = g_list_append (self->priv->currencies, _tmp14_);
	result = c;
	return result;
}


static gboolean currency_manager_file_needs_update (CurrencyManager* self, const gchar* filename, gdouble max_age) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	struct stat buf = {0};
	const gchar* _tmp2_;
	struct stat _tmp3_ = {0};
	gint _tmp4_ = 0;
	struct stat _tmp5_;
	time_t _tmp6_;
	time_t modify_time;
	time_t _tmp7_;
	time_t now;
	time_t _tmp8_;
	time_t _tmp9_;
	gdouble _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = g_file_test (_tmp0_, G_FILE_TEST_IS_REGULAR);
	if (!_tmp1_) {
		result = TRUE;
		return result;
	}
	memset (&buf, 0, sizeof (struct stat));
	_tmp2_ = filename;
	_tmp4_ = stat (_tmp2_, &_tmp3_);
	buf = _tmp3_;
	if (_tmp4_ == (-1)) {
		result = TRUE;
		return result;
	}
	_tmp5_ = buf;
	_tmp6_ = _tmp5_.st_mtime;
	modify_time = _tmp6_;
	_tmp7_ = time (NULL);
	now = _tmp7_;
	_tmp8_ = now;
	_tmp9_ = modify_time;
	_tmp10_ = max_age;
	if (((gdouble) (_tmp8_ - _tmp9_)) > _tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gchar* string_chug (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchug (_tmp1_);
	result = _result_;
	return result;
}


static void currency_manager_load_imf_rates (CurrencyManager* self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* name_map;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashTable* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GHashTable* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GHashTable* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GHashTable* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GHashTable* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GHashTable* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GHashTable* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GHashTable* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GHashTable* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GHashTable* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GHashTable* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GHashTable* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GHashTable* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	GHashTable* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GHashTable* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	GHashTable* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GHashTable* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GHashTable* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	GHashTable* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	GHashTable* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	GHashTable* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	GHashTable* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GHashTable* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GHashTable* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	GHashTable* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	GHashTable* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	GHashTable* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	GHashTable* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	GHashTable* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	GHashTable* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	GHashTable* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	GHashTable* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	GHashTable* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	GHashTable* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	GHashTable* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	GHashTable* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GHashTable* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	GHashTable* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	GHashTable* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	GHashTable* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	GHashTable* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	GHashTable* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	GHashTable* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_ = NULL;
	gchar* filename;
	gchar* data = NULL;
	const gchar* _tmp161_;
	gchar** _tmp162_;
	gchar** _tmp163_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data;
	gchar** _tmp164_;
	gint _tmp164__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	name_map = _tmp2_;
	_tmp3_ = name_map;
	_tmp4_ = g_strdup ("Euro");
	_tmp5_ = g_strdup ("EUR");
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = name_map;
	_tmp7_ = g_strdup ("Japanese Yen");
	_tmp8_ = g_strdup ("JPY");
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp8_);
	_tmp9_ = name_map;
	_tmp10_ = g_strdup ("U.K. Pound Sterling");
	_tmp11_ = g_strdup ("GBP");
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = name_map;
	_tmp13_ = g_strdup ("U.S. Dollar");
	_tmp14_ = g_strdup ("USD");
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = name_map;
	_tmp16_ = g_strdup ("Algerian Dinar");
	_tmp17_ = g_strdup ("DZD");
	g_hash_table_insert (_tmp15_, _tmp16_, _tmp17_);
	_tmp18_ = name_map;
	_tmp19_ = g_strdup ("Australian Dollar");
	_tmp20_ = g_strdup ("AUD");
	g_hash_table_insert (_tmp18_, _tmp19_, _tmp20_);
	_tmp21_ = name_map;
	_tmp22_ = g_strdup ("Bahrain Dinar");
	_tmp23_ = g_strdup ("BHD");
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = name_map;
	_tmp25_ = g_strdup ("Botswana Pula");
	_tmp26_ = g_strdup ("BWP");
	g_hash_table_insert (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = name_map;
	_tmp28_ = g_strdup ("Brazilian Real");
	_tmp29_ = g_strdup ("BRL");
	g_hash_table_insert (_tmp27_, _tmp28_, _tmp29_);
	_tmp30_ = name_map;
	_tmp31_ = g_strdup ("Brunei Dollar");
	_tmp32_ = g_strdup ("BND");
	g_hash_table_insert (_tmp30_, _tmp31_, _tmp32_);
	_tmp33_ = name_map;
	_tmp34_ = g_strdup ("Canadian Dollar");
	_tmp35_ = g_strdup ("CAD");
	g_hash_table_insert (_tmp33_, _tmp34_, _tmp35_);
	_tmp36_ = name_map;
	_tmp37_ = g_strdup ("Chilean Peso");
	_tmp38_ = g_strdup ("CLP");
	g_hash_table_insert (_tmp36_, _tmp37_, _tmp38_);
	_tmp39_ = name_map;
	_tmp40_ = g_strdup ("Chinese Yuan");
	_tmp41_ = g_strdup ("CNY");
	g_hash_table_insert (_tmp39_, _tmp40_, _tmp41_);
	_tmp42_ = name_map;
	_tmp43_ = g_strdup ("Colombian Peso");
	_tmp44_ = g_strdup ("COP");
	g_hash_table_insert (_tmp42_, _tmp43_, _tmp44_);
	_tmp45_ = name_map;
	_tmp46_ = g_strdup ("Czech Koruna");
	_tmp47_ = g_strdup ("CZK");
	g_hash_table_insert (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = name_map;
	_tmp49_ = g_strdup ("Danish Krone");
	_tmp50_ = g_strdup ("DKK");
	g_hash_table_insert (_tmp48_, _tmp49_, _tmp50_);
	_tmp51_ = name_map;
	_tmp52_ = g_strdup ("Hungarian Forint");
	_tmp53_ = g_strdup ("HUF");
	g_hash_table_insert (_tmp51_, _tmp52_, _tmp53_);
	_tmp54_ = name_map;
	_tmp55_ = g_strdup ("Icelandic Krona");
	_tmp56_ = g_strdup ("ISK");
	g_hash_table_insert (_tmp54_, _tmp55_, _tmp56_);
	_tmp57_ = name_map;
	_tmp58_ = g_strdup ("Indian Rupee");
	_tmp59_ = g_strdup ("INR");
	g_hash_table_insert (_tmp57_, _tmp58_, _tmp59_);
	_tmp60_ = name_map;
	_tmp61_ = g_strdup ("Indonesian Rupiah");
	_tmp62_ = g_strdup ("IDR");
	g_hash_table_insert (_tmp60_, _tmp61_, _tmp62_);
	_tmp63_ = name_map;
	_tmp64_ = g_strdup ("Iranian Rial");
	_tmp65_ = g_strdup ("IRR");
	g_hash_table_insert (_tmp63_, _tmp64_, _tmp65_);
	_tmp66_ = name_map;
	_tmp67_ = g_strdup ("Israeli New Sheqel");
	_tmp68_ = g_strdup ("ILS");
	g_hash_table_insert (_tmp66_, _tmp67_, _tmp68_);
	_tmp69_ = name_map;
	_tmp70_ = g_strdup ("Kazakhstani Tenge");
	_tmp71_ = g_strdup ("KZT");
	g_hash_table_insert (_tmp69_, _tmp70_, _tmp71_);
	_tmp72_ = name_map;
	_tmp73_ = g_strdup ("Korean Won");
	_tmp74_ = g_strdup ("KRW");
	g_hash_table_insert (_tmp72_, _tmp73_, _tmp74_);
	_tmp75_ = name_map;
	_tmp76_ = g_strdup ("Kuwaiti Dinar");
	_tmp77_ = g_strdup ("KWD");
	g_hash_table_insert (_tmp75_, _tmp76_, _tmp77_);
	_tmp78_ = name_map;
	_tmp79_ = g_strdup ("Libyan Dinar");
	_tmp80_ = g_strdup ("LYD");
	g_hash_table_insert (_tmp78_, _tmp79_, _tmp80_);
	_tmp81_ = name_map;
	_tmp82_ = g_strdup ("Malaysian Ringgit");
	_tmp83_ = g_strdup ("MYR");
	g_hash_table_insert (_tmp81_, _tmp82_, _tmp83_);
	_tmp84_ = name_map;
	_tmp85_ = g_strdup ("Mauritian Rupee");
	_tmp86_ = g_strdup ("MUR");
	g_hash_table_insert (_tmp84_, _tmp85_, _tmp86_);
	_tmp87_ = name_map;
	_tmp88_ = g_strdup ("Mexican Peso");
	_tmp89_ = g_strdup ("MXN");
	g_hash_table_insert (_tmp87_, _tmp88_, _tmp89_);
	_tmp90_ = name_map;
	_tmp91_ = g_strdup ("Nepalese Rupee");
	_tmp92_ = g_strdup ("NPR");
	g_hash_table_insert (_tmp90_, _tmp91_, _tmp92_);
	_tmp93_ = name_map;
	_tmp94_ = g_strdup ("New Zealand Dollar");
	_tmp95_ = g_strdup ("NZD");
	g_hash_table_insert (_tmp93_, _tmp94_, _tmp95_);
	_tmp96_ = name_map;
	_tmp97_ = g_strdup ("Norwegian Krone");
	_tmp98_ = g_strdup ("NOK");
	g_hash_table_insert (_tmp96_, _tmp97_, _tmp98_);
	_tmp99_ = name_map;
	_tmp100_ = g_strdup ("Rial Omani");
	_tmp101_ = g_strdup ("OMR");
	g_hash_table_insert (_tmp99_, _tmp100_, _tmp101_);
	_tmp102_ = name_map;
	_tmp103_ = g_strdup ("Pakistani Rupee");
	_tmp104_ = g_strdup ("PKR");
	g_hash_table_insert (_tmp102_, _tmp103_, _tmp104_);
	_tmp105_ = name_map;
	_tmp106_ = g_strdup ("Nuevo Sol");
	_tmp107_ = g_strdup ("PEN");
	g_hash_table_insert (_tmp105_, _tmp106_, _tmp107_);
	_tmp108_ = name_map;
	_tmp109_ = g_strdup ("Philippine Peso");
	_tmp110_ = g_strdup ("PHP");
	g_hash_table_insert (_tmp108_, _tmp109_, _tmp110_);
	_tmp111_ = name_map;
	_tmp112_ = g_strdup ("Polish Zloty");
	_tmp113_ = g_strdup ("PLN");
	g_hash_table_insert (_tmp111_, _tmp112_, _tmp113_);
	_tmp114_ = name_map;
	_tmp115_ = g_strdup ("Qatar Riyal");
	_tmp116_ = g_strdup ("QAR");
	g_hash_table_insert (_tmp114_, _tmp115_, _tmp116_);
	_tmp117_ = name_map;
	_tmp118_ = g_strdup ("Russian Ruble");
	_tmp119_ = g_strdup ("RUB");
	g_hash_table_insert (_tmp117_, _tmp118_, _tmp119_);
	_tmp120_ = name_map;
	_tmp121_ = g_strdup ("Saudi Arabian Riyal");
	_tmp122_ = g_strdup ("SAR");
	g_hash_table_insert (_tmp120_, _tmp121_, _tmp122_);
	_tmp123_ = name_map;
	_tmp124_ = g_strdup ("Singapore Dollar");
	_tmp125_ = g_strdup ("SGD");
	g_hash_table_insert (_tmp123_, _tmp124_, _tmp125_);
	_tmp126_ = name_map;
	_tmp127_ = g_strdup ("South African Rand");
	_tmp128_ = g_strdup ("ZAR");
	g_hash_table_insert (_tmp126_, _tmp127_, _tmp128_);
	_tmp129_ = name_map;
	_tmp130_ = g_strdup ("Sri Lanka Rupee");
	_tmp131_ = g_strdup ("LKR");
	g_hash_table_insert (_tmp129_, _tmp130_, _tmp131_);
	_tmp132_ = name_map;
	_tmp133_ = g_strdup ("Swedish Krona");
	_tmp134_ = g_strdup ("SEK");
	g_hash_table_insert (_tmp132_, _tmp133_, _tmp134_);
	_tmp135_ = name_map;
	_tmp136_ = g_strdup ("Swiss Franc");
	_tmp137_ = g_strdup ("CHF");
	g_hash_table_insert (_tmp135_, _tmp136_, _tmp137_);
	_tmp138_ = name_map;
	_tmp139_ = g_strdup ("Thai Baht");
	_tmp140_ = g_strdup ("THB");
	g_hash_table_insert (_tmp138_, _tmp139_, _tmp140_);
	_tmp141_ = name_map;
	_tmp142_ = g_strdup ("Trinidad And Tobago Dollar");
	_tmp143_ = g_strdup ("TTD");
	g_hash_table_insert (_tmp141_, _tmp142_, _tmp143_);
	_tmp144_ = name_map;
	_tmp145_ = g_strdup ("Tunisian Dinar");
	_tmp146_ = g_strdup ("TND");
	g_hash_table_insert (_tmp144_, _tmp145_, _tmp146_);
	_tmp147_ = name_map;
	_tmp148_ = g_strdup ("U.A.E. Dirham");
	_tmp149_ = g_strdup ("AED");
	g_hash_table_insert (_tmp147_, _tmp148_, _tmp149_);
	_tmp150_ = name_map;
	_tmp151_ = g_strdup ("Peso Uruguayo");
	_tmp152_ = g_strdup ("UYU");
	g_hash_table_insert (_tmp150_, _tmp151_, _tmp152_);
	_tmp153_ = name_map;
	_tmp154_ = g_strdup ("Bolivar Fuerte");
	_tmp155_ = g_strdup ("VEF");
	g_hash_table_insert (_tmp153_, _tmp154_, _tmp155_);
	_tmp156_ = currency_manager_get_imf_rate_filepath (self);
	filename = _tmp156_;
	{
		const gchar* _tmp157_;
		gchar* _tmp158_ = NULL;
		_tmp157_ = filename;
		g_file_get_contents (_tmp157_, &_tmp158_, NULL, &_inner_error_);
		_g_free0 (data);
		data = _tmp158_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp159_;
		const gchar* _tmp160_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp159_ = e;
		_tmp160_ = _tmp159_->message;
		g_warning ("currency.vala:223: Failed to read exchange rates: %s", _tmp160_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (filename);
		_g_hash_table_unref0 (name_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp161_ = data;
	_tmp163_ = _tmp162_ = g_strsplit (_tmp161_, "\n", 0);
	lines = _tmp163_;
	lines_length1 = _vala_array_length (_tmp162_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp164_ = lines;
	_tmp164__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp164_;
		line_collection_length1 = _tmp164__length1;
		for (line_it = 0; line_it < _tmp164__length1; line_it = line_it + 1) {
			gchar* _tmp165_;
			gchar* line = NULL;
			_tmp165_ = g_strdup (line_collection[line_it]);
			line = _tmp165_;
			{
				const gchar* _tmp166_;
				gchar* _tmp167_ = NULL;
				const gchar* _tmp168_;
				gboolean _tmp170_;
				const gchar* _tmp171_;
				gchar** _tmp172_;
				gchar** _tmp173_ = NULL;
				gchar** tokens;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp174_;
				gint _tmp174__length1;
				const gchar* _tmp175_;
				_tmp166_ = line;
				_tmp167_ = string_chug (_tmp166_);
				_g_free0 (line);
				line = _tmp167_;
				_tmp168_ = line;
				if (g_strcmp0 (_tmp168_, "") == 0) {
					gboolean _tmp169_;
					_tmp169_ = in_data;
					if (!_tmp169_) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				_tmp170_ = in_data;
				if (!_tmp170_) {
					_g_free0 (line);
					continue;
				}
				_tmp171_ = line;
				_tmp173_ = _tmp172_ = g_strsplit (_tmp171_, "\t", 0);
				tokens = _tmp173_;
				tokens_length1 = _vala_array_length (_tmp172_);
				_tokens_size_ = tokens_length1;
				_tmp174_ = tokens;
				_tmp174__length1 = tokens_length1;
				_tmp175_ = _tmp174_[0];
				if (g_strcmp0 (_tmp175_, "Currency") != 0) {
					gint value_index = 0;
					gint _tmp186_;
					gchar** _tmp187_;
					gint _tmp187__length1;
					{
						gboolean _tmp176_;
						value_index = 1;
						_tmp176_ = TRUE;
						while (TRUE) {
							gboolean _tmp177_;
							gint _tmp179_;
							gchar** _tmp180_;
							gint _tmp180__length1;
							gchar** _tmp181_;
							gint _tmp181__length1;
							gint _tmp182_;
							const gchar* _tmp183_;
							gchar* _tmp184_ = NULL;
							gchar* value;
							const gchar* _tmp185_;
							_tmp177_ = _tmp176_;
							if (!_tmp177_) {
								gint _tmp178_;
								_tmp178_ = value_index;
								value_index = _tmp178_ + 1;
							}
							_tmp176_ = FALSE;
							_tmp179_ = value_index;
							_tmp180_ = tokens;
							_tmp180__length1 = tokens_length1;
							if (!(_tmp179_ < _tmp180__length1)) {
								break;
							}
							_tmp181_ = tokens;
							_tmp181__length1 = tokens_length1;
							_tmp182_ = value_index;
							_tmp183_ = _tmp181_[_tmp182_];
							_tmp184_ = string_chug (_tmp183_);
							value = _tmp184_;
							_tmp185_ = value;
							if (g_strcmp0 (_tmp185_, "") != 0) {
								_g_free0 (value);
								break;
							}
							_g_free0 (value);
						}
					}
					_tmp186_ = value_index;
					_tmp187_ = tokens;
					_tmp187__length1 = tokens_length1;
					if (_tmp186_ < _tmp187__length1) {
						GHashTable* _tmp188_;
						gchar** _tmp189_;
						gint _tmp189__length1;
						const gchar* _tmp190_;
						gconstpointer _tmp191_ = NULL;
						gchar* _tmp192_;
						gchar* symbol;
						const gchar* _tmp193_;
						_tmp188_ = name_map;
						_tmp189_ = tokens;
						_tmp189__length1 = tokens_length1;
						_tmp190_ = _tmp189_[0];
						_tmp191_ = g_hash_table_lookup (_tmp188_, _tmp190_);
						_tmp192_ = g_strdup ((const gchar*) _tmp191_);
						symbol = _tmp192_;
						_tmp193_ = symbol;
						if (_tmp193_ != NULL) {
							const gchar* _tmp194_;
							Currency* _tmp195_ = NULL;
							Currency* c;
							Currency* _tmp196_;
							gchar** _tmp203_;
							gint _tmp203__length1;
							gint _tmp204_;
							const gchar* _tmp205_;
							Number* _tmp206_ = NULL;
							Number* value;
							Number* _tmp207_;
							Number* _tmp208_ = NULL;
							Currency* _tmp209_;
							Number* _tmp210_;
							_tmp194_ = symbol;
							_tmp195_ = currency_manager_get_currency (self, _tmp194_);
							c = _tmp195_;
							_tmp196_ = c;
							if (_tmp196_ == NULL) {
								gchar** _tmp197_;
								gint _tmp197__length1;
								gint _tmp198_;
								const gchar* _tmp199_;
								const gchar* _tmp200_;
								const gchar* _tmp201_;
								Currency* _tmp202_ = NULL;
								_tmp197_ = tokens;
								_tmp197__length1 = tokens_length1;
								_tmp198_ = value_index;
								_tmp199_ = _tmp197_[_tmp198_];
								_tmp200_ = symbol;
								g_debug ("currency.vala:267: Using IMF rate of %s for %s", _tmp199_, _tmp200_);
								_tmp201_ = symbol;
								_tmp202_ = currency_manager_add_currency (self, _tmp201_);
								_g_object_unref0 (c);
								c = _tmp202_;
							}
							_tmp203_ = tokens;
							_tmp203__length1 = tokens_length1;
							_tmp204_ = value_index;
							_tmp205_ = _tmp203_[_tmp204_];
							_tmp206_ = mp_set_from_string (_tmp205_, 10);
							value = _tmp206_;
							_tmp207_ = value;
							_tmp208_ = number_reciprocal (_tmp207_);
							_number_unref0 (value);
							value = _tmp208_;
							_tmp209_ = c;
							_tmp210_ = value;
							currency_set_value (_tmp209_, _tmp210_);
							_number_unref0 (value);
							_g_object_unref0 (c);
						} else {
							gchar** _tmp211_;
							gint _tmp211__length1;
							const gchar* _tmp212_;
							_tmp211_ = tokens;
							_tmp211__length1 = tokens_length1;
							_tmp212_ = _tmp211_[0];
							g_warning ("currency.vala:275: Unknown currency '%s'", _tmp212_);
						}
						_g_free0 (symbol);
					}
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_free0 (filename);
	_g_hash_table_unref0 (name_map);
}


static void currency_manager_set_ecb_rate (CurrencyManager* self, xmlNode* node, Currency* eur_rate) {
	gchar* name;
	gchar* value;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp20_;
	gboolean _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (eur_rate != NULL);
	name = NULL;
	value = NULL;
	{
		xmlNode* _tmp0_;
		xmlAttr* _tmp1_;
		xmlAttr* attribute;
		_tmp0_ = node;
		_tmp1_ = _tmp0_->properties;
		attribute = _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				xmlAttr* _tmp6_;
				xmlAttr* _tmp7_;
				xmlNode* n;
				xmlAttr* _tmp8_;
				const gchar* _tmp9_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					xmlAttr* _tmp4_;
					xmlAttr* _tmp5_;
					_tmp4_ = attribute;
					_tmp5_ = _tmp4_->next;
					attribute = _tmp5_;
				}
				_tmp2_ = FALSE;
				_tmp6_ = attribute;
				if (!(_tmp6_ != NULL)) {
					break;
				}
				_tmp7_ = attribute;
				n = (xmlNode*) _tmp7_;
				_tmp8_ = attribute;
				_tmp9_ = _tmp8_->name;
				if (g_strcmp0 (_tmp9_, "currency") == 0) {
					xmlNode* _tmp10_;
					gchar* _tmp11_ = NULL;
					_tmp10_ = n;
					_tmp11_ = xmlNodeGetContent (_tmp10_);
					_g_free0 (name);
					name = _tmp11_;
				} else {
					xmlAttr* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = attribute;
					_tmp13_ = _tmp12_->name;
					if (g_strcmp0 (_tmp13_, "rate") == 0) {
						xmlNode* _tmp14_;
						gchar* _tmp15_ = NULL;
						_tmp14_ = n;
						_tmp15_ = xmlNodeGetContent (_tmp14_);
						_g_free0 (value);
						value = _tmp15_;
					}
				}
			}
		}
	}
	_tmp18_ = name;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		_tmp19_ = value;
		_tmp17_ = _tmp19_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp20_ = _tmp17_;
	if (_tmp20_) {
		const gchar* _tmp21_;
		Currency* _tmp22_ = NULL;
		Currency* _tmp23_;
		_tmp21_ = name;
		_tmp22_ = currency_manager_get_currency (self, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp16_ = _tmp23_ == NULL;
		_g_object_unref0 (_tmp23_);
	} else {
		_tmp16_ = FALSE;
	}
	_tmp24_ = _tmp16_;
	if (_tmp24_) {
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		Currency* _tmp28_ = NULL;
		Currency* c;
		const gchar* _tmp29_;
		Number* _tmp30_ = NULL;
		Number* r;
		Currency* _tmp31_;
		Number* _tmp32_ = NULL;
		Number* v;
		Number* _tmp33_;
		Number* _tmp34_;
		Number* _tmp35_ = NULL;
		Currency* _tmp36_;
		Number* _tmp37_;
		_tmp25_ = value;
		_tmp26_ = name;
		g_debug ("currency.vala:297: Using ECB rate of %s for %s", _tmp25_, _tmp26_);
		_tmp27_ = name;
		_tmp28_ = currency_manager_add_currency (self, _tmp27_);
		c = _tmp28_;
		_tmp29_ = value;
		_tmp30_ = mp_set_from_string (_tmp29_, 10);
		r = _tmp30_;
		_tmp31_ = eur_rate;
		_tmp32_ = currency_get_value (_tmp31_);
		v = _tmp32_;
		_tmp33_ = v;
		_tmp34_ = r;
		_tmp35_ = number_multiply (_tmp33_, _tmp34_);
		_number_unref0 (v);
		v = _tmp35_;
		_tmp36_ = c;
		_tmp37_ = v;
		currency_set_value (_tmp36_, _tmp37_);
		_number_unref0 (v);
		_number_unref0 (r);
		_g_object_unref0 (c);
	}
	_g_free0 (value);
	_g_free0 (name);
}


static void currency_manager_set_ecb_fixed_rate (CurrencyManager* self, const gchar* name, const gchar* value, Currency* eur_rate) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	Currency* _tmp3_ = NULL;
	Currency* c;
	const gchar* _tmp4_;
	Number* _tmp5_ = NULL;
	Number* r;
	Currency* _tmp6_;
	Number* _tmp7_ = NULL;
	Number* v;
	Number* _tmp8_;
	Number* _tmp9_ = NULL;
	Number* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_return_if_fail (eur_rate != NULL);
	_tmp0_ = value;
	_tmp1_ = name;
	g_debug ("currency.vala:308: Using ECB fixed rate of %s for %s", _tmp0_, _tmp1_);
	_tmp2_ = name;
	_tmp3_ = currency_manager_add_currency (self, _tmp2_);
	c = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = mp_set_from_string (_tmp4_, 10);
	r = _tmp5_;
	_tmp6_ = eur_rate;
	_tmp7_ = currency_get_value (_tmp6_);
	v = _tmp7_;
	_tmp8_ = v;
	_tmp9_ = number_divide (_tmp8_, r);
	_number_unref0 (v);
	v = _tmp9_;
	_tmp10_ = v;
	currency_set_value (c, _tmp10_);
	_number_unref0 (v);
	_number_unref0 (r);
	_g_object_unref0 (c);
}


static void currency_manager_load_ecb_rates (CurrencyManager* self) {
	Currency* _tmp0_ = NULL;
	Currency* eur_rate;
	Currency* _tmp1_;
	Currency* _tmp2_;
	Currency* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* filename;
	const gchar* _tmp5_;
	xmlDoc* _tmp6_ = NULL;
	xmlDoc* document;
	xmlDoc* _tmp7_;
	xmlDoc* _tmp9_;
	xmlXPathContext* _tmp10_;
	xmlXPathContext* xpath_ctx;
	xmlXPathContext* _tmp11_;
	xmlXPathContext* _tmp12_;
	xmlXPathContext* _tmp13_;
	xmlXPathObject* _tmp14_ = NULL;
	xmlXPathObject* xpath_obj;
	xmlXPathObject* _tmp15_;
	gint _tmp16_ = 0;
	xmlXPathObject* _tmp17_;
	xmlNodeSet* _tmp18_;
	gint _tmp22_;
	gint len;
	g_return_if_fail (self != NULL);
	_tmp0_ = currency_manager_get_currency (self, "EUR");
	eur_rate = _tmp0_;
	_tmp1_ = eur_rate;
	if (_tmp1_ == NULL) {
		g_warning ("currency.vala:322: Cannot use ECB rates as don't have EUR rate");
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp2_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "EEK", "0.06391", _tmp2_);
	_tmp3_ = eur_rate;
	currency_manager_set_ecb_fixed_rate (self, "CFA", "0.152449", _tmp3_);
	xmlInitParser ();
	_tmp4_ = currency_manager_get_ecb_rate_filepath (self);
	filename = _tmp4_;
	_tmp5_ = filename;
	_tmp6_ = xmlReadFile (_tmp5_, NULL, 0);
	document = _tmp6_;
	_tmp7_ = document;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = filename;
		g_warning ("currency.vala:335: Couldn't parse ECB rate file %s", _tmp8_);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp9_ = document;
	_tmp10_ = xmlXPathNewContext (_tmp9_);
	xpath_ctx = _tmp10_;
	_tmp11_ = xpath_ctx;
	if (_tmp11_ == NULL) {
		g_warning ("currency.vala:342: Couldn't create XPath context");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp12_ = xpath_ctx;
	xmlXPathRegisterNs (_tmp12_, "xref", "http://www.ecb.int/vocabulary/2002-08-01/eurofxref");
	_tmp13_ = xpath_ctx;
	_tmp14_ = xmlXPathEvalExpression ("//xref:Cube[@currency][@rate]", _tmp13_);
	xpath_obj = _tmp14_;
	_tmp15_ = xpath_obj;
	if (_tmp15_ == NULL) {
		g_warning ("currency.vala:350: Couldn't create XPath object");
		_xmlXPathFreeContext0 (xpath_ctx);
		_g_free0 (filename);
		_g_object_unref0 (eur_rate);
		return;
	}
	_tmp17_ = xpath_obj;
	_tmp18_ = _tmp17_->nodesetval;
	if (_tmp18_ != NULL) {
		xmlXPathObject* _tmp19_;
		xmlNodeSet* _tmp20_;
		gint _tmp21_ = 0;
		_tmp19_ = xpath_obj;
		_tmp20_ = _tmp19_->nodesetval;
		_tmp21_ = xmlXPathNodeSetGetLength (_tmp20_);
		_tmp16_ = _tmp21_;
	} else {
		_tmp16_ = 0;
	}
	_tmp22_ = _tmp16_;
	len = _tmp22_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				gint _tmp26_;
				gint _tmp27_;
				xmlXPathObject* _tmp28_;
				xmlNodeSet* _tmp29_;
				gint _tmp30_;
				xmlNode* _tmp31_ = NULL;
				xmlNode* node;
				xmlNode* _tmp32_;
				xmlElementType _tmp33_;
				xmlNode* _tmp36_;
				xmlElementType _tmp37_;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = i;
				_tmp27_ = len;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = xpath_obj;
				_tmp29_ = _tmp28_->nodesetval;
				_tmp30_ = i;
				_tmp31_ = xmlXPathNodeSetItem (_tmp29_, _tmp30_);
				node = _tmp31_;
				_tmp32_ = node;
				_tmp33_ = _tmp32_->type;
				if (_tmp33_ == XML_ELEMENT_NODE) {
					xmlNode* _tmp34_;
					Currency* _tmp35_;
					_tmp34_ = node;
					_tmp35_ = eur_rate;
					currency_manager_set_ecb_rate (self, _tmp34_, _tmp35_);
				}
				_tmp36_ = node;
				_tmp37_ = _tmp36_->type;
				if (_tmp37_ != XML_NAMESPACE_DECL) {
					node = NULL;
				}
			}
		}
	}
	xmlCleanupParser ();
	_xmlXPathFreeContext0 (xpath_ctx);
	_g_free0 (filename);
	_g_object_unref0 (eur_rate);
}


static gboolean currency_manager_load_rates (CurrencyManager* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	GList* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = loaded_rates;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = downloading_imf_rates;
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = downloading_ecb_rates;
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	currency_manager_load_imf_rates (self);
	currency_manager_load_ecb_rates (self);
	_tmp5_ = self->priv->currencies;
	{
		GList* c_collection = NULL;
		GList* c_it = NULL;
		c_collection = _tmp5_;
		for (c_it = c_collection; c_it != NULL; c_it = c_it->next) {
			Currency* _tmp6_;
			Currency* c = NULL;
			_tmp6_ = _g_object_ref0 ((Currency*) c_it->data);
			c = _tmp6_;
			{
				Currency* _tmp7_;
				Number* _tmp8_ = NULL;
				Number* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_;
				_tmp7_ = c;
				_tmp8_ = currency_get_value (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = number_is_zero (_tmp9_);
				_tmp11_ = _tmp10_;
				_number_unref0 (_tmp9_);
				if (_tmp11_) {
					Currency* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp12_ = c;
					_tmp13_ = currency_get_name (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_;
					g_warning ("currency.vala:386: Currency %s is not provided by IMF or ECB", _tmp15_);
					_g_free0 (_tmp15_);
				}
				_g_object_unref0 (c);
			}
		}
	}
	g_debug ("currency.vala:388: Rates loaded");
	loaded_rates = TRUE;
	g_signal_emit_by_name (self, "updated");
	result = TRUE;
	return result;
}


static void _currency_manager_download_imf_cb_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	currency_manager_download_imf_cb (self, source_object, res);
}


static void _currency_manager_download_ecb_cb_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	currency_manager_download_ecb_cb (self, source_object, res);
}


Number* currency_manager_get_value (CurrencyManager* self, const gchar* currency) {
	Number* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* path;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	Currency* _tmp16_ = NULL;
	Currency* c;
	Currency* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (currency != NULL, NULL);
	_tmp0_ = currency_manager_get_imf_rate_filepath (self);
	path = _tmp0_;
	_tmp2_ = downloading_imf_rates;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = path;
		_tmp4_ = currency_manager_file_needs_update (self, _tmp3_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		downloading_imf_rates = TRUE;
		g_debug ("currency.vala:403: Downloading rates from the IMF...");
		_tmp6_ = path;
		currency_manager_download_file (self, "http://www.imf.org/external/np/fin/data/rms_five.aspx?tsvflag=Y", _tmp6_, _currency_manager_download_imf_cb_gasync_ready_callback, self);
	}
	_tmp7_ = currency_manager_get_ecb_rate_filepath (self);
	_g_free0 (path);
	path = _tmp7_;
	_tmp9_ = downloading_ecb_rates;
	if (!_tmp9_) {
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = path;
		_tmp11_ = currency_manager_file_needs_update (self, _tmp10_, (gdouble) (((60 * 60) * 24) * 7));
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		const gchar* _tmp13_;
		downloading_ecb_rates = TRUE;
		g_debug ("currency.vala:410: Downloading rates from the ECB...");
		_tmp13_ = path;
		currency_manager_download_file (self, "http://www.ecb.europa.eu/stats/eurofxref/eurofxref-daily.xml", _tmp13_, _currency_manager_download_ecb_cb_gasync_ready_callback, self);
	}
	_tmp14_ = currency_manager_load_rates (self);
	if (!_tmp14_) {
		result = NULL;
		_g_free0 (path);
		return result;
	}
	_tmp15_ = currency;
	_tmp16_ = currency_manager_get_currency (self, _tmp15_);
	c = _tmp16_;
	_tmp17_ = c;
	if (_tmp17_ != NULL) {
		Currency* _tmp18_;
		Number* _tmp19_ = NULL;
		_tmp18_ = c;
		_tmp19_ = currency_get_value (_tmp18_);
		result = _tmp19_;
		_g_object_unref0 (c);
		_g_free0 (path);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (c);
		_g_free0 (path);
		return result;
	}
	_g_object_unref0 (c);
	_g_free0 (path);
}


static void currency_manager_download_file (CurrencyManager* self, const gchar* uri, const gchar* filename, GAsyncReadyCallback callback, void* callback_target) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* directory;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* source;
	const gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* dest;
	GAsyncReadyCallback _tmp6_;
	void* _tmp6__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = g_path_get_dirname (_tmp0_);
	directory = _tmp1_;
	g_mkdir_with_parents (directory, 0755);
	_tmp2_ = uri;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	source = _tmp3_;
	_tmp4_ = filename;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	dest = _tmp5_;
	_tmp6_ = callback;
	_tmp6__target = callback_target;
	g_file_copy_async (source, dest, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, _tmp6_, _tmp6__target);
	_g_object_unref0 (dest);
	_g_object_unref0 (source);
	_g_free0 (directory);
}


static void currency_manager_download_imf_cb (CurrencyManager* self, GObject* object, GAsyncResult* _result_) {
	GObject* _tmp0_;
	GFile* _tmp1_;
	GFile* f;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_FILE) ? ((GFile*) _tmp0_) : NULL);
	f = _tmp1_;
	{
		GAsyncResult* _tmp2_;
		_tmp2_ = _result_;
		g_file_copy_finish (f, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		g_debug ("currency.vala:442: IMF rates updated");
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("currency.vala:446: Couldn't download IMF currency rate file: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	downloading_imf_rates = FALSE;
	currency_manager_load_rates (self);
	_g_object_unref0 (f);
}


static void currency_manager_download_ecb_cb (CurrencyManager* self, GObject* object, GAsyncResult* _result_) {
	GObject* _tmp0_;
	GFile* _tmp1_;
	GFile* f;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = object;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_FILE) ? ((GFile*) _tmp0_) : NULL);
	f = _tmp1_;
	{
		GAsyncResult* _tmp2_;
		_tmp2_ = _result_;
		g_file_copy_finish (f, _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		g_debug ("currency.vala:459: ECB rates updated");
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("currency.vala:463: Couldn't download ECB currency rate file: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	downloading_ecb_rates = FALSE;
	currency_manager_load_rates (self);
	_g_object_unref0 (f);
}


CurrencyManager* currency_manager_construct (GType object_type) {
	CurrencyManager * self = NULL;
	self = (CurrencyManager*) g_object_new (object_type, NULL);
	return self;
}


CurrencyManager* currency_manager_new (void) {
	return currency_manager_construct (TYPE_CURRENCY_MANAGER);
}


static void currency_manager_class_init (CurrencyManagerClass * klass) {
	currency_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = currency_manager_finalize;
	g_signal_new ("updated", TYPE_CURRENCY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void currency_manager_instance_init (CurrencyManager * self) {
	self->priv = CURRENCY_MANAGER_GET_PRIVATE (self);
}


static void currency_manager_finalize (GObject* obj) {
	CurrencyManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY_MANAGER, CurrencyManager);
	__g_list_free__g_object_unref0_0 (self->priv->currencies);
	G_OBJECT_CLASS (currency_manager_parent_class)->finalize (obj);
}


GType currency_manager_get_type (void) {
	static volatile gsize currency_manager_type_id__volatile = 0;
	if (g_once_init_enter (&currency_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CurrencyManager), 0, (GInstanceInitFunc) currency_manager_instance_init, NULL };
		GType currency_manager_type_id;
		currency_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CurrencyManager", &g_define_type_info, 0);
		g_once_init_leave (&currency_manager_type_id__volatile, currency_manager_type_id);
	}
	return currency_manager_type_id__volatile;
}


Currency* currency_construct (GType object_type, const gchar* name, const gchar* display_name, const gchar* symbol) {
	Currency * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	self = (Currency*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp3_;
	_tmp4_ = symbol;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->_symbol);
	self->priv->_symbol = _tmp5_;
	return self;
}


Currency* currency_new (const gchar* name, const gchar* display_name, const gchar* symbol) {
	return currency_construct (TYPE_CURRENCY, name, display_name, symbol);
}


static gpointer _number_ref0 (gpointer self) {
	return self ? number_ref (self) : NULL;
}


void currency_set_value (Currency* self, Number* value) {
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _number_ref0 (_tmp0_);
	_number_unref0 (self->priv->value);
	self->priv->value = _tmp1_;
}


Number* currency_get_value (Currency* self) {
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->value;
	_tmp1_ = _number_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_display_name (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* currency_get_symbol (Currency* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbol;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void currency_class_init (CurrencyClass * klass) {
	currency_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CurrencyPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_currency_get_property;
	G_OBJECT_CLASS (klass)->finalize = currency_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CURRENCY_SYMBOL, g_param_spec_string ("symbol", "symbol", "symbol", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void currency_instance_init (Currency * self) {
	self->priv = CURRENCY_GET_PRIVATE (self);
}


static void currency_finalize (GObject* obj) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CURRENCY, Currency);
	_number_unref0 (self->priv->value);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_symbol);
	G_OBJECT_CLASS (currency_parent_class)->finalize (obj);
}


GType currency_get_type (void) {
	static volatile gsize currency_type_id__volatile = 0;
	if (g_once_init_enter (&currency_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CurrencyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) currency_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Currency), 0, (GInstanceInitFunc) currency_instance_init, NULL };
		GType currency_type_id;
		currency_type_id = g_type_register_static (G_TYPE_OBJECT, "Currency", &g_define_type_info, 0);
		g_once_init_leave (&currency_type_id__volatile, currency_type_id);
	}
	return currency_type_id__volatile;
}


static void _vala_currency_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Currency * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CURRENCY, Currency);
	switch (property_id) {
		case CURRENCY_NAME:
		g_value_take_string (value, currency_get_name (self));
		break;
		case CURRENCY_DISPLAY_NAME:
		g_value_take_string (value, currency_get_display_name (self));
		break;
		case CURRENCY_SYMBOL:
		g_value_take_string (value, currency_get_symbol (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



