/* valatrystatement.c generated by valac, the Vala compiler
 * generated from valatrystatement.vala, do not modify */

/* valatrystatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;

#define VALA_TYPE_STATEMENT (vala_statement_get_type ())
#define VALA_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STATEMENT, ValaStatement))
#define VALA_IS_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STATEMENT))
#define VALA_STATEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_STATEMENT, ValaStatementIface))

typedef struct _ValaStatement ValaStatement;
typedef struct _ValaStatementIface ValaStatementIface;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;
typedef struct _ValaTryStatementPrivate ValaTryStatementPrivate;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaStatementIface {
	GTypeInterface parent_iface;
};

struct _ValaTryStatement {
	ValaCodeNode parent_instance;
	ValaTryStatementPrivate * priv;
};

struct _ValaTryStatementClass {
	ValaCodeNodeClass parent_class;
};

struct _ValaTryStatementPrivate {
	gboolean _after_try_block_reachable;
	ValaBlock* _body;
	ValaBlock* _finally_body;
	ValaList* catch_clauses;
};


static gpointer vala_try_statement_parent_class = NULL;
static ValaStatementIface* vala_try_statement_vala_statement_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_statement_get_type (void) G_GNUC_CONST;
GType vala_try_statement_get_type (void) G_GNUC_CONST;
GType vala_block_get_type (void) G_GNUC_CONST;
GType vala_catch_clause_get_type (void) G_GNUC_CONST;
#define VALA_TRY_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TRY_STATEMENT, ValaTryStatementPrivate))
enum  {
	VALA_TRY_STATEMENT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
ValaTryStatement* vala_try_statement_construct (GType object_type, ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference);
ValaCodeNode* vala_code_node_construct (GType object_type);
void vala_try_statement_set_body (ValaTryStatement* self, ValaBlock* value);
void vala_try_statement_set_finally_body (ValaTryStatement* self, ValaBlock* value);
void vala_code_node_set_source_reference (ValaCodeNode* self, ValaSourceReference* value);
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaList* vala_try_statement_get_catch_clauses (ValaTryStatement* self);
static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_try_statement (ValaCodeVisitor* self, ValaTryStatement* stmt);
static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaBlock* vala_try_statement_get_body (ValaTryStatement* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaBlock* vala_try_statement_get_finally_body (ValaTryStatement* self);
static gboolean vala_try_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
ValaList* vala_code_node_get_error_types (ValaCodeNode* self);
ValaDataType* vala_catch_clause_get_error_type (ValaCatchClause* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
ValaBlock* vala_catch_clause_get_body (ValaCatchClause* self);
void vala_code_node_add_error_types (ValaCodeNode* self, ValaList* error_types);
static void vala_try_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
gboolean vala_try_statement_get_after_try_block_reachable (ValaTryStatement* self);
void vala_try_statement_set_after_try_block_reachable (ValaTryStatement* self, gboolean value);
static void vala_try_statement_finalize (ValaCodeNode* obj);


/**
 * Creates a new try statement.
 *
 * @param body             body of the try statement
 * @param finally_body     body of the optional finally clause
 * @param source_reference reference to source code
 * @return                 newly created try statement
 */
ValaTryStatement* vala_try_statement_construct (GType object_type, ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference) {
	ValaTryStatement* self = NULL;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaTryStatement*) vala_code_node_construct (object_type);
	_tmp0_ = body;
	vala_try_statement_set_body (self, _tmp0_);
	_tmp1_ = finally_body;
	vala_try_statement_set_finally_body (self, _tmp1_);
	_tmp2_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	return self;
}


ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference) {
	return vala_try_statement_construct (VALA_TYPE_TRY_STATEMENT, body, finally_body, source_reference);
}


/**
 * Appends the specified clause to the list of catch clauses.
 *
 * @param clause a catch clause
 */
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause) {
	ValaCatchClause* _tmp0_;
	ValaList* _tmp1_;
	ValaCatchClause* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	_tmp0_ = clause;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = self->priv->catch_clauses;
	_tmp2_ = clause;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
}


/**
 * Returns a copy of the list of catch clauses.
 *
 * @return list of catch clauses
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_try_statement_get_catch_clauses (ValaTryStatement* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->catch_clauses;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTryStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_try_statement (_tmp0_, self);
}


static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTryStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaBlock* _tmp16_;
	ValaBlock* _tmp17_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_try_statement_get_body (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	{
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		ValaList* _clause_list;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _clause_size;
		gint _clause_index;
		_tmp3_ = self->priv->catch_clauses;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_clause_list = _tmp4_;
		_tmp5_ = _clause_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_clause_size = _tmp7_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			ValaCatchClause* clause;
			ValaCatchClause* _tmp14_;
			ValaCodeVisitor* _tmp15_;
			_tmp8_ = _clause_index;
			_clause_index = _tmp8_ + 1;
			_tmp9_ = _clause_index;
			_tmp10_ = _clause_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _clause_list;
			_tmp12_ = _clause_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			clause = (ValaCatchClause*) _tmp13_;
			_tmp14_ = clause;
			_tmp15_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp16_ = vala_try_statement_get_finally_body (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaBlock* _tmp18_;
		ValaBlock* _tmp19_;
		ValaCodeVisitor* _tmp20_;
		_tmp18_ = vala_try_statement_get_finally_body (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, _tmp20_);
	}
}


static gboolean vala_try_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaTryStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaCodeContext* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	ValaArrayList* error_types;
	GEqualFunc _tmp23_;
	ValaArrayList* _tmp24_;
	ValaArrayList* handled_error_types;
	ValaBlock* _tmp90_;
	ValaBlock* _tmp91_;
	ValaArrayList* _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp111_;
	self = (ValaTryStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_try_statement_get_body (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp7_);
	error_types = _tmp8_;
	{
		ValaBlock* _tmp9_;
		ValaBlock* _tmp10_;
		ValaList* _tmp11_ = NULL;
		ValaList* _body_error_type_list;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _body_error_type_size;
		gint _body_error_type_index;
		_tmp9_ = vala_try_statement_get_body (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp10_);
		_body_error_type_list = _tmp11_;
		_tmp12_ = _body_error_type_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_body_error_type_size = _tmp14_;
		_body_error_type_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_ = NULL;
			ValaDataType* body_error_type;
			ValaArrayList* _tmp21_;
			ValaDataType* _tmp22_;
			_tmp15_ = _body_error_type_index;
			_body_error_type_index = _tmp15_ + 1;
			_tmp16_ = _body_error_type_index;
			_tmp17_ = _body_error_type_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _body_error_type_list;
			_tmp19_ = _body_error_type_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			body_error_type = (ValaDataType*) _tmp20_;
			_tmp21_ = error_types;
			_tmp22_ = body_error_type;
			vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
			_vala_code_node_unref0 (body_error_type);
		}
		_vala_iterable_unref0 (_body_error_type_list);
	}
	_tmp23_ = g_direct_equal;
	_tmp24_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp23_);
	handled_error_types = _tmp24_;
	{
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		ValaList* _clause_list;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _clause_size;
		gint _clause_index;
		_tmp25_ = self->priv->catch_clauses;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_clause_list = _tmp26_;
		_tmp27_ = _clause_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_clause_size = _tmp29_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_ = NULL;
			ValaCatchClause* clause;
			ValaArrayList* _tmp72_;
			ValaCatchClause* _tmp73_;
			ValaCodeContext* _tmp74_;
			_tmp30_ = _clause_index;
			_clause_index = _tmp30_ + 1;
			_tmp31_ = _clause_index;
			_tmp32_ = _clause_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _clause_list;
			_tmp34_ = _clause_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			clause = (ValaCatchClause*) _tmp35_;
			{
				ValaArrayList* _tmp36_;
				ValaArrayList* _tmp37_;
				ValaArrayList* _body_error_type_list;
				ValaArrayList* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _body_error_type_size;
				gint _body_error_type_index;
				_tmp36_ = error_types;
				_tmp37_ = _vala_iterable_ref0 (_tmp36_);
				_body_error_type_list = _tmp37_;
				_tmp38_ = _body_error_type_list;
				_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_body_error_type_size = _tmp40_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					ValaArrayList* _tmp44_;
					gint _tmp45_;
					gpointer _tmp46_ = NULL;
					ValaDataType* body_error_type;
					gboolean _tmp47_ = FALSE;
					ValaCatchClause* _tmp48_;
					ValaDataType* _tmp49_;
					ValaDataType* _tmp50_;
					gboolean _tmp56_;
					_tmp41_ = _body_error_type_index;
					_body_error_type_index = _tmp41_ + 1;
					_tmp42_ = _body_error_type_index;
					_tmp43_ = _body_error_type_size;
					if (!(_tmp42_ < _tmp43_)) {
						break;
					}
					_tmp44_ = _body_error_type_list;
					_tmp45_ = _body_error_type_index;
					_tmp46_ = vala_list_get ((ValaList*) _tmp44_, _tmp45_);
					body_error_type = (ValaDataType*) _tmp46_;
					_tmp48_ = clause;
					_tmp49_ = vala_catch_clause_get_error_type (_tmp48_);
					_tmp50_ = _tmp49_;
					if (_tmp50_ == NULL) {
						_tmp47_ = TRUE;
					} else {
						ValaDataType* _tmp51_;
						ValaCatchClause* _tmp52_;
						ValaDataType* _tmp53_;
						ValaDataType* _tmp54_;
						gboolean _tmp55_ = FALSE;
						_tmp51_ = body_error_type;
						_tmp52_ = clause;
						_tmp53_ = vala_catch_clause_get_error_type (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = vala_data_type_compatible (_tmp51_, _tmp54_);
						_tmp47_ = _tmp55_;
					}
					_tmp56_ = _tmp47_;
					if (_tmp56_) {
						ValaArrayList* _tmp57_;
						ValaDataType* _tmp58_;
						_tmp57_ = handled_error_types;
						_tmp58_ = body_error_type;
						vala_collection_add ((ValaCollection*) _tmp57_, _tmp58_);
					}
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			{
				ValaArrayList* _tmp59_;
				ValaArrayList* _tmp60_;
				ValaArrayList* _handled_error_type_list;
				ValaArrayList* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				gint _handled_error_type_size;
				gint _handled_error_type_index;
				_tmp59_ = handled_error_types;
				_tmp60_ = _vala_iterable_ref0 (_tmp59_);
				_handled_error_type_list = _tmp60_;
				_tmp61_ = _handled_error_type_list;
				_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
				_tmp63_ = _tmp62_;
				_handled_error_type_size = _tmp63_;
				_handled_error_type_index = -1;
				while (TRUE) {
					gint _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					ValaArrayList* _tmp67_;
					gint _tmp68_;
					gpointer _tmp69_ = NULL;
					ValaDataType* handled_error_type;
					ValaArrayList* _tmp70_;
					ValaDataType* _tmp71_;
					_tmp64_ = _handled_error_type_index;
					_handled_error_type_index = _tmp64_ + 1;
					_tmp65_ = _handled_error_type_index;
					_tmp66_ = _handled_error_type_size;
					if (!(_tmp65_ < _tmp66_)) {
						break;
					}
					_tmp67_ = _handled_error_type_list;
					_tmp68_ = _handled_error_type_index;
					_tmp69_ = vala_list_get ((ValaList*) _tmp67_, _tmp68_);
					handled_error_type = (ValaDataType*) _tmp69_;
					_tmp70_ = error_types;
					_tmp71_ = handled_error_type;
					vala_collection_remove ((ValaCollection*) _tmp70_, _tmp71_);
					_vala_code_node_unref0 (handled_error_type);
				}
				_vala_iterable_unref0 (_handled_error_type_list);
			}
			_tmp72_ = handled_error_types;
			vala_collection_clear ((ValaCollection*) _tmp72_);
			_tmp73_ = clause;
			_tmp74_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp73_, _tmp74_);
			{
				ValaCatchClause* _tmp75_;
				ValaBlock* _tmp76_;
				ValaBlock* _tmp77_;
				ValaList* _tmp78_ = NULL;
				ValaList* _body_error_type_list;
				ValaList* _tmp79_;
				gint _tmp80_;
				gint _tmp81_;
				gint _body_error_type_size;
				gint _body_error_type_index;
				_tmp75_ = clause;
				_tmp76_ = vala_catch_clause_get_body (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp77_);
				_body_error_type_list = _tmp78_;
				_tmp79_ = _body_error_type_list;
				_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
				_tmp81_ = _tmp80_;
				_body_error_type_size = _tmp81_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp82_;
					gint _tmp83_;
					gint _tmp84_;
					ValaList* _tmp85_;
					gint _tmp86_;
					gpointer _tmp87_ = NULL;
					ValaDataType* body_error_type;
					ValaArrayList* _tmp88_;
					ValaDataType* _tmp89_;
					_tmp82_ = _body_error_type_index;
					_body_error_type_index = _tmp82_ + 1;
					_tmp83_ = _body_error_type_index;
					_tmp84_ = _body_error_type_size;
					if (!(_tmp83_ < _tmp84_)) {
						break;
					}
					_tmp85_ = _body_error_type_list;
					_tmp86_ = _body_error_type_index;
					_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
					body_error_type = (ValaDataType*) _tmp87_;
					_tmp88_ = error_types;
					_tmp89_ = body_error_type;
					vala_collection_add ((ValaCollection*) _tmp88_, _tmp89_);
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp90_ = vala_try_statement_get_finally_body (self);
	_tmp91_ = _tmp90_;
	if (_tmp91_ != NULL) {
		ValaBlock* _tmp92_;
		ValaBlock* _tmp93_;
		ValaCodeContext* _tmp94_;
		_tmp92_ = vala_try_statement_get_finally_body (self);
		_tmp93_ = _tmp92_;
		_tmp94_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp93_, _tmp94_);
		{
			ValaBlock* _tmp95_;
			ValaBlock* _tmp96_;
			ValaList* _tmp97_ = NULL;
			ValaList* _body_error_type_list;
			ValaList* _tmp98_;
			gint _tmp99_;
			gint _tmp100_;
			gint _body_error_type_size;
			gint _body_error_type_index;
			_tmp95_ = vala_try_statement_get_finally_body (self);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp96_);
			_body_error_type_list = _tmp97_;
			_tmp98_ = _body_error_type_list;
			_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
			_tmp100_ = _tmp99_;
			_body_error_type_size = _tmp100_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				ValaList* _tmp104_;
				gint _tmp105_;
				gpointer _tmp106_ = NULL;
				ValaDataType* body_error_type;
				ValaArrayList* _tmp107_;
				ValaDataType* _tmp108_;
				_tmp101_ = _body_error_type_index;
				_body_error_type_index = _tmp101_ + 1;
				_tmp102_ = _body_error_type_index;
				_tmp103_ = _body_error_type_size;
				if (!(_tmp102_ < _tmp103_)) {
					break;
				}
				_tmp104_ = _body_error_type_list;
				_tmp105_ = _body_error_type_index;
				_tmp106_ = vala_list_get (_tmp104_, _tmp105_);
				body_error_type = (ValaDataType*) _tmp106_;
				_tmp107_ = error_types;
				_tmp108_ = body_error_type;
				vala_collection_add ((ValaCollection*) _tmp107_, _tmp108_);
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp109_ = error_types;
	vala_code_node_add_error_types ((ValaCodeNode*) self, (ValaList*) _tmp109_);
	_tmp110_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp111_ = _tmp110_;
	result = !_tmp111_;
	_vala_iterable_unref0 (handled_error_types);
	_vala_iterable_unref0 (error_types);
	return result;
}


static void vala_try_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaTryStatement * self;
	ValaCodeGenerator* _tmp0_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_try_statement ((ValaCodeVisitor*) _tmp0_, self);
}


ValaBlock* vala_try_statement_get_body (ValaTryStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_try_statement_set_body (ValaTryStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp1_;
	_tmp2_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_try_statement_get_finally_body (ValaTryStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finally_body;
	result = _tmp0_;
	return result;
}


void vala_try_statement_set_finally_body (ValaTryStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_finally_body);
	self->priv->_finally_body = _tmp1_;
	_tmp2_ = self->priv->_finally_body;
	if (_tmp2_ != NULL) {
		ValaBlock* _tmp3_;
		_tmp3_ = self->priv->_finally_body;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


gboolean vala_try_statement_get_after_try_block_reachable (ValaTryStatement* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_after_try_block_reachable;
	result = _tmp0_;
	return result;
}


void vala_try_statement_set_after_try_block_reachable (ValaTryStatement* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_after_try_block_reachable = _tmp0_;
}


static void vala_try_statement_class_init (ValaTryStatementClass * klass) {
	vala_try_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_try_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaTryStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_try_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_try_statement_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->check = vala_try_statement_real_check;
	VALA_CODE_NODE_CLASS (klass)->emit = vala_try_statement_real_emit;
}


static void vala_try_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_try_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_try_statement_instance_init (ValaTryStatement * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_TRY_STATEMENT_GET_PRIVATE (self);
	self->priv->_after_try_block_reachable = TRUE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, _tmp0_);
	self->priv->catch_clauses = (ValaList*) _tmp1_;
}


static void vala_try_statement_finalize (ValaCodeNode* obj) {
	ValaTryStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TRY_STATEMENT, ValaTryStatement);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_finally_body);
	_vala_iterable_unref0 (self->priv->catch_clauses);
	VALA_CODE_NODE_CLASS (vala_try_statement_parent_class)->finalize (obj);
}


/**
 * Represents a try statement in the source code.
 */
GType vala_try_statement_get_type (void) {
	static volatile gsize vala_try_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_try_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTryStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_try_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTryStatement), 0, (GInstanceInitFunc) vala_try_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_try_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_try_statement_type_id;
		vala_try_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTryStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_try_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_try_statement_type_id__volatile, vala_try_statement_type_id);
	}
	return vala_try_statement_type_id__volatile;
}



