/* baobab-location-list.c generated by valac 0.17.3.12-6a5ea3, the Vala compiler
 * generated from baobab-location-list.vala, do not modify */

/* -*- indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>


#define EGG_TYPE_LIST_BOX (egg_list_box_get_type ())
#define EGG_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EGG_TYPE_LIST_BOX, EggListBox))
#define EGG_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EGG_TYPE_LIST_BOX, EggListBoxClass))
#define EGG_IS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EGG_TYPE_LIST_BOX))
#define EGG_IS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EGG_TYPE_LIST_BOX))
#define EGG_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EGG_TYPE_LIST_BOX, EggListBoxClass))

typedef struct _EggListBox EggListBox;
typedef struct _EggListBoxClass EggListBoxClass;
typedef struct _EggListBoxPrivate EggListBoxPrivate;

#define BAOBAB_TYPE_LOCATION_LIST (baobab_location_list_get_type ())
#define BAOBAB_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList))
#define BAOBAB_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))
#define BAOBAB_IS_LOCATION_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_IS_LOCATION_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_LIST))
#define BAOBAB_LOCATION_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListClass))

typedef struct _BaobabLocationList BaobabLocationList;
typedef struct _BaobabLocationListClass BaobabLocationListClass;
typedef struct _BaobabLocationListPrivate BaobabLocationListPrivate;

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__baobab_location_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_location_unref0_ (var), NULL)))

#define BAOBAB_TYPE_LOCATION_WIDGET (baobab_location_widget_get_type ())
#define BAOBAB_LOCATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidget))
#define BAOBAB_LOCATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidgetClass))
#define BAOBAB_IS_LOCATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_WIDGET))
#define BAOBAB_IS_LOCATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_WIDGET))
#define BAOBAB_LOCATION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidgetClass))

typedef struct _BaobabLocationWidget BaobabLocationWidget;
typedef struct _BaobabLocationWidgetClass BaobabLocationWidgetClass;
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _EggListBox {
	GtkContainer parent_instance;
	EggListBoxPrivate * priv;
};

struct _EggListBoxClass {
	GtkContainerClass parent_class;
	void (*child_selected) (EggListBox* self, GtkWidget* child);
	void (*child_activated) (EggListBox* self, GtkWidget* child);
	void (*activate_cursor_child) (EggListBox* self);
	void (*toggle_cursor_child) (EggListBox* self);
	void (*move_cursor) (EggListBox* self, GtkMovementStep step, gint count);
};

struct _BaobabLocationList {
	EggListBox parent_instance;
	BaobabLocationListPrivate * priv;
};

struct _BaobabLocationListClass {
	EggListBoxClass parent_class;
};

typedef void (*BaobabLocationListLocationAction) (BaobabLocation* l, void* user_data);
struct _BaobabLocationListPrivate {
	GVolumeMonitor* monitor;
	GList* locations;
	BaobabLocationListLocationAction location_action;
	gpointer location_action_target;
	GDestroyNotify location_action_target_destroy_notify;
};

typedef void (*EggListBoxUpdateSeparatorFunc) (GtkWidget** separator, GtkWidget* child, GtkWidget* before, void* user_data);

static gpointer baobab_location_list_parent_class = NULL;

GType egg_list_box_get_type (void) G_GNUC_CONST;
GType baobab_location_list_get_type (void) G_GNUC_CONST;
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION_LIST, BaobabLocationListPrivate))
enum  {
	BAOBAB_LOCATION_LIST_DUMMY_PROPERTY
};
static void _baobab_location_unref0_ (gpointer var);
static void _g_list_free__baobab_location_unref0_ (GList* self);
#define BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS 5
static void baobab_location_list_update_separator (BaobabLocationList* self, GtkWidget** separator, GtkWidget* widget, GtkWidget* before_widget);
static void baobab_location_list_real_child_activated (EggListBox* base, GtkWidget* widget);
GType baobab_location_widget_get_type (void) G_GNUC_CONST;
BaobabLocation* baobab_location_widget_get_location (BaobabLocationWidget* self);
static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume);
void baobab_location_list_update (BaobabLocationList* self);
static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume);
GVolume* baobab_location_get_volume (BaobabLocation* self);
static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume);
BaobabLocation* baobab_location_new_from_volume (GVolume* volume_);
BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_);
static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount);
static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount);
GMount* baobab_location_get_mount (BaobabLocation* self);
static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount);
BaobabLocation* baobab_location_new_from_mount (GMount* mount_);
BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_);
void baobab_location_update (BaobabLocation* self);
static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file);
GFile* baobab_location_get_file (BaobabLocation* self);
static void baobab_location_list_populate (BaobabLocationList* self);
BaobabLocation* baobab_location_new_for_main_volume (void);
BaobabLocation* baobab_location_construct_for_main_volume (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
BaobabLocation* baobab_location_get_home_location (void);
BaobabLocation* baobab_location_new_for_recent_info (GtkRecentInfo* recent_info);
BaobabLocation* baobab_location_construct_for_recent_info (GType object_type, GtkRecentInfo* recent_info);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify);
static void __lambda4_ (BaobabLocationList* self, GtkWidget* widget);
static void ___lambda4__gtk_callback (GtkWidget* widget, gpointer self);
BaobabLocationWidget* baobab_location_widget_new (BaobabLocation* location_);
BaobabLocationWidget* baobab_location_widget_construct (GType object_type, BaobabLocation* location_);
void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void gtk_recent_data_destroy (GtkRecentData* self);
BaobabLocationList* baobab_location_list_new (void);
BaobabLocationList* baobab_location_list_construct (GType object_type);
EggListBox* egg_list_box_new (void);
EggListBox* egg_list_box_construct (GType object_type);
static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
void egg_list_box_set_selection_mode (EggListBox* self, GtkSelectionMode mode);
void egg_list_box_set_separator_funcs (EggListBox* self, EggListBoxUpdateSeparatorFunc update_separator, void* update_separator_target, GDestroyNotify update_separator_target_destroy_notify);
static void _baobab_location_list_update_separator_egg_list_box_update_separator_func (GtkWidget** separator, GtkWidget* child, GtkWidget* before, gpointer self);
static void baobab_location_list_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _baobab_location_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL));
}


static void _g_list_free__baobab_location_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_location_unref0_, NULL);
	g_list_free (self);
}


static void baobab_location_list_update_separator (BaobabLocationList* self, GtkWidget** separator, GtkWidget* widget, GtkWidget* before_widget) {
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp1_ = before_widget;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		_tmp2_ = *separator;
		_tmp0_ = _tmp2_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkSeparator* _tmp4_;
		_tmp4_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (*separator);
		*separator = (GtkWidget*) _tmp4_;
	} else {
		_g_object_unref0 (*separator);
		*separator = NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_location_list_real_child_activated (EggListBox* base, GtkWidget* widget) {
	BaobabLocationList * self;
	BaobabLocationListLocationAction _tmp0_;
	void* _tmp0__target;
	self = (BaobabLocationList*) base;
	_tmp0_ = self->priv->location_action;
	_tmp0__target = self->priv->location_action_target;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		BaobabLocationWidget* _tmp2_;
		BaobabLocationWidget* location_widget;
		BaobabLocationListLocationAction _tmp3_;
		void* _tmp3__target;
		BaobabLocationWidget* _tmp4_;
		BaobabLocation* _tmp5_;
		BaobabLocation* _tmp6_;
		_tmp1_ = widget;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, BAOBAB_TYPE_LOCATION_WIDGET) ? ((BaobabLocationWidget*) _tmp1_) : NULL);
		location_widget = _tmp2_;
		_tmp3_ = self->priv->location_action;
		_tmp3__target = self->priv->location_action_target;
		_tmp4_ = location_widget;
		_tmp5_ = baobab_location_widget_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp3_ (_tmp6_, _tmp3__target);
		_g_object_unref0 (location_widget);
	}
}


static void baobab_location_list_volume_changed (BaobabLocationList* self, GVolume* volume) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	baobab_location_list_update (self);
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void baobab_location_list_volume_removed (BaobabLocationList* self, GVolume* volume) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GVolume* _tmp3_;
				GVolume* _tmp4_;
				GVolume* _tmp5_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = volume;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_volume_added (BaobabLocationList* self, GVolume* volume) {
	GVolume* _tmp0_;
	BaobabLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = volume;
	_tmp1_ = baobab_location_new_from_volume (_tmp0_);
	self->priv->locations = g_list_append (self->priv->locations, _tmp1_);
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_changed (BaobabLocationList* self, GMount* mount) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
}


static void baobab_location_list_mount_removed (BaobabLocationList* self, GMount* mount) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GMount* _tmp3_;
				GMount* _tmp4_;
				GMount* _tmp5_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_mount (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = mount;
				if (_tmp4_ == _tmp5_) {
					BaobabLocation* _tmp6_;
					_tmp6_ = location;
					self->priv->locations = g_list_remove (self->priv->locations, _tmp6_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}


static void baobab_location_list_mount_added (BaobabLocationList* self, GMount* mount) {
	GMount* _tmp0_;
	GVolume* _tmp1_ = NULL;
	GVolume* volume;
	GVolume* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = mount;
	_tmp1_ = g_mount_get_volume (_tmp0_);
	volume = _tmp1_;
	_tmp2_ = volume;
	if (_tmp2_ == NULL) {
		GMount* _tmp3_;
		BaobabLocation* _tmp4_;
		_tmp3_ = mount;
		_tmp4_ = baobab_location_new_from_mount (_tmp3_);
		self->priv->locations = g_list_append (self->priv->locations, _tmp4_);
	} else {
		GList* _tmp5_;
		_tmp5_ = self->priv->locations;
		{
			GList* location_collection = NULL;
			GList* location_it = NULL;
			location_collection = _tmp5_;
			for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
				BaobabLocation* _tmp6_;
				BaobabLocation* location = NULL;
				_tmp6_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
				location = _tmp6_;
				{
					BaobabLocation* _tmp7_;
					GVolume* _tmp8_;
					GVolume* _tmp9_;
					GVolume* _tmp10_;
					_tmp7_ = location;
					_tmp8_ = baobab_location_get_volume (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = volume;
					if (_tmp9_ == _tmp10_) {
						BaobabLocation* _tmp11_;
						_tmp11_ = location;
						baobab_location_update (_tmp11_);
						_baobab_location_unref0 (location);
						break;
					}
					_baobab_location_unref0 (location);
				}
			}
		}
	}
	baobab_location_list_update (self);
	_g_object_unref0 (volume);
}


static gboolean baobab_location_list_already_present (BaobabLocationList* self, GFile* file) {
	gboolean result = FALSE;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* l = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) l_it->data);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				BaobabLocation* _tmp3_;
				GFile* _tmp4_;
				GFile* _tmp5_;
				gboolean _tmp11_;
				_tmp3_ = l;
				_tmp4_ = baobab_location_get_file (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					BaobabLocation* _tmp6_;
					GFile* _tmp7_;
					GFile* _tmp8_;
					GFile* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp6_ = l;
					_tmp7_ = baobab_location_get_file (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = file;
					_tmp10_ = g_file_equal (_tmp8_, _tmp9_);
					_tmp2_ = _tmp10_;
				} else {
					_tmp2_ = FALSE;
				}
				_tmp11_ = _tmp2_;
				if (_tmp11_) {
					result = TRUE;
					_baobab_location_unref0 (l);
					return result;
				}
				_baobab_location_unref0 (l);
			}
		}
	}
	result = FALSE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
	g_list_free (self);
}


static void baobab_location_list_populate (BaobabLocationList* self) {
	BaobabLocation* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GList* _tmp2_ = NULL;
	GVolumeMonitor* _tmp6_;
	GList* _tmp7_ = NULL;
	BaobabLocation* _tmp15_ = NULL;
	GtkRecentManager* _tmp16_ = NULL;
	GtkRecentManager* _tmp17_;
	GtkRecentManager* recent_manager;
	GtkRecentManager* _tmp18_;
	GList* _tmp19_ = NULL;
	GList* recent_items;
	gint n_recents;
	GList* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_new_for_main_volume ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp0_);
	_tmp1_ = self->priv->monitor;
	_tmp2_ = g_volume_monitor_get_volumes (_tmp1_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp2_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp3_;
			GVolume* volume = NULL;
			_tmp3_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp3_;
			{
				GVolume* _tmp4_;
				BaobabLocation* _tmp5_;
				_tmp4_ = volume;
				_tmp5_ = baobab_location_new_from_volume (_tmp4_);
				self->priv->locations = g_list_append (self->priv->locations, _tmp5_);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
	_tmp6_ = self->priv->monitor;
	_tmp7_ = g_volume_monitor_get_mounts (_tmp6_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp7_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp8_;
			GMount* mount = NULL;
			_tmp8_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp8_;
			{
				GMount* _tmp9_;
				GVolume* _tmp10_ = NULL;
				GVolume* _tmp11_;
				gboolean _tmp12_;
				_tmp9_ = mount;
				_tmp10_ = g_mount_get_volume (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_ == NULL;
				_g_object_unref0 (_tmp11_);
				if (_tmp12_) {
					GMount* _tmp13_;
					BaobabLocation* _tmp14_;
					_tmp13_ = mount;
					_tmp14_ = baobab_location_new_from_mount (_tmp13_);
					self->priv->locations = g_list_append (self->priv->locations, _tmp14_);
				} else {
				}
				_g_object_unref0 (mount);
			}
		}
		__g_list_free__g_object_unref0_0 (mount_collection);
	}
	_tmp15_ = baobab_location_get_home_location ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp15_);
	_tmp16_ = gtk_recent_manager_get_default ();
	_tmp17_ = _g_object_ref0 (_tmp16_);
	recent_manager = _tmp17_;
	_tmp18_ = recent_manager;
	_tmp19_ = gtk_recent_manager_get_items (_tmp18_);
	recent_items = _tmp19_;
	n_recents = 0;
	_tmp20_ = recent_items;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp20_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GtkRecentInfo* _tmp21_;
			GtkRecentInfo* info = NULL;
			_tmp21_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) info_it->data);
			info = _tmp21_;
			{
				gint _tmp22_;
				gboolean _tmp23_ = FALSE;
				GtkRecentInfo* _tmp24_;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp28_;
				_tmp22_ = n_recents;
				if (_tmp22_ >= BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS) {
					_gtk_recent_info_unref0 (info);
					break;
				}
				_tmp24_ = info;
				_tmp25_ = gtk_recent_info_has_group (_tmp24_, "baobab");
				if (_tmp25_) {
					GtkRecentInfo* _tmp26_;
					gboolean _tmp27_ = FALSE;
					_tmp26_ = info;
					_tmp27_ = gtk_recent_info_exists (_tmp26_);
					_tmp23_ = _tmp27_;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp28_ = _tmp23_;
				if (_tmp28_) {
					GtkRecentInfo* _tmp29_;
					const gchar* _tmp30_ = NULL;
					GFile* _tmp31_ = NULL;
					GFile* _tmp32_;
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_;
					_tmp29_ = info;
					_tmp30_ = gtk_recent_info_get_uri (_tmp29_);
					_tmp31_ = g_file_new_for_uri (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = baobab_location_list_already_present (self, _tmp32_);
					_tmp34_ = !_tmp33_;
					_g_object_unref0 (_tmp32_);
					if (_tmp34_) {
						GtkRecentInfo* _tmp35_;
						BaobabLocation* _tmp36_;
						gint _tmp37_;
						_tmp35_ = info;
						_tmp36_ = baobab_location_new_for_recent_info (_tmp35_);
						self->priv->locations = g_list_append (self->priv->locations, _tmp36_);
						_tmp37_ = n_recents;
						n_recents = _tmp37_ + 1;
					}
				}
				_gtk_recent_info_unref0 (info);
			}
		}
	}
	baobab_location_list_update (self);
	__g_list_free__gtk_recent_info_unref0_0 (recent_items);
	_g_object_unref0 (recent_manager);
}


void baobab_location_list_set_action (BaobabLocationList* self, BaobabLocationListLocationAction action, void* action_target, GDestroyNotify action_target_destroy_notify) {
	BaobabLocationListLocationAction _tmp0_;
	void* _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_tmp0_ = action;
	_tmp0__target = action_target;
	_tmp0__target_destroy_notify = action_target_destroy_notify;
	action_target_destroy_notify = NULL;
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	self->priv->location_action = _tmp0_;
	self->priv->location_action_target = _tmp0__target;
	self->priv->location_action_target_destroy_notify = _tmp0__target_destroy_notify;
	(action_target_destroy_notify == NULL) ? NULL : (action_target_destroy_notify (action_target), NULL);
	action = NULL;
	action_target = NULL;
	action_target_destroy_notify = NULL;
}


static void __lambda4_ (BaobabLocationList* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda4__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda4_ (self, widget);
}


void baobab_location_list_update (BaobabLocationList* self) {
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_container_foreach ((GtkContainer*) self, ___lambda4__gtk_callback, self);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				BaobabLocationWidget* _tmp3_;
				BaobabLocationWidget* _tmp4_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_widget_new (_tmp2_);
				g_object_ref_sink (_tmp3_);
				_tmp4_ = _tmp3_;
				gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
				_g_object_unref0 (_tmp4_);
				_baobab_location_unref0 (location);
			}
		}
	}
	gtk_widget_show_all ((GtkWidget*) self);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gtk_recent_data_destroy (GtkRecentData* self) {
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mime_type);
	_g_free0 ((*self).app_name);
	_g_free0 ((*self).app_exec);
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}


void baobab_location_list_add_location (BaobabLocationList* self, BaobabLocation* location) {
	BaobabLocation* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkRecentData data = {0};
	gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	GtkRecentManager* _tmp16_ = NULL;
	BaobabLocation* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	GtkRecentData _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp1_ = baobab_location_get_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = baobab_location_list_already_present (self, _tmp2_);
	if (!_tmp3_) {
		BaobabLocation* _tmp4_;
		BaobabLocation* _tmp5_;
		_tmp4_ = location;
		_tmp5_ = _baobab_location_ref0 (_tmp4_);
		self->priv->locations = g_list_append (self->priv->locations, _tmp5_);
	}
	baobab_location_list_update (self);
	memset (&data, 0, sizeof (GtkRecentData));
	_g_free0 (data.display_name);
	data.display_name = NULL;
	_g_free0 (data.description);
	data.description = NULL;
	_tmp6_ = g_strdup ("inode/directory");
	_g_free0 (data.mime_type);
	data.mime_type = _tmp6_;
	_tmp7_ = g_get_application_name ();
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (data.app_name);
	data.app_name = _tmp8_;
	_tmp9_ = g_get_prgname ();
	_tmp10_ = g_strdup_printf ("%s %%u", _tmp9_);
	_g_free0 (data.app_exec);
	data.app_exec = _tmp10_;
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	groups = _tmp11_;
	groups_length1 = 2;
	_groups_size_ = groups_length1;
	_tmp12_ = g_strdup ("baobab");
	_g_free0 (groups[0]);
	groups[0] = _tmp12_;
	_tmp13_ = groups[0];
	_g_free0 (groups[1]);
	groups[1] = NULL;
	_tmp14_ = groups[1];
	_tmp15_ = (groups != NULL) ? _vala_array_dup1 (groups, groups_length1) : ((gpointer) groups);
	_tmp15__length1 = groups_length1;
	data.groups = (_vala_array_free (data.groups, _vala_array_length (data.groups), (GDestroyNotify) g_free), NULL);
	data.groups = _tmp15_;
	_tmp16_ = gtk_recent_manager_get_default ();
	_tmp17_ = location;
	_tmp18_ = baobab_location_get_file (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_file_get_uri (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = data;
	gtk_recent_manager_add_full (_tmp16_, _tmp21_, &_tmp22_);
	_g_free0 (_tmp21_);
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	gtk_recent_data_destroy (&data);
}


BaobabLocationList* baobab_location_list_construct (GType object_type) {
	BaobabLocationList * self = NULL;
	self = (BaobabLocationList*) egg_list_box_construct (object_type);
	return self;
}


BaobabLocationList* baobab_location_list_new (void) {
	return baobab_location_list_construct (BAOBAB_TYPE_LOCATION_LIST);
}


static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_changed (self, mount);
}


static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_removed (self, mount);
}


static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	baobab_location_list_mount_added (self, mount);
}


static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_changed (self, volume);
}


static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_removed (self, volume);
}


static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	baobab_location_list_volume_added (self, volume);
}


static void _baobab_location_list_update_separator_egg_list_box_update_separator_func (GtkWidget** separator, GtkWidget* child, GtkWidget* before, gpointer self) {
	baobab_location_list_update_separator (self, separator, child, before);
}


static GObject * baobab_location_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabLocationList * self;
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GVolumeMonitor* _tmp6_;
	parent_class = G_OBJECT_CLASS (baobab_location_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = self->priv->monitor;
	g_signal_connect_object (_tmp1_, "mount-changed", (GCallback) _baobab_location_list_mount_changed_g_volume_monitor_mount_changed, self, 0);
	_tmp2_ = self->priv->monitor;
	g_signal_connect_object (_tmp2_, "mount-removed", (GCallback) _baobab_location_list_mount_removed_g_volume_monitor_mount_removed, self, 0);
	_tmp3_ = self->priv->monitor;
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) _baobab_location_list_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp4_ = self->priv->monitor;
	g_signal_connect_object (_tmp4_, "volume-changed", (GCallback) _baobab_location_list_volume_changed_g_volume_monitor_volume_changed, self, 0);
	_tmp5_ = self->priv->monitor;
	g_signal_connect_object (_tmp5_, "volume-removed", (GCallback) _baobab_location_list_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp6_ = self->priv->monitor;
	g_signal_connect_object (_tmp6_, "volume-added", (GCallback) _baobab_location_list_volume_added_g_volume_monitor_volume_added, self, 0);
	egg_list_box_set_selection_mode ((EggListBox*) self, GTK_SELECTION_NONE);
	egg_list_box_set_separator_funcs ((EggListBox*) self, _baobab_location_list_update_separator_egg_list_box_update_separator_func, g_object_ref (self), g_object_unref);
	baobab_location_list_populate (self);
	return obj;
}


static void baobab_location_list_class_init (BaobabLocationListClass * klass) {
	baobab_location_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabLocationListPrivate));
	EGG_LIST_BOX_CLASS (klass)->child_activated = baobab_location_list_real_child_activated;
	G_OBJECT_CLASS (klass)->constructor = baobab_location_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_list_finalize;
}


static void baobab_location_list_instance_init (BaobabLocationList * self) {
	self->priv = BAOBAB_LOCATION_LIST_GET_PRIVATE (self);
	self->priv->locations = NULL;
}


static void baobab_location_list_finalize (GObject* obj) {
	BaobabLocationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_g_object_unref0 (self->priv->monitor);
	__g_list_free__baobab_location_unref0_0 (self->priv->locations);
	(self->priv->location_action_target_destroy_notify == NULL) ? NULL : (self->priv->location_action_target_destroy_notify (self->priv->location_action_target), NULL);
	self->priv->location_action = NULL;
	self->priv->location_action_target = NULL;
	self->priv->location_action_target_destroy_notify = NULL;
	G_OBJECT_CLASS (baobab_location_list_parent_class)->finalize (obj);
}


GType baobab_location_list_get_type (void) {
	static volatile gsize baobab_location_list_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationList), 0, (GInstanceInitFunc) baobab_location_list_instance_init, NULL };
		GType baobab_location_list_type_id;
		baobab_location_list_type_id = g_type_register_static (EGG_TYPE_LIST_BOX, "BaobabLocationList", &g_define_type_info, 0);
		g_once_init_leave (&baobab_location_list_type_id__volatile, baobab_location_list_type_id);
	}
	return baobab_location_list_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



