/*
 * Copyright (C) 2008-2009 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 * Copyright (C) 2010-2012 Jiri Techet <techet@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef CHAMPLAIN_H
#define CHAMPLAIN_H

#define __CHAMPLAIN_CHAMPLAIN_H_INSIDE__

#include <glib.h>

#include "champlain/champlain-features.h"
#include "champlain/champlain-defines.h"
#include "champlain/champlain-enum-types.h"
#include "champlain/champlain-version.h"

#include "champlain/champlain-layer.h"
#include "champlain/champlain-marker-layer.h"
#include "champlain/champlain-path-layer.h"
#include "champlain/champlain-point.h"
#include "champlain/champlain-custom-marker.h"
#include "champlain/champlain-location.h"
#include "champlain/champlain-coordinate.h"
#include "champlain/champlain-marker.h"
#include "champlain/champlain-label.h"
#include "champlain/champlain-view.h"
#include "champlain/champlain-bounding-box.h"
#include "champlain/champlain-scale.h"

#include "champlain/champlain-map-source.h"
#include "champlain/champlain-tile-source.h"
#include "champlain/champlain-tile-cache.h"
#include "champlain/champlain-renderer.h"

#include "champlain/champlain-map-source-factory.h"

#include "champlain/champlain-map-source-chain.h"

#include "champlain/champlain-network-tile-source.h"
#include "champlain/champlain-network-bbox-tile-source.h"
#include "champlain/champlain-file-tile-source.h"
#include "champlain/champlain-null-tile-source.h"

#include "champlain/champlain-memory-cache.h"
#include "champlain/champlain-file-cache.h"

#include "champlain/champlain-image-renderer.h"
#include "champlain/champlain-error-tile-renderer.h"

#undef __CHAMPLAIN_CHAMPLAIN_H_INSIDE__

#endif
