/* baobab-window.c generated by valac 0.17.1.35-814b, the Vala compiler
 * generated from baobab-window.vala, do not modify */

/* -*- indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "baobab-chart.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;
typedef struct _BaobabWindowPrivate BaobabWindowPrivate;

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;

#define BAOBAB_TYPE_LOCATION_MONITOR (baobab_location_monitor_get_type ())
#define BAOBAB_LOCATION_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_MONITOR, BaobabLocationMonitor))
#define BAOBAB_LOCATION_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_MONITOR, BaobabLocationMonitorClass))
#define BAOBAB_IS_LOCATION_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_MONITOR))
#define BAOBAB_IS_LOCATION_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_MONITOR))
#define BAOBAB_LOCATION_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_MONITOR, BaobabLocationMonitorClass))

typedef struct _BaobabLocationMonitor BaobabLocationMonitor;
typedef struct _BaobabLocationMonitorClass BaobabLocationMonitorClass;

#define BAOBAB_WINDOW_TYPE_UI_PAGE (baobab_window_ui_page_get_type ())

#define BAOBAB_WINDOW_TYPE_CHART_PAGE (baobab_window_chart_page_get_type ())

#define BAOBAB_WINDOW_TYPE_DND_TARGETS (baobab_window_dnd_targets_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_monitor_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_monitor_unref (var), NULL)))

#define BAOBAB_WINDOW_TYPE_ACTION_STATE (baobab_window_action_state_get_type ())
typedef struct _BaobabWindowActionState BaobabWindowActionState;

#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
typedef struct _Block2Data Block2Data;

#define BAOBAB_TYPE_CONNECT_SERVER (baobab_connect_server_get_type ())
#define BAOBAB_CONNECT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CONNECT_SERVER, BaobabConnectServer))
#define BAOBAB_CONNECT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CONNECT_SERVER, BaobabConnectServerClass))
#define BAOBAB_IS_CONNECT_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CONNECT_SERVER))
#define BAOBAB_IS_CONNECT_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CONNECT_SERVER))
#define BAOBAB_CONNECT_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CONNECT_SERVER, BaobabConnectServerClass))

typedef struct _BaobabConnectServer BaobabConnectServer;
typedef struct _BaobabConnectServerClass BaobabConnectServerClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;

#define BAOBAB_TYPE_LOCATION_WIDGET (baobab_location_widget_get_type ())
#define BAOBAB_LOCATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidget))
#define BAOBAB_LOCATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidgetClass))
#define BAOBAB_IS_LOCATION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_WIDGET))
#define BAOBAB_IS_LOCATION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_WIDGET))
#define BAOBAB_LOCATION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_WIDGET, BaobabLocationWidgetClass))

typedef struct _BaobabLocationWidget BaobabLocationWidget;
typedef struct _BaobabLocationWidgetClass BaobabLocationWidgetClass;
typedef struct _Block3Data Block3Data;
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define BAOBAB_SCANNER_TYPE_COLUMNS (baobab_scanner_columns_get_type ())
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BaobabWindow {
	GtkApplicationWindow parent_instance;
	BaobabWindowPrivate * priv;
};

struct _BaobabWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _BaobabWindowPrivate {
	GSettings* ui_settings;
	GtkNotebook* main_notebook;
	GtkToolbar* toolbar;
	GtkToolItem* toolbar_home_toolitem;
	GtkToolButton* toolbar_show_home_page;
	GtkToolButton* toolbar_rescan;
	GtkInfoBar* infobar;
	GtkLabel* infobar_primary;
	GtkLabel* infobar_secondary;
	GtkTreeView* treeview;
	GtkNotebook* chart_notebook;
	GtkGrid* location_view;
	BaobabChart* rings_chart;
	BaobabChart* treemap_chart;
	GtkSpinner* spinner;
	BaobabScanner* scanner;
	BaobabLocationMonitor* location_monitor;
};

typedef enum  {
	BAOBAB_WINDOW_UI_PAGE_HOME,
	BAOBAB_WINDOW_UI_PAGE_RESULT
} BaobabWindowUIPage;

typedef enum  {
	BAOBAB_WINDOW_CHART_PAGE_RINGS,
	BAOBAB_WINDOW_CHART_PAGE_TREEMAP,
	BAOBAB_WINDOW_CHART_PAGE_SPINNER
} BaobabWindowChartPage;

typedef enum  {
	BAOBAB_WINDOW_DND_TARGETS_URI_LIST
} BaobabWindowDndTargets;

struct _BaobabWindowActionState {
	gchar* name;
	gboolean enable;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _Block2Data {
	int _ref_count_;
	BaobabWindow * self;
	GtkFileChooserDialog* file_chooser;
};

typedef void (*BaobabLocationWidgetActionOnClick) (BaobabLocation* location, void* user_data);
struct _Block3Data {
	int _ref_count_;
	BaobabWindow * self;
	BaobabLocation* location_;
};

struct _Block4Data {
	int _ref_count_;
	BaobabWindow * self;
	GtkMenu* popup;
	GtkTreeSelection* selection;
};

typedef enum  {
	BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME,
	BAOBAB_SCANNER_COLUMNS_PARSE_NAME,
	BAOBAB_SCANNER_COLUMNS_PERCENT,
	BAOBAB_SCANNER_COLUMNS_SIZE,
	BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE,
	BAOBAB_SCANNER_COLUMNS_ELEMENTS,
	BAOBAB_SCANNER_COLUMNS_STATE,
	BAOBAB_SCANNER_COLUMNS_ERROR,
	BAOBAB_SCANNER_COLUMNS_COLUMNS
} BaobabScannerColumns;


static gpointer baobab_window_parent_class = NULL;
static GdkCursor* baobab_window_busy_cursor;
static GdkCursor* baobab_window_busy_cursor = NULL;

GType baobab_window_get_type (void) G_GNUC_CONST;
GType baobab_scanner_get_type (void) G_GNUC_CONST;
gpointer baobab_location_monitor_ref (gpointer instance);
void baobab_location_monitor_unref (gpointer instance);
GParamSpec* baobab_param_spec_location_monitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location_monitor (GValue* value, gpointer v_object);
void baobab_value_take_location_monitor (GValue* value, gpointer v_object);
gpointer baobab_value_get_location_monitor (const GValue* value);
GType baobab_location_monitor_get_type (void) G_GNUC_CONST;
#define BAOBAB_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_WINDOW, BaobabWindowPrivate))
enum  {
	BAOBAB_WINDOW_DUMMY_PROPERTY
};
static GType baobab_window_ui_page_get_type (void) G_GNUC_UNUSED;
static GType baobab_window_chart_page_get_type (void) G_GNUC_UNUSED;
static GType baobab_window_dnd_targets_get_type (void) G_GNUC_UNUSED;
static void baobab_window_on_show_home_page_activate (BaobabWindow* self);
static void _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_radio_activate (BaobabWindow* self, GSimpleAction* action, GVariant* parameter);
static void _baobab_window_radio_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_chart_type_changed (BaobabWindow* self, GSimpleAction* action, GVariant* value);
static void _baobab_window_on_chart_type_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void baobab_window_on_scan_home_activate (BaobabWindow* self);
static void _baobab_window_on_scan_home_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_scan_folder_activate (BaobabWindow* self);
static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_scan_remote_activate (BaobabWindow* self);
static void _baobab_window_on_scan_remote_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_stop_activate (BaobabWindow* self);
static void _baobab_window_on_stop_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_reload_activate (BaobabWindow* self);
static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_show_toolbar (BaobabWindow* self);
static void _baobab_window_on_show_toolbar_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_show_allocated (BaobabWindow* self);
static void _baobab_window_on_show_allocated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_expand_all (BaobabWindow* self);
static void _baobab_window_on_expand_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_collapse_all (BaobabWindow* self);
static void _baobab_window_on_collapse_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_help_activate (BaobabWindow* self);
static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_window_on_about_activate (BaobabWindow* self);
static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType baobab_window_action_state_get_type (void) G_GNUC_CONST;
BaobabWindowActionState* baobab_window_action_state_dup (const BaobabWindowActionState* self);
void baobab_window_action_state_free (BaobabWindowActionState* self);
void baobab_window_action_state_copy (const BaobabWindowActionState* self, BaobabWindowActionState* dest);
void baobab_window_action_state_destroy (BaobabWindowActionState* self);
GType baobab_application_get_type (void) G_GNUC_CONST;
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
static void baobab_window_setup_home_page (BaobabWindow* self);
static void baobab_window_setup_treeview (BaobabWindow* self, GtkBuilder* builder);
static void __lambda17_ (BaobabWindow* self);
static void baobab_window_clear_message (BaobabWindow* self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
GSettings* baobab_application_get_ui_settings (void);
static void baobab_window_on_chart_item_activated (BaobabWindow* self, BaobabChart* chart, GtkTreeIter* iter);
static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender, GtkTreeIter* iter, gpointer self);
static void baobab_window_on_drag_data_received (BaobabWindow* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint target_type, guint time);
static void _baobab_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static void baobab_window_enable_drop (BaobabWindow* self);
static void baobab_window_set_ui_page (BaobabWindow* self, BaobabWindowUIPage page);
static void baobab_window_set_busy (BaobabWindow* self, gboolean busy);
void baobab_scanner_cancel (BaobabScanner* self);
static gchar* _variant_get2 (GVariant* value);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_, gint response);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
BaobabConnectServer* baobab_connect_server_new (void);
BaobabConnectServer* baobab_connect_server_construct (GType object_type);
GType baobab_connect_server_get_type (void) G_GNUC_CONST;
static void __lambda5_ (BaobabWindow* self, const gchar* uri);
static void ___lambda5__baobab_connect_server_selected (BaobabConnectServer* _sender, const gchar* uri, gpointer self);
void baobab_connect_server_show (BaobabConnectServer* self);
GFile* baobab_scanner_get_directory (BaobabScanner* self);
BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self);
static void baobab_window_disable_drop (BaobabWindow* self);
static void baobab_window_update_locations (BaobabWindow* self);
static void __lambda7_ (BaobabWindow* self, GtkWidget* widget);
static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self);
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
GList* baobab_location_monitor_get_locations (BaobabLocationMonitor* self);
GType baobab_location_widget_get_type (void) G_GNUC_CONST;
gboolean baobab_location_get_is_home_location (BaobabLocation* self);
static void _____lambda9_ (BaobabWindow* self, BaobabLocation* location_);
static void ______lambda9__baobab_location_widget_action_on_click (BaobabLocation* location, gpointer self);
BaobabLocationWidget* baobab_location_widget_new (BaobabLocation* location, BaobabLocationWidgetActionOnClick action, void* action_target);
BaobabLocationWidget* baobab_location_widget_construct (GType object_type, BaobabLocation* location, BaobabLocationWidgetActionOnClick action, void* action_target);
static void _____lambda10_ (BaobabWindow* self, BaobabLocation* location_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error);
static void __lambda11_ (Block3Data* _data3_, GObject* location__, GAsyncResult* res);
const gchar* baobab_location_get_mount_point (BaobabLocation* self);
static void baobab_window_message (BaobabWindow* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ______lambda10__baobab_location_widget_action_on_click (BaobabLocation* location, gpointer self);
BaobabLocationMonitor* baobab_location_monitor_get (void);
static void __lambda6_ (BaobabWindow* self);
static void ___lambda6__baobab_location_monitor_changed (BaobabLocationMonitor* _sender, gpointer self);
static gboolean baobab_window_show_treeview_popup (BaobabWindow* self, GtkMenu* popup, GdkEventButton* event);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda12_ (Block4Data* _data4_, GdkEventButton* event);
static gboolean ___lambda12__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean __lambda13_ (Block4Data* _data4_);
static gboolean ___lambda13__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void __lambda14_ (BaobabWindow* self);
GType baobab_scanner_columns_get_type (void) G_GNUC_CONST;
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda15_ (BaobabWindow* self);
static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda16_ (Block4Data* _data4_);
static void ___lambda16__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
gboolean baobab_window_check_dir (BaobabWindow* self, GFile* directory);
static void baobab_window_first_row_has_child (BaobabWindow* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void baobab_window_set_model (BaobabWindow* self, GtkTreeModel* model);
BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags);
BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags);
static void __lambda3_ (BaobabWindow* self);
void baobab_scanner_finish (BaobabScanner* self, GError** error);
static void ___lambda3__baobab_scanner_completed (BaobabScanner* _sender, gpointer self);
void baobab_scanner_scan (BaobabScanner* self);
static void baobab_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry BAOBAB_WINDOW_action_entries[13] = {{"show-home-page", _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback}, {"active-chart", _baobab_window_radio_activate_gsimple_action_activate_callback, "s", "'rings'", _baobab_window_on_chart_type_changed_gsimple_action_change_state_callback}, {"scan-home", _baobab_window_on_scan_home_activate_gsimple_action_activate_callback}, {"scan-folder", _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback}, {"scan-remote", _baobab_window_on_scan_remote_activate_gsimple_action_activate_callback}, {"stop", _baobab_window_on_stop_activate_gsimple_action_activate_callback}, {"reload", _baobab_window_on_reload_activate_gsimple_action_activate_callback}, {"show-toolbar", _baobab_window_on_show_toolbar_gsimple_action_activate_callback}, {"show-allocated", _baobab_window_on_show_allocated_gsimple_action_activate_callback}, {"expand-all", _baobab_window_on_expand_all_gsimple_action_activate_callback}, {"collapse-all", _baobab_window_on_collapse_all_gsimple_action_activate_callback}, {"help", _baobab_window_on_help_activate_gsimple_action_activate_callback}, {"about", _baobab_window_on_about_activate_gsimple_action_activate_callback}};
static const BaobabWindowActionState BAOBAB_WINDOW_actions_while_scanning[8] = {{"scan-home", FALSE}, {"scan-folder", FALSE}, {"scan-remote", FALSE}, {"stop", TRUE}, {"reload", FALSE}, {"show-allocated", FALSE}, {"expand-all", FALSE}, {"collapse-all", FALSE}};
static const GtkTargetEntry BAOBAB_WINDOW_dnd_target_list[1] = {{"text/uri-list", (guint) 0, (guint) BAOBAB_WINDOW_DND_TARGETS_URI_LIST}};

static GType baobab_window_ui_page_get_type (void) {
	static volatile gsize baobab_window_ui_page_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_ui_page_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_WINDOW_UI_PAGE_HOME, "BAOBAB_WINDOW_UI_PAGE_HOME", "home"}, {BAOBAB_WINDOW_UI_PAGE_RESULT, "BAOBAB_WINDOW_UI_PAGE_RESULT", "result"}, {0, NULL, NULL}};
		GType baobab_window_ui_page_type_id;
		baobab_window_ui_page_type_id = g_enum_register_static ("BaobabWindowUIPage", values);
		g_once_init_leave (&baobab_window_ui_page_type_id__volatile, baobab_window_ui_page_type_id);
	}
	return baobab_window_ui_page_type_id__volatile;
}


static GType baobab_window_chart_page_get_type (void) {
	static volatile gsize baobab_window_chart_page_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_chart_page_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_WINDOW_CHART_PAGE_RINGS, "BAOBAB_WINDOW_CHART_PAGE_RINGS", "rings"}, {BAOBAB_WINDOW_CHART_PAGE_TREEMAP, "BAOBAB_WINDOW_CHART_PAGE_TREEMAP", "treemap"}, {BAOBAB_WINDOW_CHART_PAGE_SPINNER, "BAOBAB_WINDOW_CHART_PAGE_SPINNER", "spinner"}, {0, NULL, NULL}};
		GType baobab_window_chart_page_type_id;
		baobab_window_chart_page_type_id = g_enum_register_static ("BaobabWindowChartPage", values);
		g_once_init_leave (&baobab_window_chart_page_type_id__volatile, baobab_window_chart_page_type_id);
	}
	return baobab_window_chart_page_type_id__volatile;
}


static GType baobab_window_dnd_targets_get_type (void) {
	static volatile gsize baobab_window_dnd_targets_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_dnd_targets_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_WINDOW_DND_TARGETS_URI_LIST, "BAOBAB_WINDOW_DND_TARGETS_URI_LIST", "uri-list"}, {0, NULL, NULL}};
		GType baobab_window_dnd_targets_type_id;
		baobab_window_dnd_targets_type_id = g_enum_register_static ("BaobabWindowDndTargets", values);
		g_once_init_leave (&baobab_window_dnd_targets_type_id__volatile, baobab_window_dnd_targets_type_id);
	}
	return baobab_window_dnd_targets_type_id__volatile;
}


static void _baobab_window_on_show_home_page_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_home_page_activate (self);
}


static void _baobab_window_radio_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_radio_activate (self, action, parameter);
}


static void _baobab_window_on_chart_type_changed_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	baobab_window_on_chart_type_changed (self, action, value);
}


static void _baobab_window_on_scan_home_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_scan_home_activate (self);
}


static void _baobab_window_on_scan_folder_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_scan_folder_activate (self);
}


static void _baobab_window_on_scan_remote_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_scan_remote_activate (self);
}


static void _baobab_window_on_stop_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_stop_activate (self);
}


static void _baobab_window_on_reload_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_reload_activate (self);
}


static void _baobab_window_on_show_toolbar_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_toolbar (self);
}


static void _baobab_window_on_show_allocated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_show_allocated (self);
}


static void _baobab_window_on_expand_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_expand_all (self);
}


static void _baobab_window_on_collapse_all_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_collapse_all (self);
}


static void _baobab_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_help_activate (self);
}


static void _baobab_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_window_on_about_activate (self);
}


static void baobab_window_radio_activate (BaobabWindow* self, GSimpleAction* action, GVariant* parameter) {
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = parameter;
	g_signal_emit_by_name (_tmp0_, "change-state", _tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda17_ (BaobabWindow* self) {
	baobab_window_clear_message (self);
}


static void ___lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda17_ (self);
}


static void _baobab_window_on_chart_item_activated_baobab_chart_item_activated (BaobabChart* _sender, GtkTreeIter* iter, gpointer self) {
	baobab_window_on_chart_item_activated (self, _sender, iter);
}


static void _baobab_window_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	baobab_window_on_drag_data_received (self, _sender, context, x, y, selection_data, info, time_);
}


BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app) {
	BaobabWindow * self = NULL;
	BaobabApplication* _tmp0_;
	GdkCursor* _tmp1_;
	GtkBuilder* _tmp2_;
	GtkBuilder* builder;
	GObject* _tmp4_ = NULL;
	GtkNotebook* _tmp5_;
	GObject* _tmp6_ = NULL;
	GtkToolbar* _tmp7_;
	GObject* _tmp8_ = NULL;
	GtkToolItem* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkToolButton* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkToolButton* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkInfoBar* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkLabel* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkTreeView* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkNotebook* _tmp23_;
	GObject* _tmp24_ = NULL;
	BaobabChart* _tmp25_;
	GObject* _tmp26_ = NULL;
	BaobabChart* _tmp27_;
	GObject* _tmp28_ = NULL;
	GtkSpinner* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkGrid* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkButton* _tmp33_;
	GtkButton* infobar_close_button;
	GtkToolbar* _tmp34_;
	GtkStyleContext* _tmp35_ = NULL;
	GSettings* _tmp36_ = NULL;
	GAction* _tmp37_ = NULL;
	GSettings* _tmp38_;
	GVariant* _tmp39_ = NULL;
	GVariant* _tmp40_;
	BaobabChart* _tmp41_;
	BaobabChart* _tmp42_;
	GObject* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (BaobabWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	_tmp1_ = gdk_cursor_new (GDK_WATCH);
	_g_object_unref0 (baobab_window_busy_cursor);
	baobab_window_busy_cursor = _tmp1_;
	g_action_map_add_action_entries ((GActionMap*) self, (GActionEntry*) BAOBAB_WINDOW_action_entries, G_N_ELEMENTS (BAOBAB_WINDOW_action_entries), self);
	_tmp2_ = gtk_builder_new ();
	builder = _tmp2_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/baobab/ui/baobab-main-window.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e->message;
		g_error ("baobab-window.vala:113: loading main builder file: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = gtk_builder_get_object (builder, "main-notebook");
	_tmp5_ = _g_object_ref0 (GTK_IS_NOTEBOOK (_tmp4_) ? ((GtkNotebook*) _tmp4_) : NULL);
	_g_object_unref0 (self->priv->main_notebook);
	self->priv->main_notebook = _tmp5_;
	_tmp6_ = gtk_builder_get_object (builder, "toolbar");
	_tmp7_ = _g_object_ref0 (GTK_IS_TOOLBAR (_tmp6_) ? ((GtkToolbar*) _tmp6_) : NULL);
	_g_object_unref0 (self->priv->toolbar);
	self->priv->toolbar = _tmp7_;
	_tmp8_ = gtk_builder_get_object (builder, "home-page-toolitem");
	_tmp9_ = _g_object_ref0 (GTK_IS_TOOL_ITEM (_tmp8_) ? ((GtkToolItem*) _tmp8_) : NULL);
	_g_object_unref0 (self->priv->toolbar_home_toolitem);
	self->priv->toolbar_home_toolitem = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "show-home-page-button");
	_tmp11_ = _g_object_ref0 (GTK_IS_TOOL_BUTTON (_tmp10_) ? ((GtkToolButton*) _tmp10_) : NULL);
	_g_object_unref0 (self->priv->toolbar_show_home_page);
	self->priv->toolbar_show_home_page = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "rescan-button");
	_tmp13_ = _g_object_ref0 (GTK_IS_TOOL_BUTTON (_tmp12_) ? ((GtkToolButton*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->toolbar_rescan);
	self->priv->toolbar_rescan = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "infobar");
	_tmp15_ = _g_object_ref0 (GTK_IS_INFO_BAR (_tmp14_) ? ((GtkInfoBar*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "infobar-primary-label");
	_tmp17_ = _g_object_ref0 (GTK_IS_LABEL (_tmp16_) ? ((GtkLabel*) _tmp16_) : NULL);
	_g_object_unref0 (self->priv->infobar_primary);
	self->priv->infobar_primary = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "infobar-secondary-label");
	_tmp19_ = _g_object_ref0 (GTK_IS_LABEL (_tmp18_) ? ((GtkLabel*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->infobar_secondary);
	self->priv->infobar_secondary = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "treeview");
	_tmp21_ = _g_object_ref0 (GTK_IS_TREE_VIEW (_tmp20_) ? ((GtkTreeView*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "chart-notebook");
	_tmp23_ = _g_object_ref0 (GTK_IS_NOTEBOOK (_tmp22_) ? ((GtkNotebook*) _tmp22_) : NULL);
	_g_object_unref0 (self->priv->chart_notebook);
	self->priv->chart_notebook = _tmp23_;
	_tmp24_ = gtk_builder_get_object (builder, "rings-chart");
	_tmp25_ = _g_object_ref0 (BAOBAB_IS_CHART (_tmp24_) ? ((BaobabChart*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->rings_chart);
	self->priv->rings_chart = _tmp25_;
	_tmp26_ = gtk_builder_get_object (builder, "treemap-chart");
	_tmp27_ = _g_object_ref0 (BAOBAB_IS_CHART (_tmp26_) ? ((BaobabChart*) _tmp26_) : NULL);
	_g_object_unref0 (self->priv->treemap_chart);
	self->priv->treemap_chart = _tmp27_;
	_tmp28_ = gtk_builder_get_object (builder, "spinner");
	_tmp29_ = _g_object_ref0 (GTK_IS_SPINNER (_tmp28_) ? ((GtkSpinner*) _tmp28_) : NULL);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp29_;
	_tmp30_ = gtk_builder_get_object (builder, "location-view");
	_tmp31_ = _g_object_ref0 (GTK_IS_GRID (_tmp30_) ? ((GtkGrid*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->location_view);
	self->priv->location_view = _tmp31_;
	baobab_window_setup_home_page (self);
	baobab_window_setup_treeview (self, builder);
	_tmp32_ = gtk_builder_get_object (builder, "infobar-close-button");
	_tmp33_ = _g_object_ref0 (GTK_IS_BUTTON (_tmp32_) ? ((GtkButton*) _tmp32_) : NULL);
	infobar_close_button = _tmp33_;
	g_signal_connect_object (infobar_close_button, "clicked", (GCallback) ___lambda17__gtk_button_clicked, self, 0);
	_tmp34_ = self->priv->toolbar;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, GTK_STYLE_CLASS_MENUBAR);
	_tmp36_ = baobab_application_get_ui_settings ();
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp36_;
	_tmp37_ = g_action_map_lookup_action ((GActionMap*) self, "active-chart");
	_tmp38_ = self->priv->ui_settings;
	_tmp39_ = g_settings_get_value (_tmp38_, "active-chart");
	_tmp40_ = _tmp39_;
	g_action_change_state (_tmp37_, _tmp40_);
	_g_variant_unref0 (_tmp40_);
	_tmp41_ = self->priv->rings_chart;
	g_signal_connect_object (_tmp41_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	_tmp42_ = self->priv->treemap_chart;
	g_signal_connect_object (_tmp42_, "item-activated", (GCallback) _baobab_window_on_chart_item_activated_baobab_chart_item_activated, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _baobab_window_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	baobab_window_enable_drop (self);
	_tmp43_ = gtk_builder_get_object (builder, "window-contents");
	gtk_container_add ((GtkContainer*) self, GTK_IS_WIDGET (_tmp43_) ? ((GtkWidget*) _tmp43_) : NULL);
	_tmp44_ = _ ("Disk Usage Analyzer");
	gtk_window_set_title ((GtkWindow*) self, _tmp44_);
	gtk_window_set_default_size ((GtkWindow*) self, 800, 500);
	gtk_window_set_hide_titlebar_when_maximized ((GtkWindow*) self, TRUE);
	baobab_window_set_ui_page (self, BAOBAB_WINDOW_UI_PAGE_HOME);
	baobab_window_set_busy (self, FALSE);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (infobar_close_button);
	_g_object_unref0 (builder);
	return self;
}


BaobabWindow* baobab_window_new (BaobabApplication* app) {
	return baobab_window_construct (BAOBAB_TYPE_WINDOW, app);
}


static void baobab_window_set_ui_page (BaobabWindow* self, BaobabWindowUIPage page) {
	GtkToolItem* _tmp0_;
	BaobabWindowUIPage _tmp1_;
	GtkToolButton* _tmp2_;
	BaobabWindowUIPage _tmp3_;
	GtkToolButton* _tmp4_;
	BaobabWindowUIPage _tmp5_;
	GtkNotebook* _tmp6_;
	BaobabWindowUIPage _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->toolbar_home_toolitem;
	_tmp1_ = page;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, _tmp1_ == BAOBAB_WINDOW_UI_PAGE_HOME);
	_tmp2_ = self->priv->toolbar_show_home_page;
	_tmp3_ = page;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, _tmp3_ == BAOBAB_WINDOW_UI_PAGE_RESULT);
	_tmp4_ = self->priv->toolbar_rescan;
	_tmp5_ = page;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp5_ == BAOBAB_WINDOW_UI_PAGE_RESULT);
	_tmp6_ = self->priv->main_notebook;
	_tmp7_ = page;
	g_object_set (_tmp6_, "page", (gint) _tmp7_, NULL);
}


static void baobab_window_on_show_home_page_activate (BaobabWindow* self) {
	BaobabScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scanner;
	if (_tmp0_ != NULL) {
		BaobabScanner* _tmp1_;
		_tmp1_ = self->priv->scanner;
		baobab_scanner_cancel (_tmp1_);
	}
	baobab_window_clear_message (self);
	baobab_window_set_ui_page (self, BAOBAB_WINDOW_UI_PAGE_HOME);
}


static gchar* _variant_get2 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static void baobab_window_on_chart_type_changed (BaobabWindow* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	GSettings* _tmp7_;
	GVariant* _tmp8_;
	GSimpleAction* _tmp9_;
	GVariant* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = value;
	_tmp1_ = _variant_get2 (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	g_free (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("rings")))) {
		switch (0) {
			default:
			{
				GtkNotebook* _tmp5_;
				_tmp5_ = self->priv->chart_notebook;
				g_object_set (_tmp5_, "page", (gint) BAOBAB_WINDOW_CHART_PAGE_RINGS, NULL);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("treemap")))) {
		switch (0) {
			default:
			{
				GtkNotebook* _tmp6_;
				_tmp6_ = self->priv->chart_notebook;
				g_object_set (_tmp6_, "page", (gint) BAOBAB_WINDOW_CHART_PAGE_TREEMAP, NULL);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				return;
			}
		}
	}
	_tmp7_ = self->priv->ui_settings;
	_tmp8_ = value;
	g_settings_set_value (_tmp7_, "active-chart", _tmp8_);
	_tmp9_ = action;
	_tmp10_ = value;
	g_simple_action_set_state (_tmp9_, _tmp10_);
}


static void baobab_window_on_scan_home_activate (BaobabWindow* self) {
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* dir;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	dir = _tmp1_;
	baobab_window_scan_directory (self, dir, BAOBAB_SCAN_FLAGS_NONE);
	_g_object_unref0 (dir);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BaobabWindow * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->file_chooser);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda4_ (Block2Data* _data2_, gint response) {
	BaobabWindow * self;
	gint _tmp0_;
	self = _data2_->self;
	_tmp0_ = response;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFile* dir;
		GFile* _tmp3_;
		_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _data2_->file_chooser);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		dir = _tmp2_;
		_tmp3_ = dir;
		baobab_window_scan_directory (self, _tmp3_, BAOBAB_SCAN_FLAGS_NONE);
		_g_object_unref0 (dir);
	}
	gtk_widget_destroy ((GtkWidget*) _data2_->file_chooser);
}


static void ___lambda4__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda4_ (self, response_id);
}


static void baobab_window_on_scan_folder_activate (BaobabWindow* self) {
	Block2Data* _data2_;
	const gchar* _tmp0_ = NULL;
	GtkFileChooserDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _ ("Select Folder");
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp1_);
	_data2_->file_chooser = _tmp1_;
	gtk_window_set_modal ((GtkWindow*) _data2_->file_chooser, TRUE);
	g_signal_connect_data ((GtkDialog*) _data2_->file_chooser, "response", (GCallback) ___lambda4__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->file_chooser);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void __lambda5_ (BaobabWindow* self, const gchar* uri) {
	const gchar* _tmp0_;
	_tmp0_ = uri;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_ = NULL;
		GFile* dir;
		GFile* _tmp3_;
		_tmp1_ = uri;
		_tmp2_ = g_file_new_for_uri (_tmp1_);
		dir = _tmp2_;
		_tmp3_ = dir;
		baobab_window_scan_directory (self, _tmp3_, BAOBAB_SCAN_FLAGS_NONE);
		_g_object_unref0 (dir);
	}
}


static void ___lambda5__baobab_connect_server_selected (BaobabConnectServer* _sender, const gchar* uri, gpointer self) {
	__lambda5_ (self, uri);
}


static void baobab_window_on_scan_remote_activate (BaobabWindow* self) {
	BaobabConnectServer* _tmp0_;
	BaobabConnectServer* connect_server;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_connect_server_new ();
	connect_server = _tmp0_;
	g_signal_connect_object (connect_server, "selected", (GCallback) ___lambda5__baobab_connect_server_selected, self, 0);
	baobab_connect_server_show (connect_server);
	_g_object_unref0 (connect_server);
}


static void baobab_window_on_stop_activate (BaobabWindow* self) {
	BaobabScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scanner;
	if (_tmp0_ != NULL) {
		BaobabScanner* _tmp1_;
		_tmp1_ = self->priv->scanner;
		baobab_scanner_cancel (_tmp1_);
	}
}


static void baobab_window_on_reload_activate (BaobabWindow* self) {
	BaobabScanner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scanner;
	if (_tmp0_ != NULL) {
		BaobabScanner* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		BaobabScanner* _tmp4_;
		BaobabScanFlags _tmp5_;
		BaobabScanFlags _tmp6_;
		_tmp1_ = self->priv->scanner;
		_tmp2_ = baobab_scanner_get_directory (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->scanner;
		_tmp5_ = baobab_scanner_get_scan_flags (_tmp4_);
		_tmp6_ = _tmp5_;
		baobab_window_scan_directory (self, _tmp3_, _tmp6_);
	}
}


static void baobab_window_on_show_toolbar (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
}


static void baobab_window_on_show_allocated (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
}


static void baobab_window_on_expand_all (BaobabWindow* self) {
	GtkTreeView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	gtk_tree_view_expand_all (_tmp0_);
}


static void baobab_window_on_collapse_all (BaobabWindow* self) {
	GtkTreeView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	gtk_tree_view_collapse_all (_tmp0_);
}


static void baobab_window_on_help_activate (BaobabWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GdkScreen* _tmp0_ = NULL;
		guint32 _tmp1_ = 0U;
		_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp1_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp0_, "help:baobab", _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("baobab-window.vala:263: Failed to show help: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void baobab_window_on_about_activate (BaobabWindow* self) {
	static const gchar* authors[] = {"Ryan Lortie <desrt@desrt.ca>", "Fabio Marzocca <thesaltydog@gmail.com>", "Paolo Borelli <pborelli@gnome.com>", "Benoît Dejean <benoit@placenet.org>", "Igalia (rings-chart and treemap widget) <www.igalia.com>"};
	static const char copyright[] = "Copyright \xc2\xa9 2005-2011 Fabio Marzocca, Paolo Borelli, Benoît Dej" \
"ean, Igalia\n" "Copyright \xc2\xa9 2011-2012 Ryan Lortie, Paolo Borelli\n";
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Baobab");
	_tmp1_ = _ ("A graphical tool to analyze disk usage.");
	_tmp2_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", _tmp0_, "logo-icon-name", "baobab", "version", VERSION, "comments", _tmp1_, "copyright", copyright, "license-type", GTK_LICENSE_GPL_2_0, "wrap-license", FALSE, "authors", authors, "translator-credits", _tmp2_, NULL, NULL);
}


static void baobab_window_on_chart_item_activated (BaobabWindow* self, BaobabChart* chart, GtkTreeIter* iter) {
	BaobabScanner* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* path;
	GtkTreeView* _tmp3_;
	GtkTreePath* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkTreeView* _tmp8_;
	GtkTreePath* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (chart != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp0_, &_tmp1_);
	path = _tmp2_;
	_tmp3_ = self->priv->treeview;
	_tmp4_ = path;
	_tmp5_ = gtk_tree_view_row_expanded (_tmp3_, _tmp4_);
	if (!_tmp5_) {
		GtkTreeView* _tmp6_;
		GtkTreePath* _tmp7_;
		_tmp6_ = self->priv->treeview;
		_tmp7_ = path;
		gtk_tree_view_expand_to_path (_tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->treeview;
	_tmp9_ = path;
	gtk_tree_view_set_cursor (_tmp8_, _tmp9_, NULL, FALSE);
	_gtk_tree_path_free0 (path);
}


static void baobab_window_on_drag_data_received (BaobabWindow* self, GtkWidget* widget, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint target_type, guint time) {
	GFile* dir;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkSelectionData* _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp7_;
	GFile* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	dir = NULL;
	_tmp2_ = selection_data;
	if (_tmp2_ != NULL) {
		GtkSelectionData* _tmp3_;
		gint _tmp4_ = 0;
		_tmp3_ = selection_data;
		_tmp4_ = gtk_selection_data_get_length (_tmp3_);
		_tmp1_ = _tmp4_ >= 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		guint _tmp6_;
		_tmp6_ = target_type;
		_tmp0_ = _tmp6_ == ((guint) BAOBAB_WINDOW_DND_TARGETS_URI_LIST);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		GtkSelectionData* _tmp8_;
		guchar* _tmp9_ = NULL;
		gchar** _tmp10_;
		gchar** _tmp11_ = NULL;
		gchar** uris;
		gint uris_length1;
		gint _uris_size_;
		gboolean _tmp12_ = FALSE;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gboolean _tmp15_;
		_tmp8_ = selection_data;
		_tmp9_ = gtk_selection_data_get_data (_tmp8_);
		_tmp11_ = _tmp10_ = g_uri_list_extract_uris ((const gchar*) _tmp9_);
		uris = _tmp11_;
		uris_length1 = _vala_array_length (_tmp10_);
		_uris_size_ = uris_length1;
		_tmp13_ = uris;
		_tmp13__length1 = uris_length1;
		if (_tmp13_ != NULL) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			_tmp14_ = uris;
			_tmp14__length1 = uris_length1;
			_tmp12_ = _tmp14__length1 == 1;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			GFile* _tmp18_ = NULL;
			_tmp16_ = uris;
			_tmp16__length1 = uris_length1;
			_tmp17_ = _tmp16_[0];
			_tmp18_ = g_file_new_for_uri (_tmp17_);
			_g_object_unref0 (dir);
			dir = _tmp18_;
		}
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp19_ = dir;
	if (_tmp19_ != NULL) {
		GdkDragContext* _tmp20_;
		guint _tmp21_;
		GFile* _tmp22_;
		_tmp20_ = context;
		_tmp21_ = time;
		gtk_drag_finish (_tmp20_, TRUE, FALSE, (guint32) _tmp21_);
		_tmp22_ = dir;
		baobab_window_scan_directory (self, _tmp22_, BAOBAB_SCAN_FLAGS_NONE);
	} else {
		GdkDragContext* _tmp23_;
		guint _tmp24_;
		_tmp23_ = context;
		_tmp24_ = time;
		gtk_drag_finish (_tmp23_, FALSE, FALSE, (guint32) _tmp24_);
	}
	_g_object_unref0 (dir);
}


static void baobab_window_enable_drop (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_drag_dest_set ((GtkWidget*) self, (GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_MOTION) | GTK_DEST_DEFAULT_HIGHLIGHT, BAOBAB_WINDOW_dnd_target_list, G_N_ELEMENTS (BAOBAB_WINDOW_dnd_target_list), GDK_ACTION_COPY);
}


static void baobab_window_disable_drop (BaobabWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_drag_dest_unset ((GtkWidget*) self);
}


static void __lambda7_ (BaobabWindow* self, GtkWidget* widget) {
	GtkWidget* _tmp0_;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_destroy (_tmp0_);
}


static void ___lambda7__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda7_ (self, widget);
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void _____lambda9_ (BaobabWindow* self, BaobabLocation* location_) {
	g_return_if_fail (location_ != NULL);
	baobab_window_on_scan_home_activate (self);
}


static void ______lambda9__baobab_location_widget_action_on_click (BaobabLocation* location, gpointer self) {
	_____lambda9_ (self, location);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BaobabWindow * self;
		self = _data3_->self;
		_baobab_location_unref0 (_data3_->location_);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda11_ (Block3Data* _data3_, GObject* location__, GAsyncResult* res) {
	BaobabWindow * self;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		BaobabLocation* _tmp0_;
		GAsyncResult* _tmp1_;
		BaobabLocation* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_;
		_tmp0_ = _data3_->location_;
		_tmp1_ = res;
		baobab_location_mount_volume_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp2_ = _data3_->location_;
		_tmp3_ = baobab_location_get_mount_point (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		baobab_window_scan_directory (self, _tmp6_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = _ ("Could not analyze volume.");
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		baobab_window_message (self, _tmp7_, _tmp9_, GTK_MESSAGE_ERROR);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda11_ (self, source_object, res);
	block3_data_unref (self);
}


static void _____lambda10_ (BaobabWindow* self, BaobabLocation* location_) {
	Block3Data* _data3_;
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabLocation* _tmp2_;
	g_return_if_fail (location_ != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = location_;
	_tmp1_ = _baobab_location_ref0 (_tmp0_);
	_data3_->location_ = _tmp1_;
	_tmp2_ = _data3_->location_;
	baobab_location_mount_volume (_tmp2_, ___lambda11__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void ______lambda10__baobab_location_widget_action_on_click (BaobabLocation* location, gpointer self) {
	_____lambda10_ (self, location);
}


static void baobab_window_update_locations (BaobabWindow* self) {
	GtkGrid* _tmp0_;
	BaobabLocationMonitor* _tmp1_;
	GList* _tmp2_ = NULL;
	GtkGrid* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_view;
	gtk_container_foreach ((GtkContainer*) _tmp0_, ___lambda7__gtk_callback, self);
	_tmp1_ = self->priv->location_monitor;
	_tmp2_ = baobab_location_monitor_get_locations (_tmp1_);
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp2_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp3_;
			BaobabLocation* location = NULL;
			_tmp3_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp3_;
			{
				BaobabLocationWidget* loc_widget = NULL;
				BaobabLocation* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				GtkGrid* _tmp11_;
				BaobabLocationWidget* _tmp12_;
				_tmp4_ = location;
				_tmp5_ = baobab_location_get_is_home_location (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					BaobabLocation* _tmp7_;
					BaobabLocationWidget* _tmp8_;
					_tmp7_ = location;
					_tmp8_ = baobab_location_widget_new (_tmp7_, ______lambda9__baobab_location_widget_action_on_click, self);
					g_object_ref_sink (_tmp8_);
					_g_object_unref0 (loc_widget);
					loc_widget = _tmp8_;
				} else {
					BaobabLocation* _tmp9_;
					BaobabLocationWidget* _tmp10_;
					_tmp9_ = location;
					_tmp10_ = baobab_location_widget_new (_tmp9_, ______lambda10__baobab_location_widget_action_on_click, self);
					g_object_ref_sink (_tmp10_);
					_g_object_unref0 (loc_widget);
					loc_widget = _tmp10_;
				}
				_tmp11_ = self->priv->location_view;
				_tmp12_ = loc_widget;
				gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
				_g_object_unref0 (loc_widget);
				_baobab_location_unref0 (location);
			}
		}
	}
	_tmp13_ = self->priv->location_view;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
}


static void __lambda6_ (BaobabWindow* self) {
	baobab_window_update_locations (self);
}


static void ___lambda6__baobab_location_monitor_changed (BaobabLocationMonitor* _sender, gpointer self) {
	__lambda6_ (self);
}


static void baobab_window_setup_home_page (BaobabWindow* self) {
	BaobabLocationMonitor* _tmp0_ = NULL;
	BaobabLocationMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_monitor_get ();
	_baobab_location_monitor_unref0 (self->priv->location_monitor);
	self->priv->location_monitor = _tmp0_;
	_tmp1_ = self->priv->location_monitor;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) ___lambda6__baobab_location_monitor_changed, self, 0);
	baobab_window_update_locations (self);
}


static gboolean baobab_window_show_treeview_popup (BaobabWindow* self, GtkMenu* popup, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (popup != NULL, FALSE);
	_tmp0_ = event;
	if (_tmp0_ != NULL) {
		GtkMenu* _tmp1_;
		GdkEventButton* _tmp2_;
		guint _tmp3_;
		GdkEventButton* _tmp4_;
		guint32 _tmp5_;
		_tmp1_ = popup;
		_tmp2_ = event;
		_tmp3_ = (*_tmp2_).button;
		_tmp4_ = event;
		_tmp5_ = (*_tmp4_).time;
		gtk_menu_popup (_tmp1_, NULL, NULL, NULL, NULL, _tmp3_, _tmp5_);
	} else {
		GtkMenu* _tmp6_;
		guint32 _tmp7_ = 0U;
		GtkMenu* _tmp8_;
		_tmp6_ = popup;
		_tmp7_ = gtk_get_current_event_time ();
		gtk_menu_popup (_tmp6_, NULL, NULL, NULL, NULL, (guint) 0, _tmp7_);
		_tmp8_ = popup;
		gtk_menu_shell_select_first ((GtkMenuShell*) _tmp8_, FALSE);
	}
	result = TRUE;
	return result;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BaobabWindow * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->selection);
		_g_object_unref0 (_data4_->popup);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean __lambda12_ (Block4Data* _data4_, GdkEventButton* event) {
	BaobabWindow * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data4_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_event_triggers_context_menu ((GdkEvent*) (event));
	if (_tmp0_) {
		GdkEventButton _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = *event;
		_tmp2_ = baobab_window_show_treeview_popup (self, _data4_->popup, &_tmp1_);
		result = _tmp2_;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda12__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = __lambda12_ (self, event);
	return result;
}


static gboolean __lambda13_ (Block4Data* _data4_) {
	BaobabWindow * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = _data4_->self;
	_tmp0_ = baobab_window_show_treeview_popup (self, _data4_->popup, NULL);
	result = _tmp0_;
	return result;
}


static gboolean ___lambda13__gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = __lambda13_ (self);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void __lambda14_ (BaobabWindow* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		gchar* parse_name = NULL;
		BaobabScanner* _tmp6_;
		GtkTreeIter _tmp7_;
		const gchar* _tmp8_;
		GFile* _tmp9_ = NULL;
		GFile* file;
		_tmp6_ = self->priv->scanner;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, &parse_name, -1);
		_tmp8_ = parse_name;
		_tmp9_ = g_file_parse_name (_tmp8_);
		file = _tmp9_;
		{
			GFile* _tmp10_;
			GFileInfo* _tmp11_ = NULL;
			GFileInfo* info;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* content;
			const gchar* _tmp15_;
			GAppInfo* _tmp16_ = NULL;
			GAppInfo* appinfo;
			GList* files;
			GFile* _tmp17_;
			GFile* _tmp18_;
			GAppInfo* _tmp19_;
			GList* _tmp20_;
			_tmp10_ = file;
			_tmp11_ = g_file_query_info (_tmp10_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error_);
			info = _tmp11_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_tmp12_ = info;
			_tmp13_ = g_file_info_get_content_type (_tmp12_);
			_tmp14_ = g_strdup (_tmp13_);
			content = _tmp14_;
			_tmp15_ = content;
			_tmp16_ = g_app_info_get_default_for_type (_tmp15_, TRUE);
			appinfo = _tmp16_;
			files = NULL;
			_tmp17_ = file;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			files = g_list_append (files, _tmp18_);
			_tmp19_ = appinfo;
			_tmp20_ = files;
			g_app_info_launch (_tmp19_, _tmp20_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				__g_list_free__g_object_unref0_0 (files);
				_g_object_unref0 (appinfo);
				_g_free0 (content);
				_g_object_unref0 (info);
				goto __catch10_g_error;
			}
			__g_list_free__g_object_unref0_0 (files);
			_g_object_unref0 (appinfo);
			_g_free0 (content);
			_g_object_unref0 (info);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			g_warning ("baobab-window.vala:409: Failed open file with application: %s", _tmp22_);
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (parse_name);
			_g_object_unref0 (selection);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (file);
		_g_free0 (parse_name);
	}
	_g_object_unref0 (selection);
}


static void ___lambda14__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda14_ (self);
}


static void __lambda15_ (BaobabWindow* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (_tmp5_) {
		gchar* parse_name = NULL;
		BaobabScanner* _tmp6_;
		GtkTreeIter _tmp7_;
		const gchar* _tmp8_;
		GFile* _tmp9_ = NULL;
		GFile* file;
		_tmp6_ = self->priv->scanner;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, &parse_name, -1);
		_tmp8_ = parse_name;
		_tmp9_ = g_file_parse_name (_tmp8_);
		file = _tmp9_;
		{
			GFile* _tmp10_;
			BaobabScanner* _tmp11_;
			_tmp10_ = file;
			g_file_trash (_tmp10_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			_tmp11_ = self->priv->scanner;
			gtk_tree_store_remove ((GtkTreeStore*) _tmp11_, &iter);
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("baobab-window.vala:425: Failed to move file to the trash: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally11:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			_g_free0 (parse_name);
			_g_object_unref0 (selection);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (file);
		_g_free0 (parse_name);
	}
	_g_object_unref0 (selection);
}


static void ___lambda15__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda15_ (self);
}


static void __lambda16_ (Block4Data* _data4_) {
	BaobabWindow * self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	self = _data4_->self;
	_tmp1_ = gtk_tree_selection_get_selected (_data4_->selection, NULL, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		BaobabScanner* _tmp2_;
		GtkTreeIter _tmp3_;
		GtkTreePath* _tmp4_ = NULL;
		GtkTreePath* path;
		BaobabChart* _tmp5_;
		GtkTreePath* _tmp6_;
		BaobabChart* _tmp7_;
		GtkTreePath* _tmp8_;
		_tmp2_ = self->priv->scanner;
		_tmp3_ = iter;
		_tmp4_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp2_, &_tmp3_);
		path = _tmp4_;
		_tmp5_ = self->priv->rings_chart;
		_tmp6_ = path;
		baobab_chart_set_root (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->treemap_chart;
		_tmp8_ = path;
		baobab_chart_set_root (_tmp7_, _tmp8_);
		_gtk_tree_path_free0 (path);
	}
}


static void ___lambda16__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda16_ (self);
}


static void baobab_window_setup_treeview (BaobabWindow* self, GtkBuilder* builder) {
	Block4Data* _data4_;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_ = NULL;
	GtkMenu* _tmp2_;
	GtkBuilder* _tmp3_;
	GObject* _tmp4_ = NULL;
	GtkMenuItem* _tmp5_;
	GtkMenuItem* open_item;
	GtkBuilder* _tmp6_;
	GObject* _tmp7_ = NULL;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* trash_item;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeSelection* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "treeview-popup-menu");
	_tmp2_ = _g_object_ref0 (GTK_IS_MENU (_tmp1_) ? ((GtkMenu*) _tmp1_) : NULL);
	_data4_->popup = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "treeview-popup-open");
	_tmp5_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp4_) ? ((GtkMenuItem*) _tmp4_) : NULL);
	open_item = _tmp5_;
	_tmp6_ = builder;
	_tmp7_ = gtk_builder_get_object (_tmp6_, "treeview-popup-trash");
	_tmp8_ = _g_object_ref0 (GTK_IS_MENU_ITEM (_tmp7_) ? ((GtkMenuItem*) _tmp7_) : NULL);
	trash_item = _tmp8_;
	_tmp9_ = self->priv->treeview;
	g_signal_connect_data ((GtkWidget*) _tmp9_, "button-press-event", (GCallback) ___lambda12__gtk_widget_button_press_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp10_ = self->priv->treeview;
	g_signal_connect_data ((GtkWidget*) _tmp10_, "popup-menu", (GCallback) ___lambda13__gtk_widget_popup_menu, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_object (open_item, "activate", (GCallback) ___lambda14__gtk_menu_item_activate, self, 0);
	g_signal_connect_object (trash_item, "activate", (GCallback) ___lambda15__gtk_menu_item_activate, self, 0);
	_tmp11_ = self->priv->treeview;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_data4_->selection = _tmp13_;
	g_signal_connect_data (_data4_->selection, "changed", (GCallback) ___lambda16__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (trash_item);
	_g_object_unref0 (open_item);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static void baobab_window_message (BaobabWindow* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType type) {
	GtkInfoBar* _tmp0_;
	GtkMessageType _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GtkInfoBar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_msg != NULL);
	g_return_if_fail (secondary_msg != NULL);
	_tmp0_ = self->priv->infobar;
	_tmp1_ = type;
	gtk_info_bar_set_message_type (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->infobar_primary;
	_tmp3_ = primary_msg;
	_tmp4_ = _ (_tmp3_);
	_tmp5_ = g_strdup_printf ("<b>%s</b>", _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_label (_tmp2_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->infobar_secondary;
	_tmp8_ = secondary_msg;
	_tmp9_ = _ (_tmp8_);
	_tmp10_ = g_strdup_printf ("<small>%s</small>", _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _tmp12_);
}


static void baobab_window_clear_message (BaobabWindow* self) {
	GtkInfoBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static void baobab_window_set_busy (BaobabWindow* self, gboolean busy) {
	GdkCursor* cursor;
	gboolean _tmp0_;
	GdkWindow* _tmp20_ = NULL;
	GdkWindow* _tmp21_;
	GdkWindow* window;
	GdkWindow* _tmp22_;
	g_return_if_fail (self != NULL);
	cursor = NULL;
	_tmp0_ = busy;
	if (_tmp0_) {
		GdkCursor* _tmp1_;
		GdkCursor* _tmp2_;
		BaobabChart* _tmp3_;
		BaobabChart* _tmp4_;
		GAction* _tmp5_ = NULL;
		GtkNotebook* _tmp6_;
		GtkSpinner* _tmp7_;
		GtkToolButton* _tmp8_;
		const gchar* _tmp9_ = NULL;
		_tmp1_ = baobab_window_busy_cursor;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (cursor);
		cursor = _tmp2_;
		baobab_window_disable_drop (self);
		_tmp3_ = self->priv->rings_chart;
		baobab_chart_freeze_updates (_tmp3_);
		_tmp4_ = self->priv->treemap_chart;
		baobab_chart_freeze_updates (_tmp4_);
		_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "active-chart");
		g_simple_action_set_enabled (G_IS_SIMPLE_ACTION (_tmp5_) ? ((GSimpleAction*) _tmp5_) : NULL, FALSE);
		_tmp6_ = self->priv->chart_notebook;
		g_object_set (_tmp6_, "page", (gint) BAOBAB_WINDOW_CHART_PAGE_SPINNER, NULL);
		_tmp7_ = self->priv->spinner;
		gtk_spinner_start (_tmp7_);
		_tmp8_ = self->priv->toolbar_show_home_page;
		_tmp9_ = _ ("Cancel scan");
		gtk_tool_button_set_label (_tmp8_, _tmp9_);
	} else {
		BaobabChart* _tmp10_;
		BaobabChart* _tmp11_;
		GAction* _tmp12_ = NULL;
		GtkSpinner* _tmp13_;
		GAction* _tmp14_ = NULL;
		GSettings* _tmp15_;
		GVariant* _tmp16_ = NULL;
		GVariant* _tmp17_;
		GtkToolButton* _tmp18_;
		const gchar* _tmp19_ = NULL;
		baobab_window_enable_drop (self);
		_tmp10_ = self->priv->rings_chart;
		baobab_chart_thaw_updates (_tmp10_);
		_tmp11_ = self->priv->treemap_chart;
		baobab_chart_thaw_updates (_tmp11_);
		_tmp12_ = g_action_map_lookup_action ((GActionMap*) self, "active-chart");
		g_simple_action_set_enabled (G_IS_SIMPLE_ACTION (_tmp12_) ? ((GSimpleAction*) _tmp12_) : NULL, TRUE);
		_tmp13_ = self->priv->spinner;
		gtk_spinner_stop (_tmp13_);
		_tmp14_ = g_action_map_lookup_action ((GActionMap*) self, "active-chart");
		_tmp15_ = self->priv->ui_settings;
		_tmp16_ = g_settings_get_value (_tmp15_, "active-chart");
		_tmp17_ = _tmp16_;
		g_action_change_state (_tmp14_, _tmp17_);
		_g_variant_unref0 (_tmp17_);
		_tmp18_ = self->priv->toolbar_show_home_page;
		_tmp19_ = _ ("All locations");
		gtk_tool_button_set_label (_tmp18_, _tmp19_);
	}
	_tmp20_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp21_ = _g_object_ref0 (_tmp20_);
	window = _tmp21_;
	_tmp22_ = window;
	if (_tmp22_ != NULL) {
		GdkWindow* _tmp23_;
		GdkCursor* _tmp24_;
		_tmp23_ = window;
		_tmp24_ = cursor;
		gdk_window_set_cursor (_tmp23_, _tmp24_);
	}
	{
		BaobabWindowActionState* action_state_collection = NULL;
		gint action_state_collection_length1 = 0;
		gint _action_state_collection_size_ = 0;
		gint action_state_it = 0;
		action_state_collection = BAOBAB_WINDOW_actions_while_scanning;
		action_state_collection_length1 = G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning);
		for (action_state_it = 0; action_state_it < G_N_ELEMENTS (BAOBAB_WINDOW_actions_while_scanning); action_state_it = action_state_it + 1) {
			BaobabWindowActionState _tmp25_ = {0};
			BaobabWindowActionState action_state = {0};
			baobab_window_action_state_copy (&action_state_collection[action_state_it], &_tmp25_);
			action_state = _tmp25_;
			{
				BaobabWindowActionState _tmp26_;
				const gchar* _tmp27_;
				GAction* _tmp28_ = NULL;
				GSimpleAction* _tmp29_;
				GSimpleAction* action;
				GSimpleAction* _tmp30_;
				gboolean _tmp31_;
				BaobabWindowActionState _tmp32_;
				gboolean _tmp33_;
				_tmp26_ = action_state;
				_tmp27_ = _tmp26_.name;
				_tmp28_ = g_action_map_lookup_action ((GActionMap*) self, _tmp27_);
				_tmp29_ = _g_object_ref0 (G_IS_SIMPLE_ACTION (_tmp28_) ? ((GSimpleAction*) _tmp28_) : NULL);
				action = _tmp29_;
				_tmp30_ = action;
				_tmp31_ = busy;
				_tmp32_ = action_state;
				_tmp33_ = _tmp32_.enable;
				g_simple_action_set_enabled (_tmp30_, _tmp31_ == _tmp33_);
				_g_object_unref0 (action);
				baobab_window_action_state_destroy (&action_state);
			}
		}
	}
	_g_object_unref0 (window);
	_g_object_unref0 (cursor);
}


gboolean baobab_window_check_dir (BaobabWindow* self, GFile* directory) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* info;
		GFileInfo* _tmp2_;
		GFileType _tmp3_ = 0;
		_tmp0_ = directory;
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		_tmp2_ = info;
		_tmp3_ = g_file_info_get_file_type (_tmp2_);
		if (_tmp3_ != G_FILE_TYPE_DIRECTORY) {
			const gchar* _tmp4_ = NULL;
			GFile* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* primary;
			const gchar* _tmp10_;
			const gchar* _tmp11_ = NULL;
			_tmp4_ = _ ("\"%s\" is not a valid folder");
			_tmp5_ = directory;
			_tmp6_ = g_file_get_parse_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			primary = _tmp9_;
			_tmp10_ = primary;
			_tmp11_ = _ ("Could not analyze disk usage.");
			baobab_window_message (self, _tmp10_, _tmp11_, GTK_MESSAGE_ERROR);
			result = FALSE;
			_g_free0 (primary);
			_g_object_unref0 (info);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (info);
		return result;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
		GFile* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* primary;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _ ("\"%s\" is not a valid folder");
		_tmp13_ = directory;
		_tmp14_ = g_file_get_parse_name (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf (_tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		primary = _tmp17_;
		_tmp18_ = primary;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		baobab_window_message (self, _tmp18_, _tmp20_, GTK_MESSAGE_ERROR);
		result = FALSE;
		_g_free0 (primary);
		_g_error_free0 (e);
		return result;
	}
	__finally12:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


static void _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_window_first_row_has_child (self, _sender, path, iter);
}


static void baobab_window_first_row_has_child (BaobabWindow* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreeModel* _tmp0_;
	guint _tmp1_ = 0U;
	GtkTreeView* _tmp2_;
	GtkTreePath* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	g_signal_parse_name ("row-has-child-toggled", GTK_TYPE_TREE_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled, self);
	_tmp2_ = self->priv->treeview;
	_tmp3_ = path;
	gtk_tree_view_expand_row (_tmp2_, _tmp3_, FALSE);
}


static void baobab_window_set_model (BaobabWindow* self, GtkTreeModel* model) {
	GtkTreeIter first = {0};
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_;
	GtkTreeModel* _tmp16_;
	BaobabChart* _tmp17_;
	GtkTreeModel* _tmp18_;
	BaobabChart* _tmp19_;
	BaobabChart* _tmp20_;
	GtkTreeModel* _tmp21_;
	BaobabChart* _tmp22_;
	GtkTreeModel* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = model;
	gtk_tree_view_set_model (_tmp0_, _tmp1_);
	_tmp3_ = model;
	_tmp5_ = gtk_tree_model_iter_children (_tmp3_, &_tmp4_, NULL);
	first = _tmp4_;
	if (_tmp5_) {
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp6_ = model;
		_tmp7_ = first;
		_tmp8_ = gtk_tree_model_iter_has_child (_tmp6_, &_tmp7_);
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp9_ = _tmp2_;
	if (_tmp9_) {
		GtkTreeView* _tmp10_;
		GtkTreeModel* _tmp11_;
		GtkTreeIter _tmp12_;
		GtkTreePath* _tmp13_ = NULL;
		GtkTreePath* _tmp14_;
		_tmp10_ = self->priv->treeview;
		_tmp11_ = model;
		_tmp12_ = first;
		_tmp13_ = gtk_tree_model_get_path (_tmp11_, &_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_tree_view_expand_row (_tmp10_, _tmp14_, FALSE);
		_gtk_tree_path_free0 (_tmp14_);
	} else {
		GtkTreeModel* _tmp15_;
		_tmp15_ = model;
		g_signal_connect_object (_tmp15_, "row-has-child-toggled", (GCallback) _baobab_window_first_row_has_child_gtk_tree_model_row_has_child_toggled, self, 0);
	}
	_tmp16_ = model;
	_tmp17_ = self->priv->rings_chart;
	g_object_bind_property_with_closures ((GObject*) _tmp16_, "max-depth", (GObject*) _tmp17_, "max-depth", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp18_ = model;
	_tmp19_ = self->priv->treemap_chart;
	g_object_bind_property_with_closures ((GObject*) _tmp18_, "max-depth", (GObject*) _tmp19_, "max-depth", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp20_ = self->priv->treemap_chart;
	_tmp21_ = model;
	baobab_chart_set_model_with_columns (_tmp20_, _tmp21_, (guint) BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, (guint) BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, (guint) BAOBAB_SCANNER_COLUMNS_PARSE_NAME, (guint) BAOBAB_SCANNER_COLUMNS_PERCENT, (guint) BAOBAB_SCANNER_COLUMNS_ELEMENTS, NULL);
	_tmp22_ = self->priv->rings_chart;
	_tmp23_ = model;
	baobab_chart_set_model_with_columns (_tmp22_, _tmp23_, (guint) BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, (guint) BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, (guint) BAOBAB_SCANNER_COLUMNS_PARSE_NAME, (guint) BAOBAB_SCANNER_COLUMNS_PERCENT, (guint) BAOBAB_SCANNER_COLUMNS_ELEMENTS, NULL);
}


static void __lambda3_ (BaobabWindow* self) {
	GError * _inner_error_ = NULL;
	baobab_window_set_busy (self, FALSE);
	{
		BaobabScanner* _tmp0_;
		_tmp0_ = self->priv->scanner;
		baobab_scanner_finish (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch13_g_io_error_cancelled;
			}
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_io_error_cancelled:
	{
		GError* e = NULL;
		BaobabScanner* _tmp1_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = self->priv->scanner;
		gtk_tree_store_clear ((GtkTreeStore*) _tmp1_);
		_g_error_free0 (e);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		BaobabScanner* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* primary;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _ ("Could not scan folder \"%s\" or some of the folders it contains.");
		_tmp3_ = self->priv->scanner;
		_tmp4_ = baobab_scanner_get_directory (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_parse_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf (_tmp2_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		primary = _tmp9_;
		_tmp10_ = primary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		baobab_window_message (self, _tmp10_, _tmp12_, GTK_MESSAGE_WARNING);
		_g_free0 (primary);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda3__baobab_scanner_completed (BaobabScanner* _sender, gpointer self) {
	__lambda3_ (self);
}


void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags) {
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	BaobabScanFlags _tmp3_;
	BaobabScanner* _tmp4_;
	BaobabScanner* _tmp5_;
	BaobabScanner* _tmp6_;
	BaobabScanner* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	_tmp0_ = directory;
	_tmp1_ = baobab_window_check_dir (self, _tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = directory;
	_tmp3_ = flags;
	_tmp4_ = baobab_scanner_new (_tmp2_, _tmp3_);
	_g_object_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp4_;
	_tmp5_ = self->priv->scanner;
	baobab_window_set_model (self, (GtkTreeModel*) _tmp5_);
	_tmp6_ = self->priv->scanner;
	g_signal_connect_object (_tmp6_, "completed", (GCallback) ___lambda3__baobab_scanner_completed, self, 0);
	baobab_window_clear_message (self);
	baobab_window_set_ui_page (self, BAOBAB_WINDOW_UI_PAGE_RESULT);
	baobab_window_set_busy (self, TRUE);
	_tmp7_ = self->priv->scanner;
	baobab_scanner_scan (_tmp7_);
}


void baobab_window_action_state_copy (const BaobabWindowActionState* self, BaobabWindowActionState* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).enable;
	(*dest).enable = _tmp2_;
}


void baobab_window_action_state_destroy (BaobabWindowActionState* self) {
	_g_free0 ((*self).name);
}


BaobabWindowActionState* baobab_window_action_state_dup (const BaobabWindowActionState* self) {
	BaobabWindowActionState* dup;
	dup = g_new0 (BaobabWindowActionState, 1);
	baobab_window_action_state_copy (self, dup);
	return dup;
}


void baobab_window_action_state_free (BaobabWindowActionState* self) {
	baobab_window_action_state_destroy (self);
	g_free (self);
}


GType baobab_window_action_state_get_type (void) {
	static volatile gsize baobab_window_action_state_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_action_state_type_id__volatile)) {
		GType baobab_window_action_state_type_id;
		baobab_window_action_state_type_id = g_boxed_type_register_static ("BaobabWindowActionState", (GBoxedCopyFunc) baobab_window_action_state_dup, (GBoxedFreeFunc) baobab_window_action_state_free);
		g_once_init_leave (&baobab_window_action_state_type_id__volatile, baobab_window_action_state_type_id);
	}
	return baobab_window_action_state_type_id__volatile;
}


static void baobab_window_class_init (BaobabWindowClass * klass) {
	baobab_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = baobab_window_finalize;
}


static void baobab_window_instance_init (BaobabWindow * self) {
	self->priv = BAOBAB_WINDOW_GET_PRIVATE (self);
}


static void baobab_window_finalize (GObject* obj) {
	BaobabWindow * self;
	self = BAOBAB_WINDOW (obj);
	_g_object_unref0 (self->priv->ui_settings);
	_g_object_unref0 (self->priv->main_notebook);
	_g_object_unref0 (self->priv->toolbar);
	_g_object_unref0 (self->priv->toolbar_home_toolitem);
	_g_object_unref0 (self->priv->toolbar_show_home_page);
	_g_object_unref0 (self->priv->toolbar_rescan);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->infobar_primary);
	_g_object_unref0 (self->priv->infobar_secondary);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->chart_notebook);
	_g_object_unref0 (self->priv->location_view);
	_g_object_unref0 (self->priv->rings_chart);
	_g_object_unref0 (self->priv->treemap_chart);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->scanner);
	_baobab_location_monitor_unref0 (self->priv->location_monitor);
	G_OBJECT_CLASS (baobab_window_parent_class)->finalize (obj);
}


GType baobab_window_get_type (void) {
	static volatile gsize baobab_window_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabWindow), 0, (GInstanceInitFunc) baobab_window_instance_init, NULL };
		GType baobab_window_type_id;
		baobab_window_type_id = g_type_register_static (GTK_TYPE_APPLICATION_WINDOW, "BaobabWindow", &g_define_type_info, 0);
		g_once_init_leave (&baobab_window_type_id__volatile, baobab_window_type_id);
	}
	return baobab_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



