/* baobab-location.c generated by valac 0.17.1.35-814b, the Vala compiler
 * generated from baobab-location.vala, do not modify */

/* -*- indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>


#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;
typedef struct _BaobabLocationPrivate BaobabLocationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BaobabLocationMountVolumeData BaobabLocationMountVolumeData;
typedef struct _BaobabParamSpecLocation BaobabParamSpecLocation;

struct _BaobabLocation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabLocationPrivate * priv;
};

struct _BaobabLocationClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabLocation *self);
};

struct _BaobabLocationPrivate {
	gchar* _name;
	gchar* _mount_point;
	guint64* _size;
	guint64* _used;
	guint64* _reserved;
	GIcon* _icon;
	GVolume* _volume;
	GMount* _mount;
};

struct _BaobabLocationMountVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BaobabLocation* self;
	gboolean _tmp0_;
	GMount* _tmp1_;
	GVolume* _tmp2_;
	gboolean _tmp3_;
	GtkMountOperation* _tmp4_;
	GtkMountOperation* mount_op;
	GVolume* _tmp5_;
	GtkMountOperation* _tmp6_;
	GError * _inner_error_;
};

struct _BaobabParamSpecLocation {
	GParamSpec parent_instance;
};


static gpointer baobab_location_parent_class = NULL;
static BaobabLocation* baobab_location_home_location;
static BaobabLocation* baobab_location_home_location = NULL;

gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION, BaobabLocationPrivate))
enum  {
	BAOBAB_LOCATION_DUMMY_PROPERTY
};
#define BAOBAB_LOCATION_FS_ATTRIBUTES G_FILE_ATTRIBUTE_FILESYSTEM_SIZE "," G_FILE_ATTRIBUTE_FILESYSTEM_USED
BaobabLocation* baobab_location_get_home_location (void);
BaobabLocation* baobab_location_new_from_volume (GVolume* volume_);
BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_);
static void baobab_location_set_volume (BaobabLocation* self, GVolume* value);
GVolume* baobab_location_get_volume (BaobabLocation* self);
static void __lambda2_ (BaobabLocation* self, GVolume* vol);
static void baobab_location_update_volume_info (BaobabLocation* self);
static void ___lambda2__g_volume_changed (GVolume* _sender, gpointer self);
BaobabLocation* baobab_location_new_from_mount (GMount* mount_);
BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_);
static void baobab_location_set_mount (BaobabLocation* self, GMount* value);
static void baobab_location_fill_from_mount (BaobabLocation* self);
BaobabLocation* baobab_location_new_for_main_volume (void);
BaobabLocation* baobab_location_construct_for_main_volume (GType object_type);
static void baobab_location_set_name (BaobabLocation* self, const gchar* value);
static void baobab_location_set_mount_point (BaobabLocation* self, const gchar* value);
static void baobab_location_set_icon (BaobabLocation* self, GIcon* value);
static void baobab_location_get_fs_usage (BaobabLocation* self, GFile* file);
const gchar* baobab_location_get_mount_point (BaobabLocation* self);
BaobabLocation* baobab_location_new_for_home_folder (void);
BaobabLocation* baobab_location_construct_for_home_folder (GType object_type);
static void baobab_location_make_this_home_location (BaobabLocation* self);
GMount* baobab_location_get_mount (BaobabLocation* self);
static void baobab_location_set_size (BaobabLocation* self, guint64* value);
static void baobab_location_set_used (BaobabLocation* self, guint64* value);
static void baobab_location_set_reserved (BaobabLocation* self, guint64* value);
guint64* baobab_location_get_size (BaobabLocation* self);
guint64* baobab_location_get_used (BaobabLocation* self);
static void baobab_location_mount_volume_data_free (gpointer _data);
void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error);
static gboolean baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_);
static void baobab_location_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
BaobabLocation* baobab_location_new (void);
BaobabLocation* baobab_location_construct (GType object_type);
const gchar* baobab_location_get_name (BaobabLocation* self);
static guint64* _uint64_dup (guint64* self);
guint64* baobab_location_get_reserved (BaobabLocation* self);
GIcon* baobab_location_get_icon (BaobabLocation* self);
gboolean baobab_location_get_is_home_location (BaobabLocation* self);
static void baobab_location_finalize (BaobabLocation* obj);


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


BaobabLocation* baobab_location_get_home_location (void) {
	BaobabLocation* result = NULL;
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	_tmp0_ = baobab_location_home_location;
	_tmp1_ = _baobab_location_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void __lambda2_ (BaobabLocation* self, GVolume* vol) {
	g_return_if_fail (vol != NULL);
	baobab_location_update_volume_info (self);
}


static void ___lambda2__g_volume_changed (GVolume* _sender, gpointer self) {
	__lambda2_ (self, _sender);
}


BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_) {
	BaobabLocation* self = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	g_return_val_if_fail (volume_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = volume_;
	baobab_location_set_volume (self, _tmp0_);
	_tmp1_ = self->priv->_volume;
	g_signal_connect (_tmp1_, "changed", (GCallback) ___lambda2__g_volume_changed, self);
	baobab_location_update_volume_info (self);
	return self;
}


BaobabLocation* baobab_location_new_from_volume (GVolume* volume_) {
	return baobab_location_construct_from_volume (BAOBAB_TYPE_LOCATION, volume_);
}


BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_) {
	BaobabLocation* self = NULL;
	GMount* _tmp0_;
	g_return_val_if_fail (mount_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = mount_;
	baobab_location_set_mount (self, _tmp0_);
	baobab_location_fill_from_mount (self);
	return self;
}


BaobabLocation* baobab_location_new_from_mount (GMount* mount_) {
	return baobab_location_construct_from_mount (BAOBAB_TYPE_LOCATION, mount_);
}


BaobabLocation* baobab_location_construct_for_main_volume (GType object_type) {
	BaobabLocation* self = NULL;
	const gchar* _tmp0_ = NULL;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	const gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = _ ("Main volume");
	baobab_location_set_name (self, _tmp0_);
	baobab_location_set_mount_point (self, "/");
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("drive-harddisk-system");
	_tmp2_ = _tmp1_;
	baobab_location_set_icon (self, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_mount_point;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	baobab_location_get_fs_usage (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	return self;
}


BaobabLocation* baobab_location_new_for_main_volume (void) {
	return baobab_location_construct_for_main_volume (BAOBAB_TYPE_LOCATION);
}


BaobabLocation* baobab_location_construct_for_home_folder (GType object_type) {
	BaobabLocation* self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = g_get_home_dir ();
	baobab_location_set_mount_point (self, _tmp0_);
	baobab_location_make_this_home_location (self);
	_tmp1_ = self->priv->_mount_point;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	baobab_location_get_fs_usage (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}


BaobabLocation* baobab_location_new_for_home_folder (void) {
	return baobab_location_construct_for_home_folder (BAOBAB_TYPE_LOCATION);
}


static void baobab_location_make_this_home_location (BaobabLocation* self) {
	const gchar* _tmp0_ = NULL;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	BaobabLocation* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Home folder");
	baobab_location_set_name (self, _tmp0_);
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("user-home");
	_tmp2_ = _tmp1_;
	baobab_location_set_icon (self, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = _baobab_location_ref0 (self);
	_baobab_location_unref0 (baobab_location_home_location);
	baobab_location_home_location = _tmp3_;
}


static void baobab_location_update_volume_info (BaobabLocation* self) {
	GVolume* _tmp0_;
	GMount* _tmp1_ = NULL;
	GMount* _tmp2_;
	GMount* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_mount (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_mount;
	if (_tmp3_ != NULL) {
		baobab_location_fill_from_mount (self);
	} else {
		GVolume* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		GVolume* _tmp7_;
		GIcon* _tmp8_ = NULL;
		GIcon* _tmp9_;
		_tmp4_ = self->priv->_volume;
		_tmp5_ = g_volume_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		baobab_location_set_name (self, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->_volume;
		_tmp8_ = g_volume_get_icon (_tmp7_);
		_tmp9_ = _tmp8_;
		baobab_location_set_icon (self, _tmp9_);
		_g_object_unref0 (_tmp9_);
		baobab_location_set_mount_point (self, NULL);
		baobab_location_set_size (self, NULL);
		baobab_location_set_used (self, NULL);
	}
}


static void baobab_location_fill_from_mount (BaobabLocation* self) {
	GMount* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GMount* _tmp3_;
	GIcon* _tmp4_ = NULL;
	GIcon* _tmp5_;
	GMount* _tmp6_;
	GFile* _tmp7_ = NULL;
	GFile* file;
	GFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	GFile* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mount;
	_tmp1_ = g_mount_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_mount;
	_tmp4_ = g_mount_get_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	baobab_location_set_icon (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_mount;
	_tmp7_ = g_mount_get_root (_tmp6_);
	file = _tmp7_;
	_tmp8_ = file;
	_tmp9_ = g_file_get_path (_tmp8_);
	_tmp10_ = _tmp9_;
	baobab_location_set_mount_point (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->_mount_point;
	_tmp12_ = g_get_home_dir ();
	if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
		baobab_location_make_this_home_location (self);
	}
	_tmp13_ = file;
	baobab_location_get_fs_usage (self, _tmp13_);
	_g_object_unref0 (file);
}


static void baobab_location_get_fs_usage (BaobabLocation* self, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	baobab_location_set_size (self, NULL);
	baobab_location_set_used (self, NULL);
	baobab_location_set_reserved (self, NULL);
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* info;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		guint64* _tmp8_;
		gboolean _tmp10_;
		gboolean _tmp12_;
		_tmp0_ = file;
		_tmp1_ = g_file_query_filesystem_info (_tmp0_, BAOBAB_LOCATION_FS_ATTRIBUTES, NULL, &_inner_error_);
		info = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp2_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		if (_tmp2_) {
			guint64 _tmp3_ = 0ULL;
			_tmp3_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
			baobab_location_set_size (self, &_tmp3_);
		}
		_tmp4_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
		if (_tmp4_) {
			guint64 _tmp5_ = 0ULL;
			_tmp5_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
			baobab_location_set_used (self, &_tmp5_);
		}
		_tmp8_ = self->priv->_size;
		if (_tmp8_ != NULL) {
			guint64* _tmp9_;
			_tmp9_ = self->priv->_used;
			_tmp7_ = _tmp9_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gboolean _tmp11_ = FALSE;
			_tmp11_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			_tmp6_ = _tmp11_;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp12_ = _tmp6_;
		if (_tmp12_) {
			guint64 _tmp13_ = 0ULL;
			guint64 free;
			guint64* _tmp14_;
			guint64 _tmp15_;
			guint64* _tmp16_;
			guint64 _tmp17_;
			_tmp13_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			free = _tmp13_;
			_tmp14_ = self->priv->_size;
			_tmp15_ = free;
			_tmp16_ = self->priv->_used;
			_tmp17_ = ((*_tmp14_) - _tmp15_) - (*_tmp16_);
			baobab_location_set_reserved (self, &_tmp17_);
		}
		_g_object_unref0 (info);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void baobab_location_mount_volume_data_free (gpointer _data) {
	BaobabLocationMountVolumeData* _data_;
	_data_ = _data;
	_baobab_location_unref0 (_data_->self);
	g_slice_free (BaobabLocationMountVolumeData, _data_);
}


void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BaobabLocationMountVolumeData* _data_;
	BaobabLocation* _tmp0_;
	_data_ = g_slice_new0 (BaobabLocationMountVolumeData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, baobab_location_mount_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, baobab_location_mount_volume_data_free);
	_tmp0_ = _baobab_location_ref0 (self);
	_data_->self = _tmp0_;
	baobab_location_mount_volume_co (_data_);
}


void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error) {
	BaobabLocationMountVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void baobab_location_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BaobabLocationMountVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	baobab_location_mount_volume_co (_data_);
}


static gboolean baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->_mount;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->_volume;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	_data_->_tmp3_ = _data_->_tmp0_;
	if (_data_->_tmp3_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = (GtkMountOperation*) gtk_mount_operation_new (NULL);
	_data_->mount_op = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->_volume;
	_data_->_tmp6_ = _data_->mount_op;
	_data_->_state_ = 1;
	g_volume_mount (_data_->_tmp5_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp6_, NULL, baobab_location_mount_volume_ready, _data_);
	return FALSE;
	_state_1:
	g_volume_mount_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->mount_op);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	baobab_location_update_volume_info (_data_->self);
	_g_object_unref0 (_data_->mount_op);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


BaobabLocation* baobab_location_construct (GType object_type) {
	BaobabLocation* self = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	return self;
}


BaobabLocation* baobab_location_new (void) {
	return baobab_location_construct (BAOBAB_TYPE_LOCATION);
}


const gchar* baobab_location_get_name (BaobabLocation* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_name (BaobabLocation* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


const gchar* baobab_location_get_mount_point (BaobabLocation* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount_point;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_mount_point (BaobabLocation* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mount_point);
	self->priv->_mount_point = _tmp1_;
}


guint64* baobab_location_get_size (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static guint64* _uint64_dup (guint64* self) {
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}


static gpointer __uint64_dup0 (gpointer self) {
	return self ? _uint64_dup (self) : NULL;
}


static void baobab_location_set_size (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_;
	guint64* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_size);
	self->priv->_size = _tmp1_;
}


guint64* baobab_location_get_used (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_used;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_used (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_;
	guint64* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_used);
	self->priv->_used = _tmp1_;
}


guint64* baobab_location_get_reserved (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reserved;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_reserved (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_;
	guint64* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_reserved);
	self->priv->_reserved = _tmp1_;
}


GIcon* baobab_location_get_icon (BaobabLocation* self) {
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_location_set_icon (BaobabLocation* self, GIcon* value) {
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
}


GVolume* baobab_location_get_volume (BaobabLocation* self) {
	GVolume* result;
	GVolume* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_volume (BaobabLocation* self, GVolume* value) {
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_volume);
	self->priv->_volume = _tmp1_;
}


GMount* baobab_location_get_mount (BaobabLocation* self) {
	GMount* result;
	GMount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_mount (BaobabLocation* self, GMount* value) {
	GMount* _tmp0_;
	GMount* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_mount);
	self->priv->_mount = _tmp1_;
}


gboolean baobab_location_get_is_home_location (BaobabLocation* self) {
	gboolean result;
	BaobabLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = baobab_location_home_location;
	result = self == _tmp0_;
	return result;
}


static void baobab_value_location_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void baobab_value_location_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		baobab_location_unref (value->data[0].v_pointer);
	}
}


static void baobab_value_location_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer baobab_value_location_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* baobab_value_location_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BaobabLocation* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* baobab_value_location_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BaobabLocation** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_location_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BaobabParamSpecLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer baobab_value_get_location (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION), NULL);
	return value->data[0].v_pointer;
}


void baobab_value_set_location (GValue* value, gpointer v_object) {
	BaobabLocation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}


void baobab_value_take_location (GValue* value, gpointer v_object) {
	BaobabLocation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}


static void baobab_location_class_init (BaobabLocationClass * klass) {
	baobab_location_parent_class = g_type_class_peek_parent (klass);
	BAOBAB_LOCATION_CLASS (klass)->finalize = baobab_location_finalize;
	g_type_class_add_private (klass, sizeof (BaobabLocationPrivate));
}


static void baobab_location_instance_init (BaobabLocation * self) {
	self->priv = BAOBAB_LOCATION_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void baobab_location_finalize (BaobabLocation* obj) {
	BaobabLocation * self;
	self = BAOBAB_LOCATION (obj);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_mount_point);
	_g_free0 (self->priv->_size);
	_g_free0 (self->priv->_used);
	_g_free0 (self->priv->_reserved);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_volume);
	_g_object_unref0 (self->priv->_mount);
}


GType baobab_location_get_type (void) {
	static volatile gsize baobab_location_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { baobab_value_location_init, baobab_value_location_free_value, baobab_value_location_copy_value, baobab_value_location_peek_pointer, "p", baobab_value_location_collect_value, "p", baobab_value_location_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocation), 0, (GInstanceInitFunc) baobab_location_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType baobab_location_type_id;
		baobab_location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabLocation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&baobab_location_type_id__volatile, baobab_location_type_id);
	}
	return baobab_location_type_id__volatile;
}


gpointer baobab_location_ref (gpointer instance) {
	BaobabLocation* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void baobab_location_unref (gpointer instance) {
	BaobabLocation* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



