/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

gpointer vala_compiler_ref (gpointer instance);
void vala_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_compiler (GValue* value, gpointer v_object);
void vala_value_take_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_compiler (const GValue* value);
GType vala_compiler_get_type (void) G_GNUC_CONST;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
ValaCompiler* vala_compiler_new (void);
ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[47] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	ValaCodeContext* _tmp11_;
	ValaReport* _tmp12_;
	ValaReport* _tmp13_;
	gint _tmp14_ = 0;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_ = 0;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		result = 0;
		return result;
	}
	_tmp11_ = self->priv->context;
	_tmp12_ = vala_code_context_get_report (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_report_get_errors (_tmp13_);
	if (_tmp14_ == 0) {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_;
		gboolean _tmp21_;
		_tmp16_ = vala_compiler_fatal_warnings;
		if (!_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			ValaCodeContext* _tmp17_;
			ValaReport* _tmp18_;
			ValaReport* _tmp19_;
			gint _tmp20_ = 0;
			_tmp17_ = self->priv->context;
			_tmp18_ = vala_code_context_get_report (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_report_get_warnings (_tmp19_);
			_tmp15_ = _tmp20_ == 0;
		}
		_tmp21_ = _tmp15_;
		_tmp10_ = _tmp21_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp22_ = _tmp10_;
	if (_tmp22_) {
		gboolean _tmp23_;
		_tmp23_ = vala_compiler_quiet_mode;
		if (!_tmp23_) {
			FILE* _tmp24_;
			ValaCodeContext* _tmp25_;
			ValaReport* _tmp26_;
			ValaReport* _tmp27_;
			gint _tmp28_ = 0;
			_tmp24_ = stdout;
			_tmp25_ = self->priv->context;
			_tmp26_ = vala_code_context_get_report (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_report_get_warnings (_tmp27_);
			fprintf (_tmp24_, "Compilation succeeded - %d warning(s)\n", _tmp28_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp29_;
		_tmp29_ = vala_compiler_quiet_mode;
		if (!_tmp29_) {
			FILE* _tmp30_;
			ValaCodeContext* _tmp31_;
			ValaReport* _tmp32_;
			ValaReport* _tmp33_;
			gint _tmp34_ = 0;
			ValaCodeContext* _tmp35_;
			ValaReport* _tmp36_;
			ValaReport* _tmp37_;
			gint _tmp38_ = 0;
			_tmp30_ = stdout;
			_tmp31_ = self->priv->context;
			_tmp32_ = vala_code_context_get_report (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_report_get_errors (_tmp33_);
			_tmp35_ = self->priv->context;
			_tmp36_ = vala_code_context_get_report (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_report_get_warnings (_tmp37_);
			fprintf (_tmp30_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp34_, _tmp38_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp6_;
	gboolean _tmp8_;
	ValaCodeContext* _tmp21_;
	gboolean _tmp22_;
	ValaCodeContext* _tmp23_;
	gboolean _tmp24_;
	ValaCodeContext* _tmp25_;
	gboolean _tmp26_;
	ValaCodeContext* _tmp27_;
	gboolean _tmp28_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	ValaCodeContext* _tmp31_;
	ValaReport* _tmp32_;
	ValaReport* _tmp33_;
	gboolean _tmp34_;
	ValaCodeContext* _tmp35_;
	ValaReport* _tmp36_;
	ValaReport* _tmp37_;
	gboolean _tmp38_;
	ValaCodeContext* _tmp39_;
	gboolean _tmp40_;
	ValaCodeContext* _tmp41_;
	gboolean _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	ValaCodeContext* _tmp45_;
	gboolean _tmp46_;
	ValaCodeContext* _tmp47_;
	const gchar* _tmp48_;
	gboolean _tmp49_ = FALSE;
	const gchar* _tmp50_;
	gboolean _tmp52_;
	ValaCodeContext* _tmp53_;
	gboolean _tmp54_;
	ValaCodeContext* _tmp55_;
	const gchar* _tmp56_;
	ValaCodeContext* _tmp57_;
	const gchar* _tmp58_;
	ValaCodeContext* _tmp59_;
	const gchar* _tmp60_;
	ValaCodeContext* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp71_;
	ValaCodeContext* _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	gchar** _tmp82_;
	gint _tmp82__length1;
	ValaCodeContext* _tmp83_;
	gchar** _tmp84_;
	gint _tmp84__length1;
	gchar** _tmp85_;
	gint _tmp85__length1;
	ValaCodeContext* _tmp86_;
	gchar** _tmp87_;
	gint _tmp87__length1;
	gchar** _tmp88_;
	gint _tmp88__length1;
	ValaCodeContext* _tmp89_;
	gboolean _tmp90_;
	ValaCodeContext* _tmp91_;
	gboolean _tmp92_;
	ValaCodeContext* _tmp93_;
	gboolean _tmp94_;
	ValaCodeContext* _tmp95_;
	gboolean _tmp96_;
	const gchar* _tmp97_;
	gboolean _tmp115_;
	const gchar* _tmp116_;
	ValaCodeContext* _tmp117_;
	gboolean _tmp118_;
	ValaCodeContext* _tmp119_;
	const gchar* _tmp120_;
	ValaCodeContext* _tmp121_;
	gboolean _tmp122_;
	gchar** _tmp123_;
	gint _tmp123__length1;
	ValaCodeContext* _tmp136_;
	ValaProfile _tmp137_;
	ValaProfile _tmp138_;
	gchar** _tmp173_;
	gint _tmp173__length1;
	gchar** _tmp178_;
	gint _tmp178__length1;
	gboolean _tmp188_ = FALSE;
	ValaCodeContext* _tmp189_;
	ValaReport* _tmp190_;
	ValaReport* _tmp191_;
	gint _tmp192_ = 0;
	gboolean _tmp200_;
	ValaCodeContext* _tmp202_;
	ValaProfile _tmp203_;
	ValaProfile _tmp204_;
	gboolean has_c_files;
	gchar** _tmp217_;
	gint _tmp217__length1;
	gboolean _tmp225_ = FALSE;
	ValaCodeContext* _tmp226_;
	ValaReport* _tmp227_;
	ValaReport* _tmp228_;
	gint _tmp229_ = 0;
	gboolean _tmp237_;
	ValaParser* _tmp239_;
	ValaParser* parser;
	ValaParser* _tmp240_;
	ValaCodeContext* _tmp241_;
	ValaGenieParser* _tmp242_;
	ValaGenieParser* genie_parser;
	ValaGenieParser* _tmp243_;
	ValaCodeContext* _tmp244_;
	ValaGirParser* _tmp245_;
	ValaGirParser* gir_parser;
	ValaGirParser* _tmp246_;
	ValaCodeContext* _tmp247_;
	gboolean _tmp248_ = FALSE;
	ValaCodeContext* _tmp249_;
	ValaReport* _tmp250_;
	ValaReport* _tmp251_;
	gint _tmp252_ = 0;
	gboolean _tmp260_;
	const gchar* _tmp262_;
	ValaCodeContext* _tmp268_;
	gboolean _tmp269_ = FALSE;
	ValaCodeContext* _tmp270_;
	ValaReport* _tmp271_;
	ValaReport* _tmp272_;
	gint _tmp273_ = 0;
	gboolean _tmp281_;
	gboolean _tmp283_ = FALSE;
	gboolean _tmp284_ = FALSE;
	gboolean _tmp285_;
	gboolean _tmp287_;
	gboolean _tmp289_;
	const gchar* _tmp296_;
	gboolean _tmp301_ = FALSE;
	ValaCodeContext* _tmp302_;
	ValaReport* _tmp303_;
	ValaReport* _tmp304_;
	gint _tmp305_ = 0;
	gboolean _tmp313_;
	ValaCodeContext* _tmp315_;
	ValaCodeGenerator* _tmp316_;
	ValaCodeGenerator* _tmp317_;
	ValaCodeContext* _tmp318_;
	gboolean _tmp319_ = FALSE;
	ValaCodeContext* _tmp320_;
	ValaReport* _tmp321_;
	ValaReport* _tmp322_;
	gint _tmp323_ = 0;
	gboolean _tmp331_;
	gboolean _tmp333_ = FALSE;
	const gchar* _tmp334_;
	gboolean _tmp336_;
	const gchar* _tmp339_;
	const gchar* _tmp395_;
	const gchar* _tmp410_;
	const gchar* _tmp435_;
	gboolean _tmp438_;
	gint _tmp456_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp4_ = vala_compiler_ccode_only;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = vala_compiler_compile_only;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = vala_compiler_output;
		_tmp2_ = _tmp7_ == NULL;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = vala_compiler_sources;
		_tmp9__length1 = _vala_array_length (vala_compiler_sources);
		_tmp10_ = _tmp9_[0];
		_tmp11_ = string_last_index_of_char (_tmp10_, (gunichar) '.', 0);
		if (_tmp11_ != (-1)) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gint _tmp14_ = 0;
			gint dot;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gint _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp12_ = vala_compiler_sources;
			_tmp12__length1 = _vala_array_length (vala_compiler_sources);
			_tmp13_ = _tmp12_[0];
			_tmp14_ = string_last_index_of_char (_tmp13_, (gunichar) '.', 0);
			dot = _tmp14_;
			_tmp15_ = vala_compiler_sources;
			_tmp15__length1 = _vala_array_length (vala_compiler_sources);
			_tmp16_ = _tmp15_[0];
			_tmp17_ = dot;
			_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_path_get_basename (_tmp19_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp20_;
			_g_free0 (_tmp19_);
		}
	}
	_tmp21_ = self->priv->context;
	_tmp22_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp21_, !_tmp22_);
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->context;
	_tmp26_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->context;
	_tmp28_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp29_, _tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_code_context_get_report (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp33_, !_tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_code_context_get_report (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp37_, !_tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp41_, !_tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp47_, _tmp48_);
	_tmp50_ = vala_compiler_header_filename;
	if (_tmp50_ == NULL) {
		gboolean _tmp51_;
		_tmp51_ = vala_compiler_use_header;
		_tmp49_ = _tmp51_;
	} else {
		_tmp49_ = FALSE;
	}
	_tmp52_ = _tmp49_;
	if (_tmp52_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->context;
	_tmp62_ = vala_compiler_output;
	vala_code_context_set_output (_tmp61_, _tmp62_);
	_tmp63_ = vala_compiler_basedir;
	if (_tmp63_ == NULL) {
		ValaCodeContext* _tmp64_;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_;
		_tmp64_ = self->priv->context;
		_tmp65_ = vala_code_context_realpath (".");
		_tmp66_ = _tmp65_;
		vala_code_context_set_basedir (_tmp64_, _tmp66_);
		_g_free0 (_tmp66_);
	} else {
		ValaCodeContext* _tmp67_;
		const gchar* _tmp68_;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_;
		_tmp67_ = self->priv->context;
		_tmp68_ = vala_compiler_basedir;
		_tmp69_ = vala_code_context_realpath (_tmp68_);
		_tmp70_ = _tmp69_;
		vala_code_context_set_basedir (_tmp67_, _tmp70_);
		_g_free0 (_tmp70_);
	}
	_tmp71_ = vala_compiler_directory;
	if (_tmp71_ != NULL) {
		ValaCodeContext* _tmp72_;
		const gchar* _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		_tmp72_ = self->priv->context;
		_tmp73_ = vala_compiler_directory;
		_tmp74_ = vala_code_context_realpath (_tmp73_);
		_tmp75_ = _tmp74_;
		vala_code_context_set_directory (_tmp72_, _tmp75_);
		_g_free0 (_tmp75_);
	} else {
		ValaCodeContext* _tmp76_;
		ValaCodeContext* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		_tmp76_ = self->priv->context;
		_tmp77_ = self->priv->context;
		_tmp78_ = vala_code_context_get_basedir (_tmp77_);
		_tmp79_ = _tmp78_;
		vala_code_context_set_directory (_tmp76_, _tmp79_);
	}
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_compiler_vapi_directories;
	_tmp81__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp82_ = (_tmp81_ != NULL) ? _vala_array_dup1 (_tmp81_, _tmp81__length1) : ((gpointer) _tmp81_);
	_tmp82__length1 = _tmp81__length1;
	_tmp80_->vapi_directories = (_vala_array_free (_tmp80_->vapi_directories, _tmp80_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp80_->vapi_directories = _tmp82_;
	_tmp80_->vapi_directories_length1 = _tmp82__length1;
	_tmp83_ = self->priv->context;
	_tmp84_ = vala_compiler_gir_directories;
	_tmp84__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp85_ = (_tmp84_ != NULL) ? _vala_array_dup2 (_tmp84_, _tmp84__length1) : ((gpointer) _tmp84_);
	_tmp85__length1 = _tmp84__length1;
	_tmp83_->gir_directories = (_vala_array_free (_tmp83_->gir_directories, _tmp83_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp83_->gir_directories = _tmp85_;
	_tmp83_->gir_directories_length1 = _tmp85__length1;
	_tmp86_ = self->priv->context;
	_tmp87_ = vala_compiler_metadata_directories;
	_tmp87__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp88_ = (_tmp87_ != NULL) ? _vala_array_dup3 (_tmp87_, _tmp87__length1) : ((gpointer) _tmp87_);
	_tmp88__length1 = _tmp87__length1;
	_tmp86_->metadata_directories = (_vala_array_free (_tmp86_->metadata_directories, _tmp86_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp86_->metadata_directories = _tmp88_;
	_tmp86_->metadata_directories_length1 = _tmp88__length1;
	_tmp89_ = self->priv->context;
	_tmp90_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp89_, _tmp90_);
	_tmp91_ = self->priv->context;
	_tmp92_ = vala_compiler_thread;
	vala_code_context_set_thread (_tmp91_, _tmp92_);
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->context;
	_tmp96_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp95_, _tmp96_);
	_tmp97_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp97_, "posix") == 0) {
		ValaCodeContext* _tmp98_;
		ValaCodeContext* _tmp99_;
		_tmp98_ = self->priv->context;
		vala_code_context_set_profile (_tmp98_, VALA_PROFILE_POSIX);
		_tmp99_ = self->priv->context;
		vala_code_context_add_define (_tmp99_, "POSIX");
	} else {
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		const gchar* _tmp102_;
		gboolean _tmp104_;
		gboolean _tmp106_;
		_tmp102_ = vala_compiler_profile;
		if (g_strcmp0 (_tmp102_, "gobject-2.0") == 0) {
			_tmp101_ = TRUE;
		} else {
			const gchar* _tmp103_;
			_tmp103_ = vala_compiler_profile;
			_tmp101_ = g_strcmp0 (_tmp103_, "gobject") == 0;
		}
		_tmp104_ = _tmp101_;
		if (_tmp104_) {
			_tmp100_ = TRUE;
		} else {
			const gchar* _tmp105_;
			_tmp105_ = vala_compiler_profile;
			_tmp100_ = _tmp105_ == NULL;
		}
		_tmp106_ = _tmp100_;
		if (_tmp106_) {
			ValaCodeContext* _tmp107_;
			ValaCodeContext* _tmp108_;
			_tmp107_ = self->priv->context;
			vala_code_context_set_profile (_tmp107_, VALA_PROFILE_GOBJECT);
			_tmp108_ = self->priv->context;
			vala_code_context_add_define (_tmp108_, "GOBJECT");
		} else {
			const gchar* _tmp109_;
			_tmp109_ = vala_compiler_profile;
			if (g_strcmp0 (_tmp109_, "dova") == 0) {
				ValaCodeContext* _tmp110_;
				ValaCodeContext* _tmp111_;
				_tmp110_ = self->priv->context;
				vala_code_context_set_profile (_tmp110_, VALA_PROFILE_DOVA);
				_tmp111_ = self->priv->context;
				vala_code_context_add_define (_tmp111_, "DOVA");
			} else {
				const gchar* _tmp112_;
				gchar* _tmp113_ = NULL;
				gchar* _tmp114_;
				_tmp112_ = vala_compiler_profile;
				_tmp113_ = g_strdup_printf ("Unknown profile %s", _tmp112_);
				_tmp114_ = _tmp113_;
				vala_report_error (NULL, _tmp114_);
				_g_free0 (_tmp114_);
			}
		}
	}
	_tmp115_ = vala_compiler_nostdpkg;
	_tmp116_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp115_ | (_tmp116_ != NULL);
	_tmp117_ = self->priv->context;
	_tmp118_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp117_, _tmp118_);
	_tmp119_ = self->priv->context;
	_tmp120_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp119_, _tmp120_);
	_tmp121_ = self->priv->context;
	_tmp122_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp121_, _tmp122_);
	_tmp123_ = vala_compiler_defines;
	_tmp123__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp123_ != NULL) {
		gchar** _tmp124_;
		gint _tmp124__length1;
		_tmp124_ = vala_compiler_defines;
		_tmp124__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp124_;
			define_collection_length1 = _tmp124__length1;
			for (define_it = 0; define_it < _tmp124__length1; define_it = define_it + 1) {
				gchar* _tmp125_;
				gchar* define = NULL;
				_tmp125_ = g_strdup (define_collection[define_it]);
				define = _tmp125_;
				{
					ValaCodeContext* _tmp126_;
					const gchar* _tmp127_;
					_tmp126_ = self->priv->context;
					_tmp127_ = define;
					vala_code_context_add_define (_tmp126_, _tmp127_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i;
		i = 2;
		{
			gboolean _tmp128_;
			_tmp128_ = TRUE;
			while (TRUE) {
				gboolean _tmp129_;
				gint _tmp131_;
				ValaCodeContext* _tmp132_;
				gint _tmp133_;
				gchar* _tmp134_ = NULL;
				gchar* _tmp135_;
				_tmp129_ = _tmp128_;
				if (!_tmp129_) {
					gint _tmp130_;
					_tmp130_ = i;
					i = _tmp130_ + 2;
				}
				_tmp128_ = FALSE;
				_tmp131_ = i;
				if (!(_tmp131_ <= 18)) {
					break;
				}
				_tmp132_ = self->priv->context;
				_tmp133_ = i;
				_tmp134_ = g_strdup_printf ("VALA_0_%d", _tmp133_);
				_tmp135_ = _tmp134_;
				vala_code_context_add_define (_tmp132_, _tmp135_);
				_g_free0 (_tmp135_);
			}
		}
	}
	_tmp136_ = self->priv->context;
	_tmp137_ = vala_code_context_get_profile (_tmp136_);
	_tmp138_ = _tmp137_;
	if (_tmp138_ == VALA_PROFILE_POSIX) {
		gboolean _tmp139_;
		_tmp139_ = vala_compiler_nostdpkg;
		if (!_tmp139_) {
			ValaCodeContext* _tmp140_;
			_tmp140_ = self->priv->context;
			vala_code_context_add_external_package (_tmp140_, "posix");
		}
	} else {
		ValaCodeContext* _tmp141_;
		ValaProfile _tmp142_;
		ValaProfile _tmp143_;
		_tmp141_ = self->priv->context;
		_tmp142_ = vala_code_context_get_profile (_tmp141_);
		_tmp143_ = _tmp142_;
		if (_tmp143_ == VALA_PROFILE_GOBJECT) {
			gint glib_major;
			gint glib_minor;
			gboolean _tmp144_ = FALSE;
			const gchar* _tmp145_;
			gboolean _tmp148_;
			ValaCodeContext* _tmp149_;
			gint _tmp150_;
			ValaCodeContext* _tmp151_;
			gint _tmp152_;
			ValaCodeContext* _tmp153_;
			gint _tmp154_;
			gint _tmp155_;
			gboolean _tmp165_;
			glib_major = 2;
			glib_minor = 16;
			_tmp145_ = vala_compiler_target_glib;
			if (_tmp145_ != NULL) {
				const gchar* _tmp146_;
				gint _tmp147_ = 0;
				_tmp146_ = vala_compiler_target_glib;
				_tmp147_ = sscanf (_tmp146_, "%d.%d", &glib_major, &glib_minor);
				_tmp144_ = _tmp147_ != 2;
			} else {
				_tmp144_ = FALSE;
			}
			_tmp148_ = _tmp144_;
			if (_tmp148_) {
				vala_report_error (NULL, "Invalid format for --target-glib");
			}
			_tmp149_ = self->priv->context;
			_tmp150_ = glib_major;
			vala_code_context_set_target_glib_major (_tmp149_, _tmp150_);
			_tmp151_ = self->priv->context;
			_tmp152_ = glib_minor;
			vala_code_context_set_target_glib_minor (_tmp151_, _tmp152_);
			_tmp153_ = self->priv->context;
			_tmp154_ = vala_code_context_get_target_glib_major (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_ != 2) {
				vala_report_error (NULL, "This version of valac only supports GLib 2");
			}
			{
				gint i;
				i = 16;
				{
					gboolean _tmp156_;
					_tmp156_ = TRUE;
					while (TRUE) {
						gboolean _tmp157_;
						gint _tmp159_;
						gint _tmp160_;
						ValaCodeContext* _tmp161_;
						gint _tmp162_;
						gchar* _tmp163_ = NULL;
						gchar* _tmp164_;
						_tmp157_ = _tmp156_;
						if (!_tmp157_) {
							gint _tmp158_;
							_tmp158_ = i;
							i = _tmp158_ + 2;
						}
						_tmp156_ = FALSE;
						_tmp159_ = i;
						_tmp160_ = glib_minor;
						if (!(_tmp159_ <= _tmp160_)) {
							break;
						}
						_tmp161_ = self->priv->context;
						_tmp162_ = i;
						_tmp163_ = g_strdup_printf ("GLIB_2_%d", _tmp162_);
						_tmp164_ = _tmp163_;
						vala_code_context_add_define (_tmp161_, _tmp164_);
						_g_free0 (_tmp164_);
					}
				}
			}
			_tmp165_ = vala_compiler_nostdpkg;
			if (!_tmp165_) {
				ValaCodeContext* _tmp166_;
				ValaCodeContext* _tmp167_;
				_tmp166_ = self->priv->context;
				vala_code_context_add_external_package (_tmp166_, "glib-2.0");
				_tmp167_ = self->priv->context;
				vala_code_context_add_external_package (_tmp167_, "gobject-2.0");
			}
		} else {
			ValaCodeContext* _tmp168_;
			ValaProfile _tmp169_;
			ValaProfile _tmp170_;
			_tmp168_ = self->priv->context;
			_tmp169_ = vala_code_context_get_profile (_tmp168_);
			_tmp170_ = _tmp169_;
			if (_tmp170_ == VALA_PROFILE_DOVA) {
				gboolean _tmp171_;
				_tmp171_ = vala_compiler_nostdpkg;
				if (!_tmp171_) {
					ValaCodeContext* _tmp172_;
					_tmp172_ = self->priv->context;
					vala_code_context_add_external_package (_tmp172_, "dova-core-0.1");
				}
			}
		}
	}
	_tmp173_ = vala_compiler_packages;
	_tmp173__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp173_ != NULL) {
		gchar** _tmp174_;
		gint _tmp174__length1;
		_tmp174_ = vala_compiler_packages;
		_tmp174__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp174_;
			package_collection_length1 = _tmp174__length1;
			for (package_it = 0; package_it < _tmp174__length1; package_it = package_it + 1) {
				gchar* _tmp175_;
				gchar* package = NULL;
				_tmp175_ = g_strdup (package_collection[package_it]);
				package = _tmp175_;
				{
					ValaCodeContext* _tmp176_;
					const gchar* _tmp177_;
					_tmp176_ = self->priv->context;
					_tmp177_ = package;
					vala_code_context_add_external_package (_tmp176_, _tmp177_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp178_ = vala_compiler_fast_vapis;
	_tmp178__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp178_ != NULL) {
		gchar** _tmp179_;
		gint _tmp179__length1;
		_tmp179_ = vala_compiler_fast_vapis;
		_tmp179__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp179_;
			vapi_collection_length1 = _tmp179__length1;
			for (vapi_it = 0; vapi_it < _tmp179__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp180_;
				gchar* vapi = NULL;
				_tmp180_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp180_;
				{
					const gchar* _tmp181_;
					gchar* _tmp182_ = NULL;
					gchar* rpath;
					ValaCodeContext* _tmp183_;
					const gchar* _tmp184_;
					ValaSourceFile* _tmp185_;
					ValaSourceFile* source_file;
					ValaCodeContext* _tmp186_;
					ValaSourceFile* _tmp187_;
					_tmp181_ = vapi;
					_tmp182_ = vala_code_context_realpath (_tmp181_);
					rpath = _tmp182_;
					_tmp183_ = self->priv->context;
					_tmp184_ = rpath;
					_tmp185_ = vala_source_file_new (_tmp183_, VALA_SOURCE_FILE_TYPE_FAST, _tmp184_, NULL, FALSE);
					source_file = _tmp185_;
					_tmp186_ = self->priv->context;
					_tmp187_ = source_file;
					vala_code_context_add_source_file (_tmp186_, _tmp187_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
	}
	_tmp189_ = self->priv->context;
	_tmp190_ = vala_code_context_get_report (_tmp189_);
	_tmp191_ = _tmp190_;
	_tmp192_ = vala_report_get_errors (_tmp191_);
	if (_tmp192_ > 0) {
		_tmp188_ = TRUE;
	} else {
		gboolean _tmp193_ = FALSE;
		gboolean _tmp194_;
		gboolean _tmp199_;
		_tmp194_ = vala_compiler_fatal_warnings;
		if (_tmp194_) {
			ValaCodeContext* _tmp195_;
			ValaReport* _tmp196_;
			ValaReport* _tmp197_;
			gint _tmp198_ = 0;
			_tmp195_ = self->priv->context;
			_tmp196_ = vala_code_context_get_report (_tmp195_);
			_tmp197_ = _tmp196_;
			_tmp198_ = vala_report_get_warnings (_tmp197_);
			_tmp193_ = _tmp198_ > 0;
		} else {
			_tmp193_ = FALSE;
		}
		_tmp199_ = _tmp193_;
		_tmp188_ = _tmp199_;
	}
	_tmp200_ = _tmp188_;
	if (_tmp200_) {
		gint _tmp201_ = 0;
		_tmp201_ = vala_compiler_quit (self);
		result = _tmp201_;
		return result;
	}
	_tmp202_ = self->priv->context;
	_tmp203_ = vala_code_context_get_profile (_tmp202_);
	_tmp204_ = _tmp203_;
	if (_tmp204_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp205_;
		ValaGDBusServerModule* _tmp206_;
		ValaGDBusServerModule* _tmp207_;
		_tmp205_ = self->priv->context;
		_tmp206_ = vala_gd_bus_server_module_new ();
		_tmp207_ = _tmp206_;
		vala_code_context_set_codegen (_tmp205_, (ValaCodeGenerator*) _tmp207_);
		_vala_code_visitor_unref0 (_tmp207_);
	} else {
		ValaCodeContext* _tmp208_;
		ValaProfile _tmp209_;
		ValaProfile _tmp210_;
		_tmp208_ = self->priv->context;
		_tmp209_ = vala_code_context_get_profile (_tmp208_);
		_tmp210_ = _tmp209_;
		if (_tmp210_ == VALA_PROFILE_DOVA) {
			ValaCodeContext* _tmp211_;
			ValaDovaErrorModule* _tmp212_;
			ValaDovaErrorModule* _tmp213_;
			_tmp211_ = self->priv->context;
			_tmp212_ = vala_dova_error_module_new ();
			_tmp213_ = _tmp212_;
			vala_code_context_set_codegen (_tmp211_, (ValaCodeGenerator*) _tmp213_);
			_vala_code_visitor_unref0 (_tmp213_);
		} else {
			ValaCodeContext* _tmp214_;
			ValaCCodeDelegateModule* _tmp215_;
			ValaCCodeDelegateModule* _tmp216_;
			_tmp214_ = self->priv->context;
			_tmp215_ = vala_ccode_delegate_module_new ();
			_tmp216_ = _tmp215_;
			vala_code_context_set_codegen (_tmp214_, (ValaCodeGenerator*) _tmp216_);
			_vala_code_visitor_unref0 (_tmp216_);
		}
	}
	has_c_files = FALSE;
	_tmp217_ = vala_compiler_sources;
	_tmp217__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp217_;
		source_collection_length1 = _tmp217__length1;
		for (source_it = 0; source_it < _tmp217__length1; source_it = source_it + 1) {
			gchar* _tmp218_;
			gchar* source = NULL;
			_tmp218_ = g_strdup (source_collection[source_it]);
			source = _tmp218_;
			{
				ValaCodeContext* _tmp219_;
				const gchar* _tmp220_;
				gboolean _tmp221_;
				gboolean _tmp222_ = FALSE;
				_tmp219_ = self->priv->context;
				_tmp220_ = source;
				_tmp221_ = vala_compiler_run_output;
				_tmp222_ = vala_code_context_add_source_filename (_tmp219_, _tmp220_, _tmp221_, TRUE);
				if (_tmp222_) {
					const gchar* _tmp223_;
					gboolean _tmp224_ = FALSE;
					_tmp223_ = source;
					_tmp224_ = g_str_has_suffix (_tmp223_, ".c");
					if (_tmp224_) {
						has_c_files = TRUE;
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp226_ = self->priv->context;
	_tmp227_ = vala_code_context_get_report (_tmp226_);
	_tmp228_ = _tmp227_;
	_tmp229_ = vala_report_get_errors (_tmp228_);
	if (_tmp229_ > 0) {
		_tmp225_ = TRUE;
	} else {
		gboolean _tmp230_ = FALSE;
		gboolean _tmp231_;
		gboolean _tmp236_;
		_tmp231_ = vala_compiler_fatal_warnings;
		if (_tmp231_) {
			ValaCodeContext* _tmp232_;
			ValaReport* _tmp233_;
			ValaReport* _tmp234_;
			gint _tmp235_ = 0;
			_tmp232_ = self->priv->context;
			_tmp233_ = vala_code_context_get_report (_tmp232_);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_report_get_warnings (_tmp234_);
			_tmp230_ = _tmp235_ > 0;
		} else {
			_tmp230_ = FALSE;
		}
		_tmp236_ = _tmp230_;
		_tmp225_ = _tmp236_;
	}
	_tmp237_ = _tmp225_;
	if (_tmp237_) {
		gint _tmp238_ = 0;
		_tmp238_ = vala_compiler_quit (self);
		result = _tmp238_;
		return result;
	}
	_tmp239_ = vala_parser_new ();
	parser = _tmp239_;
	_tmp240_ = parser;
	_tmp241_ = self->priv->context;
	vala_parser_parse (_tmp240_, _tmp241_);
	_tmp242_ = vala_genie_parser_new ();
	genie_parser = _tmp242_;
	_tmp243_ = genie_parser;
	_tmp244_ = self->priv->context;
	vala_genie_parser_parse (_tmp243_, _tmp244_);
	_tmp245_ = vala_gir_parser_new ();
	gir_parser = _tmp245_;
	_tmp246_ = gir_parser;
	_tmp247_ = self->priv->context;
	vala_gir_parser_parse (_tmp246_, _tmp247_);
	_tmp249_ = self->priv->context;
	_tmp250_ = vala_code_context_get_report (_tmp249_);
	_tmp251_ = _tmp250_;
	_tmp252_ = vala_report_get_errors (_tmp251_);
	if (_tmp252_ > 0) {
		_tmp248_ = TRUE;
	} else {
		gboolean _tmp253_ = FALSE;
		gboolean _tmp254_;
		gboolean _tmp259_;
		_tmp254_ = vala_compiler_fatal_warnings;
		if (_tmp254_) {
			ValaCodeContext* _tmp255_;
			ValaReport* _tmp256_;
			ValaReport* _tmp257_;
			gint _tmp258_ = 0;
			_tmp255_ = self->priv->context;
			_tmp256_ = vala_code_context_get_report (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_report_get_warnings (_tmp257_);
			_tmp253_ = _tmp258_ > 0;
		} else {
			_tmp253_ = FALSE;
		}
		_tmp259_ = _tmp253_;
		_tmp248_ = _tmp259_;
	}
	_tmp260_ = _tmp248_;
	if (_tmp260_) {
		gint _tmp261_ = 0;
		_tmp261_ = vala_compiler_quit (self);
		result = _tmp261_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp262_ = vala_compiler_fast_vapi_filename;
	if (_tmp262_ != NULL) {
		ValaCodeWriter* _tmp263_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp264_;
		ValaCodeContext* _tmp265_;
		const gchar* _tmp266_;
		gint _tmp267_ = 0;
		_tmp263_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp263_;
		_tmp264_ = interface_writer;
		_tmp265_ = self->priv->context;
		_tmp266_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp264_, _tmp265_, _tmp266_);
		_tmp267_ = vala_compiler_quit (self);
		result = _tmp267_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp268_ = self->priv->context;
	vala_code_context_check (_tmp268_);
	_tmp270_ = self->priv->context;
	_tmp271_ = vala_code_context_get_report (_tmp270_);
	_tmp272_ = _tmp271_;
	_tmp273_ = vala_report_get_errors (_tmp272_);
	if (_tmp273_ > 0) {
		_tmp269_ = TRUE;
	} else {
		gboolean _tmp274_ = FALSE;
		gboolean _tmp275_;
		gboolean _tmp280_;
		_tmp275_ = vala_compiler_fatal_warnings;
		if (_tmp275_) {
			ValaCodeContext* _tmp276_;
			ValaReport* _tmp277_;
			ValaReport* _tmp278_;
			gint _tmp279_ = 0;
			_tmp276_ = self->priv->context;
			_tmp277_ = vala_code_context_get_report (_tmp276_);
			_tmp278_ = _tmp277_;
			_tmp279_ = vala_report_get_warnings (_tmp278_);
			_tmp274_ = _tmp279_ > 0;
		} else {
			_tmp274_ = FALSE;
		}
		_tmp280_ = _tmp274_;
		_tmp269_ = _tmp280_;
	}
	_tmp281_ = _tmp269_;
	if (_tmp281_) {
		gint _tmp282_ = 0;
		_tmp282_ = vala_compiler_quit (self);
		result = _tmp282_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp285_ = vala_compiler_ccode_only;
	if (!_tmp285_) {
		gboolean _tmp286_;
		_tmp286_ = vala_compiler_compile_only;
		_tmp284_ = !_tmp286_;
	} else {
		_tmp284_ = FALSE;
	}
	_tmp287_ = _tmp284_;
	if (_tmp287_) {
		const gchar* _tmp288_;
		_tmp288_ = vala_compiler_library;
		_tmp283_ = _tmp288_ == NULL;
	} else {
		_tmp283_ = FALSE;
	}
	_tmp289_ = _tmp283_;
	if (_tmp289_) {
		gboolean _tmp290_ = FALSE;
		gboolean _tmp291_;
		gboolean _tmp295_;
		_tmp291_ = has_c_files;
		if (!_tmp291_) {
			ValaCodeContext* _tmp292_;
			ValaMethod* _tmp293_;
			ValaMethod* _tmp294_;
			_tmp292_ = self->priv->context;
			_tmp293_ = vala_code_context_get_entry_point (_tmp292_);
			_tmp294_ = _tmp293_;
			_tmp290_ = _tmp294_ == NULL;
		} else {
			_tmp290_ = FALSE;
		}
		_tmp295_ = _tmp290_;
		if (_tmp295_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp296_ = vala_compiler_dump_tree;
	if (_tmp296_ != NULL) {
		ValaCodeWriter* _tmp297_;
		ValaCodeWriter* code_writer;
		ValaCodeWriter* _tmp298_;
		ValaCodeContext* _tmp299_;
		const gchar* _tmp300_;
		_tmp297_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp297_;
		_tmp298_ = code_writer;
		_tmp299_ = self->priv->context;
		_tmp300_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp298_, _tmp299_, _tmp300_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp302_ = self->priv->context;
	_tmp303_ = vala_code_context_get_report (_tmp302_);
	_tmp304_ = _tmp303_;
	_tmp305_ = vala_report_get_errors (_tmp304_);
	if (_tmp305_ > 0) {
		_tmp301_ = TRUE;
	} else {
		gboolean _tmp306_ = FALSE;
		gboolean _tmp307_;
		gboolean _tmp312_;
		_tmp307_ = vala_compiler_fatal_warnings;
		if (_tmp307_) {
			ValaCodeContext* _tmp308_;
			ValaReport* _tmp309_;
			ValaReport* _tmp310_;
			gint _tmp311_ = 0;
			_tmp308_ = self->priv->context;
			_tmp309_ = vala_code_context_get_report (_tmp308_);
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_report_get_warnings (_tmp310_);
			_tmp306_ = _tmp311_ > 0;
		} else {
			_tmp306_ = FALSE;
		}
		_tmp312_ = _tmp306_;
		_tmp301_ = _tmp312_;
	}
	_tmp313_ = _tmp301_;
	if (_tmp313_) {
		gint _tmp314_ = 0;
		_tmp314_ = vala_compiler_quit (self);
		result = _tmp314_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp315_ = self->priv->context;
	_tmp316_ = vala_code_context_get_codegen (_tmp315_);
	_tmp317_ = _tmp316_;
	_tmp318_ = self->priv->context;
	vala_code_generator_emit (_tmp317_, _tmp318_);
	_tmp320_ = self->priv->context;
	_tmp321_ = vala_code_context_get_report (_tmp320_);
	_tmp322_ = _tmp321_;
	_tmp323_ = vala_report_get_errors (_tmp322_);
	if (_tmp323_ > 0) {
		_tmp319_ = TRUE;
	} else {
		gboolean _tmp324_ = FALSE;
		gboolean _tmp325_;
		gboolean _tmp330_;
		_tmp325_ = vala_compiler_fatal_warnings;
		if (_tmp325_) {
			ValaCodeContext* _tmp326_;
			ValaReport* _tmp327_;
			ValaReport* _tmp328_;
			gint _tmp329_ = 0;
			_tmp326_ = self->priv->context;
			_tmp327_ = vala_code_context_get_report (_tmp326_);
			_tmp328_ = _tmp327_;
			_tmp329_ = vala_report_get_warnings (_tmp328_);
			_tmp324_ = _tmp329_ > 0;
		} else {
			_tmp324_ = FALSE;
		}
		_tmp330_ = _tmp324_;
		_tmp319_ = _tmp330_;
	}
	_tmp331_ = _tmp319_;
	if (_tmp331_) {
		gint _tmp332_ = 0;
		_tmp332_ = vala_compiler_quit (self);
		result = _tmp332_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp334_ = vala_compiler_vapi_filename;
	if (_tmp334_ == NULL) {
		const gchar* _tmp335_;
		_tmp335_ = vala_compiler_library;
		_tmp333_ = _tmp335_ != NULL;
	} else {
		_tmp333_ = FALSE;
	}
	_tmp336_ = _tmp333_;
	if (_tmp336_) {
		const gchar* _tmp337_;
		gchar* _tmp338_ = NULL;
		_tmp337_ = vala_compiler_library;
		_tmp338_ = g_strdup_printf ("%s.vapi", _tmp337_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp338_;
	}
	_tmp339_ = vala_compiler_library;
	if (_tmp339_ != NULL) {
		const gchar* _tmp340_;
		_tmp340_ = vala_compiler_gir;
		if (_tmp340_ != NULL) {
			ValaCodeContext* _tmp341_;
			ValaProfile _tmp342_;
			ValaProfile _tmp343_;
			_tmp341_ = self->priv->context;
			_tmp342_ = vala_code_context_get_profile (_tmp341_);
			_tmp343_ = _tmp342_;
			if (_tmp343_ == VALA_PROFILE_GOBJECT) {
				const gchar* _tmp344_;
				gint _tmp345_;
				gint _tmp346_;
				glong gir_len;
				const gchar* _tmp347_;
				gint _tmp348_ = 0;
				gint last_hyphen;
				gboolean _tmp349_ = FALSE;
				gint _tmp350_;
				gboolean _tmp353_;
				_tmp344_ = vala_compiler_gir;
				_tmp345_ = strlen (_tmp344_);
				_tmp346_ = _tmp345_;
				gir_len = (glong) _tmp346_;
				_tmp347_ = vala_compiler_gir;
				_tmp348_ = string_last_index_of_char (_tmp347_, (gunichar) '-', 0);
				last_hyphen = _tmp348_;
				_tmp350_ = last_hyphen;
				if (_tmp350_ == (-1)) {
					_tmp349_ = TRUE;
				} else {
					const gchar* _tmp351_;
					gboolean _tmp352_ = FALSE;
					_tmp351_ = vala_compiler_gir;
					_tmp352_ = g_str_has_suffix (_tmp351_, ".gir");
					_tmp349_ = !_tmp352_;
				}
				_tmp353_ = _tmp349_;
				if (_tmp353_) {
					const gchar* _tmp354_;
					gchar* _tmp355_ = NULL;
					gchar* _tmp356_;
					_tmp354_ = vala_compiler_gir;
					_tmp355_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp354_);
					_tmp356_ = _tmp355_;
					vala_report_error (NULL, _tmp356_);
					_g_free0 (_tmp356_);
				} else {
					const gchar* _tmp357_;
					gint _tmp358_;
					gchar* _tmp359_ = NULL;
					gchar* gir_namespace;
					const gchar* _tmp360_;
					gint _tmp361_;
					glong _tmp362_;
					gint _tmp363_;
					gchar* _tmp364_ = NULL;
					gchar* gir_version;
					const gchar* _tmp365_;
					gboolean _tmp366_ = FALSE;
					gboolean _tmp367_ = FALSE;
					gboolean _tmp368_ = FALSE;
					const gchar* _tmp369_;
					gboolean _tmp371_;
					gboolean _tmp375_;
					gboolean _tmp378_;
					_tmp357_ = vala_compiler_gir;
					_tmp358_ = last_hyphen;
					_tmp359_ = string_substring (_tmp357_, (glong) 0, (glong) _tmp358_);
					gir_namespace = _tmp359_;
					_tmp360_ = vala_compiler_gir;
					_tmp361_ = last_hyphen;
					_tmp362_ = gir_len;
					_tmp363_ = last_hyphen;
					_tmp364_ = string_substring (_tmp360_, (glong) (_tmp361_ + 1), (_tmp362_ - _tmp363_) - 5);
					gir_version = _tmp364_;
					_tmp365_ = gir_version;
					g_strcanon (_tmp365_, "0123456789.", '?');
					_tmp369_ = gir_namespace;
					if (g_strcmp0 (_tmp369_, "") == 0) {
						_tmp368_ = TRUE;
					} else {
						const gchar* _tmp370_;
						_tmp370_ = gir_version;
						_tmp368_ = g_strcmp0 (_tmp370_, "") == 0;
					}
					_tmp371_ = _tmp368_;
					if (_tmp371_) {
						_tmp367_ = TRUE;
					} else {
						const gchar* _tmp372_;
						gchar _tmp373_ = '\0';
						gboolean _tmp374_ = FALSE;
						_tmp372_ = gir_version;
						_tmp373_ = string_get (_tmp372_, (glong) 0);
						_tmp374_ = g_ascii_isdigit (_tmp373_);
						_tmp367_ = !_tmp374_;
					}
					_tmp375_ = _tmp367_;
					if (_tmp375_) {
						_tmp366_ = TRUE;
					} else {
						const gchar* _tmp376_;
						gboolean _tmp377_ = FALSE;
						_tmp376_ = gir_version;
						_tmp377_ = string_contains (_tmp376_, "?");
						_tmp366_ = _tmp377_;
					}
					_tmp378_ = _tmp366_;
					if (_tmp378_) {
						const gchar* _tmp379_;
						gchar* _tmp380_ = NULL;
						gchar* _tmp381_;
						_tmp379_ = vala_compiler_gir;
						_tmp380_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp379_);
						_tmp381_ = _tmp380_;
						vala_report_error (NULL, _tmp381_);
						_g_free0 (_tmp381_);
					} else {
						ValaGIRWriter* _tmp382_;
						ValaGIRWriter* gir_writer;
						gchar* _tmp383_;
						gchar* gir_directory;
						const gchar* _tmp384_;
						ValaGIRWriter* _tmp389_;
						ValaCodeContext* _tmp390_;
						const gchar* _tmp391_;
						const gchar* _tmp392_;
						const gchar* _tmp393_;
						const gchar* _tmp394_;
						_tmp382_ = vala_gir_writer_new ();
						gir_writer = _tmp382_;
						_tmp383_ = g_strdup (".");
						gir_directory = _tmp383_;
						_tmp384_ = vala_compiler_directory;
						if (_tmp384_ != NULL) {
							ValaCodeContext* _tmp385_;
							const gchar* _tmp386_;
							const gchar* _tmp387_;
							gchar* _tmp388_;
							_tmp385_ = self->priv->context;
							_tmp386_ = vala_code_context_get_directory (_tmp385_);
							_tmp387_ = _tmp386_;
							_tmp388_ = g_strdup (_tmp387_);
							_g_free0 (gir_directory);
							gir_directory = _tmp388_;
						}
						_tmp389_ = gir_writer;
						_tmp390_ = self->priv->context;
						_tmp391_ = gir_directory;
						_tmp392_ = gir_namespace;
						_tmp393_ = gir_version;
						_tmp394_ = vala_compiler_library;
						vala_gir_writer_write_file (_tmp389_, _tmp390_, _tmp391_, _tmp392_, _tmp393_, _tmp394_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp395_ = vala_compiler_vapi_filename;
	if (_tmp395_ != NULL) {
		ValaCodeWriter* _tmp396_;
		ValaCodeWriter* interface_writer;
		gboolean _tmp397_ = FALSE;
		const gchar* _tmp398_;
		gboolean _tmp401_;
		ValaCodeWriter* _tmp407_;
		ValaCodeContext* _tmp408_;
		const gchar* _tmp409_;
		_tmp396_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp396_;
		_tmp398_ = vala_compiler_directory;
		if (_tmp398_ != NULL) {
			const gchar* _tmp399_;
			gboolean _tmp400_ = FALSE;
			_tmp399_ = vala_compiler_vapi_filename;
			_tmp400_ = g_path_is_absolute (_tmp399_);
			_tmp397_ = !_tmp400_;
		} else {
			_tmp397_ = FALSE;
		}
		_tmp401_ = _tmp397_;
		if (_tmp401_) {
			ValaCodeContext* _tmp402_;
			const gchar* _tmp403_;
			const gchar* _tmp404_;
			const gchar* _tmp405_;
			gchar* _tmp406_ = NULL;
			_tmp402_ = self->priv->context;
			_tmp403_ = vala_code_context_get_directory (_tmp402_);
			_tmp404_ = _tmp403_;
			_tmp405_ = vala_compiler_vapi_filename;
			_tmp406_ = g_strdup_printf ("%s%c%s", _tmp404_, (gint) G_DIR_SEPARATOR, _tmp405_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp406_;
		}
		_tmp407_ = interface_writer;
		_tmp408_ = self->priv->context;
		_tmp409_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp407_, _tmp408_, _tmp409_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp410_ = vala_compiler_internal_vapi_filename;
	if (_tmp410_ != NULL) {
		gboolean _tmp411_ = FALSE;
		const gchar* _tmp412_;
		gboolean _tmp414_;
		ValaCodeWriter* _tmp416_;
		ValaCodeWriter* interface_writer;
		ValaCodeWriter* _tmp417_;
		const gchar* _tmp418_;
		const gchar* _tmp419_;
		const gchar* _tmp420_;
		gchar* _tmp421_;
		gchar* vapi_filename;
		gboolean _tmp422_ = FALSE;
		const gchar* _tmp423_;
		gboolean _tmp426_;
		ValaCodeWriter* _tmp432_;
		ValaCodeContext* _tmp433_;
		const gchar* _tmp434_;
		_tmp412_ = vala_compiler_internal_header_filename;
		if (_tmp412_ == NULL) {
			_tmp411_ = TRUE;
		} else {
			const gchar* _tmp413_;
			_tmp413_ = vala_compiler_header_filename;
			_tmp411_ = _tmp413_ == NULL;
		}
		_tmp414_ = _tmp411_;
		if (_tmp414_) {
			gint _tmp415_ = 0;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp415_ = vala_compiler_quit (self);
			result = _tmp415_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp416_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp416_;
		_tmp417_ = interface_writer;
		_tmp418_ = vala_compiler_header_filename;
		_tmp419_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp417_, _tmp418_, _tmp419_);
		_tmp420_ = vala_compiler_internal_vapi_filename;
		_tmp421_ = g_strdup (_tmp420_);
		vapi_filename = _tmp421_;
		_tmp423_ = vala_compiler_directory;
		if (_tmp423_ != NULL) {
			const gchar* _tmp424_;
			gboolean _tmp425_ = FALSE;
			_tmp424_ = vapi_filename;
			_tmp425_ = g_path_is_absolute (_tmp424_);
			_tmp422_ = !_tmp425_;
		} else {
			_tmp422_ = FALSE;
		}
		_tmp426_ = _tmp422_;
		if (_tmp426_) {
			ValaCodeContext* _tmp427_;
			const gchar* _tmp428_;
			const gchar* _tmp429_;
			const gchar* _tmp430_;
			gchar* _tmp431_ = NULL;
			_tmp427_ = self->priv->context;
			_tmp428_ = vala_code_context_get_directory (_tmp427_);
			_tmp429_ = _tmp428_;
			_tmp430_ = vapi_filename;
			_tmp431_ = g_strdup_printf ("%s%c%s", _tmp429_, (gint) G_DIR_SEPARATOR, _tmp430_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp431_;
		}
		_tmp432_ = interface_writer;
		_tmp433_ = self->priv->context;
		_tmp434_ = vapi_filename;
		vala_code_writer_write_file (_tmp432_, _tmp433_, _tmp434_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp435_ = vala_compiler_dependencies;
	if (_tmp435_ != NULL) {
		ValaCodeContext* _tmp436_;
		const gchar* _tmp437_;
		_tmp436_ = self->priv->context;
		_tmp437_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp436_, _tmp437_);
	}
	_tmp438_ = vala_compiler_ccode_only;
	if (!_tmp438_) {
		ValaCCodeCompiler* _tmp439_;
		ValaCCodeCompiler* ccompiler;
		gboolean _tmp440_ = FALSE;
		const gchar* _tmp441_;
		gboolean _tmp443_;
		gchar** _tmp446_;
		gint _tmp446__length1;
		_tmp439_ = vala_ccode_compiler_new ();
		ccompiler = _tmp439_;
		_tmp441_ = vala_compiler_cc_command;
		if (_tmp441_ == NULL) {
			const gchar* _tmp442_ = NULL;
			_tmp442_ = g_getenv ("CC");
			_tmp440_ = _tmp442_ != NULL;
		} else {
			_tmp440_ = FALSE;
		}
		_tmp443_ = _tmp440_;
		if (_tmp443_) {
			const gchar* _tmp444_ = NULL;
			gchar* _tmp445_;
			_tmp444_ = g_getenv ("CC");
			_tmp445_ = g_strdup (_tmp444_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp445_;
		}
		_tmp446_ = vala_compiler_cc_options;
		_tmp446__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp446_ == NULL) {
			ValaCCodeCompiler* _tmp447_;
			ValaCodeContext* _tmp448_;
			const gchar* _tmp449_;
			gchar** _tmp450_ = NULL;
			gchar** _tmp451_;
			gint _tmp451__length1;
			_tmp447_ = ccompiler;
			_tmp448_ = self->priv->context;
			_tmp449_ = vala_compiler_cc_command;
			_tmp450_ = g_new0 (gchar*, 0 + 1);
			_tmp451_ = _tmp450_;
			_tmp451__length1 = 0;
			vala_ccode_compiler_compile (_tmp447_, _tmp448_, _tmp449_, _tmp451_, 0);
			_tmp451_ = (_vala_array_free (_tmp451_, _tmp451__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp452_;
			ValaCodeContext* _tmp453_;
			const gchar* _tmp454_;
			gchar** _tmp455_;
			gint _tmp455__length1;
			_tmp452_ = ccompiler;
			_tmp453_ = self->priv->context;
			_tmp454_ = vala_compiler_cc_command;
			_tmp455_ = vala_compiler_cc_options;
			_tmp455__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp452_, _tmp453_, _tmp454_, _tmp455_, _tmp455__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp456_ = vala_compiler_quit (self);
	result = _tmp456_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda2_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda2__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda2_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp8_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	const gchar* _tmp32_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_ = NULL;
	const gchar* _tmp46_;
	gint _tmp47_ = 0;
	gint outputfd;
	gint _tmp48_;
	ValaCompiler* _tmp49_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp50_;
	gint _tmp51_ = 0;
	gint ret;
	gint _tmp52_;
	gint _tmp53_;
	const gchar* _tmp54_;
	gint _tmp55_ = 0;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_ = NULL;
	gchar** target_args;
	gint target_args_length1;
	gint _target_args_size_;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp8_ = _tmp0_;
	if (_tmp8_) {
		gint _tmp29_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GOptionContext* _tmp15_;
			GOptionContext* opt_context;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gchar** temp_args;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = g_strconcat ("valac ", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			g_shell_parse_argv (_tmp12_, &_tmp14_, &_tmp13_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp13_;
			compile_args_length1 = _tmp14_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp12_);
			if (_inner_error_ != NULL) {
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp20_ = stdout;
			_tmp21_ = e;
			_tmp22_ = _tmp21_->message;
			fprintf (_tmp20_, "%s\n", _tmp22_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp23_;
			GError* _tmp24_;
			const gchar* _tmp25_;
			FILE* _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = stdout;
			_tmp24_ = e;
			_tmp25_ = _tmp24_->message;
			fprintf (_tmp23_, "%s\n", _tmp25_);
			_tmp26_ = stdout;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = _tmp27_[0];
			fprintf (_tmp26_, "Run '%s --help' to see a full list of available command line options.\n", _tmp28_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp29_ = i;
		i = _tmp29_ + 1;
	}
	_tmp30_ = args;
	_tmp30__length1 = args_length1;
	_tmp31_ = i;
	_tmp32_ = _tmp30_[_tmp31_];
	if (_tmp32_ == NULL) {
		FILE* _tmp33_;
		_tmp33_ = stderr;
		fprintf (_tmp33_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp34_ = args;
	_tmp34__length1 = args_length1;
	_tmp35_ = i;
	_tmp36_ = _tmp34_[_tmp35_];
	_tmp37_ = g_strdup (_tmp36_);
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp38_;
	_tmp39_ = g_get_tmp_dir ();
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_path_get_basename (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp39_, _tmp44_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp45_;
	_g_free0 (_tmp44_);
	_tmp46_ = vala_compiler_output;
	_tmp47_ = g_mkstemp (_tmp46_);
	outputfd = _tmp47_;
	_tmp48_ = outputfd;
	if (_tmp48_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp49_ = vala_compiler_new ();
	compiler = _tmp49_;
	_tmp50_ = compiler;
	_tmp51_ = vala_compiler_run (_tmp50_);
	ret = _tmp51_;
	_tmp52_ = ret;
	if (_tmp52_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp53_ = outputfd;
	close (_tmp53_);
	_tmp54_ = vala_compiler_output;
	_tmp55_ = g_chmod (_tmp54_, 0700);
	if (_tmp55_ != 0) {
		const gchar* _tmp56_;
		_tmp56_ = vala_compiler_output;
		g_unlink (_tmp56_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp57_ = vala_compiler_output;
	_tmp58_ = g_strdup (_tmp57_);
	_tmp59_ = g_new0 (gchar*, 1 + 1);
	_tmp59_[0] = _tmp58_;
	target_args = _tmp59_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp60_;
		gchar** _tmp61_;
		gint _tmp61__length1;
		gchar** _tmp62_;
		gint _tmp62__length1;
		gchar** _tmp63_;
		gint _tmp63__length1;
		gint _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gint _tmp67_;
		_tmp60_ = i;
		_tmp61_ = args;
		_tmp61__length1 = args_length1;
		if (!(_tmp60_ < _tmp61__length1)) {
			break;
		}
		_tmp62_ = target_args;
		_tmp62__length1 = target_args_length1;
		_tmp63_ = args;
		_tmp63__length1 = args_length1;
		_tmp64_ = i;
		_tmp65_ = _tmp63_[_tmp64_];
		_tmp66_ = g_strdup (_tmp65_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp66_);
		_tmp67_ = i;
		i = _tmp67_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp68_;
		gchar** _tmp69_;
		gint _tmp69__length1;
		GPid _tmp70_ = 0;
		const gchar* _tmp71_;
		GPid _tmp72_;
		GMainLoop* _tmp73_;
		gint _tmp74_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp68_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp68_;
		_data1_->child_status = 0;
		_tmp69_ = target_args;
		_tmp69__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp69_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp70_, &_inner_error_);
		pid = _tmp70_;
		if (_inner_error_ != NULL) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp71_ = vala_compiler_output;
		g_unlink (_tmp71_);
		_tmp72_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp72_, ____lambda2__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp73_ = _data1_->loop;
		g_main_loop_run (_tmp73_);
		_tmp74_ = _data1_->child_status;
		result = _tmp74_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp75_;
		GError* _tmp76_;
		const gchar* _tmp77_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp75_ = stdout;
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		fprintf (_tmp75_, "%s\n", _tmp77_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp23_;
	gboolean _tmp25_ = FALSE;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gboolean _tmp28_;
	ValaCompiler* _tmp30_;
	ValaCompiler* compiler;
	ValaCompiler* _tmp31_;
	gint _tmp32_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	_tmp10_ = _tmp0_;
	if (_tmp10_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_ = 0;
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		_tmp12_ = vala_compiler_run_source (_tmp11_, _tmp11__length1);
		result = _tmp12_;
		return result;
	}
	{
		GOptionContext* _tmp13_;
		GOptionContext* opt_context;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		GOptionContext* _tmp16_;
		_tmp13_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp13_;
		_tmp14_ = opt_context;
		g_option_context_set_help_enabled (_tmp14_, TRUE);
		_tmp15_ = opt_context;
		g_option_context_add_main_entries (_tmp15_, VALA_COMPILER_options, NULL);
		_tmp16_ = opt_context;
		g_option_context_parse (_tmp16_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp23_ = vala_compiler_version;
	if (_tmp23_) {
		FILE* _tmp24_;
		_tmp24_ = stdout;
		fprintf (_tmp24_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp26_ = vala_compiler_sources;
	_tmp26__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp26_ == NULL) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = vala_compiler_fast_vapis;
		_tmp27__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp25_ = _tmp27_ == NULL;
	} else {
		_tmp25_ = FALSE;
	}
	_tmp28_ = _tmp25_;
	if (_tmp28_) {
		FILE* _tmp29_;
		_tmp29_ = stderr;
		fprintf (_tmp29_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp30_ = vala_compiler_new ();
	compiler = _tmp30_;
	_tmp31_ = compiler;
	_tmp32_ = vala_compiler_run (_tmp31_);
	result = _tmp32_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_compiler_main (argv, argc);
}


ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	VALA_COMPILER_CLASS (klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler* obj) {
	ValaCompiler * self;
	self = VALA_COMPILER (obj);
	_vala_code_context_unref0 (self->priv->context);
}


GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_compiler_unref (gpointer instance) {
	ValaCompiler* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



