/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp417_ = FALSE;
	ValaMethod* _tmp418_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp584_;
	ValaCCodeExpression* _tmp585_;
	gboolean _tmp586_ = FALSE;
	ValaMethod* _tmp587_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp615_ = FALSE;
	ValaMethod* _tmp616_;
	gboolean _tmp779_ = FALSE;
	ValaMethod* _tmp780_;
	ValaMethod* _tmp834_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp1028_;
	ValaIterator* _tmp1029_;
	ValaIterator* _tmp1450_;
	gboolean _tmp1460_ = FALSE;
	gboolean _tmp1461_ = FALSE;
	ValaMethod* _tmp1462_;
	gboolean _tmp1583_ = FALSE;
	ValaDelegate* _tmp1584_;
	gboolean _tmp1680_ = FALSE;
	ValaMethod* _tmp1681_;
	gboolean _tmp1697_;
	gboolean _tmp1698_;
	gboolean _tmp1741_ = FALSE;
	ValaDelegate* _tmp1742_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1760_;
	ValaDataType* _tmp1761_;
	gboolean _tmp1762_ = FALSE;
	ValaDataType* _tmp1763_;
	ValaCCodeFunctionCall* _tmp1791_;
	ValaCCodeFunctionCall* _tmp1792_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1805_;
	ValaCCodeFunctionCall* _tmp1806_;
	ValaCCodeFunctionCall* _tmp1821_;
	gboolean _tmp1836_;
	gboolean _tmp1837_;
	gboolean _tmp1861_;
	gboolean _tmp1862_;
	gboolean _tmp1897_ = FALSE;
	gboolean _tmp1898_ = FALSE;
	ValaMethod* _tmp1899_;
	gboolean _tmp1937_ = FALSE;
	gboolean _tmp1938_ = FALSE;
	gboolean _tmp1939_ = FALSE;
	gboolean _tmp1940_ = FALSE;
	gboolean _tmp1941_ = FALSE;
	ValaMethod* _tmp1942_;
	gboolean _tmp1959_ = FALSE;
	gboolean _tmp1960_ = FALSE;
	ValaMethod* _tmp1961_;
	ValaMethod* _tmp1980_;
	gboolean _tmp2090_ = FALSE;
	ValaCodeNode* _tmp2091_;
	ValaCodeNode* _tmp2092_;
	ValaList* _tmp2192_;
	ValaIterator* _tmp2193_;
	gboolean _tmp2347_ = FALSE;
	gboolean _tmp2348_ = FALSE;
	ValaMethod* _tmp2349_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp367_ = FALSE;
		ValaMemberAccess* _tmp368_;
		const gchar* _tmp369_;
		const gchar* _tmp370_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		} else {
			gboolean _tmp240_ = FALSE;
			gboolean _tmp241_ = FALSE;
			gboolean _tmp242_ = FALSE;
			ValaMethod* _tmp243_;
			_tmp243_ = m;
			if (_tmp243_ != NULL) {
				ValaMethod* _tmp244_;
				_tmp244_ = m;
				_tmp242_ = vala_get_ccode_no_wrapper (_tmp244_);
			} else {
				_tmp242_ = FALSE;
			}
			if (_tmp242_) {
				ValaMethod* _tmp245_;
				ValaMemberBinding _tmp246_;
				ValaMemberBinding _tmp247_;
				_tmp245_ = m;
				_tmp246_ = vala_method_get_binding (_tmp245_);
				_tmp247_ = _tmp246_;
				_tmp241_ = _tmp247_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp241_ = FALSE;
			}
			if (_tmp241_) {
				ValaMethod* _tmp248_;
				_tmp248_ = m;
				_tmp240_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp248_, VALA_TYPE_CREATION_METHOD);
			} else {
				_tmp240_ = FALSE;
			}
			if (_tmp240_) {
				ValaTargetValue* instance_value = NULL;
				ValaMemberAccess* _tmp249_;
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				ValaTargetValue* _tmp252_;
				ValaTargetValue* _tmp253_;
				ValaTargetValue* _tmp254_;
				gboolean _tmp255_ = FALSE;
				gboolean _tmp256_ = FALSE;
				ValaMemberAccess* _tmp257_;
				const gchar* _tmp258_;
				const gchar* _tmp259_;
				ValaCCodeExpression* pub_inst = NULL;
				ValaTargetValue* _tmp281_;
				ValaCCodeExpression* _tmp282_;
				ValaCCodeExpression* _tmp283_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaMethod* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaCCodeFunctionCall* _tmp352_;
				_tmp249_ = ma;
				_tmp250_ = vala_member_access_get_inner (_tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_expression_get_target_value (_tmp251_);
				_tmp253_ = _tmp252_;
				_tmp254_ = _vala_target_value_ref0 (_tmp253_);
				instance_value = _tmp254_;
				_tmp257_ = ma;
				_tmp258_ = vala_member_access_get_member_name (_tmp257_);
				_tmp259_ = _tmp258_;
				if (g_strcmp0 (_tmp259_, "begin") == 0) {
					_tmp256_ = TRUE;
				} else {
					ValaMemberAccess* _tmp260_;
					const gchar* _tmp261_;
					const gchar* _tmp262_;
					_tmp260_ = ma;
					_tmp261_ = vala_member_access_get_member_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp256_ = g_strcmp0 (_tmp262_, "end") == 0;
				}
				if (_tmp256_) {
					ValaMemberAccess* _tmp263_;
					ValaExpression* _tmp264_;
					ValaExpression* _tmp265_;
					ValaSymbol* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaMemberAccess* _tmp268_;
					ValaSymbol* _tmp269_;
					ValaSymbol* _tmp270_;
					_tmp263_ = ma;
					_tmp264_ = vala_member_access_get_inner (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_expression_get_symbol_reference (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = ma;
					_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp255_ = _tmp267_ == _tmp270_;
				} else {
					_tmp255_ = FALSE;
				}
				if (_tmp255_) {
					ValaMemberAccess* inner_ma = NULL;
					ValaMemberAccess* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					ValaMemberAccess* _tmp274_;
					ValaMemberAccess* _tmp275_;
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaTargetValue* _tmp278_;
					ValaTargetValue* _tmp279_;
					ValaTargetValue* _tmp280_;
					_tmp271_ = ma;
					_tmp272_ = vala_member_access_get_inner (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					inner_ma = _tmp274_;
					_tmp275_ = inner_ma;
					_tmp276_ = vala_member_access_get_inner (_tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_target_value (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = _vala_target_value_ref0 (_tmp279_);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp280_;
					_vala_code_node_unref0 (inner_ma);
				}
				_tmp281_ = instance_value;
				_tmp282_ = vala_get_cvalue_ (_tmp281_);
				_tmp283_ = _vala_ccode_node_ref0 (_tmp282_);
				pub_inst = _tmp283_;
				vcast = NULL;
				_tmp284_ = m;
				_tmp285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp284_);
				_tmp286_ = _tmp285_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp286_, VALA_TYPE_CLASS)) {
					ValaClass* base_class = NULL;
					ValaMethod* _tmp287_;
					ValaSymbol* _tmp288_;
					ValaSymbol* _tmp289_;
					ValaClass* _tmp290_;
					gboolean _tmp291_;
					gboolean _tmp292_;
					_tmp287_ = m;
					_tmp288_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp287_);
					_tmp289_ = _tmp288_;
					base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_CLASS, ValaClass);
					_tmp290_ = base_class;
					_tmp291_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp290_);
					_tmp292_ = _tmp291_;
					if (_tmp292_) {
						ValaCCodeIdentifier* _tmp293_;
						ValaCCodeIdentifier* _tmp294_;
						ValaCCodeFunctionCall* _tmp295_;
						ValaCCodeFunctionCall* _tmp296_;
						ValaCCodeExpression* _tmp297_;
						ValaCCodeFunctionCall* _tmp298_;
						ValaClass* _tmp299_;
						gchar* _tmp300_;
						gchar* _tmp301_;
						ValaCCodeIdentifier* _tmp302_;
						ValaCCodeIdentifier* _tmp303_;
						ValaCCodeFunctionCall* _tmp304_;
						ValaClass* _tmp305_;
						gchar* _tmp306_;
						gchar* _tmp307_;
						ValaCCodeIdentifier* _tmp308_;
						ValaCCodeIdentifier* _tmp309_;
						_tmp293_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_CLASS");
						_tmp294_ = _tmp293_;
						_tmp295_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp294_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp295_;
						_vala_ccode_node_unref0 (_tmp294_);
						_tmp296_ = vcast;
						_tmp297_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp296_, _tmp297_);
						_tmp298_ = vcast;
						_tmp299_ = base_class;
						_tmp300_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp299_);
						_tmp301_ = _tmp300_;
						_tmp302_ = vala_ccode_identifier_new (_tmp301_);
						_tmp303_ = _tmp302_;
						vala_ccode_function_call_add_argument (_tmp298_, (ValaCCodeExpression*) _tmp303_);
						_vala_ccode_node_unref0 (_tmp303_);
						_g_free0 (_tmp301_);
						_tmp304_ = vcast;
						_tmp305_ = base_class;
						_tmp306_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp305_);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_ccode_identifier_new (_tmp307_);
						_tmp309_ = _tmp308_;
						vala_ccode_function_call_add_argument (_tmp304_, (ValaCCodeExpression*) _tmp309_);
						_vala_ccode_node_unref0 (_tmp309_);
						_g_free0 (_tmp307_);
					} else {
						ValaClass* _tmp310_;
						gchar* _tmp311_;
						gchar* _tmp312_;
						ValaCCodeIdentifier* _tmp313_;
						ValaCCodeIdentifier* _tmp314_;
						ValaCCodeFunctionCall* _tmp315_;
						ValaCCodeFunctionCall* _tmp316_;
						ValaCCodeExpression* _tmp317_;
						_tmp310_ = base_class;
						_tmp311_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp310_);
						_tmp312_ = _tmp311_;
						_tmp313_ = vala_ccode_identifier_new (_tmp312_);
						_tmp314_ = _tmp313_;
						_tmp315_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp314_);
						_vala_ccode_node_unref0 (vcast);
						vcast = _tmp315_;
						_vala_ccode_node_unref0 (_tmp314_);
						_g_free0 (_tmp312_);
						_tmp316_ = vcast;
						_tmp317_ = pub_inst;
						vala_ccode_function_call_add_argument (_tmp316_, _tmp317_);
					}
				} else {
					ValaMethod* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp318_ = m;
					_tmp319_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp318_);
					_tmp320_ = _tmp319_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp320_, VALA_TYPE_INTERFACE)) {
						ValaInterface* base_iface = NULL;
						ValaMethod* _tmp321_;
						ValaSymbol* _tmp322_;
						ValaSymbol* _tmp323_;
						ValaInterface* _tmp324_;
						gboolean _tmp325_;
						gboolean _tmp326_;
						_tmp321_ = m;
						_tmp322_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp321_);
						_tmp323_ = _tmp322_;
						base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface);
						_tmp324_ = base_iface;
						_tmp325_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp324_);
						_tmp326_ = _tmp325_;
						if (_tmp326_) {
							ValaCCodeIdentifier* _tmp327_;
							ValaCCodeIdentifier* _tmp328_;
							ValaCCodeFunctionCall* _tmp329_;
							ValaCCodeFunctionCall* _tmp330_;
							ValaCCodeExpression* _tmp331_;
							ValaCCodeFunctionCall* _tmp332_;
							ValaInterface* _tmp333_;
							gchar* _tmp334_;
							gchar* _tmp335_;
							ValaCCodeIdentifier* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeFunctionCall* _tmp338_;
							ValaInterface* _tmp339_;
							gchar* _tmp340_;
							gchar* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							ValaCCodeIdentifier* _tmp343_;
							_tmp327_ = vala_ccode_identifier_new ("G_TYPE_INSTANCE_GET_INTERFACE");
							_tmp328_ = _tmp327_;
							_tmp329_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp328_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp329_;
							_vala_ccode_node_unref0 (_tmp328_);
							_tmp330_ = vcast;
							_tmp331_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp330_, _tmp331_);
							_tmp332_ = vcast;
							_tmp333_ = base_iface;
							_tmp334_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = vala_ccode_identifier_new (_tmp335_);
							_tmp337_ = _tmp336_;
							vala_ccode_function_call_add_argument (_tmp332_, (ValaCCodeExpression*) _tmp337_);
							_vala_ccode_node_unref0 (_tmp337_);
							_g_free0 (_tmp335_);
							_tmp338_ = vcast;
							_tmp339_ = base_iface;
							_tmp340_ = vala_get_ccode_type_name ((ValaObjectTypeSymbol*) _tmp339_);
							_tmp341_ = _tmp340_;
							_tmp342_ = vala_ccode_identifier_new (_tmp341_);
							_tmp343_ = _tmp342_;
							vala_ccode_function_call_add_argument (_tmp338_, (ValaCCodeExpression*) _tmp343_);
							_vala_ccode_node_unref0 (_tmp343_);
							_g_free0 (_tmp341_);
						} else {
							ValaInterface* _tmp344_;
							gchar* _tmp345_;
							gchar* _tmp346_;
							ValaCCodeIdentifier* _tmp347_;
							ValaCCodeIdentifier* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							ValaCCodeExpression* _tmp351_;
							_tmp344_ = base_iface;
							_tmp345_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_identifier_new (_tmp346_);
							_tmp348_ = _tmp347_;
							_tmp349_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (vcast);
							vcast = _tmp349_;
							_vala_ccode_node_unref0 (_tmp348_);
							_g_free0 (_tmp346_);
							_tmp350_ = vcast;
							_tmp351_ = pub_inst;
							vala_ccode_function_call_add_argument (_tmp350_, _tmp351_);
						}
					}
				}
				_tmp352_ = vcast;
				if (_tmp352_ != NULL) {
					ValaCCodeFunctionCall* _tmp353_;
					ValaCCodeFunctionCall* _tmp354_;
					ValaMethod* _tmp355_;
					gchar* _tmp356_;
					gchar* _tmp357_;
					ValaCCodeMemberAccess* _tmp358_;
					ValaCCodeMemberAccess* _tmp359_;
					ValaCCodeFunctionCall* _tmp360_;
					ValaCCodeFunctionCall* _tmp361_;
					ValaMethod* _tmp362_;
					gchar* _tmp363_;
					gchar* _tmp364_;
					ValaCCodeMemberAccess* _tmp365_;
					ValaCCodeMemberAccess* _tmp366_;
					_tmp353_ = async_call;
					_tmp354_ = vcast;
					_tmp355_ = m;
					_tmp356_ = vala_get_ccode_vfunc_name (_tmp355_);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp354_, _tmp357_);
					_tmp359_ = _tmp358_;
					vala_ccode_function_call_set_call (_tmp353_, (ValaCCodeExpression*) _tmp359_);
					_vala_ccode_node_unref0 (_tmp359_);
					_g_free0 (_tmp357_);
					_tmp360_ = finish_call;
					_tmp361_ = vcast;
					_tmp362_ = m;
					_tmp363_ = vala_get_ccode_finish_vfunc_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp361_, _tmp364_);
					_tmp366_ = _tmp365_;
					vala_ccode_function_call_set_call (_tmp360_, (ValaCCodeExpression*) _tmp366_);
					_vala_ccode_node_unref0 (_tmp366_);
					_g_free0 (_tmp364_);
				}
				_vala_ccode_node_unref0 (vcast);
				_vala_ccode_node_unref0 (pub_inst);
				_vala_target_value_unref0 (instance_value);
			}
		}
		_tmp368_ = ma;
		_tmp369_ = vala_member_access_get_member_name (_tmp368_);
		_tmp370_ = _tmp369_;
		if (g_strcmp0 (_tmp370_, "begin") == 0) {
			ValaMemberAccess* _tmp371_;
			ValaExpression* _tmp372_;
			ValaExpression* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			ValaMemberAccess* _tmp376_;
			ValaSymbol* _tmp377_;
			ValaSymbol* _tmp378_;
			_tmp371_ = ma;
			_tmp372_ = vala_member_access_get_inner (_tmp371_);
			_tmp373_ = _tmp372_;
			_tmp374_ = vala_expression_get_symbol_reference (_tmp373_);
			_tmp375_ = _tmp374_;
			_tmp376_ = ma;
			_tmp377_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp376_);
			_tmp378_ = _tmp377_;
			_tmp367_ = _tmp375_ == _tmp378_;
		} else {
			_tmp367_ = FALSE;
		}
		if (_tmp367_) {
			ValaCCodeFunctionCall* _tmp379_;
			ValaCCodeFunctionCall* _tmp380_;
			ValaMethod* _tmp381_;
			ValaList* _tmp382_;
			_tmp379_ = async_call;
			_tmp380_ = _vala_ccode_node_ref0 (_tmp379_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp380_;
			_tmp381_ = m;
			_tmp382_ = vala_method_get_async_begin_parameters (_tmp381_);
			_vala_iterable_unref0 (params);
			params = _tmp382_;
		} else {
			gboolean _tmp383_ = FALSE;
			ValaMemberAccess* _tmp384_;
			const gchar* _tmp385_;
			const gchar* _tmp386_;
			_tmp384_ = ma;
			_tmp385_ = vala_member_access_get_member_name (_tmp384_);
			_tmp386_ = _tmp385_;
			if (g_strcmp0 (_tmp386_, "end") == 0) {
				ValaMemberAccess* _tmp387_;
				ValaExpression* _tmp388_;
				ValaExpression* _tmp389_;
				ValaSymbol* _tmp390_;
				ValaSymbol* _tmp391_;
				ValaMemberAccess* _tmp392_;
				ValaSymbol* _tmp393_;
				ValaSymbol* _tmp394_;
				_tmp387_ = ma;
				_tmp388_ = vala_member_access_get_inner (_tmp387_);
				_tmp389_ = _tmp388_;
				_tmp390_ = vala_expression_get_symbol_reference (_tmp389_);
				_tmp391_ = _tmp390_;
				_tmp392_ = ma;
				_tmp393_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp392_);
				_tmp394_ = _tmp393_;
				_tmp383_ = _tmp391_ == _tmp394_;
			} else {
				_tmp383_ = FALSE;
			}
			if (_tmp383_) {
				ValaCCodeFunctionCall* _tmp395_;
				ValaCCodeFunctionCall* _tmp396_;
				ValaMethod* _tmp397_;
				ValaList* _tmp398_;
				_tmp395_ = finish_call;
				_tmp396_ = _vala_ccode_node_ref0 (_tmp395_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp396_;
				_tmp397_ = m;
				_tmp398_ = vala_method_get_async_end_parameters (_tmp397_);
				_vala_iterable_unref0 (params);
				params = _tmp398_;
			} else {
				gboolean _tmp399_;
				gboolean _tmp400_;
				_tmp399_ = vala_method_call_get_is_yield_expression (expr);
				_tmp400_ = _tmp399_;
				if (!_tmp400_) {
					ValaCCodeFunctionCall* _tmp401_;
					ValaCCodeFunctionCall* _tmp402_;
					ValaMethod* _tmp403_;
					ValaList* _tmp404_;
					_tmp401_ = async_call;
					_tmp402_ = _vala_ccode_node_ref0 (_tmp401_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp402_;
					_tmp403_ = m;
					_tmp404_ = vala_method_get_async_begin_parameters (_tmp403_);
					_vala_iterable_unref0 (params);
					params = _tmp404_;
				} else {
					ValaCCodeFunctionCall* _tmp405_;
					ValaCCodeFunctionCall* _tmp406_;
					GHashFunc _tmp407_;
					GEqualFunc _tmp408_;
					GEqualFunc _tmp409_;
					ValaHashMap* _tmp410_;
					ValaHashMap* _tmp411_;
					ValaMethod* _tmp412_;
					ValaCCodeIdentifier* _tmp413_;
					ValaCCodeIdentifier* _tmp414_;
					ValaCCodeMemberAccess* _tmp415_;
					ValaCCodeMemberAccess* _tmp416_;
					_tmp405_ = finish_call;
					_tmp406_ = _vala_ccode_node_ref0 (_tmp405_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp406_;
					_tmp407_ = g_direct_hash;
					_tmp408_ = g_direct_equal;
					_tmp409_ = g_direct_equal;
					_tmp410_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp407_, _tmp408_, _tmp409_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp410_;
					_tmp411_ = out_arg_map;
					_tmp412_ = m;
					_tmp413_ = vala_ccode_identifier_new ("_data_");
					_tmp414_ = _tmp413_;
					_tmp415_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp414_, "_res_");
					_tmp416_ = _tmp415_;
					vala_map_set ((ValaMap*) _tmp411_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp412_), FALSE)), (ValaCCodeExpression*) _tmp416_);
					_vala_ccode_node_unref0 (_tmp416_);
					_vala_ccode_node_unref0 (_tmp414_);
				}
			}
		}
	}
	_tmp418_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp418_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp419_;
		ValaSymbol* _tmp420_;
		ValaSymbol* _tmp421_;
		_tmp419_ = m;
		_tmp420_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp419_);
		_tmp421_ = _tmp420_;
		_tmp417_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp421_, VALA_TYPE_CLASS);
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaCodeContext* _tmp422_;
		ValaCodeContext* _tmp423_;
		ValaProfile _tmp424_;
		ValaProfile _tmp425_;
		ValaClass* _tmp437_;
		ValaClass* _tmp438_;
		gboolean _tmp439_;
		gboolean _tmp440_;
		_tmp422_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp423_ = _tmp422_;
		_tmp424_ = vala_code_context_get_profile (_tmp423_);
		_tmp425_ = _tmp424_;
		if (_tmp425_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp426_;
			ValaSymbol* _tmp427_;
			ValaSymbol* _tmp428_;
			gboolean _tmp429_;
			gboolean _tmp430_;
			_tmp426_ = m;
			_tmp427_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp426_);
			_tmp428_ = _tmp427_;
			_tmp429_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_CLASS, ValaClass));
			_tmp430_ = _tmp429_;
			if (!_tmp430_) {
				ValaCCodeFunctionCall* _tmp431_;
				ValaCCodeExpression* _tmp432_;
				ValaCCodeExpression* _tmp433_;
				_tmp431_ = ccall;
				_tmp432_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp433_ = _tmp432_;
				vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
				_vala_ccode_node_unref0 (_tmp433_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp434_;
			ValaCCodeExpression* _tmp435_;
			ValaCCodeExpression* _tmp436_;
			_tmp434_ = ccall;
			_tmp435_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp436_ = _tmp435_;
			vala_ccode_function_call_add_argument (_tmp434_, _tmp436_);
			_vala_ccode_node_unref0 (_tmp436_);
		}
		_tmp437_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp438_ = _tmp437_;
		_tmp439_ = vala_class_get_is_compact (_tmp438_);
		_tmp440_ = _tmp439_;
		if (!_tmp440_) {
			ValaClass* _tmp441_;
			ValaClass* _tmp442_;
			ValaMethod* _tmp443_;
			ValaSymbol* _tmp444_;
			ValaSymbol* _tmp445_;
			_tmp441_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp442_ = _tmp441_;
			_tmp443_ = m;
			_tmp444_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp443_);
			_tmp445_ = _tmp444_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp445_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp446_;
					ValaClass* _tmp447_;
					ValaList* _tmp448_;
					ValaList* _tmp449_;
					gint _base_type_size = 0;
					ValaList* _tmp450_;
					gint _tmp451_;
					gint _tmp452_;
					gint _base_type_index = 0;
					_tmp446_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp447_ = _tmp446_;
					_tmp448_ = vala_class_get_base_types (_tmp447_);
					_tmp449_ = _vala_iterable_ref0 (_tmp448_);
					_base_type_list = _tmp449_;
					_tmp450_ = _base_type_list;
					_tmp451_ = vala_collection_get_size ((ValaCollection*) _tmp450_);
					_tmp452_ = _tmp451_;
					_base_type_size = _tmp452_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp453_;
						gint _tmp454_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp455_;
						gpointer _tmp456_;
						ValaDataType* _tmp457_;
						ValaTypeSymbol* _tmp458_;
						ValaTypeSymbol* _tmp459_;
						_base_type_index = _base_type_index + 1;
						_tmp453_ = _base_type_index;
						_tmp454_ = _base_type_size;
						if (!(_tmp453_ < _tmp454_)) {
							break;
						}
						_tmp455_ = _base_type_list;
						_tmp456_ = vala_list_get (_tmp455_, _base_type_index);
						base_type = (ValaDataType*) _tmp456_;
						_tmp457_ = base_type;
						_tmp458_ = vala_data_type_get_type_symbol (_tmp457_);
						_tmp459_ = _tmp458_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp459_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp460_;
							gchar* _tmp461_;
							gchar* _tmp462_;
							gboolean _tmp463_;
							ValaHashMap* _tmp469_;
							ValaDataType* _tmp470_;
							ValaList* _tmp471_;
							ValaList* _tmp472_;
							type_parameters = NULL;
							_tmp460_ = m;
							_tmp461_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp460_);
							_tmp462_ = _tmp461_;
							_tmp463_ = g_strcmp0 (_tmp462_, "g_object_new") == 0;
							_g_free0 (_tmp462_);
							if (_tmp463_) {
								ValaDataType* _tmp464_;
								ValaTypeSymbol* _tmp465_;
								ValaTypeSymbol* _tmp466_;
								ValaList* _tmp467_;
								ValaList* _tmp468_;
								_tmp464_ = base_type;
								_tmp465_ = vala_data_type_get_type_symbol (_tmp464_);
								_tmp466_ = _tmp465_;
								_tmp467_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_CLASS, ValaClass));
								_tmp468_ = _vala_iterable_ref0 (_tmp467_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp468_;
							}
							_tmp469_ = in_arg_map;
							_tmp470_ = base_type;
							_tmp471_ = vala_data_type_get_type_arguments (_tmp470_);
							_tmp472_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp469_, _tmp471_, (ValaCodeNode*) expr, TRUE, _tmp472_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp473_;
				ValaSymbol* _tmp474_;
				ValaSymbol* _tmp475_;
				ValaClass* _tmp476_;
				type_param_index = 0;
				_tmp473_ = m;
				_tmp474_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp473_);
				_tmp475_ = _tmp474_;
				_tmp476_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp475_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp476_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp477_;
					ValaList* _tmp478_;
					ValaList* _tmp479_;
					gint _type_param_size = 0;
					ValaList* _tmp480_;
					gint _tmp481_;
					gint _tmp482_;
					gint _type_param_index = 0;
					_tmp477_ = cl;
					_tmp478_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp477_);
					_tmp479_ = _vala_iterable_ref0 (_tmp478_);
					_type_param_list = _tmp479_;
					_tmp480_ = _type_param_list;
					_tmp481_ = vala_collection_get_size ((ValaCollection*) _tmp480_);
					_tmp482_ = _tmp481_;
					_type_param_size = _tmp482_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp483_;
						gint _tmp484_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp485_;
						gpointer _tmp486_;
						ValaHashMap* _tmp487_;
						ValaTypeParameter* _tmp488_;
						const gchar* _tmp489_;
						const gchar* _tmp490_;
						gchar* _tmp491_;
						gchar* _tmp492_;
						gchar* _tmp493_;
						gchar* _tmp494_;
						ValaCCodeIdentifier* _tmp495_;
						ValaCCodeIdentifier* _tmp496_;
						ValaHashMap* _tmp497_;
						ValaTypeParameter* _tmp498_;
						const gchar* _tmp499_;
						const gchar* _tmp500_;
						gchar* _tmp501_;
						gchar* _tmp502_;
						gchar* _tmp503_;
						gchar* _tmp504_;
						ValaCCodeIdentifier* _tmp505_;
						ValaCCodeIdentifier* _tmp506_;
						ValaHashMap* _tmp507_;
						ValaTypeParameter* _tmp508_;
						const gchar* _tmp509_;
						const gchar* _tmp510_;
						gchar* _tmp511_;
						gchar* _tmp512_;
						gchar* _tmp513_;
						gchar* _tmp514_;
						ValaCCodeIdentifier* _tmp515_;
						ValaCCodeIdentifier* _tmp516_;
						gint _tmp517_;
						_type_param_index = _type_param_index + 1;
						_tmp483_ = _type_param_index;
						_tmp484_ = _type_param_size;
						if (!(_tmp483_ < _tmp484_)) {
							break;
						}
						_tmp485_ = _type_param_list;
						_tmp486_ = vala_list_get (_tmp485_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp486_;
						_tmp487_ = in_arg_map;
						_tmp488_ = type_param;
						_tmp489_ = vala_symbol_get_name ((ValaSymbol*) _tmp488_);
						_tmp490_ = _tmp489_;
						_tmp491_ = g_ascii_strdown (_tmp490_, (gssize) -1);
						_tmp492_ = _tmp491_;
						_tmp493_ = g_strdup_printf ("%s_type", _tmp492_);
						_tmp494_ = _tmp493_;
						_tmp495_ = vala_ccode_identifier_new (_tmp494_);
						_tmp496_ = _tmp495_;
						vala_map_set ((ValaMap*) _tmp487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp496_);
						_vala_ccode_node_unref0 (_tmp496_);
						_g_free0 (_tmp494_);
						_g_free0 (_tmp492_);
						_tmp497_ = in_arg_map;
						_tmp498_ = type_param;
						_tmp499_ = vala_symbol_get_name ((ValaSymbol*) _tmp498_);
						_tmp500_ = _tmp499_;
						_tmp501_ = g_ascii_strdown (_tmp500_, (gssize) -1);
						_tmp502_ = _tmp501_;
						_tmp503_ = g_strdup_printf ("%s_dup_func", _tmp502_);
						_tmp504_ = _tmp503_;
						_tmp505_ = vala_ccode_identifier_new (_tmp504_);
						_tmp506_ = _tmp505_;
						vala_map_set ((ValaMap*) _tmp497_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp506_);
						_vala_ccode_node_unref0 (_tmp506_);
						_g_free0 (_tmp504_);
						_g_free0 (_tmp502_);
						_tmp507_ = in_arg_map;
						_tmp508_ = type_param;
						_tmp509_ = vala_symbol_get_name ((ValaSymbol*) _tmp508_);
						_tmp510_ = _tmp509_;
						_tmp511_ = g_ascii_strdown (_tmp510_, (gssize) -1);
						_tmp512_ = _tmp511_;
						_tmp513_ = g_strdup_printf ("%s_destroy_func", _tmp512_);
						_tmp514_ = _tmp513_;
						_tmp515_ = vala_ccode_identifier_new (_tmp514_);
						_tmp516_ = _tmp515_;
						vala_map_set ((ValaMap*) _tmp507_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp516_);
						_vala_ccode_node_unref0 (_tmp516_);
						_g_free0 (_tmp514_);
						_g_free0 (_tmp512_);
						_tmp517_ = type_param_index;
						type_param_index = _tmp517_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp518_;
			ValaClass* _tmp519_;
			ValaClass* _tmp520_;
			_tmp518_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp519_ = _tmp518_;
			_tmp520_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp519_, (ValaTypeSymbol*) _tmp520_)) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp521_;
				ValaClass* _tmp522_;
				gchar* _tmp523_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp524_;
				ValaCCodeDeclaration* _tmp525_;
				ValaCCodeDeclaration* _tmp526_;
				const gchar* _tmp527_;
				const gchar* _tmp528_;
				const gchar* _tmp529_;
				const gchar* _tmp530_;
				gchar* _tmp531_;
				gchar* _tmp532_;
				ValaCCodeConstant* _tmp533_;
				ValaCCodeConstant* _tmp534_;
				ValaCCodeVariableDeclarator* _tmp535_;
				ValaCCodeVariableDeclarator* _tmp536_;
				ValaCCodeFunction* _tmp537_;
				ValaCCodeFunction* _tmp538_;
				ValaCCodeDeclaration* _tmp539_;
				ValaCCodeFunctionCall* _tmp540_;
				ValaCCodeIdentifier* _tmp541_;
				ValaCCodeIdentifier* _tmp542_;
				ValaCCodeUnaryExpression* _tmp543_;
				ValaCCodeUnaryExpression* _tmp544_;
				ValaCCodeCastExpression* _tmp545_;
				ValaCCodeCastExpression* _tmp546_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp547_;
				ValaCCodeIdentifier* _tmp548_;
				ValaCCodeFunctionCall* _tmp549_;
				ValaCCodeFunctionCall* _tmp550_;
				ValaCCodeFunctionCall* _tmp551_;
				ValaClass* _tmp552_;
				ValaClass* _tmp553_;
				gchar* _tmp554_;
				gchar* _tmp555_;
				ValaCCodeIdentifier* _tmp556_;
				ValaCCodeIdentifier* _tmp557_;
				ValaCCodeFunctionCall* _tmp558_;
				ValaCCodeFunctionCall* _tmp559_;
				_tmp521_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp522_ = _tmp521_;
				_tmp523_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp522_, NULL);
				class_prefix = _tmp523_;
				_tmp524_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp524_;
				_tmp525_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp525_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp526_ = funcs;
				_tmp527_ = class_prefix;
				_tmp528_ = class_prefix;
				_tmp529_ = class_prefix;
				_tmp530_ = class_prefix;
				_tmp531_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp527_, _tmp528_, _tmp529_, _tmp530_);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_ccode_constant_new (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp534_, NULL);
				_tmp536_ = _tmp535_;
				vala_ccode_declaration_add_declarator (_tmp526_, (ValaCCodeDeclarator*) _tmp536_);
				_vala_ccode_node_unref0 (_tmp536_);
				_vala_ccode_node_unref0 (_tmp534_);
				_g_free0 (_tmp532_);
				_tmp537_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp538_ = _tmp537_;
				_tmp539_ = funcs;
				vala_ccode_function_add_statement (_tmp538_, (ValaCCodeNode*) _tmp539_);
				_tmp540_ = ccall;
				_tmp541_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp542_ = _tmp541_;
				_tmp543_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp544_, "GSourceFuncs *");
				_tmp546_ = _tmp545_;
				vala_ccode_function_call_add_argument (_tmp540_, (ValaCCodeExpression*) _tmp546_);
				_vala_ccode_node_unref0 (_tmp546_);
				_vala_ccode_node_unref0 (_tmp544_);
				_vala_ccode_node_unref0 (_tmp542_);
				_tmp547_ = vala_ccode_identifier_new ("sizeof");
				_tmp548_ = _tmp547_;
				_tmp549_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp548_);
				_tmp550_ = _tmp549_;
				_vala_ccode_node_unref0 (_tmp548_);
				csizeof = _tmp550_;
				_tmp551_ = csizeof;
				_tmp552_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp553_ = _tmp552_;
				_tmp554_ = vala_get_ccode_name ((ValaCodeNode*) _tmp553_);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_ccode_identifier_new (_tmp555_);
				_tmp557_ = _tmp556_;
				vala_ccode_function_call_add_argument (_tmp551_, (ValaCCodeExpression*) _tmp557_);
				_vala_ccode_node_unref0 (_tmp557_);
				_g_free0 (_tmp555_);
				_tmp558_ = ccall;
				_tmp559_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp558_, (ValaCCodeExpression*) _tmp559_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp560_ = FALSE;
		ValaMethod* _tmp561_;
		_tmp561_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp561_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp562_;
			ValaSymbol* _tmp563_;
			ValaSymbol* _tmp564_;
			_tmp562_ = m;
			_tmp563_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp562_);
			_tmp564_ = _tmp563_;
			_tmp560_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp564_, VALA_TYPE_STRUCT);
		} else {
			_tmp560_ = FALSE;
		}
		if (_tmp560_) {
			ValaCCodeFunctionCall* _tmp565_;
			ValaCCodeExpression* _tmp566_;
			ValaCCodeExpression* _tmp567_;
			_tmp565_ = ccall;
			_tmp566_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp567_ = _tmp566_;
			vala_ccode_function_call_add_argument (_tmp565_, _tmp567_);
			_vala_ccode_node_unref0 (_tmp567_);
		} else {
			gboolean _tmp568_ = FALSE;
			gboolean _tmp569_ = FALSE;
			gboolean _tmp570_ = FALSE;
			gboolean _tmp571_ = FALSE;
			ValaMethod* _tmp572_;
			_tmp572_ = m;
			if (_tmp572_ != NULL) {
				ValaMethod* _tmp573_;
				_tmp573_ = m;
				_tmp571_ = vala_method_has_type_parameters (_tmp573_);
			} else {
				_tmp571_ = FALSE;
			}
			if (_tmp571_) {
				ValaMethod* _tmp574_;
				_tmp574_ = m;
				_tmp570_ = !vala_get_ccode_has_generic_type_parameter (_tmp574_);
			} else {
				_tmp570_ = FALSE;
			}
			if (_tmp570_) {
				ValaMethod* _tmp575_;
				_tmp575_ = m;
				_tmp569_ = !vala_get_ccode_simple_generics (_tmp575_);
			} else {
				_tmp569_ = FALSE;
			}
			if (_tmp569_) {
				gboolean _tmp576_ = FALSE;
				ValaCCodeFunctionCall* _tmp577_;
				ValaCCodeFunctionCall* _tmp578_;
				_tmp577_ = ccall;
				_tmp578_ = finish_call;
				if (_tmp577_ != _tmp578_) {
					_tmp576_ = TRUE;
				} else {
					gboolean _tmp579_;
					gboolean _tmp580_;
					_tmp579_ = vala_method_call_get_is_yield_expression (expr);
					_tmp580_ = _tmp579_;
					_tmp576_ = _tmp580_;
				}
				_tmp568_ = _tmp576_;
			} else {
				_tmp568_ = FALSE;
			}
			if (_tmp568_) {
				ValaHashMap* _tmp581_;
				ValaMemberAccess* _tmp582_;
				ValaList* _tmp583_;
				_tmp581_ = in_arg_map;
				_tmp582_ = ma;
				_tmp583_ = vala_member_access_get_type_arguments (_tmp582_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp581_, _tmp583_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp584_ = ccall;
	_tmp585_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp584_);
	ccall_expr = _tmp585_;
	_tmp587_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp587_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp588_;
		ValaCodeContext* _tmp589_;
		ValaProfile _tmp590_;
		ValaProfile _tmp591_;
		_tmp588_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp589_ = _tmp588_;
		_tmp590_ = vala_code_context_get_profile (_tmp589_);
		_tmp591_ = _tmp590_;
		_tmp586_ = _tmp591_ != VALA_PROFILE_POSIX;
	} else {
		_tmp586_ = FALSE;
	}
	if (_tmp586_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp592_;
		ValaExpression* _tmp593_;
		ValaExpression* _tmp594_;
		ValaDataType* _tmp595_;
		ValaDataType* _tmp596_;
		ValaArrayType* _tmp597_;
		ValaHashMap* _tmp598_;
		ValaArrayType* _tmp599_;
		ValaDataType* _tmp600_;
		ValaDataType* _tmp601_;
		gchar* _tmp602_;
		gchar* _tmp603_;
		ValaCCodeIdentifier* _tmp604_;
		ValaCCodeIdentifier* _tmp605_;
		_tmp592_ = ma;
		_tmp593_ = vala_member_access_get_inner (_tmp592_);
		_tmp594_ = _tmp593_;
		_tmp595_ = vala_expression_get_value_type (_tmp594_);
		_tmp596_ = _tmp595_;
		_tmp597_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp596_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp597_;
		_tmp598_ = in_arg_map;
		_tmp599_ = array_type;
		_tmp600_ = vala_array_type_get_element_type (_tmp599_);
		_tmp601_ = _tmp600_;
		_tmp602_ = vala_get_ccode_name ((ValaCodeNode*) _tmp601_);
		_tmp603_ = _tmp602_;
		_tmp604_ = vala_ccode_identifier_new (_tmp603_);
		_tmp605_ = _tmp604_;
		vala_map_set ((ValaMap*) _tmp598_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp605_);
		_vala_ccode_node_unref0 (_tmp605_);
		_g_free0 (_tmp603_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp606_;
		_tmp606_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp606_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp607_;
			_tmp607_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp607_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp608_;
				ValaExpression* _tmp609_;
				ValaExpression* _tmp610_;
				ValaTargetValue* _tmp611_;
				ValaTargetValue* _tmp612_;
				ValaTargetValue* _tmp613_;
				ValaTargetValue* _tmp614_;
				_tmp608_ = ma;
				_tmp609_ = vala_member_access_get_inner (_tmp608_);
				_tmp610_ = _tmp609_;
				_tmp611_ = vala_expression_get_target_value (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp612_, (ValaCodeNode*) expr);
				_tmp614_ = _tmp613_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp614_);
				_vala_target_value_unref0 (_tmp614_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp616_ = m;
	if (_tmp616_ != NULL) {
		ValaMethod* _tmp617_;
		gboolean _tmp618_;
		gboolean _tmp619_;
		_tmp617_ = m;
		_tmp618_ = vala_method_get_is_async_callback (_tmp617_);
		_tmp619_ = _tmp618_;
		_tmp615_ = _tmp619_;
	} else {
		_tmp615_ = FALSE;
	}
	if (_tmp615_) {
		ValaMethod* _tmp620_;
		ValaMethod* _tmp621_;
		gboolean _tmp622_;
		gboolean _tmp623_;
		ValaHashMap* _tmp637_;
		ValaMethod* _tmp638_;
		ValaCCodeExpression* _tmp639_;
		ValaHashMap* _tmp640_;
		ValaMethod* _tmp641_;
		ValaCCodeExpression* _tmp642_;
		_tmp620_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp621_ = _tmp620_;
		_tmp622_ = vala_method_get_closure (_tmp621_);
		_tmp623_ = _tmp622_;
		if (_tmp623_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp624_;
			ValaSymbol* _tmp625_;
			ValaSymbol* _tmp626_;
			ValaBlock* _tmp627_;
			ValaBlock* _tmp628_;
			ValaBlock* _tmp629_;
			ValaBlock* _tmp630_;
			gchar* _tmp631_;
			gchar* _tmp632_;
			ValaCCodeExpression* _tmp633_;
			ValaCCodeExpression* _tmp634_;
			ValaCCodeMemberAccess* _tmp635_;
			_tmp624_ = m;
			_tmp625_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp624_);
			_tmp626_ = _tmp625_;
			_tmp627_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp626_, VALA_TYPE_METHOD, ValaMethod));
			_tmp628_ = _tmp627_;
			_tmp629_ = _vala_code_node_ref0 (_tmp628_);
			block = _tmp629_;
			_tmp630_ = block;
			_tmp631_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp630_));
			_tmp632_ = _tmp631_;
			_tmp633_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp632_);
			_tmp634_ = _tmp633_;
			_tmp635_ = vala_ccode_member_access_new_pointer (_tmp634_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp635_;
			_vala_ccode_node_unref0 (_tmp634_);
			_g_free0 (_tmp632_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp636_;
			_tmp636_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp636_;
		}
		_tmp637_ = in_arg_map;
		_tmp638_ = m;
		_tmp639_ = instance;
		vala_map_set ((ValaMap*) _tmp637_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp638_), FALSE)), _tmp639_);
		_tmp640_ = out_arg_map;
		_tmp641_ = m;
		_tmp642_ = instance;
		vala_map_set ((ValaMap*) _tmp640_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp641_), FALSE)), _tmp642_);
	} else {
		gboolean _tmp643_ = FALSE;
		gboolean _tmp644_ = FALSE;
		ValaMethod* _tmp645_;
		_tmp645_ = m;
		if (_tmp645_ != NULL) {
			ValaMethod* _tmp646_;
			ValaMemberBinding _tmp647_;
			ValaMemberBinding _tmp648_;
			_tmp646_ = m;
			_tmp647_ = vala_method_get_binding (_tmp646_);
			_tmp648_ = _tmp647_;
			_tmp644_ = _tmp648_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp644_ = FALSE;
		}
		if (_tmp644_) {
			ValaMethod* _tmp649_;
			_tmp649_ = m;
			_tmp643_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp649_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp643_ = FALSE;
		}
		if (_tmp643_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp650_;
			ValaExpression* _tmp651_;
			ValaExpression* _tmp652_;
			ValaTargetValue* _tmp653_;
			ValaTargetValue* _tmp654_;
			ValaTargetValue* _tmp655_;
			gboolean _tmp656_ = FALSE;
			gboolean _tmp657_ = FALSE;
			ValaMemberAccess* _tmp658_;
			const gchar* _tmp659_;
			const gchar* _tmp660_;
			ValaTargetValue* _tmp682_;
			ValaCCodeExpression* _tmp683_;
			ValaCCodeExpression* _tmp684_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp685_;
			ValaSymbol* _tmp686_;
			ValaSymbol* _tmp687_;
			ValaStruct* _tmp688_;
			gboolean _tmp689_ = FALSE;
			ValaStruct* _tmp690_;
			ValaMethod* _tmp698_;
			gboolean _tmp699_;
			gboolean _tmp700_;
			_tmp650_ = ma;
			_tmp651_ = vala_member_access_get_inner (_tmp650_);
			_tmp652_ = _tmp651_;
			_tmp653_ = vala_expression_get_target_value (_tmp652_);
			_tmp654_ = _tmp653_;
			_tmp655_ = _vala_target_value_ref0 (_tmp654_);
			instance_value = _tmp655_;
			_tmp658_ = ma;
			_tmp659_ = vala_member_access_get_member_name (_tmp658_);
			_tmp660_ = _tmp659_;
			if (g_strcmp0 (_tmp660_, "begin") == 0) {
				_tmp657_ = TRUE;
			} else {
				ValaMemberAccess* _tmp661_;
				const gchar* _tmp662_;
				const gchar* _tmp663_;
				_tmp661_ = ma;
				_tmp662_ = vala_member_access_get_member_name (_tmp661_);
				_tmp663_ = _tmp662_;
				_tmp657_ = g_strcmp0 (_tmp663_, "end") == 0;
			}
			if (_tmp657_) {
				ValaMemberAccess* _tmp664_;
				ValaExpression* _tmp665_;
				ValaExpression* _tmp666_;
				ValaSymbol* _tmp667_;
				ValaSymbol* _tmp668_;
				ValaMemberAccess* _tmp669_;
				ValaSymbol* _tmp670_;
				ValaSymbol* _tmp671_;
				_tmp664_ = ma;
				_tmp665_ = vala_member_access_get_inner (_tmp664_);
				_tmp666_ = _tmp665_;
				_tmp667_ = vala_expression_get_symbol_reference (_tmp666_);
				_tmp668_ = _tmp667_;
				_tmp669_ = ma;
				_tmp670_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp669_);
				_tmp671_ = _tmp670_;
				_tmp656_ = _tmp668_ == _tmp671_;
			} else {
				_tmp656_ = FALSE;
			}
			if (_tmp656_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp672_;
				ValaExpression* _tmp673_;
				ValaExpression* _tmp674_;
				ValaMemberAccess* _tmp675_;
				ValaMemberAccess* _tmp676_;
				ValaExpression* _tmp677_;
				ValaExpression* _tmp678_;
				ValaTargetValue* _tmp679_;
				ValaTargetValue* _tmp680_;
				ValaTargetValue* _tmp681_;
				_tmp672_ = ma;
				_tmp673_ = vala_member_access_get_inner (_tmp672_);
				_tmp674_ = _tmp673_;
				_tmp675_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp674_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp675_;
				_tmp676_ = inner_ma;
				_tmp677_ = vala_member_access_get_inner (_tmp676_);
				_tmp678_ = _tmp677_;
				_tmp679_ = vala_expression_get_target_value (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = _vala_target_value_ref0 (_tmp680_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp681_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp682_ = instance_value;
			_tmp683_ = vala_get_cvalue_ (_tmp682_);
			_tmp684_ = _vala_ccode_node_ref0 (_tmp683_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp684_;
			_tmp685_ = m;
			_tmp686_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp685_);
			_tmp687_ = _tmp686_;
			_tmp688_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp687_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp687_) : NULL);
			st = _tmp688_;
			_tmp690_ = st;
			if (_tmp690_ != NULL) {
				ValaStruct* _tmp691_;
				_tmp691_ = st;
				_tmp689_ = !vala_struct_is_simple_type (_tmp691_);
			} else {
				_tmp689_ = FALSE;
			}
			if (_tmp689_) {
				ValaTargetValue* _tmp692_;
				ValaTargetValue* _tmp695_;
				ValaCCodeExpression* _tmp696_;
				ValaCCodeUnaryExpression* _tmp697_;
				_tmp692_ = instance_value;
				if (!vala_get_lvalue (_tmp692_)) {
					ValaTargetValue* _tmp693_;
					ValaTargetValue* _tmp694_;
					_tmp693_ = instance_value;
					_tmp694_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp693_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp694_;
				}
				_tmp695_ = instance_value;
				_tmp696_ = vala_get_cvalue_ (_tmp695_);
				_tmp697_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp696_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp697_;
			}
			_tmp698_ = m;
			_tmp699_ = vala_method_get_coroutine (_tmp698_);
			_tmp700_ = _tmp699_;
			if (!_tmp700_) {
				ValaHashMap* _tmp701_;
				ValaMethod* _tmp702_;
				ValaCCodeExpression* _tmp703_;
				_tmp701_ = in_arg_map;
				_tmp702_ = m;
				_tmp703_ = instance;
				vala_map_set ((ValaMap*) _tmp701_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp702_), FALSE)), _tmp703_);
			} else {
				gboolean _tmp704_;
				gboolean _tmp705_;
				_tmp704_ = vala_method_call_get_is_yield_expression (expr);
				_tmp705_ = _tmp704_;
				if (_tmp705_) {
					ValaHashMap* _tmp706_;
					ValaMethod* _tmp707_;
					ValaCCodeExpression* _tmp708_;
					ValaMethod* _tmp709_;
					_tmp706_ = in_arg_map;
					_tmp707_ = m;
					_tmp708_ = instance;
					vala_map_set ((ValaMap*) _tmp706_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp707_), FALSE)), _tmp708_);
					_tmp709_ = m;
					if (vala_get_ccode_finish_instance (_tmp709_)) {
						ValaHashMap* _tmp710_;
						ValaMethod* _tmp711_;
						ValaCCodeExpression* _tmp712_;
						_tmp710_ = out_arg_map;
						_tmp711_ = m;
						_tmp712_ = instance;
						vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp711_), FALSE)), _tmp712_);
					}
				} else {
					gboolean _tmp713_ = FALSE;
					ValaMemberAccess* _tmp714_;
					const gchar* _tmp715_;
					const gchar* _tmp716_;
					_tmp714_ = ma;
					_tmp715_ = vala_member_access_get_member_name (_tmp714_);
					_tmp716_ = _tmp715_;
					if (g_strcmp0 (_tmp716_, "end") != 0) {
						_tmp713_ = TRUE;
					} else {
						ValaMethod* _tmp717_;
						_tmp717_ = m;
						_tmp713_ = vala_get_ccode_finish_instance (_tmp717_);
					}
					if (_tmp713_) {
						ValaHashMap* _tmp718_;
						ValaMethod* _tmp719_;
						ValaCCodeExpression* _tmp720_;
						ValaHashMap* _tmp721_;
						ValaMethod* _tmp722_;
						ValaCCodeExpression* _tmp723_;
						_tmp718_ = out_arg_map;
						_tmp719_ = m;
						_tmp720_ = instance;
						vala_map_set ((ValaMap*) _tmp718_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp719_), FALSE)), _tmp720_);
						_tmp721_ = in_arg_map;
						_tmp722_ = m;
						_tmp723_ = instance;
						vala_map_set ((ValaMap*) _tmp721_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp722_), FALSE)), _tmp723_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp724_ = FALSE;
			ValaMethod* _tmp725_;
			_tmp725_ = m;
			if (_tmp725_ != NULL) {
				ValaMethod* _tmp726_;
				ValaMemberBinding _tmp727_;
				ValaMemberBinding _tmp728_;
				_tmp726_ = m;
				_tmp727_ = vala_method_get_binding (_tmp726_);
				_tmp728_ = _tmp727_;
				_tmp724_ = _tmp728_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp724_ = FALSE;
			}
			if (_tmp724_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp729_;
				ValaSymbol* _tmp730_;
				ValaSymbol* _tmp731_;
				ValaClass* _tmp732_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp733_;
				gchar* _tmp734_;
				gchar* _tmp735_;
				ValaCCodeIdentifier* _tmp736_;
				ValaCCodeIdentifier* _tmp737_;
				ValaCCodeFunctionCall* _tmp738_;
				ValaCCodeFunctionCall* _tmp739_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp740_;
				ValaExpression* _tmp741_;
				ValaExpression* _tmp742_;
				ValaCCodeFunctionCall* _tmp771_;
				ValaCCodeExpression* _tmp772_;
				ValaHashMap* _tmp773_;
				ValaMethod* _tmp774_;
				ValaCCodeFunctionCall* _tmp775_;
				ValaHashMap* _tmp776_;
				ValaMethod* _tmp777_;
				ValaCCodeFunctionCall* _tmp778_;
				_tmp729_ = m;
				_tmp730_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp729_);
				_tmp731_ = _tmp730_;
				_tmp732_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp731_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp732_;
				_tmp733_ = cl;
				_tmp734_ = vala_get_ccode_class_type_function (_tmp733_);
				_tmp735_ = _tmp734_;
				_tmp736_ = vala_ccode_identifier_new (_tmp735_);
				_tmp737_ = _tmp736_;
				_tmp738_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp737_);
				_tmp739_ = _tmp738_;
				_vala_ccode_node_unref0 (_tmp737_);
				_g_free0 (_tmp735_);
				cast = _tmp739_;
				_tmp740_ = ma;
				_tmp741_ = vala_member_access_get_inner (_tmp740_);
				_tmp742_ = _tmp741_;
				if (_tmp742_ == NULL) {
					ValaDataType* _tmp743_;
					_tmp743_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp743_ == NULL) {
						ValaCCodeIdentifier* _tmp744_;
						_tmp744_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp744_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaClass* _tmp745_;
						gchar* _tmp746_;
						gchar* _tmp747_;
						ValaCCodeIdentifier* _tmp748_;
						ValaCCodeIdentifier* _tmp749_;
						ValaCCodeFunctionCall* _tmp750_;
						ValaCCodeFunctionCall* _tmp751_;
						ValaCCodeFunctionCall* _tmp752_;
						ValaCCodeExpression* _tmp753_;
						ValaCCodeExpression* _tmp754_;
						ValaCCodeFunctionCall* _tmp755_;
						ValaCCodeExpression* _tmp756_;
						_tmp745_ = cl;
						_tmp746_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp745_);
						_tmp747_ = _tmp746_;
						_tmp748_ = vala_ccode_identifier_new (_tmp747_);
						_tmp749_ = _tmp748_;
						_tmp750_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp749_);
						_tmp751_ = _tmp750_;
						_vala_ccode_node_unref0 (_tmp749_);
						_g_free0 (_tmp747_);
						k = _tmp751_;
						_tmp752_ = k;
						_tmp753_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp754_ = _tmp753_;
						vala_ccode_function_call_add_argument (_tmp752_, _tmp754_);
						_vala_ccode_node_unref0 (_tmp754_);
						_tmp755_ = k;
						_tmp756_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp755_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp756_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaClass* _tmp757_;
					gchar* _tmp758_;
					gchar* _tmp759_;
					ValaCCodeIdentifier* _tmp760_;
					ValaCCodeIdentifier* _tmp761_;
					ValaCCodeFunctionCall* _tmp762_;
					ValaCCodeFunctionCall* _tmp763_;
					ValaCCodeFunctionCall* _tmp764_;
					ValaMemberAccess* _tmp765_;
					ValaExpression* _tmp766_;
					ValaExpression* _tmp767_;
					ValaCCodeExpression* _tmp768_;
					ValaCCodeFunctionCall* _tmp769_;
					ValaCCodeExpression* _tmp770_;
					_tmp757_ = cl;
					_tmp758_ = vala_get_ccode_type_get_function ((ValaObjectTypeSymbol*) _tmp757_);
					_tmp759_ = _tmp758_;
					_tmp760_ = vala_ccode_identifier_new (_tmp759_);
					_tmp761_ = _tmp760_;
					_tmp762_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp761_);
					_tmp763_ = _tmp762_;
					_vala_ccode_node_unref0 (_tmp761_);
					_g_free0 (_tmp759_);
					k = _tmp763_;
					_tmp764_ = k;
					_tmp765_ = ma;
					_tmp766_ = vala_member_access_get_inner (_tmp765_);
					_tmp767_ = _tmp766_;
					_tmp768_ = vala_get_cvalue (_tmp767_);
					vala_ccode_function_call_add_argument (_tmp764_, _tmp768_);
					_tmp769_ = k;
					_tmp770_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp769_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp770_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp771_ = cast;
				_tmp772_ = klass;
				vala_ccode_function_call_add_argument (_tmp771_, _tmp772_);
				_tmp773_ = in_arg_map;
				_tmp774_ = m;
				_tmp775_ = cast;
				vala_map_set ((ValaMap*) _tmp773_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp774_), FALSE)), (ValaCCodeExpression*) _tmp775_);
				_tmp776_ = out_arg_map;
				_tmp777_ = m;
				_tmp778_ = cast;
				vala_map_set ((ValaMap*) _tmp776_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp777_), FALSE)), (ValaCCodeExpression*) _tmp778_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp780_ = m;
	if (_tmp780_ != NULL) {
		ValaMethod* _tmp781_;
		_tmp781_ = m;
		_tmp779_ = vala_get_ccode_has_generic_type_parameter (_tmp781_);
	} else {
		_tmp779_ = FALSE;
	}
	if (_tmp779_) {
		ValaMethod* _tmp782_;
		_tmp782_ = m;
		if (vala_method_has_type_parameters (_tmp782_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp783_;
				ValaList* _tmp784_;
				ValaList* _tmp785_;
				gint _type_arg_size = 0;
				ValaList* _tmp786_;
				gint _tmp787_;
				gint _tmp788_;
				gint _type_arg_index = 0;
				_tmp783_ = ma;
				_tmp784_ = vala_member_access_get_type_arguments (_tmp783_);
				_tmp785_ = _vala_iterable_ref0 (_tmp784_);
				_type_arg_list = _tmp785_;
				_tmp786_ = _type_arg_list;
				_tmp787_ = vala_collection_get_size ((ValaCollection*) _tmp786_);
				_tmp788_ = _tmp787_;
				_type_arg_size = _tmp788_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp789_;
					gint _tmp790_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp791_;
					gpointer _tmp792_;
					gboolean _tmp793_ = FALSE;
					gboolean _tmp794_ = FALSE;
					gboolean _tmp795_ = FALSE;
					ValaMethod* _tmp796_;
					ValaHashMap* _tmp804_;
					ValaMethod* _tmp805_;
					ValaDataType* _tmp806_;
					gchar* _tmp807_;
					gchar* _tmp808_;
					ValaCCodeIdentifier* _tmp809_;
					ValaCCodeIdentifier* _tmp810_;
					gint _tmp811_;
					_type_arg_index = _type_arg_index + 1;
					_tmp789_ = _type_arg_index;
					_tmp790_ = _type_arg_size;
					if (!(_tmp789_ < _tmp790_)) {
						break;
					}
					_tmp791_ = _type_arg_list;
					_tmp792_ = vala_list_get (_tmp791_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp792_;
					_tmp796_ = m;
					if (vala_get_ccode_simple_generics (_tmp796_)) {
						ValaDataType* _tmp797_;
						_tmp797_ = type_arg;
						_tmp795_ = vala_data_type_is_real_struct_type (_tmp797_);
					} else {
						_tmp795_ = FALSE;
					}
					if (_tmp795_) {
						ValaDataType* _tmp798_;
						gboolean _tmp799_;
						gboolean _tmp800_;
						_tmp798_ = type_arg;
						_tmp799_ = vala_data_type_get_nullable (_tmp798_);
						_tmp800_ = _tmp799_;
						_tmp794_ = !_tmp800_;
					} else {
						_tmp794_ = FALSE;
					}
					if (_tmp794_) {
						ValaDataType* _tmp801_;
						_tmp801_ = type_arg;
						_tmp793_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp801_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp793_ = FALSE;
					}
					if (_tmp793_) {
						ValaDataType* _tmp802_;
						ValaPointerType* _tmp803_;
						_tmp802_ = type_arg;
						_tmp803_ = vala_pointer_type_new (_tmp802_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp803_;
					}
					_tmp804_ = in_arg_map;
					_tmp805_ = m;
					_tmp806_ = type_arg;
					_tmp807_ = vala_get_ccode_name ((ValaCodeNode*) _tmp806_);
					_tmp808_ = _tmp807_;
					_tmp809_ = vala_ccode_identifier_new (_tmp808_);
					_tmp810_ = _tmp809_;
					vala_map_set ((ValaMap*) _tmp804_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp805_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp810_);
					_vala_ccode_node_unref0 (_tmp810_);
					_g_free0 (_tmp808_);
					_tmp811_ = type_param_index;
					type_param_index = _tmp811_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp812_;
				ValaExpression* _tmp813_;
				ValaExpression* _tmp814_;
				ValaDataType* _tmp815_;
				ValaDataType* _tmp816_;
				ValaList* _tmp817_;
				ValaList* _tmp818_;
				gint _type_arg_size = 0;
				ValaList* _tmp819_;
				gint _tmp820_;
				gint _tmp821_;
				gint _type_arg_index = 0;
				_tmp812_ = ma;
				_tmp813_ = vala_member_access_get_inner (_tmp812_);
				_tmp814_ = _tmp813_;
				_tmp815_ = vala_expression_get_value_type (_tmp814_);
				_tmp816_ = _tmp815_;
				_tmp817_ = vala_data_type_get_type_arguments (_tmp816_);
				_tmp818_ = _vala_iterable_ref0 (_tmp817_);
				_type_arg_list = _tmp818_;
				_tmp819_ = _type_arg_list;
				_tmp820_ = vala_collection_get_size ((ValaCollection*) _tmp819_);
				_tmp821_ = _tmp820_;
				_type_arg_size = _tmp821_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp822_;
					gint _tmp823_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp824_;
					gpointer _tmp825_;
					ValaHashMap* _tmp826_;
					ValaMethod* _tmp827_;
					ValaDataType* _tmp828_;
					gchar* _tmp829_;
					gchar* _tmp830_;
					ValaCCodeIdentifier* _tmp831_;
					ValaCCodeIdentifier* _tmp832_;
					gint _tmp833_;
					_type_arg_index = _type_arg_index + 1;
					_tmp822_ = _type_arg_index;
					_tmp823_ = _type_arg_size;
					if (!(_tmp822_ < _tmp823_)) {
						break;
					}
					_tmp824_ = _type_arg_list;
					_tmp825_ = vala_list_get (_tmp824_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp825_;
					_tmp826_ = in_arg_map;
					_tmp827_ = m;
					_tmp828_ = type_arg;
					_tmp829_ = vala_get_ccode_name ((ValaCodeNode*) _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = vala_ccode_identifier_new (_tmp830_);
					_tmp832_ = _tmp831_;
					vala_map_set ((ValaMap*) _tmp826_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp827_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp832_);
					_vala_ccode_node_unref0 (_tmp832_);
					_g_free0 (_tmp830_);
					_tmp833_ = type_param_index;
					type_param_index = _tmp833_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp834_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp834_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp835_;
		ValaExpression* _tmp836_;
		ValaExpression* _tmp837_;
		ValaDataType* _tmp838_;
		ValaDataType* _tmp839_;
		ValaArrayType* _tmp840_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp841_;
		ValaCCodeIdentifier* _tmp842_;
		ValaCCodeFunctionCall* _tmp843_;
		ValaCCodeFunctionCall* _tmp844_;
		ValaCCodeFunctionCall* _tmp845_;
		ValaArrayType* _tmp846_;
		ValaDataType* _tmp847_;
		ValaDataType* _tmp848_;
		gchar* _tmp849_;
		gchar* _tmp850_;
		ValaCCodeIdentifier* _tmp851_;
		ValaCCodeIdentifier* _tmp852_;
		ValaHashMap* _tmp853_;
		ValaCCodeFunctionCall* _tmp854_;
		_tmp835_ = ma;
		_tmp836_ = vala_member_access_get_inner (_tmp835_);
		_tmp837_ = _tmp836_;
		_tmp838_ = vala_expression_get_value_type (_tmp837_);
		_tmp839_ = _tmp838_;
		_tmp840_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp839_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp840_;
		_tmp841_ = vala_ccode_identifier_new ("sizeof");
		_tmp842_ = _tmp841_;
		_tmp843_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp842_);
		_tmp844_ = _tmp843_;
		_vala_ccode_node_unref0 (_tmp842_);
		csizeof = _tmp844_;
		_tmp845_ = csizeof;
		_tmp846_ = array_type;
		_tmp847_ = vala_array_type_get_element_type (_tmp846_);
		_tmp848_ = _tmp847_;
		_tmp849_ = vala_get_ccode_name ((ValaCodeNode*) _tmp848_);
		_tmp850_ = _tmp849_;
		_tmp851_ = vala_ccode_identifier_new (_tmp850_);
		_tmp852_ = _tmp851_;
		vala_ccode_function_call_add_argument (_tmp845_, (ValaCCodeExpression*) _tmp852_);
		_vala_ccode_node_unref0 (_tmp852_);
		_g_free0 (_tmp850_);
		_tmp853_ = in_arg_map;
		_tmp854_ = csizeof;
		vala_map_set ((ValaMap*) _tmp853_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp854_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp855_;
		_tmp855_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp855_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp856_;
			ValaMethod* _tmp857_;
			ValaMethod* _tmp858_;
			gint param_nr = 0;
			ValaMethod* _tmp924_;
			ValaCCodeBaseModuleEmitContext* _tmp925_;
			_tmp856_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp857_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp856_, (ValaSymbol*) _tmp857_);
			_tmp858_ = m;
			vala_method_clear_parameters (_tmp858_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp859_;
				ValaList* _tmp860_;
				gint _arg_size = 0;
				ValaList* _tmp861_;
				gint _tmp862_;
				gint _tmp863_;
				gint _arg_index = 0;
				_tmp859_ = vala_method_call_get_argument_list (expr);
				_tmp860_ = _vala_iterable_ref0 (_tmp859_);
				_arg_list = _tmp860_;
				_tmp861_ = _arg_list;
				_tmp862_ = vala_collection_get_size ((ValaCollection*) _tmp861_);
				_tmp863_ = _tmp862_;
				_arg_size = _tmp863_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp864_;
					gint _tmp865_;
					ValaExpression* arg = NULL;
					ValaList* _tmp866_;
					gpointer _tmp867_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp868_;
					ValaUnaryExpression* _tmp869_;
					gboolean _tmp870_ = FALSE;
					ValaUnaryExpression* _tmp871_;
					gint _tmp912_;
					_arg_index = _arg_index + 1;
					_tmp864_ = _arg_index;
					_tmp865_ = _arg_size;
					if (!(_tmp864_ < _tmp865_)) {
						break;
					}
					_tmp866_ = _arg_list;
					_tmp867_ = vala_list_get (_tmp866_, _arg_index);
					arg = (ValaExpression*) _tmp867_;
					_tmp868_ = arg;
					_tmp869_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp868_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp868_) : NULL);
					unary = _tmp869_;
					_tmp871_ = unary;
					if (_tmp871_ != NULL) {
						ValaUnaryExpression* _tmp872_;
						ValaUnaryOperator _tmp873_;
						ValaUnaryOperator _tmp874_;
						_tmp872_ = unary;
						_tmp873_ = vala_unary_expression_get_operator (_tmp872_);
						_tmp874_ = _tmp873_;
						_tmp870_ = _tmp874_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp870_ = FALSE;
					}
					if (_tmp870_) {
						ValaParameter* param = NULL;
						gchar* _tmp875_;
						gchar* _tmp876_;
						ValaUnaryExpression* _tmp877_;
						ValaExpression* _tmp878_;
						ValaExpression* _tmp879_;
						ValaDataType* _tmp880_;
						ValaDataType* _tmp881_;
						ValaParameter* _tmp882_;
						ValaParameter* _tmp883_;
						ValaParameter* _tmp884_;
						ValaMethod* _tmp885_;
						ValaParameter* _tmp886_;
						_tmp875_ = g_strdup_printf ("param%d", param_nr);
						_tmp876_ = _tmp875_;
						_tmp877_ = unary;
						_tmp878_ = vala_unary_expression_get_inner (_tmp877_);
						_tmp879_ = _tmp878_;
						_tmp880_ = vala_expression_get_value_type (_tmp879_);
						_tmp881_ = _tmp880_;
						_tmp882_ = vala_parameter_new (_tmp876_, _tmp881_, NULL);
						_tmp883_ = _tmp882_;
						_g_free0 (_tmp876_);
						param = _tmp883_;
						_tmp884_ = param;
						vala_parameter_set_direction (_tmp884_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp885_ = m;
						_tmp886_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp885_, _tmp886_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp887_ = FALSE;
						ValaUnaryExpression* _tmp888_;
						_tmp888_ = unary;
						if (_tmp888_ != NULL) {
							ValaUnaryExpression* _tmp889_;
							ValaUnaryOperator _tmp890_;
							ValaUnaryOperator _tmp891_;
							_tmp889_ = unary;
							_tmp890_ = vala_unary_expression_get_operator (_tmp889_);
							_tmp891_ = _tmp890_;
							_tmp887_ = _tmp891_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp887_ = FALSE;
						}
						if (_tmp887_) {
							ValaParameter* param = NULL;
							gchar* _tmp892_;
							gchar* _tmp893_;
							ValaUnaryExpression* _tmp894_;
							ValaExpression* _tmp895_;
							ValaExpression* _tmp896_;
							ValaDataType* _tmp897_;
							ValaDataType* _tmp898_;
							ValaParameter* _tmp899_;
							ValaParameter* _tmp900_;
							ValaParameter* _tmp901_;
							ValaMethod* _tmp902_;
							ValaParameter* _tmp903_;
							_tmp892_ = g_strdup_printf ("param%d", param_nr);
							_tmp893_ = _tmp892_;
							_tmp894_ = unary;
							_tmp895_ = vala_unary_expression_get_inner (_tmp894_);
							_tmp896_ = _tmp895_;
							_tmp897_ = vala_expression_get_value_type (_tmp896_);
							_tmp898_ = _tmp897_;
							_tmp899_ = vala_parameter_new (_tmp893_, _tmp898_, NULL);
							_tmp900_ = _tmp899_;
							_g_free0 (_tmp893_);
							param = _tmp900_;
							_tmp901_ = param;
							vala_parameter_set_direction (_tmp901_, VALA_PARAMETER_DIRECTION_REF);
							_tmp902_ = m;
							_tmp903_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp902_, _tmp903_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp904_;
							gchar* _tmp905_;
							gchar* _tmp906_;
							ValaExpression* _tmp907_;
							ValaDataType* _tmp908_;
							ValaDataType* _tmp909_;
							ValaParameter* _tmp910_;
							ValaParameter* _tmp911_;
							_tmp904_ = m;
							_tmp905_ = g_strdup_printf ("param%d", param_nr);
							_tmp906_ = _tmp905_;
							_tmp907_ = arg;
							_tmp908_ = vala_expression_get_value_type (_tmp907_);
							_tmp909_ = _tmp908_;
							_tmp910_ = vala_parameter_new (_tmp906_, _tmp909_, NULL);
							_tmp911_ = _tmp910_;
							vala_callable_add_parameter ((ValaCallable*) _tmp904_, _tmp911_);
							_vala_code_node_unref0 (_tmp911_);
							_g_free0 (_tmp906_);
						}
					}
					_tmp912_ = param_nr;
					param_nr = _tmp912_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp913_;
				ValaList* _tmp914_;
				ValaList* _tmp915_;
				gint _param_size = 0;
				ValaList* _tmp916_;
				gint _tmp917_;
				gint _tmp918_;
				gint _param_index = 0;
				_tmp913_ = m;
				_tmp914_ = vala_callable_get_parameters ((ValaCallable*) _tmp913_);
				_tmp915_ = _vala_iterable_ref0 (_tmp914_);
				_param_list = _tmp915_;
				_tmp916_ = _param_list;
				_tmp917_ = vala_collection_get_size ((ValaCollection*) _tmp916_);
				_tmp918_ = _tmp917_;
				_param_size = _tmp918_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp919_;
					gint _tmp920_;
					ValaParameter* param = NULL;
					ValaList* _tmp921_;
					gpointer _tmp922_;
					ValaParameter* _tmp923_;
					_param_index = _param_index + 1;
					_tmp919_ = _param_index;
					_tmp920_ = _param_size;
					if (!(_tmp919_ < _tmp920_)) {
						break;
					}
					_tmp921_ = _param_list;
					_tmp922_ = vala_list_get (_tmp921_, _param_index);
					param = (ValaParameter*) _tmp922_;
					_tmp923_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp923_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp924_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp924_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp925_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp925_);
		} else {
			gboolean _tmp926_ = FALSE;
			gboolean _tmp927_ = FALSE;
			ValaMethod* _tmp928_;
			_tmp928_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp928_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp929_;
				ValaCodeContext* _tmp930_;
				ValaProfile _tmp931_;
				ValaProfile _tmp932_;
				_tmp929_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp930_ = _tmp929_;
				_tmp931_ = vala_code_context_get_profile (_tmp930_);
				_tmp932_ = _tmp931_;
				_tmp927_ = _tmp932_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp927_ = FALSE;
			}
			if (_tmp927_) {
				ValaMethod* _tmp933_;
				ValaSymbol* _tmp934_;
				ValaSymbol* _tmp935_;
				_tmp933_ = m;
				_tmp934_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp933_);
				_tmp935_ = _tmp934_;
				_tmp926_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp935_, VALA_TYPE_CLASS);
			} else {
				_tmp926_ = FALSE;
			}
			if (_tmp926_) {
				ValaCCodeFunction* _tmp936_;
				ValaCCodeFunction* _tmp937_;
				ValaCCodeExpression* _tmp938_;
				ValaCCodeExpression* _tmp939_;
				ValaCCodeFunctionCall* _tmp940_;
				ValaClass* _tmp941_;
				ValaClass* _tmp942_;
				gchar* _tmp943_;
				gchar* _tmp944_;
				gchar* _tmp945_;
				gchar* _tmp946_;
				ValaCCodeCastExpression* _tmp947_;
				ValaCCodeCastExpression* _tmp948_;
				ValaMethod* _tmp949_;
				ValaMethod* _tmp950_;
				ValaBlock* _tmp951_;
				ValaBlock* _tmp952_;
				gboolean _tmp953_;
				gboolean _tmp954_;
				gboolean _tmp981_ = FALSE;
				ValaClass* _tmp982_;
				ValaClass* _tmp983_;
				gboolean _tmp984_;
				gboolean _tmp985_;
				_tmp936_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp937_ = _tmp936_;
				_tmp938_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp939_ = _tmp938_;
				_tmp940_ = ccall;
				_tmp941_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp942_ = _tmp941_;
				_tmp943_ = vala_get_ccode_name ((ValaCodeNode*) _tmp942_);
				_tmp944_ = _tmp943_;
				_tmp945_ = g_strconcat (_tmp944_, "*", NULL);
				_tmp946_ = _tmp945_;
				_tmp947_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp940_, _tmp946_);
				_tmp948_ = _tmp947_;
				vala_ccode_function_add_assignment (_tmp937_, _tmp939_, (ValaCCodeExpression*) _tmp948_);
				_vala_ccode_node_unref0 (_tmp948_);
				_g_free0 (_tmp946_);
				_g_free0 (_tmp944_);
				_vala_ccode_node_unref0 (_tmp939_);
				_tmp949_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp950_ = _tmp949_;
				_tmp951_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp950_);
				_tmp952_ = _tmp951_;
				_tmp953_ = vala_block_get_captured (_tmp952_);
				_tmp954_ = _tmp953_;
				if (_tmp954_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp955_;
					ValaClass* _tmp956_;
					ValaObjectType* _tmp957_;
					ValaObjectType* _tmp958_;
					ValaSourceReference* _tmp959_;
					ValaSourceReference* _tmp960_;
					ValaCCodeExpression* _tmp961_;
					ValaCCodeExpression* _tmp962_;
					ValaCCodeFunctionCall* _tmp963_;
					ValaCCodeFunctionCall* _tmp964_;
					ValaCCodeFunctionCall* _tmp965_;
					ValaCCodeExpression* _tmp966_;
					ValaCCodeExpression* _tmp967_;
					ValaCCodeFunction* _tmp968_;
					ValaCCodeFunction* _tmp969_;
					ValaMethod* _tmp970_;
					ValaMethod* _tmp971_;
					ValaBlock* _tmp972_;
					ValaBlock* _tmp973_;
					gchar* _tmp974_;
					gchar* _tmp975_;
					ValaCCodeExpression* _tmp976_;
					ValaCCodeExpression* _tmp977_;
					ValaCCodeMemberAccess* _tmp978_;
					ValaCCodeMemberAccess* _tmp979_;
					ValaCCodeFunctionCall* _tmp980_;
					_tmp955_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp956_ = _tmp955_;
					_tmp957_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp956_);
					_tmp958_ = _tmp957_;
					_tmp959_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp960_ = _tmp959_;
					_tmp961_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp958_, _tmp960_, FALSE);
					_tmp962_ = _tmp961_;
					_tmp963_ = vala_ccode_function_call_new (_tmp962_);
					_tmp964_ = _tmp963_;
					_vala_ccode_node_unref0 (_tmp962_);
					_vala_code_node_unref0 (_tmp958_);
					ref_call = _tmp964_;
					_tmp965_ = ref_call;
					_tmp966_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp967_ = _tmp966_;
					vala_ccode_function_call_add_argument (_tmp965_, _tmp967_);
					_vala_ccode_node_unref0 (_tmp967_);
					_tmp968_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp969_ = _tmp968_;
					_tmp970_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp971_ = _tmp970_;
					_tmp972_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp971_);
					_tmp973_ = _tmp972_;
					_tmp974_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp973_));
					_tmp975_ = _tmp974_;
					_tmp976_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp975_);
					_tmp977_ = _tmp976_;
					_tmp978_ = vala_ccode_member_access_new_pointer (_tmp977_, "self");
					_tmp979_ = _tmp978_;
					_tmp980_ = ref_call;
					vala_ccode_function_add_assignment (_tmp969_, (ValaCCodeExpression*) _tmp979_, (ValaCCodeExpression*) _tmp980_);
					_vala_ccode_node_unref0 (_tmp979_);
					_vala_ccode_node_unref0 (_tmp977_);
					_g_free0 (_tmp975_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp982_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp983_ = _tmp982_;
				_tmp984_ = vala_class_get_is_compact (_tmp983_);
				_tmp985_ = _tmp984_;
				if (!_tmp985_) {
					ValaClass* _tmp986_;
					ValaClass* _tmp987_;
					_tmp986_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp987_ = _tmp986_;
					_tmp981_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp987_);
				} else {
					_tmp981_ = FALSE;
				}
				if (_tmp981_) {
					gchar** suffices = NULL;
					gchar* _tmp988_;
					gchar* _tmp989_;
					gchar* _tmp990_;
					gchar** _tmp991_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp988_ = g_strdup ("type");
					_tmp989_ = g_strdup ("dup_func");
					_tmp990_ = g_strdup ("destroy_func");
					_tmp991_ = g_new0 (gchar*, 3 + 1);
					_tmp991_[0] = _tmp988_;
					_tmp991_[1] = _tmp989_;
					_tmp991_[2] = _tmp990_;
					suffices = _tmp991_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp992_;
						ValaClass* _tmp993_;
						ValaList* _tmp994_;
						ValaList* _tmp995_;
						gint _type_param_size = 0;
						ValaList* _tmp996_;
						gint _tmp997_;
						gint _tmp998_;
						gint _type_param_index = 0;
						_tmp992_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp993_ = _tmp992_;
						_tmp994_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp993_);
						_tmp995_ = _vala_iterable_ref0 (_tmp994_);
						_type_param_list = _tmp995_;
						_tmp996_ = _type_param_list;
						_tmp997_ = vala_collection_get_size ((ValaCollection*) _tmp996_);
						_tmp998_ = _tmp997_;
						_type_param_size = _tmp998_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp999_;
							gint _tmp1000_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp1001_;
							gpointer _tmp1002_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp1003_;
							ValaCCodeIdentifier* _tmp1004_;
							ValaCCodeMemberAccess* _tmp1005_;
							ValaCCodeMemberAccess* _tmp1006_;
							gchar** _tmp1007_;
							gint _tmp1007__length1;
							_type_param_index = _type_param_index + 1;
							_tmp999_ = _type_param_index;
							_tmp1000_ = _type_param_size;
							if (!(_tmp999_ < _tmp1000_)) {
								break;
							}
							_tmp1001_ = _type_param_list;
							_tmp1002_ = vala_list_get (_tmp1001_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp1002_;
							_tmp1003_ = vala_ccode_identifier_new ("self");
							_tmp1004_ = _tmp1003_;
							_tmp1005_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1004_, "priv");
							_tmp1006_ = _tmp1005_;
							_vala_ccode_node_unref0 (_tmp1004_);
							priv_access = _tmp1006_;
							_tmp1007_ = suffices;
							_tmp1007__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp1007_;
								suffix_collection_length1 = _tmp1007__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp1008_;
									gchar* suffix = NULL;
									_tmp1008_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp1008_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp1009_;
										const gchar* _tmp1010_;
										const gchar* _tmp1011_;
										gchar* _tmp1012_;
										gchar* _tmp1013_;
										const gchar* _tmp1014_;
										gchar* _tmp1015_;
										gchar* _tmp1016_;
										ValaCCodeIdentifier* _tmp1017_;
										ValaCCodeIdentifier* _tmp1018_;
										ValaCCodeFunction* _tmp1019_;
										ValaCCodeFunction* _tmp1020_;
										ValaCCodeMemberAccess* _tmp1021_;
										ValaCCodeIdentifier* _tmp1022_;
										const gchar* _tmp1023_;
										const gchar* _tmp1024_;
										ValaCCodeMemberAccess* _tmp1025_;
										ValaCCodeMemberAccess* _tmp1026_;
										ValaCCodeIdentifier* _tmp1027_;
										_tmp1009_ = type_param;
										_tmp1010_ = vala_symbol_get_name ((ValaSymbol*) _tmp1009_);
										_tmp1011_ = _tmp1010_;
										_tmp1012_ = g_ascii_strdown (_tmp1011_, (gssize) -1);
										_tmp1013_ = _tmp1012_;
										_tmp1014_ = suffix;
										_tmp1015_ = g_strdup_printf ("%s_%s", _tmp1013_, _tmp1014_);
										_tmp1016_ = _tmp1015_;
										_tmp1017_ = vala_ccode_identifier_new (_tmp1016_);
										_tmp1018_ = _tmp1017_;
										_g_free0 (_tmp1016_);
										_g_free0 (_tmp1013_);
										param_name = _tmp1018_;
										_tmp1019_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp1020_ = _tmp1019_;
										_tmp1021_ = priv_access;
										_tmp1022_ = param_name;
										_tmp1023_ = vala_ccode_identifier_get_name (_tmp1022_);
										_tmp1024_ = _tmp1023_;
										_tmp1025_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1021_, _tmp1024_);
										_tmp1026_ = _tmp1025_;
										_tmp1027_ = param_name;
										vala_ccode_function_add_assignment (_tmp1020_, (ValaCCodeExpression*) _tmp1026_, (ValaCCodeExpression*) _tmp1027_);
										_vala_ccode_node_unref0 (_tmp1026_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp1028_ = params;
	_tmp1029_ = vala_iterable_iterator ((ValaIterable*) _tmp1028_);
	params_it = _tmp1029_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1030_;
		ValaList* _tmp1031_;
		gint _arg_size = 0;
		ValaList* _tmp1032_;
		gint _tmp1033_;
		gint _tmp1034_;
		gint _arg_index = 0;
		_tmp1030_ = vala_method_call_get_argument_list (expr);
		_tmp1031_ = _vala_iterable_ref0 (_tmp1030_);
		_arg_list = _tmp1031_;
		_tmp1032_ = _arg_list;
		_tmp1033_ = vala_collection_get_size ((ValaCollection*) _tmp1032_);
		_tmp1034_ = _tmp1033_;
		_arg_size = _tmp1034_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1035_;
			gint _tmp1036_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1037_;
			gpointer _tmp1038_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp1039_;
			ValaCCodeExpression* _tmp1040_;
			ValaCCodeExpression* _tmp1041_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp1042_;
			ValaHashMap* _tmp1043_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1044_;
			gboolean _tmp1054_ = FALSE;
			ValaParameter* _tmp1055_;
			gdouble _tmp1399_ = 0.0;
			gboolean _tmp1400_ = FALSE;
			ValaParameter* _tmp1401_;
			ValaHashMap* _tmp1403_;
			ValaCCodeExpression* _tmp1404_;
			gboolean _tmp1405_ = FALSE;
			ValaMethod* _tmp1406_;
			gboolean _tmp1431_ = FALSE;
			ValaExpression* _tmp1432_;
			gint _tmp1449_;
			_arg_index = _arg_index + 1;
			_tmp1035_ = _arg_index;
			_tmp1036_ = _arg_size;
			if (!(_tmp1035_ < _tmp1036_)) {
				break;
			}
			_tmp1037_ = _arg_list;
			_tmp1038_ = vala_list_get (_tmp1037_, _arg_index);
			arg = (ValaExpression*) _tmp1038_;
			_tmp1039_ = arg;
			_tmp1040_ = vala_get_cvalue (_tmp1039_);
			_tmp1041_ = _vala_ccode_node_ref0 (_tmp1040_);
			cexpr = _tmp1041_;
			_tmp1042_ = in_arg_map;
			_tmp1043_ = _vala_map_ref0 (_tmp1042_);
			carg_map = _tmp1043_;
			param = NULL;
			_tmp1044_ = params_it;
			if (vala_iterator_next (_tmp1044_)) {
				ValaIterator* _tmp1045_;
				gpointer _tmp1046_;
				gboolean _tmp1047_ = FALSE;
				ValaParameter* _tmp1048_;
				gboolean _tmp1049_;
				gboolean _tmp1050_;
				_tmp1045_ = params_it;
				_tmp1046_ = vala_iterator_get (_tmp1045_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1046_;
				_tmp1048_ = param;
				_tmp1049_ = vala_parameter_get_params_array (_tmp1048_);
				_tmp1050_ = _tmp1049_;
				if (_tmp1050_) {
					_tmp1047_ = TRUE;
				} else {
					ValaParameter* _tmp1051_;
					gboolean _tmp1052_;
					gboolean _tmp1053_;
					_tmp1051_ = param;
					_tmp1052_ = vala_parameter_get_ellipsis (_tmp1051_);
					_tmp1053_ = _tmp1052_;
					_tmp1047_ = _tmp1053_;
				}
				ellipsis = _tmp1047_;
			}
			_tmp1055_ = param;
			if (_tmp1055_ != NULL) {
				_tmp1054_ = !ellipsis;
			} else {
				_tmp1054_ = FALSE;
			}
			if (_tmp1054_) {
				ValaParameter* _tmp1056_;
				ValaParameterDirection _tmp1057_;
				ValaParameterDirection _tmp1058_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1061_;
				ValaUnaryExpression* _tmp1062_;
				gboolean _tmp1063_ = FALSE;
				ValaUnaryExpression* _tmp1064_;
				ValaParameter* _tmp1329_;
				gchar* _tmp1330_;
				gchar* _tmp1331_;
				gboolean _tmp1332_;
				_tmp1056_ = param;
				_tmp1057_ = vala_parameter_get_direction (_tmp1056_);
				_tmp1058_ = _tmp1057_;
				if (_tmp1058_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp1059_;
					ValaHashMap* _tmp1060_;
					_tmp1059_ = out_arg_map;
					_tmp1060_ = _vala_map_ref0 (_tmp1059_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1060_;
				}
				_tmp1061_ = arg;
				_tmp1062_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1061_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1061_) : NULL);
				unary = _tmp1062_;
				_tmp1064_ = unary;
				if (_tmp1064_ == NULL) {
					_tmp1063_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp1065_;
					ValaUnaryOperator _tmp1066_;
					ValaUnaryOperator _tmp1067_;
					_tmp1065_ = unary;
					_tmp1066_ = vala_unary_expression_get_operator (_tmp1065_);
					_tmp1067_ = _tmp1066_;
					_tmp1063_ = _tmp1067_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp1063_) {
					gboolean _tmp1068_ = FALSE;
					gboolean _tmp1069_ = FALSE;
					ValaParameter* _tmp1070_;
					ValaParameter* _tmp1212_;
					ValaExpression* _tmp1213_;
					ValaCCodeExpression* _tmp1214_;
					ValaCCodeExpression* _tmp1215_;
					_tmp1070_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1070_)) {
						ValaParameter* _tmp1071_;
						ValaDataType* _tmp1072_;
						ValaDataType* _tmp1073_;
						_tmp1071_ = param;
						_tmp1072_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1071_);
						_tmp1073_ = _tmp1072_;
						_tmp1069_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1073_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1069_ = FALSE;
					}
					if (_tmp1069_) {
						ValaParameter* _tmp1074_;
						ValaDataType* _tmp1075_;
						ValaDataType* _tmp1076_;
						gboolean _tmp1077_;
						gboolean _tmp1078_;
						_tmp1074_ = param;
						_tmp1075_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1074_);
						_tmp1076_ = _tmp1075_;
						_tmp1077_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1076_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1078_ = _tmp1077_;
						_tmp1068_ = !_tmp1078_;
					} else {
						_tmp1068_ = FALSE;
					}
					if (_tmp1068_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1079_;
						ValaDataType* _tmp1080_;
						ValaDataType* _tmp1081_;
						ValaArrayType* _tmp1082_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1083_;
						gchar* _tmp1084_;
						gboolean _tmp1085_ = FALSE;
						ValaUnaryExpression* _tmp1086_;
						_tmp1079_ = param;
						_tmp1080_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1079_);
						_tmp1081_ = _tmp1080_;
						_tmp1082_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1081_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1082_;
						_tmp1083_ = param;
						_tmp1084_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1083_);
						length_ctype = _tmp1084_;
						_tmp1086_ = unary;
						if (_tmp1086_ != NULL) {
							ValaUnaryExpression* _tmp1087_;
							ValaUnaryOperator _tmp1088_;
							ValaUnaryOperator _tmp1089_;
							_tmp1087_ = unary;
							_tmp1088_ = vala_unary_expression_get_operator (_tmp1087_);
							_tmp1089_ = _tmp1088_;
							_tmp1085_ = _tmp1089_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp1085_ = FALSE;
						}
						if (_tmp1085_) {
							const gchar* _tmp1090_;
							gchar* _tmp1091_;
							_tmp1090_ = length_ctype;
							_tmp1091_ = g_strdup_printf ("%s*", _tmp1090_);
							_g_free0 (length_ctype);
							length_ctype = _tmp1091_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1092_ = FALSE;
								_tmp1092_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1094_;
									gint _tmp1095_;
									gint _tmp1096_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp1097_;
									ValaCCodeExpression* _tmp1098_;
									ValaCCodeExpression* _tmp1099_;
									const gchar* _tmp1100_;
									ValaCCodeCastExpression* _tmp1101_;
									ValaCCodeCastExpression* _tmp1102_;
									ValaHashMap* _tmp1103_;
									ValaParameter* _tmp1104_;
									ValaCCodeCastExpression* _tmp1105_;
									if (!_tmp1092_) {
										gint _tmp1093_;
										_tmp1093_ = dim;
										dim = _tmp1093_ + 1;
									}
									_tmp1092_ = FALSE;
									_tmp1094_ = array_type;
									_tmp1095_ = vala_array_type_get_rank (_tmp1094_);
									_tmp1096_ = _tmp1095_;
									if (!(dim <= _tmp1096_)) {
										break;
									}
									_tmp1097_ = arg;
									_tmp1098_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1097_, dim);
									_tmp1099_ = _tmp1098_;
									_tmp1100_ = length_ctype;
									_tmp1101_ = vala_ccode_cast_expression_new (_tmp1099_, _tmp1100_);
									_tmp1102_ = _tmp1101_;
									_vala_ccode_node_unref0 (_tmp1099_);
									array_length_expr = _tmp1102_;
									_tmp1103_ = carg_map;
									_tmp1104_ = param;
									_tmp1105_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp1103_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1104_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1105_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1106_ = FALSE;
						ValaParameter* _tmp1107_;
						_tmp1107_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1107_)) {
							ValaParameter* _tmp1108_;
							ValaDataType* _tmp1109_;
							ValaDataType* _tmp1110_;
							_tmp1108_ = param;
							_tmp1109_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1108_);
							_tmp1110_ = _tmp1109_;
							_tmp1106_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1110_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1106_ = FALSE;
						}
						if (_tmp1106_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1111_;
							ValaDataType* _tmp1112_;
							ValaDataType* _tmp1113_;
							ValaDelegateType* _tmp1114_;
							ValaDelegateType* _tmp1115_;
							ValaDelegate* _tmp1116_;
							ValaDelegate* _tmp1117_;
							gboolean _tmp1118_;
							gboolean _tmp1119_;
							_tmp1111_ = param;
							_tmp1112_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1111_);
							_tmp1113_ = _tmp1112_;
							_tmp1114_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1113_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1114_;
							_tmp1115_ = deleg_type;
							_tmp1116_ = vala_delegate_type_get_delegate_symbol (_tmp1115_);
							_tmp1117_ = _tmp1116_;
							_tmp1118_ = vala_delegate_get_has_target (_tmp1117_);
							_tmp1119_ = _tmp1118_;
							if (_tmp1119_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp1120_;
								ValaCCodeExpression* _tmp1121_ = NULL;
								ValaCCodeExpression* _tmp1122_;
								ValaCCodeExpression* _tmp1123_;
								ValaParameter* _tmp1124_;
								gchar* _tmp1125_;
								gchar* _tmp1126_;
								gboolean _tmp1127_;
								_tmp1120_ = arg;
								_tmp1122_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1120_, &_tmp1121_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1121_;
								delegate_target = _tmp1122_;
								_tmp1123_ = delegate_target;
								_vala_assert (_tmp1123_ != NULL, "delegate_target != null");
								_tmp1124_ = param;
								_tmp1125_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1124_);
								_tmp1126_ = _tmp1125_;
								_tmp1127_ = g_strcmp0 (_tmp1126_, "GClosure*") == 0;
								_g_free0 (_tmp1126_);
								if (_tmp1127_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1128_;
									ValaCCodeIdentifier* _tmp1129_;
									ValaCCodeFunctionCall* _tmp1130_;
									ValaCCodeFunctionCall* _tmp1131_;
									ValaCCodeFunctionCall* _tmp1132_;
									ValaCCodeExpression* _tmp1133_;
									ValaCCodeCastExpression* _tmp1134_;
									ValaCCodeCastExpression* _tmp1135_;
									ValaCCodeFunctionCall* _tmp1136_;
									ValaCCodeExpression* _tmp1137_;
									ValaCCodeFunctionCall* _tmp1138_;
									ValaCCodeExpression* _tmp1139_;
									ValaCCodeCastExpression* _tmp1140_;
									ValaCCodeCastExpression* _tmp1141_;
									ValaCCodeExpression* _tmp1142_;
									ValaCCodeConstant* _tmp1143_;
									ValaCCodeConstant* _tmp1144_;
									ValaCCodeBinaryExpression* _tmp1145_;
									ValaCCodeBinaryExpression* _tmp1146_;
									ValaCCodeConstant* _tmp1147_;
									ValaCCodeConstant* _tmp1148_;
									ValaCCodeFunctionCall* _tmp1149_;
									ValaCCodeConditionalExpression* _tmp1150_;
									_tmp1128_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1129_ = _tmp1128_;
									_tmp1130_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1129_);
									_tmp1131_ = _tmp1130_;
									_vala_ccode_node_unref0 (_tmp1129_);
									closure_new = _tmp1131_;
									_tmp1132_ = closure_new;
									_tmp1133_ = cexpr;
									_tmp1134_ = vala_ccode_cast_expression_new (_tmp1133_, "GCallback");
									_tmp1135_ = _tmp1134_;
									vala_ccode_function_call_add_argument (_tmp1132_, (ValaCCodeExpression*) _tmp1135_);
									_vala_ccode_node_unref0 (_tmp1135_);
									_tmp1136_ = closure_new;
									_tmp1137_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1136_, _tmp1137_);
									_tmp1138_ = closure_new;
									_tmp1139_ = delegate_target_destroy_notify;
									_tmp1140_ = vala_ccode_cast_expression_new (_tmp1139_, "GClosureNotify");
									_tmp1141_ = _tmp1140_;
									vala_ccode_function_call_add_argument (_tmp1138_, (ValaCCodeExpression*) _tmp1141_);
									_vala_ccode_node_unref0 (_tmp1141_);
									_tmp1142_ = cexpr;
									_tmp1143_ = vala_ccode_constant_new ("NULL");
									_tmp1144_ = _tmp1143_;
									_tmp1145_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1142_, (ValaCCodeExpression*) _tmp1144_);
									_tmp1146_ = _tmp1145_;
									_tmp1147_ = vala_ccode_constant_new ("NULL");
									_tmp1148_ = _tmp1147_;
									_tmp1149_ = closure_new;
									_tmp1150_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1146_, (ValaCCodeExpression*) _tmp1148_, (ValaCCodeExpression*) _tmp1149_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1150_;
									_vala_ccode_node_unref0 (_tmp1148_);
									_vala_ccode_node_unref0 (_tmp1146_);
									_vala_ccode_node_unref0 (_tmp1144_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaCCodeExpression* node = NULL;
									ValaHashMap* _tmp1151_;
									ValaParameter* _tmp1152_;
									gpointer _tmp1153_;
									gboolean _tmp1154_ = FALSE;
									ValaCCodeExpression* _tmp1155_;
									_tmp1151_ = carg_map;
									_tmp1152_ = param;
									_tmp1153_ = vala_map_get ((ValaMap*) _tmp1151_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1152_), FALSE)));
									node = (ValaCCodeExpression*) _tmp1153_;
									_tmp1155_ = node;
									if (_tmp1155_ == NULL) {
										_tmp1154_ = TRUE;
									} else {
										gboolean _tmp1156_ = FALSE;
										ValaCCodeExpression* _tmp1157_;
										_tmp1157_ = node;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1157_, VALA_TYPE_CCODE_CONSTANT)) {
											ValaCCodeExpression* _tmp1158_;
											const gchar* _tmp1159_;
											const gchar* _tmp1160_;
											_tmp1158_ = node;
											_tmp1159_ = vala_ccode_constant_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1158_, VALA_TYPE_CCODE_CONSTANT, ValaCCodeConstant));
											_tmp1160_ = _tmp1159_;
											_tmp1156_ = g_strcmp0 (_tmp1160_, "NULL") == 0;
										} else {
											_tmp1156_ = FALSE;
										}
										_tmp1154_ = _tmp1156_;
									}
									if (_tmp1154_) {
										ValaHashMap* _tmp1161_;
										ValaParameter* _tmp1162_;
										ValaCCodeExpression* _tmp1163_;
										ValaDelegateType* _tmp1164_;
										_tmp1161_ = carg_map;
										_tmp1162_ = param;
										_tmp1163_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1161_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1162_), FALSE)), _tmp1163_);
										_tmp1164_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1164_)) {
											ValaCCodeExpression* _tmp1165_;
											ValaHashMap* _tmp1166_;
											ValaParameter* _tmp1167_;
											ValaCCodeExpression* _tmp1168_;
											_tmp1165_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1165_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1166_ = carg_map;
											_tmp1167_ = param;
											_tmp1168_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1166_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1167_), FALSE)), _tmp1168_);
										}
									}
									_vala_ccode_node_unref0 (node);
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1169_;
							ValaDataType* _tmp1170_;
							ValaDataType* _tmp1171_;
							_tmp1169_ = param;
							_tmp1170_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1169_);
							_tmp1171_ = _tmp1170_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1171_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1172_;
								ValaParameter* _tmp1173_;
								ValaExpression* _tmp1174_;
								ValaCCodeExpression* _tmp1175_ = NULL;
								ValaCCodeExpression* _tmp1176_;
								ValaCCodeExpression* _tmp1177_;
								_tmp1172_ = carg_map;
								_tmp1173_ = param;
								_tmp1174_ = arg;
								_tmp1176_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1174_, &_tmp1175_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1175_;
								_tmp1177_ = _tmp1176_;
								vala_map_set ((ValaMap*) _tmp1172_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1173_), FALSE)), _tmp1177_);
								_vala_ccode_node_unref0 (_tmp1177_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1178_;
								ValaDataType* _tmp1179_;
								ValaDataType* _tmp1180_;
								_tmp1178_ = param;
								_tmp1179_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1178_);
								_tmp1180_ = _tmp1179_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1180_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1181_ = FALSE;
									ValaMethod* _tmp1182_;
									_tmp1182_ = m;
									if (_tmp1182_ != NULL) {
										ValaMethod* _tmp1183_;
										_tmp1183_ = m;
										_tmp1181_ = vala_get_ccode_simple_generics (_tmp1183_);
									} else {
										_tmp1181_ = FALSE;
									}
									if (_tmp1181_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1184_;
										ValaDataType* _tmp1185_;
										ValaDataType* _tmp1186_;
										ValaGenericType* _tmp1187_;
										gint type_param_index = 0;
										ValaMethod* _tmp1188_;
										ValaGenericType* _tmp1189_;
										ValaTypeParameter* _tmp1190_;
										ValaTypeParameter* _tmp1191_;
										const gchar* _tmp1192_;
										const gchar* _tmp1193_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1194_;
										ValaList* _tmp1195_;
										gpointer _tmp1196_;
										ValaParameter* _tmp1197_;
										ValaDataType* _tmp1198_;
										ValaDataType* _tmp1199_;
										gboolean _tmp1200_;
										gboolean _tmp1201_;
										_tmp1184_ = param;
										_tmp1185_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1184_);
										_tmp1186_ = _tmp1185_;
										_tmp1187_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1186_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1187_;
										_tmp1188_ = m;
										_tmp1189_ = generic_type;
										_tmp1190_ = vala_generic_type_get_type_parameter (_tmp1189_);
										_tmp1191_ = _tmp1190_;
										_tmp1192_ = vala_symbol_get_name ((ValaSymbol*) _tmp1191_);
										_tmp1193_ = _tmp1192_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1188_, _tmp1193_);
										_tmp1194_ = ma;
										_tmp1195_ = vala_member_access_get_type_arguments (_tmp1194_);
										_tmp1196_ = vala_list_get (_tmp1195_, type_param_index);
										type_arg = (ValaDataType*) _tmp1196_;
										_tmp1197_ = param;
										_tmp1198_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1197_);
										_tmp1199_ = _tmp1198_;
										_tmp1200_ = vala_data_type_get_value_owned (_tmp1199_);
										_tmp1201_ = _tmp1200_;
										if (_tmp1201_) {
											ValaDataType* _tmp1202_;
											_tmp1202_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1202_)) {
												ValaHashMap* _tmp1203_;
												ValaParameter* _tmp1204_;
												ValaDataType* _tmp1205_;
												ValaCCodeExpression* _tmp1206_;
												ValaCCodeExpression* _tmp1207_;
												_tmp1203_ = carg_map;
												_tmp1204_ = param;
												_tmp1205_ = type_arg;
												_tmp1206_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1205_, FALSE);
												_tmp1207_ = _tmp1206_;
												vala_map_set ((ValaMap*) _tmp1203_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1204_), FALSE)), _tmp1207_);
												_vala_ccode_node_unref0 (_tmp1207_);
											} else {
												ValaHashMap* _tmp1208_;
												ValaParameter* _tmp1209_;
												ValaCCodeConstant* _tmp1210_;
												ValaCCodeConstant* _tmp1211_;
												_tmp1208_ = carg_map;
												_tmp1209_ = param;
												_tmp1210_ = vala_ccode_constant_new ("NULL");
												_tmp1211_ = _tmp1210_;
												vala_map_set ((ValaMap*) _tmp1208_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1209_), FALSE)), (ValaCCodeExpression*) _tmp1211_);
												_vala_ccode_node_unref0 (_tmp1211_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1212_ = param;
					_tmp1213_ = arg;
					_tmp1214_ = cexpr;
					_tmp1215_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1212_, _tmp1213_, _tmp1214_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1215_;
				} else {
					ValaExpression* _tmp1216_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1217_;
					ValaDataType* _tmp1218_;
					ValaDataType* _tmp1219_;
					ValaParameter* _tmp1220_;
					ValaDataType* _tmp1221_;
					ValaDataType* _tmp1222_;
					gboolean _tmp1223_;
					gboolean _tmp1224_;
					ValaLocalVariable* _tmp1225_;
					ValaLocalVariable* _tmp1226_;
					ValaExpression* _tmp1227_;
					ValaLocalVariable* _tmp1228_;
					const gchar* _tmp1229_;
					const gchar* _tmp1230_;
					ValaCCodeExpression* _tmp1231_;
					ValaCCodeExpression* _tmp1232_;
					ValaExpression* _tmp1233_;
					ValaTargetValue* _tmp1234_;
					ValaTargetValue* _tmp1235_;
					ValaExpression* _tmp1236_;
					ValaDataType* _tmp1237_;
					ValaDataType* _tmp1238_;
					ValaExpression* _tmp1239_;
					ValaCCodeExpression* _tmp1240_;
					ValaCCodeUnaryExpression* _tmp1241_;
					gboolean _tmp1242_ = FALSE;
					gboolean _tmp1243_ = FALSE;
					ValaParameter* _tmp1244_;
					_tmp1216_ = arg;
					vala_expression_set_target_value (_tmp1216_, NULL);
					_tmp1217_ = param;
					_tmp1218_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1217_);
					_tmp1219_ = _tmp1218_;
					_tmp1220_ = param;
					_tmp1221_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1220_);
					_tmp1222_ = _tmp1221_;
					_tmp1223_ = vala_data_type_get_value_owned (_tmp1222_);
					_tmp1224_ = _tmp1223_;
					_tmp1225_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1219_, _tmp1224_, NULL, TRUE);
					temp_var = _tmp1225_;
					_tmp1226_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1226_, FALSE);
					_tmp1227_ = arg;
					_tmp1228_ = temp_var;
					_tmp1229_ = vala_symbol_get_name ((ValaSymbol*) _tmp1228_);
					_tmp1230_ = _tmp1229_;
					_tmp1231_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1230_);
					_tmp1232_ = _tmp1231_;
					vala_set_cvalue (_tmp1227_, _tmp1232_);
					_vala_ccode_node_unref0 (_tmp1232_);
					_tmp1233_ = arg;
					_tmp1234_ = vala_expression_get_target_value (_tmp1233_);
					_tmp1235_ = _tmp1234_;
					_tmp1236_ = arg;
					_tmp1237_ = vala_expression_get_target_type (_tmp1236_);
					_tmp1238_ = _tmp1237_;
					vala_target_value_set_value_type (_tmp1235_, _tmp1238_);
					_tmp1239_ = arg;
					_tmp1240_ = vala_get_cvalue (_tmp1239_);
					_tmp1241_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1240_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1241_;
					_tmp1244_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1244_)) {
						ValaParameter* _tmp1245_;
						ValaDataType* _tmp1246_;
						ValaDataType* _tmp1247_;
						_tmp1245_ = param;
						_tmp1246_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1245_);
						_tmp1247_ = _tmp1246_;
						_tmp1243_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1247_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1243_ = FALSE;
					}
					if (_tmp1243_) {
						ValaParameter* _tmp1248_;
						ValaDataType* _tmp1249_;
						ValaDataType* _tmp1250_;
						gboolean _tmp1251_;
						gboolean _tmp1252_;
						_tmp1248_ = param;
						_tmp1249_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1248_);
						_tmp1250_ = _tmp1249_;
						_tmp1251_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1250_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1252_ = _tmp1251_;
						_tmp1242_ = !_tmp1252_;
					} else {
						_tmp1242_ = FALSE;
					}
					if (_tmp1242_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1253_;
						ValaDataType* _tmp1254_;
						ValaDataType* _tmp1255_;
						ValaArrayType* _tmp1256_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1257_;
						gchar* _tmp1258_;
						_tmp1253_ = param;
						_tmp1254_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1253_);
						_tmp1255_ = _tmp1254_;
						_tmp1256_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1255_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1256_;
						_tmp1257_ = param;
						_tmp1258_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1257_);
						length_ctype = _tmp1258_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1259_ = FALSE;
								_tmp1259_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1261_;
									gint _tmp1262_;
									gint _tmp1263_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1264_;
									ValaCType* _tmp1265_;
									ValaCType* _tmp1266_;
									ValaLocalVariable* _tmp1267_;
									ValaLocalVariable* _tmp1268_;
									ValaLocalVariable* _tmp1269_;
									ValaExpression* _tmp1270_;
									ValaLocalVariable* _tmp1271_;
									const gchar* _tmp1272_;
									const gchar* _tmp1273_;
									ValaCCodeExpression* _tmp1274_;
									ValaCCodeExpression* _tmp1275_;
									ValaHashMap* _tmp1276_;
									ValaParameter* _tmp1277_;
									ValaExpression* _tmp1278_;
									ValaList* _tmp1279_;
									gpointer _tmp1280_;
									ValaCCodeExpression* _tmp1281_;
									ValaCCodeUnaryExpression* _tmp1282_;
									ValaCCodeUnaryExpression* _tmp1283_;
									if (!_tmp1259_) {
										gint _tmp1260_;
										_tmp1260_ = dim;
										dim = _tmp1260_ + 1;
									}
									_tmp1259_ = FALSE;
									_tmp1261_ = array_type;
									_tmp1262_ = vala_array_type_get_rank (_tmp1261_);
									_tmp1263_ = _tmp1262_;
									if (!(dim <= _tmp1263_)) {
										break;
									}
									_tmp1264_ = length_ctype;
									_tmp1265_ = vala_ctype_new (_tmp1264_, "0");
									_tmp1266_ = _tmp1265_;
									_tmp1267_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1266_, TRUE, NULL, TRUE);
									_tmp1268_ = _tmp1267_;
									_vala_code_node_unref0 (_tmp1266_);
									temp_array_length = _tmp1268_;
									_tmp1269_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1269_, FALSE);
									_tmp1270_ = arg;
									_tmp1271_ = temp_array_length;
									_tmp1272_ = vala_symbol_get_name ((ValaSymbol*) _tmp1271_);
									_tmp1273_ = _tmp1272_;
									_tmp1274_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1273_);
									_tmp1275_ = _tmp1274_;
									vala_append_array_length (_tmp1270_, _tmp1275_);
									_vala_ccode_node_unref0 (_tmp1275_);
									_tmp1276_ = carg_map;
									_tmp1277_ = param;
									_tmp1278_ = arg;
									_tmp1279_ = vala_get_array_lengths (_tmp1278_);
									_tmp1280_ = vala_list_get (_tmp1279_, dim - 1);
									_tmp1281_ = (ValaCCodeExpression*) _tmp1280_;
									_tmp1282_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1281_);
									_tmp1283_ = _tmp1282_;
									vala_map_set ((ValaMap*) _tmp1276_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1277_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1283_);
									_vala_ccode_node_unref0 (_tmp1283_);
									_vala_ccode_node_unref0 (_tmp1281_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1284_ = FALSE;
						ValaParameter* _tmp1285_;
						_tmp1285_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1285_)) {
							ValaParameter* _tmp1286_;
							ValaDataType* _tmp1287_;
							ValaDataType* _tmp1288_;
							_tmp1286_ = param;
							_tmp1287_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1286_);
							_tmp1288_ = _tmp1287_;
							_tmp1284_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1288_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1284_ = FALSE;
						}
						if (_tmp1284_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1289_;
							ValaDataType* _tmp1290_;
							ValaDataType* _tmp1291_;
							ValaDelegateType* _tmp1292_;
							ValaDelegateType* _tmp1293_;
							ValaDelegate* _tmp1294_;
							ValaDelegate* _tmp1295_;
							gboolean _tmp1296_;
							gboolean _tmp1297_;
							_tmp1289_ = param;
							_tmp1290_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1289_);
							_tmp1291_ = _tmp1290_;
							_tmp1292_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1291_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1292_;
							_tmp1293_ = deleg_type;
							_tmp1294_ = vala_delegate_type_get_delegate_symbol (_tmp1293_);
							_tmp1295_ = _tmp1294_;
							_tmp1296_ = vala_delegate_get_has_target (_tmp1295_);
							_tmp1297_ = _tmp1296_;
							if (_tmp1297_) {
								ValaDataType* _tmp1298_;
								ValaLocalVariable* _tmp1299_;
								ValaLocalVariable* _tmp1300_;
								ValaExpression* _tmp1301_;
								ValaLocalVariable* _tmp1302_;
								const gchar* _tmp1303_;
								const gchar* _tmp1304_;
								ValaCCodeExpression* _tmp1305_;
								ValaCCodeExpression* _tmp1306_;
								ValaHashMap* _tmp1307_;
								ValaParameter* _tmp1308_;
								ValaExpression* _tmp1309_;
								ValaCCodeExpression* _tmp1310_;
								ValaCCodeUnaryExpression* _tmp1311_;
								ValaCCodeUnaryExpression* _tmp1312_;
								ValaDelegateType* _tmp1313_;
								_tmp1298_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
								_tmp1299_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1298_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1299_;
								_tmp1300_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1300_, FALSE);
								_tmp1301_ = arg;
								_tmp1302_ = temp_var;
								_tmp1303_ = vala_symbol_get_name ((ValaSymbol*) _tmp1302_);
								_tmp1304_ = _tmp1303_;
								_tmp1305_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1304_);
								_tmp1306_ = _tmp1305_;
								vala_set_delegate_target (_tmp1301_, _tmp1306_);
								_vala_ccode_node_unref0 (_tmp1306_);
								_tmp1307_ = carg_map;
								_tmp1308_ = param;
								_tmp1309_ = arg;
								_tmp1310_ = vala_get_delegate_target (_tmp1309_);
								_tmp1311_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1310_);
								_tmp1312_ = _tmp1311_;
								vala_map_set ((ValaMap*) _tmp1307_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1308_), FALSE)), (ValaCCodeExpression*) _tmp1312_);
								_vala_ccode_node_unref0 (_tmp1312_);
								_tmp1313_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1313_)) {
									ValaDelegateType* _tmp1314_;
									ValaLocalVariable* _tmp1315_;
									ValaLocalVariable* _tmp1316_;
									ValaExpression* _tmp1317_;
									ValaLocalVariable* _tmp1318_;
									const gchar* _tmp1319_;
									const gchar* _tmp1320_;
									ValaCCodeExpression* _tmp1321_;
									ValaCCodeExpression* _tmp1322_;
									ValaHashMap* _tmp1323_;
									ValaParameter* _tmp1324_;
									ValaExpression* _tmp1325_;
									ValaCCodeExpression* _tmp1326_;
									ValaCCodeUnaryExpression* _tmp1327_;
									ValaCCodeUnaryExpression* _tmp1328_;
									_tmp1314_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
									_tmp1315_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1314_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1315_;
									_tmp1316_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1316_, FALSE);
									_tmp1317_ = arg;
									_tmp1318_ = temp_var;
									_tmp1319_ = vala_symbol_get_name ((ValaSymbol*) _tmp1318_);
									_tmp1320_ = _tmp1319_;
									_tmp1321_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1320_);
									_tmp1322_ = _tmp1321_;
									vala_set_delegate_target_destroy_notify (_tmp1317_, _tmp1322_);
									_vala_ccode_node_unref0 (_tmp1322_);
									_tmp1323_ = carg_map;
									_tmp1324_ = param;
									_tmp1325_ = arg;
									_tmp1326_ = vala_get_delegate_target_destroy_notify (_tmp1325_);
									_tmp1327_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1326_);
									_tmp1328_ = _tmp1327_;
									vala_map_set ((ValaMap*) _tmp1323_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1324_), FALSE)), (ValaCCodeExpression*) _tmp1328_);
									_vala_ccode_node_unref0 (_tmp1328_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1329_ = param;
				_tmp1330_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1329_);
				_tmp1331_ = _tmp1330_;
				_tmp1332_ = _tmp1331_ != NULL;
				_g_free0 (_tmp1331_);
				if (_tmp1332_) {
					ValaCCodeExpression* _tmp1333_;
					ValaParameter* _tmp1334_;
					gchar* _tmp1335_;
					gchar* _tmp1336_;
					ValaCCodeCastExpression* _tmp1337_;
					_tmp1333_ = cexpr;
					_tmp1334_ = param;
					_tmp1335_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1334_);
					_tmp1336_ = _tmp1335_;
					_tmp1337_ = vala_ccode_cast_expression_new (_tmp1333_, _tmp1336_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1337_;
					_g_free0 (_tmp1336_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1338_;
				ValaUnaryExpression* _tmp1339_;
				gboolean _tmp1340_ = FALSE;
				gboolean _tmp1341_ = FALSE;
				_tmp1338_ = arg;
				_tmp1339_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1338_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1338_) : NULL);
				unary = _tmp1339_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1342_;
					_tmp1342_ = unary;
					_tmp1341_ = _tmp1342_ != NULL;
				} else {
					_tmp1341_ = FALSE;
				}
				if (_tmp1341_) {
					ValaUnaryExpression* _tmp1343_;
					ValaUnaryOperator _tmp1344_;
					ValaUnaryOperator _tmp1345_;
					_tmp1343_ = unary;
					_tmp1344_ = vala_unary_expression_get_operator (_tmp1343_);
					_tmp1345_ = _tmp1344_;
					_tmp1340_ = _tmp1345_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1340_ = FALSE;
				}
				if (_tmp1340_) {
					ValaHashMap* _tmp1346_;
					ValaHashMap* _tmp1347_;
					ValaExpression* _tmp1348_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1349_;
					ValaDataType* _tmp1350_;
					ValaDataType* _tmp1351_;
					ValaExpression* _tmp1352_;
					ValaDataType* _tmp1353_;
					ValaDataType* _tmp1354_;
					gboolean _tmp1355_;
					gboolean _tmp1356_;
					ValaLocalVariable* _tmp1357_;
					ValaLocalVariable* _tmp1358_;
					ValaExpression* _tmp1359_;
					ValaLocalVariable* _tmp1360_;
					const gchar* _tmp1361_;
					const gchar* _tmp1362_;
					ValaCCodeExpression* _tmp1363_;
					ValaCCodeExpression* _tmp1364_;
					ValaExpression* _tmp1365_;
					ValaTargetValue* _tmp1366_;
					ValaTargetValue* _tmp1367_;
					ValaExpression* _tmp1368_;
					ValaDataType* _tmp1369_;
					ValaDataType* _tmp1370_;
					gboolean _tmp1371_ = FALSE;
					ValaExpression* _tmp1372_;
					ValaDataType* _tmp1373_;
					ValaDataType* _tmp1374_;
					ValaExpression* _tmp1393_;
					ValaCCodeExpression* _tmp1394_;
					ValaCCodeUnaryExpression* _tmp1395_;
					_tmp1346_ = out_arg_map;
					_tmp1347_ = _vala_map_ref0 (_tmp1346_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1347_;
					_tmp1348_ = arg;
					vala_expression_set_target_value (_tmp1348_, NULL);
					_tmp1349_ = arg;
					_tmp1350_ = vala_expression_get_value_type (_tmp1349_);
					_tmp1351_ = _tmp1350_;
					_tmp1352_ = arg;
					_tmp1353_ = vala_expression_get_value_type (_tmp1352_);
					_tmp1354_ = _tmp1353_;
					_tmp1355_ = vala_data_type_get_value_owned (_tmp1354_);
					_tmp1356_ = _tmp1355_;
					_tmp1357_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1351_, _tmp1356_, NULL, TRUE);
					temp_var = _tmp1357_;
					_tmp1358_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1358_, FALSE);
					_tmp1359_ = arg;
					_tmp1360_ = temp_var;
					_tmp1361_ = vala_symbol_get_name ((ValaSymbol*) _tmp1360_);
					_tmp1362_ = _tmp1361_;
					_tmp1363_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1362_);
					_tmp1364_ = _tmp1363_;
					vala_set_cvalue (_tmp1359_, _tmp1364_);
					_vala_ccode_node_unref0 (_tmp1364_);
					_tmp1365_ = arg;
					_tmp1366_ = vala_expression_get_target_value (_tmp1365_);
					_tmp1367_ = _tmp1366_;
					_tmp1368_ = arg;
					_tmp1369_ = vala_expression_get_value_type (_tmp1368_);
					_tmp1370_ = _tmp1369_;
					vala_target_value_set_value_type (_tmp1367_, _tmp1370_);
					_tmp1372_ = arg;
					_tmp1373_ = vala_expression_get_value_type (_tmp1372_);
					_tmp1374_ = _tmp1373_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1374_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1375_;
						ValaDataType* _tmp1376_;
						ValaDataType* _tmp1377_;
						ValaDelegate* _tmp1378_;
						ValaDelegate* _tmp1379_;
						gboolean _tmp1380_;
						gboolean _tmp1381_;
						_tmp1375_ = arg;
						_tmp1376_ = vala_expression_get_value_type (_tmp1375_);
						_tmp1377_ = _tmp1376_;
						_tmp1378_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1377_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1379_ = _tmp1378_;
						_tmp1380_ = vala_delegate_get_has_target (_tmp1379_);
						_tmp1381_ = _tmp1380_;
						_tmp1371_ = _tmp1381_;
					} else {
						_tmp1371_ = FALSE;
					}
					if (_tmp1371_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1382_;
						ValaTargetValue* _tmp1383_;
						ValaTargetValue* _tmp1384_;
						ValaGLibValue* _tmp1385_;
						ValaCCodeExpression* _tmp1386_;
						ValaGLibValue* _tmp1389_;
						ValaCCodeExpression* _tmp1390_;
						_tmp1382_ = arg;
						_tmp1383_ = vala_expression_get_target_value (_tmp1382_);
						_tmp1384_ = _tmp1383_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1384_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1385_ = arg_value;
						_tmp1386_ = _tmp1385_->delegate_target_cvalue;
						if (_tmp1386_ == NULL) {
							ValaGLibValue* _tmp1387_;
							ValaCCodeConstant* _tmp1388_;
							_tmp1387_ = arg_value;
							_tmp1388_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1387_->delegate_target_cvalue);
							_tmp1387_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1388_;
						}
						_tmp1389_ = arg_value;
						_tmp1390_ = _tmp1389_->delegate_target_destroy_notify_cvalue;
						if (_tmp1390_ == NULL) {
							ValaGLibValue* _tmp1391_;
							ValaCCodeConstant* _tmp1392_;
							_tmp1391_ = arg_value;
							_tmp1392_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1391_->delegate_target_destroy_notify_cvalue);
							_tmp1391_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1392_;
						}
					}
					_tmp1393_ = arg;
					_tmp1394_ = vala_get_cvalue (_tmp1393_);
					_tmp1395_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1394_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1395_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1396_;
					ValaCCodeExpression* _tmp1397_;
					ValaCCodeExpression* _tmp1398_;
					_tmp1396_ = arg;
					_tmp1397_ = cexpr;
					_tmp1398_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1396_, _tmp1397_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1398_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1401_ = param;
			if (_tmp1401_ != NULL) {
				_tmp1400_ = !ellipsis;
			} else {
				_tmp1400_ = FALSE;
			}
			if (_tmp1400_) {
				ValaParameter* _tmp1402_;
				_tmp1402_ = param;
				_tmp1399_ = vala_get_ccode_pos (_tmp1402_);
			} else {
				_tmp1399_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1399_, ellipsis);
			_tmp1403_ = carg_map;
			_tmp1404_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1403_, (gpointer) ((gintptr) arg_pos), _tmp1404_);
			_tmp1406_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1406_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1407_;
				ValaCodeContext* _tmp1408_;
				ValaProfile _tmp1409_;
				ValaProfile _tmp1410_;
				_tmp1407_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1408_ = _tmp1407_;
				_tmp1409_ = vala_code_context_get_profile (_tmp1408_);
				_tmp1410_ = _tmp1409_;
				_tmp1405_ = _tmp1410_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1405_ = FALSE;
			}
			if (_tmp1405_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1411_;
				ValaExpression* _tmp1412_;
				ValaExpression* _tmp1413_;
				ValaDataType* _tmp1414_;
				ValaDataType* _tmp1415_;
				ValaDataType* _tmp1416_;
				ValaDataType* _tmp1417_;
				gchar* _tmp1418_;
				gchar* _tmp1419_;
				gchar* _tmp1420_;
				gchar* _tmp1421_;
				ValaCCodeIdentifier* _tmp1422_;
				ValaCCodeIdentifier* _tmp1423_;
				ValaHashMap* _tmp1424_;
				ValaCCodeIdentifier* _tmp1425_;
				ValaCCodeExpression* _tmp1426_;
				ValaCCodeBinaryExpression* _tmp1427_;
				ValaCCodeBinaryExpression* _tmp1428_;
				_tmp1411_ = ma;
				_tmp1412_ = vala_member_access_get_inner (_tmp1411_);
				_tmp1413_ = _tmp1412_;
				_tmp1414_ = vala_expression_get_value_type (_tmp1413_);
				_tmp1415_ = _tmp1414_;
				_tmp1416_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1415_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1417_ = _tmp1416_;
				_tmp1418_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1417_);
				_tmp1419_ = _tmp1418_;
				_tmp1420_ = g_strdup_printf ("sizeof (%s)", _tmp1419_);
				_tmp1421_ = _tmp1420_;
				_tmp1422_ = vala_ccode_identifier_new (_tmp1421_);
				_tmp1423_ = _tmp1422_;
				_g_free0 (_tmp1421_);
				_g_free0 (_tmp1419_);
				csizeof = _tmp1423_;
				_tmp1424_ = carg_map;
				_tmp1425_ = csizeof;
				_tmp1426_ = cexpr;
				_tmp1427_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1425_, _tmp1426_);
				_tmp1428_ = _tmp1427_;
				vala_map_set ((ValaMap*) _tmp1424_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1428_);
				_vala_ccode_node_unref0 (_tmp1428_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1429_;
				ValaCCodeExpression* _tmp1430_;
				_tmp1429_ = carg_map;
				_tmp1430_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1429_, (gpointer) ((gintptr) arg_pos), _tmp1430_);
			}
			_tmp1432_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1432_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1431_ = ellipsis;
			} else {
				_tmp1431_ = FALSE;
			}
			if (_tmp1431_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1433_;
				ValaNamedArgument* _tmp1434_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1435_;
				const gchar* _tmp1436_;
				const gchar* _tmp1437_;
				gchar** _tmp1438_;
				gchar** _tmp1439_;
				gchar** _tmp1440_;
				gint _tmp1440__length1;
				gchar* _tmp1441_;
				gchar* _tmp1442_;
				ValaHashMap* _tmp1443_;
				const gchar* _tmp1444_;
				gchar* _tmp1445_;
				gchar* _tmp1446_;
				ValaCCodeConstant* _tmp1447_;
				ValaCCodeConstant* _tmp1448_;
				_tmp1433_ = arg;
				_tmp1434_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1433_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1434_;
				_tmp1435_ = named_arg;
				_tmp1436_ = vala_named_argument_get_name (_tmp1435_);
				_tmp1437_ = _tmp1436_;
				_tmp1439_ = _tmp1438_ = g_strsplit (_tmp1437_, "_", 0);
				_tmp1440_ = _tmp1439_;
				_tmp1440__length1 = _vala_array_length (_tmp1438_);
				_tmp1441_ = _vala_g_strjoinv ("-", _tmp1440_, (gint) _vala_array_length (_tmp1438_));
				_tmp1442_ = _tmp1441_;
				_tmp1440_ = (_vala_array_free (_tmp1440_, _tmp1440__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1442_;
				_tmp1443_ = carg_map;
				_tmp1444_ = name;
				_tmp1445_ = g_strdup_printf ("\"%s\"", _tmp1444_);
				_tmp1446_ = _tmp1445_;
				_tmp1447_ = vala_ccode_constant_new (_tmp1446_);
				_tmp1448_ = _tmp1447_;
				vala_map_set ((ValaMap*) _tmp1443_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1448_);
				_vala_ccode_node_unref0 (_tmp1448_);
				_g_free0 (_tmp1446_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1449_ = i;
			i = _tmp1449_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1450_ = params_it;
	if (vala_iterator_next (_tmp1450_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1451_;
		gpointer _tmp1452_;
		gboolean _tmp1453_ = FALSE;
		ValaParameter* _tmp1454_;
		gboolean _tmp1455_;
		gboolean _tmp1456_;
		_tmp1451_ = params_it;
		_tmp1452_ = vala_iterator_get (_tmp1451_);
		param = (ValaParameter*) _tmp1452_;
		_tmp1454_ = param;
		_tmp1455_ = vala_parameter_get_params_array (_tmp1454_);
		_tmp1456_ = _tmp1455_;
		if (_tmp1456_) {
			_tmp1453_ = TRUE;
		} else {
			ValaParameter* _tmp1457_;
			gboolean _tmp1458_;
			gboolean _tmp1459_;
			_tmp1457_ = param;
			_tmp1458_ = vala_parameter_get_ellipsis (_tmp1457_);
			_tmp1459_ = _tmp1458_;
			_tmp1453_ = _tmp1459_;
		}
		_vala_assert (_tmp1453_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1462_ = m;
	if (_tmp1462_ != NULL) {
		ValaMethod* _tmp1463_;
		ValaDataType* _tmp1464_;
		ValaDataType* _tmp1465_;
		_tmp1463_ = m;
		_tmp1464_ = vala_callable_get_return_type ((ValaCallable*) _tmp1463_);
		_tmp1465_ = _tmp1464_;
		_tmp1461_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1465_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1461_ = FALSE;
	}
	if (_tmp1461_) {
		ValaCCodeFunctionCall* _tmp1466_;
		ValaCCodeFunctionCall* _tmp1467_;
		_tmp1466_ = async_call;
		_tmp1467_ = ccall;
		_tmp1460_ = _tmp1466_ != _tmp1467_;
	} else {
		_tmp1460_ = FALSE;
	}
	if (_tmp1460_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1468_;
		ValaDataType* _tmp1469_;
		ValaDataType* _tmp1470_;
		ValaArrayType* _tmp1471_;
		_tmp1468_ = m;
		_tmp1469_ = vala_callable_get_return_type ((ValaCallable*) _tmp1468_);
		_tmp1470_ = _tmp1469_;
		_tmp1471_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1470_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1471_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1472_ = FALSE;
				_tmp1472_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1474_;
					gint _tmp1475_;
					gint _tmp1476_;
					ValaMethod* _tmp1477_;
					if (!_tmp1472_) {
						gint _tmp1473_;
						_tmp1473_ = dim;
						dim = _tmp1473_ + 1;
					}
					_tmp1472_ = FALSE;
					_tmp1474_ = array_type;
					_tmp1475_ = vala_array_type_get_rank (_tmp1474_);
					_tmp1476_ = _tmp1475_;
					if (!(dim <= _tmp1476_)) {
						break;
					}
					_tmp1477_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1477_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1478_;
						ValaDataType* _tmp1479_;
						ValaLocalVariable* _tmp1480_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1481_;
						const gchar* _tmp1482_;
						const gchar* _tmp1483_;
						ValaCCodeExpression* _tmp1484_;
						ValaLocalVariable* _tmp1485_;
						ValaCCodeExpression* _tmp1486_;
						ValaCCodeExpression* _tmp1487_;
						ValaCCodeAssignment* _tmp1488_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1489_;
						ValaCCodeIdentifier* _tmp1490_;
						ValaCCodeFunctionCall* _tmp1491_;
						ValaCCodeFunctionCall* _tmp1492_;
						ValaCCodeFunctionCall* _tmp1493_;
						ValaCCodeExpression* _tmp1494_;
						ValaCCodeFunctionCall* _tmp1495_;
						_tmp1478_ = itype;
						_tmp1479_ = vala_data_type_get_return_type (_tmp1478_);
						_tmp1480_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1479_, TRUE, NULL, FALSE);
						temp_var = _tmp1480_;
						_tmp1481_ = temp_var;
						_tmp1482_ = vala_symbol_get_name ((ValaSymbol*) _tmp1481_);
						_tmp1483_ = _tmp1482_;
						_tmp1484_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1483_);
						temp_ref = _tmp1484_;
						_tmp1485_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1485_, FALSE);
						_tmp1486_ = temp_ref;
						_tmp1487_ = ccall_expr;
						_tmp1488_ = vala_ccode_assignment_new (_tmp1486_, _tmp1487_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1488_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1489_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1490_ = _tmp1489_;
						_tmp1491_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1490_);
						_tmp1492_ = _tmp1491_;
						_vala_ccode_node_unref0 (_tmp1490_);
						len_call = _tmp1492_;
						_tmp1493_ = len_call;
						_tmp1494_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1493_, _tmp1494_);
						_tmp1495_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1495_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1496_;
						_tmp1496_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1496_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1497_;
							gchar* _tmp1498_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1499_;
							ValaCType* _tmp1500_;
							ValaCType* _tmp1501_;
							ValaLocalVariable* _tmp1502_;
							ValaLocalVariable* _tmp1503_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1504_;
							const gchar* _tmp1505_;
							const gchar* _tmp1506_;
							ValaCCodeExpression* _tmp1507_;
							ValaLocalVariable* _tmp1508_;
							ValaHashMap* _tmp1509_;
							ValaMethod* _tmp1510_;
							ValaCCodeExpression* _tmp1511_;
							ValaCCodeUnaryExpression* _tmp1512_;
							ValaCCodeUnaryExpression* _tmp1513_;
							ValaCCodeExpression* _tmp1514_;
							_tmp1497_ = m;
							_tmp1498_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1497_);
							length_ctype = _tmp1498_;
							_tmp1499_ = length_ctype;
							_tmp1500_ = vala_ctype_new (_tmp1499_, "0");
							_tmp1501_ = _tmp1500_;
							_tmp1502_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1501_, TRUE, NULL, TRUE);
							_tmp1503_ = _tmp1502_;
							_vala_code_node_unref0 (_tmp1501_);
							temp_var = _tmp1503_;
							_tmp1504_ = temp_var;
							_tmp1505_ = vala_symbol_get_name ((ValaSymbol*) _tmp1504_);
							_tmp1506_ = _tmp1505_;
							_tmp1507_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1506_);
							temp_ref = _tmp1507_;
							_tmp1508_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1508_, FALSE);
							_tmp1509_ = out_arg_map;
							_tmp1510_ = m;
							_tmp1511_ = temp_ref;
							_tmp1512_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1511_);
							_tmp1513_ = _tmp1512_;
							vala_map_set ((ValaMap*) _tmp1509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1510_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1513_);
							_vala_ccode_node_unref0 (_tmp1513_);
							_tmp1514_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1514_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1515_;
							gchar* _tmp1516_;
							gchar* _tmp1517_;
							gboolean _tmp1518_;
							_tmp1515_ = m;
							_tmp1516_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1515_);
							_tmp1517_ = _tmp1516_;
							_tmp1518_ = _tmp1517_ != NULL;
							_g_free0 (_tmp1517_);
							if (_tmp1518_) {
								ValaMethod* _tmp1519_;
								gchar* _tmp1520_;
								gchar* _tmp1521_;
								ValaCCodeConstant* _tmp1522_;
								ValaCCodeConstant* _tmp1523_;
								_tmp1519_ = m;
								_tmp1520_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1519_);
								_tmp1521_ = _tmp1520_;
								_tmp1522_ = vala_ccode_constant_new (_tmp1521_);
								_tmp1523_ = _tmp1522_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1523_);
								_vala_ccode_node_unref0 (_tmp1523_);
								_g_free0 (_tmp1521_);
							} else {
								ValaCCodeConstant* _tmp1524_;
								ValaCCodeConstant* _tmp1525_;
								_tmp1524_ = vala_ccode_constant_new ("-1");
								_tmp1525_ = _tmp1524_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1525_);
								_vala_ccode_node_unref0 (_tmp1525_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1526_ = FALSE;
		gboolean _tmp1527_ = FALSE;
		ValaMethod* _tmp1528_;
		_tmp1528_ = m;
		if (_tmp1528_ != NULL) {
			ValaMethod* _tmp1529_;
			ValaDataType* _tmp1530_;
			ValaDataType* _tmp1531_;
			_tmp1529_ = m;
			_tmp1530_ = vala_callable_get_return_type ((ValaCallable*) _tmp1529_);
			_tmp1531_ = _tmp1530_;
			_tmp1527_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1531_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1527_ = FALSE;
		}
		if (_tmp1527_) {
			ValaCCodeFunctionCall* _tmp1532_;
			ValaCCodeFunctionCall* _tmp1533_;
			_tmp1532_ = async_call;
			_tmp1533_ = ccall;
			_tmp1526_ = _tmp1532_ != _tmp1533_;
		} else {
			_tmp1526_ = FALSE;
		}
		if (_tmp1526_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1534_;
			ValaDataType* _tmp1535_;
			ValaDataType* _tmp1536_;
			ValaDelegateType* _tmp1537_;
			gboolean _tmp1538_ = FALSE;
			ValaMethod* _tmp1539_;
			_tmp1534_ = m;
			_tmp1535_ = vala_callable_get_return_type ((ValaCallable*) _tmp1534_);
			_tmp1536_ = _tmp1535_;
			_tmp1537_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1536_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1537_;
			_tmp1539_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1539_)) {
				ValaDelegateType* _tmp1540_;
				ValaDelegate* _tmp1541_;
				ValaDelegate* _tmp1542_;
				gboolean _tmp1543_;
				gboolean _tmp1544_;
				_tmp1540_ = deleg_type;
				_tmp1541_ = vala_delegate_type_get_delegate_symbol (_tmp1540_);
				_tmp1542_ = _tmp1541_;
				_tmp1543_ = vala_delegate_get_has_target (_tmp1542_);
				_tmp1544_ = _tmp1543_;
				_tmp1538_ = _tmp1544_;
			} else {
				_tmp1538_ = FALSE;
			}
			if (_tmp1538_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1545_;
				ValaLocalVariable* _tmp1546_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1547_;
				const gchar* _tmp1548_;
				const gchar* _tmp1549_;
				ValaCCodeExpression* _tmp1550_;
				ValaLocalVariable* _tmp1551_;
				ValaHashMap* _tmp1552_;
				ValaMethod* _tmp1553_;
				ValaCCodeExpression* _tmp1554_;
				ValaCCodeUnaryExpression* _tmp1555_;
				ValaCCodeUnaryExpression* _tmp1556_;
				ValaCCodeExpression* _tmp1557_;
				ValaDelegateType* _tmp1558_;
				_tmp1545_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1546_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1545_, TRUE, NULL, TRUE);
				temp_var = _tmp1546_;
				_tmp1547_ = temp_var;
				_tmp1548_ = vala_symbol_get_name ((ValaSymbol*) _tmp1547_);
				_tmp1549_ = _tmp1548_;
				_tmp1550_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1549_);
				temp_ref = _tmp1550_;
				_tmp1551_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1551_, FALSE);
				_tmp1552_ = out_arg_map;
				_tmp1553_ = m;
				_tmp1554_ = temp_ref;
				_tmp1555_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1554_);
				_tmp1556_ = _tmp1555_;
				vala_map_set ((ValaMap*) _tmp1552_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1553_), FALSE)), (ValaCCodeExpression*) _tmp1556_);
				_vala_ccode_node_unref0 (_tmp1556_);
				_tmp1557_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1557_);
				_tmp1558_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1558_)) {
					ValaDelegateType* _tmp1559_;
					ValaLocalVariable* _tmp1560_;
					ValaLocalVariable* _tmp1561_;
					const gchar* _tmp1562_;
					const gchar* _tmp1563_;
					ValaCCodeExpression* _tmp1564_;
					ValaLocalVariable* _tmp1565_;
					ValaHashMap* _tmp1566_;
					ValaMethod* _tmp1567_;
					ValaCCodeExpression* _tmp1568_;
					ValaCCodeUnaryExpression* _tmp1569_;
					ValaCCodeUnaryExpression* _tmp1570_;
					ValaCCodeExpression* _tmp1571_;
					_tmp1559_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1560_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1559_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1560_;
					_tmp1561_ = temp_var;
					_tmp1562_ = vala_symbol_get_name ((ValaSymbol*) _tmp1561_);
					_tmp1563_ = _tmp1562_;
					_tmp1564_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1563_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1564_;
					_tmp1565_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1565_, FALSE);
					_tmp1566_ = out_arg_map;
					_tmp1567_ = m;
					_tmp1568_ = temp_ref;
					_tmp1569_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1568_);
					_tmp1570_ = _tmp1569_;
					vala_map_set ((ValaMap*) _tmp1566_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1567_), FALSE)), (ValaCCodeExpression*) _tmp1570_);
					_vala_ccode_node_unref0 (_tmp1570_);
					_tmp1571_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1571_);
				} else {
					ValaCCodeConstant* _tmp1572_;
					ValaCCodeConstant* _tmp1573_;
					_tmp1572_ = vala_ccode_constant_new ("NULL");
					_tmp1573_ = _tmp1572_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1573_);
					_vala_ccode_node_unref0 (_tmp1573_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1574_;
				ValaCCodeConstant* _tmp1575_;
				ValaDelegateType* _tmp1576_;
				ValaDelegate* _tmp1577_;
				ValaDelegate* _tmp1578_;
				gboolean _tmp1579_;
				gboolean _tmp1580_;
				_tmp1574_ = vala_ccode_constant_new ("NULL");
				_tmp1575_ = _tmp1574_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1575_);
				_vala_ccode_node_unref0 (_tmp1575_);
				_tmp1576_ = deleg_type;
				_tmp1577_ = vala_delegate_type_get_delegate_symbol (_tmp1576_);
				_tmp1578_ = _tmp1577_;
				_tmp1579_ = vala_delegate_get_has_target (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				if (_tmp1580_) {
					ValaCCodeConstant* _tmp1581_;
					ValaCCodeConstant* _tmp1582_;
					_tmp1581_ = vala_ccode_constant_new ("NULL");
					_tmp1582_ = _tmp1581_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1582_);
					_vala_ccode_node_unref0 (_tmp1582_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1584_ = deleg;
	if (_tmp1584_ != NULL) {
		ValaDelegate* _tmp1585_;
		ValaDataType* _tmp1586_;
		ValaDataType* _tmp1587_;
		_tmp1585_ = deleg;
		_tmp1586_ = vala_callable_get_return_type ((ValaCallable*) _tmp1585_);
		_tmp1587_ = _tmp1586_;
		_tmp1583_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1587_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1583_ = FALSE;
	}
	if (_tmp1583_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1588_;
		ValaDataType* _tmp1589_;
		ValaDataType* _tmp1590_;
		ValaArrayType* _tmp1591_;
		_tmp1588_ = deleg;
		_tmp1589_ = vala_callable_get_return_type ((ValaCallable*) _tmp1588_);
		_tmp1590_ = _tmp1589_;
		_tmp1591_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1590_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1591_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1592_ = FALSE;
				_tmp1592_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1594_;
					gint _tmp1595_;
					gint _tmp1596_;
					ValaDelegate* _tmp1597_;
					if (!_tmp1592_) {
						gint _tmp1593_;
						_tmp1593_ = dim;
						dim = _tmp1593_ + 1;
					}
					_tmp1592_ = FALSE;
					_tmp1594_ = array_type;
					_tmp1595_ = vala_array_type_get_rank (_tmp1594_);
					_tmp1596_ = _tmp1595_;
					if (!(dim <= _tmp1596_)) {
						break;
					}
					_tmp1597_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1597_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1598_;
						ValaDataType* _tmp1599_;
						ValaLocalVariable* _tmp1600_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1601_;
						const gchar* _tmp1602_;
						const gchar* _tmp1603_;
						ValaCCodeExpression* _tmp1604_;
						ValaLocalVariable* _tmp1605_;
						ValaCCodeExpression* _tmp1606_;
						ValaCCodeExpression* _tmp1607_;
						ValaCCodeAssignment* _tmp1608_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1609_;
						ValaCCodeIdentifier* _tmp1610_;
						ValaCCodeFunctionCall* _tmp1611_;
						ValaCCodeFunctionCall* _tmp1612_;
						ValaCCodeFunctionCall* _tmp1613_;
						ValaCCodeExpression* _tmp1614_;
						ValaCCodeFunctionCall* _tmp1615_;
						_tmp1598_ = itype;
						_tmp1599_ = vala_data_type_get_return_type (_tmp1598_);
						_tmp1600_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1599_, TRUE, NULL, FALSE);
						temp_var = _tmp1600_;
						_tmp1601_ = temp_var;
						_tmp1602_ = vala_symbol_get_name ((ValaSymbol*) _tmp1601_);
						_tmp1603_ = _tmp1602_;
						_tmp1604_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1603_);
						temp_ref = _tmp1604_;
						_tmp1605_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1605_, FALSE);
						_tmp1606_ = temp_ref;
						_tmp1607_ = ccall_expr;
						_tmp1608_ = vala_ccode_assignment_new (_tmp1606_, _tmp1607_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1608_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1609_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1610_ = _tmp1609_;
						_tmp1611_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1610_);
						_tmp1612_ = _tmp1611_;
						_vala_ccode_node_unref0 (_tmp1610_);
						len_call = _tmp1612_;
						_tmp1613_ = len_call;
						_tmp1614_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1613_, _tmp1614_);
						_tmp1615_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1615_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1616_;
						_tmp1616_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1616_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1617_;
							gchar* _tmp1618_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1619_;
							ValaCType* _tmp1620_;
							ValaCType* _tmp1621_;
							ValaLocalVariable* _tmp1622_;
							ValaLocalVariable* _tmp1623_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1624_;
							const gchar* _tmp1625_;
							const gchar* _tmp1626_;
							ValaCCodeExpression* _tmp1627_;
							ValaLocalVariable* _tmp1628_;
							ValaHashMap* _tmp1629_;
							ValaDelegate* _tmp1630_;
							ValaCCodeExpression* _tmp1631_;
							ValaCCodeUnaryExpression* _tmp1632_;
							ValaCCodeUnaryExpression* _tmp1633_;
							ValaCCodeExpression* _tmp1634_;
							_tmp1617_ = deleg;
							_tmp1618_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1617_);
							length_ctype = _tmp1618_;
							_tmp1619_ = length_ctype;
							_tmp1620_ = vala_ctype_new (_tmp1619_, "0");
							_tmp1621_ = _tmp1620_;
							_tmp1622_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1621_, TRUE, NULL, TRUE);
							_tmp1623_ = _tmp1622_;
							_vala_code_node_unref0 (_tmp1621_);
							temp_var = _tmp1623_;
							_tmp1624_ = temp_var;
							_tmp1625_ = vala_symbol_get_name ((ValaSymbol*) _tmp1624_);
							_tmp1626_ = _tmp1625_;
							_tmp1627_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1626_);
							temp_ref = _tmp1627_;
							_tmp1628_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1628_, FALSE);
							_tmp1629_ = out_arg_map;
							_tmp1630_ = deleg;
							_tmp1631_ = temp_ref;
							_tmp1632_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1631_);
							_tmp1633_ = _tmp1632_;
							vala_map_set ((ValaMap*) _tmp1629_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1630_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1633_);
							_vala_ccode_node_unref0 (_tmp1633_);
							_tmp1634_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1634_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1635_;
							ValaCCodeConstant* _tmp1636_;
							_tmp1635_ = vala_ccode_constant_new ("-1");
							_tmp1636_ = _tmp1635_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1636_);
							_vala_ccode_node_unref0 (_tmp1636_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1637_ = FALSE;
		gboolean _tmp1638_ = FALSE;
		ValaDelegate* _tmp1639_;
		_tmp1639_ = deleg;
		if (_tmp1639_ != NULL) {
			ValaDelegate* _tmp1640_;
			ValaDataType* _tmp1641_;
			ValaDataType* _tmp1642_;
			_tmp1640_ = deleg;
			_tmp1641_ = vala_callable_get_return_type ((ValaCallable*) _tmp1640_);
			_tmp1642_ = _tmp1641_;
			_tmp1638_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1642_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1638_ = FALSE;
		}
		if (_tmp1638_) {
			ValaDelegate* _tmp1643_;
			_tmp1643_ = deleg;
			_tmp1637_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1643_);
		} else {
			_tmp1637_ = FALSE;
		}
		if (_tmp1637_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1644_;
			ValaDataType* _tmp1645_;
			ValaDataType* _tmp1646_;
			ValaDelegateType* _tmp1647_;
			ValaDelegateType* _tmp1648_;
			ValaDelegate* _tmp1649_;
			ValaDelegate* _tmp1650_;
			gboolean _tmp1651_;
			gboolean _tmp1652_;
			_tmp1644_ = deleg;
			_tmp1645_ = vala_callable_get_return_type ((ValaCallable*) _tmp1644_);
			_tmp1646_ = _tmp1645_;
			_tmp1647_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1646_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1647_;
			_tmp1648_ = deleg_type;
			_tmp1649_ = vala_delegate_type_get_delegate_symbol (_tmp1648_);
			_tmp1650_ = _tmp1649_;
			_tmp1651_ = vala_delegate_get_has_target (_tmp1650_);
			_tmp1652_ = _tmp1651_;
			if (_tmp1652_) {
				ValaLocalVariable* temp_var = NULL;
				ValaDataType* _tmp1653_;
				ValaLocalVariable* _tmp1654_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1655_;
				const gchar* _tmp1656_;
				const gchar* _tmp1657_;
				ValaCCodeExpression* _tmp1658_;
				ValaLocalVariable* _tmp1659_;
				ValaHashMap* _tmp1660_;
				ValaDelegate* _tmp1661_;
				ValaCCodeExpression* _tmp1662_;
				ValaCCodeUnaryExpression* _tmp1663_;
				ValaCCodeUnaryExpression* _tmp1664_;
				ValaCCodeExpression* _tmp1665_;
				ValaDelegateType* _tmp1666_;
				_tmp1653_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
				_tmp1654_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1653_, TRUE, NULL, TRUE);
				temp_var = _tmp1654_;
				_tmp1655_ = temp_var;
				_tmp1656_ = vala_symbol_get_name ((ValaSymbol*) _tmp1655_);
				_tmp1657_ = _tmp1656_;
				_tmp1658_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1657_);
				temp_ref = _tmp1658_;
				_tmp1659_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1659_, FALSE);
				_tmp1660_ = out_arg_map;
				_tmp1661_ = deleg;
				_tmp1662_ = temp_ref;
				_tmp1663_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1662_);
				_tmp1664_ = _tmp1663_;
				vala_map_set ((ValaMap*) _tmp1660_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1661_), FALSE)), (ValaCCodeExpression*) _tmp1664_);
				_vala_ccode_node_unref0 (_tmp1664_);
				_tmp1665_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1665_);
				_tmp1666_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1666_)) {
					ValaDelegateType* _tmp1667_;
					ValaLocalVariable* _tmp1668_;
					ValaLocalVariable* _tmp1669_;
					const gchar* _tmp1670_;
					const gchar* _tmp1671_;
					ValaCCodeExpression* _tmp1672_;
					ValaLocalVariable* _tmp1673_;
					ValaHashMap* _tmp1674_;
					ValaDelegate* _tmp1675_;
					ValaCCodeExpression* _tmp1676_;
					ValaCCodeUnaryExpression* _tmp1677_;
					ValaCCodeUnaryExpression* _tmp1678_;
					ValaCCodeExpression* _tmp1679_;
					_tmp1667_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
					_tmp1668_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1667_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1668_;
					_tmp1669_ = temp_var;
					_tmp1670_ = vala_symbol_get_name ((ValaSymbol*) _tmp1669_);
					_tmp1671_ = _tmp1670_;
					_tmp1672_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1671_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1672_;
					_tmp1673_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1673_, FALSE);
					_tmp1674_ = out_arg_map;
					_tmp1675_ = deleg;
					_tmp1676_ = temp_ref;
					_tmp1677_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1676_);
					_tmp1678_ = _tmp1677_;
					vala_map_set ((ValaMap*) _tmp1674_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1675_), FALSE)), (ValaCCodeExpression*) _tmp1678_);
					_vala_ccode_node_unref0 (_tmp1678_);
					_tmp1679_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1679_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1681_ = m;
	if (_tmp1681_ != NULL) {
		ValaMethod* _tmp1682_;
		gboolean _tmp1683_;
		gboolean _tmp1684_;
		_tmp1682_ = m;
		_tmp1683_ = vala_method_get_coroutine (_tmp1682_);
		_tmp1684_ = _tmp1683_;
		_tmp1680_ = _tmp1684_;
	} else {
		_tmp1680_ = FALSE;
	}
	if (_tmp1680_) {
		gboolean _tmp1685_;
		gboolean _tmp1686_;
		_tmp1685_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1686_ = _tmp1685_;
		if (_tmp1686_) {
			ValaHashMap* _tmp1687_;
			ValaMethod* _tmp1688_;
			ValaMethod* _tmp1689_;
			gchar* _tmp1690_;
			gchar* _tmp1691_;
			ValaCCodeIdentifier* _tmp1692_;
			ValaCCodeIdentifier* _tmp1693_;
			ValaHashMap* _tmp1694_;
			ValaCCodeIdentifier* _tmp1695_;
			ValaCCodeIdentifier* _tmp1696_;
			_tmp1687_ = in_arg_map;
			_tmp1688_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1689_ = _tmp1688_;
			_tmp1690_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1689_);
			_tmp1691_ = _tmp1690_;
			_tmp1692_ = vala_ccode_identifier_new (_tmp1691_);
			_tmp1693_ = _tmp1692_;
			vala_map_set ((ValaMap*) _tmp1687_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1693_);
			_vala_ccode_node_unref0 (_tmp1693_);
			_g_free0 (_tmp1691_);
			_tmp1694_ = in_arg_map;
			_tmp1695_ = vala_ccode_identifier_new ("_data_");
			_tmp1696_ = _tmp1695_;
			vala_map_set ((ValaMap*) _tmp1694_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1696_);
			_vala_ccode_node_unref0 (_tmp1696_);
		}
	}
	_tmp1697_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1698_ = _tmp1697_;
	if (_tmp1698_) {
		ValaCallable* _tmp1699_ = NULL;
		ValaMethod* _tmp1700_;
		ValaHashMap* _tmp1702_;
		ValaCCodeExpression* _tmp1703_;
		ValaCCodeExpression* _tmp1704_;
		ValaCCodeUnaryExpression* _tmp1705_;
		ValaCCodeUnaryExpression* _tmp1706_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1700_ = m;
		_tmp1699_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1700_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1699_ == NULL) {
			ValaDelegate* _tmp1701_;
			_tmp1701_ = deleg;
			_tmp1699_ = (ValaCallable*) _tmp1701_;
		}
		_tmp1702_ = out_arg_map;
		_tmp1703_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1704_ = _tmp1703_;
		_tmp1705_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1704_);
		_tmp1706_ = _tmp1705_;
		vala_map_set ((ValaMap*) _tmp1702_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1699_), FALSE)), (ValaCCodeExpression*) _tmp1706_);
		_vala_ccode_node_unref0 (_tmp1706_);
		_vala_ccode_node_unref0 (_tmp1704_);
	} else {
		gboolean _tmp1707_ = FALSE;
		gboolean _tmp1708_ = FALSE;
		ValaMethod* _tmp1709_;
		_tmp1709_ = m;
		if (_tmp1709_ != NULL) {
			ValaMethod* _tmp1710_;
			_tmp1710_ = m;
			_tmp1708_ = vala_method_has_error_type_parameter (_tmp1710_);
		} else {
			_tmp1708_ = FALSE;
		}
		if (_tmp1708_) {
			ValaCCodeFunctionCall* _tmp1711_;
			ValaCCodeFunctionCall* _tmp1712_;
			_tmp1711_ = async_call;
			_tmp1712_ = ccall;
			_tmp1707_ = _tmp1711_ != _tmp1712_;
		} else {
			_tmp1707_ = FALSE;
		}
		if (_tmp1707_) {
			ValaHashMap* _tmp1713_;
			ValaMethod* _tmp1714_;
			ValaCCodeConstant* _tmp1715_;
			ValaCCodeConstant* _tmp1716_;
			_tmp1713_ = out_arg_map;
			_tmp1714_ = m;
			_tmp1715_ = vala_ccode_constant_new ("NULL");
			_tmp1716_ = _tmp1715_;
			vala_map_set ((ValaMap*) _tmp1713_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1714_), FALSE)), (ValaCCodeExpression*) _tmp1716_);
			_vala_ccode_node_unref0 (_tmp1716_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1717_;
		_tmp1717_ = m;
		if (_tmp1717_ == NULL) {
			ValaHashMap* _tmp1718_;
			ValaCCodeConstant* _tmp1719_;
			ValaCCodeConstant* _tmp1720_;
			_tmp1718_ = in_arg_map;
			_tmp1719_ = vala_ccode_constant_new ("NULL");
			_tmp1720_ = _tmp1719_;
			vala_map_set ((ValaMap*) _tmp1718_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1720_);
			_vala_ccode_node_unref0 (_tmp1720_);
		} else {
			gboolean _tmp1721_ = FALSE;
			gboolean _tmp1722_ = FALSE;
			gboolean _tmp1723_ = FALSE;
			ValaMethod* _tmp1724_;
			gboolean _tmp1725_;
			gboolean _tmp1726_;
			_tmp1724_ = m;
			_tmp1725_ = vala_method_get_printf_format (_tmp1724_);
			_tmp1726_ = _tmp1725_;
			if (!_tmp1726_) {
				ValaMethod* _tmp1727_;
				gboolean _tmp1728_;
				gboolean _tmp1729_;
				_tmp1727_ = m;
				_tmp1728_ = vala_method_get_scanf_format (_tmp1727_);
				_tmp1729_ = _tmp1728_;
				_tmp1723_ = !_tmp1729_;
			} else {
				_tmp1723_ = FALSE;
			}
			if (_tmp1723_) {
				ValaMethod* _tmp1730_;
				gchar* _tmp1731_;
				gchar* _tmp1732_;
				_tmp1730_ = m;
				_tmp1731_ = vala_get_ccode_sentinel (_tmp1730_);
				_tmp1732_ = _tmp1731_;
				_tmp1722_ = g_strcmp0 (_tmp1732_, "") != 0;
				_g_free0 (_tmp1732_);
			} else {
				_tmp1722_ = FALSE;
			}
			if (_tmp1722_) {
				gboolean _tmp1733_;
				gboolean _tmp1734_;
				_tmp1733_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1734_ = _tmp1733_;
				_tmp1721_ = !_tmp1734_;
			} else {
				_tmp1721_ = FALSE;
			}
			if (_tmp1721_) {
				ValaHashMap* _tmp1735_;
				ValaMethod* _tmp1736_;
				gchar* _tmp1737_;
				gchar* _tmp1738_;
				ValaCCodeConstant* _tmp1739_;
				ValaCCodeConstant* _tmp1740_;
				_tmp1735_ = in_arg_map;
				_tmp1736_ = m;
				_tmp1737_ = vala_get_ccode_sentinel (_tmp1736_);
				_tmp1738_ = _tmp1737_;
				_tmp1739_ = vala_ccode_constant_new (_tmp1738_);
				_tmp1740_ = _tmp1739_;
				vala_map_set ((ValaMap*) _tmp1735_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1740_);
				_vala_ccode_node_unref0 (_tmp1740_);
				_g_free0 (_tmp1738_);
			}
		}
	}
	_tmp1742_ = deleg;
	if (_tmp1742_ != NULL) {
		ValaDelegate* _tmp1743_;
		gboolean _tmp1744_;
		gboolean _tmp1745_;
		_tmp1743_ = deleg;
		_tmp1744_ = vala_delegate_get_has_target (_tmp1743_);
		_tmp1745_ = _tmp1744_;
		_tmp1741_ = _tmp1745_;
	} else {
		_tmp1741_ = FALSE;
	}
	if (_tmp1741_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1746_;
		ValaDelegate* _tmp1747_;
		ValaExpression* _tmp1748_;
		ValaExpression* _tmp1749_;
		ValaCCodeExpression* _tmp1750_ = NULL;
		ValaCCodeExpression* _tmp1751_;
		ValaCCodeExpression* _tmp1752_;
		ValaHashMap* _tmp1753_;
		ValaDelegate* _tmp1754_;
		ValaExpression* _tmp1755_;
		ValaExpression* _tmp1756_;
		ValaCCodeExpression* _tmp1757_ = NULL;
		ValaCCodeExpression* _tmp1758_;
		ValaCCodeExpression* _tmp1759_;
		_tmp1746_ = in_arg_map;
		_tmp1747_ = deleg;
		_tmp1748_ = vala_method_call_get_call (expr);
		_tmp1749_ = _tmp1748_;
		_tmp1751_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1749_, &_tmp1750_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1750_;
		_tmp1752_ = _tmp1751_;
		vala_map_set ((ValaMap*) _tmp1746_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1747_), FALSE)), _tmp1752_);
		_vala_ccode_node_unref0 (_tmp1752_);
		_tmp1753_ = out_arg_map;
		_tmp1754_ = deleg;
		_tmp1755_ = vala_method_call_get_call (expr);
		_tmp1756_ = _tmp1755_;
		_tmp1758_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1756_, &_tmp1757_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1757_;
		_tmp1759_ = _tmp1758_;
		vala_map_set ((ValaMap*) _tmp1753_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1754_), FALSE)), _tmp1759_);
		_vala_ccode_node_unref0 (_tmp1759_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1760_ = itype;
	_tmp1761_ = vala_data_type_get_return_type (_tmp1760_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1761_);
	_tmp1763_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1763_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1764_;
		ValaDataType* _tmp1765_;
		_tmp1764_ = itype;
		_tmp1765_ = vala_data_type_get_return_type (_tmp1764_);
		_tmp1762_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1765_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1762_ = FALSE;
	}
	if (_tmp1762_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1766_;
		ValaSignal* _tmp1767_;
		ValaSignal* _tmp1768_;
		ValaSignal* _tmp1769_;
		gboolean _tmp1770_ = FALSE;
		gboolean _tmp1771_ = FALSE;
		ValaMemberAccess* _tmp1772_;
		_tmp1766_ = itype;
		_tmp1767_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1766_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1768_ = _tmp1767_;
		_tmp1769_ = _vala_code_node_ref0 (_tmp1768_);
		sig = _tmp1769_;
		_tmp1772_ = ma;
		if (_tmp1772_ != NULL) {
			ValaMemberAccess* _tmp1773_;
			ValaExpression* _tmp1774_;
			ValaExpression* _tmp1775_;
			_tmp1773_ = ma;
			_tmp1774_ = vala_member_access_get_inner (_tmp1773_);
			_tmp1775_ = _tmp1774_;
			_tmp1771_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1775_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1771_ = FALSE;
		}
		if (_tmp1771_) {
			ValaSignal* _tmp1776_;
			gboolean _tmp1777_;
			gboolean _tmp1778_;
			_tmp1776_ = sig;
			_tmp1777_ = vala_signal_get_is_virtual (_tmp1776_);
			_tmp1778_ = _tmp1777_;
			_tmp1770_ = _tmp1778_;
		} else {
			_tmp1770_ = FALSE;
		}
		if (_tmp1770_) {
		} else {
			gboolean _tmp1779_ = FALSE;
			ValaSignal* _tmp1780_;
			_tmp1780_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1780_)) {
				_tmp1779_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1781_;
				ValaSourceReference* _tmp1782_;
				ValaSourceReference* _tmp1783_;
				ValaSourceFile* _tmp1784_;
				ValaSourceFile* _tmp1785_;
				ValaSignal* _tmp1786_;
				ValaSourceReference* _tmp1787_;
				ValaSourceReference* _tmp1788_;
				ValaSourceFile* _tmp1789_;
				ValaSourceFile* _tmp1790_;
				_tmp1781_ = ma;
				_tmp1782_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1781_);
				_tmp1783_ = _tmp1782_;
				_tmp1784_ = vala_source_reference_get_file (_tmp1783_);
				_tmp1785_ = _tmp1784_;
				_tmp1786_ = sig;
				_tmp1787_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1786_);
				_tmp1788_ = _tmp1787_;
				_tmp1789_ = vala_source_reference_get_file (_tmp1788_);
				_tmp1790_ = _tmp1789_;
				_tmp1779_ = _tmp1785_ == _tmp1790_;
			}
			if (_tmp1779_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1791_ = async_call;
	_tmp1792_ = ccall;
	if (_tmp1791_ == _tmp1792_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1793_;
		ValaDataType* _tmp1794_;
		ValaLocalVariable* _tmp1795_;
		ValaLocalVariable* _tmp1796_;
		const gchar* _tmp1797_;
		const gchar* _tmp1798_;
		ValaCCodeExpression* _tmp1799_;
		ValaLocalVariable* _tmp1800_;
		ValaHashMap* _tmp1801_;
		ValaCCodeExpression* _tmp1802_;
		ValaCCodeUnaryExpression* _tmp1803_;
		ValaCCodeUnaryExpression* _tmp1804_;
		_tmp1793_ = itype;
		_tmp1794_ = vala_data_type_get_return_type (_tmp1793_);
		_tmp1795_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1794_, TRUE, NULL, TRUE);
		out_param_var = _tmp1795_;
		_tmp1796_ = out_param_var;
		_tmp1797_ = vala_symbol_get_name ((ValaSymbol*) _tmp1796_);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1798_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1799_;
		_tmp1800_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1800_, FALSE);
		_tmp1801_ = out_arg_map;
		_tmp1802_ = out_param_ref;
		_tmp1803_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1802_);
		_tmp1804_ = _tmp1803_;
		vala_map_set ((ValaMap*) _tmp1801_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1804_);
		_vala_ccode_node_unref0 (_tmp1804_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1805_ = async_call;
	_tmp1806_ = ccall;
	if (_tmp1805_ != _tmp1806_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1817_;
			ValaHashMap* _tmp1818_;
			gpointer _tmp1819_;
			ValaCCodeExpression* _tmp1820_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1807_;
				ValaSet* _tmp1808_;
				ValaSet* _tmp1809_;
				ValaIterator* _tmp1810_;
				ValaIterator* _tmp1811_;
				_tmp1807_ = out_arg_map;
				_tmp1808_ = vala_map_get_keys ((ValaMap*) _tmp1807_);
				_tmp1809_ = _tmp1808_;
				_tmp1810_ = vala_iterable_iterator ((ValaIterable*) _tmp1809_);
				_tmp1811_ = _tmp1810_;
				_vala_iterable_unref0 (_tmp1809_);
				_pos_it = _tmp1811_;
				while (TRUE) {
					ValaIterator* _tmp1812_;
					gint pos = 0;
					ValaIterator* _tmp1813_;
					gpointer _tmp1814_;
					gboolean _tmp1815_ = FALSE;
					_tmp1812_ = _pos_it;
					if (!vala_iterator_next (_tmp1812_)) {
						break;
					}
					_tmp1813_ = _pos_it;
					_tmp1814_ = vala_iterator_get (_tmp1813_);
					pos = (gint) ((gintptr) _tmp1814_);
					if (pos > last_pos) {
						gboolean _tmp1816_ = FALSE;
						if (min_pos == -1) {
							_tmp1816_ = TRUE;
						} else {
							_tmp1816_ = pos < min_pos;
						}
						_tmp1815_ = _tmp1816_;
					} else {
						_tmp1815_ = FALSE;
					}
					if (_tmp1815_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1817_ = ccall;
			_tmp1818_ = out_arg_map;
			_tmp1819_ = vala_map_get ((ValaMap*) _tmp1818_, (gpointer) ((gintptr) min_pos));
			_tmp1820_ = (ValaCCodeExpression*) _tmp1819_;
			vala_ccode_function_call_add_argument (_tmp1817_, _tmp1820_);
			_vala_ccode_node_unref0 (_tmp1820_);
			last_pos = min_pos;
		}
	}
	_tmp1821_ = async_call;
	if (_tmp1821_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1832_;
			ValaHashMap* _tmp1833_;
			gpointer _tmp1834_;
			ValaCCodeExpression* _tmp1835_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1822_;
				ValaSet* _tmp1823_;
				ValaSet* _tmp1824_;
				ValaIterator* _tmp1825_;
				ValaIterator* _tmp1826_;
				_tmp1822_ = in_arg_map;
				_tmp1823_ = vala_map_get_keys ((ValaMap*) _tmp1822_);
				_tmp1824_ = _tmp1823_;
				_tmp1825_ = vala_iterable_iterator ((ValaIterable*) _tmp1824_);
				_tmp1826_ = _tmp1825_;
				_vala_iterable_unref0 (_tmp1824_);
				_pos_it = _tmp1826_;
				while (TRUE) {
					ValaIterator* _tmp1827_;
					gint pos = 0;
					ValaIterator* _tmp1828_;
					gpointer _tmp1829_;
					gboolean _tmp1830_ = FALSE;
					_tmp1827_ = _pos_it;
					if (!vala_iterator_next (_tmp1827_)) {
						break;
					}
					_tmp1828_ = _pos_it;
					_tmp1829_ = vala_iterator_get (_tmp1828_);
					pos = (gint) ((gintptr) _tmp1829_);
					if (pos > last_pos) {
						gboolean _tmp1831_ = FALSE;
						if (min_pos == -1) {
							_tmp1831_ = TRUE;
						} else {
							_tmp1831_ = pos < min_pos;
						}
						_tmp1830_ = _tmp1831_;
					} else {
						_tmp1830_ = FALSE;
					}
					if (_tmp1830_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1832_ = async_call;
			_tmp1833_ = in_arg_map;
			_tmp1834_ = vala_map_get ((ValaMap*) _tmp1833_, (gpointer) ((gintptr) min_pos));
			_tmp1835_ = (ValaCCodeExpression*) _tmp1834_;
			vala_ccode_function_call_add_argument (_tmp1832_, _tmp1835_);
			_vala_ccode_node_unref0 (_tmp1835_);
			last_pos = min_pos;
		}
	}
	_tmp1836_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1837_ = _tmp1836_;
	if (_tmp1837_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1838_;
		gint _tmp1839_;
		ValaCCodeFunction* _tmp1840_;
		ValaCCodeFunction* _tmp1841_;
		ValaCCodeIdentifier* _tmp1842_;
		ValaCCodeIdentifier* _tmp1843_;
		ValaCCodeMemberAccess* _tmp1844_;
		ValaCCodeMemberAccess* _tmp1845_;
		gchar* _tmp1846_;
		gchar* _tmp1847_;
		ValaCCodeConstant* _tmp1848_;
		ValaCCodeConstant* _tmp1849_;
		ValaCCodeFunction* _tmp1850_;
		ValaCCodeFunction* _tmp1851_;
		ValaCCodeFunctionCall* _tmp1852_;
		ValaCCodeFunction* _tmp1853_;
		ValaCCodeFunction* _tmp1854_;
		ValaCCodeConstant* _tmp1855_;
		ValaCCodeConstant* _tmp1856_;
		ValaCCodeFunction* _tmp1857_;
		ValaCCodeFunction* _tmp1858_;
		gchar* _tmp1859_;
		gchar* _tmp1860_;
		_tmp1838_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1839_ = _tmp1838_->next_coroutine_state;
		_tmp1838_->next_coroutine_state = _tmp1839_ + 1;
		state = _tmp1839_;
		_tmp1840_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1841_ = _tmp1840_;
		_tmp1842_ = vala_ccode_identifier_new ("_data_");
		_tmp1843_ = _tmp1842_;
		_tmp1844_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1843_, "_state_");
		_tmp1845_ = _tmp1844_;
		_tmp1846_ = g_strdup_printf ("%i", state);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = vala_ccode_constant_new (_tmp1847_);
		_tmp1849_ = _tmp1848_;
		vala_ccode_function_add_assignment (_tmp1841_, (ValaCCodeExpression*) _tmp1845_, (ValaCCodeExpression*) _tmp1849_);
		_vala_ccode_node_unref0 (_tmp1849_);
		_g_free0 (_tmp1847_);
		_vala_ccode_node_unref0 (_tmp1845_);
		_vala_ccode_node_unref0 (_tmp1843_);
		_tmp1850_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1851_ = _tmp1850_;
		_tmp1852_ = async_call;
		vala_ccode_function_add_expression (_tmp1851_, (ValaCCodeExpression*) _tmp1852_);
		_tmp1853_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_constant_new ("FALSE");
		_tmp1856_ = _tmp1855_;
		vala_ccode_function_add_return (_tmp1854_, (ValaCCodeExpression*) _tmp1856_);
		_vala_ccode_node_unref0 (_tmp1856_);
		_tmp1857_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = g_strdup_printf ("_state_%d", state);
		_tmp1860_ = _tmp1859_;
		vala_ccode_function_add_label (_tmp1858_, _tmp1860_);
		_g_free0 (_tmp1860_);
	}
	_tmp1861_ = vala_method_call_get_is_assert (expr);
	_tmp1862_ = _tmp1861_;
	if (_tmp1862_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1863_;
		ValaSourceReference* _tmp1864_;
		ValaSourceLocation _tmp1865_ = {0};
		ValaSourceLocation _tmp1866_;
		gchar* _tmp1867_;
		ValaSourceReference* _tmp1868_;
		ValaSourceReference* _tmp1869_;
		ValaSourceLocation _tmp1870_ = {0};
		ValaSourceLocation _tmp1871_;
		gchar* _tmp1872_;
		ValaSourceReference* _tmp1873_;
		ValaSourceReference* _tmp1874_;
		ValaSourceLocation _tmp1875_ = {0};
		ValaSourceLocation _tmp1876_;
		gchar* _tmp1877_;
		gchar* _tmp1878_;
		ValaCCodeFunctionCall* _tmp1879_;
		ValaCCodeIdentifier* _tmp1880_;
		ValaCCodeIdentifier* _tmp1881_;
		ValaCCodeFunctionCall* _tmp1882_;
		const gchar* _tmp1883_;
		gchar* _tmp1884_;
		gchar* _tmp1885_;
		gchar* _tmp1886_;
		gchar* _tmp1887_;
		gchar* _tmp1888_;
		gchar* _tmp1889_;
		ValaCCodeConstant* _tmp1890_;
		ValaCCodeConstant* _tmp1891_;
		_tmp1863_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1864_ = _tmp1863_;
		vala_source_reference_get_begin (_tmp1864_, &_tmp1865_);
		_tmp1866_ = _tmp1865_;
		_tmp1867_ = _tmp1866_.pos;
		_tmp1868_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1869_ = _tmp1868_;
		vala_source_reference_get_end (_tmp1869_, &_tmp1870_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = _tmp1871_.pos;
		_tmp1873_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1874_ = _tmp1873_;
		vala_source_reference_get_begin (_tmp1874_, &_tmp1875_);
		_tmp1876_ = _tmp1875_;
		_tmp1877_ = _tmp1876_.pos;
		_tmp1878_ = string_substring ((const gchar*) _tmp1867_, (glong) 0, (glong) ((gint) (_tmp1872_ - _tmp1877_)));
		message = _tmp1878_;
		_tmp1879_ = ccall;
		_tmp1880_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1881_ = _tmp1880_;
		vala_ccode_function_call_set_call (_tmp1879_, (ValaCCodeExpression*) _tmp1881_);
		_vala_ccode_node_unref0 (_tmp1881_);
		_tmp1882_ = ccall;
		_tmp1883_ = message;
		_tmp1884_ = string_replace (_tmp1883_, "\n", " ");
		_tmp1885_ = _tmp1884_;
		_tmp1886_ = g_strescape (_tmp1885_, "");
		_tmp1887_ = _tmp1886_;
		_tmp1888_ = g_strdup_printf ("\"%s\"", _tmp1887_);
		_tmp1889_ = _tmp1888_;
		_tmp1890_ = vala_ccode_constant_new (_tmp1889_);
		_tmp1891_ = _tmp1890_;
		vala_ccode_function_call_add_argument (_tmp1882_, (ValaCCodeExpression*) _tmp1891_);
		_vala_ccode_node_unref0 (_tmp1891_);
		_g_free0 (_tmp1889_);
		_g_free0 (_tmp1887_);
		_g_free0 (_tmp1885_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1892_;
		ValaCCodeFunction* _tmp1893_;
		ValaCCodeExpression* _tmp1894_;
		ValaCCodeExpression* _tmp1895_;
		ValaCCodeExpression* _tmp1896_;
		_tmp1892_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1893_ = _tmp1892_;
		_tmp1894_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1893_, _tmp1894_);
		_tmp1895_ = out_param_ref;
		_tmp1896_ = _vala_ccode_node_ref0 (_tmp1895_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1896_;
	}
	_tmp1899_ = m;
	if (_tmp1899_ != NULL) {
		ValaMethod* _tmp1900_;
		ValaMemberBinding _tmp1901_;
		ValaMemberBinding _tmp1902_;
		_tmp1900_ = m;
		_tmp1901_ = vala_method_get_binding (_tmp1900_);
		_tmp1902_ = _tmp1901_;
		_tmp1898_ = _tmp1902_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1898_ = FALSE;
	}
	if (_tmp1898_) {
		ValaMethod* _tmp1903_;
		gboolean _tmp1904_;
		gboolean _tmp1905_;
		_tmp1903_ = m;
		_tmp1904_ = vala_method_get_returns_modified_pointer (_tmp1903_);
		_tmp1905_ = _tmp1904_;
		_tmp1897_ = _tmp1905_;
	} else {
		_tmp1897_ = FALSE;
	}
	if (_tmp1897_) {
		gboolean _tmp1906_ = FALSE;
		gboolean _tmp1907_ = FALSE;
		ValaMemberAccess* _tmp1908_;
		_tmp1908_ = ma;
		if (_tmp1908_ != NULL) {
			ValaMemberAccess* _tmp1909_;
			ValaExpression* _tmp1910_;
			ValaExpression* _tmp1911_;
			ValaSymbol* _tmp1912_;
			ValaSymbol* _tmp1913_;
			_tmp1909_ = ma;
			_tmp1910_ = vala_member_access_get_inner (_tmp1909_);
			_tmp1911_ = _tmp1910_;
			_tmp1912_ = vala_expression_get_symbol_reference (_tmp1911_);
			_tmp1913_ = _tmp1912_;
			_tmp1907_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1913_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1907_ = FALSE;
		}
		if (_tmp1907_) {
			ValaMemberAccess* _tmp1914_;
			ValaExpression* _tmp1915_;
			ValaExpression* _tmp1916_;
			_tmp1914_ = ma;
			_tmp1915_ = vala_member_access_get_inner (_tmp1914_);
			_tmp1916_ = _tmp1915_;
			_tmp1906_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1916_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1906_ = FALSE;
		}
		if (_tmp1906_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1917_;
			ValaExpression* _tmp1918_;
			ValaExpression* _tmp1919_;
			ValaSymbol* _tmp1920_;
			ValaSymbol* _tmp1921_;
			ValaProperty* _tmp1922_;
			ValaProperty* _tmp1923_;
			ValaMemberAccess* _tmp1924_;
			ValaExpression* _tmp1925_;
			ValaExpression* _tmp1926_;
			ValaExpression* _tmp1927_;
			ValaExpression* _tmp1928_;
			ValaDataType* _tmp1929_;
			ValaDataType* _tmp1930_;
			ValaCCodeExpression* _tmp1931_;
			ValaGLibValue* _tmp1932_;
			ValaGLibValue* _tmp1933_;
			_tmp1917_ = ma;
			_tmp1918_ = vala_member_access_get_inner (_tmp1917_);
			_tmp1919_ = _tmp1918_;
			_tmp1920_ = vala_expression_get_symbol_reference (_tmp1919_);
			_tmp1921_ = _tmp1920_;
			_tmp1922_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1921_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1922_;
			_tmp1923_ = prop;
			_tmp1924_ = ma;
			_tmp1925_ = vala_member_access_get_inner (_tmp1924_);
			_tmp1926_ = _tmp1925_;
			_tmp1927_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1926_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1928_ = _tmp1927_;
			_tmp1929_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1930_ = _tmp1929_;
			_tmp1931_ = ccall_expr;
			_tmp1932_ = vala_glib_value_new (_tmp1930_, _tmp1931_, FALSE);
			_tmp1933_ = _tmp1932_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1923_, _tmp1928_, (ValaTargetValue*) _tmp1933_);
			_vala_target_value_unref0 (_tmp1933_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1934_;
			ValaCCodeExpression* _tmp1935_;
			ValaCCodeAssignment* _tmp1936_;
			_tmp1934_ = instance;
			_tmp1935_ = ccall_expr;
			_tmp1936_ = vala_ccode_assignment_new (_tmp1934_, _tmp1935_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1936_;
		}
	}
	_tmp1942_ = m;
	if (_tmp1942_ != NULL) {
		ValaMethod* _tmp1943_;
		_tmp1943_ = m;
		_tmp1941_ = vala_get_ccode_simple_generics (_tmp1943_);
	} else {
		_tmp1941_ = FALSE;
	}
	if (_tmp1941_) {
		ValaMethod* _tmp1944_;
		ValaDataType* _tmp1945_;
		ValaDataType* _tmp1946_;
		_tmp1944_ = m;
		_tmp1945_ = vala_callable_get_return_type ((ValaCallable*) _tmp1944_);
		_tmp1946_ = _tmp1945_;
		_tmp1940_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1946_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1940_ = FALSE;
	}
	if (_tmp1940_) {
		ValaDataType* _tmp1947_;
		ValaDataType* _tmp1948_;
		_tmp1947_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1948_ = _tmp1947_;
		_tmp1939_ = vala_data_type_is_real_struct_type (_tmp1948_);
	} else {
		_tmp1939_ = FALSE;
	}
	if (_tmp1939_) {
		ValaDataType* _tmp1949_;
		ValaDataType* _tmp1950_;
		gboolean _tmp1951_;
		gboolean _tmp1952_;
		_tmp1949_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1950_ = _tmp1949_;
		_tmp1951_ = vala_data_type_get_nullable (_tmp1950_);
		_tmp1952_ = _tmp1951_;
		_tmp1938_ = !_tmp1952_;
	} else {
		_tmp1938_ = FALSE;
	}
	if (_tmp1938_) {
		ValaDataType* _tmp1953_;
		ValaDataType* _tmp1954_;
		_tmp1953_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1954_ = _tmp1953_;
		_tmp1937_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1954_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1937_ = FALSE;
	}
	if (_tmp1937_) {
		ValaCCodeExpression* _tmp1955_;
		ValaCCodeParenthesizedExpression* _tmp1956_;
		ValaCCodeParenthesizedExpression* _tmp1957_;
		ValaCCodeUnaryExpression* _tmp1958_;
		_tmp1955_ = ccall_expr;
		_tmp1956_ = vala_ccode_parenthesized_expression_new (_tmp1955_);
		_tmp1957_ = _tmp1956_;
		_tmp1958_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1957_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1958_;
		_vala_ccode_node_unref0 (_tmp1957_);
	}
	_tmp1961_ = m;
	if (_tmp1961_ != NULL) {
		ValaMethod* _tmp1962_;
		gchar* _tmp1963_;
		gchar* _tmp1964_;
		_tmp1962_ = m;
		_tmp1963_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1962_);
		_tmp1964_ = _tmp1963_;
		_tmp1960_ = _tmp1964_ != NULL;
		_g_free0 (_tmp1964_);
	} else {
		_tmp1960_ = FALSE;
	}
	if (_tmp1960_) {
		ValaMethod* _tmp1965_;
		gchar* _tmp1966_;
		gchar* _tmp1967_;
		ValaMethod* _tmp1968_;
		ValaDataType* _tmp1969_;
		ValaDataType* _tmp1970_;
		gchar* _tmp1971_;
		gchar* _tmp1972_;
		_tmp1965_ = m;
		_tmp1966_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1965_);
		_tmp1967_ = _tmp1966_;
		_tmp1968_ = m;
		_tmp1969_ = vala_callable_get_return_type ((ValaCallable*) _tmp1968_);
		_tmp1970_ = _tmp1969_;
		_tmp1971_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1970_);
		_tmp1972_ = _tmp1971_;
		_tmp1959_ = g_strcmp0 (_tmp1967_, _tmp1972_) != 0;
		_g_free0 (_tmp1972_);
		_g_free0 (_tmp1967_);
	} else {
		_tmp1959_ = FALSE;
	}
	if (_tmp1959_) {
		ValaCCodeExpression* _tmp1973_;
		ValaMethod* _tmp1974_;
		ValaDataType* _tmp1975_;
		ValaDataType* _tmp1976_;
		gchar* _tmp1977_;
		gchar* _tmp1978_;
		ValaCCodeCastExpression* _tmp1979_;
		_tmp1973_ = ccall_expr;
		_tmp1974_ = m;
		_tmp1975_ = vala_callable_get_return_type ((ValaCallable*) _tmp1974_);
		_tmp1976_ = _tmp1975_;
		_tmp1977_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1976_);
		_tmp1978_ = _tmp1977_;
		_tmp1979_ = vala_ccode_cast_expression_new (_tmp1973_, _tmp1978_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1979_;
		_g_free0 (_tmp1978_);
	}
	_tmp1980_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1980_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1981_;
		ValaIterator* _tmp1982_;
		ValaIterator* _tmp1983_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1984_;
		gpointer _tmp1985_;
		ValaExpression* _tmp1986_;
		ValaCCodeExpression* _tmp1987_;
		ValaCCodeExpression* _tmp1988_;
		ValaCCodeExpression* _tmp1989_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1990_;
		ValaLocalVariable* _tmp1991_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1992_;
		const gchar* _tmp1993_;
		const gchar* _tmp1994_;
		ValaCCodeExpression* _tmp1995_;
		ValaLocalVariable* _tmp1996_;
		ValaCCodeFile* _tmp1997_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1998_;
		ValaExpression* _tmp1999_;
		ValaExpression* _tmp2000_;
		ValaCCodeExpression* _tmp2001_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp2002_;
		ValaExpression* _tmp2003_;
		ValaExpression* _tmp2004_;
		ValaCCodeExpression* _tmp2005_;
		ValaCCodeExpression* _tmp2006_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp2007_;
		ValaExpression* _tmp2008_;
		ValaExpression* _tmp2009_;
		ValaDataType* _tmp2010_;
		ValaDataType* _tmp2011_;
		ValaArrayType* _tmp2012_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp2013_;
		ValaDataType* _tmp2014_;
		ValaDataType* _tmp2015_;
		gchar* _tmp2016_;
		gchar* _tmp2017_;
		gchar* _tmp2018_;
		gchar* _tmp2019_;
		ValaCCodeIdentifier* _tmp2020_;
		ValaCCodeIdentifier* _tmp2021_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp2022_;
		ValaCCodeExpression* _tmp2023_;
		ValaCCodeBinaryExpression* _tmp2024_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp2025_;
		ValaCCodeExpression* _tmp2026_;
		ValaCCodeBinaryExpression* _tmp2027_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp2028_;
		ValaCCodeIdentifier* _tmp2029_;
		ValaCCodeFunctionCall* _tmp2030_;
		ValaCCodeFunctionCall* _tmp2031_;
		ValaCCodeFunctionCall* _tmp2032_;
		ValaCCodeExpression* _tmp2033_;
		ValaCCodeExpression* _tmp2034_;
		ValaCCodeBinaryExpression* _tmp2035_;
		ValaCCodeBinaryExpression* _tmp2036_;
		ValaCCodeFunctionCall* _tmp2037_;
		ValaCCodeConstant* _tmp2038_;
		ValaCCodeConstant* _tmp2039_;
		ValaCCodeFunctionCall* _tmp2040_;
		ValaCCodeIdentifier* _tmp2041_;
		ValaCCodeBinaryExpression* _tmp2042_;
		ValaCCodeBinaryExpression* _tmp2043_;
		ValaCCodeBinaryExpression* _tmp2044_;
		ValaCCodeFunction* _tmp2045_;
		ValaCCodeFunction* _tmp2046_;
		ValaCCodeExpression* _tmp2047_;
		ValaCCodeExpression* _tmp2048_;
		ValaCCodeFunction* _tmp2049_;
		ValaCCodeFunction* _tmp2050_;
		ValaCCodeExpression* _tmp2051_;
		ValaCCodeFunction* _tmp2052_;
		ValaCCodeFunction* _tmp2053_;
		ValaCCodeBinaryExpression* _tmp2054_;
		ValaCCodeFunctionCall* _tmp2055_;
		ValaCCodeConstant* _tmp2056_;
		ValaCCodeConstant* _tmp2057_;
		ValaCCodeConditionalExpression* _tmp2058_;
		ValaCCodeConditionalExpression* _tmp2059_;
		ValaCCodeFunction* _tmp2060_;
		ValaCCodeFunction* _tmp2061_;
		ValaMemberAccess* _tmp2062_;
		ValaExpression* _tmp2063_;
		ValaExpression* _tmp2064_;
		ValaCCodeExpression* _tmp2065_;
		ValaCCodeExpression* _tmp2066_;
		ValaCCodeExpression* _tmp2067_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp2068_;
		ValaExpression* _tmp2069_;
		ValaExpression* _tmp2070_;
		ValaSymbol* _tmp2071_;
		ValaSymbol* _tmp2072_;
		ValaSymbol* _tmp2073_;
		gboolean _tmp2074_ = FALSE;
		gboolean _tmp2075_ = FALSE;
		ValaSymbol* _tmp2076_;
		_tmp1981_ = vala_method_call_get_argument_list (expr);
		_tmp1982_ = vala_iterable_iterator ((ValaIterable*) _tmp1981_);
		arg_it = _tmp1982_;
		_tmp1983_ = arg_it;
		vala_iterator_next (_tmp1983_);
		_tmp1984_ = arg_it;
		_tmp1985_ = vala_iterator_get (_tmp1984_);
		_tmp1986_ = (ValaExpression*) _tmp1985_;
		_tmp1987_ = vala_get_cvalue (_tmp1986_);
		_tmp1988_ = _vala_ccode_node_ref0 (_tmp1987_);
		_tmp1989_ = _tmp1988_;
		_vala_code_node_unref0 (_tmp1986_);
		new_size = _tmp1989_;
		_tmp1990_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1991_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1990_, TRUE, NULL, FALSE);
		temp_decl = _tmp1991_;
		_tmp1992_ = temp_decl;
		_tmp1993_ = vala_symbol_get_name ((ValaSymbol*) _tmp1992_);
		_tmp1994_ = _tmp1993_;
		_tmp1995_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1994_);
		temp_ref = _tmp1995_;
		_tmp1996_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1996_, FALSE);
		_tmp1997_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1997_, "string.h", FALSE);
		_tmp1998_ = ma;
		_tmp1999_ = vala_member_access_get_inner (_tmp1998_);
		_tmp2000_ = _tmp1999_;
		_tmp2001_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2000_, 1);
		clen = _tmp2001_;
		_tmp2002_ = ma;
		_tmp2003_ = vala_member_access_get_inner (_tmp2002_);
		_tmp2004_ = _tmp2003_;
		_tmp2005_ = vala_get_cvalue (_tmp2004_);
		_tmp2006_ = _vala_ccode_node_ref0 (_tmp2005_);
		celems = _tmp2006_;
		_tmp2007_ = ma;
		_tmp2008_ = vala_member_access_get_inner (_tmp2007_);
		_tmp2009_ = _tmp2008_;
		_tmp2010_ = vala_expression_get_value_type (_tmp2009_);
		_tmp2011_ = _tmp2010_;
		_tmp2012_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2011_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp2012_;
		_tmp2013_ = array_type;
		_tmp2014_ = vala_array_type_get_element_type (_tmp2013_);
		_tmp2015_ = _tmp2014_;
		_tmp2016_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2015_);
		_tmp2017_ = _tmp2016_;
		_tmp2018_ = g_strdup_printf ("sizeof (%s)", _tmp2017_);
		_tmp2019_ = _tmp2018_;
		_tmp2020_ = vala_ccode_identifier_new (_tmp2019_);
		_tmp2021_ = _tmp2020_;
		_g_free0 (_tmp2019_);
		_g_free0 (_tmp2017_);
		csizeof = _tmp2021_;
		_tmp2022_ = temp_ref;
		_tmp2023_ = clen;
		_tmp2024_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp2022_, _tmp2023_);
		cdelta = _tmp2024_;
		_tmp2025_ = temp_ref;
		_tmp2026_ = clen;
		_tmp2027_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp2025_, _tmp2026_);
		ccheck = _tmp2027_;
		_tmp2028_ = vala_ccode_identifier_new ("memset");
		_tmp2029_ = _tmp2028_;
		_tmp2030_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2029_);
		_tmp2031_ = _tmp2030_;
		_vala_ccode_node_unref0 (_tmp2029_);
		czero = _tmp2031_;
		_tmp2032_ = czero;
		_tmp2033_ = celems;
		_tmp2034_ = clen;
		_tmp2035_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp2033_, _tmp2034_);
		_tmp2036_ = _tmp2035_;
		vala_ccode_function_call_add_argument (_tmp2032_, (ValaCCodeExpression*) _tmp2036_);
		_vala_ccode_node_unref0 (_tmp2036_);
		_tmp2037_ = czero;
		_tmp2038_ = vala_ccode_constant_new ("0");
		_tmp2039_ = _tmp2038_;
		vala_ccode_function_call_add_argument (_tmp2037_, (ValaCCodeExpression*) _tmp2039_);
		_vala_ccode_node_unref0 (_tmp2039_);
		_tmp2040_ = czero;
		_tmp2041_ = csizeof;
		_tmp2042_ = cdelta;
		_tmp2043_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp2041_, (ValaCCodeExpression*) _tmp2042_);
		_tmp2044_ = _tmp2043_;
		vala_ccode_function_call_add_argument (_tmp2040_, (ValaCCodeExpression*) _tmp2044_);
		_vala_ccode_node_unref0 (_tmp2044_);
		_tmp2045_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2046_ = _tmp2045_;
		_tmp2047_ = temp_ref;
		_tmp2048_ = new_size;
		vala_ccode_function_add_assignment (_tmp2046_, _tmp2047_, _tmp2048_);
		_tmp2049_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2050_ = _tmp2049_;
		_tmp2051_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp2050_, _tmp2051_);
		_tmp2052_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2053_ = _tmp2052_;
		_tmp2054_ = ccheck;
		_tmp2055_ = czero;
		_tmp2056_ = vala_ccode_constant_new ("NULL");
		_tmp2057_ = _tmp2056_;
		_tmp2058_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp2054_, (ValaCCodeExpression*) _tmp2055_, (ValaCCodeExpression*) _tmp2057_);
		_tmp2059_ = _tmp2058_;
		vala_ccode_function_add_expression (_tmp2053_, (ValaCCodeExpression*) _tmp2059_);
		_vala_ccode_node_unref0 (_tmp2059_);
		_vala_ccode_node_unref0 (_tmp2057_);
		_tmp2060_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2061_ = _tmp2060_;
		_tmp2062_ = ma;
		_tmp2063_ = vala_member_access_get_inner (_tmp2062_);
		_tmp2064_ = _tmp2063_;
		_tmp2065_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp2064_, 1);
		_tmp2066_ = _tmp2065_;
		_tmp2067_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp2061_, _tmp2066_, _tmp2067_);
		_vala_ccode_node_unref0 (_tmp2066_);
		_tmp2068_ = ma;
		_tmp2069_ = vala_member_access_get_inner (_tmp2068_);
		_tmp2070_ = _tmp2069_;
		_tmp2071_ = vala_expression_get_symbol_reference (_tmp2070_);
		_tmp2072_ = _tmp2071_;
		_tmp2073_ = _vala_code_node_ref0 (_tmp2072_);
		array_var = _tmp2073_;
		_tmp2076_ = array_var;
		if (_tmp2076_ != NULL) {
			ValaSymbol* _tmp2077_;
			_tmp2077_ = array_var;
			_tmp2075_ = vala_symbol_is_internal_symbol (_tmp2077_);
		} else {
			_tmp2075_ = FALSE;
		}
		if (_tmp2075_) {
			gboolean _tmp2078_ = FALSE;
			ValaSymbol* _tmp2079_;
			_tmp2079_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2079_, VALA_TYPE_LOCAL_VARIABLE)) {
				_tmp2078_ = TRUE;
			} else {
				ValaSymbol* _tmp2080_;
				_tmp2080_ = array_var;
				_tmp2078_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2080_, VALA_TYPE_FIELD);
			}
			_tmp2074_ = _tmp2078_;
		} else {
			_tmp2074_ = FALSE;
		}
		if (_tmp2074_) {
			ValaCCodeFunction* _tmp2081_;
			ValaCCodeFunction* _tmp2082_;
			ValaMemberAccess* _tmp2083_;
			ValaExpression* _tmp2084_;
			ValaExpression* _tmp2085_;
			ValaTargetValue* _tmp2086_;
			ValaTargetValue* _tmp2087_;
			ValaCCodeExpression* _tmp2088_;
			ValaCCodeExpression* _tmp2089_;
			_tmp2081_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2082_ = _tmp2081_;
			_tmp2083_ = ma;
			_tmp2084_ = vala_member_access_get_inner (_tmp2083_);
			_tmp2085_ = _tmp2084_;
			_tmp2086_ = vala_expression_get_target_value (_tmp2085_);
			_tmp2087_ = _tmp2086_;
			_tmp2088_ = vala_get_array_size_cvalue (_tmp2087_);
			_tmp2089_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp2082_, _tmp2088_, _tmp2089_);
		}
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp2091_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp2092_ = _tmp2091_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2092_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp2093_;
		ValaDataType* _tmp2094_;
		_tmp2093_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp2094_ = _tmp2093_;
		_tmp2090_ = !vala_data_type_is_disposable (_tmp2094_);
	} else {
		_tmp2090_ = FALSE;
	}
	if (_tmp2090_) {
		gboolean _tmp2095_ = FALSE;
		ValaCCodeExpression* _tmp2096_;
		_tmp2096_ = ccall_expr;
		if (_tmp2096_ != NULL) {
			_tmp2095_ = !return_result_via_out_param;
		} else {
			_tmp2095_ = FALSE;
		}
		if (_tmp2095_) {
			ValaCCodeFunction* _tmp2097_;
			ValaCCodeFunction* _tmp2098_;
			ValaCCodeExpression* _tmp2099_;
			_tmp2097_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp2098_ = _tmp2097_;
			_tmp2099_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp2098_, _tmp2099_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp2100_;
		ValaDataType* _tmp2101_;
		ValaDataType* _tmp2102_;
		gboolean _tmp2103_ = FALSE;
		ValaDataType* _tmp2104_;
		ValaDataType* _tmp2105_;
		gboolean _tmp2158_ = FALSE;
		ValaMethod* _tmp2159_;
		_tmp2100_ = itype;
		_tmp2101_ = vala_data_type_get_return_type (_tmp2100_);
		_tmp2102_ = _vala_code_node_ref0 (_tmp2101_);
		result_type = _tmp2102_;
		_tmp2104_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp2105_ = _tmp2104_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2105_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp2106_;
			ValaDataType* _tmp2107_;
			_tmp2106_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp2107_ = _tmp2106_;
			_tmp2103_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp2107_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp2103_ = FALSE;
		}
		if (_tmp2103_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp2108_;
			ValaDataType* _tmp2109_;
			ValaTypeParameter* _tmp2110_;
			ValaTypeParameter* _tmp2111_;
			ValaTypeParameter* _tmp2112_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp2113_;
			ValaSymbol* _tmp2114_;
			ValaSymbol* _tmp2115_;
			ValaSymbol* _tmp2116_;
			ValaSymbol* _tmp2117_;
			ValaStruct* _tmp2118_;
			gboolean _tmp2119_ = FALSE;
			ValaTypeParameter* _tmp2120_;
			ValaSymbol* _tmp2121_;
			ValaSymbol* _tmp2122_;
			ValaTypeSymbol* _tmp2123_;
			gboolean _tmp2132_ = FALSE;
			gboolean _tmp2133_ = FALSE;
			ValaStruct* _tmp2134_;
			_tmp2108_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp2109_ = _tmp2108_;
			_tmp2110_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp2109_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp2111_ = _tmp2110_;
			_tmp2112_ = _vala_code_node_ref0 (_tmp2111_);
			type_parameter = _tmp2112_;
			_tmp2113_ = type_parameter;
			_tmp2114_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2113_);
			_tmp2115_ = _tmp2114_;
			_tmp2116_ = vala_symbol_get_parent_symbol (_tmp2115_);
			_tmp2117_ = _tmp2116_;
			_tmp2118_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2117_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2117_) : NULL);
			st = _tmp2118_;
			_tmp2120_ = type_parameter;
			_tmp2121_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2120_);
			_tmp2122_ = _tmp2121_;
			_tmp2123_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2123_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2119_ = TRUE;
			} else {
				gboolean _tmp2124_ = FALSE;
				ValaStruct* _tmp2125_;
				_tmp2125_ = st;
				if (_tmp2125_ != NULL) {
					ValaStruct* _tmp2126_;
					gchar* _tmp2127_;
					gchar* _tmp2128_;
					_tmp2126_ = st;
					_tmp2127_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2126_);
					_tmp2128_ = _tmp2127_;
					_tmp2124_ = g_strcmp0 (_tmp2128_, "va_list") == 0;
					_g_free0 (_tmp2128_);
				} else {
					_tmp2124_ = FALSE;
				}
				_tmp2119_ = _tmp2124_;
			}
			if (_tmp2119_) {
				ValaDataType* _tmp2129_;
				ValaDataType* _tmp2130_;
				ValaDataType* _tmp2131_;
				_tmp2129_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2130_ = _tmp2129_;
				_tmp2131_ = _vala_code_node_ref0 (_tmp2130_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2131_;
			}
			_tmp2134_ = st;
			if (_tmp2134_ != NULL) {
				ValaStruct* _tmp2135_;
				gchar* _tmp2136_;
				gchar* _tmp2137_;
				_tmp2135_ = st;
				_tmp2136_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2135_);
				_tmp2137_ = _tmp2136_;
				_tmp2133_ = g_strcmp0 (_tmp2137_, "va_list") == 0;
				_g_free0 (_tmp2137_);
			} else {
				_tmp2133_ = FALSE;
			}
			if (_tmp2133_) {
				ValaMemberAccess* _tmp2138_;
				const gchar* _tmp2139_;
				const gchar* _tmp2140_;
				_tmp2138_ = ma;
				_tmp2139_ = vala_member_access_get_member_name (_tmp2138_);
				_tmp2140_ = _tmp2139_;
				_tmp2132_ = g_strcmp0 (_tmp2140_, "arg") == 0;
			} else {
				_tmp2132_ = FALSE;
			}
			if (_tmp2132_) {
				gboolean _tmp2141_ = FALSE;
				ValaDataType* _tmp2142_;
				_tmp2142_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2142_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2143_;
					ValaDelegate* _tmp2144_;
					ValaDelegate* _tmp2145_;
					gboolean _tmp2146_;
					gboolean _tmp2147_;
					_tmp2143_ = result_type;
					_tmp2144_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2143_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2145_ = _tmp2144_;
					_tmp2146_ = vala_delegate_get_has_target (_tmp2145_);
					_tmp2147_ = _tmp2146_;
					_tmp2141_ = _tmp2147_;
				} else {
					_tmp2141_ = FALSE;
				}
				if (_tmp2141_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2148_;
					ValaTargetValue* _tmp2149_;
					ValaGLibValue* _tmp2150_;
					ValaCCodeExpression* _tmp2151_;
					ValaGLibValue* _tmp2154_;
					ValaCCodeExpression* _tmp2155_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2148_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2149_ = _tmp2148_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2149_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2150_ = arg_value;
					_tmp2151_ = _tmp2150_->delegate_target_cvalue;
					if (_tmp2151_ == NULL) {
						ValaGLibValue* _tmp2152_;
						ValaCCodeConstant* _tmp2153_;
						_tmp2152_ = arg_value;
						_tmp2153_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2152_->delegate_target_cvalue);
						_tmp2152_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2153_;
					}
					_tmp2154_ = arg_value;
					_tmp2155_ = _tmp2154_->delegate_target_destroy_notify_cvalue;
					if (_tmp2155_ == NULL) {
						ValaGLibValue* _tmp2156_;
						ValaCCodeConstant* _tmp2157_;
						_tmp2156_ = arg_value;
						_tmp2157_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2156_->delegate_target_destroy_notify_cvalue);
						_tmp2156_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2157_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2159_ = m;
		if (_tmp2159_ != NULL) {
			ValaMethod* _tmp2160_;
			_tmp2160_ = m;
			_tmp2158_ = vala_method_get_format_arg_index (_tmp2160_) >= 0;
		} else {
			_tmp2158_ = FALSE;
		}
		if (_tmp2158_) {
			ValaCCodeExpression* _tmp2161_;
			_tmp2161_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2161_);
		} else {
			gboolean _tmp2162_ = FALSE;
			ValaMethod* _tmp2163_;
			_tmp2163_ = m;
			if (_tmp2163_ != NULL) {
				ValaMethod* _tmp2164_;
				_tmp2164_ = m;
				_tmp2162_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2164_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2162_ = FALSE;
			}
			if (_tmp2162_) {
				ValaCCodeExpression* _tmp2165_;
				_tmp2165_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2165_);
			} else {
				gboolean _tmp2166_ = FALSE;
				gboolean _tmp2167_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2167_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2167_ = FALSE;
				}
				if (_tmp2167_) {
					gboolean _tmp2168_ = FALSE;
					ValaDataType* _tmp2169_;
					_tmp2169_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2169_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2170_;
						_tmp2170_ = result_type;
						_tmp2168_ = !vala_data_type_is_disposable (_tmp2170_);
					} else {
						_tmp2168_ = FALSE;
					}
					_tmp2166_ = _tmp2168_;
				} else {
					_tmp2166_ = FALSE;
				}
				if (_tmp2166_) {
					ValaCCodeExpression* _tmp2171_;
					_tmp2171_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2171_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2172_;
						ValaDataType* _tmp2173_;
						gboolean _tmp2174_;
						gboolean _tmp2175_;
						ValaLocalVariable* _tmp2176_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2177_;
						const gchar* _tmp2178_;
						const gchar* _tmp2179_;
						ValaCCodeExpression* _tmp2180_;
						ValaLocalVariable* _tmp2181_;
						ValaCCodeFunction* _tmp2182_;
						ValaCCodeFunction* _tmp2183_;
						ValaCCodeExpression* _tmp2184_;
						ValaCCodeExpression* _tmp2185_;
						ValaCCodeExpression* _tmp2186_;
						ValaTargetValue* _tmp2187_;
						ValaTargetValue* _tmp2188_;
						_tmp2172_ = result_type;
						_tmp2173_ = result_type;
						_tmp2174_ = vala_data_type_get_value_owned (_tmp2173_);
						_tmp2175_ = _tmp2174_;
						_tmp2176_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2172_, _tmp2175_, NULL, FALSE);
						temp_var = _tmp2176_;
						_tmp2177_ = temp_var;
						_tmp2178_ = vala_symbol_get_name ((ValaSymbol*) _tmp2177_);
						_tmp2179_ = _tmp2178_;
						_tmp2180_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2179_);
						temp_ref = _tmp2180_;
						_tmp2181_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2181_, FALSE);
						_tmp2182_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2183_ = _tmp2182_;
						_tmp2184_ = temp_ref;
						_tmp2185_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2183_, _tmp2184_, _tmp2185_);
						_tmp2186_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2186_);
						_tmp2187_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2188_ = _tmp2187_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2188_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2189_;
						ValaTargetValue* _tmp2190_;
						ValaTargetValue* _tmp2191_;
						_tmp2189_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2189_);
						_tmp2190_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2191_ = _tmp2190_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2191_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2192_ = params;
	_tmp2193_ = vala_iterable_iterator ((ValaIterable*) _tmp2192_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2193_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2194_;
		ValaList* _tmp2195_;
		gint _arg_size = 0;
		ValaList* _tmp2196_;
		gint _tmp2197_;
		gint _tmp2198_;
		gint _arg_index = 0;
		_tmp2194_ = vala_method_call_get_argument_list (expr);
		_tmp2195_ = _vala_iterable_ref0 (_tmp2194_);
		_arg_list = _tmp2195_;
		_tmp2196_ = _arg_list;
		_tmp2197_ = vala_collection_get_size ((ValaCollection*) _tmp2196_);
		_tmp2198_ = _tmp2197_;
		_arg_size = _tmp2198_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2199_;
			gint _tmp2200_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2201_;
			gpointer _tmp2202_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2203_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2206_;
			ValaUnaryExpression* _tmp2207_;
			gboolean _tmp2208_ = FALSE;
			ValaUnaryExpression* _tmp2209_;
			gboolean _tmp2267_ = FALSE;
			ValaUnaryExpression* _tmp2268_;
			ValaUnaryExpression* _tmp2272_;
			ValaExpression* _tmp2273_;
			ValaExpression* _tmp2274_;
			ValaDataType* _tmp2275_;
			ValaDataType* _tmp2276_;
			gboolean _tmp2286_ = FALSE;
			ValaMemberAccess* _tmp2287_;
			ValaSymbol* _tmp2288_;
			ValaSymbol* _tmp2289_;
			ValaUnaryExpression* _tmp2305_;
			ValaExpression* _tmp2306_;
			ValaExpression* _tmp2307_;
			ValaTargetValue* _tmp2308_;
			ValaTargetValue* _tmp2309_;
			ValaUnaryExpression* _tmp2310_;
			ValaTargetValue* _tmp2311_;
			ValaTargetValue* _tmp2312_;
			ValaUnaryExpression* _tmp2313_;
			ValaExpression* _tmp2314_;
			ValaExpression* _tmp2315_;
			ValaDataType* _tmp2316_;
			ValaDataType* _tmp2317_;
			ValaExpression* _tmp2318_;
			ValaTargetValue* _tmp2319_;
			ValaTargetValue* _tmp2320_;
			ValaSourceReference* _tmp2321_;
			ValaSourceReference* _tmp2322_;
			gboolean _tmp2323_ = FALSE;
			ValaParameter* _tmp2324_;
			_arg_index = _arg_index + 1;
			_tmp2199_ = _arg_index;
			_tmp2200_ = _arg_size;
			if (!(_tmp2199_ < _tmp2200_)) {
				break;
			}
			_tmp2201_ = _arg_list;
			_tmp2202_ = vala_list_get (_tmp2201_, _arg_index);
			arg = (ValaExpression*) _tmp2202_;
			param = NULL;
			_tmp2203_ = params_it;
			if (vala_iterator_next (_tmp2203_)) {
				ValaIterator* _tmp2204_;
				gpointer _tmp2205_;
				_tmp2204_ = params_it;
				_tmp2205_ = vala_iterator_get (_tmp2204_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2205_;
			}
			_tmp2206_ = arg;
			_tmp2207_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2206_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2206_) : NULL);
			unary = _tmp2207_;
			_tmp2209_ = unary;
			if (_tmp2209_ != NULL) {
				ValaUnaryExpression* _tmp2210_;
				ValaUnaryOperator _tmp2211_;
				ValaUnaryOperator _tmp2212_;
				_tmp2210_ = unary;
				_tmp2211_ = vala_unary_expression_get_operator (_tmp2210_);
				_tmp2212_ = _tmp2211_;
				_tmp2208_ = _tmp2212_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2208_ = FALSE;
			}
			if (_tmp2208_) {
				gboolean _tmp2213_ = FALSE;
				gboolean _tmp2214_ = FALSE;
				gboolean _tmp2215_ = FALSE;
				gboolean _tmp2216_ = FALSE;
				ValaParameter* _tmp2217_;
				_tmp2217_ = param;
				if (_tmp2217_ != NULL) {
					ValaParameter* _tmp2218_;
					_tmp2218_ = param;
					_tmp2216_ = vala_get_ccode_array_length ((ValaCodeNode*) _tmp2218_);
				} else {
					_tmp2216_ = FALSE;
				}
				if (_tmp2216_) {
					ValaParameter* _tmp2219_;
					ValaDataType* _tmp2220_;
					ValaDataType* _tmp2221_;
					_tmp2219_ = param;
					_tmp2220_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2219_);
					_tmp2221_ = _tmp2220_;
					_tmp2215_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2221_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2215_ = FALSE;
				}
				if (_tmp2215_) {
					ValaParameter* _tmp2222_;
					ValaDataType* _tmp2223_;
					ValaDataType* _tmp2224_;
					gboolean _tmp2225_;
					gboolean _tmp2226_;
					_tmp2222_ = param;
					_tmp2223_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2222_);
					_tmp2224_ = _tmp2223_;
					_tmp2225_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2224_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2226_ = _tmp2225_;
					_tmp2214_ = !_tmp2226_;
				} else {
					_tmp2214_ = FALSE;
				}
				if (_tmp2214_) {
					ValaParameter* _tmp2227_;
					ValaDataType* _tmp2228_;
					ValaDataType* _tmp2229_;
					gint _tmp2230_;
					gint _tmp2231_;
					_tmp2227_ = param;
					_tmp2228_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2227_);
					_tmp2229_ = _tmp2228_;
					_tmp2230_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2229_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2231_ = _tmp2230_;
					_tmp2213_ = _tmp2231_ == 1;
				} else {
					_tmp2213_ = FALSE;
				}
				if (_tmp2213_) {
					ValaVariable* array_var = NULL;
					ValaUnaryExpression* _tmp2232_;
					ValaExpression* _tmp2233_;
					ValaExpression* _tmp2234_;
					ValaSymbol* _tmp2235_;
					ValaSymbol* _tmp2236_;
					gboolean _tmp2237_ = FALSE;
					gboolean _tmp2238_ = FALSE;
					gboolean _tmp2239_ = FALSE;
					gboolean _tmp2240_ = FALSE;
					ValaVariable* _tmp2241_;
					_tmp2232_ = unary;
					_tmp2233_ = vala_unary_expression_get_inner (_tmp2232_);
					_tmp2234_ = _tmp2233_;
					_tmp2235_ = vala_expression_get_symbol_reference (_tmp2234_);
					_tmp2236_ = _tmp2235_;
					array_var = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2236_, VALA_TYPE_VARIABLE) ? ((ValaVariable*) _tmp2236_) : NULL;
					_tmp2241_ = array_var;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2241_, VALA_TYPE_LOCAL_VARIABLE)) {
						_tmp2240_ = TRUE;
					} else {
						ValaVariable* _tmp2242_;
						_tmp2242_ = array_var;
						_tmp2240_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2242_, VALA_TYPE_FIELD);
					}
					if (_tmp2240_) {
						ValaVariable* _tmp2243_;
						_tmp2243_ = array_var;
						_tmp2239_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp2243_);
					} else {
						_tmp2239_ = FALSE;
					}
					if (_tmp2239_) {
						ValaVariable* _tmp2244_;
						ValaDataType* _tmp2245_;
						ValaDataType* _tmp2246_;
						_tmp2244_ = array_var;
						_tmp2245_ = vala_variable_get_variable_type (_tmp2244_);
						_tmp2246_ = _tmp2245_;
						_tmp2238_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2246_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp2238_ = FALSE;
					}
					if (_tmp2238_) {
						ValaVariable* _tmp2247_;
						ValaDataType* _tmp2248_;
						ValaDataType* _tmp2249_;
						gboolean _tmp2250_;
						gboolean _tmp2251_;
						_tmp2247_ = array_var;
						_tmp2248_ = vala_variable_get_variable_type (_tmp2247_);
						_tmp2249_ = _tmp2248_;
						_tmp2250_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2249_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp2251_ = _tmp2250_;
						_tmp2237_ = !_tmp2251_;
					} else {
						_tmp2237_ = FALSE;
					}
					if (_tmp2237_) {
						ValaCCodeFunction* _tmp2252_;
						ValaCCodeFunction* _tmp2253_;
						ValaUnaryExpression* _tmp2254_;
						ValaExpression* _tmp2255_;
						ValaExpression* _tmp2256_;
						ValaTargetValue* _tmp2257_;
						ValaTargetValue* _tmp2258_;
						ValaCCodeExpression* _tmp2259_;
						ValaUnaryExpression* _tmp2260_;
						ValaExpression* _tmp2261_;
						ValaExpression* _tmp2262_;
						ValaTargetValue* _tmp2263_;
						ValaTargetValue* _tmp2264_;
						ValaCCodeExpression* _tmp2265_;
						ValaCCodeExpression* _tmp2266_;
						_tmp2252_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2253_ = _tmp2252_;
						_tmp2254_ = unary;
						_tmp2255_ = vala_unary_expression_get_inner (_tmp2254_);
						_tmp2256_ = _tmp2255_;
						_tmp2257_ = vala_expression_get_target_value (_tmp2256_);
						_tmp2258_ = _tmp2257_;
						_tmp2259_ = vala_get_array_size_cvalue (_tmp2258_);
						_tmp2260_ = unary;
						_tmp2261_ = vala_unary_expression_get_inner (_tmp2260_);
						_tmp2262_ = _tmp2261_;
						_tmp2263_ = vala_expression_get_target_value (_tmp2262_);
						_tmp2264_ = _tmp2263_;
						_tmp2265_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2264_, 1);
						_tmp2266_ = _tmp2265_;
						vala_ccode_function_add_assignment (_tmp2253_, _tmp2259_, _tmp2266_);
						_vala_ccode_node_unref0 (_tmp2266_);
					}
				}
			}
			_tmp2268_ = unary;
			if (_tmp2268_ == NULL) {
				_tmp2267_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2269_;
				ValaUnaryOperator _tmp2270_;
				ValaUnaryOperator _tmp2271_;
				_tmp2269_ = unary;
				_tmp2270_ = vala_unary_expression_get_operator (_tmp2269_);
				_tmp2271_ = _tmp2270_;
				_tmp2267_ = _tmp2271_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2267_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2272_ = unary;
			_tmp2273_ = vala_unary_expression_get_inner (_tmp2272_);
			_tmp2274_ = _tmp2273_;
			_tmp2275_ = vala_expression_get_value_type (_tmp2274_);
			_tmp2276_ = _tmp2275_;
			if (vala_ccode_base_module_requires_destroy (_tmp2276_)) {
				ValaCCodeFunction* _tmp2277_;
				ValaCCodeFunction* _tmp2278_;
				ValaUnaryExpression* _tmp2279_;
				ValaExpression* _tmp2280_;
				ValaExpression* _tmp2281_;
				ValaTargetValue* _tmp2282_;
				ValaTargetValue* _tmp2283_;
				ValaCCodeExpression* _tmp2284_;
				ValaCCodeExpression* _tmp2285_;
				_tmp2277_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2278_ = _tmp2277_;
				_tmp2279_ = unary;
				_tmp2280_ = vala_unary_expression_get_inner (_tmp2279_);
				_tmp2281_ = _tmp2280_;
				_tmp2282_ = vala_expression_get_target_value (_tmp2281_);
				_tmp2283_ = _tmp2282_;
				_tmp2284_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2283_, FALSE);
				_tmp2285_ = _tmp2284_;
				vala_ccode_function_add_expression (_tmp2278_, _tmp2285_);
				_vala_ccode_node_unref0 (_tmp2285_);
			}
			_tmp2287_ = ma;
			_tmp2288_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2287_);
			_tmp2289_ = _tmp2288_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2289_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2290_;
				ValaTargetValue* _tmp2291_;
				ValaTargetValue* _tmp2292_;
				ValaDataType* _tmp2293_;
				ValaDataType* _tmp2294_;
				_tmp2290_ = unary;
				_tmp2291_ = vala_expression_get_target_value ((ValaExpression*) _tmp2290_);
				_tmp2292_ = _tmp2291_;
				_tmp2293_ = vala_target_value_get_value_type (_tmp2292_);
				_tmp2294_ = _tmp2293_;
				_tmp2286_ = _tmp2294_ == NULL;
			} else {
				_tmp2286_ = FALSE;
			}
			if (_tmp2286_) {
				ValaUnaryExpression* _tmp2295_;
				ValaTargetValue* _tmp2296_;
				ValaTargetValue* _tmp2297_;
				ValaUnaryExpression* _tmp2298_;
				ValaExpression* _tmp2299_;
				ValaExpression* _tmp2300_;
				ValaDataType* _tmp2301_;
				ValaDataType* _tmp2302_;
				ValaDataType* _tmp2303_;
				ValaDataType* _tmp2304_;
				_tmp2295_ = unary;
				_tmp2296_ = vala_expression_get_target_value ((ValaExpression*) _tmp2295_);
				_tmp2297_ = _tmp2296_;
				_tmp2298_ = unary;
				_tmp2299_ = vala_unary_expression_get_inner (_tmp2298_);
				_tmp2300_ = _tmp2299_;
				_tmp2301_ = vala_expression_get_value_type (_tmp2300_);
				_tmp2302_ = _tmp2301_;
				_tmp2303_ = vala_data_type_copy (_tmp2302_);
				_tmp2304_ = _tmp2303_;
				vala_target_value_set_value_type (_tmp2297_, _tmp2304_);
				_vala_code_node_unref0 (_tmp2304_);
			}
			_tmp2305_ = unary;
			_tmp2306_ = vala_unary_expression_get_inner (_tmp2305_);
			_tmp2307_ = _tmp2306_;
			_tmp2308_ = vala_expression_get_target_value (_tmp2307_);
			_tmp2309_ = _tmp2308_;
			_tmp2310_ = unary;
			_tmp2311_ = vala_expression_get_target_value ((ValaExpression*) _tmp2310_);
			_tmp2312_ = _tmp2311_;
			_tmp2313_ = unary;
			_tmp2314_ = vala_unary_expression_get_inner (_tmp2313_);
			_tmp2315_ = _tmp2314_;
			_tmp2316_ = vala_expression_get_value_type (_tmp2315_);
			_tmp2317_ = _tmp2316_;
			_tmp2318_ = arg;
			_tmp2319_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2312_, _tmp2317_, (ValaCodeNode*) _tmp2318_);
			_tmp2320_ = _tmp2319_;
			_tmp2321_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2322_ = _tmp2321_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2309_, _tmp2320_, _tmp2322_);
			_vala_target_value_unref0 (_tmp2320_);
			_tmp2324_ = param;
			if (_tmp2324_ != NULL) {
				ValaParameter* _tmp2325_;
				_tmp2325_ = param;
				_tmp2323_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2325_);
			} else {
				_tmp2323_ = FALSE;
			}
			if (_tmp2323_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2326_;
				ValaCCodeIdentifier* _tmp2327_;
				ValaCCodeFunctionCall* _tmp2328_;
				ValaCCodeFunctionCall* _tmp2329_;
				ValaCCodeFunctionCall* _tmp2330_;
				ValaUnaryExpression* _tmp2331_;
				ValaExpression* _tmp2332_;
				ValaExpression* _tmp2333_;
				ValaTargetValue* _tmp2334_;
				ValaTargetValue* _tmp2335_;
				ValaCCodeExpression* _tmp2336_;
				ValaCCodeFunction* _tmp2337_;
				ValaCCodeFunction* _tmp2338_;
				ValaUnaryExpression* _tmp2339_;
				ValaExpression* _tmp2340_;
				ValaExpression* _tmp2341_;
				ValaTargetValue* _tmp2342_;
				ValaTargetValue* _tmp2343_;
				ValaCCodeExpression* _tmp2344_;
				ValaCCodeExpression* _tmp2345_;
				ValaCCodeFunctionCall* _tmp2346_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2326_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2327_ = _tmp2326_;
				_tmp2328_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2327_);
				_tmp2329_ = _tmp2328_;
				_vala_ccode_node_unref0 (_tmp2327_);
				len_call = _tmp2329_;
				_tmp2330_ = len_call;
				_tmp2331_ = unary;
				_tmp2332_ = vala_unary_expression_get_inner (_tmp2331_);
				_tmp2333_ = _tmp2332_;
				_tmp2334_ = vala_expression_get_target_value (_tmp2333_);
				_tmp2335_ = _tmp2334_;
				_tmp2336_ = vala_get_cvalue_ (_tmp2335_);
				vala_ccode_function_call_add_argument (_tmp2330_, _tmp2336_);
				_tmp2337_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2338_ = _tmp2337_;
				_tmp2339_ = unary;
				_tmp2340_ = vala_unary_expression_get_inner (_tmp2339_);
				_tmp2341_ = _tmp2340_;
				_tmp2342_ = vala_expression_get_target_value (_tmp2341_);
				_tmp2343_ = _tmp2342_;
				_tmp2344_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2343_, 1);
				_tmp2345_ = _tmp2344_;
				_tmp2346_ = len_call;
				vala_ccode_function_add_assignment (_tmp2338_, _tmp2345_, (ValaCCodeExpression*) _tmp2346_);
				_vala_ccode_node_unref0 (_tmp2345_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2349_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2349_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2350_;
		ValaSymbol* _tmp2351_;
		ValaSymbol* _tmp2352_;
		_tmp2350_ = m;
		_tmp2351_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2350_);
		_tmp2352_ = _tmp2351_;
		_tmp2348_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2352_, VALA_TYPE_CLASS);
	} else {
		_tmp2348_ = FALSE;
	}
	if (_tmp2348_) {
		gboolean _tmp2353_ = FALSE;
		gboolean _tmp2354_ = FALSE;
		ValaClass* _tmp2355_;
		ValaClass* _tmp2356_;
		gboolean _tmp2357_;
		gboolean _tmp2358_;
		_tmp2355_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2356_ = _tmp2355_;
		_tmp2357_ = vala_class_get_is_compact (_tmp2356_);
		_tmp2358_ = _tmp2357_;
		if (_tmp2358_) {
			ValaClass* _tmp2359_;
			ValaClass* _tmp2360_;
			ValaClass* _tmp2361_;
			ValaClass* _tmp2362_;
			_tmp2359_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2360_ = _tmp2359_;
			_tmp2361_ = vala_class_get_base_class (_tmp2360_);
			_tmp2362_ = _tmp2361_;
			_tmp2354_ = _tmp2362_ != NULL;
		} else {
			_tmp2354_ = FALSE;
		}
		if (_tmp2354_) {
			_tmp2353_ = TRUE;
		} else {
			ValaClass* _tmp2363_;
			ValaClass* _tmp2364_;
			ValaClass* _tmp2365_;
			_tmp2363_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2364_ = _tmp2363_;
			_tmp2365_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2353_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp2364_, (ValaTypeSymbol*) _tmp2365_);
		}
		_tmp2347_ = _tmp2353_;
	} else {
		_tmp2347_ = FALSE;
	}
	if (_tmp2347_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2366_;
		ValaClass* _tmp2367_;
		gchar* _tmp2368_;
		gchar* _tmp2369_;
		gchar* _tmp2370_;
		gchar* _tmp2371_;
		ValaCCodeIdentifier* _tmp2372_;
		ValaCCodeIdentifier* _tmp2373_;
		ValaCCodeFunctionCall* _tmp2374_;
		ValaCCodeFunctionCall* _tmp2375_;
		ValaCCodeFunctionCall* _tmp2376_;
		ValaCCodeExpression* _tmp2377_;
		ValaCCodeExpression* _tmp2378_;
		ValaClass* _tmp2379_;
		ValaClass* _tmp2380_;
		gboolean _tmp2381_;
		gboolean _tmp2382_;
		ValaCCodeFunction* _tmp2386_;
		ValaCCodeFunction* _tmp2387_;
		ValaCCodeFunctionCall* _tmp2388_;
		_tmp2366_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2367_ = _tmp2366_;
		_tmp2368_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2367_, NULL);
		_tmp2369_ = _tmp2368_;
		_tmp2370_ = g_strdup_printf ("%s_instance_init", _tmp2369_);
		_tmp2371_ = _tmp2370_;
		_tmp2372_ = vala_ccode_identifier_new (_tmp2371_);
		_tmp2373_ = _tmp2372_;
		_tmp2374_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2373_);
		_tmp2375_ = _tmp2374_;
		_vala_ccode_node_unref0 (_tmp2373_);
		_g_free0 (_tmp2371_);
		_g_free0 (_tmp2369_);
		cinitcall = _tmp2375_;
		_tmp2376_ = cinitcall;
		_tmp2377_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2378_ = _tmp2377_;
		vala_ccode_function_call_add_argument (_tmp2376_, _tmp2378_);
		_vala_ccode_node_unref0 (_tmp2378_);
		_tmp2379_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2380_ = _tmp2379_;
		_tmp2381_ = vala_class_get_is_compact (_tmp2380_);
		_tmp2382_ = _tmp2381_;
		if (!_tmp2382_) {
			ValaCCodeFunctionCall* _tmp2383_;
			ValaCCodeConstant* _tmp2384_;
			ValaCCodeConstant* _tmp2385_;
			_tmp2383_ = cinitcall;
			_tmp2384_ = vala_ccode_constant_new ("NULL");
			_tmp2385_ = _tmp2384_;
			vala_ccode_function_call_add_argument (_tmp2383_, (ValaCCodeExpression*) _tmp2385_);
			_vala_ccode_node_unref0 (_tmp2385_);
		}
		_tmp2386_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2387_ = _tmp2386_;
		_tmp2388_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2387_, (ValaCCodeExpression*) _tmp2388_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gpointer _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaEnumValue* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunction* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaEnumValue* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCCodeConstant* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			_enum_value_index = _enum_value_index + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = vala_list_get (_tmp27_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp28_;
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = enum_value;
			_tmp32_ = vala_get_ccode_name ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_ccode_identifier_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_ccode_function_add_case (_tmp30_, (ValaCCodeExpression*) _tmp35_);
			_vala_ccode_node_unref0 (_tmp35_);
			_g_free0 (_tmp33_);
			_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = enum_value;
			_tmp39_ = vala_get_ccode_name ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("\"", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "\"", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_ccode_constant_new (_tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	vala_ccode_function_close (_tmp48_);
	_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_constant_new ("NULL");
	_tmp52_ = _tmp51_;
	vala_ccode_function_add_return (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function_declaration (_tmp53_, _tmp54_);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = function;
	vala_ccode_file_add_function (_tmp55_, _tmp56_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaUnaryExpression* _tmp11_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp9_) : NULL;
			_tmp11_ = unary;
			if (_tmp11_ != NULL) {
				gboolean _tmp12_ = FALSE;
				ValaUnaryExpression* _tmp13_;
				ValaUnaryOperator _tmp14_;
				ValaUnaryOperator _tmp15_;
				_tmp13_ = unary;
				_tmp14_ = vala_unary_expression_get_operator (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp12_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp16_;
					ValaUnaryOperator _tmp17_;
					ValaUnaryOperator _tmp18_;
					_tmp16_ = unary;
					_tmp17_ = vala_unary_expression_get_operator (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp10_ = _tmp12_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

