/* valacodecontext.c generated by valac, the Vala compiler
 * generated from valacodecontext.vala, do not modify */

/* valacodecontext.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_report_unref0(var) ((var == NULL) ? NULL : (var = (vala_report_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
typedef struct _ValaParamSpecCodeContext ValaParamSpecCodeContext;

struct _ValaCodeContextPrivate {
	gboolean _assert;
	gboolean _checking;
	gboolean _deprecated;
	gboolean _hide_internal;
	gboolean _since_check;
	gboolean _experimental;
	gboolean _experimental_non_null;
	gboolean _gobject_tracing;
	gboolean _ccode_only;
	gchar* _pkg_config_command;
	gboolean _abi_stability;
	gchar* _header_filename;
	gchar* _internal_header_filename;
	gchar* _includedir;
	gchar* _symbols_filename;
	gboolean _compile_only;
	gchar* _output;
	gchar* _basedir;
	gchar* _directory;
	gchar** _vapi_directories;
	gint _vapi_directories_length1;
	gint __vapi_directories_size_;
	gchar** _gir_directories;
	gint _gir_directories_length1;
	gint __gir_directories_size_;
	gchar** _metadata_directories;
	gint _metadata_directories_length1;
	gint __metadata_directories_size_;
	gboolean _debug;
	gint _optlevel;
	gboolean _mem_profiler;
	ValaMethod* _module_init_method;
	gboolean _save_temps;
	ValaProfile _profile;
	gboolean _verbose_mode;
	gboolean _version_header;
	gboolean _use_fast_vapi;
	gboolean _keep_going;
	gboolean _vapi_comments;
	ValaReport* _report;
	ValaMethod* _entry_point;
	gchar* _entry_point_name;
	gboolean _run_output;
	gchar** _gresources;
	gint _gresources_length1;
	gint __gresources_size_;
	gchar** _gresources_directories;
	gint _gresources_directories_length1;
	gint __gresources_directories_size_;
	ValaList* source_files;
	ValaMap* source_files_map;
	ValaList* c_source_files;
	ValaNamespace* _root;
	ValaList* packages;
	ValaSet* defines;
	gint target_glib_major;
	gint target_glib_minor;
	ValaSymbolResolver* _resolver;
	ValaSemanticAnalyzer* _analyzer;
	ValaFlowAnalyzer* _flow_analyzer;
	ValaCodeGenerator* _codegen;
	ValaUsedAttr* _used_attr;
};

struct _ValaParamSpecCodeContext {
	GParamSpec parent_instance;
};

static gint ValaCodeContext_private_offset;
static gpointer vala_code_context_parent_class = NULL;
static GStaticPrivate vala_code_context_context_stack_key;
static GStaticPrivate vala_code_context_context_stack_key = G_STATIC_PRIVATE_INIT;

static gchar** _vala_array_dup1 (gchar** self,
                          gint length);
static gchar** _vala_array_dup2 (gchar** self,
                          gint length);
static gchar** _vala_array_dup3 (gchar** self,
                          gint length);
static void vala_code_context_set_profile (ValaCodeContext* self,
                                    ValaProfile value);
static gchar** _vala_array_dup4 (gchar** self,
                          gint length);
static gchar** _vala_array_dup5 (gchar** self,
                          gint length);
static void vala_code_context_set_resolver (ValaCodeContext* self,
                                     ValaSymbolResolver* value);
static void vala_code_context_set_analyzer (ValaCodeContext* self,
                                     ValaSemanticAnalyzer* value);
static void vala_code_context_set_flow_analyzer (ValaCodeContext* self,
                                          ValaFlowAnalyzer* value);
static void vala_code_context_add_default_defines (ValaCodeContext* self);
static gchar* vala_code_context_get_file_path (ValaCodeContext* self,
                                        const gchar* basename,
                                        const gchar* versioned_data_dir,
                                        const gchar* data_dir,
                                        gchar** directories,
                                        gint directories_length1);
static gboolean vala_code_context_ends_with_dir_separator (const gchar* s);
static void vala_code_context_finalize (ValaCodeContext * obj);
static GType vala_code_context_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline gpointer
vala_code_context_get_instance_private (ValaCodeContext* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCodeContext_private_offset);
}

gboolean
vala_code_context_get_assert (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_assert;
	return result;
}

void
vala_code_context_set_assert (ValaCodeContext* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_assert = value;
}

gboolean
vala_code_context_get_checking (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_checking;
	return result;
}

void
vala_code_context_set_checking (ValaCodeContext* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_checking = value;
}

gboolean
vala_code_context_get_deprecated (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_deprecated;
	return result;
}

void
vala_code_context_set_deprecated (ValaCodeContext* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_deprecated = value;
}

gboolean
vala_code_context_get_hide_internal (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hide_internal;
	return result;
}

void
vala_code_context_set_hide_internal (ValaCodeContext* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hide_internal = value;
}

gboolean
vala_code_context_get_since_check (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_since_check;
	return result;
}

void
vala_code_context_set_since_check (ValaCodeContext* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_since_check = value;
}

gboolean
vala_code_context_get_experimental (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental;
	return result;
}

void
vala_code_context_set_experimental (ValaCodeContext* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_experimental = value;
}

gboolean
vala_code_context_get_experimental_non_null (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_experimental_non_null;
	return result;
}

void
vala_code_context_set_experimental_non_null (ValaCodeContext* self,
                                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_experimental_non_null = value;
}

gboolean
vala_code_context_get_gobject_tracing (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_gobject_tracing;
	return result;
}

void
vala_code_context_set_gobject_tracing (ValaCodeContext* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_gobject_tracing = value;
}

gboolean
vala_code_context_get_ccode_only (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ccode_only;
	return result;
}

void
vala_code_context_set_ccode_only (ValaCodeContext* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_ccode_only = value;
}

const gchar*
vala_code_context_get_pkg_config_command (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_pkg_config_command (ValaCodeContext* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_pkg_config_command);
	self->priv->_pkg_config_command = _tmp0_;
}

gboolean
vala_code_context_get_abi_stability (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_abi_stability;
	return result;
}

void
vala_code_context_set_abi_stability (ValaCodeContext* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_abi_stability = value;
}

const gchar*
vala_code_context_get_header_filename (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_filename;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_header_filename (ValaCodeContext* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_header_filename);
	self->priv->_header_filename = _tmp0_;
}

const gchar*
vala_code_context_get_internal_header_filename (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_internal_header_filename;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_internal_header_filename (ValaCodeContext* self,
                                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_internal_header_filename);
	self->priv->_internal_header_filename = _tmp0_;
}

const gchar*
vala_code_context_get_includedir (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_includedir;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_includedir (ValaCodeContext* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_includedir);
	self->priv->_includedir = _tmp0_;
}

const gchar*
vala_code_context_get_symbols_filename (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_symbols_filename;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_symbols_filename (ValaCodeContext* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_symbols_filename);
	self->priv->_symbols_filename = _tmp0_;
}

gboolean
vala_code_context_get_compile_only (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_compile_only;
	return result;
}

void
vala_code_context_set_compile_only (ValaCodeContext* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_compile_only = value;
}

const gchar*
vala_code_context_get_output (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_output;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_output (ValaCodeContext* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_output);
	self->priv->_output = _tmp0_;
}

const gchar*
vala_code_context_get_basedir (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basedir;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_basedir (ValaCodeContext* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_basedir);
	self->priv->_basedir = _tmp0_;
}

const gchar*
vala_code_context_get_directory (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_directory (ValaCodeContext* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_directory);
	self->priv->_directory = _tmp0_;
}

gchar**
vala_code_context_get_vapi_directories (ValaCodeContext* self,
                                        gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vapi_directories;
	_tmp0__length1 = self->priv->_vapi_directories_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
vala_code_context_set_vapi_directories (ValaCodeContext* self,
                                        gchar** value,
                                        gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	self->priv->_vapi_directories = (_vala_array_free (self->priv->_vapi_directories, self->priv->_vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_vapi_directories = _tmp0_;
	self->priv->_vapi_directories_length1 = _tmp0__length1;
	self->priv->__vapi_directories_size_ = self->priv->_vapi_directories_length1;
}

gchar**
vala_code_context_get_gir_directories (ValaCodeContext* self,
                                       gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gir_directories;
	_tmp0__length1 = self->priv->_gir_directories_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
vala_code_context_set_gir_directories (ValaCodeContext* self,
                                       gchar** value,
                                       gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	self->priv->_gir_directories = (_vala_array_free (self->priv->_gir_directories, self->priv->_gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_gir_directories = _tmp0_;
	self->priv->_gir_directories_length1 = _tmp0__length1;
	self->priv->__gir_directories_size_ = self->priv->_gir_directories_length1;
}

gchar**
vala_code_context_get_metadata_directories (ValaCodeContext* self,
                                            gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_metadata_directories;
	_tmp0__length1 = self->priv->_metadata_directories_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
vala_code_context_set_metadata_directories (ValaCodeContext* self,
                                            gchar** value,
                                            gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	self->priv->_metadata_directories = (_vala_array_free (self->priv->_metadata_directories, self->priv->_metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_metadata_directories = _tmp0_;
	self->priv->_metadata_directories_length1 = _tmp0__length1;
	self->priv->__metadata_directories_size_ = self->priv->_metadata_directories_length1;
}

gboolean
vala_code_context_get_debug (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_debug;
	return result;
}

void
vala_code_context_set_debug (ValaCodeContext* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_debug = value;
}

gint
vala_code_context_get_optlevel (ValaCodeContext* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_optlevel;
	return result;
}

void
vala_code_context_set_optlevel (ValaCodeContext* self,
                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_optlevel = value;
}

gboolean
vala_code_context_get_mem_profiler (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mem_profiler;
	return result;
}

void
vala_code_context_set_mem_profiler (ValaCodeContext* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mem_profiler = value;
}

ValaMethod*
vala_code_context_get_module_init_method (ValaCodeContext* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_module_init_method;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_code_context_set_module_init_method (ValaCodeContext* self,
                                          ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	self->priv->_module_init_method = _tmp0_;
}

gboolean
vala_code_context_get_save_temps (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_save_temps;
	return result;
}

void
vala_code_context_set_save_temps (ValaCodeContext* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_save_temps = value;
}

ValaProfile
vala_code_context_get_profile (ValaCodeContext* self)
{
	ValaProfile result;
	ValaProfile _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_profile;
	result = _tmp0_;
	return result;
}

static void
vala_code_context_set_profile (ValaCodeContext* self,
                               ValaProfile value)
{
	g_return_if_fail (self != NULL);
	self->priv->_profile = value;
}

gboolean
vala_code_context_get_verbose_mode (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose_mode;
	return result;
}

void
vala_code_context_set_verbose_mode (ValaCodeContext* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_verbose_mode = value;
}

gboolean
vala_code_context_get_version_header (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_version_header;
	return result;
}

void
vala_code_context_set_version_header (ValaCodeContext* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_version_header = value;
}

gboolean
vala_code_context_get_use_fast_vapi (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_fast_vapi;
	return result;
}

void
vala_code_context_set_use_fast_vapi (ValaCodeContext* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_use_fast_vapi = value;
}

gboolean
vala_code_context_get_keep_going (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_keep_going;
	return result;
}

void
vala_code_context_set_keep_going (ValaCodeContext* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_keep_going = value;
}

gboolean
vala_code_context_get_vapi_comments (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_vapi_comments;
	return result;
}

void
vala_code_context_set_vapi_comments (ValaCodeContext* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_vapi_comments = value;
}

/**
 * Returns true if the target version of glib is greater than or
 * equal to the specified version.
 */
gboolean
vala_code_context_require_glib_version (ValaCodeContext* self,
                                        gint major,
                                        gint minor)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->target_glib_major > major) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->target_glib_major == major) {
			_tmp1_ = self->priv->target_glib_minor >= minor;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}

gboolean
vala_code_context_get_save_csources (ValaCodeContext* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_save_temps;
	result = _tmp0_;
	return result;
}

ValaReport*
vala_code_context_get_report (ValaCodeContext* self)
{
	ValaReport* result;
	ValaReport* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_report;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_report_ref0 (gpointer self)
{
	return self ? vala_report_ref (self) : NULL;
}

void
vala_code_context_set_report (ValaCodeContext* self,
                              ValaReport* value)
{
	ValaReport* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_report_ref0 (value);
	_vala_report_unref0 (self->priv->_report);
	self->priv->_report = _tmp0_;
}

ValaMethod*
vala_code_context_get_entry_point (ValaCodeContext* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_entry_point (ValaCodeContext* self,
                                   ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_entry_point);
	self->priv->_entry_point = _tmp0_;
}

const gchar*
vala_code_context_get_entry_point_name (ValaCodeContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry_point_name;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_entry_point_name (ValaCodeContext* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_entry_point_name);
	self->priv->_entry_point_name = _tmp0_;
}

gboolean
vala_code_context_get_run_output (ValaCodeContext* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_run_output;
	return result;
}

void
vala_code_context_set_run_output (ValaCodeContext* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_run_output = value;
}

gchar**
vala_code_context_get_gresources (ValaCodeContext* self,
                                  gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gresources;
	_tmp0__length1 = self->priv->_gresources_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
vala_code_context_set_gresources (ValaCodeContext* self,
                                  gchar** value,
                                  gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup4 (value, value_length1) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	self->priv->_gresources = (_vala_array_free (self->priv->_gresources, self->priv->_gresources_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_gresources = _tmp0_;
	self->priv->_gresources_length1 = _tmp0__length1;
	self->priv->__gresources_size_ = self->priv->_gresources_length1;
}

gchar**
vala_code_context_get_gresources_directories (ValaCodeContext* self,
                                              gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gresources_directories;
	_tmp0__length1 = self->priv->_gresources_directories_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
vala_code_context_set_gresources_directories (ValaCodeContext* self,
                                              gchar** value,
                                              gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup5 (value, value_length1) : ((gpointer) value);
	_tmp0__length1 = value_length1;
	self->priv->_gresources_directories = (_vala_array_free (self->priv->_gresources_directories, self->priv->_gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_gresources_directories = _tmp0_;
	self->priv->_gresources_directories_length1 = _tmp0__length1;
	self->priv->__gresources_directories_size_ = self->priv->_gresources_directories_length1;
}

ValaNamespace*
vala_code_context_get_root (ValaCodeContext* self)
{
	ValaNamespace* result;
	ValaNamespace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root;
	result = _tmp0_;
	return result;
}

ValaSymbolResolver*
vala_code_context_get_resolver (ValaCodeContext* self)
{
	ValaSymbolResolver* result;
	ValaSymbolResolver* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resolver;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_visitor_ref0 (gpointer self)
{
	return self ? vala_code_visitor_ref (self) : NULL;
}

static void
vala_code_context_set_resolver (ValaCodeContext* self,
                                ValaSymbolResolver* value)
{
	ValaSymbolResolver* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_vala_code_visitor_unref0 (self->priv->_resolver);
	self->priv->_resolver = _tmp0_;
}

ValaSemanticAnalyzer*
vala_code_context_get_analyzer (ValaCodeContext* self)
{
	ValaSemanticAnalyzer* result;
	ValaSemanticAnalyzer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_analyzer;
	result = _tmp0_;
	return result;
}

static void
vala_code_context_set_analyzer (ValaCodeContext* self,
                                ValaSemanticAnalyzer* value)
{
	ValaSemanticAnalyzer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_vala_code_visitor_unref0 (self->priv->_analyzer);
	self->priv->_analyzer = _tmp0_;
}

ValaFlowAnalyzer*
vala_code_context_get_flow_analyzer (ValaCodeContext* self)
{
	ValaFlowAnalyzer* result;
	ValaFlowAnalyzer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_flow_analyzer;
	result = _tmp0_;
	return result;
}

static void
vala_code_context_set_flow_analyzer (ValaCodeContext* self,
                                     ValaFlowAnalyzer* value)
{
	ValaFlowAnalyzer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_vala_code_visitor_unref0 (self->priv->_flow_analyzer);
	self->priv->_flow_analyzer = _tmp0_;
}

ValaCodeGenerator*
vala_code_context_get_codegen (ValaCodeContext* self)
{
	ValaCodeGenerator* result;
	ValaCodeGenerator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_codegen;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_codegen (ValaCodeContext* self,
                               ValaCodeGenerator* value)
{
	ValaCodeGenerator* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_vala_code_visitor_unref0 (self->priv->_codegen);
	self->priv->_codegen = _tmp0_;
}

ValaUsedAttr*
vala_code_context_get_used_attr (ValaCodeContext* self)
{
	ValaUsedAttr* result;
	ValaUsedAttr* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_used_attr;
	result = _tmp0_;
	return result;
}

void
vala_code_context_set_used_attr (ValaCodeContext* self,
                                 ValaUsedAttr* value)
{
	ValaUsedAttr* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_visitor_ref0 (value);
	_vala_code_visitor_unref0 (self->priv->_used_attr);
	self->priv->_used_attr = _tmp0_;
}

ValaCodeContext*
vala_code_context_construct (GType object_type)
{
	ValaCodeContext* self = NULL;
	ValaSymbolResolver* _tmp0_;
	ValaSymbolResolver* _tmp1_;
	ValaSemanticAnalyzer* _tmp2_;
	ValaSemanticAnalyzer* _tmp3_;
	ValaFlowAnalyzer* _tmp4_;
	ValaFlowAnalyzer* _tmp5_;
	ValaUsedAttr* _tmp6_;
	ValaUsedAttr* _tmp7_;
	self = (ValaCodeContext*) g_type_create_instance (object_type);
	vala_code_context_add_default_defines (self);
	_tmp0_ = vala_symbol_resolver_new ();
	_tmp1_ = _tmp0_;
	vala_code_context_set_resolver (self, _tmp1_);
	_vala_code_visitor_unref0 (_tmp1_);
	_tmp2_ = vala_semantic_analyzer_new ();
	_tmp3_ = _tmp2_;
	vala_code_context_set_analyzer (self, _tmp3_);
	_vala_code_visitor_unref0 (_tmp3_);
	_tmp4_ = vala_flow_analyzer_new ();
	_tmp5_ = _tmp4_;
	vala_code_context_set_flow_analyzer (self, _tmp5_);
	_vala_code_visitor_unref0 (_tmp5_);
	_tmp6_ = vala_used_attr_new ();
	_tmp7_ = _tmp6_;
	vala_code_context_set_used_attr (self, _tmp7_);
	_vala_code_visitor_unref0 (_tmp7_);
	return self;
}

ValaCodeContext*
vala_code_context_new (void)
{
	return vala_code_context_construct (VALA_TYPE_CODE_CONTEXT);
}

/**
 * Return the topmost context from the context stack.
 */
ValaCodeContext*
vala_code_context_get (void)
{
	ValaList* context_stack = NULL;
	void* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaList* _tmp2_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	ValaCodeContext* result = NULL;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp2_ = context_stack;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = context_stack;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == 0;
	}
	if (_tmp1_) {
		g_error ("valacodecontext.vala:259: internal: No context available to get");
	}
	_tmp6_ = context_stack;
	_tmp7_ = context_stack;
	_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_list_get (_tmp6_, _tmp9_ - 1);
	result = (ValaCodeContext*) _tmp10_;
	return result;
}

/**
 * Push the specified context to the context stack.
 */
void
vala_code_context_push (ValaCodeContext* context)
{
	ValaArrayList* context_stack = NULL;
	void* _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp5_;
	g_return_if_fail (context != NULL);
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp1_ = context_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_CODE_CONTEXT, (GBoxedCopyFunc) vala_code_context_ref, (GDestroyNotify) vala_code_context_unref, _tmp2_);
		context_stack = _tmp3_;
		_tmp4_ = context_stack;
		g_static_private_set (&vala_code_context_context_stack_key, _tmp4_, NULL);
	}
	_tmp5_ = context_stack;
	vala_collection_add ((ValaCollection*) _tmp5_, context);
}

/**
 * Remove the topmost context from the context stack.
 */
void
vala_code_context_pop (void)
{
	ValaList* context_stack = NULL;
	void* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaList* _tmp2_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	ValaCodeContext* _tmp11_;
	_tmp0_ = g_static_private_get (&vala_code_context_context_stack_key);
	context_stack = _tmp0_;
	_tmp2_ = context_stack;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = context_stack;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == 0;
	}
	if (_tmp1_) {
		g_error ("valacodecontext.vala:285: internal: No context available to pop");
	}
	_tmp6_ = context_stack;
	_tmp7_ = context_stack;
	_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_list_remove_at (_tmp6_, _tmp9_ - 1);
	_tmp11_ = (ValaCodeContext*) _tmp10_;
	_vala_code_context_unref0 (_tmp11_);
}

/**
 * Returns the list of source files.
 *
 * @return list of source files
 */
ValaList*
vala_code_context_get_source_files (ValaCodeContext* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->source_files;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of C source files.
 *
 * @return list of C source files
 */
ValaList*
vala_code_context_get_c_source_files (ValaCodeContext* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->c_source_files;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified file to the list of source files.
 *
 * @param file a source file
 */
void
vala_code_context_add_source_file (ValaCodeContext* self,
                                   ValaSourceFile* file)
{
	ValaMap* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaList* _tmp7_;
	ValaMap* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->source_files_map;
	_tmp1_ = vala_source_file_get_filename (file);
	_tmp2_ = _tmp1_;
	if (vala_map_contains (_tmp0_, _tmp2_)) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = vala_source_file_get_filename (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("Ignoring source file `%s', which was already added to this context", _tmp4_);
		_tmp6_ = _tmp5_;
		vala_report_warning (NULL, _tmp6_);
		_g_free0 (_tmp6_);
		return;
	}
	_tmp7_ = self->priv->source_files;
	vala_collection_add ((ValaCollection*) _tmp7_, file);
	_tmp8_ = self->priv->source_files_map;
	_tmp9_ = vala_source_file_get_filename (file);
	_tmp10_ = _tmp9_;
	vala_map_set (_tmp8_, _tmp10_, file);
}

/**
 * Returns the source file for a given path.
 *
 * @param filename a path to a source file
 * @return the source file if found
 */
ValaSourceFile*
vala_code_context_get_source_file (ValaCodeContext* self,
                                   const gchar* filename)
{
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaSourceFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = self->priv->source_files_map;
	_tmp1_ = vala_map_get (_tmp0_, filename);
	result = (ValaSourceFile*) _tmp1_;
	return result;
}

/**
 * Adds the specified file to the list of C source files.
 *
 * @param file a C source file
 */
void
vala_code_context_add_c_source_file (ValaCodeContext* self,
                                     const gchar* file)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->c_source_files;
	vala_collection_add ((ValaCollection*) _tmp0_, file);
}

/**
 * Returns the list of used packages.
 *
 * @return list of used packages
 */
ValaList*
vala_code_context_get_packages (ValaCodeContext* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->packages;
	result = _tmp0_;
	return result;
}

/**
 * Returns whether the specified package is being used.
 *
 * @param pkg a package name
 * @return    true if the specified package is being used
 */
gboolean
vala_code_context_has_package (ValaCodeContext* self,
                               const gchar* pkg)
{
	ValaList* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_tmp0_ = self->priv->packages;
	result = vala_collection_contains ((ValaCollection*) _tmp0_, pkg);
	return result;
}

/**
 * Adds the specified package to the list of used packages.
 *
 * @param pkg a package name
 */
void
vala_code_context_add_package (ValaCodeContext* self,
                               const gchar* pkg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pkg != NULL);
	_tmp0_ = self->priv->packages;
	vala_collection_add ((ValaCollection*) _tmp0_, pkg);
}

/**
 * Pull the specified package into the context.
 * The method is tolerant if the package has been already loaded.
 *
 * @param pkg a package name
 * @return false if the package could not be loaded
 *
 */
gboolean
vala_code_context_add_external_package (ValaCodeContext* self,
                                        const gchar* pkg)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* rpath = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	ValaSourceFile* source_file = NULL;
	const gchar* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp16_;
	gchar* deps_filename = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	if (vala_code_context_has_package (self, pkg)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_code_context_get_vapi_path (self, pkg);
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = vala_code_context_get_gir_path (self, pkg);
		_g_free0 (path);
		path = _tmp2_;
	}
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_strdup_printf ("Package `%s' not found in specified Vala API directories or GObject-In" \
"trospection GIR directories", pkg);
		_tmp5_ = _tmp4_;
		vala_report_error (NULL, _tmp5_);
		_g_free0 (_tmp5_);
		result = FALSE;
		_g_free0 (path);
		return result;
	}
	vala_code_context_add_package (self, pkg);
	_tmp6_ = path;
	_tmp7_ = vala_code_context_realpath (_tmp6_);
	rpath = _tmp7_;
	_tmp8_ = path;
	_tmp9_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp8_, NULL, FALSE);
	source_file = _tmp9_;
	_tmp10_ = source_file;
	vala_code_context_add_source_file (self, _tmp10_);
	_tmp11_ = rpath;
	_tmp12_ = path;
	if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
		ValaMap* _tmp13_;
		const gchar* _tmp14_;
		ValaSourceFile* _tmp15_;
		_tmp13_ = self->priv->source_files_map;
		_tmp14_ = rpath;
		_tmp15_ = source_file;
		vala_map_set (_tmp13_, _tmp14_, _tmp15_);
	}
	_tmp16_ = self->priv->_verbose_mode;
	if (_tmp16_) {
		FILE* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = stdout;
		_tmp18_ = path;
		fprintf (_tmp17_, "Loaded package `%s'\n", _tmp18_);
	}
	_tmp19_ = path;
	_tmp20_ = g_path_get_dirname (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (pkg, ".deps", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_build_path ("/", _tmp21_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	deps_filename = _tmp25_;
	_tmp26_ = deps_filename;
	if (!vala_code_context_add_packages_from_file (self, _tmp26_)) {
		result = FALSE;
		_g_free0 (deps_filename);
		_vala_source_file_unref0 (source_file);
		_g_free0 (rpath);
		_g_free0 (path);
		return result;
	}
	result = TRUE;
	_g_free0 (deps_filename);
	_vala_source_file_unref0 (source_file);
	_g_free0 (rpath);
	_g_free0 (path);
	return result;
}

/**
 * Read the given filename and pull in packages.
 * The method is tolerant if the file does not exist.
 *
 * @param filename a filename
 * @return false if an error occurs while reading the file or if a package could not be added
 */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gboolean
vala_code_context_add_packages_from_file (ValaCodeContext* self,
                                          const gchar* filename)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
		result = TRUE;
		return result;
	}
	{
		gchar* contents = NULL;
		gchar* _tmp0_ = NULL;
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		g_file_get_contents (filename, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			_g_free0 (contents);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp2_ = contents;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "\n", 0);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp4_;
			package_collection_length1 = _vala_array_length (_tmp3_);
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp5_;
				gchar* package = NULL;
				_tmp5_ = g_strdup (package_collection[package_it]);
				package = _tmp5_;
				{
					const gchar* _tmp6_;
					gchar* _tmp7_;
					const gchar* _tmp8_;
					_tmp6_ = package;
					_tmp7_ = string_strip (_tmp6_);
					_g_free0 (package);
					package = _tmp7_;
					_tmp8_ = package;
					if (g_strcmp0 (_tmp8_, "") != 0) {
						const gchar* _tmp9_;
						_tmp9_ = package;
						vala_code_context_add_external_package (self, _tmp9_);
					}
					_g_free0 (package);
				}
			}
			package_collection = (_vala_array_free (package_collection, package_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (contents);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup_printf ("Unable to read dependency file: %s", _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (NULL, _tmp13_);
		_g_free0 (_tmp13_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = TRUE;
	return result;
}

/**
 * Add the specified source file to the context. Only .vala, .vapi, .gs,
 * and .c extensions are supported.
 *
 * @param filename a filename
 * @param is_source true to force adding the file as .vala or .gs
 * @param cmdline true if the file came from the command line.
 * @return false if the file is not recognized or the file does not exist
 */
gboolean
vala_code_context_add_source_filename (ValaCodeContext* self,
                                       const gchar* filename,
                                       gboolean is_source,
                                       gboolean cmdline)
{
	gchar* rpath = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("%s not found", filename);
		_tmp1_ = _tmp0_;
		vala_report_error (NULL, _tmp1_);
		_g_free0 (_tmp1_);
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_realpath (filename);
	rpath = _tmp2_;
	if (is_source) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_str_has_suffix (filename, ".vala");
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_str_has_suffix (filename, ".gs");
	}
	if (_tmp3_) {
		ValaSourceFile* source_file = NULL;
		const gchar* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		ValaProfile _tmp8_;
		ValaSourceFile* _tmp28_;
		const gchar* _tmp29_;
		_tmp5_ = rpath;
		_tmp6_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp5_, NULL, cmdline);
		source_file = _tmp6_;
		_tmp7_ = source_file;
		vala_source_file_set_relative_filename (_tmp7_, filename);
		_tmp8_ = self->priv->_profile;
		if (_tmp8_ == VALA_PROFILE_POSIX) {
			ValaUsingDirective* ns_ref = NULL;
			ValaUnresolvedSymbol* _tmp9_;
			ValaUnresolvedSymbol* _tmp10_;
			ValaUsingDirective* _tmp11_;
			ValaUsingDirective* _tmp12_;
			ValaSourceFile* _tmp13_;
			ValaUsingDirective* _tmp14_;
			ValaNamespace* _tmp15_;
			ValaNamespace* _tmp16_;
			ValaUsingDirective* _tmp17_;
			_tmp9_ = vala_unresolved_symbol_new (NULL, "Posix", NULL);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_using_directive_new ((ValaSymbol*) _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_vala_code_node_unref0 (_tmp10_);
			ns_ref = _tmp12_;
			_tmp13_ = source_file;
			_tmp14_ = ns_ref;
			vala_source_file_add_using_directive (_tmp13_, _tmp14_);
			_tmp15_ = vala_code_context_get_root (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = ns_ref;
			vala_namespace_add_using_directive (_tmp16_, _tmp17_);
			_vala_code_node_unref0 (ns_ref);
		} else {
			ValaProfile _tmp18_;
			_tmp18_ = self->priv->_profile;
			if (_tmp18_ == VALA_PROFILE_GOBJECT) {
				ValaUsingDirective* ns_ref = NULL;
				ValaUnresolvedSymbol* _tmp19_;
				ValaUnresolvedSymbol* _tmp20_;
				ValaUsingDirective* _tmp21_;
				ValaUsingDirective* _tmp22_;
				ValaSourceFile* _tmp23_;
				ValaUsingDirective* _tmp24_;
				ValaNamespace* _tmp25_;
				ValaNamespace* _tmp26_;
				ValaUsingDirective* _tmp27_;
				_tmp19_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_using_directive_new ((ValaSymbol*) _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_vala_code_node_unref0 (_tmp20_);
				ns_ref = _tmp22_;
				_tmp23_ = source_file;
				_tmp24_ = ns_ref;
				vala_source_file_add_using_directive (_tmp23_, _tmp24_);
				_tmp25_ = vala_code_context_get_root (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = ns_ref;
				vala_namespace_add_using_directive (_tmp26_, _tmp27_);
				_vala_code_node_unref0 (ns_ref);
			}
		}
		_tmp28_ = source_file;
		vala_code_context_add_source_file (self, _tmp28_);
		_tmp29_ = rpath;
		if (g_strcmp0 (_tmp29_, filename) != 0) {
			ValaMap* _tmp30_;
			ValaSourceFile* _tmp31_;
			_tmp30_ = self->priv->source_files_map;
			_tmp31_ = source_file;
			vala_map_set (_tmp30_, filename, _tmp31_);
		}
		_vala_source_file_unref0 (source_file);
	} else {
		gboolean _tmp32_ = FALSE;
		if (g_str_has_suffix (filename, ".vapi")) {
			_tmp32_ = TRUE;
		} else {
			_tmp32_ = g_str_has_suffix (filename, ".gir");
		}
		if (_tmp32_) {
			ValaSourceFile* source_file = NULL;
			const gchar* _tmp33_;
			ValaSourceFile* _tmp34_;
			ValaSourceFile* _tmp35_;
			ValaSourceFile* _tmp36_;
			const gchar* _tmp37_;
			_tmp33_ = rpath;
			_tmp34_ = vala_source_file_new (self, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp33_, NULL, cmdline);
			source_file = _tmp34_;
			_tmp35_ = source_file;
			vala_source_file_set_relative_filename (_tmp35_, filename);
			_tmp36_ = source_file;
			vala_code_context_add_source_file (self, _tmp36_);
			_tmp37_ = rpath;
			if (g_strcmp0 (_tmp37_, filename) != 0) {
				ValaMap* _tmp38_;
				ValaSourceFile* _tmp39_;
				_tmp38_ = self->priv->source_files_map;
				_tmp39_ = source_file;
				vala_map_set (_tmp38_, filename, _tmp39_);
			}
			_vala_source_file_unref0 (source_file);
		} else {
			if (g_str_has_suffix (filename, ".c")) {
				const gchar* _tmp40_;
				_tmp40_ = rpath;
				vala_code_context_add_c_source_file (self, _tmp40_);
			} else {
				if (g_str_has_suffix (filename, ".h")) {
				} else {
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp41_ = g_strdup_printf ("%s is not a supported source file type. Only .vala, .vapi, .gs, and .c" \
" files are supported.", filename);
					_tmp42_ = _tmp41_;
					vala_report_error (NULL, _tmp42_);
					_g_free0 (_tmp42_);
					result = FALSE;
					_g_free0 (rpath);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (rpath);
	return result;
}

/**
 * Visits the complete code tree file by file.
 * It is possible to add new source files while visiting the tree.
 *
 * @param visitor the visitor to be called when traversing
 */
void
vala_code_context_accept (ValaCodeContext* self,
                          ValaCodeVisitor* visitor)
{
	ValaNamespace* _tmp0_;
	ValaNamespace* _tmp1_;
	gint index = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_code_context_get_root (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	index = 0;
	while (TRUE) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		ValaSourceFile* source_file = NULL;
		ValaList* _tmp5_;
		gpointer _tmp6_;
		ValaSourceFile* _tmp7_;
		gint _tmp8_;
		_tmp2_ = self->priv->source_files;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (!(index < _tmp4_)) {
			break;
		}
		_tmp5_ = self->priv->source_files;
		_tmp6_ = vala_list_get (_tmp5_, index);
		source_file = (ValaSourceFile*) _tmp6_;
		_tmp7_ = source_file;
		vala_source_file_accept (_tmp7_, visitor);
		_tmp8_ = index;
		index = _tmp8_ + 1;
		_vala_source_file_unref0 (source_file);
	}
}

/**
 * Resolve and analyze.
 */
void
vala_code_context_check (ValaCodeContext* self)
{
	ValaSymbolResolver* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaReport* _tmp5_;
	ValaFlowAnalyzer* _tmp6_;
	ValaReport* _tmp7_;
	ValaUsedAttr* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_resolver;
	vala_symbol_resolver_resolve (_tmp0_, self);
	_tmp2_ = self->priv->_keep_going;
	if (!_tmp2_) {
		ValaReport* _tmp3_;
		_tmp3_ = self->priv->_report;
		_tmp1_ = vala_report_get_errors (_tmp3_) > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	_tmp4_ = self->priv->_analyzer;
	vala_semantic_analyzer_analyze (_tmp4_, self);
	_tmp5_ = self->priv->_report;
	if (vala_report_get_errors (_tmp5_) > 0) {
		return;
	}
	_tmp6_ = self->priv->_flow_analyzer;
	vala_flow_analyzer_analyze (_tmp6_, self);
	_tmp7_ = self->priv->_report;
	if (vala_report_get_errors (_tmp7_) > 0) {
		return;
	}
	_tmp8_ = self->priv->_used_attr;
	vala_used_attr_check_unused (_tmp8_, self);
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

void
vala_code_context_add_define (ValaCodeContext* self,
                              const gchar* define)
{
	ValaSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (define != NULL);
	if (vala_code_context_is_defined (self, define)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("`%s' is already defined", define);
		_tmp1_ = _tmp0_;
		vala_report_warning (NULL, _tmp1_);
		_g_free0 (_tmp1_);
		if (g_regex_match_all (_thread_safe_regex_init (&_tmp_regex_0, "VALA_0_\\d+", 0), define, 0, NULL)) {
			vala_report_warning (NULL, "`VALA_0_XX' defines are automatically added up to current compiler ver" \
"sion in use");
		} else {
			if (g_regex_match_all (_thread_safe_regex_init (&_tmp_regex_1, "GLIB_2_\\d+", 0), define, 0, NULL)) {
				vala_report_warning (NULL, "`GLIB_2_XX' defines are automatically added up to targeted glib versio" \
"n");
			}
		}
	}
	_tmp2_ = self->priv->defines;
	vala_collection_add ((ValaCollection*) _tmp2_, define);
}

gboolean
vala_code_context_is_defined (ValaCodeContext* self,
                              const gchar* define)
{
	ValaSet* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (define != NULL, FALSE);
	_tmp0_ = self->priv->defines;
	result = vala_collection_contains ((ValaCollection*) _tmp0_, define);
	return result;
}

static void
vala_code_context_add_default_defines (ValaCodeContext* self)
{
	gint api_major = 0;
	gint api_minor = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	api_major = 0;
	api_minor = 0;
	_tmp4_ = sscanf (VALA_API_VERSION, "%d.%d", &_tmp2_, &_tmp3_);
	api_major = _tmp2_;
	api_minor = _tmp3_;
	if (_tmp4_ != 2) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = api_major > 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (api_minor % 2) != 0;
	}
	if (_tmp0_) {
		vala_report_error (NULL, "Invalid format for Vala.API_VERSION");
		return;
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaSet* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp5_) {
					i += 2;
				}
				_tmp5_ = FALSE;
				if (!(i <= api_minor)) {
					break;
				}
				_tmp6_ = self->priv->defines;
				_tmp7_ = g_strdup_printf ("VALA_0_%d", i);
				_tmp8_ = _tmp7_;
				vala_collection_add ((ValaCollection*) _tmp6_, _tmp8_);
				_g_free0 (_tmp8_);
			}
		}
	}
	self->priv->target_glib_major = 2;
	self->priv->target_glib_minor = 48;
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				ValaSet* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				if (!_tmp9_) {
					i += 2;
				}
				_tmp9_ = FALSE;
				if (!(i <= self->priv->target_glib_minor)) {
					break;
				}
				_tmp10_ = self->priv->defines;
				_tmp11_ = g_strdup_printf ("GLIB_2_%d", i);
				_tmp12_ = _tmp11_;
				vala_collection_add ((ValaCollection*) _tmp10_, _tmp12_);
				_g_free0 (_tmp12_);
			}
		}
	}
}

/**
 * Set the target profile for code generation.
 *
 * This must be called once.
 *
 * @param profile the profile to use
 * @param include_stdpkg whether to include profile-specific default packages
 */
void
vala_code_context_set_target_profile (ValaCodeContext* self,
                                      ValaProfile profile,
                                      gboolean include_stdpkg)
{
	g_return_if_fail (self != NULL);
	switch (profile) {
		default:
		case VALA_PROFILE_GOBJECT:
		{
			vala_code_context_set_profile (self, profile);
			vala_code_context_add_define (self, "GOBJECT");
			if (include_stdpkg) {
				vala_code_context_add_external_package (self, "glib-2.0");
				vala_code_context_add_external_package (self, "gobject-2.0");
			}
			break;
		}
		case VALA_PROFILE_POSIX:
		{
			vala_code_context_set_profile (self, profile);
			vala_code_context_add_define (self, "POSIX");
			if (include_stdpkg) {
				vala_code_context_add_external_package (self, "posix");
			}
			break;
		}
	}
}

/**
 * Set the target version of glib for code generation.
 *
 * This may be called once or not at all.
 *
 * @param target_glib a string of the format "%d.%d"
 */
void
vala_code_context_set_target_glib_version (ValaCodeContext* self,
                                           const gchar* target_glib)
{
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_glib != NULL);
	glib_major = 0;
	glib_minor = 0;
	if (g_strcmp0 (target_glib, "auto") == 0) {
		gchar* available_glib = NULL;
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		_tmp0_ = vala_code_context_pkg_config_modversion (self, "glib-2.0");
		available_glib = _tmp0_;
		_tmp2_ = available_glib;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
			gint _tmp6_;
			_tmp3_ = available_glib;
			_tmp6_ = sscanf (_tmp3_, "%d.%d", &_tmp4_, &_tmp5_);
			glib_major = _tmp4_;
			glib_minor = _tmp5_;
			_tmp1_ = _tmp6_ >= 2;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = glib_minor;
			glib_minor = _tmp7_ + 1;
			glib_minor -= glib_minor % 2;
			_tmp8_ = g_strdup_printf ("%d.%d", glib_major, glib_minor);
			_tmp9_ = _tmp8_;
			vala_code_context_set_target_glib_version (self, _tmp9_);
			_g_free0 (_tmp9_);
		} else {
			vala_report_warning (NULL, "Could not determine the version of `glib-2.0', target version of glib " \
"was not set");
		}
		_g_free0 (available_glib);
		return;
	}
	glib_major = self->priv->target_glib_major;
	glib_minor = self->priv->target_glib_minor;
	if (target_glib != NULL) {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_;
		_tmp14_ = sscanf (target_glib, "%d.%d", &_tmp12_, &_tmp13_);
		glib_major = _tmp12_;
		glib_minor = _tmp13_;
		_tmp11_ = _tmp14_ != 2;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = (glib_minor % 2) != 0;
	}
	if (_tmp10_) {
		vala_report_error (NULL, "Only a stable version of GLib can be targeted, use MAJOR.MINOR format " \
"with MINOR as an even number");
	}
	if (glib_major != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	if (glib_minor <= self->priv->target_glib_minor) {
		return;
	}
	{
		gint i = 0;
		i = self->priv->target_glib_major + 2;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				ValaSet* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp15_) {
					i += 2;
				}
				_tmp15_ = FALSE;
				if (!(i <= glib_minor)) {
					break;
				}
				_tmp16_ = self->priv->defines;
				_tmp17_ = g_strdup_printf ("GLIB_2_%d", i);
				_tmp18_ = _tmp17_;
				vala_collection_add ((ValaCollection*) _tmp16_, _tmp18_);
				_g_free0 (_tmp18_);
			}
		}
	}
	self->priv->target_glib_major = glib_major;
	self->priv->target_glib_minor = glib_minor;
}

gchar*
vala_code_context_get_vapi_path (ValaCodeContext* self,
                                 const gchar* pkg)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	_tmp0_ = g_strconcat (pkg, ".vapi", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_vapi_directories (self, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = vala_code_context_get_file_path (self, _tmp1_, "vala" PACKAGE_SUFFIX "/vapi", "vala/vapi", _tmp4_, (gint) _tmp4__length1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp1_);
	path = _tmp6_;
	_tmp7_ = path;
	if (_tmp7_ == NULL) {
		gchar* filename = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = g_strconcat (pkg, ".vapi", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_build_path ("/", PACKAGE_DATADIR, "vapi", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		filename = _tmp11_;
		_tmp12_ = filename;
		if (g_file_test (_tmp12_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = filename;
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (path);
			path = _tmp14_;
		}
		_g_free0 (filename);
	}
	result = path;
	return result;
}

gchar*
vala_code_context_get_gir_path (ValaCodeContext* self,
                                const gchar* gir)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir != NULL, NULL);
	_tmp0_ = g_strconcat (gir, ".gir", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_gir_directories (self, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = vala_code_context_get_file_path (self, _tmp1_, "gir-1.0", NULL, _tmp4_, (gint) _tmp4__length1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp1_);
	result = _tmp6_;
	return result;
}

gchar*
vala_code_context_get_gresource_path (ValaCodeContext* self,
                                      const gchar* gresource,
                                      const gchar* resource)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gresource != NULL, NULL);
	g_return_val_if_fail (resource != NULL, NULL);
	_tmp0_ = g_path_get_dirname (gresource);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = vala_code_context_get_file_path (self, resource, NULL, NULL, _tmp2_, (gint) 1);
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	filename = _tmp4_;
	_tmp5_ = filename;
	if (_tmp5_ == NULL) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		gint _tmp7_ = 0;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		_tmp6_ = vala_code_context_get_gresources_directories (self, &_tmp7_);
		_tmp6__length1 = _tmp7_;
		_tmp8_ = _tmp6_;
		_tmp8__length1 = _tmp6__length1;
		_tmp9_ = vala_code_context_get_file_path (self, resource, NULL, NULL, _tmp8_, (gint) _tmp8__length1);
		_g_free0 (filename);
		filename = _tmp9_;
	}
	result = filename;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
vala_code_context_get_metadata_path (ValaCodeContext* self,
                                     const gchar* gir_filename)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	gchar* metadata_basename = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* metadata_filename = NULL;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_filename != NULL, NULL);
	_tmp0_ = g_path_get_basename (gir_filename);
	basename = _tmp0_;
	_tmp1_ = basename;
	_tmp2_ = basename;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = strlen (".gir");
	_tmp6_ = _tmp5_;
	_tmp7_ = string_substring (_tmp1_, (glong) 0, (glong) (_tmp4_ - _tmp6_));
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s.metadata", _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	metadata_basename = _tmp10_;
	_tmp11_ = metadata_basename;
	_tmp12_ = vala_code_context_get_metadata_directories (self, &_tmp13_);
	_tmp12__length1 = _tmp13_;
	_tmp14_ = _tmp12_;
	_tmp14__length1 = _tmp12__length1;
	_tmp15_ = vala_code_context_get_file_path (self, _tmp11_, NULL, NULL, _tmp14_, (gint) _tmp14__length1);
	metadata_filename = _tmp15_;
	_tmp16_ = metadata_filename;
	if (_tmp16_ != NULL) {
		result = metadata_filename;
		_g_free0 (metadata_basename);
		_g_free0 (basename);
		return result;
	}
	_tmp17_ = g_path_get_dirname (gir_filename);
	_tmp18_ = _tmp17_;
	_tmp19_ = metadata_basename;
	_tmp20_ = g_build_path ("/", _tmp18_, _tmp19_, NULL);
	_g_free0 (metadata_filename);
	metadata_filename = _tmp20_;
	_g_free0 (_tmp18_);
	_tmp21_ = metadata_filename;
	if (g_file_test (_tmp21_, G_FILE_TEST_EXISTS)) {
		result = metadata_filename;
		_g_free0 (metadata_basename);
		_g_free0 (basename);
		return result;
	}
	result = NULL;
	_g_free0 (metadata_filename);
	_g_free0 (metadata_basename);
	_g_free0 (basename);
	return result;
}

static gchar*
vala_code_context_get_file_path (ValaCodeContext* self,
                                 const gchar* basename,
                                 const gchar* versioned_data_dir,
                                 const gchar* data_dir,
                                 gchar** directories,
                                 gint directories_length1)
{
	gchar* filename = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	filename = NULL;
	if (directories != NULL) {
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = directories;
			dir_collection_length1 = directories_length1;
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				const gchar* dir = NULL;
				dir = dir_collection[dir_it];
				{
					const gchar* _tmp0_;
					gchar* _tmp1_;
					const gchar* _tmp2_;
					_tmp0_ = dir;
					_tmp1_ = g_build_path ("/", _tmp0_, basename, NULL);
					_g_free0 (filename);
					filename = _tmp1_;
					_tmp2_ = filename;
					if (g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
						result = filename;
						return result;
					}
				}
			}
		}
	}
	if (data_dir != NULL) {
		gchar** _tmp3_;
		gchar** _tmp4_;
		_tmp4_ = _tmp3_ = g_get_system_data_dirs ();
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp4_;
			dir_collection_length1 = _vala_array_length (_tmp3_);
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				const gchar* dir = NULL;
				dir = dir_collection[dir_it];
				{
					const gchar* _tmp5_;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = dir;
					_tmp6_ = g_build_path ("/", _tmp5_, data_dir, basename, NULL);
					_g_free0 (filename);
					filename = _tmp6_;
					_tmp7_ = filename;
					if (g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
						result = filename;
						return result;
					}
				}
			}
		}
	}
	if (versioned_data_dir != NULL) {
		gchar** _tmp8_;
		gchar** _tmp9_;
		_tmp9_ = _tmp8_ = g_get_system_data_dirs ();
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp9_;
			dir_collection_length1 = _vala_array_length (_tmp8_);
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				const gchar* dir = NULL;
				dir = dir_collection[dir_it];
				{
					const gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp10_ = dir;
					_tmp11_ = g_build_path ("/", _tmp10_, versioned_data_dir, basename, NULL);
					_g_free0 (filename);
					filename = _tmp11_;
					_tmp12_ = filename;
					if (g_file_test (_tmp12_, G_FILE_TEST_EXISTS)) {
						result = filename;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	_g_free0 (filename);
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_code_context_write_dependencies (ValaCodeContext* self,
                                      const gchar* filename)
{
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* _tmp4_;
	FILE* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_fopen (filename, "w");
	stream = _tmp0_;
	_tmp1_ = stream;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("unable to open `%s' for writing", filename);
		_tmp3_ = _tmp2_;
		vala_report_error (NULL, _tmp3_);
		_g_free0 (_tmp3_);
		_fclose0 (stream);
		return;
	}
	_tmp4_ = stream;
	fprintf (_tmp4_, "%s:", filename);
	{
		ValaList* _src_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _src_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _src_index = 0;
		_tmp5_ = self->priv->source_files;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_src_list = _tmp6_;
		_tmp7_ = _src_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_src_size = _tmp9_;
		_src_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaSourceFile* src = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaSourceFile* _tmp15_;
			ValaSourceFileType _tmp16_;
			ValaSourceFileType _tmp17_;
			_src_index = _src_index + 1;
			_tmp10_ = _src_index;
			_tmp11_ = _src_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _src_list;
			_tmp13_ = vala_list_get (_tmp12_, _src_index);
			src = (ValaSourceFile*) _tmp13_;
			_tmp15_ = src;
			_tmp16_ = vala_source_file_get_file_type (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == VALA_SOURCE_FILE_TYPE_FAST) {
				ValaSourceFile* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp18_ = src;
				_tmp19_ = vala_source_file_get_used (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp14_ = _tmp20_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				FILE* _tmp21_;
				ValaSourceFile* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp21_ = stream;
				_tmp22_ = src;
				_tmp23_ = vala_source_file_get_filename (_tmp22_);
				_tmp24_ = _tmp23_;
				fprintf (_tmp21_, " %s", _tmp24_);
			}
			_vala_source_file_unref0 (src);
		}
		_vala_iterable_unref0 (_src_list);
	}
	_tmp25_ = stream;
	fprintf (_tmp25_, "\n\n");
	_fclose0 (stream);
}

void
vala_code_context_write_external_dependencies (ValaCodeContext* self,
                                               const gchar* filename)
{
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gboolean first = FALSE;
	FILE* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_fopen (filename, "w");
	stream = _tmp0_;
	_tmp1_ = stream;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("unable to open `%s' for writing", filename);
		_tmp3_ = _tmp2_;
		vala_report_error (NULL, _tmp3_);
		_g_free0 (_tmp3_);
		_fclose0 (stream);
		return;
	}
	first = TRUE;
	{
		ValaList* _src_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _src_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _src_index = 0;
		_tmp4_ = self->priv->source_files;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_src_list = _tmp5_;
		_tmp6_ = _src_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_src_size = _tmp8_;
		_src_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaSourceFile* src = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValaSourceFile* _tmp14_;
			ValaSourceFileType _tmp15_;
			ValaSourceFileType _tmp16_;
			_src_index = _src_index + 1;
			_tmp9_ = _src_index;
			_tmp10_ = _src_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _src_list;
			_tmp12_ = vala_list_get (_tmp11_, _src_index);
			src = (ValaSourceFile*) _tmp12_;
			_tmp14_ = src;
			_tmp15_ = vala_source_file_get_file_type (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ != VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp17_;
				gboolean _tmp18_;
				gboolean _tmp19_;
				_tmp17_ = src;
				_tmp18_ = vala_source_file_get_used (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp13_ = _tmp19_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				FILE* _tmp22_;
				ValaSourceFile* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				if (first) {
					FILE* _tmp20_;
					first = FALSE;
					_tmp20_ = stream;
					fprintf (_tmp20_, "%s: ", filename);
				} else {
					FILE* _tmp21_;
					_tmp21_ = stream;
					fputs (" \\\n\t", _tmp21_);
				}
				_tmp22_ = stream;
				_tmp23_ = src;
				_tmp24_ = vala_source_file_get_filename (_tmp23_);
				_tmp25_ = _tmp24_;
				fprintf (_tmp22_, "%s", _tmp25_);
			}
			_vala_source_file_unref0 (src);
		}
		_vala_iterable_unref0 (_src_list);
	}
	_tmp26_ = stream;
	fputs ("\n\n", _tmp26_);
	_fclose0 (stream);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
vala_code_context_ends_with_dir_separator (const gchar* s)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	result = G_IS_DIR_SEPARATOR (string_get_char (s, (glong) (_tmp1_ - 1)));
	return result;
}

/**
 * Returns canonicalized absolute pathname
 * ported from glibc
 *
 * @param name the path being checked
 * @return a canonicalized absolute pathname
 */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

gchar*
vala_code_context_realpath (const gchar* name)
{
	gchar* rpath = NULL;
	const gchar* start = NULL;
	const gchar* end = NULL;
	glong root_len = 0L;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gchar* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	if (!g_path_is_absolute (name)) {
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = g_get_current_dir ();
		_g_free0 (rpath);
		rpath = _tmp0_;
		end = name;
		_tmp1_ = end;
		start = _tmp1_;
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = g_path_skip_root (name);
		end = _tmp2_;
		_tmp3_ = end;
		start = _tmp3_;
		_tmp4_ = start;
		_tmp5_ = string_substring (name, (glong) 0, (glong) ((gint) (((gchar*) _tmp4_) - ((gchar*) name))));
		_g_free0 (rpath);
		rpath = _tmp5_;
	}
	_tmp6_ = rpath;
	_tmp7_ = g_path_skip_root (_tmp6_);
	_tmp8_ = rpath;
	root_len = (glong) (((gchar*) _tmp7_) - ((gchar*) _tmp8_));
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			const gchar* _tmp11_;
			glong len = 0L;
			if (!_tmp9_) {
				const gchar* _tmp10_;
				_tmp10_ = end;
				start = _tmp10_;
			}
			_tmp9_ = FALSE;
			_tmp11_ = start;
			if (!(string_get_char (_tmp11_, (glong) 0) != ((gunichar) 0))) {
				break;
			}
			while (TRUE) {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = start;
				if (!G_IS_DIR_SEPARATOR (string_get_char (_tmp12_, (glong) 0))) {
					break;
				}
				_tmp13_ = start;
				_tmp14_ = g_utf8_next_char (_tmp13_);
				start = _tmp14_;
			}
			len = (glong) 0;
			{
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = start;
				end = _tmp15_;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_;
					glong _tmp22_;
					if (!_tmp16_) {
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						_tmp17_ = end;
						_tmp18_ = g_utf8_next_char (_tmp17_);
						end = _tmp18_;
					}
					_tmp16_ = FALSE;
					_tmp20_ = end;
					if (string_get_char (_tmp20_, (glong) 0) != ((gunichar) 0)) {
						const gchar* _tmp21_;
						_tmp21_ = end;
						_tmp19_ = !G_IS_DIR_SEPARATOR (string_get_char (_tmp21_, (glong) 0));
					} else {
						_tmp19_ = FALSE;
					}
					if (!_tmp19_) {
						break;
					}
					_tmp22_ = len;
					len = _tmp22_ + 1;
				}
			}
			if (len == ((glong) 0)) {
				break;
			} else {
				gboolean _tmp23_ = FALSE;
				if (len == ((glong) 1)) {
					const gchar* _tmp24_;
					_tmp24_ = start;
					_tmp23_ = string_get_char (_tmp24_, (glong) 0) == ((gunichar) '.');
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
				} else {
					gboolean _tmp25_ = FALSE;
					if (len == ((glong) 2)) {
						const gchar* _tmp26_;
						_tmp26_ = start;
						_tmp25_ = g_str_has_prefix (_tmp26_, "..");
					} else {
						_tmp25_ = FALSE;
					}
					if (_tmp25_) {
						const gchar* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						_tmp27_ = rpath;
						_tmp28_ = strlen (_tmp27_);
						_tmp29_ = _tmp28_;
						if (((glong) _tmp29_) > root_len) {
							{
								gboolean _tmp30_ = FALSE;
								_tmp30_ = TRUE;
								while (TRUE) {
									const gchar* _tmp32_;
									const gchar* _tmp33_;
									gint _tmp34_;
									gint _tmp35_;
									gchar* _tmp36_;
									if (!_tmp30_) {
										const gchar* _tmp31_;
										_tmp31_ = rpath;
										if (!(!vala_code_context_ends_with_dir_separator (_tmp31_))) {
											break;
										}
									}
									_tmp30_ = FALSE;
									_tmp32_ = rpath;
									_tmp33_ = rpath;
									_tmp34_ = strlen (_tmp33_);
									_tmp35_ = _tmp34_;
									_tmp36_ = string_substring (_tmp32_, (glong) 0, (glong) (_tmp35_ - 1));
									_g_free0 (rpath);
									rpath = _tmp36_;
								}
							}
						}
					} else {
						const gchar* _tmp37_;
						const gchar* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp37_ = rpath;
						if (!vala_code_context_ends_with_dir_separator (_tmp37_)) {
							const gchar* _tmp38_;
							gchar* _tmp39_;
							_tmp38_ = rpath;
							_tmp39_ = g_strconcat (_tmp38_, G_DIR_SEPARATOR_S, NULL);
							_g_free0 (rpath);
							rpath = _tmp39_;
						}
						_tmp40_ = rpath;
						_tmp41_ = start;
						_tmp42_ = end;
						_tmp43_ = start;
						_tmp44_ = string_substring (_tmp41_, (glong) 0, (glong) (((gchar*) _tmp42_) - ((gchar*) _tmp43_)));
						_tmp45_ = _tmp44_;
						_tmp46_ = g_strconcat (_tmp40_, _tmp45_, NULL);
						_g_free0 (rpath);
						rpath = _tmp46_;
						_g_free0 (_tmp45_);
					}
				}
			}
		}
	}
	_tmp48_ = rpath;
	_tmp49_ = strlen (_tmp48_);
	_tmp50_ = _tmp49_;
	if (((glong) _tmp50_) > root_len) {
		const gchar* _tmp51_;
		_tmp51_ = rpath;
		_tmp47_ = vala_code_context_ends_with_dir_separator (_tmp51_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gchar* _tmp56_;
		_tmp52_ = rpath;
		_tmp53_ = rpath;
		_tmp54_ = strlen (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = string_substring (_tmp52_, (glong) 0, (glong) (_tmp55_ - 1));
		_g_free0 (rpath);
		rpath = _tmp56_;
	}
	if (G_DIR_SEPARATOR != '/') {
		gchar** components = NULL;
		const gchar* _tmp57_;
		gchar** _tmp58_;
		gchar** _tmp59_;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		gchar* _tmp61_;
		_tmp57_ = rpath;
		_tmp59_ = _tmp58_ = g_strsplit (_tmp57_, "\\", 0);
		components = _tmp59_;
		components_length1 = _vala_array_length (_tmp58_);
		_components_size_ = components_length1;
		_tmp60_ = components;
		_tmp60__length1 = components_length1;
		_tmp61_ = _vala_g_strjoinv ("/", _tmp60_, (gint) _tmp60__length1);
		_g_free0 (rpath);
		rpath = _tmp61_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}

gboolean
vala_code_context_pkg_config_exists (ValaCodeContext* self,
                                     const gchar* package_name)
{
	gchar* pc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint exit_status = 0;
	gboolean _tmp9_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (package_name != NULL, FALSE);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --exists ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, package_name, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pc = _tmp4_;
	{
		gint _tmp5_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp5_, &_inner_error0_);
		exit_status = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		vala_report_error (NULL, _tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally0:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp9_;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
vala_code_context_pkg_config_modversion (ValaCodeContext* self,
                                         const gchar* package_name)
{
	gchar* pc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* output = NULL;
	gint exit_status = 0;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (package_name != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --silence-errors --modversion ", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, package_name, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pc = _tmp4_;
	output = NULL;
	{
		gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		g_spawn_command_line_sync (pc, &_tmp5_, NULL, &_tmp6_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp5_;
		exit_status = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (exit_status == 0) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = output;
			_tmp8_ = string_slice (_tmp7_, (glong) 0, (glong) -1);
			_g_free0 (output);
			output = _tmp8_;
			_tmp9_ = output;
			if (g_strcmp0 (_tmp9_, "") == 0) {
				_g_free0 (output);
				output = NULL;
			}
		} else {
			_g_free0 (output);
			output = NULL;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		g_clear_error (&_inner_error0_);
		_g_free0 (output);
		output = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = output;
	_g_free0 (pc);
	return result;
}

gchar*
vala_code_context_pkg_config_compile_flags (ValaCodeContext* self,
                                            const gchar* package_name)
{
	gchar* pc = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* output = NULL;
	gint exit_status = 0;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (package_name != NULL, NULL);
	_tmp0_ = self->priv->_pkg_config_command;
	_tmp1_ = g_strconcat (_tmp0_, " --cflags", NULL);
	pc = _tmp1_;
	_tmp2_ = self->priv->_compile_only;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = pc;
		_tmp4_ = g_strconcat (_tmp3_, " --libs", NULL);
		_g_free0 (pc);
		pc = _tmp4_;
	}
	_tmp5_ = pc;
	_tmp6_ = g_strconcat (_tmp5_, package_name, NULL);
	_g_free0 (pc);
	pc = _tmp6_;
	output = NULL;
	{
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp7_ = pc;
		g_spawn_command_line_sync (_tmp7_, &_tmp8_, NULL, &_tmp9_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp8_;
		exit_status = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (exit_status != 0) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = self->priv->_pkg_config_command;
			_tmp11_ = g_strdup_printf ("%s exited with status %d", _tmp10_, exit_status);
			_tmp12_ = _tmp11_;
			vala_report_error (NULL, _tmp12_);
			_g_free0 (_tmp12_);
			result = NULL;
			_g_free0 (output);
			_g_free0 (pc);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		vala_report_error (NULL, _tmp14_);
		_g_free0 (output);
		output = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (output);
		_g_free0 (pc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = output;
	_g_free0 (pc);
	return result;
}

static void
vala_value_code_context_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_code_context_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_code_context_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_code_context_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_code_context_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_code_context_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCodeContext * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_code_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_code_context_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	ValaCodeContext ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_param_spec_code_context (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ValaParamSpecCodeContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_value_get_code_context (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}

void
vala_value_set_code_context (GValue* value,
                             gpointer v_object)
{
	ValaCodeContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}

void
vala_value_take_code_context (GValue* value,
                              gpointer v_object)
{
	ValaCodeContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_context_unref (old);
	}
}

static void
vala_code_context_class_init (ValaCodeContextClass * klass,
                              gpointer klass_data)
{
	vala_code_context_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeContextClass *) klass)->finalize = vala_code_context_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCodeContext_private_offset);
	g_static_private_init (&vala_code_context_context_stack_key);
	vala_code_context_context_stack_key = vala_code_context_context_stack_key;
}

static void
vala_code_context_instance_init (ValaCodeContext * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	ValaReport* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	ValaNamespace* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	ValaHashSet* _tmp20_;
	self->priv = vala_code_context_get_instance_private (self);
	_tmp0_ = g_strdup ("pkg-config");
	self->priv->_pkg_config_command = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->_vapi_directories = _tmp1_;
	self->priv->_vapi_directories_length1 = 0;
	self->priv->__vapi_directories_size_ = self->priv->_vapi_directories_length1;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->_gir_directories = _tmp2_;
	self->priv->_gir_directories_length1 = 0;
	self->priv->__gir_directories_size_ = self->priv->_gir_directories_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->_metadata_directories = _tmp3_;
	self->priv->_metadata_directories_length1 = 0;
	self->priv->__metadata_directories_size_ = self->priv->_metadata_directories_length1;
	_tmp4_ = vala_report_new ();
	self->priv->_report = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	self->priv->_gresources = _tmp5_;
	self->priv->_gresources_length1 = 0;
	self->priv->__gresources_size_ = self->priv->_gresources_length1;
	_tmp6_ = g_new0 (gchar*, 0 + 1);
	self->priv->_gresources_directories = _tmp6_;
	self->priv->_gresources_directories_length1 = 0;
	self->priv->__gresources_directories_size_ = self->priv->_gresources_directories_length1;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_SOURCE_FILE, (GBoxedCopyFunc) vala_source_file_ref, (GDestroyNotify) vala_source_file_unref, _tmp7_);
	self->priv->source_files = (ValaList*) _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SOURCE_FILE, NULL, NULL, _tmp9_, _tmp10_, _tmp11_);
	self->priv->source_files_map = (ValaMap*) _tmp12_;
	_tmp13_ = g_str_equal;
	_tmp14_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp13_);
	self->priv->c_source_files = (ValaList*) _tmp14_;
	_tmp15_ = vala_namespace_new (NULL, NULL);
	self->priv->_root = _tmp15_;
	_tmp16_ = g_str_equal;
	_tmp17_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp16_);
	self->priv->packages = (ValaList*) _tmp17_;
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp18_, _tmp19_);
	self->priv->defines = (ValaSet*) _tmp20_;
	self->ref_count = 1;
}

static void
vala_code_context_finalize (ValaCodeContext * obj)
{
	ValaCodeContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_CONTEXT, ValaCodeContext);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_pkg_config_command);
	_g_free0 (self->priv->_header_filename);
	_g_free0 (self->priv->_internal_header_filename);
	_g_free0 (self->priv->_includedir);
	_g_free0 (self->priv->_symbols_filename);
	_g_free0 (self->priv->_output);
	_g_free0 (self->priv->_basedir);
	_g_free0 (self->priv->_directory);
	self->priv->_vapi_directories = (_vala_array_free (self->priv->_vapi_directories, self->priv->_vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_gir_directories = (_vala_array_free (self->priv->_gir_directories, self->priv->_gir_directories_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_metadata_directories = (_vala_array_free (self->priv->_metadata_directories, self->priv->_metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (self->priv->_module_init_method);
	_vala_report_unref0 (self->priv->_report);
	_vala_code_node_unref0 (self->priv->_entry_point);
	_g_free0 (self->priv->_entry_point_name);
	self->priv->_gresources = (_vala_array_free (self->priv->_gresources, self->priv->_gresources_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_gresources_directories = (_vala_array_free (self->priv->_gresources_directories, self->priv->_gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->source_files);
	_vala_map_unref0 (self->priv->source_files_map);
	_vala_iterable_unref0 (self->priv->c_source_files);
	_vala_code_node_unref0 (self->priv->_root);
	_vala_iterable_unref0 (self->priv->packages);
	_vala_iterable_unref0 (self->priv->defines);
	_vala_code_visitor_unref0 (self->priv->_resolver);
	_vala_code_visitor_unref0 (self->priv->_analyzer);
	_vala_code_visitor_unref0 (self->priv->_flow_analyzer);
	_vala_code_visitor_unref0 (self->priv->_codegen);
	_vala_code_visitor_unref0 (self->priv->_used_attr);
}

/**
 * The root of the code tree.
 */
static GType
vala_code_context_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_code_context_init, vala_value_code_context_free_value, vala_value_code_context_copy_value, vala_value_code_context_peek_pointer, "p", vala_value_code_context_collect_value, "p", vala_value_code_context_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCodeContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeContext), 0, (GInstanceInitFunc) vala_code_context_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_code_context_type_id;
	vala_code_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaCodeContext_private_offset = g_type_add_instance_private (vala_code_context_type_id, sizeof (ValaCodeContextPrivate));
	return vala_code_context_type_id;
}

GType
vala_code_context_get_type (void)
{
	static volatile gsize vala_code_context_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_context_type_id__volatile)) {
		GType vala_code_context_type_id;
		vala_code_context_type_id = vala_code_context_get_type_once ();
		g_once_init_leave (&vala_code_context_type_id__volatile, vala_code_context_type_id);
	}
	return vala_code_context_type_id__volatile;
}

gpointer
vala_code_context_ref (gpointer instance)
{
	ValaCodeContext * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_code_context_unref (gpointer instance)
{
	ValaCodeContext * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

