/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};

static gint ValaCreationMethod_private_offset;
static gpointer vala_creation_method_parent_class = NULL;

static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);
static GType vala_creation_method_get_type_once (void);

static inline gpointer
vala_creation_method_get_instance_private (ValaCreationMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCreationMethod_private_offset);
}

const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}

void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}

gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_chain_up;
	return result;
}

void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}

/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}

ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}

static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaList* _tmp10_;
	ValaBlock* _tmp41_;
	ValaBlock* _tmp42_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp10_ = ((ValaMethod*) self)->error_types;
	if (_tmp10_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp11_;
			ValaList* _tmp12_;
			gint _error_type_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _error_type_index = 0;
			_tmp11_ = ((ValaMethod*) self)->error_types;
			_tmp12_ = _vala_iterable_ref0 (_tmp11_);
			_error_type_list = _tmp12_;
			_tmp13_ = _error_type_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_error_type_size = _tmp15_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp18_;
				gpointer _tmp19_;
				ValaDataType* _tmp20_;
				_error_type_index = _error_type_index + 1;
				_tmp16_ = _error_type_index;
				_tmp17_ = _error_type_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _error_type_list;
				_tmp19_ = vala_list_get (_tmp18_, _error_type_index);
				error_type = (ValaDataType*) _tmp19_;
				_tmp20_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _precondition_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _precondition_index = 0;
		_tmp21_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp22_ = _vala_iterable_ref0 (_tmp21_);
		_precondition_list = _tmp22_;
		_tmp23_ = _precondition_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_precondition_size = _tmp25_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaExpression* _tmp30_;
			_precondition_index = _precondition_index + 1;
			_tmp26_ = _precondition_index;
			_tmp27_ = _precondition_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _precondition_list;
			_tmp29_ = vala_list_get (_tmp28_, _precondition_index);
			precondition = (ValaExpression*) _tmp29_;
			_tmp30_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		gint _postcondition_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _postcondition_index = 0;
		_tmp31_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_postcondition_list = _tmp32_;
		_tmp33_ = _postcondition_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_postcondition_size = _tmp35_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp38_;
			gpointer _tmp39_;
			ValaExpression* _tmp40_;
			_postcondition_index = _postcondition_index + 1;
			_tmp36_ = _postcondition_index;
			_tmp37_ = _postcondition_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _postcondition_list;
			_tmp39_ = vala_list_get (_tmp38_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp39_;
			_tmp40_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp41_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaBlock* _tmp43_;
		ValaBlock* _tmp44_;
		_tmp43_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp44_ = _tmp43_;
		vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSourceFile* _tmp28_;
	ValaSourceFile* _tmp29_;
	ValaSourceFile* _tmp30_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSymbol* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSemanticAnalyzer* _tmp44_;
	ValaSemanticAnalyzer* _tmp45_;
	gint i = 0;
	ValaList* _tmp67_;
	ValaBlock* _tmp110_;
	ValaBlock* _tmp111_;
	ValaSemanticAnalyzer* _tmp235_;
	ValaSemanticAnalyzer* _tmp236_;
	ValaSourceFile* _tmp237_;
	ValaSemanticAnalyzer* _tmp238_;
	ValaSemanticAnalyzer* _tmp239_;
	ValaSymbol* _tmp240_;
	gboolean _tmp241_ = FALSE;
	gboolean _tmp242_ = FALSE;
	gboolean _tmp243_;
	gboolean _tmp244_;
	gboolean _tmp255_ = FALSE;
	ValaBlock* _tmp256_;
	ValaBlock* _tmp257_;
	gboolean _tmp300_;
	gboolean _tmp301_;
	gboolean result = FALSE;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_method_get_this_parameter ((ValaMethod*) self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ValaParameter* _tmp24_;
		ValaParameter* _tmp25_;
		_tmp24_ = vala_method_get_this_parameter ((ValaMethod*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_code_context_get_analyzer (context);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_semantic_analyzer_get_current_source_file (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_source_file_ref0 (_tmp29_);
	old_source_file = _tmp30_;
	_tmp31_ = vala_code_context_get_analyzer (context);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_semantic_analyzer_get_current_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _vala_code_node_ref0 (_tmp34_);
	old_symbol = _tmp35_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValaSemanticAnalyzer* _tmp38_;
		ValaSemanticAnalyzer* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaSourceFile* _tmp43_;
		_tmp38_ = vala_code_context_get_analyzer (context);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_source_reference_get_file (_tmp41_);
		_tmp43_ = _tmp42_;
		vala_semantic_analyzer_set_current_source_file (_tmp39_, _tmp43_);
	}
	_tmp44_ = vala_code_context_get_analyzer (context);
	_tmp45_ = _tmp44_;
	vala_semantic_analyzer_set_current_symbol (_tmp45_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _param_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _param_index = 0;
		_tmp46_ = vala_callable_get_parameters ((ValaCallable*) self);
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_param_list = _tmp47_;
		_tmp48_ = _param_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_param_size = _tmp50_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			ValaParameter* param = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaParameter* _tmp55_;
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gint _tmp66_;
			_param_index = _param_index + 1;
			_tmp51_ = _param_index;
			_tmp52_ = _param_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _param_list;
			_tmp54_ = vala_list_get (_tmp53_, _param_index);
			param = (ValaParameter*) _tmp54_;
			_tmp55_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp55_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			if (i == 0) {
				ValaParameter* _tmp58_;
				gboolean _tmp59_;
				gboolean _tmp60_;
				_tmp58_ = param;
				_tmp59_ = vala_parameter_get_ellipsis (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp57_ = _tmp60_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaBlock* _tmp61_;
				ValaBlock* _tmp62_;
				_tmp61_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp62_ = _tmp61_;
				_tmp56_ = _tmp62_ != NULL;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaParameter* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp63_ = param;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				vala_report_error (_tmp65_, "Named parameter required before `...'");
			}
			_tmp66_ = i;
			i = _tmp66_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp67_ = ((ValaMethod*) self)->error_types;
	if (_tmp67_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp68_;
			ValaList* _tmp69_;
			gint _error_type_size = 0;
			ValaList* _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			gint _error_type_index = 0;
			_tmp68_ = ((ValaMethod*) self)->error_types;
			_tmp69_ = _vala_iterable_ref0 (_tmp68_);
			_error_type_list = _tmp69_;
			_tmp70_ = _error_type_list;
			_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
			_tmp72_ = _tmp71_;
			_error_type_size = _tmp72_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp73_;
				gint _tmp74_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp75_;
				gpointer _tmp76_;
				ValaDataType* _tmp77_;
				ValaSemanticAnalyzer* _tmp78_;
				ValaSemanticAnalyzer* _tmp79_;
				ValaDataType* _tmp80_;
				_error_type_index = _error_type_index + 1;
				_tmp73_ = _error_type_index;
				_tmp74_ = _error_type_size;
				if (!(_tmp73_ < _tmp74_)) {
					break;
				}
				_tmp75_ = _error_type_list;
				_tmp76_ = vala_list_get (_tmp75_, _error_type_index);
				error_type = (ValaDataType*) _tmp76_;
				_tmp77_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp77_, context);
				_tmp78_ = vala_code_context_get_analyzer (context);
				_tmp79_ = _tmp78_;
				_tmp80_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp79_, (ValaSymbol*) self, _tmp80_)) {
					ValaSourceReference* _tmp81_;
					ValaSourceReference* _tmp82_;
					ValaDataType* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp82_ = _tmp81_;
					_tmp83_ = error_type;
					_tmp84_ = vala_code_node_to_string ((ValaCodeNode*) _tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp87_ = _tmp86_;
					_tmp88_ = g_strdup_printf ("error type `%s' is less accessible than creation method `%s'", _tmp85_, _tmp87_);
					_tmp89_ = _tmp88_;
					vala_report_error (_tmp82_, _tmp89_);
					_g_free0 (_tmp89_);
					_g_free0 (_tmp87_);
					_g_free0 (_tmp85_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _precondition_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _precondition_index = 0;
		_tmp90_ = vala_method_get_preconditions ((ValaMethod*) self);
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_precondition_list = _tmp91_;
		_tmp92_ = _precondition_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_precondition_size = _tmp94_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp97_;
			gpointer _tmp98_;
			ValaExpression* _tmp99_;
			_precondition_index = _precondition_index + 1;
			_tmp95_ = _precondition_index;
			_tmp96_ = _precondition_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _precondition_list;
			_tmp98_ = vala_list_get (_tmp97_, _precondition_index);
			precondition = (ValaExpression*) _tmp98_;
			_tmp99_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp99_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp100_;
		ValaList* _tmp101_;
		gint _postcondition_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _postcondition_index = 0;
		_tmp100_ = vala_method_get_postconditions ((ValaMethod*) self);
		_tmp101_ = _vala_iterable_ref0 (_tmp100_);
		_postcondition_list = _tmp101_;
		_tmp102_ = _postcondition_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_postcondition_size = _tmp104_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp107_;
			gpointer _tmp108_;
			ValaExpression* _tmp109_;
			_postcondition_index = _postcondition_index + 1;
			_tmp105_ = _postcondition_index;
			_tmp106_ = _postcondition_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _postcondition_list;
			_tmp108_ = vala_list_get (_tmp107_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp108_;
			_tmp109_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp110_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp111_ = _tmp110_;
	if (_tmp111_ != NULL) {
		ValaBlock* _tmp112_;
		ValaBlock* _tmp113_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp114_;
		ValaSymbol* _tmp115_;
		gboolean _tmp116_ = FALSE;
		gboolean _tmp117_ = FALSE;
		gboolean _tmp118_;
		_tmp112_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp113_ = _tmp112_;
		vala_code_node_check ((ValaCodeNode*) _tmp113_, context);
		_tmp114_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		cl = VALA_IS_CLASS (_tmp115_) ? ((ValaClass*) _tmp115_) : NULL;
		_tmp118_ = self->priv->_chain_up;
		if (!_tmp118_) {
			ValaClass* _tmp119_;
			_tmp119_ = cl;
			_tmp117_ = _tmp119_ != NULL;
		} else {
			_tmp117_ = FALSE;
		}
		if (_tmp117_) {
			ValaClass* _tmp120_;
			ValaClass* _tmp121_;
			ValaClass* _tmp122_;
			_tmp120_ = cl;
			_tmp121_ = vala_class_get_base_class (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp116_ = _tmp122_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			gboolean _tmp123_ = FALSE;
			gboolean _tmp124_ = FALSE;
			ValaProfile _tmp125_;
			ValaProfile _tmp126_;
			_tmp125_ = vala_code_context_get_profile (context);
			_tmp126_ = _tmp125_;
			if (_tmp126_ == VALA_PROFILE_GOBJECT) {
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaClass* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaCreationMethod* _tmp131_;
				_tmp127_ = cl;
				_tmp128_ = vala_class_get_base_class (_tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_class_get_default_construction_method (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp124_ = _tmp131_ != NULL;
			} else {
				_tmp124_ = FALSE;
			}
			if (_tmp124_) {
				ValaClass* _tmp132_;
				ValaClass* _tmp133_;
				ValaClass* _tmp134_;
				ValaCreationMethod* _tmp135_;
				ValaCreationMethod* _tmp136_;
				gboolean _tmp137_;
				gboolean _tmp138_;
				_tmp132_ = cl;
				_tmp133_ = vala_class_get_base_class (_tmp132_);
				_tmp134_ = _tmp133_;
				_tmp135_ = vala_class_get_default_construction_method (_tmp134_);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp136_);
				_tmp138_ = _tmp137_;
				_tmp123_ = !_tmp138_;
			} else {
				_tmp123_ = FALSE;
			}
			if (_tmp123_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp139_;
				ValaSemanticAnalyzer* _tmp140_;
				ValaBlock* _tmp141_;
				ValaBlock* _tmp142_;
				ValaSemanticAnalyzer* _tmp143_;
				ValaSemanticAnalyzer* _tmp144_;
				ValaBlock* _tmp145_;
				ValaBlock* _tmp146_;
				ValaSemanticAnalyzer* _tmp147_;
				ValaSemanticAnalyzer* _tmp148_;
				ValaBlock* _tmp149_;
				ValaBlock* _tmp150_;
				ValaBlock* _tmp151_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp152_;
				ValaSourceReference* _tmp153_;
				ValaMemberAccess* _tmp154_;
				ValaMemberAccess* _tmp155_;
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaMemberAccess* _tmp158_;
				ValaMemberAccess* _tmp159_;
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				ValaMethodCall* _tmp162_;
				ValaMethodCall* _tmp163_;
				ValaSourceReference* _tmp164_;
				ValaSourceReference* _tmp165_;
				ValaExpressionStatement* _tmp166_;
				ValaExpressionStatement* _tmp167_;
				ValaBlock* _tmp168_;
				ValaBlock* _tmp169_;
				ValaExpressionStatement* _tmp170_;
				ValaExpressionStatement* _tmp171_;
				ValaSemanticAnalyzer* _tmp172_;
				ValaSemanticAnalyzer* _tmp173_;
				ValaSemanticAnalyzer* _tmp174_;
				ValaSemanticAnalyzer* _tmp175_;
				ValaBlock* _tmp176_;
				ValaBlock* _tmp177_;
				_tmp139_ = vala_code_context_get_analyzer (context);
				_tmp140_ = _tmp139_;
				_tmp141_ = _tmp140_->insert_block;
				_tmp142_ = _vala_code_node_ref0 (_tmp141_);
				old_insert_block = _tmp142_;
				_tmp143_ = vala_code_context_get_analyzer (context);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp146_ = _tmp145_;
				vala_semantic_analyzer_set_current_symbol (_tmp144_, (ValaSymbol*) _tmp146_);
				_tmp147_ = vala_code_context_get_analyzer (context);
				_tmp148_ = _tmp147_;
				_tmp149_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (_tmp148_->insert_block);
				_tmp148_->insert_block = _tmp151_;
				_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_member_access_new_simple ("GLib", _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_member_access_new ((ValaExpression*) _tmp155_, "Object", _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_method_call_new ((ValaExpression*) _tmp159_, _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp165_ = _tmp164_;
				_tmp166_ = vala_expression_statement_new ((ValaExpression*) _tmp163_, _tmp165_);
				_tmp167_ = _tmp166_;
				_vala_code_node_unref0 (_tmp163_);
				_vala_code_node_unref0 (_tmp159_);
				_vala_code_node_unref0 (_tmp155_);
				stmt = _tmp167_;
				_tmp168_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp169_ = _tmp168_;
				_tmp170_ = stmt;
				vala_block_insert_statement (_tmp169_, 0, (ValaStatement*) _tmp170_);
				_tmp171_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp171_, context);
				_tmp172_ = vala_code_context_get_analyzer (context);
				_tmp173_ = _tmp172_;
				vala_semantic_analyzer_set_current_symbol (_tmp173_, (ValaSymbol*) self);
				_tmp174_ = vala_code_context_get_analyzer (context);
				_tmp175_ = _tmp174_;
				_tmp176_ = old_insert_block;
				_tmp177_ = _vala_code_node_ref0 (_tmp176_);
				_vala_code_node_unref0 (_tmp175_->insert_block);
				_tmp175_->insert_block = _tmp177_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp178_ = FALSE;
				ValaClass* _tmp179_;
				ValaClass* _tmp180_;
				ValaClass* _tmp181_;
				ValaCreationMethod* _tmp182_;
				ValaCreationMethod* _tmp183_;
				_tmp179_ = cl;
				_tmp180_ = vala_class_get_base_class (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_class_get_default_construction_method (_tmp181_);
				_tmp183_ = _tmp182_;
				if (_tmp183_ == NULL) {
					_tmp178_ = TRUE;
				} else {
					ValaClass* _tmp184_;
					ValaClass* _tmp185_;
					ValaClass* _tmp186_;
					ValaCreationMethod* _tmp187_;
					ValaCreationMethod* _tmp188_;
					ValaSymbolAccessibility _tmp189_;
					ValaSymbolAccessibility _tmp190_;
					_tmp184_ = cl;
					_tmp185_ = vala_class_get_base_class (_tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_class_get_default_construction_method (_tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_symbol_get_access ((ValaSymbol*) _tmp188_);
					_tmp190_ = _tmp189_;
					_tmp178_ = _tmp190_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp178_) {
					ValaSourceReference* _tmp191_;
					ValaSourceReference* _tmp192_;
					_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp192_ = _tmp191_;
					vala_report_error (_tmp192_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp193_;
					ValaClass* _tmp194_;
					ValaClass* _tmp195_;
					ValaCreationMethod* _tmp196_;
					ValaCreationMethod* _tmp197_;
					_tmp193_ = cl;
					_tmp194_ = vala_class_get_base_class (_tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_class_get_default_construction_method (_tmp195_);
					_tmp197_ = _tmp196_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp197_) > 0) {
						ValaSourceReference* _tmp198_;
						ValaSourceReference* _tmp199_;
						_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp199_ = _tmp198_;
						vala_report_error (_tmp199_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp200_;
						ValaSemanticAnalyzer* _tmp201_;
						ValaBlock* _tmp202_;
						ValaBlock* _tmp203_;
						ValaSemanticAnalyzer* _tmp204_;
						ValaSemanticAnalyzer* _tmp205_;
						ValaBlock* _tmp206_;
						ValaBlock* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaBlock* _tmp210_;
						ValaBlock* _tmp211_;
						ValaBlock* _tmp212_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp213_;
						ValaSourceReference* _tmp214_;
						ValaBaseAccess* _tmp215_;
						ValaBaseAccess* _tmp216_;
						ValaSourceReference* _tmp217_;
						ValaSourceReference* _tmp218_;
						ValaMethodCall* _tmp219_;
						ValaMethodCall* _tmp220_;
						ValaSourceReference* _tmp221_;
						ValaSourceReference* _tmp222_;
						ValaExpressionStatement* _tmp223_;
						ValaExpressionStatement* _tmp224_;
						ValaBlock* _tmp225_;
						ValaBlock* _tmp226_;
						ValaExpressionStatement* _tmp227_;
						ValaExpressionStatement* _tmp228_;
						ValaSemanticAnalyzer* _tmp229_;
						ValaSemanticAnalyzer* _tmp230_;
						ValaSemanticAnalyzer* _tmp231_;
						ValaSemanticAnalyzer* _tmp232_;
						ValaBlock* _tmp233_;
						ValaBlock* _tmp234_;
						_tmp200_ = vala_code_context_get_analyzer (context);
						_tmp201_ = _tmp200_;
						_tmp202_ = _tmp201_->insert_block;
						_tmp203_ = _vala_code_node_ref0 (_tmp202_);
						old_insert_block = _tmp203_;
						_tmp204_ = vala_code_context_get_analyzer (context);
						_tmp205_ = _tmp204_;
						_tmp206_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp207_ = _tmp206_;
						vala_semantic_analyzer_set_current_symbol (_tmp205_, (ValaSymbol*) _tmp207_);
						_tmp208_ = vala_code_context_get_analyzer (context);
						_tmp209_ = _tmp208_;
						_tmp210_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp211_ = _tmp210_;
						_tmp212_ = _vala_code_node_ref0 (_tmp211_);
						_vala_code_node_unref0 (_tmp209_->insert_block);
						_tmp209_->insert_block = _tmp212_;
						_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_base_access_new (_tmp214_);
						_tmp216_ = _tmp215_;
						_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp218_ = _tmp217_;
						_tmp219_ = vala_method_call_new ((ValaExpression*) _tmp216_, _tmp218_);
						_tmp220_ = _tmp219_;
						_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp222_ = _tmp221_;
						_tmp223_ = vala_expression_statement_new ((ValaExpression*) _tmp220_, _tmp222_);
						_tmp224_ = _tmp223_;
						_vala_code_node_unref0 (_tmp220_);
						_vala_code_node_unref0 (_tmp216_);
						stmt = _tmp224_;
						_tmp225_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp226_ = _tmp225_;
						_tmp227_ = stmt;
						vala_block_insert_statement (_tmp226_, 0, (ValaStatement*) _tmp227_);
						_tmp228_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
						_tmp229_ = vala_code_context_get_analyzer (context);
						_tmp230_ = _tmp229_;
						vala_semantic_analyzer_set_current_symbol (_tmp230_, (ValaSymbol*) self);
						_tmp231_ = vala_code_context_get_analyzer (context);
						_tmp232_ = _tmp231_;
						_tmp233_ = old_insert_block;
						_tmp234_ = _vala_code_node_ref0 (_tmp233_);
						_vala_code_node_unref0 (_tmp232_->insert_block);
						_tmp232_->insert_block = _tmp234_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
	}
	_tmp235_ = vala_code_context_get_analyzer (context);
	_tmp236_ = _tmp235_;
	_tmp237_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp236_, _tmp237_);
	_tmp238_ = vala_code_context_get_analyzer (context);
	_tmp239_ = _tmp238_;
	_tmp240_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp239_, _tmp240_);
	_tmp243_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp244_ = _tmp243_;
	if (_tmp244_) {
		_tmp242_ = TRUE;
	} else {
		gboolean _tmp245_;
		gboolean _tmp246_;
		_tmp245_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp246_ = _tmp245_;
		_tmp242_ = _tmp246_;
	}
	if (_tmp242_) {
		_tmp241_ = TRUE;
	} else {
		gboolean _tmp247_;
		gboolean _tmp248_;
		_tmp247_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp248_ = _tmp247_;
		_tmp241_ = _tmp248_;
	}
	if (_tmp241_) {
		ValaSourceReference* _tmp249_;
		ValaSourceReference* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		gchar* _tmp254_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp250_ = _tmp249_;
		_tmp251_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp252_ = _tmp251_;
		_tmp253_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp252_);
		_tmp254_ = _tmp253_;
		vala_report_error (_tmp250_, _tmp254_);
		_g_free0 (_tmp254_);
		_g_free0 (_tmp252_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp256_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		ValaBlock* _tmp258_;
		ValaBlock* _tmp259_;
		gboolean _tmp260_;
		gboolean _tmp261_;
		_tmp258_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_code_node_get_error ((ValaCodeNode*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp255_ = !_tmp261_;
	} else {
		_tmp255_ = FALSE;
	}
	if (_tmp255_) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp262_;
		ValaArrayList* _tmp263_;
		ValaBlock* _tmp264_;
		ValaBlock* _tmp265_;
		ValaArrayList* _tmp266_;
		_tmp262_ = g_direct_equal;
		_tmp263_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp262_);
		body_errors = _tmp263_;
		_tmp264_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp265_ = _tmp264_;
		_tmp266_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp265_, (ValaCollection*) _tmp266_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp267_;
			ValaArrayList* _tmp268_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp269_;
			gint _tmp270_;
			gint _tmp271_;
			gint _body_error_type_index = 0;
			_tmp267_ = body_errors;
			_tmp268_ = _vala_iterable_ref0 (_tmp267_);
			_body_error_type_list = _tmp268_;
			_tmp269_ = _body_error_type_list;
			_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
			_tmp271_ = _tmp270_;
			_body_error_type_size = _tmp271_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp272_;
				gint _tmp273_;
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp274_;
				gpointer _tmp275_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp276_;
				gboolean _tmp288_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp272_ = _body_error_type_index;
				_tmp273_ = _body_error_type_size;
				if (!(_tmp272_ < _tmp273_)) {
					break;
				}
				_tmp274_ = _body_error_type_list;
				_tmp275_ = vala_list_get ((ValaList*) _tmp274_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp275_;
				can_propagate_error = FALSE;
				_tmp276_ = ((ValaMethod*) self)->error_types;
				if (_tmp276_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp277_;
						ValaList* _tmp278_;
						gint _method_error_type_size = 0;
						ValaList* _tmp279_;
						gint _tmp280_;
						gint _tmp281_;
						gint _method_error_type_index = 0;
						_tmp277_ = ((ValaMethod*) self)->error_types;
						_tmp278_ = _vala_iterable_ref0 (_tmp277_);
						_method_error_type_list = _tmp278_;
						_tmp279_ = _method_error_type_list;
						_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
						_tmp281_ = _tmp280_;
						_method_error_type_size = _tmp281_;
						_method_error_type_index = -1;
						while (TRUE) {
							gint _tmp282_;
							gint _tmp283_;
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp284_;
							gpointer _tmp285_;
							ValaDataType* _tmp286_;
							ValaDataType* _tmp287_;
							_method_error_type_index = _method_error_type_index + 1;
							_tmp282_ = _method_error_type_index;
							_tmp283_ = _method_error_type_size;
							if (!(_tmp282_ < _tmp283_)) {
								break;
							}
							_tmp284_ = _method_error_type_list;
							_tmp285_ = vala_list_get (_tmp284_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp285_;
							_tmp286_ = body_error_type;
							_tmp287_ = method_error_type;
							if (vala_data_type_compatible (_tmp286_, _tmp287_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				if (!can_propagate_error) {
					ValaDataType* _tmp289_;
					gboolean _tmp290_;
					gboolean _tmp291_;
					_tmp289_ = body_error_type;
					_tmp290_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp289_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp291_ = _tmp290_;
					_tmp288_ = !_tmp291_;
				} else {
					_tmp288_ = FALSE;
				}
				if (_tmp288_) {
					ValaDataType* _tmp292_;
					ValaSourceReference* _tmp293_;
					ValaSourceReference* _tmp294_;
					ValaDataType* _tmp295_;
					gchar* _tmp296_;
					gchar* _tmp297_;
					gchar* _tmp298_;
					gchar* _tmp299_;
					_tmp292_ = body_error_type;
					_tmp293_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp292_);
					_tmp294_ = _tmp293_;
					_tmp295_ = body_error_type;
					_tmp296_ = vala_code_node_to_string ((ValaCodeNode*) _tmp295_);
					_tmp297_ = _tmp296_;
					_tmp298_ = g_strdup_printf ("unhandled error `%s'", _tmp297_);
					_tmp299_ = _tmp298_;
					vala_report_warning (_tmp294_, _tmp299_);
					_g_free0 (_tmp299_);
					_g_free0 (_tmp297_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	_tmp300_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp301_ = _tmp300_;
	result = !_tmp301_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_creation_method_class_init (ValaCreationMethodClass * klass,
                                 gpointer klass_data)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCreationMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}

static void
vala_creation_method_instance_init (ValaCreationMethod * self,
                                    gpointer klass)
{
	self->priv = vala_creation_method_get_instance_private (self);
}

static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}

/**
 * Represents a type creation method.
 */
static GType
vala_creation_method_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
	GType vala_creation_method_type_id;
	vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	ValaCreationMethod_private_offset = g_type_add_instance_private (vala_creation_method_type_id, sizeof (ValaCreationMethodPrivate));
	return vala_creation_method_type_id;
}

GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = vala_creation_method_get_type_once ();
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}

