/* valaforeachstatement.c generated by valac, the Vala compiler
 * generated from valaforeachstatement.vala, do not modify */

/* valaforeachstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaForeachStatementPrivate {
	gchar* _variable_name;
	gboolean _use_iterator;
	ValaLocalVariable* _element_variable;
	ValaLocalVariable* _collection_variable;
	ValaLocalVariable* _iterator_variable;
	ValaExpression* _collection;
	ValaBlock* _body;
	ValaDataType* _data_type;
};

static gint ValaForeachStatement_private_offset;
static gpointer vala_foreach_statement_parent_class = NULL;

static void vala_foreach_statement_set_type_reference (ValaForeachStatement* self,
                                                ValaDataType* value);
static void vala_foreach_statement_set_variable_name (ValaForeachStatement* self,
                                               const gchar* value);
static void vala_foreach_statement_set_collection (ValaForeachStatement* self,
                                            ValaExpression* value);
static void vala_foreach_statement_set_body (ValaForeachStatement* self,
                                      ValaBlock* value);
static void vala_foreach_statement_set_use_iterator (ValaForeachStatement* self,
                                              gboolean value);
static void vala_foreach_statement_set_element_variable (ValaForeachStatement* self,
                                                  ValaLocalVariable* value);
static void vala_foreach_statement_set_collection_variable (ValaForeachStatement* self,
                                                     ValaLocalVariable* value);
static void vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self,
                                                   ValaLocalVariable* value);
static void vala_foreach_statement_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_foreach_statement_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static void vala_foreach_statement_real_replace_type (ValaCodeNode* base,
                                               ValaDataType* old_type,
                                               ValaDataType* new_type);
static gboolean vala_foreach_statement_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static gboolean vala_foreach_statement_check_without_iterator (ValaForeachStatement* self,
                                                        ValaCodeContext* context,
                                                        ValaDataType* collection_type,
                                                        ValaDataType* element_type);
static gboolean vala_foreach_statement_check_with_iterator (ValaForeachStatement* self,
                                                     ValaCodeContext* context,
                                                     ValaDataType* collection_type);
static gboolean vala_foreach_statement_check_with_index (ValaForeachStatement* self,
                                                  ValaCodeContext* context,
                                                  ValaDataType* collection_type);
static gboolean vala_foreach_statement_analyze_element_type (ValaForeachStatement* self,
                                                      ValaDataType* element_type);
static void vala_foreach_statement_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static void vala_foreach_statement_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_foreach_statement_finalize (ValaCodeNode * obj);
static GType vala_foreach_statement_get_type_once (void);

static inline gpointer
vala_foreach_statement_get_instance_private (ValaForeachStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForeachStatement_private_offset);
}

ValaDataType*
vala_foreach_statement_get_type_reference (ValaForeachStatement* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_foreach_statement_set_type_reference (ValaForeachStatement* self,
                                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		_tmp2_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_foreach_statement_get_variable_name (ValaForeachStatement* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_variable_name;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_variable_name (ValaForeachStatement* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_variable_name);
	self->priv->_variable_name = _tmp0_;
}

ValaExpression*
vala_foreach_statement_get_collection (ValaForeachStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_collection (ValaForeachStatement* self,
                                       ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_collection);
	self->priv->_collection = _tmp0_;
	_tmp1_ = self->priv->_collection;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaBlock*
vala_foreach_statement_get_body (ValaForeachStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_body (ValaForeachStatement* self,
                                 ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_foreach_statement_get_use_iterator (ValaForeachStatement* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_use_iterator;
	return result;
}

static void
vala_foreach_statement_set_use_iterator (ValaForeachStatement* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_use_iterator = value;
}

ValaLocalVariable*
vala_foreach_statement_get_element_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_element_variable (ValaForeachStatement* self,
                                             ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_element_variable);
	self->priv->_element_variable = _tmp0_;
}

ValaLocalVariable*
vala_foreach_statement_get_collection_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collection_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_collection_variable (ValaForeachStatement* self,
                                                ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	self->priv->_collection_variable = _tmp0_;
}

ValaLocalVariable*
vala_foreach_statement_get_iterator_variable (ValaForeachStatement* self)
{
	ValaLocalVariable* result;
	ValaLocalVariable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_iterator_variable;
	result = _tmp0_;
	return result;
}

static void
vala_foreach_statement_set_iterator_variable (ValaForeachStatement* self,
                                              ValaLocalVariable* value)
{
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	self->priv->_iterator_variable = _tmp0_;
}

/**
 * Creates a new foreach statement.
 *
 * @param type_reference    element type
 * @param variable_name     element variable name
 * @param collection        container
 * @param body              loop body
 * @param source_reference  reference to source code
 * @return                  newly created foreach statement
 */
ValaForeachStatement*
vala_foreach_statement_construct (GType object_type,
                                  ValaDataType* type_reference,
                                  const gchar* variable_name,
                                  ValaExpression* collection,
                                  ValaBlock* body,
                                  ValaSourceReference* source_reference)
{
	ValaForeachStatement* self = NULL;
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForeachStatement*) vala_block_construct (object_type, source_reference);
	vala_foreach_statement_set_variable_name (self, variable_name);
	vala_foreach_statement_set_collection (self, collection);
	vala_foreach_statement_set_body (self, body);
	vala_foreach_statement_set_type_reference (self, type_reference);
	return self;
}

ValaForeachStatement*
vala_foreach_statement_new (ValaDataType* type_reference,
                            const gchar* variable_name,
                            ValaExpression* collection,
                            ValaBlock* body,
                            ValaSourceReference* source_reference)
{
	return vala_foreach_statement_construct (VALA_TYPE_FOREACH_STATEMENT, type_reference, variable_name, collection, body, source_reference);
}

static void
vala_foreach_statement_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
		return;
	}
	vala_code_visitor_visit_foreach_statement (visitor, self);
}

static void
vala_foreach_statement_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
		return;
	}
	_tmp1_ = vala_foreach_statement_get_collection (self);
	_tmp2_ = _tmp1_;
	vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
	_tmp3_ = vala_foreach_statement_get_collection (self);
	_tmp4_ = _tmp3_;
	vala_code_visitor_visit_end_full_expression (visitor, _tmp4_);
	_tmp5_ = vala_foreach_statement_get_type_reference (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp7_ = vala_foreach_statement_get_type_reference (self);
		_tmp8_ = _tmp7_;
		vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
	}
	_tmp9_ = vala_foreach_statement_get_body (self);
	_tmp10_ = _tmp9_;
	vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
}

static void
vala_foreach_statement_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaForeachStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_foreach_statement_get_collection (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_foreach_statement_set_collection (self, new_node);
	}
}

static void
vala_foreach_statement_real_replace_type (ValaCodeNode* base,
                                          ValaDataType* old_type,
                                          ValaDataType* new_type)
{
	ValaForeachStatement * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_foreach_statement_set_type_reference (self, new_type);
	}
}

static gboolean
vala_foreach_statement_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* collection_type = NULL;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gboolean result = FALSE;
	self = (ValaForeachStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_foreach_statement_get_collection (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	} else {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp6_ = vala_foreach_statement_get_collection (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == NULL) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			_tmp10_ = vala_foreach_statement_get_collection (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "invalid collection expression");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = vala_foreach_statement_get_collection (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_expression_get_value_type (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_data_type_copy (_tmp17_);
	collection_type = _tmp18_;
	_tmp19_ = vala_foreach_statement_get_collection (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = collection_type;
	_tmp22_ = vala_data_type_copy (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_expression_set_target_type (_tmp20_, _tmp23_);
	_vala_code_node_unref0 (_tmp23_);
	_tmp24_ = collection_type;
	if (VALA_IS_ARRAY_TYPE (_tmp24_)) {
		ValaArrayType* array_type = NULL;
		ValaDataType* _tmp25_;
		ValaArrayType* _tmp26_;
		ValaArrayType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaArrayType* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		_tmp25_ = collection_type;
		_tmp26_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp26_;
		_tmp27_ = array_type;
		vala_array_type_set_inline_allocated (_tmp27_, FALSE);
		_tmp28_ = collection_type;
		_tmp29_ = array_type;
		_tmp30_ = vala_array_type_get_element_type (_tmp29_);
		_tmp31_ = _tmp30_;
		result = vala_foreach_statement_check_without_iterator (self, context, _tmp28_, _tmp31_);
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (collection_type);
		return result;
	} else {
		gboolean _tmp32_ = FALSE;
		ValaProfile _tmp33_;
		ValaProfile _tmp34_;
		_tmp33_ = vala_code_context_get_profile (context);
		_tmp34_ = _tmp33_;
		if (_tmp34_ == VALA_PROFILE_GOBJECT) {
			gboolean _tmp35_ = FALSE;
			ValaDataType* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaDataType* _tmp39_;
			_tmp36_ = collection_type;
			_tmp37_ = vala_code_context_get_analyzer (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_->glist_type;
			if (vala_data_type_compatible (_tmp36_, _tmp39_)) {
				_tmp35_ = TRUE;
			} else {
				ValaDataType* _tmp40_;
				ValaSemanticAnalyzer* _tmp41_;
				ValaSemanticAnalyzer* _tmp42_;
				ValaDataType* _tmp43_;
				_tmp40_ = collection_type;
				_tmp41_ = vala_code_context_get_analyzer (context);
				_tmp42_ = _tmp41_;
				_tmp43_ = _tmp42_->gslist_type;
				_tmp35_ = vala_data_type_compatible (_tmp40_, _tmp43_);
			}
			_tmp32_ = _tmp35_;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaDataType* _tmp44_;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaDataType* _tmp56_;
			gboolean _tmp57_;
			_tmp44_ = collection_type;
			_tmp45_ = vala_data_type_get_type_arguments (_tmp44_);
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_ != 1) {
				ValaExpression* _tmp48_;
				ValaExpression* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaSourceReference* _tmp51_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_foreach_statement_get_collection (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				vala_report_error (_tmp51_, "missing type argument for collection");
				result = FALSE;
				_vala_code_node_unref0 (collection_type);
				return result;
			}
			_tmp52_ = collection_type;
			_tmp53_ = collection_type;
			_tmp54_ = vala_data_type_get_type_arguments (_tmp53_);
			_tmp55_ = vala_list_get (_tmp54_, 0);
			_tmp56_ = (ValaDataType*) _tmp55_;
			_tmp57_ = vala_foreach_statement_check_without_iterator (self, context, _tmp52_, _tmp56_);
			_vala_code_node_unref0 (_tmp56_);
			result = _tmp57_;
			_vala_code_node_unref0 (collection_type);
			return result;
		} else {
			gboolean _tmp58_ = FALSE;
			ValaProfile _tmp59_;
			ValaProfile _tmp60_;
			_tmp59_ = vala_code_context_get_profile (context);
			_tmp60_ = _tmp59_;
			if (_tmp60_ == VALA_PROFILE_GOBJECT) {
				ValaDataType* _tmp61_;
				ValaSemanticAnalyzer* _tmp62_;
				ValaSemanticAnalyzer* _tmp63_;
				ValaDataType* _tmp64_;
				_tmp61_ = collection_type;
				_tmp62_ = vala_code_context_get_analyzer (context);
				_tmp63_ = _tmp62_;
				_tmp64_ = _tmp63_->gvaluearray_type;
				_tmp58_ = vala_data_type_compatible (_tmp61_, _tmp64_);
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaDataType* _tmp65_;
				ValaSemanticAnalyzer* _tmp66_;
				ValaSemanticAnalyzer* _tmp67_;
				ValaStructValueType* _tmp68_;
				_tmp65_ = collection_type;
				_tmp66_ = vala_code_context_get_analyzer (context);
				_tmp67_ = _tmp66_;
				_tmp68_ = _tmp67_->gvalue_type;
				result = vala_foreach_statement_check_without_iterator (self, context, _tmp65_, (ValaDataType*) _tmp68_);
				_vala_code_node_unref0 (collection_type);
				return result;
			} else {
				ValaDataType* _tmp69_;
				_tmp69_ = collection_type;
				result = vala_foreach_statement_check_with_iterator (self, context, _tmp69_);
				_vala_code_node_unref0 (collection_type);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (collection_type);
}

static gboolean
vala_foreach_statement_check_with_index (ValaForeachStatement* self,
                                         ValaCodeContext* context,
                                         ValaDataType* collection_type)
{
	ValaMethod* get_method = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaList* parameters = NULL;
	ValaMethod* _tmp3_;
	ValaList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ValaProperty* size_property = NULL;
	ValaSymbol* _tmp14_;
	ValaProperty* _tmp15_;
	ValaProperty* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaLocalVariable* _tmp24_;
	ValaLocalVariable* _tmp25_;
	ValaSourceReference* _tmp26_;
	ValaSourceReference* _tmp27_;
	ValaDeclarationStatement* _tmp28_;
	ValaDeclarationStatement* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaSourceReference* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaMemberAccess* _tmp38_;
	ValaMemberAccess* _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaMemberAccess* _tmp42_;
	ValaMemberAccess* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaLocalVariable* _tmp46_;
	ValaLocalVariable* _tmp47_;
	ValaSourceReference* _tmp48_;
	ValaSourceReference* _tmp49_;
	ValaDeclarationStatement* _tmp50_;
	ValaDeclarationStatement* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	ValaSourceReference* _tmp55_;
	ValaSourceReference* _tmp56_;
	ValaIntegerLiteral* _tmp57_;
	ValaIntegerLiteral* _tmp58_;
	ValaSourceReference* _tmp59_;
	ValaSourceReference* _tmp60_;
	ValaUnaryExpression* _tmp61_;
	ValaUnaryExpression* _tmp62_;
	ValaSourceReference* _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaLocalVariable* _tmp65_;
	ValaLocalVariable* _tmp66_;
	ValaSourceReference* _tmp67_;
	ValaSourceReference* _tmp68_;
	ValaDeclarationStatement* _tmp69_;
	ValaDeclarationStatement* _tmp70_;
	ValaUnaryExpression* next = NULL;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaSourceReference* _tmp75_;
	ValaMemberAccess* _tmp76_;
	ValaMemberAccess* _tmp77_;
	ValaSourceReference* _tmp78_;
	ValaSourceReference* _tmp79_;
	ValaUnaryExpression* _tmp80_;
	ValaUnaryExpression* _tmp81_;
	ValaBinaryExpression* conditional = NULL;
	ValaUnaryExpression* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	ValaSourceReference* _tmp86_;
	ValaSourceReference* _tmp87_;
	ValaMemberAccess* _tmp88_;
	ValaMemberAccess* _tmp89_;
	ValaSourceReference* _tmp90_;
	ValaSourceReference* _tmp91_;
	ValaBinaryExpression* _tmp92_;
	ValaBinaryExpression* _tmp93_;
	ValaWhileStatement* loop = NULL;
	ValaBinaryExpression* _tmp94_;
	ValaBlock* _tmp95_;
	ValaBlock* _tmp96_;
	ValaSourceReference* _tmp97_;
	ValaSourceReference* _tmp98_;
	ValaWhileStatement* _tmp99_;
	ValaWhileStatement* _tmp100_;
	ValaMethodCall* get_call = NULL;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	ValaSourceReference* _tmp104_;
	ValaSourceReference* _tmp105_;
	ValaMemberAccess* _tmp106_;
	ValaMemberAccess* _tmp107_;
	ValaSourceReference* _tmp108_;
	ValaSourceReference* _tmp109_;
	ValaMemberAccess* _tmp110_;
	ValaMemberAccess* _tmp111_;
	ValaSourceReference* _tmp112_;
	ValaSourceReference* _tmp113_;
	ValaMethodCall* _tmp114_;
	ValaMethodCall* _tmp115_;
	ValaMethodCall* _tmp116_;
	const gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaMemberAccess* _tmp122_;
	ValaMemberAccess* _tmp123_;
	ValaBlock* _tmp124_;
	ValaBlock* _tmp125_;
	ValaDataType* _tmp126_;
	ValaDataType* _tmp127_;
	const gchar* _tmp128_;
	ValaMethodCall* _tmp129_;
	ValaSourceReference* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaLocalVariable* _tmp132_;
	ValaLocalVariable* _tmp133_;
	ValaSourceReference* _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaDeclarationStatement* _tmp136_;
	ValaDeclarationStatement* _tmp137_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_member (collection_type, "get");
	_tmp1_ = VALA_IS_METHOD (_tmp0_) ? ((ValaMethod*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	get_method = _tmp1_;
	_tmp2_ = get_method;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp3_ = get_method;
	_tmp4_ = vala_callable_get_parameters ((ValaCallable*) _tmp3_);
	parameters = _tmp4_;
	_tmp6_ = parameters;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != 1) {
		_tmp5_ = TRUE;
	} else {
		ValaList* _tmp9_;
		gpointer _tmp10_;
		ValaParameter* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp9_ = parameters;
		_tmp10_ = vala_list_get (_tmp9_, 0);
		_tmp11_ = (ValaParameter*) _tmp10_;
		_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp5_ = !VALA_IS_INTEGER_TYPE (_tmp13_);
		_vala_code_node_unref0 (_tmp11_);
	}
	if (_tmp5_) {
		result = FALSE;
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp14_ = vala_data_type_get_member (collection_type, "size");
	_tmp15_ = VALA_IS_PROPERTY (_tmp14_) ? ((ValaProperty*) _tmp14_) : NULL;
	if (_tmp15_ == NULL) {
		_vala_code_node_unref0 (_tmp14_);
	}
	size_property = _tmp15_;
	_tmp16_ = size_property;
	if (_tmp16_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (size_property);
		_vala_code_node_unref0 (get_method);
		return result;
	}
	_tmp17_ = self->priv->_variable_name;
	_tmp18_ = g_strdup_printf ("_%s_list", _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_foreach_statement_get_collection (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_local_variable_new (NULL, _tmp19_, _tmp21_, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_declaration_statement_new ((ValaSymbol*) _tmp25_, _tmp27_);
	_tmp29_ = _tmp28_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp29_);
	_vala_code_node_unref0 (_tmp29_);
	_vala_code_node_unref0 (_tmp25_);
	_g_free0 (_tmp19_);
	_tmp30_ = self->priv->_variable_name;
	_tmp31_ = g_strdup_printf ("_%s_size", _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->_variable_name;
	_tmp34_ = g_strdup_printf ("_%s_list", _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_member_access_new_simple (_tmp35_, _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_member_access_new ((ValaExpression*) _tmp39_, "size", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_local_variable_new (NULL, _tmp32_, (ValaExpression*) _tmp43_, _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_declaration_statement_new ((ValaSymbol*) _tmp47_, _tmp49_);
	_tmp51_ = _tmp50_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp51_);
	_vala_code_node_unref0 (_tmp51_);
	_vala_code_node_unref0 (_tmp47_);
	_vala_code_node_unref0 (_tmp43_);
	_vala_code_node_unref0 (_tmp39_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp32_);
	_tmp52_ = self->priv->_variable_name;
	_tmp53_ = g_strdup_printf ("_%s_index", _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_integer_literal_new ("1", _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp60_ = _tmp59_;
	_tmp61_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, (ValaExpression*) _tmp58_, _tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_local_variable_new (NULL, _tmp54_, (ValaExpression*) _tmp62_, _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_declaration_statement_new ((ValaSymbol*) _tmp66_, _tmp68_);
	_tmp70_ = _tmp69_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp70_);
	_vala_code_node_unref0 (_tmp70_);
	_vala_code_node_unref0 (_tmp66_);
	_vala_code_node_unref0 (_tmp62_);
	_vala_code_node_unref0 (_tmp58_);
	_g_free0 (_tmp54_);
	_tmp71_ = self->priv->_variable_name;
	_tmp72_ = g_strdup_printf ("_%s_index", _tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_member_access_new_simple (_tmp73_, _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp79_ = _tmp78_;
	_tmp80_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_INCREMENT, (ValaExpression*) _tmp77_, _tmp79_);
	_tmp81_ = _tmp80_;
	_vala_code_node_unref0 (_tmp77_);
	_g_free0 (_tmp73_);
	next = _tmp81_;
	_tmp82_ = next;
	_tmp83_ = self->priv->_variable_name;
	_tmp84_ = g_strdup_printf ("_%s_size", _tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_member_access_new_simple (_tmp85_, _tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp91_ = _tmp90_;
	_tmp92_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_LESS_THAN, (ValaExpression*) _tmp82_, (ValaExpression*) _tmp89_, _tmp91_);
	_tmp93_ = _tmp92_;
	_vala_code_node_unref0 (_tmp89_);
	_g_free0 (_tmp85_);
	conditional = _tmp93_;
	_tmp94_ = conditional;
	_tmp95_ = vala_foreach_statement_get_body (self);
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_while_statement_new ((ValaExpression*) _tmp94_, _tmp96_, _tmp98_);
	loop = _tmp99_;
	_tmp100_ = loop;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp100_);
	_tmp101_ = self->priv->_variable_name;
	_tmp102_ = g_strdup_printf ("_%s_list", _tmp101_);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_member_access_new_simple (_tmp103_, _tmp105_);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_member_access_new ((ValaExpression*) _tmp107_, "get", _tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_method_call_new ((ValaExpression*) _tmp111_, _tmp113_);
	_tmp115_ = _tmp114_;
	_vala_code_node_unref0 (_tmp111_);
	_vala_code_node_unref0 (_tmp107_);
	_g_free0 (_tmp103_);
	get_call = _tmp115_;
	_tmp116_ = get_call;
	_tmp117_ = self->priv->_variable_name;
	_tmp118_ = g_strdup_printf ("_%s_index", _tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = vala_member_access_new_simple (_tmp119_, _tmp121_);
	_tmp123_ = _tmp122_;
	vala_method_call_add_argument (_tmp116_, (ValaExpression*) _tmp123_);
	_vala_code_node_unref0 (_tmp123_);
	_g_free0 (_tmp119_);
	_tmp124_ = vala_foreach_statement_get_body (self);
	_tmp125_ = _tmp124_;
	_tmp126_ = vala_foreach_statement_get_type_reference (self);
	_tmp127_ = _tmp126_;
	_tmp128_ = self->priv->_variable_name;
	_tmp129_ = get_call;
	_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_local_variable_new (_tmp127_, _tmp128_, (ValaExpression*) _tmp129_, _tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp135_ = _tmp134_;
	_tmp136_ = vala_declaration_statement_new ((ValaSymbol*) _tmp133_, _tmp135_);
	_tmp137_ = _tmp136_;
	vala_block_insert_statement (_tmp125_, 0, (ValaStatement*) _tmp137_);
	_vala_code_node_unref0 (_tmp137_);
	_vala_code_node_unref0 (_tmp133_);
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	result = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context);
	_vala_code_node_unref0 (get_call);
	_vala_code_node_unref0 (loop);
	_vala_code_node_unref0 (conditional);
	_vala_code_node_unref0 (next);
	_vala_code_node_unref0 (size_property);
	_vala_code_node_unref0 (get_method);
	return result;
}

static gboolean
vala_foreach_statement_check_with_iterator (ValaForeachStatement* self,
                                            ValaCodeContext* context,
                                            ValaDataType* collection_type)
{
	ValaMethod* iterator_method = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp2_;
	ValaMethod* _tmp11_;
	ValaList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	ValaDataType* iterator_type = NULL;
	ValaMethod* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaMethodCall* iterator_call = NULL;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaSourceReference* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaMemberAccess* _tmp42_;
	ValaMemberAccess* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaMethodCall* _tmp46_;
	ValaMethodCall* _tmp47_;
	ValaDataType* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	ValaMethodCall* _tmp52_;
	ValaSourceReference* _tmp53_;
	ValaSourceReference* _tmp54_;
	ValaLocalVariable* _tmp55_;
	ValaLocalVariable* _tmp56_;
	ValaSourceReference* _tmp57_;
	ValaSourceReference* _tmp58_;
	ValaDeclarationStatement* _tmp59_;
	ValaDeclarationStatement* _tmp60_;
	ValaMethod* next_value_method = NULL;
	ValaDataType* _tmp61_;
	ValaSymbol* _tmp62_;
	ValaMethod* _tmp63_;
	ValaMethod* next_method = NULL;
	ValaDataType* _tmp64_;
	ValaSymbol* _tmp65_;
	ValaMethod* _tmp66_;
	ValaMethod* _tmp67_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	vala_foreach_statement_set_use_iterator (self, TRUE);
	if (vala_foreach_statement_check_with_index (self, context, collection_type)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_data_type_get_member (collection_type, "iterator");
	_tmp1_ = VALA_IS_METHOD (_tmp0_) ? ((ValaMethod*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	iterator_method = _tmp1_;
	_tmp2_ = iterator_method;
	if (_tmp2_ == NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = vala_foreach_statement_get_collection (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) collection_type);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("`%s' does not have an `iterator' method", _tmp8_);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp6_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp11_ = iterator_method;
	_tmp12_ = vala_callable_get_parameters ((ValaCallable*) _tmp11_);
	_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != 0) {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaSourceReference* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaMethod* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp15_ = vala_foreach_statement_get_collection (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = iterator_method;
		_tmp20_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("`%s' must not have any parameters", _tmp21_);
		_tmp23_ = _tmp22_;
		vala_report_error (_tmp18_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp24_ = iterator_method;
	_tmp25_ = vala_callable_get_return_type ((ValaCallable*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_data_type_get_actual_type (_tmp26_, collection_type, NULL, (ValaCodeNode*) self);
	iterator_type = _tmp27_;
	_tmp28_ = iterator_type;
	if (VALA_IS_VOID_TYPE (_tmp28_)) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaMethod* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		_tmp29_ = vala_foreach_statement_get_collection (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = iterator_method;
		_tmp34_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("`%s' must return an iterator", _tmp35_);
		_tmp37_ = _tmp36_;
		vala_report_error (_tmp32_, _tmp37_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (iterator_type);
		_vala_code_node_unref0 (iterator_method);
		return result;
	}
	_tmp38_ = vala_foreach_statement_get_collection (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_member_access_new (_tmp39_, "iterator", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_method_call_new ((ValaExpression*) _tmp43_, _tmp45_);
	_tmp47_ = _tmp46_;
	_vala_code_node_unref0 (_tmp43_);
	iterator_call = _tmp47_;
	_tmp48_ = iterator_type;
	_tmp49_ = self->priv->_variable_name;
	_tmp50_ = g_strdup_printf ("_%s_it", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = iterator_call;
	_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_local_variable_new (_tmp48_, _tmp51_, (ValaExpression*) _tmp52_, _tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_declaration_statement_new ((ValaSymbol*) _tmp56_, _tmp58_);
	_tmp60_ = _tmp59_;
	vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp60_);
	_vala_code_node_unref0 (_tmp60_);
	_vala_code_node_unref0 (_tmp56_);
	_g_free0 (_tmp51_);
	_tmp61_ = iterator_type;
	_tmp62_ = vala_data_type_get_member (_tmp61_, "next_value");
	_tmp63_ = VALA_IS_METHOD (_tmp62_) ? ((ValaMethod*) _tmp62_) : NULL;
	if (_tmp63_ == NULL) {
		_vala_code_node_unref0 (_tmp62_);
	}
	next_value_method = _tmp63_;
	_tmp64_ = iterator_type;
	_tmp65_ = vala_data_type_get_member (_tmp64_, "next");
	_tmp66_ = VALA_IS_METHOD (_tmp65_) ? ((ValaMethod*) _tmp65_) : NULL;
	if (_tmp66_ == NULL) {
		_vala_code_node_unref0 (_tmp65_);
	}
	next_method = _tmp66_;
	_tmp67_ = next_value_method;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaList* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		ValaDataType* element_type = NULL;
		ValaMethod* _tmp81_;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaDataType* _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp88_;
		ValaDataType* _tmp98_;
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		const gchar* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaLocalVariable* _tmp104_;
		ValaLocalVariable* _tmp105_;
		ValaSourceReference* _tmp106_;
		ValaSourceReference* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaDeclarationStatement* _tmp109_;
		ValaMethodCall* next_value_call = NULL;
		const gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaMemberAccess* _tmp120_;
		ValaSourceReference* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaMethodCall* _tmp123_;
		ValaMethodCall* _tmp124_;
		ValaAssignment* assignment = NULL;
		const gchar* _tmp125_;
		ValaSourceReference* _tmp126_;
		ValaSourceReference* _tmp127_;
		ValaMemberAccess* _tmp128_;
		ValaMemberAccess* _tmp129_;
		ValaMethodCall* _tmp130_;
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaAssignment* _tmp133_;
		ValaAssignment* _tmp134_;
		ValaBinaryExpression* conditional = NULL;
		ValaAssignment* _tmp135_;
		ValaSourceReference* _tmp136_;
		ValaSourceReference* _tmp137_;
		ValaNullLiteral* _tmp138_;
		ValaNullLiteral* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaSourceReference* _tmp141_;
		ValaBinaryExpression* _tmp142_;
		ValaBinaryExpression* _tmp143_;
		ValaWhileStatement* loop = NULL;
		ValaBinaryExpression* _tmp144_;
		ValaBlock* _tmp145_;
		ValaBlock* _tmp146_;
		ValaSourceReference* _tmp147_;
		ValaSourceReference* _tmp148_;
		ValaWhileStatement* _tmp149_;
		ValaWhileStatement* _tmp150_;
		_tmp68_ = next_value_method;
		_tmp69_ = vala_callable_get_parameters ((ValaCallable*) _tmp68_);
		_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp71_ != 0) {
			ValaExpression* _tmp72_;
			ValaExpression* _tmp73_;
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaMethod* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			_tmp72_ = vala_foreach_statement_get_collection (self);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = next_value_method;
			_tmp77_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = g_strdup_printf ("`%s' must not have any parameters", _tmp78_);
			_tmp80_ = _tmp79_;
			vala_report_error (_tmp75_, _tmp80_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp78_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp81_ = next_value_method;
		_tmp82_ = vala_callable_get_return_type ((ValaCallable*) _tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = iterator_type;
		_tmp85_ = vala_data_type_get_actual_type (_tmp83_, _tmp84_, NULL, (ValaCodeNode*) self);
		element_type = _tmp85_;
		_tmp86_ = element_type;
		_tmp87_ = vala_data_type_get_nullable (_tmp86_);
		_tmp88_ = _tmp87_;
		if (!_tmp88_) {
			ValaExpression* _tmp89_;
			ValaExpression* _tmp90_;
			ValaSourceReference* _tmp91_;
			ValaSourceReference* _tmp92_;
			ValaMethod* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			_tmp89_ = vala_foreach_statement_get_collection (self);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = next_value_method;
			_tmp94_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp93_);
			_tmp95_ = _tmp94_;
			_tmp96_ = g_strdup_printf ("return type of `%s' must be nullable", _tmp95_);
			_tmp97_ = _tmp96_;
			vala_report_error (_tmp92_, _tmp97_);
			_g_free0 (_tmp97_);
			_g_free0 (_tmp95_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp98_ = element_type;
		if (!vala_foreach_statement_analyze_element_type (self, _tmp98_)) {
			result = FALSE;
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
		_tmp99_ = vala_foreach_statement_get_type_reference (self);
		_tmp100_ = _tmp99_;
		_tmp101_ = self->priv->_variable_name;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_local_variable_new (_tmp100_, _tmp101_, NULL, _tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_declaration_statement_new ((ValaSymbol*) _tmp105_, _tmp107_);
		_tmp109_ = _tmp108_;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp109_);
		_vala_code_node_unref0 (_tmp109_);
		_vala_code_node_unref0 (_tmp105_);
		_tmp110_ = self->priv->_variable_name;
		_tmp111_ = g_strdup_printf ("_%s_it", _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_member_access_new ((ValaExpression*) _tmp116_, "next_value", _tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_method_call_new ((ValaExpression*) _tmp120_, _tmp122_);
		_tmp124_ = _tmp123_;
		_vala_code_node_unref0 (_tmp120_);
		_vala_code_node_unref0 (_tmp116_);
		_g_free0 (_tmp112_);
		next_value_call = _tmp124_;
		_tmp125_ = self->priv->_variable_name;
		_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_member_access_new (NULL, _tmp125_, _tmp127_);
		_tmp129_ = _tmp128_;
		_tmp130_ = next_value_call;
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_assignment_new ((ValaExpression*) _tmp129_, (ValaExpression*) _tmp130_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp132_);
		_tmp134_ = _tmp133_;
		_vala_code_node_unref0 (_tmp129_);
		assignment = _tmp134_;
		_tmp135_ = assignment;
		_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_null_literal_new (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_INEQUALITY, (ValaExpression*) _tmp135_, (ValaExpression*) _tmp139_, _tmp141_);
		_tmp143_ = _tmp142_;
		_vala_code_node_unref0 (_tmp139_);
		conditional = _tmp143_;
		_tmp144_ = conditional;
		_tmp145_ = vala_foreach_statement_get_body (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_while_statement_new ((ValaExpression*) _tmp144_, _tmp146_, _tmp148_);
		loop = _tmp149_;
		_tmp150_ = loop;
		vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp150_);
		_vala_code_node_unref0 (loop);
		_vala_code_node_unref0 (conditional);
		_vala_code_node_unref0 (assignment);
		_vala_code_node_unref0 (next_value_call);
		_vala_code_node_unref0 (element_type);
	} else {
		ValaMethod* _tmp151_;
		_tmp151_ = next_method;
		if (_tmp151_ != NULL) {
			ValaMethod* _tmp152_;
			ValaList* _tmp153_;
			gint _tmp154_;
			gint _tmp155_;
			ValaMethod* _tmp165_;
			ValaDataType* _tmp166_;
			ValaDataType* _tmp167_;
			ValaSemanticAnalyzer* _tmp168_;
			ValaSemanticAnalyzer* _tmp169_;
			ValaDataType* _tmp170_;
			ValaMethod* get_method = NULL;
			ValaDataType* _tmp180_;
			ValaSymbol* _tmp181_;
			ValaMethod* _tmp182_;
			ValaMethod* _tmp183_;
			ValaMethod* _tmp193_;
			ValaList* _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			ValaDataType* element_type = NULL;
			ValaMethod* _tmp206_;
			ValaDataType* _tmp207_;
			ValaDataType* _tmp208_;
			ValaDataType* _tmp209_;
			ValaDataType* _tmp210_;
			ValaDataType* _tmp211_;
			ValaDataType* _tmp221_;
			ValaMethodCall* next_call = NULL;
			const gchar* _tmp222_;
			gchar* _tmp223_;
			gchar* _tmp224_;
			ValaSourceReference* _tmp225_;
			ValaSourceReference* _tmp226_;
			ValaMemberAccess* _tmp227_;
			ValaMemberAccess* _tmp228_;
			ValaSourceReference* _tmp229_;
			ValaSourceReference* _tmp230_;
			ValaMemberAccess* _tmp231_;
			ValaMemberAccess* _tmp232_;
			ValaSourceReference* _tmp233_;
			ValaSourceReference* _tmp234_;
			ValaMethodCall* _tmp235_;
			ValaMethodCall* _tmp236_;
			ValaWhileStatement* loop = NULL;
			ValaMethodCall* _tmp237_;
			ValaBlock* _tmp238_;
			ValaBlock* _tmp239_;
			ValaSourceReference* _tmp240_;
			ValaSourceReference* _tmp241_;
			ValaWhileStatement* _tmp242_;
			ValaWhileStatement* _tmp243_;
			ValaMethodCall* get_call = NULL;
			const gchar* _tmp244_;
			gchar* _tmp245_;
			gchar* _tmp246_;
			ValaSourceReference* _tmp247_;
			ValaSourceReference* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaMemberAccess* _tmp250_;
			ValaSourceReference* _tmp251_;
			ValaSourceReference* _tmp252_;
			ValaMemberAccess* _tmp253_;
			ValaMemberAccess* _tmp254_;
			ValaSourceReference* _tmp255_;
			ValaSourceReference* _tmp256_;
			ValaMethodCall* _tmp257_;
			ValaMethodCall* _tmp258_;
			ValaBlock* _tmp259_;
			ValaBlock* _tmp260_;
			ValaDataType* _tmp261_;
			ValaDataType* _tmp262_;
			const gchar* _tmp263_;
			ValaMethodCall* _tmp264_;
			ValaSourceReference* _tmp265_;
			ValaSourceReference* _tmp266_;
			ValaLocalVariable* _tmp267_;
			ValaLocalVariable* _tmp268_;
			ValaSourceReference* _tmp269_;
			ValaSourceReference* _tmp270_;
			ValaDeclarationStatement* _tmp271_;
			ValaDeclarationStatement* _tmp272_;
			_tmp152_ = next_method;
			_tmp153_ = vala_callable_get_parameters ((ValaCallable*) _tmp152_);
			_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_ != 0) {
				ValaExpression* _tmp156_;
				ValaExpression* _tmp157_;
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaMethod* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				gchar* _tmp164_;
				_tmp156_ = vala_foreach_statement_get_collection (self);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = next_method;
				_tmp161_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = g_strdup_printf ("`%s' must not have any parameters", _tmp162_);
				_tmp164_ = _tmp163_;
				vala_report_error (_tmp159_, _tmp164_);
				_g_free0 (_tmp164_);
				_g_free0 (_tmp162_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp165_ = next_method;
			_tmp166_ = vala_callable_get_return_type ((ValaCallable*) _tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_code_context_get_analyzer (context);
			_tmp169_ = _tmp168_;
			_tmp170_ = _tmp169_->bool_type;
			if (!vala_data_type_compatible (_tmp167_, _tmp170_)) {
				ValaExpression* _tmp171_;
				ValaExpression* _tmp172_;
				ValaSourceReference* _tmp173_;
				ValaSourceReference* _tmp174_;
				ValaMethod* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				_tmp171_ = vala_foreach_statement_get_collection (self);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp172_);
				_tmp174_ = _tmp173_;
				_tmp175_ = next_method;
				_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = g_strdup_printf ("`%s' must return a boolean value", _tmp177_);
				_tmp179_ = _tmp178_;
				vala_report_error (_tmp174_, _tmp179_);
				_g_free0 (_tmp179_);
				_g_free0 (_tmp177_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp180_ = iterator_type;
			_tmp181_ = vala_data_type_get_member (_tmp180_, "get");
			_tmp182_ = VALA_IS_METHOD (_tmp181_) ? ((ValaMethod*) _tmp181_) : NULL;
			if (_tmp182_ == NULL) {
				_vala_code_node_unref0 (_tmp181_);
			}
			get_method = _tmp182_;
			_tmp183_ = get_method;
			if (_tmp183_ == NULL) {
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSourceReference* _tmp186_;
				ValaSourceReference* _tmp187_;
				ValaDataType* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				gchar* _tmp192_;
				_tmp184_ = vala_foreach_statement_get_collection (self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = iterator_type;
				_tmp189_ = vala_code_node_to_string ((ValaCodeNode*) _tmp188_);
				_tmp190_ = _tmp189_;
				_tmp191_ = g_strdup_printf ("`%s' does not have a `get' method", _tmp190_);
				_tmp192_ = _tmp191_;
				vala_report_error (_tmp187_, _tmp192_);
				_g_free0 (_tmp192_);
				_g_free0 (_tmp190_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp193_ = get_method;
			_tmp194_ = vala_callable_get_parameters ((ValaCallable*) _tmp193_);
			_tmp195_ = vala_collection_get_size ((ValaCollection*) _tmp194_);
			_tmp196_ = _tmp195_;
			if (_tmp196_ != 0) {
				ValaExpression* _tmp197_;
				ValaExpression* _tmp198_;
				ValaSourceReference* _tmp199_;
				ValaSourceReference* _tmp200_;
				ValaMethod* _tmp201_;
				gchar* _tmp202_;
				gchar* _tmp203_;
				gchar* _tmp204_;
				gchar* _tmp205_;
				_tmp197_ = vala_foreach_statement_get_collection (self);
				_tmp198_ = _tmp197_;
				_tmp199_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = get_method;
				_tmp202_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = g_strdup_printf ("`%s' must not have any parameters", _tmp203_);
				_tmp205_ = _tmp204_;
				vala_report_error (_tmp200_, _tmp205_);
				_g_free0 (_tmp205_);
				_g_free0 (_tmp203_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp206_ = get_method;
			_tmp207_ = vala_callable_get_return_type ((ValaCallable*) _tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = iterator_type;
			_tmp210_ = vala_data_type_get_actual_type (_tmp208_, _tmp209_, NULL, (ValaCodeNode*) self);
			element_type = _tmp210_;
			_tmp211_ = element_type;
			if (VALA_IS_VOID_TYPE (_tmp211_)) {
				ValaExpression* _tmp212_;
				ValaExpression* _tmp213_;
				ValaSourceReference* _tmp214_;
				ValaSourceReference* _tmp215_;
				ValaMethod* _tmp216_;
				gchar* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				gchar* _tmp220_;
				_tmp212_ = vala_foreach_statement_get_collection (self);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = get_method;
				_tmp217_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = g_strdup_printf ("`%s' must return an element", _tmp218_);
				_tmp220_ = _tmp219_;
				vala_report_error (_tmp215_, _tmp220_);
				_g_free0 (_tmp220_);
				_g_free0 (_tmp218_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp221_ = element_type;
			if (!vala_foreach_statement_analyze_element_type (self, _tmp221_)) {
				result = FALSE;
				_vala_code_node_unref0 (element_type);
				_vala_code_node_unref0 (get_method);
				_vala_code_node_unref0 (next_method);
				_vala_code_node_unref0 (next_value_method);
				_vala_code_node_unref0 (iterator_call);
				_vala_code_node_unref0 (iterator_type);
				_vala_code_node_unref0 (iterator_method);
				return result;
			}
			_tmp222_ = self->priv->_variable_name;
			_tmp223_ = g_strdup_printf ("_%s_it", _tmp222_);
			_tmp224_ = _tmp223_;
			_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp226_ = _tmp225_;
			_tmp227_ = vala_member_access_new_simple (_tmp224_, _tmp226_);
			_tmp228_ = _tmp227_;
			_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp230_ = _tmp229_;
			_tmp231_ = vala_member_access_new ((ValaExpression*) _tmp228_, "next", _tmp230_);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp234_ = _tmp233_;
			_tmp235_ = vala_method_call_new ((ValaExpression*) _tmp232_, _tmp234_);
			_tmp236_ = _tmp235_;
			_vala_code_node_unref0 (_tmp232_);
			_vala_code_node_unref0 (_tmp228_);
			_g_free0 (_tmp224_);
			next_call = _tmp236_;
			_tmp237_ = next_call;
			_tmp238_ = vala_foreach_statement_get_body (self);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp241_ = _tmp240_;
			_tmp242_ = vala_while_statement_new ((ValaExpression*) _tmp237_, _tmp239_, _tmp241_);
			loop = _tmp242_;
			_tmp243_ = loop;
			vala_block_add_statement ((ValaBlock*) self, (ValaStatement*) _tmp243_);
			_tmp244_ = self->priv->_variable_name;
			_tmp245_ = g_strdup_printf ("_%s_it", _tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_member_access_new_simple (_tmp246_, _tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp252_ = _tmp251_;
			_tmp253_ = vala_member_access_new ((ValaExpression*) _tmp250_, "get", _tmp252_);
			_tmp254_ = _tmp253_;
			_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_method_call_new ((ValaExpression*) _tmp254_, _tmp256_);
			_tmp258_ = _tmp257_;
			_vala_code_node_unref0 (_tmp254_);
			_vala_code_node_unref0 (_tmp250_);
			_g_free0 (_tmp246_);
			get_call = _tmp258_;
			_tmp259_ = vala_foreach_statement_get_body (self);
			_tmp260_ = _tmp259_;
			_tmp261_ = vala_foreach_statement_get_type_reference (self);
			_tmp262_ = _tmp261_;
			_tmp263_ = self->priv->_variable_name;
			_tmp264_ = get_call;
			_tmp265_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp266_ = _tmp265_;
			_tmp267_ = vala_local_variable_new (_tmp262_, _tmp263_, (ValaExpression*) _tmp264_, _tmp266_);
			_tmp268_ = _tmp267_;
			_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp270_ = _tmp269_;
			_tmp271_ = vala_declaration_statement_new ((ValaSymbol*) _tmp268_, _tmp270_);
			_tmp272_ = _tmp271_;
			vala_block_insert_statement (_tmp260_, 0, (ValaStatement*) _tmp272_);
			_vala_code_node_unref0 (_tmp272_);
			_vala_code_node_unref0 (_tmp268_);
			_vala_code_node_unref0 (get_call);
			_vala_code_node_unref0 (loop);
			_vala_code_node_unref0 (next_call);
			_vala_code_node_unref0 (element_type);
			_vala_code_node_unref0 (get_method);
		} else {
			ValaExpression* _tmp273_;
			ValaExpression* _tmp274_;
			ValaSourceReference* _tmp275_;
			ValaSourceReference* _tmp276_;
			ValaDataType* _tmp277_;
			gchar* _tmp278_;
			gchar* _tmp279_;
			gchar* _tmp280_;
			gchar* _tmp281_;
			_tmp273_ = vala_foreach_statement_get_collection (self);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp277_ = iterator_type;
			_tmp278_ = vala_code_node_to_string ((ValaCodeNode*) _tmp277_);
			_tmp279_ = _tmp278_;
			_tmp280_ = g_strdup_printf ("`%s' does not have a `next_value' or `next' method", _tmp279_);
			_tmp281_ = _tmp280_;
			vala_report_error (_tmp276_, _tmp281_);
			_g_free0 (_tmp281_);
			_g_free0 (_tmp279_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (next_method);
			_vala_code_node_unref0 (next_value_method);
			_vala_code_node_unref0 (iterator_call);
			_vala_code_node_unref0 (iterator_type);
			_vala_code_node_unref0 (iterator_method);
			return result;
		}
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
	result = VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context);
	_vala_code_node_unref0 (next_method);
	_vala_code_node_unref0 (next_value_method);
	_vala_code_node_unref0 (iterator_call);
	_vala_code_node_unref0 (iterator_type);
	_vala_code_node_unref0 (iterator_method);
	return result;
}

static gboolean
vala_foreach_statement_analyze_element_type (ValaForeachStatement* self,
                                             ValaDataType* element_type)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_data_type_copy (element_type);
		_tmp3_ = _tmp2_;
		vala_foreach_statement_set_type_reference (self, _tmp3_);
		_vala_code_node_unref0 (_tmp3_);
	} else {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_foreach_statement_get_type_reference (self);
		_tmp5_ = _tmp4_;
		if (!vala_data_type_compatible (element_type, _tmp5_)) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) element_type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_foreach_statement_get_type_reference (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Foreach: Cannot convert from `%s' to `%s'", _tmp9_, _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp7_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp9_);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			if (vala_data_type_is_disposable (element_type)) {
				gboolean _tmp18_;
				gboolean _tmp19_;
				_tmp18_ = vala_data_type_get_value_owned (element_type);
				_tmp19_ = _tmp18_;
				_tmp17_ = _tmp19_;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ValaDataType* _tmp20_;
				ValaDataType* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp20_ = vala_foreach_statement_get_type_reference (self);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_data_type_get_value_owned (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp16_ = !_tmp23_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp25_, "Foreach: Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_foreach_statement_check_without_iterator (ValaForeachStatement* self,
                                               ValaCodeContext* context,
                                               ValaDataType* collection_type,
                                               ValaDataType* element_type)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	const gchar* _tmp18_;
	ValaSourceReference* _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaLocalVariable* _tmp21_;
	ValaLocalVariable* _tmp22_;
	ValaBlock* _tmp23_;
	ValaBlock* _tmp24_;
	ValaScope* _tmp25_;
	ValaScope* _tmp26_;
	const gchar* _tmp27_;
	ValaLocalVariable* _tmp28_;
	ValaBlock* _tmp29_;
	ValaBlock* _tmp30_;
	ValaLocalVariable* _tmp31_;
	ValaLocalVariable* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaSemanticAnalyzer* _tmp34_;
	ValaSemanticAnalyzer* _tmp35_;
	ValaSymbol* _tmp36_;
	ValaSymbol* _tmp37_;
	ValaScope* _tmp38_;
	ValaScope* _tmp39_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	ValaLocalVariable* _tmp42_;
	ValaLocalVariable* _tmp43_;
	ValaBlock* _tmp44_;
	ValaBlock* _tmp45_;
	ValaSemanticAnalyzer* _tmp56_;
	ValaSemanticAnalyzer* _tmp57_;
	ValaSemanticAnalyzer* _tmp58_;
	ValaSemanticAnalyzer* _tmp59_;
	ValaSymbol* _tmp60_;
	ValaSymbol* _tmp61_;
	ValaSymbol* _tmp62_;
	ValaSymbol* _tmp63_;
	ValaDataType* _tmp64_;
	ValaDataType* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	ValaLocalVariable* _tmp69_;
	ValaLocalVariable* _tmp70_;
	ValaLocalVariable* _tmp71_;
	ValaLocalVariable* _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (collection_type != NULL, FALSE);
	g_return_val_if_fail (element_type != NULL, FALSE);
	_tmp0_ = vala_foreach_statement_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_data_type_copy (element_type);
		_tmp3_ = _tmp2_;
		vala_foreach_statement_set_type_reference (self, _tmp3_);
		_vala_code_node_unref0 (_tmp3_);
	} else {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp4_ = vala_foreach_statement_get_type_reference (self);
		_tmp5_ = _tmp4_;
		if (!vala_data_type_compatible (element_type, _tmp5_)) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) element_type);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_foreach_statement_get_type_reference (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Foreach: Cannot convert from `%s' to `%s'", _tmp9_, _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp7_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp9_);
			result = FALSE;
			return result;
		}
	}
	_tmp16_ = vala_foreach_statement_get_type_reference (self);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_variable_name;
	_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_local_variable_new (_tmp17_, _tmp18_, NULL, _tmp20_);
	_tmp22_ = _tmp21_;
	vala_foreach_statement_set_element_variable (self, _tmp22_);
	_vala_code_node_unref0 (_tmp22_);
	_tmp23_ = vala_foreach_statement_get_body (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->_variable_name;
	_tmp28_ = self->priv->_element_variable;
	vala_scope_add (_tmp26_, _tmp27_, (ValaSymbol*) _tmp28_);
	_tmp29_ = vala_foreach_statement_get_body (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_element_variable;
	vala_block_add_local_variable (_tmp30_, _tmp31_);
	_tmp32_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp32_, TRUE);
	_tmp33_ = self->priv->_element_variable;
	vala_code_node_set_checked ((ValaCodeNode*) _tmp33_, TRUE);
	_tmp34_ = vala_code_context_get_analyzer (context);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_symbol_get_scope (_tmp37_);
	_tmp39_ = _tmp38_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp39_);
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	vala_semantic_analyzer_set_current_symbol (_tmp41_, (ValaSymbol*) self);
	_tmp42_ = self->priv->_element_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp42_);
	_tmp43_ = self->priv->_element_variable;
	vala_block_remove_local_variable ((ValaBlock*) self, _tmp43_);
	_tmp44_ = vala_foreach_statement_get_body (self);
	_tmp45_ = _tmp44_;
	vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp46_;
		ValaList* _tmp47_;
		gint _local_size = 0;
		ValaList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _local_index = 0;
		_tmp46_ = vala_block_get_local_variables ((ValaBlock*) self);
		_tmp47_ = _vala_iterable_ref0 (_tmp46_);
		_local_list = _tmp47_;
		_tmp48_ = _local_list;
		_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_local_size = _tmp50_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaLocalVariable* _tmp55_;
			_local_index = _local_index + 1;
			_tmp51_ = _local_index;
			_tmp52_ = _local_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _local_list;
			_tmp54_ = vala_list_get (_tmp53_, _local_index);
			local = (ValaLocalVariable*) _tmp54_;
			_tmp55_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp55_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	_tmp56_ = vala_code_context_get_analyzer (context);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_code_context_get_analyzer (context);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_semantic_analyzer_get_current_symbol (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = vala_symbol_get_parent_symbol (_tmp61_);
	_tmp63_ = _tmp62_;
	vala_semantic_analyzer_set_current_symbol (_tmp57_, _tmp63_);
	_tmp64_ = vala_data_type_copy (collection_type);
	_tmp65_ = _tmp64_;
	_tmp66_ = self->priv->_variable_name;
	_tmp67_ = g_strdup_printf ("%s_collection", _tmp66_);
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_local_variable_new (_tmp65_, _tmp68_, NULL, NULL);
	_tmp70_ = _tmp69_;
	vala_foreach_statement_set_collection_variable (self, _tmp70_);
	_vala_code_node_unref0 (_tmp70_);
	_g_free0 (_tmp68_);
	_vala_code_node_unref0 (_tmp65_);
	_tmp71_ = self->priv->_collection_variable;
	vala_block_add_local_variable ((ValaBlock*) self, _tmp71_);
	_tmp72_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp72_, TRUE);
	_tmp73_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp74_ = _tmp73_;
	result = !_tmp74_;
	return result;
}

static void
vala_foreach_statement_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaForeachStatement * self;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_foreach_statement_get_collection (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	_tmp4_ = vala_foreach_statement_get_body (self);
	_tmp5_ = _tmp4_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp5_, collection, source_reference);
}

static void
vala_foreach_statement_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaForeachStatement * self;
	gboolean _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaLocalVariable* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaLocalVariable* _tmp7_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = self->priv->_use_iterator;
	if (_tmp0_) {
		VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), codegen);
		return;
	}
	_tmp1_ = vala_foreach_statement_get_collection (self);
	_tmp2_ = _tmp1_;
	vala_code_node_emit ((ValaCodeNode*) _tmp2_, codegen);
	_tmp3_ = vala_foreach_statement_get_collection (self);
	_tmp4_ = _tmp3_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) codegen, _tmp4_);
	_tmp5_ = self->priv->_element_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp5_, TRUE);
	_tmp6_ = self->priv->_collection_variable;
	vala_symbol_set_active ((ValaSymbol*) _tmp6_, TRUE);
	_tmp7_ = self->priv->_iterator_variable;
	if (_tmp7_ != NULL) {
		ValaLocalVariable* _tmp8_;
		_tmp8_ = self->priv->_iterator_variable;
		vala_symbol_set_active ((ValaSymbol*) _tmp8_, TRUE);
	}
	vala_code_visitor_visit_foreach_statement ((ValaCodeVisitor*) codegen, self);
}

static void
vala_foreach_statement_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaForeachStatement * self;
	ValaLocalVariable* _tmp0_;
	self = (ValaForeachStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_element_variable;
	if (_tmp0_ != NULL) {
		ValaLocalVariable* _tmp1_;
		_tmp1_ = self->priv->_element_variable;
		vala_collection_add (collection, (ValaVariable*) _tmp1_);
	}
}

static void
vala_foreach_statement_class_init (ValaForeachStatementClass * klass,
                                   gpointer klass_data)
{
	vala_foreach_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_foreach_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForeachStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_foreach_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_foreach_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_foreach_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_foreach_statement_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_foreach_statement_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_foreach_statement_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_foreach_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_foreach_statement_real_get_defined_variables;
}

static void
vala_foreach_statement_instance_init (ValaForeachStatement * self,
                                      gpointer klass)
{
	self->priv = vala_foreach_statement_get_instance_private (self);
}

static void
vala_foreach_statement_finalize (ValaCodeNode * obj)
{
	ValaForeachStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement);
	_g_free0 (self->priv->_variable_name);
	_vala_code_node_unref0 (self->priv->_element_variable);
	_vala_code_node_unref0 (self->priv->_collection_variable);
	_vala_code_node_unref0 (self->priv->_iterator_variable);
	_vala_code_node_unref0 (self->priv->_collection);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_foreach_statement_parent_class)->finalize (obj);
}

/**
 * Represents a foreach statement in the source code.
 *
 * Foreach statements iterate over the elements of a collection.
 */
static GType
vala_foreach_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaForeachStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_foreach_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForeachStatement), 0, (GInstanceInitFunc) vala_foreach_statement_instance_init, NULL };
	GType vala_foreach_statement_type_id;
	vala_foreach_statement_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaForeachStatement", &g_define_type_info, 0);
	ValaForeachStatement_private_offset = g_type_add_instance_private (vala_foreach_statement_type_id, sizeof (ValaForeachStatementPrivate));
	return vala_foreach_statement_type_id;
}

GType
vala_foreach_statement_get_type (void)
{
	static volatile gsize vala_foreach_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_foreach_statement_type_id__volatile)) {
		GType vala_foreach_statement_type_id;
		vala_foreach_statement_type_id = vala_foreach_statement_get_type_once ();
		g_once_init_leave (&vala_foreach_statement_type_id__volatile, vala_foreach_statement_type_id);
	}
	return vala_foreach_statement_type_id__volatile;
}

