/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	ValaArrayList* visited_types = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp666_ = FALSE;
	gboolean _tmp667_ = FALSE;
	gboolean _tmp668_ = FALSE;
	ValaExpression* _tmp669_;
	ValaExpression* _tmp670_;
	ValaSymbol* _tmp698_;
	ValaSymbol* _tmp699_;
	ValaSymbol* _tmp771_;
	ValaSymbol* _tmp772_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp810_;
	ValaSymbol* _tmp811_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp812_;
	ValaSymbol* _tmp813_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1202_;
	ValaSymbol* _tmp1203_;
	ValaSymbol* _tmp1205_;
	ValaVersionAttribute* _tmp1206_;
	ValaVersionAttribute* _tmp1207_;
	ValaSourceReference* _tmp1208_;
	ValaSourceReference* _tmp1209_;
	gboolean _tmp1210_ = FALSE;
	ValaSymbolAccessibility _tmp1211_;
	gboolean _tmp1267_ = FALSE;
	gboolean _tmp1294_ = FALSE;
	gboolean _tmp1295_ = FALSE;
	ValaDataType* _tmp1574_;
	ValaDataType* _tmp1575_;
	gboolean _tmp1578_;
	gboolean _tmp1579_;
	gboolean _tmp1580_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	visited_types = _tmp19_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaScope* _tmp24_;
		ValaScope* _tmp25_;
		const gchar* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		base_symbol = (ValaSymbol*) _tmp22_;
		_tmp23_ = base_symbol;
		_tmp24_ = vala_symbol_get_scope (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_member_name;
		_tmp27_ = vala_scope_lookup (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
	} else {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		_tmp29_ = vala_member_access_get_inner (self);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == NULL) {
			const gchar* _tmp31_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp40_;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSymbol* _tmp42_;
			ValaSymbol* _tmp43_;
			gboolean _tmp200_ = FALSE;
			ValaSymbol* _tmp201_;
			ValaSymbol* _tmp202_;
			_tmp31_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp31_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp32_;
				ValaSemanticAnalyzer* _tmp33_;
				_tmp32_ = vala_code_context_get_analyzer (context);
				_tmp33_ = _tmp32_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp33_)) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp35_ = _tmp34_;
					vala_report_error (_tmp35_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			base_symbol = _tmp39_;
			method_found = FALSE;
			_tmp40_ = vala_code_context_get_analyzer (context);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_semantic_analyzer_get_current_symbol (_tmp41_);
			_tmp43_ = _tmp42_;
			sym = _tmp43_;
			while (TRUE) {
				gboolean _tmp44_ = FALSE;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp91_;
				const gchar* _tmp92_;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				gboolean _tmp95_ = FALSE;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				gboolean _tmp153_ = FALSE;
				gboolean _tmp154_ = FALSE;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				_tmp45_ = sym;
				if (_tmp45_ != NULL) {
					ValaSymbol* _tmp46_;
					ValaSymbol* _tmp47_;
					_tmp46_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp47_ = _tmp46_;
					_tmp44_ = _tmp47_ == NULL;
				} else {
					_tmp44_ = FALSE;
				}
				if (!_tmp44_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp48_;
					_tmp48_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp48_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						_tmp49_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						this_parameter = _tmp52_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp53_;
						_tmp53_ = sym;
						if (VALA_IS_PROPERTY (_tmp53_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp54_;
							ValaProperty* _tmp55_;
							ValaParameter* _tmp56_;
							ValaParameter* _tmp57_;
							ValaProperty* _tmp58_;
							ValaMemberBinding _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							_tmp54_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp55_ = prop;
							_tmp56_ = vala_property_get_this_parameter (_tmp55_);
							_tmp57_ = _tmp56_;
							this_parameter = _tmp57_;
							_tmp58_ = prop;
							_tmp59_ = vala_property_get_binding (_tmp58_);
							_tmp60_ = _tmp59_;
							may_access_instance_members = _tmp60_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_klass_members = _tmp63_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp64_;
							_tmp64_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp64_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp65_;
								ValaConstructor* _tmp66_;
								ValaParameter* _tmp67_;
								ValaParameter* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaMemberBinding _tmp70_;
								ValaMemberBinding _tmp71_;
								_tmp65_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp66_ = c;
								_tmp67_ = vala_constructor_get_this_parameter (_tmp66_);
								_tmp68_ = _tmp67_;
								this_parameter = _tmp68_;
								_tmp69_ = c;
								_tmp70_ = vala_constructor_get_binding (_tmp69_);
								_tmp71_ = _tmp70_;
								may_access_instance_members = _tmp71_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp72_;
								_tmp72_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp72_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp73_;
									ValaDestructor* _tmp74_;
									ValaParameter* _tmp75_;
									ValaParameter* _tmp76_;
									ValaDestructor* _tmp77_;
									ValaMemberBinding _tmp78_;
									ValaMemberBinding _tmp79_;
									_tmp73_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp74_ = d;
									_tmp75_ = vala_destructor_get_this_parameter (_tmp74_);
									_tmp76_ = _tmp75_;
									this_parameter = _tmp76_;
									_tmp77_ = d;
									_tmp78_ = vala_destructor_get_binding (_tmp77_);
									_tmp79_ = _tmp78_;
									may_access_instance_members = _tmp79_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp80_;
									_tmp80_ = sym;
									if (VALA_IS_METHOD (_tmp80_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp81_;
										ValaMethod* _tmp82_;
										ValaParameter* _tmp83_;
										ValaParameter* _tmp84_;
										ValaMethod* _tmp85_;
										ValaMemberBinding _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMethod* _tmp88_;
										ValaMemberBinding _tmp89_;
										ValaMemberBinding _tmp90_;
										_tmp81_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_METHOD, ValaMethod);
										_tmp82_ = m;
										_tmp83_ = vala_method_get_this_parameter (_tmp82_);
										_tmp84_ = _tmp83_;
										this_parameter = _tmp84_;
										_tmp85_ = m;
										_tmp86_ = vala_method_get_binding (_tmp85_);
										_tmp87_ = _tmp86_;
										may_access_instance_members = _tmp87_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp88_ = m;
										_tmp89_ = vala_method_get_binding (_tmp88_);
										_tmp90_ = _tmp89_;
										may_access_klass_members = _tmp90_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp91_ = sym;
				_tmp92_ = self->priv->_member_name;
				_tmp93_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp91_, _tmp92_);
				_tmp94_ = _tmp93_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp94_);
				_vala_code_node_unref0 (_tmp94_);
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp97_ = _tmp96_;
				if (_tmp97_ == NULL) {
					ValaSymbol* _tmp98_;
					_tmp98_ = sym;
					_tmp95_ = VALA_IS_WITH_STATEMENT (_tmp98_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaWithStatement* w = NULL;
					ValaSymbol* _tmp99_;
					ValaDataType* variable_type = NULL;
					ValaWithStatement* _tmp100_;
					ValaLocalVariable* _tmp101_;
					ValaLocalVariable* _tmp102_;
					ValaDataType* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					ValaArrayList* _tmp111_;
					ValaDataType* _tmp112_;
					ValaDataType* _tmp113_;
					const gchar* _tmp114_;
					ValaSymbol* _tmp115_;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					ValaSymbol* _tmp118_;
					_tmp99_ = sym;
					w = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_WITH_STATEMENT, ValaWithStatement);
					_tmp100_ = w;
					_tmp101_ = vala_with_statement_get_with_variable (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_variable_get_variable_type ((ValaVariable*) _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = _vala_code_node_ref0 (_tmp104_);
					variable_type = _tmp105_;
					_tmp106_ = variable_type;
					if (VALA_IS_POINTER_TYPE (_tmp106_)) {
						ValaDataType* _tmp107_;
						ValaDataType* _tmp108_;
						ValaDataType* _tmp109_;
						ValaDataType* _tmp110_;
						_tmp107_ = variable_type;
						_tmp108_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp107_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
						_tmp109_ = _tmp108_;
						_tmp110_ = _vala_code_node_ref0 (_tmp109_);
						_vala_code_node_unref0 (variable_type);
						variable_type = _tmp110_;
					}
					_tmp111_ = visited_types;
					_tmp112_ = variable_type;
					vala_collection_add ((ValaCollection*) _tmp111_, _tmp112_);
					_tmp113_ = variable_type;
					_tmp114_ = self->priv->_member_name;
					_tmp115_ = vala_data_type_get_member (_tmp113_, _tmp114_);
					_tmp116_ = _tmp115_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp116_);
					_vala_code_node_unref0 (_tmp116_);
					_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp118_ = _tmp117_;
					if (_tmp118_ != NULL) {
						ValaWithStatement* _tmp119_;
						ValaLocalVariable* _tmp120_;
						ValaLocalVariable* _tmp121_;
						const gchar* _tmp122_;
						const gchar* _tmp123_;
						ValaSourceReference* _tmp124_;
						ValaSourceReference* _tmp125_;
						ValaMemberAccess* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaWithStatement* _tmp128_;
						ValaLocalVariable* _tmp129_;
						ValaLocalVariable* _tmp130_;
						ValaSymbol* _tmp131_;
						ValaSymbol* _tmp132_;
						ValaWithStatement* _tmp133_;
						ValaBlock* _tmp134_;
						ValaBlock* _tmp135_;
						_tmp119_ = w;
						_tmp120_ = vala_with_statement_get_with_variable (_tmp119_);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_symbol_get_name ((ValaSymbol*) _tmp121_);
						_tmp123_ = _tmp122_;
						_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp125_ = _tmp124_;
						_tmp126_ = vala_member_access_new (NULL, _tmp123_, _tmp125_);
						_tmp127_ = _tmp126_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp127_);
						_vala_code_node_unref0 (_tmp127_);
						_tmp128_ = w;
						_tmp129_ = vala_with_statement_get_with_variable (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp130_);
						_tmp132_ = _tmp131_;
						_tmp133_ = w;
						_tmp134_ = vala_with_statement_get_body (_tmp133_);
						_tmp135_ = _tmp134_;
						if (_tmp132_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp135_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							ValaExpression* _tmp136_;
							ValaExpression* _tmp137_;
							_tmp136_ = vala_member_access_get_inner (self);
							_tmp137_ = _tmp136_;
							vala_code_node_check ((ValaCodeNode*) _tmp137_, context);
						} else {
							ValaSymbol* old_symbol = NULL;
							ValaSemanticAnalyzer* _tmp138_;
							ValaSemanticAnalyzer* _tmp139_;
							ValaSymbol* _tmp140_;
							ValaSymbol* _tmp141_;
							ValaSymbol* _tmp142_;
							ValaSemanticAnalyzer* _tmp143_;
							ValaSemanticAnalyzer* _tmp144_;
							ValaWithStatement* _tmp145_;
							ValaSymbol* _tmp146_;
							ValaSymbol* _tmp147_;
							ValaExpression* _tmp148_;
							ValaExpression* _tmp149_;
							ValaSemanticAnalyzer* _tmp150_;
							ValaSemanticAnalyzer* _tmp151_;
							ValaSymbol* _tmp152_;
							_tmp138_ = vala_code_context_get_analyzer (context);
							_tmp139_ = _tmp138_;
							_tmp140_ = vala_semantic_analyzer_get_current_symbol (_tmp139_);
							_tmp141_ = _tmp140_;
							_tmp142_ = _vala_code_node_ref0 (_tmp141_);
							old_symbol = _tmp142_;
							_tmp143_ = vala_code_context_get_analyzer (context);
							_tmp144_ = _tmp143_;
							_tmp145_ = w;
							_tmp146_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp145_);
							_tmp147_ = _tmp146_;
							vala_semantic_analyzer_set_current_symbol (_tmp144_, _tmp147_);
							_tmp148_ = vala_member_access_get_inner (self);
							_tmp149_ = _tmp148_;
							vala_code_node_check ((ValaCodeNode*) _tmp149_, context);
							_tmp150_ = vala_code_context_get_analyzer (context);
							_tmp151_ = _tmp150_;
							_tmp152_ = old_symbol;
							vala_semantic_analyzer_set_current_symbol (_tmp151_, _tmp152_);
							_vala_code_node_unref0 (old_symbol);
						}
						may_access_instance_members = TRUE;
					}
					_vala_code_node_unref0 (variable_type);
				}
				_tmp155_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp156_ = _tmp155_;
				if (_tmp156_ == NULL) {
					ValaSymbol* _tmp157_;
					_tmp157_ = sym;
					_tmp154_ = VALA_IS_TYPESYMBOL (_tmp157_);
				} else {
					_tmp154_ = FALSE;
				}
				if (_tmp154_) {
					_tmp153_ = may_access_instance_members;
				} else {
					_tmp153_ = FALSE;
				}
				if (_tmp153_) {
					ValaParameter* _tmp158_;
					ValaDataType* _tmp159_;
					ValaDataType* _tmp160_;
					const gchar* _tmp161_;
					ValaSymbol* _tmp162_;
					ValaSymbol* _tmp163_;
					gboolean _tmp164_ = FALSE;
					ValaSymbol* _tmp165_;
					ValaSymbol* _tmp166_;
					_tmp158_ = this_parameter;
					_tmp159_ = vala_variable_get_variable_type ((ValaVariable*) _tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = self->priv->_member_name;
					_tmp162_ = vala_data_type_get_member (_tmp160_, _tmp161_);
					_tmp163_ = _tmp162_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp163_);
					_vala_code_node_unref0 (_tmp163_);
					_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp166_ = _tmp165_;
					if (_tmp166_ != NULL) {
						ValaSymbol* _tmp167_;
						ValaSymbol* _tmp168_;
						_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp168_ = _tmp167_;
						_tmp164_ = vala_member_access_is_instance_symbol (_tmp168_);
					} else {
						_tmp164_ = FALSE;
					}
					if (_tmp164_) {
						ValaSourceReference* _tmp169_;
						ValaSourceReference* _tmp170_;
						ValaMemberAccess* _tmp171_;
						ValaMemberAccess* _tmp172_;
						ValaExpression* _tmp173_;
						ValaExpression* _tmp174_;
						ValaParameter* _tmp175_;
						ValaDataType* _tmp176_;
						ValaDataType* _tmp177_;
						ValaDataType* _tmp178_;
						ValaDataType* _tmp179_;
						ValaExpression* _tmp180_;
						ValaExpression* _tmp181_;
						ValaDataType* _tmp182_;
						ValaDataType* _tmp183_;
						ValaExpression* _tmp184_;
						ValaExpression* _tmp185_;
						ValaParameter* _tmp186_;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						const gchar* _tmp191_;
						ValaSymbol* _tmp192_;
						ValaSymbol* _tmp193_;
						_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp170_ = _tmp169_;
						_tmp171_ = vala_member_access_new (NULL, "this", _tmp170_);
						_tmp172_ = _tmp171_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp172_);
						_vala_code_node_unref0 (_tmp172_);
						_tmp173_ = vala_member_access_get_inner (self);
						_tmp174_ = _tmp173_;
						_tmp175_ = this_parameter;
						_tmp176_ = vala_variable_get_variable_type ((ValaVariable*) _tmp175_);
						_tmp177_ = _tmp176_;
						_tmp178_ = vala_data_type_copy (_tmp177_);
						_tmp179_ = _tmp178_;
						vala_expression_set_value_type (_tmp174_, _tmp179_);
						_vala_code_node_unref0 (_tmp179_);
						_tmp180_ = vala_member_access_get_inner (self);
						_tmp181_ = _tmp180_;
						_tmp182_ = vala_expression_get_value_type (_tmp181_);
						_tmp183_ = _tmp182_;
						vala_data_type_set_value_owned (_tmp183_, FALSE);
						_tmp184_ = vala_member_access_get_inner (self);
						_tmp185_ = _tmp184_;
						_tmp186_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp185_, (ValaSymbol*) _tmp186_);
						_tmp187_ = vala_member_access_get_inner (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						_tmp191_ = self->priv->_member_name;
						_tmp192_ = vala_data_type_get_member (_tmp190_, _tmp191_);
						_tmp193_ = _tmp192_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						_vala_code_node_unref0 (_tmp193_);
					}
				}
				_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp195_ = _tmp194_;
				if (_tmp195_ == NULL) {
					ValaSymbol* _tmp196_;
					_tmp196_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp196_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp197_ = sym;
				_tmp198_ = vala_symbol_get_parent_symbol (_tmp197_);
				_tmp199_ = _tmp198_;
				sym = _tmp199_;
			}
			_tmp201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp202_ = _tmp201_;
			if (_tmp202_ == NULL) {
				ValaSourceReference* _tmp203_;
				ValaSourceReference* _tmp204_;
				_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp204_ = _tmp203_;
				_tmp200_ = _tmp204_ != NULL;
			} else {
				_tmp200_ = FALSE;
			}
			if (_tmp200_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp205_;
					ValaSourceReference* _tmp206_;
					ValaList* _tmp207_;
					ValaList* _tmp208_;
					ValaList* _tmp209_;
					gint _ns_size = 0;
					ValaList* _tmp210_;
					gint _tmp211_;
					gint _tmp212_;
					gint _ns_index = 0;
					_tmp205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp206_ = _tmp205_;
					_tmp207_ = vala_source_reference_get_using_directives (_tmp206_);
					_tmp208_ = _tmp207_;
					_tmp209_ = _vala_iterable_ref0 (_tmp208_);
					_ns_list = _tmp209_;
					_tmp210_ = _ns_list;
					_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
					_tmp212_ = _tmp211_;
					_ns_size = _tmp212_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp213_;
						gint _tmp214_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp215_;
						gpointer _tmp216_;
						ValaUsingDirective* _tmp217_;
						gboolean _tmp218_;
						gboolean _tmp219_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp220_;
						ValaSymbol* _tmp221_;
						ValaSymbol* _tmp222_;
						ValaScope* _tmp223_;
						ValaScope* _tmp224_;
						const gchar* _tmp225_;
						ValaSymbol* _tmp226_;
						ValaSymbol* _tmp227_;
						_ns_index = _ns_index + 1;
						_tmp213_ = _ns_index;
						_tmp214_ = _ns_size;
						if (!(_tmp213_ < _tmp214_)) {
							break;
						}
						_tmp215_ = _ns_list;
						_tmp216_ = vala_list_get (_tmp215_, _ns_index);
						ns = (ValaUsingDirective*) _tmp216_;
						_tmp217_ = ns;
						_tmp218_ = vala_code_node_get_error ((ValaCodeNode*) _tmp217_);
						_tmp219_ = _tmp218_;
						if (_tmp219_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp220_ = ns;
						_tmp221_ = vala_using_directive_get_namespace_symbol (_tmp220_);
						_tmp222_ = _tmp221_;
						_tmp223_ = vala_symbol_get_scope (_tmp222_);
						_tmp224_ = _tmp223_;
						_tmp225_ = self->priv->_member_name;
						_tmp226_ = vala_scope_lookup (_tmp224_, _tmp225_);
						local_sym = _tmp226_;
						_tmp227_ = local_sym;
						if (_tmp227_ != NULL) {
							gboolean _tmp228_ = FALSE;
							ValaSymbol* _tmp229_;
							ValaSymbol* _tmp230_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp246_;
							ValaSymbol* _tmp247_;
							ValaSymbol* _tmp248_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp268_;
							ValaExpression* _tmp269_;
							ValaExpression* _tmp270_;
							ValaSymbol* _tmp271_;
							_tmp229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp230_ = _tmp229_;
							if (_tmp230_ != NULL) {
								ValaSymbol* _tmp231_;
								ValaSymbol* _tmp232_;
								ValaSymbol* _tmp233_;
								_tmp231_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp232_ = _tmp231_;
								_tmp233_ = local_sym;
								_tmp228_ = _tmp232_ != _tmp233_;
							} else {
								_tmp228_ = FALSE;
							}
							if (_tmp228_) {
								ValaSourceReference* _tmp234_;
								ValaSourceReference* _tmp235_;
								const gchar* _tmp236_;
								ValaSymbol* _tmp237_;
								ValaSymbol* _tmp238_;
								gchar* _tmp239_;
								gchar* _tmp240_;
								ValaSymbol* _tmp241_;
								gchar* _tmp242_;
								gchar* _tmp243_;
								gchar* _tmp244_;
								gchar* _tmp245_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp235_ = _tmp234_;
								_tmp236_ = self->priv->_member_name;
								_tmp237_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp238_ = _tmp237_;
								_tmp239_ = vala_symbol_get_full_name (_tmp238_);
								_tmp240_ = _tmp239_;
								_tmp241_ = local_sym;
								_tmp242_ = vala_symbol_get_full_name (_tmp241_);
								_tmp243_ = _tmp242_;
								_tmp244_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp236_, _tmp240_, _tmp243_);
								_tmp245_ = _tmp244_;
								vala_report_error (_tmp235_, _tmp245_);
								_g_free0 (_tmp245_);
								_g_free0 (_tmp243_);
								_g_free0 (_tmp240_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp246_ = local_sym;
							_tmp247_ = vala_symbol_get_parent_symbol (_tmp246_);
							_tmp248_ = _tmp247_;
							inner_sym = _tmp248_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp249_ = FALSE;
								ValaSymbol* _tmp250_;
								ValaMemberAccess* _tmp254_;
								ValaSymbol* _tmp255_;
								const gchar* _tmp256_;
								const gchar* _tmp257_;
								ValaSourceReference* _tmp258_;
								ValaSourceReference* _tmp259_;
								ValaMemberAccess* _tmp260_;
								ValaMemberAccess* _tmp261_;
								ValaMemberAccess* _tmp262_;
								ValaExpression* _tmp263_;
								ValaExpression* _tmp264_;
								ValaSymbol* _tmp265_;
								ValaSymbol* _tmp266_;
								ValaSymbol* _tmp267_;
								_tmp250_ = inner_sym;
								if (_tmp250_ != NULL) {
									ValaSymbol* _tmp251_;
									const gchar* _tmp252_;
									const gchar* _tmp253_;
									_tmp251_ = inner_sym;
									_tmp252_ = vala_symbol_get_name (_tmp251_);
									_tmp253_ = _tmp252_;
									_tmp249_ = _tmp253_ != NULL;
								} else {
									_tmp249_ = FALSE;
								}
								if (!_tmp249_) {
									break;
								}
								_tmp254_ = inner_ma;
								_tmp255_ = inner_sym;
								_tmp256_ = vala_symbol_get_name (_tmp255_);
								_tmp257_ = _tmp256_;
								_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp259_ = _tmp258_;
								_tmp260_ = vala_member_access_new (NULL, _tmp257_, _tmp259_);
								_tmp261_ = _tmp260_;
								vala_member_access_set_inner (_tmp254_, (ValaExpression*) _tmp261_);
								_vala_code_node_unref0 (_tmp261_);
								_tmp262_ = inner_ma;
								_tmp263_ = vala_member_access_get_inner (_tmp262_);
								_tmp264_ = _tmp263_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp265_ = inner_sym;
								_tmp266_ = vala_symbol_get_parent_symbol (_tmp265_);
								_tmp267_ = _tmp266_;
								inner_sym = _tmp267_;
							}
							_tmp268_ = inner_ma;
							vala_member_access_set_qualified (_tmp268_, TRUE);
							_tmp269_ = vala_member_access_get_inner (self);
							_tmp270_ = _tmp269_;
							vala_code_node_check ((ValaCodeNode*) _tmp270_, context);
							_tmp271_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp271_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp272_;
			ValaExpression* _tmp273_;
			gboolean _tmp274_;
			gboolean _tmp275_;
			ValaExpression* _tmp276_;
			ValaExpression* _tmp277_;
			ValaDataType* _tmp278_;
			ValaDataType* _tmp279_;
			ValaExpression* _tmp297_;
			ValaExpression* _tmp298_;
			gboolean _tmp313_ = FALSE;
			ValaExpression* _tmp314_;
			ValaExpression* _tmp315_;
			gboolean _tmp322_ = FALSE;
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			gboolean _tmp345_ = FALSE;
			ValaExpression* _tmp346_;
			ValaExpression* _tmp347_;
			gboolean _tmp366_ = FALSE;
			ValaSymbol* _tmp367_;
			ValaSymbol* _tmp368_;
			gboolean _tmp402_ = FALSE;
			gboolean _tmp403_ = FALSE;
			ValaSymbol* _tmp404_;
			ValaSymbol* _tmp405_;
			gboolean _tmp637_ = FALSE;
			ValaSymbol* _tmp638_;
			ValaSymbol* _tmp639_;
			_tmp272_ = vala_member_access_get_inner (self);
			_tmp273_ = _tmp272_;
			_tmp274_ = vala_code_node_get_error ((ValaCodeNode*) _tmp273_);
			_tmp275_ = _tmp274_;
			if (_tmp275_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
			_tmp276_ = vala_member_access_get_inner (self);
			_tmp277_ = _tmp276_;
			_tmp278_ = vala_expression_get_value_type (_tmp277_);
			_tmp279_ = _tmp278_;
			if (VALA_IS_POINTER_TYPE (_tmp279_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp280_;
				ValaExpression* _tmp281_;
				ValaDataType* _tmp282_;
				ValaDataType* _tmp283_;
				gboolean _tmp284_ = FALSE;
				ValaPointerType* _tmp285_;
				_tmp280_ = vala_member_access_get_inner (self);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_expression_get_value_type (_tmp281_);
				_tmp283_ = _tmp282_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp283_) ? ((ValaPointerType*) _tmp283_) : NULL;
				_tmp285_ = pointer_type;
				if (_tmp285_ != NULL) {
					ValaPointerType* _tmp286_;
					ValaDataType* _tmp287_;
					ValaDataType* _tmp288_;
					_tmp286_ = pointer_type;
					_tmp287_ = vala_pointer_type_get_base_type (_tmp286_);
					_tmp288_ = _tmp287_;
					_tmp284_ = VALA_IS_VALUE_TYPE (_tmp288_);
				} else {
					_tmp284_ = FALSE;
				}
				if (_tmp284_) {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaSourceReference* _tmp291_;
					ValaSourceReference* _tmp292_;
					ValaPointerIndirection* _tmp293_;
					ValaPointerIndirection* _tmp294_;
					ValaExpression* _tmp295_;
					ValaExpression* _tmp296_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_pointer_indirection_new (_tmp290_, _tmp292_);
					_tmp294_ = _tmp293_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp294_);
					_vala_code_node_unref0 (_tmp294_);
					_tmp295_ = vala_member_access_get_inner (self);
					_tmp296_ = _tmp295_;
					vala_code_node_check ((ValaCodeNode*) _tmp296_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp297_ = vala_member_access_get_inner (self);
			_tmp298_ = _tmp297_;
			if (VALA_IS_MEMBER_ACCESS (_tmp298_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp299_;
				ValaExpression* _tmp300_;
				ValaMemberAccess* _tmp301_;
				gboolean _tmp302_;
				_tmp299_ = vala_member_access_get_inner (self);
				_tmp300_ = _tmp299_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp300_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp301_ = ma;
				_tmp302_ = _tmp301_->priv->_prototype_access;
				if (_tmp302_) {
					ValaSourceReference* _tmp303_;
					ValaSourceReference* _tmp304_;
					ValaExpression* _tmp305_;
					ValaExpression* _tmp306_;
					ValaSymbol* _tmp307_;
					ValaSymbol* _tmp308_;
					gchar* _tmp309_;
					gchar* _tmp310_;
					gchar* _tmp311_;
					gchar* _tmp312_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp303_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp304_ = _tmp303_;
					_tmp305_ = vala_member_access_get_inner (self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_expression_get_symbol_reference (_tmp306_);
					_tmp308_ = _tmp307_;
					_tmp309_ = vala_symbol_get_full_name (_tmp308_);
					_tmp310_ = _tmp309_;
					_tmp311_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp310_);
					_tmp312_ = _tmp311_;
					vala_report_error (_tmp304_, _tmp312_);
					_g_free0 (_tmp312_);
					_g_free0 (_tmp310_);
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
			}
			_tmp314_ = vala_member_access_get_inner (self);
			_tmp315_ = _tmp314_;
			if (VALA_IS_CAST_EXPRESSION (_tmp315_)) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				gboolean _tmp318_;
				gboolean _tmp319_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp317_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp319_ = _tmp318_;
				_tmp313_ = _tmp319_;
			} else {
				_tmp313_ = FALSE;
			}
			if (_tmp313_) {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_warning (_tmp321_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp323_ = vala_member_access_get_inner (self);
			_tmp324_ = _tmp323_;
			if (VALA_IS_MEMBER_ACCESS (_tmp324_)) {
				_tmp322_ = TRUE;
			} else {
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp322_ = VALA_IS_BASE_ACCESS (_tmp326_);
			}
			if (_tmp322_) {
				ValaExpression* _tmp327_;
				ValaExpression* _tmp328_;
				ValaSymbol* _tmp329_;
				ValaSymbol* _tmp330_;
				gboolean _tmp331_ = FALSE;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp327_ = vala_member_access_get_inner (self);
				_tmp328_ = _tmp327_;
				_tmp329_ = vala_expression_get_symbol_reference (_tmp328_);
				_tmp330_ = _tmp329_;
				base_symbol = _tmp330_;
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ == NULL) {
					gboolean _tmp334_ = FALSE;
					ValaSymbol* _tmp335_;
					_tmp335_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp335_)) {
						_tmp334_ = TRUE;
					} else {
						ValaSymbol* _tmp336_;
						_tmp336_ = base_symbol;
						_tmp334_ = VALA_IS_TYPESYMBOL (_tmp336_);
					}
					_tmp331_ = _tmp334_;
				} else {
					_tmp331_ = FALSE;
				}
				if (_tmp331_) {
					ValaSymbol* _tmp337_;
					ValaScope* _tmp338_;
					ValaScope* _tmp339_;
					const gchar* _tmp340_;
					ValaSymbol* _tmp341_;
					ValaSymbol* _tmp342_;
					ValaExpression* _tmp343_;
					ValaExpression* _tmp344_;
					_tmp337_ = base_symbol;
					_tmp338_ = vala_symbol_get_scope (_tmp337_);
					_tmp339_ = _tmp338_;
					_tmp340_ = self->priv->_member_name;
					_tmp341_ = vala_scope_lookup (_tmp339_, _tmp340_);
					_tmp342_ = _tmp341_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp342_);
					_vala_code_node_unref0 (_tmp342_);
					_tmp343_ = vala_member_access_get_inner (self);
					_tmp344_ = _tmp343_;
					if (VALA_IS_BASE_ACCESS (_tmp344_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp346_ = vala_member_access_get_inner (self);
			_tmp347_ = _tmp346_;
			if (VALA_IS_MEMBER_ACCESS (_tmp347_)) {
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaSymbol* _tmp350_;
				ValaSymbol* _tmp351_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_symbol_reference (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp345_ = VALA_IS_TYPEPARAMETER (_tmp351_);
			} else {
				_tmp345_ = FALSE;
			}
			if (_tmp345_) {
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaExpression* _tmp354_;
				ValaExpression* _tmp355_;
				ValaSymbol* _tmp356_;
				ValaSymbol* _tmp357_;
				ValaGenericType* _tmp358_;
				ValaGenericType* _tmp359_;
				ValaExpression* _tmp360_;
				ValaExpression* _tmp361_;
				ValaDataType* _tmp362_;
				ValaDataType* _tmp363_;
				ValaSourceReference* _tmp364_;
				ValaSourceReference* _tmp365_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_member_access_get_inner (self);
				_tmp355_ = _tmp354_;
				_tmp356_ = vala_expression_get_symbol_reference (_tmp355_);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp359_ = _tmp358_;
				vala_expression_set_value_type (_tmp353_, (ValaDataType*) _tmp359_);
				_vala_code_node_unref0 (_tmp359_);
				_tmp360_ = vala_member_access_get_inner (self);
				_tmp361_ = _tmp360_;
				_tmp362_ = vala_expression_get_value_type (_tmp361_);
				_tmp363_ = _tmp362_;
				_tmp364_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp365_ = _tmp364_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp363_, _tmp365_);
			}
			_tmp367_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp368_ = _tmp367_;
			if (_tmp368_ == NULL) {
				ValaExpression* _tmp369_;
				ValaExpression* _tmp370_;
				ValaDataType* _tmp371_;
				ValaDataType* _tmp372_;
				_tmp369_ = vala_member_access_get_inner (self);
				_tmp370_ = _tmp369_;
				_tmp371_ = vala_expression_get_value_type (_tmp370_);
				_tmp372_ = _tmp371_;
				_tmp366_ = _tmp372_ != NULL;
			} else {
				_tmp366_ = FALSE;
			}
			if (_tmp366_) {
				gboolean _tmp373_;
				ValaSymbol* _tmp400_;
				ValaSymbol* _tmp401_;
				_tmp373_ = self->priv->_pointer_member_access;
				if (_tmp373_) {
					ValaExpression* _tmp374_;
					ValaExpression* _tmp375_;
					ValaDataType* _tmp376_;
					ValaDataType* _tmp377_;
					const gchar* _tmp378_;
					ValaSymbol* _tmp379_;
					ValaSymbol* _tmp380_;
					_tmp374_ = vala_member_access_get_inner (self);
					_tmp375_ = _tmp374_;
					_tmp376_ = vala_expression_get_value_type (_tmp375_);
					_tmp377_ = _tmp376_;
					_tmp378_ = self->priv->_member_name;
					_tmp379_ = vala_data_type_get_pointer_member (_tmp377_, _tmp378_);
					_tmp380_ = _tmp379_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp380_);
					_vala_code_node_unref0 (_tmp380_);
				} else {
					ValaExpression* _tmp381_;
					ValaExpression* _tmp382_;
					ValaDataType* _tmp383_;
					ValaDataType* _tmp384_;
					ValaTypeSymbol* _tmp385_;
					ValaTypeSymbol* _tmp386_;
					ValaExpression* _tmp393_;
					ValaExpression* _tmp394_;
					ValaDataType* _tmp395_;
					ValaDataType* _tmp396_;
					const gchar* _tmp397_;
					ValaSymbol* _tmp398_;
					ValaSymbol* _tmp399_;
					_tmp381_ = vala_member_access_get_inner (self);
					_tmp382_ = _tmp381_;
					_tmp383_ = vala_expression_get_value_type (_tmp382_);
					_tmp384_ = _tmp383_;
					_tmp385_ = vala_data_type_get_type_symbol (_tmp384_);
					_tmp386_ = _tmp385_;
					if (_tmp386_ != NULL) {
						ValaExpression* _tmp387_;
						ValaExpression* _tmp388_;
						ValaDataType* _tmp389_;
						ValaDataType* _tmp390_;
						ValaTypeSymbol* _tmp391_;
						ValaTypeSymbol* _tmp392_;
						_tmp387_ = vala_member_access_get_inner (self);
						_tmp388_ = _tmp387_;
						_tmp389_ = vala_expression_get_value_type (_tmp388_);
						_tmp390_ = _tmp389_;
						_tmp391_ = vala_data_type_get_type_symbol (_tmp390_);
						_tmp392_ = _tmp391_;
						base_symbol = (ValaSymbol*) _tmp392_;
					}
					_tmp393_ = vala_member_access_get_inner (self);
					_tmp394_ = _tmp393_;
					_tmp395_ = vala_expression_get_value_type (_tmp394_);
					_tmp396_ = _tmp395_;
					_tmp397_ = self->priv->_member_name;
					_tmp398_ = vala_data_type_get_member (_tmp396_, _tmp397_);
					_tmp399_ = _tmp398_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp399_);
					_vala_code_node_unref0 (_tmp399_);
				}
				_tmp400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp401_ = _tmp400_;
				if (_tmp401_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp404_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp405_ = _tmp404_;
			if (_tmp405_ == NULL) {
				ValaExpression* _tmp406_;
				ValaExpression* _tmp407_;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				_tmp406_ = vala_member_access_get_inner (self);
				_tmp407_ = _tmp406_;
				_tmp408_ = vala_expression_get_value_type (_tmp407_);
				_tmp409_ = _tmp408_;
				_tmp403_ = _tmp409_ != NULL;
			} else {
				_tmp403_ = FALSE;
			}
			if (_tmp403_) {
				ValaExpression* _tmp410_;
				ValaExpression* _tmp411_;
				ValaDataType* _tmp412_;
				ValaDataType* _tmp413_;
				gboolean _tmp414_;
				gboolean _tmp415_;
				_tmp410_ = vala_member_access_get_inner (self);
				_tmp411_ = _tmp410_;
				_tmp412_ = vala_expression_get_value_type (_tmp411_);
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_data_type_get_is_dynamic (_tmp413_);
				_tmp415_ = _tmp414_;
				_tmp402_ = _tmp415_;
			} else {
				_tmp402_ = FALSE;
			}
			if (_tmp402_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp416_;
				ValaExpression* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaObjectType* _tmp420_;
				ValaCodeNode* _tmp421_;
				ValaCodeNode* _tmp422_;
				ValaSymbol* _tmp585_;
				ValaSymbol* _tmp586_;
				ValaSymbol* _tmp635_;
				ValaSymbol* _tmp636_;
				_tmp416_ = vala_member_access_get_inner (self);
				_tmp417_ = _tmp416_;
				_tmp418_ = vala_expression_get_value_type (_tmp417_);
				_tmp419_ = _tmp418_;
				_tmp420_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp420_;
				_tmp421_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp422_ = _tmp421_;
				if (VALA_IS_METHOD_CALL (_tmp422_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp423_;
					ValaCodeNode* _tmp424_;
					ValaMethodCall* _tmp425_;
					ValaExpression* _tmp426_;
					ValaExpression* _tmp427_;
					_tmp423_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp424_ = _tmp423_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp424_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp425_ = invoc;
					_tmp426_ = vala_method_call_get_call (_tmp425_);
					_tmp427_ = _tmp426_;
					if (_tmp427_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp428_;
						ValaDataType* _tmp429_;
						ValaDataType* _tmp430_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp445_;
						ValaExpression* _tmp446_;
						ValaDataType* _tmp447_;
						ValaDataType* _tmp448_;
						const gchar* _tmp449_;
						ValaDataType* _tmp450_;
						ValaSourceReference* _tmp451_;
						ValaSourceReference* _tmp452_;
						ValaDynamicMethod* _tmp453_;
						ValaDynamicMethod* _tmp454_;
						ValaMethodCall* _tmp455_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp456_;
						ValaErrorType* _tmp457_;
						ValaDynamicMethod* _tmp458_;
						ValaErrorType* _tmp459_;
						ValaDynamicMethod* _tmp460_;
						ValaDynamicMethod* _tmp461_;
						ValaParameter* _tmp462_;
						ValaParameter* _tmp463_;
						ValaDynamicMethod* _tmp464_;
						ValaObjectType* _tmp465_;
						ValaDataType* _tmp466_;
						ValaDataType* _tmp467_;
						ValaParameter* _tmp468_;
						ValaParameter* _tmp469_;
						ValaObjectType* _tmp470_;
						ValaTypeSymbol* _tmp471_;
						ValaTypeSymbol* _tmp472_;
						ValaScope* _tmp473_;
						ValaScope* _tmp474_;
						ValaDynamicMethod* _tmp475_;
						ValaDynamicMethod* _tmp476_;
						_tmp428_ = invoc;
						_tmp429_ = vala_expression_get_target_type ((ValaExpression*) _tmp428_);
						_tmp430_ = _tmp429_;
						if (_tmp430_ != NULL) {
							ValaMethodCall* _tmp431_;
							ValaDataType* _tmp432_;
							ValaDataType* _tmp433_;
							ValaDataType* _tmp434_;
							ValaDataType* _tmp435_;
							_tmp431_ = invoc;
							_tmp432_ = vala_expression_get_target_type ((ValaExpression*) _tmp431_);
							_tmp433_ = _tmp432_;
							_tmp434_ = vala_data_type_copy (_tmp433_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp434_;
							_tmp435_ = ret_type;
							vala_data_type_set_value_owned (_tmp435_, TRUE);
						} else {
							ValaMethodCall* _tmp436_;
							ValaCodeNode* _tmp437_;
							ValaCodeNode* _tmp438_;
							_tmp436_ = invoc;
							_tmp437_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp436_);
							_tmp438_ = _tmp437_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp438_)) {
								ValaVoidType* _tmp439_;
								_tmp439_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp439_;
							} else {
								ValaExpression* _tmp440_;
								ValaExpression* _tmp441_;
								ValaDataType* _tmp442_;
								ValaDataType* _tmp443_;
								ValaDataType* _tmp444_;
								_tmp440_ = vala_member_access_get_inner (self);
								_tmp441_ = _tmp440_;
								_tmp442_ = vala_expression_get_value_type (_tmp441_);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_data_type_copy (_tmp443_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp444_;
							}
						}
						_tmp445_ = vala_member_access_get_inner (self);
						_tmp446_ = _tmp445_;
						_tmp447_ = vala_expression_get_value_type (_tmp446_);
						_tmp448_ = _tmp447_;
						_tmp449_ = self->priv->_member_name;
						_tmp450_ = ret_type;
						_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp452_ = _tmp451_;
						_tmp453_ = vala_dynamic_method_new (_tmp448_, _tmp449_, _tmp450_, _tmp452_, NULL);
						m = _tmp453_;
						_tmp454_ = m;
						_tmp455_ = invoc;
						vala_dynamic_method_set_invocation (_tmp454_, _tmp455_);
						_tmp456_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp456_;
						_tmp457_ = err;
						vala_error_type_set_dynamic_error (_tmp457_, TRUE);
						_tmp458_ = m;
						_tmp459_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp458_, (ValaDataType*) _tmp459_);
						_tmp460_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp460_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp461_ = m;
						_tmp462_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp463_ = _tmp462_;
						vala_callable_add_parameter ((ValaCallable*) _tmp461_, _tmp463_);
						_vala_code_node_unref0 (_tmp463_);
						_tmp464_ = m;
						_tmp465_ = dynamic_object_type;
						_tmp466_ = vala_data_type_copy ((ValaDataType*) _tmp465_);
						_tmp467_ = _tmp466_;
						_tmp468_ = vala_parameter_new ("this", _tmp467_, NULL);
						_tmp469_ = _tmp468_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp464_, _tmp469_);
						_vala_code_node_unref0 (_tmp469_);
						_vala_code_node_unref0 (_tmp467_);
						_tmp470_ = dynamic_object_type;
						_tmp471_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp470_);
						_tmp472_ = _tmp471_;
						_tmp473_ = vala_symbol_get_scope ((ValaSymbol*) _tmp472_);
						_tmp474_ = _tmp473_;
						_tmp475_ = m;
						vala_scope_add (_tmp474_, NULL, (ValaSymbol*) _tmp475_);
						_tmp476_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp476_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp477_;
					ValaCodeNode* _tmp478_;
					_tmp477_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp478_ = _tmp477_;
					if (VALA_IS_ASSIGNMENT (_tmp478_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp479_;
						ValaCodeNode* _tmp480_;
						ValaAssignment* _tmp481_;
						ValaExpression* _tmp482_;
						ValaExpression* _tmp483_;
						_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp480_ = _tmp479_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp480_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp481_ = a;
						_tmp482_ = vala_assignment_get_left (_tmp481_);
						_tmp483_ = _tmp482_;
						if (_tmp483_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp484_;
							ValaExpression* _tmp485_;
							ValaDataType* _tmp486_;
							ValaDataType* _tmp487_;
							const gchar* _tmp488_;
							ValaSourceReference* _tmp489_;
							ValaSourceReference* _tmp490_;
							ValaDynamicProperty* _tmp491_;
							ValaDynamicProperty* _tmp492_;
							ValaDynamicProperty* _tmp493_;
							ValaDynamicProperty* _tmp494_;
							ValaSourceReference* _tmp495_;
							ValaSourceReference* _tmp496_;
							ValaPropertyAccessor* _tmp497_;
							ValaPropertyAccessor* _tmp498_;
							ValaDynamicProperty* _tmp499_;
							ValaExpression* _tmp500_;
							ValaExpression* _tmp501_;
							ValaDataType* _tmp502_;
							ValaDataType* _tmp503_;
							ValaTypeSymbol* _tmp504_;
							ValaTypeSymbol* _tmp505_;
							ValaScope* _tmp506_;
							ValaScope* _tmp507_;
							ValaObjectType* _tmp508_;
							ValaTypeSymbol* _tmp509_;
							ValaTypeSymbol* _tmp510_;
							ValaScope* _tmp511_;
							ValaScope* _tmp512_;
							ValaDynamicProperty* _tmp513_;
							ValaDynamicProperty* _tmp514_;
							_tmp484_ = vala_member_access_get_inner (self);
							_tmp485_ = _tmp484_;
							_tmp486_ = vala_expression_get_value_type (_tmp485_);
							_tmp487_ = _tmp486_;
							_tmp488_ = self->priv->_member_name;
							_tmp489_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp490_ = _tmp489_;
							_tmp491_ = vala_dynamic_property_new (_tmp487_, _tmp488_, _tmp490_, NULL);
							prop = _tmp491_;
							_tmp492_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp492_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp493_ = prop;
							_tmp494_ = prop;
							_tmp495_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp494_);
							_tmp496_ = _tmp495_;
							_tmp497_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp496_, NULL);
							_tmp498_ = _tmp497_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp493_, _tmp498_);
							_vala_code_node_unref0 (_tmp498_);
							_tmp499_ = prop;
							_tmp500_ = vala_member_access_get_inner (self);
							_tmp501_ = _tmp500_;
							_tmp502_ = vala_expression_get_value_type (_tmp501_);
							_tmp503_ = _tmp502_;
							_tmp504_ = vala_data_type_get_type_symbol (_tmp503_);
							_tmp505_ = _tmp504_;
							_tmp506_ = vala_symbol_get_scope ((ValaSymbol*) _tmp505_);
							_tmp507_ = _tmp506_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp499_, _tmp507_);
							_tmp508_ = dynamic_object_type;
							_tmp509_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp508_);
							_tmp510_ = _tmp509_;
							_tmp511_ = vala_symbol_get_scope ((ValaSymbol*) _tmp510_);
							_tmp512_ = _tmp511_;
							_tmp513_ = prop;
							vala_scope_add (_tmp512_, NULL, (ValaSymbol*) _tmp513_);
							_tmp514_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp514_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp515_ = FALSE;
						gboolean _tmp516_ = FALSE;
						ValaCodeNode* _tmp517_;
						ValaCodeNode* _tmp518_;
						_tmp517_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp518_ = _tmp517_;
						if (VALA_IS_MEMBER_ACCESS (_tmp518_)) {
							ValaExpression* _tmp519_;
							ValaExpression* _tmp520_;
							_tmp519_ = vala_member_access_get_inner (self);
							_tmp520_ = _tmp519_;
							_tmp516_ = VALA_IS_MEMBER_ACCESS (_tmp520_);
						} else {
							_tmp516_ = FALSE;
						}
						if (_tmp516_) {
							ValaCodeNode* _tmp521_;
							ValaCodeNode* _tmp522_;
							ValaCodeNode* _tmp523_;
							ValaCodeNode* _tmp524_;
							_tmp521_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp522_ = _tmp521_;
							_tmp523_ = vala_code_node_get_parent_node (_tmp522_);
							_tmp524_ = _tmp523_;
							_tmp515_ = VALA_IS_METHOD_CALL (_tmp524_);
						} else {
							_tmp515_ = FALSE;
						}
						if (_tmp515_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp525_;
							ValaCodeNode* _tmp526_;
							gboolean _tmp527_ = FALSE;
							ValaMemberAccess* _tmp528_;
							const gchar* _tmp529_;
							_tmp525_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp526_ = _tmp525_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp526_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp528_ = ma;
							_tmp529_ = _tmp528_->priv->_member_name;
							if (g_strcmp0 (_tmp529_, "connect") == 0) {
								_tmp527_ = TRUE;
							} else {
								ValaMemberAccess* _tmp530_;
								const gchar* _tmp531_;
								_tmp530_ = ma;
								_tmp531_ = _tmp530_->priv->_member_name;
								_tmp527_ = g_strcmp0 (_tmp531_, "connect_after") == 0;
							}
							if (_tmp527_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp532_;
								ValaExpression* _tmp533_;
								ValaDataType* _tmp534_;
								ValaDataType* _tmp535_;
								const gchar* _tmp536_;
								ValaVoidType* _tmp537_;
								ValaVoidType* _tmp538_;
								ValaSourceReference* _tmp539_;
								ValaSourceReference* _tmp540_;
								ValaDynamicSignal* _tmp541_;
								ValaDynamicSignal* _tmp542_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp543_;
								ValaCodeNode* _tmp544_;
								ValaCodeNode* _tmp545_;
								ValaCodeNode* _tmp546_;
								ValaMethodCall* _tmp547_;
								ValaMethodCall* _tmp548_;
								ValaList* _tmp549_;
								gint _tmp550_;
								gint _tmp551_;
								ValaDynamicSignal* _tmp577_;
								ValaObjectType* _tmp578_;
								ValaTypeSymbol* _tmp579_;
								ValaTypeSymbol* _tmp580_;
								ValaScope* _tmp581_;
								ValaScope* _tmp582_;
								ValaDynamicSignal* _tmp583_;
								ValaDynamicSignal* _tmp584_;
								_tmp532_ = vala_member_access_get_inner (self);
								_tmp533_ = _tmp532_;
								_tmp534_ = vala_expression_get_value_type (_tmp533_);
								_tmp535_ = _tmp534_;
								_tmp536_ = self->priv->_member_name;
								_tmp537_ = vala_void_type_new (NULL);
								_tmp538_ = _tmp537_;
								_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp540_ = _tmp539_;
								_tmp541_ = vala_dynamic_signal_new (_tmp535_, _tmp536_, (ValaDataType*) _tmp538_, _tmp540_, NULL);
								_tmp542_ = _tmp541_;
								_vala_code_node_unref0 (_tmp538_);
								s = _tmp542_;
								_tmp543_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp544_ = _tmp543_;
								_tmp545_ = vala_code_node_get_parent_node (_tmp544_);
								_tmp546_ = _tmp545_;
								_tmp547_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp546_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp547_;
								_tmp548_ = mcall;
								_tmp549_ = vala_method_call_get_argument_list (_tmp548_);
								_tmp550_ = vala_collection_get_size ((ValaCollection*) _tmp549_);
								_tmp551_ = _tmp550_;
								if (_tmp551_ > 0) {
									ValaDynamicSignal* _tmp552_;
									ValaMethodCall* _tmp553_;
									ValaList* _tmp554_;
									gpointer _tmp555_;
									ValaExpression* _tmp556_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp557_;
									ValaExpression* _tmp558_;
									ValaExpression* _tmp559_;
									gboolean _tmp560_ = FALSE;
									gboolean _tmp561_ = FALSE;
									ValaMemberAccess* _tmp562_;
									_tmp552_ = s;
									_tmp553_ = mcall;
									_tmp554_ = vala_method_call_get_argument_list (_tmp553_);
									_tmp555_ = vala_list_get (_tmp554_, 0);
									_tmp556_ = (ValaExpression*) _tmp555_;
									vala_dynamic_signal_set_handler (_tmp552_, _tmp556_);
									_vala_code_node_unref0 (_tmp556_);
									_tmp557_ = s;
									_tmp558_ = vala_dynamic_signal_get_handler (_tmp557_);
									_tmp559_ = _tmp558_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp559_) ? ((ValaMemberAccess*) _tmp559_) : NULL;
									_tmp562_ = arg;
									if (_tmp562_ == NULL) {
										_tmp561_ = TRUE;
									} else {
										ValaMemberAccess* _tmp563_;
										_tmp563_ = arg;
										_tmp561_ = !vala_code_node_check ((ValaCodeNode*) _tmp563_, context);
									}
									if (_tmp561_) {
										_tmp560_ = TRUE;
									} else {
										ValaMemberAccess* _tmp564_;
										ValaSymbol* _tmp565_;
										ValaSymbol* _tmp566_;
										_tmp564_ = arg;
										_tmp565_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp564_);
										_tmp566_ = _tmp565_;
										_tmp560_ = !VALA_IS_METHOD (_tmp566_);
									}
									if (_tmp560_) {
										ValaDynamicSignal* _tmp567_;
										ValaExpression* _tmp568_;
										ValaExpression* _tmp569_;
										ValaSourceReference* _tmp570_;
										ValaSourceReference* _tmp571_;
										ValaDynamicSignal* _tmp572_;
										gchar* _tmp573_;
										gchar* _tmp574_;
										gchar* _tmp575_;
										gchar* _tmp576_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp567_ = s;
										_tmp568_ = vala_dynamic_signal_get_handler (_tmp567_);
										_tmp569_ = _tmp568_;
										_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp569_);
										_tmp571_ = _tmp570_;
										_tmp572_ = s;
										_tmp573_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp572_);
										_tmp574_ = _tmp573_;
										_tmp575_ = g_strdup_printf ("Invalid handler for `%s'", _tmp574_);
										_tmp576_ = _tmp575_;
										vala_report_error (_tmp571_, _tmp576_);
										_g_free0 (_tmp576_);
										_g_free0 (_tmp574_);
									}
								}
								_tmp577_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp577_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp578_ = dynamic_object_type;
								_tmp579_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp578_);
								_tmp580_ = _tmp579_;
								_tmp581_ = vala_symbol_get_scope ((ValaSymbol*) _tmp580_);
								_tmp582_ = _tmp581_;
								_tmp583_ = s;
								vala_scope_add (_tmp582_, NULL, (ValaSymbol*) _tmp583_);
								_tmp584_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp584_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp585_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp586_ = _tmp585_;
				if (_tmp586_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp587_;
					ValaExpression* _tmp588_;
					ValaDataType* _tmp589_;
					ValaDataType* _tmp590_;
					const gchar* _tmp591_;
					ValaSourceReference* _tmp592_;
					ValaSourceReference* _tmp593_;
					ValaDynamicProperty* _tmp594_;
					ValaDataType* _tmp595_;
					ValaDataType* _tmp596_;
					ValaDynamicProperty* _tmp607_;
					ValaDynamicProperty* _tmp608_;
					ValaDynamicProperty* _tmp609_;
					ValaDataType* _tmp610_;
					ValaDataType* _tmp611_;
					ValaDataType* _tmp612_;
					ValaDataType* _tmp613_;
					ValaDynamicProperty* _tmp614_;
					ValaSourceReference* _tmp615_;
					ValaSourceReference* _tmp616_;
					ValaPropertyAccessor* _tmp617_;
					ValaPropertyAccessor* _tmp618_;
					ValaDynamicProperty* _tmp619_;
					ValaExpression* _tmp620_;
					ValaExpression* _tmp621_;
					ValaDataType* _tmp622_;
					ValaDataType* _tmp623_;
					ValaTypeSymbol* _tmp624_;
					ValaTypeSymbol* _tmp625_;
					ValaScope* _tmp626_;
					ValaScope* _tmp627_;
					ValaObjectType* _tmp628_;
					ValaTypeSymbol* _tmp629_;
					ValaTypeSymbol* _tmp630_;
					ValaScope* _tmp631_;
					ValaScope* _tmp632_;
					ValaDynamicProperty* _tmp633_;
					ValaDynamicProperty* _tmp634_;
					_tmp587_ = vala_member_access_get_inner (self);
					_tmp588_ = _tmp587_;
					_tmp589_ = vala_expression_get_value_type (_tmp588_);
					_tmp590_ = _tmp589_;
					_tmp591_ = self->priv->_member_name;
					_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_dynamic_property_new (_tmp590_, _tmp591_, _tmp593_, NULL);
					prop = _tmp594_;
					_tmp595_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp596_ = _tmp595_;
					if (_tmp596_ != NULL) {
						ValaDynamicProperty* _tmp597_;
						ValaDataType* _tmp598_;
						ValaDataType* _tmp599_;
						_tmp597_ = prop;
						_tmp598_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp599_ = _tmp598_;
						vala_property_set_property_type ((ValaProperty*) _tmp597_, _tmp599_);
					} else {
						ValaDynamicProperty* _tmp600_;
						ValaExpression* _tmp601_;
						ValaExpression* _tmp602_;
						ValaDataType* _tmp603_;
						ValaDataType* _tmp604_;
						ValaDataType* _tmp605_;
						ValaDataType* _tmp606_;
						_tmp600_ = prop;
						_tmp601_ = vala_member_access_get_inner (self);
						_tmp602_ = _tmp601_;
						_tmp603_ = vala_expression_get_value_type (_tmp602_);
						_tmp604_ = _tmp603_;
						_tmp605_ = vala_data_type_copy (_tmp604_);
						_tmp606_ = _tmp605_;
						vala_property_set_property_type ((ValaProperty*) _tmp600_, _tmp606_);
						_vala_code_node_unref0 (_tmp606_);
					}
					_tmp607_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp607_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp608_ = prop;
					_tmp609_ = prop;
					_tmp610_ = vala_property_get_property_type ((ValaProperty*) _tmp609_);
					_tmp611_ = _tmp610_;
					_tmp612_ = vala_data_type_copy (_tmp611_);
					_tmp613_ = _tmp612_;
					_tmp614_ = prop;
					_tmp615_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp614_);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp613_, NULL, _tmp616_, NULL);
					_tmp618_ = _tmp617_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp608_, _tmp618_);
					_vala_code_node_unref0 (_tmp618_);
					_vala_code_node_unref0 (_tmp613_);
					_tmp619_ = prop;
					_tmp620_ = vala_member_access_get_inner (self);
					_tmp621_ = _tmp620_;
					_tmp622_ = vala_expression_get_value_type (_tmp621_);
					_tmp623_ = _tmp622_;
					_tmp624_ = vala_data_type_get_type_symbol (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_symbol_get_scope ((ValaSymbol*) _tmp625_);
					_tmp627_ = _tmp626_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp619_, _tmp627_);
					_tmp628_ = dynamic_object_type;
					_tmp629_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_symbol_get_scope ((ValaSymbol*) _tmp630_);
					_tmp632_ = _tmp631_;
					_tmp633_ = prop;
					vala_scope_add (_tmp632_, NULL, (ValaSymbol*) _tmp633_);
					_tmp634_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp634_);
					_vala_code_node_unref0 (prop);
				}
				_tmp635_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp636_ = _tmp635_;
				if (_tmp636_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp638_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp639_ = _tmp638_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp639_)) {
				ValaExpression* _tmp640_;
				ValaExpression* _tmp641_;
				ValaSymbol* _tmp642_;
				ValaSymbol* _tmp643_;
				_tmp640_ = vala_member_access_get_inner (self);
				_tmp641_ = _tmp640_;
				_tmp642_ = vala_expression_get_symbol_reference (_tmp641_);
				_tmp643_ = _tmp642_;
				_tmp637_ = VALA_IS_VARIABLE (_tmp643_);
			} else {
				_tmp637_ = FALSE;
			}
			if (_tmp637_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp644_;
				ValaSemanticAnalyzer* _tmp645_;
				ValaExpression* _tmp646_;
				ValaExpression* _tmp647_;
				ValaSymbol* _tmp648_;
				ValaSymbol* _tmp649_;
				ValaDataType* _tmp650_;
				ValaArrayType* _tmp651_;
				gboolean _tmp652_ = FALSE;
				ValaArrayType* _tmp653_;
				_tmp644_ = vala_code_context_get_analyzer (context);
				_tmp645_ = _tmp644_;
				_tmp646_ = vala_member_access_get_inner (self);
				_tmp647_ = _tmp646_;
				_tmp648_ = vala_expression_get_symbol_reference (_tmp647_);
				_tmp649_ = _tmp648_;
				_tmp650_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp645_, _tmp649_, TRUE);
				_tmp651_ = VALA_IS_ARRAY_TYPE (_tmp650_) ? ((ValaArrayType*) _tmp650_) : NULL;
				if (_tmp651_ == NULL) {
					_vala_code_node_unref0 (_tmp650_);
				}
				inner_type = _tmp651_;
				_tmp653_ = inner_type;
				if (_tmp653_ != NULL) {
					ValaArrayType* _tmp654_;
					gboolean _tmp655_;
					gboolean _tmp656_;
					_tmp654_ = inner_type;
					_tmp655_ = vala_array_type_get_inline_allocated (_tmp654_);
					_tmp656_ = _tmp655_;
					_tmp652_ = _tmp656_;
				} else {
					_tmp652_ = FALSE;
				}
				if (_tmp652_) {
					ValaSourceReference* _tmp657_;
					ValaSourceReference* _tmp658_;
					_tmp657_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp658_ = _tmp657_;
					vala_report_error (_tmp658_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp659_ = FALSE;
					ValaArrayType* _tmp660_;
					_tmp660_ = inner_type;
					if (_tmp660_ != NULL) {
						ValaArrayType* _tmp661_;
						gboolean _tmp662_;
						gboolean _tmp663_;
						_tmp661_ = inner_type;
						_tmp662_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp661_);
						_tmp663_ = _tmp662_;
						_tmp659_ = !_tmp663_;
					} else {
						_tmp659_ = FALSE;
					}
					if (_tmp659_) {
						ValaSourceReference* _tmp664_;
						ValaSourceReference* _tmp665_;
						_tmp664_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp665_ = _tmp664_;
						vala_report_error (_tmp665_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp669_ = vala_member_access_get_inner (self);
	_tmp670_ = _tmp669_;
	if (_tmp670_ == NULL) {
		ValaSymbol* _tmp671_;
		ValaSymbol* _tmp672_;
		_tmp671_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp672_ = _tmp671_;
		_tmp668_ = _tmp672_ == NULL;
	} else {
		_tmp668_ = FALSE;
	}
	if (_tmp668_) {
		ValaDataType* _tmp673_;
		ValaDataType* _tmp674_;
		_tmp673_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp674_ = _tmp673_;
		_tmp667_ = _tmp674_ != NULL;
	} else {
		_tmp667_ = FALSE;
	}
	if (_tmp667_) {
		ValaDataType* _tmp675_;
		ValaDataType* _tmp676_;
		ValaTypeSymbol* _tmp677_;
		ValaTypeSymbol* _tmp678_;
		_tmp675_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp676_ = _tmp675_;
		_tmp677_ = vala_data_type_get_type_symbol (_tmp676_);
		_tmp678_ = _tmp677_;
		_tmp666_ = VALA_IS_ENUM (_tmp678_);
	} else {
		_tmp666_ = FALSE;
	}
	if (_tmp666_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp679_;
		ValaDataType* _tmp680_;
		ValaTypeSymbol* _tmp681_;
		ValaTypeSymbol* _tmp682_;
		_tmp679_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp680_ = _tmp679_;
		_tmp681_ = vala_data_type_get_type_symbol (_tmp680_);
		_tmp682_ = _tmp681_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp682_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp683_;
			ValaList* _tmp684_;
			ValaList* _tmp685_;
			gint _val_size = 0;
			ValaList* _tmp686_;
			gint _tmp687_;
			gint _tmp688_;
			gint _val_index = 0;
			_tmp683_ = enum_type;
			_tmp684_ = vala_enum_get_values (_tmp683_);
			_tmp685_ = _vala_iterable_ref0 (_tmp684_);
			_val_list = _tmp685_;
			_tmp686_ = _val_list;
			_tmp687_ = vala_collection_get_size ((ValaCollection*) _tmp686_);
			_tmp688_ = _tmp687_;
			_val_size = _tmp688_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp689_;
				gint _tmp690_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp691_;
				gpointer _tmp692_;
				const gchar* _tmp693_;
				ValaEnumValue* _tmp694_;
				const gchar* _tmp695_;
				const gchar* _tmp696_;
				_val_index = _val_index + 1;
				_tmp689_ = _val_index;
				_tmp690_ = _val_size;
				if (!(_tmp689_ < _tmp690_)) {
					break;
				}
				_tmp691_ = _val_list;
				_tmp692_ = vala_list_get (_tmp691_, _val_index);
				val = (ValaEnumValue*) _tmp692_;
				_tmp693_ = self->priv->_member_name;
				_tmp694_ = val;
				_tmp695_ = vala_symbol_get_name ((ValaSymbol*) _tmp694_);
				_tmp696_ = _tmp695_;
				if (g_strcmp0 (_tmp693_, _tmp696_) == 0) {
					ValaEnumValue* _tmp697_;
					_tmp697_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp697_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp698_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp699_ = _tmp698_;
	if (_tmp699_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp700_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp701_ = FALSE;
		ValaExpression* _tmp702_;
		ValaExpression* _tmp703_;
		gchar* base_type_package = NULL;
		gchar* _tmp723_;
		gboolean _tmp724_ = FALSE;
		ValaSymbol* _tmp725_;
		gchar* visited_types_string = NULL;
		gchar* _tmp740_;
		ValaSourceReference* _tmp757_;
		ValaSourceReference* _tmp758_;
		const gchar* _tmp759_;
		const gchar* _tmp760_;
		const gchar* _tmp761_;
		const gchar* _tmp762_;
		gchar* _tmp763_;
		gchar* _tmp764_;
		ValaInvalidType* _tmp765_;
		ValaInvalidType* _tmp766_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp700_ = g_strdup ("(null)");
		base_type_name = _tmp700_;
		base_type = NULL;
		_tmp702_ = vala_member_access_get_inner (self);
		_tmp703_ = _tmp702_;
		if (_tmp703_ != NULL) {
			ValaExpression* _tmp704_;
			ValaExpression* _tmp705_;
			ValaDataType* _tmp706_;
			ValaDataType* _tmp707_;
			_tmp704_ = vala_member_access_get_inner (self);
			_tmp705_ = _tmp704_;
			_tmp706_ = vala_expression_get_value_type (_tmp705_);
			_tmp707_ = _tmp706_;
			_tmp701_ = _tmp707_ != NULL;
		} else {
			_tmp701_ = FALSE;
		}
		if (_tmp701_) {
			ValaExpression* _tmp708_;
			ValaExpression* _tmp709_;
			ValaDataType* _tmp710_;
			ValaDataType* _tmp711_;
			gchar* _tmp712_;
			ValaExpression* _tmp713_;
			ValaExpression* _tmp714_;
			ValaDataType* _tmp715_;
			ValaDataType* _tmp716_;
			ValaTypeSymbol* _tmp717_;
			ValaTypeSymbol* _tmp718_;
			_tmp708_ = vala_member_access_get_inner (self);
			_tmp709_ = _tmp708_;
			_tmp710_ = vala_expression_get_value_type (_tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = vala_code_node_to_string ((ValaCodeNode*) _tmp711_);
			_g_free0 (base_type_name);
			base_type_name = _tmp712_;
			_tmp713_ = vala_member_access_get_inner (self);
			_tmp714_ = _tmp713_;
			_tmp715_ = vala_expression_get_value_type (_tmp714_);
			_tmp716_ = _tmp715_;
			_tmp717_ = vala_data_type_get_type_symbol (_tmp716_);
			_tmp718_ = _tmp717_;
			base_type = (ValaSymbol*) _tmp718_;
		} else {
			ValaSymbol* _tmp719_;
			_tmp719_ = base_symbol;
			if (_tmp719_ != NULL) {
				ValaSymbol* _tmp720_;
				gchar* _tmp721_;
				ValaSymbol* _tmp722_;
				_tmp720_ = base_symbol;
				_tmp721_ = vala_symbol_get_full_name (_tmp720_);
				_g_free0 (base_type_name);
				base_type_name = _tmp721_;
				_tmp722_ = base_symbol;
				base_type = _tmp722_;
			}
		}
		_tmp723_ = g_strdup ("");
		base_type_package = _tmp723_;
		_tmp725_ = base_type;
		if (_tmp725_ != NULL) {
			ValaSymbol* _tmp726_;
			gboolean _tmp727_;
			gboolean _tmp728_;
			_tmp726_ = base_type;
			_tmp727_ = vala_symbol_get_external_package (_tmp726_);
			_tmp728_ = _tmp727_;
			_tmp724_ = _tmp728_;
		} else {
			_tmp724_ = FALSE;
		}
		if (_tmp724_) {
			ValaSymbol* _tmp729_;
			ValaSourceReference* _tmp730_;
			ValaSourceReference* _tmp731_;
			ValaSourceFile* _tmp732_;
			ValaSourceFile* _tmp733_;
			const gchar* _tmp734_;
			const gchar* _tmp735_;
			gchar* _tmp736_;
			const gchar* _tmp737_;
			_tmp729_ = base_symbol;
			_tmp730_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp729_);
			_tmp731_ = _tmp730_;
			_tmp732_ = vala_source_reference_get_file (_tmp731_);
			_tmp733_ = _tmp732_;
			_tmp734_ = vala_source_file_get_package_name (_tmp733_);
			_tmp735_ = _tmp734_;
			_tmp736_ = g_strdup (_tmp735_);
			_g_free0 (base_type_package);
			base_type_package = _tmp736_;
			_tmp737_ = base_type_package;
			if (_tmp737_ != NULL) {
				const gchar* _tmp738_;
				gchar* _tmp739_;
				_tmp738_ = base_type_package;
				_tmp739_ = g_strdup_printf (" (%s)", _tmp738_);
				_g_free0 (base_type_package);
				base_type_package = _tmp739_;
			}
		}
		_tmp740_ = g_strdup ("");
		visited_types_string = _tmp740_;
		{
			ValaArrayList* _type_list = NULL;
			ValaArrayList* _tmp741_;
			ValaArrayList* _tmp742_;
			gint _type_size = 0;
			ValaArrayList* _tmp743_;
			gint _tmp744_;
			gint _tmp745_;
			gint _type_index = 0;
			_tmp741_ = visited_types;
			_tmp742_ = _vala_iterable_ref0 (_tmp741_);
			_type_list = _tmp742_;
			_tmp743_ = _type_list;
			_tmp744_ = vala_collection_get_size ((ValaCollection*) _tmp743_);
			_tmp745_ = _tmp744_;
			_type_size = _tmp745_;
			_type_index = -1;
			while (TRUE) {
				gint _tmp746_;
				gint _tmp747_;
				ValaDataType* type = NULL;
				ValaArrayList* _tmp748_;
				gpointer _tmp749_;
				const gchar* _tmp750_;
				ValaDataType* _tmp751_;
				gchar* _tmp752_;
				gchar* _tmp753_;
				gchar* _tmp754_;
				gchar* _tmp755_;
				gchar* _tmp756_;
				_type_index = _type_index + 1;
				_tmp746_ = _type_index;
				_tmp747_ = _type_size;
				if (!(_tmp746_ < _tmp747_)) {
					break;
				}
				_tmp748_ = _type_list;
				_tmp749_ = vala_list_get ((ValaList*) _tmp748_, _type_index);
				type = (ValaDataType*) _tmp749_;
				_tmp750_ = visited_types_string;
				_tmp751_ = type;
				_tmp752_ = vala_code_node_to_string ((ValaCodeNode*) _tmp751_);
				_tmp753_ = _tmp752_;
				_tmp754_ = g_strdup_printf (" or `%s'", _tmp753_);
				_tmp755_ = _tmp754_;
				_tmp756_ = g_strconcat (_tmp750_, _tmp755_, NULL);
				_g_free0 (visited_types_string);
				visited_types_string = _tmp756_;
				_g_free0 (_tmp755_);
				_g_free0 (_tmp753_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
		_tmp757_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp758_ = _tmp757_;
		_tmp759_ = self->priv->_member_name;
		_tmp760_ = base_type_name;
		_tmp761_ = base_type_package;
		_tmp762_ = visited_types_string;
		_tmp763_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s%s", _tmp759_, _tmp760_, _tmp761_, _tmp762_);
		_tmp764_ = _tmp763_;
		vala_report_error (_tmp758_, _tmp764_);
		_g_free0 (_tmp764_);
		_tmp765_ = vala_invalid_type_new ();
		_tmp766_ = _tmp765_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp766_);
		_vala_code_node_unref0 (_tmp766_);
		result = FALSE;
		_g_free0 (visited_types_string);
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		_vala_iterable_unref0 (visited_types);
		return result;
	} else {
		ValaSymbol* _tmp767_;
		ValaSymbol* _tmp768_;
		gboolean _tmp769_;
		gboolean _tmp770_;
		_tmp767_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp768_ = _tmp767_;
		_tmp769_ = vala_code_node_get_error ((ValaCodeNode*) _tmp768_);
		_tmp770_ = _tmp769_;
		if (_tmp770_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	_tmp771_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp772_ = _tmp771_;
	if (VALA_IS_SIGNAL (_tmp772_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp773_;
		ValaSymbol* _tmp774_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp781_;
		ValaCodeNode* _tmp782_;
		ValaCodeNode* _tmp783_;
		gboolean _tmp784_ = FALSE;
		gboolean _tmp785_ = FALSE;
		gboolean _tmp786_ = FALSE;
		ValaCodeNode* _tmp787_;
		_tmp773_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp774_ = _tmp773_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp774_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp775_;
			ValaCodeNode* _tmp776_;
			ValaCodeNode* _tmp777_;
			ValaCodeNode* _tmp778_;
			ValaCodeNode* _tmp779_;
			ValaCodeNode* _tmp780_;
			_tmp775_ = ma;
			_tmp776_ = vala_code_node_get_parent_node (_tmp775_);
			_tmp777_ = _tmp776_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp777_)) {
				break;
			}
			_tmp778_ = ma;
			_tmp779_ = vala_code_node_get_parent_node (_tmp778_);
			_tmp780_ = _tmp779_;
			ma = _tmp780_;
		}
		_tmp781_ = ma;
		_tmp782_ = vala_code_node_get_parent_node (_tmp781_);
		_tmp783_ = _tmp782_;
		parent = _tmp783_;
		_tmp787_ = parent;
		if (_tmp787_ != NULL) {
			ValaCodeNode* _tmp788_;
			_tmp788_ = parent;
			_tmp786_ = !VALA_IS_ELEMENT_ACCESS (_tmp788_);
		} else {
			_tmp786_ = FALSE;
		}
		if (_tmp786_) {
			ValaCodeNode* _tmp789_;
			ValaExpression* _tmp790_;
			ValaExpression* _tmp791_;
			_tmp789_ = ma;
			_tmp790_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp789_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp791_ = _tmp790_;
			_tmp785_ = !VALA_IS_BASE_ACCESS (_tmp791_);
		} else {
			_tmp785_ = FALSE;
		}
		if (_tmp785_) {
			gboolean _tmp792_ = FALSE;
			ValaCodeNode* _tmp793_;
			_tmp793_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp793_)) {
				_tmp792_ = TRUE;
			} else {
				ValaCodeNode* _tmp794_;
				ValaList* _tmp795_;
				_tmp794_ = parent;
				_tmp795_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp794_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp792_ = vala_collection_contains ((ValaCollection*) _tmp795_, (ValaExpression*) self);
			}
			_tmp784_ = _tmp792_;
		} else {
			_tmp784_ = FALSE;
		}
		if (_tmp784_) {
			ValaSignal* _tmp796_;
			ValaAttribute* _tmp797_;
			_tmp796_ = sig;
			_tmp797_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp796_, "HasEmitter");
			if (_tmp797_ != NULL) {
				ValaSignal* _tmp798_;
				ValaSignal* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				_tmp798_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp798_, context)) {
					result = FALSE;
					_vala_iterable_unref0 (visited_types);
					return result;
				}
				_tmp799_ = sig;
				_tmp800_ = vala_signal_get_emitter (_tmp799_);
				_tmp801_ = _tmp800_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp801_);
			} else {
				ValaSourceReference* _tmp802_;
				ValaSourceReference* _tmp803_;
				ValaSymbol* _tmp804_;
				ValaSymbol* _tmp805_;
				gchar* _tmp806_;
				gchar* _tmp807_;
				gchar* _tmp808_;
				gchar* _tmp809_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp802_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp805_ = _tmp804_;
				_tmp806_ = vala_symbol_get_full_name (_tmp805_);
				_tmp807_ = _tmp806_;
				_tmp808_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp807_);
				_tmp809_ = _tmp808_;
				vala_report_error (_tmp803_, _tmp809_);
				_g_free0 (_tmp809_);
				_g_free0 (_tmp807_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	_tmp810_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp811_ = _tmp810_;
	member = _tmp811_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp812_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp812_, context)) {
		result = FALSE;
		_vala_iterable_unref0 (visited_types);
		return result;
	}
	_tmp813_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp813_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp814_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp815_;
		ValaSymbol* _tmp816_;
		ValaSymbol* _tmp817_;
		gboolean _tmp818_ = FALSE;
		ValaBlock* _tmp819_;
		_tmp814_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp814_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp815_ = local;
		_tmp816_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp815_);
		_tmp817_ = _tmp816_;
		block = VALA_IS_BLOCK (_tmp817_) ? ((ValaBlock*) _tmp817_) : NULL;
		_tmp819_ = block;
		if (_tmp819_ != NULL) {
			ValaBlock* _tmp820_;
			ValaSymbol* _tmp821_;
			ValaSemanticAnalyzer* _tmp822_;
			ValaSemanticAnalyzer* _tmp823_;
			ValaSymbol* _tmp824_;
			ValaSymbol* _tmp825_;
			_tmp820_ = block;
			_tmp821_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp820_);
			_tmp822_ = vala_code_context_get_analyzer (context);
			_tmp823_ = _tmp822_;
			_tmp824_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp823_);
			_tmp825_ = _tmp824_;
			_tmp818_ = _tmp821_ != _tmp825_;
		} else {
			_tmp818_ = FALSE;
		}
		if (_tmp818_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp826_;
			ValaSemanticAnalyzer* _tmp827_;
			ValaSymbol* _tmp828_;
			ValaSymbol* _tmp829_;
			ValaLocalVariable* _tmp840_;
			ValaBlock* _tmp841_;
			_tmp826_ = vala_code_context_get_analyzer (context);
			_tmp827_ = _tmp826_;
			_tmp828_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp827_);
			_tmp829_ = _tmp828_;
			sym = _tmp829_;
			while (TRUE) {
				ValaSymbol* _tmp830_;
				ValaBlock* _tmp831_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp832_;
				ValaMethod* _tmp833_;
				ValaSymbol* _tmp837_;
				ValaSymbol* _tmp838_;
				ValaSymbol* _tmp839_;
				_tmp830_ = sym;
				_tmp831_ = block;
				if (!(_tmp830_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp831_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp832_ = sym;
				method = VALA_IS_METHOD (_tmp832_) ? ((ValaMethod*) _tmp832_) : NULL;
				_tmp833_ = method;
				if (_tmp833_ != NULL) {
					ValaMethod* _tmp834_;
					ValaMethod* _tmp835_;
					ValaLocalVariable* _tmp836_;
					_tmp834_ = method;
					vala_method_set_closure (_tmp834_, TRUE);
					_tmp835_ = method;
					_tmp836_ = local;
					vala_method_add_captured_variable (_tmp835_, _tmp836_);
				}
				_tmp837_ = sym;
				_tmp838_ = vala_symbol_get_parent_symbol (_tmp837_);
				_tmp839_ = _tmp838_;
				sym = _tmp839_;
			}
			_tmp840_ = local;
			vala_local_variable_set_captured (_tmp840_, TRUE);
			_tmp841_ = block;
			vala_block_set_captured (_tmp841_, TRUE);
		}
	} else {
		ValaSymbol* _tmp842_;
		_tmp842_ = member;
		if (VALA_IS_PARAMETER (_tmp842_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp843_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp844_;
			ValaSymbol* _tmp845_;
			ValaSymbol* _tmp846_;
			gboolean _tmp847_ = FALSE;
			gboolean _tmp848_ = FALSE;
			ValaMethod* _tmp849_;
			_tmp843_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp843_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp844_ = param;
			_tmp845_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp844_);
			_tmp846_ = _tmp845_;
			m = VALA_IS_METHOD (_tmp846_) ? ((ValaMethod*) _tmp846_) : NULL;
			_tmp849_ = m;
			if (_tmp849_ != NULL) {
				ValaMethod* _tmp850_;
				ValaSemanticAnalyzer* _tmp851_;
				ValaSemanticAnalyzer* _tmp852_;
				ValaSymbol* _tmp853_;
				ValaSymbol* _tmp854_;
				_tmp850_ = m;
				_tmp851_ = vala_code_context_get_analyzer (context);
				_tmp852_ = _tmp851_;
				_tmp853_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp852_);
				_tmp854_ = _tmp853_;
				_tmp848_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp850_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp854_;
			} else {
				_tmp848_ = FALSE;
			}
			if (_tmp848_) {
				ValaParameter* _tmp855_;
				ValaMethod* _tmp856_;
				ValaParameter* _tmp857_;
				ValaParameter* _tmp858_;
				_tmp855_ = param;
				_tmp856_ = m;
				_tmp857_ = vala_method_get_this_parameter (_tmp856_);
				_tmp858_ = _tmp857_;
				_tmp847_ = _tmp855_ != _tmp858_;
			} else {
				_tmp847_ = FALSE;
			}
			if (_tmp847_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp859_;
				ValaSemanticAnalyzer* _tmp860_;
				ValaSymbol* _tmp861_;
				ValaSymbol* _tmp862_;
				ValaParameter* _tmp871_;
				ValaMethod* _tmp872_;
				ValaBlock* _tmp873_;
				ValaBlock* _tmp874_;
				ValaParameter* _tmp875_;
				ValaParameterDirection _tmp876_;
				ValaParameterDirection _tmp877_;
				_tmp859_ = vala_code_context_get_analyzer (context);
				_tmp860_ = _tmp859_;
				_tmp861_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp860_);
				_tmp862_ = _tmp861_;
				sym = _tmp862_;
				while (TRUE) {
					ValaSymbol* _tmp863_;
					ValaMethod* _tmp864_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp865_;
					ValaMethod* _tmp866_;
					ValaSymbol* _tmp868_;
					ValaSymbol* _tmp869_;
					ValaSymbol* _tmp870_;
					_tmp863_ = sym;
					_tmp864_ = m;
					if (!(_tmp863_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp864_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp865_ = sym;
					method = VALA_IS_METHOD (_tmp865_) ? ((ValaMethod*) _tmp865_) : NULL;
					_tmp866_ = method;
					if (_tmp866_ != NULL) {
						ValaMethod* _tmp867_;
						_tmp867_ = method;
						vala_method_set_closure (_tmp867_, TRUE);
					}
					_tmp868_ = sym;
					_tmp869_ = vala_symbol_get_parent_symbol (_tmp868_);
					_tmp870_ = _tmp869_;
					sym = _tmp870_;
				}
				_tmp871_ = param;
				vala_parameter_set_captured (_tmp871_, TRUE);
				_tmp872_ = m;
				_tmp873_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp872_);
				_tmp874_ = _tmp873_;
				vala_block_set_captured (_tmp874_, TRUE);
				_tmp875_ = param;
				_tmp876_ = vala_parameter_get_direction (_tmp875_);
				_tmp877_ = _tmp876_;
				if (_tmp877_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp878_;
					ValaSourceReference* _tmp879_;
					ValaParameter* _tmp880_;
					gchar* _tmp881_;
					gchar* _tmp882_;
					gchar* _tmp883_;
					gchar* _tmp884_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp878_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp879_ = _tmp878_;
					_tmp880_ = param;
					_tmp881_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp880_);
					_tmp882_ = _tmp881_;
					_tmp883_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp882_);
					_tmp884_ = _tmp883_;
					vala_report_error (_tmp879_, _tmp884_);
					_g_free0 (_tmp884_);
					_g_free0 (_tmp882_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp885_;
				ValaSymbol* _tmp886_;
				ValaSymbol* _tmp887_;
				ValaSymbol* _tmp888_;
				ValaSymbol* _tmp889_;
				gboolean _tmp890_ = FALSE;
				gboolean _tmp891_ = FALSE;
				ValaPropertyAccessor* _tmp892_;
				_tmp885_ = param;
				_tmp886_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp885_);
				_tmp887_ = _tmp886_;
				_tmp888_ = vala_symbol_get_parent_symbol (_tmp887_);
				_tmp889_ = _tmp888_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp889_) ? ((ValaPropertyAccessor*) _tmp889_) : NULL;
				_tmp892_ = acc;
				if (_tmp892_ != NULL) {
					ValaPropertyAccessor* _tmp893_;
					ValaSemanticAnalyzer* _tmp894_;
					ValaSemanticAnalyzer* _tmp895_;
					ValaSymbol* _tmp896_;
					ValaSymbol* _tmp897_;
					_tmp893_ = acc;
					_tmp894_ = vala_code_context_get_analyzer (context);
					_tmp895_ = _tmp894_;
					_tmp896_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp895_);
					_tmp897_ = _tmp896_;
					_tmp891_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp893_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp897_;
				} else {
					_tmp891_ = FALSE;
				}
				if (_tmp891_) {
					ValaParameter* _tmp898_;
					ValaPropertyAccessor* _tmp899_;
					ValaProperty* _tmp900_;
					ValaProperty* _tmp901_;
					ValaParameter* _tmp902_;
					ValaParameter* _tmp903_;
					_tmp898_ = param;
					_tmp899_ = acc;
					_tmp900_ = vala_property_accessor_get_prop (_tmp899_);
					_tmp901_ = _tmp900_;
					_tmp902_ = vala_property_get_this_parameter (_tmp901_);
					_tmp903_ = _tmp902_;
					_tmp890_ = _tmp898_ != _tmp903_;
				} else {
					_tmp890_ = FALSE;
				}
				if (_tmp890_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp904_;
					ValaSemanticAnalyzer* _tmp905_;
					ValaSymbol* _tmp906_;
					ValaSymbol* _tmp907_;
					ValaParameter* _tmp916_;
					ValaPropertyAccessor* _tmp917_;
					ValaBlock* _tmp918_;
					ValaBlock* _tmp919_;
					_tmp904_ = vala_code_context_get_analyzer (context);
					_tmp905_ = _tmp904_;
					_tmp906_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp905_);
					_tmp907_ = _tmp906_;
					sym = _tmp907_;
					while (TRUE) {
						ValaSymbol* _tmp908_;
						ValaMethod* _tmp909_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp910_;
						ValaMethod* _tmp911_;
						ValaSymbol* _tmp913_;
						ValaSymbol* _tmp914_;
						ValaSymbol* _tmp915_;
						_tmp908_ = sym;
						_tmp909_ = m;
						if (!(_tmp908_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp909_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp910_ = sym;
						method = VALA_IS_METHOD (_tmp910_) ? ((ValaMethod*) _tmp910_) : NULL;
						_tmp911_ = method;
						if (_tmp911_ != NULL) {
							ValaMethod* _tmp912_;
							_tmp912_ = method;
							vala_method_set_closure (_tmp912_, TRUE);
						}
						_tmp913_ = sym;
						_tmp914_ = vala_symbol_get_parent_symbol (_tmp913_);
						_tmp915_ = _tmp914_;
						sym = _tmp915_;
					}
					_tmp916_ = param;
					vala_parameter_set_captured (_tmp916_, TRUE);
					_tmp917_ = acc;
					_tmp918_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp917_);
					_tmp919_ = _tmp918_;
					vala_block_set_captured (_tmp919_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp920_;
			_tmp920_ = member;
			if (VALA_IS_FIELD (_tmp920_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp921_;
				ValaField* _tmp922_;
				ValaSymbolAccessibility _tmp923_;
				ValaSymbolAccessibility _tmp924_;
				ValaField* _tmp925_;
				ValaMemberBinding _tmp926_;
				ValaMemberBinding _tmp927_;
				ValaField* _tmp928_;
				ValaMemberBinding _tmp929_;
				ValaMemberBinding _tmp930_;
				ValaField* _tmp931_;
				ValaDataType* _tmp932_;
				ValaDataType* _tmp933_;
				_tmp921_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp921_, VALA_TYPE_FIELD, ValaField);
				_tmp922_ = f;
				_tmp923_ = vala_symbol_get_access ((ValaSymbol*) _tmp922_);
				_tmp924_ = _tmp923_;
				access = _tmp924_;
				_tmp925_ = f;
				_tmp926_ = vala_field_get_binding (_tmp925_);
				_tmp927_ = _tmp926_;
				instance = _tmp927_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp928_ = f;
				_tmp929_ = vala_field_get_binding (_tmp928_);
				_tmp930_ = _tmp929_;
				klass = _tmp930_ == VALA_MEMBER_BINDING_CLASS;
				_tmp931_ = f;
				_tmp932_ = vala_variable_get_variable_type ((ValaVariable*) _tmp931_);
				_tmp933_ = _tmp932_;
				if (VALA_IS_GENERIC_TYPE (_tmp933_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp934_;
				_tmp934_ = member;
				if (VALA_IS_CONSTANT (_tmp934_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp935_;
					ValaConstant* _tmp936_;
					ValaSymbolAccessibility _tmp937_;
					ValaSymbolAccessibility _tmp938_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp939_;
					ValaSymbol* _tmp940_;
					ValaSymbol* _tmp941_;
					gboolean _tmp942_ = FALSE;
					ValaBlock* _tmp943_;
					_tmp935_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp935_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp936_ = c;
					_tmp937_ = vala_symbol_get_access ((ValaSymbol*) _tmp936_);
					_tmp938_ = _tmp937_;
					access = _tmp938_;
					_tmp939_ = c;
					_tmp940_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp939_);
					_tmp941_ = _tmp940_;
					block = VALA_IS_BLOCK (_tmp941_) ? ((ValaBlock*) _tmp941_) : NULL;
					_tmp943_ = block;
					if (_tmp943_ != NULL) {
						ValaBlock* _tmp944_;
						ValaSymbol* _tmp945_;
						ValaSemanticAnalyzer* _tmp946_;
						ValaSemanticAnalyzer* _tmp947_;
						ValaSymbol* _tmp948_;
						ValaSymbol* _tmp949_;
						_tmp944_ = block;
						_tmp945_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp944_);
						_tmp946_ = vala_code_context_get_analyzer (context);
						_tmp947_ = _tmp946_;
						_tmp948_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp947_);
						_tmp949_ = _tmp948_;
						_tmp942_ = _tmp945_ != _tmp949_;
					} else {
						_tmp942_ = FALSE;
					}
					if (_tmp942_) {
						ValaSourceReference* _tmp950_;
						ValaSourceReference* _tmp951_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp950_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp951_ = _tmp950_;
						vala_report_error (_tmp951_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_iterable_unref0 (visited_types);
						return result;
					}
				} else {
					ValaSymbol* _tmp952_;
					_tmp952_ = member;
					if (VALA_IS_METHOD (_tmp952_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp953_;
						ValaMethod* _tmp954_;
						gboolean _tmp955_;
						gboolean _tmp956_;
						ValaMethod* _tmp1045_;
						ValaSymbolAccessibility _tmp1046_;
						ValaSymbolAccessibility _tmp1047_;
						ValaMethod* _tmp1048_;
						ValaMethod* _tmp1052_;
						ValaMemberBinding _tmp1053_;
						ValaMemberBinding _tmp1054_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						gboolean _tmp1078_ = FALSE;
						ValaGenericType* _tmp1079_;
						_tmp953_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp953_, VALA_TYPE_METHOD, ValaMethod);
						_tmp954_ = m;
						_tmp955_ = vala_method_get_is_async_callback (_tmp954_);
						_tmp956_ = _tmp955_;
						if (_tmp956_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp957_;
							ValaSemanticAnalyzer* _tmp958_;
							ValaMethod* _tmp959_;
							ValaMethod* _tmp960_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp961_;
							ValaMethod* _tmp990_;
							ValaSemanticAnalyzer* _tmp991_;
							ValaSemanticAnalyzer* _tmp992_;
							ValaMethod* _tmp993_;
							ValaMethod* _tmp994_;
							ValaMethod* _tmp1010_;
							ValaMethod* _tmp1011_;
							ValaMethod* _tmp1012_;
							ValaSymbol* _tmp1013_;
							ValaSymbol* _tmp1014_;
							_tmp957_ = vala_code_context_get_analyzer (context);
							_tmp958_ = _tmp957_;
							_tmp959_ = vala_semantic_analyzer_get_current_async_method (_tmp958_);
							_tmp960_ = _tmp959_;
							async_method = _tmp960_;
							is_valid_access = FALSE;
							_tmp961_ = async_method;
							if (_tmp961_ != NULL) {
								ValaMethod* _tmp962_;
								ValaMethod* _tmp963_;
								ValaMethod* _tmp964_;
								_tmp962_ = m;
								_tmp963_ = async_method;
								_tmp964_ = vala_method_get_callback_method (_tmp963_);
								if (_tmp962_ == _tmp964_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp965_ = FALSE;
									ValaMethod* _tmp966_;
									ValaMethod* _tmp967_;
									ValaMethod* _tmp968_;
									_tmp966_ = async_method;
									_tmp967_ = vala_method_get_base_method (_tmp966_);
									_tmp968_ = _tmp967_;
									if (_tmp968_ != NULL) {
										ValaMethod* _tmp969_;
										ValaMethod* _tmp970_;
										ValaMethod* _tmp971_;
										ValaMethod* _tmp972_;
										ValaMethod* _tmp973_;
										_tmp969_ = m;
										_tmp970_ = async_method;
										_tmp971_ = vala_method_get_base_method (_tmp970_);
										_tmp972_ = _tmp971_;
										_tmp973_ = vala_method_get_callback_method (_tmp972_);
										_tmp965_ = _tmp969_ == _tmp973_;
									} else {
										_tmp965_ = FALSE;
									}
									if (_tmp965_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp974_ = FALSE;
										ValaMethod* _tmp975_;
										ValaMethod* _tmp976_;
										ValaMethod* _tmp977_;
										_tmp975_ = async_method;
										_tmp976_ = vala_method_get_base_interface_method (_tmp975_);
										_tmp977_ = _tmp976_;
										if (_tmp977_ != NULL) {
											ValaMethod* _tmp978_;
											ValaMethod* _tmp979_;
											ValaMethod* _tmp980_;
											ValaMethod* _tmp981_;
											ValaMethod* _tmp982_;
											_tmp978_ = m;
											_tmp979_ = async_method;
											_tmp980_ = vala_method_get_base_interface_method (_tmp979_);
											_tmp981_ = _tmp980_;
											_tmp982_ = vala_method_get_callback_method (_tmp981_);
											_tmp974_ = _tmp978_ == _tmp982_;
										} else {
											_tmp974_ = FALSE;
										}
										if (_tmp974_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp983_;
								ValaSourceReference* _tmp984_;
								ValaMethod* _tmp985_;
								gchar* _tmp986_;
								gchar* _tmp987_;
								gchar* _tmp988_;
								gchar* _tmp989_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp983_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp984_ = _tmp983_;
								_tmp985_ = m;
								_tmp986_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp985_);
								_tmp987_ = _tmp986_;
								_tmp988_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp987_);
								_tmp989_ = _tmp988_;
								vala_report_error (_tmp984_, _tmp989_);
								_g_free0 (_tmp989_);
								_g_free0 (_tmp987_);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp990_ = async_method;
							_tmp991_ = vala_code_context_get_analyzer (context);
							_tmp992_ = _tmp991_;
							_tmp993_ = vala_semantic_analyzer_get_current_method (_tmp992_);
							_tmp994_ = _tmp993_;
							if (_tmp990_ != _tmp994_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp995_;
								ValaSemanticAnalyzer* _tmp996_;
								ValaMethod* _tmp997_;
								ValaMethod* _tmp998_;
								ValaMethod* _tmp1007_;
								ValaBlock* _tmp1008_;
								ValaBlock* _tmp1009_;
								_tmp995_ = vala_code_context_get_analyzer (context);
								_tmp996_ = _tmp995_;
								_tmp997_ = vala_semantic_analyzer_get_current_method (_tmp996_);
								_tmp998_ = _tmp997_;
								sym = (ValaSymbol*) _tmp998_;
								while (TRUE) {
									ValaSymbol* _tmp999_;
									ValaMethod* _tmp1000_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp1001_;
									ValaMethod* _tmp1002_;
									ValaSymbol* _tmp1004_;
									ValaSymbol* _tmp1005_;
									ValaSymbol* _tmp1006_;
									_tmp999_ = sym;
									_tmp1000_ = async_method;
									if (!(_tmp999_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1000_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp1001_ = sym;
									method = VALA_IS_METHOD (_tmp1001_) ? ((ValaMethod*) _tmp1001_) : NULL;
									_tmp1002_ = method;
									if (_tmp1002_ != NULL) {
										ValaMethod* _tmp1003_;
										_tmp1003_ = method;
										vala_method_set_closure (_tmp1003_, TRUE);
									}
									_tmp1004_ = sym;
									_tmp1005_ = vala_symbol_get_parent_symbol (_tmp1004_);
									_tmp1006_ = _tmp1005_;
									sym = _tmp1006_;
								}
								_tmp1007_ = async_method;
								_tmp1008_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp1007_);
								_tmp1009_ = _tmp1008_;
								vala_block_set_captured (_tmp1009_, TRUE);
							}
							_tmp1010_ = async_method;
							_tmp1011_ = vala_method_get_callback_method (_tmp1010_);
							m = _tmp1011_;
							_tmp1012_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1012_);
							_tmp1013_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp1014_ = _tmp1013_;
							member = _tmp1014_;
						} else {
							ValaMethod* _tmp1015_;
							ValaMethod* _tmp1016_;
							ValaMethod* _tmp1017_;
							_tmp1015_ = m;
							_tmp1016_ = vala_method_get_base_method (_tmp1015_);
							_tmp1017_ = _tmp1016_;
							if (_tmp1017_ != NULL) {
								ValaMethod* _tmp1018_;
								ValaMethod* _tmp1019_;
								ValaMethod* _tmp1020_;
								ValaMethod* _tmp1021_;
								ValaSignal* _tmp1022_;
								ValaSignal* _tmp1023_;
								ValaSymbol* _tmp1028_;
								ValaSymbol* _tmp1029_;
								_tmp1018_ = m;
								_tmp1019_ = vala_method_get_base_method (_tmp1018_);
								_tmp1020_ = _tmp1019_;
								m = _tmp1020_;
								_tmp1021_ = m;
								_tmp1022_ = vala_method_get_signal_reference (_tmp1021_);
								_tmp1023_ = _tmp1022_;
								if (_tmp1023_ != NULL) {
									ValaMethod* _tmp1024_;
									ValaSignal* _tmp1025_;
									ValaSignal* _tmp1026_;
									_tmp1024_ = m;
									_tmp1025_ = vala_method_get_signal_reference (_tmp1024_);
									_tmp1026_ = _tmp1025_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1026_);
								} else {
									ValaMethod* _tmp1027_;
									_tmp1027_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1027_);
								}
								_tmp1028_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1029_ = _tmp1028_;
								member = _tmp1029_;
							} else {
								ValaMethod* _tmp1030_;
								ValaMethod* _tmp1031_;
								ValaMethod* _tmp1032_;
								_tmp1030_ = m;
								_tmp1031_ = vala_method_get_base_interface_method (_tmp1030_);
								_tmp1032_ = _tmp1031_;
								if (_tmp1032_ != NULL) {
									ValaMethod* _tmp1033_;
									ValaMethod* _tmp1034_;
									ValaMethod* _tmp1035_;
									ValaMethod* _tmp1036_;
									ValaSignal* _tmp1037_;
									ValaSignal* _tmp1038_;
									ValaSymbol* _tmp1043_;
									ValaSymbol* _tmp1044_;
									_tmp1033_ = m;
									_tmp1034_ = vala_method_get_base_interface_method (_tmp1033_);
									_tmp1035_ = _tmp1034_;
									m = _tmp1035_;
									_tmp1036_ = m;
									_tmp1037_ = vala_method_get_signal_reference (_tmp1036_);
									_tmp1038_ = _tmp1037_;
									if (_tmp1038_ != NULL) {
										ValaMethod* _tmp1039_;
										ValaSignal* _tmp1040_;
										ValaSignal* _tmp1041_;
										_tmp1039_ = m;
										_tmp1040_ = vala_method_get_signal_reference (_tmp1039_);
										_tmp1041_ = _tmp1040_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1041_);
									} else {
										ValaMethod* _tmp1042_;
										_tmp1042_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1042_);
									}
									_tmp1043_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1044_ = _tmp1043_;
									member = _tmp1044_;
								}
							}
						}
						_tmp1045_ = m;
						_tmp1046_ = vala_symbol_get_access ((ValaSymbol*) _tmp1045_);
						_tmp1047_ = _tmp1046_;
						access = _tmp1047_;
						_tmp1048_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1048_)) {
							ValaMethod* _tmp1049_;
							ValaMemberBinding _tmp1050_;
							ValaMemberBinding _tmp1051_;
							_tmp1049_ = m;
							_tmp1050_ = vala_method_get_binding (_tmp1049_);
							_tmp1051_ = _tmp1050_;
							instance = _tmp1051_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1052_ = m;
						_tmp1053_ = vala_method_get_binding (_tmp1052_);
						_tmp1054_ = _tmp1053_;
						klass = _tmp1054_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1055_;
							ValaList* _tmp1056_;
							ValaList* _tmp1057_;
							gint _param_size = 0;
							ValaList* _tmp1058_;
							gint _tmp1059_;
							gint _tmp1060_;
							gint _param_index = 0;
							_tmp1055_ = m;
							_tmp1056_ = vala_callable_get_parameters ((ValaCallable*) _tmp1055_);
							_tmp1057_ = _vala_iterable_ref0 (_tmp1056_);
							_param_list = _tmp1057_;
							_tmp1058_ = _param_list;
							_tmp1059_ = vala_collection_get_size ((ValaCollection*) _tmp1058_);
							_tmp1060_ = _tmp1059_;
							_param_size = _tmp1060_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1061_;
								gint _tmp1062_;
								ValaParameter* param = NULL;
								ValaList* _tmp1063_;
								gpointer _tmp1064_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1065_;
								ValaDataType* _tmp1066_;
								ValaDataType* _tmp1067_;
								gboolean _tmp1068_ = FALSE;
								ValaGenericType* _tmp1069_;
								_param_index = _param_index + 1;
								_tmp1061_ = _param_index;
								_tmp1062_ = _param_size;
								if (!(_tmp1061_ < _tmp1062_)) {
									break;
								}
								_tmp1063_ = _param_list;
								_tmp1064_ = vala_list_get (_tmp1063_, _param_index);
								param = (ValaParameter*) _tmp1064_;
								_tmp1065_ = param;
								_tmp1066_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1065_);
								_tmp1067_ = _tmp1066_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp1067_) ? ((ValaGenericType*) _tmp1067_) : NULL;
								_tmp1069_ = generic_type;
								if (_tmp1069_ != NULL) {
									ValaGenericType* _tmp1070_;
									ValaTypeParameter* _tmp1071_;
									ValaTypeParameter* _tmp1072_;
									ValaSymbol* _tmp1073_;
									ValaSymbol* _tmp1074_;
									_tmp1070_ = generic_type;
									_tmp1071_ = vala_generic_type_get_type_parameter (_tmp1070_);
									_tmp1072_ = _tmp1071_;
									_tmp1073_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1072_);
									_tmp1074_ = _tmp1073_;
									_tmp1068_ = VALA_IS_TYPESYMBOL (_tmp1074_);
								} else {
									_tmp1068_ = FALSE;
								}
								if (_tmp1068_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1075_ = m;
						_tmp1076_ = vala_callable_get_return_type ((ValaCallable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp1077_) ? ((ValaGenericType*) _tmp1077_) : NULL;
						_tmp1079_ = generic_type;
						if (_tmp1079_ != NULL) {
							ValaGenericType* _tmp1080_;
							ValaTypeParameter* _tmp1081_;
							ValaTypeParameter* _tmp1082_;
							ValaSymbol* _tmp1083_;
							ValaSymbol* _tmp1084_;
							_tmp1080_ = generic_type;
							_tmp1081_ = vala_generic_type_get_type_parameter (_tmp1080_);
							_tmp1082_ = _tmp1081_;
							_tmp1083_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1082_);
							_tmp1084_ = _tmp1083_;
							_tmp1078_ = VALA_IS_TYPESYMBOL (_tmp1084_);
						} else {
							_tmp1078_ = FALSE;
						}
						if (_tmp1078_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1085_;
						_tmp1085_ = member;
						if (VALA_IS_PROPERTY (_tmp1085_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1086_;
							ValaProperty* _tmp1087_;
							ValaProperty* _tmp1088_;
							ValaProperty* _tmp1089_;
							ValaProperty* _tmp1090_;
							ValaProperty* _tmp1106_;
							ValaSymbolAccessibility _tmp1107_;
							ValaSymbolAccessibility _tmp1108_;
							gboolean _tmp1109_;
							gboolean _tmp1110_;
							ValaProperty* _tmp1175_;
							ValaMemberBinding _tmp1176_;
							ValaMemberBinding _tmp1177_;
							ValaProperty* _tmp1178_;
							ValaDataType* _tmp1179_;
							ValaDataType* _tmp1180_;
							_tmp1086_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1086_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1087_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1087_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_iterable_unref0 (visited_types);
								return result;
							}
							_tmp1088_ = prop;
							_tmp1089_ = vala_property_get_base_property (_tmp1088_);
							_tmp1090_ = _tmp1089_;
							if (_tmp1090_ != NULL) {
								ValaProperty* _tmp1091_;
								ValaProperty* _tmp1092_;
								ValaProperty* _tmp1093_;
								ValaProperty* _tmp1094_;
								ValaSymbol* _tmp1095_;
								ValaSymbol* _tmp1096_;
								_tmp1091_ = prop;
								_tmp1092_ = vala_property_get_base_property (_tmp1091_);
								_tmp1093_ = _tmp1092_;
								prop = _tmp1093_;
								_tmp1094_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1094_);
								_tmp1095_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1096_ = _tmp1095_;
								member = _tmp1096_;
							} else {
								ValaProperty* _tmp1097_;
								ValaProperty* _tmp1098_;
								ValaProperty* _tmp1099_;
								_tmp1097_ = prop;
								_tmp1098_ = vala_property_get_base_interface_property (_tmp1097_);
								_tmp1099_ = _tmp1098_;
								if (_tmp1099_ != NULL) {
									ValaProperty* _tmp1100_;
									ValaProperty* _tmp1101_;
									ValaProperty* _tmp1102_;
									ValaProperty* _tmp1103_;
									ValaSymbol* _tmp1104_;
									ValaSymbol* _tmp1105_;
									_tmp1100_ = prop;
									_tmp1101_ = vala_property_get_base_interface_property (_tmp1100_);
									_tmp1102_ = _tmp1101_;
									prop = _tmp1102_;
									_tmp1103_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1103_);
									_tmp1104_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1105_ = _tmp1104_;
									member = _tmp1105_;
								}
							}
							_tmp1106_ = prop;
							_tmp1107_ = vala_symbol_get_access ((ValaSymbol*) _tmp1106_);
							_tmp1108_ = _tmp1107_;
							access = _tmp1108_;
							_tmp1109_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1110_ = _tmp1109_;
							if (_tmp1110_) {
								ValaProperty* _tmp1111_;
								ValaPropertyAccessor* _tmp1112_;
								ValaPropertyAccessor* _tmp1113_;
								ValaProperty* _tmp1121_;
								ValaSymbolAccessibility _tmp1122_;
								ValaSymbolAccessibility _tmp1123_;
								_tmp1111_ = prop;
								_tmp1112_ = vala_property_get_set_accessor (_tmp1111_);
								_tmp1113_ = _tmp1112_;
								if (_tmp1113_ == NULL) {
									ValaSourceReference* _tmp1114_;
									ValaSourceReference* _tmp1115_;
									ValaProperty* _tmp1116_;
									gchar* _tmp1117_;
									gchar* _tmp1118_;
									gchar* _tmp1119_;
									gchar* _tmp1120_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1115_ = _tmp1114_;
									_tmp1116_ = prop;
									_tmp1117_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1116_);
									_tmp1118_ = _tmp1117_;
									_tmp1119_ = g_strdup_printf ("Property `%s' is read-only", _tmp1118_);
									_tmp1120_ = _tmp1119_;
									vala_report_error (_tmp1115_, _tmp1120_);
									_g_free0 (_tmp1120_);
									_g_free0 (_tmp1118_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1121_ = prop;
								_tmp1122_ = vala_symbol_get_access ((ValaSymbol*) _tmp1121_);
								_tmp1123_ = _tmp1122_;
								if (_tmp1123_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1124_;
									ValaPropertyAccessor* _tmp1125_;
									ValaPropertyAccessor* _tmp1126_;
									ValaSymbolAccessibility _tmp1127_;
									ValaSymbolAccessibility _tmp1128_;
									_tmp1124_ = prop;
									_tmp1125_ = vala_property_get_set_accessor (_tmp1124_);
									_tmp1126_ = _tmp1125_;
									_tmp1127_ = vala_symbol_get_access ((ValaSymbol*) _tmp1126_);
									_tmp1128_ = _tmp1127_;
									access = _tmp1128_;
								} else {
									gboolean _tmp1129_ = FALSE;
									ValaProperty* _tmp1130_;
									ValaSymbolAccessibility _tmp1131_;
									ValaSymbolAccessibility _tmp1132_;
									_tmp1130_ = prop;
									_tmp1131_ = vala_symbol_get_access ((ValaSymbol*) _tmp1130_);
									_tmp1132_ = _tmp1131_;
									if (_tmp1132_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1133_;
										ValaPropertyAccessor* _tmp1134_;
										ValaPropertyAccessor* _tmp1135_;
										ValaSymbolAccessibility _tmp1136_;
										ValaSymbolAccessibility _tmp1137_;
										_tmp1133_ = prop;
										_tmp1134_ = vala_property_get_set_accessor (_tmp1133_);
										_tmp1135_ = _tmp1134_;
										_tmp1136_ = vala_symbol_get_access ((ValaSymbol*) _tmp1135_);
										_tmp1137_ = _tmp1136_;
										_tmp1129_ = _tmp1137_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1129_ = FALSE;
									}
									if (_tmp1129_) {
										ValaProperty* _tmp1138_;
										ValaPropertyAccessor* _tmp1139_;
										ValaPropertyAccessor* _tmp1140_;
										ValaSymbolAccessibility _tmp1141_;
										ValaSymbolAccessibility _tmp1142_;
										_tmp1138_ = prop;
										_tmp1139_ = vala_property_get_set_accessor (_tmp1138_);
										_tmp1140_ = _tmp1139_;
										_tmp1141_ = vala_symbol_get_access ((ValaSymbol*) _tmp1140_);
										_tmp1142_ = _tmp1141_;
										access = _tmp1142_;
									}
								}
							} else {
								ValaProperty* _tmp1143_;
								ValaPropertyAccessor* _tmp1144_;
								ValaPropertyAccessor* _tmp1145_;
								ValaProperty* _tmp1153_;
								ValaSymbolAccessibility _tmp1154_;
								ValaSymbolAccessibility _tmp1155_;
								_tmp1143_ = prop;
								_tmp1144_ = vala_property_get_get_accessor (_tmp1143_);
								_tmp1145_ = _tmp1144_;
								if (_tmp1145_ == NULL) {
									ValaSourceReference* _tmp1146_;
									ValaSourceReference* _tmp1147_;
									ValaProperty* _tmp1148_;
									gchar* _tmp1149_;
									gchar* _tmp1150_;
									gchar* _tmp1151_;
									gchar* _tmp1152_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1147_ = _tmp1146_;
									_tmp1148_ = prop;
									_tmp1149_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1148_);
									_tmp1150_ = _tmp1149_;
									_tmp1151_ = g_strdup_printf ("Property `%s' is write-only", _tmp1150_);
									_tmp1152_ = _tmp1151_;
									vala_report_error (_tmp1147_, _tmp1152_);
									_g_free0 (_tmp1152_);
									_g_free0 (_tmp1150_);
									result = FALSE;
									_vala_iterable_unref0 (visited_types);
									return result;
								}
								_tmp1153_ = prop;
								_tmp1154_ = vala_symbol_get_access ((ValaSymbol*) _tmp1153_);
								_tmp1155_ = _tmp1154_;
								if (_tmp1155_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1156_;
									ValaPropertyAccessor* _tmp1157_;
									ValaPropertyAccessor* _tmp1158_;
									ValaSymbolAccessibility _tmp1159_;
									ValaSymbolAccessibility _tmp1160_;
									_tmp1156_ = prop;
									_tmp1157_ = vala_property_get_get_accessor (_tmp1156_);
									_tmp1158_ = _tmp1157_;
									_tmp1159_ = vala_symbol_get_access ((ValaSymbol*) _tmp1158_);
									_tmp1160_ = _tmp1159_;
									access = _tmp1160_;
								} else {
									gboolean _tmp1161_ = FALSE;
									ValaProperty* _tmp1162_;
									ValaSymbolAccessibility _tmp1163_;
									ValaSymbolAccessibility _tmp1164_;
									_tmp1162_ = prop;
									_tmp1163_ = vala_symbol_get_access ((ValaSymbol*) _tmp1162_);
									_tmp1164_ = _tmp1163_;
									if (_tmp1164_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1165_;
										ValaPropertyAccessor* _tmp1166_;
										ValaPropertyAccessor* _tmp1167_;
										ValaSymbolAccessibility _tmp1168_;
										ValaSymbolAccessibility _tmp1169_;
										_tmp1165_ = prop;
										_tmp1166_ = vala_property_get_get_accessor (_tmp1165_);
										_tmp1167_ = _tmp1166_;
										_tmp1168_ = vala_symbol_get_access ((ValaSymbol*) _tmp1167_);
										_tmp1169_ = _tmp1168_;
										_tmp1161_ = _tmp1169_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1161_ = FALSE;
									}
									if (_tmp1161_) {
										ValaProperty* _tmp1170_;
										ValaPropertyAccessor* _tmp1171_;
										ValaPropertyAccessor* _tmp1172_;
										ValaSymbolAccessibility _tmp1173_;
										ValaSymbolAccessibility _tmp1174_;
										_tmp1170_ = prop;
										_tmp1171_ = vala_property_get_get_accessor (_tmp1170_);
										_tmp1172_ = _tmp1171_;
										_tmp1173_ = vala_symbol_get_access ((ValaSymbol*) _tmp1172_);
										_tmp1174_ = _tmp1173_;
										access = _tmp1174_;
									}
								}
							}
							_tmp1175_ = prop;
							_tmp1176_ = vala_property_get_binding (_tmp1175_);
							_tmp1177_ = _tmp1176_;
							instance = _tmp1177_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1178_ = prop;
							_tmp1179_ = vala_property_get_property_type (_tmp1178_);
							_tmp1180_ = _tmp1179_;
							if (VALA_IS_GENERIC_TYPE (_tmp1180_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1181_;
							_tmp1181_ = member;
							if (VALA_IS_SIGNAL (_tmp1181_)) {
								ValaSymbol* _tmp1182_;
								ValaSymbolAccessibility _tmp1183_;
								ValaSymbolAccessibility _tmp1184_;
								instance = TRUE;
								_tmp1182_ = member;
								_tmp1183_ = vala_symbol_get_access (_tmp1182_);
								_tmp1184_ = _tmp1183_;
								access = _tmp1184_;
							} else {
								gboolean _tmp1185_ = FALSE;
								gboolean _tmp1186_;
								_tmp1186_ = self->priv->_creation_member;
								if (!_tmp1186_) {
									ValaSymbol* _tmp1187_;
									_tmp1187_ = member;
									_tmp1185_ = VALA_IS_ERROR_CODE (_tmp1187_);
								} else {
									_tmp1185_ = FALSE;
								}
								if (_tmp1185_) {
									ValaSymbol* _tmp1188_;
									ValaConstant* _tmp1189_;
									ValaConstant* _tmp1190_;
									ValaSymbol* _tmp1191_;
									ValaSymbol* _tmp1192_;
									_tmp1188_ = member;
									_tmp1189_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1188_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1190_ = _tmp1189_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1190_);
									_tmp1191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1192_ = _tmp1191_;
									member = _tmp1192_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1193_;
		ValaSymbol* _tmp1194_;
		ValaCodeNode* _tmp1195_;
		ValaCodeNode* _tmp1196_;
		ValaCodeNode* _tmp1197_;
		gboolean _tmp1198_ = FALSE;
		ValaCodeNode* _tmp1199_;
		_tmp1193_ = parent;
		_tmp1194_ = member;
		if (!(_tmp1193_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1194_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1195_ = parent;
		_tmp1196_ = vala_code_node_get_parent_node (_tmp1195_);
		_tmp1197_ = _tmp1196_;
		parent = _tmp1197_;
		_tmp1199_ = parent;
		if (_tmp1199_ == NULL) {
			_tmp1198_ = TRUE;
		} else {
			ValaCodeNode* _tmp1200_;
			ValaSymbol* _tmp1201_;
			_tmp1200_ = parent;
			_tmp1201_ = member;
			_tmp1198_ = _tmp1200_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1201_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1198_) {
			break;
		}
	}
	_tmp1202_ = parent;
	_tmp1203_ = member;
	if (_tmp1202_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1203_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1204_;
		_tmp1204_ = member;
		vala_symbol_set_used (_tmp1204_, TRUE);
	}
	_tmp1205_ = member;
	_tmp1206_ = vala_symbol_get_version (_tmp1205_);
	_tmp1207_ = _tmp1206_;
	_tmp1208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1209_ = _tmp1208_;
	vala_version_attribute_check (_tmp1207_, context, _tmp1209_);
	_tmp1211_ = access;
	if (_tmp1211_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1212_;
		ValaSymbol* _tmp1213_;
		ValaSymbol* _tmp1214_;
		_tmp1212_ = member;
		_tmp1213_ = vala_symbol_get_parent_symbol (_tmp1212_);
		_tmp1214_ = _tmp1213_;
		_tmp1210_ = VALA_IS_TYPESYMBOL (_tmp1214_);
	} else {
		_tmp1210_ = FALSE;
	}
	if (_tmp1210_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1215_;
		ValaSymbol* _tmp1216_;
		ValaSymbol* _tmp1217_;
		gboolean in_subtype = FALSE;
		_tmp1215_ = member;
		_tmp1216_ = vala_symbol_get_parent_symbol (_tmp1215_);
		_tmp1217_ = _tmp1216_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1217_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1218_;
			ValaSemanticAnalyzer* _tmp1219_;
			ValaSymbol* _tmp1220_;
			ValaSymbol* _tmp1221_;
			ValaSymbol* _tmp1222_;
			_tmp1218_ = vala_code_context_get_analyzer (context);
			_tmp1219_ = _tmp1218_;
			_tmp1220_ = vala_semantic_analyzer_get_current_symbol (_tmp1219_);
			_tmp1221_ = _tmp1220_;
			_tmp1222_ = _vala_code_node_ref0 (_tmp1221_);
			this_symbol = _tmp1222_;
			{
				gboolean _tmp1223_ = FALSE;
				_tmp1223_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1228_;
					ValaSymbol* _tmp1229_;
					ValaTypeSymbol* _tmp1230_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1231_;
					gboolean _tmp1232_ = FALSE;
					ValaClass* _tmp1233_;
					if (!_tmp1223_) {
						ValaSymbol* _tmp1224_;
						ValaSymbol* _tmp1225_;
						ValaSymbol* _tmp1226_;
						ValaSymbol* _tmp1227_;
						_tmp1224_ = this_symbol;
						_tmp1225_ = vala_symbol_get_parent_symbol (_tmp1224_);
						_tmp1226_ = _tmp1225_;
						_tmp1227_ = _vala_code_node_ref0 (_tmp1226_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1227_;
					}
					_tmp1223_ = FALSE;
					_tmp1228_ = this_symbol;
					if (!(_tmp1228_ != NULL)) {
						break;
					}
					_tmp1229_ = this_symbol;
					_tmp1230_ = target_type;
					if (_tmp1229_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1230_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1231_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1231_) ? ((ValaClass*) _tmp1231_) : NULL;
					_tmp1233_ = cl;
					if (_tmp1233_ != NULL) {
						ValaClass* _tmp1234_;
						ValaTypeSymbol* _tmp1235_;
						_tmp1234_ = cl;
						_tmp1235_ = target_type;
						_tmp1232_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1234_, _tmp1235_);
					} else {
						_tmp1232_ = FALSE;
					}
					if (_tmp1232_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1236_;
			ValaSourceReference* _tmp1237_;
			ValaSymbol* _tmp1238_;
			gchar* _tmp1239_;
			gchar* _tmp1240_;
			gchar* _tmp1241_;
			gchar* _tmp1242_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = member;
			_tmp1239_ = vala_symbol_get_full_name (_tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1241_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1240_);
			_tmp1242_ = _tmp1241_;
			vala_report_error (_tmp1237_, _tmp1242_);
			_g_free0 (_tmp1242_);
			_g_free0 (_tmp1240_);
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1243_;
		_tmp1243_ = access;
		if (_tmp1243_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1244_;
			ValaSymbol* _tmp1245_;
			ValaSymbol* _tmp1246_;
			gboolean in_target_type = FALSE;
			_tmp1244_ = member;
			_tmp1245_ = vala_symbol_get_parent_symbol (_tmp1244_);
			_tmp1246_ = _tmp1245_;
			target_type = _tmp1246_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1247_;
				ValaSemanticAnalyzer* _tmp1248_;
				ValaSymbol* _tmp1249_;
				ValaSymbol* _tmp1250_;
				ValaSymbol* _tmp1251_;
				_tmp1247_ = vala_code_context_get_analyzer (context);
				_tmp1248_ = _tmp1247_;
				_tmp1249_ = vala_semantic_analyzer_get_current_symbol (_tmp1248_);
				_tmp1250_ = _tmp1249_;
				_tmp1251_ = _vala_code_node_ref0 (_tmp1250_);
				this_symbol = _tmp1251_;
				{
					gboolean _tmp1252_ = FALSE;
					_tmp1252_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1257_;
						ValaSymbol* _tmp1258_;
						ValaSymbol* _tmp1259_;
						if (!_tmp1252_) {
							ValaSymbol* _tmp1253_;
							ValaSymbol* _tmp1254_;
							ValaSymbol* _tmp1255_;
							ValaSymbol* _tmp1256_;
							_tmp1253_ = this_symbol;
							_tmp1254_ = vala_symbol_get_parent_symbol (_tmp1253_);
							_tmp1255_ = _tmp1254_;
							_tmp1256_ = _vala_code_node_ref0 (_tmp1255_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1256_;
						}
						_tmp1252_ = FALSE;
						_tmp1257_ = this_symbol;
						if (!(_tmp1257_ != NULL)) {
							break;
						}
						_tmp1258_ = target_type;
						_tmp1259_ = this_symbol;
						if (_tmp1258_ == _tmp1259_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1260_;
				ValaSourceReference* _tmp1261_;
				ValaSymbol* _tmp1262_;
				gchar* _tmp1263_;
				gchar* _tmp1264_;
				gchar* _tmp1265_;
				gchar* _tmp1266_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1261_ = _tmp1260_;
				_tmp1262_ = member;
				_tmp1263_ = vala_symbol_get_full_name (_tmp1262_);
				_tmp1264_ = _tmp1263_;
				_tmp1265_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1264_);
				_tmp1266_ = _tmp1265_;
				vala_report_error (_tmp1261_, _tmp1266_);
				_g_free0 (_tmp1266_);
				_g_free0 (_tmp1264_);
				result = FALSE;
				_vala_iterable_unref0 (visited_types);
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1268_;
		ValaExpression* _tmp1269_;
		_tmp1268_ = vala_member_access_get_inner (self);
		_tmp1269_ = _tmp1268_;
		_tmp1267_ = _tmp1269_ != NULL;
	} else {
		_tmp1267_ = FALSE;
	}
	if (_tmp1267_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1270_;
		ValaExpression* _tmp1271_;
		ValaDataType* _tmp1272_;
		ValaDataType* _tmp1273_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1274_;
		ValaExpression* _tmp1275_;
		ValaDataType* _tmp1276_;
		ValaDataType* _tmp1277_;
		ValaPointerType* _tmp1278_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1282_;
		gboolean _tmp1283_ = FALSE;
		gboolean _tmp1284_ = FALSE;
		ValaObjectType* _tmp1285_;
		_tmp1270_ = vala_member_access_get_inner (self);
		_tmp1271_ = _tmp1270_;
		_tmp1272_ = vala_expression_get_value_type (_tmp1271_);
		_tmp1273_ = _tmp1272_;
		instance_type = _tmp1273_;
		_tmp1274_ = vala_member_access_get_inner (self);
		_tmp1275_ = _tmp1274_;
		_tmp1276_ = vala_expression_get_value_type (_tmp1275_);
		_tmp1277_ = _tmp1276_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1277_) ? ((ValaPointerType*) _tmp1277_) : NULL;
		_tmp1278_ = pointer_type;
		if (_tmp1278_ != NULL) {
			ValaPointerType* _tmp1279_;
			ValaDataType* _tmp1280_;
			ValaDataType* _tmp1281_;
			_tmp1279_ = pointer_type;
			_tmp1280_ = vala_pointer_type_get_base_type (_tmp1279_);
			_tmp1281_ = _tmp1280_;
			instance_type = _tmp1281_;
		}
		_tmp1282_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1282_) ? ((ValaObjectType*) _tmp1282_) : NULL;
		_tmp1285_ = object_type;
		if (_tmp1285_ != NULL) {
			ValaObjectType* _tmp1286_;
			ValaObjectTypeSymbol* _tmp1287_;
			ValaObjectTypeSymbol* _tmp1288_;
			_tmp1286_ = object_type;
			_tmp1287_ = vala_object_type_get_object_type_symbol (_tmp1286_);
			_tmp1288_ = _tmp1287_;
			_tmp1284_ = vala_object_type_symbol_has_type_parameters (_tmp1288_);
		} else {
			_tmp1284_ = FALSE;
		}
		if (_tmp1284_) {
			ValaDataType* _tmp1289_;
			_tmp1289_ = instance_type;
			_tmp1283_ = !vala_data_type_has_type_arguments (_tmp1289_);
		} else {
			_tmp1283_ = FALSE;
		}
		if (_tmp1283_) {
			ValaExpression* _tmp1290_;
			ValaExpression* _tmp1291_;
			ValaSourceReference* _tmp1292_;
			ValaSourceReference* _tmp1293_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1290_ = vala_member_access_get_inner (self);
			_tmp1291_ = _tmp1290_;
			_tmp1292_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1291_);
			_tmp1293_ = _tmp1292_;
			vala_report_error (_tmp1293_, "missing generic type arguments");
			result = FALSE;
			_vala_iterable_unref0 (visited_types);
			return result;
		}
	}
	if (instance) {
		_tmp1295_ = !may_access_instance_members;
	} else {
		_tmp1295_ = FALSE;
	}
	if (_tmp1295_) {
		_tmp1294_ = TRUE;
	} else {
		gboolean _tmp1296_ = FALSE;
		if (klass) {
			_tmp1296_ = !may_access_klass_members;
		} else {
			_tmp1296_ = FALSE;
		}
		_tmp1294_ = _tmp1296_;
	}
	if (_tmp1294_) {
		ValaSymbol* _tmp1297_;
		ValaSymbol* _tmp1298_;
		ValaDataType* _tmp1321_;
		ValaDataType* _tmp1322_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1297_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1298_ = _tmp1297_;
		if (VALA_IS_METHOD (_tmp1298_)) {
			ValaSemanticAnalyzer* _tmp1299_;
			ValaSemanticAnalyzer* _tmp1300_;
			ValaSymbol* _tmp1301_;
			ValaSymbol* _tmp1302_;
			gboolean _tmp1303_;
			gboolean _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			_tmp1299_ = vala_code_context_get_analyzer (context);
			_tmp1300_ = _tmp1299_;
			_tmp1301_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1302_ = _tmp1301_;
			_tmp1303_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1304_ = _tmp1303_;
			_tmp1305_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1300_, _tmp1302_, _tmp1304_);
			_tmp1306_ = _tmp1305_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1306_);
			_vala_code_node_unref0 (_tmp1306_);
		} else {
			ValaSymbol* _tmp1307_;
			ValaSymbol* _tmp1308_;
			_tmp1307_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1308_ = _tmp1307_;
			if (VALA_IS_FIELD (_tmp1308_)) {
				ValaSymbol* _tmp1309_;
				ValaSymbol* _tmp1310_;
				ValaFieldPrototype* _tmp1311_;
				ValaFieldPrototype* _tmp1312_;
				_tmp1309_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1310_ = _tmp1309_;
				_tmp1311_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1310_, VALA_TYPE_FIELD, ValaField));
				_tmp1312_ = _tmp1311_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1312_);
				_vala_code_node_unref0 (_tmp1312_);
			} else {
				ValaSymbol* _tmp1313_;
				ValaSymbol* _tmp1314_;
				_tmp1313_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1314_ = _tmp1313_;
				if (VALA_IS_PROPERTY (_tmp1314_)) {
					ValaSymbol* _tmp1315_;
					ValaSymbol* _tmp1316_;
					ValaPropertyPrototype* _tmp1317_;
					ValaPropertyPrototype* _tmp1318_;
					_tmp1315_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1316_ = _tmp1315_;
					_tmp1317_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1316_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1318_ = _tmp1317_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1318_);
					_vala_code_node_unref0 (_tmp1318_);
				} else {
					ValaInvalidType* _tmp1319_;
					ValaInvalidType* _tmp1320_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1319_ = vala_invalid_type_new ();
					_tmp1320_ = _tmp1319_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1320_);
					_vala_code_node_unref0 (_tmp1320_);
				}
			}
		}
		_tmp1321_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1322_ = _tmp1321_;
		if (_tmp1322_ != NULL) {
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			ValaDataType* _tmp1325_;
			ValaDataType* _tmp1326_;
			gboolean _tmp1327_;
			gboolean _tmp1328_;
			_tmp1323_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1324_ = _tmp1323_;
			_tmp1325_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = vala_data_type_get_value_owned (_tmp1326_);
			_tmp1328_ = _tmp1327_;
			vala_data_type_set_value_owned (_tmp1324_, _tmp1328_);
		}
	} else {
		gboolean _tmp1329_ = FALSE;
		gboolean _tmp1350_ = FALSE;
		gboolean _tmp1351_ = FALSE;
		gboolean _tmp1352_ = FALSE;
		gboolean _tmp1353_ = FALSE;
		gboolean _tmp1395_ = FALSE;
		gboolean _tmp1396_ = FALSE;
		gboolean _tmp1397_ = FALSE;
		gboolean _tmp1398_ = FALSE;
		gboolean _tmp1399_ = FALSE;
		gboolean _tmp1400_;
		gboolean _tmp1401_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1428_;
		ValaSymbol* _tmp1429_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1430_;
		ValaExpression* _tmp1431_;
		gboolean _tmp1432_ = FALSE;
		gboolean _tmp1433_ = FALSE;
		gboolean _tmp1434_ = FALSE;
		gboolean _tmp1435_ = FALSE;
		gboolean _tmp1436_ = FALSE;
		ValaMethod* _tmp1437_;
		ValaSemanticAnalyzer* _tmp1476_;
		ValaSemanticAnalyzer* _tmp1477_;
		ValaSymbol* _tmp1478_;
		ValaSymbol* _tmp1479_;
		gboolean _tmp1480_;
		gboolean _tmp1481_;
		ValaDataType* _tmp1482_;
		ValaDataType* _tmp1483_;
		gboolean _tmp1484_ = FALSE;
		ValaExpression* _tmp1485_;
		ValaExpression* _tmp1486_;
		ValaSymbol* _tmp1499_;
		ValaSymbol* _tmp1500_;
		if (instance) {
			ValaExpression* _tmp1330_;
			ValaExpression* _tmp1331_;
			_tmp1330_ = vala_member_access_get_inner (self);
			_tmp1331_ = _tmp1330_;
			_tmp1329_ = _tmp1331_ == NULL;
		} else {
			_tmp1329_ = FALSE;
		}
		if (_tmp1329_) {
			ValaSourceReference* _tmp1332_;
			ValaSourceReference* _tmp1333_;
			ValaMemberAccess* _tmp1334_;
			ValaMemberAccess* _tmp1335_;
			ValaExpression* _tmp1336_;
			ValaExpression* _tmp1337_;
			ValaParameter* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaDataType* _tmp1340_;
			ValaDataType* _tmp1341_;
			ValaDataType* _tmp1342_;
			ValaExpression* _tmp1343_;
			ValaExpression* _tmp1344_;
			ValaDataType* _tmp1345_;
			ValaDataType* _tmp1346_;
			ValaExpression* _tmp1347_;
			ValaExpression* _tmp1348_;
			ValaParameter* _tmp1349_;
			_tmp1332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_member_access_new (NULL, "this", _tmp1333_);
			_tmp1335_ = _tmp1334_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1335_);
			_vala_code_node_unref0 (_tmp1335_);
			_tmp1336_ = vala_member_access_get_inner (self);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = this_parameter;
			_tmp1339_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1338_);
			_tmp1340_ = _tmp1339_;
			_tmp1341_ = vala_data_type_copy (_tmp1340_);
			_tmp1342_ = _tmp1341_;
			vala_expression_set_value_type (_tmp1337_, _tmp1342_);
			_vala_code_node_unref0 (_tmp1342_);
			_tmp1343_ = vala_member_access_get_inner (self);
			_tmp1344_ = _tmp1343_;
			_tmp1345_ = vala_expression_get_value_type (_tmp1344_);
			_tmp1346_ = _tmp1345_;
			vala_data_type_set_value_owned (_tmp1346_, FALSE);
			_tmp1347_ = vala_member_access_get_inner (self);
			_tmp1348_ = _tmp1347_;
			_tmp1349_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1348_, (ValaSymbol*) _tmp1349_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1353_ = !klass;
		} else {
			_tmp1353_ = FALSE;
		}
		if (_tmp1353_) {
			ValaSymbol* _tmp1354_;
			ValaSymbol* _tmp1355_;
			_tmp1354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1355_ = _tmp1354_;
			_tmp1352_ = !VALA_IS_CREATION_METHOD (_tmp1355_);
		} else {
			_tmp1352_ = FALSE;
		}
		if (_tmp1352_) {
			_tmp1351_ = may_access_instance_members;
		} else {
			_tmp1351_ = FALSE;
		}
		if (_tmp1351_) {
			ValaExpression* _tmp1356_;
			ValaExpression* _tmp1357_;
			_tmp1356_ = vala_member_access_get_inner (self);
			_tmp1357_ = _tmp1356_;
			_tmp1350_ = _tmp1357_ != NULL;
		} else {
			_tmp1350_ = FALSE;
		}
		if (_tmp1350_) {
			ValaExpression* _tmp1358_;
			ValaExpression* _tmp1359_;
			ValaSymbol* _tmp1360_;
			ValaSymbol* _tmp1361_;
			_tmp1358_ = vala_member_access_get_inner (self);
			_tmp1359_ = _tmp1358_;
			_tmp1360_ = vala_expression_get_symbol_reference (_tmp1359_);
			_tmp1361_ = _tmp1360_;
			if (VALA_IS_METHOD (_tmp1361_)) {
			} else {
				ValaSourceReference* _tmp1362_;
				ValaSourceReference* _tmp1363_;
				ValaSymbol* _tmp1364_;
				ValaSymbol* _tmp1365_;
				gchar* _tmp1366_;
				gchar* _tmp1367_;
				gchar* _tmp1368_;
				gchar* _tmp1369_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1370_;
				ValaSymbol* _tmp1371_;
				ValaSymbol* _tmp1372_;
				ValaSymbol* _tmp1373_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1393_;
				ValaExpression* _tmp1394_;
				_tmp1362_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1363_ = _tmp1362_;
				_tmp1364_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1365_ = _tmp1364_;
				_tmp1366_ = vala_symbol_get_full_name (_tmp1365_);
				_tmp1367_ = _tmp1366_;
				_tmp1368_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1367_);
				_tmp1369_ = _tmp1368_;
				vala_report_warning (_tmp1363_, _tmp1369_);
				_g_free0 (_tmp1369_);
				_g_free0 (_tmp1367_);
				_tmp1370_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1371_ = _tmp1370_;
				_tmp1372_ = vala_symbol_get_parent_symbol (_tmp1371_);
				_tmp1373_ = _tmp1372_;
				inner_sym = _tmp1373_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1374_ = FALSE;
					ValaSymbol* _tmp1375_;
					ValaMemberAccess* _tmp1379_;
					ValaSymbol* _tmp1380_;
					const gchar* _tmp1381_;
					const gchar* _tmp1382_;
					ValaSourceReference* _tmp1383_;
					ValaSourceReference* _tmp1384_;
					ValaMemberAccess* _tmp1385_;
					ValaMemberAccess* _tmp1386_;
					ValaMemberAccess* _tmp1387_;
					ValaExpression* _tmp1388_;
					ValaExpression* _tmp1389_;
					ValaSymbol* _tmp1390_;
					ValaSymbol* _tmp1391_;
					ValaSymbol* _tmp1392_;
					_tmp1375_ = inner_sym;
					if (_tmp1375_ != NULL) {
						ValaSymbol* _tmp1376_;
						const gchar* _tmp1377_;
						const gchar* _tmp1378_;
						_tmp1376_ = inner_sym;
						_tmp1377_ = vala_symbol_get_name (_tmp1376_);
						_tmp1378_ = _tmp1377_;
						_tmp1374_ = _tmp1378_ != NULL;
					} else {
						_tmp1374_ = FALSE;
					}
					if (!_tmp1374_) {
						break;
					}
					_tmp1379_ = inner_ma;
					_tmp1380_ = inner_sym;
					_tmp1381_ = vala_symbol_get_name (_tmp1380_);
					_tmp1382_ = _tmp1381_;
					_tmp1383_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1384_ = _tmp1383_;
					_tmp1385_ = vala_member_access_new (NULL, _tmp1382_, _tmp1384_);
					_tmp1386_ = _tmp1385_;
					vala_member_access_set_inner (_tmp1379_, (ValaExpression*) _tmp1386_);
					_vala_code_node_unref0 (_tmp1386_);
					_tmp1387_ = inner_ma;
					_tmp1388_ = vala_member_access_get_inner (_tmp1387_);
					_tmp1389_ = _tmp1388_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1389_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1390_ = inner_sym;
					_tmp1391_ = vala_symbol_get_parent_symbol (_tmp1390_);
					_tmp1392_ = _tmp1391_;
					inner_sym = _tmp1392_;
				}
				_tmp1393_ = vala_member_access_get_inner (self);
				_tmp1394_ = _tmp1393_;
				vala_code_node_check ((ValaCodeNode*) _tmp1394_, context);
			}
		}
		_tmp1400_ = vala_code_context_get_experimental_non_null (context);
		_tmp1401_ = _tmp1400_;
		if (_tmp1401_) {
			_tmp1399_ = instance;
		} else {
			_tmp1399_ = FALSE;
		}
		if (_tmp1399_) {
			ValaExpression* _tmp1402_;
			ValaExpression* _tmp1403_;
			ValaDataType* _tmp1404_;
			ValaDataType* _tmp1405_;
			gboolean _tmp1406_;
			gboolean _tmp1407_;
			_tmp1402_ = vala_member_access_get_inner (self);
			_tmp1403_ = _tmp1402_;
			_tmp1404_ = vala_expression_get_value_type (_tmp1403_);
			_tmp1405_ = _tmp1404_;
			_tmp1406_ = vala_data_type_get_nullable (_tmp1405_);
			_tmp1407_ = _tmp1406_;
			_tmp1398_ = _tmp1407_;
		} else {
			_tmp1398_ = FALSE;
		}
		if (_tmp1398_) {
			ValaExpression* _tmp1408_;
			ValaExpression* _tmp1409_;
			ValaDataType* _tmp1410_;
			ValaDataType* _tmp1411_;
			_tmp1408_ = vala_member_access_get_inner (self);
			_tmp1409_ = _tmp1408_;
			_tmp1410_ = vala_expression_get_value_type (_tmp1409_);
			_tmp1411_ = _tmp1410_;
			_tmp1397_ = !VALA_IS_POINTER_TYPE (_tmp1411_);
		} else {
			_tmp1397_ = FALSE;
		}
		if (_tmp1397_) {
			ValaExpression* _tmp1412_;
			ValaExpression* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			_tmp1412_ = vala_member_access_get_inner (self);
			_tmp1413_ = _tmp1412_;
			_tmp1414_ = vala_expression_get_value_type (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			_tmp1396_ = !VALA_IS_GENERIC_TYPE (_tmp1415_);
		} else {
			_tmp1396_ = FALSE;
		}
		if (_tmp1396_) {
			ValaExpression* _tmp1416_;
			ValaExpression* _tmp1417_;
			ValaDataType* _tmp1418_;
			ValaDataType* _tmp1419_;
			_tmp1416_ = vala_member_access_get_inner (self);
			_tmp1417_ = _tmp1416_;
			_tmp1418_ = vala_expression_get_value_type (_tmp1417_);
			_tmp1419_ = _tmp1418_;
			_tmp1395_ = !VALA_IS_ARRAY_TYPE (_tmp1419_);
		} else {
			_tmp1395_ = FALSE;
		}
		if (_tmp1395_) {
			ValaSourceReference* _tmp1420_;
			ValaSourceReference* _tmp1421_;
			ValaSymbol* _tmp1422_;
			ValaSymbol* _tmp1423_;
			gchar* _tmp1424_;
			gchar* _tmp1425_;
			gchar* _tmp1426_;
			gchar* _tmp1427_;
			_tmp1420_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1421_ = _tmp1420_;
			_tmp1422_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1423_ = _tmp1422_;
			_tmp1424_ = vala_symbol_get_full_name (_tmp1423_);
			_tmp1425_ = _tmp1424_;
			_tmp1426_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1425_);
			_tmp1427_ = _tmp1426_;
			vala_report_error (_tmp1421_, _tmp1427_);
			_g_free0 (_tmp1427_);
			_g_free0 (_tmp1425_);
		}
		_tmp1428_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1429_ = _tmp1428_;
		m = VALA_IS_METHOD (_tmp1429_) ? ((ValaMethod*) _tmp1429_) : NULL;
		_tmp1430_ = vala_member_access_get_inner (self);
		_tmp1431_ = _tmp1430_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1431_) ? ((ValaMemberAccess*) _tmp1431_) : NULL;
		_tmp1437_ = m;
		if (_tmp1437_ != NULL) {
			ValaMethod* _tmp1438_;
			ValaMemberBinding _tmp1439_;
			ValaMemberBinding _tmp1440_;
			_tmp1438_ = m;
			_tmp1439_ = vala_method_get_binding (_tmp1438_);
			_tmp1440_ = _tmp1439_;
			_tmp1436_ = _tmp1440_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1436_ = FALSE;
		}
		if (_tmp1436_) {
			ValaMethod* _tmp1441_;
			ValaSymbol* _tmp1442_;
			ValaSymbol* _tmp1443_;
			_tmp1441_ = m;
			_tmp1442_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1441_);
			_tmp1443_ = _tmp1442_;
			_tmp1435_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1443_);
		} else {
			_tmp1435_ = FALSE;
		}
		if (_tmp1435_) {
			ValaExpression* _tmp1444_;
			ValaExpression* _tmp1445_;
			_tmp1444_ = vala_member_access_get_inner (self);
			_tmp1445_ = _tmp1444_;
			_tmp1434_ = _tmp1445_ != NULL;
		} else {
			_tmp1434_ = FALSE;
		}
		if (_tmp1434_) {
			ValaExpression* _tmp1446_;
			ValaExpression* _tmp1447_;
			ValaDataType* _tmp1448_;
			ValaDataType* _tmp1449_;
			_tmp1446_ = vala_member_access_get_inner (self);
			_tmp1447_ = _tmp1446_;
			_tmp1448_ = vala_expression_get_value_type (_tmp1447_);
			_tmp1449_ = _tmp1448_;
			_tmp1433_ = _tmp1449_ == NULL;
		} else {
			_tmp1433_ = FALSE;
		}
		if (_tmp1433_) {
			ValaMemberAccess* _tmp1450_;
			ValaList* _tmp1451_;
			gint _tmp1452_;
			gint _tmp1453_;
			_tmp1450_ = inner_ma;
			_tmp1451_ = _tmp1450_->priv->type_argument_list;
			_tmp1452_ = vala_collection_get_size ((ValaCollection*) _tmp1451_);
			_tmp1453_ = _tmp1452_;
			_tmp1432_ = _tmp1453_ > 0;
		} else {
			_tmp1432_ = FALSE;
		}
		if (_tmp1432_) {
			ValaExpression* _tmp1454_;
			ValaExpression* _tmp1455_;
			ValaMethod* _tmp1456_;
			ValaSymbol* _tmp1457_;
			ValaSymbol* _tmp1458_;
			ValaObjectType* _tmp1459_;
			ValaObjectType* _tmp1460_;
			_tmp1454_ = vala_member_access_get_inner (self);
			_tmp1455_ = _tmp1454_;
			_tmp1456_ = m;
			_tmp1457_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1456_);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1458_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1460_ = _tmp1459_;
			vala_expression_set_value_type (_tmp1455_, (ValaDataType*) _tmp1460_);
			_vala_code_node_unref0 (_tmp1460_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1461_;
				ValaList* _tmp1462_;
				ValaList* _tmp1463_;
				gint _type_argument_size = 0;
				ValaList* _tmp1464_;
				gint _tmp1465_;
				gint _tmp1466_;
				gint _type_argument_index = 0;
				_tmp1461_ = inner_ma;
				_tmp1462_ = _tmp1461_->priv->type_argument_list;
				_tmp1463_ = _vala_iterable_ref0 (_tmp1462_);
				_type_argument_list = _tmp1463_;
				_tmp1464_ = _type_argument_list;
				_tmp1465_ = vala_collection_get_size ((ValaCollection*) _tmp1464_);
				_tmp1466_ = _tmp1465_;
				_type_argument_size = _tmp1466_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1467_;
					gint _tmp1468_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1469_;
					gpointer _tmp1470_;
					ValaExpression* _tmp1471_;
					ValaExpression* _tmp1472_;
					ValaDataType* _tmp1473_;
					ValaDataType* _tmp1474_;
					ValaDataType* _tmp1475_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1467_ = _type_argument_index;
					_tmp1468_ = _type_argument_size;
					if (!(_tmp1467_ < _tmp1468_)) {
						break;
					}
					_tmp1469_ = _type_argument_list;
					_tmp1470_ = vala_list_get (_tmp1469_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1470_;
					_tmp1471_ = vala_member_access_get_inner (self);
					_tmp1472_ = _tmp1471_;
					_tmp1473_ = vala_expression_get_value_type (_tmp1472_);
					_tmp1474_ = _tmp1473_;
					_tmp1475_ = type_argument;
					vala_data_type_add_type_argument (_tmp1474_, _tmp1475_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1476_ = vala_code_context_get_analyzer (context);
		_tmp1477_ = _tmp1476_;
		_tmp1478_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1479_ = _tmp1478_;
		_tmp1480_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1481_ = _tmp1480_;
		_tmp1482_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1477_, _tmp1479_, _tmp1481_);
		_tmp1483_ = _tmp1482_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1483_);
		_vala_code_node_unref0 (_tmp1483_);
		_tmp1485_ = vala_member_access_get_inner (self);
		_tmp1486_ = _tmp1485_;
		if (_tmp1486_ != NULL) {
			ValaDataType* _tmp1487_;
			ValaDataType* _tmp1488_;
			_tmp1487_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1488_ = _tmp1487_;
			_tmp1484_ = _tmp1488_ != NULL;
		} else {
			_tmp1484_ = FALSE;
		}
		if (_tmp1484_) {
			ValaDataType* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaExpression* _tmp1491_;
			ValaExpression* _tmp1492_;
			ValaDataType* _tmp1493_;
			ValaDataType* _tmp1494_;
			ValaDataType* _tmp1495_;
			ValaDataType* _tmp1496_;
			_tmp1489_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_member_access_get_inner (self);
			_tmp1492_ = _tmp1491_;
			_tmp1493_ = vala_expression_get_value_type (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			_tmp1495_ = vala_data_type_get_actual_type (_tmp1490_, _tmp1494_, NULL, (ValaCodeNode*) self);
			_tmp1496_ = _tmp1495_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1496_);
			_vala_code_node_unref0 (_tmp1496_);
		} else {
			ValaDataType* _tmp1497_;
			ValaDataType* _tmp1498_;
			_tmp1497_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1498_ = _tmp1497_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1498_);
		}
		_tmp1499_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1500_ = _tmp1499_;
		if (VALA_IS_METHOD (_tmp1500_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1501_;
			ValaSymbol* _tmp1502_;
			ValaDataType* _tmp1503_;
			ValaDataType* _tmp1504_;
			gboolean _tmp1511_ = FALSE;
			_tmp1501_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1502_ = _tmp1501_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1502_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1503_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1504_ = _tmp1503_;
			if (_tmp1504_ != NULL) {
				ValaDataType* _tmp1505_;
				ValaDataType* _tmp1506_;
				ValaDataType* _tmp1507_;
				ValaDataType* _tmp1508_;
				gboolean _tmp1509_;
				gboolean _tmp1510_;
				_tmp1505_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1506_ = _tmp1505_;
				_tmp1507_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1508_ = _tmp1507_;
				_tmp1509_ = vala_data_type_get_value_owned (_tmp1508_);
				_tmp1510_ = _tmp1509_;
				vala_data_type_set_value_owned (_tmp1506_, _tmp1510_);
			}
			if (instance) {
				ValaMethod* _tmp1512_;
				ValaSymbol* _tmp1513_;
				ValaSymbol* _tmp1514_;
				_tmp1512_ = method;
				_tmp1513_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1512_);
				_tmp1514_ = _tmp1513_;
				_tmp1511_ = VALA_IS_TYPESYMBOL (_tmp1514_);
			} else {
				_tmp1511_ = FALSE;
			}
			if (_tmp1511_) {
				ValaExpression* _tmp1515_;
				ValaExpression* _tmp1516_;
				ValaMethod* _tmp1517_;
				ValaSymbol* _tmp1518_;
				ValaSymbol* _tmp1519_;
				ValaDataType* _tmp1520_;
				ValaDataType* _tmp1521_;
				ValaExpression* _tmp1522_;
				ValaExpression* _tmp1523_;
				ValaDataType* _tmp1524_;
				ValaDataType* _tmp1525_;
				ValaMethod* _tmp1526_;
				ValaParameter* _tmp1527_;
				ValaParameter* _tmp1528_;
				ValaDataType* _tmp1529_;
				ValaDataType* _tmp1530_;
				gboolean _tmp1531_;
				gboolean _tmp1532_;
				_tmp1515_ = vala_member_access_get_inner (self);
				_tmp1516_ = _tmp1515_;
				_tmp1517_ = method;
				_tmp1518_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1517_);
				_tmp1519_ = _tmp1518_;
				_tmp1520_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1519_);
				_tmp1521_ = _tmp1520_;
				vala_expression_set_target_type (_tmp1516_, _tmp1521_);
				_vala_code_node_unref0 (_tmp1521_);
				_tmp1522_ = vala_member_access_get_inner (self);
				_tmp1523_ = _tmp1522_;
				_tmp1524_ = vala_expression_get_target_type (_tmp1523_);
				_tmp1525_ = _tmp1524_;
				_tmp1526_ = method;
				_tmp1527_ = vala_method_get_this_parameter (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1529_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1528_);
				_tmp1530_ = _tmp1529_;
				_tmp1531_ = vala_data_type_get_value_owned (_tmp1530_);
				_tmp1532_ = _tmp1531_;
				vala_data_type_set_value_owned (_tmp1525_, _tmp1532_);
			}
		} else {
			gboolean _tmp1533_ = FALSE;
			gboolean _tmp1534_ = FALSE;
			ValaSymbol* _tmp1535_;
			ValaSymbol* _tmp1536_;
			_tmp1535_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1536_ = _tmp1535_;
			if (VALA_IS_PROPERTY (_tmp1536_)) {
				_tmp1534_ = instance;
			} else {
				_tmp1534_ = FALSE;
			}
			if (_tmp1534_) {
				ValaSymbol* _tmp1537_;
				ValaSymbol* _tmp1538_;
				ValaSymbol* _tmp1539_;
				ValaSymbol* _tmp1540_;
				_tmp1537_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1538_ = _tmp1537_;
				_tmp1539_ = vala_symbol_get_parent_symbol (_tmp1538_);
				_tmp1540_ = _tmp1539_;
				_tmp1533_ = _tmp1540_ != NULL;
			} else {
				_tmp1533_ = FALSE;
			}
			if (_tmp1533_) {
				ValaExpression* _tmp1541_;
				ValaExpression* _tmp1542_;
				ValaSymbol* _tmp1543_;
				ValaSymbol* _tmp1544_;
				ValaSymbol* _tmp1545_;
				ValaSymbol* _tmp1546_;
				ValaDataType* _tmp1547_;
				ValaDataType* _tmp1548_;
				_tmp1541_ = vala_member_access_get_inner (self);
				_tmp1542_ = _tmp1541_;
				_tmp1543_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1544_ = _tmp1543_;
				_tmp1545_ = vala_symbol_get_parent_symbol (_tmp1544_);
				_tmp1546_ = _tmp1545_;
				_tmp1547_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1546_);
				_tmp1548_ = _tmp1547_;
				vala_expression_set_target_type (_tmp1542_, _tmp1548_);
				_vala_code_node_unref0 (_tmp1548_);
			} else {
				gboolean _tmp1549_ = FALSE;
				gboolean _tmp1550_ = FALSE;
				gboolean _tmp1551_ = FALSE;
				ValaSymbol* _tmp1552_;
				ValaSymbol* _tmp1553_;
				_tmp1552_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1553_ = _tmp1552_;
				if (VALA_IS_FIELD (_tmp1553_)) {
					_tmp1551_ = TRUE;
				} else {
					ValaSymbol* _tmp1554_;
					ValaSymbol* _tmp1555_;
					_tmp1554_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1555_ = _tmp1554_;
					_tmp1551_ = VALA_IS_SIGNAL (_tmp1555_);
				}
				if (_tmp1551_) {
					_tmp1550_ = instance;
				} else {
					_tmp1550_ = FALSE;
				}
				if (_tmp1550_) {
					ValaSymbol* _tmp1556_;
					ValaSymbol* _tmp1557_;
					ValaSymbol* _tmp1558_;
					ValaSymbol* _tmp1559_;
					_tmp1556_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1557_ = _tmp1556_;
					_tmp1558_ = vala_symbol_get_parent_symbol (_tmp1557_);
					_tmp1559_ = _tmp1558_;
					_tmp1549_ = _tmp1559_ != NULL;
				} else {
					_tmp1549_ = FALSE;
				}
				if (_tmp1549_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1560_;
					ValaSymbol* _tmp1561_;
					ValaSymbol* _tmp1562_;
					ValaSymbol* _tmp1563_;
					ValaDataType* _tmp1564_;
					ValaExpression* _tmp1565_;
					ValaExpression* _tmp1566_;
					ValaDataType* _tmp1567_;
					ValaExpression* _tmp1568_;
					ValaExpression* _tmp1569_;
					ValaDataType* _tmp1570_;
					ValaDataType* _tmp1571_;
					ValaDataType* _tmp1572_;
					ValaDataType* _tmp1573_;
					_tmp1560_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1561_ = _tmp1560_;
					_tmp1562_ = vala_symbol_get_parent_symbol (_tmp1561_);
					_tmp1563_ = _tmp1562_;
					_tmp1564_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1563_);
					parent_type = _tmp1564_;
					_tmp1565_ = vala_member_access_get_inner (self);
					_tmp1566_ = _tmp1565_;
					_tmp1567_ = parent_type;
					_tmp1568_ = vala_member_access_get_inner (self);
					_tmp1569_ = _tmp1568_;
					_tmp1570_ = vala_expression_get_value_type (_tmp1569_);
					_tmp1571_ = _tmp1570_;
					_tmp1572_ = vala_data_type_get_actual_type (_tmp1567_, _tmp1571_, NULL, (ValaCodeNode*) self);
					_tmp1573_ = _tmp1572_;
					vala_expression_set_target_type (_tmp1566_, _tmp1573_);
					_vala_code_node_unref0 (_tmp1573_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1574_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1575_ = _tmp1574_;
	if (_tmp1575_ != NULL) {
		ValaDataType* _tmp1576_;
		ValaDataType* _tmp1577_;
		_tmp1576_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1577_ = _tmp1576_;
		vala_code_node_check ((ValaCodeNode*) _tmp1577_, context);
	}
	_tmp1578_ = self->priv->_tainted_access;
	if (!_tmp1578_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1579_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1580_ = _tmp1579_;
	result = !_tmp1580_;
	_vala_iterable_unref0 (visited_types);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

