/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaAssignment_private_offset;
static gpointer vala_assignment_parent_class = NULL;

static void vala_assignment_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gchar* vala_assignment_real_to_string (ValaCodeNode* base);
static void vala_assignment_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base,
                                             ValaSymbol* sym);
static void vala_assignment_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference);
static gboolean vala_assignment_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_assignment_check_constant_assignment (ValaAssignment* self,
                                                ValaMemberAccess* inner);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);
static GType vala_assignment_get_type_once (void);

static inline gpointer
vala_assignment_get_instance_private (ValaAssignment* self)
{
	return G_STRUCT_MEMBER_P (self, ValaAssignment_private_offset);
}

ValaExpression*
vala_assignment_get_left (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_assignment_set_left (ValaAssignment* self,
                          ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaAssignmentOperator
vala_assignment_get_operator (ValaAssignment* self)
{
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_operator (ValaAssignment* self,
                              ValaAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_assignment_get_right (ValaAssignment* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_assignment_set_right (ValaAssignment* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment*
vala_assignment_construct (GType object_type,
                           ValaExpression* left,
                           ValaExpression* right,
                           ValaAssignmentOperator operator,
                           ValaSourceReference* source_reference)
{
	ValaAssignment* self = NULL;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	vala_assignment_set_right (self, right);
	vala_assignment_set_operator (self, operator);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_assignment_set_left (self, left);
	return self;
}

ValaAssignment*
vala_assignment_new (ValaExpression* left,
                     ValaExpression* right,
                     ValaAssignmentOperator operator,
                     ValaSourceReference* source_reference)
{
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}

static void
vala_assignment_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_assignment (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_assignment_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static gchar*
vala_assignment_real_to_string (ValaCodeNode* base)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaAssignmentOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result = NULL;
	self = (ValaAssignment*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_assignment_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static void
vala_assignment_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_assignment_set_left (self, new_node);
	}
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_assignment_set_right (self, new_node);
	}
}

static gboolean
vala_assignment_real_is_pure (ValaExpression* base)
{
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_assignment_real_is_accessible (ValaExpression* base,
                                    ValaSymbol* sym)
{
	ValaAssignment * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_assignment_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_assignment_real_get_error_types (ValaCodeNode* base,
                                      ValaCollection* collection,
                                      ValaSourceReference* source_reference)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_assignment_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_assignment_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaAssignment * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	ValaExpression* _tmp93_;
	ValaExpression* _tmp94_;
	ValaExpression* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp238_;
	ValaExpression* _tmp239_;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	gboolean _tmp242_ = FALSE;
	gboolean _tmp243_ = FALSE;
	ValaAssignmentOperator _tmp244_;
	ValaMemberAccess* _tmp291_;
	ValaExpression* _tmp648_;
	ValaExpression* _tmp649_;
	ValaDataType* _tmp650_;
	ValaDataType* _tmp651_;
	ValaDataType* _tmp660_;
	ValaDataType* _tmp661_;
	gboolean _tmp664_;
	gboolean _tmp665_;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (VALA_IS_TUPLE (_tmp7_)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_EXPRESSION_STATEMENT (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaSemanticAnalyzer* _tmp28_;
		ValaBlock* _tmp29_;
		ValaDeclarationStatement* _tmp30_;
		ValaDeclarationStatement* _tmp31_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaSemanticAnalyzer* _tmp80_;
		ValaSemanticAnalyzer* _tmp81_;
		ValaList* _tmp82_;
		ValaCodeNode* _tmp83_;
		ValaCodeNode* _tmp84_;
		ValaExpressionStatement* _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaExpressionStatement* _tmp88_;
		ValaExpression* _tmp89_;
		ValaExpression* _tmp90_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		tuple = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple);
		_tmp13_ = vala_code_node_get_temp_name ();
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_assignment_get_right (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_assignment_get_right (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (NULL, _tmp14_, _tmp16_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp14_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = vala_code_context_get_analyzer (context);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_->insert_block;
		_tmp30_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp29_, (ValaStatement*) _tmp30_);
		_tmp31_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, context);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp32_;
			ValaList* _tmp33_;
			ValaList* _tmp34_;
			gint _expr_size = 0;
			ValaList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _expr_index = 0;
			_tmp32_ = tuple;
			_tmp33_ = vala_tuple_get_expressions (_tmp32_);
			_tmp34_ = _vala_iterable_ref0 (_tmp33_);
			_expr_list = _tmp34_;
			_tmp35_ = _expr_list;
			_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_expr_size = _tmp37_;
			_expr_index = -1;
			while (TRUE) {
				ValaExpression* expr = NULL;
				ValaList* _tmp38_;
				gpointer _tmp39_;
				ValaExpressionStatement* _tmp40_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ValaExpression* _tmp49_;
				ValaExpression* _tmp50_;
				ValaSourceReference* _tmp51_;
				ValaSourceReference* _tmp52_;
				ValaMemberAccess* _tmp53_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaElementAccess* _tmp58_;
				ValaElementAccess* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaExpression* _tmp62_;
				ValaSourceReference* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaIntegerLiteral* _tmp65_;
				ValaIntegerLiteral* _tmp66_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp67_;
				ValaElementAccess* _tmp68_;
				ValaAssignmentOperator _tmp69_;
				ValaExpression* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaAssignment* _tmp73_;
				ValaAssignment* _tmp74_;
				ValaExpression* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaExpressionStatement* _tmp78_;
				gint _tmp79_;
				_expr_index = _expr_index + 1;
				if (!(_expr_index < _expr_size)) {
					break;
				}
				_tmp38_ = _expr_list;
				_tmp39_ = vala_list_get (_tmp38_, _expr_index);
				expr = (ValaExpression*) _tmp39_;
				_tmp40_ = stmt;
				if (_tmp40_ != NULL) {
					ValaSemanticAnalyzer* _tmp41_;
					ValaSemanticAnalyzer* _tmp42_;
					ValaBlock* _tmp43_;
					ValaExpressionStatement* _tmp44_;
					ValaExpressionStatement* _tmp45_;
					_tmp41_ = vala_code_context_get_analyzer (context);
					_tmp42_ = _tmp41_;
					_tmp43_ = _tmp42_->insert_block;
					_tmp44_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp43_, (ValaStatement*) _tmp44_);
					_tmp45_ = stmt;
					vala_code_node_check ((ValaCodeNode*) _tmp45_, context);
				}
				_tmp46_ = local;
				_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = vala_assignment_get_right (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_member_access_new_simple (_tmp48_, _tmp52_);
				temp_access = _tmp53_;
				_tmp54_ = temp_access;
				_tmp55_ = expr;
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = vala_element_access_new ((ValaExpression*) _tmp54_, _tmp57_);
				ea = _tmp58_;
				_tmp59_ = ea;
				_tmp60_ = g_strdup_printf ("%i", i);
				_tmp61_ = _tmp60_;
				_tmp62_ = expr;
				_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_integer_literal_new (_tmp61_, _tmp64_);
				_tmp66_ = _tmp65_;
				vala_element_access_append_index (_tmp59_, (ValaExpression*) _tmp66_);
				_vala_code_node_unref0 (_tmp66_);
				_g_free0 (_tmp61_);
				_tmp67_ = expr;
				_tmp68_ = ea;
				_tmp69_ = self->priv->_operator;
				_tmp70_ = expr;
				_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = vala_assignment_new (_tmp67_, (ValaExpression*) _tmp68_, _tmp69_, _tmp72_);
				assign = _tmp73_;
				_tmp74_ = assign;
				_tmp75_ = expr;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_expression_statement_new ((ValaExpression*) _tmp74_, _tmp77_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp78_;
				_tmp79_ = i;
				i = _tmp79_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp80_ = vala_code_context_get_analyzer (context);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp82_, (ValaCodeNode*) self);
		_tmp83_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = stmt;
		_tmp86_ = vala_expression_statement_get_expression (_tmp85_);
		_tmp87_ = _tmp86_;
		vala_code_node_replace_expression (_tmp84_, (ValaExpression*) self, _tmp87_);
		_tmp88_ = stmt;
		_tmp89_ = vala_expression_statement_get_expression (_tmp88_);
		_tmp90_ = _tmp89_;
		result = vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp91_ = vala_assignment_get_left (self);
	_tmp92_ = _tmp91_;
	vala_expression_set_lvalue (_tmp92_, TRUE);
	_tmp93_ = vala_assignment_get_left (self);
	_tmp94_ = _tmp93_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp94_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp95_ = vala_assignment_get_left (self);
	_tmp96_ = _tmp95_;
	if (VALA_IS_MEMBER_ACCESS (_tmp96_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaMemberAccess* _tmp99_;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		ValaMemberAccess* _tmp102_;
		ValaSymbol* _tmp103_;
		ValaSymbol* _tmp104_;
		ValaMemberAccess* _tmp120_;
		gboolean _tmp121_;
		gboolean _tmp122_;
		gboolean _tmp132_ = FALSE;
		ValaMemberAccess* _tmp133_;
		gboolean _tmp134_;
		gboolean _tmp135_;
		ValaMemberAccess* _tmp139_;
		ValaSymbol* _tmp140_;
		ValaSymbol* _tmp141_;
		_tmp97_ = vala_assignment_get_left (self);
		_tmp98_ = _tmp97_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp99_ = ma;
		vala_assignment_check_constant_assignment (self, _tmp99_);
		_tmp102_ = ma;
		_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp102_);
		_tmp104_ = _tmp103_;
		if (!VALA_IS_DYNAMIC_PROPERTY (_tmp104_)) {
			ValaMemberAccess* _tmp105_;
			ValaDataType* _tmp106_;
			ValaDataType* _tmp107_;
			_tmp105_ = ma;
			_tmp106_ = vala_expression_get_value_type ((ValaExpression*) _tmp105_);
			_tmp107_ = _tmp106_;
			_tmp101_ = _tmp107_ == NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			_tmp100_ = TRUE;
		} else {
			gboolean _tmp108_ = FALSE;
			gboolean _tmp109_ = FALSE;
			ValaMemberAccess* _tmp110_;
			ValaExpression* _tmp111_;
			ValaExpression* _tmp112_;
			_tmp110_ = ma;
			_tmp111_ = vala_member_access_get_inner (_tmp110_);
			_tmp112_ = _tmp111_;
			if (_tmp112_ == NULL) {
				ValaMemberAccess* _tmp113_;
				const gchar* _tmp114_;
				const gchar* _tmp115_;
				_tmp113_ = ma;
				_tmp114_ = vala_member_access_get_member_name (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp109_ = g_strcmp0 (_tmp115_, "this") == 0;
			} else {
				_tmp109_ = FALSE;
			}
			if (_tmp109_) {
				ValaSemanticAnalyzer* _tmp116_;
				ValaSemanticAnalyzer* _tmp117_;
				_tmp116_ = vala_code_context_get_analyzer (context);
				_tmp117_ = _tmp116_;
				_tmp108_ = vala_semantic_analyzer_is_in_instance_method (_tmp117_);
			} else {
				_tmp108_ = FALSE;
			}
			_tmp100_ = _tmp108_;
		}
		if (_tmp100_) {
			ValaSourceReference* _tmp118_;
			ValaSourceReference* _tmp119_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp119_ = _tmp118_;
			vala_report_error (_tmp119_, "unsupported lvalue in assignment");
			result = FALSE;
			return result;
		}
		_tmp120_ = ma;
		_tmp121_ = vala_member_access_get_prototype_access (_tmp120_);
		_tmp122_ = _tmp121_;
		if (_tmp122_) {
			ValaSourceReference* _tmp123_;
			ValaSourceReference* _tmp124_;
			ValaMemberAccess* _tmp125_;
			ValaSymbol* _tmp126_;
			ValaSymbol* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp123_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp124_ = _tmp123_;
			_tmp125_ = ma;
			_tmp126_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_symbol_get_full_name (_tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp129_);
			_tmp131_ = _tmp130_;
			vala_report_error (_tmp124_, _tmp131_);
			_g_free0 (_tmp131_);
			_g_free0 (_tmp129_);
			result = FALSE;
			return result;
		}
		_tmp133_ = ma;
		_tmp134_ = vala_code_node_get_error ((ValaCodeNode*) _tmp133_);
		_tmp135_ = _tmp134_;
		if (_tmp135_) {
			_tmp132_ = TRUE;
		} else {
			ValaMemberAccess* _tmp136_;
			ValaSymbol* _tmp137_;
			ValaSymbol* _tmp138_;
			_tmp136_ = ma;
			_tmp137_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp136_);
			_tmp138_ = _tmp137_;
			_tmp132_ = _tmp138_ == NULL;
		}
		if (_tmp132_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp139_ = ma;
		_tmp140_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp139_);
		_tmp141_ = _tmp140_;
		if (VALA_IS_DYNAMIC_PROPERTY (_tmp141_)) {
		} else {
			ValaExpression* _tmp142_;
			ValaExpression* _tmp143_;
			ValaMemberAccess* _tmp144_;
			ValaDataType* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaExpression* _tmp149_;
			ValaExpression* _tmp150_;
			ValaMemberAccess* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			ValaDataType* _tmp155_;
			_tmp142_ = vala_assignment_get_right (self);
			_tmp143_ = _tmp142_;
			_tmp144_ = ma;
			_tmp145_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_data_type_copy (_tmp146_);
			_tmp148_ = _tmp147_;
			vala_expression_set_formal_target_type (_tmp143_, _tmp148_);
			_vala_code_node_unref0 (_tmp148_);
			_tmp149_ = vala_assignment_get_right (self);
			_tmp150_ = _tmp149_;
			_tmp151_ = ma;
			_tmp152_ = vala_expression_get_value_type ((ValaExpression*) _tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_copy (_tmp153_);
			_tmp155_ = _tmp154_;
			vala_expression_set_target_type (_tmp150_, _tmp155_);
			_vala_code_node_unref0 (_tmp155_);
		}
	} else {
		ValaExpression* _tmp156_;
		ValaExpression* _tmp157_;
		_tmp156_ = vala_assignment_get_left (self);
		_tmp157_ = _tmp156_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp157_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp158_;
			ValaExpression* _tmp159_;
			ValaElementAccess* _tmp160_;
			ValaExpression* _tmp161_;
			ValaExpression* _tmp162_;
			ValaElementAccess* _tmp163_;
			ValaExpression* _tmp164_;
			ValaExpression* _tmp165_;
			ValaDataType* _tmp166_;
			ValaDataType* _tmp167_;
			ValaTypeSymbol* _tmp168_;
			ValaTypeSymbol* _tmp169_;
			ValaSemanticAnalyzer* _tmp170_;
			ValaSemanticAnalyzer* _tmp171_;
			ValaDataType* _tmp172_;
			ValaTypeSymbol* _tmp173_;
			ValaTypeSymbol* _tmp174_;
			_tmp158_ = vala_assignment_get_left (self);
			_tmp159_ = _tmp158_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp160_ = ea;
			_tmp161_ = vala_element_access_get_container (_tmp160_);
			_tmp162_ = _tmp161_;
			vala_assignment_check_constant_assignment (self, VALA_IS_MEMBER_ACCESS (_tmp162_) ? ((ValaMemberAccess*) _tmp162_) : NULL);
			_tmp163_ = ea;
			_tmp164_ = vala_element_access_get_container (_tmp163_);
			_tmp165_ = _tmp164_;
			_tmp166_ = vala_expression_get_value_type (_tmp165_);
			_tmp167_ = _tmp166_;
			_tmp168_ = vala_data_type_get_type_symbol (_tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_code_context_get_analyzer (context);
			_tmp171_ = _tmp170_;
			_tmp172_ = _tmp171_->string_type;
			_tmp173_ = vala_data_type_get_type_symbol (_tmp172_);
			_tmp174_ = _tmp173_;
			if (_tmp169_ == _tmp174_) {
				ValaElementAccess* _tmp175_;
				ValaSourceReference* _tmp176_;
				ValaSourceReference* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp175_ = ea;
				_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp177_, "strings are immutable");
				result = FALSE;
				return result;
			} else {
				ValaElementAccess* _tmp178_;
				ValaExpression* _tmp179_;
				ValaExpression* _tmp180_;
				ValaDataType* _tmp181_;
				ValaDataType* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaSymbol* _tmp184_;
				gboolean _tmp185_;
				_tmp178_ = ea;
				_tmp179_ = vala_element_access_get_container (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_expression_get_value_type (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = vala_data_type_get_member (_tmp182_, "set");
				_tmp184_ = _tmp183_;
				_tmp185_ = VALA_IS_METHOD (_tmp184_);
				_vala_code_node_unref0 (_tmp184_);
				if (_tmp185_) {
					ValaMethodCall* set_call = NULL;
					ValaElementAccess* _tmp186_;
					ValaExpression* _tmp187_;
					ValaExpression* _tmp188_;
					ValaSourceReference* _tmp189_;
					ValaSourceReference* _tmp190_;
					ValaMemberAccess* _tmp191_;
					ValaMemberAccess* _tmp192_;
					ValaSourceReference* _tmp193_;
					ValaSourceReference* _tmp194_;
					ValaMethodCall* _tmp195_;
					ValaMethodCall* _tmp196_;
					ValaMethodCall* _tmp207_;
					ValaExpression* _tmp208_;
					ValaExpression* _tmp209_;
					ValaCodeNode* _tmp210_;
					ValaCodeNode* _tmp211_;
					ValaMethodCall* _tmp212_;
					ValaMethodCall* _tmp213_;
					_tmp186_ = ea;
					_tmp187_ = vala_element_access_get_container (_tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp190_ = _tmp189_;
					_tmp191_ = vala_member_access_new (_tmp188_, "set", _tmp190_);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_method_call_new ((ValaExpression*) _tmp192_, _tmp194_);
					_tmp196_ = _tmp195_;
					_vala_code_node_unref0 (_tmp192_);
					set_call = _tmp196_;
					{
						ValaList* _e_list = NULL;
						ValaElementAccess* _tmp197_;
						ValaList* _tmp198_;
						ValaList* _tmp199_;
						gint _e_size = 0;
						ValaList* _tmp200_;
						gint _tmp201_;
						gint _tmp202_;
						gint _e_index = 0;
						_tmp197_ = ea;
						_tmp198_ = vala_element_access_get_indices (_tmp197_);
						_tmp199_ = _vala_iterable_ref0 (_tmp198_);
						_e_list = _tmp199_;
						_tmp200_ = _e_list;
						_tmp201_ = vala_collection_get_size ((ValaCollection*) _tmp200_);
						_tmp202_ = _tmp201_;
						_e_size = _tmp202_;
						_e_index = -1;
						while (TRUE) {
							ValaExpression* e = NULL;
							ValaList* _tmp203_;
							gpointer _tmp204_;
							ValaMethodCall* _tmp205_;
							ValaExpression* _tmp206_;
							_e_index = _e_index + 1;
							if (!(_e_index < _e_size)) {
								break;
							}
							_tmp203_ = _e_list;
							_tmp204_ = vala_list_get (_tmp203_, _e_index);
							e = (ValaExpression*) _tmp204_;
							_tmp205_ = set_call;
							_tmp206_ = e;
							vala_method_call_add_argument (_tmp205_, _tmp206_);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp207_ = set_call;
					_tmp208_ = vala_assignment_get_right (self);
					_tmp209_ = _tmp208_;
					vala_method_call_add_argument (_tmp207_, _tmp209_);
					_tmp210_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp211_ = _tmp210_;
					_tmp212_ = set_call;
					vala_code_node_replace_expression (_tmp211_, (ValaExpression*) self, (ValaExpression*) _tmp212_);
					_tmp213_ = set_call;
					result = vala_code_node_check ((ValaCodeNode*) _tmp213_, context);
					_vala_code_node_unref0 (set_call);
					return result;
				} else {
					ValaExpression* _tmp214_;
					ValaExpression* _tmp215_;
					ValaExpression* _tmp216_;
					ValaExpression* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					_tmp214_ = vala_assignment_get_right (self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_assignment_get_left (self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_expression_get_value_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_data_type_copy (_tmp219_);
					_tmp221_ = _tmp220_;
					vala_expression_set_target_type (_tmp215_, _tmp221_);
					_vala_code_node_unref0 (_tmp221_);
				}
			}
		} else {
			ValaExpression* _tmp222_;
			ValaExpression* _tmp223_;
			_tmp222_ = vala_assignment_get_left (self);
			_tmp223_ = _tmp222_;
			if (VALA_IS_POINTER_INDIRECTION (_tmp223_)) {
				ValaExpression* _tmp224_;
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				ValaExpression* _tmp227_;
				ValaDataType* _tmp228_;
				ValaDataType* _tmp229_;
				ValaDataType* _tmp230_;
				ValaDataType* _tmp231_;
				_tmp224_ = vala_assignment_get_right (self);
				_tmp225_ = _tmp224_;
				_tmp226_ = vala_assignment_get_left (self);
				_tmp227_ = _tmp226_;
				_tmp228_ = vala_expression_get_value_type (_tmp227_);
				_tmp229_ = _tmp228_;
				_tmp230_ = vala_data_type_copy (_tmp229_);
				_tmp231_ = _tmp230_;
				vala_expression_set_target_type (_tmp225_, _tmp231_);
				_vala_code_node_unref0 (_tmp231_);
			} else {
				ValaExpression* _tmp232_;
				ValaExpression* _tmp233_;
				_tmp232_ = vala_assignment_get_left (self);
				_tmp233_ = _tmp232_;
				if (VALA_IS_LITERAL (_tmp233_)) {
					ValaSourceReference* _tmp234_;
					ValaSourceReference* _tmp235_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp235_ = _tmp234_;
					vala_report_error (_tmp235_, "Literals are immutable");
					result = FALSE;
					return result;
				} else {
					ValaSourceReference* _tmp236_;
					ValaSourceReference* _tmp237_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp237_ = _tmp236_;
					vala_report_error (_tmp237_, "unsupported lvalue in assignment");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp238_ = vala_assignment_get_right (self);
	_tmp239_ = _tmp238_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp239_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp240_ = vala_assignment_get_left (self);
	_tmp241_ = _tmp240_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp241_) ? ((ValaMemberAccess*) _tmp241_) : NULL;
	_tmp244_ = self->priv->_operator;
	if (_tmp244_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaMemberAccess* _tmp245_;
		_tmp245_ = ma;
		_tmp243_ = _tmp245_ != NULL;
	} else {
		_tmp243_ = FALSE;
	}
	if (_tmp243_) {
		gboolean _tmp246_ = FALSE;
		ValaExpression* _tmp247_;
		ValaExpression* _tmp248_;
		ValaDataType* _tmp249_;
		ValaDataType* _tmp250_;
		_tmp247_ = vala_assignment_get_left (self);
		_tmp248_ = _tmp247_;
		_tmp249_ = vala_expression_get_value_type (_tmp248_);
		_tmp250_ = _tmp249_;
		if (vala_data_type_is_non_null_simple_type (_tmp250_)) {
			ValaMemberAccess* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			_tmp251_ = ma;
			_tmp252_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp251_);
			_tmp253_ = _tmp252_;
			_tmp246_ = VALA_IS_LOCAL_VARIABLE (_tmp253_);
		} else {
			_tmp246_ = FALSE;
		}
		_tmp242_ = !_tmp246_;
	} else {
		_tmp242_ = FALSE;
	}
	if (_tmp242_) {
		ValaMemberAccess* old_value = NULL;
		ValaMemberAccess* _tmp254_;
		ValaExpression* _tmp255_;
		ValaExpression* _tmp256_;
		ValaMemberAccess* _tmp257_;
		const gchar* _tmp258_;
		const gchar* _tmp259_;
		ValaMemberAccess* _tmp260_;
		ValaBinaryOperator bop = 0;
		ValaAssignmentOperator _tmp261_;
		ValaBinaryExpression* bin = NULL;
		ValaBinaryOperator _tmp264_;
		ValaMemberAccess* _tmp265_;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaBinaryExpression* _tmp270_;
		ValaBinaryExpression* _tmp271_;
		ValaExpression* _tmp272_;
		ValaExpression* _tmp273_;
		ValaDataType* _tmp274_;
		ValaDataType* _tmp275_;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaExpression* _tmp278_;
		ValaExpression* _tmp279_;
		ValaDataType* _tmp280_;
		ValaDataType* _tmp281_;
		ValaDataType* _tmp282_;
		ValaDataType* _tmp283_;
		ValaExpression* _tmp284_;
		ValaExpression* _tmp285_;
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		ValaBinaryExpression* _tmp288_;
		ValaExpression* _tmp289_;
		ValaExpression* _tmp290_;
		_tmp254_ = ma;
		_tmp255_ = vala_member_access_get_inner (_tmp254_);
		_tmp256_ = _tmp255_;
		_tmp257_ = ma;
		_tmp258_ = vala_member_access_get_member_name (_tmp257_);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_member_access_new (_tmp256_, _tmp259_, NULL);
		old_value = _tmp260_;
		_tmp261_ = self->priv->_operator;
		switch (_tmp261_) {
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_OR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_AND;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
			{
				bop = VALA_BINARY_OPERATOR_BITWISE_XOR;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_ADD:
			{
				bop = VALA_BINARY_OPERATOR_PLUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SUB:
			{
				bop = VALA_BINARY_OPERATOR_MINUS;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_MUL:
			{
				bop = VALA_BINARY_OPERATOR_MUL;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_DIV:
			{
				bop = VALA_BINARY_OPERATOR_DIV;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_PERCENT:
			{
				bop = VALA_BINARY_OPERATOR_MOD;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_LEFT;
				break;
			}
			case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
			{
				bop = VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				break;
			}
			default:
			{
				ValaSourceReference* _tmp262_;
				ValaSourceReference* _tmp263_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp262_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp263_ = _tmp262_;
				vala_report_error (_tmp263_, "internal error: unsupported assignment operator");
				result = FALSE;
				_vala_code_node_unref0 (old_value);
				return result;
			}
		}
		_tmp264_ = bop;
		_tmp265_ = old_value;
		_tmp266_ = vala_assignment_get_right (self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_binary_expression_new (_tmp264_, (ValaExpression*) _tmp265_, _tmp267_, _tmp269_);
		bin = _tmp270_;
		_tmp271_ = bin;
		_tmp272_ = vala_assignment_get_right (self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_expression_get_target_type (_tmp273_);
		_tmp275_ = _tmp274_;
		vala_expression_set_target_type ((ValaExpression*) _tmp271_, _tmp275_);
		_tmp276_ = vala_assignment_get_right (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_assignment_get_right (self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_expression_get_target_type (_tmp279_);
		_tmp281_ = _tmp280_;
		_tmp282_ = vala_data_type_copy (_tmp281_);
		_tmp283_ = _tmp282_;
		vala_expression_set_target_type (_tmp277_, _tmp283_);
		_vala_code_node_unref0 (_tmp283_);
		_tmp284_ = vala_assignment_get_right (self);
		_tmp285_ = _tmp284_;
		_tmp286_ = vala_expression_get_target_type (_tmp285_);
		_tmp287_ = _tmp286_;
		vala_data_type_set_value_owned (_tmp287_, FALSE);
		_tmp288_ = bin;
		vala_assignment_set_right (self, (ValaExpression*) _tmp288_);
		_tmp289_ = vala_assignment_get_right (self);
		_tmp290_ = _tmp289_;
		vala_code_node_check ((ValaCodeNode*) _tmp290_, context);
		vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
		_vala_code_node_unref0 (bin);
		_vala_code_node_unref0 (old_value);
	}
	_tmp291_ = ma;
	if (_tmp291_ != NULL) {
		ValaMemberAccess* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		gboolean _tmp461_ = FALSE;
		ValaExpression* _tmp462_;
		ValaExpression* _tmp463_;
		ValaDataType* _tmp464_;
		ValaDataType* _tmp465_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp520_;
		ValaExpression* _tmp521_;
		gboolean _tmp522_ = FALSE;
		ValaMemberAccess* _tmp523_;
		_tmp292_ = ma;
		_tmp293_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp292_);
		_tmp294_ = _tmp293_;
		if (VALA_IS_PROPERTY (_tmp294_)) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp295_;
			ValaSymbol* _tmp296_;
			ValaSymbol* _tmp297_;
			ValaDynamicProperty* dynamic_prop = NULL;
			ValaProperty* _tmp298_;
			ValaDynamicProperty* _tmp299_;
			gboolean _tmp314_ = FALSE;
			ValaProperty* _tmp315_;
			ValaPropertyAccessor* _tmp316_;
			ValaPropertyAccessor* _tmp317_;
			_tmp295_ = ma;
			_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp295_);
			_tmp297_ = _tmp296_;
			prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_PROPERTY, ValaProperty);
			_tmp298_ = prop;
			dynamic_prop = VALA_IS_DYNAMIC_PROPERTY (_tmp298_) ? ((ValaDynamicProperty*) _tmp298_) : NULL;
			_tmp299_ = dynamic_prop;
			if (_tmp299_ != NULL) {
				ValaDynamicProperty* _tmp300_;
				ValaExpression* _tmp301_;
				ValaExpression* _tmp302_;
				ValaDataType* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				ValaDataType* _tmp306_;
				ValaExpression* _tmp307_;
				ValaExpression* _tmp308_;
				ValaDynamicProperty* _tmp309_;
				ValaDataType* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				ValaDataType* _tmp313_;
				_tmp300_ = dynamic_prop;
				_tmp301_ = vala_assignment_get_right (self);
				_tmp302_ = _tmp301_;
				_tmp303_ = vala_expression_get_value_type (_tmp302_);
				_tmp304_ = _tmp303_;
				_tmp305_ = vala_data_type_copy (_tmp304_);
				_tmp306_ = _tmp305_;
				vala_property_set_property_type ((ValaProperty*) _tmp300_, _tmp306_);
				_vala_code_node_unref0 (_tmp306_);
				_tmp307_ = vala_assignment_get_left (self);
				_tmp308_ = _tmp307_;
				_tmp309_ = dynamic_prop;
				_tmp310_ = vala_property_get_property_type ((ValaProperty*) _tmp309_);
				_tmp311_ = _tmp310_;
				_tmp312_ = vala_data_type_copy (_tmp311_);
				_tmp313_ = _tmp312_;
				vala_expression_set_value_type (_tmp308_, _tmp313_);
				_vala_code_node_unref0 (_tmp313_);
			}
			_tmp315_ = prop;
			_tmp316_ = vala_property_get_set_accessor (_tmp315_);
			_tmp317_ = _tmp316_;
			if (_tmp317_ == NULL) {
				_tmp314_ = TRUE;
			} else {
				gboolean _tmp318_ = FALSE;
				ValaProperty* _tmp319_;
				ValaPropertyAccessor* _tmp320_;
				ValaPropertyAccessor* _tmp321_;
				gboolean _tmp322_;
				gboolean _tmp323_;
				_tmp319_ = prop;
				_tmp320_ = vala_property_get_set_accessor (_tmp319_);
				_tmp321_ = _tmp320_;
				_tmp322_ = vala_property_accessor_get_writable (_tmp321_);
				_tmp323_ = _tmp322_;
				if (!_tmp323_) {
					gboolean _tmp324_ = FALSE;
					ValaSemanticAnalyzer* _tmp325_;
					ValaSemanticAnalyzer* _tmp326_;
					ValaMethod* _tmp327_;
					_tmp325_ = vala_code_context_get_analyzer (context);
					_tmp326_ = _tmp325_;
					_tmp327_ = vala_semantic_analyzer_find_current_method (_tmp326_);
					if (VALA_IS_CREATION_METHOD (_tmp327_)) {
						_tmp324_ = TRUE;
					} else {
						ValaSemanticAnalyzer* _tmp328_;
						ValaSemanticAnalyzer* _tmp329_;
						_tmp328_ = vala_code_context_get_analyzer (context);
						_tmp329_ = _tmp328_;
						_tmp324_ = vala_semantic_analyzer_is_in_constructor (_tmp329_);
					}
					_tmp318_ = !_tmp324_;
				} else {
					_tmp318_ = FALSE;
				}
				_tmp314_ = _tmp318_;
			}
			if (_tmp314_) {
				ValaMemberAccess* _tmp330_;
				ValaMemberAccess* _tmp331_;
				ValaSourceReference* _tmp332_;
				ValaSourceReference* _tmp333_;
				ValaProperty* _tmp334_;
				gchar* _tmp335_;
				gchar* _tmp336_;
				gchar* _tmp337_;
				gchar* _tmp338_;
				_tmp330_ = ma;
				vala_code_node_set_error ((ValaCodeNode*) _tmp330_, TRUE);
				_tmp331_ = ma;
				_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp331_);
				_tmp333_ = _tmp332_;
				_tmp334_ = prop;
				_tmp335_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp334_);
				_tmp336_ = _tmp335_;
				_tmp337_ = g_strdup_printf ("Property `%s' is read-only", _tmp336_);
				_tmp338_ = _tmp337_;
				vala_report_error (_tmp333_, _tmp338_);
				_g_free0 (_tmp338_);
				_g_free0 (_tmp336_);
				result = FALSE;
				return result;
			} else {
				gboolean _tmp339_ = FALSE;
				gboolean _tmp340_ = FALSE;
				gboolean _tmp341_;
				gboolean _tmp342_;
				_tmp341_ = vala_code_context_get_deprecated (context);
				_tmp342_ = _tmp341_;
				if (!_tmp342_) {
					ValaProperty* _tmp343_;
					ValaPropertyAccessor* _tmp344_;
					ValaPropertyAccessor* _tmp345_;
					gboolean _tmp346_;
					gboolean _tmp347_;
					_tmp343_ = prop;
					_tmp344_ = vala_property_get_set_accessor (_tmp343_);
					_tmp345_ = _tmp344_;
					_tmp346_ = vala_property_accessor_get_writable (_tmp345_);
					_tmp347_ = _tmp346_;
					_tmp340_ = !_tmp347_;
				} else {
					_tmp340_ = FALSE;
				}
				if (_tmp340_) {
					ValaSemanticAnalyzer* _tmp348_;
					ValaSemanticAnalyzer* _tmp349_;
					ValaMethod* _tmp350_;
					_tmp348_ = vala_code_context_get_analyzer (context);
					_tmp349_ = _tmp348_;
					_tmp350_ = vala_semantic_analyzer_find_current_method (_tmp349_);
					_tmp339_ = VALA_IS_CREATION_METHOD (_tmp350_);
				} else {
					_tmp339_ = FALSE;
				}
				if (_tmp339_) {
					ValaMemberAccess* _tmp351_;
					ValaExpression* _tmp352_;
					ValaExpression* _tmp353_;
					ValaSymbol* _tmp354_;
					ValaSymbol* _tmp355_;
					ValaSemanticAnalyzer* _tmp356_;
					ValaSemanticAnalyzer* _tmp357_;
					ValaMethod* _tmp358_;
					ValaParameter* _tmp359_;
					ValaParameter* _tmp360_;
					_tmp351_ = ma;
					_tmp352_ = vala_member_access_get_inner (_tmp351_);
					_tmp353_ = _tmp352_;
					_tmp354_ = vala_expression_get_symbol_reference (_tmp353_);
					_tmp355_ = _tmp354_;
					_tmp356_ = vala_code_context_get_analyzer (context);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_semantic_analyzer_find_current_method (_tmp357_);
					_tmp359_ = vala_method_get_this_parameter (_tmp358_);
					_tmp360_ = _tmp359_;
					if (_tmp355_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						ValaMemberAccess* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaSourceReference* _tmp363_;
						ValaProperty* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						gchar* _tmp368_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp361_ = ma;
						_tmp362_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = prop;
						_tmp365_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = g_strdup_printf ("Property `%s' is read-only", _tmp366_);
						_tmp368_ = _tmp367_;
						vala_report_error (_tmp363_, _tmp368_);
						_g_free0 (_tmp368_);
						_g_free0 (_tmp366_);
						result = FALSE;
						return result;
					} else {
						ValaMemberAccess* _tmp369_;
						ValaSourceReference* _tmp370_;
						ValaSourceReference* _tmp371_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp369_ = ma;
						_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp369_);
						_tmp371_ = _tmp370_;
						vala_report_error (_tmp371_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
						result = FALSE;
						return result;
					}
				}
			}
		} else {
			gboolean _tmp372_ = FALSE;
			ValaMemberAccess* _tmp373_;
			ValaSymbol* _tmp374_;
			ValaSymbol* _tmp375_;
			_tmp373_ = ma;
			_tmp374_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp373_);
			_tmp375_ = _tmp374_;
			if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp375_)) {
				ValaMemberAccess* _tmp376_;
				ValaExpression* _tmp377_;
				ValaExpression* _tmp378_;
				ValaDataType* _tmp379_;
				ValaDataType* _tmp380_;
				gboolean _tmp381_;
				gboolean _tmp382_;
				_tmp376_ = ma;
				_tmp377_ = vala_member_access_get_inner (_tmp376_);
				_tmp378_ = _tmp377_;
				_tmp379_ = vala_expression_get_value_type (_tmp378_);
				_tmp380_ = _tmp379_;
				_tmp381_ = vala_array_type_get_inline_allocated (G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp382_ = _tmp381_;
				_tmp372_ = _tmp382_;
			} else {
				_tmp372_ = FALSE;
			}
			if (_tmp372_) {
				ValaSourceReference* _tmp383_;
				ValaSourceReference* _tmp384_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp383_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp384_ = _tmp383_;
				vala_report_error (_tmp384_, "`length' field of fixed length arrays is read-only");
				result = FALSE;
				return result;
			} else {
				gboolean _tmp385_ = FALSE;
				ValaMemberAccess* _tmp386_;
				ValaSymbol* _tmp387_;
				ValaSymbol* _tmp388_;
				_tmp386_ = ma;
				_tmp387_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp386_);
				_tmp388_ = _tmp387_;
				if (VALA_IS_VARIABLE (_tmp388_)) {
					ValaExpression* _tmp389_;
					ValaExpression* _tmp390_;
					ValaDataType* _tmp391_;
					ValaDataType* _tmp392_;
					_tmp389_ = vala_assignment_get_right (self);
					_tmp390_ = _tmp389_;
					_tmp391_ = vala_expression_get_value_type (_tmp390_);
					_tmp392_ = _tmp391_;
					_tmp385_ = VALA_IS_METHOD_TYPE (_tmp392_);
				} else {
					_tmp385_ = FALSE;
				}
				if (_tmp385_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp393_;
					ValaSymbol* _tmp394_;
					ValaSymbol* _tmp395_;
					ValaVariable* _tmp396_;
					ValaDataType* _tmp397_;
					ValaDataType* _tmp398_;
					_tmp393_ = ma;
					_tmp394_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp393_);
					_tmp395_ = _tmp394_;
					variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp395_, VALA_TYPE_VARIABLE, ValaVariable);
					_tmp396_ = variable;
					_tmp397_ = vala_variable_get_variable_type (_tmp396_);
					_tmp398_ = _tmp397_;
					if (VALA_IS_DELEGATE_TYPE (_tmp398_)) {
						ValaExpression* _tmp399_;
						ValaExpression* _tmp400_;
						ValaDataType* _tmp401_;
						ValaDataType* _tmp402_;
						ValaVariable* _tmp403_;
						ValaDataType* _tmp404_;
						ValaDataType* _tmp405_;
						_tmp399_ = vala_assignment_get_right (self);
						_tmp400_ = _tmp399_;
						_tmp401_ = vala_expression_get_value_type (_tmp400_);
						_tmp402_ = _tmp401_;
						_tmp403_ = variable;
						_tmp404_ = vala_variable_get_variable_type (_tmp403_);
						_tmp405_ = _tmp404_;
						if (!vala_data_type_compatible (_tmp402_, _tmp405_)) {
							ValaMethod* m = NULL;
							ValaExpression* _tmp406_;
							ValaExpression* _tmp407_;
							ValaSymbol* _tmp408_;
							ValaSymbol* _tmp409_;
							ValaDelegate* cb = NULL;
							ValaVariable* _tmp410_;
							ValaDataType* _tmp411_;
							ValaDataType* _tmp412_;
							ValaDelegate* _tmp413_;
							ValaDelegate* _tmp414_;
							ValaSourceReference* _tmp415_;
							ValaSourceReference* _tmp416_;
							ValaMethod* _tmp417_;
							gchar* _tmp418_;
							gchar* _tmp419_;
							ValaDelegate* _tmp420_;
							gchar* _tmp421_;
							gchar* _tmp422_;
							gchar* _tmp423_;
							gchar* _tmp424_;
							_tmp406_ = vala_assignment_get_right (self);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_expression_get_symbol_reference (_tmp407_);
							_tmp409_ = _tmp408_;
							m = G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_METHOD, ValaMethod);
							_tmp410_ = variable;
							_tmp411_ = vala_variable_get_variable_type (_tmp410_);
							_tmp412_ = _tmp411_;
							_tmp413_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp412_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							_tmp414_ = _tmp413_;
							cb = _tmp414_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp415_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp416_ = _tmp415_;
							_tmp417_ = m;
							_tmp418_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp417_);
							_tmp419_ = _tmp418_;
							_tmp420_ = cb;
							_tmp421_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp420_);
							_tmp422_ = _tmp421_;
							_tmp423_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp419_, _tmp422_);
							_tmp424_ = _tmp423_;
							vala_report_error (_tmp416_, _tmp424_);
							_g_free0 (_tmp424_);
							_g_free0 (_tmp422_);
							_g_free0 (_tmp419_);
							result = FALSE;
							return result;
						}
					} else {
						ValaSourceReference* _tmp425_;
						ValaSourceReference* _tmp426_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp426_ = _tmp425_;
						vala_report_error (_tmp426_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						return result;
					}
				} else {
					ValaMemberAccess* _tmp427_;
					ValaSymbol* _tmp428_;
					ValaSymbol* _tmp429_;
					_tmp427_ = ma;
					_tmp428_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp427_);
					_tmp429_ = _tmp428_;
					if (VALA_IS_VARIABLE (_tmp429_)) {
						ValaVariable* variable = NULL;
						ValaMemberAccess* _tmp430_;
						ValaSymbol* _tmp431_;
						ValaSymbol* _tmp432_;
						ValaArrayType* variable_array_type = NULL;
						ValaVariable* _tmp433_;
						ValaDataType* _tmp434_;
						ValaDataType* _tmp435_;
						gboolean _tmp436_ = FALSE;
						gboolean _tmp437_ = FALSE;
						gboolean _tmp438_ = FALSE;
						ValaArrayType* _tmp439_;
						_tmp430_ = ma;
						_tmp431_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp430_);
						_tmp432_ = _tmp431_;
						variable = G_TYPE_CHECK_INSTANCE_CAST (_tmp432_, VALA_TYPE_VARIABLE, ValaVariable);
						_tmp433_ = variable;
						_tmp434_ = vala_variable_get_variable_type (_tmp433_);
						_tmp435_ = _tmp434_;
						variable_array_type = VALA_IS_ARRAY_TYPE (_tmp435_) ? ((ValaArrayType*) _tmp435_) : NULL;
						_tmp439_ = variable_array_type;
						if (_tmp439_ != NULL) {
							ValaArrayType* _tmp440_;
							gboolean _tmp441_;
							gboolean _tmp442_;
							_tmp440_ = variable_array_type;
							_tmp441_ = vala_array_type_get_inline_allocated (_tmp440_);
							_tmp442_ = _tmp441_;
							_tmp438_ = _tmp442_;
						} else {
							_tmp438_ = FALSE;
						}
						if (_tmp438_) {
							ValaExpression* _tmp443_;
							ValaExpression* _tmp444_;
							_tmp443_ = vala_assignment_get_right (self);
							_tmp444_ = _tmp443_;
							_tmp437_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp444_);
						} else {
							_tmp437_ = FALSE;
						}
						if (_tmp437_) {
							ValaExpression* _tmp445_;
							ValaExpression* _tmp446_;
							ValaInitializerList* _tmp447_;
							ValaInitializerList* _tmp448_;
							_tmp445_ = vala_assignment_get_right (self);
							_tmp446_ = _tmp445_;
							_tmp447_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp446_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
							_tmp448_ = _tmp447_;
							_tmp436_ = _tmp448_ == NULL;
						} else {
							_tmp436_ = FALSE;
						}
						if (_tmp436_) {
							ValaSourceReference* _tmp449_;
							ValaSourceReference* _tmp450_;
							ValaCodeNode* _tmp451_;
							ValaCodeNode* _tmp452_;
							ValaCodeNode* _tmp453_;
							ValaCodeNode* _tmp454_;
							ValaCodeNode* _tmp455_;
							ValaCodeNode* _tmp456_;
							ValaSourceReference* _tmp457_;
							ValaSourceReference* _tmp458_;
							ValaEmptyStatement* _tmp459_;
							ValaEmptyStatement* _tmp460_;
							_tmp449_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp450_ = _tmp449_;
							vala_report_warning (_tmp450_, "Inline allocated arrays don't require an explicit instantiation");
							_tmp451_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp452_ = _tmp451_;
							_tmp453_ = vala_code_node_get_parent_node (_tmp452_);
							_tmp454_ = _tmp453_;
							_tmp455_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp456_ = _tmp455_;
							_tmp457_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp458_ = _tmp457_;
							_tmp459_ = vala_empty_statement_new (_tmp458_);
							_tmp460_ = _tmp459_;
							vala_block_replace_statement (G_TYPE_CHECK_INSTANCE_CAST (_tmp454_, VALA_TYPE_BLOCK, ValaBlock), G_TYPE_CHECK_INSTANCE_CAST (_tmp456_, VALA_TYPE_STATEMENT, ValaStatement), (ValaStatement*) _tmp460_);
							_vala_code_node_unref0 (_tmp460_);
							result = TRUE;
							return result;
						}
					}
				}
			}
		}
		_tmp462_ = vala_assignment_get_left (self);
		_tmp463_ = _tmp462_;
		_tmp464_ = vala_expression_get_value_type (_tmp463_);
		_tmp465_ = _tmp464_;
		if (_tmp465_ != NULL) {
			ValaExpression* _tmp466_;
			ValaExpression* _tmp467_;
			ValaDataType* _tmp468_;
			ValaDataType* _tmp469_;
			_tmp466_ = vala_assignment_get_right (self);
			_tmp467_ = _tmp466_;
			_tmp468_ = vala_expression_get_value_type (_tmp467_);
			_tmp469_ = _tmp468_;
			_tmp461_ = _tmp469_ != NULL;
		} else {
			_tmp461_ = FALSE;
		}
		if (_tmp461_) {
			ValaExpression* _tmp470_;
			ValaExpression* _tmp471_;
			ValaDataType* _tmp472_;
			ValaDataType* _tmp473_;
			ValaExpression* _tmp474_;
			ValaExpression* _tmp475_;
			ValaDataType* _tmp476_;
			ValaDataType* _tmp477_;
			ValaMemberAccess* _tmp494_;
			ValaSymbol* _tmp495_;
			ValaSymbol* _tmp496_;
			_tmp470_ = vala_assignment_get_right (self);
			_tmp471_ = _tmp470_;
			_tmp472_ = vala_expression_get_value_type (_tmp471_);
			_tmp473_ = _tmp472_;
			_tmp474_ = vala_assignment_get_left (self);
			_tmp475_ = _tmp474_;
			_tmp476_ = vala_expression_get_value_type (_tmp475_);
			_tmp477_ = _tmp476_;
			if (!vala_data_type_compatible (_tmp473_, _tmp477_)) {
				ValaSourceReference* _tmp478_;
				ValaSourceReference* _tmp479_;
				ValaExpression* _tmp480_;
				ValaExpression* _tmp481_;
				ValaDataType* _tmp482_;
				ValaDataType* _tmp483_;
				gchar* _tmp484_;
				gchar* _tmp485_;
				ValaExpression* _tmp486_;
				ValaExpression* _tmp487_;
				ValaDataType* _tmp488_;
				ValaDataType* _tmp489_;
				gchar* _tmp490_;
				gchar* _tmp491_;
				gchar* _tmp492_;
				gchar* _tmp493_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp479_ = _tmp478_;
				_tmp480_ = vala_assignment_get_right (self);
				_tmp481_ = _tmp480_;
				_tmp482_ = vala_expression_get_value_type (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_code_node_to_string ((ValaCodeNode*) _tmp483_);
				_tmp485_ = _tmp484_;
				_tmp486_ = vala_assignment_get_left (self);
				_tmp487_ = _tmp486_;
				_tmp488_ = vala_expression_get_value_type (_tmp487_);
				_tmp489_ = _tmp488_;
				_tmp490_ = vala_code_node_to_string ((ValaCodeNode*) _tmp489_);
				_tmp491_ = _tmp490_;
				_tmp492_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp485_, _tmp491_);
				_tmp493_ = _tmp492_;
				vala_report_error (_tmp479_, _tmp493_);
				_g_free0 (_tmp493_);
				_g_free0 (_tmp491_);
				_g_free0 (_tmp485_);
				result = FALSE;
				return result;
			}
			_tmp494_ = ma;
			_tmp495_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp494_);
			_tmp496_ = _tmp495_;
			if (!VALA_IS_PROPERTY (_tmp496_)) {
				ValaExpression* _tmp497_;
				ValaExpression* _tmp498_;
				ValaDataType* _tmp499_;
				ValaDataType* _tmp500_;
				_tmp497_ = vala_assignment_get_right (self);
				_tmp498_ = _tmp497_;
				_tmp499_ = vala_expression_get_value_type (_tmp498_);
				_tmp500_ = _tmp499_;
				if (vala_data_type_is_disposable (_tmp500_)) {
					gboolean _tmp501_ = FALSE;
					ValaExpression* _tmp502_;
					ValaExpression* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					_tmp502_ = vala_assignment_get_left (self);
					_tmp503_ = _tmp502_;
					_tmp504_ = vala_expression_get_value_type (_tmp503_);
					_tmp505_ = _tmp504_;
					if (!VALA_IS_POINTER_TYPE (_tmp505_)) {
						ValaExpression* _tmp506_;
						ValaExpression* _tmp507_;
						ValaDataType* _tmp508_;
						ValaDataType* _tmp509_;
						gboolean _tmp510_;
						gboolean _tmp511_;
						_tmp506_ = vala_assignment_get_left (self);
						_tmp507_ = _tmp506_;
						_tmp508_ = vala_expression_get_value_type (_tmp507_);
						_tmp509_ = _tmp508_;
						_tmp510_ = vala_data_type_get_value_owned (_tmp509_);
						_tmp511_ = _tmp510_;
						_tmp501_ = !_tmp511_;
					} else {
						_tmp501_ = FALSE;
					}
					if (_tmp501_) {
						ValaSourceReference* _tmp512_;
						ValaSourceReference* _tmp513_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp513_ = _tmp512_;
						vala_report_error (_tmp513_, "Invalid assignment from owned expression to unowned variable");
					}
				} else {
					ValaExpression* _tmp514_;
					ValaExpression* _tmp515_;
					ValaDataType* _tmp516_;
					ValaDataType* _tmp517_;
					gboolean _tmp518_;
					gboolean _tmp519_;
					_tmp514_ = vala_assignment_get_left (self);
					_tmp515_ = _tmp514_;
					_tmp516_ = vala_expression_get_value_type (_tmp515_);
					_tmp517_ = _tmp516_;
					_tmp518_ = vala_data_type_get_value_owned (_tmp517_);
					_tmp519_ = _tmp518_;
					if (_tmp519_) {
					}
				}
			}
		}
		_tmp520_ = vala_assignment_get_right (self);
		_tmp521_ = _tmp520_;
		right_ma = VALA_IS_MEMBER_ACCESS (_tmp521_) ? ((ValaMemberAccess*) _tmp521_) : NULL;
		_tmp523_ = right_ma;
		if (_tmp523_ != NULL) {
			ValaMemberAccess* _tmp524_;
			ValaSymbol* _tmp525_;
			ValaSymbol* _tmp526_;
			ValaMemberAccess* _tmp527_;
			ValaSymbol* _tmp528_;
			ValaSymbol* _tmp529_;
			_tmp524_ = ma;
			_tmp525_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp524_);
			_tmp526_ = _tmp525_;
			_tmp527_ = right_ma;
			_tmp528_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp527_);
			_tmp529_ = _tmp528_;
			_tmp522_ = _tmp526_ == _tmp529_;
		} else {
			_tmp522_ = FALSE;
		}
		if (_tmp522_) {
			gboolean _tmp530_ = FALSE;
			ValaMemberAccess* _tmp531_;
			ValaSymbol* _tmp532_;
			ValaSymbol* _tmp533_;
			_tmp531_ = ma;
			_tmp532_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp531_);
			_tmp533_ = _tmp532_;
			if (VALA_IS_LOCAL_VARIABLE (_tmp533_)) {
				_tmp530_ = TRUE;
			} else {
				ValaMemberAccess* _tmp534_;
				ValaSymbol* _tmp535_;
				ValaSymbol* _tmp536_;
				_tmp534_ = ma;
				_tmp535_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp534_);
				_tmp536_ = _tmp535_;
				_tmp530_ = VALA_IS_PARAMETER (_tmp536_);
			}
			if (_tmp530_) {
				ValaSourceReference* _tmp537_;
				ValaSourceReference* _tmp538_;
				_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp538_ = _tmp537_;
				vala_report_warning (_tmp538_, "Assignment to same variable");
			} else {
				ValaMemberAccess* _tmp539_;
				ValaSymbol* _tmp540_;
				ValaSymbol* _tmp541_;
				_tmp539_ = ma;
				_tmp540_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp539_);
				_tmp541_ = _tmp540_;
				if (VALA_IS_FIELD (_tmp541_)) {
					ValaField* f = NULL;
					ValaMemberAccess* _tmp542_;
					ValaSymbol* _tmp543_;
					ValaSymbol* _tmp544_;
					ValaField* _tmp545_;
					ValaMemberBinding _tmp546_;
					ValaMemberBinding _tmp547_;
					_tmp542_ = ma;
					_tmp543_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp542_);
					_tmp544_ = _tmp543_;
					f = G_TYPE_CHECK_INSTANCE_CAST (_tmp544_, VALA_TYPE_FIELD, ValaField);
					_tmp545_ = f;
					_tmp546_ = vala_field_get_binding (_tmp545_);
					_tmp547_ = _tmp546_;
					if (_tmp547_ == VALA_MEMBER_BINDING_STATIC) {
						ValaSourceReference* _tmp548_;
						ValaSourceReference* _tmp549_;
						_tmp548_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp549_ = _tmp548_;
						vala_report_warning (_tmp549_, "Assignment to same variable");
					} else {
						ValaMemberAccess* ma_inner = NULL;
						ValaMemberAccess* _tmp550_;
						ValaExpression* _tmp551_;
						ValaExpression* _tmp552_;
						ValaMemberAccess* right_ma_inner = NULL;
						ValaMemberAccess* _tmp553_;
						ValaExpression* _tmp554_;
						ValaExpression* _tmp555_;
						gboolean _tmp556_ = FALSE;
						gboolean _tmp557_ = FALSE;
						gboolean _tmp558_ = FALSE;
						gboolean _tmp559_ = FALSE;
						gboolean _tmp560_ = FALSE;
						ValaMemberAccess* _tmp561_;
						_tmp550_ = ma;
						_tmp551_ = vala_member_access_get_inner (_tmp550_);
						_tmp552_ = _tmp551_;
						ma_inner = VALA_IS_MEMBER_ACCESS (_tmp552_) ? ((ValaMemberAccess*) _tmp552_) : NULL;
						_tmp553_ = right_ma;
						_tmp554_ = vala_member_access_get_inner (_tmp553_);
						_tmp555_ = _tmp554_;
						right_ma_inner = VALA_IS_MEMBER_ACCESS (_tmp555_) ? ((ValaMemberAccess*) _tmp555_) : NULL;
						_tmp561_ = ma_inner;
						if (_tmp561_ != NULL) {
							ValaMemberAccess* _tmp562_;
							const gchar* _tmp563_;
							const gchar* _tmp564_;
							_tmp562_ = ma_inner;
							_tmp563_ = vala_member_access_get_member_name (_tmp562_);
							_tmp564_ = _tmp563_;
							_tmp560_ = g_strcmp0 (_tmp564_, "this") == 0;
						} else {
							_tmp560_ = FALSE;
						}
						if (_tmp560_) {
							ValaMemberAccess* _tmp565_;
							ValaExpression* _tmp566_;
							ValaExpression* _tmp567_;
							_tmp565_ = ma_inner;
							_tmp566_ = vala_member_access_get_inner (_tmp565_);
							_tmp567_ = _tmp566_;
							_tmp559_ = _tmp567_ == NULL;
						} else {
							_tmp559_ = FALSE;
						}
						if (_tmp559_) {
							ValaMemberAccess* _tmp568_;
							_tmp568_ = right_ma_inner;
							_tmp558_ = _tmp568_ != NULL;
						} else {
							_tmp558_ = FALSE;
						}
						if (_tmp558_) {
							ValaMemberAccess* _tmp569_;
							const gchar* _tmp570_;
							const gchar* _tmp571_;
							_tmp569_ = right_ma_inner;
							_tmp570_ = vala_member_access_get_member_name (_tmp569_);
							_tmp571_ = _tmp570_;
							_tmp557_ = g_strcmp0 (_tmp571_, "this") == 0;
						} else {
							_tmp557_ = FALSE;
						}
						if (_tmp557_) {
							ValaMemberAccess* _tmp572_;
							ValaExpression* _tmp573_;
							ValaExpression* _tmp574_;
							_tmp572_ = right_ma_inner;
							_tmp573_ = vala_member_access_get_inner (_tmp572_);
							_tmp574_ = _tmp573_;
							_tmp556_ = _tmp574_ == NULL;
						} else {
							_tmp556_ = FALSE;
						}
						if (_tmp556_) {
							ValaSourceReference* _tmp575_;
							ValaSourceReference* _tmp576_;
							_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp576_ = _tmp575_;
							vala_report_warning (_tmp576_, "Assignment to same variable");
						}
					}
				}
			}
		}
	} else {
		ValaExpression* _tmp577_;
		ValaExpression* _tmp578_;
		_tmp577_ = vala_assignment_get_left (self);
		_tmp578_ = _tmp577_;
		if (VALA_IS_ELEMENT_ACCESS (_tmp578_)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp579_;
			ValaExpression* _tmp580_;
			ValaExpression* _tmp581_;
			ValaExpression* _tmp582_;
			ValaDataType* _tmp583_;
			ValaDataType* _tmp584_;
			ValaExpression* _tmp585_;
			ValaExpression* _tmp586_;
			ValaDataType* _tmp587_;
			ValaDataType* _tmp588_;
			ValaExpression* _tmp605_;
			ValaExpression* _tmp606_;
			ValaDataType* _tmp607_;
			ValaDataType* _tmp608_;
			_tmp579_ = vala_assignment_get_left (self);
			_tmp580_ = _tmp579_;
			ea = G_TYPE_CHECK_INSTANCE_CAST (_tmp580_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
			_tmp581_ = vala_assignment_get_right (self);
			_tmp582_ = _tmp581_;
			_tmp583_ = vala_expression_get_value_type (_tmp582_);
			_tmp584_ = _tmp583_;
			_tmp585_ = vala_assignment_get_left (self);
			_tmp586_ = _tmp585_;
			_tmp587_ = vala_expression_get_value_type (_tmp586_);
			_tmp588_ = _tmp587_;
			if (!vala_data_type_compatible (_tmp584_, _tmp588_)) {
				ValaSourceReference* _tmp589_;
				ValaSourceReference* _tmp590_;
				ValaExpression* _tmp591_;
				ValaExpression* _tmp592_;
				ValaDataType* _tmp593_;
				ValaDataType* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				ValaExpression* _tmp597_;
				ValaExpression* _tmp598_;
				ValaDataType* _tmp599_;
				ValaDataType* _tmp600_;
				gchar* _tmp601_;
				gchar* _tmp602_;
				gchar* _tmp603_;
				gchar* _tmp604_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp589_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp590_ = _tmp589_;
				_tmp591_ = vala_assignment_get_right (self);
				_tmp592_ = _tmp591_;
				_tmp593_ = vala_expression_get_value_type (_tmp592_);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_code_node_to_string ((ValaCodeNode*) _tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = vala_assignment_get_left (self);
				_tmp598_ = _tmp597_;
				_tmp599_ = vala_expression_get_value_type (_tmp598_);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_code_node_to_string ((ValaCodeNode*) _tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp596_, _tmp602_);
				_tmp604_ = _tmp603_;
				vala_report_error (_tmp590_, _tmp604_);
				_g_free0 (_tmp604_);
				_g_free0 (_tmp602_);
				_g_free0 (_tmp596_);
				result = FALSE;
				return result;
			}
			_tmp605_ = vala_assignment_get_right (self);
			_tmp606_ = _tmp605_;
			_tmp607_ = vala_expression_get_value_type (_tmp606_);
			_tmp608_ = _tmp607_;
			if (vala_data_type_is_disposable (_tmp608_)) {
				ValaDataType* element_type = NULL;
				ValaElementAccess* _tmp609_;
				ValaExpression* _tmp610_;
				ValaExpression* _tmp611_;
				ValaDataType* _tmp612_;
				ValaDataType* _tmp613_;
				gboolean _tmp635_ = FALSE;
				ValaDataType* _tmp636_;
				_tmp609_ = ea;
				_tmp610_ = vala_element_access_get_container (_tmp609_);
				_tmp611_ = _tmp610_;
				_tmp612_ = vala_expression_get_value_type (_tmp611_);
				_tmp613_ = _tmp612_;
				if (VALA_IS_ARRAY_TYPE (_tmp613_)) {
					ValaArrayType* array_type = NULL;
					ValaElementAccess* _tmp614_;
					ValaExpression* _tmp615_;
					ValaExpression* _tmp616_;
					ValaDataType* _tmp617_;
					ValaDataType* _tmp618_;
					ValaArrayType* _tmp619_;
					ValaDataType* _tmp620_;
					ValaDataType* _tmp621_;
					ValaDataType* _tmp622_;
					_tmp614_ = ea;
					_tmp615_ = vala_element_access_get_container (_tmp614_);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_expression_get_value_type (_tmp616_);
					_tmp618_ = _tmp617_;
					array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp618_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp619_ = array_type;
					_tmp620_ = vala_array_type_get_element_type (_tmp619_);
					_tmp621_ = _tmp620_;
					_tmp622_ = _vala_code_node_ref0 (_tmp621_);
					_vala_code_node_unref0 (element_type);
					element_type = _tmp622_;
				} else {
					ValaList* args = NULL;
					ValaElementAccess* _tmp623_;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaDataType* _tmp626_;
					ValaDataType* _tmp627_;
					ValaList* _tmp628_;
					ValaList* _tmp629_;
					ValaList* _tmp630_;
					gint _tmp631_;
					gint _tmp632_;
					ValaList* _tmp633_;
					gpointer _tmp634_;
					_tmp623_ = ea;
					_tmp624_ = vala_element_access_get_container (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_expression_get_value_type (_tmp625_);
					_tmp627_ = _tmp626_;
					_tmp628_ = vala_data_type_get_type_arguments (_tmp627_);
					_tmp629_ = _vala_iterable_ref0 (_tmp628_);
					args = _tmp629_;
					_tmp630_ = args;
					_tmp631_ = vala_collection_get_size ((ValaCollection*) _tmp630_);
					_tmp632_ = _tmp631_;
					_vala_assert (_tmp632_ == 1, "args.size == 1");
					_tmp633_ = args;
					_tmp634_ = vala_list_get (_tmp633_, 0);
					_vala_code_node_unref0 (element_type);
					element_type = (ValaDataType*) _tmp634_;
					_vala_iterable_unref0 (args);
				}
				_tmp636_ = element_type;
				if (!VALA_IS_POINTER_TYPE (_tmp636_)) {
					ValaDataType* _tmp637_;
					gboolean _tmp638_;
					gboolean _tmp639_;
					_tmp637_ = element_type;
					_tmp638_ = vala_data_type_get_value_owned (_tmp637_);
					_tmp639_ = _tmp638_;
					_tmp635_ = !_tmp639_;
				} else {
					_tmp635_ = FALSE;
				}
				if (_tmp635_) {
					ValaSourceReference* _tmp640_;
					ValaSourceReference* _tmp641_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp640_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp641_ = _tmp640_;
					vala_report_error (_tmp641_, "Invalid assignment from owned expression to unowned variable");
					result = FALSE;
					_vala_code_node_unref0 (element_type);
					return result;
				}
				_vala_code_node_unref0 (element_type);
			} else {
				ValaExpression* _tmp642_;
				ValaExpression* _tmp643_;
				ValaDataType* _tmp644_;
				ValaDataType* _tmp645_;
				gboolean _tmp646_;
				gboolean _tmp647_;
				_tmp642_ = vala_assignment_get_left (self);
				_tmp643_ = _tmp642_;
				_tmp644_ = vala_expression_get_value_type (_tmp643_);
				_tmp645_ = _tmp644_;
				_tmp646_ = vala_data_type_get_value_owned (_tmp645_);
				_tmp647_ = _tmp646_;
				if (_tmp647_) {
				}
			}
		} else {
			result = TRUE;
			return result;
		}
	}
	_tmp648_ = vala_assignment_get_left (self);
	_tmp649_ = _tmp648_;
	_tmp650_ = vala_expression_get_value_type (_tmp649_);
	_tmp651_ = _tmp650_;
	if (_tmp651_ != NULL) {
		ValaExpression* _tmp652_;
		ValaExpression* _tmp653_;
		ValaDataType* _tmp654_;
		ValaDataType* _tmp655_;
		ValaDataType* _tmp656_;
		ValaDataType* _tmp657_;
		ValaDataType* _tmp658_;
		ValaDataType* _tmp659_;
		_tmp652_ = vala_assignment_get_left (self);
		_tmp653_ = _tmp652_;
		_tmp654_ = vala_expression_get_value_type (_tmp653_);
		_tmp655_ = _tmp654_;
		_tmp656_ = vala_data_type_copy (_tmp655_);
		_tmp657_ = _tmp656_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp657_);
		_vala_code_node_unref0 (_tmp657_);
		_tmp658_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp659_ = _tmp658_;
		vala_data_type_set_value_owned (_tmp659_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp660_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp661_ = _tmp660_;
	if (_tmp661_ != NULL) {
		ValaDataType* _tmp662_;
		ValaDataType* _tmp663_;
		_tmp662_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp663_ = _tmp662_;
		vala_code_node_check ((ValaCodeNode*) _tmp663_, context);
	}
	_tmp664_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp665_ = _tmp664_;
	result = !_tmp665_;
	return result;
}

static gboolean
vala_assignment_is_array_add (ValaAssignment* self)
{
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaBinaryExpression* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	binary = VALA_IS_BINARY_EXPRESSION (_tmp1_) ? ((ValaBinaryExpression*) _tmp1_) : NULL;
	_tmp3_ = binary;
	if (_tmp3_ != NULL) {
		ValaBinaryExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = binary;
		_tmp5_ = vala_binary_expression_get_left (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_value_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = VALA_IS_ARRAY_TYPE (_tmp8_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaBinaryExpression* _tmp9_;
		ValaBinaryOperator _tmp10_;
		ValaBinaryOperator _tmp11_;
		_tmp9_ = binary;
		_tmp10_ = vala_binary_expression_get_operator (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaBinaryExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			_tmp12_ = vala_assignment_get_left (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_expression_get_symbol_reference (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = binary;
			_tmp17_ = vala_binary_expression_get_left (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp15_ == _tmp20_) {
				ValaBinaryExpression* _tmp21_;
				ValaExpression* _tmp22_;
				ValaExpression* _tmp23_;
				_tmp21_ = binary;
				_tmp22_ = vala_binary_expression_get_left (_tmp21_);
				_tmp23_ = _tmp22_;
				vala_expression_set_lvalue (_tmp23_, TRUE);
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
vala_assignment_check_constant_assignment (ValaAssignment* self,
                                           ValaMemberAccess* inner)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		if (!(inner != NULL)) {
			break;
		}
		_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) inner);
		_tmp1_ = _tmp0_;
		if (VALA_IS_CONSTANT (_tmp1_)) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			vala_report_error (_tmp3_, "Assignment to constant after initialization");
			break;
		}
		_tmp4_ = vala_member_access_get_inner (inner);
		_tmp5_ = _tmp4_;
		if (VALA_IS_MEMBER_ACCESS (_tmp5_)) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			_tmp6_ = vala_member_access_get_inner (inner);
			_tmp7_ = _tmp6_;
			inner = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		} else {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (inner);
			_tmp9_ = _tmp8_;
			if (VALA_IS_ELEMENT_ACCESS (_tmp9_)) {
				ValaExpression* _tmp10_;
				ValaExpression* _tmp11_;
				ValaExpression* _tmp12_;
				ValaExpression* _tmp13_;
				_tmp10_ = vala_member_access_get_inner (inner);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_element_access_get_container (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				_tmp13_ = _tmp12_;
				inner = VALA_IS_MEMBER_ACCESS (_tmp13_) ? ((ValaMemberAccess*) _tmp13_) : NULL;
			} else {
				inner = NULL;
			}
		}
	}
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static void
vala_assignment_real_emit (ValaCodeNode* base,
                           ValaCodeGenerator* codegen)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaExpression* _tmp130_;
	ValaExpression* _tmp131_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	pi = VALA_IS_POINTER_INDIRECTION (_tmp5_) ? ((ValaPointerIndirection*) _tmp5_) : NULL;
	_tmp6_ = ma;
	if (_tmp6_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		ValaField* _tmp21_;
		gboolean instance = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		ValaAssignmentOperator _tmp36_;
		gboolean _tmp115_ = FALSE;
		gboolean _tmp116_ = FALSE;
		_tmp7_ = ma;
		_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		local = VALA_IS_LOCAL_VARIABLE (_tmp9_) ? ((ValaLocalVariable*) _tmp9_) : NULL;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		param = VALA_IS_PARAMETER (_tmp12_) ? ((ValaParameter*) _tmp12_) : NULL;
		_tmp13_ = ma;
		_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
		_tmp15_ = _tmp14_;
		field = VALA_IS_FIELD (_tmp15_) ? ((ValaField*) _tmp15_) : NULL;
		_tmp16_ = ma;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
		_tmp18_ = _tmp17_;
		property = VALA_IS_PROPERTY (_tmp18_) ? ((ValaProperty*) _tmp18_) : NULL;
		_tmp21_ = field;
		if (_tmp21_ != NULL) {
			ValaField* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp22_ = field;
			_tmp23_ = vala_field_get_binding (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp25_ = FALSE;
			ValaProperty* _tmp26_;
			_tmp26_ = property;
			if (_tmp26_ != NULL) {
				ValaProperty* _tmp27_;
				ValaMemberBinding _tmp28_;
				ValaMemberBinding _tmp29_;
				_tmp27_ = property;
				_tmp28_ = vala_property_get_binding (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp19_ = _tmp25_;
		}
		instance = _tmp19_;
		_tmp36_ = self->priv->_operator;
		if (_tmp36_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp37_ = FALSE;
			gboolean _tmp38_ = FALSE;
			ValaLocalVariable* _tmp39_;
			_tmp39_ = local;
			if (_tmp39_ != NULL) {
				_tmp38_ = TRUE;
			} else {
				ValaParameter* _tmp40_;
				_tmp40_ = param;
				_tmp38_ = _tmp40_ != NULL;
			}
			if (_tmp38_) {
				_tmp37_ = TRUE;
			} else {
				ValaField* _tmp41_;
				_tmp41_ = field;
				_tmp37_ = _tmp41_ != NULL;
			}
			_tmp35_ = _tmp37_;
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			_tmp34_ = !vala_assignment_is_array_add (self);
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			ValaField* _tmp42_;
			_tmp42_ = field;
			_tmp33_ = !VALA_IS_ARRAY_LENGTH_FIELD (_tmp42_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			_tmp32_ = !VALA_IS_DELEGATE_TARGET_FIELD (_tmp43_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaField* _tmp44_;
			_tmp44_ = field;
			_tmp31_ = !VALA_IS_DELEGATE_DESTROY_FIELD (_tmp44_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gboolean _tmp45_ = FALSE;
			ValaExpression* _tmp46_;
			ValaExpression* _tmp47_;
			ValaDataType* _tmp48_;
			ValaDataType* _tmp49_;
			_tmp46_ = vala_assignment_get_left (self);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_expression_get_value_type (_tmp47_);
			_tmp49_ = _tmp48_;
			if (vala_data_type_is_real_non_null_struct_type (_tmp49_)) {
				ValaExpression* _tmp50_;
				ValaExpression* _tmp51_;
				_tmp50_ = vala_assignment_get_right (self);
				_tmp51_ = _tmp50_;
				_tmp45_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp51_);
			} else {
				_tmp45_ = FALSE;
			}
			_tmp30_ = !_tmp45_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			gboolean _tmp52_ = FALSE;
			ValaExpression* _tmp59_;
			ValaExpression* _tmp60_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaTargetValue* _tmp63_;
			ValaTargetValue* _tmp64_;
			ValaTargetValue* _tmp65_;
			ValaLocalVariable* _tmp66_;
			ValaCodeNode* _tmp91_;
			ValaCodeNode* _tmp92_;
			if (instance) {
				ValaMemberAccess* _tmp53_;
				ValaExpression* _tmp54_;
				ValaExpression* _tmp55_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_inner (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp52_ = _tmp55_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaMemberAccess* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				_tmp56_ = ma;
				_tmp57_ = vala_member_access_get_inner (_tmp56_);
				_tmp58_ = _tmp57_;
				vala_code_node_emit ((ValaCodeNode*) _tmp58_, codegen);
			}
			_tmp59_ = vala_assignment_get_right (self);
			_tmp60_ = _tmp59_;
			vala_code_node_emit ((ValaCodeNode*) _tmp60_, codegen);
			_tmp61_ = vala_assignment_get_right (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_expression_get_target_value (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = _vala_target_value_ref0 (_tmp64_);
			new_value = _tmp65_;
			_tmp66_ = local;
			if (_tmp66_ != NULL) {
				ValaLocalVariable* _tmp67_;
				ValaTargetValue* _tmp68_;
				ValaSourceReference* _tmp69_;
				ValaSourceReference* _tmp70_;
				_tmp67_ = local;
				_tmp68_ = new_value;
				_tmp69_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp70_ = _tmp69_;
				vala_code_generator_store_local (codegen, _tmp67_, _tmp68_, FALSE, _tmp70_);
			} else {
				ValaParameter* _tmp71_;
				_tmp71_ = param;
				if (_tmp71_ != NULL) {
					ValaParameter* _tmp72_;
					ValaTargetValue* _tmp73_;
					ValaSourceReference* _tmp74_;
					ValaSourceReference* _tmp75_;
					_tmp72_ = param;
					_tmp73_ = new_value;
					_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp75_ = _tmp74_;
					vala_code_generator_store_parameter (codegen, _tmp72_, _tmp73_, FALSE, _tmp75_);
				} else {
					ValaField* _tmp76_;
					_tmp76_ = field;
					if (_tmp76_ != NULL) {
						ValaTargetValue* _tmp77_ = NULL;
						gboolean _tmp78_ = FALSE;
						ValaField* _tmp87_;
						ValaTargetValue* _tmp88_;
						ValaSourceReference* _tmp89_;
						ValaSourceReference* _tmp90_;
						if (instance) {
							ValaMemberAccess* _tmp79_;
							ValaExpression* _tmp80_;
							ValaExpression* _tmp81_;
							_tmp79_ = ma;
							_tmp80_ = vala_member_access_get_inner (_tmp79_);
							_tmp81_ = _tmp80_;
							_tmp78_ = _tmp81_ != NULL;
						} else {
							_tmp78_ = FALSE;
						}
						if (_tmp78_) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							ValaTargetValue* _tmp85_;
							ValaTargetValue* _tmp86_;
							_tmp82_ = ma;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = vala_expression_get_target_value (_tmp84_);
							_tmp86_ = _tmp85_;
							_tmp77_ = _tmp86_;
						} else {
							_tmp77_ = NULL;
						}
						_tmp87_ = field;
						_tmp88_ = new_value;
						_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp90_ = _tmp89_;
						vala_code_generator_store_field (codegen, _tmp87_, _tmp77_, _tmp88_, _tmp90_);
					}
				}
			}
			_tmp91_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp92_ = _tmp91_;
			if (!VALA_IS_EXPRESSION_STATEMENT (_tmp92_)) {
				ValaLocalVariable* _tmp93_;
				_tmp93_ = local;
				if (_tmp93_ != NULL) {
					ValaLocalVariable* _tmp94_;
					ValaTargetValue* _tmp95_;
					ValaTargetValue* _tmp96_;
					_tmp94_ = local;
					_tmp95_ = vala_code_generator_load_local (codegen, _tmp94_);
					_tmp96_ = _tmp95_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp96_);
					_vala_target_value_unref0 (_tmp96_);
				} else {
					ValaParameter* _tmp97_;
					_tmp97_ = param;
					if (_tmp97_ != NULL) {
						ValaParameter* _tmp98_;
						ValaTargetValue* _tmp99_;
						ValaTargetValue* _tmp100_;
						_tmp98_ = param;
						_tmp99_ = vala_code_generator_load_parameter (codegen, _tmp98_);
						_tmp100_ = _tmp99_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp100_);
						_vala_target_value_unref0 (_tmp100_);
					} else {
						ValaField* _tmp101_;
						_tmp101_ = field;
						if (_tmp101_ != NULL) {
							ValaTargetValue* _tmp102_ = NULL;
							gboolean _tmp103_ = FALSE;
							ValaField* _tmp112_;
							ValaTargetValue* _tmp113_;
							ValaTargetValue* _tmp114_;
							if (instance) {
								ValaMemberAccess* _tmp104_;
								ValaExpression* _tmp105_;
								ValaExpression* _tmp106_;
								_tmp104_ = ma;
								_tmp105_ = vala_member_access_get_inner (_tmp104_);
								_tmp106_ = _tmp105_;
								_tmp103_ = _tmp106_ != NULL;
							} else {
								_tmp103_ = FALSE;
							}
							if (_tmp103_) {
								ValaMemberAccess* _tmp107_;
								ValaExpression* _tmp108_;
								ValaExpression* _tmp109_;
								ValaTargetValue* _tmp110_;
								ValaTargetValue* _tmp111_;
								_tmp107_ = ma;
								_tmp108_ = vala_member_access_get_inner (_tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = vala_expression_get_target_value (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp102_ = _tmp111_;
							} else {
								_tmp102_ = NULL;
							}
							_tmp112_ = field;
							_tmp113_ = vala_code_generator_load_field (codegen, _tmp112_, _tmp102_);
							_tmp114_ = _tmp113_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
							_vala_target_value_unref0 (_tmp114_);
						}
					}
				}
			}
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			return;
		}
		if (instance) {
			ValaMemberAccess* _tmp117_;
			ValaExpression* _tmp118_;
			ValaExpression* _tmp119_;
			_tmp117_ = ma;
			_tmp118_ = vala_member_access_get_inner (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp116_ = _tmp119_ != NULL;
		} else {
			_tmp116_ = FALSE;
		}
		if (_tmp116_) {
			ValaProperty* _tmp120_;
			_tmp120_ = property;
			_tmp115_ = _tmp120_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			ValaMemberAccess* _tmp121_;
			ValaExpression* _tmp122_;
			ValaExpression* _tmp123_;
			_tmp121_ = ma;
			_tmp122_ = vala_member_access_get_inner (_tmp121_);
			_tmp123_ = _tmp122_;
			vala_code_node_emit ((ValaCodeNode*) _tmp123_, codegen);
		} else {
			ValaProperty* _tmp124_;
			_tmp124_ = property;
			if (_tmp124_ == NULL) {
				ValaMemberAccess* _tmp125_;
				_tmp125_ = ma;
				vala_code_node_emit ((ValaCodeNode*) _tmp125_, codegen);
			}
		}
	} else {
		ValaElementAccess* _tmp126_;
		_tmp126_ = ea;
		if (_tmp126_ != NULL) {
			ValaElementAccess* _tmp127_;
			_tmp127_ = ea;
			vala_code_node_emit ((ValaCodeNode*) _tmp127_, codegen);
		} else {
			ValaPointerIndirection* _tmp128_;
			_tmp128_ = pi;
			if (_tmp128_ != NULL) {
				ValaPointerIndirection* _tmp129_;
				_tmp129_ = pi;
				vala_code_node_emit ((ValaCodeNode*) _tmp129_, codegen);
			}
		}
	}
	_tmp130_ = vala_assignment_get_right (self);
	_tmp131_ = _tmp130_;
	vala_code_node_emit ((ValaCodeNode*) _tmp131_, codegen);
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_assignment_real_get_defined_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaLocalVariable* _tmp12_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_assignment_get_left (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_symbol_reference (_tmp5_);
	_tmp7_ = _tmp6_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp7_) ? ((ValaLocalVariable*) _tmp7_) : NULL;
	_tmp8_ = vala_assignment_get_left (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_expression_get_symbol_reference (_tmp9_);
	_tmp11_ = _tmp10_;
	param = VALA_IS_PARAMETER (_tmp11_) ? ((ValaParameter*) _tmp11_) : NULL;
	_tmp12_ = local;
	if (_tmp12_ != NULL) {
		ValaLocalVariable* _tmp13_;
		_tmp13_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp13_);
	} else {
		gboolean _tmp14_ = FALSE;
		ValaParameter* _tmp15_;
		_tmp15_ = param;
		if (_tmp15_ != NULL) {
			ValaParameter* _tmp16_;
			ValaParameterDirection _tmp17_;
			ValaParameterDirection _tmp18_;
			_tmp16_ = param;
			_tmp17_ = vala_parameter_get_direction (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaParameter* _tmp19_;
			_tmp19_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp19_);
		}
	}
}

static void
vala_assignment_real_get_used_variables (ValaCodeNode* base,
                                         ValaCollection* collection)
{
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMemberAccess* _tmp5_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp1_) ? ((ValaMemberAccess*) _tmp1_) : NULL;
	_tmp2_ = vala_assignment_get_left (self);
	_tmp3_ = _tmp2_;
	ea = VALA_IS_ELEMENT_ACCESS (_tmp3_) ? ((ValaElementAccess*) _tmp3_) : NULL;
	_tmp5_ = ma;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		_tmp6_ = ma;
		_tmp7_ = vala_member_access_get_inner (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
	} else {
		ValaElementAccess* _tmp12_;
		_tmp12_ = ea;
		if (_tmp12_ != NULL) {
			ValaElementAccess* _tmp13_;
			_tmp13_ = ea;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
		}
	}
	_tmp14_ = vala_assignment_get_right (self);
	_tmp15_ = _tmp14_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp15_, collection);
}

static void
vala_assignment_class_init (ValaAssignmentClass * klass,
                            gpointer klass_data)
{
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_adjust_private_offset (klass, &ValaAssignment_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_assignment_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_assignment_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_assignment_real_get_used_variables;
}

static void
vala_assignment_instance_init (ValaAssignment * self,
                               gpointer klass)
{
	self->priv = vala_assignment_get_instance_private (self);
}

static void
vala_assignment_finalize (ValaCodeNode * obj)
{
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}

/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
static GType
vala_assignment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
	GType vala_assignment_type_id;
	vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
	ValaAssignment_private_offset = g_type_add_instance_private (vala_assignment_type_id, sizeof (ValaAssignmentPrivate));
	return vala_assignment_type_id;
}

GType
vala_assignment_get_type (void)
{
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		GType vala_assignment_type_id;
		vala_assignment_type_id = vala_assignment_get_type_once ();
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}

const gchar*
vala_assignment_operator_to_string (ValaAssignmentOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			result = "=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			result = "|=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			result = "&=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			result = "^=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_ADD:
		{
			result = "+=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SUB:
		{
			result = "-=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_MUL:
		{
			result = "*=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_DIV:
		{
			result = "/=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_PERCENT:
		{
			result = "%=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			result = "<<=";
			return result;
		}
		case VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>=";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
vala_assignment_operator_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
	GType vala_assignment_operator_type_id;
	vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
	return vala_assignment_operator_type_id;
}

GType
vala_assignment_operator_get_type (void)
{
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = vala_assignment_operator_get_type_once ();
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}

