/* generator.c generated by valac, the Vala compiler
 * generated from generator.vala, do not modify */

/* generator.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <valadoc.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <vala.h>
#include <gobject/gvaluecollector.h>

#define GTKDOC_TYPE_GENERATOR (gtkdoc_generator_get_type ())
#define GTKDOC_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GENERATOR, GtkdocGenerator))
#define GTKDOC_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GENERATOR, GtkdocGeneratorClass))
#define GTKDOC_IS_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GENERATOR))
#define GTKDOC_IS_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GENERATOR))
#define GTKDOC_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GENERATOR, GtkdocGeneratorClass))

typedef struct _GtkdocGenerator GtkdocGenerator;
typedef struct _GtkdocGeneratorClass GtkdocGeneratorClass;
typedef struct _GtkdocGeneratorPrivate GtkdocGeneratorPrivate;

#define GTKDOC_DBUS_TYPE_INTERFACE (gtkdoc_dbus_interface_get_type ())
#define GTKDOC_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterface))
#define GTKDOC_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))
#define GTKDOC_DBUS_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_INTERFACE))
#define GTKDOC_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_INTERFACE, GtkdocDBusInterfaceClass))

typedef struct _GtkdocDBusInterface GtkdocDBusInterface;
typedef struct _GtkdocDBusInterfaceClass GtkdocDBusInterfaceClass;

#define GTKDOC_GENERATOR_TYPE_FILE_DATA (gtkdoc_generator_file_data_get_type ())
#define GTKDOC_GENERATOR_FILE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_GENERATOR_TYPE_FILE_DATA, GtkdocGeneratorFileData))
#define GTKDOC_GENERATOR_FILE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_GENERATOR_TYPE_FILE_DATA, GtkdocGeneratorFileDataClass))
#define GTKDOC_GENERATOR_IS_FILE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_GENERATOR_TYPE_FILE_DATA))
#define GTKDOC_GENERATOR_IS_FILE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_GENERATOR_TYPE_FILE_DATA))
#define GTKDOC_GENERATOR_FILE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_GENERATOR_TYPE_FILE_DATA, GtkdocGeneratorFileDataClass))

typedef struct _GtkdocGeneratorFileData GtkdocGeneratorFileData;
typedef struct _GtkdocGeneratorFileDataClass GtkdocGeneratorFileDataClass;

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;

#define GTKDOC_DBUS_TYPE_MEMBER (gtkdoc_dbus_member_get_type ())
#define GTKDOC_DBUS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMember))
#define GTKDOC_DBUS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))
#define GTKDOC_DBUS_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_MEMBER))
#define GTKDOC_DBUS_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_MEMBER, GtkdocDBusMemberClass))

typedef struct _GtkdocDBusMember GtkdocDBusMember;
typedef struct _GtkdocDBusMemberClass GtkdocDBusMemberClass;
enum  {
	GTKDOC_GENERATOR_0_PROPERTY,
	GTKDOC_GENERATOR_NUM_PROPERTIES
};
static GParamSpec* gtkdoc_generator_properties[GTKDOC_GENERATOR_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _gtkdoc_dbus_interface_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_interface_unref (var), NULL)))
#define _gtkdoc_dbus_member_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_member_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
#define _gtkdoc_text_writer_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_text_writer_unref (var), NULL)))
typedef struct _GtkdocGeneratorFileDataPrivate GtkdocGeneratorFileDataPrivate;

#define GTKDOC_TYPE_GCOMMENT (gtkdoc_gcomment_get_type ())
#define GTKDOC_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGComment))
#define GTKDOC_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))
#define GTKDOC_IS_GCOMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_IS_GCOMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_GCOMMENT))
#define GTKDOC_GCOMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_GCOMMENT, GtkdocGCommentClass))

typedef struct _GtkdocGComment GtkdocGComment;
typedef struct _GtkdocGCommentClass GtkdocGCommentClass;
#define _gtkdoc_generator_file_data_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_generator_file_data_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _gtkdoc_gcomment_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_gcomment_unref (var), NULL)))
typedef struct _GtkdocHeaderPrivate GtkdocHeaderPrivate;
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))
typedef struct _GtkdocGCommentPrivate GtkdocGCommentPrivate;

#define GTKDOC_TYPE_COMMENT_CONVERTER (gtkdoc_comment_converter_get_type ())
#define GTKDOC_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverter))
#define GTKDOC_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))
#define GTKDOC_IS_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_IS_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_COMMENT_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))

typedef struct _GtkdocCommentConverter GtkdocCommentConverter;
typedef struct _GtkdocCommentConverterClass GtkdocCommentConverterClass;
typedef struct _GtkdocCommentConverterPrivate GtkdocCommentConverterPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GtkdocDBusMemberPrivate GtkdocDBusMemberPrivate;

#define GTKDOC_DBUS_TYPE_PARAMETER (gtkdoc_dbus_parameter_get_type ())
#define GTKDOC_DBUS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameter))
#define GTKDOC_DBUS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))
#define GTKDOC_DBUS_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_DBUS_TYPE_PARAMETER))
#define GTKDOC_DBUS_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_DBUS_TYPE_PARAMETER, GtkdocDBusParameterClass))

typedef struct _GtkdocDBusParameter GtkdocDBusParameter;
typedef struct _GtkdocDBusParameterClass GtkdocDBusParameterClass;
typedef enum  {
	GTKDOC_DBUS_PARAMETER_DIRECTION_NONE,
	GTKDOC_DBUS_PARAMETER_DIRECTION_IN,
	GTKDOC_DBUS_PARAMETER_DIRECTION_OUT
} GtkdocDBusParameterDirection;

#define GTKDOC_DBUS_PARAMETER_TYPE_DIRECTION (gtkdoc_dbus_parameter_direction_get_type ())
#define _gtkdoc_dbus_parameter_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_dbus_parameter_unref (var), NULL)))
typedef struct _GtkdocGeneratorParamSpecFileData GtkdocGeneratorParamSpecFileData;

struct _GtkdocGenerator {
	ValadocApiVisitor parent_instance;
	ValaList* dbus_interfaces;
	GtkdocGeneratorPrivate * priv;
};

struct _GtkdocGeneratorClass {
	ValadocApiVisitorClass parent_class;
};

struct _GtkdocGeneratorPrivate {
	ValadocErrorReporter* reporter;
	ValadocSettings* settings;
	ValaMap* files_data;
	gchar* current_cname;
	ValaList* current_headers;
	ValadocApiTree* current_tree;
	ValadocApiClass* current_class;
	ValadocApiMethod* current_method;
	ValadocApiDelegate* current_delegate;
	ValadocApiSignal* current_signal;
	GtkdocDBusInterface* current_dbus_interface;
	GtkdocDBusMember* current_dbus_member;
};

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* filename;
	gchar* mode;
	GtkdocTextWriterPrivate * priv;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocGeneratorFileData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* filename;
	gchar* title;
	GtkdocGComment* section_comment;
	ValaList* comments;
	ValaList* section_lines;
	ValaList* standard_section_lines;
	ValaList* private_section_lines;
	GtkdocGeneratorFileDataPrivate * priv;
};

struct _GtkdocGeneratorFileDataClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGeneratorFileData *self);
};

struct _GtkdocHeader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	gchar** annotations;
	gint annotations_length1;
	gchar* value;
	gdouble pos;
	gboolean block;
	GtkdocHeaderPrivate * priv;
};

struct _GtkdocHeaderClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocHeader *self);
};

struct _GtkdocGComment {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* symbol;
	gchar** symbol_annotations;
	gint symbol_annotations_length1;
	ValaList* headers;
	gboolean short_description;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	gchar** returns_annotations;
	gint returns_annotations_length1;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	gboolean is_section;
	GtkdocGCommentPrivate * priv;
};

struct _GtkdocGCommentClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocGComment *self);
};

struct _GtkdocCommentConverter {
	ValadocContentContentVisitor parent_instance;
	ValadocApiNode* node_reference;
	gboolean is_dbus;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	ValaList* parameters;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	GtkdocCommentConverterPrivate * priv;
};

struct _GtkdocCommentConverterClass {
	ValadocContentContentVisitorClass parent_class;
};

struct _GtkdocDBusMember {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* name;
	ValaList* parameters;
	GtkdocGComment* comment;
	GtkdocDBusInterface* iface;
	GtkdocDBusMemberPrivate * priv;
};

struct _GtkdocDBusMemberClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocDBusMember *self);
};

struct _GtkdocGeneratorParamSpecFileData {
	GParamSpec parent_instance;
};

static gint GtkdocGenerator_private_offset;
static gpointer gtkdoc_generator_parent_class = NULL;
static gpointer gtkdoc_generator_file_data_parent_class = NULL;

GType gtkdoc_generator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGenerator, g_object_unref)
gpointer gtkdoc_dbus_interface_ref (gpointer instance);
void gtkdoc_dbus_interface_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_interface (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_interface (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_interface (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_interface (const GValue* value);
GType gtkdoc_dbus_interface_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusInterface, gtkdoc_dbus_interface_unref)
static gpointer gtkdoc_generator_file_data_ref (gpointer instance);
static void gtkdoc_generator_file_data_unref (gpointer instance);
static GParamSpec* gtkdoc_generator_param_spec_file_data (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags) G_GNUC_UNUSED;
static void gtkdoc_generator_value_set_file_data (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED;
static void gtkdoc_generator_value_take_file_data (GValue* value,
                                            gpointer v_object) G_GNUC_UNUSED;
static gpointer gtkdoc_generator_value_get_file_data (const GValue* value) G_GNUC_UNUSED;
static GType gtkdoc_generator_file_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGeneratorFileData, gtkdoc_generator_file_data_unref)
gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocHeader, gtkdoc_header_unref)
gpointer gtkdoc_dbus_member_ref (gpointer instance);
void gtkdoc_dbus_member_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_member (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_dbus_value_set_member (GValue* value,
                                   gpointer v_object);
void gtkdoc_dbus_value_take_member (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_dbus_value_get_member (const GValue* value);
GType gtkdoc_dbus_member_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusMember, gtkdoc_dbus_member_unref)
static gchar* gtkdoc_generator_combine_inline_docs (GtkdocGenerator* self,
                                             const gchar* str1,
                                             const gchar* str2);
static ValadocApiNode* gtkdoc_generator_get_current_method_or_delegate (GtkdocGenerator* self);
gboolean gtkdoc_generator_execute (GtkdocGenerator* self,
                                   ValadocSettings* settings,
                                   ValadocApiTree* tree,
                                   ValadocErrorReporter* reporter);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value,
                                   gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocTextWriter, gtkdoc_text_writer_unref)
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename,
                                          const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type,
                                                const gchar* filename,
                                                const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
gchar* gtkdoc_get_section (const gchar* filename);
gpointer gtkdoc_gcomment_ref (gpointer instance);
void gtkdoc_gcomment_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_gcomment (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void gtkdoc_value_set_gcomment (GValue* value,
                                gpointer v_object);
void gtkdoc_value_take_gcomment (GValue* value,
                                 gpointer v_object);
gpointer gtkdoc_value_get_gcomment (const GValue* value);
GType gtkdoc_gcomment_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocGComment, gtkdoc_gcomment_unref)
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                                    const gchar* line);
gchar* gtkdoc_gcomment_to_string (GtkdocGComment* self);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
ValaSet* gtkdoc_generator_get_filenames (GtkdocGenerator* self);
static GtkdocGeneratorFileData* gtkdoc_generator_get_file_data (GtkdocGenerator* self,
                                                         const gchar* filename);
static GtkdocGeneratorFileData* gtkdoc_generator_file_data_new (void);
static GtkdocGeneratorFileData* gtkdoc_generator_file_data_construct (GType object_type);
static ValaList* gtkdoc_generator_merge_headers (GtkdocGenerator* self,
                                          ValaList* doc_headers,
                                          ValaList* lang_headers);
static gchar** _vala_array_dup4 (gchar** self,
                          gint length);
static void gtkdoc_generator_set_section_comment (GtkdocGenerator* self,
                                           const gchar* filename,
                                           const gchar* section_name,
                                           ValadocContentComment* comment,
                                           const gchar* symbol_full_name);
static GtkdocGComment* gtkdoc_generator_create_gcomment (GtkdocGenerator* self,
                                                  const gchar* symbol,
                                                  ValadocContentComment* comment,
                                                  gchar** returns_annotations,
                                                  gint returns_annotations_length1,
                                                  gboolean is_dbus);
GType gtkdoc_comment_converter_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocCommentConverter, g_object_unref)
GtkdocCommentConverter* gtkdoc_comment_converter_new (ValadocErrorReporter* reporter,
                                                      ValadocApiNode* node_reference);
GtkdocCommentConverter* gtkdoc_comment_converter_construct (GType object_type,
                                                            ValadocErrorReporter* reporter,
                                                            ValadocApiNode* node_reference);
void gtkdoc_comment_converter_convert (GtkdocCommentConverter* self,
                                       ValadocContentComment* comment,
                                       gboolean is_dbus);
GtkdocGComment* gtkdoc_gcomment_new (void);
GtkdocGComment* gtkdoc_gcomment_construct (GType object_type);
static gchar** _vala_array_dup5 (gchar** self,
                          gint length);
static gchar** _vala_array_dup6 (gchar** self,
                          gint length);
static GtkdocGComment* gtkdoc_generator_add_comment (GtkdocGenerator* self,
                                              const gchar* filename,
                                              const gchar* symbol,
                                              ValadocContentComment* comment);
static GtkdocGComment* gtkdoc_generator_add_symbol (GtkdocGenerator* self,
                                             const gchar* filename,
                                             const gchar* cname,
                                             ValadocContentComment* comment,
                                             const gchar* symbol,
                                             gchar** returns_annotations,
                                             gint returns_annotations_length1);
static void gtkdoc_generator_file_data_register_section_line (GtkdocGeneratorFileData* self,
                                                       const gchar* line);
static GtkdocHeader* gtkdoc_generator_add_custom_header (GtkdocGenerator* self,
                                                  const gchar* name,
                                                  const gchar* comment,
                                                  gchar** annotations,
                                                  gint annotations_length1,
                                                  gdouble pos,
                                                  gboolean block);
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
static gchar** _vala_array_dup7 (gchar** self,
                          gint length);
static GtkdocHeader* gtkdoc_generator_remove_custom_header (GtkdocGenerator* self,
                                                     const gchar* name);
static GtkdocHeader* gtkdoc_generator_add_header (GtkdocGenerator* self,
                                           const gchar* name,
                                           ValadocContentComment* comment,
                                           gchar** annotations,
                                           gint annotations_length1,
                                           gdouble pos);
static gchar** _vala_array_dup8 (gchar** self,
                          gint length);
static void gtkdoc_generator_real_visit_tree (ValadocApiVisitor* base,
                                       ValadocApiTree* tree);
static void gtkdoc_generator_real_visit_package (ValadocApiVisitor* base,
                                          ValadocApiPackage* package);
static void gtkdoc_generator_real_visit_namespace (ValadocApiVisitor* base,
                                            ValadocApiNamespace* ns);
static void gtkdoc_generator_real_visit_interface (ValadocApiVisitor* base,
                                            ValadocApiInterface* iface);
GtkdocDBusInterface* gtkdoc_dbus_interface_new (const gchar* package_name,
                                                const gchar* name,
                                                const gchar* purpose,
                                                const gchar* description);
GtkdocDBusInterface* gtkdoc_dbus_interface_construct (GType object_type,
                                                      const gchar* package_name,
                                                      const gchar* name,
                                                      const gchar* purpose,
                                                      const gchar* description);
gboolean gtkdoc_dbus_interface_write (GtkdocDBusInterface* self,
                                      ValadocSettings* settings,
                                      ValadocErrorReporter* reporter);
static void gtkdoc_generator_process_attributes (GtkdocGenerator* self,
                                          ValadocApiSymbol* sym,
                                          GtkdocGComment* gcomment);
static void gtkdoc_generator_visit_abstract_method (GtkdocGenerator* self,
                                             ValadocApiMethod* m);
static void gtkdoc_generator_visit_abstract_property (GtkdocGenerator* self,
                                               ValadocApiProperty* prop);
gchar* gtkdoc_get_docbook_link (ValadocApiItem* item,
                                gboolean is_dbus,
                                gboolean is_async_finish);
static void gtkdoc_generator_file_data_register_standard_section_line (GtkdocGeneratorFileData* self,
                                                                const gchar* line);
static void gtkdoc_generator_real_visit_class (ValadocApiVisitor* base,
                                        ValadocApiClass* cl);
gchar* gtkdoc_get_docbook_type_link (ValadocApiClass* cls);
gchar* gtkdoc_to_docbook_id (const gchar* name);
static void gtkdoc_generator_file_data_register_private_section_line (GtkdocGeneratorFileData* self,
                                                               const gchar* line);
gchar* gtkdoc_to_lower_case (const gchar* camel);
static gchar** gtkdoc_generator_create_see_function_array (GtkdocGenerator* self,
                                                    gchar** functions,
                                                    gint functions_length1,
                                                    gint* result_length1);
static void _vala_array_add19 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup9 (gchar** self,
                          gint length);
static void gtkdoc_generator_real_visit_struct (ValadocApiVisitor* base,
                                         ValadocApiStruct* st);
static void gtkdoc_generator_visit_thrown_error_domain (GtkdocGenerator* self,
                                                 ValadocApiNode* _error_);
static void gtkdoc_generator_real_visit_error_domain (ValadocApiVisitor* base,
                                               ValadocApiErrorDomain* edomain);
static void gtkdoc_generator_real_visit_error_code (ValadocApiVisitor* base,
                                             ValadocApiErrorCode* ecode);
static void gtkdoc_generator_real_visit_enum (ValadocApiVisitor* base,
                                       ValadocApiEnum* en);
static void gtkdoc_generator_real_visit_enum_value (ValadocApiVisitor* base,
                                             ValadocApiEnumValue* eval);
static gchar* gtkdoc_generator_combine_comments (GtkdocGenerator* self,
                                          const gchar* brief,
                                          const gchar* _long_);
static void gtkdoc_generator_real_visit_property (ValadocApiVisitor* base,
                                           ValadocApiProperty* prop);
gchar* gtkdoc_get_cname (ValadocApiItem* item);
static void gtkdoc_generator_real_visit_field (ValadocApiVisitor* base,
                                        ValadocApiField* f);
static void gtkdoc_generator_real_visit_constant (ValadocApiVisitor* base,
                                           ValadocApiConstant* c);
static void gtkdoc_generator_real_visit_delegate (ValadocApiVisitor* base,
                                           ValadocApiDelegate* d);
static void gtkdoc_generator_real_visit_signal (ValadocApiVisitor* base,
                                         ValadocApiSignal* sig);
GtkdocDBusMember* gtkdoc_dbus_member_new (const gchar* name);
GtkdocDBusMember* gtkdoc_dbus_member_construct (GType object_type,
                                                const gchar* name);
gpointer gtkdoc_dbus_parameter_ref (gpointer instance);
void gtkdoc_dbus_parameter_unref (gpointer instance);
GParamSpec* gtkdoc_dbus_param_spec_parameter (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void gtkdoc_dbus_value_set_parameter (GValue* value,
                                      gpointer v_object);
void gtkdoc_dbus_value_take_parameter (GValue* value,
                                       gpointer v_object);
gpointer gtkdoc_dbus_value_get_parameter (const GValue* value);
GType gtkdoc_dbus_parameter_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocDBusParameter, gtkdoc_dbus_parameter_unref)
void gtkdoc_dbus_interface_add_signal (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
static void gtkdoc_generator_real_visit_method (ValadocApiVisitor* base,
                                         ValadocApiMethod* m);
static void _vala_array_add20 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add21 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup10 (gchar** self,
                           gint length);
static void _vala_array_add22 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup11 (gchar** self,
                           gint length);
GType gtkdoc_dbus_parameter_direction_get_type (void) G_GNUC_CONST;
GtkdocDBusParameter* gtkdoc_dbus_parameter_new (const gchar* name,
                                                const gchar* signature,
                                                GtkdocDBusParameterDirection direction);
GtkdocDBusParameter* gtkdoc_dbus_parameter_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* signature,
                                                      GtkdocDBusParameterDirection direction);
void gtkdoc_dbus_member_add_parameter (GtkdocDBusMember* self,
                                       GtkdocDBusParameter* parameter);
void gtkdoc_dbus_interface_add_method (GtkdocDBusInterface* self,
                                       GtkdocDBusMember* member);
static gchar** _vala_array_dup12 (gchar** self,
                           gint length);
static void _vala_array_add23 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar** _vala_array_dup13 (gchar** self,
                           gint length);
static void gtkdoc_generator_real_visit_formal_parameter (ValadocApiVisitor* base,
                                                   ValadocApiParameter* param);
static void _vala_array_add24 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add25 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add26 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node,
                                  const gchar* name);
static void _vala_array_add28 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
gchar* gtkdoc_get_gtkdoc_link (ValadocApiNode* symbol);
GtkdocGenerator* gtkdoc_generator_new (void);
GtkdocGenerator* gtkdoc_generator_construct (GType object_type);
static void gtkdoc_generator_file_data_finalize (GtkdocGeneratorFileData * obj);
static GType gtkdoc_generator_file_data_get_type_once (void);
static void gtkdoc_generator_finalize (GObject * obj);
static GType gtkdoc_generator_get_type_once (void);
static void _vala_gtkdoc_generator_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gtkdoc_generator_get_instance_private (GtkdocGenerator* self)
{
	return G_STRUCT_MEMBER_P (self, GtkdocGenerator_private_offset);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
gtkdoc_generator_combine_inline_docs (GtkdocGenerator* self,
                                      const gchar* str1,
                                      const gchar* str2)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GString* _tmp5_;
	GString* _tmp12_;
	gchar* _tmp13_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (str1 != NULL) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = builder;
		_tmp2_ = g_strchomp (str1);
		g_string_append (_tmp1_, _tmp2_);
	}
	_tmp5_ = builder;
	if (_tmp5_->len > ((gssize) 0)) {
		GString* _tmp6_;
		const gchar* _tmp7_;
		GString* _tmp8_;
		_tmp6_ = builder;
		_tmp7_ = _tmp6_->str;
		_tmp8_ = builder;
		_tmp4_ = string_get (_tmp7_, (glong) (_tmp8_->len - 1)) != '.';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = str2 != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GString* _tmp9_;
		_tmp9_ = builder;
		g_string_append (_tmp9_, ". ");
	}
	if (str2 != NULL) {
		GString* _tmp10_;
		GString* _tmp11_;
		_tmp10_ = builder;
		g_string_append_c (_tmp10_, ' ');
		_tmp11_ = builder;
		g_string_append (_tmp11_, str2);
	}
	_tmp12_ = builder;
	_tmp13_ = _tmp12_->str;
	_tmp12_->str = NULL;
	result = _tmp13_;
	_g_string_free0 (builder);
	return result;
}

static ValadocApiNode*
gtkdoc_generator_get_current_method_or_delegate (GtkdocGenerator* self)
{
	ValadocApiNode* result;
	ValadocApiMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_method;
	if (_tmp0_ != NULL) {
		ValadocApiMethod* _tmp1_;
		_tmp1_ = self->priv->current_method;
		result = (ValadocApiNode*) _tmp1_;
		return result;
	} else {
		ValadocApiDelegate* _tmp2_;
		_tmp2_ = self->priv->current_delegate;
		if (_tmp2_ != NULL) {
			ValadocApiDelegate* _tmp3_;
			_tmp3_ = self->priv->current_delegate;
			result = (ValadocApiNode*) _tmp3_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

gboolean
gtkdoc_generator_execute (GtkdocGenerator* self,
                          ValadocSettings* settings,
                          ValadocApiTree* tree,
                          ValadocErrorReporter* reporter)
{
	ValadocSettings* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocApiTree* _tmp2_;
	gchar* code_dir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* sections = NULL;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkdocTextWriter* sections_writer = NULL;
	const gchar* _tmp12_;
	GtkdocTextWriter* _tmp13_;
	GtkdocTextWriter* _tmp14_;
	GtkdocTextWriter* _tmp112_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	g_return_val_if_fail (tree != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	_tmp2_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->priv->current_tree);
	self->priv->current_tree = _tmp2_;
	valadoc_api_tree_accept (tree, (ValadocApiVisitor*) self);
	_tmp3_ = settings->path;
	_tmp4_ = g_build_filename (_tmp3_, "ccomments", NULL);
	code_dir = _tmp4_;
	_tmp5_ = settings->path;
	_tmp6_ = settings->pkg_name;
	_tmp7_ = g_strdup_printf ("%s-sections.txt", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_filename (_tmp5_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	sections = _tmp10_;
	_tmp11_ = code_dir;
	g_mkdir_with_parents (_tmp11_, 0777);
	_tmp12_ = sections;
	_tmp13_ = gtkdoc_text_writer_new (_tmp12_, "a");
	sections_writer = _tmp13_;
	_tmp14_ = sections_writer;
	if (!gtkdoc_text_writer_open (_tmp14_)) {
		GtkdocTextWriter* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = sections_writer;
		_tmp16_ = _tmp15_->filename;
		valadoc_error_reporter_simple_error (reporter, "GtkDoc", "unable to open '%s' for writing", _tmp16_);
		result = FALSE;
		_gtkdoc_text_writer_unref0 (sections_writer);
		_g_free0 (sections);
		_g_free0 (code_dir);
		return result;
	}
	{
		ValaIterator* _file_data_it = NULL;
		ValaMap* _tmp17_;
		ValaCollection* _tmp18_;
		ValaCollection* _tmp19_;
		ValaIterator* _tmp20_;
		ValaIterator* _tmp21_;
		_tmp17_ = self->priv->files_data;
		_tmp18_ = vala_map_get_values (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_iterable_iterator ((ValaIterable*) _tmp19_);
		_tmp21_ = _tmp20_;
		_vala_iterable_unref0 (_tmp19_);
		_file_data_it = _tmp21_;
		while (TRUE) {
			ValaIterator* _tmp22_;
			GtkdocGeneratorFileData* file_data = NULL;
			ValaIterator* _tmp23_;
			gpointer _tmp24_;
			gchar* basename = NULL;
			GtkdocGeneratorFileData* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			GtkdocTextWriter* cwriter = NULL;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GtkdocTextWriter* _tmp34_;
			GtkdocTextWriter* _tmp35_;
			GtkdocTextWriter* _tmp36_;
			GtkdocGeneratorFileData* _tmp39_;
			GtkdocGComment* _tmp40_;
			GtkdocTextWriter* _tmp58_;
			GtkdocTextWriter* _tmp59_;
			GtkdocTextWriter* _tmp60_;
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			GtkdocGeneratorFileData* _tmp64_;
			const gchar* _tmp65_;
			GtkdocGeneratorFileData* _tmp81_;
			ValaList* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			GtkdocGeneratorFileData* _tmp96_;
			ValaList* _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			GtkdocTextWriter* _tmp111_;
			_tmp22_ = _file_data_it;
			if (!vala_iterator_next (_tmp22_)) {
				break;
			}
			_tmp23_ = _file_data_it;
			_tmp24_ = vala_iterator_get (_tmp23_);
			file_data = (GtkdocGeneratorFileData*) _tmp24_;
			_tmp25_ = file_data;
			_tmp26_ = _tmp25_->filename;
			_tmp27_ = gtkdoc_get_section (_tmp26_);
			basename = _tmp27_;
			_tmp28_ = code_dir;
			_tmp29_ = basename;
			_tmp30_ = g_strdup_printf ("%s.c", _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_build_filename (_tmp28_, _tmp31_, NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = gtkdoc_text_writer_new (_tmp33_, "w");
			_tmp35_ = _tmp34_;
			_g_free0 (_tmp33_);
			_g_free0 (_tmp31_);
			cwriter = _tmp35_;
			_tmp36_ = cwriter;
			if (!gtkdoc_text_writer_open (_tmp36_)) {
				GtkdocTextWriter* _tmp37_;
				const gchar* _tmp38_;
				_tmp37_ = cwriter;
				_tmp38_ = _tmp37_->filename;
				valadoc_error_reporter_simple_error (reporter, "GtkDoc", "unable to open '%s' for writing", _tmp38_);
				result = FALSE;
				_gtkdoc_text_writer_unref0 (cwriter);
				_g_free0 (basename);
				_gtkdoc_generator_file_data_unref0 (file_data);
				_vala_iterator_unref0 (_file_data_it);
				_gtkdoc_text_writer_unref0 (sections_writer);
				_g_free0 (sections);
				_g_free0 (code_dir);
				return result;
			}
			_tmp39_ = file_data;
			_tmp40_ = _tmp39_->section_comment;
			if (_tmp40_ != NULL) {
				GtkdocTextWriter* _tmp41_;
				GtkdocGeneratorFileData* _tmp42_;
				GtkdocGComment* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp41_ = cwriter;
				_tmp42_ = file_data;
				_tmp43_ = _tmp42_->section_comment;
				_tmp44_ = gtkdoc_gcomment_to_string (_tmp43_);
				_tmp45_ = _tmp44_;
				gtkdoc_text_writer_write_line (_tmp41_, _tmp45_);
				_g_free0 (_tmp45_);
			}
			{
				ValaList* _comment_list = NULL;
				GtkdocGeneratorFileData* _tmp46_;
				ValaList* _tmp47_;
				ValaList* _tmp48_;
				gint _comment_size = 0;
				ValaList* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _comment_index = 0;
				_tmp46_ = file_data;
				_tmp47_ = _tmp46_->comments;
				_tmp48_ = _vala_iterable_ref0 (_tmp47_);
				_comment_list = _tmp48_;
				_tmp49_ = _comment_list;
				_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
				_tmp51_ = _tmp50_;
				_comment_size = _tmp51_;
				_comment_index = -1;
				while (TRUE) {
					GtkdocGComment* comment = NULL;
					ValaList* _tmp52_;
					gpointer _tmp53_;
					GtkdocTextWriter* _tmp54_;
					GtkdocGComment* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					_comment_index = _comment_index + 1;
					if (!(_comment_index < _comment_size)) {
						break;
					}
					_tmp52_ = _comment_list;
					_tmp53_ = vala_list_get (_tmp52_, _comment_index);
					comment = (GtkdocGComment*) _tmp53_;
					_tmp54_ = cwriter;
					_tmp55_ = comment;
					_tmp56_ = gtkdoc_gcomment_to_string (_tmp55_);
					_tmp57_ = _tmp56_;
					gtkdoc_text_writer_write_line (_tmp54_, _tmp57_);
					_g_free0 (_tmp57_);
					_gtkdoc_gcomment_unref0 (comment);
				}
				_vala_iterable_unref0 (_comment_list);
			}
			_tmp58_ = cwriter;
			gtkdoc_text_writer_close (_tmp58_);
			_tmp59_ = sections_writer;
			gtkdoc_text_writer_write_line (_tmp59_, "<SECTION>");
			_tmp60_ = sections_writer;
			_tmp61_ = basename;
			_tmp62_ = g_strdup_printf ("<FILE>%s</FILE>", _tmp61_);
			_tmp63_ = _tmp62_;
			gtkdoc_text_writer_write_line (_tmp60_, _tmp63_);
			_g_free0 (_tmp63_);
			_tmp64_ = file_data;
			_tmp65_ = _tmp64_->title;
			if (_tmp65_ != NULL) {
				GtkdocTextWriter* _tmp66_;
				GtkdocGeneratorFileData* _tmp67_;
				const gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp66_ = sections_writer;
				_tmp67_ = file_data;
				_tmp68_ = _tmp67_->title;
				_tmp69_ = g_strdup_printf ("<TITLE>%s</TITLE>", _tmp68_);
				_tmp70_ = _tmp69_;
				gtkdoc_text_writer_write_line (_tmp66_, _tmp70_);
				_g_free0 (_tmp70_);
			}
			{
				ValaList* _section_line_list = NULL;
				GtkdocGeneratorFileData* _tmp71_;
				ValaList* _tmp72_;
				ValaList* _tmp73_;
				gint _section_line_size = 0;
				ValaList* _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				gint _section_line_index = 0;
				_tmp71_ = file_data;
				_tmp72_ = _tmp71_->section_lines;
				_tmp73_ = _vala_iterable_ref0 (_tmp72_);
				_section_line_list = _tmp73_;
				_tmp74_ = _section_line_list;
				_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
				_tmp76_ = _tmp75_;
				_section_line_size = _tmp76_;
				_section_line_index = -1;
				while (TRUE) {
					gchar* section_line = NULL;
					ValaList* _tmp77_;
					gpointer _tmp78_;
					GtkdocTextWriter* _tmp79_;
					const gchar* _tmp80_;
					_section_line_index = _section_line_index + 1;
					if (!(_section_line_index < _section_line_size)) {
						break;
					}
					_tmp77_ = _section_line_list;
					_tmp78_ = vala_list_get (_tmp77_, _section_line_index);
					section_line = (gchar*) _tmp78_;
					_tmp79_ = sections_writer;
					_tmp80_ = section_line;
					gtkdoc_text_writer_write_line (_tmp79_, _tmp80_);
					_g_free0 (section_line);
				}
				_vala_iterable_unref0 (_section_line_list);
			}
			_tmp81_ = file_data;
			_tmp82_ = _tmp81_->standard_section_lines;
			_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
			_tmp84_ = _tmp83_;
			if (_tmp84_ > 0) {
				GtkdocTextWriter* _tmp85_;
				_tmp85_ = sections_writer;
				gtkdoc_text_writer_write_line (_tmp85_, "<SUBSECTION Standard>");
				{
					ValaList* _section_line_list = NULL;
					GtkdocGeneratorFileData* _tmp86_;
					ValaList* _tmp87_;
					ValaList* _tmp88_;
					gint _section_line_size = 0;
					ValaList* _tmp89_;
					gint _tmp90_;
					gint _tmp91_;
					gint _section_line_index = 0;
					_tmp86_ = file_data;
					_tmp87_ = _tmp86_->standard_section_lines;
					_tmp88_ = _vala_iterable_ref0 (_tmp87_);
					_section_line_list = _tmp88_;
					_tmp89_ = _section_line_list;
					_tmp90_ = vala_collection_get_size ((ValaCollection*) _tmp89_);
					_tmp91_ = _tmp90_;
					_section_line_size = _tmp91_;
					_section_line_index = -1;
					while (TRUE) {
						gchar* section_line = NULL;
						ValaList* _tmp92_;
						gpointer _tmp93_;
						GtkdocTextWriter* _tmp94_;
						const gchar* _tmp95_;
						_section_line_index = _section_line_index + 1;
						if (!(_section_line_index < _section_line_size)) {
							break;
						}
						_tmp92_ = _section_line_list;
						_tmp93_ = vala_list_get (_tmp92_, _section_line_index);
						section_line = (gchar*) _tmp93_;
						_tmp94_ = sections_writer;
						_tmp95_ = section_line;
						gtkdoc_text_writer_write_line (_tmp94_, _tmp95_);
						_g_free0 (section_line);
					}
					_vala_iterable_unref0 (_section_line_list);
				}
			}
			_tmp96_ = file_data;
			_tmp97_ = _tmp96_->private_section_lines;
			_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
			_tmp99_ = _tmp98_;
			if (_tmp99_ > 0) {
				GtkdocTextWriter* _tmp100_;
				_tmp100_ = sections_writer;
				gtkdoc_text_writer_write_line (_tmp100_, "<SUBSECTION Private>");
				{
					ValaList* _section_line_list = NULL;
					GtkdocGeneratorFileData* _tmp101_;
					ValaList* _tmp102_;
					ValaList* _tmp103_;
					gint _section_line_size = 0;
					ValaList* _tmp104_;
					gint _tmp105_;
					gint _tmp106_;
					gint _section_line_index = 0;
					_tmp101_ = file_data;
					_tmp102_ = _tmp101_->private_section_lines;
					_tmp103_ = _vala_iterable_ref0 (_tmp102_);
					_section_line_list = _tmp103_;
					_tmp104_ = _section_line_list;
					_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
					_tmp106_ = _tmp105_;
					_section_line_size = _tmp106_;
					_section_line_index = -1;
					while (TRUE) {
						gchar* section_line = NULL;
						ValaList* _tmp107_;
						gpointer _tmp108_;
						GtkdocTextWriter* _tmp109_;
						const gchar* _tmp110_;
						_section_line_index = _section_line_index + 1;
						if (!(_section_line_index < _section_line_size)) {
							break;
						}
						_tmp107_ = _section_line_list;
						_tmp108_ = vala_list_get (_tmp107_, _section_line_index);
						section_line = (gchar*) _tmp108_;
						_tmp109_ = sections_writer;
						_tmp110_ = section_line;
						gtkdoc_text_writer_write_line (_tmp109_, _tmp110_);
						_g_free0 (section_line);
					}
					_vala_iterable_unref0 (_section_line_list);
				}
			}
			_tmp111_ = sections_writer;
			gtkdoc_text_writer_write_line (_tmp111_, "</SECTION>");
			_gtkdoc_text_writer_unref0 (cwriter);
			_g_free0 (basename);
			_gtkdoc_generator_file_data_unref0 (file_data);
		}
		_vala_iterator_unref0 (_file_data_it);
	}
	_tmp112_ = sections_writer;
	gtkdoc_text_writer_close (_tmp112_);
	result = TRUE;
	_gtkdoc_text_writer_unref0 (sections_writer);
	_g_free0 (sections);
	_g_free0 (code_dir);
	return result;
}

ValaSet*
gtkdoc_generator_get_filenames (GtkdocGenerator* self)
{
	ValaMap* _tmp0_;
	ValaSet* _tmp1_;
	ValaSet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->files_data;
	_tmp1_ = vala_map_get_keys (_tmp0_);
	result = _tmp1_;
	return result;
}

static GtkdocGeneratorFileData*
gtkdoc_generator_get_file_data (GtkdocGenerator* self,
                                const gchar* filename)
{
	GtkdocGeneratorFileData* file_data = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	GtkdocGeneratorFileData* _tmp2_;
	GtkdocGeneratorFileData* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = self->priv->files_data;
	_tmp1_ = vala_map_get (_tmp0_, filename);
	file_data = (GtkdocGeneratorFileData*) _tmp1_;
	_tmp2_ = file_data;
	if (_tmp2_ == NULL) {
		GtkdocGeneratorFileData* _tmp3_;
		GtkdocGeneratorFileData* _tmp4_;
		gchar* _tmp5_;
		GtkdocGeneratorFileData* _tmp6_;
		GtkdocGeneratorFileData* _tmp7_;
		GtkdocGeneratorFileData* _tmp8_;
		GEqualFunc _tmp9_;
		ValaArrayList* _tmp10_;
		GtkdocGeneratorFileData* _tmp11_;
		GEqualFunc _tmp12_;
		ValaArrayList* _tmp13_;
		GtkdocGeneratorFileData* _tmp14_;
		GEqualFunc _tmp15_;
		ValaArrayList* _tmp16_;
		GtkdocGeneratorFileData* _tmp17_;
		GEqualFunc _tmp18_;
		ValaArrayList* _tmp19_;
		ValaMap* _tmp20_;
		GtkdocGeneratorFileData* _tmp21_;
		_tmp3_ = gtkdoc_generator_file_data_new ();
		_gtkdoc_generator_file_data_unref0 (file_data);
		file_data = _tmp3_;
		_tmp4_ = file_data;
		_tmp5_ = g_strdup (filename);
		_g_free0 (_tmp4_->filename);
		_tmp4_->filename = _tmp5_;
		_tmp6_ = file_data;
		_g_free0 (_tmp6_->title);
		_tmp6_->title = NULL;
		_tmp7_ = file_data;
		_gtkdoc_gcomment_unref0 (_tmp7_->section_comment);
		_tmp7_->section_comment = NULL;
		_tmp8_ = file_data;
		_tmp9_ = g_direct_equal;
		_tmp10_ = vala_array_list_new (GTKDOC_TYPE_GCOMMENT, (GBoxedCopyFunc) gtkdoc_gcomment_ref, (GDestroyNotify) gtkdoc_gcomment_unref, _tmp9_);
		_vala_iterable_unref0 (_tmp8_->comments);
		_tmp8_->comments = (ValaList*) _tmp10_;
		_tmp11_ = file_data;
		_tmp12_ = g_str_equal;
		_tmp13_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp12_);
		_vala_iterable_unref0 (_tmp11_->section_lines);
		_tmp11_->section_lines = (ValaList*) _tmp13_;
		_tmp14_ = file_data;
		_tmp15_ = g_str_equal;
		_tmp16_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp15_);
		_vala_iterable_unref0 (_tmp14_->standard_section_lines);
		_tmp14_->standard_section_lines = (ValaList*) _tmp16_;
		_tmp17_ = file_data;
		_tmp18_ = g_str_equal;
		_tmp19_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp18_);
		_vala_iterable_unref0 (_tmp17_->private_section_lines);
		_tmp17_->private_section_lines = (ValaList*) _tmp19_;
		_tmp20_ = self->priv->files_data;
		_tmp21_ = file_data;
		vala_map_set (_tmp20_, filename, _tmp21_);
	}
	result = file_data;
	return result;
}

static gpointer
_gtkdoc_header_ref0 (gpointer self)
{
	return self ? gtkdoc_header_ref (self) : NULL;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static ValaList*
gtkdoc_generator_merge_headers (GtkdocGenerator* self,
                                ValaList* doc_headers,
                                ValaList* lang_headers)
{
	ValaArrayList* headers = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (doc_headers != NULL, NULL);
	if (lang_headers == NULL) {
		ValaList* _tmp0_;
		_tmp0_ = _vala_iterable_ref0 (doc_headers);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp1_);
	headers = _tmp2_;
	{
		ValaList* _doc_header_list = NULL;
		ValaList* _tmp3_;
		gint _doc_header_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _doc_header_index = 0;
		_tmp3_ = _vala_iterable_ref0 (doc_headers);
		_doc_header_list = _tmp3_;
		_tmp4_ = _doc_header_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_doc_header_size = _tmp6_;
		_doc_header_index = -1;
		while (TRUE) {
			GtkdocHeader* doc_header = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			GtkdocHeader* header = NULL;
			GtkdocHeader* _tmp9_;
			GtkdocHeader* _tmp10_;
			ValaArrayList* _tmp42_;
			GtkdocHeader* _tmp43_;
			_doc_header_index = _doc_header_index + 1;
			if (!(_doc_header_index < _doc_header_size)) {
				break;
			}
			_tmp7_ = _doc_header_list;
			_tmp8_ = vala_list_get (_tmp7_, _doc_header_index);
			doc_header = (GtkdocHeader*) _tmp8_;
			_tmp9_ = doc_header;
			_tmp10_ = _gtkdoc_header_ref0 (_tmp9_);
			header = _tmp10_;
			{
				ValaList* _lang_header_list = NULL;
				ValaList* _tmp11_;
				gint _lang_header_size = 0;
				ValaList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _lang_header_index = 0;
				_tmp11_ = _vala_iterable_ref0 (lang_headers);
				_lang_header_list = _tmp11_;
				_tmp12_ = _lang_header_list;
				_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_lang_header_size = _tmp14_;
				_lang_header_index = -1;
				while (TRUE) {
					GtkdocHeader* lang_header = NULL;
					ValaList* _tmp15_;
					gpointer _tmp16_;
					GtkdocHeader* _tmp17_;
					const gchar* _tmp18_;
					GtkdocHeader* _tmp19_;
					const gchar* _tmp20_;
					_lang_header_index = _lang_header_index + 1;
					if (!(_lang_header_index < _lang_header_size)) {
						break;
					}
					_tmp15_ = _lang_header_list;
					_tmp16_ = vala_list_get (_tmp15_, _lang_header_index);
					lang_header = (GtkdocHeader*) _tmp16_;
					_tmp17_ = doc_header;
					_tmp18_ = _tmp17_->name;
					_tmp19_ = lang_header;
					_tmp20_ = _tmp19_->name;
					if (g_strcmp0 (_tmp18_, _tmp20_) == 0) {
						GtkdocHeader* _tmp21_;
						GtkdocHeader* _tmp22_;
						gchar** _tmp23_;
						gint _tmp23__length1;
						gchar** _tmp24_;
						gint _tmp24__length1;
						GtkdocHeader* _tmp25_;
						const gchar* _tmp26_;
						GtkdocHeader* _tmp27_;
						_tmp21_ = header;
						_tmp22_ = lang_header;
						_tmp23_ = _tmp22_->annotations;
						_tmp23__length1 = _tmp22_->annotations_length1;
						_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup4 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
						_tmp24__length1 = _tmp23__length1;
						_tmp21_->annotations = (_vala_array_free (_tmp21_->annotations, _tmp21_->annotations_length1, (GDestroyNotify) g_free), NULL);
						_tmp21_->annotations = _tmp24_;
						_tmp21_->annotations_length1 = _tmp24__length1;
						_tmp25_ = lang_header;
						_tmp26_ = _tmp25_->value;
						if (_tmp26_ == NULL) {
							_gtkdoc_header_unref0 (lang_header);
							continue;
						}
						_tmp27_ = lang_header;
						if (_tmp27_->block) {
							GtkdocHeader* _tmp28_;
							GtkdocHeader* _tmp29_;
							const gchar* _tmp30_;
							GtkdocHeader* _tmp31_;
							const gchar* _tmp32_;
							gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp28_ = header;
							_tmp29_ = header;
							_tmp30_ = _tmp29_->value;
							_tmp31_ = lang_header;
							_tmp32_ = _tmp31_->value;
							_tmp33_ = g_strdup_printf ("<para>%s</para>", _tmp32_);
							_tmp34_ = _tmp33_;
							_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
							_g_free0 (_tmp29_->value);
							_tmp29_->value = _tmp35_;
							_g_free0 (_tmp34_);
						} else {
							GtkdocHeader* _tmp36_;
							GtkdocHeader* _tmp37_;
							const gchar* _tmp38_;
							GtkdocHeader* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp36_ = header;
							_tmp37_ = lang_header;
							_tmp38_ = _tmp37_->value;
							_tmp39_ = header;
							_tmp40_ = _tmp39_->value;
							_tmp41_ = gtkdoc_generator_combine_inline_docs (self, _tmp38_, _tmp40_);
							_g_free0 (_tmp36_->value);
							_tmp36_->value = _tmp41_;
						}
					}
					_gtkdoc_header_unref0 (lang_header);
				}
				_vala_iterable_unref0 (_lang_header_list);
			}
			_tmp42_ = headers;
			_tmp43_ = header;
			vala_collection_add ((ValaCollection*) _tmp42_, _tmp43_);
			_gtkdoc_header_unref0 (header);
			_gtkdoc_header_unref0 (doc_header);
		}
		_vala_iterable_unref0 (_doc_header_list);
	}
	{
		ValaList* _lang_header_list = NULL;
		ValaList* _tmp44_;
		gint _lang_header_size = 0;
		ValaList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _lang_header_index = 0;
		_tmp44_ = _vala_iterable_ref0 (lang_headers);
		_lang_header_list = _tmp44_;
		_tmp45_ = _lang_header_list;
		_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
		_tmp47_ = _tmp46_;
		_lang_header_size = _tmp47_;
		_lang_header_index = -1;
		while (TRUE) {
			GtkdocHeader* lang_header = NULL;
			ValaList* _tmp48_;
			gpointer _tmp49_;
			gboolean found = FALSE;
			gboolean _tmp61_ = FALSE;
			_lang_header_index = _lang_header_index + 1;
			if (!(_lang_header_index < _lang_header_size)) {
				break;
			}
			_tmp48_ = _lang_header_list;
			_tmp49_ = vala_list_get (_tmp48_, _lang_header_index);
			lang_header = (GtkdocHeader*) _tmp49_;
			found = FALSE;
			{
				ValaArrayList* _header_list = NULL;
				ValaArrayList* _tmp50_;
				ValaArrayList* _tmp51_;
				gint _header_size = 0;
				ValaArrayList* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				gint _header_index = 0;
				_tmp50_ = headers;
				_tmp51_ = _vala_iterable_ref0 (_tmp50_);
				_header_list = _tmp51_;
				_tmp52_ = _header_list;
				_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
				_tmp54_ = _tmp53_;
				_header_size = _tmp54_;
				_header_index = -1;
				while (TRUE) {
					GtkdocHeader* header = NULL;
					ValaArrayList* _tmp55_;
					gpointer _tmp56_;
					GtkdocHeader* _tmp57_;
					const gchar* _tmp58_;
					GtkdocHeader* _tmp59_;
					const gchar* _tmp60_;
					_header_index = _header_index + 1;
					if (!(_header_index < _header_size)) {
						break;
					}
					_tmp55_ = _header_list;
					_tmp56_ = vala_list_get ((ValaList*) _tmp55_, _header_index);
					header = (GtkdocHeader*) _tmp56_;
					_tmp57_ = header;
					_tmp58_ = _tmp57_->name;
					_tmp59_ = lang_header;
					_tmp60_ = _tmp59_->name;
					if (g_strcmp0 (_tmp58_, _tmp60_) == 0) {
						found = TRUE;
						_gtkdoc_header_unref0 (header);
						break;
					}
					_gtkdoc_header_unref0 (header);
				}
				_vala_iterable_unref0 (_header_list);
			}
			if (!found) {
				GtkdocHeader* _tmp62_;
				const gchar* _tmp63_;
				_tmp62_ = lang_header;
				_tmp63_ = _tmp62_->value;
				_tmp61_ = _tmp63_ != NULL;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				ValaArrayList* _tmp64_;
				GtkdocHeader* _tmp65_;
				_tmp64_ = headers;
				_tmp65_ = lang_header;
				vala_collection_add ((ValaCollection*) _tmp64_, _tmp65_);
			}
			_gtkdoc_header_unref0 (lang_header);
		}
		_vala_iterable_unref0 (_lang_header_list);
	}
	result = (ValaList*) headers;
	return result;
}

static gpointer
_gtkdoc_gcomment_ref0 (gpointer self)
{
	return self ? gtkdoc_gcomment_ref (self) : NULL;
}

static void
gtkdoc_generator_set_section_comment (GtkdocGenerator* self,
                                      const gchar* filename,
                                      const gchar* section_name,
                                      ValadocContentComment* comment,
                                      const gchar* symbol_full_name)
{
	GtkdocGeneratorFileData* file_data = NULL;
	GtkdocGeneratorFileData* _tmp0_;
	GtkdocGeneratorFileData* _tmp1_;
	const gchar* _tmp2_;
	GtkdocGeneratorFileData* _tmp5_;
	GtkdocGComment* _tmp6_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkdocGComment* _tmp9_;
	GtkdocGComment* _tmp10_;
	GtkdocGComment* _tmp11_;
	GtkdocGComment* _tmp12_;
	GtkdocGeneratorFileData* _tmp13_;
	GtkdocGComment* _tmp14_;
	GtkdocGComment* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GtkdocGComment* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (section_name != NULL);
	g_return_if_fail (symbol_full_name != NULL);
	_tmp0_ = gtkdoc_generator_get_file_data (self, filename);
	file_data = _tmp0_;
	_tmp1_ = file_data;
	_tmp2_ = _tmp1_->title;
	if (_tmp2_ == NULL) {
		GtkdocGeneratorFileData* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = file_data;
		_tmp4_ = g_strdup (section_name);
		_g_free0 (_tmp3_->title);
		_tmp3_->title = _tmp4_;
	}
	if (comment == NULL) {
		_gtkdoc_generator_file_data_unref0 (file_data);
		return;
	}
	_tmp5_ = file_data;
	_tmp6_ = _tmp5_->section_comment;
	if (_tmp6_ != NULL) {
		_gtkdoc_generator_file_data_unref0 (file_data);
		return;
	}
	_tmp7_ = gtkdoc_get_section (filename);
	_tmp8_ = _tmp7_;
	_tmp9_ = gtkdoc_generator_create_gcomment (self, _tmp8_, comment, NULL, (gint) 0, FALSE);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	gcomment = _tmp10_;
	_tmp11_ = gcomment;
	_tmp11_->is_section = TRUE;
	_tmp12_ = gcomment;
	_tmp12_->short_description = TRUE;
	_tmp13_ = file_data;
	_tmp14_ = gcomment;
	_tmp15_ = _gtkdoc_gcomment_ref0 (_tmp14_);
	_gtkdoc_gcomment_unref0 (_tmp13_->section_comment);
	_tmp13_->section_comment = _tmp15_;
	_tmp17_ = gcomment;
	_tmp18_ = _tmp17_->long_comment;
	if (_tmp18_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		GtkdocGComment* _tmp19_;
		const gchar* _tmp20_;
		_tmp19_ = gcomment;
		_tmp20_ = _tmp19_->long_comment;
		_tmp16_ = g_strcmp0 (_tmp20_, "") == 0;
	}
	if (_tmp16_) {
		ValadocErrorReporter* _tmp21_;
		_tmp21_ = self->priv->reporter;
		valadoc_error_reporter_simple_warning (_tmp21_, "GtkDoc", "Missing long description in the documentation for ‘%s’ which forms gtk" \
"-doc section ‘%s’.", symbol_full_name, section_name);
	}
	_gtkdoc_gcomment_unref0 (gcomment);
	_gtkdoc_generator_file_data_unref0 (file_data);
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GtkdocGComment*
gtkdoc_generator_create_gcomment (GtkdocGenerator* self,
                                  const gchar* symbol,
                                  ValadocContentComment* comment,
                                  gchar** returns_annotations,
                                  gint returns_annotations_length1,
                                  gboolean is_dbus)
{
	GtkdocCommentConverter* converter = NULL;
	ValadocErrorReporter* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	GtkdocCommentConverter* _tmp3_;
	GtkdocGComment* gcomment = NULL;
	GtkdocGComment* _tmp5_;
	gchar* _tmp6_;
	GtkdocCommentConverter* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GtkdocCommentConverter* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GtkdocCommentConverter* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GtkdocCommentConverter* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	ValaList* _tmp20_;
	GtkdocCommentConverter* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	ValaList* _tmp24_;
	ValaList* _tmp25_;
	ValaList* _tmp26_;
	GtkdocCommentConverter* _tmp27_;
	ValaList* _tmp28_;
	GtkdocGComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = self->priv->reporter;
	_tmp1_ = gtkdoc_generator_get_current_method_or_delegate (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtkdoc_comment_converter_new (_tmp0_, _tmp2_);
	converter = _tmp3_;
	if (comment != NULL) {
		GtkdocCommentConverter* _tmp4_;
		_tmp4_ = converter;
		gtkdoc_comment_converter_convert (_tmp4_, comment, is_dbus);
	}
	_tmp5_ = gtkdoc_gcomment_new ();
	gcomment = _tmp5_;
	_tmp6_ = g_strdup (symbol);
	_g_free0 (gcomment->symbol);
	gcomment->symbol = _tmp6_;
	_tmp7_ = converter;
	_tmp8_ = _tmp7_->returns;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (gcomment->returns);
	gcomment->returns = _tmp9_;
	_tmp10_ = (returns_annotations != NULL) ? _vala_array_dup5 (returns_annotations, returns_annotations_length1) : ((gpointer) returns_annotations);
	_tmp10__length1 = returns_annotations_length1;
	gcomment->returns_annotations = (_vala_array_free (gcomment->returns_annotations, gcomment->returns_annotations_length1, (GDestroyNotify) g_free), NULL);
	gcomment->returns_annotations = _tmp10_;
	gcomment->returns_annotations_length1 = _tmp10__length1;
	_tmp11_ = converter;
	_tmp12_ = _tmp11_->see_also;
	_tmp12__length1 = _tmp11_->see_also_length1;
	_tmp13_ = (_tmp12_ != NULL) ? _vala_array_dup6 (_tmp12_, _tmp12__length1) : ((gpointer) _tmp12_);
	_tmp13__length1 = _tmp12__length1;
	gcomment->see_also = (_vala_array_free (gcomment->see_also, gcomment->see_also_length1, (GDestroyNotify) g_free), NULL);
	gcomment->see_also = _tmp13_;
	gcomment->see_also_length1 = _tmp13__length1;
	_tmp14_ = converter;
	_tmp15_ = _tmp14_->brief_comment;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (gcomment->brief_comment);
	gcomment->brief_comment = _tmp16_;
	_tmp17_ = converter;
	_tmp18_ = _tmp17_->long_comment;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (gcomment->long_comment);
	gcomment->long_comment = _tmp19_;
	_tmp20_ = gcomment->headers;
	_tmp21_ = converter;
	_tmp22_ = _tmp21_->parameters;
	_tmp23_ = self->priv->current_headers;
	_tmp24_ = gtkdoc_generator_merge_headers (self, _tmp22_, _tmp23_);
	_tmp25_ = _tmp24_;
	vala_collection_add_all ((ValaCollection*) _tmp20_, (ValaCollection*) _tmp25_);
	_vala_iterable_unref0 (_tmp25_);
	_tmp26_ = gcomment->versioning;
	_tmp27_ = converter;
	_tmp28_ = _tmp27_->versioning;
	vala_collection_add_all ((ValaCollection*) _tmp26_, (ValaCollection*) _tmp28_);
	result = gcomment;
	_g_object_unref0 (converter);
	return result;
}

static GtkdocGComment*
gtkdoc_generator_add_comment (GtkdocGenerator* self,
                              const gchar* filename,
                              const gchar* symbol,
                              ValadocContentComment* comment)
{
	GtkdocGeneratorFileData* file_data = NULL;
	GtkdocGeneratorFileData* _tmp0_;
	GtkdocGComment* gcomment = NULL;
	GtkdocGComment* _tmp1_;
	ValaList* _tmp2_;
	GtkdocGComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = gtkdoc_generator_get_file_data (self, filename);
	file_data = _tmp0_;
	_tmp1_ = gtkdoc_generator_create_gcomment (self, symbol, comment, NULL, (gint) 0, FALSE);
	gcomment = _tmp1_;
	_tmp2_ = file_data->comments;
	vala_collection_add ((ValaCollection*) _tmp2_, gcomment);
	result = gcomment;
	_gtkdoc_generator_file_data_unref0 (file_data);
	return result;
}

static GtkdocGComment*
gtkdoc_generator_add_symbol (GtkdocGenerator* self,
                             const gchar* filename,
                             const gchar* cname,
                             ValadocContentComment* comment,
                             const gchar* symbol,
                             gchar** returns_annotations,
                             gint returns_annotations_length1)
{
	GtkdocGeneratorFileData* file_data = NULL;
	GtkdocGeneratorFileData* _tmp0_;
	GtkdocGeneratorFileData* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkdocGComment* gcomment = NULL;
	GtkdocGComment* _tmp3_;
	GtkdocGeneratorFileData* _tmp4_;
	ValaList* _tmp5_;
	GtkdocGComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (cname != NULL, NULL);
	_tmp0_ = gtkdoc_generator_get_file_data (self, filename);
	file_data = _tmp0_;
	_tmp1_ = file_data;
	gtkdoc_generator_file_data_register_section_line (_tmp1_, cname);
	_tmp2_ = symbol;
	if (_tmp2_ == NULL) {
		_tmp2_ = cname;
	}
	_tmp3_ = gtkdoc_generator_create_gcomment (self, _tmp2_, comment, returns_annotations, (gint) returns_annotations_length1, FALSE);
	gcomment = _tmp3_;
	_tmp4_ = file_data;
	_tmp5_ = _tmp4_->comments;
	vala_collection_add ((ValaCollection*) _tmp5_, gcomment);
	result = gcomment;
	_gtkdoc_generator_file_data_unref0 (file_data);
	return result;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GtkdocHeader*
gtkdoc_generator_add_custom_header (GtkdocGenerator* self,
                                    const gchar* name,
                                    const gchar* comment,
                                    gchar** annotations,
                                    gint annotations_length1,
                                    gdouble pos,
                                    gboolean block)
{
	gboolean _tmp0_ = FALSE;
	GtkdocHeader* header = NULL;
	GtkdocHeader* _tmp1_;
	GtkdocHeader* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	ValaList* _tmp4_;
	GtkdocHeader* _tmp5_;
	GtkdocHeader* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (comment == NULL) {
		_tmp0_ = annotations == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = gtkdoc_header_new (name, comment, pos, block);
	header = _tmp1_;
	_tmp2_ = header;
	_tmp3_ = (annotations != NULL) ? _vala_array_dup7 (annotations, annotations_length1) : ((gpointer) annotations);
	_tmp3__length1 = annotations_length1;
	_tmp2_->annotations = (_vala_array_free (_tmp2_->annotations, _tmp2_->annotations_length1, (GDestroyNotify) g_free), NULL);
	_tmp2_->annotations = _tmp3_;
	_tmp2_->annotations_length1 = _tmp3__length1;
	_tmp4_ = self->priv->current_headers;
	_tmp5_ = header;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp5_);
	result = header;
	return result;
}

static GtkdocHeader*
gtkdoc_generator_remove_custom_header (GtkdocGenerator* self,
                                       const gchar* name)
{
	ValaIterator* it = NULL;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	GtkdocHeader* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->current_headers;
	_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaIterator* _tmp2_;
		GtkdocHeader* header = NULL;
		ValaIterator* _tmp3_;
		gpointer _tmp4_;
		GtkdocHeader* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = it;
		if (!vala_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_iterator_get (_tmp3_);
		header = (GtkdocHeader*) _tmp4_;
		_tmp5_ = header;
		_tmp6_ = _tmp5_->name;
		if (g_strcmp0 (_tmp6_, name) == 0) {
			ValaIterator* _tmp7_;
			_tmp7_ = it;
			vala_iterator_remove (_tmp7_);
			result = header;
			_vala_iterator_unref0 (it);
			return result;
		}
		_gtkdoc_header_unref0 (header);
	}
	result = NULL;
	_vala_iterator_unref0 (it);
	return result;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GtkdocHeader*
gtkdoc_generator_add_header (GtkdocGenerator* self,
                             const gchar* name,
                             ValadocContentComment* comment,
                             gchar** annotations,
                             gint annotations_length1,
                             gdouble pos)
{
	gboolean _tmp0_ = FALSE;
	GtkdocCommentConverter* converter = NULL;
	ValadocErrorReporter* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocApiNode* _tmp3_;
	GtkdocCommentConverter* _tmp4_;
	GtkdocHeader* header = NULL;
	GtkdocHeader* _tmp5_;
	GtkdocHeader* _tmp6_;
	GtkdocHeader* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	ValaList* _tmp24_;
	GtkdocHeader* _tmp25_;
	GtkdocHeader* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (comment == NULL) {
		_tmp0_ = annotations == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->reporter;
	_tmp2_ = gtkdoc_generator_get_current_method_or_delegate (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtkdoc_comment_converter_new (_tmp1_, _tmp3_);
	converter = _tmp4_;
	_tmp5_ = gtkdoc_header_new (name, NULL, DBL_MAX, TRUE);
	header = _tmp5_;
	_tmp6_ = header;
	_tmp6_->pos = pos;
	if (comment != NULL) {
		GtkdocCommentConverter* _tmp7_;
		GtkdocCommentConverter* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = converter;
		gtkdoc_comment_converter_convert (_tmp7_, comment, FALSE);
		_tmp8_ = converter;
		_tmp9_ = _tmp8_->brief_comment;
		if (_tmp9_ != NULL) {
			GtkdocHeader* _tmp10_;
			GtkdocCommentConverter* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			GtkdocCommentConverter* _tmp14_;
			const gchar* _tmp15_;
			_tmp10_ = header;
			_tmp11_ = converter;
			_tmp12_ = _tmp11_->brief_comment;
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (_tmp10_->value);
			_tmp10_->value = _tmp13_;
			_tmp14_ = converter;
			_tmp15_ = _tmp14_->long_comment;
			if (_tmp15_ != NULL) {
				GtkdocHeader* _tmp16_;
				GtkdocHeader* _tmp17_;
				const gchar* _tmp18_;
				GtkdocCommentConverter* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp16_ = header;
				_tmp17_ = header;
				_tmp18_ = _tmp17_->value;
				_tmp19_ = converter;
				_tmp20_ = _tmp19_->long_comment;
				_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
				_g_free0 (_tmp17_->value);
				_tmp17_->value = _tmp21_;
			}
		}
	}
	_tmp22_ = header;
	_tmp23_ = (annotations != NULL) ? _vala_array_dup8 (annotations, annotations_length1) : ((gpointer) annotations);
	_tmp23__length1 = annotations_length1;
	_tmp22_->annotations = (_vala_array_free (_tmp22_->annotations, _tmp22_->annotations_length1, (GDestroyNotify) g_free), NULL);
	_tmp22_->annotations = _tmp23_;
	_tmp22_->annotations_length1 = _tmp23__length1;
	_tmp24_ = self->priv->current_headers;
	_tmp25_ = header;
	vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
	result = header;
	_g_object_unref0 (converter);
	return result;
}

static void
gtkdoc_generator_real_visit_tree (ValadocApiVisitor* base,
                                  ValadocApiTree* tree)
{
	GtkdocGenerator * self;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (tree != NULL);
	valadoc_api_tree_accept_children (tree, (ValadocApiVisitor*) self);
}

static void
gtkdoc_generator_real_visit_package (ValadocApiVisitor* base,
                                     ValadocApiPackage* package)
{
	GtkdocGenerator * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (package != NULL);
	_tmp0_ = valadoc_api_package_get_is_package (package);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	valadoc_api_node_accept_all_children ((ValadocApiNode*) package, (ValadocApiVisitor*) self, TRUE);
}

static void
gtkdoc_generator_real_visit_namespace (ValadocApiVisitor* base,
                                       ValadocApiNamespace* ns)
{
	GtkdocGenerator * self;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (ns != NULL);
	_tmp1_ = valadoc_documentation_get_filename ((ValadocDocumentation*) ns);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValadocContentComment* _tmp4_;
		ValadocContentComment* _tmp5_;
		_tmp4_ = valadoc_api_node_get_documentation ((ValadocApiNode*) ns);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ValadocContentComment* _tmp12_;
		ValadocContentComment* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = valadoc_documentation_get_filename ((ValadocDocumentation*) ns);
		_tmp7_ = _tmp6_;
		_tmp8_ = valadoc_documentation_get_filename ((ValadocDocumentation*) ns);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtkdoc_get_section (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_api_node_get_documentation ((ValadocApiNode*) ns);
		_tmp13_ = _tmp12_;
		_tmp14_ = valadoc_api_node_get_full_name ((ValadocApiNode*) ns);
		_tmp15_ = _tmp14_;
		gtkdoc_generator_set_section_comment (self, _tmp7_, _tmp11_, _tmp13_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
	valadoc_api_node_accept_all_children ((ValadocApiNode*) ns, (ValadocApiVisitor*) self, TRUE);
}

static gpointer
_gtkdoc_dbus_interface_ref0 (gpointer self)
{
	return self ? gtkdoc_dbus_interface_ref (self) : NULL;
}

static void
gtkdoc_generator_real_visit_interface (ValadocApiVisitor* base,
                                       ValadocApiInterface* iface)
{
	GtkdocGenerator * self;
	gchar* old_cname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValaList* old_headers = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	GtkdocDBusInterface* old_dbus_interface = NULL;
	GtkdocDBusInterface* _tmp4_;
	GtkdocDBusInterface* _tmp5_;
	gchar* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValadocContentComment* _tmp21_;
	ValadocContentComment* _tmp22_;
	GtkdocGComment* _tmp23_;
	GtkdocGComment* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	ValadocContentComment* _tmp29_;
	ValadocContentComment* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GtkdocDBusInterface* _tmp33_;
	GtkdocGComment* _tmp39_;
	ValaList* _tmp40_;
	ValaList* abstract_methods = NULL;
	ValadocApiNodeType* _tmp41_;
	ValadocApiNodeType* _tmp42_;
	gint _tmp42__length1;
	ValaList* _tmp43_;
	ValaList* _tmp44_;
	ValaList* abstract_properties = NULL;
	ValadocApiNodeType* _tmp59_;
	ValadocApiNodeType* _tmp60_;
	gint _tmp60__length1;
	ValaList* _tmp61_;
	ValaList* _tmp62_;
	GtkdocHeader* _tmp77_;
	GtkdocHeader* _tmp78_;
	ValadocApiAttribute* _tmp79_;
	ValadocApiAttribute* _tmp80_;
	gboolean _tmp81_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	GtkdocGComment* _tmp130_;
	GtkdocGComment* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	GtkdocGeneratorFileData* file_data = NULL;
	gchar* _tmp135_;
	gchar* _tmp136_;
	GtkdocGeneratorFileData* _tmp137_;
	GtkdocGeneratorFileData* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	const gchar* _tmp149_;
	gchar* _tmp150_;
	ValaList* _tmp151_;
	ValaList* _tmp152_;
	GtkdocDBusInterface* _tmp153_;
	GtkdocDBusInterface* _tmp154_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->current_cname;
	_tmp1_ = g_strdup (_tmp0_);
	old_cname = _tmp1_;
	_tmp2_ = self->priv->current_headers;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	old_headers = _tmp3_;
	_tmp4_ = self->priv->current_dbus_interface;
	_tmp5_ = _gtkdoc_dbus_interface_ref0 (_tmp4_);
	old_dbus_interface = _tmp5_;
	_tmp6_ = valadoc_api_interface_get_cname (iface);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp7_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp8_;
	_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
	self->priv->current_dbus_interface = NULL;
	_tmp9_ = valadoc_api_interface_get_dbus_name (iface);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_free0 (_tmp10_);
	if (_tmp11_) {
		ValadocSettings* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkdocDBusInterface* _tmp16_;
		_tmp12_ = self->priv->settings;
		_tmp13_ = _tmp12_->pkg_name;
		_tmp14_ = valadoc_api_interface_get_dbus_name (iface);
		_tmp15_ = _tmp14_;
		_tmp16_ = gtkdoc_dbus_interface_new (_tmp13_, _tmp15_, "", "");
		_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
		self->priv->current_dbus_interface = _tmp16_;
		_g_free0 (_tmp15_);
	}
	valadoc_api_node_accept_all_children ((ValadocApiNode*) iface, (ValadocApiVisitor*) self, TRUE);
	_tmp17_ = valadoc_documentation_get_filename ((ValadocDocumentation*) iface);
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_api_interface_get_cname (iface);
	_tmp20_ = _tmp19_;
	_tmp21_ = valadoc_api_node_get_documentation ((ValadocApiNode*) iface);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtkdoc_generator_add_symbol (self, _tmp18_, _tmp20_, _tmp22_, NULL, NULL, (gint) 0);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	gcomment = _tmp24_;
	_tmp25_ = valadoc_documentation_get_filename ((ValadocDocumentation*) iface);
	_tmp26_ = _tmp25_;
	_tmp27_ = valadoc_api_interface_get_cname (iface);
	_tmp28_ = _tmp27_;
	_tmp29_ = valadoc_api_node_get_documentation ((ValadocApiNode*) iface);
	_tmp30_ = _tmp29_;
	_tmp31_ = valadoc_api_node_get_full_name ((ValadocApiNode*) iface);
	_tmp32_ = _tmp31_;
	gtkdoc_generator_set_section_comment (self, _tmp26_, _tmp28_, _tmp30_, _tmp32_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp33_ = self->priv->current_dbus_interface;
	if (_tmp33_ != NULL) {
		GtkdocDBusInterface* _tmp34_;
		ValadocSettings* _tmp35_;
		ValadocErrorReporter* _tmp36_;
		ValaList* _tmp37_;
		GtkdocDBusInterface* _tmp38_;
		_tmp34_ = self->priv->current_dbus_interface;
		_tmp35_ = self->priv->settings;
		_tmp36_ = self->priv->reporter;
		gtkdoc_dbus_interface_write (_tmp34_, _tmp35_, _tmp36_);
		_tmp37_ = self->dbus_interfaces;
		_tmp38_ = self->priv->current_dbus_interface;
		vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
	}
	_tmp39_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) iface, _tmp39_);
	_tmp40_ = self->priv->current_headers;
	vala_collection_clear ((ValaCollection*) _tmp40_);
	_tmp41_ = g_new0 (ValadocApiNodeType, 1);
	_tmp41_[0] = VALADOC_API_NODE_TYPE_METHOD;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 1;
	_tmp43_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) iface, _tmp42_, (gint) 1, FALSE);
	_tmp44_ = _tmp43_;
	_tmp42_ = (g_free (_tmp42_), NULL);
	abstract_methods = _tmp44_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _m_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _m_index = 0;
		_tmp45_ = abstract_methods;
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_m_list = _tmp46_;
		_tmp47_ = _m_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_m_size = _tmp49_;
		_m_index = -1;
		while (TRUE) {
			ValadocApiNode* m = NULL;
			ValaList* _tmp50_;
			gpointer _tmp51_;
			gboolean _tmp52_ = FALSE;
			ValadocApiNode* _tmp53_;
			ValadocSettings* _tmp54_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp50_ = _m_list;
			_tmp51_ = vala_list_get (_tmp50_, _m_index);
			m = (ValadocApiNode*) _tmp51_;
			_tmp53_ = m;
			_tmp54_ = self->priv->settings;
			if (valadoc_api_node_is_browsable (_tmp53_, _tmp54_)) {
				_tmp52_ = TRUE;
			} else {
				ValadocApiNode* _tmp55_;
				gboolean _tmp56_;
				gboolean _tmp57_;
				_tmp55_ = m;
				_tmp56_ = valadoc_api_symbol_get_is_protected (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
				_tmp57_ = _tmp56_;
				_tmp52_ = _tmp57_;
			}
			if (_tmp52_) {
				ValadocApiNode* _tmp58_;
				_tmp58_ = m;
				gtkdoc_generator_visit_abstract_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			}
			_g_object_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp59_ = g_new0 (ValadocApiNodeType, 1);
	_tmp59_[0] = VALADOC_API_NODE_TYPE_PROPERTY;
	_tmp60_ = _tmp59_;
	_tmp60__length1 = 1;
	_tmp61_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) iface, _tmp60_, (gint) 1, FALSE);
	_tmp62_ = _tmp61_;
	_tmp60_ = (g_free (_tmp60_), NULL);
	abstract_properties = _tmp62_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp63_;
		ValaList* _tmp64_;
		gint _prop_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _prop_index = 0;
		_tmp63_ = abstract_properties;
		_tmp64_ = _vala_iterable_ref0 (_tmp63_);
		_prop_list = _tmp64_;
		_tmp65_ = _prop_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_prop_size = _tmp67_;
		_prop_index = -1;
		while (TRUE) {
			ValadocApiNode* prop = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			gboolean _tmp70_ = FALSE;
			ValadocApiNode* _tmp71_;
			ValadocSettings* _tmp72_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp68_ = _prop_list;
			_tmp69_ = vala_list_get (_tmp68_, _prop_index);
			prop = (ValadocApiNode*) _tmp69_;
			_tmp71_ = prop;
			_tmp72_ = self->priv->settings;
			if (valadoc_api_node_is_browsable (_tmp71_, _tmp72_)) {
				_tmp70_ = TRUE;
			} else {
				ValadocApiNode* _tmp73_;
				gboolean _tmp74_;
				gboolean _tmp75_;
				_tmp73_ = prop;
				_tmp74_ = valadoc_api_symbol_get_is_protected (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
				_tmp75_ = _tmp74_;
				_tmp70_ = _tmp75_;
			}
			if (_tmp70_) {
				ValadocApiNode* _tmp76_;
				_tmp76_ = prop;
				gtkdoc_generator_visit_abstract_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
			}
			_g_object_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp77_ = gtkdoc_generator_add_custom_header (self, "parent_iface", "the parent interface structure", NULL, (gint) 0, DBL_MAX, TRUE);
	_tmp78_ = _tmp77_;
	_gtkdoc_header_unref0 (_tmp78_);
	_tmp79_ = valadoc_api_symbol_get_attribute ((ValadocApiSymbol*) iface, "GenericAccessors");
	_tmp80_ = _tmp79_;
	_tmp81_ = _tmp80_ != NULL;
	_g_object_unref0 (_tmp80_);
	if (_tmp81_) {
		ValaList* type_parameters = NULL;
		ValaList* _tmp82_;
		_tmp82_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) iface, VALADOC_API_NODE_TYPE_TYPE_PARAMETER, FALSE);
		type_parameters = _tmp82_;
		{
			ValaList* __type_list = NULL;
			ValaList* _tmp83_;
			ValaList* _tmp84_;
			gint __type_size = 0;
			ValaList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint __type_index = 0;
			_tmp83_ = type_parameters;
			_tmp84_ = _vala_iterable_ref0 (_tmp83_);
			__type_list = _tmp84_;
			_tmp85_ = __type_list;
			_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			__type_size = _tmp87_;
			__type_index = -1;
			while (TRUE) {
				ValadocApiNode* _type = NULL;
				ValaList* _tmp88_;
				gpointer _tmp89_;
				ValadocApiTypeParameter* type = NULL;
				ValadocApiNode* _tmp90_;
				ValadocApiTypeParameter* _tmp91_;
				gchar* type_name_down = NULL;
				ValadocApiTypeParameter* _tmp92_;
				const gchar* _tmp93_;
				const gchar* _tmp94_;
				gchar* _tmp95_;
				const gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				const gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				GtkdocHeader* _tmp102_;
				GtkdocHeader* _tmp103_;
				const gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* _tmp108_;
				const gchar* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				GtkdocHeader* _tmp112_;
				GtkdocHeader* _tmp113_;
				const gchar* _tmp114_;
				gchar* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				gchar* _tmp118_;
				const gchar* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				GtkdocHeader* _tmp122_;
				GtkdocHeader* _tmp123_;
				__type_index = __type_index + 1;
				if (!(__type_index < __type_size)) {
					break;
				}
				_tmp88_ = __type_list;
				_tmp89_ = vala_list_get (_tmp88_, __type_index);
				_type = (ValadocApiNode*) _tmp89_;
				_tmp90_ = _type;
				_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp90_) : NULL);
				type = _tmp91_;
				_tmp92_ = type;
				_tmp93_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_utf8_strdown (_tmp94_, (gssize) -1);
				type_name_down = _tmp95_;
				_tmp96_ = type_name_down;
				_tmp97_ = g_strdup_printf ("get_%s_type", _tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = type_name_down;
				_tmp100_ = g_strdup_printf ("The #GType for %s", _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = gtkdoc_generator_add_custom_header (self, _tmp98_, _tmp101_, NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp103_ = _tmp102_;
				_gtkdoc_header_unref0 (_tmp103_);
				_g_free0 (_tmp101_);
				_g_free0 (_tmp98_);
				_tmp104_ = type_name_down;
				_tmp105_ = g_strdup_printf ("get_%s_dup_func", _tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = valadoc_api_interface_get_cname (iface);
				_tmp108_ = _tmp107_;
				_tmp109_ = type_name_down;
				_tmp110_ = g_strdup_printf ("A dup function for #%sIface.get_%s_type()", _tmp108_, _tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = gtkdoc_generator_add_custom_header (self, _tmp106_, _tmp111_, NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp113_ = _tmp112_;
				_gtkdoc_header_unref0 (_tmp113_);
				_g_free0 (_tmp111_);
				_g_free0 (_tmp108_);
				_g_free0 (_tmp106_);
				_tmp114_ = type_name_down;
				_tmp115_ = g_strdup_printf ("get_%s_destroy_func", _tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = valadoc_api_interface_get_cname (iface);
				_tmp118_ = _tmp117_;
				_tmp119_ = type_name_down;
				_tmp120_ = g_strdup_printf ("A destroy function for #%sIface.get_%s_type()", _tmp118_, _tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = gtkdoc_generator_add_custom_header (self, _tmp116_, _tmp121_, NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp123_ = _tmp122_;
				_gtkdoc_header_unref0 (_tmp123_);
				_g_free0 (_tmp121_);
				_g_free0 (_tmp118_);
				_g_free0 (_tmp116_);
				_g_free0 (type_name_down);
				_g_object_unref0 (type);
				_g_object_unref0 (_type);
			}
			_vala_iterable_unref0 (__type_list);
		}
		_vala_iterable_unref0 (type_parameters);
	}
	_tmp124_ = valadoc_documentation_get_filename ((ValadocDocumentation*) iface);
	_tmp125_ = _tmp124_;
	_tmp126_ = valadoc_api_interface_get_cname (iface);
	_tmp127_ = _tmp126_;
	_tmp128_ = g_strconcat (_tmp127_, "Iface", NULL);
	_tmp129_ = _tmp128_;
	_tmp130_ = gtkdoc_generator_add_symbol (self, _tmp125_, _tmp129_, NULL, NULL, NULL, (gint) 0);
	_gtkdoc_gcomment_unref0 (gcomment);
	gcomment = _tmp130_;
	_g_free0 (_tmp129_);
	_g_free0 (_tmp127_);
	_g_free0 (_tmp125_);
	_tmp131_ = gcomment;
	_tmp132_ = gtkdoc_get_docbook_link ((ValadocApiItem*) iface, FALSE, FALSE);
	_tmp133_ = _tmp132_;
	_tmp134_ = g_strdup_printf ("Interface for creating %s implementations.", _tmp133_);
	_g_free0 (_tmp131_->brief_comment);
	_tmp131_->brief_comment = _tmp134_;
	_g_free0 (_tmp133_);
	_tmp135_ = valadoc_documentation_get_filename ((ValadocDocumentation*) iface);
	_tmp136_ = _tmp135_;
	_tmp137_ = gtkdoc_generator_get_file_data (self, _tmp136_);
	_tmp138_ = _tmp137_;
	_g_free0 (_tmp136_);
	file_data = _tmp138_;
	_tmp139_ = valadoc_api_typesymbol_get_type_cast_macro_name ((ValadocApiTypeSymbol*) iface);
	_tmp140_ = _tmp139_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp140_);
	_g_free0 (_tmp140_);
	_tmp141_ = valadoc_api_interface_get_interface_macro_name (iface);
	_tmp142_ = _tmp141_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp142_);
	_g_free0 (_tmp142_);
	_tmp143_ = valadoc_api_typesymbol_get_is_type_macro_name ((ValadocApiTypeSymbol*) iface);
	_tmp144_ = _tmp143_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp144_);
	_g_free0 (_tmp144_);
	_tmp145_ = valadoc_api_typesymbol_get_type_macro_name ((ValadocApiTypeSymbol*) iface);
	_tmp146_ = _tmp145_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp146_);
	_g_free0 (_tmp146_);
	_tmp147_ = valadoc_api_typesymbol_get_type_function_name ((ValadocApiTypeSymbol*) iface);
	_tmp148_ = _tmp147_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp148_);
	_g_free0 (_tmp148_);
	_tmp149_ = old_cname;
	_tmp150_ = g_strdup (_tmp149_);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp150_;
	_tmp151_ = old_headers;
	_tmp152_ = _vala_iterable_ref0 (_tmp151_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp152_;
	_tmp153_ = old_dbus_interface;
	_tmp154_ = _gtkdoc_dbus_interface_ref0 (_tmp153_);
	_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
	self->priv->current_dbus_interface = _tmp154_;
	_gtkdoc_generator_file_data_unref0 (file_data);
	_vala_iterable_unref0 (abstract_properties);
	_vala_iterable_unref0 (abstract_methods);
	_gtkdoc_gcomment_unref0 (gcomment);
	_gtkdoc_dbus_interface_unref0 (old_dbus_interface);
	_vala_iterable_unref0 (old_headers);
	_g_free0 (old_cname);
}

static void
gtkdoc_generator_real_visit_class (ValadocApiVisitor* base,
                                   ValadocApiClass* cl)
{
	GtkdocGenerator * self;
	gchar* old_cname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValaList* old_headers = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValadocApiClass* old_class = NULL;
	ValadocApiClass* _tmp4_;
	ValadocApiClass* _tmp5_;
	GtkdocDBusInterface* old_dbus_interface = NULL;
	GtkdocDBusInterface* _tmp6_;
	GtkdocDBusInterface* _tmp7_;
	gchar* _tmp8_;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValadocApiClass* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkdocGComment* _tmp24_;
	GtkdocGComment* _tmp25_;
	GtkdocGComment* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	ValadocContentComment* _tmp34_;
	ValadocContentComment* _tmp35_;
	GtkdocGComment* _tmp36_;
	GtkdocGComment* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	ValadocContentComment* _tmp42_;
	ValadocContentComment* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GtkdocDBusInterface* _tmp46_;
	GtkdocGComment* _tmp52_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_;
	gboolean _tmp55_;
	ValaList* _tmp185_;
	ValaList* abstract_methods = NULL;
	ValadocApiNodeType* _tmp186_;
	ValadocApiNodeType* _tmp187_;
	gint _tmp187__length1;
	ValaList* _tmp188_;
	ValaList* _tmp189_;
	ValaList* abstract_properties = NULL;
	ValadocApiNodeType* _tmp204_;
	ValadocApiNodeType* _tmp205_;
	gint _tmp205__length1;
	ValaList* _tmp206_;
	ValaList* _tmp207_;
	GtkdocHeader* _tmp222_;
	GtkdocHeader* _tmp223_;
	gchar* _tmp224_;
	gchar* _tmp225_;
	gchar* _tmp226_;
	gchar* _tmp227_;
	gchar* _tmp228_;
	gchar* _tmp229_;
	GtkdocGComment* _tmp230_;
	GtkdocGComment* _tmp231_;
	gchar* _tmp232_;
	gchar* _tmp233_;
	gchar* _tmp234_;
	GtkdocGeneratorFileData* file_data = NULL;
	gchar* _tmp235_;
	gchar* _tmp236_;
	GtkdocGeneratorFileData* _tmp237_;
	GtkdocGeneratorFileData* _tmp238_;
	GtkdocGeneratorFileData* _tmp239_;
	gchar* _tmp240_;
	gchar* _tmp241_;
	GtkdocGeneratorFileData* _tmp242_;
	gchar* _tmp243_;
	gchar* _tmp244_;
	GtkdocGeneratorFileData* _tmp245_;
	gchar* _tmp246_;
	gchar* _tmp247_;
	GtkdocGeneratorFileData* _tmp248_;
	gchar* _tmp249_;
	gchar* _tmp250_;
	GtkdocGeneratorFileData* _tmp251_;
	gchar* _tmp252_;
	gchar* _tmp253_;
	GtkdocGeneratorFileData* _tmp254_;
	gchar* _tmp255_;
	gchar* _tmp256_;
	GtkdocGeneratorFileData* _tmp257_;
	gchar* _tmp258_;
	gchar* _tmp259_;
	gchar* _tmp260_ = NULL;
	ValadocApiNamespace* _tmp261_;
	ValadocApiNamespace* _tmp262_;
	const gchar* _tmp263_;
	const gchar* _tmp264_;
	GtkdocGeneratorFileData* _tmp273_;
	const gchar* _tmp274_;
	const gchar* _tmp275_;
	gchar* _tmp276_;
	gchar* _tmp277_;
	gchar* _tmp278_;
	gchar* _tmp279_;
	gchar* _tmp280_;
	gchar* _tmp281_;
	const gchar* _tmp282_;
	gchar* _tmp283_;
	ValaList* _tmp284_;
	ValaList* _tmp285_;
	ValadocApiClass* _tmp286_;
	ValadocApiClass* _tmp287_;
	GtkdocDBusInterface* _tmp288_;
	GtkdocDBusInterface* _tmp289_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->current_cname;
	_tmp1_ = g_strdup (_tmp0_);
	old_cname = _tmp1_;
	_tmp2_ = self->priv->current_headers;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	old_headers = _tmp3_;
	_tmp4_ = self->priv->current_class;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	old_class = _tmp5_;
	_tmp6_ = self->priv->current_dbus_interface;
	_tmp7_ = _gtkdoc_dbus_interface_ref0 (_tmp6_);
	old_dbus_interface = _tmp7_;
	_tmp8_ = valadoc_api_class_get_cname (cl);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp9_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp10_;
	_tmp11_ = _g_object_ref0 (cl);
	_g_object_unref0 (self->priv->current_class);
	self->priv->current_class = _tmp11_;
	_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
	self->priv->current_dbus_interface = NULL;
	_tmp12_ = valadoc_api_class_get_dbus_name (cl);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_ != NULL;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		ValadocSettings* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkdocDBusInterface* _tmp19_;
		_tmp15_ = self->priv->settings;
		_tmp16_ = _tmp15_->pkg_name;
		_tmp17_ = valadoc_api_class_get_dbus_name (cl);
		_tmp18_ = _tmp17_;
		_tmp19_ = gtkdoc_dbus_interface_new (_tmp16_, _tmp18_, "", "");
		_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
		self->priv->current_dbus_interface = _tmp19_;
		_g_free0 (_tmp18_);
	}
	_tmp20_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
	_tmp21_ = _tmp20_;
	_tmp22_ = valadoc_api_class_get_type_id (cl);
	_tmp23_ = _tmp22_;
	_tmp24_ = gtkdoc_generator_add_symbol (self, _tmp21_, _tmp23_, NULL, NULL, NULL, (gint) 0);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	gcomment = _tmp25_;
	_tmp26_ = gcomment;
	_tmp27_ = gtkdoc_get_docbook_link ((ValadocApiItem*) cl, FALSE, FALSE);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strdup_printf ("The type for %s.", _tmp28_);
	_g_free0 (_tmp26_->brief_comment);
	_tmp26_->brief_comment = _tmp29_;
	_g_free0 (_tmp28_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) cl, (ValadocApiVisitor*) self, TRUE);
	_tmp30_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
	_tmp31_ = _tmp30_;
	_tmp32_ = valadoc_api_class_get_cname (cl);
	_tmp33_ = _tmp32_;
	_tmp34_ = valadoc_api_node_get_documentation ((ValadocApiNode*) cl);
	_tmp35_ = _tmp34_;
	_tmp36_ = gtkdoc_generator_add_symbol (self, _tmp31_, _tmp33_, _tmp35_, NULL, NULL, (gint) 0);
	_tmp37_ = _tmp36_;
	_gtkdoc_gcomment_unref0 (_tmp37_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp38_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
	_tmp39_ = _tmp38_;
	_tmp40_ = valadoc_api_class_get_cname (cl);
	_tmp41_ = _tmp40_;
	_tmp42_ = valadoc_api_node_get_documentation ((ValadocApiNode*) cl);
	_tmp43_ = _tmp42_;
	_tmp44_ = valadoc_api_node_get_full_name ((ValadocApiNode*) cl);
	_tmp45_ = _tmp44_;
	gtkdoc_generator_set_section_comment (self, _tmp39_, _tmp41_, _tmp43_, _tmp45_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp46_ = self->priv->current_dbus_interface;
	if (_tmp46_ != NULL) {
		GtkdocDBusInterface* _tmp47_;
		ValadocSettings* _tmp48_;
		ValadocErrorReporter* _tmp49_;
		ValaList* _tmp50_;
		GtkdocDBusInterface* _tmp51_;
		_tmp47_ = self->priv->current_dbus_interface;
		_tmp48_ = self->priv->settings;
		_tmp49_ = self->priv->reporter;
		gtkdoc_dbus_interface_write (_tmp47_, _tmp48_, _tmp49_);
		_tmp50_ = self->dbus_interfaces;
		_tmp51_ = self->priv->current_dbus_interface;
		vala_collection_add ((ValaCollection*) _tmp50_, _tmp51_);
	}
	_tmp52_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) cl, _tmp52_);
	_tmp54_ = valadoc_api_class_get_is_fundamental (cl);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		ValadocApiTypeReference* _tmp56_;
		ValadocApiTypeReference* _tmp57_;
		_tmp56_ = valadoc_api_class_get_base_type (cl);
		_tmp57_ = _tmp56_;
		_tmp53_ = _tmp57_ == NULL;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		gchar* filename = NULL;
		gchar* _tmp58_;
		ValaList* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		GtkdocHeader* _tmp64_;
		GtkdocHeader* _tmp65_;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		GtkdocGComment* _tmp69_;
		GtkdocGComment* _tmp70_;
		gchar* _tmp71_;
		GtkdocGComment* _tmp72_;
		gchar* _tmp73_;
		ValaList* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		GtkdocHeader* _tmp79_;
		GtkdocHeader* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		GtkdocGComment* _tmp84_;
		GtkdocGComment* _tmp85_;
		gchar* _tmp86_;
		ValaList* _tmp87_;
		GtkdocHeader* _tmp88_;
		GtkdocHeader* _tmp89_;
		GtkdocHeader* _tmp90_;
		GtkdocHeader* _tmp91_;
		GtkdocHeader* _tmp92_;
		GtkdocHeader* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		GtkdocHeader* _tmp98_;
		GtkdocHeader* _tmp99_;
		GtkdocHeader* _tmp100_;
		GtkdocHeader* _tmp101_;
		const gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		GtkdocGComment* _tmp105_;
		GtkdocGComment* _tmp106_;
		gchar* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		GtkdocGComment* _tmp110_;
		gchar* _tmp111_;
		ValaList* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		GtkdocHeader* _tmp117_;
		GtkdocHeader* _tmp118_;
		GtkdocHeader* _tmp119_;
		GtkdocHeader* _tmp120_;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		GtkdocGComment* _tmp124_;
		GtkdocGComment* _tmp125_;
		gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		GtkdocGComment* _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		gchar* _tmp132_;
		gchar* _tmp133_;
		gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		ValaList* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		GtkdocHeader* _tmp148_;
		GtkdocHeader* _tmp149_;
		const gchar* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		GtkdocGComment* _tmp153_;
		GtkdocGComment* _tmp154_;
		gchar* _tmp155_;
		gchar* _tmp156_;
		gchar* _tmp157_;
		GtkdocGComment* _tmp158_;
		gchar* _tmp159_;
		ValaList* _tmp160_;
		gchar* _tmp161_;
		gchar* _tmp162_;
		gchar* _tmp163_;
		gchar* _tmp164_;
		GtkdocHeader* _tmp165_;
		GtkdocHeader* _tmp166_;
		GtkdocHeader* _tmp167_;
		GtkdocHeader* _tmp168_;
		const gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		GtkdocGComment* _tmp172_;
		GtkdocGComment* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		gchar* _tmp176_;
		GtkdocGComment* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		gchar* _tmp184_;
		_tmp58_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
		filename = _tmp58_;
		_tmp59_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp59_);
		_tmp60_ = gtkdoc_get_docbook_link ((ValadocApiItem*) cl, FALSE, FALSE);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strdup_printf ("a %s.", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = gtkdoc_generator_add_custom_header (self, "instance", _tmp63_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp65_ = _tmp64_;
		_gtkdoc_header_unref0 (_tmp65_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		_tmp66_ = filename;
		_tmp67_ = valadoc_api_class_get_ref_function_cname (cl);
		_tmp68_ = _tmp67_;
		_tmp69_ = gtkdoc_generator_add_symbol (self, _tmp66_, _tmp68_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp69_;
		_g_free0 (_tmp68_);
		_tmp70_ = gcomment;
		_tmp71_ = g_strdup ("Increases the reference count of @object.");
		_g_free0 (_tmp70_->brief_comment);
		_tmp70_->brief_comment = _tmp71_;
		_tmp72_ = gcomment;
		_tmp73_ = g_strdup ("the same @object");
		_g_free0 (_tmp72_->returns);
		_tmp72_->returns = _tmp73_;
		_tmp74_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp74_);
		_tmp75_ = gtkdoc_get_docbook_link ((ValadocApiItem*) cl, FALSE, FALSE);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strdup_printf ("a %s.", _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = gtkdoc_generator_add_custom_header (self, "instance", _tmp78_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp80_ = _tmp79_;
		_gtkdoc_header_unref0 (_tmp80_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		_tmp81_ = filename;
		_tmp82_ = valadoc_api_class_get_unref_function_cname (cl);
		_tmp83_ = _tmp82_;
		_tmp84_ = gtkdoc_generator_add_symbol (self, _tmp81_, _tmp83_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp84_;
		_g_free0 (_tmp83_);
		_tmp85_ = gcomment;
		_tmp86_ = g_strdup ("Decreases the reference count of @object. When its reference count dro" \
"ps to 0, the object is finalized (i.e. its memory is freed).");
		_g_free0 (_tmp85_->brief_comment);
		_tmp85_->brief_comment = _tmp86_;
		_tmp87_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp87_);
		_tmp88_ = gtkdoc_generator_add_custom_header (self, "name", "canonical name of the property specified", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp89_ = _tmp88_;
		_gtkdoc_header_unref0 (_tmp89_);
		_tmp90_ = gtkdoc_generator_add_custom_header (self, "nick", "nick name for the property specified", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp91_ = _tmp90_;
		_gtkdoc_header_unref0 (_tmp91_);
		_tmp92_ = gtkdoc_generator_add_custom_header (self, "blurb", "description of the property specified", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp93_ = _tmp92_;
		_gtkdoc_header_unref0 (_tmp93_);
		_tmp94_ = gtkdoc_get_docbook_type_link (cl);
		_tmp95_ = _tmp94_;
		_tmp96_ = g_strdup_printf ("%s derived type of this property", _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = gtkdoc_generator_add_custom_header (self, "object_type", _tmp97_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp99_ = _tmp98_;
		_gtkdoc_header_unref0 (_tmp99_);
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
		_tmp100_ = gtkdoc_generator_add_custom_header (self, "flags", "flags for the property specified", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp101_ = _tmp100_;
		_gtkdoc_header_unref0 (_tmp101_);
		_tmp102_ = filename;
		_tmp103_ = valadoc_api_class_get_param_spec_function_cname (cl);
		_tmp104_ = _tmp103_;
		_tmp105_ = gtkdoc_generator_add_symbol (self, _tmp102_, _tmp104_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp105_;
		_g_free0 (_tmp104_);
		_tmp106_ = gcomment;
		_tmp107_ = gtkdoc_get_docbook_type_link (cl);
		_tmp108_ = _tmp107_;
		_tmp109_ = g_strdup_printf ("Creates a new <link linkend=\"GParamSpecBoxed\"><type>GParamSpecBoxed<" \
"/type></link> instance specifying a %s derived property.", _tmp108_);
		_g_free0 (_tmp106_->brief_comment);
		_tmp106_->brief_comment = _tmp109_;
		_g_free0 (_tmp108_);
		_tmp110_ = gcomment;
		_tmp111_ = g_strdup ("See <link linkend=\"g-param-spec-internal\"><function>g_param_spec_int" \
"ernal()</function></link> for details on property names.");
		_g_free0 (_tmp110_->long_comment);
		_tmp110_->long_comment = _tmp111_;
		_tmp112_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp112_);
		_tmp113_ = gtkdoc_get_docbook_type_link (cl);
		_tmp114_ = _tmp113_;
		_tmp115_ = g_strdup_printf ("a valid <link linkend=\"GValue\"><type>GValue</type></link> of %s deri" \
"ved type", _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = gtkdoc_generator_add_custom_header (self, "value", _tmp116_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp118_ = _tmp117_;
		_gtkdoc_header_unref0 (_tmp118_);
		_g_free0 (_tmp116_);
		_g_free0 (_tmp114_);
		_tmp119_ = gtkdoc_generator_add_custom_header (self, "v_object", "object value to be set", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp120_ = _tmp119_;
		_gtkdoc_header_unref0 (_tmp120_);
		_tmp121_ = filename;
		_tmp122_ = valadoc_api_class_get_set_value_function_cname (cl);
		_tmp123_ = _tmp122_;
		_tmp124_ = gtkdoc_generator_add_symbol (self, _tmp121_, _tmp123_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp124_;
		_g_free0 (_tmp123_);
		_tmp125_ = gcomment;
		_tmp126_ = gtkdoc_get_docbook_type_link (cl);
		_tmp127_ = _tmp126_;
		_tmp128_ = g_strdup_printf ("Set the contents of a %s derived <link linkend=\"GValue\"><type>GValue" \
"</type></link> to @v_object.", _tmp127_);
		_g_free0 (_tmp125_->brief_comment);
		_tmp125_->brief_comment = _tmp128_;
		_g_free0 (_tmp127_);
		_tmp129_ = gcomment;
		_tmp130_ = valadoc_api_class_get_set_value_function_cname (cl);
		_tmp131_ = _tmp130_;
		_tmp132_ = gtkdoc_to_docbook_id (_tmp131_);
		_tmp133_ = _tmp132_;
		_tmp134_ = valadoc_api_class_get_set_value_function_cname (cl);
		_tmp135_ = _tmp134_;
		_tmp136_ = valadoc_api_class_get_take_value_function_cname (cl);
		_tmp137_ = _tmp136_;
		_tmp138_ = gtkdoc_to_docbook_id (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = valadoc_api_class_get_take_value_function_cname (cl);
		_tmp141_ = _tmp140_;
		_tmp142_ = g_strdup_printf ("<link linkend=\"%s\"><function>%s()</function></link> increases the re" \
"ference count of @v_object (the <link linkend=\"GValue\"><type>GValue<" \
"/type></link> holds a reference to @v_object). If you do not wish to i" \
"ncrease the reference count of the object (i.e. you wish to pass your " \
"current reference to the <link linkend=\"GValue\"><type>GValue</type><" \
"/link> because you no longer need it), use <link linkend=\"%s\"><funct" \
"ion>%s()</function></link> instead.\n" \
"\n" \
"It is important that your <link linkend=\"GValue\"><type>GValue</type>" \
"</link> holds a reference to @v_object (either its own, or one it has " \
"taken) to ensure that the object won't be destroyed while the <link li" \
"nkend=\"GValue\"><type>GValue</type></link> still exists).", _tmp133_, _tmp135_, _tmp139_, _tmp141_);
		_g_free0 (_tmp129_->long_comment);
		_tmp129_->long_comment = _tmp142_;
		_g_free0 (_tmp141_);
		_g_free0 (_tmp139_);
		_g_free0 (_tmp137_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp133_);
		_g_free0 (_tmp131_);
		_tmp143_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp143_);
		_tmp144_ = gtkdoc_get_docbook_type_link (cl);
		_tmp145_ = _tmp144_;
		_tmp146_ = g_strdup_printf ("a valid <link linkend=\"GValue\"><type>GValue</type></link> of %s deri" \
"ved type", _tmp145_);
		_tmp147_ = _tmp146_;
		_tmp148_ = gtkdoc_generator_add_custom_header (self, "value", _tmp147_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp149_ = _tmp148_;
		_gtkdoc_header_unref0 (_tmp149_);
		_g_free0 (_tmp147_);
		_g_free0 (_tmp145_);
		_tmp150_ = filename;
		_tmp151_ = valadoc_api_class_get_get_value_function_cname (cl);
		_tmp152_ = _tmp151_;
		_tmp153_ = gtkdoc_generator_add_symbol (self, _tmp150_, _tmp152_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp153_;
		_g_free0 (_tmp152_);
		_tmp154_ = gcomment;
		_tmp155_ = gtkdoc_get_docbook_type_link (cl);
		_tmp156_ = _tmp155_;
		_tmp157_ = g_strdup_printf ("Get the contents of a %s derived <link linkend=\"GValue\"><type>GValue" \
"</type></link>.", _tmp156_);
		_g_free0 (_tmp154_->brief_comment);
		_tmp154_->brief_comment = _tmp157_;
		_g_free0 (_tmp156_);
		_tmp158_ = gcomment;
		_tmp159_ = g_strdup ("object contents of @value");
		_g_free0 (_tmp158_->returns);
		_tmp158_->returns = _tmp159_;
		_tmp160_ = self->priv->current_headers;
		vala_collection_clear ((ValaCollection*) _tmp160_);
		_tmp161_ = gtkdoc_get_docbook_type_link (cl);
		_tmp162_ = _tmp161_;
		_tmp163_ = g_strdup_printf ("a valid <link linkend=\"GValue\"><type>GValue</type></link> of %s deri" \
"ved type", _tmp162_);
		_tmp164_ = _tmp163_;
		_tmp165_ = gtkdoc_generator_add_custom_header (self, "value", _tmp164_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp166_ = _tmp165_;
		_gtkdoc_header_unref0 (_tmp166_);
		_g_free0 (_tmp164_);
		_g_free0 (_tmp162_);
		_tmp167_ = gtkdoc_generator_add_custom_header (self, "v_object", "object value to be set", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp168_ = _tmp167_;
		_gtkdoc_header_unref0 (_tmp168_);
		_tmp169_ = filename;
		_tmp170_ = valadoc_api_class_get_take_value_function_cname (cl);
		_tmp171_ = _tmp170_;
		_tmp172_ = gtkdoc_generator_add_symbol (self, _tmp169_, _tmp171_, NULL, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp172_;
		_g_free0 (_tmp171_);
		_tmp173_ = gcomment;
		_tmp174_ = gtkdoc_get_docbook_type_link (cl);
		_tmp175_ = _tmp174_;
		_tmp176_ = g_strdup_printf ("Sets the contents of a %s derived <link linkend=\"GValue\"><type>GValu" \
"e</type></link> to @v_object and takes over the ownership of the calle" \
"rs reference to @v_object; the caller doesn't have to unref it any mor" \
"e (i.e. the reference count of the object is not increased).", _tmp175_);
		_g_free0 (_tmp173_->brief_comment);
		_tmp173_->brief_comment = _tmp176_;
		_g_free0 (_tmp175_);
		_tmp177_ = gcomment;
		_tmp178_ = valadoc_api_class_get_set_value_function_cname (cl);
		_tmp179_ = _tmp178_;
		_tmp180_ = gtkdoc_to_docbook_id (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = valadoc_api_class_get_set_value_function_cname (cl);
		_tmp183_ = _tmp182_;
		_tmp184_ = g_strdup_printf ("If you want the GValue to hold its own reference to @v_object, use <li" \
"nk linkend=\"%s\"><function>%s()</function></link> instead.", _tmp181_, _tmp183_);
		_g_free0 (_tmp177_->long_comment);
		_tmp177_->long_comment = _tmp184_;
		_g_free0 (_tmp183_);
		_g_free0 (_tmp181_);
		_g_free0 (_tmp179_);
		_g_free0 (filename);
	}
	_tmp185_ = self->priv->current_headers;
	vala_collection_clear ((ValaCollection*) _tmp185_);
	_tmp186_ = g_new0 (ValadocApiNodeType, 1);
	_tmp186_[0] = VALADOC_API_NODE_TYPE_METHOD;
	_tmp187_ = _tmp186_;
	_tmp187__length1 = 1;
	_tmp188_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) cl, _tmp187_, (gint) 1, FALSE);
	_tmp189_ = _tmp188_;
	_tmp187_ = (g_free (_tmp187_), NULL);
	abstract_methods = _tmp189_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp190_;
		ValaList* _tmp191_;
		gint _m_size = 0;
		ValaList* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gint _m_index = 0;
		_tmp190_ = abstract_methods;
		_tmp191_ = _vala_iterable_ref0 (_tmp190_);
		_m_list = _tmp191_;
		_tmp192_ = _m_list;
		_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
		_tmp194_ = _tmp193_;
		_m_size = _tmp194_;
		_m_index = -1;
		while (TRUE) {
			ValadocApiNode* m = NULL;
			ValaList* _tmp195_;
			gpointer _tmp196_;
			gboolean _tmp197_ = FALSE;
			ValadocApiNode* _tmp198_;
			ValadocSettings* _tmp199_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp195_ = _m_list;
			_tmp196_ = vala_list_get (_tmp195_, _m_index);
			m = (ValadocApiNode*) _tmp196_;
			_tmp198_ = m;
			_tmp199_ = self->priv->settings;
			if (valadoc_api_node_is_browsable (_tmp198_, _tmp199_)) {
				_tmp197_ = TRUE;
			} else {
				ValadocApiNode* _tmp200_;
				gboolean _tmp201_;
				gboolean _tmp202_;
				_tmp200_ = m;
				_tmp201_ = valadoc_api_symbol_get_is_protected (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
				_tmp202_ = _tmp201_;
				_tmp197_ = _tmp202_;
			}
			if (_tmp197_) {
				ValadocApiNode* _tmp203_;
				_tmp203_ = m;
				gtkdoc_generator_visit_abstract_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp203_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			}
			_g_object_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp204_ = g_new0 (ValadocApiNodeType, 1);
	_tmp204_[0] = VALADOC_API_NODE_TYPE_PROPERTY;
	_tmp205_ = _tmp204_;
	_tmp205__length1 = 1;
	_tmp206_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) cl, _tmp205_, (gint) 1, FALSE);
	_tmp207_ = _tmp206_;
	_tmp205_ = (g_free (_tmp205_), NULL);
	abstract_properties = _tmp207_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp208_;
		ValaList* _tmp209_;
		gint _prop_size = 0;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		gint _prop_index = 0;
		_tmp208_ = abstract_properties;
		_tmp209_ = _vala_iterable_ref0 (_tmp208_);
		_prop_list = _tmp209_;
		_tmp210_ = _prop_list;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		_prop_size = _tmp212_;
		_prop_index = -1;
		while (TRUE) {
			ValadocApiNode* prop = NULL;
			ValaList* _tmp213_;
			gpointer _tmp214_;
			gboolean _tmp215_ = FALSE;
			ValadocApiNode* _tmp216_;
			ValadocSettings* _tmp217_;
			_prop_index = _prop_index + 1;
			if (!(_prop_index < _prop_size)) {
				break;
			}
			_tmp213_ = _prop_list;
			_tmp214_ = vala_list_get (_tmp213_, _prop_index);
			prop = (ValadocApiNode*) _tmp214_;
			_tmp216_ = prop;
			_tmp217_ = self->priv->settings;
			if (valadoc_api_node_is_browsable (_tmp216_, _tmp217_)) {
				_tmp215_ = TRUE;
			} else {
				ValadocApiNode* _tmp218_;
				gboolean _tmp219_;
				gboolean _tmp220_;
				_tmp218_ = prop;
				_tmp219_ = valadoc_api_symbol_get_is_protected (G_TYPE_CHECK_INSTANCE_CAST (_tmp218_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
				_tmp220_ = _tmp219_;
				_tmp215_ = _tmp220_;
			}
			if (_tmp215_) {
				ValadocApiNode* _tmp221_;
				_tmp221_ = prop;
				gtkdoc_generator_visit_abstract_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp221_, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
			}
			_g_object_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp222_ = gtkdoc_generator_add_custom_header (self, "parent_class", "the parent class structure", NULL, (gint) 0, DBL_MAX, TRUE);
	_tmp223_ = _tmp222_;
	_gtkdoc_header_unref0 (_tmp223_);
	_tmp224_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
	_tmp225_ = _tmp224_;
	_tmp226_ = valadoc_api_class_get_cname (cl);
	_tmp227_ = _tmp226_;
	_tmp228_ = g_strconcat (_tmp227_, "Class", NULL);
	_tmp229_ = _tmp228_;
	_tmp230_ = gtkdoc_generator_add_symbol (self, _tmp225_, _tmp229_, NULL, NULL, NULL, (gint) 0);
	_gtkdoc_gcomment_unref0 (gcomment);
	gcomment = _tmp230_;
	_g_free0 (_tmp229_);
	_g_free0 (_tmp227_);
	_g_free0 (_tmp225_);
	_tmp231_ = gcomment;
	_tmp232_ = gtkdoc_get_docbook_type_link (cl);
	_tmp233_ = _tmp232_;
	_tmp234_ = g_strdup_printf ("The class structure for %s. All the fields in this structure are priva" \
"te and should never be accessed directly.", _tmp233_);
	_g_free0 (_tmp231_->brief_comment);
	_tmp231_->brief_comment = _tmp234_;
	_g_free0 (_tmp233_);
	_tmp235_ = valadoc_documentation_get_filename ((ValadocDocumentation*) cl);
	_tmp236_ = _tmp235_;
	_tmp237_ = gtkdoc_generator_get_file_data (self, _tmp236_);
	_tmp238_ = _tmp237_;
	_g_free0 (_tmp236_);
	file_data = _tmp238_;
	_tmp239_ = file_data;
	_tmp240_ = valadoc_api_typesymbol_get_is_type_macro_name ((ValadocApiTypeSymbol*) cl);
	_tmp241_ = _tmp240_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp239_, _tmp241_);
	_g_free0 (_tmp241_);
	_tmp242_ = file_data;
	_tmp243_ = valadoc_api_class_get_is_class_type_macro_name (cl);
	_tmp244_ = _tmp243_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp242_, _tmp244_);
	_g_free0 (_tmp244_);
	_tmp245_ = file_data;
	_tmp246_ = valadoc_api_typesymbol_get_type_cast_macro_name ((ValadocApiTypeSymbol*) cl);
	_tmp247_ = _tmp246_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp245_, _tmp247_);
	_g_free0 (_tmp247_);
	_tmp248_ = file_data;
	_tmp249_ = valadoc_api_class_get_class_type_macro_name (cl);
	_tmp250_ = _tmp249_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp248_, _tmp250_);
	_g_free0 (_tmp250_);
	_tmp251_ = file_data;
	_tmp252_ = valadoc_api_class_get_class_macro_name (cl);
	_tmp253_ = _tmp252_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp251_, _tmp253_);
	_g_free0 (_tmp253_);
	_tmp254_ = file_data;
	_tmp255_ = valadoc_api_typesymbol_get_type_function_name ((ValadocApiTypeSymbol*) cl);
	_tmp256_ = _tmp255_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp254_, _tmp256_);
	_g_free0 (_tmp256_);
	_tmp257_ = file_data;
	_tmp258_ = valadoc_api_class_get_private_cname (cl);
	_tmp259_ = _tmp258_;
	gtkdoc_generator_file_data_register_private_section_line (_tmp257_, _tmp259_);
	_g_free0 (_tmp259_);
	_tmp261_ = valadoc_api_node_get_nspace ((ValadocApiNode*) cl);
	_tmp262_ = _tmp261_;
	_tmp263_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp262_);
	_tmp264_ = _tmp263_;
	if (_tmp264_ != NULL) {
		ValadocApiNamespace* _tmp265_;
		ValadocApiNamespace* _tmp266_;
		const gchar* _tmp267_;
		const gchar* _tmp268_;
		gchar* _tmp269_;
		gchar* _tmp270_;
		gchar* _tmp271_;
		_tmp265_ = valadoc_api_node_get_nspace ((ValadocApiNode*) cl);
		_tmp266_ = _tmp265_;
		_tmp267_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp266_);
		_tmp268_ = _tmp267_;
		_tmp269_ = g_utf8_strdown (_tmp268_, (gssize) -1);
		_tmp270_ = _tmp269_;
		_tmp271_ = g_strconcat (_tmp270_, "_", NULL);
		_g_free0 (_tmp260_);
		_tmp260_ = _tmp271_;
		_g_free0 (_tmp270_);
	} else {
		gchar* _tmp272_;
		_tmp272_ = g_strdup ("");
		_g_free0 (_tmp260_);
		_tmp260_ = _tmp272_;
	}
	_tmp273_ = file_data;
	_tmp274_ = valadoc_api_node_get_name ((ValadocApiNode*) cl);
	_tmp275_ = _tmp274_;
	_tmp276_ = gtkdoc_to_lower_case (_tmp275_);
	_tmp277_ = _tmp276_;
	_tmp278_ = g_strconcat (_tmp260_, _tmp277_, NULL);
	_tmp279_ = _tmp278_;
	_tmp280_ = g_strconcat (_tmp279_, "_construct", NULL);
	_tmp281_ = _tmp280_;
	gtkdoc_generator_file_data_register_private_section_line (_tmp273_, _tmp281_);
	_g_free0 (_tmp281_);
	_g_free0 (_tmp279_);
	_g_free0 (_tmp277_);
	_tmp282_ = old_cname;
	_tmp283_ = g_strdup (_tmp282_);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp283_;
	_tmp284_ = old_headers;
	_tmp285_ = _vala_iterable_ref0 (_tmp284_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp285_;
	_tmp286_ = old_class;
	_tmp287_ = _g_object_ref0 (_tmp286_);
	_g_object_unref0 (self->priv->current_class);
	self->priv->current_class = _tmp287_;
	_tmp288_ = old_dbus_interface;
	_tmp289_ = _gtkdoc_dbus_interface_ref0 (_tmp288_);
	_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
	self->priv->current_dbus_interface = _tmp289_;
	_g_free0 (_tmp260_);
	_gtkdoc_generator_file_data_unref0 (file_data);
	_vala_iterable_unref0 (abstract_properties);
	_vala_iterable_unref0 (abstract_methods);
	_gtkdoc_gcomment_unref0 (gcomment);
	_gtkdoc_dbus_interface_unref0 (old_dbus_interface);
	_g_object_unref0 (old_class);
	_vala_iterable_unref0 (old_headers);
	_g_free0 (old_cname);
}

static void
_vala_array_add19 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
gtkdoc_generator_create_see_function_array (GtkdocGenerator* self,
                                            gchar** functions,
                                            gint functions_length1,
                                            gint* result_length1)
{
	gchar** arr = NULL;
	gchar** _tmp0_;
	gint arr_length1;
	gint _arr_size_;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint __tmp5__size_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arr = _tmp0_;
	arr_length1 = 0;
	_arr_size_ = arr_length1;
	{
		gchar** func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
		func_collection = functions;
		func_collection_length1 = functions_length1;
		for (func_it = 0; func_it < func_collection_length1; func_it = func_it + 1) {
			gchar* _tmp1_;
			gchar* func = NULL;
			_tmp1_ = g_strdup (func_collection[func_it]);
			func = _tmp1_;
			{
				const gchar* _tmp2_;
				_tmp2_ = func;
				if (_tmp2_ != NULL) {
					const gchar* _tmp3_;
					gchar* _tmp4_;
					_tmp3_ = func;
					_tmp4_ = g_strconcat (_tmp3_, "()", NULL);
					_vala_array_add19 (&arr, &arr_length1, &_arr_size_, _tmp4_);
				}
				_g_free0 (func);
			}
		}
	}
	_tmp6_ = arr;
	_tmp6__length1 = arr_length1;
	if (_tmp6__length1 > 0) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = arr;
		_tmp7__length1 = arr_length1;
		_tmp5_ = _tmp7_;
		_tmp5__length1 = _tmp7__length1;
		__tmp5__size_ = _tmp5__length1;
	} else {
		_tmp5_ = NULL;
		_tmp5__length1 = 0;
		__tmp5__size_ = _tmp5__length1;
	}
	_tmp8_ = (_tmp5_ != NULL) ? _vala_array_dup9 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp8__length1 = _tmp5__length1;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	arr = (_vala_array_free (arr, arr_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
gtkdoc_generator_real_visit_struct (ValadocApiVisitor* base,
                                    ValadocApiStruct* st)
{
	GtkdocGenerator * self;
	gchar* old_cname = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValaList* old_headers = NULL;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	gchar* _tmp4_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValadocContentComment* _tmp11_;
	ValadocContentComment* _tmp12_;
	GtkdocGComment* _tmp13_;
	GtkdocGComment* _tmp14_;
	GtkdocGComment* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	ValaList* _tmp18_;
	ValaList* _tmp19_;
	GtkdocGeneratorFileData* file_data = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkdocGeneratorFileData* _tmp22_;
	GtkdocGeneratorFileData* _tmp23_;
	GtkdocGeneratorFileData* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GtkdocGeneratorFileData* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* dup_function_cname = NULL;
	gchar* _tmp30_;
	gchar* free_function_cname = NULL;
	gchar* _tmp31_;
	gchar* copy_function_cname = NULL;
	gchar* _tmp32_;
	gchar* destroy_function_cname = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp63_;
	const gchar* _tmp86_;
	const gchar* _tmp121_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->current_cname;
	_tmp1_ = g_strdup (_tmp0_);
	old_cname = _tmp1_;
	_tmp2_ = self->priv->current_headers;
	_tmp3_ = _vala_iterable_ref0 (_tmp2_);
	old_headers = _tmp3_;
	_tmp4_ = valadoc_api_struct_get_cname (st);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp6_;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) st, (ValadocApiVisitor*) self, TRUE);
	_tmp7_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_struct_get_cname (st);
	_tmp10_ = _tmp9_;
	_tmp11_ = valadoc_api_node_get_documentation ((ValadocApiNode*) st);
	_tmp12_ = _tmp11_;
	_tmp13_ = gtkdoc_generator_add_symbol (self, _tmp8_, _tmp10_, _tmp12_, NULL, NULL, (gint) 0);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	gcomment = _tmp14_;
	_tmp15_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) st, _tmp15_);
	_tmp16_ = old_cname;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->priv->current_cname);
	self->priv->current_cname = _tmp17_;
	_tmp18_ = old_headers;
	_tmp19_ = _vala_iterable_ref0 (_tmp18_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp19_;
	_tmp20_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
	_tmp21_ = _tmp20_;
	_tmp22_ = gtkdoc_generator_get_file_data (self, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	file_data = _tmp23_;
	_tmp24_ = file_data;
	_tmp25_ = valadoc_api_typesymbol_get_type_macro_name ((ValadocApiTypeSymbol*) st);
	_tmp26_ = _tmp25_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp24_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = file_data;
	_tmp28_ = valadoc_api_typesymbol_get_type_function_name ((ValadocApiTypeSymbol*) st);
	_tmp29_ = _tmp28_;
	gtkdoc_generator_file_data_register_standard_section_line (_tmp27_, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp30_ = valadoc_api_struct_get_dup_function_cname (st);
	dup_function_cname = _tmp30_;
	_tmp31_ = valadoc_api_struct_get_free_function_cname (st);
	free_function_cname = _tmp31_;
	_tmp32_ = valadoc_api_struct_get_copy_function_cname (st);
	copy_function_cname = _tmp32_;
	_tmp33_ = valadoc_api_struct_get_destroy_function_cname (st);
	destroy_function_cname = _tmp33_;
	_tmp34_ = dup_function_cname;
	if (_tmp34_ != NULL) {
		GtkdocGComment* dup_gcomment = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		GtkdocGComment* _tmp38_;
		GtkdocGComment* _tmp39_;
		GtkdocGComment* _tmp40_;
		ValaList* _tmp41_;
		GtkdocHeader* _tmp42_;
		GtkdocHeader* _tmp43_;
		const gchar* _tmp44_;
		GtkdocGComment* _tmp50_;
		gchar* _tmp51_;
		GtkdocGComment* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		gint _tmp61_ = 0;
		gchar** _tmp62_;
		_tmp35_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
		_tmp36_ = _tmp35_;
		_tmp37_ = dup_function_cname;
		_tmp38_ = gtkdoc_generator_add_symbol (self, _tmp36_, _tmp37_, NULL, NULL, NULL, (gint) 0);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp36_);
		dup_gcomment = _tmp39_;
		_tmp40_ = dup_gcomment;
		_tmp41_ = _tmp40_->headers;
		_tmp42_ = gtkdoc_header_new ("self", "the instance to duplicate", DBL_MAX, TRUE);
		_tmp43_ = _tmp42_;
		vala_collection_add ((ValaCollection*) _tmp41_, _tmp43_);
		_gtkdoc_header_unref0 (_tmp43_);
		_tmp44_ = free_function_cname;
		if (_tmp44_ != NULL) {
			GtkdocGComment* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp45_ = dup_gcomment;
			_tmp46_ = free_function_cname;
			_tmp47_ = g_strdup_printf ("a copy of @self, free with %s()", _tmp46_);
			_g_free0 (_tmp45_->returns);
			_tmp45_->returns = _tmp47_;
		} else {
			GtkdocGComment* _tmp48_;
			gchar* _tmp49_;
			_tmp48_ = dup_gcomment;
			_tmp49_ = g_strdup ("a copy of @self");
			_g_free0 (_tmp48_->returns);
			_tmp48_->returns = _tmp49_;
		}
		_tmp50_ = dup_gcomment;
		_tmp51_ = g_strdup ("Creates a copy of self.");
		_g_free0 (_tmp50_->brief_comment);
		_tmp50_->brief_comment = _tmp51_;
		_tmp52_ = dup_gcomment;
		_tmp53_ = copy_function_cname;
		_tmp54_ = g_strdup (_tmp53_);
		_tmp55_ = destroy_function_cname;
		_tmp56_ = g_strdup (_tmp55_);
		_tmp57_ = free_function_cname;
		_tmp58_ = g_strdup (_tmp57_);
		_tmp59_ = g_new0 (gchar*, 3 + 1);
		_tmp59_[0] = _tmp54_;
		_tmp59_[1] = _tmp56_;
		_tmp59_[2] = _tmp58_;
		_tmp60_ = _tmp59_;
		_tmp60__length1 = 3;
		_tmp62_ = gtkdoc_generator_create_see_function_array (self, _tmp60_, (gint) 3, &_tmp61_);
		_tmp52_->see_also = (_vala_array_free (_tmp52_->see_also, _tmp52_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp52_->see_also = _tmp62_;
		_tmp52_->see_also_length1 = _tmp61_;
		_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
		_gtkdoc_gcomment_unref0 (dup_gcomment);
	}
	_tmp63_ = free_function_cname;
	if (_tmp63_ != NULL) {
		GtkdocGComment* free_gcomment = NULL;
		gchar* _tmp64_;
		gchar* _tmp65_;
		const gchar* _tmp66_;
		GtkdocGComment* _tmp67_;
		GtkdocGComment* _tmp68_;
		GtkdocGComment* _tmp69_;
		ValaList* _tmp70_;
		GtkdocHeader* _tmp71_;
		GtkdocHeader* _tmp72_;
		GtkdocGComment* _tmp73_;
		gchar* _tmp74_;
		GtkdocGComment* _tmp75_;
		const gchar* _tmp76_;
		gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar** _tmp82_;
		gchar** _tmp83_;
		gint _tmp83__length1;
		gint _tmp84_ = 0;
		gchar** _tmp85_;
		_tmp64_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
		_tmp65_ = _tmp64_;
		_tmp66_ = free_function_cname;
		_tmp67_ = gtkdoc_generator_add_symbol (self, _tmp65_, _tmp66_, NULL, NULL, NULL, (gint) 0);
		_tmp68_ = _tmp67_;
		_g_free0 (_tmp65_);
		free_gcomment = _tmp68_;
		_tmp69_ = free_gcomment;
		_tmp70_ = _tmp69_->headers;
		_tmp71_ = gtkdoc_header_new ("self", "the struct to free", DBL_MAX, TRUE);
		_tmp72_ = _tmp71_;
		vala_collection_add ((ValaCollection*) _tmp70_, _tmp72_);
		_gtkdoc_header_unref0 (_tmp72_);
		_tmp73_ = free_gcomment;
		_tmp74_ = g_strdup ("Frees the heap-allocated struct.");
		_g_free0 (_tmp73_->brief_comment);
		_tmp73_->brief_comment = _tmp74_;
		_tmp75_ = free_gcomment;
		_tmp76_ = dup_function_cname;
		_tmp77_ = g_strdup (_tmp76_);
		_tmp78_ = copy_function_cname;
		_tmp79_ = g_strdup (_tmp78_);
		_tmp80_ = destroy_function_cname;
		_tmp81_ = g_strdup (_tmp80_);
		_tmp82_ = g_new0 (gchar*, 3 + 1);
		_tmp82_[0] = _tmp77_;
		_tmp82_[1] = _tmp79_;
		_tmp82_[2] = _tmp81_;
		_tmp83_ = _tmp82_;
		_tmp83__length1 = 3;
		_tmp85_ = gtkdoc_generator_create_see_function_array (self, _tmp83_, (gint) 3, &_tmp84_);
		_tmp75_->see_also = (_vala_array_free (_tmp75_->see_also, _tmp75_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp75_->see_also = _tmp85_;
		_tmp75_->see_also_length1 = _tmp84_;
		_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
		_gtkdoc_gcomment_unref0 (free_gcomment);
	}
	_tmp86_ = copy_function_cname;
	if (_tmp86_ != NULL) {
		GtkdocGComment* copy_gcomment = NULL;
		gchar* _tmp87_;
		gchar* _tmp88_;
		const gchar* _tmp89_;
		GtkdocGComment* _tmp90_;
		GtkdocGComment* _tmp91_;
		GtkdocGComment* _tmp92_;
		ValaList* _tmp93_;
		GtkdocHeader* _tmp94_;
		GtkdocHeader* _tmp95_;
		const gchar* _tmp96_;
		GtkdocGComment* _tmp108_;
		gchar* _tmp109_;
		GtkdocGComment* _tmp110_;
		const gchar* _tmp111_;
		gchar* _tmp112_;
		const gchar* _tmp113_;
		gchar* _tmp114_;
		const gchar* _tmp115_;
		gchar* _tmp116_;
		gchar** _tmp117_;
		gchar** _tmp118_;
		gint _tmp118__length1;
		gint _tmp119_ = 0;
		gchar** _tmp120_;
		_tmp87_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
		_tmp88_ = _tmp87_;
		_tmp89_ = copy_function_cname;
		_tmp90_ = gtkdoc_generator_add_symbol (self, _tmp88_, _tmp89_, NULL, NULL, NULL, (gint) 0);
		_tmp91_ = _tmp90_;
		_g_free0 (_tmp88_);
		copy_gcomment = _tmp91_;
		_tmp92_ = copy_gcomment;
		_tmp93_ = _tmp92_->headers;
		_tmp94_ = gtkdoc_header_new ("self", "the struct to copy", DBL_MAX, TRUE);
		_tmp95_ = _tmp94_;
		vala_collection_add ((ValaCollection*) _tmp93_, _tmp95_);
		_gtkdoc_header_unref0 (_tmp95_);
		_tmp96_ = destroy_function_cname;
		if (_tmp96_ != NULL) {
			GtkdocGComment* _tmp97_;
			ValaList* _tmp98_;
			const gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			GtkdocHeader* _tmp102_;
			GtkdocHeader* _tmp103_;
			_tmp97_ = copy_gcomment;
			_tmp98_ = _tmp97_->headers;
			_tmp99_ = destroy_function_cname;
			_tmp100_ = g_strdup_printf ("a unused struct. Use %s() to free the content.", _tmp99_);
			_tmp101_ = _tmp100_;
			_tmp102_ = gtkdoc_header_new ("dest", _tmp101_, DBL_MAX, TRUE);
			_tmp103_ = _tmp102_;
			vala_collection_add ((ValaCollection*) _tmp98_, _tmp103_);
			_gtkdoc_header_unref0 (_tmp103_);
			_g_free0 (_tmp101_);
		} else {
			GtkdocGComment* _tmp104_;
			ValaList* _tmp105_;
			GtkdocHeader* _tmp106_;
			GtkdocHeader* _tmp107_;
			_tmp104_ = copy_gcomment;
			_tmp105_ = _tmp104_->headers;
			_tmp106_ = gtkdoc_header_new ("dest", "a unused struct.", DBL_MAX, TRUE);
			_tmp107_ = _tmp106_;
			vala_collection_add ((ValaCollection*) _tmp105_, _tmp107_);
			_gtkdoc_header_unref0 (_tmp107_);
		}
		_tmp108_ = copy_gcomment;
		_tmp109_ = g_strdup ("Creates a copy of self.");
		_g_free0 (_tmp108_->brief_comment);
		_tmp108_->brief_comment = _tmp109_;
		_tmp110_ = copy_gcomment;
		_tmp111_ = dup_function_cname;
		_tmp112_ = g_strdup (_tmp111_);
		_tmp113_ = destroy_function_cname;
		_tmp114_ = g_strdup (_tmp113_);
		_tmp115_ = free_function_cname;
		_tmp116_ = g_strdup (_tmp115_);
		_tmp117_ = g_new0 (gchar*, 3 + 1);
		_tmp117_[0] = _tmp112_;
		_tmp117_[1] = _tmp114_;
		_tmp117_[2] = _tmp116_;
		_tmp118_ = _tmp117_;
		_tmp118__length1 = 3;
		_tmp120_ = gtkdoc_generator_create_see_function_array (self, _tmp118_, (gint) 3, &_tmp119_);
		_tmp110_->see_also = (_vala_array_free (_tmp110_->see_also, _tmp110_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp110_->see_also = _tmp120_;
		_tmp110_->see_also_length1 = _tmp119_;
		_tmp118_ = (_vala_array_free (_tmp118_, _tmp118__length1, (GDestroyNotify) g_free), NULL);
		_gtkdoc_gcomment_unref0 (copy_gcomment);
	}
	_tmp121_ = destroy_function_cname;
	if (_tmp121_ != NULL) {
		GtkdocGComment* destroy_gcomment = NULL;
		gchar* _tmp122_;
		gchar* _tmp123_;
		const gchar* _tmp124_;
		GtkdocGComment* _tmp125_;
		GtkdocGComment* _tmp126_;
		GtkdocGComment* _tmp127_;
		ValaList* _tmp128_;
		GtkdocHeader* _tmp129_;
		GtkdocHeader* _tmp130_;
		GtkdocGComment* _tmp131_;
		gchar* _tmp132_;
		GtkdocGComment* _tmp133_;
		const gchar* _tmp134_;
		gchar* _tmp135_;
		const gchar* _tmp136_;
		gchar* _tmp137_;
		const gchar* _tmp138_;
		gchar* _tmp139_;
		gchar** _tmp140_;
		gchar** _tmp141_;
		gint _tmp141__length1;
		gint _tmp142_ = 0;
		gchar** _tmp143_;
		_tmp122_ = valadoc_documentation_get_filename ((ValadocDocumentation*) st);
		_tmp123_ = _tmp122_;
		_tmp124_ = destroy_function_cname;
		_tmp125_ = gtkdoc_generator_add_symbol (self, _tmp123_, _tmp124_, NULL, NULL, NULL, (gint) 0);
		_tmp126_ = _tmp125_;
		_g_free0 (_tmp123_);
		destroy_gcomment = _tmp126_;
		_tmp127_ = destroy_gcomment;
		_tmp128_ = _tmp127_->headers;
		_tmp129_ = gtkdoc_header_new ("self", "the struct to destroy", DBL_MAX, TRUE);
		_tmp130_ = _tmp129_;
		vala_collection_add ((ValaCollection*) _tmp128_, _tmp130_);
		_gtkdoc_header_unref0 (_tmp130_);
		_tmp131_ = destroy_gcomment;
		_tmp132_ = g_strdup ("Frees the content of the struct pointed by @self.");
		_g_free0 (_tmp131_->brief_comment);
		_tmp131_->brief_comment = _tmp132_;
		_tmp133_ = destroy_gcomment;
		_tmp134_ = dup_function_cname;
		_tmp135_ = g_strdup (_tmp134_);
		_tmp136_ = copy_function_cname;
		_tmp137_ = g_strdup (_tmp136_);
		_tmp138_ = free_function_cname;
		_tmp139_ = g_strdup (_tmp138_);
		_tmp140_ = g_new0 (gchar*, 3 + 1);
		_tmp140_[0] = _tmp135_;
		_tmp140_[1] = _tmp137_;
		_tmp140_[2] = _tmp139_;
		_tmp141_ = _tmp140_;
		_tmp141__length1 = 3;
		_tmp143_ = gtkdoc_generator_create_see_function_array (self, _tmp141_, (gint) 3, &_tmp142_);
		_tmp133_->see_also = (_vala_array_free (_tmp133_->see_also, _tmp133_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp133_->see_also = _tmp143_;
		_tmp133_->see_also_length1 = _tmp142_;
		_tmp141_ = (_vala_array_free (_tmp141_, _tmp141__length1, (GDestroyNotify) g_free), NULL);
		_gtkdoc_gcomment_unref0 (destroy_gcomment);
	}
	_g_free0 (destroy_function_cname);
	_g_free0 (copy_function_cname);
	_g_free0 (free_function_cname);
	_g_free0 (dup_function_cname);
	_gtkdoc_generator_file_data_unref0 (file_data);
	_gtkdoc_gcomment_unref0 (gcomment);
	_vala_iterable_unref0 (old_headers);
	_g_free0 (old_cname);
}

/**
 * Visit thrown error domains
 */
static void
gtkdoc_generator_visit_thrown_error_domain (GtkdocGenerator* self,
                                            ValadocApiNode* _error_)
{
	GtkdocHeader* param_header = NULL;
	ValadocApiErrorDomain* edomain = NULL;
	ValadocApiErrorDomain* _tmp11_;
	ValadocApiErrorDomain* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	param_header = NULL;
	{
		ValaList* _header_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _header_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _header_index = 0;
		_tmp0_ = self->priv->current_headers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_header_list = _tmp1_;
		_tmp2_ = _header_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_header_size = _tmp4_;
		_header_index = -1;
		while (TRUE) {
			GtkdocHeader* header = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			GtkdocHeader* _tmp7_;
			const gchar* _tmp8_;
			_header_index = _header_index + 1;
			if (!(_header_index < _header_size)) {
				break;
			}
			_tmp5_ = _header_list;
			_tmp6_ = vala_list_get (_tmp5_, _header_index);
			header = (GtkdocHeader*) _tmp6_;
			_tmp7_ = header;
			_tmp8_ = _tmp7_->name;
			if (g_strcmp0 (_tmp8_, "error") == 0) {
				GtkdocHeader* _tmp9_;
				GtkdocHeader* _tmp10_;
				_tmp9_ = header;
				_tmp10_ = _gtkdoc_header_ref0 (_tmp9_);
				_gtkdoc_header_unref0 (param_header);
				param_header = _tmp10_;
				_gtkdoc_header_unref0 (header);
				break;
			}
			_gtkdoc_header_unref0 (header);
		}
		_vala_iterable_unref0 (_header_list);
	}
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_error_, VALADOC_API_TYPE_ERROR_DOMAIN) ? ((ValadocApiErrorDomain*) _error_) : NULL);
	edomain = _tmp11_;
	_tmp12_ = edomain;
	if (_tmp12_ != NULL) {
		GtkdocHeader* _tmp13_;
		_tmp13_ = param_header;
		if (_tmp13_ == NULL) {
			ValadocApiErrorDomain* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar** _tmp18_;
			gchar** _tmp19_;
			gint _tmp19__length1;
			GtkdocHeader* _tmp20_;
			GtkdocHeader* _tmp21_;
			_tmp14_ = edomain;
			_tmp15_ = valadoc_api_error_domain_get_cname (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf ("error-domains %s", _tmp16_);
			_tmp18_ = g_new0 (gchar*, 1 + 1);
			_tmp18_[0] = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp19__length1 = 1;
			_tmp20_ = gtkdoc_generator_add_custom_header (self, "error", "location to store the error occurring, or %NULL to ignore", _tmp19_, (gint) 1, DBL_MAX - 1, TRUE);
			_tmp21_ = _tmp20_;
			_gtkdoc_header_unref0 (_tmp21_);
			_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp16_);
		} else {
			gchar* annotation = NULL;
			GtkdocHeader* _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_;
			ValadocApiErrorDomain* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GtkdocHeader* _tmp33_;
			gchar** _tmp34_;
			gint _tmp34__length1;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp22_ = param_header;
			_tmp23_ = _tmp22_->annotations;
			_tmp23__length1 = _tmp22_->annotations_length1;
			_tmp24_ = _tmp23_[0];
			_tmp25_ = g_strdup (_tmp24_);
			annotation = _tmp25_;
			_tmp26_ = annotation;
			_tmp27_ = edomain;
			_tmp28_ = valadoc_api_error_domain_get_cname (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf (" %s", _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp26_, _tmp31_, NULL);
			_g_free0 (annotation);
			annotation = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_tmp33_ = param_header;
			_tmp34_ = _tmp33_->annotations;
			_tmp34__length1 = _tmp33_->annotations_length1;
			_tmp35_ = annotation;
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (_tmp34_[0]);
			_tmp34_[0] = _tmp36_;
			_g_free0 (annotation);
		}
	} else {
		GtkdocHeader* _tmp37_;
		_tmp37_ = param_header;
		if (_tmp37_ == NULL) {
			GtkdocHeader* _tmp38_;
			GtkdocHeader* _tmp39_;
			_tmp38_ = gtkdoc_generator_add_custom_header (self, "error", "location to store the error occurring, or %NULL to ignore", NULL, (gint) 0, DBL_MAX - 1, TRUE);
			_tmp39_ = _tmp38_;
			_gtkdoc_header_unref0 (_tmp39_);
		}
	}
	_g_object_unref0 (edomain);
	_gtkdoc_header_unref0 (param_header);
}

/**
 * Visit error domain definitions
 */
static void
gtkdoc_generator_real_visit_error_domain (ValadocApiVisitor* base,
                                          ValadocApiErrorDomain* edomain)
{
	GtkdocGenerator * self;
	ValaList* old_headers = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValadocContentComment* _tmp8_;
	ValadocContentComment* _tmp9_;
	GtkdocGComment* _tmp10_;
	GtkdocGComment* _tmp11_;
	GtkdocGeneratorFileData* file_data = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkdocGeneratorFileData* _tmp14_;
	GtkdocGeneratorFileData* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaList* _tmp20_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = self->priv->current_headers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	old_headers = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp3_;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) edomain, (ValadocApiVisitor*) self, TRUE);
	_tmp4_ = valadoc_documentation_get_filename ((ValadocDocumentation*) edomain);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_api_error_domain_get_cname (edomain);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_api_node_get_documentation ((ValadocApiNode*) edomain);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtkdoc_generator_add_symbol (self, _tmp5_, _tmp7_, _tmp9_, NULL, NULL, (gint) 0);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	gcomment = _tmp11_;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) edomain, gcomment);
	_tmp12_ = valadoc_documentation_get_filename ((ValadocDocumentation*) edomain);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtkdoc_generator_get_file_data (self, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	file_data = _tmp15_;
	_tmp16_ = valadoc_api_error_domain_get_quark_function_name (edomain);
	_tmp17_ = _tmp16_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = valadoc_api_error_domain_get_quark_macro_name (edomain);
	_tmp19_ = _tmp18_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = _vala_iterable_ref0 (old_headers);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp20_;
	_gtkdoc_generator_file_data_unref0 (file_data);
	_gtkdoc_gcomment_unref0 (gcomment);
	_vala_iterable_unref0 (old_headers);
}

static void
gtkdoc_generator_real_visit_error_code (ValadocApiVisitor* base,
                                        ValadocApiErrorCode* ecode)
{
	GtkdocGenerator * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	GtkdocHeader* _tmp4_;
	GtkdocHeader* _tmp5_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (ecode != NULL);
	_tmp0_ = valadoc_api_error_code_get_cname (ecode);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_node_get_documentation ((ValadocApiNode*) ecode);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtkdoc_generator_add_header (self, _tmp1_, _tmp3_, NULL, (gint) 0, DBL_MAX);
	_tmp5_ = _tmp4_;
	_gtkdoc_header_unref0 (_tmp5_);
	_g_free0 (_tmp1_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) ecode, (ValadocApiVisitor*) self, TRUE);
}

static void
gtkdoc_generator_real_visit_enum (ValadocApiVisitor* base,
                                  ValadocApiEnum* en)
{
	GtkdocGenerator * self;
	ValaList* old_headers = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValadocContentComment* _tmp8_;
	ValadocContentComment* _tmp9_;
	GtkdocGComment* _tmp10_;
	GtkdocGComment* _tmp11_;
	GtkdocGeneratorFileData* file_data = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkdocGeneratorFileData* _tmp14_;
	GtkdocGeneratorFileData* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaList* _tmp20_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->current_headers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	old_headers = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp3_;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) en, (ValadocApiVisitor*) self, TRUE);
	_tmp4_ = valadoc_documentation_get_filename ((ValadocDocumentation*) en);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_api_enum_get_cname (en);
	_tmp7_ = _tmp6_;
	_tmp8_ = valadoc_api_node_get_documentation ((ValadocApiNode*) en);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtkdoc_generator_add_symbol (self, _tmp5_, _tmp7_, _tmp9_, NULL, NULL, (gint) 0);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	gcomment = _tmp11_;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) en, gcomment);
	_tmp12_ = valadoc_documentation_get_filename ((ValadocDocumentation*) en);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtkdoc_generator_get_file_data (self, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	file_data = _tmp15_;
	_tmp16_ = valadoc_api_typesymbol_get_type_macro_name ((ValadocApiTypeSymbol*) en);
	_tmp17_ = _tmp16_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = valadoc_api_typesymbol_get_type_function_name ((ValadocApiTypeSymbol*) en);
	_tmp19_ = _tmp18_;
	gtkdoc_generator_file_data_register_standard_section_line (file_data, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = _vala_iterable_ref0 (old_headers);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp20_;
	_gtkdoc_generator_file_data_unref0 (file_data);
	_gtkdoc_gcomment_unref0 (gcomment);
	_vala_iterable_unref0 (old_headers);
}

static void
gtkdoc_generator_real_visit_enum_value (ValadocApiVisitor* base,
                                        ValadocApiEnumValue* eval)
{
	GtkdocGenerator * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	GtkdocHeader* _tmp4_;
	GtkdocHeader* _tmp5_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (eval != NULL);
	_tmp0_ = valadoc_api_enum_value_get_cname (eval);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_node_get_documentation ((ValadocApiNode*) eval);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtkdoc_generator_add_header (self, _tmp1_, _tmp3_, NULL, (gint) 0, DBL_MAX);
	_tmp5_ = _tmp4_;
	_gtkdoc_header_unref0 (_tmp5_);
	_g_free0 (_tmp1_);
	valadoc_api_node_accept_all_children ((ValadocApiNode*) eval, (ValadocApiVisitor*) self, TRUE);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
gtkdoc_generator_combine_comments (GtkdocGenerator* self,
                                   const gchar* brief,
                                   const gchar* _long_)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* _tmp4_ = NULL;
	gchar* _long = NULL;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GString* _tmp9_;
	const gchar* _tmp12_;
	GString* _tmp15_;
	gchar* _tmp16_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	if (brief != NULL) {
		GString* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = builder;
		_tmp2_ = string_strip (brief);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
	}
	if (_long_ != NULL) {
		gchar* _tmp5_;
		_tmp5_ = string_strip (_long_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp4_);
	_long = _tmp7_;
	_tmp9_ = builder;
	if (_tmp9_->len > ((gssize) 0)) {
		const gchar* _tmp10_;
		_tmp10_ = _long;
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GString* _tmp11_;
		_tmp11_ = builder;
		g_string_append (_tmp11_, "\n\n");
	}
	_tmp12_ = _long;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		GString* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = builder;
		_tmp14_ = _long;
		g_string_append (_tmp13_, _tmp14_);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp15_->str = NULL;
	result = _tmp16_;
	_g_free0 (_long);
	_g_free0 (_tmp4_);
	_g_string_free0 (builder);
	return result;
}

static void
gtkdoc_generator_real_visit_property (ValadocApiVisitor* base,
                                      ValadocApiProperty* prop)
{
	GtkdocGenerator * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValadocContentComment* _tmp21_;
	ValadocContentComment* _tmp22_;
	GtkdocGComment* _tmp23_;
	GtkdocGComment* _tmp24_;
	ValadocApiTypeParameter* type_parameter = NULL;
	ValadocApiTypeReference* _tmp25_;
	ValadocApiTypeReference* _tmp26_;
	ValadocApiItem* _tmp27_;
	ValadocApiItem* _tmp28_;
	ValadocApiTypeParameter* _tmp29_;
	gchar* return_type_link = NULL;
	ValadocApiTypeParameter* _tmp30_;
	GtkdocGComment* _tmp64_;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_ = FALSE;
	ValadocApiPropertyAccessor* _tmp67_;
	ValadocApiPropertyAccessor* _tmp68_;
	gboolean _tmp148_ = FALSE;
	gboolean _tmp149_ = FALSE;
	ValadocApiPropertyAccessor* _tmp150_;
	ValadocApiPropertyAccessor* _tmp151_;
	const gchar* _tmp234_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (prop != NULL);
	_tmp2_ = valadoc_api_property_get_is_override (prop);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) prop);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = valadoc_api_property_get_is_abstract (prop);
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = valadoc_api_property_get_is_virtual (prop);
			_tmp11_ = _tmp10_;
			_tmp7_ = !_tmp11_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValadocApiProperty* _tmp12_;
			ValadocApiProperty* _tmp13_;
			_tmp12_ = valadoc_api_property_get_base_property (prop);
			_tmp13_ = _tmp12_;
			_tmp6_ = _tmp13_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp14_ = valadoc_documentation_get_filename ((ValadocDocumentation*) prop);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->current_cname;
	_tmp17_ = valadoc_api_property_get_cname (prop);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf ("%s:%s", _tmp16_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = valadoc_api_node_get_documentation ((ValadocApiNode*) prop);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtkdoc_generator_add_comment (self, _tmp15_, _tmp20_, _tmp22_);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	gcomment = _tmp24_;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) prop, (ValadocApiVisitor*) self, TRUE);
	_tmp25_ = valadoc_api_property_get_property_type (prop);
	_tmp26_ = _tmp25_;
	_tmp27_ = valadoc_api_typereference_get_data_type (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp28_) : NULL);
	type_parameter = _tmp29_;
	return_type_link = NULL;
	_tmp30_ = type_parameter;
	if (_tmp30_ != NULL) {
		ValadocApiTypeParameter* _tmp31_;
		ValadocApiItem* _tmp32_;
		ValadocApiItem* _tmp33_;
		_tmp31_ = type_parameter;
		_tmp32_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp31_);
		_tmp33_ = _tmp32_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiItem* _tmp34_;
			ValadocApiItem* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			ValadocApiTypeParameter* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp34_ = valadoc_api_item_get_parent ((ValadocApiItem*) prop);
			_tmp35_ = _tmp34_;
			_tmp36_ = gtkdoc_get_cname (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = type_parameter;
			_tmp39_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_utf8_strdown (_tmp40_, (gssize) -1);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strdup_printf ("#%s:%s-type", _tmp37_, _tmp42_);
			_g_free0 (return_type_link);
			return_type_link = _tmp43_;
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
		} else {
			gboolean _tmp44_ = FALSE;
			ValadocApiTypeParameter* _tmp45_;
			ValadocApiItem* _tmp46_;
			ValadocApiItem* _tmp47_;
			_tmp45_ = type_parameter;
			_tmp46_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp45_);
			_tmp47_ = _tmp46_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiTypeParameter* _tmp48_;
				ValadocApiItem* _tmp49_;
				ValadocApiItem* _tmp50_;
				ValadocApiAttribute* _tmp51_;
				ValadocApiAttribute* _tmp52_;
				_tmp48_ = type_parameter;
				_tmp49_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = valadoc_api_symbol_get_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), "GenericAccessors");
				_tmp52_ = _tmp51_;
				_tmp44_ = _tmp52_ != NULL;
				_g_object_unref0 (_tmp52_);
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				ValadocApiTypeParameter* _tmp53_;
				ValadocApiItem* _tmp54_;
				ValadocApiItem* _tmp55_;
				gchar* _tmp56_;
				gchar* _tmp57_;
				ValadocApiTypeParameter* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp53_ = type_parameter;
				_tmp54_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = gtkdoc_get_cname (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = type_parameter;
				_tmp59_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_utf8_strdown (_tmp60_, (gssize) -1);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strdup_printf ("#_%sIface.get_%s_type()", _tmp57_, _tmp62_);
				_g_free0 (return_type_link);
				return_type_link = _tmp63_;
				_g_free0 (_tmp62_);
				_g_free0 (_tmp57_);
			}
		}
	}
	_tmp64_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) prop, _tmp64_);
	_tmp67_ = valadoc_api_property_get_getter (prop);
	_tmp68_ = _tmp67_;
	if (_tmp68_ != NULL) {
		ValadocApiPropertyAccessor* _tmp69_;
		ValadocApiPropertyAccessor* _tmp70_;
		gboolean _tmp71_;
		gboolean _tmp72_;
		_tmp69_ = valadoc_api_property_get_getter (prop);
		_tmp70_ = _tmp69_;
		_tmp71_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp66_ = !_tmp72_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValadocApiPropertyAccessor* _tmp73_;
		ValadocApiPropertyAccessor* _tmp74_;
		gboolean _tmp75_;
		gboolean _tmp76_;
		_tmp73_ = valadoc_api_property_get_getter (prop);
		_tmp74_ = _tmp73_;
		_tmp75_ = valadoc_api_property_accessor_get_is_get (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp65_ = _tmp76_;
	} else {
		_tmp65_ = FALSE;
	}
	if (_tmp65_) {
		GtkdocGComment* getter_gcomment = NULL;
		gchar* _tmp77_;
		gchar* _tmp78_;
		ValadocApiPropertyAccessor* _tmp79_;
		ValadocApiPropertyAccessor* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		GtkdocGComment* _tmp83_;
		GtkdocGComment* _tmp84_;
		GtkdocGComment* _tmp85_;
		ValaList* _tmp86_;
		ValadocApiItem* _tmp87_;
		ValadocApiItem* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		GtkdocHeader* _tmp93_;
		GtkdocHeader* _tmp94_;
		GtkdocGComment* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		const gchar* _tmp99_;
		GtkdocGComment* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		GtkdocGComment* _tmp111_;
		GtkdocGComment* _tmp112_;
		const gchar* _tmp113_;
		GtkdocGComment* _tmp114_;
		const gchar* _tmp115_;
		gchar* _tmp116_;
		gboolean _tmp117_ = FALSE;
		ValadocApiTypeReference* _tmp118_;
		ValadocApiTypeReference* _tmp119_;
		GtkdocGComment* _tmp144_;
		GtkdocGComment* _tmp145_;
		ValaList* _tmp146_;
		ValaList* _tmp147_;
		_tmp77_ = valadoc_documentation_get_filename ((ValadocDocumentation*) prop);
		_tmp78_ = _tmp77_;
		_tmp79_ = valadoc_api_property_get_getter (prop);
		_tmp80_ = _tmp79_;
		_tmp81_ = valadoc_api_property_accessor_get_cname (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = gtkdoc_generator_add_symbol (self, _tmp78_, _tmp82_, NULL, NULL, NULL, (gint) 0);
		_tmp84_ = _tmp83_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp78_);
		getter_gcomment = _tmp84_;
		_tmp85_ = getter_gcomment;
		_tmp86_ = _tmp85_->headers;
		_tmp87_ = valadoc_api_item_get_parent ((ValadocApiItem*) prop);
		_tmp88_ = _tmp87_;
		_tmp89_ = gtkdoc_get_docbook_link (_tmp88_, FALSE, FALSE);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strdup_printf ("the %s instance to query", _tmp90_);
		_tmp92_ = _tmp91_;
		_tmp93_ = gtkdoc_header_new ("self", _tmp92_, (gdouble) 1, TRUE);
		_tmp94_ = _tmp93_;
		vala_collection_add ((ValaCollection*) _tmp86_, _tmp94_);
		_gtkdoc_header_unref0 (_tmp94_);
		_g_free0 (_tmp92_);
		_g_free0 (_tmp90_);
		_tmp95_ = getter_gcomment;
		_tmp96_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strdup_printf ("the value of the %s property", _tmp97_);
		_g_free0 (_tmp95_->returns);
		_tmp95_->returns = _tmp98_;
		_g_free0 (_tmp97_);
		_tmp99_ = return_type_link;
		if (_tmp99_ != NULL) {
			GtkdocGComment* _tmp100_;
			GtkdocGComment* _tmp101_;
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			_tmp100_ = getter_gcomment;
			_tmp101_ = getter_gcomment;
			_tmp102_ = _tmp101_->returns;
			_tmp103_ = return_type_link;
			_tmp104_ = g_strconcat (" of type ", _tmp103_, NULL);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strconcat (_tmp102_, _tmp105_, NULL);
			_g_free0 (_tmp101_->returns);
			_tmp101_->returns = _tmp106_;
			_g_free0 (_tmp105_);
		}
		_tmp107_ = getter_gcomment;
		_tmp108_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp109_ = _tmp108_;
		_tmp110_ = g_strdup_printf ("Get and return the current value of the %s property.", _tmp109_);
		_g_free0 (_tmp107_->brief_comment);
		_tmp107_->brief_comment = _tmp110_;
		_g_free0 (_tmp109_);
		_tmp111_ = getter_gcomment;
		_tmp112_ = gcomment;
		_tmp113_ = _tmp112_->brief_comment;
		_tmp114_ = gcomment;
		_tmp115_ = _tmp114_->long_comment;
		_tmp116_ = gtkdoc_generator_combine_comments (self, _tmp113_, _tmp115_);
		_g_free0 (_tmp111_->long_comment);
		_tmp111_->long_comment = _tmp116_;
		_tmp118_ = valadoc_api_property_get_property_type (prop);
		_tmp119_ = _tmp118_;
		if (_tmp119_ != NULL) {
			ValadocApiTypeReference* _tmp120_;
			ValadocApiTypeReference* _tmp121_;
			ValadocApiItem* _tmp122_;
			ValadocApiItem* _tmp123_;
			_tmp120_ = valadoc_api_property_get_property_type (prop);
			_tmp121_ = _tmp120_;
			_tmp122_ = valadoc_api_typereference_get_data_type (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp117_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALADOC_API_TYPE_ARRAY);
		} else {
			_tmp117_ = FALSE;
		}
		if (_tmp117_) {
			ValadocApiItem* array_type = NULL;
			ValadocApiTypeReference* _tmp124_;
			ValadocApiTypeReference* _tmp125_;
			ValadocApiItem* _tmp126_;
			ValadocApiItem* _tmp127_;
			ValadocApiItem* _tmp128_;
			_tmp124_ = valadoc_api_property_get_property_type (prop);
			_tmp125_ = _tmp124_;
			_tmp126_ = valadoc_api_typereference_get_data_type (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = _g_object_ref0 (_tmp127_);
			array_type = _tmp128_;
			{
				guint dim = 0U;
				dim = (guint) 1;
				{
					gboolean _tmp129_ = FALSE;
					_tmp129_ = TRUE;
					while (TRUE) {
						gboolean _tmp135_ = FALSE;
						ValadocApiItem* _tmp136_;
						GtkdocGComment* _tmp138_;
						ValaList* _tmp139_;
						gchar* _tmp140_;
						gchar* _tmp141_;
						GtkdocHeader* _tmp142_;
						GtkdocHeader* _tmp143_;
						if (!_tmp129_) {
							guint _tmp130_;
							ValadocApiItem* _tmp131_;
							ValadocApiItem* _tmp132_;
							ValadocApiItem* _tmp133_;
							ValadocApiItem* _tmp134_;
							_tmp130_ = dim;
							dim = _tmp130_ + 1;
							_tmp131_ = array_type;
							_tmp132_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
							_tmp133_ = _tmp132_;
							_tmp134_ = _g_object_ref0 (_tmp133_);
							_g_object_unref0 (array_type);
							array_type = _tmp134_;
						}
						_tmp129_ = FALSE;
						_tmp136_ = array_type;
						if (_tmp136_ != NULL) {
							ValadocApiItem* _tmp137_;
							_tmp137_ = array_type;
							_tmp135_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALADOC_API_TYPE_ARRAY);
						} else {
							_tmp135_ = FALSE;
						}
						if (!_tmp135_) {
							break;
						}
						_tmp138_ = gcomment;
						_tmp139_ = _tmp138_->headers;
						_tmp140_ = g_strdup_printf ("result_length%u", dim);
						_tmp141_ = _tmp140_;
						_tmp142_ = gtkdoc_header_new (_tmp141_, "return location for the length of the property's value", DBL_MAX, TRUE);
						_tmp143_ = _tmp142_;
						vala_collection_add ((ValaCollection*) _tmp139_, _tmp143_);
						_gtkdoc_header_unref0 (_tmp143_);
						_g_free0 (_tmp141_);
					}
				}
			}
			_g_object_unref0 (array_type);
		}
		_tmp144_ = getter_gcomment;
		_tmp145_ = gcomment;
		_tmp146_ = _tmp145_->versioning;
		_tmp147_ = _vala_iterable_ref0 (_tmp146_);
		_vala_iterable_unref0 (_tmp144_->versioning);
		_tmp144_->versioning = _tmp147_;
		_gtkdoc_gcomment_unref0 (getter_gcomment);
	}
	_tmp150_ = valadoc_api_property_get_setter (prop);
	_tmp151_ = _tmp150_;
	if (_tmp151_ != NULL) {
		ValadocApiPropertyAccessor* _tmp152_;
		ValadocApiPropertyAccessor* _tmp153_;
		gboolean _tmp154_;
		gboolean _tmp155_;
		_tmp152_ = valadoc_api_property_get_setter (prop);
		_tmp153_ = _tmp152_;
		_tmp154_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) _tmp153_);
		_tmp155_ = _tmp154_;
		_tmp149_ = !_tmp155_;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValadocApiPropertyAccessor* _tmp156_;
		ValadocApiPropertyAccessor* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp156_ = valadoc_api_property_get_setter (prop);
		_tmp157_ = _tmp156_;
		_tmp158_ = valadoc_api_property_accessor_get_is_set (_tmp157_);
		_tmp159_ = _tmp158_;
		_tmp148_ = _tmp159_;
	} else {
		_tmp148_ = FALSE;
	}
	if (_tmp148_) {
		GtkdocGComment* setter_gcomment = NULL;
		gchar* _tmp160_;
		gchar* _tmp161_;
		ValadocApiPropertyAccessor* _tmp162_;
		ValadocApiPropertyAccessor* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		GtkdocGComment* _tmp166_;
		GtkdocGComment* _tmp167_;
		GtkdocGComment* _tmp168_;
		ValaList* _tmp169_;
		ValadocApiItem* _tmp170_;
		ValadocApiItem* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		GtkdocHeader* _tmp176_;
		GtkdocHeader* _tmp177_;
		gchar* _tmp178_ = NULL;
		const gchar* _tmp179_;
		gchar* type_desc = NULL;
		gchar* _tmp183_;
		GtkdocGComment* _tmp184_;
		ValaList* _tmp185_;
		gchar* _tmp186_;
		gchar* _tmp187_;
		const gchar* _tmp188_;
		gchar* _tmp189_;
		gchar* _tmp190_;
		GtkdocHeader* _tmp191_;
		GtkdocHeader* _tmp192_;
		GtkdocGComment* _tmp193_;
		gchar* _tmp194_;
		gchar* _tmp195_;
		gchar* _tmp196_;
		GtkdocGComment* _tmp197_;
		GtkdocGComment* _tmp198_;
		const gchar* _tmp199_;
		GtkdocGComment* _tmp200_;
		const gchar* _tmp201_;
		gchar* _tmp202_;
		gboolean _tmp203_ = FALSE;
		ValadocApiTypeReference* _tmp204_;
		ValadocApiTypeReference* _tmp205_;
		GtkdocGComment* _tmp230_;
		GtkdocGComment* _tmp231_;
		ValaList* _tmp232_;
		ValaList* _tmp233_;
		_tmp160_ = valadoc_documentation_get_filename ((ValadocDocumentation*) prop);
		_tmp161_ = _tmp160_;
		_tmp162_ = valadoc_api_property_get_setter (prop);
		_tmp163_ = _tmp162_;
		_tmp164_ = valadoc_api_property_accessor_get_cname (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp166_ = gtkdoc_generator_add_symbol (self, _tmp161_, _tmp165_, NULL, NULL, NULL, (gint) 0);
		_tmp167_ = _tmp166_;
		_g_free0 (_tmp165_);
		_g_free0 (_tmp161_);
		setter_gcomment = _tmp167_;
		_tmp168_ = setter_gcomment;
		_tmp169_ = _tmp168_->headers;
		_tmp170_ = valadoc_api_item_get_parent ((ValadocApiItem*) prop);
		_tmp171_ = _tmp170_;
		_tmp172_ = gtkdoc_get_docbook_link (_tmp171_, FALSE, FALSE);
		_tmp173_ = _tmp172_;
		_tmp174_ = g_strdup_printf ("the %s instance to modify", _tmp173_);
		_tmp175_ = _tmp174_;
		_tmp176_ = gtkdoc_header_new ("self", _tmp175_, (gdouble) 1, TRUE);
		_tmp177_ = _tmp176_;
		vala_collection_add ((ValaCollection*) _tmp169_, _tmp177_);
		_gtkdoc_header_unref0 (_tmp177_);
		_g_free0 (_tmp175_);
		_g_free0 (_tmp173_);
		_tmp179_ = return_type_link;
		if (_tmp179_ != NULL) {
			const gchar* _tmp180_;
			gchar* _tmp181_;
			_tmp180_ = return_type_link;
			_tmp181_ = g_strconcat (" of type ", _tmp180_, NULL);
			_g_free0 (_tmp178_);
			_tmp178_ = _tmp181_;
		} else {
			gchar* _tmp182_;
			_tmp182_ = g_strdup ("");
			_g_free0 (_tmp178_);
			_tmp178_ = _tmp182_;
		}
		_tmp183_ = g_strdup (_tmp178_);
		type_desc = _tmp183_;
		_tmp184_ = setter_gcomment;
		_tmp185_ = _tmp184_->headers;
		_tmp186_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp187_ = _tmp186_;
		_tmp188_ = type_desc;
		_tmp189_ = g_strdup_printf ("the new value of the %s property%s", _tmp187_, _tmp188_);
		_tmp190_ = _tmp189_;
		_tmp191_ = gtkdoc_header_new ("value", _tmp190_, (gdouble) 2, TRUE);
		_tmp192_ = _tmp191_;
		vala_collection_add ((ValaCollection*) _tmp185_, _tmp192_);
		_gtkdoc_header_unref0 (_tmp192_);
		_g_free0 (_tmp190_);
		_g_free0 (_tmp187_);
		_tmp193_ = setter_gcomment;
		_tmp194_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp195_ = _tmp194_;
		_tmp196_ = g_strdup_printf ("Set the value of the %s property to @value.", _tmp195_);
		_g_free0 (_tmp193_->brief_comment);
		_tmp193_->brief_comment = _tmp196_;
		_g_free0 (_tmp195_);
		_tmp197_ = setter_gcomment;
		_tmp198_ = gcomment;
		_tmp199_ = _tmp198_->brief_comment;
		_tmp200_ = gcomment;
		_tmp201_ = _tmp200_->long_comment;
		_tmp202_ = gtkdoc_generator_combine_comments (self, _tmp199_, _tmp201_);
		_g_free0 (_tmp197_->long_comment);
		_tmp197_->long_comment = _tmp202_;
		_tmp204_ = valadoc_api_property_get_property_type (prop);
		_tmp205_ = _tmp204_;
		if (_tmp205_ != NULL) {
			ValadocApiTypeReference* _tmp206_;
			ValadocApiTypeReference* _tmp207_;
			ValadocApiItem* _tmp208_;
			ValadocApiItem* _tmp209_;
			_tmp206_ = valadoc_api_property_get_property_type (prop);
			_tmp207_ = _tmp206_;
			_tmp208_ = valadoc_api_typereference_get_data_type (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp203_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, VALADOC_API_TYPE_ARRAY);
		} else {
			_tmp203_ = FALSE;
		}
		if (_tmp203_) {
			ValadocApiItem* array_type = NULL;
			ValadocApiTypeReference* _tmp210_;
			ValadocApiTypeReference* _tmp211_;
			ValadocApiItem* _tmp212_;
			ValadocApiItem* _tmp213_;
			ValadocApiItem* _tmp214_;
			_tmp210_ = valadoc_api_property_get_property_type (prop);
			_tmp211_ = _tmp210_;
			_tmp212_ = valadoc_api_typereference_get_data_type (_tmp211_);
			_tmp213_ = _tmp212_;
			_tmp214_ = _g_object_ref0 (_tmp213_);
			array_type = _tmp214_;
			{
				guint dim = 0U;
				dim = (guint) 1;
				{
					gboolean _tmp215_ = FALSE;
					_tmp215_ = TRUE;
					while (TRUE) {
						gboolean _tmp221_ = FALSE;
						ValadocApiItem* _tmp222_;
						GtkdocGComment* _tmp224_;
						ValaList* _tmp225_;
						gchar* _tmp226_;
						gchar* _tmp227_;
						GtkdocHeader* _tmp228_;
						GtkdocHeader* _tmp229_;
						if (!_tmp215_) {
							guint _tmp216_;
							ValadocApiItem* _tmp217_;
							ValadocApiItem* _tmp218_;
							ValadocApiItem* _tmp219_;
							ValadocApiItem* _tmp220_;
							_tmp216_ = dim;
							dim = _tmp216_ + 1;
							_tmp217_ = array_type;
							_tmp218_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp217_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
							_tmp219_ = _tmp218_;
							_tmp220_ = _g_object_ref0 (_tmp219_);
							_g_object_unref0 (array_type);
							array_type = _tmp220_;
						}
						_tmp215_ = FALSE;
						_tmp222_ = array_type;
						if (_tmp222_ != NULL) {
							ValadocApiItem* _tmp223_;
							_tmp223_ = array_type;
							_tmp221_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp223_, VALADOC_API_TYPE_ARRAY);
						} else {
							_tmp221_ = FALSE;
						}
						if (!_tmp221_) {
							break;
						}
						_tmp224_ = gcomment;
						_tmp225_ = _tmp224_->headers;
						_tmp226_ = g_strdup_printf ("value_length%u", dim);
						_tmp227_ = _tmp226_;
						_tmp228_ = gtkdoc_header_new (_tmp227_, "length of the property's new value", DBL_MAX, TRUE);
						_tmp229_ = _tmp228_;
						vala_collection_add ((ValaCollection*) _tmp225_, _tmp229_);
						_gtkdoc_header_unref0 (_tmp229_);
						_g_free0 (_tmp227_);
					}
				}
			}
			_g_object_unref0 (array_type);
		}
		_tmp230_ = setter_gcomment;
		_tmp231_ = gcomment;
		_tmp232_ = _tmp231_->versioning;
		_tmp233_ = _vala_iterable_ref0 (_tmp232_);
		_vala_iterable_unref0 (_tmp230_->versioning);
		_tmp230_->versioning = _tmp233_;
		_g_free0 (type_desc);
		_g_free0 (_tmp178_);
		_gtkdoc_gcomment_unref0 (setter_gcomment);
	}
	_tmp234_ = return_type_link;
	if (_tmp234_ != NULL) {
		gchar* return_type_desc = NULL;
		ValadocApiItem* _tmp235_;
		ValadocApiItem* _tmp236_;
		gchar* _tmp237_;
		gchar* _tmp238_;
		ValadocApiTypeParameter* _tmp239_;
		const gchar* _tmp240_;
		const gchar* _tmp241_;
		gchar* _tmp242_;
		gchar* _tmp243_;
		gchar* _tmp244_;
		gchar* _tmp245_;
		GtkdocGComment* _tmp246_;
		const gchar* _tmp247_;
		GtkdocGComment* _tmp248_;
		const gchar* _tmp249_;
		gchar* _tmp250_;
		_tmp235_ = valadoc_api_item_get_parent ((ValadocApiItem*) prop);
		_tmp236_ = _tmp235_;
		_tmp237_ = gtkdoc_get_cname (_tmp236_);
		_tmp238_ = _tmp237_;
		_tmp239_ = type_parameter;
		_tmp240_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp239_);
		_tmp241_ = _tmp240_;
		_tmp242_ = g_utf8_strdown (_tmp241_, (gssize) -1);
		_tmp243_ = _tmp242_;
		_tmp244_ = g_strdup_printf ("<para>Holds a value from type #%s:%s-type.</para>", _tmp238_, _tmp243_);
		_tmp245_ = _tmp244_;
		_g_free0 (_tmp243_);
		_g_free0 (_tmp238_);
		return_type_desc = _tmp245_;
		_tmp246_ = gcomment;
		_tmp247_ = return_type_desc;
		_tmp248_ = gcomment;
		_tmp249_ = _tmp248_->long_comment;
		_tmp250_ = gtkdoc_generator_combine_inline_docs (self, _tmp247_, _tmp249_);
		_g_free0 (_tmp246_->long_comment);
		_tmp246_->long_comment = _tmp250_;
		_g_free0 (return_type_desc);
	}
	_g_free0 (return_type_link);
	_g_object_unref0 (type_parameter);
	_gtkdoc_gcomment_unref0 (gcomment);
}

static void
gtkdoc_generator_real_visit_field (ValadocApiVisitor* base,
                                   ValadocApiField* f)
{
	GtkdocGenerator * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaList* _tmp2_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_headers;
	if (_tmp2_ == NULL) {
		GtkdocGComment* gcomment = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		ValadocContentComment* _tmp7_;
		ValadocContentComment* _tmp8_;
		GtkdocGComment* _tmp9_;
		GtkdocGComment* _tmp10_;
		GtkdocGComment* _tmp11_;
		_tmp3_ = valadoc_documentation_get_filename ((ValadocDocumentation*) f);
		_tmp4_ = _tmp3_;
		_tmp5_ = valadoc_api_field_get_cname (f);
		_tmp6_ = _tmp5_;
		_tmp7_ = valadoc_api_node_get_documentation ((ValadocApiNode*) f);
		_tmp8_ = _tmp7_;
		_tmp9_ = gtkdoc_generator_add_symbol (self, _tmp4_, _tmp6_, _tmp8_, NULL, NULL, (gint) 0);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		gcomment = _tmp10_;
		valadoc_api_node_accept_all_children ((ValadocApiNode*) f, (ValadocApiVisitor*) self, TRUE);
		_tmp11_ = gcomment;
		gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) f, _tmp11_);
		_gtkdoc_gcomment_unref0 (gcomment);
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		ValadocContentComment* _tmp14_;
		ValadocContentComment* _tmp15_;
		GtkdocHeader* _tmp16_;
		GtkdocHeader* _tmp17_;
		_tmp12_ = valadoc_api_field_get_cname (f);
		_tmp13_ = _tmp12_;
		_tmp14_ = valadoc_api_node_get_documentation ((ValadocApiNode*) f);
		_tmp15_ = _tmp14_;
		_tmp16_ = gtkdoc_generator_add_header (self, _tmp13_, _tmp15_, NULL, (gint) 0, DBL_MAX);
		_tmp17_ = _tmp16_;
		_gtkdoc_header_unref0 (_tmp17_);
		_g_free0 (_tmp13_);
		valadoc_api_node_accept_all_children ((ValadocApiNode*) f, (ValadocApiVisitor*) self, TRUE);
	}
}

static void
gtkdoc_generator_real_visit_constant (ValadocApiVisitor* base,
                                      ValadocApiConstant* c)
{
	GtkdocGenerator * self;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValadocContentComment* _tmp4_;
	ValadocContentComment* _tmp5_;
	GtkdocGComment* _tmp6_;
	GtkdocGComment* _tmp7_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = valadoc_documentation_get_filename ((ValadocDocumentation*) c);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_constant_get_cname (c);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_node_get_documentation ((ValadocApiNode*) c);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtkdoc_generator_add_symbol (self, _tmp1_, _tmp3_, _tmp5_, NULL, NULL, (gint) 0);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	gcomment = _tmp7_;
	valadoc_api_node_accept_all_children ((ValadocApiNode*) c, (ValadocApiVisitor*) self, TRUE);
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) c, gcomment);
	_gtkdoc_gcomment_unref0 (gcomment);
}

static void
gtkdoc_generator_real_visit_delegate (ValadocApiVisitor* base,
                                      ValadocApiDelegate* d)
{
	GtkdocGenerator * self;
	ValaList* old_headers = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValadocApiDelegate* old_delegate = NULL;
	ValadocApiDelegate* _tmp2_;
	ValadocApiDelegate* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValadocApiDelegate* _tmp6_;
	ValadocApiNodeType* _tmp7_;
	ValadocApiNodeType* _tmp8_;
	gint _tmp8__length1;
	ValaList* exceptions = NULL;
	ValadocApiNodeType* _tmp9_;
	ValadocApiNodeType* _tmp10_;
	gint _tmp10__length1;
	ValaList* _tmp11_;
	ValaList* _tmp12_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValadocContentComment* _tmp32_;
	ValadocContentComment* _tmp33_;
	GtkdocGComment* _tmp34_;
	GtkdocGComment* _tmp35_;
	ValadocApiTypeParameter* type_parameter = NULL;
	ValadocApiTypeReference* _tmp36_;
	ValadocApiTypeReference* _tmp37_;
	ValadocApiItem* _tmp38_;
	ValadocApiItem* _tmp39_;
	ValadocApiTypeParameter* _tmp40_;
	ValadocApiTypeParameter* _tmp41_;
	GtkdocGComment* _tmp86_;
	ValaList* _tmp87_;
	ValaList* _tmp88_;
	ValadocApiDelegate* _tmp89_;
	ValadocApiDelegate* _tmp90_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->current_headers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	old_headers = _tmp1_;
	_tmp2_ = self->priv->current_delegate;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_delegate = _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp5_;
	_tmp6_ = _g_object_ref0 (d);
	_g_object_unref0 (self->priv->current_delegate);
	self->priv->current_delegate = _tmp6_;
	_tmp7_ = g_new0 (ValadocApiNodeType, 2);
	_tmp7_[0] = VALADOC_API_NODE_TYPE_FORMAL_PARAMETER;
	_tmp7_[1] = VALADOC_API_NODE_TYPE_TYPE_PARAMETER;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	valadoc_api_node_accept_children ((ValadocApiNode*) d, _tmp8_, (gint) 2, (ValadocApiVisitor*) self, TRUE);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp9_ = g_new0 (ValadocApiNodeType, 2);
	_tmp9_[0] = VALADOC_API_NODE_TYPE_ERROR_DOMAIN;
	_tmp9_[1] = VALADOC_API_NODE_TYPE_CLASS;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) d, _tmp10_, (gint) 2, TRUE);
	_tmp12_ = _tmp11_;
	_tmp10_ = (g_free (_tmp10_), NULL);
	exceptions = _tmp12_;
	{
		ValaList* _ex_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _ex_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _ex_index = 0;
		_tmp13_ = exceptions;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_ex_list = _tmp14_;
		_tmp15_ = _ex_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_ex_size = _tmp17_;
		_ex_index = -1;
		while (TRUE) {
			ValadocApiNode* ex = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValadocApiNode* _tmp20_;
			_ex_index = _ex_index + 1;
			if (!(_ex_index < _ex_size)) {
				break;
			}
			_tmp18_ = _ex_list;
			_tmp19_ = vala_list_get (_tmp18_, _ex_index);
			ex = (ValadocApiNode*) _tmp19_;
			_tmp20_ = ex;
			gtkdoc_generator_visit_thrown_error_domain (self, _tmp20_);
			_g_object_unref0 (ex);
		}
		_vala_iterable_unref0 (_ex_list);
	}
	_tmp21_ = valadoc_api_delegate_get_is_static (d);
	_tmp22_ = _tmp21_;
	if (!_tmp22_) {
		gchar* _tmp23_;
		gchar** _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		GtkdocHeader* _tmp26_;
		GtkdocHeader* _tmp27_;
		_tmp23_ = g_strdup ("closure");
		_tmp24_ = g_new0 (gchar*, 1 + 1);
		_tmp24_[0] = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp25__length1 = 1;
		_tmp26_ = gtkdoc_generator_add_custom_header (self, "user_data", "data to pass to the delegate function", _tmp25_, (gint) 1, DBL_MAX, TRUE);
		_tmp27_ = _tmp26_;
		_gtkdoc_header_unref0 (_tmp27_);
		_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp28_ = valadoc_documentation_get_filename ((ValadocDocumentation*) d);
	_tmp29_ = _tmp28_;
	_tmp30_ = valadoc_api_delegate_get_cname (d);
	_tmp31_ = _tmp30_;
	_tmp32_ = valadoc_api_node_get_documentation ((ValadocApiNode*) d);
	_tmp33_ = _tmp32_;
	_tmp34_ = gtkdoc_generator_add_symbol (self, _tmp29_, _tmp31_, _tmp33_, NULL, NULL, (gint) 0);
	_tmp35_ = _tmp34_;
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	gcomment = _tmp35_;
	_tmp36_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) d);
	_tmp37_ = _tmp36_;
	_tmp38_ = valadoc_api_typereference_get_data_type (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp39_) : NULL);
	type_parameter = _tmp40_;
	_tmp41_ = type_parameter;
	if (_tmp41_ != NULL) {
		ValadocApiTypeParameter* _tmp42_;
		ValadocApiItem* _tmp43_;
		ValadocApiItem* _tmp44_;
		_tmp42_ = type_parameter;
		_tmp43_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp42_);
		_tmp44_ = _tmp43_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALADOC_API_TYPE_CLASS)) {
			gchar* return_type_desc = NULL;
			ValadocApiItem* _tmp45_;
			ValadocApiItem* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValadocApiTypeParameter* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			GtkdocGComment* _tmp56_;
			const gchar* _tmp57_;
			GtkdocGComment* _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp45_ = valadoc_api_item_get_parent ((ValadocApiItem*) d);
			_tmp46_ = _tmp45_;
			_tmp47_ = gtkdoc_get_cname (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = type_parameter;
			_tmp50_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = g_utf8_strdown (_tmp51_, (gssize) -1);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strdup_printf ("A value from type #%s:%s-type.", _tmp48_, _tmp53_);
			_tmp55_ = _tmp54_;
			_g_free0 (_tmp53_);
			_g_free0 (_tmp48_);
			return_type_desc = _tmp55_;
			_tmp56_ = gcomment;
			_tmp57_ = return_type_desc;
			_tmp58_ = gcomment;
			_tmp59_ = _tmp58_->returns;
			_tmp60_ = gtkdoc_generator_combine_inline_docs (self, _tmp57_, _tmp59_);
			_g_free0 (_tmp56_->returns);
			_tmp56_->returns = _tmp60_;
			_g_free0 (return_type_desc);
		} else {
			gboolean _tmp61_ = FALSE;
			ValadocApiTypeParameter* _tmp62_;
			ValadocApiItem* _tmp63_;
			ValadocApiItem* _tmp64_;
			_tmp62_ = type_parameter;
			_tmp63_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp62_);
			_tmp64_ = _tmp63_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiTypeParameter* _tmp65_;
				ValadocApiItem* _tmp66_;
				ValadocApiItem* _tmp67_;
				ValadocApiAttribute* _tmp68_;
				ValadocApiAttribute* _tmp69_;
				_tmp65_ = type_parameter;
				_tmp66_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = valadoc_api_symbol_get_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), "GenericAccessors");
				_tmp69_ = _tmp68_;
				_tmp61_ = _tmp69_ != NULL;
				_g_object_unref0 (_tmp69_);
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				gchar* return_type_desc = NULL;
				ValadocApiItem* _tmp70_;
				ValadocApiItem* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				ValadocApiTypeParameter* _tmp74_;
				const gchar* _tmp75_;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				GtkdocGComment* _tmp81_;
				const gchar* _tmp82_;
				GtkdocGComment* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				_tmp70_ = valadoc_api_item_get_parent ((ValadocApiItem*) d);
				_tmp71_ = _tmp70_;
				_tmp72_ = gtkdoc_get_cname (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = type_parameter;
				_tmp75_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_utf8_strdown (_tmp76_, (gssize) -1);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strdup_printf ("A value from type #_%sIface.get_%s_type().", _tmp73_, _tmp78_);
				_tmp80_ = _tmp79_;
				_g_free0 (_tmp78_);
				_g_free0 (_tmp73_);
				return_type_desc = _tmp80_;
				_tmp81_ = gcomment;
				_tmp82_ = return_type_desc;
				_tmp83_ = gcomment;
				_tmp84_ = _tmp83_->returns;
				_tmp85_ = gtkdoc_generator_combine_inline_docs (self, _tmp82_, _tmp84_);
				_g_free0 (_tmp81_->returns);
				_tmp81_->returns = _tmp85_;
				_g_free0 (return_type_desc);
			}
		}
	}
	_tmp86_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) d, _tmp86_);
	_tmp87_ = old_headers;
	_tmp88_ = _vala_iterable_ref0 (_tmp87_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp88_;
	_tmp89_ = old_delegate;
	_tmp90_ = _g_object_ref0 (_tmp89_);
	_g_object_unref0 (self->priv->current_delegate);
	self->priv->current_delegate = _tmp90_;
	_g_object_unref0 (type_parameter);
	_gtkdoc_gcomment_unref0 (gcomment);
	_vala_iterable_unref0 (exceptions);
	_g_object_unref0 (old_delegate);
	_vala_iterable_unref0 (old_headers);
}

static gpointer
_gtkdoc_dbus_member_ref0 (gpointer self)
{
	return self ? gtkdoc_dbus_member_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gtkdoc_generator_real_visit_signal (ValadocApiVisitor* base,
                                    ValadocApiSignal* sig)
{
	GtkdocGenerator * self;
	ValaList* old_headers = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValadocApiSignal* old_signal = NULL;
	ValadocApiSignal* _tmp2_;
	ValadocApiSignal* _tmp3_;
	GtkdocDBusMember* old_dbus_member = NULL;
	GtkdocDBusMember* _tmp4_;
	GtkdocDBusMember* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValadocApiSignal* _tmp8_;
	gboolean _tmp9_ = FALSE;
	GtkdocDBusInterface* _tmp10_;
	gchar* name = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkdocGComment* gcomment = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValadocContentComment* _tmp26_;
	ValadocContentComment* _tmp27_;
	GtkdocGComment* _tmp28_;
	GtkdocGComment* _tmp29_;
	GtkdocGComment* _tmp30_;
	ValaList* _tmp31_;
	ValadocApiItem* _tmp32_;
	ValadocApiItem* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	ValadocApiItem* _tmp38_;
	ValadocApiItem* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GtkdocHeader* _tmp44_;
	GtkdocHeader* _tmp45_;
	gboolean _tmp46_ = FALSE;
	GtkdocDBusInterface* _tmp47_;
	ValadocApiTypeParameter* type_parameter = NULL;
	ValadocApiTypeReference* _tmp61_;
	ValadocApiTypeReference* _tmp62_;
	ValadocApiItem* _tmp63_;
	ValadocApiItem* _tmp64_;
	ValadocApiTypeParameter* _tmp65_;
	ValadocApiTypeParameter* _tmp66_;
	GtkdocGComment* _tmp113_;
	ValaList* _tmp114_;
	ValaList* _tmp115_;
	ValadocApiSignal* _tmp116_;
	ValadocApiSignal* _tmp117_;
	GtkdocDBusMember* _tmp118_;
	GtkdocDBusMember* _tmp119_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->current_headers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	old_headers = _tmp1_;
	_tmp2_ = self->priv->current_signal;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_signal = _tmp3_;
	_tmp4_ = self->priv->current_dbus_member;
	_tmp5_ = _gtkdoc_dbus_member_ref0 (_tmp4_);
	old_dbus_member = _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp6_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp7_;
	_tmp8_ = _g_object_ref0 (sig);
	_g_object_unref0 (self->priv->current_signal);
	self->priv->current_signal = _tmp8_;
	_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
	self->priv->current_dbus_member = NULL;
	_tmp10_ = self->priv->current_dbus_interface;
	if (_tmp10_ != NULL) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = valadoc_api_signal_get_is_dbus_visible (sig);
		_tmp12_ = _tmp11_;
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		GtkdocDBusMember* _tmp15_;
		_tmp13_ = valadoc_api_signal_get_dbus_name (sig);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtkdoc_dbus_member_new (_tmp14_);
		_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
		self->priv->current_dbus_member = _tmp15_;
		_g_free0 (_tmp14_);
	}
	valadoc_api_node_accept_all_children ((ValadocApiNode*) sig, (ValadocApiVisitor*) self, TRUE);
	_tmp16_ = valadoc_api_signal_get_cname (sig);
	_tmp17_ = _tmp16_;
	_tmp18_ = string_replace (_tmp17_, "_", "-");
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	name = _tmp19_;
	_tmp20_ = valadoc_documentation_get_filename ((ValadocDocumentation*) sig);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->current_cname;
	_tmp23_ = name;
	_tmp24_ = g_strdup_printf ("%s::%s", _tmp22_, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_api_node_get_documentation ((ValadocApiNode*) sig);
	_tmp27_ = _tmp26_;
	_tmp28_ = gtkdoc_generator_add_comment (self, _tmp21_, _tmp25_, _tmp27_);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp21_);
	gcomment = _tmp29_;
	_tmp30_ = gcomment;
	_tmp31_ = _tmp30_->headers;
	_tmp32_ = valadoc_api_item_get_parent ((ValadocApiItem*) sig);
	_tmp33_ = _tmp32_;
	_tmp34_ = valadoc_api_node_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALADOC_API_TYPE_NODE, ValadocApiNode));
	_tmp35_ = _tmp34_;
	_tmp36_ = gtkdoc_to_lower_case (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = valadoc_api_item_get_parent ((ValadocApiItem*) sig);
	_tmp39_ = _tmp38_;
	_tmp40_ = gtkdoc_get_docbook_link (_tmp39_, FALSE, FALSE);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf ("the %s instance that received the signal", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = gtkdoc_header_new (_tmp37_, _tmp43_, 0.1, TRUE);
	_tmp45_ = _tmp44_;
	vala_list_insert (_tmp31_, 0, _tmp45_);
	_gtkdoc_header_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp41_);
	_g_free0 (_tmp37_);
	_tmp47_ = self->priv->current_dbus_interface;
	if (_tmp47_ != NULL) {
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp48_ = valadoc_api_signal_get_is_dbus_visible (sig);
		_tmp49_ = _tmp48_;
		_tmp46_ = _tmp49_;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		GtkdocGComment* dbuscomment = NULL;
		gchar* _tmp50_;
		gchar* _tmp51_;
		ValadocContentComment* _tmp52_;
		ValadocContentComment* _tmp53_;
		GtkdocGComment* _tmp54_;
		GtkdocGComment* _tmp55_;
		GtkdocDBusMember* _tmp56_;
		GtkdocGComment* _tmp57_;
		GtkdocGComment* _tmp58_;
		GtkdocDBusInterface* _tmp59_;
		GtkdocDBusMember* _tmp60_;
		_tmp50_ = valadoc_api_signal_get_dbus_name (sig);
		_tmp51_ = _tmp50_;
		_tmp52_ = valadoc_api_node_get_documentation ((ValadocApiNode*) sig);
		_tmp53_ = _tmp52_;
		_tmp54_ = gtkdoc_generator_create_gcomment (self, _tmp51_, _tmp53_, NULL, (gint) 0, TRUE);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp51_);
		dbuscomment = _tmp55_;
		_tmp56_ = self->priv->current_dbus_member;
		_tmp57_ = dbuscomment;
		_tmp58_ = _gtkdoc_gcomment_ref0 (_tmp57_);
		_gtkdoc_gcomment_unref0 (_tmp56_->comment);
		_tmp56_->comment = _tmp58_;
		_tmp59_ = self->priv->current_dbus_interface;
		_tmp60_ = self->priv->current_dbus_member;
		gtkdoc_dbus_interface_add_signal (_tmp59_, _tmp60_);
		_gtkdoc_gcomment_unref0 (dbuscomment);
	}
	_tmp61_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) sig);
	_tmp62_ = _tmp61_;
	_tmp63_ = valadoc_api_typereference_get_data_type (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp64_) : NULL);
	type_parameter = _tmp65_;
	_tmp66_ = type_parameter;
	if (_tmp66_ != NULL) {
		ValadocApiTypeParameter* _tmp67_;
		ValadocApiItem* _tmp68_;
		ValadocApiItem* _tmp69_;
		_tmp67_ = type_parameter;
		_tmp68_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp67_);
		_tmp69_ = _tmp68_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALADOC_API_TYPE_CLASS)) {
			gchar* return_type_desc = NULL;
			ValadocApiTypeParameter* _tmp70_;
			ValadocApiItem* _tmp71_;
			ValadocApiItem* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			ValadocApiTypeParameter* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			GtkdocGComment* _tmp82_;
			const gchar* _tmp83_;
			GtkdocGComment* _tmp84_;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp70_ = type_parameter;
			_tmp71_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = gtkdoc_get_cname (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = type_parameter;
			_tmp76_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = g_utf8_strdown (_tmp77_, (gssize) -1);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strdup_printf ("A value from type #%s:%s-type.", _tmp74_, _tmp79_);
			_tmp81_ = _tmp80_;
			_g_free0 (_tmp79_);
			_g_free0 (_tmp74_);
			return_type_desc = _tmp81_;
			_tmp82_ = gcomment;
			_tmp83_ = return_type_desc;
			_tmp84_ = gcomment;
			_tmp85_ = _tmp84_->returns;
			_tmp86_ = gtkdoc_generator_combine_inline_docs (self, _tmp83_, _tmp85_);
			_g_free0 (_tmp82_->returns);
			_tmp82_->returns = _tmp86_;
			_g_free0 (return_type_desc);
		} else {
			gboolean _tmp87_ = FALSE;
			ValadocApiTypeParameter* _tmp88_;
			ValadocApiItem* _tmp89_;
			ValadocApiItem* _tmp90_;
			_tmp88_ = type_parameter;
			_tmp89_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp88_);
			_tmp90_ = _tmp89_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiTypeParameter* _tmp91_;
				ValadocApiItem* _tmp92_;
				ValadocApiItem* _tmp93_;
				ValadocApiAttribute* _tmp94_;
				ValadocApiAttribute* _tmp95_;
				_tmp91_ = type_parameter;
				_tmp92_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = valadoc_api_symbol_get_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), "GenericAccessors");
				_tmp95_ = _tmp94_;
				_tmp87_ = _tmp95_ != NULL;
				_g_object_unref0 (_tmp95_);
			} else {
				_tmp87_ = FALSE;
			}
			if (_tmp87_) {
				gchar* return_type_desc = NULL;
				ValadocApiTypeParameter* _tmp96_;
				ValadocApiItem* _tmp97_;
				ValadocApiItem* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				ValadocApiTypeParameter* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				GtkdocGComment* _tmp108_;
				const gchar* _tmp109_;
				GtkdocGComment* _tmp110_;
				const gchar* _tmp111_;
				gchar* _tmp112_;
				_tmp96_ = type_parameter;
				_tmp97_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp96_);
				_tmp98_ = _tmp97_;
				_tmp99_ = gtkdoc_get_cname (_tmp98_);
				_tmp100_ = _tmp99_;
				_tmp101_ = type_parameter;
				_tmp102_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = g_utf8_strdown (_tmp103_, (gssize) -1);
				_tmp105_ = _tmp104_;
				_tmp106_ = g_strdup_printf ("A value from type #_%sIface.get_%s_type().", _tmp100_, _tmp105_);
				_tmp107_ = _tmp106_;
				_g_free0 (_tmp105_);
				_g_free0 (_tmp100_);
				return_type_desc = _tmp107_;
				_tmp108_ = gcomment;
				_tmp109_ = return_type_desc;
				_tmp110_ = gcomment;
				_tmp111_ = _tmp110_->returns;
				_tmp112_ = gtkdoc_generator_combine_inline_docs (self, _tmp109_, _tmp111_);
				_g_free0 (_tmp108_->returns);
				_tmp108_->returns = _tmp112_;
				_g_free0 (return_type_desc);
			}
		}
	}
	_tmp113_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) sig, _tmp113_);
	_tmp114_ = old_headers;
	_tmp115_ = _vala_iterable_ref0 (_tmp114_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp115_;
	_tmp116_ = old_signal;
	_tmp117_ = _g_object_ref0 (_tmp116_);
	_g_object_unref0 (self->priv->current_signal);
	self->priv->current_signal = _tmp117_;
	_tmp118_ = old_dbus_member;
	_tmp119_ = _gtkdoc_dbus_member_ref0 (_tmp118_);
	_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
	self->priv->current_dbus_member = _tmp119_;
	_g_object_unref0 (type_parameter);
	_gtkdoc_gcomment_unref0 (gcomment);
	_g_free0 (name);
	_gtkdoc_dbus_member_unref0 (old_dbus_member);
	_g_object_unref0 (old_signal);
	_vala_iterable_unref0 (old_headers);
}

static void
_vala_array_add20 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add21 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup10 (gchar** self,
                   gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add22 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
_vala_array_dup12 (gchar** self,
                   gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add23 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup13 (gchar** self,
                   gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gtkdoc_generator_real_visit_method (ValadocApiVisitor* base,
                                    ValadocApiMethod* m)
{
	GtkdocGenerator * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gchar** annotations = NULL;
	gchar** _tmp23_;
	gint annotations_length1;
	gint _annotations_size_;
	ValadocApiTypeReference* _tmp24_;
	ValadocApiTypeReference* _tmp25_;
	ValaList* old_headers = NULL;
	ValaList* _tmp36_;
	ValaList* _tmp37_;
	ValadocApiMethod* old_method = NULL;
	ValadocApiMethod* _tmp38_;
	ValadocApiMethod* _tmp39_;
	GtkdocDBusMember* old_dbus_member = NULL;
	GtkdocDBusMember* _tmp40_;
	GtkdocDBusMember* _tmp41_;
	GEqualFunc _tmp42_;
	ValaArrayList* _tmp43_;
	ValadocApiMethod* _tmp44_;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	GtkdocDBusInterface* _tmp47_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_;
	gboolean _tmp57_;
	gboolean _tmp68_;
	gboolean _tmp69_;
	ValaList* type_parameters = NULL;
	ValaList* _tmp107_;
	ValadocApiNodeType* _tmp145_;
	ValadocApiNodeType* _tmp146_;
	gint _tmp146__length1;
	ValaList* exceptions = NULL;
	ValadocApiNodeType* _tmp147_;
	ValadocApiNodeType* _tmp148_;
	gint _tmp148__length1;
	ValaList* _tmp149_;
	ValaList* _tmp150_;
	GtkdocHeader* error_header = NULL;
	GtkdocGComment* gcomment = NULL;
	gboolean _tmp159_;
	gboolean _tmp160_;
	GtkdocGComment* _tmp195_;
	GtkdocHeader* _tmp196_;
	GtkdocHeader* _tmp197_;
	gboolean _tmp198_ = FALSE;
	gboolean _tmp199_ = FALSE;
	GtkdocDBusInterface* _tmp200_;
	ValaList* _tmp233_;
	ValaList* _tmp234_;
	ValadocApiMethod* _tmp235_;
	ValadocApiMethod* _tmp236_;
	GtkdocDBusMember* _tmp237_;
	GtkdocDBusMember* _tmp238_;
	gchar* return_type_desc = NULL;
	ValadocApiTypeParameter* type_parameter = NULL;
	ValadocApiTypeReference* _tmp239_;
	ValadocApiTypeReference* _tmp240_;
	ValadocApiItem* _tmp241_;
	ValadocApiItem* _tmp242_;
	ValadocApiTypeParameter* _tmp243_;
	ValadocApiTypeParameter* _tmp244_;
	gboolean _tmp289_;
	gboolean _tmp290_;
	gboolean _tmp340_ = FALSE;
	gboolean _tmp341_;
	gboolean _tmp342_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (m != NULL);
	_tmp5_ = valadoc_api_method_get_is_constructor (m);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		ValadocApiClass* _tmp7_;
		_tmp7_ = self->priv->current_class;
		_tmp4_ = _tmp7_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValadocApiClass* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->current_class;
		_tmp9_ = valadoc_api_class_get_is_abstract (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = valadoc_api_method_get_is_override (m);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp13_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) m);
		_tmp14_ = _tmp13_;
		_tmp1_ = _tmp14_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp17_ = valadoc_api_method_get_is_abstract (m);
		_tmp18_ = _tmp17_;
		if (!_tmp18_) {
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp19_ = valadoc_api_method_get_is_virtual (m);
			_tmp20_ = _tmp19_;
			_tmp16_ = !_tmp20_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			ValadocApiMethod* _tmp21_;
			ValadocApiMethod* _tmp22_;
			_tmp21_ = valadoc_api_method_get_base_method (m);
			_tmp22_ = _tmp21_;
			_tmp15_ = _tmp22_ != NULL;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp0_ = _tmp15_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp23_ = g_new0 (gchar*, 0 + 1);
	annotations = _tmp23_;
	annotations_length1 = 0;
	_annotations_size_ = annotations_length1;
	_tmp24_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValadocApiTypeReference* _tmp26_;
		ValadocApiTypeReference* _tmp27_;
		ValadocApiItem* _tmp28_;
		ValadocApiItem* _tmp29_;
		ValadocApiTypeReference* _tmp31_;
		ValadocApiTypeReference* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp26_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
		_tmp27_ = _tmp26_;
		_tmp28_ = valadoc_api_typereference_get_data_type (_tmp27_);
		_tmp29_ = _tmp28_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALADOC_API_TYPE_ARRAY)) {
			gchar* _tmp30_;
			_tmp30_ = g_strdup ("array length=result_length1");
			_vala_array_add20 (&annotations, &annotations_length1, &_annotations_size_, _tmp30_);
		}
		_tmp31_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
		_tmp32_ = _tmp31_;
		_tmp33_ = valadoc_api_typereference_get_is_unowned (_tmp32_);
		_tmp34_ = _tmp33_;
		if (_tmp34_) {
			gchar* _tmp35_;
			_tmp35_ = g_strdup ("transfer none");
			_vala_array_add21 (&annotations, &annotations_length1, &_annotations_size_, _tmp35_);
		}
	}
	_tmp36_ = self->priv->current_headers;
	_tmp37_ = _vala_iterable_ref0 (_tmp36_);
	old_headers = _tmp37_;
	_tmp38_ = self->priv->current_method;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	old_method = _tmp39_;
	_tmp40_ = self->priv->current_dbus_member;
	_tmp41_ = _gtkdoc_dbus_member_ref0 (_tmp40_);
	old_dbus_member = _tmp41_;
	_tmp42_ = g_direct_equal;
	_tmp43_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp42_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = (ValaList*) _tmp43_;
	_tmp44_ = _g_object_ref0 (m);
	_g_object_unref0 (self->priv->current_method);
	self->priv->current_method = _tmp44_;
	_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
	self->priv->current_dbus_member = NULL;
	_tmp47_ = self->priv->current_dbus_interface;
	if (_tmp47_ != NULL) {
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp48_ = valadoc_api_method_get_is_dbus_visible (m);
		_tmp49_ = _tmp48_;
		_tmp46_ = _tmp49_;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp50_ = valadoc_api_method_get_is_constructor (m);
		_tmp51_ = _tmp50_;
		_tmp45_ = !_tmp51_;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		gchar* _tmp52_;
		gchar* _tmp53_;
		GtkdocDBusMember* _tmp54_;
		_tmp52_ = valadoc_api_method_get_dbus_name (m);
		_tmp53_ = _tmp52_;
		_tmp54_ = gtkdoc_dbus_member_new (_tmp53_);
		_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
		self->priv->current_dbus_member = _tmp54_;
		_g_free0 (_tmp53_);
	}
	_tmp56_ = valadoc_api_method_get_is_static (m);
	_tmp57_ = _tmp56_;
	if (!_tmp57_) {
		gboolean _tmp58_;
		gboolean _tmp59_;
		_tmp58_ = valadoc_api_method_get_is_constructor (m);
		_tmp59_ = _tmp58_;
		_tmp55_ = !_tmp59_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValadocApiItem* _tmp60_;
		ValadocApiItem* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		GtkdocHeader* _tmp66_;
		GtkdocHeader* _tmp67_;
		_tmp60_ = valadoc_api_item_get_parent ((ValadocApiItem*) m);
		_tmp61_ = _tmp60_;
		_tmp62_ = gtkdoc_get_docbook_link (_tmp61_, FALSE, FALSE);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strdup_printf ("the %s instance", _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = gtkdoc_generator_add_custom_header (self, "self", _tmp65_, NULL, (gint) 0, 0.1, TRUE);
		_tmp67_ = _tmp66_;
		_gtkdoc_header_unref0 (_tmp67_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp63_);
	}
	_tmp68_ = valadoc_api_method_get_is_constructor (m);
	_tmp69_ = _tmp68_;
	if (_tmp69_) {
		ValaList* type_parameters = NULL;
		ValadocApiItem* _tmp70_;
		ValadocApiItem* _tmp71_;
		ValaList* _tmp72_;
		_tmp70_ = valadoc_api_item_get_parent ((ValadocApiItem*) m);
		_tmp71_ = _tmp70_;
		_tmp72_ = valadoc_api_node_get_children_by_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALADOC_API_TYPE_NODE, ValadocApiNode), VALADOC_API_NODE_TYPE_TYPE_PARAMETER, FALSE);
		type_parameters = _tmp72_;
		{
			ValaList* __type_list = NULL;
			ValaList* _tmp73_;
			ValaList* _tmp74_;
			gint __type_size = 0;
			ValaList* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gint __type_index = 0;
			_tmp73_ = type_parameters;
			_tmp74_ = _vala_iterable_ref0 (_tmp73_);
			__type_list = _tmp74_;
			_tmp75_ = __type_list;
			_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
			_tmp77_ = _tmp76_;
			__type_size = _tmp77_;
			__type_index = -1;
			while (TRUE) {
				ValadocApiNode* _type = NULL;
				ValaList* _tmp78_;
				gpointer _tmp79_;
				ValadocApiTypeParameter* type = NULL;
				ValadocApiNode* _tmp80_;
				ValadocApiTypeParameter* _tmp81_;
				gchar* type_name_down = NULL;
				ValadocApiTypeParameter* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				const gchar* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				GtkdocHeader* _tmp89_;
				GtkdocHeader* _tmp90_;
				const gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				const gchar* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				GtkdocHeader* _tmp97_;
				GtkdocHeader* _tmp98_;
				const gchar* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				const gchar* _tmp102_;
				gchar* _tmp103_;
				gchar* _tmp104_;
				GtkdocHeader* _tmp105_;
				GtkdocHeader* _tmp106_;
				__type_index = __type_index + 1;
				if (!(__type_index < __type_size)) {
					break;
				}
				_tmp78_ = __type_list;
				_tmp79_ = vala_list_get (_tmp78_, __type_index);
				_type = (ValadocApiNode*) _tmp79_;
				_tmp80_ = _type;
				_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp80_) : NULL);
				type = _tmp81_;
				_tmp82_ = type;
				_tmp83_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = g_utf8_strdown (_tmp84_, (gssize) -1);
				type_name_down = _tmp85_;
				_tmp86_ = type_name_down;
				_tmp87_ = g_strconcat (_tmp86_, "_type", NULL);
				_tmp88_ = _tmp87_;
				_tmp89_ = gtkdoc_generator_add_custom_header (self, _tmp88_, "A #GType", NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp90_ = _tmp89_;
				_gtkdoc_header_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
				_tmp91_ = type_name_down;
				_tmp92_ = g_strconcat (_tmp91_, "_dup_func", NULL);
				_tmp93_ = _tmp92_;
				_tmp94_ = type_name_down;
				_tmp95_ = g_strdup_printf ("A dup function for @%s_type", _tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = gtkdoc_generator_add_custom_header (self, _tmp93_, _tmp96_, NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp98_ = _tmp97_;
				_gtkdoc_header_unref0 (_tmp98_);
				_g_free0 (_tmp96_);
				_g_free0 (_tmp93_);
				_tmp99_ = type_name_down;
				_tmp100_ = g_strconcat (_tmp99_, "_destroy_func", NULL);
				_tmp101_ = _tmp100_;
				_tmp102_ = type_name_down;
				_tmp103_ = g_strdup_printf ("A destroy function for @%s_type", _tmp102_);
				_tmp104_ = _tmp103_;
				_tmp105_ = gtkdoc_generator_add_custom_header (self, _tmp101_, _tmp104_, NULL, (gint) 0, DBL_MAX, TRUE);
				_tmp106_ = _tmp105_;
				_gtkdoc_header_unref0 (_tmp106_);
				_g_free0 (_tmp104_);
				_g_free0 (_tmp101_);
				_g_free0 (type_name_down);
				_g_object_unref0 (type);
				_g_object_unref0 (_type);
			}
			_vala_iterable_unref0 (__type_list);
		}
		_vala_iterable_unref0 (type_parameters);
	}
	_tmp107_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) m, VALADOC_API_NODE_TYPE_TYPE_PARAMETER, FALSE);
	type_parameters = _tmp107_;
	{
		ValaList* __type_list = NULL;
		ValaList* _tmp108_;
		ValaList* _tmp109_;
		gint __type_size = 0;
		ValaList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint __type_index = 0;
		_tmp108_ = type_parameters;
		_tmp109_ = _vala_iterable_ref0 (_tmp108_);
		__type_list = _tmp109_;
		_tmp110_ = __type_list;
		_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		__type_size = _tmp112_;
		__type_index = -1;
		while (TRUE) {
			ValadocApiNode* _type = NULL;
			ValaList* _tmp113_;
			gpointer _tmp114_;
			ValadocApiTypeParameter* type = NULL;
			ValadocApiNode* _tmp115_;
			ValadocApiTypeParameter* _tmp116_;
			gchar* type_name_down = NULL;
			ValadocApiTypeParameter* _tmp117_;
			const gchar* _tmp118_;
			const gchar* _tmp119_;
			gchar* _tmp120_;
			const gchar* _tmp121_;
			gchar* _tmp122_;
			gchar* _tmp123_;
			const gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			GtkdocHeader* _tmp127_;
			GtkdocHeader* _tmp128_;
			const gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			const gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			GtkdocHeader* _tmp135_;
			GtkdocHeader* _tmp136_;
			const gchar* _tmp137_;
			gchar* _tmp138_;
			gchar* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			GtkdocHeader* _tmp143_;
			GtkdocHeader* _tmp144_;
			__type_index = __type_index + 1;
			if (!(__type_index < __type_size)) {
				break;
			}
			_tmp113_ = __type_list;
			_tmp114_ = vala_list_get (_tmp113_, __type_index);
			_type = (ValadocApiNode*) _tmp114_;
			_tmp115_ = _type;
			_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp115_) : NULL);
			type = _tmp116_;
			_tmp117_ = type;
			_tmp118_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp117_);
			_tmp119_ = _tmp118_;
			_tmp120_ = g_utf8_strdown (_tmp119_, (gssize) -1);
			type_name_down = _tmp120_;
			_tmp121_ = type_name_down;
			_tmp122_ = g_strconcat (_tmp121_, "_type", NULL);
			_tmp123_ = _tmp122_;
			_tmp124_ = type_name_down;
			_tmp125_ = g_strdup_printf ("The #GType for @%s", _tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = gtkdoc_generator_add_custom_header (self, _tmp123_, _tmp126_, NULL, (gint) 0, 0.2, TRUE);
			_tmp128_ = _tmp127_;
			_gtkdoc_header_unref0 (_tmp128_);
			_g_free0 (_tmp126_);
			_g_free0 (_tmp123_);
			_tmp129_ = type_name_down;
			_tmp130_ = g_strconcat (_tmp129_, "_dup_func", NULL);
			_tmp131_ = _tmp130_;
			_tmp132_ = type_name_down;
			_tmp133_ = g_strdup_printf ("A dup function for @%s_type", _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = gtkdoc_generator_add_custom_header (self, _tmp131_, _tmp134_, NULL, (gint) 0, 0.3, TRUE);
			_tmp136_ = _tmp135_;
			_gtkdoc_header_unref0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (_tmp131_);
			_tmp137_ = type_name_down;
			_tmp138_ = g_strconcat (_tmp137_, "_destroy_func", NULL);
			_tmp139_ = _tmp138_;
			_tmp140_ = type_name_down;
			_tmp141_ = g_strdup_printf ("A destroy function for @%s_type", _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = gtkdoc_generator_add_custom_header (self, _tmp139_, _tmp142_, NULL, (gint) 0, 0.4, TRUE);
			_tmp144_ = _tmp143_;
			_gtkdoc_header_unref0 (_tmp144_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp139_);
			_g_free0 (type_name_down);
			_g_object_unref0 (type);
			_g_object_unref0 (_type);
		}
		_vala_iterable_unref0 (__type_list);
	}
	_tmp145_ = g_new0 (ValadocApiNodeType, 2);
	_tmp145_[0] = VALADOC_API_NODE_TYPE_FORMAL_PARAMETER;
	_tmp145_[1] = VALADOC_API_NODE_TYPE_TYPE_PARAMETER;
	_tmp146_ = _tmp145_;
	_tmp146__length1 = 2;
	valadoc_api_node_accept_children ((ValadocApiNode*) m, _tmp146_, (gint) 2, (ValadocApiVisitor*) self, TRUE);
	_tmp146_ = (g_free (_tmp146_), NULL);
	_tmp147_ = g_new0 (ValadocApiNodeType, 2);
	_tmp147_[0] = VALADOC_API_NODE_TYPE_ERROR_DOMAIN;
	_tmp147_[1] = VALADOC_API_NODE_TYPE_CLASS;
	_tmp148_ = _tmp147_;
	_tmp148__length1 = 2;
	_tmp149_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) m, _tmp148_, (gint) 2, TRUE);
	_tmp150_ = _tmp149_;
	_tmp148_ = (g_free (_tmp148_), NULL);
	exceptions = _tmp150_;
	{
		ValaList* _ex_list = NULL;
		ValaList* _tmp151_;
		ValaList* _tmp152_;
		gint _ex_size = 0;
		ValaList* _tmp153_;
		gint _tmp154_;
		gint _tmp155_;
		gint _ex_index = 0;
		_tmp151_ = exceptions;
		_tmp152_ = _vala_iterable_ref0 (_tmp151_);
		_ex_list = _tmp152_;
		_tmp153_ = _ex_list;
		_tmp154_ = vala_collection_get_size ((ValaCollection*) _tmp153_);
		_tmp155_ = _tmp154_;
		_ex_size = _tmp155_;
		_ex_index = -1;
		while (TRUE) {
			ValadocApiNode* ex = NULL;
			ValaList* _tmp156_;
			gpointer _tmp157_;
			ValadocApiNode* _tmp158_;
			_ex_index = _ex_index + 1;
			if (!(_ex_index < _ex_size)) {
				break;
			}
			_tmp156_ = _ex_list;
			_tmp157_ = vala_list_get (_tmp156_, _ex_index);
			ex = (ValadocApiNode*) _tmp157_;
			_tmp158_ = ex;
			gtkdoc_generator_visit_thrown_error_domain (self, _tmp158_);
			_g_object_unref0 (ex);
		}
		_vala_iterable_unref0 (_ex_list);
	}
	error_header = NULL;
	gcomment = NULL;
	_tmp159_ = valadoc_api_method_get_is_yields (m);
	_tmp160_ = _tmp159_;
	if (_tmp160_) {
		gchar* _tmp161_;
		gchar** _tmp162_;
		gchar** _tmp163_;
		gint _tmp163__length1;
		GtkdocHeader* _tmp164_;
		GtkdocHeader* _tmp165_;
		gchar* _tmp166_;
		gchar** _tmp167_;
		gchar** _tmp168_;
		gint _tmp168__length1;
		GtkdocHeader* _tmp169_;
		GtkdocHeader* _tmp170_;
		GtkdocHeader* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gchar* _tmp174_;
		gchar* _tmp175_;
		ValadocContentComment* _tmp176_;
		ValadocContentComment* _tmp177_;
		GtkdocGComment* _tmp178_;
		GtkdocGComment* _tmp179_;
		gchar** see_also = NULL;
		GtkdocGComment* _tmp180_;
		gchar** _tmp181_;
		gint _tmp181__length1;
		gchar** _tmp182_;
		gint _tmp182__length1;
		gint see_also_length1;
		gint _see_also_size_;
		gchar* _tmp183_;
		GtkdocGComment* _tmp184_;
		gchar** _tmp185_;
		gint _tmp185__length1;
		gchar** _tmp186_;
		gint _tmp186__length1;
		_tmp161_ = g_strdup ("scope async");
		_tmp162_ = g_new0 (gchar*, 1 + 1);
		_tmp162_[0] = _tmp161_;
		_tmp163_ = _tmp162_;
		_tmp163__length1 = 1;
		_tmp164_ = gtkdoc_generator_add_custom_header (self, "_callback_", "callback to call when the request is satisfied", _tmp163_, (gint) 1, DBL_MAX, TRUE);
		_tmp165_ = _tmp164_;
		_gtkdoc_header_unref0 (_tmp165_);
		_tmp163_ = (_vala_array_free (_tmp163_, _tmp163__length1, (GDestroyNotify) g_free), NULL);
		_tmp166_ = g_strdup ("closure");
		_tmp167_ = g_new0 (gchar*, 1 + 1);
		_tmp167_[0] = _tmp166_;
		_tmp168_ = _tmp167_;
		_tmp168__length1 = 1;
		_tmp169_ = gtkdoc_generator_add_custom_header (self, "_user_data_", "the data to pass to @_callback_ function", _tmp168_, (gint) 1, DBL_MAX, TRUE);
		_tmp170_ = _tmp169_;
		_gtkdoc_header_unref0 (_tmp170_);
		_tmp168_ = (_vala_array_free (_tmp168_, _tmp168__length1, (GDestroyNotify) g_free), NULL);
		_tmp171_ = gtkdoc_generator_remove_custom_header (self, "error");
		_gtkdoc_header_unref0 (error_header);
		error_header = _tmp171_;
		_tmp172_ = valadoc_documentation_get_filename ((ValadocDocumentation*) m);
		_tmp173_ = _tmp172_;
		_tmp174_ = valadoc_api_method_get_cname (m);
		_tmp175_ = _tmp174_;
		_tmp176_ = valadoc_api_node_get_documentation ((ValadocApiNode*) m);
		_tmp177_ = _tmp176_;
		_tmp178_ = gtkdoc_generator_add_symbol (self, _tmp173_, _tmp175_, _tmp177_, NULL, NULL, (gint) 0);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp178_;
		_g_free0 (_tmp175_);
		_g_free0 (_tmp173_);
		_tmp179_ = gcomment;
		_g_free0 (_tmp179_->returns);
		_tmp179_->returns = NULL;
		_tmp180_ = gcomment;
		_tmp181_ = _tmp180_->see_also;
		_tmp181__length1 = _tmp180_->see_also_length1;
		_tmp182_ = (_tmp181_ != NULL) ? _vala_array_dup10 (_tmp181_, _tmp181__length1) : ((gpointer) _tmp181_);
		_tmp182__length1 = _tmp181__length1;
		see_also = _tmp182_;
		see_also_length1 = _tmp182__length1;
		_see_also_size_ = see_also_length1;
		_tmp183_ = gtkdoc_get_docbook_link ((ValadocApiItem*) m, FALSE, TRUE);
		_vala_array_add22 (&see_also, &see_also_length1, &_see_also_size_, _tmp183_);
		_tmp184_ = gcomment;
		_tmp185_ = see_also;
		_tmp185__length1 = see_also_length1;
		_tmp186_ = (_tmp185_ != NULL) ? _vala_array_dup11 (_tmp185_, _tmp185__length1) : ((gpointer) _tmp185_);
		_tmp186__length1 = _tmp185__length1;
		_tmp184_->see_also = (_vala_array_free (_tmp184_->see_also, _tmp184_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp184_->see_also = _tmp186_;
		_tmp184_->see_also_length1 = _tmp186__length1;
		see_also = (_vala_array_free (see_also, see_also_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar* _tmp187_;
		gchar* _tmp188_;
		gchar* _tmp189_;
		gchar* _tmp190_;
		ValadocContentComment* _tmp191_;
		ValadocContentComment* _tmp192_;
		gchar** _tmp193_;
		gint _tmp193__length1;
		GtkdocGComment* _tmp194_;
		_tmp187_ = valadoc_documentation_get_filename ((ValadocDocumentation*) m);
		_tmp188_ = _tmp187_;
		_tmp189_ = valadoc_api_method_get_cname (m);
		_tmp190_ = _tmp189_;
		_tmp191_ = valadoc_api_node_get_documentation ((ValadocApiNode*) m);
		_tmp192_ = _tmp191_;
		_tmp193_ = annotations;
		_tmp193__length1 = annotations_length1;
		_tmp194_ = gtkdoc_generator_add_symbol (self, _tmp188_, _tmp190_, _tmp192_, NULL, _tmp193_, (gint) _tmp193__length1);
		_gtkdoc_gcomment_unref0 (gcomment);
		gcomment = _tmp194_;
		_g_free0 (_tmp190_);
		_g_free0 (_tmp188_);
	}
	_tmp195_ = gcomment;
	gtkdoc_generator_process_attributes (self, (ValadocApiSymbol*) m, _tmp195_);
	_tmp196_ = gtkdoc_generator_remove_custom_header (self, "self");
	_tmp197_ = _tmp196_;
	_gtkdoc_header_unref0 (_tmp197_);
	_tmp200_ = self->priv->current_dbus_interface;
	if (_tmp200_ != NULL) {
		gboolean _tmp201_;
		gboolean _tmp202_;
		_tmp201_ = valadoc_api_method_get_is_dbus_visible (m);
		_tmp202_ = _tmp201_;
		_tmp199_ = _tmp202_;
	} else {
		_tmp199_ = FALSE;
	}
	if (_tmp199_) {
		gboolean _tmp203_;
		gboolean _tmp204_;
		_tmp203_ = valadoc_api_method_get_is_constructor (m);
		_tmp204_ = _tmp203_;
		_tmp198_ = !_tmp204_;
	} else {
		_tmp198_ = FALSE;
	}
	if (_tmp198_) {
		gboolean _tmp205_ = FALSE;
		ValadocApiTypeReference* _tmp206_;
		ValadocApiTypeReference* _tmp207_;
		GtkdocGComment* dbus_gcomment = NULL;
		gchar* _tmp222_;
		gchar* _tmp223_;
		ValadocContentComment* _tmp224_;
		ValadocContentComment* _tmp225_;
		GtkdocGComment* _tmp226_;
		GtkdocGComment* _tmp227_;
		GtkdocDBusMember* _tmp228_;
		GtkdocGComment* _tmp229_;
		GtkdocGComment* _tmp230_;
		GtkdocDBusInterface* _tmp231_;
		GtkdocDBusMember* _tmp232_;
		_tmp206_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
		_tmp207_ = _tmp206_;
		if (_tmp207_ != NULL) {
			ValadocApiTypeReference* _tmp208_;
			ValadocApiTypeReference* _tmp209_;
			ValadocApiItem* _tmp210_;
			ValadocApiItem* _tmp211_;
			_tmp208_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
			_tmp209_ = _tmp208_;
			_tmp210_ = valadoc_api_typereference_get_data_type (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp205_ = _tmp211_ != NULL;
		} else {
			_tmp205_ = FALSE;
		}
		if (_tmp205_) {
			GtkdocDBusParameter* dresult = NULL;
			gchar* _tmp212_;
			gchar* _tmp213_;
			ValadocApiTypeReference* _tmp214_;
			ValadocApiTypeReference* _tmp215_;
			gchar* _tmp216_;
			gchar* _tmp217_;
			GtkdocDBusParameter* _tmp218_;
			GtkdocDBusParameter* _tmp219_;
			GtkdocDBusMember* _tmp220_;
			GtkdocDBusParameter* _tmp221_;
			_tmp212_ = valadoc_api_method_get_dbus_result_name (m);
			_tmp213_ = _tmp212_;
			_tmp214_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
			_tmp215_ = _tmp214_;
			_tmp216_ = valadoc_api_typereference_get_dbus_type_signature (_tmp215_);
			_tmp217_ = _tmp216_;
			_tmp218_ = gtkdoc_dbus_parameter_new (_tmp213_, _tmp217_, GTKDOC_DBUS_PARAMETER_DIRECTION_OUT);
			_tmp219_ = _tmp218_;
			_g_free0 (_tmp217_);
			_g_free0 (_tmp213_);
			dresult = _tmp219_;
			_tmp220_ = self->priv->current_dbus_member;
			_tmp221_ = dresult;
			gtkdoc_dbus_member_add_parameter (_tmp220_, _tmp221_);
			_gtkdoc_dbus_parameter_unref0 (dresult);
		}
		_tmp222_ = valadoc_api_method_get_dbus_name (m);
		_tmp223_ = _tmp222_;
		_tmp224_ = valadoc_api_node_get_documentation ((ValadocApiNode*) m);
		_tmp225_ = _tmp224_;
		_tmp226_ = gtkdoc_generator_create_gcomment (self, _tmp223_, _tmp225_, NULL, (gint) 0, TRUE);
		_tmp227_ = _tmp226_;
		_g_free0 (_tmp223_);
		dbus_gcomment = _tmp227_;
		_tmp228_ = self->priv->current_dbus_member;
		_tmp229_ = dbus_gcomment;
		_tmp230_ = _gtkdoc_gcomment_ref0 (_tmp229_);
		_gtkdoc_gcomment_unref0 (_tmp228_->comment);
		_tmp228_->comment = _tmp230_;
		_tmp231_ = self->priv->current_dbus_interface;
		_tmp232_ = self->priv->current_dbus_member;
		gtkdoc_dbus_interface_add_method (_tmp231_, _tmp232_);
		_gtkdoc_gcomment_unref0 (dbus_gcomment);
	}
	_tmp233_ = old_headers;
	_tmp234_ = _vala_iterable_ref0 (_tmp233_);
	_vala_iterable_unref0 (self->priv->current_headers);
	self->priv->current_headers = _tmp234_;
	_tmp235_ = old_method;
	_tmp236_ = _g_object_ref0 (_tmp235_);
	_g_object_unref0 (self->priv->current_method);
	self->priv->current_method = _tmp236_;
	_tmp237_ = old_dbus_member;
	_tmp238_ = _gtkdoc_dbus_member_ref0 (_tmp237_);
	_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
	self->priv->current_dbus_member = _tmp238_;
	return_type_desc = NULL;
	_tmp239_ = valadoc_api_callable_get_return_type ((ValadocApiCallable*) m);
	_tmp240_ = _tmp239_;
	_tmp241_ = valadoc_api_typereference_get_data_type (_tmp240_);
	_tmp242_ = _tmp241_;
	_tmp243_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp242_) : NULL);
	type_parameter = _tmp243_;
	_tmp244_ = type_parameter;
	if (_tmp244_ != NULL) {
		ValadocApiTypeParameter* _tmp245_;
		ValadocApiItem* _tmp246_;
		ValadocApiItem* _tmp247_;
		_tmp245_ = type_parameter;
		_tmp246_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp245_);
		_tmp247_ = _tmp246_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALADOC_API_TYPE_CLASS)) {
			ValadocApiItem* _tmp248_;
			ValadocApiItem* _tmp249_;
			gchar* _tmp250_;
			gchar* _tmp251_;
			ValadocApiTypeParameter* _tmp252_;
			const gchar* _tmp253_;
			const gchar* _tmp254_;
			gchar* _tmp255_;
			gchar* _tmp256_;
			gchar* _tmp257_;
			_tmp248_ = valadoc_api_item_get_parent ((ValadocApiItem*) m);
			_tmp249_ = _tmp248_;
			_tmp250_ = gtkdoc_get_cname (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp252_ = type_parameter;
			_tmp253_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp252_);
			_tmp254_ = _tmp253_;
			_tmp255_ = g_utf8_strdown (_tmp254_, (gssize) -1);
			_tmp256_ = _tmp255_;
			_tmp257_ = g_strdup_printf ("A value from type #%s:%s-type.", _tmp251_, _tmp256_);
			_g_free0 (return_type_desc);
			return_type_desc = _tmp257_;
			_g_free0 (_tmp256_);
			_g_free0 (_tmp251_);
		} else {
			gboolean _tmp258_ = FALSE;
			ValadocApiTypeParameter* _tmp259_;
			ValadocApiItem* _tmp260_;
			ValadocApiItem* _tmp261_;
			_tmp259_ = type_parameter;
			_tmp260_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp259_);
			_tmp261_ = _tmp260_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiTypeParameter* _tmp262_;
				ValadocApiItem* _tmp263_;
				ValadocApiItem* _tmp264_;
				ValadocApiAttribute* _tmp265_;
				ValadocApiAttribute* _tmp266_;
				_tmp262_ = type_parameter;
				_tmp263_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = valadoc_api_symbol_get_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp264_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), "GenericAccessors");
				_tmp266_ = _tmp265_;
				_tmp258_ = _tmp266_ != NULL;
				_g_object_unref0 (_tmp266_);
			} else {
				_tmp258_ = FALSE;
			}
			if (_tmp258_) {
				ValadocApiItem* _tmp267_;
				ValadocApiItem* _tmp268_;
				gchar* _tmp269_;
				gchar* _tmp270_;
				ValadocApiTypeParameter* _tmp271_;
				const gchar* _tmp272_;
				const gchar* _tmp273_;
				gchar* _tmp274_;
				gchar* _tmp275_;
				gchar* _tmp276_;
				_tmp267_ = valadoc_api_item_get_parent ((ValadocApiItem*) m);
				_tmp268_ = _tmp267_;
				_tmp269_ = gtkdoc_get_cname (_tmp268_);
				_tmp270_ = _tmp269_;
				_tmp271_ = type_parameter;
				_tmp272_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp271_);
				_tmp273_ = _tmp272_;
				_tmp274_ = g_utf8_strdown (_tmp273_, (gssize) -1);
				_tmp275_ = _tmp274_;
				_tmp276_ = g_strdup_printf ("A value from type #_%sIface.get_%s_type().", _tmp270_, _tmp275_);
				_g_free0 (return_type_desc);
				return_type_desc = _tmp276_;
				_g_free0 (_tmp275_);
				_g_free0 (_tmp270_);
			} else {
				ValadocApiTypeParameter* _tmp277_;
				ValadocApiItem* _tmp278_;
				ValadocApiItem* _tmp279_;
				_tmp277_ = type_parameter;
				_tmp278_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp277_);
				_tmp279_ = _tmp278_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp279_, VALADOC_API_TYPE_STRUCT)) {
				} else {
					ValadocApiTypeParameter* _tmp280_;
					ValadocApiItem* _tmp281_;
					ValadocApiItem* _tmp282_;
					_tmp280_ = type_parameter;
					_tmp281_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp280_);
					_tmp282_ = _tmp281_;
					if (_tmp282_ == G_TYPE_CHECK_INSTANCE_CAST (m, VALADOC_API_TYPE_ITEM, ValadocApiItem)) {
						ValadocApiTypeParameter* _tmp283_;
						const gchar* _tmp284_;
						const gchar* _tmp285_;
						gchar* _tmp286_;
						gchar* _tmp287_;
						gchar* _tmp288_;
						_tmp283_ = type_parameter;
						_tmp284_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = g_utf8_strdown (_tmp285_, (gssize) -1);
						_tmp287_ = _tmp286_;
						_tmp288_ = g_strdup_printf ("value from type @%s_type.", _tmp287_);
						_g_free0 (return_type_desc);
						return_type_desc = _tmp288_;
						_g_free0 (_tmp287_);
					}
				}
			}
		}
	}
	_tmp289_ = valadoc_api_method_get_is_yields (m);
	_tmp290_ = _tmp289_;
	if (_tmp290_) {
		GtkdocGComment* finish_gcomment = NULL;
		gchar* _tmp291_;
		gchar* _tmp292_;
		gchar* _tmp293_;
		gchar* _tmp294_;
		ValadocContentComment* _tmp295_;
		ValadocContentComment* _tmp296_;
		GtkdocGComment* _tmp297_;
		GtkdocGComment* _tmp298_;
		GtkdocGComment* _tmp299_;
		ValaList* _tmp300_;
		gboolean _tmp301_;
		gboolean _tmp302_;
		GtkdocGComment* _tmp313_;
		ValaList* _tmp314_;
		GtkdocHeader* _tmp315_;
		GtkdocHeader* _tmp316_;
		GtkdocHeader* _tmp317_;
		gchar** see_also = NULL;
		GtkdocGComment* _tmp321_;
		gchar** _tmp322_;
		gint _tmp322__length1;
		gchar** _tmp323_;
		gint _tmp323__length1;
		gint see_also_length1;
		gint _see_also_size_;
		gchar* _tmp324_;
		GtkdocGComment* _tmp325_;
		gchar** _tmp326_;
		gint _tmp326__length1;
		gchar** _tmp327_;
		gint _tmp327__length1;
		const gchar* _tmp328_;
		_tmp291_ = valadoc_documentation_get_filename ((ValadocDocumentation*) m);
		_tmp292_ = _tmp291_;
		_tmp293_ = valadoc_api_method_get_finish_function_cname (m);
		_tmp294_ = _tmp293_;
		_tmp295_ = valadoc_api_node_get_documentation ((ValadocApiNode*) m);
		_tmp296_ = _tmp295_;
		_tmp297_ = gtkdoc_generator_add_symbol (self, _tmp292_, _tmp294_, _tmp296_, NULL, NULL, (gint) 0);
		_tmp298_ = _tmp297_;
		_g_free0 (_tmp294_);
		_g_free0 (_tmp292_);
		finish_gcomment = _tmp298_;
		_tmp299_ = finish_gcomment;
		_tmp300_ = _tmp299_->headers;
		vala_collection_clear ((ValaCollection*) _tmp300_);
		_tmp301_ = valadoc_api_method_get_is_static (m);
		_tmp302_ = _tmp301_;
		if (!_tmp302_) {
			GtkdocGComment* _tmp303_;
			ValaList* _tmp304_;
			ValadocApiItem* _tmp305_;
			ValadocApiItem* _tmp306_;
			gchar* _tmp307_;
			gchar* _tmp308_;
			gchar* _tmp309_;
			gchar* _tmp310_;
			GtkdocHeader* _tmp311_;
			GtkdocHeader* _tmp312_;
			_tmp303_ = finish_gcomment;
			_tmp304_ = _tmp303_->headers;
			_tmp305_ = valadoc_api_item_get_parent ((ValadocApiItem*) m);
			_tmp306_ = _tmp305_;
			_tmp307_ = gtkdoc_get_docbook_link (_tmp306_, FALSE, FALSE);
			_tmp308_ = _tmp307_;
			_tmp309_ = g_strdup_printf ("the %s instance", _tmp308_);
			_tmp310_ = _tmp309_;
			_tmp311_ = gtkdoc_header_new ("self", _tmp310_, DBL_MAX, TRUE);
			_tmp312_ = _tmp311_;
			vala_collection_add ((ValaCollection*) _tmp304_, _tmp312_);
			_gtkdoc_header_unref0 (_tmp312_);
			_g_free0 (_tmp310_);
			_g_free0 (_tmp308_);
		}
		_tmp313_ = finish_gcomment;
		_tmp314_ = _tmp313_->headers;
		_tmp315_ = gtkdoc_header_new ("_res_", "a <link linkend=\"GAsyncResult\"><type>GAsyncResult</type></link>", DBL_MAX, TRUE);
		_tmp316_ = _tmp315_;
		vala_collection_add ((ValaCollection*) _tmp314_, _tmp316_);
		_gtkdoc_header_unref0 (_tmp316_);
		_tmp317_ = error_header;
		if (_tmp317_ != NULL) {
			GtkdocGComment* _tmp318_;
			ValaList* _tmp319_;
			GtkdocHeader* _tmp320_;
			_tmp318_ = finish_gcomment;
			_tmp319_ = _tmp318_->headers;
			_tmp320_ = error_header;
			vala_collection_add ((ValaCollection*) _tmp319_, _tmp320_);
		}
		_tmp321_ = finish_gcomment;
		_tmp322_ = _tmp321_->see_also;
		_tmp322__length1 = _tmp321_->see_also_length1;
		_tmp323_ = (_tmp322_ != NULL) ? _vala_array_dup12 (_tmp322_, _tmp322__length1) : ((gpointer) _tmp322_);
		_tmp323__length1 = _tmp322__length1;
		see_also = _tmp323_;
		see_also_length1 = _tmp323__length1;
		_see_also_size_ = see_also_length1;
		_tmp324_ = gtkdoc_get_docbook_link ((ValadocApiItem*) m, FALSE, FALSE);
		_vala_array_add23 (&see_also, &see_also_length1, &_see_also_size_, _tmp324_);
		_tmp325_ = finish_gcomment;
		_tmp326_ = see_also;
		_tmp326__length1 = see_also_length1;
		_tmp327_ = (_tmp326_ != NULL) ? _vala_array_dup13 (_tmp326_, _tmp326__length1) : ((gpointer) _tmp326_);
		_tmp327__length1 = _tmp326__length1;
		_tmp325_->see_also = (_vala_array_free (_tmp325_->see_also, _tmp325_->see_also_length1, (GDestroyNotify) g_free), NULL);
		_tmp325_->see_also = _tmp327_;
		_tmp325_->see_also_length1 = _tmp327__length1;
		_tmp328_ = return_type_desc;
		if (_tmp328_ != NULL) {
			GtkdocGComment* _tmp329_;
			const gchar* _tmp330_;
			GtkdocGComment* _tmp331_;
			const gchar* _tmp332_;
			gchar* _tmp333_;
			_tmp329_ = finish_gcomment;
			_tmp330_ = return_type_desc;
			_tmp331_ = finish_gcomment;
			_tmp332_ = _tmp331_->returns;
			_tmp333_ = gtkdoc_generator_combine_inline_docs (self, _tmp330_, _tmp332_);
			_g_free0 (_tmp329_->returns);
			_tmp329_->returns = _tmp333_;
		}
		see_also = (_vala_array_free (see_also, see_also_length1, (GDestroyNotify) g_free), NULL);
		_gtkdoc_gcomment_unref0 (finish_gcomment);
	} else {
		const gchar* _tmp334_;
		_tmp334_ = return_type_desc;
		if (_tmp334_ != NULL) {
			GtkdocGComment* _tmp335_;
			const gchar* _tmp336_;
			GtkdocGComment* _tmp337_;
			const gchar* _tmp338_;
			gchar* _tmp339_;
			_tmp335_ = gcomment;
			_tmp336_ = return_type_desc;
			_tmp337_ = gcomment;
			_tmp338_ = _tmp337_->returns;
			_tmp339_ = gtkdoc_generator_combine_inline_docs (self, _tmp336_, _tmp338_);
			_g_free0 (_tmp335_->returns);
			_tmp335_->returns = _tmp339_;
		}
	}
	_tmp341_ = valadoc_api_method_get_is_constructor (m);
	_tmp342_ = _tmp341_;
	if (_tmp342_) {
		gchar* _tmp343_;
		gchar* _tmp344_;
		_tmp343_ = valadoc_api_method_get_cname (m);
		_tmp344_ = _tmp343_;
		_tmp340_ = !g_str_has_suffix (_tmp344_, "_new");
		_g_free0 (_tmp344_);
	} else {
		_tmp340_ = FALSE;
	}
	if (_tmp340_) {
		GtkdocGeneratorFileData* file_data = NULL;
		gchar* _tmp345_;
		gchar* _tmp346_;
		GtkdocGeneratorFileData* _tmp347_;
		GtkdocGeneratorFileData* _tmp348_;
		GtkdocGeneratorFileData* _tmp349_;
		ValaList* _tmp350_;
		gchar* _tmp351_;
		gchar* _tmp352_;
		gchar* _tmp353_;
		gchar* _tmp354_;
		_tmp345_ = valadoc_documentation_get_filename ((ValadocDocumentation*) m);
		_tmp346_ = _tmp345_;
		_tmp347_ = gtkdoc_generator_get_file_data (self, _tmp346_);
		_tmp348_ = _tmp347_;
		_g_free0 (_tmp346_);
		file_data = _tmp348_;
		_tmp349_ = file_data;
		_tmp350_ = _tmp349_->private_section_lines;
		_tmp351_ = valadoc_api_method_get_cname (m);
		_tmp352_ = _tmp351_;
		_tmp353_ = string_replace (_tmp352_, "_new", "_construct");
		_tmp354_ = _tmp353_;
		vala_collection_add ((ValaCollection*) _tmp350_, _tmp354_);
		_g_free0 (_tmp354_);
		_g_free0 (_tmp352_);
		_gtkdoc_generator_file_data_unref0 (file_data);
	}
	_g_object_unref0 (type_parameter);
	_g_free0 (return_type_desc);
	_gtkdoc_gcomment_unref0 (gcomment);
	_gtkdoc_header_unref0 (error_header);
	_vala_iterable_unref0 (exceptions);
	_vala_iterable_unref0 (type_parameters);
	_gtkdoc_dbus_member_unref0 (old_dbus_member);
	_g_object_unref0 (old_method);
	_vala_iterable_unref0 (old_headers);
	annotations = (_vala_array_free (annotations, annotations_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * Visit abstract methods
 */
static void
gtkdoc_generator_visit_abstract_method (GtkdocGenerator* self,
                                        ValadocApiMethod* m)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp1_ = valadoc_api_method_get_is_abstract (m);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = valadoc_api_method_get_is_virtual (m);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) m);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = valadoc_api_symbol_get_is_protected ((ValadocApiSymbol*) m);
		_tmp10_ = _tmp9_;
		_tmp6_ = !_tmp10_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = valadoc_api_symbol_get_is_internal ((ValadocApiSymbol*) m);
		_tmp12_ = _tmp11_;
		_tmp5_ = !_tmp12_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkdocHeader* _tmp19_;
		GtkdocHeader* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp13_ = valadoc_api_node_get_name ((ValadocApiNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtkdoc_get_docbook_link ((ValadocApiItem*) m, FALSE, FALSE);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strdup_printf ("virtual method called by %s", _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gtkdoc_generator_add_custom_header (self, _tmp14_, _tmp18_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp20_ = _tmp19_;
		_gtkdoc_header_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_tmp21_ = valadoc_api_method_get_is_yields (m);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			GtkdocHeader* _tmp33_;
			GtkdocHeader* _tmp34_;
			_tmp23_ = valadoc_api_node_get_name ((ValadocApiNode*) m);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, "_finish", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = valadoc_api_node_get_name ((ValadocApiNode*) m);
			_tmp28_ = _tmp27_;
			_tmp29_ = gtkdoc_get_docbook_link ((ValadocApiItem*) m, FALSE, FALSE);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("asynchronous finish function for <structfield>%s</structfield>, called" \
" by %s", _tmp28_, _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = gtkdoc_generator_add_custom_header (self, _tmp26_, _tmp32_, NULL, (gint) 0, DBL_MAX, TRUE);
			_tmp34_ = _tmp33_;
			_gtkdoc_header_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp26_);
		}
	} else {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		GtkdocHeader* _tmp37_;
		GtkdocHeader* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp35_ = valadoc_api_node_get_name ((ValadocApiNode*) m);
		_tmp36_ = _tmp35_;
		_tmp37_ = gtkdoc_generator_add_custom_header (self, _tmp36_, "virtual method used internally", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp38_ = _tmp37_;
		_gtkdoc_header_unref0 (_tmp38_);
		_tmp39_ = valadoc_api_method_get_is_yields (m);
		_tmp40_ = _tmp39_;
		if (_tmp40_) {
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			GtkdocHeader* _tmp45_;
			GtkdocHeader* _tmp46_;
			_tmp41_ = valadoc_api_node_get_name ((ValadocApiNode*) m);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat (_tmp42_, "_finish", NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = gtkdoc_generator_add_custom_header (self, _tmp44_, "asynchronous finish function used internally", NULL, (gint) 0, DBL_MAX, TRUE);
			_tmp46_ = _tmp45_;
			_gtkdoc_header_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
		}
	}
}

/**
 * Visit abstract properties
 */
static void
gtkdoc_generator_visit_abstract_property (GtkdocGenerator* self,
                                          ValadocApiProperty* prop)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	ValadocApiPropertyAccessor* _tmp8_;
	ValadocApiPropertyAccessor* _tmp9_;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValadocApiPropertyAccessor* _tmp36_;
	ValadocApiPropertyAccessor* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp1_ = valadoc_api_property_get_is_abstract (prop);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = valadoc_api_property_get_is_virtual (prop);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp8_ = valadoc_api_property_get_getter (prop);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValadocApiPropertyAccessor* _tmp10_;
		ValadocApiPropertyAccessor* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = valadoc_api_property_get_getter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp7_ = !_tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValadocApiPropertyAccessor* _tmp14_;
		ValadocApiPropertyAccessor* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp14_ = valadoc_api_property_get_getter (prop);
		_tmp15_ = _tmp14_;
		_tmp16_ = valadoc_api_symbol_get_is_internal ((ValadocApiSymbol*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp6_ = !_tmp17_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocApiPropertyAccessor* _tmp18_;
		ValadocApiPropertyAccessor* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp18_ = valadoc_api_property_get_getter (prop);
		_tmp19_ = _tmp18_;
		_tmp20_ = valadoc_api_property_accessor_get_is_get (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp5_ = _tmp21_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GtkdocHeader* _tmp30_;
		GtkdocHeader* _tmp31_;
		_tmp22_ = valadoc_api_node_get_name ((ValadocApiNode*) prop);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("get_", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("getter method for the abstract property %s", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = gtkdoc_generator_add_custom_header (self, _tmp25_, _tmp29_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp31_ = _tmp30_;
		_gtkdoc_header_unref0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
	}
	_tmp36_ = valadoc_api_property_get_setter (prop);
	_tmp37_ = _tmp36_;
	if (_tmp37_ != NULL) {
		ValadocApiPropertyAccessor* _tmp38_;
		ValadocApiPropertyAccessor* _tmp39_;
		gboolean _tmp40_;
		gboolean _tmp41_;
		_tmp38_ = valadoc_api_property_get_setter (prop);
		_tmp39_ = _tmp38_;
		_tmp40_ = valadoc_api_symbol_get_is_private ((ValadocApiSymbol*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp35_ = !_tmp41_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ValadocApiPropertyAccessor* _tmp42_;
		ValadocApiPropertyAccessor* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp42_ = valadoc_api_property_get_setter (prop);
		_tmp43_ = _tmp42_;
		_tmp44_ = valadoc_api_symbol_get_is_internal ((ValadocApiSymbol*) _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp34_ = !_tmp45_;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		ValadocApiPropertyAccessor* _tmp46_;
		ValadocApiPropertyAccessor* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp46_ = valadoc_api_property_get_setter (prop);
		_tmp47_ = _tmp46_;
		_tmp48_ = valadoc_api_property_accessor_get_is_set (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp33_ = _tmp49_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ValadocApiPropertyAccessor* _tmp50_;
		ValadocApiPropertyAccessor* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		_tmp50_ = valadoc_api_property_get_setter (prop);
		_tmp51_ = _tmp50_;
		_tmp52_ = valadoc_api_property_accessor_get_is_construct (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp32_ = !_tmp53_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		GtkdocHeader* _tmp62_;
		GtkdocHeader* _tmp63_;
		_tmp54_ = valadoc_api_node_get_name ((ValadocApiNode*) prop);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat ("set_", _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = gtkdoc_get_docbook_link ((ValadocApiItem*) prop, FALSE, FALSE);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_strdup_printf ("setter method for the abstract property %s", _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = gtkdoc_generator_add_custom_header (self, _tmp57_, _tmp61_, NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp63_ = _tmp62_;
		_gtkdoc_header_unref0 (_tmp63_);
		_g_free0 (_tmp61_);
		_g_free0 (_tmp59_);
		_g_free0 (_tmp57_);
	}
}

static void
_vala_array_add24 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add25 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add26 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add27 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add28 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gtkdoc_generator_real_visit_formal_parameter (ValadocApiVisitor* base,
                                              ValadocApiParameter* param)
{
	GtkdocGenerator * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* param_name = NULL;
	gchar* _tmp3_;
	gchar** annotations = NULL;
	gchar** _tmp4_;
	gint annotations_length1;
	gint _annotations_size_;
	gchar* direction = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkdocHeader* _tmp7_;
	GtkdocHeader* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	ValadocApiTypeParameter* type_parameter = NULL;
	ValadocApiTypeReference* _tmp17_;
	ValadocApiTypeReference* _tmp18_;
	ValadocApiItem* _tmp19_;
	ValadocApiItem* _tmp20_;
	ValadocApiTypeParameter* _tmp21_;
	ValadocApiTypeParameter* _tmp22_;
	ValadocApiTypeReference* _tmp81_;
	ValadocApiTypeReference* _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp86_ = FALSE;
	ValadocApiTypeReference* _tmp87_;
	ValadocApiTypeReference* _tmp88_;
	gboolean _tmp89_;
	gboolean _tmp90_;
	ValadocApiTypeReference* _tmp96_;
	ValadocApiTypeReference* _tmp97_;
	ValadocApiItem* _tmp98_;
	ValadocApiItem* _tmp99_;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_;
	gboolean _tmp116_;
	gboolean _tmp128_ = FALSE;
	ValadocApiSignal* _tmp129_;
	ValadocApiTypeReference* _tmp144_;
	ValadocApiTypeReference* _tmp145_;
	ValadocApiItem* _tmp146_;
	ValadocApiItem* _tmp147_;
	GtkdocDBusMember* _tmp181_;
	self = (GtkdocGenerator*) base;
	g_return_if_fail (param != NULL);
	_tmp1_ = valadoc_api_node_get_name ((ValadocApiNode*) param);
	_tmp2_ = _tmp1_;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "...";
	}
	_tmp3_ = g_strdup (_tmp0_);
	param_name = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	annotations = _tmp4_;
	annotations_length1 = 0;
	_annotations_size_ = annotations_length1;
	_tmp5_ = g_strdup ("in");
	direction = _tmp5_;
	_tmp6_ = param_name;
	_tmp7_ = gtkdoc_generator_add_custom_header (self, _tmp6_, "&nbsp;", NULL, (gint) 0, DBL_MAX, FALSE);
	_tmp8_ = _tmp7_;
	_gtkdoc_header_unref0 (_tmp8_);
	_tmp9_ = valadoc_api_parameter_get_is_out (param);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("out");
		_g_free0 (direction);
		direction = _tmp11_;
	} else {
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp12_ = valadoc_api_parameter_get_is_ref (param);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("inout");
			_g_free0 (direction);
			direction = _tmp14_;
		}
	}
	_tmp15_ = direction;
	_tmp16_ = g_strdup (_tmp15_);
	_vala_array_add24 (&annotations, &annotations_length1, &_annotations_size_, _tmp16_);
	_tmp17_ = valadoc_api_parameter_get_parameter_type (param);
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_api_typereference_get_data_type (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALADOC_API_TYPE_TYPEPARAMETER) ? ((ValadocApiTypeParameter*) _tmp20_) : NULL);
	type_parameter = _tmp21_;
	_tmp22_ = type_parameter;
	if (_tmp22_ != NULL) {
		ValadocApiTypeParameter* _tmp23_;
		ValadocApiItem* _tmp24_;
		ValadocApiItem* _tmp25_;
		_tmp23_ = type_parameter;
		_tmp24_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp23_);
		_tmp25_ = _tmp24_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALADOC_API_TYPE_CLASS)) {
			const gchar* _tmp26_;
			ValadocApiTypeParameter* _tmp27_;
			ValadocApiItem* _tmp28_;
			ValadocApiItem* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValadocApiTypeParameter* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			GtkdocHeader* _tmp39_;
			GtkdocHeader* _tmp40_;
			_tmp26_ = param_name;
			_tmp27_ = type_parameter;
			_tmp28_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gtkdoc_get_cname (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = type_parameter;
			_tmp33_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_utf8_strdown (_tmp34_, (gssize) -1);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strdup_printf ("A parameter from type #%s:%s-type.", _tmp31_, _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = gtkdoc_generator_add_custom_header (self, _tmp26_, _tmp38_, NULL, (gint) 0, DBL_MAX, FALSE);
			_tmp40_ = _tmp39_;
			_gtkdoc_header_unref0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp31_);
		} else {
			gboolean _tmp41_ = FALSE;
			ValadocApiTypeParameter* _tmp42_;
			ValadocApiItem* _tmp43_;
			ValadocApiItem* _tmp44_;
			_tmp42_ = type_parameter;
			_tmp43_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp42_);
			_tmp44_ = _tmp43_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALADOC_API_TYPE_INTERFACE)) {
				ValadocApiTypeParameter* _tmp45_;
				ValadocApiItem* _tmp46_;
				ValadocApiItem* _tmp47_;
				ValadocApiAttribute* _tmp48_;
				ValadocApiAttribute* _tmp49_;
				_tmp45_ = type_parameter;
				_tmp46_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = valadoc_api_symbol_get_attribute (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), "GenericAccessors");
				_tmp49_ = _tmp48_;
				_tmp41_ = _tmp49_ != NULL;
				_g_object_unref0 (_tmp49_);
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				const gchar* _tmp50_;
				ValadocApiTypeParameter* _tmp51_;
				ValadocApiItem* _tmp52_;
				ValadocApiItem* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				ValadocApiTypeParameter* _tmp56_;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				GtkdocHeader* _tmp63_;
				GtkdocHeader* _tmp64_;
				_tmp50_ = param_name;
				_tmp51_ = type_parameter;
				_tmp52_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = gtkdoc_get_cname (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = type_parameter;
				_tmp57_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = g_utf8_strdown (_tmp58_, (gssize) -1);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("A parameter from type #_%sIface.get_%s_type().", _tmp55_, _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = gtkdoc_generator_add_custom_header (self, _tmp50_, _tmp62_, NULL, (gint) 0, DBL_MAX, FALSE);
				_tmp64_ = _tmp63_;
				_gtkdoc_header_unref0 (_tmp64_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				_g_free0 (_tmp55_);
			} else {
				ValadocApiTypeParameter* _tmp65_;
				ValadocApiItem* _tmp66_;
				ValadocApiItem* _tmp67_;
				_tmp65_ = type_parameter;
				_tmp66_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp65_);
				_tmp67_ = _tmp66_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALADOC_API_TYPE_STRUCT)) {
				} else {
					ValadocApiTypeParameter* _tmp68_;
					ValadocApiItem* _tmp69_;
					ValadocApiItem* _tmp70_;
					_tmp68_ = type_parameter;
					_tmp69_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp68_);
					_tmp70_ = _tmp69_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, VALADOC_API_TYPE_METHOD)) {
						const gchar* _tmp71_;
						ValadocApiTypeParameter* _tmp72_;
						const gchar* _tmp73_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						gchar* _tmp77_;
						gchar* _tmp78_;
						GtkdocHeader* _tmp79_;
						GtkdocHeader* _tmp80_;
						_tmp71_ = param_name;
						_tmp72_ = type_parameter;
						_tmp73_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp72_);
						_tmp74_ = _tmp73_;
						_tmp75_ = g_utf8_strdown (_tmp74_, (gssize) -1);
						_tmp76_ = _tmp75_;
						_tmp77_ = g_strdup_printf ("A parameter from type @%s_type.", _tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = gtkdoc_generator_add_custom_header (self, _tmp71_, _tmp78_, NULL, (gint) 0, DBL_MAX, FALSE);
						_tmp80_ = _tmp79_;
						_gtkdoc_header_unref0 (_tmp80_);
						_g_free0 (_tmp78_);
						_g_free0 (_tmp76_);
					}
				}
			}
		}
	}
	_tmp81_ = valadoc_api_parameter_get_parameter_type (param);
	_tmp82_ = _tmp81_;
	_tmp83_ = valadoc_api_typereference_get_is_nullable (_tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_) {
		gchar* _tmp85_;
		_tmp85_ = g_strdup ("allow-none");
		_vala_array_add25 (&annotations, &annotations_length1, &_annotations_size_, _tmp85_);
	}
	_tmp87_ = valadoc_api_parameter_get_parameter_type (param);
	_tmp88_ = _tmp87_;
	_tmp89_ = valadoc_api_typereference_get_is_owned (_tmp88_);
	_tmp90_ = _tmp89_;
	if (_tmp90_) {
		ValadocApiTypeReference* _tmp91_;
		ValadocApiTypeReference* _tmp92_;
		ValadocApiItem* _tmp93_;
		ValadocApiItem* _tmp94_;
		_tmp91_ = valadoc_api_parameter_get_parameter_type (param);
		_tmp92_ = _tmp91_;
		_tmp93_ = valadoc_api_typereference_get_data_type (_tmp92_);
		_tmp94_ = _tmp93_;
		_tmp86_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, VALADOC_API_TYPE_DELEGATE);
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		gchar* _tmp95_;
		_tmp95_ = g_strdup ("transfer full");
		_vala_array_add26 (&annotations, &annotations_length1, &_annotations_size_, _tmp95_);
	}
	_tmp96_ = valadoc_api_parameter_get_parameter_type (param);
	_tmp97_ = _tmp96_;
	_tmp98_ = valadoc_api_typereference_get_data_type (_tmp97_);
	_tmp99_ = _tmp98_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALADOC_API_TYPE_ARRAY)) {
		const gchar* _tmp100_;
		gchar* _tmp101_;
		const gchar* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		const gchar* _tmp105_;
		gchar* _tmp106_;
		gchar* _tmp107_;
		ValadocApiNode* _tmp108_;
		ValadocApiNode* _tmp109_;
		const gchar* _tmp110_;
		GtkdocHeader* _tmp111_;
		GtkdocHeader* _tmp112_;
		_tmp100_ = param_name;
		_tmp101_ = g_strdup_printf ("array length=%s_length1", _tmp100_);
		_vala_array_add27 (&annotations, &annotations_length1, &_annotations_size_, _tmp101_);
		_tmp102_ = param_name;
		_tmp103_ = g_strdup_printf ("%s_length1", _tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = param_name;
		_tmp106_ = g_strdup_printf ("length of the @%s array", _tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = gtkdoc_generator_get_current_method_or_delegate (self);
		_tmp109_ = _tmp108_;
		_tmp110_ = param_name;
		_tmp111_ = gtkdoc_generator_add_custom_header (self, _tmp104_, _tmp107_, NULL, (gint) 0, gtkdoc_get_parameter_pos (_tmp109_, _tmp110_) + 0.1, TRUE);
		_tmp112_ = _tmp111_;
		_gtkdoc_header_unref0 (_tmp112_);
		_g_free0 (_tmp107_);
		_g_free0 (_tmp104_);
	}
	_tmp115_ = valadoc_api_parameter_get_ellipsis (param);
	_tmp116_ = _tmp115_;
	if (!_tmp116_) {
		ValadocApiTypeReference* _tmp117_;
		ValadocApiTypeReference* _tmp118_;
		ValadocApiItem* _tmp119_;
		ValadocApiItem* _tmp120_;
		_tmp117_ = valadoc_api_parameter_get_parameter_type (param);
		_tmp118_ = _tmp117_;
		_tmp119_ = valadoc_api_typereference_get_data_type (_tmp118_);
		_tmp120_ = _tmp119_;
		_tmp114_ = _tmp120_ != NULL;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValadocApiTypeReference* _tmp121_;
		ValadocApiTypeReference* _tmp122_;
		ValadocApiItem* _tmp123_;
		ValadocApiItem* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		_tmp121_ = valadoc_api_parameter_get_parameter_type (param);
		_tmp122_ = _tmp121_;
		_tmp123_ = valadoc_api_typereference_get_data_type (_tmp122_);
		_tmp124_ = _tmp123_;
		_tmp125_ = gtkdoc_get_cname (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp113_ = g_strcmp0 (_tmp126_, "GError") == 0;
		_g_free0 (_tmp126_);
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		gchar* _tmp127_;
		_tmp127_ = g_strdup ("not-error");
		_vala_array_add28 (&annotations, &annotations_length1, &_annotations_size_, _tmp127_);
	}
	_tmp129_ = self->priv->current_signal;
	if (_tmp129_ != NULL) {
		ValadocContentComment* _tmp130_;
		ValadocContentComment* _tmp131_;
		_tmp130_ = valadoc_api_node_get_documentation ((ValadocApiNode*) param);
		_tmp131_ = _tmp130_;
		_tmp128_ = _tmp131_ == NULL;
	} else {
		_tmp128_ = FALSE;
	}
	if (_tmp128_) {
		const gchar* _tmp132_;
		GtkdocHeader* _tmp133_;
		GtkdocHeader* _tmp134_;
		_tmp132_ = param_name;
		_tmp133_ = gtkdoc_generator_add_custom_header (self, _tmp132_, "", NULL, (gint) 0, DBL_MAX, TRUE);
		_tmp134_ = _tmp133_;
		_gtkdoc_header_unref0 (_tmp134_);
	} else {
		const gchar* _tmp135_;
		ValadocContentComment* _tmp136_;
		ValadocContentComment* _tmp137_;
		gchar** _tmp138_;
		gint _tmp138__length1;
		ValadocApiNode* _tmp139_;
		ValadocApiNode* _tmp140_;
		const gchar* _tmp141_;
		GtkdocHeader* _tmp142_;
		GtkdocHeader* _tmp143_;
		_tmp135_ = param_name;
		_tmp136_ = valadoc_api_node_get_documentation ((ValadocApiNode*) param);
		_tmp137_ = _tmp136_;
		_tmp138_ = annotations;
		_tmp138__length1 = annotations_length1;
		_tmp139_ = gtkdoc_generator_get_current_method_or_delegate (self);
		_tmp140_ = _tmp139_;
		_tmp141_ = param_name;
		_tmp142_ = gtkdoc_generator_add_header (self, _tmp135_, _tmp137_, _tmp138_, (gint) _tmp138__length1, gtkdoc_get_parameter_pos (_tmp140_, _tmp141_));
		_tmp143_ = _tmp142_;
		_gtkdoc_header_unref0 (_tmp143_);
	}
	_tmp144_ = valadoc_api_parameter_get_parameter_type (param);
	_tmp145_ = _tmp144_;
	_tmp146_ = valadoc_api_typereference_get_data_type (_tmp145_);
	_tmp147_ = _tmp146_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALADOC_API_TYPE_DELEGATE)) {
		const gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		const gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		gchar* _tmp155_;
		gchar** _tmp156_;
		gchar** _tmp157_;
		gint _tmp157__length1;
		ValadocApiNode* _tmp158_;
		ValadocApiNode* _tmp159_;
		const gchar* _tmp160_;
		GtkdocHeader* _tmp161_;
		GtkdocHeader* _tmp162_;
		ValadocApiTypeReference* _tmp163_;
		ValadocApiTypeReference* _tmp164_;
		gboolean _tmp165_;
		gboolean _tmp166_;
		_tmp148_ = param_name;
		_tmp149_ = g_strdup_printf ("%s_target", _tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = param_name;
		_tmp152_ = g_strdup_printf ("user data to pass to @%s", _tmp151_);
		_tmp153_ = _tmp152_;
		_tmp154_ = g_strdup ("allow-none");
		_tmp155_ = g_strdup ("closure");
		_tmp156_ = g_new0 (gchar*, 2 + 1);
		_tmp156_[0] = _tmp154_;
		_tmp156_[1] = _tmp155_;
		_tmp157_ = _tmp156_;
		_tmp157__length1 = 2;
		_tmp158_ = gtkdoc_generator_get_current_method_or_delegate (self);
		_tmp159_ = _tmp158_;
		_tmp160_ = param_name;
		_tmp161_ = gtkdoc_generator_add_custom_header (self, _tmp150_, _tmp153_, _tmp157_, (gint) 2, gtkdoc_get_parameter_pos (_tmp159_, _tmp160_) + 0.1, TRUE);
		_tmp162_ = _tmp161_;
		_gtkdoc_header_unref0 (_tmp162_);
		_tmp157_ = (_vala_array_free (_tmp157_, _tmp157__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp153_);
		_g_free0 (_tmp150_);
		_tmp163_ = valadoc_api_parameter_get_parameter_type (param);
		_tmp164_ = _tmp163_;
		_tmp165_ = valadoc_api_typereference_get_is_owned (_tmp164_);
		_tmp166_ = _tmp165_;
		if (_tmp166_) {
			const gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			const gchar* _tmp170_;
			gchar* _tmp171_;
			gchar* _tmp172_;
			gchar* _tmp173_;
			gchar** _tmp174_;
			gchar** _tmp175_;
			gint _tmp175__length1;
			ValadocApiNode* _tmp176_;
			ValadocApiNode* _tmp177_;
			const gchar* _tmp178_;
			GtkdocHeader* _tmp179_;
			GtkdocHeader* _tmp180_;
			_tmp167_ = param_name;
			_tmp168_ = g_strdup_printf ("%s_target_destroy_notify", _tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = param_name;
			_tmp171_ = g_strdup_printf ("function to call when @%s_target is no longer needed", _tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = g_strdup ("allow-none");
			_tmp174_ = g_new0 (gchar*, 1 + 1);
			_tmp174_[0] = _tmp173_;
			_tmp175_ = _tmp174_;
			_tmp175__length1 = 1;
			_tmp176_ = gtkdoc_generator_get_current_method_or_delegate (self);
			_tmp177_ = _tmp176_;
			_tmp178_ = param_name;
			_tmp179_ = gtkdoc_generator_add_custom_header (self, _tmp169_, _tmp172_, _tmp175_, (gint) 1, gtkdoc_get_parameter_pos (_tmp177_, _tmp178_) + 0.2, TRUE);
			_tmp180_ = _tmp179_;
			_gtkdoc_header_unref0 (_tmp180_);
			_tmp175_ = (_vala_array_free (_tmp175_, _tmp175__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_tmp172_);
			_g_free0 (_tmp169_);
		}
	}
	_tmp181_ = self->priv->current_dbus_member;
	if (_tmp181_ != NULL) {
		GtkdocDBusParameterDirection ddirection = 0;
		ValadocApiSignal* _tmp182_;
		GtkdocDBusParameter* dparam = NULL;
		const gchar* _tmp185_;
		ValadocApiTypeReference* _tmp186_;
		ValadocApiTypeReference* _tmp187_;
		gchar* _tmp188_;
		gchar* _tmp189_;
		GtkdocDBusParameterDirection _tmp190_;
		GtkdocDBusParameter* _tmp191_;
		GtkdocDBusParameter* _tmp192_;
		GtkdocDBusMember* _tmp193_;
		GtkdocDBusParameter* _tmp194_;
		ddirection = GTKDOC_DBUS_PARAMETER_DIRECTION_IN;
		_tmp182_ = self->priv->current_signal;
		if (_tmp182_ != NULL) {
			ddirection = GTKDOC_DBUS_PARAMETER_DIRECTION_NONE;
		} else {
			gboolean _tmp183_;
			gboolean _tmp184_;
			_tmp183_ = valadoc_api_parameter_get_is_out (param);
			_tmp184_ = _tmp183_;
			if (_tmp184_) {
				ddirection = GTKDOC_DBUS_PARAMETER_DIRECTION_OUT;
			}
		}
		_tmp185_ = param_name;
		_tmp186_ = valadoc_api_parameter_get_parameter_type (param);
		_tmp187_ = _tmp186_;
		_tmp188_ = valadoc_api_typereference_get_dbus_type_signature (_tmp187_);
		_tmp189_ = _tmp188_;
		_tmp190_ = ddirection;
		_tmp191_ = gtkdoc_dbus_parameter_new (_tmp185_, _tmp189_, _tmp190_);
		_tmp192_ = _tmp191_;
		_g_free0 (_tmp189_);
		dparam = _tmp192_;
		_tmp193_ = self->priv->current_dbus_member;
		_tmp194_ = dparam;
		gtkdoc_dbus_member_add_parameter (_tmp193_, _tmp194_);
		_gtkdoc_dbus_parameter_unref0 (dparam);
	}
	valadoc_api_node_accept_all_children ((ValadocApiNode*) param, (ValadocApiVisitor*) self, TRUE);
	_g_object_unref0 (type_parameter);
	_g_free0 (direction);
	annotations = (_vala_array_free (annotations, annotations_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (param_name);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
gtkdoc_generator_process_attributes (GtkdocGenerator* self,
                                     ValadocApiSymbol* sym,
                                     GtkdocGComment* gcomment)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (gcomment != NULL);
	_tmp0_ = valadoc_api_symbol_get_is_deprecated (sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValadocApiAttribute* version = NULL;
		ValadocApiAttribute* deprecated = NULL;
		gchar* deprecated_since = NULL;
		gchar* replacement = NULL;
		ValadocApiAttribute* _tmp2_;
		ValadocApiAttribute* _tmp3_;
		gchar* since = NULL;
		const gchar* _tmp22_;
		gchar* replacement_symbol_name = NULL;
		ValadocApiNode* replacement_symbol = NULL;
		const gchar* _tmp34_;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_;
		gchar* deprecation_string = NULL;
		gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		const gchar* _tmp61_;
		ValaList* _tmp83_;
		const gchar* _tmp84_;
		GtkdocHeader* _tmp85_;
		GtkdocHeader* _tmp86_;
		_tmp2_ = valadoc_api_symbol_get_attribute (sym, "Version");
		_g_object_unref0 (version);
		version = _tmp2_;
		_tmp3_ = version;
		if (_tmp3_ != NULL) {
			ValadocApiAttribute* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaCodeNode* _tmp6_;
			gchar* _tmp7_;
			ValadocApiAttribute* _tmp8_;
			ValaCodeNode* _tmp9_;
			ValaCodeNode* _tmp10_;
			gchar* _tmp11_;
			_tmp4_ = version;
			_tmp5_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "deprecated_since", NULL);
			_g_free0 (deprecated_since);
			deprecated_since = _tmp7_;
			_tmp8_ = version;
			_tmp9_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "replacement", NULL);
			_g_free0 (replacement);
			replacement = _tmp11_;
		} else {
			ValadocApiAttribute* _tmp12_;
			ValadocApiAttribute* _tmp13_;
			_tmp12_ = valadoc_api_symbol_get_attribute (sym, "Deprecated");
			_g_object_unref0 (deprecated);
			deprecated = _tmp12_;
			_tmp13_ = deprecated;
			if (_tmp13_ != NULL) {
				ValadocApiAttribute* _tmp14_;
				ValaCodeNode* _tmp15_;
				ValaCodeNode* _tmp16_;
				gchar* _tmp17_;
				ValadocApiAttribute* _tmp18_;
				ValaCodeNode* _tmp19_;
				ValaCodeNode* _tmp20_;
				gchar* _tmp21_;
				_tmp14_ = deprecated;
				_tmp15_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "since", NULL);
				_g_free0 (deprecated_since);
				deprecated_since = _tmp17_;
				_tmp18_ = deprecated;
				_tmp19_ = valadoc_api_item_get_data ((ValadocApiItem*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_attribute_get_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_ATTRIBUTE, ValaAttribute), "replacement", NULL);
				_g_free0 (replacement);
				replacement = _tmp21_;
			} else {
				g_assert_not_reached ();
			}
		}
		since = NULL;
		_tmp22_ = deprecated_since;
		if (_tmp22_ != NULL) {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp31_;
			_tmp23_ = deprecated_since;
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (since);
			since = _tmp24_;
			_tmp25_ = since;
			if (g_str_has_prefix (_tmp25_, "\"")) {
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gchar* _tmp30_;
				_tmp26_ = since;
				_tmp27_ = since;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = string_slice (_tmp26_, (glong) 1, (glong) (_tmp29_ - 1));
				_g_free0 (since);
				since = _tmp30_;
			}
			_tmp31_ = since;
			if (g_str_has_suffix (_tmp31_, "\"")) {
				const gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp32_ = since;
				_tmp33_ = string_slice (_tmp32_, (glong) 0, (glong) -1);
				_g_free0 (since);
				since = _tmp33_;
			}
		}
		replacement_symbol_name = NULL;
		replacement_symbol = NULL;
		_tmp34_ = replacement;
		if (_tmp34_ != NULL) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp43_;
			const gchar* _tmp46_;
			ValadocApiTree* _tmp49_;
			const gchar* _tmp50_;
			ValadocApiNode* _tmp51_;
			_tmp35_ = replacement;
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (replacement_symbol_name);
			replacement_symbol_name = _tmp36_;
			_tmp37_ = replacement_symbol_name;
			if (g_str_has_prefix (_tmp37_, "\"")) {
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gchar* _tmp42_;
				_tmp38_ = replacement_symbol_name;
				_tmp39_ = replacement_symbol_name;
				_tmp40_ = strlen (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = string_slice (_tmp38_, (glong) 1, (glong) (_tmp41_ - 1));
				_g_free0 (replacement_symbol_name);
				replacement_symbol_name = _tmp42_;
			}
			_tmp43_ = replacement_symbol_name;
			if (g_str_has_suffix (_tmp43_, "\"")) {
				const gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp44_ = replacement_symbol_name;
				_tmp45_ = string_slice (_tmp44_, (glong) 0, (glong) -1);
				_g_free0 (replacement_symbol_name);
				replacement_symbol_name = _tmp45_;
			}
			_tmp46_ = replacement_symbol_name;
			if (g_str_has_suffix (_tmp46_, "()")) {
				const gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp47_ = replacement_symbol_name;
				_tmp48_ = string_slice (_tmp47_, (glong) 0, (glong) -2);
				_g_free0 (replacement_symbol_name);
				replacement_symbol_name = _tmp48_;
			}
			_tmp49_ = self->priv->current_tree;
			_tmp50_ = replacement_symbol_name;
			_tmp51_ = valadoc_api_tree_search_symbol_str (_tmp49_, (ValadocApiNode*) sym, _tmp50_);
			_g_object_unref0 (replacement_symbol);
			replacement_symbol = _tmp51_;
		}
		_tmp53_ = replacement;
		if (_tmp53_ != NULL) {
			ValadocApiNode* _tmp54_;
			_tmp54_ = replacement_symbol;
			_tmp52_ = _tmp54_ == NULL;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			ValadocErrorReporter* _tmp55_;
			const gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp55_ = self->priv->reporter;
			_tmp56_ = replacement_symbol_name;
			_tmp57_ = valadoc_api_node_get_full_name ((ValadocApiNode*) sym);
			_tmp58_ = _tmp57_;
			valadoc_error_reporter_simple_warning (_tmp55_, "GtkDoc", "Couldn’t resolve replacement symbol ‘%s’ for ‘Deprecated’ attribute on" \
" %s.", _tmp56_, _tmp58_);
			_g_free0 (_tmp58_);
		}
		_tmp59_ = g_strdup ("No replacement specified.");
		deprecation_string = _tmp59_;
		_tmp61_ = since;
		if (_tmp61_ != NULL) {
			ValadocApiNode* _tmp62_;
			_tmp62_ = replacement_symbol;
			_tmp60_ = _tmp62_ != NULL;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			const gchar* _tmp63_;
			ValadocApiNode* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp63_ = since;
			_tmp64_ = replacement_symbol;
			_tmp65_ = gtkdoc_get_gtkdoc_link (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("%s: Replaced by %s.", _tmp63_, _tmp66_);
			_g_free0 (deprecation_string);
			deprecation_string = _tmp67_;
			_g_free0 (_tmp66_);
		} else {
			gboolean _tmp68_ = FALSE;
			const gchar* _tmp69_;
			_tmp69_ = since;
			if (_tmp69_ != NULL) {
				ValadocApiNode* _tmp70_;
				_tmp70_ = replacement_symbol;
				_tmp68_ = _tmp70_ == NULL;
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				const gchar* _tmp71_;
				gchar* _tmp72_;
				_tmp71_ = since;
				_tmp72_ = g_strdup_printf ("%s: No replacement specified.", _tmp71_);
				_g_free0 (deprecation_string);
				deprecation_string = _tmp72_;
			} else {
				gboolean _tmp73_ = FALSE;
				const gchar* _tmp74_;
				_tmp74_ = since;
				if (_tmp74_ == NULL) {
					ValadocApiNode* _tmp75_;
					_tmp75_ = replacement_symbol;
					_tmp73_ = _tmp75_ != NULL;
				} else {
					_tmp73_ = FALSE;
				}
				if (_tmp73_) {
					ValadocApiNode* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					gchar* _tmp79_;
					_tmp76_ = replacement_symbol;
					_tmp77_ = gtkdoc_get_gtkdoc_link (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = g_strdup_printf ("Replaced by %s.", _tmp78_);
					_g_free0 (deprecation_string);
					deprecation_string = _tmp79_;
					_g_free0 (_tmp78_);
				} else {
					ValadocErrorReporter* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					_tmp80_ = self->priv->reporter;
					_tmp81_ = valadoc_api_node_get_full_name ((ValadocApiNode*) sym);
					_tmp82_ = _tmp81_;
					valadoc_error_reporter_simple_warning (_tmp80_, "GtkDoc", "Missing ‘since’ and ‘replacement’ arguments to ‘Deprecated’ attribute " \
"on %s.", _tmp82_);
					_g_free0 (_tmp82_);
				}
			}
		}
		_tmp83_ = gcomment->versioning;
		_tmp84_ = deprecation_string;
		_tmp85_ = gtkdoc_header_new ("Deprecated", _tmp84_, DBL_MAX, TRUE);
		_tmp86_ = _tmp85_;
		vala_collection_add ((ValaCollection*) _tmp83_, _tmp86_);
		_gtkdoc_header_unref0 (_tmp86_);
		_g_free0 (deprecation_string);
		_g_object_unref0 (replacement_symbol);
		_g_free0 (replacement_symbol_name);
		_g_free0 (since);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_object_unref0 (deprecated);
		_g_object_unref0 (version);
	}
}

GtkdocGenerator*
gtkdoc_generator_construct (GType object_type)
{
	GtkdocGenerator * self = NULL;
	self = (GtkdocGenerator*) valadoc_api_visitor_construct (object_type);
	return self;
}

GtkdocGenerator*
gtkdoc_generator_new (void)
{
	return gtkdoc_generator_construct (GTKDOC_TYPE_GENERATOR);
}

static void
gtkdoc_generator_file_data_register_section_line (GtkdocGeneratorFileData* self,
                                                  const gchar* line)
{
	g_return_if_fail (self != NULL);
	if (line != NULL) {
		ValaList* _tmp0_;
		_tmp0_ = self->section_lines;
		vala_collection_add ((ValaCollection*) _tmp0_, line);
	}
}

static void
gtkdoc_generator_file_data_register_standard_section_line (GtkdocGeneratorFileData* self,
                                                           const gchar* line)
{
	g_return_if_fail (self != NULL);
	if (line != NULL) {
		ValaList* _tmp0_;
		_tmp0_ = self->standard_section_lines;
		vala_collection_add ((ValaCollection*) _tmp0_, line);
	}
}

static void
gtkdoc_generator_file_data_register_private_section_line (GtkdocGeneratorFileData* self,
                                                          const gchar* line)
{
	g_return_if_fail (self != NULL);
	if (line != NULL) {
		ValaList* _tmp0_;
		_tmp0_ = self->private_section_lines;
		vala_collection_add ((ValaCollection*) _tmp0_, line);
	}
}

static GtkdocGeneratorFileData*
gtkdoc_generator_file_data_construct (GType object_type)
{
	GtkdocGeneratorFileData* self = NULL;
	self = (GtkdocGeneratorFileData*) g_type_create_instance (object_type);
	return self;
}

static GtkdocGeneratorFileData*
gtkdoc_generator_file_data_new (void)
{
	return gtkdoc_generator_file_data_construct (GTKDOC_GENERATOR_TYPE_FILE_DATA);
}

static void
gtkdoc_generator_value_file_data_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_generator_value_file_data_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_generator_file_data_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_generator_value_file_data_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_generator_file_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_generator_value_file_data_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_generator_value_file_data_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocGeneratorFileData * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_generator_file_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_generator_value_file_data_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	GtkdocGeneratorFileData ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_generator_file_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gtkdoc_generator_param_spec_file_data (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	GtkdocGeneratorParamSpecFileData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_GENERATOR_TYPE_FILE_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gtkdoc_generator_value_get_file_data (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_GENERATOR_TYPE_FILE_DATA), NULL);
	return value->data[0].v_pointer;
}

static void
gtkdoc_generator_value_set_file_data (GValue* value,
                                      gpointer v_object)
{
	GtkdocGeneratorFileData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_GENERATOR_TYPE_FILE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_GENERATOR_TYPE_FILE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_generator_file_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_generator_file_data_unref (old);
	}
}

static void
gtkdoc_generator_value_take_file_data (GValue* value,
                                       gpointer v_object)
{
	GtkdocGeneratorFileData * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_GENERATOR_TYPE_FILE_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_GENERATOR_TYPE_FILE_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_generator_file_data_unref (old);
	}
}

static void
gtkdoc_generator_file_data_class_init (GtkdocGeneratorFileDataClass * klass,
                                       gpointer klass_data)
{
	gtkdoc_generator_file_data_parent_class = g_type_class_peek_parent (klass);
	((GtkdocGeneratorFileDataClass *) klass)->finalize = gtkdoc_generator_file_data_finalize;
}

static void
gtkdoc_generator_file_data_instance_init (GtkdocGeneratorFileData * self,
                                          gpointer klass)
{
	self->ref_count = 1;
}

static void
gtkdoc_generator_file_data_finalize (GtkdocGeneratorFileData * obj)
{
	GtkdocGeneratorFileData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_GENERATOR_TYPE_FILE_DATA, GtkdocGeneratorFileData);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filename);
	_g_free0 (self->title);
	_gtkdoc_gcomment_unref0 (self->section_comment);
	_vala_iterable_unref0 (self->comments);
	_vala_iterable_unref0 (self->section_lines);
	_vala_iterable_unref0 (self->standard_section_lines);
	_vala_iterable_unref0 (self->private_section_lines);
}

static GType
gtkdoc_generator_file_data_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gtkdoc_generator_value_file_data_init, gtkdoc_generator_value_file_data_free_value, gtkdoc_generator_value_file_data_copy_value, gtkdoc_generator_value_file_data_peek_pointer, "p", gtkdoc_generator_value_file_data_collect_value, "p", gtkdoc_generator_value_file_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocGeneratorFileDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_generator_file_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGeneratorFileData), 0, (GInstanceInitFunc) gtkdoc_generator_file_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gtkdoc_generator_file_data_type_id;
	gtkdoc_generator_file_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocGeneratorFileData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gtkdoc_generator_file_data_type_id;
}

static GType
gtkdoc_generator_file_data_get_type (void)
{
	static volatile gsize gtkdoc_generator_file_data_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_generator_file_data_type_id__volatile)) {
		GType gtkdoc_generator_file_data_type_id;
		gtkdoc_generator_file_data_type_id = gtkdoc_generator_file_data_get_type_once ();
		g_once_init_leave (&gtkdoc_generator_file_data_type_id__volatile, gtkdoc_generator_file_data_type_id);
	}
	return gtkdoc_generator_file_data_type_id__volatile;
}

static gpointer
gtkdoc_generator_file_data_ref (gpointer instance)
{
	GtkdocGeneratorFileData * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gtkdoc_generator_file_data_unref (gpointer instance)
{
	GtkdocGeneratorFileData * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_GENERATOR_FILE_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
gtkdoc_generator_class_init (GtkdocGeneratorClass * klass,
                             gpointer klass_data)
{
	gtkdoc_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GtkdocGenerator_private_offset);
	((ValadocApiVisitorClass *) klass)->visit_tree = (void (*) (ValadocApiVisitor*, ValadocApiTree*)) gtkdoc_generator_real_visit_tree;
	((ValadocApiVisitorClass *) klass)->visit_package = (void (*) (ValadocApiVisitor*, ValadocApiPackage*)) gtkdoc_generator_real_visit_package;
	((ValadocApiVisitorClass *) klass)->visit_namespace = (void (*) (ValadocApiVisitor*, ValadocApiNamespace*)) gtkdoc_generator_real_visit_namespace;
	((ValadocApiVisitorClass *) klass)->visit_interface = (void (*) (ValadocApiVisitor*, ValadocApiInterface*)) gtkdoc_generator_real_visit_interface;
	((ValadocApiVisitorClass *) klass)->visit_class = (void (*) (ValadocApiVisitor*, ValadocApiClass*)) gtkdoc_generator_real_visit_class;
	((ValadocApiVisitorClass *) klass)->visit_struct = (void (*) (ValadocApiVisitor*, ValadocApiStruct*)) gtkdoc_generator_real_visit_struct;
	((ValadocApiVisitorClass *) klass)->visit_error_domain = (void (*) (ValadocApiVisitor*, ValadocApiErrorDomain*)) gtkdoc_generator_real_visit_error_domain;
	((ValadocApiVisitorClass *) klass)->visit_error_code = (void (*) (ValadocApiVisitor*, ValadocApiErrorCode*)) gtkdoc_generator_real_visit_error_code;
	((ValadocApiVisitorClass *) klass)->visit_enum = (void (*) (ValadocApiVisitor*, ValadocApiEnum*)) gtkdoc_generator_real_visit_enum;
	((ValadocApiVisitorClass *) klass)->visit_enum_value = (void (*) (ValadocApiVisitor*, ValadocApiEnumValue*)) gtkdoc_generator_real_visit_enum_value;
	((ValadocApiVisitorClass *) klass)->visit_property = (void (*) (ValadocApiVisitor*, ValadocApiProperty*)) gtkdoc_generator_real_visit_property;
	((ValadocApiVisitorClass *) klass)->visit_field = (void (*) (ValadocApiVisitor*, ValadocApiField*)) gtkdoc_generator_real_visit_field;
	((ValadocApiVisitorClass *) klass)->visit_constant = (void (*) (ValadocApiVisitor*, ValadocApiConstant*)) gtkdoc_generator_real_visit_constant;
	((ValadocApiVisitorClass *) klass)->visit_delegate = (void (*) (ValadocApiVisitor*, ValadocApiDelegate*)) gtkdoc_generator_real_visit_delegate;
	((ValadocApiVisitorClass *) klass)->visit_signal = (void (*) (ValadocApiVisitor*, ValadocApiSignal*)) gtkdoc_generator_real_visit_signal;
	((ValadocApiVisitorClass *) klass)->visit_method = (void (*) (ValadocApiVisitor*, ValadocApiMethod*)) gtkdoc_generator_real_visit_method;
	((ValadocApiVisitorClass *) klass)->visit_formal_parameter = (void (*) (ValadocApiVisitor*, ValadocApiParameter*)) gtkdoc_generator_real_visit_formal_parameter;
	G_OBJECT_CLASS (klass)->get_property = _vala_gtkdoc_generator_get_property;
	G_OBJECT_CLASS (klass)->finalize = gtkdoc_generator_finalize;
}

static void
gtkdoc_generator_instance_init (GtkdocGenerator * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashMap* _tmp5_;
	self->priv = gtkdoc_generator_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_DBUS_TYPE_INTERFACE, (GBoxedCopyFunc) gtkdoc_dbus_interface_ref, (GDestroyNotify) gtkdoc_dbus_interface_unref, _tmp0_);
	self->dbus_interfaces = (ValaList*) _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GTKDOC_GENERATOR_TYPE_FILE_DATA, (GBoxedCopyFunc) gtkdoc_generator_file_data_ref, (GDestroyNotify) gtkdoc_generator_file_data_unref, _tmp2_, _tmp3_, _tmp4_);
	self->priv->files_data = (ValaMap*) _tmp5_;
}

static void
gtkdoc_generator_finalize (GObject * obj)
{
	GtkdocGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_GENERATOR, GtkdocGenerator);
	_vala_iterable_unref0 (self->dbus_interfaces);
	_g_object_unref0 (self->priv->reporter);
	_g_object_unref0 (self->priv->settings);
	_vala_map_unref0 (self->priv->files_data);
	_g_free0 (self->priv->current_cname);
	_vala_iterable_unref0 (self->priv->current_headers);
	_valadoc_api_tree_unref0 (self->priv->current_tree);
	_g_object_unref0 (self->priv->current_class);
	_g_object_unref0 (self->priv->current_method);
	_g_object_unref0 (self->priv->current_delegate);
	_g_object_unref0 (self->priv->current_signal);
	_gtkdoc_dbus_interface_unref0 (self->priv->current_dbus_interface);
	_gtkdoc_dbus_member_unref0 (self->priv->current_dbus_member);
	G_OBJECT_CLASS (gtkdoc_generator_parent_class)->finalize (obj);
}

static GType
gtkdoc_generator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GtkdocGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocGenerator), 0, (GInstanceInitFunc) gtkdoc_generator_instance_init, NULL };
	GType gtkdoc_generator_type_id;
	gtkdoc_generator_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "GtkdocGenerator", &g_define_type_info, 0);
	GtkdocGenerator_private_offset = g_type_add_instance_private (gtkdoc_generator_type_id, sizeof (GtkdocGeneratorPrivate));
	return gtkdoc_generator_type_id;
}

GType
gtkdoc_generator_get_type (void)
{
	static volatile gsize gtkdoc_generator_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_generator_type_id__volatile)) {
		GType gtkdoc_generator_type_id;
		gtkdoc_generator_type_id = gtkdoc_generator_get_type_once ();
		g_once_init_leave (&gtkdoc_generator_type_id__volatile, gtkdoc_generator_type_id);
	}
	return gtkdoc_generator_type_id__volatile;
}

static void
_vala_gtkdoc_generator_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GtkdocGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GTKDOC_TYPE_GENERATOR, GtkdocGenerator);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

