// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GDKMM_DRAG_H
#define _GDKMM_DRAG_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdkmm/enums.h>
#include <glibmm/object.h>
#include <gdk/gdk.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkDrag = struct _GdkDrag;
using GdkDragClass = struct _GdkDragClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Drag_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class ContentFormats;
class ContentProvider;
class Device;
class Display;
class Surface;

/** @addtogroup gdkmmEnums gdkmm Enums and Flags */

/** 
 *  @var DragCancelReason NO_TARGET
 * There is no suitable drop target.
 * 
 *  @var DragCancelReason USER_CANCELLED
 * Drag cancelled by the user.
 * 
 *  @var DragCancelReason ERROR
 * Unspecified error.
 * 
 *  @enum DragCancelReason
 * 
 * Used in Gdk::Drag to the reason of a cancelled DND operation.
 *
 * @ingroup gdkmmEnums
 */
enum class DragCancelReason
{
  NO_TARGET,
  USER_CANCELLED,
  ERROR
};


} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::DragCancelReason> : public Glib::Value_Enum<Gdk::DragCancelReason>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{


/** A %Gdk::Drag holds information about a drag in progress.
 * It is used on both source and destination sides.
 */

class Drag : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Drag;
  using CppClassType = Drag_Class;
  using BaseObjectType = GdkDrag;
  using BaseClassType = GdkDragClass;

  // noncopyable
  Drag(const Drag&) = delete;
  Drag& operator=(const Drag&) = delete;

private:  friend class Drag_Class;
  static CppClassType drag_class_;

protected:
  explicit Drag(const Glib::ConstructParams& construct_params);
  explicit Drag(GdkDrag* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Drag(Drag&& src) noexcept;
  Drag& operator=(Drag&& src) noexcept;

  ~Drag() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDrag*       gobj()       { return reinterpret_cast<GdkDrag*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDrag* gobj() const { return reinterpret_cast<GdkDrag*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDrag* gobj_copy();

private:


public:
  // The Gtk::DnD namespace contains functions that logically are Gdk::Drag methods.
  // However, they can't be members of Gdk::Drag, because they depend on code in
  // the gtk part of gtk+. Such a dependency is not allowed in a Gdk class.

  
  /** Gets the Gdk::Display that the drag object was created for.
   * 
   * @return A Gdk::Display.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Gets the Gdk::Display that the drag object was created for.
   * 
   * @return A Gdk::Display.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Returns the Gdk::Device associated to the GdkDrag object.
   * 
   * @return The Gdk::Device associated to @a drag.
   */
  Glib::RefPtr<Device> get_device();
  
  /** Returns the Gdk::Device associated to the GdkDrag object.
   * 
   * @return The Gdk::Device associated to @a drag.
   */
  Glib::RefPtr<const Device> get_device() const;

  
  /** Retrieves the formats supported by this GdkDrag object.
   * 
   * @return A Gdk::ContentFormats.
   */
  Glib::RefPtr<ContentFormats> get_formats();
  
  /** Retrieves the formats supported by this GdkDrag object.
   * 
   * @return A Gdk::ContentFormats.
   */
  Glib::RefPtr<const ContentFormats> get_formats() const;

  
  /** Determines the bitmask of possible actions proposed by the source.
   * 
   * @return The Gdk::DragAction flags.
   */
  DragAction get_actions() const;
  
  /** Determines the action chosen by the drag destination.
   * 
   * @return A Gdk::DragAction value.
   */
  DragAction get_selected_action() const;
  
  /** Checks if @a action represents a single action or if it
   * includes multiple flags that can be selected from.
   * 
   * When @a action is 0 - ie no action was given, <tt>true</tt>
   * is returned.
   * 
   * @param action A Gdk::DragAction.
   * @return <tt>true</tt> if exactly one action was given.
   */
  static bool action_is_unique(DragAction action);

  
  /** Inform GDK if the drop ended successfully. Passing <tt>false</tt>
   * for @a success may trigger a drag cancellation animation.
   * 
   * This function is called by the drag source, and should
   * be the last call before dropping the reference to the
   *  @a drag.
   * 
   * The Gdk::Drag will only take the first drop_done()
   * call as effective, if this function is called multiple times,
   * all subsequent calls will be ignored.
   * 
   * @param success Whether the drag was ultimatively successful.
   */
  void drag_drop_done(bool success);

  // No unconst version of get_drag_surface(). The surface is owned by the Drag, and shall not be changed by the caller.
  
  /** Returns the surface on which the drag icon should be rendered
   * during the drag operation. Note that the surface may not be
   * available until the drag operation has begun. GDK will move
   * the surface in accordance with the ongoing drag operation.
   * The surface is owned by @a drag and will be destroyed when
   * the drag operation is over.
   * 
   * @return The drag surface, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Surface> get_drag_surface() const;

  
  /** Sets the position of the drag surface that will be kept
   * under the cursor hotspot. Initially, the hotspot is at the
   * top left corner of the drag surface.
   * 
   * @param hot_x X coordinate of the drag surface hotspot.
   * @param hot_y Y coordinate of the drag surface hotspot.
   */
  void set_hotspot(int hot_x, int hot_y);

  /** The Gdk::ContentProvider.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentProvider> > property_content() const;


  /** The Gdk::Device that is performing the drag.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Device> > property_device() const;


  /** The Gdk::Display that the drag belongs to.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > property_display() const;


  /** The possible formats that the drag can provide its data in.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentFormats> > property_formats() const;


  /** The currently selected action.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< DragAction > property_selected_action() ;

/** The currently selected action.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DragAction > property_selected_action() const;

  /** The possible actions.
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< DragAction > property_actions() ;

/** The possible actions.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< DragAction > property_actions() const;

  /** The surface where the drag originates.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Surface> > property_surface() const;


  // no_default_handler because GdkDragClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%cancel(DragCancelReason reason)</tt>
   *
   * Flags: Run Last
   *
   * The drag operation was cancelled.
   * 
   * @param reason The reason the drag was cancelled.
   */

  Glib::SignalProxy<void(DragCancelReason)> signal_cancel();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%drop_performed()</tt>
   *
   * Flags: Run Last
   *
   * The drag operation was performed on an accepting client.
   */

  Glib::SignalProxy<void()> signal_drop_performed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%dnd_finished()</tt>
   *
   * Flags: Run Last
   *
   * The drag operation was finished, the destination
   * finished reading all data. The drag object can now
   * free all miscellaneous data.
   */

  Glib::SignalProxy<void()> signal_dnd_finished();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Drag
   */
  Glib::RefPtr<Gdk::Drag> wrap(GdkDrag* object, bool take_copy = false);
}


#endif /* _GDKMM_DRAG_H */

