// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_WINDOW_H
#define _GTKMM_WINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <vector>

#include <glibmm/object.h>
#include <gdkmm/texture.h>
#include <gtkmm/bin.h>
#include <gtkmm/native.h>
#include <gtkmm/root.h>
#include <gtkmm/application.h>
#include <gtkmm/windowgroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkWindow = struct _GtkWindow;
using GtkWindowClass = struct _GtkWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Window_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{
class ListModel;
}

namespace Gtk
{

class AccelGroup;
class WindowGroup;

/** Toplevel %Window.
 * This represents all widgets which are physical windows controlled
 * by the window manager.
 *
 * The window will be hidden when the window manager's close button is clicked.
 * Override on_delete_event() to stop this.
 *
 * Gtk::manage() has no effect on Windows because they have no parent Containers.
 *
 * When a window is closed (hidden), it's removed from its application.
 * This can cause Application::run() to return, if it is the last window.
 *
 * @ingroup Widgets
 */

class Window : public Bin, public Native, public Root
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef GtkWindow BaseObjectType;
  typedef GtkWindowClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // noncopyable
  Window(const Window&) = delete;
  Window& operator=(const Window&) = delete;

  ~Window() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Window_Class;
  static CppClassType window_class_;

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(GtkWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkWindow*       gobj()       { return reinterpret_cast<GtkWindow*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkWindow* gobj() const { return reinterpret_cast<GtkWindow*>(gobject_); }

private:

  
  //TODO: Use gtk_window_set_destroy_with_parent() to allow use of Gtk::manage() with top-level windows, using the transient-parent?

public:
  // Disambiguate calls to get_display(). Use Root::get_display(), not Widget::get_display().
  // gtk_widget_get_display() calls gtk_root_get_display(). There is no reason
  // to call gtk_widget_get_display() from a class that implements GtkRoot.
  using Root::get_display;

  // All constructors are hand-coded, because they connect a signal handler.
  
  
  Window(Window&& src) noexcept;
  Window& operator=(Window&& src) noexcept;

  explicit Window(WindowType type = WindowType::TOPLEVEL);
  

  /** The type of the window.
   *
   * Default value: Gtk::WindowType::TOPLEVEL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< WindowType > property_type() const;


  /** The title of the window.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** The title of the window.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** The :startup-id is a write-only property for setting window's
   * startup notification identifier. See Gtk::Window::set_startup_id()
   * for more details.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_WriteOnly that allows you to set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::ustring > property_startup_id() ;


  /** If <tt>true</tt>, users can resize the window.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_resizable() ;

/** If <tt>true</tt>, users can resize the window.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_resizable() const;

  /** If <tt>true</tt>, the window is modal (other windows are not usable while this one is up).
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** If <tt>true</tt>, the window is modal (other windows are not usable while this one is up).
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The default width of the window, used when initially showing the window.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_width() ;

/** The default width of the window, used when initially showing the window.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_width() const;

  /** The default height of the window, used when initially showing the window.
   *
   * Default value: -1
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_default_height() ;

/** The default height of the window, used when initially showing the window.
   *
   * Default value: -1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_default_height() const;

  /** If this window should be destroyed when the parent is destroyed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_destroy_with_parent() ;

/** If this window should be destroyed when the parent is destroyed.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_destroy_with_parent() const;

  /** If this window should be hidden when the user clicks the close button.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_hide_on_close() ;

/** If this window should be hidden when the user clicks the close button.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_hide_on_close() const;

  /** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input,
   * and should not be set by applications.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_mnemonics_visible() ;

/** Whether mnemonics are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input,
   * and should not be set by applications.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mnemonics_visible() const;

  /** The :icon-name property specifies the name of the themed icon to
   * use as the window icon. See Gtk::IconTheme for more details.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** The :icon-name property specifies the name of the themed icon to
   * use as the window icon. See Gtk::IconTheme for more details.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The display that will display this window.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Display> > property_display() ;

/** The display that will display this window.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Display> > property_display() const;

  /** Whether the toplevel is the current active window.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_active() const;


  /** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * Default value: Gdk::Surface::TypeHint::NORMAL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Surface::TypeHint > property_type_hint() ;

/** Hint to help the desktop environment understand what kind of window this is and how to treat it.
   *
   * Default value: Gdk::Surface::TypeHint::NORMAL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Surface::TypeHint > property_type_hint() const;

  /** Whether the window should be decorated by the window manager.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_decorated() ;

/** Whether the window should be decorated by the window manager.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_decorated() const;

  /** The transient parent of the window. See Gtk::Window::set_transient_for() for
   * more details about transient windows.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Window* > property_transient_for() ;

/** The transient parent of the window. See Gtk::Window::set_transient_for() for
   * more details about transient windows.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Window* > property_transient_for() const;


  /** Whether the window should receive the input focus.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_accept_focus() ;

/** Whether the window should receive the input focus.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_accept_focus() const;

  /** Whether the window should receive the input focus when mapped.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_on_map() ;

/** Whether the window should receive the input focus when mapped.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_on_map() const;

  /** Whether the window frame should have a close button.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_deletable() ;

/** Whether the window frame should have a close button.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_deletable() const;

  /** The Gtk::Application associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the :application property to <tt>nullptr</tt>.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Application> > property_application() ;

/** The Gtk::Application associated with the window.
   * 
   * The application will be kept alive for at least as long as it
   * has any windows associated with it (see Glib::application_hold()
   * for a way to keep it alive without windows).
   * 
   * Normally, the connection between the application and the window
   * will remain until the window is destroyed, but you can explicitly
   * remove it by setting the :application property to <tt>nullptr</tt>.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Application> > property_application() const;

  /** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input
   * and should not be set by applications.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_focus_visible() ;

/** Whether 'focus rectangles' are currently visible in this window.
   * 
   * This property is maintained by GTK+ based on user input
   * and should not be set by applications.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_focus_visible() const;

  /** The widget to which this window is attached.
   * See Gtk::Window::set_attached_to().
   * 
   * Examples of places where specifying this relation is useful are
   * for instance a Gtk::Menu created by a Gtk::ComboBox, a completion
   * popup window created by Gtk::Entry or a typeahead search entry
   * created by Gtk::TreeView.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_attached_to() ;

/** The widget to which this window is attached.
   * See Gtk::Window::set_attached_to().
   * 
   * Examples of places where specifying this relation is useful are
   * for instance a Gtk::Menu created by a Gtk::ComboBox, a completion
   * popup window created by Gtk::Entry or a typeahead search entry
   * created by Gtk::TreeView.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_attached_to() const;

  /** Whether the window is maximized.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_maximized() const;


  /** The default widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_default_widget() ;

/** The default widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_default_widget() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%keys_changed()</tt>
   *
   * Flags: Run First
   *
   * The signal_keys_changed() signal gets emitted when the set of accelerators
   * or mnemonics that are associated with @a window changes.
   */

  Glib::SignalProxy<void()> signal_keys_changed();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%close_request()</tt>
   *
   * Flags: Run Last
   *
   * The signal_close_request() signal is emitted when the user clicks on the close
   * button of the window.
   * 
   * Return: <tt>true</tt> to stop other handlers from being invoked for the signal
   */

  Glib::SignalProxy<bool()> signal_close_request();


  //Keybinding signals:
  
  
  /** Sets the title of the Gtk::Window. The title of a window will be
   * displayed in its title bar; on the X&nbsp;%Window System, the title bar
   * is rendered by the [window manager][gtk-X11-arch],
   * so exactly how the title appears to users may vary
   * according to a user’s exact configuration. The title should help a
   * user distinguish this window from other windows they may have
   * open. A good title might include the application name and current
   * document filename, for example.
   * 
   * @param title Title of the window.
   */
  void set_title(const Glib::ustring& title);

  
  /** Retrieves the title of the window. See set_title().
   * 
   * @return The title of the window, or <tt>nullptr</tt> if none has
   * been set explicitly. The returned string is owned by the widget
   * and must not be modified or freed.
   */
  Glib::ustring get_title() const;

  
  /** Startup notification identifiers are used by desktop environment to 
   * track application startup, to provide user feedback and other 
   * features. This function changes the corresponding property on the
   * underlying GdkSurface. Normally, startup identifier is managed 
   * automatically and you should only use this function in special cases
   * like transferring focus from other processes. You should use this
   * function before calling present() or any equivalent
   * function generating a window map event.
   * 
   * This function is only useful on X11, not with other GTK+ targets.
   * 
   * @param startup_id A string with startup-notification identifier.
   */
  void set_startup_id(const Glib::ustring& startup_id);


  /** Associate @a accel_group with @a window, such that calling
   * gtk_accel_groups_activate() on @a window will activate accelerators
   * in @a accel_group.
   * 
   * @param accel_group A Gtk::AccelGroup.
   */
  void add_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** Reverses the effects of add_accel_group().
   * 
   * @param accel_group A Gtk::AccelGroup.
   */
  void remove_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);

  
  /** If @a focus is not the current focus widget, and is focusable, sets
   * it as the focus widget for the window. To set the focus to a particular
   * widget in the toplevel, it is usually more convenient to use
   * Gtk::Widget::grab_focus() instead of this function.
   * 
   * @param focus Widget to be the new focus widget.
   */
  void set_focus(Gtk::Widget& focus);
  void unset_focus();

  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  `gtk_widget_has_focus (widget)` will
   * not be <tt>true</tt> for the widget.
   * 
   * @return The currently focused widget,
   * or <tt>nullptr</tt> if there is none.
   */
  Widget* get_focus();
  
  /** Retrieves the current focused widget within the window.
   * Note that this is the widget that would have the focus
   * if the toplevel window focused; if the toplevel window
   * is not focused then  `gtk_widget_has_focus (widget)` will
   * not be <tt>true</tt> for the widget.
   * 
   * @return The currently focused widget,
   * or <tt>nullptr</tt> if there is none.
   */
  const Widget* get_focus() const;
  
  /** The default widget is the widget that’s activated when the user
   * presses Enter in a dialog (for example). This function sets or
   * unsets the default widget for a Gtk::Window.
   * 
   * @param default_widget Widget to be the default, or <tt>nullptr</tt>
   * to unset the default widget for the toplevel.
   */
  void set_default_widget(Gtk::Widget& default_widget);
  void unset_default_widget();

  
  /** Returns the default widget for @a window. See
   * gtk_window_set_default() for more details.
   * 
   * @return The default widget, or <tt>nullptr</tt>
   * if there is none.
   */
  Widget* get_default_widget();
  
  /** Returns the default widget for @a window. See
   * gtk_window_set_default() for more details.
   * 
   * @return The default widget, or <tt>nullptr</tt>
   * if there is none.
   */
  const Widget* get_default_widget() const;

  
  /** Dialog windows should be set transient for the main application
   * window they were spawned from. This allows
   * [window managers][gtk-X11-arch] to e.g. keep the
   * dialog on top of the main window, or center the dialog over the
   * main window. Gtk::Dialog::new_with_buttons() and other convenience
   * functions in GTK+ will sometimes call
   * set_transient_for() on your behalf.
   * 
   * Passing <tt>nullptr</tt> for @a parent unsets the current transient window.
   * 
   * This function can also be used to attach a new
   * Gtk::WindowType::POPUP to a Gtk::WindowType::TOPLEVEL parent already mapped
   * on screen so that the Gtk::WindowType::POPUP will be
   * positioned relative to the Gtk::WindowType::TOPLEVEL surface.
   * 
   * On Windows, this function puts the child window on top of the parent,
   * much as the window manager would have done on X.
   * 
   * @param parent Parent window, or <tt>nullptr</tt>.
   */
  void set_transient_for(Window& parent);

  /** Unsets the current transient window.
   * @see set_transient_for().
   * @newin{2,20}
   */
  void unset_transient_for();

  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * 
   * @return The transient parent for this
   * window, or <tt>nullptr</tt> if no transient parent has been set.
   */
  Window* get_transient_for();
  
  /** Fetches the transient parent for this window. See
   * set_transient_for().
   * 
   * @return The transient parent for this
   * window, or <tt>nullptr</tt> if no transient parent has been set.
   */
  const Window* get_transient_for() const;

  /** Unsets the attached-to widget.
   * @see set_attached_to().
   * @newin{3,4}
   */
  void unset_attached_to();

  
  /** Marks @a window as attached to @a attach_widget. This creates a logical binding
   * between the window and the widget it belongs to, which is used by GTK+ to
   * propagate information such as styling or accessibility to @a window as if it
   * was a children of @a attach_widget.
   * 
   * Examples of places where specifying this relation is useful are for instance
   * a Gtk::Menu created by a Gtk::ComboBox, a completion popup window
   * created by Gtk::Entry or a typeahead search entry created by Gtk::TreeView.
   * 
   * Note that this function should not be confused with
   * set_transient_for(), which specifies a window manager relation
   * between two toplevels instead.
   * 
   * Passing <tt>nullptr</tt> for @a attach_widget detaches the window.
   * 
   * @param attach_widget A Gtk::Widget, or <tt>nullptr</tt>.
   */
  void set_attached_to(Widget& attach_widget);

  
  /** Fetches the attach widget for this window. See
   * set_attached_to().
   * 
   * @return The widget where the window
   * is attached, or <tt>nullptr</tt> if the window is not attached to any widget.
   */
  Widget* get_attached_to();
  
  /** Fetches the attach widget for this window. See
   * set_attached_to().
   * 
   * @return The widget where the window
   * is attached, or <tt>nullptr</tt> if the window is not attached to any widget.
   */
  const Widget* get_attached_to() const;

  
  /** By setting the type hint for the window, you allow the window
   * manager to decorate and handle the window in a way which is
   * suitable to the function of the window in your application.
   * 
   * This function should be called before the window becomes visible.
   * 
   * Gtk::Dialog::new_with_buttons() and other convenience functions in GTK+
   * will sometimes call set_type_hint() on your behalf.
   * 
   * @param hint The window type.
   */
  void set_type_hint(Gdk::Surface::TypeHint hint);
  
  /** Gets the type hint for this window. See set_type_hint().
   * 
   * @return The type hint for @a window.
   */
  Gdk::Surface::TypeHint get_type_hint() const;

  
  /** Windows may set a hint asking the desktop environment not to receive
   * the input focus. This function sets this hint.
   * 
   * @param setting <tt>true</tt> to let this window receive input focus.
   */
  void set_accept_focus(bool setting =  true);
  
  /** Gets the value set by set_accept_focus().
   * 
   * @return <tt>true</tt> if window should receive the input focus.
   */
  bool get_accept_focus() const;
  
  /** Windows may set a hint asking the desktop environment not to receive
   * the input focus when the window is mapped.  This function sets this
   * hint.
   * 
   * @param setting <tt>true</tt> to let this window receive input focus on map.
   */
  void set_focus_on_map(bool setting =  true);
  
  /** Gets the value set by set_focus_on_map().
   * 
   * @return <tt>true</tt> if window should receive the input focus when
   * mapped.
   */
  bool get_focus_on_map() const;

  //_WRAP_METHOD(void set_destroy_with_parent(bool setting = true), gtk_window_set_destroy_with_parent)
  // I don't that that this is ever a good thing for C++.murrayc.

  //TODO: Remove?
  
  /** Returns whether the window will be destroyed with its transient parent. See
   * set_destroy_with_parent().
   * 
   * @return <tt>true</tt> if the window will be destroyed with its transient parent.
   */
  bool get_destroy_with_parent() const;
  // I don't that that this is ever a good thing for C++.murrayc.

  
  /** If @a setting is <tt>true</tt>, then clicking the close button on the window
   * will not destroy it, but only hide it.
   * 
   * @param setting Whether to hide the window when it is closed.
   */
  void set_hide_on_close(bool setting =  true);
  
  /** Returns whether the window will be hidden when the close button is clicked.
   * 
   * @return <tt>true</tt> if the window will be hidden.
   */
  bool get_hide_on_close() const;

  
  /** Sets the Gtk::Window::property_mnemonics_visible() property.
   * 
   * @param setting The new value.
   */
  void set_mnemonics_visible(bool setting =  true);
  
  /** Gets the value of the Gtk::Window::property_mnemonics_visible() property.
   * 
   * @return <tt>true</tt> if mnemonics are supposed to be visible
   * in this window.
   */
  bool get_mnemonics_visible() const;

  
  /** Sets the Gtk::Window::property_focus_visible() property.
   * 
   * @param setting The new value.
   */
  void set_focus_visible(bool setting =  true);
  
  /** Gets the value of the Gtk::Window::property_focus_visible() property.
   * 
   * @return <tt>true</tt> if “focus rectangles” are supposed to be visible
   * in this window.
   */
  bool get_focus_visible() const;

  
  /** Sets whether the user can resize a window. Windows are user resizable
   * by default.
   * 
   * @param resizable <tt>true</tt> if the user can resize this window.
   */
  void set_resizable(bool resizable =  true);

  
  /** Gets the value set by set_resizable().
   * 
   * @return <tt>true</tt> if the user can resize the window.
   */
  bool get_resizable() const;

  
  /** Sets the Gdk::Display where the @a window is displayed; if
   * the window is already mapped, it will be unmapped, and
   * then remapped on the new display.
   * 
   * @param display A Gdk::Display.
   */
  void set_display(const Glib::RefPtr<Gdk::Display>& display);

  
  /** Returns whether the window is part of the current active toplevel.
   * (That is, the toplevel window receiving keystrokes.)
   * The return value is <tt>true</tt> if the window is active toplevel itself.
   * You might use this function if you wanted to draw a widget
   * differently in an active window from a widget in an inactive window.
   * 
   * @return <tt>true</tt> if the window part of the current active window.
   */
  bool is_active() const;

  
  /** By default, windows are decorated with a title bar, resize
   * controls, etc.  Some [window managers][gtk-X11-arch]
   * allow GTK+ to disable these decorations, creating a
   * borderless window. If you set the decorated property to <tt>false</tt>
   * using this function, GTK+ will do its best to convince the window
   * manager not to decorate the window. Depending on the system, this
   * function may not have any effect when called on a window that is
   * already visible, so you should call it before calling Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window manager
   * policy involved.
   * 
   * @param setting <tt>true</tt> to decorate the window.
   */
  void set_decorated(bool setting =  true);
  
  /** Returns whether the window has been set to have decorations
   * such as a title bar via set_decorated().
   * 
   * @return <tt>true</tt> if the window has been set to have decorations.
   */
  bool get_decorated() const;

  
  /** By default, windows have a close button in the window frame. Some 
   * [window managers][gtk-X11-arch] allow GTK+ to 
   * disable this button. If you set the deletable property to <tt>false</tt>
   * using this function, GTK+ will do its best to convince the window
   * manager not to show a close button. Depending on the system, this
   * function may not have any effect when called on a window that is
   * already visible, so you should call it before calling Gtk::Widget::show().
   * 
   * On Windows, this function always works, since there’s no window manager
   * policy involved.
   * 
   * @param setting <tt>true</tt> to decorate the window as deletable.
   */
  void set_deletable(bool setting =  true);
  
  /** Returns whether the window has been set to have a close button
   * via set_deletable().
   * 
   * @return <tt>true</tt> if the window has been set to have a close button.
   */
  bool get_deletable() const;

  
  /** Sets the icon for the window from a named themed icon.
   * See the docs for Gtk::IconTheme for more details.
   * On some platforms, the window icon is not used at all.
   * 
   * Note that this has nothing to do with the WM_ICON_NAME 
   * property which is mentioned in the ICCCM.
   * 
   * @newin{2,18}
   * 
   * @param name The name of the themed icon.
   */
  void set_icon_name(const Glib::ustring& name);
  
  /** Returns the name of the themed icon for the window,
   * see set_icon_name().
   * 
   * @return The icon name or <tt>nullptr</tt> if the window has
   * no themed icon.
   */
  Glib::ustring get_icon_name() const;

  
  /** Sets an icon to be used as fallback for windows that haven't
   * had gtk_window_set_icon_list() called on them from a named
   * themed icon, see set_icon_name().
   * 
   * @param name The name of the themed icon.
   */
  static void set_default_icon_name(const Glib::ustring& name);
  
  /** Returns the fallback icon name for windows that has been set
   * with set_default_icon_name(). The returned
   * string is owned by GTK+ and should not be modified. It
   * is only valid until the next call to
   * set_default_icon_name().
   * 
   * @return The fallback icon name for windows.
   */
  static Glib::ustring get_default_icon_name();
  
  /** By default, after showing the first Gtk::Window, GTK+ calls 
   * gdk_notify_startup_complete().  Call this function to disable 
   * the automatic startup notification. You might do this if your 
   * first window is a splash screen, and you want to delay notification 
   * until after your real main window has been shown, for example.
   * 
   * In that example, you would disable startup notification
   * temporarily, show your splash screen, then re-enable it so that
   * showing the main window would automatically result in notification.
   * 
   * @param setting <tt>true</tt> to automatically do startup notification.
   */
  static void set_auto_startup_notification(bool setting =  true);

  
  /** Sets a window modal or non-modal. Modal windows prevent interaction
   * with other windows in the same application. To keep modal dialogs
   * on top of main application windows, use
   * set_transient_for() to make the dialog transient for the
   * parent; most [window managers][gtk-X11-arch]
   * will then disallow lowering the dialog below the parent.
   * 
   * @param modal Whether the window is modal.
   */
  void set_modal(bool modal =  true);

  
  /** Returns whether the window is modal. See set_modal().
   * 
   * @return <tt>true</tt> if the window is set to be modal and
   * establishes a grab when shown.
   */
  bool get_modal() const;

  
  /** Returns a list of all existing toplevel windows.
   * 
   * If you want to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets or add new ones, be aware that
   * the list of toplevels will change and emit the "items-changed" signal.
   * 
   * @return The list of toplevel widgets.
   */
  static Glib::RefPtr<Gio::ListModel> get_toplevels();
 

  /** Returns a list of all existing toplevel windows. The widgets
   * in the list are not individually referenced. If you want
   * to iterate through the list and perform actions involving
   * callbacks that might destroy the widgets, you must call
   * `g_list_foreach (result, (GFunc)g_object_ref, <tt>nullptr</tt>)` first, and
   * then unref all the widgets afterwards.
   * 
   * @return List of toplevel widgets.
   */
  static std::vector<Window*> list_toplevels();

  
  /** Adds a mnemonic to this window.
   * 
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void add_mnemonic(guint keyval, Widget& target);

  
  /** Removes a mnemonic from this window.
   * 
   * @param keyval The mnemonic.
   * @param target The widget that gets activated by the mnemonic.
   */
  void remove_mnemonic(guint keyval, Widget& target);

  
  /** Activates the targets associated with the mnemonic.
   * 
   * @param keyval The mnemonic.
   * @param modifier The modifiers.
   * @return <tt>true</tt> if the activation is done.
   */
  bool mnemonic_activate(guint keyval, Gdk::ModifierType modifier);

  
  /** Sets the mnemonic modifier for this window.
   * 
   * @param modifier The modifier mask used to activate
   * mnemonics on this window.
   */
  void set_mnemonic_modifier(Gdk::ModifierType modifier);

  
  /** Returns the mnemonic modifier for this window. See
   * set_mnemonic_modifier().
   * 
   * @return The modifier mask used to activate
   * mnemonics on this window.
   */
  Gdk::ModifierType get_mnemonic_modifier();


  /** Presents a window to the user. This function should not be used
   * as when it is called, it is too late to gather a valid timestamp
   * to allow focus stealing prevention to work correctly.
   */
  void present();
  
  /** Presents a window to the user. This may mean raising the window
   * in the stacking order, unminimizing it, moving it to the current
   * desktop, and/or giving it the keyboard focus, possibly dependent
   * on the user’s platform, window manager, and preferences.
   * 
   * If @a window is hidden, this function calls Gtk::Widget::show()
   * as well.
   * 
   * This function should be used when the user tries to open a window
   * that’s already open. Say for example the preferences dialog is
   * currently open, and the user chooses Preferences from the menu
   * a second time; use present() to move the already-open dialog
   * where the user can see it.
   * 
   * Presents a window to the user in response to a user interaction. The
   * timestamp should be gathered when the window was requested to be shown
   * (when clicking a link for example), rather than once the window is
   * ready to be shown.
   * 
   * @param timestamp The timestamp of the user interaction (typically a 
   * button or key press event) which triggered this call.
   */
  void present(guint32 timestamp);

  
  /** Asks to minimize the specified @a window.
   * 
   * Note that you shouldn’t assume the window is definitely minimized
   * afterward, because the windowing system might not support this
   * functionality; other entities (e.g. the user or the [window manager][gtk-X11-arch])
   * could unminimize it again, or there may not be a window manager in
   * which case minimization isn’t possible, etc.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be minimized before it ever appears
   * onscreen.
   * 
   * You can track result of this operation via the Gdk::Surface::property_state()
   * property.
   */
  void minimize();
  
  /** Asks to unminimize the specified @a window.
   * 
   * Note that you shouldn’t assume the window is definitely unminimized
   * afterward, because the windowing system might not support this
   * functionality; other entities (e.g. the user or the [window manager][gtk-X11-arch])
   * could minimize it again, or there may not be a window manager in
   * which case minimization isn’t possible, etc.
   * 
   * You can track result of this operation via the Gdk::Surface::property_state()
   * property.
   */
  void unminimize();

  
  /** Asks to stick @a window, which means that it will appear on all user
   * desktops. Note that you shouldn’t assume the window is definitely
   * stuck afterward, because other entities (e.g. the user or
   * [window manager][gtk-X11-arch] could unstick it
   * again, and some window managers do not support sticking
   * windows. But normally the window will end up stuck. Just don't
   * write code that crashes if not.
   * 
   * It’s permitted to call this function before showing a window.
   * 
   * You can track result of this operation via the Gdk::Surface::property_state()
   * property.
   */
  void stick();
  
  /** Asks to unstick @a window, which means that it will appear on only
   * one of the user’s desktops. Note that you shouldn’t assume the
   * window is definitely unstuck afterward, because other entities
   * (e.g. the user or [window manager][gtk-X11-arch]) could
   * stick it again. But normally the window will
   * end up stuck. Just don’t write code that crashes if not.
   * 
   * You can track result of this operation via the Gdk::Surface::property_state()
   * property.
   */
  void unstick();

  
  /** Asks to maximize @a window, so that it becomes full-screen. Note that
   * you shouldn’t assume the window is definitely maximized afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could unmaximize it
   * again, and not all window managers support maximization. But
   * normally the window will end up maximized. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be maximized when it appears onscreen
   * initially.
   * 
   * You can track the result of this operation via the Gdk::Surface::property_state()
   * property, or by listening to notifications on the Gtk::Window::property_is_maximized()
   * property.
   */
  void maximize();
  
  /** Asks to unmaximize @a window. Note that you shouldn’t assume the
   * window is definitely unmaximized afterward, because other entities
   * (e.g. the user or [window manager][gtk-X11-arch])
   * could maximize it again, and not all window
   * managers honor requests to unmaximize. But normally the window will
   * end up unmaximized. Just don’t write code that crashes if not.
   * 
   * You can track the result of this operation via the Gdk::Surface::property_state()
   * property, or by listening to notifications on the Gtk::Window::property_is_maximized()
   * property.
   */
  void unmaximize();

  
  /** Asks to place @a window in the fullscreen state. Note that you
   * shouldn’t assume the window is definitely full screen afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could unfullscreen it
   * again, and not all window managers honor requests to fullscreen
   * windows. But normally the window will end up fullscreen. Just
   * don’t write code that crashes if not.
   * 
   * You can track iconification via the Gdk::Surface::property_state() property
   */
  void fullscreen();
  
  /** Asks to toggle off the fullscreen state for @a window. Note that you
   * shouldn’t assume the window is definitely not full screen
   * afterward, because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could fullscreen it
   * again, and not all window managers honor requests to unfullscreen
   * windows. But normally the window will end up restored to its normal
   * state. Just don’t write code that crashes if not.
   * 
   * You can track iconification via the Gdk::Surface::property_state() property
   */
  void unfullscreen();
  
  /** Asks to place @a window in the fullscreen state. Note that you shouldn't assume
   * the window is definitely full screen afterward.
   * 
   * You can track iconification via the Gdk::Surface::property_state() property
   * 
   * @param monitor Which monitor to go fullscreen on.
   */
  void fullscreen_on_monitor(const Glib::RefPtr<Gdk::Monitor>& monitor);
  
  /** Requests that the window is closed, similar to what happens
   * when a window manager close button is clicked.
   * 
   * This function can be used with close buttons in custom
   * titlebars.
   */
  void close();

  
  /** Starts resizing a window. This function is used if an application
   * has window resizing controls.
   * 
   * @param button Mouse button that initiated the drag.
   * @param edge Position of the resize control.
   * @param x X position where the user clicked to initiate the drag, in window coordinates.
   * @param y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_resize_drag(Gdk::SurfaceEdge edge, int button, int x, int y, guint32 timestamp);

  
  /** Starts moving a window. This function is used if an application has
   * window movement grips.
   * 
   * @param button Mouse button that initiated the drag.
   * @param x X position where the user clicked to initiate the drag, in window coordinates.
   * @param y Y position where the user clicked to initiate the drag.
   * @param timestamp Timestamp from the click event that initiated the drag.
   */
  void begin_move_drag(int button, int x, int y, guint32 timestamp);

  
  /** Sets the default size of a window. If the window’s “natural” size
   * (its size request) is larger than the default, the default will be
   * ignored.
   * 
   * Unlike Gtk::Widget::set_size_request(), which sets a size request for
   * a widget and thus would keep users from shrinking the window, this
   * function only sets the initial size, just as if the user had
   * resized the window themselves. Users can still shrink the window
   * again as they normally would. Setting a default size of -1 means to
   * use the “natural” default size (the size request of the window).
   * 
   * For some uses, resize() is a more appropriate function.
   * resize() changes the current size of the window, rather
   * than the size to be used on initial display. resize() always
   * affects the window itself, not the geometry widget.
   * 
   * The default size of a window only affects the first time a window is
   * shown; if a window is hidden and re-shown, it will remember the size
   * it had prior to hiding, rather than using the default size.
   * 
   * Windows can’t actually be 0x0 in size, they must be at least 1x1, but
   * passing 0 for @a width and @a height is OK, resulting in a 1x1 default size.
   * 
   * If you use this function to reestablish a previously saved window size,
   * note that the appropriate size to save is the one returned by
   * get_size(). Using the window allocation directly will not
   * work in all circumstances and can lead to growing or shrinking windows.
   * 
   * @param width Width in pixels, or -1 to unset the default width.
   * @param height Height in pixels, or -1 to unset the default height.
   */
  void set_default_size(int width, int height);

  
  /** Gets the default size of the window. A value of -1 for the width or
   * height indicates that a default size has not been explicitly set
   * for that dimension, so the “natural” size of the window will be
   * used.
   * 
   * @param width Location to store the default width.
   * @param height Location to store the default height.
   */
  void get_default_size(int& width, int& height) const;

  
  /** Resizes the window as if the user had done so, obeying geometry
   * constraints. The default geometry constraint is that windows may
   * not be smaller than their size request; to override this
   * constraint, call Gtk::Widget::set_size_request() to set the window's
   * request to a smaller value.
   * 
   * If resize() is called before showing a window for the
   * first time, it overrides any default size set with
   * set_default_size().
   * 
   * Windows may not be resized smaller than 1 by 1 pixels.
   * 
   * When using client side decorations, GTK+ will do its best to adjust
   * the given size so that the resulting window size matches the
   * requested size without the title bar, borders and shadows added for
   * the client side decorations, but there is no guarantee that the
   * result will be totally accurate because these widgets added for
   * client side decorations depend on the theme and may not be realized
   * or visible at the time resize() is issued.
   * 
   * If the GtkWindow has a titlebar widget (see set_titlebar()), then
   * typically, resize() will compensate for the height of the titlebar
   * widget only if the height is known when the resulting GtkWindow configuration
   * is issued.
   * For example, if new widgets are added after the GtkWindow configuration
   * and cause the titlebar widget to grow in height, this will result in a
   * window content smaller that specified by resize() and not
   * a larger window.
   * 
   * @param width Width in pixels to resize the window to.
   * @param height Height in pixels to resize the window to.
   */
  void resize(int width, int height);

  
  /** Obtains the current size of @a window.
   * 
   * If @a window is not visible on screen, this function return the size GTK+
   * will suggest to the [window manager][gtk-X11-arch] for the initial window
   * size (but this is not reliably the same as the size the window manager
   * will actually select). See: set_default_size().
   * 
   * Depending on the windowing system and the window manager constraints,
   * the size returned by this function may not match the size set using
   * resize(); additionally, since resize() may be
   * implemented as an asynchronous operation, GTK+ cannot guarantee in any
   * way that this code:
   * 
   * 
   * [C example ellipted]
   * 
   * will result in `new_width` and `new_height` matching `width` and
   * `height`, respectively.
   * 
   * This function will return the logical size of the Gtk::Window,
   * excluding the widgets used in client side decorations; there is,
   * however, no guarantee that the result will be completely accurate
   * because client side decoration may include widgets that depend on
   * the user preferences and that may not be visibile at the time you
   * call this function.
   * 
   * The dimensions returned by this function are suitable for being
   * stored across sessions; use set_default_size() to
   * restore them when before showing the window.
   * 
   * To avoid potential race conditions, you should only call this
   * function in response to a size change notification, for instance
   * inside a handler for the Gtk::Widget::signal_size_allocate() signal, or
   * inside a handler for the Gtk::Widget::signal_configure_event() signal:
   * 
   * 
   * [C example ellipted]
   * 
   * Note that, if you connect to the Gtk::Widget::signal_size_allocate() signal,
   * you should not use the dimensions of the Gtk::Allocation passed to
   * the signal handler, as the allocation may contain client side
   * decorations added by GTK+, depending on the windowing system in
   * use.
   * 
   * If you are getting a window size in order to position the window
   * on the screen, you should, instead, simply set the window’s semantic
   * type with set_type_hint(), which allows the window manager
   * to e.g. center dialogs. Also, if you set the transient parent of
   * dialogs with set_transient_for() window managers will
   * often center the dialog over its parent window. It's much preferred
   * to let the window manager handle these cases rather than doing it
   * yourself, because all apps will behave consistently and according to
   * user or system preferences, if the window manager handles it. Also,
   * the window manager can take into account the size of the window
   * decorations and border that it may add, and of which GTK+ has no
   * knowledge. Additionally, positioning windows in global screen coordinates
   * may not be allowed by the windowing system. For more information,
   * see: gtk_window_set_position().
   * 
   * @param width Return location for width.
   * @param height Return location for height.
   */
  void get_size(int& width, int& height) const;

  
  /** Returns the group for @a window or the default group, if
   *  @a window is <tt>nullptr</tt> or if @a window does not have an explicit
   * window group.
   * 
   * @return The Gtk::WindowGroup for a window or the default group.
   */
  Glib::RefPtr<WindowGroup> get_group();
  
  /** Returns the group for @a window or the default group, if
   *  @a window is <tt>nullptr</tt> or if @a window does not have an explicit
   * window group.
   * 
   * @return The Gtk::WindowGroup for a window or the default group.
   */
  Glib::RefPtr<const WindowGroup> get_group() const;

  
  /** Returns whether @a window has an explicit window group.
   * 
   * @return <tt>true</tt> if @a window has an explicit window group.
   */
  bool has_group() const;

  
  /** Gets the type of the window. See Gtk::WindowType.
   * 
   * @return The type of the window.
   */
  WindowType get_window_type() const;

  
  /** Gets the Gtk::Application associated with the window (if any).
   * 
   * @return A Gtk::Application, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Application> get_application();
  
  /** Gets the Gtk::Application associated with the window (if any).
   * 
   * @return A Gtk::Application, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Application> get_application() const;

  // Concerning the removal of a hidden window from the application, see
  // https://bugzilla.gnome.org/show_bug.cgi?id=639931 and Gtk::Widget_Class::hide_callback().
  
  /** Sets the Gtk::Application associated with the window.
   *
   * The application will be kept alive for at least as long as it has any windows
   * associated with it. (See Gio::Application::hold() for a way to keep it alive
   * without windows.)
   *
   * Normally, the connection between the application and the window will remain
   * until the window is closed (hidden), but you can explicitly remove it by
   * calling unset_application().
   *
   * This is equivalent to calling Gtk::Application::remove_window() and/or
   * Gtk::Application::add_window() on the old/new applications as relevant.
   *
   * @param application A Gtk::Application.
   */
  void set_application(const Glib::RefPtr<Application>& application);

  /** Unsets the Application associated with the window.
   * This could cause the application to exit if it is the application's last window.
   */
  void unset_application();

  
  /** Asks to keep @a window above, so that it stays on top. Note that
   * you shouldn’t assume the window is definitely above afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could not keep it above,
   * and not all window managers support keeping windows above. But
   * normally the window will end kept above. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be kept above when it appears onscreen
   * initially.
   * 
   * You can track iconification via the Gdk::Surface::property_state() property
   * 
   * Note that, according to the
   * [Extended Window Manager Hints Specification](http://www.freedesktop.org/Standards/wm-spec),
   * the above state is mainly meant for user preferences and should not
   * be used by applications e.g. for drawing attention to their
   * dialogs.
   * 
   * @param setting Whether to keep @a window above other windows.
   */
  void set_keep_above(bool setting =  true);
  
  /** Asks to keep @a window below, so that it stays in bottom. Note that
   * you shouldn’t assume the window is definitely below afterward,
   * because other entities (e.g. the user or
   * [window manager][gtk-X11-arch]) could not keep it below,
   * and not all window managers support putting windows below. But
   * normally the window will be kept below. Just don’t write code
   * that crashes if not.
   * 
   * It’s permitted to call this function before showing a window,
   * in which case the window will be kept below when it appears onscreen
   * initially.
   * 
   * You can track iconification via the Gdk::Surface::property_state() property
   * 
   * Note that, according to the
   * [Extended Window Manager Hints Specification](http://www.freedesktop.org/Standards/wm-spec),
   * the above state is mainly meant for user preferences and should not
   * be used by applications e.g. for drawing attention to their
   * dialogs.
   * 
   * @param setting Whether to keep @a window below other windows.
   */
  void set_keep_below(bool setting =  true);

  
  /** Sets a custom titlebar for @a window.
   * 
   * A typical widget used here is Gtk::HeaderBar, as it provides various features
   * expected of a titlebar while allowing the addition of child widgets to it.
   * 
   * If you set a custom titlebar, GTK+ will do its best to convince
   * the window manager not to put its own titlebar on the window.
   * Depending on the system, this function may not work for a window
   * that is already visible, so you set the titlebar before calling
   * Gtk::Widget::show().
   * 
   * @param titlebar The widget to use as titlebar.
   */
  void set_titlebar(Widget& titlebar);

  /** Unsets the titlebar.
   * @see set_titlebar()
   */
  void unset_titlebar();

  
  /** Returns the custom titlebar that has been set with
   * set_titlebar().
   * 
   * @return The custom titlebar, or <tt>nullptr</tt>.
   */
  Widget* get_titlebar();
  
  /** Returns the custom titlebar that has been set with
   * set_titlebar().
   * 
   * @return The custom titlebar, or <tt>nullptr</tt>.
   */
  const Widget* get_titlebar() const;

  
  /** Retrieves the current maximized state of @a window.
   * 
   * Note that since maximization is ultimately handled by the window
   * manager and happens asynchronously to an application request, you
   * shouldn’t assume the return value of this function changing
   * immediately (or at all), as an effect of calling
   * maximize() or unmaximize().
   * 
   * @return Whether the window has a maximized state.
   */
  bool is_maximized() const;

  // from gtk/gtkshow.h:
  
  /** This is a convenience function for launching the default application
   * to show the uri. The uri must be of a form understood by GIO (i.e. you
   * need to install gvfs to get support for uri schemes such as http://
   * or ftp://, as only local files are handled by GIO itself).
   * Typical examples are
   * - `file:///home/gnome/pict.jpg`
   * - `http://www.gnome.org`
   * - `mailto:me @a gnome.org`
   * 
   * Ideally the timestamp is taken from the event triggering
   * the gtk_show_uri_on_window() call. If timestamp is not known you can take
   * GDK_CURRENT_TIME.
   * 
   * This is the recommended call to be used as it passes information
   * necessary for sandbox helpers to parent their dialogs properly.
   * 
   * @newin{3,24}
   * 
   * @param uri The uri to show.
   * @param timestamp A timestamp to prevent focus stealing.
   * 
   * @throws Glib::Error
   */
  void show_uri(const Glib::ustring& uri, guint32 timestamp);

  /** Gets a vector containing each Gtk::AccelGroup associated with the window.
   * @newin{3,24}
   * @return A vector of Gtk::AccelGroup.
   */
  std::vector< Glib::RefPtr<AccelGroup> > get_accel_groups();

  /** Brings the window to the front.
   * This is just a more obvious convenience wrapper for get_surface()->raise().
   */
  void raise();

  ///Overriden to warn that it doesn't make sense to use Gtk::manage() on this class because it has no parent container.
  void set_manage() override;

protected:
  void on_window_hide();

  //See comments in the implementations:
  void destroy_();
  void _release_c_instance();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_keys_changed().
  virtual void on_keys_changed();
  /// This is a default handler for the signal signal_close_request().
  virtual bool on_close_request();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Window
   */
  Gtk::Window* wrap(GtkWindow* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_WINDOW_H */

