// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/picture.h>
#include <gtkmm/private/picture_p.h>

#include <gtk/gtk.h>

/* Copyright (C) 2018 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

namespace Gtk
{

Picture::Picture(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(picture_class_.init()))
{
  gtk_picture_set_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

Picture::Picture(const std::string& filename)
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(picture_class_.init()))
{
  gtk_picture_set_filename(gobj(), Glib::c_str_or_nullptr(filename));
}

} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Picture* wrap(GtkPicture* object, bool take_copy)
{
  return dynamic_cast<Gtk::Picture *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Picture_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Picture_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_picture_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Picture_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Picture_Class::wrap_new(GObject* o)
{
  return manage(new Picture((GtkPicture*)(o)));

}


/* The implementation: */

Picture::Picture(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

Picture::Picture(GtkPicture* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }


Picture::Picture(Picture&& src) noexcept
: Gtk::Widget(std::move(src))
{}

Picture& Picture::operator=(Picture&& src) noexcept
{
  Gtk::Widget::operator=(std::move(src));
  return *this;
}

Picture::~Picture() noexcept
{
  destroy_();
}

Picture::CppClassType Picture::picture_class_; // initialize static member

GType Picture::get_type()
{
  return picture_class_.init().get_type();
}


GType Picture::get_base_type()
{
  return gtk_picture_get_type();
}


Picture::Picture()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(picture_class_.init()))
{
  

}

Picture::Picture(const Glib::RefPtr<Gdk::Paintable>& paintable)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(picture_class_.init(), "paintable", Glib::unwrap(paintable), nullptr))
{
  

}

Picture::Picture(const Glib::RefPtr<Gio::File>& file)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(picture_class_.init(), "file", const_cast<GFile*>(Glib::unwrap<Gio::File>(file)), nullptr))
{
  

}

void Picture::set_paintable(const Glib::RefPtr<Gdk::Paintable>& paintable)
{
  gtk_picture_set_paintable(gobj(), Glib::unwrap(paintable));
}

Glib::RefPtr<Gdk::Paintable> Picture::get_paintable()
{
  auto retvalue = Glib::wrap(gtk_picture_get_paintable(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Paintable> Picture::get_paintable() const
{
  return const_cast<Picture*>(this)->get_paintable();
}

void Picture::set_file(const Glib::RefPtr<const Gio::File>& file)
{
  gtk_picture_set_file(gobj(), const_cast<GFile*>(Glib::unwrap<Gio::File>(file)));
}

Glib::RefPtr<Gio::File> Picture::get_file()
{
  auto retvalue = Glib::wrap(gtk_picture_get_file(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::File> Picture::get_file() const
{
  return const_cast<Picture*>(this)->get_file();
}

void Picture::set_filename(const std::string& filename)
{
  gtk_picture_set_filename(gobj(), filename.c_str());
}

void Picture::set_resource(const std::string& resource_path)
{
  gtk_picture_set_resource(gobj(), resource_path.c_str());
}

void Picture::set_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  gtk_picture_set_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

void Picture::set_keep_aspect_ratio(bool keep_aspect_ratio)
{
  gtk_picture_set_keep_aspect_ratio(gobj(), static_cast<int>(keep_aspect_ratio));
}

bool Picture::get_keep_aspect_ratio() const
{
  return gtk_picture_get_keep_aspect_ratio(const_cast<GtkPicture*>(gobj()));
}

void Picture::set_can_shrink(bool can_shrink)
{
  gtk_picture_set_can_shrink(gobj(), static_cast<int>(can_shrink));
}

bool Picture::get_can_shrink() const
{
  return gtk_picture_get_can_shrink(const_cast<GtkPicture*>(gobj()));
}

void Picture::set_alternative_text(const Glib::ustring& alternative_text)
{
  gtk_picture_set_alternative_text(gobj(), alternative_text.empty() ? nullptr : alternative_text.c_str());
}

Glib::ustring Picture::get_alternative_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_picture_get_alternative_text(const_cast<GtkPicture*>(gobj())));
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gdk::Paintable>>::value,
  "Type Glib::RefPtr<Gdk::Paintable> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> > Picture::property_paintable() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Paintable> >(this, "paintable");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> > Picture::property_paintable() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Paintable> >(this, "paintable");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gio::File>>::value,
  "Type Glib::RefPtr<Gio::File> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gio::File> > Picture::property_file() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gio::File> >(this, "file");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > Picture::property_file() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> >(this, "file");
}

Glib::PropertyProxy< Glib::ustring > Picture::property_alternative_text() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "alternative-text");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Picture::property_alternative_text() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "alternative-text");
}

Glib::PropertyProxy< bool > Picture::property_keep_aspect_ratio() 
{
  return Glib::PropertyProxy< bool >(this, "keep-aspect-ratio");
}

Glib::PropertyProxy_ReadOnly< bool > Picture::property_keep_aspect_ratio() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "keep-aspect-ratio");
}

Glib::PropertyProxy< bool > Picture::property_can_shrink() 
{
  return Glib::PropertyProxy< bool >(this, "can-shrink");
}

Glib::PropertyProxy_ReadOnly< bool > Picture::property_can_shrink() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-shrink");
}


} // namespace Gtk


