// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_EVENTCONTROLLERKEY_H
#define _GTKMM_EVENTCONTROLLERKEY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2018 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/eventcontroller.h>
#include <gdkmm/enums.h>
#include <gdkmm/types.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkEventControllerKey = struct _GtkEventControllerKey;
using GtkEventControllerKeyClass = struct _GtkEventControllerKeyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class EventControllerKey_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Widget;

/** Event controller for key press and key release events.
 *
 * %Gtk::EventControllerKey is an event controller meant to handle
 * key press and key release events from keyboards.
 *
 * @newin{3,94}
 *
 * @ingroup Gestures
 */

class EventControllerKey : public EventController
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = EventControllerKey;
  using CppClassType = EventControllerKey_Class;
  using BaseObjectType = GtkEventControllerKey;
  using BaseClassType = GtkEventControllerKeyClass;

  // noncopyable
  EventControllerKey(const EventControllerKey&) = delete;
  EventControllerKey& operator=(const EventControllerKey&) = delete;

private:  friend class EventControllerKey_Class;
  static CppClassType eventcontrollerkey_class_;

protected:
  explicit EventControllerKey(const Glib::ConstructParams& construct_params);
  explicit EventControllerKey(GtkEventControllerKey* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  EventControllerKey(EventControllerKey&& src) noexcept;
  EventControllerKey& operator=(EventControllerKey&& src) noexcept;

  ~EventControllerKey() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkEventControllerKey*       gobj()       { return reinterpret_cast<GtkEventControllerKey*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkEventControllerKey* gobj() const { return reinterpret_cast<GtkEventControllerKey*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkEventControllerKey* gobj_copy();

private:


protected:
  EventControllerKey();

public:
  
  static Glib::RefPtr<EventControllerKey> create();


  //TODO: GtkIMContext has not (yet) been wrapped in gtkmm.
  //_WRAP_METHOD(void set_im_context(const Glib::RefPtr<Gtk::IMContext>& im_context), gtk_event_controller_key_set_im_context)
  //_WRAP_METHOD(Glib::RefPtr<Gtk::IMContext> get_im_context(), gtk_event_controller_key_get_im_context, refreturn)
  //_WRAP_METHOD(Glib::RefPtr<const Gtk::IMContext> get_im_context(), gtk_event_controller_key_get_im_context, refreturn, constversion)

  
  /** Forwards the current event of this @a controller to a @a widget.
   * 
   * This function can only be used in handlers for the
   * Gtk::EventControllerKey::signal_key_pressed(),
   * Gtk::EventControllerKey::signal_key_released()
   * or
   * Gtk::EventControllerKey::signal_modifiers()
   * signals.
   * 
   * @param widget A Gtk::Widget.
   * @return Whether the @a widget handled the event.
   */
  bool forward(Widget& widget);
  
  /** Gets the key group of the current event of this @a controller.
   * See gdk_event_get_key_group().
   * 
   * @return The key group.
   */
  guint get_group() const;
  
  /** Returns the widget that was holding focus before.
   * 
   * This function can only be used in handlers for the
   * Gtk::EventControllerKey::signal_focus_in() and
   * Gtk::EventControllerKey::signal_focus_out() signals.
   * 
   * @return The previous focus.
   */
  Widget* get_focus_origin();
  
  /** Returns the widget that was holding focus before.
   * 
   * This function can only be used in handlers for the
   * Gtk::EventControllerKey::signal_focus_in() and
   * Gtk::EventControllerKey::signal_focus_out() signals.
   * 
   * @return The previous focus.
   */
  const Widget* get_focus_origin() const;
  
  /** Returns the widget that will be holding focus afterwards.
   * 
   * This function can only be used in handlers for the
   * Gtk::EventControllerKey::signal_focus_in() and
   * Gtk::EventControllerKey::signal_focus_out() signals.
   * 
   * @return The next focus.
   */
  Widget* get_focus_target();
  
  /** Returns the widget that will be holding focus afterwards.
   * 
   * This function can only be used in handlers for the
   * Gtk::EventControllerKey::signal_focus_in() and
   * Gtk::EventControllerKey::signal_focus_out() signals.
   * 
   * @return The next focus.
   */
  const Widget* get_focus_target() const;
  
  /** Returns the value of the GtkEventControllerKey:contains-focus property.
   * 
   * @return <tt>true</tt> if focus is within @a self or one of its children.
   */
  bool contains_focus() const;
  
  /** Returns the value of the GtkEventControllerKey:is-focus property.
   * 
   * @return <tt>true</tt> if focus is within @a self but not one of its children.
   */
  bool is_focus() const;

  // no_default_handler because GtkEventControllerKeyClass is private.
  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%key_pressed(guint keyval, guint keycode, Gdk::ModifierType state)</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever a key is pressed.
   * 
   * @param keyval The pressed key.
   * @param keycode The raw code of the pressed key.
   * @param state The bitmask, representing the state of modifier keys and pointer buttons. See Gdk::ModifierType.
   * @return <tt>true</tt> if the key press was handled, <tt>false</tt> otherwise.
   */

  Glib::SignalProxy<bool(guint, guint, Gdk::ModifierType)> signal_key_pressed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%key_released(guint keyval, guint keycode, Gdk::ModifierType state)</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever a key is released.
   * 
   * @param keyval The released key.
   * @param keycode The raw code of the released key.
   * @param state The bitmask, representing the state of modifier keys and pointer buttons. See Gdk::ModifierType.
   */

  Glib::SignalProxy<void(guint, guint, Gdk::ModifierType)> signal_key_released();

  
  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%modifiers(Gdk::ModifierType state)</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever the state of modifier keys and pointer
   * buttons change.
   * 
   * @param state The bitmask, representing the new state of modifier keys and
   * pointer buttons. See Gdk::ModifierType.
   */

  Glib::SignalProxy<bool(Gdk::ModifierType)> signal_modifiers();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%im_update()</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever the input method context filters away a
   * keypress and prevents the @a controller receiving it. See
   * Gtk::EventControllerKey::set_im_context() and
   * gtk_im_context_filter_keypress().
   */

  Glib::SignalProxy<void()> signal_im_update();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%focus_in(Gdk::CrossingMode mode, Gdk::NotifyType detail)</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever the widget controlled
   * by the @a controller or one of its descendants) is given
   * the keyboard focus.
   * 
   * @param mode Crossing mode indicating what caused this change.
   * @param detail Detail indication where the focus is coming from.
   */

  Glib::SignalProxy<void(Gdk::CrossingMode, Gdk::NotifyType)> signal_focus_in();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%focus_out(Gdk::CrossingMode mode, Gdk::NotifyType detail)</tt>
   *
   * Flags: Run Last
   *
   * This signal is emitted whenever the widget controlled
   * by the @a controller (or one of its descendants) loses
   * the keyboard focus.
   * 
   * @param mode Crossing mode indicating what caused this change.
   * @param detail Detail indication where the focus is going.
   */

  Glib::SignalProxy<void(Gdk::CrossingMode, Gdk::NotifyType)> signal_focus_out();


  /** Whether focus is in the controllers widget itself,
   * opposed to in a descendent widget. See also
   * Gtk::EventControllerKey::property_contains_focus().
   * 
   * When handling focus events, this property is updated
   * before Gtk::EventControllerKey::signal_focus_in() or
   * Gtk::EventControllerKey::signal_focus_out() are emitted.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_is_focus() const;


  /** Whether focus is contain in the controllers widget. See
   * See Gtk::EventControllerKey::property_is_focus() for whether the focus is in the widget itself
   * or inside a descendent.
   * 
   * When handling focus events, this property is updated
   * before Gtk::EventControllerKey::signal_focus_in() or
   * Gtk::EventControllerKey::signal_focus_out() are emitted.
   *
   * Default value: <tt>false</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_contains_focus() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::EventControllerKey
   */
  Glib::RefPtr<Gtk::EventControllerKey> wrap(GtkEventControllerKey* object, bool take_copy = false);
}


#endif /* _GTKMM_EVENTCONTROLLERKEY_H */

