// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_MENUBUTTON_H
#define _GTKMM_MENUBUTTON_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2012 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/widget.h>
#include <gtkmm/popover.h>
#include <giomm/menumodel.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkMenuButton = struct _GtkMenuButton;
using GtkMenuButtonClass = struct _GtkMenuButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class MenuButton_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A widget that shows a menu when clicked on.
 *
 * This menu can be provided either as a Gtk::Menu, a Gtk::Popover or an
 * abstract Gio::MenuModel.
 *
 * The %Gtk::MenuButton widget can show either an icon (set with set_icon_name())
 * or a label (set with set_label()). If neither is explicitly set,
 * a Gtk::Image is automatically created, using an arrow image oriented according
 * to set_direction() or the generic “open-menu-symbolic” icon if the direction
 * is not set.
 *
 * @ingroup Widgets
 * @newin{3,6}
 */

class MenuButton : public Widget
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MenuButton CppObjectType;
  typedef MenuButton_Class CppClassType;
  typedef GtkMenuButton BaseObjectType;
  typedef GtkMenuButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  MenuButton(MenuButton&& src) noexcept;
  MenuButton& operator=(MenuButton&& src) noexcept;

  // noncopyable
  MenuButton(const MenuButton&) = delete;
  MenuButton& operator=(const MenuButton&) = delete;

  ~MenuButton() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class MenuButton_Class;
  static CppClassType menubutton_class_;

protected:
  explicit MenuButton(const Glib::ConstructParams& construct_params);
  explicit MenuButton(GtkMenuButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkMenuButton*       gobj()       { return reinterpret_cast<GtkMenuButton*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkMenuButton* gobj() const { return reinterpret_cast<GtkMenuButton*>(gobject_); }

private:

public:

  MenuButton();

  
  /** Sets the Gtk::Popover that will be popped up when the @a menu_button is clicked,
   * or <tt>nullptr</tt> to dissociate any existing popover and disable the button.
   * 
   * If Gtk::MenuButton::property_menu_model() is set, the menu model is dissociated from the
   *  @a menu_button, and the property is set to <tt>nullptr</tt>.
   * 
   * @param popover A Gtk::Popover, or <tt>nullptr</tt> to unset and disable the button.
   */
  void set_popover(Popover& popover);

  /** Disables the button.
   */
  void unset_popover();

  
  /** Returns the Gtk::Popover that pops out of the button.
   * If the button is not using a Gtk::Popover, this function
   * returns <tt>nullptr</tt>.
   * 
   * @return A Gtk::Popover or <tt>nullptr</tt>.
   */
  Popover* get_popover();
  
  /** Returns the Gtk::Popover that pops out of the button.
   * If the button is not using a Gtk::Popover, this function
   * returns <tt>nullptr</tt>.
   * 
   * @return A Gtk::Popover or <tt>nullptr</tt>.
   */
  const Popover* get_popover() const;

  
  /** Sets the direction in which the popup will be popped up, as
   * well as changing the arrow’s direction. The child will not
   * be changed to an arrow if it was customized.
   * 
   * If the does not fit in the available space in the given direction,
   * GTK+ will its best to keep it inside the screen and fully visible.
   * 
   * If you pass Gtk::ArrowType::NONE for a @a direction, the popup will behave
   * as if you passed Gtk::ArrowType::DOWN (although you won’t see any arrows).
   * 
   * @param direction A Gtk::ArrowType.
   */
  void set_direction(ArrowType direction);
  
  /** Returns the direction the popup will be pointing at when popped up.
   * 
   * @return A Gtk::ArrowType value.
   */
  ArrowType get_direction() const;

  
  /** Sets the Gio::MenuModel from which the popup will be constructed,
   * or <tt>nullptr</tt> to dissociate any existing menu model and disable the button.
   * 
   * A Gtk::Popover will be created from the menu model with Gtk::Popover::menu_new_from_model().
   * Actions will be connected as documented for this function.
   * 
   * If Gtk::MenuButton::property_popover() is already set, it will be dissociated from the @a menu_button,
   * and the property is set to <tt>nullptr</tt>.
   * 
   * @param menu_model A Gio::MenuModel, or <tt>nullptr</tt> to unset and disable the
   * button.
   */
  void set_menu_model(const Glib::RefPtr<const Gio::MenuModel>& menu_model);

  /** Disables the button.
   */
  void unset_menu_model();

  
  /** Returns the Gio::MenuModel used to generate the popup.
   * 
   * @return A Gio::MenuModel or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Gio::MenuModel> get_menu_model();
  
  /** Returns the Gio::MenuModel used to generate the popup.
   * 
   * @return A Gio::MenuModel or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Gio::MenuModel> get_menu_model() const;

  
  /** Sets the Gtk::Widget to use to line the menu with when popped up.
   * Note that the @a align_widget must contain the Gtk::MenuButton itself.
   * 
   * Setting it to <tt>nullptr</tt> means that the menu will be aligned with the
   * button itself.
   * 
   * Note that this property is only used with menus currently,
   * and not for popovers.
   * 
   * @param align_widget A Gtk::Widget.
   */
  void set_align_widget(Widget& align_widget);
  
  /** Returns the parent Gtk::Widget to use to line up with menu.
   * 
   * @return A Gtk::Widget value or <tt>nullptr</tt>.
   */
  Widget* get_align_widget();
  
  /** Returns the parent Gtk::Widget to use to line up with menu.
   * 
   * @return A Gtk::Widget value or <tt>nullptr</tt>.
   */
  const Widget* get_align_widget() const;

  
  /** Sets the name of an icon to show inside the menu button.
   * 
   * @param icon_name The icon name.
   */
  void set_icon_name(const Glib::ustring& icon_name);
  
  /** Gets the name of the icon shown in the button.
   * 
   * @return The name of the icon shown in the button.
   */
  Glib::ustring get_icon_name() const;

  
  /** Sets the label to show inside the menu button.
   * 
   * @param label The label.
   */
  void set_label(const Glib::ustring& label);
  
  /** Gets the label shown in the button
   * 
   * @return The label shown in the button.
   */
  Glib::ustring get_label() const;

  
  /** Sets the relief style of the edges of the given
   * Gtk::MenuButton widget.
   * 
   * Two styles exist, Gtk::ReliefStyle::NORMAL and Gtk::ReliefStyle::NONE.
   * The default style is, as one can guess, Gtk::ReliefStyle::NORMAL.
   * 
   * @param relief The GtkReliefStyle as described above.
   */
  void set_relief(ReliefStyle relief);
  
  /** Returns the current relief style of the given Gtk::MenuButton.
   * 
   * @return The current Gtk::ReliefStyle.
   */
  ReliefStyle get_relief() const;

  
  /** Pop up the menu.
   */
  void popup();
  
  /** Dismiss the menu.
   */
  void popdown();

  /** Slot to create a popup for the %MenuButton on demand.
   *
   * This slot is called when the popoup of the %MenuButton is shown, but none has
   * been provided via set_popup(), set_popover() or set_menu_model().
   */
  using SlotCreatePopup = sigc::slot<void()>;

  /** Sets @a slot to be called when a popup is about to be shown.
   *
   *  @a slot should use one of
   *
   * - set_popup()
   * - set_popover()
   * - set_menu_model()
   *
   * to set a popup for the %MenuButton.
   * The %MenuButton will always be sensitive.
   *
   * Using this method will NOT reset the menu widget attached to the %MenuButton.
   * Instead, this can be done manually in @a slot.
   *
   * @param slot Slot to call when a popup is about to be shown, but none
   *             has been provided via other means.
   * @newin{3,96}
   */
  void set_create_popup_func(const SlotCreatePopup& slot);
  

  /** Undoes the effect of a previous call to set_create_popup_func().
   */
  void unset_create_popup_func();

  /** The Gio::MenuModel from which the popup will be created.
   * 
   * See Gtk::MenuButton::set_menu_model() for the interaction with the
   * Gtk::MenuButton::property_popup() property.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::MenuModel> > property_menu_model() ;

/** The Gio::MenuModel from which the popup will be created.
   * 
   * See Gtk::MenuButton::set_menu_model() for the interaction with the
   * Gtk::MenuButton::property_popup() property.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::MenuModel> > property_menu_model() const;

  /** The Gtk::Widget to use to align the menu with.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_align_widget() ;

/** The Gtk::Widget to use to align the menu with.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_align_widget() const;

  /** The Gtk::ArrowType representing the direction in which the
   * menu or popover will be popped out.
   *
   * Default value: Gtk::ArrowType::DOWN
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ArrowType > property_direction() ;

/** The Gtk::ArrowType representing the direction in which the
   * menu or popover will be popped out.
   *
   * Default value: Gtk::ArrowType::DOWN
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ArrowType > property_direction() const;

  /** The Gtk::Popover that will be popped up when the button is clicked.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Popover* > property_popover() ;

/** The Gtk::Popover that will be popped up when the button is clicked.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Popover* > property_popover() const;

  /** The name of the icon used to automatically populate the button.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_icon_name() ;

/** The name of the icon used to automatically populate the button.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_icon_name() const;

  /** The label for the button.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_label() ;

/** The label for the button.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_label() const;

  /** The border relief style.
   *
   * Default value: Gtk::ReliefStyle::NORMAL
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ReliefStyle > property_relief() ;

/** The border relief style.
   *
   * Default value: Gtk::ReliefStyle::NORMAL
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ReliefStyle > property_relief() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gtk */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::MenuButton
   */
  Gtk::MenuButton* wrap(GtkMenuButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_MENUBUTTON_H */

